       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO115.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM CREATES BATCH EMAIL RECORDS FOR WEB ORDERS.       **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    01/09    FB        ORIGINAL VERSION                       **         
A01551*  08/12/09   FB        DO NOT SEND PAST DUE EMAIL FOR OFF     **         
A01551*                       EVENTS IF THE ORDER IS ACTIVE.         **         
A37538*  07/22/10   FB        ADD FETCH FIRST 1 ROWS ONLY TO PREVENT **         
A37538*                       -811 ERROR.                            **         
ACT070*  02/25/16   MC95456   USE NEXT VALUE FOR BATCH_EMAIL_ID      **         
ACT070*  APPL5460             IN CSS_BATCH_EMAIL TABLE.              **         
      **                                                             **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO115'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-PLUS-2-DATE         PIC X(10).                        
           05  WS-PLUS-3-DATE         PIC X(10).                        
           05  WS-MINUS-1-DATE        PIC X(10).                        
           05  WS-CURRENT-TIMESTAMP   PIC X(26).                        
           05  WS-DISPLAY-PREMISE     PIC 9(10).                        
           05  WS-DISPLAY-CUSTOMER    PIC 9(10).                        
           05  WS-DISPLAY-ACCOUNT     PIC 9(13).                        
           05  WS-DISPLAY-SO          PIC 9(13).                        
           05  WS-APPT-LITERAL.                                         
               10  FILLER             PIC X(32) VALUE                   
               'Service to be performed between '.                      
               10  APPT-START-HH      PIC Z9.                           
               10  FILLER             PIC X(01) VALUE ':'.              
               10  APPT-START-MM      PIC 99.                           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  APPT-START-AM-PM   PIC X(02).                        
               10  FILLER             PIC X(05) VALUE ' and '.          
               10  APPT-STOP-HH       PIC Z9.                           
               10  FILLER             PIC X(01) VALUE ':'.              
               10  APPT-STOP-MM       PIC 99.                           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  APPT-STOP-AM-PM    PIC X(02).                        
           05  WS-APPT-LITERAL-SPECIFIC.                                
               10  FILLER             PIC X(36) VALUE                   
               'Service to be performed at or about '.                  
               10  SPEC-START-HH      PIC Z9.                           
               10  FILLER             PIC X(01) VALUE ':'.              
               10  SPEC-START-MM      PIC 99.                           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  SPEC-START-AM-PM   PIC X(02).                        
           05  WS-ARRG-LITERAL-01.                                      
               10  FILLER             PIC X(15) VALUE                   
               'SCEG will call '.                                       
               10  ARRG-CALL-B4-01    PIC XX.                           
               10  FILLER             PIC X(43) VALUE                   
               ' minutes before arriving at the location.'.             
           05  WS-ARRG-LITERAL-26.                                      
               10  FILLER             PIC X(15) VALUE                   
               'PSNC will call '.                                       
               10  ARRG-CALL-B4-26    PIC XX.                           
               10  FILLER             PIC X(43) VALUE                   
               ' minutes before arriving at the location.'.             
           05  WS-ALL-DAY-LITERAL     PIC X(52) VALUE                   
               'A responsible adult must be at the location all day.'.  
           05  WS-ITERATION-STORAGE.                                    
               10 WS-ON               PIC X(01).                        
               10 WS-OFF              PIC X(01).                        
               10 WS-HOLD-AROP        PIC X(01).                        
               10 WS-ADDRESS-LINE     PIC X(120).                       
               10 WS-FULL-NAME        PIC X(75).                        
               10 WS-ELEC-FOUND       PIC X(01).                        
               10 WS-GAS-FOUND        PIC X(01).                        
               10 WS-NEED-RELEASE-FL  PIC X(01).                        
               10 WS-SCHED-DATE       PIC X(10).                        
               10 WS-DEP-AMT          pic $$$9.99.                      
               10 WS-DUE-DATE         PIC X(10).                        
               10 WS-CHECK-HOUR       PIC X(02).                        
               10 WS-MILITARY-HH      PIC 9(02).                        
               10 WS-NULL-IND-BEGIN   PIC S9(4) COMP.                   
               10 WS-NULL-IND-END     PIC S9(4) COMP.                   
               10 WS-FORMAT-PHONE.                                      
                  15  WS-PHONE1       PIC X(03).                        
                  15  WS-DASH1        PIC X(01).                        
                  15  WS-PHONE2       PIC X(03).                        
                  15  WS-DASH2        PIC X(01).                        
                  15  WS-PHONE3       PIC X(04).                        
                                                                        
       01  CSR01416-CALL-DATA.                                          
           05  INPUT-DATE-1416           PIC X(26) VALUE SPACES.        
           05  BUSINESS-DAYS-1416        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  CSR01416-RETURN-DATA.                                        
           05  OUTPUT-DATE-1416          PIC X(26) VALUE SPACES.        
                                                                        
      *01 LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOWEB                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBEMAIL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBTEDET                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOREQ                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWKAR                                                  
           END-EXEC.                                                            
                                                                        
      * SERVICE REMINDER EMAIL                                                  
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR_1 CURSOR WITH HOLD FOR                   
               SELECT SERV_ORDER_NO,                                    
                      ON_ORDER_NO,                                      
                      OFF_ORDER_NO,                                     
                      ON_SCHED_EMAIL_FL,                                
                      OFF_SCHED_EMAIL_FL,                               
                      ACCOUNT_NO,                                       
                      PREMISE_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      ORDER_PLACED_BY,                                  
                      PHONE_NO,                                         
                      COMPANY_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), WEB_EVENT_TS
           , 121), ' ', '-'), ':', '.') WEB_EVENT_TS,                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT,                         
                      REPLACE(REPLACE(CONVERT(CHAR(26), END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT,                           
                      APPT_AM_PM_CD,                                    
                      CALL_BEFORE_MINUTS,                               
                      ACCOUNT_NO_PRIOR                                  
                 FROM CSS_SO_WEB_EVENT WS WITH(READUNCOMMITTED),                
                      CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE ORDER_STATE_CD = 'A'                              
                  AND (SERV_ORDER_NO = ON_ORDER_NO                      
                   OR  SERV_ORDER_NO = OFF_ORDER_NO)                    
                  AND CAST(ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-PLUS-2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PLUS-2-DATE
              ) <> 0) OR (LEN(:WS-PLUS-2-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-PLUS-2-DATE
              ), CONVERT(DATE, :WS-PLUS-2-DATE) )        
                  AND CAST(ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR_1 CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ON_ORDER_NO,                                              
MFA-TR*               OFF_ORDER_NO,                                             
MFA-TR*               ON_SCHED_EMAIL_FL,                                        
MFA-TR*               OFF_SCHED_EMAIL_FL,                                       
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_PLACED_BY,                                          
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               WEB_EVENT_TS,                                             
MFA-TR*               BEGIN_APPT_DT,                                            
MFA-TR*               END_APPT_DT,                                              
MFA-TR*               APPT_AM_PM_CD,                                            
MFA-TR*               CALL_BEFORE_MINUTS,                                       
MFA-TR*               ACCOUNT_NO_PRIOR                                          
MFA-TR*          FROM CSS_SO_WEB_EVENT WS,                                      
MFA-TR*               CSS_SO_DATA VO                                            
MFA-TR*         WHERE ORDER_STATE_CD = 'A'                                      
MFA-TR*           AND (SERV_ORDER_NO = ON_ORDER_NO                              
MFA-TR*            OR  SERV_ORDER_NO = OFF_ORDER_NO)                            
MFA-TR*           AND DATE(ASSIGNED_DATETIME) <= :WS-PLUS-2-DATE                
MFA-TR*           AND DATE(ASSIGNED_DATETIME) >= :WS-CURRENT-DATE               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 1000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      * SERVICE PAST DUE EMAIL                                                  
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR_2 CURSOR WITH HOLD FOR                   
               SELECT SERV_ORDER_NO,                                    
                      ON_ORDER_NO,                                      
                      OFF_ORDER_NO,                                     
                      ON_PAST_EMAIL_FL,                                 
                      OFF_PAST_EMAIL_FL,                                
                      ACCOUNT_NO,                                       
                      PREMISE_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      ORDER_PLACED_BY,                                  
                      PHONE_NO,                                         
                      VO.COMPANY_NO,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), WEB_EVENT_TS
           , 121), ' ', '-'), ':', '.') WEB_EVENT_TS,                          
                      ORDER_STATE_CD,                                   
                      ACCOUNT_NO_PRIOR,                                 
                      WORK_GROUP_ID                                     
                 FROM CSS_SO_WEB_EVENT WS WITH(READUNCOMMITTED),                
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_AREA I2 WITH(READUNCOMMITTED)                    
                WHERE ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND (SERV_ORDER_NO = ON_ORDER_NO                      
                   OR  SERV_ORDER_NO = OFF_ORDER_NO)                    
                  AND CAST(ASSIGNED_DATETIME AS DATE) < 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )        
                  AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                 
                  AND VO.COMPANY_NO = I2.COMPANY_NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR_2 CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ON_ORDER_NO,                                              
MFA-TR*               OFF_ORDER_NO,                                             
MFA-TR*               ON_PAST_EMAIL_FL,                                         
MFA-TR*               OFF_PAST_EMAIL_FL,                                        
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_PLACED_BY,                                          
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               VO.COMPANY_NO,                                            
MFA-TR*               WEB_EVENT_TS,                                             
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               ACCOUNT_NO_PRIOR,                                         
MFA-TR*               WORK_GROUP_ID                                             
MFA-TR*          FROM CSS_SO_WEB_EVENT WS,                                      
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_AREA I2                                          
MFA-TR*         WHERE ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND (SERV_ORDER_NO = ON_ORDER_NO                              
MFA-TR*            OR  SERV_ORDER_NO = OFF_ORDER_NO)                            
MFA-TR*           AND DATE(ASSIGNED_DATETIME) < :WS-CURRENT-DATE                
MFA-TR*           AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                         
MFA-TR*           AND VO.COMPANY_NO = I2.COMPANY_NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 2000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      * PAYMENT REMINDER EMAIL                                                  
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR_3 CURSOR WITH HOLD FOR                   
               SELECT SERV_ORDER_NO,                                    
                      ON_ORDER_NO,                                      
                      OFF_ORDER_NO,                                     
                      ON_STATE_EMAIL_FL,                                
                      OFF_STATE_EMAIL_FL,                               
                      ACCOUNT_NO,                                       
                      PREMISE_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      ORDER_PLACED_BY,                                  
                      PHONE_NO,                                         
                      COMPANY_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), WEB_EVENT_TS
           , 121), ' ', '-'), ':', '.') WEB_EVENT_TS,                          
                      WS.AMT_DEPOSIT,                                   
                      ACCOUNT_NO_PRIOR                                  
                 FROM CSS_SO_WEB_EVENT WS WITH(READUNCOMMITTED),                
                      CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE ORDER_STATE_CD = 'R'                              
                  AND (SERV_ORDER_NO = ON_ORDER_NO                      
                   OR  SERV_ORDER_NO = OFF_ORDER_NO)                    
                  AND CAST(ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-PLUS-3-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PLUS-3-DATE
              ) <> 0) OR (LEN(:WS-PLUS-3-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-PLUS-3-DATE
              ), CONVERT(DATE, :WS-PLUS-3-DATE) )        
                  AND CAST(ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                                                                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR_3 CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ON_ORDER_NO,                                              
MFA-TR*               OFF_ORDER_NO,                                             
MFA-TR*               ON_STATE_EMAIL_FL,                                        
MFA-TR*               OFF_STATE_EMAIL_FL,                                       
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_PLACED_BY,                                          
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               WEB_EVENT_TS,                                             
MFA-TR*               WS.AMT_DEPOSIT,                                           
MFA-TR*               ACCOUNT_NO_PRIOR                                          
MFA-TR*          FROM CSS_SO_WEB_EVENT WS,                                      
MFA-TR*               CSS_SO_DATA VO                                            
MFA-TR*         WHERE ORDER_STATE_CD = 'R'                                      
MFA-TR*           AND (SERV_ORDER_NO = ON_ORDER_NO                              
MFA-TR*            OR  SERV_ORDER_NO = OFF_ORDER_NO)                            
MFA-TR*           AND DATE(ASSIGNED_DATETIME) <= :WS-PLUS-3-DATE                
MFA-TR*           AND DATE(ASSIGNED_DATETIME) >= :WS-CURRENT-DATE               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 3000                                                    
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416                                             
                  ( :INPUT-DATE-1416
                  , :BUSINESS-DAYS-1416
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO INPUT-DATE-1416.                
           MOVE -1 TO BUSINESS-DAYS-1416.                               
           PERFORM 5100-CALL-CSR01416 THRU 5100-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO WS-MINUS-1-DATE.              
                                                                        
           PERFORM 1000-TWO-DAYS-PRIOR THRU 1000-EXIT.                  
           PERFORM 2000-PAST-ORDER-DATE THRU 2000-EXIT.                 
           PERFORM 3000-PYMT-REQ-STATE THRU 3000-EXIT.                  
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL EMAILS CREATED = ' WS-DISPLAY-COUNT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-TWO-DAYS-PRIOR.                                             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO INPUT-DATE-1416.                
           MOVE +2 TO BUSINESS-DAYS-1416.                               
           PERFORM 5100-CALL-CSR01416 THRU 5100-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO WS-PLUS-2-DATE.               
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR_1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-TWO-DAYS-PRIOR              **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR 1        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR_1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-TWO-DAYS-PRIOR              **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR 1        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR_1                                         
               INTO :VO-SERV-ORDER-NO,                                  
                    :WS-ON-ORDER-NO,                                    
                    :WS-OFF-ORDER-NO,                                   
                    :WS-ON-SCHED-EMAIL-FL,                              
                    :WS-OFF-SCHED-EMAIL-FL,                             
                    :VO-ACCOUNT-NO,                                     
                    :VO-PREMISE-NO,                                     
                    :VO-ASSIGNED-DATETIME,                              
                    :VO-ORDER-PLACED-BY,                                
                    :VO-PHONE-NO,                                       
                    :VO-COMPANY-NO,                                     
                    :WS-WEB-EVENT-TS,                                   
                    :VO-BEGIN-APPT-DT :WS-NULL-IND-BEGIN,                
                    :VO-END-APPT-DT :WS-NULL-IND-END,                    
                    :VO-APPT-AM-PM-CD,                                  
                    :VO-CALL-BEFORE-MINUTS,                             
                    :VO-ACCOUNT-NO-PRIOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-BEGIN < 0                             
                       MOVE SPACES TO VO-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL-IND-END < 0                               
                       MOVE SPACES TO VO-END-APPT-DT                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR 1       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF VO-SERV-ORDER-NO = WS-ON-ORDER-NO AND                     
              WS-ON-SCHED-EMAIL-FL = 'N'                                
                  MOVE 'Y' TO WS-ON                                     
                  PERFORM 1200-FORMAT-EMAIL THRU 1200-EXIT              
                  ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT                 
                  PERFORM 8200-UPDATE-ON-SCHED-FLAG THRU 8200-EXIT
           END-IF.     
           IF VO-SERV-ORDER-NO = WS-OFF-ORDER-NO AND                    
              WS-OFF-SCHED-EMAIL-FL = 'N'                               
                  MOVE 'Y' TO WS-OFF                                    
                  PERFORM 1200-FORMAT-EMAIL THRU 1200-EXIT              
                  ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT                 
                  PERFORM 8210-UPDATE-OFF-SCHED-FLAG THRU 8210-EXIT
           END-IF.    
                                                                        
           IF WS-COMMIT-COUNT > 100                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-FORMAT-EMAIL.                                               
                                                                        
           IF WS-ON = 'Y'                                               
               MOVE VO-ACCOUNT-NO TO AT-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AT-ACCOUNT-NO
           END-IF.               
           PERFORM 7000-SERVICE-ADDRESS THRU 7000-EXIT.                 
           PERFORM 7100-CUSTOMER-NAME THRU 7100-EXIT.                   
           PERFORM 7200-UTILITY-TYPE THRU 7200-EXIT.                    
           PERFORM 7300-GAS-WORK-TYPE THRU 7300-EXIT.                   
                                                                        
           MOVE CU-CUSTOMER-NO TO AE-CUSTOMER-NO.                       
           IF WS-ON = 'Y'                                               
               MOVE 'ECS24' TO AE-EMAIL-EVENT-CD                        
               MOVE VO-ACCOUNT-NO TO AE-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AE-ACCOUNT-NO                
               MOVE 'ECS26' TO AE-EMAIL-EVENT-CD
           END-IF.                       
           MOVE WS-MINUS-1-DATE TO AE-EMAIL-EVENT-DT.                   
           MOVE VO-COMPANY-NO TO AE-COMPANY-NO.                         
                                                                        
ACT070     PERFORM 7500-SET-NEXT-VALUE     THRU 7500-EXIT.              
           PERFORM 8000-INSERT-BATCH-EMAIL THRU 8000-EXIT.              
           IF WS-ON = 'Y'                                               
               PERFORM 1250-ON-EMAIL-DETAIL THRU 1250-EXIT              
           ELSE                                                         
               PERFORM 1275-OFF-EMAIL-DETAIL THRU 1275-EXIT
           END-IF.            
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1250-ON-EMAIL-DETAIL.                                            
                                                                        
           MOVE VO-ASSIGNED-DATETIME(1:4) TO WS-SCHED-DATE(7:4).        
           MOVE VO-ASSIGNED-DATETIME(6:2) TO WS-SCHED-DATE(1:2).        
           MOVE VO-ASSIGNED-DATETIME(9:2) TO WS-SCHED-DATE(4:2).        
           MOVE '/' TO WS-SCHED-DATE(3:1)                               
                       WS-SCHED-DATE(6:1).                              
           MOVE 'SCHED-DT' TO JK-FIELD-NAME-TX.                         
           MOVE WS-SCHED-DATE TO JK-FIELD-VALUE-TX-TEXT.                
           MOVE 10 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'UTIL-TYPE' TO JK-FIELD-NAME-TX.                        
           EVALUATE WS-ELEC-FOUND ALSO WS-GAS-FOUND                     
               WHEN 'Y' ALSO 'Y'                                        
                   MOVE 'Electric and Gas' TO JK-FIELD-VALUE-TX-TEXT    
                   MOVE 16 TO JK-FIELD-VALUE-TX-LEN                     
               WHEN 'Y' ALSO 'N'                                        
                   MOVE 'Electric' TO JK-FIELD-VALUE-TX-TEXT            
                   MOVE 8 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'Y'                                        
                   MOVE 'Gas' TO JK-FIELD-VALUE-TX-TEXT                 
                   MOVE 3 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'N'                                        
                   MOVE 'None' TO JK-FIELD-VALUE-TX-TEXT                
                   MOVE 4 TO JK-FIELD-VALUE-TX-LEN                      
           END-EVALUATE.                                                
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'CUST-NAME' TO JK-FIELD-NAME-TX.                        
           MOVE WS-FULL-NAME TO JK-FIELD-VALUE-TX-TEXT.                 
           MOVE 75 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'CONTACT-INFO' TO JK-FIELD-NAME-TX.                     
           MOVE VO-PHONE-NO(1:3) TO WS-PHONE1.                          
           MOVE VO-PHONE-NO(4:3) TO WS-PHONE2.                          
           MOVE VO-PHONE-NO(7:4) TO WS-PHONE3.                          
           MOVE '-' TO WS-DASH1 WS-DASH2.                               
           STRING VO-ORDER-PLACED-BY DELIMITED '  '                     
                  '  ' DELIMITED SIZE                                   
                  WS-FORMAT-PHONE DELIMITED SIZE                        
           INTO JK-FIELD-VALUE-TX-TEXT.                                 
           MOVE 38 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           IF VO-APPT-AM-PM-CD = 'N'                                    
               PERFORM 1375-FORMAT-SPECIFIC THRU 1375-EXIT              
           ELSE                                                         
               IF VO-APPT-AM-PM-CD > SPACES                             
                   PERFORM 1300-FORMAT-APPOINTMENT THRU 1300-EXIT       
               ELSE                                                     
                   IF VO-CALL-BEFORE-MINUTS > SPACES AND                
                      VO-CALL-BEFORE-MINUTS NOT = '000' AND             
                      VO-CALL-BEFORE-MINUTS NOT = '00' AND              
                      VO-CALL-BEFORE-MINUTS NOT = '0'                   
                         PERFORM 1325-FORMAT-CALL-B4 THRU 1325-EXIT     
                   ELSE                                                 
                       IF VI-WORK-TYPE-CD = 'UNB'                       
                         PERFORM 1350-FORMAT-ALL-DAY THRU 1350-EXIT
                       END-IF
                   END-IF
               END-IF
           END-IF    .
                                                                        
           MOVE 'PREM-ADDR' TO JK-FIELD-NAME-TX.                        
           MOVE WS-ADDRESS-LINE TO JK-FIELD-VALUE-TX-TEXT.              
           MOVE 120 TO JK-FIELD-VALUE-TX-LEN.                           
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1275-OFF-EMAIL-DETAIL.                                           
                                                                        
           MOVE VO-ASSIGNED-DATETIME(1:4) TO WS-SCHED-DATE(7:4).        
           MOVE VO-ASSIGNED-DATETIME(6:2) TO WS-SCHED-DATE(1:2).        
           MOVE VO-ASSIGNED-DATETIME(9:2) TO WS-SCHED-DATE(4:2).        
           MOVE '/' TO WS-SCHED-DATE(3:1)                               
                       WS-SCHED-DATE(6:1).                              
           MOVE 'SCHED-DT' TO JK-FIELD-NAME-TX.                         
           MOVE WS-SCHED-DATE TO JK-FIELD-VALUE-TX-TEXT.                
           MOVE 10 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'UTIL-TYPE' TO JK-FIELD-NAME-TX.                        
           EVALUATE WS-ELEC-FOUND ALSO WS-GAS-FOUND                     
               WHEN 'Y' ALSO 'Y'                                        
                   MOVE 'Electric and Gas' TO JK-FIELD-VALUE-TX-TEXT    
                   MOVE 16 TO JK-FIELD-VALUE-TX-LEN                     
               WHEN 'Y' ALSO 'N'                                        
                   MOVE 'Electric' TO JK-FIELD-VALUE-TX-TEXT            
                   MOVE 8 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'Y'                                        
                   MOVE 'Gas' TO JK-FIELD-VALUE-TX-TEXT                 
                   MOVE 3 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'N'                                        
                   MOVE 'None' TO JK-FIELD-VALUE-TX-TEXT                
                   MOVE 4 TO JK-FIELD-VALUE-TX-LEN                      
           END-EVALUATE.                                                
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'PREM-ADDR' TO JK-FIELD-NAME-TX.                        
           MOVE WS-ADDRESS-LINE TO JK-FIELD-VALUE-TX-TEXT.              
           MOVE 120 TO JK-FIELD-VALUE-TX-LEN.                           
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'CUST-NAME' TO JK-FIELD-NAME-TX.                        
           MOVE WS-FULL-NAME TO JK-FIELD-VALUE-TX-TEXT.                 
           MOVE 75 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1275-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1300-FORMAT-APPOINTMENT.                                         
                                                                        
           MOVE VO-BEGIN-APPT-DT (12:2) TO WS-CHECK-HOUR.               
           IF WS-CHECK-HOUR NOT NUMERIC                                 
               GO TO 1300-EXIT
           END-IF.                                         
           MOVE WS-CHECK-HOUR TO WS-MILITARY-HH.                        
           IF WS-MILITARY-HH > 11                                       
               MOVE 'PM' TO APPT-START-AM-PM                            
           ELSE                                                         
               MOVE 'AM' TO APPT-START-AM-PM
           END-IF.                           
           IF WS-MILITARY-HH > 12                                       
              COMPUTE WS-MILITARY-HH =                                  
                      WS-MILITARY-HH - 12
           END-IF.                              
           MOVE WS-MILITARY-HH TO APPT-START-HH.                        
           MOVE VO-BEGIN-APPT-DT (15:2) TO APPT-START-MM.               
                                                                        
           MOVE 00 TO WS-MILITARY-HH.                                   
           MOVE VO-END-APPT-DT (12:2) TO WS-CHECK-HOUR.                 
           IF WS-CHECK-HOUR NOT NUMERIC                                 
               GO TO 1300-EXIT
           END-IF.                                         
           MOVE WS-CHECK-HOUR TO WS-MILITARY-HH.                        
           IF WS-MILITARY-HH > 11                                       
               MOVE 'PM' TO APPT-STOP-AM-PM                             
           ELSE                                                         
               MOVE 'AM' TO APPT-STOP-AM-PM
           END-IF.                            
           IF WS-MILITARY-HH > 12                                       
              COMPUTE WS-MILITARY-HH =                                  
                      WS-MILITARY-HH - 12
           END-IF.                              
           MOVE WS-MILITARY-HH TO APPT-STOP-HH.                         
           MOVE VO-BEGIN-APPT-DT (15:2) TO APPT-STOP-MM.                
                                                                        
           MOVE 'APPT-ARRG' TO JK-FIELD-NAME-TX.                        
           MOVE WS-APPT-LITERAL TO JK-FIELD-VALUE-TX-TEXT.              
           MOVE 55 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1325-FORMAT-CALL-B4.                                             
                                                                        
           IF VO-COMPANY-NO = '01'                                      
               MOVE VO-CALL-BEFORE-MINUTS TO ARRG-CALL-B4-01            
               MOVE WS-ARRG-LITERAL-01 TO JK-FIELD-VALUE-TX-TEXT        
           ELSE                                                         
               MOVE VO-CALL-BEFORE-MINUTS TO ARRG-CALL-B4-26            
               MOVE WS-ARRG-LITERAL-26 TO JK-FIELD-VALUE-TX-TEXT
           END-IF.       
           MOVE 'APPT-ARRG' TO JK-FIELD-NAME-TX.                        
           MOVE 61 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1325-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1350-FORMAT-ALL-DAY.                                             
                                                                        
           MOVE 'APPT-ARRG' TO JK-FIELD-NAME-TX.                        
           MOVE WS-ALL-DAY-LITERAL TO JK-FIELD-VALUE-TX-TEXT.           
           MOVE 52 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1375-FORMAT-SPECIFIC.                                            
                                                                        
           MOVE VO-BEGIN-APPT-DT (12:2) TO WS-CHECK-HOUR.               
           IF WS-CHECK-HOUR NOT NUMERIC                                 
               GO TO 1375-EXIT
           END-IF.                                         
           MOVE WS-CHECK-HOUR TO WS-MILITARY-HH.                        
           IF WS-MILITARY-HH > 11                                       
               MOVE 'PM' TO SPEC-START-AM-PM                            
           ELSE                                                         
               MOVE 'AM' TO SPEC-START-AM-PM
           END-IF.                           
           IF WS-MILITARY-HH > 12                                       
              COMPUTE WS-MILITARY-HH =                                  
                      WS-MILITARY-HH - 12
           END-IF.                              
           MOVE WS-MILITARY-HH TO SPEC-START-HH.                        
           MOVE VO-BEGIN-APPT-DT (15:2) TO SPEC-START-MM.               
                                                                        
           MOVE 'APPT-ARRG' TO JK-FIELD-NAME-TX.                        
           MOVE WS-APPT-LITERAL-SPECIFIC TO JK-FIELD-VALUE-TX-TEXT.     
           MOVE 45 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       1375-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PAST-ORDER-DATE.                                            
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR_2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  2000-PAST-ORDER-DATE             **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR 2        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR_2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  2000-PAST-ORDER-DATE             **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR 2        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR_2                                         
               INTO :VO-SERV-ORDER-NO,                                  
                    :WS-ON-ORDER-NO,                                    
                    :WS-OFF-ORDER-NO,                                   
                    :WS-ON-PAST-EMAIL-FL,                               
                    :WS-OFF-PAST-EMAIL-FL,                              
                    :VO-ACCOUNT-NO,                                     
                    :VO-PREMISE-NO,                                     
                    :VO-ASSIGNED-DATETIME,                              
                    :VO-ORDER-PLACED-BY,                                
                    :VO-PHONE-NO,                                       
                    :VO-COMPANY-NO,                                     
                    :WS-WEB-EVENT-TS,                                   
                    :VO-ORDER-STATE-CD,                                 
                    :VO-ACCOUNT-NO-PRIOR,                               
                    :I2-WORK-GROUP-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  2100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR 2       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF I2-WORK-GROUP-ID = 'AROP' AND                             
              VO-ORDER-STATE-CD = 'H'                                   
                  MOVE 'Y' TO WS-HOLD-AROP
           END-IF.                             
                                                                        
           IF VO-SERV-ORDER-NO = WS-ON-ORDER-NO AND                     
              WS-ON-PAST-EMAIL-FL = 'N'                                 
                  MOVE 'Y' TO WS-ON                                     
                  MOVE 'N' TO WS-NEED-RELEASE-FL                        
                  IF VO-ORDER-STATE-CD = 'A'                            
                      PERFORM 7400-CHECK-RELEASE THRU 7400-EXIT         
                  END-IF                                                
                  IF WS-HOLD-AROP = 'Y'                                 
                      NEXT SENTENCE                                     
                  ELSE                                                  
                      IF VO-ORDER-STATE-CD NOT = 'A' OR                 
                        (VO-ORDER-STATE-CD = 'A' AND                    
                         WS-NEED-RELEASE-FL = 'Y')                      
                            PERFORM 2200-FORMAT-EMAIL THRU 2200-EXIT    
                            ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT       
                            PERFORM 8220-UPDATE-ON-PAST-FLAG THRU       
                                    8220-EXIT
                      END-IF
                  END-IF
           END-IF.                          
           IF VO-SERV-ORDER-NO = WS-OFF-ORDER-NO AND                    
              WS-OFF-PAST-EMAIL-FL = 'N'                                
                  MOVE 'Y' TO WS-OFF                                    
                  IF WS-HOLD-AROP = 'Y' OR                              
A01551               VO-ORDER-STATE-CD = 'A'                            
                         NEXT SENTENCE                                  
                  ELSE                                                  
                      PERFORM 2200-FORMAT-EMAIL THRU 2200-EXIT          
                      ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT             
                      PERFORM 8230-UPDATE-OFF-PAST-FLAG THRU 8230-EXIT
                  END-IF
           END-IF. 
                                                                        
           IF WS-COMMIT-COUNT > 100                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-FORMAT-EMAIL.                                               
                                                                        
           IF WS-ON = 'Y'                                               
               MOVE VO-ACCOUNT-NO TO AT-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AT-ACCOUNT-NO
           END-IF.               
           PERFORM 7000-SERVICE-ADDRESS THRU 7000-EXIT.                 
           PERFORM 7100-CUSTOMER-NAME THRU 7100-EXIT.                   
                                                                        
           IF WS-ON = 'Y'                                               
               MOVE VO-ACCOUNT-NO TO AE-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AE-ACCOUNT-NO
           END-IF.               
           MOVE VO-ACCOUNT-NO TO AE-ACCOUNT-NO.                         
           MOVE CU-CUSTOMER-NO TO AE-CUSTOMER-NO.                       
           MOVE 'ECS25' TO AE-EMAIL-EVENT-CD.                           
           MOVE WS-MINUS-1-DATE TO AE-EMAIL-EVENT-DT.                   
           MOVE VO-COMPANY-NO TO AE-COMPANY-NO.                         
                                                                        
ACT070     PERFORM 7500-SET-NEXT-VALUE     THRU 7500-EXIT.              
           PERFORM 8000-INSERT-BATCH-EMAIL THRU 8000-EXIT.              
           PERFORM 2250-EMAIL-DETAIL THRU 2250-EXIT.                    
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2250-EMAIL-DETAIL.                                               
                                                                        
           MOVE VO-ASSIGNED-DATETIME(1:4) TO WS-SCHED-DATE(7:4).        
           MOVE VO-ASSIGNED-DATETIME(6:2) TO WS-SCHED-DATE(1:2).        
           MOVE VO-ASSIGNED-DATETIME(9:2) TO WS-SCHED-DATE(4:2).        
           MOVE '/' TO WS-SCHED-DATE(3:1)                               
                       WS-SCHED-DATE(6:1).                              
           MOVE 'SCHED-DT' TO JK-FIELD-NAME-TX.                         
           MOVE WS-SCHED-DATE TO JK-FIELD-VALUE-TX-TEXT.                
           MOVE 10 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'REQ-TYPE' TO JK-FIELD-NAME-TX.                         
           IF WS-ON = 'Y'                                               
               MOVE 'Turn on service' TO JK-FIELD-VALUE-TX-TEXT         
           ELSE                                                         
               MOVE 'Turn off service' TO JK-FIELD-VALUE-TX-TEXT
           END-IF.       
           MOVE 17 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'PREM-ADDR' TO JK-FIELD-NAME-TX.                        
           MOVE WS-ADDRESS-LINE TO JK-FIELD-VALUE-TX-TEXT.              
           MOVE 120 TO JK-FIELD-VALUE-TX-LEN.                           
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'CUST-NAME' TO JK-FIELD-NAME-TX.                        
           MOVE WS-FULL-NAME TO JK-FIELD-VALUE-TX-TEXT.                 
           MOVE 75 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-PYMT-REQ-STATE.                                             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO INPUT-DATE-1416.                
           MOVE +3 TO BUSINESS-DAYS-1416.                               
           PERFORM 5100-CALL-CSR01416 THRU 5100-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO WS-PLUS-3-DATE.               
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR_3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3000-PYMT-REQ-STATE              **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR 3        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3100-FETCH-ROWS THRU 3100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR_3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3000-PYMT-REQ-STATE              **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR 3        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FETCH-ROWS.                                                 
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR_3                                         
               INTO :VO-SERV-ORDER-NO,                                  
                    :WS-ON-ORDER-NO,                                    
                    :WS-OFF-ORDER-NO,                                   
                    :WS-ON-STATE-EMAIL-FL,                              
                    :WS-OFF-STATE-EMAIL-FL,                             
                    :VO-ACCOUNT-NO,                                     
                    :VO-PREMISE-NO,                                     
                    :VO-ASSIGNED-DATETIME,                              
                    :VO-ORDER-PLACED-BY,                                
                    :VO-PHONE-NO,                                       
                    :VO-COMPANY-NO,                                     
                    :WS-WEB-EVENT-TS,                                   
                    :WS-AMT-DEPOSIT,                                    
                    :VO-ACCOUNT-NO-PRIOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 3100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR 3       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF VO-SERV-ORDER-NO = WS-ON-ORDER-NO AND                     
              WS-ON-STATE-EMAIL-FL = 'N'                                
                  MOVE 'Y' TO WS-ON                                     
                  PERFORM 3200-FORMAT-EMAIL THRU 3200-EXIT              
                  ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT                 
                  PERFORM 8240-UPDATE-ON-STATE-FLAG THRU 8240-EXIT
           END-IF.     
           IF VO-SERV-ORDER-NO = WS-OFF-ORDER-NO AND                    
              WS-OFF-STATE-EMAIL-FL = 'N'                               
                  MOVE 'Y' TO WS-OFF                                    
                  PERFORM 3200-FORMAT-EMAIL THRU 3200-EXIT              
                  ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT                 
                  PERFORM 8250-UPDATE-OFF-STATE-FLAG THRU 8250-EXIT
           END-IF.    
                                                                        
           IF WS-COMMIT-COUNT > 100                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 3100-FETCH-ROWS.                                       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-FORMAT-EMAIL.                                               
                                                                        
           IF WS-ON = 'Y'                                               
               MOVE VO-ACCOUNT-NO TO AT-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AT-ACCOUNT-NO
           END-IF.               
           PERFORM 7000-SERVICE-ADDRESS THRU 7000-EXIT.                 
           PERFORM 7100-CUSTOMER-NAME THRU 7100-EXIT.                   
           PERFORM 7200-UTILITY-TYPE THRU 7200-EXIT.                    
                                                                        
           IF WS-ON = 'Y'                                               
               MOVE VO-ACCOUNT-NO TO AE-ACCOUNT-NO                      
           ELSE                                                         
               MOVE VO-ACCOUNT-NO-PRIOR TO AE-ACCOUNT-NO
           END-IF.               
           MOVE CU-CUSTOMER-NO TO AE-CUSTOMER-NO.                       
           MOVE 'ECS23' TO AE-EMAIL-EVENT-CD.                           
           MOVE WS-MINUS-1-DATE TO AE-EMAIL-EVENT-DT.                   
           MOVE VO-COMPANY-NO TO AE-COMPANY-NO.                         
                                                                        
ACT070     PERFORM 7500-SET-NEXT-VALUE     THRU 7500-EXIT.              
           PERFORM 8000-INSERT-BATCH-EMAIL THRU 8000-EXIT.              
           PERFORM 3250-EMAIL-DETAIL THRU 3250-EXIT.                    
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3250-EMAIL-DETAIL.                                               
                                                                        
           MOVE 'DEP-AMT' TO JK-FIELD-NAME-TX.                          
           MOVE WS-AMT-DEPOSIT TO WS-DEP-AMT.                           
           MOVE WS-DEP-AMT TO JK-FIELD-VALUE-TX-TEXT.                   
           MOVE 8 TO JK-FIELD-VALUE-TX-LEN.                             
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE VO-ASSIGNED-DATETIME(1:4) TO WS-SCHED-DATE(7:4).        
           MOVE VO-ASSIGNED-DATETIME(6:2) TO WS-SCHED-DATE(1:2).        
           MOVE VO-ASSIGNED-DATETIME(9:2) TO WS-SCHED-DATE(4:2).        
           MOVE '/' TO WS-SCHED-DATE(3:1)                               
                       WS-SCHED-DATE(6:1).                              
           MOVE 'SCHED-DT' TO JK-FIELD-NAME-TX.                         
           MOVE WS-SCHED-DATE TO JK-FIELD-VALUE-TX-TEXT.                
           MOVE 10 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'CUST-NAME' TO JK-FIELD-NAME-TX.                        
           MOVE WS-FULL-NAME TO JK-FIELD-VALUE-TX-TEXT.                 
           MOVE 75 TO JK-FIELD-VALUE-TX-LEN.                            
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'UTIL-TYPE' TO JK-FIELD-NAME-TX.                        
           EVALUATE WS-ELEC-FOUND ALSO WS-GAS-FOUND                     
               WHEN 'Y' ALSO 'Y'                                        
                   MOVE 'Electric and Gas' TO JK-FIELD-VALUE-TX-TEXT    
                   MOVE 16 TO JK-FIELD-VALUE-TX-LEN                     
               WHEN 'Y' ALSO 'N'                                        
                   MOVE 'Electric' TO JK-FIELD-VALUE-TX-TEXT            
                   MOVE 8 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'Y'                                        
                   MOVE 'Gas' TO JK-FIELD-VALUE-TX-TEXT                 
                   MOVE 3 TO JK-FIELD-VALUE-TX-LEN                      
               WHEN 'N' ALSO 'N'                                        
                   MOVE 'None' TO JK-FIELD-VALUE-TX-TEXT                
                   MOVE 4 TO JK-FIELD-VALUE-TX-LEN                      
           END-EVALUATE.                                                
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'PREM-ADDR' TO JK-FIELD-NAME-TX.                        
           MOVE WS-ADDRESS-LINE TO JK-FIELD-VALUE-TX-TEXT.              
           MOVE 120 TO JK-FIELD-VALUE-TX-LEN.                           
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       3250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-CALL-CSR01416.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416                                             
      *           (:INPUT-DATE-1416,                                    
      *            :BUSINESS-DAYS-1416)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR CALLING CSR01416            **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1416 INTO                            
                 :OUTPUT-DATE-1416                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING CSR01416           **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SERVICE-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))))))))
           ) AS ADDR_LINE
                  INTO :WS-ADDRESS-LINE                                 
                  FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),             
                       CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                   
                       CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                 WHERE PREMISE_NO = :VO-PREMISE-NO                      
                   AND PR.ADDRESS_ID = DY.ADDRESS_ID                    
                   AND DY.ZIP_CODE = A4.ZIP_CODE                        
                   AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN            
                                                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                    
MFA-TR*                LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                     
MFA-TR*                LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                     
MFA-TR*                LTRIM(RTRIM(STREET_NAME) || ' ' ||                       
MFA-TR*                LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                     
MFA-TR*                LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                       
MFA-TR*                LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                 
MFA-TR*                LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                  
MFA-TR*                LTRIM(RTRIM(TOWN) || ', ' ||                             
MFA-TR*                LTRIM(RTRIM(STATE) || ' ' ||                             
MFA-TR*                LTRIM(RTRIM(DY.ZIP_CODE))))))))))))) AS ADDR_LINE        
MFA-TR*           INTO :WS-ADDRESS-LINE                                         
MFA-TR*           FROM CSS_ADDR_FORMATTED DY,                           08200000
MFA-TR*                CSS_ZIP_CODE A4,                                         
MFA-TR*                CSS_PREMISE PR                                           
MFA-TR*          WHERE PREMISE_NO = :VO-PREMISE-NO                      08250000
MFA-TR*            AND PR.ADDRESS_ID = DY.ADDRESS_ID                            
MFA-TR*            AND DY.ZIP_CODE = A4.ZIP_CODE                                
MFA-TR*            AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                    
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               MOVE VO-PREMISE-NO TO WS-DISPLAY-PREMISE                 
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_ADDR_FORMATTED *'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' WS-DISPLAY-PREMISE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7100-CUSTOMER-NAME.                                              
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + 
           LTRIM(RTRIM(MIDDLE_NAME) + ' ' + RTRIM(LAST_NAME)))) AS 
           FULL_NAME,
              CU.CUSTOMER_NO                                   
                  INTO :WS-FULL-NAME,                                   
                       :CU-CUSTOMER-NO                                  
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                    
                       CSS_CUSTOMER CU WITH(READUNCOMMITTED),                   
                       CSS_NAME DQ WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                   AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                  
                   AND CU.NAME_ID = DQ.NAME_ID                          
                   AND NAME_TYPE = 'CN'                                 
                                                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                  
MFA-TR*                LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                       
MFA-TR*                RTRIM(LAST_NAME)))) AS FULL_NAME,                        
MFA-TR*                CU.CUSTOMER_NO                                           
MFA-TR*           INTO :WS-FULL-NAME,                                           
MFA-TR*                :CU-CUSTOMER-NO                                          
MFA-TR*           FROM CSS_ACCOUNT AT,                                  08200000
MFA-TR*                CSS_CUSTOMER CU,                                         
MFA-TR*                CSS_NAME DQ                                              
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      08250000
MFA-TR*            AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                          
MFA-TR*            AND CU.NAME_ID = DQ.NAME_ID                                  
MFA-TR*            AND NAME_TYPE = 'CN'                                         
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               MOVE VO-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT                 
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_NAME           *'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7200-UTILITY-TYPE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) SERV_ORDER_NO                                    
                  INTO :VI-SERV-ORDER-NO                                
                  FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                  
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND WORK_TYPE_CD > ' '                               
                                                 
                                                                 
                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT SERV_ORDER_NO                                            
MFA-TR*           INTO :VI-SERV-ORDER-NO                                        
MFA-TR*           FROM CSS_SO_ORDER_INST                                08200000
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                08250000
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND WORK_TYPE_CD > ' '                                       
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 72001                                                  
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ELEC-FOUND                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ELEC-FOUND                            
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO               
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_ORDER_INST **'   
                   DISPLAY '**  ELECTRIC ROW                      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-SO                 
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) SERV_ORDER_NO                                    
                  INTO :VI-SERV-ORDER-NO                                
                  FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                  
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                   AND CODE_UTIL_TYPE = 'G'                             
                   AND WORK_TYPE_CD > ' '                               
                                                 
                                                                 
                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT SERV_ORDER_NO                                            
MFA-TR*           INTO :VI-SERV-ORDER-NO                                        
MFA-TR*           FROM CSS_SO_ORDER_INST                                08200000
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                08250000
MFA-TR*            AND CODE_UTIL_TYPE = 'G'                                     
MFA-TR*            AND WORK_TYPE_CD > ' '                                       
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 72002                                                  
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-GAS-FOUND                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-GAS-FOUND                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO               
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_ORDER_INST **'   
                   DISPLAY '**  GAS ROW                           **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-SO                 
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7300-GAS-WORK-TYPE.                                              
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) WORK_TYPE_CD                                     
                  INTO :VI-WORK-TYPE-CD                                 
                  FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                  
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                   AND CODE_UTIL_TYPE = 'G'                             
                   AND WORK_TYPE_CD > ' '                               
                                                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT WORK_TYPE_CD                                             
MFA-TR*           INTO :VI-WORK-TYPE-CD                                         
MFA-TR*           FROM CSS_SO_ORDER_INST                                08200000
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                08250000
MFA-TR*            AND CODE_UTIL_TYPE = 'G'                                     
MFA-TR*            AND WORK_TYPE_CD > ' '                                       
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO VI-WORK-TYPE-CD                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO               
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_ORDER_INST **'   
                   DISPLAY '**  GAS ROW                           **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-SO                 
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7400-CHECK-RELEASE.                                              
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) SERV_ORDER_NO                                    
                  INTO :EG-SERV-ORDER-NO                                
                  FROM CSS_SO_REQUIREMENT WITH(READUNCOMMITTED)                 
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                   AND REQUIREMENT_CD = '1'                             
                   AND SERV_ORDER_STATUS = '10'                         
                   AND REQMNT_COMP_DT IS NULL                           
                                                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT SERV_ORDER_NO                                            
MFA-TR*           INTO :EG-SERV-ORDER-NO                                        
MFA-TR*           FROM CSS_SO_REQUIREMENT                               08200000
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                08250000
MFA-TR*            AND REQUIREMENT_CD = '1'                                     
MFA-TR*            AND SERV_ORDER_STATUS = '10'                                 
MFA-TR*            AND REQMNT_COMP_DT IS NULL                                   
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-NEED-RELEASE-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-NEED-RELEASE-FL                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO               
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_REQUIREMENT**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-SO                 
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
                                                                        
ACT070*****************************************************************         
ACT070* 7500-SET-NEXT-VALUE.                                          *         
ACT070*****************************************************************         
ACT070 7500-SET-NEXT-VALUE.                                             
      *                                                                         
ACT070     EXEC SQL                                                     
ACT070        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***********************************'             
ACT070        DISPLAY '**  PROCESSING ERROR             **'             
ACT070        DISPLAY '**  PARAGRAPH    = 7500-SET-NEXT-VALUE    '      
ACT070        DISPLAY '**  SET CSS_BATCH_EMAIL'                         
ACT070        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
ACT070        DISPLAY '**  PROCESSING TERMINATED        **'             
ACT070        DISPLAY '***********************************'             
ACT070        PERFORM 9900-ABEND                THRU 9900-ABEND-EXIT    
ACT070     END-IF.                                                      
                                                                        
      *                                                                         
ACT070 7500-EXIT.                                                       
ACT070     EXIT.                                                        
      *                                                                         
       8000-INSERT-BATCH-EMAIL.                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BATCH_EMAIL                             
                       (ACCOUNT_NO                                      
                       ,CUSTOMER_NO                                     
                       ,EMAIL_EVENT_CD                                  
                       ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
                       ,COMPANY_NO)                                     
                VALUES                                                  
                       (:AE-ACCOUNT-NO                                  
                       ,:AE-CUSTOMER-NO                                 
                       ,:AE-EMAIL-EVENT-CD                              
                       ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
ACT070                 ,:AE-BATCH-EMAIL-ID                              
                       ,:AE-COMPANY-NO)                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                             08190000
MFA-TR*                (ACCOUNT_NO                                      08200000
MFA-TR*                ,CUSTOMER_NO                                     08210000
MFA-TR*                ,EMAIL_EVENT_CD                                  08220000
MFA-TR*                ,EMAIL_EVENT_DT                                  08230000
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                     08240000
MFA-TR*         VALUES                                                  08250000
MFA-TR*                (:AE-ACCOUNT-NO                                  08260000
MFA-TR*                ,:AE-CUSTOMER-NO                                 08270000
MFA-TR*                ,:AE-EMAIL-EVENT-CD                              08280000
MFA-TR*                ,:AE-EMAIL-EVENT-DT                              08290000
MFA-TR*                ,:AE-BATCH-EMAIL-ID                                      
MFA-TR*                ,:AE-COMPANY-NO)                                 08300000
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
A37538                                ALREADY-EXISTS                    
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               MOVE AE-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT                 
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR INSERTING CSS_BATCH_EMAIL   **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) BATCH_EMAIL_ID                                   
                  INTO :AE-BATCH-EMAIL-ID                               
                  FROM CSS_BATCH_EMAIL                                  
                 WHERE ACCOUNT_NO = :AE-ACCOUNT-NO                      
                   AND CUSTOMER_NO = :AE-CUSTOMER-NO                    
                   AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD              
                   AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )              
                   AND COMPANY_NO = :AE-COMPANY-NO                      
A37538                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT BATCH_EMAIL_ID                                   08190000
MFA-TR*           INTO :AE-BATCH-EMAIL-ID                                       
MFA-TR*           FROM CSS_BATCH_EMAIL                                  08200000
MFA-TR*          WHERE ACCOUNT_NO = :AE-ACCOUNT-NO                      08250000
MFA-TR*            AND CUSTOMER_NO = :AE-CUSTOMER-NO                            
MFA-TR*            AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                      
MFA-TR*            AND EMAIL_EVENT_DT = :AE-EMAIL-EVENT-DT                      
MFA-TR*            AND COMPANY_NO = :AE-COMPANY-NO                      08300000
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           QUERYNO 8000                                                  
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               MOVE AE-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT                 
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_BATCH_EMAIL   **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8100-INSERT-BATCH-EMAIL-DET.                                     
                                                                        
           MOVE AE-BATCH-EMAIL-ID TO JK-BATCH-EMAIL-ID.                 
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_BTCH_EMAIL_DET                             
                    (BATCH_EMAIL_ID,                                    
                     FIELD_NAME_TX,                                     
                     FIELD_VALUE_TX)                                    
             VALUES                                                     
                    (:JK-BATCH-EMAIL-ID,                                
                     :JK-FIELD-NAME-TX,                                 
                     :JK-FIELD-VALUE-TX)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
A37538                                ALREADY-EXISTS                    
               MOVE SPACES TO JK-FIELD-VALUE-TX-TEXT                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               MOVE AE-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT                 
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR INSERTING CSS_BTCH_EMAIL_DET *'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT              
               DISPLAY '**  FIELD = ' JK-FIELD-NAME-TX                  
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8200-UPDATE-ON-SCHED-FLAG.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET ON_SCHED_EMAIL_FL = 'Y'                             
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET ON_SCHED_EMAIL_FL = 'Y'                                     
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  ON_SCHED_EMAIL_FL                 **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8210-UPDATE-OFF-SCHED-FLAG.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET OFF_SCHED_EMAIL_FL = 'Y'                            
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET OFF_SCHED_EMAIL_FL = 'Y'                                    
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  OFF_SCHED_EMAIL_FL                **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8220-UPDATE-ON-PAST-FLAG.                                        
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET ON_PAST_EMAIL_FL = 'Y'                              
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET ON_PAST_EMAIL_FL = 'Y'                                      
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  ON_PAST_EMAIL_FL                  **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8230-UPDATE-OFF-PAST-FLAG.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET OFF_PAST_EMAIL_FL = 'Y'                             
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET OFF_PAST_EMAIL_FL = 'Y'                                     
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8230                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  OFF_PAST_EMAIL_FL                 **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8240-UPDATE-ON-STATE-FLAG.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET ON_STATE_EMAIL_FL = 'Y'                             
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET ON_STATE_EMAIL_FL = 'Y'                                     
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8240                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  ON_STATE_EMAIL_FL                 **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8240-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8250-UPDATE-OFF-STATE-FLAG.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SO_WEB_EVENT                                    
                SET OFF_STATE_EMAIL_FL = 'Y'                            
              WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS)         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_SO_WEB_EVENT                                            
MFA-TR*         SET OFF_STATE_EMAIL_FL = 'Y'                                    
MFA-TR*       WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                             
MFA-TR*       QUERYNO 8250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_SO_WEB_EVENT   **'       
               DISPLAY '**  OFF_STATE_EMAIL_FL                **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  KEY = ' WS-WEB-EVENT-TS                     
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       8250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO115 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
