       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO111.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   CANCELS ORDERS WHEN ASSIGNED DATETIME > 6 MONTHS AGO.     **         
      **   WORK QUEUES ARE CREATED UNDER CERTAIN CRITERIA.           **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/07    FB        ORIGINAL VERSION                       **         
C36245*    09/07    FB        POPULATE PREMISE AND CUSTOMER NUMBERS  **         
C36245*                       ON WQS.  PUT SO NUMBER IN WQ COMMENTS. **         
C36896*    02/08    FB        ADD COMMIT AFTER CALL TO CSR02021      **         
C35671*    02/08    FB        INCREASE NAME/ADDRESS LENGTHS          **         
C37219*    04/08    FB        HANDLE NOT FOUND ON CSS_ACCOUNT        **         
P37005*    04/28/08 AW41078   ADDED LOGIC FOR NEW PAYMENT REQUIRED   **         
P37005*                       ORDER STATE CODE 'R'                   **         
A01797*    10/09    FB        EMAIL PROCESSED DATE SHOULD BE NULL.   **         
A01797*                       ADD ZIPCODE TO CSR02021 RESULTS SET.   **         
A43218*    03/29    PK98692   TO DELETE SVC FROM GAS CONSTR WHEN     **         
A43218*                       CANCELLING A SO WITH PENDING SVC.      **         
I01400*    02/12    VV90387   TRACK FUEL CONVERSIONS                 **         
A03352*    11/20/12 PK98692   1. TO GENRATE WQS FOR LATE ORDERS THAT **         
A03352*    ACT3352015         ARE OLDER THAN SPECIFIED IN JOB_PARM   **         
A03352*                       2. TO NOT GENERATE WQ, WHEN A WQ OF THE**         
A03352*                       SAME CATEGORY EXISTS IN THE TABLE IN   **         
A03352*                       ANY STATUS.                            **         
P00757**  11/18/13   MC95456  REPLACED CSR00028 CALL WITH SCSCB077   **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO111'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
A03352     05  WS-PGRMNAME            PIC X(08) VALUE 'PCSSO111'.       
P00757     05  SCSCB077               PIC X(08) VALUE 'SCSCB077'.       
P00757     05  RS-RETURN-CODE         PIC S9(09) COMP VALUE +0.         
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-DISPLAY-SO          PIC 9(13).                        
           05  WS-DISPLAY-BALANCE     PIC Z(11).99.                     
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-WQ-COUNT            PIC S9(09) COMP VALUE 0.          
           05  WS-UPDATE-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DATE-TRANS          PIC X(10).                        
           05  WS-TS-REQUIRED         PIC X(26).                        
           05  WS-CURRENT-TS          PIC X(26).                        
           05  WS-NULL-IND            PIC S9(4) COMP VALUE +0.          
           05  WS-ELEC-EXISTS         PIC X(01) VALUE 'N'.              
           05  WS-GAS-EXISTS          PIC X(01) VALUE 'N'.              
           05  WS-BOTH-EXISTS         PIC X(01) VALUE 'N'.              
           05  WS-WQ-EXISTS           PIC X(01) VALUE 'N'.              
A43218     05  WS-PEND-SVC-EXISTS     PIC X(01) VALUE 'N'.              
A43218     05  WS-PEND-RTD-SVC-EXISTS PIC X(01) VALUE 'N'.              
A03352     05  WS-WQ-CREATE           PIC X(01) VALUE 'N'.              
A03352     05  WS-WQ-DATE             PIC X(10).                        
A03352     05  WS-WQ-DATE-SCEG        PIC X(10).                        
A03352     05  WS-WQ-DATE-PSNC        PIC X(10).                        
A03352     05  WS-WQ-MONTHS           PIC X(02) VALUE SPACES.           
A03352     05  WS-ASSIGNED-TS.                                          
A03352         10  WS-ASSIGNED-DATE   PIC X(10).                        
A03352         10  WS-ASSIGNED-TIME   PIC X(16).                        
A03352     05  WS-WQ-MONTHS-H         PIC S9(04) COMP.                  
P00757     05  WS-ITEM-ID             PIC S9(10)V COMP-3 VALUE +0.      
                                                                        
      *01  LOC02021       USAGE SQL TYPE IS                             
      *                   RESULT-SET-LOCATOR VARYING.                   
      *01  LOC00028       USAGE SQL TYPE IS                             
      *                   RESULT-SET-LOCATOR VARYING.                   
A43218*01  LOC04078       USAGE SQL TYPE IS                             
A43218*                   RESULT-SET-LOCATOR VARYING.                   
                                                                        
       01  MISC-COMMENTS.                                               
           10 WS-COMMENTS-1           PIC X(150) VALUE                  
              'RESEARCH THE SO FOR ELECTRIC - SCHEDULED DATE FOR ORDER I        
      -       'S OVER 6 MONTHS OLD - COMPLETE AND POST, CANCEL, OR UPDAT        
      -       'E SCHEDULED DATE OF ORDER.'.                                     
           10 WS-COMMENTS-2           PIC X(150) VALUE                  
              'RESEARCH THE SO FOR GAS - SCHEDULED DATE FOR ORDER IS OVE        
      -       'R 6 MONTHS OLD - COMPLETE AND POST, CANCEL, OR UPDATE SCH        
      -       'EDULED DATE OF ORDER.'.                                          
           10 WS-COMMENTS-3           PIC X(150) VALUE                  
              'RESEARCH THE SO FOR ELECTRIC & GAS - SCHEDULED DATE FOR O        
      -       'RDER IS OVER 6 MONTHS OLD - COMPLETE AND POST, CANCEL OR         
      -       'UPDATE SCHEDULED DATE OF ORDER.'.                                
           10 WS-COMMENTS-4           PIC X(45) VALUE                   
              'DNP SERVICE ORDER IS MORE THAN 6 MONTHS OLD.'.           
           10 WS-COMMENTS-5           PIC X(40) VALUE                   
              'CANNOT CANCEL DUE TO FINANCIAL BALANCE.'.                
                                                                        
       01  CSR02021-DATA.                                               
           03  WS-ACCOUNT-NO            PIC 9(13) VALUE ZEROES.         
           03  WS-ACCOUNT-NO-CHAR REDEFINES WS-ACCOUNT-NO PIC X(13).    
C36896     03  CSR02021-RETURN-DATA.                                    
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
           05  S-RECV-TYPE              PIC  X(03) VALUE SPACES.        
           05  S-RECV-DESC              PIC  X(25) VALUE SPACES.        
           05  S-PYMT-PRIORITY-LVL      PIC S9(04) COMP VALUE +0.       
           05  S-ITEM-ID                PIC S9(09) COMP VALUE +0.       
           05  S-SPECIAL-DUE-DATE       PIC  X(10) VALUE SPACES.        
           05  S-UTIL-RELATED           PIC  X(01) VALUE SPACES.        
           05  S-FULL-BALANCE           PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-NBR-PYMTS-REMAIN       PIC S9(04) COMP VALUE +0.       
           05  S-MNTH-PYMT-AMT          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-BILLED-BALANCE         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-AMT-AR-DAY-00          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-AMT-AR-DAY-30          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-AMT-AR-DAY-60          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-AMT-AR-DAY-90          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-DATE-BILL-DAY-00       PIC  X(10)      VALUE SPACES.   
           05  S-DATE-BILL-DAY-30       PIC  X(10)      VALUE SPACES.   
           05  S-DATE-BILL-DAY-60       PIC  X(10)      VALUE SPACES.   
           05  S-DATE-BILL-DAY-90       PIC  X(10)      VALUE SPACES.   
           05  S-ARREARS-DUE-DATE       PIC  X(10)      VALUE SPACES.   
           05  S-PAST-DUE-AMOUNT        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-CURRENT-DUE-DATE       PIC  X(10)      VALUE SPACES.   
           05  S-ACCOUNT-ARREARS        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-EPP-IND                PIC X(01)       VALUE SPACES.   
           05  S-DPP-IND                PIC X(01)       VALUE SPACES.   
           05  S-DFA-IND                PIC X(01)       VALUE SPACES.   
           05  S-STA-IND                PIC X(01)       VALUE SPACES.   
           05  S-CANREB-CODE-00         PIC X(01)       VALUE SPACES.   
           05  S-CANREB-CODE-30         PIC X(01)       VALUE SPACES.   
           05  S-CANREB-CODE-60         PIC X(01)       VALUE SPACES.   
           05  S-CANREB-CODE-90         PIC X(01)       VALUE SPACES.   
           05  S-AMT-DIRECT-PYMT        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-CODE-PAY-AHEAD         PIC  X(01)      VALUE SPACES.   
           05  S-ACCOUNT-NO             PIC  X(13)      VALUE SPACES.   
           05  S-CODE-ACCT-STAT         PIC  X(01)      VALUE SPACES.   
           05  S-ACCT-XFER-TO           PIC  X(13)      VALUE SPACES.   
           05  S-CREDIT-GROUP           PIC  X(01)      VALUE SPACES.   
           05  S-CASH-ONLY              PIC  X(01)      VALUE SPACES.   
           05  S-NO-BAD-CHECKS          PIC S9(04) COMP VALUE +0.       
           05  S-DNP-STATUS             PIC  X(02)      VALUE SPACES.   
           05  S-CODE-BANKRUPT          PIC  X(01)      VALUE SPACES.   
           05  S-CODE-PREPAID-MTR       PIC  X(01)      VALUE SPACES.   
           05  S-DISC-BALANCE           PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-DATE-DISC              PIC  X(10)      VALUE SPACES.   
           05  S-TOTAL-AR-BALANCE       PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-DATE-NEXT-BILL         PIC  X(10)      VALUE SPACES.   
           05  S-CHRG-CARD-AUTH         PIC  X(01)      VALUE SPACES.   
           05  S-DATE-LIHEAP-START      PIC  X(10)      VALUE SPACES.   
           05  S-DATE-LIHEAP-END        PIC  X(10)      VALUE SPACES.   
C35671     05  S-FULL-NAME              PIC  X(96)      VALUE SPACES.   
C35671     05  S-ADDRESS                PIC  X(96)      VALUE SPACES.   
           05  S-AC-LAST-UPDATE-TS      PIC  X(26)      VALUE SPACES.   
           05  S-AT-LAST-UPDATE-TS      PIC  X(26)      VALUE SPACES.   
           05  S-CHRG-OFF-AR            PIC  X(01)      VALUE SPACES.   
           05  S-AMT-TOT-RECONNECT      PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-AMT-RCNCT-COLL         PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-RECONNECT-IND          PIC X(01) VALUE SPACES.         
           05  S-LIEN-CD                PIC X(01) VALUE 'N'.            
           05  S-AMT-PAYOFF             PIC S9(11)V99 COMP-3 VALUE +0.  
C35671     05  S-PRINT-NAME             PIC  X(96)      VALUE SPACES.   
           05  S-CNT-LONG-DESC          PIC  X(30)      VALUE SPACES.   
           05  S-MEDICAL-FLAG           PIC  X(01)      VALUE SPACES.   
           05  S-AMT-UNUSED-CREDIT      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-TOT-SUMM-UNBILLED      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  S-WRITEOFF-FLAG          PIC  X(01)  VALUE SPACE.        
           05  S-DUMMY1                 PIC  X(01)  VALUE SPACE.        
           05  S-DUMMY2                 PIC S9(04) COMP VALUE +0.       
A01797     05  S-ZIP-CODE               PIC  X(05)  VALUE SPACE.        
                                                                        
A43218 01  CSR04078-DATA.                                               
A43218     05  WG-RETURN-CD             PIC S9(09) COMP VALUE +0.       
A43218     05  WG-ACTION-CD             PIC X(01) VALUE SPACES.         
COB305     05 WG-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305     05 WG-SERVICE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
A43218     05  WG-STRUCT-TYP-CD         PIC X(01) VALUE SPACES.         
A43218     05  WG-STRUCT-CD             PIC X(01) VALUE SPACES.         
A43218     05  WG-SALES-REP-ID          PIC X(07) VALUE SPACES.         
COB305     05 WG-BLDR-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305     05 WG-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305     05 WG-BLDR-CUST-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
A43218     05  WG-FAC-AMT               PIC S9(09)V99 COMP-3 VALUE +0.  
A43218     05  WG-OWNER-CD              PIC X(01) VALUE SPACES.         
A43218     05  WG-X-STREET1             PIC X(35) VALUE SPACES.         
A43218     05  WG-X-STREET2             PIC X(35) VALUE SPACES.         
A43218     05  WG-PFNO                  PIC X(09) VALUE SPACES.         
A43218     05  WG-CITY-GATE-ID          PIC X(07) VALUE SPACES.         
A43218     05  WG-USERID                PIC X(07) VALUE SPACES.         
A43218     05  WG-PANEL-NO              PIC X(09) VALUE SPACES.         
I01400     05  WG-FUEL-CONV-TYPE-CD     PIC X(01) VALUE SPACES.         
I01400     05  WG-FUEL-CONV-COMMENT     PIC X(20) VALUE SPACES.         
                                                                        
P00757******************************************************************        
P00757* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
P00757******************************************************************        
P00757*                                                                         
P00757     EXEC SQL                                                             
P00757        INCLUDE CWS00077                                                  
P00757     END-EXEC.                                                            
P00757*                                                                         
P00757******************************************************************        
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBORTYP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWQITS                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOEMQ                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUPD                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
A43218*---  CSS_GASLINE_SO_XRF XX  ---*                                         
A43218     EXEC SQL                                                             
A43218          INCLUDE TBGASSO                                                 
A43218     END-EXEC.                                                            
                                                                        
A43218*---  CSS_GAS_SERV_LINE XO  ---*                                          
A43218     EXEC SQL                                                             
A43218          INCLUDE TBGASSRV                                                
A43218     END-EXEC.                                                            
                                                                        
A43218*---  CSS_PREM_GAS_LINE Y0  ---*                                          
A43218     EXEC SQL                                                             
A43218          INCLUDE TBPREMLN                                                
A43218     END-EXEC.                                                            
                                                                        
A03352*---    CSS_JOB_PARM G6    ---*                                           
A03352     EXEC SQL                                                             
A03352         INCLUDE TBJBPARM                                                 
A03352     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR CURSOR WITH HOLD FOR                     
               SELECT SERV_ORDER_NO,                                    
                      ORDER_STATE_CD,                                   
                      RESP_AREA_ID,                                     
                      VO.ORDER_TYPE_CD,                                 
                      ACCOUNT_NO,                                       
                      LOCAL_OFFICE,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      ORDER_RECVED_BY,                                  
                      SERV_ORDER_STATUS,                                
C36245                PREMISE_NO,                                       
A03352                VO.COMPANY_NO                                     
                 FROM CSS_SO_DATA VO,                                   
                      CSS_ORDER_TYPE FO                                 
                WHERE ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                  :VO-ASSIGNED-DATETIME
              )         
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND SERV_ORDER_STATUS < '20'                          
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND ORDER_GROUP_CD <> 'F'                             
                  AND CUST_CNT_ID = ' '                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               VO.ORDER_TYPE_CD,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_RECVED_BY,                                          
MFA-TR*               SERV_ORDER_STATUS,                                        
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               VO.COMPANY_NO                                             
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE ASSIGNED_DATETIME < :VO-ASSIGNED-DATETIME                 
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND SERV_ORDER_STATUS < '20'                                  
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND ORDER_GROUP_CD = 'F'                                     
MFA-TR*           AND CUST_CNT_ID = ' '                                         
MFA-TR*           QUERYNO 1000                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE UTIL_CURSOR CURSOR FOR                             
               SELECT CODE_UTIL_TYPE                                    
                 FROM CSS_SO_ORDER_INST                                 
                WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD > ' '                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UTIL_CURSOR CURSOR FOR                                     
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                         
MFA-TR*           AND WORK_TYPE_CD > ' '                                        
MFA-TR*           QUERYNO 2000                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
A43218*--- CURSOR TO GET ALL PREMISES ASSOCIATED WITH A SERVICE                 
A43218     EXEC SQL                                                     
A43218       DECLARE PREM_SVC_CURSOR CURSOR FOR                         
A43218          SELECT PREMISE_NO                                       
A43218            FROM CSS_PREM_GAS_LINE                                
A43218           WHERE SERVICE_NO = :Y0-SERVICE-NO                      
A43218                                                      
A43218     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PREM_SVC_CURSOR CURSOR FOR                                 
MFA-TR*         SELECT PREMISE_NO                                               
MFA-TR*           FROM CSS_PREM_GAS_LINE                                        
MFA-TR*          WHERE SERVICE_NO = :Y0-SERVICE-NO                              
MFA-TR*          QUERYNO 7220                                                   
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2021 CURSOR
MSQ001          FOR CALL CSR02021 ( :WS-ACCOUNT-NO-CHAR
                  , ' '
                  , 'N'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4078 CURSOR
MSQ001          FOR CALL CSR04078 ( :WG-ACTION-CD
                  , :WG-PREMISE-NO
                  , :WG-SERVICE-NO
                  , :WG-STRUCT-TYP-CD
                  , :WG-STRUCT-CD
                  , :WG-SALES-REP-ID
                  , :WG-BLDR-ADDR-ID
                  , :WG-CUSTOMER-NO
                  , :WG-BLDR-CUST-NO
                  , :WG-FAC-AMT
                  , :WG-OWNER-CD
                  , :WG-X-STREET1
                  , :WG-X-STREET2
                  , :WG-PFNO
                  , :WG-CITY-GATE-ID
                  , :WG-USERID
                  , :WG-PANEL-NO
                  , :WG-FUEL-CONV-TYPE-CD
                  , :WG-FUEL-CONV-COMMENT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, 5, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TS-REQUIRED                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES TIMESTAMP                                                  
MFA-TR*             (CURRENT TIMESTAMP + 5 DAYS)                                
MFA-TR*         INTO :WS-TS-REQUIRED                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -6, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :VO-ASSIGNED-DATETIME                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES TIMESTAMP                                                  
MFA-TR*             (CURRENT TIMESTAMP - 6 MONTHS)                              
MFA-TR*         INTO :VO-ASSIGNED-DATETIME                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL ORDERS  = ' WS-DISPLAY-COUNT.                 
           MOVE WS-WQ-COUNT TO WS-DISPLAY-COUNT.                        
           DISPLAY 'TOTAL WQS     = ' WS-DISPLAY-COUNT.                 
           MOVE WS-UPDATE-COUNT TO WS-DISPLAY-COUNT.                    
           DISPLAY 'TOTAL UPDATES = ' WS-DISPLAY-COUNT.                 
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
A03352     PERFORM 5200-GET-SO-WQ-DATES    THRU 5200-EXIT.              
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING SO CURSOR           **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR                                           
               INTO :VO-SERV-ORDER-NO,                                  
                    :VO-ORDER-STATE-CD,                                 
                    :VO-RESP-AREA-ID,                                   
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-ACCOUNT-NO,                                     
                    :VO-LOCAL-OFFICE,                                   
                    :VO-ASSIGNED-DATETIME,                              
                    :VO-ORDER-RECVED-BY,                                
                    :VO-SERV-ORDER-STATUS,                              
C36245              :VO-PREMISE-NO,                                     
A03352              :VO-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING SO CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO.                      
                                                                        
           PERFORM 2000-GET-UTIL-TYPES THRU 2000-EXIT.                  
           IF WS-ELEC-EXISTS = 'Y' AND WS-GAS-EXISTS = 'Y'              
               MOVE 'Y' TO WS-BOTH-EXISTS                               
               MOVE 'N' TO WS-ELEC-EXISTS                               
                           WS-GAS-EXISTS
           END-IF.                               
                                                                        
           EVALUATE VO-ORDER-STATE-CD                                   
               WHEN 'D'                                                 
               WHEN 'B'                                                 
C37005         WHEN 'R'                                                 
               WHEN 'H'                                                 
A03352             PERFORM 5300-CHECK-WQ-DATE THRU 5300-EXIT            
A03352             IF WS-WQ-CREATE = 'Y'                                
A03352*               ADD 1 TO WS-WQ-COUNT                                      
                      PERFORM 3000-CREATE-WQ    THRU 3000-EXIT          
A03352             END-IF                                               
               WHEN OTHER                                               
                   PERFORM 4000-EVAL-SO-TYPE THRU 4000-EXIT             
           END-EVALUATE.                                                
                                                                        
           ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT.                       
           IF WS-COMMIT-COUNT > 250                                     
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                             
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-GET-UTIL-TYPES.                                             
                                                                        
           MOVE 'N' TO WS-ELEC-EXISTS                                   
                       WS-GAS-EXISTS                                    
                       WS-BOTH-EXISTS.                                  
           MOVE VO-SERV-ORDER-NO TO VI-SERV-ORDER-NO.                   
                                                                        
           EXEC SQL                                                     
               OPEN UTIL_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING UTIL CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE UTIL_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING UTIL CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH UTIL_CURSOR                                         
               INTO :VI-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF VI-CODE-UTIL-TYPE = 'E'                           
                       MOVE 'Y' TO WS-ELEC-EXISTS                       
                   END-IF                                               
                   IF VI-CODE-UTIL-TYPE = 'G'                           
                       MOVE 'Y' TO WS-GAS-EXISTS                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING UTIL CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-CREATE-WQ.                                                  
                                                                        
           PERFORM 3100-DETERMINE-WQ-EXISTS THRU 3100-EXIT.             
           IF WS-WQ-EXISTS = 'N'                                        
A03352         ADD 1 TO WS-WQ-COUNT                                     
               PERFORM 3200-FORMAT-WQ THRU 3200-EXIT                    
               IF WS-BOTH-EXISTS = 'Y'                                  
P00757             MOVE 172 TO WS-77-CATEGORY-ID                        
C36245             STRING WS-COMMENTS-3                                 
C36245                    ' '                                           
C36245                    WS-DISPLAY-SO                                 
C36245                    DELIMITED BY SIZE                             
P00757               INTO WS-77-COMMENTS-TEXT                           
P00757             MOVE 164 TO WS-77-COMMENTS-LEN                       
               END-IF                                                   
               IF WS-ELEC-EXISTS = 'Y'                                  
P00757             MOVE 78 TO WS-77-CATEGORY-ID                         
C36245             STRING WS-COMMENTS-1                                 
C36245                    ' '                                           
C36245                    WS-DISPLAY-SO                                 
C36245                    DELIMITED BY SIZE                             
P00757               INTO WS-77-COMMENTS-TEXT                           
P00757             MOVE 164 TO WS-77-COMMENTS-LEN                       
               END-IF                                                   
               IF WS-GAS-EXISTS = 'Y'                                   
P00757             MOVE 172 TO WS-77-CATEGORY-ID                        
C36245             STRING WS-COMMENTS-2                                 
C36245                    ' '                                           
C36245                    WS-DISPLAY-SO                                 
C36245                    DELIMITED BY SIZE                             
P00757               INTO WS-77-COMMENTS-TEXT                           
P00757             MOVE 164 TO WS-77-COMMENTS-LEN                       
               END-IF                                                   
               PERFORM 3300-INSERT-WQ THRU 3300-EXIT
           END-IF.                   
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-DETERMINE-WQ-EXISTS.                                        
                                                                        
           MOVE 'N' TO WS-WQ-EXISTS.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ITEM_ID                                           
                 INTO :WQ-ITEM-ID                                       
                 FROM CSS_WQ_ITEMS                                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A03352            AND CATEGORY_ID IN (78, 172, 77, 261)                 
A03352                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ITEM_ID                                                   
MFA-TR*          INTO :WQ-ITEM-ID                                               
MFA-TR*          FROM CSS_WQ_ITEMS                                              
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND CATEGORY_ID IN (78, 172, 77, 261)                         
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           QUERYNO 3100                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-WQ-EXISTS                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-WQ-EXISTS                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_WQ_ITEMS     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-FORMAT-WQ.                                                  
                                                                        
P00757     INITIALIZE CWS00077-FIELDS.                                  
P00757     MOVE 0                              TO WS-77-ITEM-ID.        
P00757     MOVE '1'                            TO WS-77-ROUTE-CATEGORY. 
P00757     MOVE 'BATCH'                        TO WS-77-USER-ID-ORIG.   
P00757     MOVE SPACES                         TO WS-77-USER-ID-ASGN.   
P00757     MOVE VO-LOCAL-OFFICE                TO WS-77-LOCAL-OFFICE.   
P00757     MOVE VO-RESP-AREA-ID                TO WS-77-RESP-AREA-ID.   
P00757     MOVE VO-ACCOUNT-NO                  TO WS-77-ACCOUNT-NO.     
P00757     MOVE VO-PREMISE-NO                  TO WS-77-PREMISE-NO.     
P00757     MOVE VO-SERV-ORDER-NO               TO WS-77-SERV-ORDER-NO.  
P00757     MOVE 'N'                            TO WS-77-PRIORITY.       
           MOVE 'PCSSO111 IS INSERTING THIS ROW' TO                     
P00757          WS-77-FREE-FORM-TXT.                                    
P00757     MOVE 33                               TO WS-77-FREE-FORM-LEN.
P00757     MOVE WS-TS-REQUIRED                   TO WS-77-DATE-REQUIRED.
P00757     MOVE WS-CURRENT-TS                    TO WS-77-DATE-CREATED. 
P00757     MOVE WS-PGRMNAME                      TO WS-77-CREATED-BY.   
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO                                       
                 INTO :AT-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                               
MFA-TR*           QUERYNO 3200                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO AT-CUSTOMER-NO                        
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ACCOUNT      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
P00757     MOVE AT-CUSTOMER-NO TO WS-77-CUSTOMER-NO.                    
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-INSERT-WQ.                                                  
                                                                        
P00757        CALL SCSCB077 USING CWS00077-FIELDS,                      
P00757                           ABEND-FILE,                            
P00757                           RS-RETURN-CODE.                        
                                                                        
P00757     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE.                
P00757     IF  ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
P00757         MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE       
P00757         DISPLAY '****************************************'       
P00757         DISPLAY '**  ERROR CALLING SCSCB077           **'        
P00757         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
P00757         DISPLAY '**  ORDER   = ' WS-DISPLAY-SO                   
P00757         DISPLAY '**  ACCOUNT = ' WS-77-ACCOUNT-NO                
P00757         DISPLAY '**  PREMISE = ' WS-77-PREMISE-NO                
P00757         DISPLAY '**  WQ-COMM = ' WS-77-COMMENTS-TEXT             
P00757         DISPLAY '**  PROCESSING TERMINATED             **'       
P00757         DISPLAY '****************************************'       
P00757         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
P00757     ELSE                                                         
P00757        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
P00757     END-IF.                                                      
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4000-EVAL-SO-TYPE.                                               
                                                                        
           EVALUATE VO-ORDER-TYPE-CD                                    
               WHEN 'DNP01'                                             
               WHEN 'DNPFB'                                             
                  PERFORM 4100-DNP-ORDERS THRU 4100-EXIT                
               WHEN 'CC001'                                             
               WHEN 'CC002'                                             
               WHEN 'CC003'                                             
               WHEN 'NC001'                                             
               WHEN 'FM002'                                             
                   PERFORM 4200-NON-DNP-ORDERS THRU 4200-EXIT           
A43218         WHEN 'FW024'                                             
A43218             PERFORM 5000-UPDATE-SO THRU 5000-EXIT                
A43218             PERFORM 5500-UPDATE-GAS-SVC THRU 5500-EXIT           
               WHEN OTHER                                               
                   PERFORM 5000-UPDATE-SO THRU 5000-EXIT                
           END-EVALUATE.                                                
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4100-DNP-ORDERS.                                                 
                                                                        
           ADD 1 TO WS-WQ-COUNT.                                        
           PERFORM 3200-FORMAT-WQ THRU 3200-EXIT.                       
           IF WS-BOTH-EXISTS = 'Y' OR WS-ELEC-EXISTS = 'Y'              
P00757         MOVE 76 TO WS-77-CATEGORY-ID                             
C36245         STRING WS-COMMENTS-4                                     
C36245                ' '                                               
C36245                WS-DISPLAY-SO                                     
C36245                DELIMITED BY SIZE                                 
C36245           INTO WS-77-COMMENTS-TEXT                               
P00757         MOVE 59 TO WS-77-COMMENTS-LEN
           END-IF.                           
           IF WS-GAS-EXISTS = 'Y'                                       
P00757         MOVE 260 TO WS-77-CATEGORY-ID                            
C36245         STRING WS-COMMENTS-4                                     
C36245                ' '                                               
C36245                WS-DISPLAY-SO                                     
C36245                DELIMITED BY SIZE                                 
P00757           INTO WS-77-COMMENTS-TEXT                               
P00757         MOVE 59 TO WS-77-COMMENTS-LEN
           END-IF.                           
           PERFORM 3300-INSERT-WQ THRU 3300-EXIT.                       
                                                                        
       4100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4200-NON-DNP-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODE_ACCT_STAT                                    
                 INTO :AT-CODE-ACCT-STAT                                
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                       
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT                                            
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                               
MFA-TR*           QUERYNO 4200                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'A' TO AT-CODE-ACCT-STAT                        
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ACCOUNT      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF AT-CODE-ACCT-STAT = 'P'                                   
               PERFORM 4300-CALL-CSR02021 THRU 4300-EXIT                
               IF S-FULL-BALANCE > 0                                    
                   PERFORM 4400-PENDING-WITH-BALANCE THRU 4400-EXIT     
               ELSE                                                     
                   PERFORM 5000-UPDATE-SO THRU 5000-EXIT                
               END-IF                                                   
           ELSE                                                         
               PERFORM 5000-UPDATE-SO THRU 5000-EXIT
           END-IF.                   
                                                                        
       4200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4300-CALL-CSR02021.                                              
                                                                        
           INITIALIZE CSR02021-DATA.                                    
           MOVE VO-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
      *    EXEC SQL                                                     
      *       CALL CSR02021 (:WS-ACCOUNT-NO-CHAR,                       
      *                      ' ',                                       
      *                      'N')                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2021
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2021
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2021 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN +466                                                
                   PERFORM 4310-PROCESS-SPDB-OUTPUT THRU 4310-EXIT      
               WHEN -471                                                
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  DBAS RESTART WLM OR CSR02021     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CALLING CSR02021           **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       4300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4310-PROCESS-SPDB-OUTPUT.                                        
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC02021)                                               
      *       WITH PROCEDURE CSR02021                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2021 CURSOR FOR RESULT SET        
      *       :LOC02021                                                 
      *    END-EXEC.                                                    
                                                                        
C36896     INITIALIZE CSR02021-RETURN-DATA.                             
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_2021 INTO                           
                 :S-RETURN-CODE                                         
                ,:S-RECV-TYPE                                           
                ,:S-RECV-DESC                                           
                ,:S-PYMT-PRIORITY-LVL                                   
                ,:S-ITEM-ID                                             
                ,:S-SPECIAL-DUE-DATE                                    
                ,:S-UTIL-RELATED                                        
                ,:S-FULL-BALANCE                                        
                ,:S-NBR-PYMTS-REMAIN                                    
                ,:S-MNTH-PYMT-AMT                                       
                ,:S-BILLED-BALANCE                                      
                ,:S-AMT-AR-DAY-00                                       
                ,:S-AMT-AR-DAY-30                                       
                ,:S-AMT-AR-DAY-60                                       
                ,:S-AMT-AR-DAY-90                                       
                ,:S-DATE-BILL-DAY-00                                    
                ,:S-DATE-BILL-DAY-30                                    
                ,:S-DATE-BILL-DAY-60                                    
                ,:S-DATE-BILL-DAY-90                                    
                ,:S-ARREARS-DUE-DATE                                    
                ,:S-PAST-DUE-AMOUNT                                     
                ,:S-CURRENT-DUE-DATE                                    
                ,:S-ACCOUNT-ARREARS                                     
                ,:S-EPP-IND                                             
                ,:S-DPP-IND                                             
                ,:S-DFA-IND                                             
                ,:S-STA-IND                                             
                ,:S-CANREB-CODE-00                                      
                ,:S-CANREB-CODE-30                                      
                ,:S-CANREB-CODE-60                                      
                ,:S-CANREB-CODE-90                                      
                ,:S-AMT-DIRECT-PYMT                                     
                ,:S-CODE-PAY-AHEAD                                      
                ,:S-ACCOUNT-NO                                          
                ,:S-CODE-ACCT-STAT                                      
                ,:S-ACCT-XFER-TO                                        
                ,:S-CREDIT-GROUP                                        
                ,:S-CASH-ONLY                                           
                ,:S-NO-BAD-CHECKS                                       
                ,:S-DNP-STATUS                                          
                ,:S-CODE-BANKRUPT                                       
                ,:S-CODE-PREPAID-MTR                                    
                ,:S-DISC-BALANCE                                        
                ,:S-DATE-DISC                                           
                ,:S-TOTAL-AR-BALANCE                                    
                ,:S-DATE-NEXT-BILL                                      
                ,:S-CHRG-CARD-AUTH                                      
                ,:S-DATE-LIHEAP-START                                   
                ,:S-DATE-LIHEAP-END                                     
                ,:S-FULL-NAME                                           
                ,:S-ADDRESS                                             
                ,:S-AC-LAST-UPDATE-TS                                   
                ,:S-AT-LAST-UPDATE-TS                                   
                ,:S-CHRG-OFF-AR                                         
                ,:S-AMT-TOT-RECONNECT                                   
                ,:S-AMT-RCNCT-COLL                                      
                ,:S-RECONNECT-IND                                       
                ,:S-LIEN-CD                                             
                ,:S-AMT-PAYOFF                                          
                ,:S-PRINT-NAME                                          
                ,:S-CNT-LONG-DESC                                       
                ,:S-MEDICAL-FLAG                                        
                ,:S-AMT-UNUSED-CREDIT                                   
                ,:S-TOT-SUMM-UNBILLED                                   
                ,:S-WRITEOFF-FLAG                                       
                ,:S-DUMMY1                                              
                ,:S-DUMMY2                                              
A01797          ,:S-ZIP-CODE                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR FETCHING CSR02021 RESULTS  **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ORDER   = ' WS-DISPLAY-SO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
C36896     EXEC SQL                                                     
C36896        CLOSE RESULT_SET_CSR_2021                                 
C36896     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36896     EXEC SQL                                                     
C36896         COMMIT                                                   
C36896     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       4310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4400-PENDING-WITH-BALANCE.                                       
                                                                        
A03352     PERFORM 5300-CHECK-WQ-DATE THRU 5300-EXIT                    
A03352     IF WS-WQ-CREATE = 'Y'                                        
A03352       PERFORM 3100-DETERMINE-WQ-EXISTS THRU 3100-EXIT            
A03352       IF WS-WQ-EXISTS = 'N'                                      
               ADD 1 TO WS-WQ-COUNT                                     
               PERFORM 3200-FORMAT-WQ THRU 3200-EXIT                    
               IF WS-BOTH-EXISTS = 'Y' OR WS-ELEC-EXISTS = 'Y'          
P00757            MOVE 77 TO WS-77-CATEGORY-ID                          
C36245            STRING WS-COMMENTS-5                                  
C36245                   ' '                                            
C36245                   WS-DISPLAY-SO                                  
C36245                   DELIMITED BY SIZE                              
P00757              INTO WS-77-COMMENTS-TEXT                            
P00757            MOVE 59 TO WS-77-COMMENTS-LEN                         
A03352         END-IF                                                   
               IF WS-GAS-EXISTS = 'Y'                                   
P00757            MOVE 261 TO WS-77-CATEGORY-ID                         
C36245            STRING WS-COMMENTS-5                                  
C36245                   ' '                                            
C36245                   WS-DISPLAY-SO                                  
C36245                   DELIMITED BY SIZE                              
P00757              INTO WS-77-COMMENTS-TEXT                            
P00757            MOVE 59 TO WS-77-COMMENTS-LEN                         
A03352         END-IF                                                   
               PERFORM 3300-INSERT-WQ THRU 3300-EXIT                    
A03352       END-IF
           END-IF.                                                    
                                                                        
       4400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-UPDATE-SO.                                                  
                                                                        
           ADD 1 TO WS-UPDATE-COUNT.                                    
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_STATE_CD = 'C',                             
                      COMPLETED_DATETIME = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )               
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET ORDER_STATE_CD = 'C',                                     
MFA-TR*               COMPLETED_DATETIME = :WS-CURRENT-TS                       
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           QUERYNO 5000                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_SO_DATA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                          (SERV_ORDER_NO,                               
                           USER_ID_UPDT_BY,                             
                           UPDATE_DATETIME,                             
                           PANEL_NO,                                    
                           ASSIGNED_DATETIME,                           
                           ORDER_TYPE_CD,                               
                           SERV_ORDER_STATUS,                           
                           ORDER_STATE_CD,                              
                           WANTED_BY_DATETIME)                          
                   VALUES (:VO-SERV-ORDER-NO,                           
                           'SYSTEM',                                    
                           CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS),                  
                           'S111',                                      
                           CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME),           
                           :VO-ORDER-TYPE-CD,                           
                           :VO-SERV-ORDER-STATUS,                       
                           'C',                                         
                           CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    USER_ID_UPDT_BY,                                     
MFA-TR*                    UPDATE_DATETIME,                                     
MFA-TR*                    PANEL_NO,                                            
MFA-TR*                    ASSIGNED_DATETIME,                                   
MFA-TR*                    ORDER_TYPE_CD,                                       
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    ORDER_STATE_CD,                                      
MFA-TR*                    WANTED_BY_DATETIME)                                  
MFA-TR*            VALUES (:VO-SERV-ORDER-NO,                                   
MFA-TR*                    'SYSTEM',                                            
MFA-TR*                    :WS-CURRENT-TS,                                      
MFA-TR*                    'S111',                                              
MFA-TR*                    :VO-ASSIGNED-DATETIME,                               
MFA-TR*                    :VO-ORDER-TYPE-CD,                                   
MFA-TR*                    :VO-SERV-ORDER-STATUS,                               
MFA-TR*                    'C',                                                 
MFA-TR*                    :VO-ASSIGNED-DATETIME)                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_SO_UPDATE    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF VO-ORDER-RECVED-BY = 'ECSPRD1'                            
               PERFORM 5100-INSERT-EMAIL-QUEUE THRU 5100-EXIT
           END-IF.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-INSERT-EMAIL-QUEUE.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_EMAIL_QUEUE                           
                          (SERV_ORDER_NO,                               
                           CREATED_TS,                                  
                           ORDER_STATE_CD)                              
                   VALUES (:VO-SERV-ORDER-NO,                           
                           CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS),                  
                           'C')                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_EMAIL_QUEUE                                   
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    CREATED_TS,                                          
MFA-TR*                    ORDER_STATE_CD)                                      
MFA-TR*            VALUES (:VO-SERV-ORDER-NO,                                   
MFA-TR*                    :WS-CURRENT-TS,                                      
MFA-TR*                    'C')                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_SO_EMAIL_QUEUE *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03352 5200-GET-SO-WQ-DATES.                                            
A03352                                                                  
A03352     MOVE WS-PGRMNAME               TO   G6-PROGRAM-NAME.         
A03352     MOVE 'A'                       TO   G6-STATUS.               
A03352     MOVE 'PARM'                    TO   G6-CMND-CODE.            
A03352                                                                  
A03352* TO GET PARM DATA FOR COMPANY NO 01                                      
A03352     MOVE '01'                      TO   G6-COMPANY-NO.           
A03352     PERFORM  7100-SELECT-JOB-PARM  THRU 7100-EXIT.               
A03352     MOVE G6-PARM-DATA(15:2)        TO   WS-WQ-MONTHS-H.          
A03352     PERFORM  7150-GET-WQ-DATE      THRU 7150-EXIT.               
A03352     MOVE WS-WQ-DATE                TO   WS-WQ-DATE-SCEG.         
A03352                                                                  
A03352* TO GET PARM DATA FOR COMPANY NO 26                                      
A03352     MOVE '26'                      TO   G6-COMPANY-NO.           
A03352     PERFORM  7100-SELECT-JOB-PARM  THRU 7100-EXIT.               
A03352     MOVE G6-PARM-DATA(15:2)        TO   WS-WQ-MONTHS-H.          
A03352     PERFORM  7150-GET-WQ-DATE      THRU 7150-EXIT.               
A03352     MOVE WS-WQ-DATE                TO   WS-WQ-DATE-PSNC.         
A03352                                                                  
A03352 5200-EXIT.                                                       
A03352     EXIT.                                                        
                                                                        
                                                                        
A03352 5300-CHECK-WQ-DATE.                                              
A03352                                                                  
A03352      MOVE VO-ASSIGNED-DATETIME TO WS-ASSIGNED-TS.                
A03352      MOVE SPACES TO WS-WQ-CREATE.                                
A03352      IF (VO-COMPANY-NO = '01' AND                                
A03352          WS-ASSIGNED-DATE < WS-WQ-DATE-SCEG)   OR                
A03352         (VO-COMPANY-NO = '26' AND                                
A03352          WS-ASSIGNED-DATE < WS-WQ-DATE-PSNC)                     
A03352         MOVE 'Y' TO WS-WQ-CREATE
            END-IF.                                
A03352                                                                  
A03352 5300-EXIT.                                                       
A03352     EXIT.                                                        
                                                                        
                                                                        
                                                                        
A43218 5500-UPDATE-GAS-SVC.                                             
A43218     PERFORM 7200-CHECK-IF-PENDING              THRU 7200-EXIT.   
A43218     IF WS-PEND-SVC-EXISTS = 'Y' THEN                             
A43218        PERFORM 8100-DELETE-GAS-SO-XRF          THRU 8100-EXIT    
A43218        MOVE XO-SERVICE-NO                      TO Y0-SERVICE-NO  
A43218        PERFORM 7210-OPEN-PREM-SVC-CURSOR       THRU 7210-EXIT    
A43218        PERFORM 7220-FETCH-PREM-SVC-CURSOR      THRU 7220-EXIT    
A43218        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
A43218           PERFORM 7230-FORMAT-CSR04078-VARS    THRU 7230-EXIT    
A43218           PERFORM 7235-CALL-CSR04078-SPDB      THRU 7235-EXIT    
A43218           PERFORM 7220-FETCH-PREM-SVC-CURSOR   THRU 7220-EXIT    
A43218        END-PERFORM                                               
A43218        PERFORM 7290-CLOSE-PREM-SVC-CURSOR      THRU 7290-EXIT    
A43218     END-IF                                                       
A43218*    ELSE                                                                 
A43218     PERFORM 7300-CHECK-IF-PENDING-RETD      THRU 7300-EXIT       
A43218     IF WS-PEND-RTD-SVC-EXISTS = 'Y' THEN                         
A43218        PERFORM 8100-DELETE-GAS-SO-XRF       THRU 8100-EXIT       
A43218        PERFORM 8200-UPDATE-RETD-TO-ACTIVE   THRU 8200-EXIT       
A43218     END-IF.                                                      
A43218*    IF WS-PEND-SVC-EXISTS = 'Y' OR                                       
A43218*       WS-PEND-RTD-SVC-EXISTS = 'Y' THEN                                 
A43218*       PERFORM 8100-DELETE-GAS-SO-XRF       THRU 8100-EXIT               
A43218*    END-IF.                                                              
                                                                        
A43218 5500-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
                                                                        
A03352 7100-SELECT-JOB-PARM.                                            
A03352                                                                  
A03352     MOVE SPACES TO G6-PARM-DATA.                                 
A03352     EXEC SQL                                                     
A03352        SELECT PARM_DATA                                          
A03352          INTO :G6-PARM-DATA                                      
A03352          FROM CSS_JOB_PARM                                       
A03352         WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
A03352           AND COMPANY_NO   = :G6-COMPANY-NO                      
A03352           AND CMND_CODE    = :G6-CMND-CODE                       
A03352           AND STATUS       = :G6-STATUS                          
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03352         CONTINUE                                                 
A03352     ELSE                                                         
A03352         MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
A03352         DISPLAY '****************************************'       
A03352         DISPLAY '**  ERROR 7100-SELECT-JOB-PARM.      **'        
A03352         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
A03352         DISPLAY '**  PROGRAM = ' G6-PROGRAM-NAME                 
A03352         DISPLAY '**  COMPANY = ' G6-COMPANY-NO                   
A03352         DISPLAY '**  PROCESSING TERMINATED             **'       
A03352         DISPLAY '****************************************'       
A03352         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
A03352     END-IF.                                                      
A03352*                                                                         
A03352 7100-EXIT.                                                       
A03352     EXIT.                                                        
                                                                        
A03352 7150-GET-WQ-DATE.                                                
A03352                                                                  
A03352     MOVE SPACES TO WS-WQ-DATE.                                   
A03352     EXEC SQL                                                     
A03352        SELECT
              CAST(DATEADD( MONTH, -(:WS-WQ-MONTHS-H), 
           CIS.CURRENT$TIMESTAMP() ) AS DATE)
            INTO
              :WS-WQ-DATE                                        
A03352     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES DATE                                                       
MFA-TR*             (CURRENT TIMESTAMP - (:WS-WQ-MONTHS-H) MONTHS)              
MFA-TR*         INTO :WS-WQ-DATE                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03352     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03352         NEXT SENTENCE                                            
A03352     ELSE                                                         
A03352         MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
A03352         DISPLAY '****************************************'       
A03352         DISPLAY '**  ERROR 7150-GET-WQ-DATE           **'        
A03352         DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE           
A03352         DISPLAY '**  PROCESSING TERMINATED             **'       
A03352         DISPLAY '****************************************'       
A03352         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
A03352                                                                  
A03352 7150-EXIT.                                                       
A03352     EXIT.                                                        
                                                                        
A43218 7200-CHECK-IF-PENDING.                                           
A43218                                                                  
A43218     MOVE SPACES TO WS-PEND-SVC-EXISTS                            
A43218                                                                  
A43218     EXEC SQL                                                     
A43218      SELECT XO.SERVICE_NO                                        
A43218            ,'Y'                                                  
A43218        INTO :XO-SERVICE-NO                                       
A43218            ,:WS-PEND-SVC-EXISTS                                  
A43218        FROM CSS_SO_DATA VO                                       
A43218            ,CSS_GASLINE_SO_XRF XX                                
A43218            ,CSS_GAS_SERV_LINE  XO                                
A43218       WHERE VO.SERV_ORDER_NO     = :VO-SERV-ORDER-NO             
A43218         AND XX.SERV_ORDER_NO     = VO.SERV_ORDER_NO              
A43218         AND XX.SERVICE_NO        = XO.SERVICE_NO                 
A43218         AND XO.SERV_LINE_STAT_FL = 'P'                           
A43218                                                      
A43218     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT XO.SERVICE_NO                                                
MFA-TR*           ,'Y'                                                          
MFA-TR*       INTO :XO-SERVICE-NO                                               
MFA-TR*           ,:WS-PEND-SVC-EXISTS                                          
MFA-TR*       FROM CSS_SO_DATA VO                                               
MFA-TR*           ,CSS_GASLINE_SO_XRF XX                                        
MFA-TR*           ,CSS_GAS_SERV_LINE  XO                                        
MFA-TR*      WHERE VO.SERV_ORDER_NO     = :VO-SERV-ORDER-NO                     
MFA-TR*        AND XX.SERV_ORDER_NO     = VO.SERV_ORDER_NO                      
MFA-TR*        AND XX.SERVICE_NO        = XO.SERVICE_NO                         
MFA-TR*        AND XO.SERV_LINE_STAT_FL = 'P'                                   
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN NOT-FOUND                                           
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 7200-CHECK-IF-PENDING       **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 7200-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7210-OPEN-PREM-SVC-CURSOR.                                       
A43218                                                                  
A43218     EXEC SQL                                                     
A43218         OPEN PREM_SVC_CURSOR                                     
A43218     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 7210-OPEN-PREM-SVC-CURSOR   **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 7210-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7220-FETCH-PREM-SVC-CURSOR.                                      
A43218                                                                  
A43218     EXEC SQL                                                     
A43218        FETCH PREM_SVC_CURSOR                                     
A43218         INTO :Y0-PREMISE-NO                                      
A43218     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN NOT-FOUND                                           
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 7220-FETCH-PREM-SVC-CURSOR  **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218                                                                  
A43218 7220-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7230-FORMAT-CSR04078-VARS.                                       
A43218     MOVE 'D'             TO  WG-ACTION-CD                        
A43218     MOVE Y0-PREMISE-NO   TO  WG-PREMISE-NO                       
A43218     MOVE XO-SERVICE-NO   TO  WG-SERVICE-NO                       
A43218                                                                  
A43218     MOVE SPACES          TO  WG-STRUCT-TYP-CD                    
A43218     MOVE SPACES          TO  WG-STRUCT-CD                        
A43218     MOVE SPACES          TO  WG-SALES-REP-ID                     
A43218     MOVE 0               TO  WG-BLDR-ADDR-ID                     
A43218     MOVE 0               TO  WG-CUSTOMER-NO                      
A43218     MOVE 0               TO  WG-BLDR-CUST-NO                     
A43218     MOVE 0.0             TO  WG-FAC-AMT                          
A43218     MOVE SPACES          TO  WG-OWNER-CD                         
A43218     MOVE SPACES          TO  WG-X-STREET1                        
A43218     MOVE SPACES          TO  WG-X-STREET2                        
A43218     MOVE SPACES          TO  WG-PFNO                             
A43218     MOVE SPACES          TO  WG-CITY-GATE-ID                     
A43218     MOVE 'SYSTEM'        TO  WG-USERID                           
A43218     MOVE '016'           TO  WG-PANEL-NO                         
I01400     MOVE SPACES          TO  WG-FUEL-CONV-TYPE-CD                
I01400     MOVE SPACES          TO  WG-FUEL-CONV-COMMENT.               
A43218                                                                  
A43218 7230-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7235-CALL-CSR04078-SPDB.                                         
A43218                                                                  
A43218*    EXEC SQL                                                     
A43218*       CALL CSR04078 ( :WG-ACTION-CD                             
A43218*                      ,:WG-PREMISE-NO                            
A43218*                      ,:WG-SERVICE-NO                            
A43218*                      ,:WG-STRUCT-TYP-CD                         
A43218*                      ,:WG-STRUCT-CD                             
A43218*                      ,:WG-SALES-REP-ID                          
A43218*                      ,:WG-BLDR-ADDR-ID                          
A43218*                      ,:WG-CUSTOMER-NO                           
A43218*                      ,:WG-BLDR-CUST-NO                          
A43218*                      ,:WG-FAC-AMT                               
A43218*                      ,:WG-OWNER-CD                              
A43218*                      ,:WG-X-STREET1                             
A43218*                      ,:WG-X-STREET2                             
A43218*                      ,:WG-PFNO                                  
A43218*                      ,:WG-CITY-GATE-ID                          
A43218*                      ,:WG-USERID                                
A43218*                      ,:WG-PANEL-NO                              
I01400*                      ,:WG-FUEL-CONV-TYPE-CD                     
I01400*                      ,:WG-FUEL-CONV-COMMENT)                    
A43218*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4078
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4078
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4078 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN +466                                                
A43218             PERFORM 7240-PROCESS-SPDB-OUTPUT THRU 7240-EXIT      
A43218         WHEN -471                                                
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  DBAS RESTART WLM OR CSR04078     **'    
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR CALLING CSR04078           **'    
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  PREMISE = ' WG-PREMISE-NO               
A43218             DISPLAY '**  SERVICE = ' WG-SERVICE-NO               
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 7235-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7240-PROCESS-SPDB-OUTPUT.                                        
A43218                                                                  
A43218*    EXEC SQL                                                     
A43218*       ASSOCIATE LOCATORS                                        
A43218*       (:LOC04078)                                               
A43218*       WITH PROCEDURE CSR04078                                   
A43218*    END-EXEC.                                                    
A43218                                                                  
A43218*    EXEC SQL                                                     
A43218*       ALLOCATE RESULT_SET_CSR_4078 CURSOR FOR RESULT SET        
A43218*       :LOC04078                                                 
A43218*    END-EXEC.                                                    
A43218                                                                  
A43218     EXEC SQL                                                     
A43218        FETCH RESULT_SET_CSR_4078 INTO                            
A43218          :WG-SERVICE-NO,                                         
A43218          :WG-RETURN-CD                                           
A43218     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A43218         NEXT SENTENCE                                            
A43218     ELSE                                                         
A43218         MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
A43218         DISPLAY '****************************************'       
A43218         DISPLAY '**  ERROR FETCHING CSR04078 RESULTS  **'        
A43218         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
A43218         DISPLAY '**  PREMISE = ' WG-PREMISE-NO                   
A43218         DISPLAY '**  SERVICE = ' WG-SERVICE-NO                   
A43218         DISPLAY '**  PROCESSING TERMINATED             **'       
A43218         DISPLAY '****************************************'       
A43218         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
A43218                                                                  
A43218 7240-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7290-CLOSE-PREM-SVC-CURSOR.                                      
A43218                                                                  
A43218     EXEC SQL                                                     
A43218         CLOSE PREM_SVC_CURSOR                                    
A43218     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 7290-CLOSE-PREM-SVC-CURSOR  **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 7290-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 7300-CHECK-IF-PENDING-RETD.                                      
A43218                                                                  
A43218     MOVE SPACES TO WS-PEND-RTD-SVC-EXISTS                        
A43218                                                                  
A43218     EXEC SQL                                                     
A43218      SELECT XO.SERVICE_NO                                        
A43218            ,'Y'                                                  
A43218        INTO :XO-SERVICE-NO                                       
A43218            ,:WS-PEND-RTD-SVC-EXISTS                              
A43218        FROM CSS_SO_DATA SO                                       
A43218            ,CSS_GASLINE_SO_XRF XX                                
A43218            ,CSS_GAS_SERV_LINE  XO                                
A43218       WHERE SO.SERV_ORDER_NO     = :VO-SERV-ORDER-NO             
A43218         AND XX.SERV_ORDER_NO     = SO.SERV_ORDER_NO              
A43218         AND XO.SERVICE_NO        = XX.SERVICE_NO                 
A43218         AND XO.SERV_LINE_STAT_FL = 'T'                           
A43218                                                      
A43218     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT XO.SERVICE_NO                                                
MFA-TR*           ,'Y'                                                          
MFA-TR*       INTO :XO-SERVICE-NO                                               
MFA-TR*           ,:WS-PEND-RTD-SVC-EXISTS                                      
MFA-TR*       FROM CSS_SO_DATA SO                                               
MFA-TR*           ,CSS_GASLINE_SO_XRF XX                                        
MFA-TR*           ,CSS_GAS_SERV_LINE  XO                                        
MFA-TR*      WHERE SO.SERV_ORDER_NO     = :VO-SERV-ORDER-NO                     
MFA-TR*        AND XX.SERV_ORDER_NO     = SO.SERV_ORDER_NO                      
MFA-TR*        AND XO.SERVICE_NO        = XX.SERVICE_NO                         
MFA-TR*        AND XO.SERV_LINE_STAT_FL = 'T'                                   
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN NOT-FOUND                                           
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 7300-CHECK-IF-PENDING-RETD  **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
                                                                        
A43218 7300-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 8100-DELETE-GAS-SO-XRF.                                          
A43218                                                                  
A43218     MOVE VO-SERV-ORDER-NO TO XX-SERV-ORDER-NO.                   
A43218     MOVE XO-SERVICE-NO    TO XX-SERVICE-NO.                      
A43218                                                                  
A43218     EXEC SQL                                                     
A43218         DELETE                                                   
A43218          FROM  CSS_GASLINE_SO_XRF                                
A43218          WHERE SERV_ORDER_NO = :XX-SERV-ORDER-NO                 
A43218          AND   SERVICE_NO    = :XX-SERVICE-NO                    
A43218     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 8100-DELETE-GAS-SO-XRF      **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  ORDER   = ' WS-DISPLAY-SO               
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 8100-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
A43218 8200-UPDATE-RETD-TO-ACTIVE.                                      
A43218                                                                  
A43218     EXEC SQL                                                     
A43218        UPDATE CSS_GAS_SERV_LINE                                  
A43218           SET SERV_LINE_STAT_FL = 'A',                           
A43218               INSTALL_TYPE_CD   = INSTALL_TYPE_ORIG              
A43218         WHERE SERVICE_NO = :XO-SERVICE-NO                        
A43218     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A43218                                                                  
A43218     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A43218     EVALUATE WS-ACTIVE-RETURN-CODE                               
A43218         WHEN SUCCESSFUL-CALL                                     
A43218             CONTINUE                                             
A43218         WHEN NOT-FOUND                                           
A43218             CONTINUE                                             
A43218         WHEN OTHER                                               
A43218             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A43218             DISPLAY '****************************************'   
A43218             DISPLAY '**  ERROR 8200-UPDATE-RETD-TO-ACTIVE  **'   
A43218             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A43218             DISPLAY '**  SERVICE  = ' XO-SERVICE-NO              
A43218             DISPLAY '**  PROCESSING TERMINATED             **'   
A43218             DISPLAY '****************************************'   
A43218             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A43218     END-EVALUATE.                                                
A43218                                                                  
A43218 8200-EXIT.                                                       
A43218     EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO111 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
