       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO110                                          
COB303 DATE-WRITTEN.  FEBRUARY 26, 2007                                 
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSSO110                                           *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      *  THIS PROGRAM WILL BE USED TO POST THE SERVICE ORDER FOR FINAL*         
      *  BILLING. IN THE DNP-FINAL BILL PROCESS, THE ACCOUNT WILL HAVE*         
      *  HAD EITHER THEIR ELECTRIC OR GAS METERS CUT,WHICH LEAVES ONLY*         
      *  1 METER TYPE TO BE CUT AS DEFINED BY A DNP-FB ORDER. IN CASE *         
      *  OF ONLY 1 METER ASSOCIATED WITH A DNP AND THERE IS NO SECOND *         
      *  ONE TO TRIGGER THE FINAL BILL,THE CODE_EDITED_YES_NO FLAG HAS*         
      *  BEEN SET TO 'Y' INDICATING NO FURTHER WORK NEEDED.           *         
      *                                                               *         
      *  THIS PROGRAM WILL PICK THOSE HAVING CODE_EDITED _YES_NO = 'Y'*         
      *  AND PROCESS THEM.                                            *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  02/26/07    MSR      PROCEDURE ORIGINALLY CODED.             *         
A02677*  04/05/11    VV90387  GENERATE WQ & SET REQUIREMENT FOR DNPFB'S         
A02677*                       WITHIN 3 DAYS                           *         
A03661*  03/29/12    MH94819  POPULATE WQ MESSAGES WITH APPROPRIATE   *         
A03661*                       INFORMATION BASED ON RETURN CODE FROM   *         
A03661*                       CSR02025                                *         
A04344*  09/12/12    MH94819  CHANGE NEGATIVE USE WQ CATEGORY TO 542  *         
A04344*                       AND ROUTING CATEGORY TO 5               *         
P00817*  11/13/14    FMB      REMOVE LIGHTING WQ.                     *         
ACT091*  02/29/16    TP7R341  REPLACE CSS_WQ_ITEMS_MF WITH            *         
ACT091*  APPL4860             CSS_WQ_ITEMS BY CALLING SCSCB077        *         
ACT091*                       REMOVE UNUSED COPYBOOKS.                *         
ACT091*  05/23/16    MC95456  INITIALIZE CWS00077-FIELDS TO AVOID     *         
ACT091*                       PROBLEM WITH WS-77-USER-ID-ASGN.        *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO110'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSSO110 STARTS HERE'.            
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO110'.     
       01  WS-PGRMNAME                  PIC X(08).                      
ACT091 01  SCSCB077                     PIC X(08) VALUE 'SCSCB077'.     
      *                                                                         
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  V-RETRIEVE-CTR-IN        PIC S9(04) COMP                 
                                                  VALUE 0001.           
           05  V-RETRIEVE-CTR-OUT       PIC S9(04) COMP                 
                                                  VALUE ZEROS.          
           05  V-METER-ROW1             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW2             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW3             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW4             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW5             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW6             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW7             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW8             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW9             PIC X(50) VALUE SPACES.         
           05  V-METER-ROW10            PIC X(50) VALUE SPACES.         
           05  V-METER-ROW11            PIC X(50) VALUE SPACES.         
           05  V-METER-ROW12            PIC X(50) VALUE SPACES.         
           05  V-METER-ROW13            PIC X(50) VALUE SPACES.         
           05  V-METER-ROW14            PIC X(50) VALUE SPACES.         
           05  V-METER-ROW15            PIC X(50) VALUE SPACES.         
           05  WS-CODE-ACCT-STAT        PIC X(1)  VALUE SPACE.          
           05  WS-CODE-BILL-STATUS      PIC X(1)  VALUE SPACE.          
           05  WS-CODE-UTIL-TYPE        PIC X(1)  VALUE SPACE.          
           05  WS-IC-NO                 PIC S9(4) COMP VALUE 0.         
           05  WS-MTR-REF-NO            PIC S9(4) COMP VALUE 0.         
           05  WS-METER-NO              PIC X(9)  VALUE SPACE.          
           05  WS-CODE-TIME-PERIOD      PIC S9(4) COMP VALUE 0.         
           05  WS-REG-ID-NO             PIC S9(4) COMP VALUE 0.         
           05  WS-LAST-READ-VALUE       PIC S9(12)V999 COMP-3 VALUE 0.  
           05  WS-LAST-REG-READ-DT      PIC X(10) VALUE SPACES.         
           05  WS-LAST-REG-READ-TS      PIC X(26) VALUE SPACES.         
           05  WS-MIN-NO-UNITS          PIC S9(9)V COMP-3 VALUE 0.      
           05  WS-MAX-NO-UNITS          PIC S9(9)V COMP-3 VALUE 0.      
           05  WS-CONSTANT              PIC S9(6)V999  COMP-3 VALUE 0.  
           05  WS-NO-DIALS              PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-RETRIEVES       PIC S9(9) COMP VALUE 0.         
           05  WS-CITY-GATE-ID          PIC X(7)  VALUE SPACE.          
           05  WS-SO-ERROR-MSG-NO       PIC X(05) VALUE SPACES.         
           05  WS-SO-ERROR-MSG-TEXT     PIC X(210) VALUE SPACES.        
           05  WS-SO-OVRD-MSG-IND       PIC X(01) VALUE SPACES.         
           05  WS-SO-FIX-PANEL-NO       PIC X(04) VALUE SPACES.         
           05  WS-SO-PAGE-NO            PIC X(40) VALUE SPACES.         
           05  WS-SO-ERROR-FL           PIC X(01) VALUE SPACES.         
           05  WS-ACTIVE-PARA           PIC X(04) VALUE SPACES.         
           05  WS-PROGRAM-NAME          PIC X(08) VALUE SPACES.         
           05  WS-AR-LOCKOUT-IND        PIC X(01) VALUE SPACES.         
           05  WS-ACCT-XFER-NO          PIC X(13) VALUE SPACES.         
           05  WS-PANEL-NO              PIC X(04) VALUE 'U110'.         
           05  WS-RECORD-CNT            PIC 9(09) VALUE ZEROS.          
           05  WS-NO-RECDS              PIC 9(09) VALUE ZEROS.          
           05  WS-FATAL-ERRORS          PIC 9(09) VALUE ZEROS.          
           05  WS-OVERRIDE-ERR          PIC X(01) VALUE SPACES.         
           05  WS-CATEGORY-ID           PIC S9(04) VALUE ZEROS.         
           05  WS-ROUTING-CATEGORY      PIC X(01) VALUE SPACES.         
           05  WS-WQ-MESSAGE            PIC X(250) VALUE SPACES.        
           05  WS-SECURED-RATE-FL       PIC X(01) VALUE SPACES.         
           05  WS-ACCT-TYPE             PIC X(01) VALUE SPACES.         
           05  WS-CODE-REV-CLASS        PIC X(03) VALUE SPACES.         
           05  WS-ORDER-TYPCD-PRE2      PIC X(02) VALUE SPACES.         
           05  WS-ORDER-TYPCD-PRE3      PIC X(03) VALUE SPACES.         
           05  WS-ORDER-TYPE-CD         PIC X(05) VALUE SPACES.         
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
COB305     05 WS-SERV-ORD-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
A02677     05  WS-NXT3-BUZ-DAYS         PIC X(10) VALUE SPACES.         
A02677     05  WS-CSR01416-RET-CD       PIC S9(09) COMP VALUE 0.        
A02677     05  WS-811                   PIC S9(09) VALUE -811 COMP.     
A02677     05  WS-803                   PIC S9(09) VALUE -803 COMP.     
A02677     05  WS-PLAN-DATE-NULL        PIC S9(04) COMP VALUE +0.       
A02677     05  WS-5-YRS                 PIC S9(09) COMP VALUE +0.       
A02677     05  WS-BIZNES-DAYS           PIC S9(02) COMP VALUE +3.       
A02677     05  WS-CHECK-DATE            PIC X(10).                      
A02677     05  WS-CHECK-TIMESTAMP       PIC X(26).                      
A02677     05  WS-LIGHT-RATE            PIC X(01) VALUE 'N'.            
A02677     05  WS-LGT-WQ-MESSAGE        PIC X(250) VALUE                
A02677     'THIS CUSTOMER IS FINAL BILLING AND REMOVING THE LIGHTS. PLEA        
A02677-    'SE REVIEW/ENTER CONTRACT CHARGES FOR LIGHTING'.                     
A02677     05  WS-REQ-COMPLETE          PIC X(01) VALUE 'N'.            
                                                                        
ACT091************************************************************              
ACT091* WORK-QUEUE RELATED FIELDS.                               *              
ACT091************************************************************              
                                                                        
ACT091 01  WS-WORK-QUEUE-DIRECTION.                                     
ACT091     05  WS-DATE-CREATED          PIC X(10)   VALUE SPACES.       
                                                                        
       01  WS-RETURN-VARIABLES.                                         
           05  WS-MSGNO                PIC S9(9) COMP VALUE +1.         
           05  WS-RETCODE              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-DATALEN              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDIC                PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-NULL-IND             PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-VALUE           PIC S9(4) COMP VALUE -1.         
           05  WS-RETURN-STATUS        PIC S9(4) COMP VALUE +0.         
                                                                        
       01  WS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-DEC REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-PRIOR-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
                                                                        
           05  WS-PREMISE-NO-CHAR      PIC X(10).                       
           05  WS-PREMISE-NO-DEC REDEFINES WS-PREMISE-NO-CHAR           
                                       PIC 9(10).                       
COB305     05 WS-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-SERVICE-ORDER-NO     PIC 9(13) VALUE ZEROS.           
           05  WS-SERV-ORDER-NO-CHAR REDEFINES WS-SERVICE-ORDER-NO      
                                       PIC X(13).                       
                                                                        
       01  WS-SO-ARRAY.                                                 
           05 WS-SERV-ORDER-TAB OCCURS 5000 TIMES                       
              INDEXED BY TAB-IND.                                       
COB305        10 WS-SERV-ORDER-NO-TB        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.        
              10 WS-LOCAL-OFFICE-TB    PIC X(03).                       
COB305        10 WS-PREMISE-NO-TB        PIC S9(10)V USAGE COMP-3 
COB305           VALUE 0.        
COB305        10 WS-ACCOUNT-NO-TB        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.        
              10 WS-ORDER-TYPE-CD-TB   PIC X(05).                       
              10 WS-RESP-AREA-ID-TB    PIC X(03).                       
              10 WS-COMPANY-NO-TB      PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-1                    PIC 9(01) VALUE 1.               
           05  WS-ONE                  PIC X(01) VALUE '1'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-SYSTEM               PIC X(09) VALUE 'SYSTEM'.        
           05  WS-2                    PIC X(01) VALUE '2'.             
           05  WS-3                    PIC X(01) VALUE '3'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-I                    PIC X(01) VALUE 'I'.             
           05  WS-C                    PIC X(01) VALUE 'C'.             
           05  WS-50                   PIC X(02) VALUE '50'.            
           05  WS-26                   PIC X(02) VALUE '26'.            
           05  WS-01                   PIC X(02) VALUE '01'.            
           05  WS-95                   PIC 9(02) VALUE 95.              
           05  WS-4                    PIC 9(01) VALUE 4.               
A04344     05  WS-5                    PIC 9(01) VALUE 5.               
           05  WS-279                  PIC 9(03) VALUE 279.             
A03661     05  WS-542                  PIC 9(03) VALUE 542.             
A03661     05  WS-299                  PIC 9(03) VALUE 299.             
A03661     05  WS-264                  PIC 9(03) VALUE 264.             
           05  WS-280                  PIC 9(03) VALUE 280.             
           05  WS-281                  PIC 9(03) VALUE 281.             
           05  WS-134                  PIC 9(03) VALUE 134.             
           05  WS-REQ-NOT-COMPLETE     PIC X(126) VALUE 'ALL REQUIREMENT        
      -    'S TO COMPLETE THE SERVICE ORDER HAVE NOT BEEN FULFILLED CHEC        
      -    'K THE REQUIREMENTS PANEL FOR ADDITIONAL INFORMATION'.               
      *                                                                         
A03661     05  WS-2025-MSG-3000        PIC X(126) VALUE 'ACTIVE MERCHAND        
A03661-    'ISE CONTRACT EXISTS ON ACCOUNT'.                                    
A03661*                                                                         
A03661     05  WS-2025-MSG-4000        PIC X(126) VALUE 'CANNOT TRANSFER        
A03661-    ' TO AN ACCOUNT ON BUDGET BILLING'.                                  
A03661*                                                                         
A03661     05  WS-2025-MSG-4025        PIC X(126) VALUE 'CANNOT TRANSFER        
A03661-    '.  CIA DEBIT ON FROM ACCOUNT SHOULD BE DISTRIBUTED'.                
A03661*                                                                         
A03661     05  WS-2025-MSG-4050        PIC X(126) VALUE 'CANNOT TRANSFER        
A03661-    ' TO AN ACCOUNT WITH FINAL BILL STATUS'.                             
A03661*                                                                         
A03661     05  WS-2025-MSG-4075        PIC X(126) VALUE 'CANNOT POST A S        
A03661-    'ET ORDER TO AN INACTIVE, FINAL BILLED OR WRITE-OFF ACCOUNT'.        
A03661*                                                                         
A03661     05  WS-2025-MSG-5000-Y      PIC X(126) VALUE 'A/R LOCKOUT IS         
A03661-    'IN EFFECT'.                                                         
A03661*                                                                         
A03661     05  WS-2025-MSG-5000-N      PIC X(126) VALUE 'ERROR - ACCOUNT        
A03661-    ' HAS ALREADY BEEN TRANSFERRED'.                                     
A03661*                                                                         
A03661     05  WS-2025-MSG-5540        PIC X(126) VALUE 'METER BEING SET        
A03661-    ' MUST BE IN INVENTORY'.                                             
A03661     05  WS-2025-MSG-6000        PIC X(126) VALUE 'SERVICE ORDER C        
A03661-    'ANNOT BE POSTED WITH NEGATIVE USAGE DAYS'.                          
A03661*                                                                         
A03661     05  WS-2025-MSG-7000        PIC X(126) VALUE 'METER INSTRUMEN        
A03661-    'T TRANSFORMER MISMATCH ON ELECTRIC METER AMPS AND CONSTANT'.        
A03661*                                                                         
A03661     05  WS-2025-MSG-7500        PIC X(126) VALUE 'CANNOT SET AN A        
A03661-    'DDITIONAL METER ON THE SAME IC WITH A DIFFERENT RATE'.              
A03661*                                                                         
A03661     05  WS-2025-MSG-7600        PIC X(126) VALUE 'CANNOT SET AN A        
A03661-    'DDITIONAL METER ON THE SAME IC WITH A DIFFERENT RATE'.              
A03661*                                                                         
A03661     05  WS-2025-MSG-7700        PIC X(126) VALUE 'RATE INFORMATIO        
A03661-    'N WAS ADDED TO ICP DETAILS AFTER THE SERVICE ORDER WAS INITI        
A03661-    'ATED'.                                                              
A03661*                                                                         
A03661     05  WS-2025-MSG-7800        PIC X(126) VALUE 'RATE INFORMATIO        
A03661-    'N WAS DELETED FROM ICP DETAILS AFTER THE SERVICE ORDER WAS I        
A03661-    'NITIATED'.                                                          
A03661*                                                                         
A03661     05  WS-2025-MSG-8000        PIC X(126) VALUE 'SERVICE ORDER C        
A03661-    'ANNOT BE POSTED WITH PENDING CONTRACT'.                             
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP      PIC S9(9) COMP VALUE 0.         
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  SW-PROCESSING               PIC X(01) VALUE SPACES.      
           05  SW-RESULTS                  PIC X(01) VALUE 'Y'.         
               88 NO-MORE-RESULTS                    VALUE 'N'.         
               88 MORE-RESULTS                       VALUE 'Y'.         
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
                                                                        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-SWITCHES.                                             
               10  WS-BUSINESS-DAY-SW        PIC X(01) VALUE 'N'.       
                   88  NEXT-BUSINESS-DAY-NOT-FOUND     VALUE 'N'.       
                   88  NEXT-BUSINESS-DAY-FOUND         VALUE 'Y'.       
               10  WS-ROW-EXISTS             PIC X(01) VALUE 'N'.       
                   88  ROW-DOES-NOT-EXIST              VALUE 'N'.       
                   88  ROW-EXISTS                      VALUE 'Y'.       
           05  WS-EIBRESP                    PIC S9(8)                  
                                             COMP SYNC VALUE ZERO.      
           05  P-RETURN-PARM                 PIC S9(09) COMP VALUE +0.  
           05  P-RETURN-PARM-NUM             PIC 9(09) VALUE ZEROS.     
           05  P-RETURN-PARM-CHAR REDEFINES P-RETURN-PARM-NUM           
                                             PIC X(09).                 
      *01 LOC74   USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2103 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC109  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC532  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2348 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2025 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC446  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A02677*01 LOC1    USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSSO110 ENDS HERE  '.            
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_RATE_PLAN_DESC >                                    
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SO_DATA >                                           
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SO_UTL_CHG >                                        
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
A02677*-------< INCLUDE CSS_CUST_PLAN                                           
A02677     EXEC SQL                                                             
A02677        INCLUDE TBCSTPLN                                                  
A02677     END-EXEC.                                                            
                                                                        
ACT091*                                                                         
ACT091*---< FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077               
ACT091     EXEC SQL                                                             
ACT091        INCLUDE CWS00077                                                  
ACT091     END-EXEC.                                                            
ACT091                                                                  
           COPY CWS09900.                                                       
           COPY CWS0070B.                                                       
                                                                        
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
                                                                        
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * ERROR HANDLING                                                          
           COPY CWS00010.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      **   DB2 CURSOR DECLARATIONS                                    **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE SERV_ORDER_CURSOR CURSOR FOR                       
               SELECT SERV_ORDER_NO          ,                          
                      LOCAL_OFFICE           ,                          
                      PREMISE_NO             ,                          
                      ACCOUNT_NO             ,                          
                      ORDER_TYPE_CD          ,                          
                      RESP_AREA_ID           ,                          
                      COMPANY_NO                                        
                 FROM CSS_SO_DATA                                       
                WHERE ASSIGNED_DATETIME        <= CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              ) 
                  AND ORDER_STATE_CD            = 'A'                   
                  AND UPPER(CODE_EDITED_YES_NO) = 'Y'                   
                  AND ORDER_TYPE_CD             = 'DNPFB'               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SERV_ORDER_CURSOR CURSOR FOR                               
MFA-TR*        SELECT SERV_ORDER_NO          ,                                  
MFA-TR*               LOCAL_OFFICE           ,                                  
MFA-TR*               PREMISE_NO             ,                                  
MFA-TR*               ACCOUNT_NO             ,                                  
MFA-TR*               ORDER_TYPE_CD          ,                                  
MFA-TR*               RESP_AREA_ID           ,                                  
MFA-TR*               COMPANY_NO                                                
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ASSIGNED_DATETIME        <= :WS-CURRENT-TIMESTAMP         
MFA-TR*           AND ORDER_STATE_CD            = 'A'                           
MFA-TR*           AND UPPER(CODE_EDITED_YES_NO) = 'Y'                           
MFA-TR*           AND ORDER_TYPE_CD             = 'DNPFB'                       
MFA-TR*    END-EXEC.                                                            
                                                                        
A02677******************************************************************        
A02677**   CURSOR FOR DNPFB WITH LIGHTING REQUIREMENTS                **        
A02677******************************************************************        
A02677                                                                  
A02677     EXEC SQL                                                     
A02677       DECLARE LIGHTS_CURSOR CURSOR FOR                           
A02677         SELECT SERV_ORDER_NO          ,                          
A02677                LOCAL_OFFICE           ,                          
A02677                PREMISE_NO             ,                          
A02677                ACCOUNT_NO             ,                          
A02677                ORDER_TYPE_CD          ,                          
A02677                RESP_AREA_ID           ,                          
A02677                COMPANY_NO             ,                          
A02677                REPLACE(REPLACE(CONVERT(CHAR(26), 
           WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME                                
A02677           FROM CSS_SO_DATA                                       
A02677          WHERE CAST(ASSIGNED_DATETIME AS DATE) > 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
A02677            AND CAST(ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-NXT3-BUZ-DAYS
              ) IS NULL OR (PATINDEX('%.%', :WS-NXT3-BUZ-DAYS
              ) <> 0) OR (LEN(:WS-NXT3-BUZ-DAYS) <> 10), CIS.CHAR2DATE(
                                                      :WS-NXT3-BUZ-DAYS
              ), CONVERT(DATE, :WS-NXT3-BUZ-DAYS) )      
A02677            AND ORDER_STATE_CD            IN ('A','B','D','H','R')
A02677            AND UPPER(CODE_EDITED_YES_NO) = 'Y'                   
A02677            AND ORDER_TYPE_CD             = 'DNPFB'               
A02677                                                      
A02677     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE LIGHTS_CURSOR CURSOR FOR                                   
MFA-TR*        SELECT SERV_ORDER_NO          ,                                  
MFA-TR*               LOCAL_OFFICE           ,                                  
MFA-TR*               PREMISE_NO             ,                                  
MFA-TR*               ACCOUNT_NO             ,                                  
MFA-TR*               ORDER_TYPE_CD          ,                                  
MFA-TR*               RESP_AREA_ID           ,                                  
MFA-TR*               COMPANY_NO             ,                                  
MFA-TR*               WANTED_BY_DATETIME                                        
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE DATE(ASSIGNED_DATETIME) > CURRENT DATE                    
MFA-TR*           AND DATE(ASSIGNED_DATETIME) <= :WS-NXT3-BUZ-DAYS              
MFA-TR*           AND ORDER_STATE_CD            IN ('A','B','D','H','R')        
MFA-TR*           AND UPPER(CODE_EDITED_YES_NO) = 'Y'                           
MFA-TR*           AND ORDER_TYPE_CD             = 'DNPFB'                       
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE CSR01416-RS CURSOR
MSQ001          FOR CALL CSR01416                                       
A02677         ( :WS-CURRENT-TIMESTAMP
                  , :WS-BIZNES-DAYS
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_DUMMY_CSR00110_1 CURSOR
MSQ001          FOR CALL CSR00110 ( :WS-SERV-ORDER-NO-CHAR
                  , :V-RETRIEVE-CTR-IN
                  , :V-METER-ROW1 OUTPUT
                  , :V-METER-ROW2 OUTPUT
                  , :V-METER-ROW3 OUTPUT
                  , :V-METER-ROW4 OUTPUT
                  , :V-METER-ROW5 OUTPUT
                  , :V-METER-ROW6 OUTPUT
                  , :V-METER-ROW7 OUTPUT
                  , :V-METER-ROW8 OUTPUT
                  , :V-METER-ROW9 OUTPUT
                  , :V-METER-ROW10 OUTPUT
                  , :V-METER-ROW11 OUTPUT
                  , :V-METER-ROW12 OUTPUT
                  , :V-METER-ROW13 OUTPUT
                  , :V-METER-ROW14 OUTPUT
                  , :V-METER-ROW15 OUTPUT
                  , :V-RETRIEVE-CTR-OUT OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2103 CURSOR
MSQ001          FOR CALL CSR02103 ( :WS-ACCOUNT-NO
                  , :V-RETRIEVE-CTR-OUT
                  , :V-METER-ROW1
                  , :V-METER-ROW2
                  , :V-METER-ROW3
                  , :V-METER-ROW4
                  , :V-METER-ROW5
                  , :V-METER-ROW6
                  , :V-METER-ROW7
                  , :V-METER-ROW8
                  , :V-METER-ROW9
                  , :V-METER-ROW10
                  , :V-METER-ROW11
                  , :V-METER-ROW12
                  , :V-METER-ROW13
                  , :V-METER-ROW14
                  , :V-METER-ROW15
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_74 CURSOR
MSQ001          FOR CALL CSR00074 ( :WS-SERV-ORDER-NO-CHAR
                  , :WS-CODE-ACCT-STAT
                  , :WS-CODE-BILL-STATUS
                  , :WS-CODE-UTIL-TYPE
                  , :WS-IC-NO
                  , :WS-MTR-REF-NO
                  , :WS-METER-NO
                  , :WS-CODE-TIME-PERIOD
                  , :WS-REG-ID-NO
                  , :WS-LAST-READ-VALUE
                  , :WS-LAST-REG-READ-TS
                  , :WS-MIN-NO-UNITS
                  , :WS-MAX-NO-UNITS
                  , :WS-CONSTANT
                  , :WS-NO-DIALS
                  , :WS-CITY-GATE-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_109 CURSOR
MSQ001          FOR CALL CSR00109 ( :WS-SERV-ORDER-NO-CHAR
                  , :WS-NO
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2025 CURSOR
MSQ001          FOR CALL CSR02025 ( :WS-SERV-ORDER-NO-CHAR
                  , 'SYSTEM'
                  , ''
                  , ''
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_532 CURSOR
MSQ001          FOR CALL CSR00532 ( :WS-SERV-ORDER-NO-CHAR
                  , :WS-CODE-UTIL-TYPE
                  , :WS-IC-NO
                  , :WS-MTR-REF-NO
                  , :WS-METER-NO
                  , :WS-REG-ID-NO
                  , :WS-LAST-READ-VALUE
                  , :WS-LAST-REG-READ-TS
                  , :WS-CODE-TIME-PERIOD
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2348 CURSOR
MSQ001          FOR CALL CSR02348 ( :WS-ACCOUNT-NO
                  , ''
                  , :WS-PANEL-NO
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_446 CURSOR
MSQ001          FOR CALL CSR00446 ( :WS-SERV-ORDER-NO-CHAR
                  , 'SYSTEM'
                  , :WS-PANEL-NO
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *     0000-MAINLINE                                              *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           IF TAB-IND = 5000                                            
              DISPLAY '*********  PCSSO110    *******'                  
              DISPLAY 'TABLE EXCEEDED MAX ROWS  *****'                  
              DISPLAY 'PLEASE RESUBMIT THE JOB AGAIN '                  
              DISPLAY '*********  PCSSO110    *******'                  
              DISPLAY '                              '                  
              MOVE 12                         TO RETURN-CODE            
           END-IF.                                                      
           DISPLAY '******* PCSSO110 ENDED   ********'                  
           DISPLAY 'TOTAL RECORDS PROCESSED = ' , WS-RECORD-CNT.        
           DISPLAY '******* PCSSO110 ENDED   ********'                  
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02677******************************************************************        
A02677*                                                                *        
A02677*     1000-PROCESS-LIGHTS                                        *        
A02677*                                                                *        
A02677******************************************************************        
A02677 1000-PROCESS-LIGHTS.                                             
A02677                                                                  
A02677     MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
A02677     PERFORM 1200-GET-CHECK-DATE               THRU 1200-EXIT.    
A02677     MOVE WS-CHECK-DATE                 TO WS-NXT3-BUZ-DAYS.      
A02677     PERFORM 7700-OPEN-LIGHTS                  THRU 7700-EXIT.    
A02677     PERFORM 7800-FETCH-LIGHTS                 THRU 7800-EXIT.    
A02677     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
A02677        PERFORM 7910-CHECK-LIGHT-RATES         THRU 7910-EXIT     
A02677        IF WS-LIGHT-RATE = 'N'                                    
A02677           PERFORM 7910A-CHECK-LIGHT-RATE      THRU 7910A-EXIT    
A02677           IF WS-LIGHT-RATE = 'Y'                                 
A02677              PERFORM 7930-GET-PLAN-DATE       THRU 7930-EXIT     
A02677              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
A02677                 PERFORM 1400-CHECK-5-YRS      THRU 1400-EXIT     
A02677              END-IF                                              
A02677           END-IF                                                 
A02677        END-IF                                                    
A02677        PERFORM 7920-CHECK-REQUIREMENT         THRU 7920-EXIT     
A02677        IF WS-LIGHT-RATE = 'Y' AND WS-REQ-COMPLETE = 'N'          
A02677           PERFORM 8000-INSERT-REQUIREMENT     THRU 8000-EXIT     
P00817           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P00817              PERFORM 1300-LIGHT-WQ            THRU 1300-EXIT     
P00817           END-IF                                                 
A02677        END-IF                                                    
A02677        PERFORM 7800-FETCH-LIGHTS              THRU 7800-EXIT     
A02677     END-PERFORM                                                  
A02677                                                                  
A02677     PERFORM 7900-CLOSE-LIGHTS                 THRU 7900-EXIT.    
A02677                                                                  
A02677 1000-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 1200-GET-CHECK-DATE                                            *        
A02677*        OBTAIN THE DATE THAT IS 3 BUSINESS DAYS AFTER THE       *        
A02677*        CURRENT DATE BY CALLING CSR01416.                       *        
A02677******************************************************************        
A02677 1200-GET-CHECK-DATE.                                             
A02677                                                                  
A02677     MOVE '1200'                     TO WS-ACTIVE-PARAGRAPH.      
A02677                                                                  
A02677     PERFORM 1210-CALL-CSR01416      THRU 1210-EXIT.              
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02677        DISPLAY '**   CHECK DATE:  ' WS-CHECK-DATE                
A02677        DISPLAY '***********************************************' 
A02677        CONTINUE                                                  
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 1200-EXIT.                                                       
A02677     EXIT.                                                        
A02677                                                                  
A02677******************************************************************        
A02677* 1210-CALL-CSR01416                                             *        
A02677*                                                                *        
A02677*                                                                *        
A02677******************************************************************        
A02677 1210-CALL-CSR01416.                                              
A02677                                                                  
A02677     MOVE '1210'                     TO WS-ACTIVE-PARAGRAPH.      
A02677                                                                  
A02677*    EXEC SQL CALL CSR01416                                       
A02677*        (:WS-CURRENT-TIMESTAMP                                   
A02677*        ,:WS-BIZNES-DAYS)                                        
A02677*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR01416-RS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR01416-RS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR01416-RS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A02677                                                                  
A02677     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
A02677                                        RS-RETURN-CODE.           
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = +466                              
A02677*       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
A02677*          CSR01416                                               
A02677*       END-EXEC                                                  
A02677*       EXEC SQL                                                  
A02677*         ALLOCATE CSR01416-RS CURSOR FOR RESULT SET :LOC1        
A02677*       END-EXEC                                                  
A02677        EXEC SQL                                                  
A02677         FETCH CSR01416-RS                                        
A02677          INTO :WS-CHECK-TIMESTAMP                                
A02677        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677        MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
A02677                                       RS-RETURN-CODE             
A02677                                                                  
A02677        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A02677            MOVE WS-CHECK-TIMESTAMP TO WS-CHECK-DATE              
A02677            CONTINUE                                              
A02677        ELSE                                                      
A02677            MOVE PROGRAM-NAME               TO ABEND-PROGRAM      
A02677            MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH   
A02677            MOVE 'FETCH CSR01416-RS'        TO ABEND-FUNCTION     
A02677            MOVE 'CSR01416'                 TO TABLE-1            
A02677            MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1    
A02677            MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1  
A02677            MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2    
A02677            MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2  
A02677            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
A02677        END-IF                                                    
A02677                                                                  
A02677        EXEC SQL                                                  
A02677            CLOSE CSR01416-RS                                     
A02677        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677        MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE        
A02677                                     RS-RETURN-CODE               
A02677                                                                  
A02677        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A02677            CONTINUE                                              
A02677        ELSE                                                      
A02677            MOVE PROGRAM-NAME               TO ABEND-PROGRAM      
A02677            MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH   
A02677            MOVE 'CLOSE CSR01416-RS'        TO ABEND-FUNCTION     
A02677            MOVE 'CSR01416'                 TO TABLE-1            
A02677            MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1    
A02677            MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1  
A02677            MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2    
A02677            MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2  
A02677            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
A02677        END-IF                                                    
A02677                                                                  
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
A02677        MOVE 'CALL'                     TO ABEND-FUNCTION         
A02677        MOVE 'CSR01416'                 TO TABLE-1                
A02677        MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1        
A02677        MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1      
A02677        MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2        
A02677        MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 1210-EXIT.                                                       
A02677     EXIT.                                                        
A02677                                                                  
A02677******************************************************************        
A02677*                                                                *        
A02677*     1300-LIGHT-WQ                                              *        
A02677*                                                                *        
A02677******************************************************************        
A02677 1300-LIGHT-WQ.                                                   
A02677                                                                  
ACT091     INITIALIZE CWS00077-FIELDS.                                  
ACT091     MOVE 461                       TO WS-77-CATEGORY-ID.         
ACT091     MOVE SPACES                    TO WS-77-RESP-AREA-ID.        
ACT091     MOVE VO-SERV-ORDER-NO          TO WS-77-SERV-ORDER-NO.       
ACT091     MOVE WS-SYSTEM                 TO WS-77-USER-ID-ORIG.        
ACT091     MOVE WS-DATE-CREATED           TO WS-77-DATE-REQUIRED.       
ACT091     MOVE VO-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT091     MOVE ZEROS                     TO WS-77-CUSTOMER-NO.         
ACT091     MOVE VO-PREMISE-NO             TO WS-77-PREMISE-NO.          
ACT091     MOVE VO-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT091     MOVE 1                         TO WS-77-ROUTE-CATEGORY.      
ACT091     MOVE WS-NO                     TO WS-77-PRIORITY.            
ACT091     MOVE WS-LGT-WQ-MESSAGE         TO WS-77-COMMENTS-TEXT.       
ACT091     MOVE LENGTH OF WS-LGT-WQ-MESSAGE                             
ACT091                                    TO WS-77-COMMENTS-LEN.        
ACT091     MOVE SPACES                    TO WS-77-FREE-FORM-TXT.       
ACT091     MOVE ZERO                      TO WS-77-FREE-FORM-LEN.       
ACT091     MOVE PROGRAM-NAME              TO WS-77-CREATED-BY.          
A02677                                                                  
A02677     PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
A02677                                                                  
A02677 1300-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677*                                                                *        
A02677*     1400-CHECK-5-YRS                                           *        
A02677*                                                                *        
A02677******************************************************************        
A02677 1400-CHECK-5-YRS.                                                
A02677                                                                  
A02677     IF WS-PLAN-DATE-NULL = 0                                     
A02677        EXEC SQL                                                  
A02677          SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :VO-WANTED-BY-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :VO-WANTED-BY-DATETIME
              ) <> 0) OR (LEN(:VO-WANTED-BY-DATETIME
              ) <> 10), CIS.CHAR2DATE(:VO-WANTED-BY-DATETIME
              ), CONVERT(DATE, :VO-WANTED-BY-DATETIME) )) -   
A02677                           CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                    :CP-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :CP-DATE-PLAN-START
              ) <> 0) OR (LEN(:CP-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:CP-DATE-PLAN-START
              ), CONVERT(DATE, :CP-DATE-PLAN-START) ))
            INTO
              :WS-5-YRS        
A02677        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SET  :WS-5-YRS = DAYS(DATE(:VO-WANTED-BY-DATETIME)) -           
MFA-TR*                          DAYS(DATE(:CP-DATE-PLAN-START))                
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677        IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                      
A02677           MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
A02677           MOVE '1400'                     TO ACTIVE-PARAGRAPH    
A02677           MOVE 'CHECK 5 YRS'              TO ABEND-FUNCTION      
A02677           MOVE 'PLAN START DATE'          TO TABLE-1             
A02677           MOVE 'DAY DIFFERENCE'           TO TABLE-ELEMENT-1     
A02677           MOVE WS-5-YRS                   TO HOSTVAR-ELEMENT-1   
A02677           PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT         
A02677           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
A02677        END-IF                                                    
A02677                                                                  
A02677        IF WS-5-YRS <= 1827                                       
A02677           MOVE 'Y'  TO  WS-LIGHT-RATE                            
A02677        END-IF                                                    
A02677                                                                  
A02677     END-IF.                                                      
A02677                                                                  
A02677 1400-EXIT.                                                       
A02677     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2000-PROCESS-OUTPUT                                        *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
A02677*    PERFORM 1000-PROCESS-LIGHTS        THRU 1000-EXIT.                   
           PERFORM 7100-OPEN-SO-DATA          THRU 7100-EXIT.           
           PERFORM 7200-FETCH-SO-DATA         THRU 7200-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7300-CLOSE-SO-DATA      THRU 7300-EXIT            
              DISPLAY '*** PCSSO110                 ********'           
              DISPLAY '*** NO DATA THIS RUN         ********'           
              DISPLAY '*** PCSSO100                 ********'           
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           SET TAB-IND                        TO WS-1.                  
      *                                                                         
           PERFORM 2010-LOAD-SO-TAB           THRU 2010-EXIT            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                   OR TAB-IND >= 5000.                                  
                                                                        
           SET WS-NO-RECDS                    TO TAB-IND.               
           PERFORM 7300-CLOSE-SO-DATA         THRU 7300-EXIT.           
      *                                                                         
           PERFORM VARYING TAB-IND FROM 1 BY 1                          
                   UNTIL TAB-IND >= WS-NO-RECDS OR                      
                   TAB-IND >= 5000                                      
              MOVE WS-SERV-ORDER-NO-TB(TAB-IND) TO WS-SERVICE-ORDER-NO  
                                                   WS-SERV-ORD-NO       
              MOVE WS-ACCOUNT-NO-TB(TAB-IND)  TO WS-ACCOUNT-NO-DEC      
              MOVE WS-COMPANY-NO-TB(TAB-IND)  TO WS-COMPANY-NO          
              ADD WS-1                        TO WS-RECORD-CNT          
              PERFORM 2100-GET-SO-STATUS      THRU 2100-EXIT            
              IF VO-SERV-ORDER-STATUS < WS-50                           
                 MOVE WS-REQ-NOT-COMPLETE     TO WS-WQ-MESSAGE          
                 PERFORM 2505-SET-WQ-CATID    THRU 2505-EXIT            
                 PERFORM 2500-CREATE-WQ       THRU 2500-EXIT            
              ELSE                                                      
                 PERFORM 2200-GET-METER-ROWS  THRU 2200-EXIT            
                 PERFORM 2300-CALL-109-FOR-EDTCHK                       
                                              THRU 2300-EXIT            
                 IF WS-OVERRIDE-ERR EQUAL WS-YES                        
                    PERFORM 2800-SET-CODE-TEMP-BILL                     
                                              THRU 2800-EXIT            
                    MOVE WS-NO                TO WS-OVERRIDE-ERR        
                 END-IF                                                 
                 IF WS-FATAL-ERRORS EQUAL ZEROS                         
                    PERFORM 2400-CALL-317-POST-DNPSO                    
                                              THRU 2400-EXIT            
                 END-IF                                                 
              END-IF                                                    
              MOVE ZEROS                      TO WS-FATAL-ERRORS        
              PERFORM 9600-COMMIT-WORK        THRU 9600-EXIT            
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *     2010-LOAD-SO-TAB                                           *        
      *                                                                *        
      ******************************************************************        
       2010-LOAD-SO-TAB.                                                
      *                                                                         
           MOVE VO-SERV-ORDER-NO        TO WS-SERV-ORDER-NO-TB(TAB-IND).
           MOVE VO-LOCAL-OFFICE         TO WS-LOCAL-OFFICE-TB(TAB-IND). 
           MOVE VO-PREMISE-NO           TO WS-PREMISE-NO-TB(TAB-IND).   
           MOVE VO-ACCOUNT-NO           TO WS-ACCOUNT-NO-TB(TAB-IND).   
           MOVE VO-ORDER-TYPE-CD        TO WS-ORDER-TYPE-CD-TB(TAB-IND).
           MOVE VO-RESP-AREA-ID         TO WS-RESP-AREA-ID-TB(TAB-IND). 
           MOVE VO-COMPANY-NO           TO WS-COMPANY-NO-TB(TAB-IND).   
           PERFORM 7200-FETCH-SO-DATA   THRU 7200-EXIT.                 
           SET TAB-IND UP BY WS-1.                                      
      *                                                                *        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *     2100-GET-SO-STATUS                                         *        
      *                                                                *        
      ******************************************************************        
       2100-GET-SO-STATUS.                                              
      *                                                                         
           EXEC SQL                                                     
              CALL CSR00056 ( :WS-SERV-ORD-NO
                  , :VO-SERV-ORDER-STATUS OUTPUT
                  )                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*       CALL CSR00056 (:WS-SERV-ORD-NO,                                   
MFA-TR*                      :VO-SERV-ORDER-STATUS)                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00056'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORD-NO             TO HOSTVAR-ELEMENT-1      
              MOVE 'SERV ORDER STATUS'        TO TABLE-ELEMENT-2        
              MOVE VO-SERV-ORDER-STATUS       TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2200-GET-METER-ROWS                                        *        
      *                                                                *        
      ******************************************************************        
       2200-GET-METER-ROWS.                                             
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR00110 (:WS-SERV-ORDER-NO-CHAR,                    
      *                      :V-RETRIEVE-CTR-IN,                        
      *                      :V-METER-ROW1,                             
      *                      :V-METER-ROW2,                             
      *                      :V-METER-ROW3,                             
      *                      :V-METER-ROW4,                             
      *                      :V-METER-ROW5,                             
      *                      :V-METER-ROW6,                             
      *                      :V-METER-ROW7,                             
      *                      :V-METER-ROW8,                             
      *                      :V-METER-ROW9,                             
      *                      :V-METER-ROW10,                            
      *                      :V-METER-ROW11,                            
      *                      :V-METER-ROW12,                            
      *                      :V-METER-ROW13,                            
      *                      :V-METER-ROW14,                            
      *                      :V-METER-ROW15,                            
      *                      :V-RETRIEVE-CTR-OUT)                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_DUMMY_CSR00110_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_DUMMY_CSR00110_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_DUMMY_CSR00110_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR +466           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00110'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
           PERFORM 2205-CALL-103              THRU 2205-EXIT.           
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2205-CALL-103                                                       
      *                                                                *        
      ******************************************************************        
       2205-CALL-103.                                                   
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR02103 (:WS-ACCOUNT-NO,                            
      *                      :V-RETRIEVE-CTR-OUT,                       
      *                      :V-METER-ROW1,                             
      *                      :V-METER-ROW2,                             
      *                      :V-METER-ROW3,                             
      *                      :V-METER-ROW4,                             
      *                      :V-METER-ROW5,                             
      *                      :V-METER-ROW6,                             
      *                      :V-METER-ROW7,                             
      *                      :V-METER-ROW8,                             
      *                      :V-METER-ROW9,                             
      *                      :V-METER-ROW10,                            
      *                      :V-METER-ROW11,                            
      *                      :V-METER-ROW12,                            
      *                      :V-METER-ROW13,                            
      *                      :V-METER-ROW14,                            
      *                      :V-METER-ROW15)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2103
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2103
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2103 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2205'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR02103'                 TO TABLE-1                
              MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2103)                                                
      *       WITH PROCEDURE CSR02103                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2103 CURSOR FOR RESULT SET        
      *       :LOC2103                                                  
      *    END-EXEC.                                                    
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2103 INTO                          
                      :P-RETURN-PARM                                    
                     ,:WS-CODE-ACCT-STAT                                
                     ,:WS-CITY-GATE-ID                                  
                     ,:WS-CODE-BILL-STATUS                              
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-MTR-REF-NO                                    
                     ,:WS-METER-NO                                      
                     ,:WS-CODE-TIME-PERIOD                              
                     ,:WS-REG-ID-NO                                     
                     ,:WS-LAST-READ-VALUE                               
                     ,:WS-LAST-REG-READ-DT                              
                     ,:WS-MIN-NO-UNITS                                  
                     ,:WS-MAX-NO-UNITS                                  
                     ,:WS-CONSTANT                                      
                     ,:WS-NO-DIALS                                      
                     ,:WS-NO-OF-RETRIEVES                               
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND   
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   NEXT SENTENCE                                        
                END-IF                                                  
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '2205'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR02103'                 TO TABLE-1              
                MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1      
                MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
                MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2      
                MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-2    
                PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF                                                     
      *                                                                         
             IF P-RETURN-PARM = ZEROES                                  
                CONTINUE                                                
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '2205'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR02103'                 TO TABLE-1              
                MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1      
                MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
                MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2      
                MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2    
                MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-3      
                MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-3    
                PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF                                                     
      *                                                                         
             EXEC SQL                                                   
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMP2( 
              IIF(TRY_CONVERT(DATE, :WS-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DT
              ), CONVERT(DATE, :WS-LAST-REG-READ-DT) ), CIS.CHAR2TIME( 
           '0.00' ) ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-LAST-REG-READ-TS              
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-LAST-REG-READ-TS =                                      
MFA-TR*             TIMESTAMP(:WS-LAST-REG-READ-DT,'0.00')                      
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '2205'                     TO ACTIVE-PARAGRAPH     
                MOVE 'SET'                      TO ABEND-FUNCTION       
                MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1      
                MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
                MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2      
                MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-2    
                MOVE 'LAST REG READ DT'         TO TABLE-ELEMENT-3      
                MOVE WS-LAST-REG-READ-DT        TO HOSTVAR-ELEMENT-3    
                PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF                                                     
      *                                                                         
             PERFORM 2210-LOAD-MTRVAL           THRU 2210-EXIT          
           END-PERFORM.                                                 
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2210-LOAD-MTRVAL                                           *        
      *                                                                *        
      ******************************************************************        
       2210-LOAD-MTRVAL.                                                
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR00074 (:WS-SERV-ORDER-NO-CHAR,                    
      *                      :WS-CODE-ACCT-STAT,                        
      *                      :WS-CODE-BILL-STATUS,                      
      *                      :WS-CODE-UTIL-TYPE,                        
      *                      :WS-IC-NO,                                 
      *                      :WS-MTR-REF-NO,                            
      *                      :WS-METER-NO,                              
      *                      :WS-CODE-TIME-PERIOD,                      
      *                      :WS-REG-ID-NO,                             
      *                      :WS-LAST-READ-VALUE,                       
      *                      :WS-LAST-REG-READ-TS,                      
      *                      :WS-MIN-NO-UNITS,                          
      *                      :WS-MAX-NO-UNITS,                          
      *                      :WS-CONSTANT,                              
      *                      :WS-NO-DIALS,                              
      *                      :WS-CITY-GATE-ID)                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_74
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_74
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_74 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00074'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC74)                                                  
      *       WITH PROCEDURE CSR00074                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_74 CURSOR FOR RESULT SET          
      *       :LOC74                                                    
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_74 INTO                              
                 :P-RETURN-PARM                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00074'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF P-RETURN-PARM = ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'CODE ACCT STAT = ',  WS-CODE-ACCT-STAT           
              DISPLAY 'CODE BILL STATUS = ',  WS-CODE-BILL-STATUS       
              DISPLAY 'CODE UTIL TYPE = ',  WS-CODE-UTIL-TYPE           
              DISPLAY 'IC NO = ',  WS-IC-NO                             
              DISPLAY 'MTR REF NO = ',  WS-MTR-REF-NO                   
              DISPLAY 'METER NO = ',  WS-METER-NO                       
              DISPLAY 'CODE TIME PERIOD = ',  WS-CODE-TIME-PERIOD       
              DISPLAY 'REG ID NO = ',  WS-REG-ID-NO                     
              DISPLAY 'LAST READ VALUE = ',  WS-LAST-READ-VALUE         
              DISPLAY 'LAST REG READ DT = ',  WS-LAST-REG-READ-TS       
              DISPLAY 'MIN NO UNITS = ',  WS-MIN-NO-UNITS               
              DISPLAY 'MAX NO UNITS = ',  WS-MAX-NO-UNITS               
              DISPLAY 'CONSTANT = ',  WS-CONSTANT                       
              DISPLAY 'NO DIALS = ',  WS-NO-DIALS                       
              DISPLAY 'CITY GATE ID = ',  WS-CITY-GATE-ID               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00074'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2        
              MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WS-COMPANY-NO = WS-26                                     
              PERFORM 2600-UPDATE-LAST-RDDT   THRU 2600-EXIT            
              PERFORM 7400-CHANGE-COMPL-DT    THRU 7400-EXIT            
           END-IF.                                                      
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2300-CALL-109-FOR-EDTCHK                                            
      *                                                                *        
      ******************************************************************        
       2300-CALL-109-FOR-EDTCHK.                                        
      *                                                                         
           MOVE WS-YES                        TO SW-FETCH.              
      *    EXEC SQL                                                     
      *       CALL CSR00109 (:WS-SERV-ORDER-NO-CHAR                     
      *                     ,:WS-NO)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_109
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_109
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_109 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00109'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC109)                                                 
      *       WITH PROCEDURE CSR00109                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_109 CURSOR FOR RESULT SET         
      *       :LOC109                                                   
      *    END-EXEC.                                                    
      *                                                                         
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_109 INTO                           
                      :P-RETURN-PARM                                    
                     ,:WS-SO-ERROR-MSG-NO                               
                     ,:WS-SO-ERROR-MSG-TEXT                             
                     ,:WS-SO-OVRD-MSG-IND                               
                     ,:WS-SO-FIX-PANEL-NO                               
                     ,:WS-SO-PAGE-NO                                    
                     ,:WS-SO-ERROR-FL                                   
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   SET NO-MORE-ROWS             TO TRUE                 
                   GO TO 2300-EXIT                                      
                END-IF                                                  
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '2300'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR00109'                 TO TABLE-1              
                MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1      
                MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1    
                PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF                                                     
      *                                                                         
             IF P-RETURN-PARM = ZEROES                                  
                CONTINUE                                                
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '2300'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR00109'                 TO TABLE-1              
                MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1      
                MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1    
                MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2      
                MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2    
                PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF                                                     
             PERFORM 2700-PROCESS-ERRORS        THRU 2700-EXIT          
           END-PERFORM.                                                 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2400-CALL-317-POST-DNPSO                                            
      *                                                                *        
      ******************************************************************        
       2400-CALL-317-POST-DNPSO.                                        
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR02025 (:WS-SERV-ORDER-NO-CHAR                     
      *                     ,'SYSTEM'                                   
      *                     ,''                                         
      *                     ,'')                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2025
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2025
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2025 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR02025'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2025)                                                
      *       WITH PROCEDURE CSR02025                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2025 CURSOR FOR RESULT SET        
      *       :LOC2025                                                  
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_2025 INTO                           
                    :P-RETURN-PARM                                      
                   ,:WS-ACTIVE-PARA                                     
                   ,:WS-PROGRAM-NAME                                    
                   ,:WS-AR-LOCKOUT-IND                                  
                   ,:WS-ACCT-XFER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02025'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF P-RETURN-PARM < ZEROES                                    
              PERFORM 5000-BUILD-TEMP-ERR-MSG THRU 5000-EXIT            
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02025'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              MOVE 'CSRO2025 RETURN CODE'     TO TABLE-ELEMENT-2        
              MOVE P-RETURN-PARM-CHAR         TO HOSTVAR-ELEMENT-2      
              MOVE ' PROGRAM NAME = '         TO TABLE-ELEMENT-3        
              MOVE WS-PROGRAM-NAME            TO HOSTVAR-ELEMENT-3      
              MOVE ' ACTIVE PARAGRAPH = '     TO TABLE-ELEMENT-4        
              MOVE WS-ACTIVE-PARA             TO HOSTVAR-ELEMENT-4      
              DISPLAY '**** PCSSO110 ERROR  ******'                     
              DISPLAY 'A/R LOCKOUT IND = ', WS-AR-LOCKOUT-IND           
              DISPLAY ' ACCT XFER NO = ', WS-ACCT-XFER-NO               
              DISPLAY '**** PCSSO110 ERROR  ******'                     
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           ELSE                                                         
              IF P-RETURN-PARM > ZEROES                                 
                 PERFORM 5000-BUILD-TEMP-ERR-MSG                        
                                              THRU 5000-EXIT            
                 PERFORM 2505-SET-WQ-CATID    THRU 2505-EXIT            
                 PERFORM 2500-CREATE-WQ       THRU 2500-EXIT            
              ELSE                                                      
                 PERFORM 5100-CANCEL-RECONNECT-ORDER                    
                                              THRU 5100-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2500-CREATE-WQ                                             *        
      *                                                                *        
      ******************************************************************        
       2500-CREATE-WQ.                                                  
                                                                        
ACT091     INITIALIZE CWS00077-FIELDS.                                  
ACT091     MOVE WS-CATEGORY-ID            TO WS-77-CATEGORY-ID.         
ACT091     MOVE WS-RESP-AREA-ID-TB(TAB-IND)                             
ACT091                                    TO WS-77-RESP-AREA-ID.        
ACT091     MOVE WS-SERV-ORDER-NO-CHAR     TO WS-77-SERV-ORDER-NO.       
ACT091     MOVE WS-SYSTEM                 TO WS-77-USER-ID-ORIG.        
ACT091     MOVE WS-DATE-CREATED           TO WS-77-DATE-REQUIRED.       
ACT091     MOVE WS-ACCOUNT-NO-TB(TAB-IND) TO WS-77-ACCOUNT-NO.          
ACT091     MOVE ZEROS                     TO WS-77-CUSTOMER-NO.         
ACT091     MOVE WS-PREMISE-NO-TB(TAB-IND) TO WS-77-PREMISE-NO.          
ACT091     MOVE WS-LOCAL-OFFICE-TB(TAB-IND)                             
ACT091                                    TO WS-77-LOCAL-OFFICE.        
ACT091     MOVE WS-ROUTING-CATEGORY       TO WS-77-ROUTE-CATEGORY.      
ACT091     MOVE WS-NO                     TO WS-77-PRIORITY.            
ACT091     MOVE WS-WQ-MESSAGE             TO WS-77-COMMENTS-TEXT.       
ACT091     MOVE LENGTH OF WS-WQ-MESSAGE   TO WS-77-COMMENTS-LEN.        
ACT091     MOVE SPACES                    TO WS-77-FREE-FORM-TXT.       
ACT091     MOVE ZERO                      TO WS-77-FREE-FORM-LEN.       
ACT091     MOVE PROGRAM-NAME              TO WS-77-CREATED-BY.          
                                                                        
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
           MOVE SPACES                    TO WS-WQ-MESSAGE.             
C35927     PERFORM 7600-RESET-SO          THRU 7600-EXIT.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2505-SET-WQ-CATID                                          *        
      *                                                                *        
      ******************************************************************        
       2505-SET-WQ-CATID.                                               
                                                                        
           PERFORM 7500-GET-RATE-INFO  THRU 7500-EXIT.                  
           PERFORM 7510-GET-SECURED-FL THRU 7510-EXIT.                  
           IF WS-SECURED-RATE-FL EQUAL WS-YES                           
              MOVE WS-I                TO WS-ACCT-TYPE                  
           ELSE                                                         
A03661        IF VE-CODE-REVENUE-CLASS(2:1) EQUAL WS-ONE                
                 MOVE WS-R             TO WS-ACCT-TYPE                  
              ELSE                                                      
                 MOVE WS-C             TO WS-ACCT-TYPE                  
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-1                   TO WS-ROUTING-CATEGORY.          
           MOVE WS-95                  TO WS-CATEGORY-ID.               
           IF WS-ACCT-TYPE EQUAL WS-I                                   
              MOVE WS-4                TO WS-ROUTING-CATEGORY           
              IF WS-COMPANY-NO EQUAL WS-01                              
                 MOVE WS-279           TO WS-CATEGORY-ID                
              ELSE                                                      
                 MOVE WS-280           TO WS-CATEGORY-ID                
              END-IF                                                    
           ELSE                                                         
              IF WS-ACCT-TYPE EQUAL WS-C                                
                 MOVE WS-281           TO WS-CATEGORY-ID                
              END-IF                                                    
           END-IF.                                                      
                                                                        
A03661     EVALUATE P-RETURN-PARM-NUM                                   
A03661        WHEN 6000                                                 
A03661           MOVE WS-542              TO WS-CATEGORY-ID             
A03661           MOVE WS-5                TO WS-ROUTING-CATEGORY        
A03661        WHEN 7500                                                 
A03661           MOVE WS-299              TO WS-CATEGORY-ID             
A03661           MOVE WS-4                TO WS-ROUTING-CATEGORY        
A03661        WHEN 8000                                                 
A03661           MOVE WS-264              TO WS-CATEGORY-ID             
A03661           MOVE WS-4                TO WS-ROUTING-CATEGORY        
A03661     END-EVALUATE.                                                
                                                                        
       2505-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      *                                                                *        
      *     2600-UPDATE-LAST-RDDT                                      *        
      *                                                                *        
      ******************************************************************        
       2600-UPDATE-LAST-RDDT.                                           
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR00532 (:WS-SERV-ORDER-NO-CHAR                     
      *                     ,:WS-CODE-UTIL-TYPE                         
      *                     ,:WS-IC-NO                                  
      *                     ,:WS-MTR-REF-NO                             
      *                     ,:WS-METER-NO                               
      *                     ,:WS-REG-ID-NO                              
      *                     ,:WS-LAST-READ-VALUE                        
      *                     ,:WS-LAST-REG-READ-TS                       
      *                     ,:WS-CODE-TIME-PERIOD)                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_532
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_532
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_532 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00532'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC532)                                                 
      *       WITH PROCEDURE CSR00532                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_532 CURSOR FOR RESULT SET         
      *       :LOC532                                                   
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_532 INTO                             
                 :P-RETURN-PARM                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00532'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF P-RETURN-PARM = ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00532'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2        
              MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      * 2700-PROCESS-ERRORS                                            *        
      *     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     PROCESS ERRORS RETURNED FROM CSR00109                      *        
      ******************************************************************        
       2700-PROCESS-ERRORS.                                             
      *                                                                         
           MOVE WS-ORDER-TYPE-CD-TB(TAB-IND)     TO WS-ORDER-TYPE-CD.   
           MOVE WS-ORDER-TYPE-CD(1:2)            TO WS-ORDER-TYPCD-PRE2.
           MOVE WS-ORDER-TYPE-CD(1:3)            TO WS-ORDER-TYPCD-PRE3.
           IF WS-SO-OVRD-MSG-IND EQUAL WS-NO                            
              PERFORM 2705-PROCESS-FATAL-ERR     THRU 2705-EXIT         
           ELSE                                                         
              IF (WS-SO-ERROR-MSG-NO = 'SO015' OR                       
                 WS-SO-ERROR-MSG-NO = 'SO016' OR                        
                 WS-SO-ERROR-MSG-NO = 'SO017' OR                        
                 WS-SO-ERROR-MSG-NO = 'SO018' OR                        
                 WS-SO-ERROR-MSG-NO = 'SO048' OR                        
                 WS-SO-ERROR-MSG-NO = 'SO049')                          
                 IF (WS-ORDER-TYPCD-PRE2 = 'CC' OR                      
                    WS-ORDER-TYPCD-PRE2 = 'NC' OR                       
                    WS-ORDER-TYPCD-PRE2 = 'OF' OR                       
                    WS-ORDER-TYPCD-PRE3 = 'DNP' OR                      
                    WS-ORDER-TYPE-CD    = 'FM006')                      
                    PERFORM 2710-DETERMINE-HILO  THRU 2710-EXIT         
              END-IF                                                    
           END-IF
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      * 2705-PROCESS-FATAL-ERR                                         *        
      *     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     PROCESS FATAL ERRORS RETURNED FROM CSR00109                *        
      ******************************************************************        
       2705-PROCESS-FATAL-ERR.                                          
      *                                                                         
           MOVE WS-1                         TO WS-FATAL-ERRORS.        
      *                                                                         
           EVALUATE WS-SO-ERROR-MSG-NO                                  
              WHEN 'SO003'                                              
              WHEN 'SO065'                                              
                 STRING WS-SO-ERROR-MSG-NO                              
                        ' '                                             
                 DELIMITED BY SIZE                                      
                        WS-SO-ERROR-MSG-TEXT                            
                 DELIMITED BY '    '                                    
                 INTO WS-WQ-MESSAGE                                     
              WHEN OTHER                                                
                 STRING WS-SO-ERROR-MSG-NO                              
                        ' '                                             
                 DELIMITED BY SIZE                                      
                        WS-SO-ERROR-MSG-TEXT                            
                 DELIMITED BY '    '                                    
                        ' DATA IN ERROR CAN BE CORRECTED ON PANEL# '    
                        WS-SO-FIX-PANEL-NO                              
                 DELIMITED BY SIZE                                      
                 INTO WS-WQ-MESSAGE                                     
           END-EVALUATE.                                                
           PERFORM 2505-SET-WQ-CATID         THRU 2505-EXIT.            
           PERFORM 2500-CREATE-WQ            THRU 2500-EXIT.            
      *                                                                         
       2705-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      * 2710-DETERMINE-HILO                                            *        
      *     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     PROCESS OVERRIDABLE ERRORS RETURNED FROM CSR00109.         *        
      ******************************************************************        
       2710-DETERMINE-HILO.                                             
      *                                                                         
           MOVE WS-YES                       TO WS-OVERRIDE-ERR.        
           MOVE WS-4                         TO WS-ROUTING-CATEGORY.    
           MOVE WS-134                       TO WS-CATEGORY-ID.         
           STRING WS-SO-ERROR-MSG-NO                                    
                  ' '                                                   
                  WS-SO-ERROR-MSG-TEXT                                  
           DELIMITED BY SIZE                                            
             INTO WS-WQ-MESSAGE.                                        
           PERFORM 2500-CREATE-WQ            THRU 2500-EXIT.            
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     2800-SET-CODE-TEMP-BILL                                             
      *                                                                *        
      ******************************************************************        
       2800-SET-CODE-TEMP-BILL.                                         
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR02348 (:WS-ACCOUNT-NO                             
      *                     ,''                                         
      *                     ,:WS-PANEL-NO)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2348
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2348
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2348 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR02348'                 TO TABLE-1                
              MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2348)                                                
      *       WITH PROCEDURE CSR02348                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2348 CURSOR FOR RESULT SET        
      *       :LOC2348                                                  
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2348 INTO                            
                    :P-RETURN-PARM                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02348'                 TO TABLE-1                
              MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF P-RETURN-PARM = ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02348'                 TO TABLE-1                
              MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2        
              MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2      
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-3        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-3      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      * 5000-BUILD-TEMP-ERR-MSG                                        *        
      *                                                                *        
      *                                                                *        
      *     BUILDS TEMP ERROR MESSAGE WHEN CSR02025 RETURNS ERR CODE   *        
      ******************************************************************        
       5000-BUILD-TEMP-ERR-MSG.                                         
      *                                                                         
           MOVE P-RETURN-PARM                 TO P-RETURN-PARM-NUM.     
A03661     EVALUATE P-RETURN-PARM-NUM                                   
A03661       WHEN 3000                                                  
A03661         MOVE WS-2025-MSG-3000 TO WS-WQ-MESSAGE                   
A03661       WHEN 4000                                                  
A03661         MOVE WS-2025-MSG-4000 TO WS-WQ-MESSAGE                   
A03661       WHEN 4025                                                  
A03661         MOVE WS-2025-MSG-4025 TO WS-WQ-MESSAGE                   
A03661       WHEN 4050                                                  
A03661         MOVE WS-2025-MSG-4050 TO WS-WQ-MESSAGE                   
A03661       WHEN 4075                                                  
A03661         MOVE WS-2025-MSG-4075 TO WS-WQ-MESSAGE                   
A03661       WHEN 5000                                                  
A03661         IF (WS-AR-LOCKOUT-IND = 'Y')                             
A03661            MOVE WS-2025-MSG-5000-Y TO WS-WQ-MESSAGE              
A03661         ELSE                                                     
A03661            MOVE WS-2025-MSG-5000-N TO WS-WQ-MESSAGE              
A03661         END-IF                                                   
A03661       WHEN 5540                                                  
A03661         MOVE WS-2025-MSG-5540 TO WS-WQ-MESSAGE                   
A03661       WHEN 6000                                                  
A03661         MOVE WS-2025-MSG-6000 TO WS-WQ-MESSAGE                   
A03661       WHEN 7000                                                  
A03661         MOVE WS-2025-MSG-7000 TO WS-WQ-MESSAGE                   
A03661       WHEN 7500                                                  
A03661         MOVE WS-2025-MSG-7500 TO WS-WQ-MESSAGE                   
A03661       WHEN 7600                                                  
A03661         MOVE WS-2025-MSG-7600 TO WS-WQ-MESSAGE                   
A03661       WHEN 7700                                                  
A03661         MOVE WS-2025-MSG-7700 TO WS-WQ-MESSAGE                   
A03661       WHEN 7800                                                  
A03661         MOVE WS-2025-MSG-7800 TO WS-WQ-MESSAGE                   
A03661       WHEN 8000                                                  
A03661         MOVE WS-2025-MSG-8000 TO WS-WQ-MESSAGE                   
A03661     END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      *                                                                *        
      *     5100-CANCEL-RECONNECT-ORDER                                *        
      *                                                                *        
      ******************************************************************        
       5100-CANCEL-RECONNECT-ORDER.                                     
      *                                                                         
      *    EXEC SQL                                                     
      *       CALL CSR00446 (:WS-SERV-ORDER-NO-CHAR                     
      *                     ,'SYSTEM'                                   
      *                     ,:WS-PANEL-NO)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_446
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_446
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_446 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00446'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC446)                                                 
      *       WITH PROCEDURE CSR00446                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_446 CURSOR FOR RESULT SET         
      *       :LOC446                                                   
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_446 INTO                             
                 :P-RETURN-PARM                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00446'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           IF P-RETURN-PARM = ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00446'                 TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SERV-ORDER-NO-CHAR      TO HOSTVAR-ELEMENT-1      
              MOVE 'P RETURN PARM'            TO TABLE-ELEMENT-2        
              MOVE P-RETURN-PARM              TO HOSTVAR-ELEMENT-2      
              PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                             *           
      ******************************************************************        
      * 7000-GET-CURRENT-TIMESTAMP                                     *        
      *     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     GET CURRENT DATE                                           *        
      ******************************************************************        
       7000-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           MOVE '7000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-DATE-CREATED                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-DATE-CREATED      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-SO-DATA                                              *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7100-OPEN-SO-DATA.                                               
                                                                        
           EXEC SQL                                                     
                 OPEN SERV_ORDER_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN SO-CURSOR'           TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-FETCH-SO-DATA                                             *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7200-FETCH-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
              FETCH SERV_ORDER_CURSOR                                   
               INTO :VO-SERV-ORDER-NO          ,                        
                    :VO-LOCAL-OFFICE           ,                        
                    :VO-PREMISE-NO             ,                        
                    :VO-ACCOUNT-NO             ,                        
                    :VO-ORDER-TYPE-CD          ,                        
                    :VO-RESP-AREA-ID           ,                        
                    :VO-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH SO-CURSOR'          TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-CLOSE-SO-DATA                                             *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7300-CLOSE-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE SERV_ORDER_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE SO-CURSOR'          TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
              MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   7400-CHANGE-COMPL-DT                                        *         
      *   UPDATE COMPLETION DATE IN CSS_SO_DATA TABLE FOR COMPANY 26  *         
      *                                                               *         
      *****************************************************************         
       7400-CHANGE-COMPL-DT.                                            
      *                                                                         
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET COMPLETED_DATETIME = CIS.CHAR2TIMESTAMP(
                                                   :WS-LAST-REG-READ-TS
              )          
               WHERE SERV_ORDER_NO = :WS-SERV-ORD-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*          SET COMPLETED_DATETIME = :WS-LAST-REG-READ-TS                  
MFA-TR*        WHERE SERV_ORDER_NO = :WS-SERV-ORD-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV ORDER NO'       TO TABLE-ELEMENT-1             
              MOVE WS-SERV-ORD-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPLETED DATETIME'  TO TABLE-ELEMENT-2             
              MOVE WS-LAST-REG-READ-TS   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   7500-GET-RATE-INFO                                          *         
      *   SELECTS THE RATE INFORMATION FROM CSS_SO_UTL_CHG TABLE      *         
      *                                                               *         
      *****************************************************************         
       7500-GET-RATE-INFO.                                              
      *                                                                         
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) RATE_PLAN_NO,
              CODE_REVENUE_CLASS,
              CODE_UTIL_TYPE                                     
                INTO :VE-RATE-PLAN-NO                                   
                    ,:VE-CODE-REVENUE-CLASS                             
                    ,:VE-CODE-UTIL-TYPE                                 
                FROM CSS_SO_UTL_CHG WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO = :WS-SERV-ORD-NO                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO                                               
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*         INTO :VE-RATE-PLAN-NO                                           
MFA-TR*             ,:VE-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:VE-CODE-UTIL-TYPE                                         
MFA-TR*         FROM CSS_SO_UTL_CHG                                             
MFA-TR*        WHERE SERV_ORDER_NO = :WS-SERV-ORD-NO                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_UTL_CHG'      TO TABLE-1                     
              MOVE 'SERV ORDER NO'       TO TABLE-ELEMENT-1             
              MOVE WS-SERV-ORD-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   7510-GET-SECURED-FL                                         *         
      *   SELECTS SECURED RATE FL INFO                                *         
      *                                                               *         
      *****************************************************************         
       7510-GET-SECURED-FL.                                             
      *                                                                         
           MOVE '7510'                   TO WS-ACTIVE-PARAGRAPH.        
           MOVE WS-COMPANY-NO            TO RD-COMPANY-NO.              
      *                                                                         
           EXEC SQL                                                     
              SELECT SECURED_RATE_FL                                    
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC                                 
               WHERE RATE_PLAN_NO   = :VE-RATE-PLAN-NO                  
                 AND CODE_UTIL_TYPE = :VE-CODE-UTIL-TYPE                
                 AND COMPANY_NO     = :RD-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7510'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-1                     
              MOVE 'RATE PLAN NO'        TO TABLE-ELEMENT-1             
              MOVE VE-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE UTIL TYPE'      TO TABLE-ELEMENT-2             
              MOVE VE-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY NO'          TO TABLE-ELEMENT-3             
              MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
C35927*                                                                         
C35927*****************************************************************         
C35927*   7600-RESET-SO                                               *         
C35927*  PROCEDURE WILL SET THE CODE_EDITIED_YES_NO FIELD ON SO_DATA  *         
C35927*  TO 'E'IF ORDER FAILS TO POST. THIS SHOULD PREVENT DUPLICATE  *         
C35927*  WQ'S FROM BEING SENT UNTIL THE ORDER IS POSTED.              *         
C35927*                                                               *         
C35927*****************************************************************         
C35927 7600-RESET-SO.                                                   
C35927*                                                                         
C35927     MOVE '7600'                   TO WS-ACTIVE-PARAGRAPH.        
C35927*                                                                         
C35927     EXEC SQL                                                     
C35927        UPDATE CSS_SO_DATA                                        
C35927           SET CODE_EDITED_YES_NO = 'E'                           
C35927         WHERE SERV_ORDER_NO  = :WS-SERV-ORD-NO                   
C35927     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35927*                                                                         
C35927     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C35927                                           RS-RETURN-CODE.        
C35927                                                                  
C35927     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35927        NEXT SENTENCE                                             
C35927     ELSE                                                         
C35927        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C35927        MOVE '7610'                TO ACTIVE-PARAGRAPH            
C35927        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C35927                                      ABEND-TABLES                
C35927        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C35927        MOVE 'CSS_SO_DATA'         TO TABLE-1                     
C35927        MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
C35927        MOVE WS-SERV-ORD-NO        TO HOSTVAR-ELEMENT-1           
C35927        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
C35927     END-IF.                                                      
C35927*                                                                         
C35927 7600-EXIT.                                                       
C35927     EXIT.                                                        
A02677                                                                  
A02677******************************************************************        
A02677* 7700-OPEN-LIGHTS                                               *        
A02677* CURSOR FOR LIGHT RATES                                         *        
A02677******************************************************************        
A02677 7700-OPEN-LIGHTS.                                                
A02677                                                                  
A02677     EXEC SQL                                                     
A02677           OPEN LIGHTS_CURSOR                                     
A02677     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7700'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'OPEN LIGHTS_CURSOR'       TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_DATA'              TO TABLE-1                
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7700-EXIT.                                                       
A02677     EXIT.                                                        
A02677                                                                  
A02677                                                                  
A02677******************************************************************        
A02677* 7800-FETCH-LIGHTS                                              *        
A02677* CURSOR FOR LIGHT RATES                                         *        
A02677******************************************************************        
A02677 7800-FETCH-LIGHTS.                                               
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        FETCH LIGHTS_CURSOR                                       
A02677         INTO :VO-SERV-ORDER-NO          ,                        
A02677              :VO-LOCAL-OFFICE           ,                        
A02677              :VO-PREMISE-NO             ,                        
A02677              :VO-ACCOUNT-NO             ,                        
A02677              :VO-ORDER-TYPE-CD          ,                        
A02677              :VO-RESP-AREA-ID           ,                        
A02677              :VO-COMPANY-NO             ,                        
A02677              :VO-WANTED-BY-DATETIME                              
A02677     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7800'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'FETCH LIGHTS_CURSOR'      TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_DATA'              TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7800-EXIT.                                                       
A02677     EXIT.                                                        
A02677                                                                  
A02677                                                                  
A02677******************************************************************        
A02677* 7900-CLOSE-LIGHTS                                              *        
A02677* CURSOR FOR LIGHT RATES                                         *        
A02677******************************************************************        
A02677 7900-CLOSE-LIGHTS.                                               
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        CLOSE LIGHTS_CURSOR                                       
A02677     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7900'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'CLOSE LIGHTS_CURSOR'      TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_DATA'              TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7900-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 7910-CHECK-LIGHT-RATES.                                        *        
A02677* CHECK IF THERE ARE ANY LIGHT RATES                             *        
A02677******************************************************************        
A02677 7910-CHECK-LIGHT-RATES.                                          
A02677                                                                  
A02677     MOVE 'N'                          TO WS-LIGHT-RATE.          
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        SELECT 'Y',                                               
A02677               RATE_PLAN_NO,                                      
A02677               U.CODE_UTIL_TYPE,                                  
A02677               U.IC_NO                                            
A02677          INTO :WS-LIGHT-RATE,                                    
A02677               :VE-RATE-PLAN-NO,                                  
A02677               :VE-CODE-UTIL-TYPE,                                
A02677               :VE-IC-NO                                          
A02677          FROM CSS_SO_UTL_CHG U,                                  
A02677               CSS_CUST_PLAN C                                    
A02677         WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO               
A02677           AND C.ACCOUNT_NO     = :VO-ACCOUNT-NO                  
A02677           AND U.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE                
A02677           AND U.IC_NO          = C.IC_NO                         
A02677           AND U.RATE_PLAN_NO   IN ('017','018',                  
A02677                                    '025',                        
A02677                                    '062','067')                  
A02677           AND CODE_PLAN_STATUS <> 'R'                            
A02677                                                      
A02677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              U.CODE_UTIL_TYPE,                                          
MFA-TR*              U.IC_NO                                                    
MFA-TR*         INTO :WS-LIGHT-RATE,                                            
MFA-TR*              :VE-RATE-PLAN-NO,                                          
MFA-TR*              :VE-CODE-UTIL-TYPE,                                        
MFA-TR*              :VE-IC-NO                                                  
MFA-TR*         FROM CSS_SO_UTL_CHG U,                                          
MFA-TR*              CSS_CUST_PLAN C                                            
MFA-TR*        WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO                       
MFA-TR*          AND C.ACCOUNT_NO     = :VO-ACCOUNT-NO                          
MFA-TR*          AND U.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE                        
MFA-TR*          AND U.IC_NO          = C.IC_NO                                 
MFA-TR*          AND U.RATE_PLAN_NO   IN ('017','018',                          
MFA-TR*                                   '025',                                
MFA-TR*                                   '062','067')                          
MFA-TR*          AND CODE_PLAN_STATUS <> 'R'                                    
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
A02677        WS-811                                                    
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7910'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'CHECK LIGHT RATE'         TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_UTL_CHG'           TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7910-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 7910A-CHECK-LIGHT-RATE.                                        *        
A02677* CHECK IF THERE ARE ANY LIGHT RATE '026'                        *        
A02677******************************************************************        
A02677 7910A-CHECK-LIGHT-RATE.                                          
A02677                                                                  
A02677     MOVE 'N'                          TO WS-LIGHT-RATE.          
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        SELECT 'Y',                                               
A02677               RATE_PLAN_NO,                                      
A02677               U.CODE_UTIL_TYPE,                                  
A02677               U.IC_NO                                            
A02677          INTO :WS-LIGHT-RATE,                                    
A02677               :VE-RATE-PLAN-NO,                                  
A02677               :VE-CODE-UTIL-TYPE,                                
A02677               :VE-IC-NO                                          
A02677          FROM CSS_SO_UTL_CHG U,                                  
A02677               CSS_CUST_PLAN C                                    
A02677         WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO               
A02677           AND C.ACCOUNT_NO     = :VO-ACCOUNT-NO                  
A02677           AND U.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE                
A02677           AND U.IC_NO          = C.IC_NO                         
A02677           AND U.RATE_PLAN_NO   = '026'                           
A02677           AND CODE_PLAN_STATUS <> 'R'                            
A02677                                                      
A02677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              U.CODE_UTIL_TYPE,                                          
MFA-TR*              U.IC_NO                                                    
MFA-TR*         INTO :WS-LIGHT-RATE,                                            
MFA-TR*              :VE-RATE-PLAN-NO,                                          
MFA-TR*              :VE-CODE-UTIL-TYPE,                                        
MFA-TR*              :VE-IC-NO                                                  
MFA-TR*         FROM CSS_SO_UTL_CHG U,                                          
MFA-TR*              CSS_CUST_PLAN C                                            
MFA-TR*        WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO                       
MFA-TR*          AND C.ACCOUNT_NO     = :VO-ACCOUNT-NO                          
MFA-TR*          AND U.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE                        
MFA-TR*          AND U.IC_NO          = C.IC_NO                                 
MFA-TR*          AND U.RATE_PLAN_NO   = '026'                                   
MFA-TR*          AND CODE_PLAN_STATUS <> 'R'                                    
MFA-TR*        QUERYNO 7911                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
A02677        WS-811                                                    
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7910A'                    TO ACTIVE-PARAGRAPH       
A02677        MOVE 'CHECK LIGHT RATE'         TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_UTL_CHG'           TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7910A-EXIT.                                                      
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 7920-CHECK-REQUIREMENT.                                        *        
A02677* CHECK IF REQUIREMENT ALREADY EXISTS THAT IS COMPLETED          *        
A02677******************************************************************        
A02677 7920-CHECK-REQUIREMENT.                                          
A02677                                                                  
A02677     MOVE 'N'                          TO WS-REQ-COMPLETE.        
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        SELECT 'Y'                                                
A02677          INTO :WS-REQ-COMPLETE                                   
A02677          FROM CSS_SO_REQUIREMENT                                 
A02677         WHERE SERV_ORDER_NO     = :VO-SERV-ORDER-NO              
A02677           AND REQUIREMENT_CD    = '2'                            
A02677           AND RESOURCE_CD       = '0'                            
A02677           AND SERV_ORDER_STATUS = '40'                           
A02677                                                      
A02677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REQ-COMPLETE                                           
MFA-TR*         FROM CSS_SO_REQUIREMENT                                         
MFA-TR*        WHERE SERV_ORDER_NO     = :VO-SERV-ORDER-NO                      
MFA-TR*          AND REQUIREMENT_CD    = '2'                                    
MFA-TR*          AND RESOURCE_CD       = '0'                                    
MFA-TR*          AND SERV_ORDER_STATUS = '40'                                   
MFA-TR*        QUERYNO 7920                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
A02677        WS-811                                                    
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7920'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'CHECK REQUIREMNT'         TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_REQUIREMENT'       TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7920-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 7930-GET-PLAN-DATE                                             *        
A02677* CHECK THE PLAN START DATE                                      *        
A02677******************************************************************        
A02677 7930-GET-PLAN-DATE.                                              
A02677                                                                  
A02677     MOVE 'N'        TO  WS-LIGHT-RATE.                           
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        SELECT DATE_PLAN_START,                                   
A02677               CODE_PLAN_STATUS                                   
A02677          INTO :CP-DATE-PLAN-START :WS-PLAN-DATE-NULL,            
A02677               :CP-CODE-PLAN-STATUS                               
A02677          FROM CSS_CUST_PLAN                                      
A02677         WHERE ACCOUNT_NO        = :VO-ACCOUNT-NO                 
A02677           AND CODE_UTIL_TYPE    = :VE-CODE-UTIL-TYPE             
A02677           AND IC_NO             = :VE-IC-NO                      
A02677           AND CODE_PLAN_STATUS  <> 'R'                           
A02677                                                      
A02677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_PLAN_START,                                           
MFA-TR*              CODE_PLAN_STATUS                                           
MFA-TR*         INTO :CP-DATE-PLAN-START :WS-PLAN-DATE-NULL,                    
MFA-TR*              :CP-CODE-PLAN-STATUS                                       
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*        WHERE ACCOUNT_NO        = :VO-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :VE-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :VE-IC-NO                              
MFA-TR*          AND CODE_PLAN_STATUS  <> 'R'                                   
MFA-TR*        QUERYNO 7930                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677       IF WS-ACTIVE-RETURN-CODE = WS-811                          
A02677          PERFORM 7930A-GET-PLAN-DTLS     THRU 7930A-EXIT         
A02677       ELSE                                                       
A02677          MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
A02677          MOVE '7930'                     TO ACTIVE-PARAGRAPH     
A02677          MOVE 'GET PLAN DATE'            TO ABEND-FUNCTION       
A02677          MOVE 'CSS_CUST_PLAN'            TO TABLE-1              
A02677          MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1      
A02677          MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1    
A02677          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
A02677       END-IF                                                     
A02677     END-IF.                                                      
A02677                                                                  
A02677 7930-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 7930A-GET-PLAN-DTLS.                                           *        
A02677* CHECK THE PLAN START DATE                                      *        
A02677******************************************************************        
A02677 7930A-GET-PLAN-DTLS.                                             
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        SELECT MAX(DATE_PLAN_START)                               
A02677          INTO :CP-DATE-PLAN-START :WS-PLAN-DATE-NULL             
A02677          FROM CSS_CUST_PLAN                                      
A02677         WHERE ACCOUNT_NO        = :VO-ACCOUNT-NO                 
A02677           AND CODE_UTIL_TYPE    = :VE-CODE-UTIL-TYPE             
A02677           AND IC_NO             = :VE-IC-NO                      
A02677           AND CODE_PLAN_STATUS  <> 'R'                           
A02677     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '7930A'                    TO ACTIVE-PARAGRAPH       
A02677        MOVE 'GET PLAN DATE'            TO ABEND-FUNCTION         
A02677        MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 7930A-EXIT.                                                      
A02677     EXIT.                                                        
A02677*                                                                         
A02677******************************************************************        
A02677* 8000-INSERT-REQUIREMENT                                        *        
A02677*                                                                *        
A02677*                                                                *        
A02677*                                                                *        
A02677******************************************************************        
A02677 8000-INSERT-REQUIREMENT.                                         
A02677                                                                  
A02677     EXEC SQL                                                     
A02677        INSERT INTO CSS_SO_REQUIREMENT                            
A02677               (SERV_ORDER_NO,                                    
A02677                REQUIREMENT_CD,                                   
A02677                RESOURCE_CD,                                      
A02677                REQMNT_STAGE_CD,                                  
A02677                SERV_ORDER_STATUS)                                
A02677        VALUES (:VO-SERV-ORDER-NO,                                
A02677                '2',                                              
A02677                '0',                                              
A02677                'R',                                              
A02677                '40')                                             
A02677     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02677                                                                  
A02677     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02677                                           RS-RETURN-CODE.        
A02677                                                                  
A02677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-803         
A02677        NEXT SENTENCE                                             
A02677     ELSE                                                         
A02677        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02677        MOVE '8000'                     TO ACTIVE-PARAGRAPH       
A02677        MOVE 'INSERT REQUIREMENT'       TO ABEND-FUNCTION         
A02677        MOVE 'CSS_SO_REQUIREMENT'       TO TABLE-1                
A02677        MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-1        
A02677        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
A02677        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A02677     END-IF.                                                      
A02677                                                                  
A02677 8000-EXIT.                                                       
A02677     EXIT.                                                        
A02677*                                                                         
ACT091*****************************************************************         
ACT091* 8895-INSERT-WORK-QUEUE                                                  
ACT091*****************************************************************         
ACT091 8895-INSERT-WORK-QUEUE.                                          
ACT091                                                                  
ACT091     MOVE '8895'                      TO WS-ACTIVE-PARAGRAPH.     
ACT091                                                                  
ACT091     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT091                            ABEND-FILE,                           
ACT091                            RS-RETURN-CODE.                       
ACT091                                                                  
ACT091     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
ACT091                                                                  
ACT091     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT091        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
ACT091        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT091        DISPLAY 'CALL SCSCB077         '                          
ACT091        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT091        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT091        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT091        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT091        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT091     END-IF.                                                      
ACT091                                                                  
ACT091 8895-EXIT.  EXIT.                                                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9600-COMMIT-WORK                                               *        
      *                                                                *        
      ******************************************************************        
       9600-COMMIT-WORK.                                                
                                                                        
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       9600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
      *                                                                         
       9998-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE.          
                                                                        
       9998-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           DISPLAY '*************************************'.             
           DISPLAY '**    PCSSO110 PROCESSING ERROR    **'.             
           DISPLAY '*************************************'.             
                                                                        
           IF WS-DB2-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' WS-DB2-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF WS-DB2-FUNCTION > SPACES                                  
               DISPLAY '**    FUNCTION  = ' WS-DB2-FUNCTION             
           END-IF.                                                      
                                                                        
           IF ACTIVE-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' ACTIVE-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               DISPLAY '**    FUNCTION  = ' ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           IF TABLE-1 > SPACES                                          
               DISPLAY '**    TABLE/FILE = ' TABLE-1                    
           END-IF.                                                      
                                                                        
           DISPLAY '*************************************'.             
      ***************************************************************           
      *    THIS INCLUDES THE WQ INSERT MODULE                      **           
      ***************************************************************           
                                                                        
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **           
      ***************************************************************           
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
      *                                                                         
