       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO106.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM ARCHIVES SERVICE ORDERS TO HISTORY.               **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/07    FB        ORIGINAL VERSION                       **         
C35403*    08/07    FB        DO NOT ARCHIVE ORDERS WITH UNPOSTED    **         
C35403*                       MATERIAL.                              **         
C35749*    11/07    FB        NEW COLUMN ON CSS_SO_FINAL_BILL.       **         
C34591*    02/08    VV        ADDED TWO NEW TABLES CSS_SO_ACCU_DATA  **         
C34591*                       AND CSS_SO_ACCU_DETAIL.                **         
C37169*    04/08    VV        ADDED NEW TABLE - CSS_SO_AROP.         **         
C35979*    05/08    FMB       ADDED COLUMN TO CSS_SO_MATL_TRAN.      **         
A37666*    09/09    FMB       ADDED CSS_SO_WEB_EVENT.                **         
A01712*    09/09    FMB       CHANGE FROM REQUIRING ALL 'Y' IN POSTED**         
A01712*                       FLAG TO REQUIRING AT LEAST ONE 'Y'     **         
A18341*    11/10    PK        DO NOT ARCHIVE IF THE PROCESSED DATE IS**         
A18341*                       NOT NULL IN ATLEAST 1 ROW FOR AN ORDER **         
A18341*                       IN CSS_SO_MATL_TRAN                    **         
P00198*    07/10    SC41135   ADDED CSS_SO_NDO_CALL_LIST             **         
P00480*    12/12    FMB       ADDED NEW COLUMNS ON CSS_SO_DATA.      **         
P00470*    02/14    FMB       REMOVE VAL_DPV_FL FROM                 **         
P00470*                       CSS_SO_FINAL_BILL.                     **         
P00718*    05/14    FMB       ADD NEW CLICK FIELDS.                  **         
P00795*    07/15    FMB       ADD NEW COLUMN ON CSS_SO_DATA.         **         
A05460*    11/10    VV        REMOVE ACCURACY DATA TABLES.           **         
P01176*    09/16    VV        ADD NEW COLUMN ON CSS_SO_ORDER_INST.   **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO106'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT-CHAR   PIC X(03) VALUE ZEROES.           
           05  WS-COMMIT-COUNT REDEFINES WS-COMMIT-COUNT-CHAR PIC 9(3). 
           05  WS-COUNT-TO-COMMIT     PIC S9(09) COMP VALUE 0.          
           05  WS-DATE-TRANS          PIC X(10).                        
           05  WS-NULL-IND            PIC S9(4) COMP VALUE +0.          
           05  WS-MONTHS-COUNT        PIC 99.                           
           05  WS-MONTHS-SQL          PIC S9(04) COMP VALUE +0.         
           05  WS-DISPLAY-SO          PIC 9(13).                        
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTDAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOCHR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTCHR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOCREW                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTCRW                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOCRQ                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTCRQ                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODNP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTDNP                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOEQP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTEQP                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOFIN                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTFIN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOMAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTMAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOMCG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTMCG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOMTR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTMTR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTODR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOPRT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSORCG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTRCG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOREG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTREG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOREM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTREM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOREQ                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTREQ                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOSLB                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTSLB                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUHR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUHR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUMG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUMG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUPD                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUPD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUTG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUTG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUTL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUTL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOXAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTXAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOXCN                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTXCN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCADPQU                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWMSTRN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTTRN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUMC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTUMC                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOCHG                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTCHG                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOMA                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTMA                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOMAC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTMAC                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOAROP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSOARP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRELORD                                                
           END-EXEC.                                                            
                                                                        
A37666     EXEC SQL                                                             
A37666          INCLUDE TBSOWEB                                                 
A37666     END-EXEC.                                                            
                                                                        
P00198     EXEC SQL                                                             
P00198          INCLUDE TBNDOLST                                                
P00198     END-EXEC.                                                            
                                                                        
P00198     EXEC SQL                                                             
P00198          INCLUDE TBHNDOLS                                                
P00198     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR CURSOR WITH HOLD FOR                     
               SELECT SERV_ORDER_NO                                     
                 FROM CSS_SO_DATA SO                                    
                WHERE ORDER_STATE_CD IN ('C', 'Z')                      
                   AND COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                 :VO-COMPLETED-DATETIME
              )     
A01712            AND (NOT EXISTS                                       
A01712             (SELECT 'X'                                          
A01712                FROM CSS_SO_MATL_TRAN WU                          
A01712               WHERE WU.SERV_ORDER_NO = SO.SERV_ORDER_NO)         
A01712             OR EXISTS                                            
A01712             (SELECT 'X'                                          
A01712                FROM CSS_SO_MATL_TRAN WU                          
A01712               WHERE WU.SERV_ORDER_NO = SO.SERV_ORDER_NO          
A01712                 AND MATL_POSTED_FL = 'Y'                         
A18341                 AND OK_TO_PROCESS_FL  = 'Y'                      
A18341                 AND PROCESSED_DT IS NOT NULL))                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          FROM CSS_SO_DATA SO                                            
MFA-TR*         WHERE ORDER_STATE_CD IN ('C', 'Z')                              
MFA-TR*            AND COMPLETED_DATETIME <= :VO-COMPLETED-DATETIME             
MFA-TR*           AND (NOT EXISTS                                               
MFA-TR*            (SELECT 'X'                                                  
MFA-TR*               FROM CSS_SO_MATL_TRAN WU                                  
MFA-TR*              WHERE WU.SERV_ORDER_NO = SO.SERV_ORDER_NO)                 
MFA-TR*            OR EXISTS                                                    
MFA-TR*            (SELECT 'X'                                                  
MFA-TR*               FROM CSS_SO_MATL_TRAN WU                                  
MFA-TR*              WHERE WU.SERV_ORDER_NO = SO.SERV_ORDER_NO                  
MFA-TR*                AND MATL_POSTED_FL = 'Y'                                 
MFA-TR*                AND OK_TO_PROCESS_FL  = 'Y'                              
MFA-TR*                AND PROCESSED_DT IS NOT NULL))                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7000-SELECT-JOB-PARM THRU 7000-EXIT.                 
           MOVE WS-MONTHS-COUNT TO WS-MONTHS-SQL.                       
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                         :WS-MONTHS-SQL
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :VO-COMPLETED-DATETIME                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES TIMESTAMP                                                  
MFA-TR*            (CURRENT TIMESTAMP - :WS-MONTHS-SQL MONTHS)                  
MFA-TR*         INTO :VO-COMPLETED-DATETIME                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF WS-COMMIT-COUNT-CHAR NOT NUMERIC                          
               MOVE '100' TO WS-COMMIT-COUNT-CHAR
           END-IF.                      
                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL ORDERS ARCHIVED = ' WS-DISPLAY-COUNT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR                                           
               INTO :VO-SERV-ORDER-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-ARCHIVE-PROCESS THRU 2000-EXIT.                 
                                                                        
           ADD 1 TO WS-COUNT-TO-COMMIT WS-ROW-COUNT.                    
                                                                        
           IF WS-COUNT-TO-COMMIT > WS-COMMIT-COUNT                      
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COUNT-TO-COMMIT
           END-IF.                          
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-ARCHIVE-PROCESS.                                            
                                                                        
           MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-SO.                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_DATA                                  
                          (PREMISE_NO,                                  
                           ACCOUNT_NO,                                  
                           SERV_ORDER_NO,                               
                           ORDER_TYPE_CD,                               
                           COMPANY_NO,                                  
                           LOCAL_OFFICE,                                
                           SERV_ORDER_STATUS,                           
                           PHONE_NO_EXT,                                
                           PHONE_NO,                                    
                           ORDER_PLACED_BY,                             
                           ORDER_RECVED_BY,                             
                           WANTED_BY_DATETIME,                          
                           DATE_RECVED,                                 
                           USER_ID_CPTD_BY,                             
                           COMPLETED_DATETIME,                          
                           CODE_EDITED_YES_NO,                          
                           ORDER_REASON,                                
                           BACK_DATED_IND,                              
                           RESP_AREA_ID,                                
                           CALL_BEFORE_MINUTS,                          
                           NOTIFY_CUST_IND,                             
                           NOTIFY_CSR_IND,                              
                           BREAKERS_OFF_IND,                            
                           NUMBER_OF_VISITS,                            
                           ORD_ASSIGNED_TO,                             
                           ASSIGNED_DATETIME,                           
                           DEPOSIT_AMT,                                 
                           WORK_COMPLETED_IND,                          
                           CATHODIC_PROTECT,                            
                           INIT_BY_CNTRCT_IND,                          
                           DATE_PRINTED,                                
                           WORK_AREA_ID,                                
                           ORDER_PRIORITY_CD,                           
                           AMT_DNP_AT_BILLING,                          
                           ORDER_STATE_CD,                              
                           BEGIN_APPT_DT,                               
                           END_APPT_DT,                                 
                           APPT_AM_PM_CD,                               
                           SO_EST_LABOR_HR,                             
                           DATE_FORECAST_DNP,                           
                           ACCOUNT_NO_PRIOR,                            
                           CODES_DATA_PRESENT,                          
                           VERIFY_RATE,                                 
                           COMPLETED_BY,                                
                           COMPLETED_BY_SEC,                            
                           PRINTED_IND,                                 
                           CUSTCHG_ORD_TYP_FL,                          
                           PRICE_PER_SERV,                              
                           ACCOUNT_TYPE_CODE,                           
                           WORK_START_DT,                               
                           MADE_SAFE_DT,                                
                           CUST_CNT_ID,                                 
P00480                     ALT_PHONE_NO,                                
P00480                     MTR_ACCESSIBLE_CD,                           
P00480                     MTR_ACCESSIBLE_DT,                           
P00480                     MTR_ACCESSIBLE_RSN,                          
P00480                     SOURCE_SYSTEM_CD,                            
P00480                     ALT_PHONE_NO_EXT,                            
P00480                     HOME_ALL_DAY_FL,                             
P00718                     SO_BUSINESS_UNIT,                            
P00718                     OPTIMIZE_ORDER_FL,                           
P00795                     ORDER_KEY)                                   
               SELECT  PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       SERV_ORDER_NO,                                   
                       ORDER_TYPE_CD,                                   
                       COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       SERV_ORDER_STATUS,                               
                       PHONE_NO_EXT,                                    
                       PHONE_NO,                                        
                       ORDER_PLACED_BY,                                 
                       ORDER_RECVED_BY,                                 
                       WANTED_BY_DATETIME,                              
                       DATE_RECVED,                                     
                       USER_ID_CPTD_BY,                                 
                       COMPLETED_DATETIME,                              
                       CODE_EDITED_YES_NO,                              
                       ORDER_REASON,                                    
                       BACK_DATED_IND,                                  
                       RESP_AREA_ID,                                    
                       CALL_BEFORE_MINUTS,                              
                       NOTIFY_CUST_IND,                                 
                       NOTIFY_CSR_IND,                                  
                       BREAKERS_OFF_IND,                                
                       NUMBER_OF_VISITS,                                
                       ORD_ASSIGNED_TO,                                 
                       ASSIGNED_DATETIME,                               
                       DEPOSIT_AMT,                                     
                       WORK_COMPLETED_IND,                              
                       CATHODIC_PROTECT,                                
                       INIT_BY_CNTRCT_IND,                              
                       DATE_PRINTED,                                    
                       WORK_AREA_ID,                                    
                       ORDER_PRIORITY_CD,                               
                       AMT_DNP_AT_BILLING,                              
                       ORDER_STATE_CD,                                  
                       BEGIN_APPT_DT,                                   
                       END_APPT_DT,                                     
                       APPT_AM_PM_CD,                                   
                       SO_EST_LABOR_HR,                                 
                       DATE_FORECAST_DNP,                               
                       ACCOUNT_NO_PRIOR,                                
                       CODES_DATA_PRESENT,                              
                       VERIFY_RATE,                                     
                       COMPLETED_BY,                                    
                       COMPLETED_BY_SEC,                                
                       PRINTED_IND,                                     
                       CUSTCHG_ORD_TYP_FL,                              
                       PRICE_PER_SERV,                                  
                       ACCOUNT_TYPE_CODE,                               
                       WORK_START_DT,                                   
                       MADE_SAFE_DT,                                    
                       CUST_CNT_ID,                                     
P00480                 ALT_PHONE_NO,                                    
P00480                 MTR_ACCESSIBLE_CD,                               
P00480                 MTR_ACCESSIBLE_DT,                               
P00480                 MTR_ACCESSIBLE_RSN,                              
P00480                 SOURCE_SYSTEM_CD,                                
P00480                 ALT_PHONE_NO_EXT,                                
P00480                 HOME_ALL_DAY_FL,                                 
P00718                 SO_BUSINESS_UNIT,                                
P00718                 OPTIMIZE_ORDER_FL,                               
P00795                 ORDER_KEY                                        
                 FROM CSS_SO_DATA SO                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_DATA  **'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_ORDER_INST                            
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           SO_INST_SEQ_NO,                              
                           CODE_METER_LOC,                              
                           HOLD_RELEASE,                                
                           IC_NO,                                       
                           METER_NO,                                    
                           METER_SUPPLYING,                             
                           MTR_REF_NO,                                  
                           PER_TEMP_IND,                                
                           RLSE_DATE,                                   
                           RLSE_NO,                                     
                           WORK_TYPE_CD,                                
P00718                     TASK_STATUS_CD,                              
P01176                     SAMPLE_TEST_FL)                              
               SELECT  SERV_ORDER_NO,                                   
                       CODE_UTIL_TYPE,                                  
                       SO_INST_SEQ_NO,                                  
                       CODE_METER_LOC,                                  
                       HOLD_RELEASE,                                    
                       IC_NO,                                           
                       METER_NO,                                        
                       METER_SUPPLYING,                                 
                       MTR_REF_NO,                                      
                       PER_TEMP_IND,                                    
                       RLSE_DATE,                                       
                       RLSE_NO,                                         
                       WORK_TYPE_CD,                                    
P00718                 TASK_STATUS_CD,                                  
P01176                 SAMPLE_TEST_FL                                   
                 FROM CSS_SO_ORDER_INST                                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_ORD_INST*'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_APPLIANCE                             
                          (SERV_ORDER_NO,                               
                           EQUIPMENT_UNQ,                               
                           APPLIANCE_CD,                                
                           APPLIANCE_SEQ_NO,                            
                           CAUTION_TAG_IND,                             
                           CODE_UTIL_TYPE,                              
                           CUTOFF_IND,                                  
                           EQUIP_OWNER,                                 
                           IMPROPER_REASON,                             
                           INSTALL_DT,                                  
                           LEAK_IND,                                    
                           LIGHT_IND,                                   
                           PRD_SRV_TYP_DESC,                            
                           REPAIR_IND,                                  
                           REPLACE_APP_FL,                              
                           INSTALL_IND)                                 
               SELECT SERV_ORDER_NO,                                    
                      EQUIPMENT_UNQ,                                    
                      APPLIANCE_CD,                                     
                      APPLIANCE_SEQ_NO,                                 
                      CAUTION_TAG_IND,                                  
                      CODE_UTIL_TYPE,                                   
                      CUTOFF_IND,                                       
                      EQUIP_OWNER,                                      
                      IMPROPER_REASON,                                  
                      INSTALL_DT,                                       
                      LEAK_IND,                                         
                      LIGHT_IND,                                        
                      PRD_SRV_TYP_DESC,                                 
                      REPAIR_IND,                                       
                      REPLACE_APP_FL,                                   
                      INSTALL_IND                                       
                 FROM CSS_SO_APPLIANCE                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_APPLIANCE'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_CHARGES                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           OT_CHARGEABLE_HRS,                           
                           REG_CHARGEABLE_HRS,                          
                           MATERIAL_CHRG,                               
                           OTHER_CHRG,                                  
                           CALC_LABOR_CHRG,                             
                           COMMENTS,                                    
                           STD_LABOR_CHRG,                              
                           ADDL_LABOR_CHRG,                             
                           ADDL_MATL_CHRG,                              
                           CLASS_CD,                                    
                           CNT_NAME_CD,                                 
                           LBR_MARKUP_TYPE_CD,                          
                           MATL_OVERRIDE_CHRG,                          
                           MTL_MARKUP_TYPE_CD,                          
                           EQUIP_CHARG_AM,                              
                           EQUIP_OVERRIDE_AM,                           
                           CONTRACTOR_AM,                               
                           ACCOUNT_TYPE_CODE,                           
                           WAIVER_TYPE_CD,                              
                           WORK_PERIOD_CD)                              
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      OT_CHARGEABLE_HRS,                                
                      REG_CHARGEABLE_HRS,                               
                      MATERIAL_CHRG,                                    
                      OTHER_CHRG,                                       
                      CALC_LABOR_CHRG,                                  
                      COMMENTS,                                         
                      STD_LABOR_CHRG,                                   
                      ADDL_LABOR_CHRG,                                  
                      ADDL_MATL_CHRG,                                   
                      CLASS_CD,                                         
                      CNT_NAME_CD,                                      
                      LBR_MARKUP_TYPE_CD,                               
                      MATL_OVERRIDE_CHRG,                               
                      MTL_MARKUP_TYPE_CD,                               
                      EQUIP_CHARG_AM,                                   
                      EQUIP_OVERRIDE_AM,                                
                      CONTRACTOR_AM,                                    
                      ACCOUNT_TYPE_CODE,                                
                      WAIVER_TYPE_CD,                                   
                      WORK_PERIOD_CD                                    
                 FROM CSS_SO_CHARGES                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_CHARGES*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_LABOR_CHRGS                           
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           CLASS_CD,                                    
                           EMPLOYEE_NO,                                 
                           HOL_CHARGEABLE_HRS,                          
                           OT_CHARGEABLE_HRS,                           
                           REG_CHARGEABLE_HRS)                          
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      CLASS_CD,                                         
                      EMPLOYEE_NO,                                      
                      HOL_CHARGEABLE_HRS,                               
                      OT_CHARGEABLE_HRS,                                
                      REG_CHARGEABLE_HRS                                
                 FROM CSS_SO_LABOR_CHRGS                                
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_LABOR-CHG'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_STD_LABOR                             
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           CHRG_SEQ_NO,                                 
                           CHARGE_CODE,                                 
                           CHRG_AMOUNT)                                 
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      CHRG_SEQ_NO,                                      
                      CHARGE_CODE,                                      
                      CHRG_AMOUNT                                       
                 FROM CSS_SO_STD_LABOR                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_STD_LABOR'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_MATERIALS                             
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           MATERIAL_SEQ_NO,                             
                           AREA_TAX,                                    
                           CHRG_FOR_MATERIAL,                           
                           MATERIAL_DESC,                               
                           MATERIAL_ID,                                 
                           QUANTITY,                                    
                           STATE_TAX,                                   
                           TOT_CHARGE_EQUIP,                            
                           TOT_MATERIAL_CHRG)                           
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      MATERIAL_SEQ_NO,                                  
                      AREA_TAX,                                         
                      CHRG_FOR_MATERIAL,                                
                      MATERIAL_DESC,                                    
                      MATERIAL_ID,                                      
                      QUANTITY,                                         
                      STATE_TAX,                                        
                      TOT_CHARGE_EQUIP,                                 
                      TOT_MATERIAL_CHRG                                 
                 FROM CSS_SO_MATERIALS                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_MATERIALS'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_CNTRCT_XFER                           
                          (SERV_ORDER_NO,                               
                           CNT_ITEM_ID,                                 
                           ACCOUNT_NO)                                  
               SELECT SERV_ORDER_NO,                                    
                      CNT_ITEM_ID,                                      
                      ACCOUNT_NO                                        
                 FROM CSS_SO_CNTRCT_XFER                                
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_CNT_XFER'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_DNP                                   
                          (SERV_ORDER_NO,                               
                           AMOUNT_DISC_BAL,                             
                           CREDIT_GROUP,                                
                           CUR_MTH_ARREARS_CD,                          
                           DATE_BILL_DAY_00,                            
                           DNP_CNCL_REASON_CD,                          
                           SECURITIES_TOT_AMT)                          
               SELECT SERV_ORDER_NO,                                    
                      AMOUNT_DISC_BAL,                                  
                      CREDIT_GROUP,                                     
                      CUR_MTH_ARREARS_CD,                               
                      DATE_BILL_DAY_00,                                 
                      DNP_CNCL_REASON_CD,                               
                      SECURITIES_TOT_AMT                                
                 FROM CSS_SO_DNP                                        
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_DNP   **'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_FB_UMCNTRCT                           
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           RATE_PLAN_NO,                                
                           REV_INSTALL_AMT)                             
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      RATE_PLAN_NO,                                     
                      REV_INSTALL_AMT                                   
                 FROM CSS_SO_FB_UMCNTRCT                                
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_FB_UMRCT'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_FINAL_BILL                            
                          (SERV_ORDER_NO,                               
                           ADDR_COUNTRY,                                
                           ADDR_PREFIX_1,                               
                           ADDR_PREFIX_2,                               
                           ADDR_ST,                                     
                           ADDR_SUFFIX,                                 
                           ADDR_ZIP_CODE,                               
                           ADDRESS_FORMAT,                              
                           ADDRESS_OVERFLOW,                            
                           CARRIER_ROUTE,                               
                           CREDIT_LETTER_IND,                           
                           FINAL_BILL_CY_ST,                            
                           FINAL_BILL_OVFL,                             
                           HOUSE_NO,                                    
                           SEND_TO_LOCOFF_IND,                          
                           STREET_LOCATION_1,                           
                           STREET_LOCATION_2,                           
                           STREET_NAME,                                 
                           STREET_SUFFIX,                               
                           ZIP_CODE,                                    
                           ZIP_CODE_PLUS_FOUR,                          
                           ZIP_CODE_TOKEN,                              
                           USPS_DELIV_PT_CD,                            
C35749                     VALIDATION_TS,                               
C35749                     ADDR_ST_2)                                   
               SELECT SERV_ORDER_NO,                                    
                      ADDR_COUNTRY,                                     
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      ADDR_ST,                                          
                      ADDR_SUFFIX,                                      
                      ADDR_ZIP_CODE,                                    
                      ADDRESS_FORMAT,                                   
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      CREDIT_LETTER_IND,                                
                      FINAL_BILL_CY_ST,                                 
                      FINAL_BILL_OVFL,                                  
                      HOUSE_NO,                                         
                      SEND_TO_LOCOFF_IND,                               
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      USPS_DELIV_PT_CD,                                 
C35749                VALIDATION_TS,                                    
C35749                ADDR_ST_2                                         
                 FROM CSS_SO_FINAL_BILL                                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_FINAL_BILL'  
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_REMARKS                               
                          (SERV_ORDER_NO,                               
                           REMARK_TYPE_CD,                              
                           REMARK_DATETIME,                             
                           CHANGED_BY_USER_ID,                          
                           REMARK_TX)                                   
               SELECT SERV_ORDER_NO,                                    
                      REMARK_TYPE_CD,                                   
                      REMARK_DATETIME,                                  
                      CHANGED_BY_USER_ID,                               
                      REMARK_TX                                         
                 FROM CSS_SO_REMARKS                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_REMARKS*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_REQUIREMENT                           
                          (SERV_ORDER_NO,                               
                           SERV_ORDER_STATUS,                           
                           REQUIREMENT_CD,                              
                           AUTH_BY_USER_ID,                             
                           COMP_BY_USER_ID,                             
                           DAYS_DURATION_NM,                            
                           DISP_CD,                                     
                           LABOR_HRS_NM,                                
                           MILESTONE_FL,                                
                           NONSTD_REQMNT_TEXT,                          
                           REQMNT_COMP_DT,                              
                           REQMNT_STAGE_CD,                             
                           RESOURCE_CD,                                 
                           SCHED_END_DT,                                
                           SCHED_START_DT)                              
               SELECT SERV_ORDER_NO,                                    
                      SERV_ORDER_STATUS,                                
                      REQUIREMENT_CD,                                   
                      AUTH_BY_USER_ID,                                  
                      COMP_BY_USER_ID,                                  
                      DAYS_DURATION_NM,                                 
                      DISP_CD,                                          
                      LABOR_HRS_NM,                                     
                      MILESTONE_FL,                                     
                      NONSTD_REQMNT_TEXT,                               
                      REQMNT_COMP_DT,                                   
                      REQMNT_STAGE_CD,                                  
                      RESOURCE_CD,                                      
                      SCHED_END_DT,                                     
                      SCHED_START_DT                                    
                 FROM CSS_SO_REQUIREMENT                                
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_RQMT   **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_UNCHRG_HRS                            
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           CHARGE_CODE,                                 
                           UNCHRG_HOURS)                                
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      CHARGE_CODE,                                      
                      UNCHRG_HOURS                                      
                 FROM CSS_SO_UNCHRG_HRS                                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_UNCH_HRS'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_UPDATE                                
                          (SERV_ORDER_NO,                               
                           UPDATE_DATETIME,                             
                           ASSIGNED_DATETIME,                           
                           ORDER_STATE_CD,                              
                           ORDER_TYPE_CD,                               
                           PANEL_NO,                                    
                           SERV_ORDER_STATUS,                           
                           USER_ID_UPDT_BY,                             
                           WANTED_BY_DATETIME)                          
               SELECT SERV_ORDER_NO,                                    
                      UPDATE_DATETIME,                                  
                      ASSIGNED_DATETIME,                                
                      ORDER_STATE_CD,                                   
                      ORDER_TYPE_CD,                                    
                      PANEL_NO,                                         
                      SERV_ORDER_STATUS,                                
                      USER_ID_UPDT_BY,                                  
                      WANTED_BY_DATETIME                                
                 FROM CSS_SO_UPDATE                                     
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_UPDATE**'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_UTILITY                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           CODE_CITY_TAX_XMT,                           
                           CODE_CURTAIL_PRTY,                           
                           CODE_ESTIMATE_OK,                            
                           CODE_MTR_READ_FREQ,                          
                           CODE_OTHR_TAX_XMT,                           
                           CODE_REVENUE_CLASS,                          
                           CODE_SERVICE_TYPE,                           
                           CODE_SIC_NO,                                 
                           CODE_STAT_TAX_XMT,                           
                           CODE_XCIS_TAX_XMT,                           
                           DATE_INSTALL,                                
                           DATE_LST_NRML_BILL,                          
                           END_USER_PER_RATE,                           
                           GAS_BASE_LAST_UPDT,                          
                           GAS_BASE_USE,                                
                           GAS_PREV_BASE_USE,                           
                           RATE_PLAN_NO,                                
                           READ_CYCLE,                                  
                           READ_ROUTE,                                  
                           SEASONAL_USE_CODE,                           
                           SPLY_SENSITIVE_IND,                          
                           STATE_TAX_EXMPT_NO)                          
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      CODE_CITY_TAX_XMT,                                
                      CODE_CURTAIL_PRTY,                                
                      CODE_ESTIMATE_OK,                                 
                      CODE_MTR_READ_FREQ,                               
                      CODE_OTHR_TAX_XMT,                                
                      CODE_REVENUE_CLASS,                               
                      CODE_SERVICE_TYPE,                                
                      CODE_SIC_NO,                                      
                      CODE_STAT_TAX_XMT,                                
                      CODE_XCIS_TAX_XMT,                                
                      DATE_INSTALL,                                     
                      DATE_LST_NRML_BILL,                               
                      END_USER_PER_RATE,                                
                      GAS_BASE_LAST_UPDT,                               
                      GAS_BASE_USE,                                     
                      GAS_PREV_BASE_USE,                                
                      RATE_PLAN_NO,                                     
                      READ_CYCLE,                                       
                      READ_ROUTE,                                       
                      SEASONAL_USE_CODE,                                
                      SPLY_SENSITIVE_IND,                               
                      STATE_TAX_EXMPT_NO                                
                 FROM CSS_SO_UTILITY                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_UTILITY*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_METER                                 
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           CODE_ALRT_CHNG_IND,                          
                           CODE_LAST_REG_READ,                          
                           CODE_METER_LOC,                              
                           CODE_METER_STATUS,                           
                           CODE_MTR_RD_INST1,                           
                           CODE_MTR_RD_INST2,                           
                           CODE_MTR_RD_INST3,                           
                           CODE_SPCL_SEAL,                              
                           CODE_STATUS_REAS,                            
                           CODE_TIME_PERIOD,                            
                           CODE_USAGE_ID,                               
                           CODE_USAGE_SOURCE,                           
                           CODE_USAGE_TYPE,                             
                           CONSTANT,                                    
                           DELIVERY_LEVEL_CD,                           
                           DIGTL_MTR_TYPE,                              
                           DIST_NODE_POINT,                             
                           EXCEPT_OVERRIDE_CD,                          
                           HEXAGRAM_LOCATION,                           
                           IDR_RECIPIENT_CD,                            
                           INSULATED_IND,                               
                           LAST_READ_VALUE,                             
                           LOCK_TYPE_ID,                                
                           METER_NO,                                    
                           METER_SUPPLYING,                             
                           MTR_READ_SOURCE_CD,                          
                           NO_DIALS,                                    
                           POINT_ID,                                    
                           PROGRAM_ID,                                  
                           REG_ID_NO,                                   
                           REGISTER_RD_SEQ,                             
                           REMOTE_READ_IND,                             
                           SEAL_CODE_ID,                                
                           UTILITY_SOURCE_CD,                           
                           GIS_POINT_ID,                                
                           METER_PRESSURE)                              
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      CODE_ALRT_CHNG_IND,                               
                      CODE_LAST_REG_READ,                               
                      CODE_METER_LOC,                                   
                      CODE_METER_STATUS,                                
                      CODE_MTR_RD_INST1,                                
                      CODE_MTR_RD_INST2,                                
                      CODE_MTR_RD_INST3,                                
                      CODE_SPCL_SEAL,                                   
                      CODE_STATUS_REAS,                                 
                      CODE_TIME_PERIOD,                                 
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      CODE_USAGE_TYPE,                                  
                      CONSTANT,                                         
                      DELIVERY_LEVEL_CD,                                
                      DIGTL_MTR_TYPE,                                   
                      DIST_NODE_POINT,                                  
                      EXCEPT_OVERRIDE_CD,                               
                      HEXAGRAM_LOCATION,                                
                      IDR_RECIPIENT_CD,                                 
                      INSULATED_IND,                                    
                      LAST_READ_VALUE,                                  
                      LOCK_TYPE_ID,                                     
                      METER_NO,                                         
                      METER_SUPPLYING,                                  
                      MTR_READ_SOURCE_CD,                               
                      NO_DIALS,                                         
                      POINT_ID,                                         
                      PROGRAM_ID,                                       
                      REG_ID_NO,                                        
                      REGISTER_RD_SEQ,                                  
                      REMOTE_READ_IND,                                  
                      SEAL_CODE_ID,                                     
                      UTILITY_SOURCE_CD,                                
                      GIS_POINT_ID,                                     
                      METER_PRESSURE                                    
                 FROM CSS_SO_METER                                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_METER **'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_REGISTER                              
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           CODE_LAST_REG_READ,                          
                           CODE_REG_STATUS,                             
                           CODE_STATUS_REAS,                            
                           CODE_TIME_PERIOD,                            
                           CODE_USAGE_ID,                               
                           CODE_USAGE_SOURCE,                           
                           CODE_USAGE_TYPE,                             
                           CONSTANT,                                    
                           LAST_READ_VALUE,                             
                           METER_NO,                                    
                           NO_DIALS,                                    
                           REG_ID_NO,                                   
                           REGISTER_RD_SEQ,                             
                           SEASONAL_USE_CD)                             
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      CODE_LAST_REG_READ,                               
                      CODE_REG_STATUS,                                  
                      CODE_STATUS_REAS,                                 
                      CODE_TIME_PERIOD,                                 
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      CODE_USAGE_TYPE,                                  
                      CONSTANT,                                         
                      LAST_READ_VALUE,                                  
                      METER_NO,                                         
                      NO_DIALS,                                         
                      REG_ID_NO,                                        
                      REGISTER_RD_SEQ,                                  
                      SEASONAL_USE_CD                                   
                 FROM CSS_SO_REGISTER                                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_REGISTER'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_UTL_CHG                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           CODE_REVENUE_CLASS,                          
                           CODE_SIC_NO,                                 
                           RATE_PLAN_NO,                                
                           READ_CYCLE,                                  
                           READ_ROUTE,                                  
                           CODE_UTIL_STAT_IS)                           
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      READ_CYCLE,                                       
                      READ_ROUTE,                                       
                      CODE_UTIL_STAT_IS                                 
                 FROM CSS_SO_UTL_CHG                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_UTL_CHG*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_UMTR_CHG                              
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           RATE_ITEM_CODE,                              
                           ITEM_SEQ_NO,                                 
                           CODE_PLAN_REA_IS,                            
                           CODE_PLAN_STAT_IS,                           
                           CODE_PLAN_STATUS,                            
                           CODE_SERV_TYPE,                              
                           CODE_STAT_REASON,                            
                           DIST_NO,                                     
                           LIGHT_NO,                                    
                           MTHLY_AMOUNT_FIXED,                          
                           NO_UNITS,                                    
                           POLE_NO,                                     
                           UM_EQUIP_ID,                                 
                           USAGE_FIXED)                                 
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      RATE_ITEM_CODE,                                   
                      ITEM_SEQ_NO,                                      
                      CODE_PLAN_REA_IS,                                 
                      CODE_PLAN_STAT_IS,                                
                      CODE_PLAN_STATUS,                                 
                      CODE_SERV_TYPE,                                   
                      CODE_STAT_REASON,                                 
                      DIST_NO,                                          
                      LIGHT_NO,                                         
                      MTHLY_AMOUNT_FIXED,                               
                      NO_UNITS,                                         
                      POLE_NO,                                          
                      UM_EQUIP_ID,                                      
                      USAGE_FIXED                                       
                 FROM CSS_SO_UMTR_CHG                                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_UMTR_CHG'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_MTR_CHG                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           CODE_DEST,                                   
                           CODE_STATUS_REA_IS,                          
                           CODE_STATUS_REA_WS,                          
                           CODE_MTR_STATUS_IS,                          
                           CODE_MTR_STATUS_WS,                          
                           CODE_TIME_PERIOD,                            
                           CODE_USAGE_ID,                               
                           CODE_USAGE_SOURCE,                           
                           CODE_USAGE_TYPE,                             
                           CONSTANT,                                    
                           DEST_NO,                                     
                           LAST_READ_VALUE,                             
                           LAST_REG_READ_DATE,                          
                           METER_NO,                                    
                           NO_DIALS,                                    
                           POST_MTR_CHG_IND,                            
                           READ_VALUE_IS,                               
                           REG_ID_NO,                                   
                           MTR_READ_SOURCE_CD,                          
                           METER_SUPPLYING,                             
                           PROGRAM_ID,                                  
                           IDR_RECIPIENT_CD,                            
                           UTILITY_SOURCE_CD,                           
                           DELIVERY_LEVEL_CD,                           
                           LOCK_TYPE_ID,                                
                           INSULATED_IND,                               
                           HEXAGRAM_LOCATION,                           
                           SEAL_CODE_ID,                                
                           POINT_ID,                                    
                           CODE_METER_LOC,                              
                           GIS_POINT_ID,                                
                           METER_PRESSURE)                              
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      CODE_DEST,                                        
                      CODE_STATUS_REA_IS,                               
                      CODE_STATUS_REA_WS,                               
                      CODE_MTR_STATUS_IS,                               
                      CODE_MTR_STATUS_WS,                               
                      CODE_TIME_PERIOD,                                 
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      CODE_USAGE_TYPE,                                  
                      CONSTANT,                                         
                      DEST_NO,                                          
                      LAST_READ_VALUE,                                  
                      LAST_REG_READ_DATE,                               
                      METER_NO,                                         
                      NO_DIALS,                                         
                      POST_MTR_CHG_IND,                                 
                      READ_VALUE_IS,                                    
                      REG_ID_NO,                                        
                      MTR_READ_SOURCE_CD,                               
                      METER_SUPPLYING,                                  
                      PROGRAM_ID,                                       
                      IDR_RECIPIENT_CD,                                 
                      UTILITY_SOURCE_CD,                                
                      DELIVERY_LEVEL_CD,                                
                      LOCK_TYPE_ID,                                     
                      INSULATED_IND,                                    
                      HEXAGRAM_LOCATION,                                
                      SEAL_CODE_ID,                                     
                      POINT_ID,                                         
                      CODE_METER_LOC,                                   
                      GIS_POINT_ID,                                     
                      METER_PRESSURE                                    
                 FROM CSS_SO_MTR_CHG                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_MTR_CHG*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_REG_CHG                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           CODE_STATUS_REA_IS,                          
                           CODE_STATUS_REA_WS,                          
                           CODE_REG_STATUS_IS,                          
                           CODE_REG_STATUS_WS,                          
                           CODE_TIME_PERIOD,                            
                           CODE_USAGE_ID,                               
                           CODE_USAGE_SOURCE,                           
                           CODE_USAGE_TYPE,                             
                           CONSTANT,                                    
                           LAST_READ_VALUE,                             
                           LAST_REG_READ_DT,                            
                           METER_NO,                                    
                           NO_DIALS,                                    
                           READ_VALUE_IS,                               
                           REG_ID_NO)                                   
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      CODE_STATUS_REA_IS,                               
                      CODE_STATUS_REA_WS,                               
                      CODE_REG_STATUS_IS,                               
                      CODE_REG_STATUS_WS,                               
                      CODE_TIME_PERIOD,                                 
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      CODE_USAGE_TYPE,                                  
                      CONSTANT,                                         
                      LAST_READ_VALUE,                                  
                      LAST_REG_READ_DT,                                 
                      METER_NO,                                         
                      NO_DIALS,                                         
                      READ_VALUE_IS,                                    
                      REG_ID_NO                                         
                 FROM CSS_SO_REG_CHG                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_REG_CHG*'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_ACCT_XFER                             
                          (SERV_ORDER_NO,                               
                           COAPPL_XFER_IND,                             
                           DEPOSIT_XFER_IND,                            
                           EPP_XFER_IND,                                
                           IN_LIEU_XFER_IND,                            
                           MED_CERT_XFER_IND,                           
                           OTHER_AR_XFER_IND,                           
                           PROJ_SHR_XFER_IND,                           
                           ROOMMATE_XFER_IND,                           
                           TO_ACCT_NO,                                  
                           WHT_CROSS_XFER_IND,                          
                           WRITE_OFF_XFER_IND)                          
               SELECT SERV_ORDER_NO,                                    
                      COAPPL_XFER_IND,                                  
                      DEPOSIT_XFER_IND,                                 
                      EPP_XFER_IND,                                     
                      IN_LIEU_XFER_IND,                                 
                      MED_CERT_XFER_IND,                                
                      OTHER_AR_XFER_IND,                                
                      PROJ_SHR_XFER_IND,                                
                      ROOMMATE_XFER_IND,                                
                      ROUND(TO_ACCT_NO, 0),                             
                      WHT_CROSS_XFER_IND,                               
                      WRITE_OFF_XFER_IND                                
                 FROM CSS_SO_ACCT_XFER                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_ACCT_XFER'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_CUST_REQ                              
                          (SERV_ORDER_NO,                               
                           CUST_REQ_TYPE_CD,                            
                           CUST_REQ_SOURCE_CD)                          
               SELECT SERV_ORDER_NO,                                    
                      CUST_REQ_TYPE_CD,                                 
                      CUST_REQ_SOURCE_CD                                
                 FROM CSS_SO_CUST_REQ                                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_DATA  **'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_CREW                                  
                          (SERV_ORDER_NO,                               
                           CREW_ID,                                     
                           WORK_SEQ_NM,                                 
                           WORK_DT,                                     
                           CREW_SCHED_DT,                               
                           CREW_COMPLETE_DT)                            
               SELECT SERV_ORDER_NO,                                    
                      CREW_ID,                                          
                      WORK_SEQ_NM,                                      
                      WORK_DT,                                          
                      CREW_SCHED_DT,                                    
                      CREW_COMPLETE_DT                                  
                 FROM CSS_SO_CREW                                       
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_CREW  **'    
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_MATL_TRAN                             
                          (SERV_ORDER_NO,                               
                           COMP_UNIT_CD,                                
                           CU_SEQ_NM,                                   
                           MATL_USAGE_CD,                               
                           MATL_ITEM_CD,                                
                           WORK_ORDER_NM,                               
                           GL_ACCT_NO,                                  
                           FUNC_ACT_CD,                                 
                           POINT,                                       
                           SPAN_TO_POINT,                               
                           MISC_TRK_STOCK_AM,                           
                           MATL_ITEM_QT,                                
                           CU_QT,                                       
                           MATL_ITEM_TOT_AM,                            
                           MATL_ITEM_TYPE_CD,                           
                           UOM_CD,                                      
                           COST_CENTER,                                 
                           EMPLOYEE_ID,                                 
                           COMPANY_NO,                                  
                           LOCAL_STORERM_ID,                            
                           WORK_AREA_WO_NM,                             
                           OK_TO_PROCESS_FL,                            
                           PROCESSED_DT,                                
                           MATL_POSTED_FL,                              
C35979                     GAS_CARRIER_FL)                              
               SELECT SERV_ORDER_NO,                                    
                      COMP_UNIT_CD,                                     
                      CU_SEQ_NM,                                        
                      MATL_USAGE_CD,                                    
                      MATL_ITEM_CD,                                     
                      WORK_ORDER_NM,                                    
                      GL_ACCT_NO,                                       
                      FUNC_ACT_CD,                                      
                      POINT,                                            
                      SPAN_TO_POINT,                                    
                      MISC_TRK_STOCK_AM,                                
                      MATL_ITEM_QT,                                     
                      CU_QT,                                            
                      MATL_ITEM_TOT_AM,                                 
                      MATL_ITEM_TYPE_CD,                                
                      UOM_CD,                                           
                      COST_CENTER,                                      
                      EMPLOYEE_ID,                                      
                      COMPANY_NO,                                       
                      LOCAL_STORERM_ID,                                 
                      WORK_AREA_WO_NM,                                  
                      OK_TO_PROCESS_FL,                                 
                      PROCESSED_DT,                                     
                      MATL_POSTED_FL,                                   
C35979                GAS_CARRIER_FL                                    
                  FROM CSS_SO_MATL_TRAN                                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_MATL_TRAN'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_MTR_ATT                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           METER_NO,                                    
                           REG_ID_NO,                                   
                           DEVICE_NO,                                   
                           CODE_ATT_TYPE,                               
                           STATUS_CD,                                   
                           CODE_STATUS_REASON,                          
                           COMPANY_NO,                                  
                           READ_VALUE_IS,                               
                           HOW_ATTACHED_CD)                             
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      METER_NO,                                         
                      REG_ID_NO,                                        
                      DEVICE_NO,                                        
                      CODE_ATT_TYPE,                                    
                      STATUS_CD,                                        
                      CODE_STATUS_REASON,                               
                      COMPANY_NO,                                       
                      READ_VALUE_IS,                                    
                      HOW_ATTACHED_CD                                   
                  FROM CSS_SO_MTR_ATT                                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_MTR_ATT *'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_MTR_ATT_CHG                           
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           IC_NO,                                       
                           MTR_REF_NO,                                  
                           METER_NO,                                    
                           REG_ID_NO,                                   
                           DEVICE_NO,                                   
                           CODE_ATT_TYPE,                               
                           STATUS_CD,                                   
                           CODE_STATUS_REASON,                          
                           COMPANY_NO,                                  
                           READ_VALUE_IS,                               
                           HOW_ATTACHED_CD)                             
               SELECT SERV_ORDER_NO,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      MTR_REF_NO,                                       
                      METER_NO,                                         
                      REG_ID_NO,                                        
                      DEVICE_NO,                                        
                      CODE_ATT_TYPE,                                    
                      STATUS_CD,                                        
                      CODE_STATUS_REASON,                               
                      COMPANY_NO,                                       
                      READ_VALUE_IS,                                    
                      HOW_ATTACHED_CD                                   
                  FROM CSS_SO_MTR_ATT_CHG                               
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_MTR_ATT *'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
P00198     EXEC SQL                                                     
P00198         INSERT INTO HST_SO_NDO_CALL_LIST                         
P00198               (  SERV_ORDER_NO                                   
P00198                 ,ASSIGNED_DATETIME                               
P00198                 ,ACCOUNT_NO                                      
P00198                 ,COMPANY_NO                                      
P00198                 ,CALL_PRIORITY_CD                                
P00198                 ,PHONE_NO                                        
P00198                 ,CALL_STATUS_CD                                  
P00198                 ,CALL_RESULT_CD                                  
P00198                 ,NDO_MSG_ID                                      
P00198                 ,LAST_CALL_TS                                    
P00198                 ,LAST_UPDATE_TS                                  
P00198                 ,LAST_UPDATE_USERID                              
P00198                 ,CALL_COUNT )                                    
P00198         SELECT   SERV_ORDER_NO                                   
P00198                 ,ASSIGNED_DATETIME                               
P00198                 ,ACCOUNT_NO                                      
P00198                 ,COMPANY_NO                                      
P00198                 ,CALL_PRIORITY_CD                                
P00198                 ,PHONE_NO                                        
P00198                 ,CALL_STATUS_CD                                  
P00198                 ,CALL_RESULT_CD                                  
P00198                 ,NDO_MSG_ID                                      
P00198                 ,LAST_CALL_TS                                    
P00198                 ,LAST_UPDATE_TS                                  
P00198                 ,LAST_UPDATE_USERID                              
P00198                 ,CALL_COUNT                                      
P00198            FROM CSS_SO_NDO_CALL_LIST                             
P00198          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
P00198     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00198      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
P00198      EVALUATE WS-ACTIVE-RETURN-CODE                              
P00198        WHEN SUCCESSFUL-CALL                                      
P00198        WHEN NOT-FOUND                                            
P00198            CONTINUE                                              
P00198        WHEN OTHER                                                
P00198            MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE      
P00198            DISPLAY '****************************************'    
P00198            DISPLAY '**  ERROR SELECT/INSERT CSS_SO_NDO_CALL_LI*' 
P00198            DISPLAY '**  ORDER - ' WS-DISPLAY-SO                  
P00198            DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE           
P00198            DISPLAY '**  PROCESSING TERMINATED             **'    
P00198             DISPLAY '****************************************'   
P00198             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
P00198     END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_SO_AROP                                  
                     (  SERV_ORDER_NO                                   
                       ,PRORATED_DAYS_NM                                
                       ,AROP_RELEASE_ST_CD                              
                       ,AROP_RELEASE_DT                                 
                       ,ORIG_ASSIGN_DT)                                 
               SELECT   SERV_ORDER_NO                                   
                       ,PRORATED_DAYS_NM                                
                       ,AROP_RELEASE_ST_CD                              
                       ,AROP_RELEASE_DT                                 
                       ,ORIG_ASSIGN_DT                                  
                  FROM CSS_SO_AROP                                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT/INSERT CSS_SO_AROP   **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RELATED_ORDER                            
                WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO            
                   OR RELATED_SRVC_ORDER = :VO-SERV-ORDER-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_RELATED_ORDER  **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
A37666     EXEC SQL                                                     
A37666         DELETE FROM CSS_SO_WEB_EVENT                             
A37666          WHERE ON_ORDER_NO      = :VO-SERV-ORDER-NO              
A37666             OR OFF_ORDER_NO     = :VO-SERV-ORDER-NO              
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37666         WHEN SUCCESSFUL-CALL                                     
A37666         WHEN NOT-FOUND                                           
A37666             CONTINUE                                             
A37666         WHEN OTHER                                               
A37666             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A37666             DISPLAY '****************************************'   
A37666             DISPLAY '**  ERROR DELETING CSS_SO_WEB_EVENT   **'   
A37666             DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
A37666             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A37666             DISPLAY '**  PROCESSING TERMINATED             **'   
A37666             DISPLAY '****************************************'   
A37666             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A37666     END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_SO_DATA                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_SO_DATA        **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'SO106'                             
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(8:2) TO WS-MONTHS-COUNT                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'SO106'                             
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(14:3) TO WS-COMMIT-COUNT-CHAR           
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO106 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
