       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO105.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. DAVID BOWDEN.                                            
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00090000
      ******************************************************************00240000
      ** PURPOSE :                                                    **        
      **     EXTRACT METER READ SERVICE ORDERS FROM DB2 AND PUT THEM  **        
      **     INTO A FLAT FILE TO BE PROCESSED IN A SKIP ROUTE         **        
      **                                                              **        
      ******************************************************************00320000
      ******************************************************************00100000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *   DATE          INITIALS    REASON                             *00130000
      *   2007-07-30    DB18339     NEW PROGRAM                        *        
      *   2008-03-26    DB18339     ADDED WORK AREA CHANGE LOG         *        
C37154*   2008-05-29    DB18339     ADDED READ BEFORE CHECK            *        
C37181*   2008-06-17    DB18339     ADDED EXISTING DNP CHECK           *        
      *   2008-09-08    DB18339     ADDED EXIST CHECK TO SO_UTL_CHG    *        
      *   2008-11-03    DB18339     CHANGED OUTPUT FILE FOR INTEGRATOR *        
      *                             TO PRE-ALLOCATED INSTEAD OF GTG    *        
A03152*   2011-02-23    DB18339     ADD CANCELLATION OF CAD WHEN ORDER *        
A03152*                             SENT TO AROP                       *        
A04684*   2013-05-15    DB18339     ADD READ CHECK FOR NON-AROP RDO    *        
A04684*                             ORDERS; WILL BE PLACED IN OORRSCEG *        
A04684*   2014-06-05    VV90387     SEND CANCEL TRANSACTION TO CLICK   *        
A04684*                             IF AROP WORK AREA                  *        
A04684*   2014-08-19    DB18339     REMOVED METERS NOW FILTERED FROM   *        
A04684*                             AMR CHECK IN PARA 7550             *        
A05020*   2015-02-05    DB18339     REMOVED PRINTED_IND FILTER FROM    *        
A05020*                             MAIN CURSOR.                       *        
A05189*   2015-02-25    DB18339     ADDING PROCESSING FOR ORDERS       *        
A05189*                             ALREADY SET TO AROP AT CREATION    *        
A05189*   2015-05-01    DB18339     CHANGED 7450 TO ALSO LOOK FOR TASK *        
A05189*                             STATUS = 'R'                       *        
      ******************************************************************00221000
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSSO105-FILE ASSIGN  UT-S-FCSSO105                  
                   FILE STATUS IS WS-FSO105-STATUS.                     
A05189      SELECT FCSS105B-FILE ASSIGN  UT-S-FCSS105B                  
A05189             FILE STATUS IS WS-FSO105B-STATUS.                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSSO105-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSO105                           PIC X(133).                 
A05189 FD  FCSS105B-FILE                                                
A05189     BLOCK CONTAINS  0 RECORDS                                    
A05189     RECORDING MODE  IS F                                         
A05189     LABEL RECORDS   ARE STANDARD.                                
A05189 01  FSO105B.                                                     
A05189   05 E-FSO105B-REC.                                              
A05189      10 E-FSO105B-DAT                PIC X(80).                  
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO105'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)  VALUE            
           'WORKING STORAGE FOR PCSSO105 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
A05189     05 WS-RETURN-CODE                PIC 9(01) VALUE 0.          
           05 WS-WORK-AREA-ID               PIC X(08).                  
           05 WS-TIME                       PIC X(26).                  
           05 WS-ASSIGNED-DATE              PIC X(10).                  
           05 WS-PROCESS-DATE               PIC X(10).                  
           05 WS-DATE-TODAY                 PIC X(10).                  
A04684     05 WS-DATE-TODAY-TS              PIC X(26).                  
A04684     05 WS-DATE-TODAY-TS1   REDEFINES WS-DATE-TODAY-TS.           
A04684        10 WS-TODAY-TS1               PIC X(10).                  
A04684        10 WS-TODAY-TS2               PIC X(16).                  
A04684     05 WS-DATE-YEST                  PIC X(10).                  
A04684     05 WS-LAST-BUSINESS-DAY          PIC S9(4) COMP VALUE 0.     
A04684     05 WS-OUTPUT-DATE-1416           PIC X(26).                  
           05 WS-OPTIMUM-DATE               PIC X(10).                  
           05 WS-DATE-PRIOR                 PIC X(10).                  
           05 WS-DATE-AFTER                 PIC X(10).                  
           05 WS-ORDER-TYPE                 PIC X(03).                  
           05 WS-SERV-ORDER-NO              PIC X(13).                  
           05 WS-PRINT-ROWS                 PIC 9(09).                  
           05 WS-RECORD-COUNT               PIC 9(09).                  
A05189     05 WS-ORDER-STATE-CD             PIC X(01) VALUE 'H'.        
A05189     05 WS-REMOVE-AROP-IND            PIC X(01) VALUE 'N'.        
A05189     05 WS-CLICK-STATUS               PIC X(01) VALUE 'N'.        
           05 WS-NULL-IND1                  PIC S9(04) COMP VALUE 0.    
                                                                        
       01  WS-MISC-2.                                                   
           05 WS-PGRMNAME                  PIC X(10)  VALUE 'PCSSO105'. 
           05 PROGRAM-NAME                 PIC X(08)  VALUE 'PCSSO105'. 
           05 WS-COMMON                    PIC X(10)  VALUE 'COMMON  '. 
           05 WS-DISPLAY-SQLCODE           PIC -(8)9.                   
           05 WS-FSO105-STATUS             PIC X(02)  VALUE '00'.       
              88  WS-FSO105-SUCCESSFUL               VALUE '00'.        
A05189     05 WS-FSO105B-STATUS            PIC X(02)  VALUE '00'.       
A05189        88  WS-FSO105B-SUCCESSFUL               VALUE '00'.       
           05 WS-01                         PIC X(02)  VALUE '01'.      
           05 WS-26                         PIC X(02)  VALUE '26'.      
           05 WS-811                        PIC S9(9)  VALUE -811 COMP. 
           05 WS-OPT-RANGE-FL               PIC X(01)  VALUE ' '.       
           05 WS-OPT-DT-EXISTS              PIC X(01)  VALUE ' '.       
           05 WS-LIGHT-IND                  PIC X(01)  VALUE ' '.       
           05 WS-WORK-ORDER-IND             PIC X(01)  VALUE ' '.       
           05 WS-REMOTE-READ-IND            PIC X(01)  VALUE ' '.       
           05 WS-RLSE-INFO-REQ              PIC X(01)  VALUE ' '.       
C37154     05 WS-READ-EXISTS                PIC X(01)  VALUE ' '.       
C37154     05 WS-BAD-READ                   PIC X(01)  VALUE ' '.       
C37181     05 WS-DNP-EXISTS                 PIC X(01)  VALUE ' '.       
A03152     05 WS-CAD-EXISTS                 PIC X(01)  VALUE ' '.       
           05 WS-COMMENTS                   PIC X(210) VALUE ' '.       
           05 WS-COMMENT2                   PIC X(210) VALUE ' '.       
           05 WS-WA-COMMENTS                PIC X(75)  VALUE ' '.       
           05 WS-APPL-PGM-ID                PIC X(04)  VALUE ' '.       
           05 WS-Y                          PIC X(01)  VALUE 'Y'.       
           05 WS-N                          PIC X(01)  VALUE 'N'.       
           05 WS-ROW-COUNT                  PIC S9(09) COMP VALUE 0.    
           05 WS-COMMIT-COUNT-CHAR          PIC X(03) VALUE ZEROES.     
           05 WS-COMMIT-COUNT REDEFINES WS-COMMIT-COUNT-CHAR PIC 9(3).  
           05 WS-COUNT-TO-COMMIT            PIC S9(09) COMP VALUE 0.    
                                                                        
       01  CSR04251-RETURN-DATA.                                        
           03  RETURN-CODE-4251         PIC S9(9) COMP VALUE 0.         
           03  OLD-WORK-AREA-4251       PIC X(12) VALUE SPACES.         
           03  OLD-WORK-AREA-TX-4251    PIC X(40) VALUE SPACES.         
           03  NEW-WORK-AREA-4251       PIC X(12) VALUE SPACES.         
           03  LOCAL-OFFICE-4251        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4251      PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4251        PIC X(03) VALUE SPACES.         
           03  CRAWL-IND-4251           PIC X(01) VALUE SPACES.         
           03  METER-IND-4251           PIC X(01) VALUE SPACES.         
           03  ZIP-CODE-4251            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-4251          PIC X(04) VALUE SPACES.         
           03  POINT-ID-4251            PIC X(10) VALUE SPACES.         
           03  BUSINESS-UNIT-4251       PIC X(03) VALUE SPACES.         
                                                                        
      ******************************************************************        
      *     WORKING STORAGE FOR FILE VARIABLES                         *        
      ******************************************************************        
       01 WS-DETAIL-LINE.                                               
          05 WS-DETAIL-LINE1.                                           
             10 E-ACCOUNT-NO                PIC X(13).                  
             10 E-SERV-ORDER-NO             PIC X(13).                  
             10 E-COMPANY-NO                PIC X(02).                  
             10 E-LOCAL-OFFICE              PIC X(03).                  
             10 E-READ-CYCLE                PIC X(02).                  
             10 E-READ-ROUTE                PIC X(04).                  
                                                                        
A05189 01 WS-DETAIL-ERROR.                                              
A05189    05 WS-DETAIL-ERROR1.                                          
A05189       10 E-SERV-ORDER-NO-2           PIC X(13).                  
A05189       10 E-SPACES                    PIC X(67) VALUE SPACES.     
                                                                        
       01  WS-BLANK-LINE                    PIC X(133) VALUE SPACES.    
                                                                        
       COPY CWS00038.                                                   01270000
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
       COPY FIOJC01.                                                    01300000
                                                                        
      ***************************************************************** 01320000
      * SQL COMMUNICATION AREA                                        * 01330000
      ***************************************************************** 01320000
           EXEC SQL                                                     01350000
                INCLUDE SQLCA                                           01360000
           END-EXEC.                                                    01370000
                                                                        
      ***************************************************************** 01320000
      * CSS_MODEL_SQL      (PREFIX = MS)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_COMPANY        (PREFIX = C7)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_ACCOUNT        (PREFIX = AT)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_JOB_PARM       (PREFIX = G6)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_LOCAL_OFFICE   (PREFIX = B1)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_MTRD_ENVRNMT   (PREFIX = MN)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_PRINT_LOC   (PREFIX = C4)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOLOC                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_CAD_CNTL    (PREFIX = C6)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCDCNT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_ORDER_INST  (PREFIX = VI)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_PRINT_QUEUE (PREFIX = VP)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOPRT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_CAD_QUEUE   (PREFIX = QP)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCADPQU                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_DATA        (PREFIX = VO)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_APPLIANCE   (PREFIX = VQ)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOEQP                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_AROP (PREFIX = MB)                                     *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOAROP                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_UTIL_ENVRNMT (PREFIX = UT)                                          
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_WORK_TYPE      (PREFIX = L4)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBWKTYP                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_READ_WINDOW    (PREFIX = RW)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_WORK_AREA (PREFIX = I2)                                   *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE STBWKAR                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_ROUTE_REPORT (PREFIX = PW)                                *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
                                                                        
A04684***************************************************************** 01320000
A04684* CSS_OFFCYCLE_READS (PREFIX = 3B)                              *         
A04684***************************************************************** 01320000
A04684     EXEC SQL                                                             
A04684         INCLUDE TBOFFCYR                                                 
A04684     END-EXEC.                                                            
                                                                        
A05189***************************************************************** 01320000
A05189* CSS_SO_TASK_QUEUE  (PREFIX = TQ)                              *         
A05189***************************************************************** 01320000
A05189     EXEC SQL                                                             
A05189         INCLUDE TBTSKQUE                                                 
A05189     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR DECLARATIONS                                           *         
      *****************************************************************         
           EXEC SQL                                                     
               DECLARE AROP-CUR CURSOR WITH HOLD FOR                    
                SELECT VO.SERV_ORDER_NO,                                
                   VO.ACCOUNT_NO,                                       
                   VO.ACCOUNT_NO_PRIOR,                                 
C37181             VO.PREMISE_NO,                                       
                   VO.COMPANY_NO,                                       
                   VO.LOCAL_OFFICE,                                     
                   VO.WORK_AREA_ID,                                     
                   I2.WORK_AREA_TX,                                     
                   B1.AROP_EXTRACT_CD,                                  
                   B1.AROP_DAYS_PRIOR,                                  
                   B1.AROP_DAYS_AFTER,                                  
                   CAST(CAST(VO.ASSIGNED_DATETIME AS DATE)
            AS CHAR(10)) AS ASSIGNED_DATE    
                                                                        
                FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
                                                                        
                INNER JOIN CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                ON VO.ACCOUNT_NO_PRIOR = AT.ACCOUNT_NO                  
                                                                        
                INNER JOIN CSS_COMPANY C7 WITH(READUNCOMMITTED)                 
                ON VO.COMPANY_NO = C7.COMPANY_NO                        
                                                                        
                INNER JOIN CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)            
                ON B1.COMPANY_NO = VO.COMPANY_NO                        
                AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                   
                                                                        
                INNER JOIN CSS_WORK_AREA I2 WITH(READUNCOMMITTED)               
                ON I2.COMPANY_NO = VO.COMPANY_NO                        
                AND I2.WORK_AREA_ID = VO.WORK_AREA_ID                   
                                                                        
                WHERE CAST(VO.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-TODAY
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TODAY
              ) <> 0) OR (LEN(:WS-DATE-TODAY) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TODAY
              ), CONVERT(DATE, :WS-DATE-TODAY) )      
                  AND VO.ORDER_STATE_CD = 'A'                           
                  AND VO.BACK_DATED_IND IN (' ','N')                    
A05020*           AND VO.PRINTED_IND = 'N'                                      
                  AND C7.AROP_EXTRACT_FL = 'Y'                          
                  AND VO.ASSIGNED_DATETIME IS NOT NULL                  
                  AND EXISTS (SELECT * FROM CSS_SO_ORDER_INST VI
                           WITH(READUNCOMMITTED)        
                      WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO)        
                  AND EXISTS (SELECT * FROM CSS_SO_UTL_CHG VE
                           WITH(READUNCOMMITTED)           
                      WHERE VO.SERV_ORDER_NO = VE.SERV_ORDER_NO)        
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AROP-CUR CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT VO.SERV_ORDER_NO,                                        
MFA-TR*            VO.ACCOUNT_NO,                                               
MFA-TR*            VO.ACCOUNT_NO_PRIOR,                                         
MFA-TR*            VO.PREMISE_NO,                                               
MFA-TR*            VO.COMPANY_NO,                                               
MFA-TR*            VO.LOCAL_OFFICE,                                             
MFA-TR*            VO.WORK_AREA_ID,                                             
MFA-TR*            I2.WORK_AREA_TX,                                             
MFA-TR*            B1.AROP_EXTRACT_CD,                                          
MFA-TR*            B1.AROP_DAYS_PRIOR,                                          
MFA-TR*            B1.AROP_DAYS_AFTER,                                          
MFA-TR*            CHAR(DATE(VO.ASSIGNED_DATETIME)) AS ASSIGNED_DATE            
MFA-TR*                                                                         
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_ACCOUNT AT                                       
MFA-TR*         ON VO.ACCOUNT_NO_PRIOR = AT.ACCOUNT_NO                          
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_COMPANY C7                                       
MFA-TR*         ON VO.COMPANY_NO = C7.COMPANY_NO                                
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_LOCAL_OFFICE B1                                  
MFA-TR*         ON B1.COMPANY_NO = VO.COMPANY_NO                                
MFA-TR*         AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                           
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_WORK_AREA I2                                     
MFA-TR*         ON I2.COMPANY_NO = VO.COMPANY_NO                                
MFA-TR*         AND I2.WORK_AREA_ID = VO.WORK_AREA_ID                           
MFA-TR*                                                                         
MFA-TR*         WHERE DATE(VO.ASSIGNED_DATETIME) <= :WS-DATE-TODAY              
MFA-TR*           AND VO.ORDER_STATE_CD = 'A'                                   
MFA-TR*           AND VO.BACK_DATED_IND IN (' ','N')                            
MFA-TR*           AND VO.PRINTED_IND = 'N'                                      
MFA-TR*           AND C7.AROP_EXTRACT_FL = 'Y'                                  
MFA-TR*           AND VO.ASSIGNED_DATETIME IS NOT NULL                          
MFA-TR*           AND EXISTS (SELECT * FROM CSS_SO_ORDER_INST VI                
MFA-TR*               WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO)                
MFA-TR*           AND EXISTS (SELECT * FROM CSS_SO_UTL_CHG VE                   
MFA-TR*               WHERE VO.SERV_ORDER_NO = VE.SERV_ORDER_NO)                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE ORDER-CUR CURSOR WITH HOLD FOR                   
                SELECT METER_NO,                                        
                       CODE_UTIL_TYPE,                                  
                       IC_NO                                            
                FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND VI.WORK_TYPE_CD <> '   '                          
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ORDER-CUR CURSOR WITH HOLD FOR                           
MFA-TR*         SELECT METER_NO,                                                
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO                                                    
MFA-TR*         FROM CSS_SO_ORDER_INST VI                                       
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND VI.WORK_TYPE_CD <> '   '                                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
A05189     EXEC SQL                                                     
A05189         DECLARE AROP-NEW-CUR CURSOR WITH HOLD FOR                
A05189          SELECT VO.SERV_ORDER_NO,                                
A05189             VO.ACCOUNT_NO,                                       
A05189             VO.ACCOUNT_NO_PRIOR,                                 
A05189             VO.PREMISE_NO,                                       
A05189             VO.COMPANY_NO,                                       
A05189             VO.LOCAL_OFFICE,                                     
A05189             VO.WORK_AREA_ID,                                     
A05189             I2.WORK_AREA_TX,                                     
A05189             B1.AROP_EXTRACT_CD,                                  
A05189             B1.AROP_DAYS_PRIOR,                                  
A05189             B1.AROP_DAYS_AFTER,                                  
A05189             CAST(CAST(VO.ASSIGNED_DATETIME AS DATE)
            AS CHAR(10)) AS ASSIGNED_DATE    
A05189                                                                  
A05189          FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
A05189                                                                  
A05189          INNER JOIN CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
A05189          ON VO.ACCOUNT_NO_PRIOR = AT.ACCOUNT_NO                  
A05189                                                                  
A05189          INNER JOIN CSS_COMPANY C7 WITH(READUNCOMMITTED)                 
A05189          ON VO.COMPANY_NO = C7.COMPANY_NO                        
A05189                                                                  
A05189          INNER JOIN CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)            
A05189          ON B1.COMPANY_NO = VO.COMPANY_NO                        
A05189          AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                   
A05189                                                                  
A05189          INNER JOIN CSS_WORK_AREA I2 WITH(READUNCOMMITTED)               
A05189          ON I2.COMPANY_NO = VO.COMPANY_NO                        
A05189          AND I2.WORK_AREA_ID = VO.WORK_AREA_ID                   
A05189                                                                  
A05189          WHERE CAST(VO.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-TODAY
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TODAY
              ) <> 0) OR (LEN(:WS-DATE-TODAY) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TODAY
              ), CONVERT(DATE, :WS-DATE-TODAY) )      
A05189            AND VO.WORK_AREA_ID IN ('AROPSCEG', 'AROPPSNC')       
A05189            AND VO.ORDER_STATE_CD = 'H'                           
A05189            AND VO.ASSIGNED_DATETIME IS NOT NULL                  
A05189            AND EXISTS (SELECT * FROM CSS_SO_ORDER_INST VI
                           WITH(READUNCOMMITTED)        
A05189                WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO)        
A05189            AND EXISTS (SELECT * FROM CSS_SO_UTL_CHG VE
                           WITH(READUNCOMMITTED)           
A05189                WHERE VO.SERV_ORDER_NO = VE.SERV_ORDER_NO)        
A05189            AND NOT EXISTS (SELECT * FROM CSS_SO_AROP MB
                           WITH(READUNCOMMITTED)          
A05189                WHERE VO.SERV_ORDER_NO = MB.SERV_ORDER_NO)        
A05189            FOR READ ONLY                                 
A05189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AROP-NEW-CUR CURSOR WITH HOLD FOR                        
MFA-TR*         SELECT VO.SERV_ORDER_NO,                                        
MFA-TR*            VO.ACCOUNT_NO,                                               
MFA-TR*            VO.ACCOUNT_NO_PRIOR,                                         
MFA-TR*            VO.PREMISE_NO,                                               
MFA-TR*            VO.COMPANY_NO,                                               
MFA-TR*            VO.LOCAL_OFFICE,                                             
MFA-TR*            VO.WORK_AREA_ID,                                             
MFA-TR*            I2.WORK_AREA_TX,                                             
MFA-TR*            B1.AROP_EXTRACT_CD,                                          
MFA-TR*            B1.AROP_DAYS_PRIOR,                                          
MFA-TR*            B1.AROP_DAYS_AFTER,                                          
MFA-TR*            CHAR(DATE(VO.ASSIGNED_DATETIME)) AS ASSIGNED_DATE            
MFA-TR*                                                                         
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_ACCOUNT AT                                       
MFA-TR*         ON VO.ACCOUNT_NO_PRIOR = AT.ACCOUNT_NO                          
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_COMPANY C7                                       
MFA-TR*         ON VO.COMPANY_NO = C7.COMPANY_NO                                
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_LOCAL_OFFICE B1                                  
MFA-TR*         ON B1.COMPANY_NO = VO.COMPANY_NO                                
MFA-TR*         AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                           
MFA-TR*                                                                         
MFA-TR*         INNER JOIN CSS_WORK_AREA I2                                     
MFA-TR*         ON I2.COMPANY_NO = VO.COMPANY_NO                                
MFA-TR*         AND I2.WORK_AREA_ID = VO.WORK_AREA_ID                           
MFA-TR*                                                                         
MFA-TR*         WHERE DATE(VO.ASSIGNED_DATETIME) <= :WS-DATE-TODAY              
MFA-TR*           AND VO.WORK_AREA_ID IN ('AROPSCEG', 'AROPPSNC')               
MFA-TR*           AND VO.ORDER_STATE_CD = 'H'                                   
MFA-TR*           AND VO.ASSIGNED_DATETIME IS NOT NULL                          
MFA-TR*           AND EXISTS (SELECT * FROM CSS_SO_ORDER_INST VI                
MFA-TR*               WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO)                
MFA-TR*           AND EXISTS (SELECT * FROM CSS_SO_UTL_CHG VE                   
MFA-TR*               WHERE VO.SERV_ORDER_NO = VE.SERV_ORDER_NO)                
MFA-TR*           AND NOT EXISTS (SELECT * FROM CSS_SO_AROP MB                  
MFA-TR*               WHERE VO.SERV_ORDER_NO = MB.SERV_ORDER_NO)                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                           PIC X(40) VALUE             
          'WORKING STORAGE FOR PCSSO105 ENDS HERE  '.                   
                                                                        
A04684*01  LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
A05189*01  LOC4251 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4251 CURSOR
MSQ001          FOR CALL CSR04251                                             
A05189             ( :VO-SERV-ORDER-NO
                  , 'N'
                  , 'SYSTEM'
                  , 'AROP'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416 ( :WS-DATE-TODAY-TS
                  , :WS-LAST-BUSINESS-DAY
                  )
MSQ001        END-EXEC.
        
                                                                        
      ******************************************************************02630000
      *   0000-MAINLINE.                                               *02650000
      *        CONTROLS MAIN PATH OF PROGRAM                           *02660000
      ******************************************************************02630000
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           IF WS-COMMIT-COUNT-CHAR NOT NUMERIC                          
               MOVE '20' TO WS-COMMIT-COUNT-CHAR
           END-IF.                       
                                                                        
           PERFORM 1000-INITIALIZATION     THRU 1000-EXIT.              
                                                                        
           PERFORM 2000-MAIN-PROCESS       THRU 2000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    1000-INITIALIZATION.                                        *03000000
      *         GETS JOB PARM DATE AND OPENS FCSSO105 FILES            *03010000
      ******************************************************************02630000
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: ' PROGRAM-NAME.                    
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN EXTEND FCSSO105-FILE.                                   
                                                                        
           IF WS-FSO105-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSSO105 PROCESSING ERROR         **'   
              DISPLAY '     OPEN ERROR OF FCSSO105 OUTPUT FILE '        
              DISPLAY '     FILE STATUS = ' WS-FSO105-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
A05189     OPEN EXTEND FCSS105B-FILE.                                   
A05189                                                                  
A05189     IF WS-FSO105B-SUCCESSFUL                                     
A05189        CONTINUE                                                  
A05189     ELSE                                                         
A05189        DISPLAY ' '                                               
A05189        DISPLAY '**       PCSSO105 PROCESSING ERROR         **'   
A05189        DISPLAY '     OPEN ERROR OF FCSS105B OUTPUT FILE '        
A05189        DISPLAY '     FILE STATUS = ' WS-FSO105B-STATUS           
A05189        DISPLAY '**         PROCESSING TERMINATED           **'   
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
                                                                        
           INITIALIZE WS-MISC.                                          
                                                                        
           PERFORM 7500-GET-TIMESTAMP      THRU 7500-EXIT.              
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
           IF COMMON-DATE-NEEDED                                        
              MOVE 'SO102'                 TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE              TO WS-DATE-TODAY             
                                              WS-PROCESS-DATE.          
                                                                        
A04684     MOVE WS-DATE-TODAY              TO WS-TODAY-TS1.             
A04684     MOVE '-00.00.00.000000'         TO WS-TODAY-TS2.             
A04684     MOVE -1                         TO WS-LAST-BUSINESS-DAY.     
A04684     PERFORM 8300-GET-LAST-BUSINESS-DAY THRU 8300-EXIT.           
                                                                        
A04684     MOVE WS-OUTPUT-DATE-1416(1:10)  TO WS-DATE-YEST.             
                                                                        
A04684*    EXEC SQL                                                             
A04684*        SET :WS-DATE-YEST = DATE(:WS-DATE-TODAY) - 1 DAYS                
A04684*    END-EXEC.                                                            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2000-MAIN-PROCESS                                           *03963003
      *         DETERMINES WEEKEND/HOLIDAY OR BUSINESS DAY PROCESSING  *03964003
      ******************************************************************02630000
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 2100-AROP-CUR-SELECT          THRU 2100-EXIT.        
           PERFORM 2500-AROP-NEW-CUR-SELECT      THRU 2500-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2100-AROP-CUR-SELECT                                        *03975505
      *    THIS RETRIEVES SO_DATA INFO FOR AMR ANALYSIS                *        
      ******************************************************************02630000
       2100-AROP-CUR-SELECT.                                            
                                                                        
A05189     MOVE 'N' TO WS-REMOVE-AROP-IND.                              
                                                                        
           PERFORM 7700-OPEN-AROP-CURSOR         THRU 7700-EXIT.        
                                                                        
           PERFORM 7725-FETCH-AROP-CURSOR        THRU 7725-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
             MOVE 'Y' TO WS-WORK-ORDER-IND                              
             PERFORM 7850-WORK-ORDER-CHECK       THRU 7850-EXIT         
             IF WS-WORK-ORDER-IND = 'Y'                                 
                MOVE 'N' TO WS-LIGHT-IND                                
                MOVE 'N' TO WS-RLSE-INFO-REQ                            
                PERFORM 7800-SO-APPL-CHECK          THRU 7800-EXIT      
A05189          PERFORM 7875-VALIDATE-RLSE-INFO     THRU 7875-EXIT      
                IF WS-LIGHT-IND = 'N' AND WS-RLSE-INFO-REQ = 'N'        
                                                                        
A04684            IF B1-AROP-EXTRACT-CD = 'N' AND VO-COMPANY-NO = '01'  
A04684               PERFORM 2200-OOC-FILE-SELECT   THRU 2200-EXIT      
A04684            END-IF                                                
                                                                        
                  EXEC SQL                                              
                   SELECT
              DATEADD( DAY, -:B1-AROP-DAYS-PRIOR, IIF(TRY_CONVERT(DATE, 
                                                      :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ) )
            INTO
              :WS-DATE-PRIOR             
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*           EXEC SQL                                                      
MFA-TR*            SET :WS-DATE-PRIOR = DATE(:WS-ASSIGNED-DATE) -               
MFA-TR*                            :B1-AROP-DAYS-PRIOR DAYS                     
MFA-TR*           END-EXEC                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                  EXEC SQL                                              
                   SELECT
              DATEADD( DAY, :B1-AROP-DAYS-AFTER, IIF(TRY_CONVERT(DATE, 
                                                      :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ) )
            INTO
              :WS-DATE-AFTER             
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*           EXEC SQL                                                      
MFA-TR*            SET :WS-DATE-AFTER = DATE(:WS-ASSIGNED-DATE) +               
MFA-TR*                            :B1-AROP-DAYS-AFTER DAYS                     
MFA-TR*           END-EXEC                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                  MOVE 'Y' TO WS-OPT-DT-EXISTS                          
                  PERFORM 7525-GET-OPTIMUM-DATE       THRU 7525-EXIT    
                  IF WS-OPT-DT-EXISTS = 'Y'                             
                    MOVE RW-OPTIMUM-READ-DATE TO WS-OPTIMUM-DATE        
                    IF WS-DATE-PRIOR <= WS-OPTIMUM-DATE AND             
                     WS-DATE-AFTER  >= WS-OPTIMUM-DATE                  
                     MOVE 'Y' TO WS-OPT-RANGE-FL                        
                    END-IF                                              
                                                                        
C37154              MOVE 'N' TO WS-READ-EXISTS                          
C37154              MOVE 'N' TO WS-BAD-READ                             
C37154              PERFORM 2300-CHECK-READS     THRU 2300-EXIT         
                   IF WS-OPT-RANGE-FL = 'Y'                             
C37154               IF WS-READ-EXISTS = 'N'                            
C37181                PERFORM 2400-CHECK-DNP     THRU 2400-EXIT         
C37181                IF WS-DNP-EXISTS = 'N'                            
                       MOVE 'AROP' TO WS-APPL-PGM-ID                    
                       MOVE 'HOLD FOR AROP IN CYCLE - ORIG WORK AREA: ' 
                                                     TO WS-WA-COMMENTS  
                       PERFORM 8250-SO-REMARKS     THRU 8250-EXIT       
                       IF VO-COMPANY-NO = '01'                          
                        MOVE 'AROPSCEG' TO VO-WORK-AREA-ID              
                       ELSE                                             
                        MOVE 'AROPPSNC' TO VO-WORK-AREA-ID              
                       END-IF                                           
A05189                 PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT     
                       PERFORM 8000-UPDATE-SO-DATA THRU 8000-EXIT       
                       PERFORM 8200-SO-UPDATE      THRU 8200-EXIT       
                       PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT       
C37181                END-IF                                            
C37154               END-IF                                             
                   ELSE                                                 
C37154               MOVE 'N' TO WS-BAD-READ                            
C37154               PERFORM 7250-BAD-READ-CHECK THRU 7250-EXIT         
C37154               IF WS-BAD-READ = 'N'                               
                      PERFORM 2200-OOC-FILE-SELECT THRU 2200-EXIT       
C37154               END-IF                                             
                   END-IF                                               
                  END-IF                                                
                END-IF                                                  
             END-IF                                                     
             PERFORM 7725-FETCH-AROP-CURSOR    THRU 7725-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7750-CLOSE-AROP-CURSOR      THRU 7750-EXIT.          
                                                                        
A05189*    MOVE '9999999999999'    TO E-ACCOUNT-NO.                             
A05189*    MOVE WS-DATE-TODAY      TO E-SERV-ORDER-NO.                          
A05189*    MOVE SPACES             TO E-COMPANY-NO.                             
A05189*    MOVE SPACES             TO E-LOCAL-OFFICE.                           
A05189*    MOVE SPACES             TO E-READ-CYCLE.                             
A05189*    MOVE SPACES             TO E-READ-ROUTE.                             
A05189*    WRITE FSO105            FROM WS-DETAIL-LINE1.                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2200-OOC-FILE-SELECT                                        *03975505
      *    THIS RETRIEVES ACCOUNT NUMBERS FOR OUT OF CYCLE FILE        *        
      ******************************************************************02630000
       2200-OOC-FILE-SELECT.                                            
                                                                        
A04684     MOVE 'Y' TO WS-REMOTE-READ-IND                               
A04684     PERFORM 7550-AMR-CHECK  THRU 7550-EXIT                       
A04684     IF WS-REMOTE-READ-IND = 'Y'                                  
             IF B1-AROP-EXTRACT-CD = 'B'                                
C37181          PERFORM 2400-CHECK-DNP     THRU 2400-EXIT               
C37181          IF WS-DNP-EXISTS = 'N'                                  
                 MOVE VO-ACCOUNT-NO-PRIOR  TO E-ACCOUNT-NO              
                 MOVE VO-SERV-ORDER-NO     TO E-SERV-ORDER-NO           
                 MOVE VO-COMPANY-NO        TO E-COMPANY-NO              
                 MOVE VO-LOCAL-OFFICE      TO E-LOCAL-OFFICE            
                 MOVE UT-READ-CYCLE        TO E-READ-CYCLE              
                 MOVE UT-READ-ROUTE        TO E-READ-ROUTE              
                 WRITE FSO105            FROM WS-DETAIL-LINE1           
                 MOVE 'AROO' TO WS-APPL-PGM-ID                          
                 MOVE 'HOLD FOR AROP OUT OF CYCLE - ORIG WORK AREA: '   
                                                   TO WS-WA-COMMENTS    
                 PERFORM 8250-SO-REMARKS     THRU 8250-EXIT             
                 IF VO-COMPANY-NO = '01'                                
                  MOVE 'AROCSCEG' TO VO-WORK-AREA-ID                    
                 ELSE                                                   
                  MOVE 'AROCPSNC' TO VO-WORK-AREA-ID                    
                 END-IF                                                 
A05189           PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT           
                 PERFORM 8000-UPDATE-SO-DATA THRU 8000-EXIT             
                 PERFORM 8200-SO-UPDATE      THRU 8200-EXIT             
                 PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT             
C37181          END-IF                                                  
A04684* NEXT SECTION CHECKS FOR READS IN OFFCYCLE TABLE                         
A04684* FOR NON-OOC AND NON-AROP LOCAL OFFICES                                  
A04684       ELSE                                                       
A04684        IF VO-COMPANY-NO = '01'                                   
A04684          PERFORM 2400-CHECK-DNP     THRU 2400-EXIT               
A04684          IF WS-DNP-EXISTS = 'N'                                  
A04684           MOVE 'N' TO WS-READ-EXISTS                             
A04684           PERFORM 2350-CHECK-OFFCYCLE-READS THRU 2350-EXIT       
A04684           IF WS-READ-EXISTS = 'Y'                                
A04684            MOVE VO-ACCOUNT-NO-PRIOR  TO E-ACCOUNT-NO             
A04684            MOVE VO-SERV-ORDER-NO     TO E-SERV-ORDER-NO          
A04684            MOVE VO-COMPANY-NO        TO E-COMPANY-NO             
A04684            MOVE VO-LOCAL-OFFICE      TO E-LOCAL-OFFICE           
A04684            MOVE UT-READ-CYCLE        TO E-READ-CYCLE             
A04684            MOVE UT-READ-ROUTE        TO E-READ-ROUTE             
A04684            WRITE FSO105            FROM WS-DETAIL-LINE1          
A04684            MOVE 'AROO' TO WS-APPL-PGM-ID                         
A04684            MOVE 'HOLD FOR OFFCYCLE READ CHECK - ORIG WORK AREA: '
A04684                                              TO WS-WA-COMMENTS   
A04684            PERFORM 8250-SO-REMARKS     THRU 8250-EXIT            
A04684            MOVE 'OORRSCEG' TO VO-WORK-AREA-ID                    
A05189            PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT          
A04684            PERFORM 8000-UPDATE-SO-DATA THRU 8000-EXIT            
A04684            PERFORM 8200-SO-UPDATE      THRU 8200-EXIT            
A04684            PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT            
A04684           END-IF                                                 
C37181          END-IF                                                  
A04684        END-IF                                                    
A04684       END-IF                                                     
A04684     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05189******************************************************************02630000
A05189*    2250-OOC-FOR-AROP-ORDERS.                                   *03975505
A05189*    DETERMINES IF EXISTING AROP ORDERS SHOULD BE AROP OOC.      *        
A05189******************************************************************02630000
A05189 2250-OOC-FOR-AROP-ORDERS.                                        
A05189                                                                  
A05189     MOVE 'Y' TO WS-REMOTE-READ-IND                               
A05189     PERFORM 7550-AMR-CHECK  THRU 7550-EXIT                       
A05189     IF WS-REMOTE-READ-IND = 'Y'                                  
A05189       IF B1-AROP-EXTRACT-CD = 'B'                                
A05189          PERFORM 2400-CHECK-DNP     THRU 2400-EXIT               
A05189          IF WS-DNP-EXISTS = 'N'                                  
A05189           MOVE VO-ACCOUNT-NO-PRIOR  TO E-ACCOUNT-NO              
A05189           MOVE VO-SERV-ORDER-NO     TO E-SERV-ORDER-NO           
A05189           MOVE VO-COMPANY-NO        TO E-COMPANY-NO              
A05189           MOVE VO-LOCAL-OFFICE      TO E-LOCAL-OFFICE            
A05189           MOVE UT-READ-CYCLE        TO E-READ-CYCLE              
A05189           MOVE UT-READ-ROUTE        TO E-READ-ROUTE              
A05189           WRITE FSO105              FROM WS-DETAIL-LINE1         
A05189           MOVE 'N'                  TO WS-REMOVE-AROP-IND        
A05189           MOVE 'AROO'               TO WS-APPL-PGM-ID            
A05189           MOVE 'AROP IN CYCLE'      TO I2-WORK-AREA-TX           
A05189           MOVE 'HOLD FOR AROP OUT OF CYCLE - ORIG WORK AREA: '   
A05189                                             TO WS-WA-COMMENTS    
A05189           PERFORM 8250-SO-REMARKS     THRU 8250-EXIT             
A05189           IF VO-COMPANY-NO = '01'                                
A05189            MOVE 'AROCSCEG' TO VO-WORK-AREA-ID                    
A05189           ELSE                                                   
A05189            MOVE 'AROCPSNC' TO VO-WORK-AREA-ID                    
A05189           END-IF                                                 
A05189           PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT           
A05189           PERFORM 8000-UPDATE-SO-DATA THRU 8000-EXIT             
A05189           PERFORM 8200-SO-UPDATE      THRU 8200-EXIT             
A05189           PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT             
A05189          ELSE                                                    
A05189           PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT           
A05189          END-IF                                                  
A05189* NEXT SECTION CHECKS FOR READS IN OFFCYCLE TABLE                 03976005
A05189* FOR NON-OOC AND NON-AROP LOCAL OFFICES                          03976005
A05189       ELSE                                                       
A05189        IF VO-COMPANY-NO = '01'                                   
A05189          PERFORM 2400-CHECK-DNP     THRU 2400-EXIT               
A05189          IF WS-DNP-EXISTS = 'N'                                  
A05189           MOVE 'N' TO WS-READ-EXISTS                             
A05189           PERFORM 2350-CHECK-OFFCYCLE-READS THRU 2350-EXIT       
A05189           IF WS-READ-EXISTS = 'Y'                                
A05189            MOVE VO-ACCOUNT-NO-PRIOR  TO E-ACCOUNT-NO             
A05189            MOVE VO-SERV-ORDER-NO     TO E-SERV-ORDER-NO          
A05189            MOVE VO-COMPANY-NO        TO E-COMPANY-NO             
A05189            MOVE VO-LOCAL-OFFICE      TO E-LOCAL-OFFICE           
A05189            MOVE UT-READ-CYCLE        TO E-READ-CYCLE             
A05189            MOVE UT-READ-ROUTE        TO E-READ-ROUTE             
A05189            WRITE FSO105              FROM WS-DETAIL-LINE1        
A05189            MOVE 'N'                  TO WS-REMOVE-AROP-IND       
A05189            MOVE 'AROO'               TO WS-APPL-PGM-ID           
A05189            MOVE 'AROP IN CYCLE'      TO I2-WORK-AREA-TX          
A05189            MOVE 'HOLD FOR OFFCYCLE READ CHECK - ORIG WORK AREA: '
A05189                                              TO WS-WA-COMMENTS   
A05189            PERFORM 8250-SO-REMARKS     THRU 8250-EXIT            
A05189            MOVE 'OORRSCEG' TO VO-WORK-AREA-ID                    
A05189            PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT          
A05189            PERFORM 8000-UPDATE-SO-DATA THRU 8000-EXIT            
A05189            PERFORM 8200-SO-UPDATE      THRU 8200-EXIT            
A05189            PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT            
A05189           ELSE                                                   
A05189            PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT          
A05189           END-IF                                                 
A05189          ELSE                                                    
A05189           PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT           
A05189          END-IF                                                  
A05189        ELSE                                                      
A05189         PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT             
A05189        END-IF                                                    
A05189       END-IF                                                     
A05189     END-IF.                                                      
A05189                                                                  
A05189 2250-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
C37154******************************************************************02630000
      *    2300-CHECK-READS                                            *03975505
      *    LOOPS THROUGH SO_ORDER_INST ROWS AND CHECKS ROUTE_REPORT    *        
      *    FOR GOOD READS WITH NO SUPERVISOR ESTIMATES IN CUR REV MONTH*        
      ******************************************************************02630000
       2300-CHECK-READS.                                                
                                                                        
           PERFORM 7100-OPEN-ORDER-CURSOR         THRU 7100-EXIT.       
           PERFORM 7125-FETCH-ORDER-CURSOR        THRU 7125-EXIT.       
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR       
             WS-READ-EXISTS = 'Y'                                       
             PERFORM 7200-VALID-READ-CHECK       THRU 7200-EXIT         
           END-PERFORM.                                                 
C37154     PERFORM 7150-CLOSE-ORDER-CURSOR       THRU 7150-EXIT.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04684******************************************************************02630000
A04684*    2350-CHECK-OFFCYCLE-READS                                   *03975505
A04684*    LOOPS THROUGH SO_ORDER_INST ROWS AND CHECKS OFFCYCLE_READS  *        
A04684*    ON EACH METER; LOOP STOPS IMMEDIATELY IF A READ IS NOT FOUND*        
A04684******************************************************************02630000
A04684 2350-CHECK-OFFCYCLE-READS.                                       
A04684                                                                  
A04684     PERFORM 7100-OPEN-ORDER-CURSOR         THRU 7100-EXIT.       
A04684     PERFORM 7135-FETCH-ORDER-CURSOR        THRU 7135-EXIT.       
A04684     PERFORM 2375-PROCESS-OFFCYCLE-READS    THRU 2375-EXIT        
A04684       UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
A04684     PERFORM 7150-CLOSE-ORDER-CURSOR        THRU 7150-EXIT.       
A04684                                                                  
A04684 2350-EXIT.                                                       
A04684     EXIT.                                                        
                                                                        
A04684******************************************************************02630000
A04684*    2375-PROCESS-OFFCYCLE-READS                                 *03975505
A04684*    LOOPS THROUGH SO_ORDER_INST ROWS AND CHECKS OFFCYCLE_READS  *        
A04684*    ON EACH METER; LOOP STOPS IMMEDIATELY IF A READ IS NOT FOUND*        
A04684******************************************************************02630000
A04684 2375-PROCESS-OFFCYCLE-READS.                                     
A04684                                                                  
A04684     PERFORM 7350-OFFCYCLE-READ-CHECK       THRU 7350-EXIT.       
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A04684        MOVE 'N' TO WS-READ-EXISTS                                
A04684        GO TO 2375-EXIT                                           
A04684     END-IF.                                                      
A04684     PERFORM 7135-FETCH-ORDER-CURSOR        THRU 7135-EXIT.       
A04684                                                                  
A04684 2375-EXIT.                                                       
A04684     EXIT.                                                        
                                                                        
C37181******************************************************************02630000
      *    2400-CHECK-DNP                                              *03975505
      *    CHECKS FOR DNP OR RECONNECT SERVICE ORDERS BY PREMISE NO    *        
      ******************************************************************02630000
       2400-CHECK-DNP.                                                  
                                                                        
           MOVE 'N' TO WS-DNP-EXISTS.                                   
           PERFORM 7300-CHECK-DNP-RECONN          THRU 7300-EXIT.       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05189******************************************************************02630000
A05189*    2500-AROP-NEW-CUR-SELECT                                    *03975505
A05189*    THIS RETRIEVES SO_DATA INFO WHERE AROP WORK AREA SELECTED   *        
A05189******************************************************************02630000
A05189 2500-AROP-NEW-CUR-SELECT.                                        
A05189                                                                  
A05189     PERFORM 7900-OPEN-AROP-NEW-CURSOR     THRU 7900-EXIT.        
A05189                                                                  
A05189     PERFORM 7925-FETCH-AROP-NEW-CURSOR    THRU 7925-EXIT.        
A05189                                                                  
A05189     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
A05189       MOVE 'Y' TO WS-WORK-ORDER-IND                              
A05189       PERFORM 7850-WORK-ORDER-CHECK       THRU 7850-EXIT         
A05189       IF WS-WORK-ORDER-IND = 'Y'                                 
A05189          MOVE 'N' TO WS-LIGHT-IND                                
A05189          MOVE 'N' TO WS-RLSE-INFO-REQ                            
A05189          PERFORM 7800-SO-APPL-CHECK          THRU 7800-EXIT      
A05189          PERFORM 7875-VALIDATE-RLSE-INFO     THRU 7875-EXIT      
A05189          IF WS-LIGHT-IND = 'N' AND WS-RLSE-INFO-REQ = 'N'        
A05189                                                                  
A05189            EXEC SQL                                              
A05189             SELECT
              DATEADD( DAY, -:B1-AROP-DAYS-PRIOR, IIF(TRY_CONVERT(DATE, 
                                                      :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ) )
            INTO
              :WS-DATE-PRIOR             
A05189            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*           EXEC SQL                                                      
MFA-TR*            SET :WS-DATE-PRIOR = DATE(:WS-ASSIGNED-DATE) -               
MFA-TR*                            :B1-AROP-DAYS-PRIOR DAYS                     
MFA-TR*           END-EXEC                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189            EXEC SQL                                              
A05189             SELECT
              DATEADD( DAY, :B1-AROP-DAYS-AFTER, IIF(TRY_CONVERT(DATE, 
                                                      :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ) )
            INTO
              :WS-DATE-AFTER             
A05189            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*           EXEC SQL                                                      
MFA-TR*            SET :WS-DATE-AFTER = DATE(:WS-ASSIGNED-DATE) +               
MFA-TR*                            :B1-AROP-DAYS-AFTER DAYS                     
MFA-TR*           END-EXEC                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189            MOVE 'Y' TO WS-OPT-DT-EXISTS                          
A05189            PERFORM 7525-GET-OPTIMUM-DATE       THRU 7525-EXIT    
A05189            IF WS-OPT-DT-EXISTS = 'Y'                             
A05189              MOVE RW-OPTIMUM-READ-DATE TO WS-OPTIMUM-DATE        
A05189              IF WS-DATE-PRIOR <= WS-OPTIMUM-DATE AND             
A05189               WS-DATE-AFTER  >= WS-OPTIMUM-DATE                  
A05189               MOVE 'Y' TO WS-OPT-RANGE-FL                        
A05189              END-IF                                              
A05189                                                                  
A05189              MOVE 'N' TO WS-READ-EXISTS                          
A05189              MOVE 'N' TO WS-BAD-READ                             
A05189              PERFORM 2300-CHECK-READS     THRU 2300-EXIT         
A05189              IF WS-OPT-RANGE-FL = 'Y'                            
A05189               IF WS-READ-EXISTS = 'N'                            
A05189                PERFORM 2400-CHECK-DNP     THRU 2400-EXIT         
A05189                IF WS-DNP-EXISTS = 'N'                            
A05189                 PERFORM 2700-CANCEL-CAD-CLICK THRU 2700-EXIT     
A05189                 PERFORM 8500-INSERT-SO-AROP THRU 8500-EXIT       
A05189                ELSE                                              
A05189                 PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT     
A05189                END-IF                                            
A05189               ELSE                                               
A05189                PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT      
A05189               END-IF                                             
A05189              ELSE                                                
A05189               MOVE 'N' TO WS-BAD-READ                            
A05189               PERFORM 7250-BAD-READ-CHECK THRU 7250-EXIT         
A05189               IF WS-BAD-READ = 'N'                               
A05189                PERFORM 2250-OOC-FOR-AROP-ORDERS THRU 2250-EXIT   
A05189               ELSE                                               
A05189                PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT      
A05189               END-IF                                             
A05189              END-IF                                              
A05189            END-IF                                                
A05189          END-IF                                                  
A05189       ELSE                                                       
A05189          PERFORM 2600-REMOVE-FROM-AROP THRU 2600-EXIT            
A05189       END-IF                                                     
A05189       PERFORM 7925-FETCH-AROP-NEW-CURSOR THRU 7925-EXIT          
A05189     END-PERFORM.                                                 
A05189                                                                  
A05189     PERFORM 7950-CLOSE-AROP-NEW-CURSOR  THRU 7950-EXIT.          
A05189                                                                  
A05189     MOVE '9999999999999'    TO E-ACCOUNT-NO.                     
A05189     MOVE WS-DATE-TODAY      TO E-SERV-ORDER-NO.                  
A05189     MOVE SPACES             TO E-COMPANY-NO.                     
A05189     MOVE SPACES             TO E-LOCAL-OFFICE.                   
A05189     MOVE SPACES             TO E-READ-CYCLE.                     
A05189     MOVE SPACES             TO E-READ-ROUTE.                     
A05189     WRITE FSO105            FROM WS-DETAIL-LINE1.                
A05189                                                                  
A05189     MOVE WS-DATE-TODAY      TO E-SERV-ORDER-NO-2.                
A05189     WRITE FSO105B           FROM WS-DETAIL-ERROR1.               
A05189                                                                  
A05189 2500-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
A05189******************************************************************02630000
A05189*    2600-REMOVE-FROM-AROP.                                      *03975505
A05189*    RECALCS WORK AREA AND ADDS REMARKS AND AUDIT INFO.          *        
A05189******************************************************************02630000
A05189 2600-REMOVE-FROM-AROP.                                           
A05189                                                                  
A05189     MOVE 'Y' TO WS-REMOVE-AROP-IND.                              
A05189                                                                  
A05189     PERFORM 7975-RECALC-WORK-AREA         THRU 7975-EXIT.        
A05189     MOVE NEW-WORK-AREA-4251               TO VO-WORK-AREA-ID.    
A05189     MOVE BUSINESS-UNIT-4251               TO VO-SO-BUSINESS-UNIT.
A05189     MOVE 'AROP'                           TO WS-APPL-PGM-ID.     
A05189     MOVE 'SET TO ACTIVE BY AROP - ORIG WORK AREA: '              
A05189                                           TO WS-WA-COMMENTS.     
A05189     MOVE 'AROP IN CYCLE'                  TO I2-WORK-AREA-TX.    
A05189     PERFORM 8250-SO-REMARKS               THRU 8250-EXIT.        
A05189     PERFORM 8000-UPDATE-SO-DATA           THRU 8000-EXIT.        
A05189     PERFORM 8200-SO-UPDATE                THRU 8200-EXIT.        
A05189                                                                  
A05189 2600-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
A05189******************************************************************02630000
A05189*    2700-CANCEL-CAD-CLICK.                                      *03975505
A05189*    SEND CANCELS TO CAD OR CLICK BECAUSE ORDER IS AROP.         *        
A05189******************************************************************02630000
A05189 2700-CANCEL-CAD-CLICK.                                           
A05189                                                                  
A05189     MOVE 'N' TO WS-CAD-EXISTS.                                   
A05189     MOVE 'N' TO WS-CLICK-STATUS.                                 
A05189     PERFORM 7400-CHECK-CAD-QUEUE THRU 7400-EXIT.                 
A05189     IF WS-CAD-EXISTS = 'Y'                                       
A05189        PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT             
A05189     ELSE                                                         
A05189        PERFORM 7450-CHECK-CLICK-TASK THRU 7450-EXIT              
A05189        IF WS-CLICK-STATUS = 'Y'                                  
A05189           PERFORM 8800-CLICK-CANCEL  THRU 8800-EXIT              
A05189           PERFORM 8810-CLICK-TASK    THRU 8810-EXIT              
A05189        END-IF                                                    
A05189     END-IF.                                                      
A05189                                                                  
A05189 2700-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
C37154******************************************************************08061003
      *   7100-OPEN-ORDER-CURSOR                                       *08063003
      *        OPENS THE ORDER-CUR CURSOR TO FETCH ROWS FROM ORDER_INST*08064003
      ******************************************************************08061003
C37154 7100-OPEN-ORDER-CURSOR.                                          
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN ORDER-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7100-OPEN-ORDER-CURSOR'      
              DISPLAY '**  OPEN AROP CURSOR'                            
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37154******************************************************************08061003
      *   7125-FETCH-ORDER-CURSOR                               *       08071703
      ******************************************************************08061003
                                                                        
C37154 7125-FETCH-ORDER-CURSOR.                                         
                                                                        
           MOVE '7125'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH ORDER-CUR                                           
               INTO :VI-METER-NO,                                       
                    :VI-CODE-UTIL-TYPE,                                 
                    :VI-IC-NO                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
A05189     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05189        WHEN SUCCESSFUL-CALL                                      
A05189            CONTINUE                                              
A05189        WHEN NOT-FOUND                                            
A05189            MOVE VO-SERV-ORDER-NO     TO E-SERV-ORDER-NO-2        
A05189            WRITE FSO105B             FROM WS-DETAIL-ERROR1       
A05189            MOVE 1                    TO WS-RETURN-CODE           
A05189********SETTING THESE FLAGS TO SKIP THE ORDER AND MOVE ON                 
A05189            MOVE 'Y'                  TO WS-OPT-RANGE-FL          
A05189            MOVE 'Y'                  TO WS-READ-EXISTS           
A05189        WHEN OTHER                                                
A05189            MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE      
A05189            MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO        
A05189            DISPLAY '***********************************'         
A05189            DISPLAY '**  PROCESSING ERROR             **'         
A05189            DISPLAY '**  PARAGRAPH    = 7125-FETCH-ORDER-CURSOR'  
A05189            DISPLAY '**  FETCH AROP CURSOR'                       
A05189            DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE      
A05189            DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO        
A05189            DISPLAY '**  PROCESSING TERMINATED        **'         
A05189            DISPLAY '***********************************'         
A05189            PERFORM 9900-ABEND           THRU 9900-EXIT           
A05189     END-EVALUATE.                                                
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04684******************************************************************08061003
A04684*   7135-FETCH-ORDER-CURSOR                                      *08071703
A04684*   DIFFERENT FETCH CURSOR SO THAT NOT-FOUND CAN BE USED IN 2350 *08071703
A04684******************************************************************08061003
A04684                                                                  
A04684 7135-FETCH-ORDER-CURSOR.                                         
A04684                                                                  
A04684     MOVE '7135'                     TO WS-ACTIVE-PARAGRAPH.      
A04684                                                                  
A04684     EXEC SQL                                                     
A04684        FETCH ORDER-CUR                                           
A04684         INTO :VI-METER-NO,                                       
A04684              :VI-CODE-UTIL-TYPE,                                 
A04684              :VI-IC-NO                                           
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684                                                                  
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684                                                                  
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04684        NEXT SENTENCE                                             
A04684     ELSE                                                         
A04684        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A04684        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
A04684        DISPLAY '***********************************'             
A04684        DISPLAY '**  PROCESSING ERROR             **'             
A04684        DISPLAY '**  PARAGRAPH    = 7135-FETCH-ORDER-CURSOR'      
A04684        DISPLAY '**  FETCH AROP CURSOR'                           
A04684        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A04684        DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
A04684        DISPLAY '**  PROCESSING TERMINATED        **'             
A04684        DISPLAY '***********************************'             
A04684        PERFORM 9900-ABEND           THRU 9900-EXIT               
A04684     END-IF.                                                      
A04684                                                                  
A04684 7135-EXIT.                                                       
A04684     EXIT.                                                        
                                                                        
C37154******************************************************************08061003
      *   7150-CLOSE-ORDER-CURSOR                                      *08076303
      ******************************************************************08061003
                                                                        
C37154 7150-CLOSE-ORDER-CURSOR.                                         
                                                                        
           MOVE '7150'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE ORDER-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7150-CLOSE-ORDER-CURSOR'      
              DISPLAY '**  CLOSE AROP CURSOR '                          
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37154******************************************************************02630000
      *   7200-VALID-READ-CHECK.                                       *08063003
      *        CHECKS IF VALID READ EXISTS IN CSS_ROUTE_REPORT         *08064003
      ******************************************************************08061003
                                                                        
C37154 7200-VALID-READ-CHECK.                                           
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                 INTO :WS-READ-EXISTS                                   
                FROM CSS_ROUTE_REPORT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 
                  AND METER_NO = :VI-METER-NO                           
                  AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
                  AND IC_NO = :VI-IC-NO                                 
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
                  AND TYPE_OF_RD_IND <> 'S'                             
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT 'Y'                                              08069403
MFA-TR*          INTO :WS-READ-EXISTS                                   08069403
MFA-TR*         FROM CSS_ROUTE_REPORT                                   08069403
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 08069403
MFA-TR*           AND METER_NO = :VI-METER-NO                           08069403
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               08069403
MFA-TR*           AND IC_NO = :VI-IC-NO                                 08069403
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                 08069403
MFA-TR*           AND TYPE_OF_RD_IND <> 'S'                             08069403
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08069403
MFA-TR*         QUERYNO 7200                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7200-VALID-READ-CHECK'       
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  ACCOUNT NO   = ' VO-ACCOUNT-NO-PRIOR         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37154******************************************************************02630000
      *   7250-BAD-READ-CHECK.                                         *08063003
      *        CHECKS IF BAD READ EXISTS IN CSS_ROUTE_REPORT           *08064003
      ******************************************************************08061003
                                                                        
C37154 7250-BAD-READ-CHECK.                                             
                                                                        
           MOVE '7250'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                 INTO :WS-BAD-READ                                      
                FROM CSS_ROUTE_REPORT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 
                  AND METER_NO = :VI-METER-NO                           
                  AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
                  AND IC_NO = :VI-IC-NO                                 
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
                  AND READING_COND_CD BETWEEN 'A' AND 'Z'               
                  AND TYPE_OF_RD_IND <> 'S'                             
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT 'Y'                                              08069403
MFA-TR*          INTO :WS-BAD-READ                                      08069403
MFA-TR*         FROM CSS_ROUTE_REPORT                                   08069403
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 08069403
MFA-TR*           AND METER_NO = :VI-METER-NO                           08069403
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               08069403
MFA-TR*           AND IC_NO = :VI-IC-NO                                 08069403
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                 08069403
MFA-TR*           AND READING_COND_CD BETWEEN 'A' AND 'Z'                       
MFA-TR*           AND TYPE_OF_RD_IND <> 'S'                             08069403
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08069403
MFA-TR*         QUERYNO 7250                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7250-BAD-READ-CHECK'         
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  ACCOUNT NO   = ' VO-ACCOUNT-NO-PRIOR         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37181******************************************************************02630000
      *   7300-CHECK-DNP-RECONN.                                       *08063003
      *        CHECKS IF DNP OR RECONNECT EXISTS FOR THIS PREMISE      *08064003
      ******************************************************************08061003
                                                                        
C37181 7300-CHECK-DNP-RECONN.                                           
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                  
              INTO :WS-DNP-EXISTS                                       
            FROM CSS_SO_DATA WITH(READUNCOMMITTED)                              
            WHERE PREMISE_NO = :VO-PREMISE-NO                           
            AND ORDER_TYPE_CD IN ('DNP01', 'FM006', 'DNPFB')            
            AND ORDER_STATE_CD IN ('A','B','D','H','R','Z')             
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*     SELECT 'Y'                                                  08069403
MFA-TR*       INTO :WS-DNP-EXISTS                                       08069403
MFA-TR*     FROM CSS_SO_DATA                                                    
MFA-TR*     WHERE PREMISE_NO = :VO-PREMISE-NO                                   
MFA-TR*     AND ORDER_TYPE_CD IN ('DNP01', 'FM006', 'DNPFB')                    
MFA-TR*     AND ORDER_STATE_CD IN ('A','B','D','H','R','Z')                     
MFA-TR*     FETCH FIRST ROW ONLY WITH UR                                08069403
MFA-TR*     QUERYNO 7300                                                08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7300-CHECK-DNP-RECONN'       
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  ACCOUNT NO   = ' VO-PREMISE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04684******************************************************************02630000
A04684*   7350-OFFCYCLE-READ-CHECK                                     *08063003
A04684*        CHECKS IF VALID READ EXISTS IN CSS_OFFCYCLE_READS       *08064003
A04684******************************************************************08061003
A04684                                                                  
A04684 7350-OFFCYCLE-READ-CHECK.                                        
A04684                                                                  
A04684     MOVE '7350'                     TO WS-ACTIVE-PARAGRAPH.      
A04684                                                                  
A04684     EXEC SQL                                                     
A04684          SELECT TOP(1) 'Y'                                              
A04684           INTO :WS-READ-EXISTS                                   
A04684          FROM CSS_OFFCYCLE_READS WITH(READUNCOMMITTED)                   
A04684          WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 
A04684            AND METER_NO = :VI-METER-NO                           
A04684            AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
A04684            AND IC_NO = :VI-IC-NO                                 
A04684            AND REG_READ_DT >= IIF(TRY_CONVERT(DATE, :WS-DATE-YEST
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-YEST
              ) <> 0) OR (LEN(:WS-DATE-YEST) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-YEST
              ), CONVERT(DATE, :WS-DATE-YEST) )                      
A04684                                       
A04684                                                      
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT 'Y'                                              08069403
MFA-TR*          INTO :WS-READ-EXISTS                                   08069403
MFA-TR*         FROM CSS_OFFCYCLE_READS                                 08069403
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                 08069403
MFA-TR*           AND METER_NO = :VI-METER-NO                           08069403
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               08069403
MFA-TR*           AND IC_NO = :VI-IC-NO                                 08069403
MFA-TR*           AND REG_READ_DT >= :WS-DATE-YEST                      08069403
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08069403
MFA-TR*         QUERYNO 7350                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684                                                                  
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684                                                                  
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04684        NEXT SENTENCE                                             
A04684     ELSE                                                         
A04684          MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
A04684          DISPLAY '***********************************'           
A04684          DISPLAY '**  PROCESSING ERROR             **'           
A04684          DISPLAY '**  PARAGRAPH    =  7350-OFFCYCLE-READ-CHECK'  
A04684          DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE        
A04684          DISPLAY '**  ACCOUNT NO   = ' VO-ACCOUNT-NO-PRIOR       
A04684          DISPLAY '**  PROCESSING TERMINATED        **'           
A04684          DISPLAY '***********************************'           
A04684          PERFORM 9900-ABEND           THRU 9900-EXIT             
A04684     END-IF.                                                      
A04684                                                                  
A04684 7350-EXIT.                                                       
A04684     EXIT.                                                        
                                                                        
A03152******************************************************************02630000
A03152*   7400-CHECK-CAD-QUEUE.                                        *08063003
A03152*        CHECKS IF S.O. EXISTS IN CAD                            *08064003
A03152******************************************************************08061003
A03152                                                                  
A03152 7400-CHECK-CAD-QUEUE.                                            
A03152                                                                  
A03152     MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
A03152                                                                  
A03152     EXEC SQL                                                     
A03152      SELECT TOP(1) 'Y'                                                  
A03152        INTO :WS-CAD-EXISTS                                       
A03152      FROM CSS_SO_CAD_QUEUE WITH(READUNCOMMITTED)                         
A03152      WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                     
A03152      AND CAD_TRANS_TY_ACTN IN (' ','A')                          
A03152                                       
A03152                                                      
A03152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*     SELECT 'Y'                                                  08069403
MFA-TR*       INTO :WS-CAD-EXISTS                                       08069403
MFA-TR*     FROM CSS_SO_CAD_QUEUE                                       08067103
MFA-TR*     WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                     08067103
MFA-TR*     AND CAD_TRANS_TY_ACTN IN (' ','A')                          08067103
MFA-TR*     FETCH FIRST ROW ONLY WITH UR                                        
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03152                                                                  
A03152     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03152                                                                  
A03152     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03152        NEXT SENTENCE                                             
A03152     ELSE                                                         
A03152        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A03152        DISPLAY '***********************************'             
A03152        DISPLAY '**  PROCESSING ERROR             **'             
A03152        DISPLAY '**  PARAGRAPH    =  7400-CHECK-CAD-QUEUE'        
A03152        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A03152        DISPLAY '**  SERV ORDER NO = ' VO-SERV-ORDER-NO           
A03152        DISPLAY '**  PROCESSING TERMINATED        **'             
A03152        DISPLAY '***********************************'             
A03152        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03152     END-IF.                                                      
A03152                                                                  
A03152 7400-EXIT.                                                       
A03152     EXIT.                                                        
                                                                        
P00718******************************************************************02630000
P00718*   7450-CHECK-CLICK-TASK.                                       *08063003
P00718*        CHECKS IF S.O. SENT TO CLICK                            *08064003
P00718******************************************************************08061003
P00718                                                                  
P00718 7450-CHECK-CLICK-TASK.                                           
P00718                                                                  
P00718     MOVE '7450'                     TO WS-ACTIVE-PARAGRAPH.      
P00718                                                                  
P00718     EXEC SQL                                                     
P00718        SELECT TOP(1) TASK_STATUS_CD,
              SO_BUSINESS_UNIT,
              'Y'                                                
P00718          INTO :VI-TASK-STATUS-CD,                                
P00718               :VO-SO-BUSINESS-UNIT,                              
P00718               :WS-CLICK-STATUS                                   
P00718          FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),                
P00718               CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
P00718         WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO               
P00718           AND VI.SERV_ORDER_NO  = :VO-SERV-ORDER-NO              
P00718           AND VI.WORK_TYPE_CD   > ' '                            
P00718           AND TASK_STATUS_CD    IN ('S','R')                     
P00718                                       
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*       SELECT TASK_STATUS_CD,                                    08069403
MFA-TR*              SO_BUSINESS_UNIT,                                  08069403
MFA-TR*              'Y'                                                08069403
MFA-TR*         INTO :VI-TASK-STATUS-CD,                                08069403
MFA-TR*              :VO-SO-BUSINESS-UNIT,                                      
MFA-TR*              :WS-CLICK-STATUS                                           
MFA-TR*         FROM CSS_SO_ORDER_INST VI,                              08067103
MFA-TR*              CSS_SO_DATA VO                                     08067103
MFA-TR*        WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO               08067103
MFA-TR*          AND VI.SERV_ORDER_NO  = :VO-SERV-ORDER-NO              08067103
MFA-TR*          AND VI.WORK_TYPE_CD   > ' '                            08067103
MFA-TR*          AND TASK_STATUS_CD    IN ('S','R')                     08067103
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00718            MOVE 'N'                   TO WS-CLICK-STATUS         
P00718        ELSE                                                      
P00718            MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE      
P00718            DISPLAY '***********************************'         
P00718            DISPLAY '**  PROCESSING ERROR             **'         
P00718            DISPLAY '**  PARAGRAPH     =  7450-CHECK-CLICK-TASK'  
P00718            DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE     
P00718            DISPLAY '**  SERV ORDER NO = ' VO-SERV-ORDER-NO       
P00718            DISPLAY '**  PROCESSING TERMINATED        **'         
P00718            DISPLAY '***********************************'         
P00718            PERFORM 9900-ABEND           THRU 9900-EXIT           
P00718        END-IF                                                    
P00718     END-IF.                                                      
P00718                                                                  
P00718 7450-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7500-GET-TIMESTAMP.                                          *08063003
      *        GETS THE START AND END TIME.                            *08064003
      ******************************************************************08061003
                                                                        
       7500-GET-TIMESTAMP.                                              
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SET :WS-TIME = CURRENT TIMESTAMP                        08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7500-GET-TIMESTAMP'          
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7525-GET-OPTIMUM-DATE.                                       *08063003
      *        GETS THE OPTIMUM READ DATE                              *08064003
      ******************************************************************08061003
                                                                        
       7525-GET-OPTIMUM-DATE.                                           
                                                                        
           MOVE '7525'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) UT.ACCOUNT_NO,
              RW.OPTIMUM_READ_DATE,
              UT.READ_CYCLE,
              UT.READ_ROUTE,
              RW.REVENUE_MONTH   
                  INTO :UT-ACCOUNT-NO,                                  
                       :RW-OPTIMUM-READ-DATE,                           
                       :UT-READ-CYCLE,                                  
                       :UT-READ-ROUTE,                                  
C37154                 :RW-REVENUE-MONTH                                
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                INNER JOIN CSS_READ_WINDOW RW WITH(READUNCOMMITTED)             
                 ON UT.READ_CYCLE = RW.READ_CYCLE                       
                WHERE UT.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              
                  AND RW.OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PRIOR
              ) <> 0) OR (LEN(:WS-DATE-PRIOR) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-PRIOR
              ), CONVERT(DATE, :WS-DATE-PRIOR) )            
                ORDER BY RW.OPTIMUM_READ_DATE                           
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT UT.ACCOUNT_NO, RW.OPTIMUM_READ_DATE,             08069403
MFA-TR*                UT.READ_CYCLE, UT.READ_ROUTE, RW.REVENUE_MONTH   08069403
MFA-TR*           INTO :UT-ACCOUNT-NO,                                  08069403
MFA-TR*                :RW-OPTIMUM-READ-DATE,                           08069403
MFA-TR*                :UT-READ-CYCLE,                                  08069403
MFA-TR*                :UT-READ-ROUTE,                                  08069403
MFA-TR*                :RW-REVENUE-MONTH                                08069403
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                08069403
MFA-TR*         INNER JOIN CSS_READ_WINDOW RW                           08069403
MFA-TR*          ON UT.READ_CYCLE = RW.READ_CYCLE                       08069403
MFA-TR*         WHERE UT.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              08069403
MFA-TR*           AND RW.OPTIMUM_READ_DATE >= :WS-DATE-PRIOR            08069403
MFA-TR*         ORDER BY RW.OPTIMUM_READ_DATE                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7525                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'N' TO WS-OPT-DT-EXISTS                              
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7550-AMR-CHECK.                                              *08063003
      *        CHECKS IF REMOTE_READ_IND = 'A'                         *08064003
      ******************************************************************08061003
                                                                        
       7550-AMR-CHECK.                                                  
                                                                        
           MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'N'                                              
                  INTO :WS-REMOTE-READ-IND                              
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              
                  AND MN.REMOTE_READ_IND <> 'A'                         
A04684            AND MN.CODE_METER_STATUS <> 'K'                       
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT 'N'                                              08069403
MFA-TR*           INTO :WS-REMOTE-READ-IND                              08069403
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                08069403
MFA-TR*         WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              08069403
MFA-TR*           AND MN.REMOTE_READ_IND <> 'A'                         08069403
MFA-TR*           AND MN.CODE_METER_STATUS <> 'K'                       08069403
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08069403
MFA-TR*         QUERYNO 7550                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7550-AMR-CHECK'              
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  ACCOUNT NO   = ' VO-ACCOUNT-NO-PRIOR         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7700-OPEN-AROP-CURSOR                                    *    08063003
      *        OPENS THE AROP-CUR CURSOR TO FETCH ROWS                 *08064003
      ******************************************************************08061003
       7700-OPEN-AROP-CURSOR.                                           
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN AROP-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7700-OPEN-AROP-CURSOR'       
              DISPLAY '**  OPEN AROP CURSOR'                            
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7725-FETCH-AROP-CURSOR                                   *    08071703
      ******************************************************************08061003
                                                                        
       7725-FETCH-AROP-CURSOR.                                          
                                                                        
           MOVE '7725'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH AROP-CUR                                            
               INTO :VO-SERV-ORDER-NO       ,                           
                    :VO-ACCOUNT-NO          ,                           
                    :VO-ACCOUNT-NO-PRIOR    ,                           
C37181              :VO-PREMISE-NO          ,                           
                    :VO-COMPANY-NO          ,                           
                    :VO-LOCAL-OFFICE        ,                           
                    :VO-WORK-AREA-ID        ,                           
                    :I2-WORK-AREA-TX        ,                           
                    :B1-AROP-EXTRACT-CD     ,                           
                    :B1-AROP-DAYS-PRIOR     ,                           
                    :B1-AROP-DAYS-AFTER     ,                           
                    :WS-ASSIGNED-DATE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SPACES TO WS-OPT-RANGE-FL                            
              MOVE SPACES TO WS-LIGHT-IND                               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7725-FETCH-AROP-CURSOR'       
              DISPLAY '**  FETCH AROP CURSOR'                           
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7750-CLOSE-AROP-CURSOR                                   *    08076303
      ******************************************************************08061003
                                                                        
       7750-CLOSE-AROP-CURSOR.                                          
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE AROP-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7750-CLOSE-AROP-CURSOR'       
              DISPLAY '**  CLOSE AROP CURSOR '                          
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-SO-APPL-CHECK.                                              
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-LIGHT-IND                                    
                FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)                  
                WHERE VQ.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND VQ.CODE_UTIL_TYPE = 'G'                           
                  AND VQ.LIGHT_IND = 'Y'                                
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SELECT 'Y'                                              08069403
MFA-TR*           INTO :WS-LIGHT-IND                                    08069403
MFA-TR*         FROM CSS_SO_APPLIANCE VQ                                08069403
MFA-TR*         WHERE VQ.SERV_ORDER_NO = :VO-SERV-ORDER-NO              08069403
MFA-TR*           AND VQ.CODE_UTIL_TYPE = 'G'                           08069403
MFA-TR*           AND VQ.LIGHT_IND = 'Y'                                08069403
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08069403
MFA-TR*         QUERYNO 7800                                            08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7800-SO-APPL-CHECK'          
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7850-WORK-ORDER-CHECK                                         08063003
      *        CHECKS IF EVERY WORK ORDER ON THIS SO IS AROP = Y       *08064003
      ******************************************************************08061003
                                                                        
       7850-WORK-ORDER-CHECK.                                           
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                  INTO :WS-WORK-ORDER-IND                               
                FROM CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)                
                INNER JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
                  ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                
                INNER JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)               
                  ON VO.COMPANY_NO = L4.COMPANY_NO                      
                  AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                 
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND L4.AROP_EXTRACT_IND = 'N'                         
                                             
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*        SELECT 'N'                                               08069403
MFA-TR*           INTO :WS-WORK-ORDER-IND                               08069403
MFA-TR*         FROM CSS_SO_ORDER_INST  VI                              08069403
MFA-TR*         INNER JOIN CSS_SO_DATA VO                                       
MFA-TR*           ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                08069403
MFA-TR*         INNER JOIN CSS_WORK_TYPE L4                             08069403
MFA-TR*           ON VO.COMPANY_NO = L4.COMPANY_NO                      08069403
MFA-TR*           AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                 08069403
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND L4.AROP_EXTRACT_IND = 'N'                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7850-WORK-ORDER-CHECK'       
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
A05189*   7875-VALIDATE-RLSE-INFO.                                     *08090000
      *   DETERMINES IF RELEASE IS REQUIRED OR NOT THIS CHECKS IF THE  *08100000
      *   ORDER REQUIRES A RELEASE AND IF IT DOES MAKE SURE THE RELEASE*        
      *   NUMBER IS PRESENT -- THIS MEANS THAT THE RELEASE REQUIREMENT *        
      *   HAS BEEN COMPLETED.                                          *        
      ******************************************************************08061003
                                                                        
A05189 7875-VALIDATE-RLSE-INFO.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RLSE-INFO-REQ                                 
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD  > ' '                               
                  AND HOLD_RELEASE  = 'Y'                               
                  AND RLSE_NO       = ' '                               
                                             
A05189                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RLSE-INFO-REQ                                         
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND WORK_TYPE_CD  > ' '                                       
MFA-TR*           AND HOLD_RELEASE  = 'Y'                                       
MFA-TR*           AND RLSE_NO       = ' '                                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7875                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR WS-811                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH        = 7875-VALIDATE-RLSE-INFO'  
              DISPLAY '**  RETURN CODE      = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**  SERVICE ORDER NO = ' WS-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
A05189 7875-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05189******************************************************************08061003
A05189*   7900-OPEN-AROP-NEW-CURSOR                                    *08063003
A05189*        OPENS THE AROP-NEW-CUR CURSOR TO FETCH ROWS THAT ALREADY*08064003
A05189*        HAVE AROP WORK AREA.                                    *08064003
A05189******************************************************************08061003
A05189 7900-OPEN-AROP-NEW-CURSOR.                                       
A05189                                                                  
A05189     MOVE '7900'                     TO WS-ACTIVE-PARAGRAPH.      
A05189                                                                  
A05189     EXEC SQL                                                     
A05189          OPEN AROP-NEW-CUR                                       
A05189     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05189        NEXT SENTENCE                                             
A05189     ELSE                                                         
A05189        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05189        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
A05189        DISPLAY '***********************************'             
A05189        DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH    =  7900-OPEN-AROP-NEW-CURSOR'   
A05189        DISPLAY '**  OPEN AROP NEW CURSOR'                        
A05189        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A05189        DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
A05189        DISPLAY '**  PROCESSING TERMINATED        **'             
A05189        DISPLAY '***********************************'             
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
A05189                                                                  
A05189 7900-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
A05189******************************************************************08061003
A05189*   7925-FETCH-AROP-NEW-CURSOR                                   *08071703
A05189******************************************************************08061003
A05189                                                                  
A05189 7925-FETCH-AROP-NEW-CURSOR.                                      
A05189                                                                  
A05189     MOVE '7925'                     TO WS-ACTIVE-PARAGRAPH.      
A05189                                                                  
A05189     EXEC SQL                                                     
A05189        FETCH AROP-NEW-CUR                                        
A05189         INTO :VO-SERV-ORDER-NO       ,                           
A05189              :VO-ACCOUNT-NO          ,                           
A05189              :VO-ACCOUNT-NO-PRIOR    ,                           
A05189              :VO-PREMISE-NO          ,                           
A05189              :VO-COMPANY-NO          ,                           
A05189              :VO-LOCAL-OFFICE        ,                           
A05189              :VO-WORK-AREA-ID        ,                           
A05189              :I2-WORK-AREA-TX        ,                           
A05189              :B1-AROP-EXTRACT-CD     ,                           
A05189              :B1-AROP-DAYS-PRIOR     ,                           
A05189              :B1-AROP-DAYS-AFTER     ,                           
A05189              :WS-ASSIGNED-DATE                                   
A05189     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05189        MOVE SPACES TO WS-OPT-RANGE-FL                            
A05189        MOVE SPACES TO WS-LIGHT-IND                               
A05189     ELSE                                                         
A05189        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05189        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
A05189        DISPLAY '***********************************'             
A05189        DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH    = 7925-FETCH-AROP-NEW-CURSOR'   
A05189        DISPLAY '**  FETCH AROP CURSOR'                           
A05189        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A05189        DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
A05189        DISPLAY '**  PROCESSING TERMINATED        **'             
A05189        DISPLAY '***********************************'             
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
A05189                                                                  
A05189 7925-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
A05189******************************************************************08061003
A05189*   7950-CLOSE-AROP-NEW-CURSOR                                   *08076303
A05189******************************************************************08061003
A05189                                                                  
A05189 7950-CLOSE-AROP-NEW-CURSOR.                                      
A05189                                                                  
A05189     MOVE '7950'                     TO WS-ACTIVE-PARAGRAPH.      
A05189                                                                  
A05189     EXEC SQL                                                     
A05189          CLOSE AROP-NEW-CUR                                      
A05189     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05189        NEXT SENTENCE                                             
A05189     ELSE                                                         
A05189        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05189        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
A05189        DISPLAY '***********************************'             
A05189        DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH    = 7950-CLOSE-AROP-NEW-CURSOR'   
A05189        DISPLAY '**  CLOSE AROP CURSOR '                          
A05189        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A05189        DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
A05189        DISPLAY '**  PROCESSING TERMINATED        **'             
A05189        DISPLAY '***********************************'             
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
A05189                                                                  
A05189 7950-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
A05189******************************************************************02630000
A05189*   7975-RECALC-WORK-AREA.                                       *08063003
A05189*        RECALCULATES WORK AREA FOR ORDER USING CSR04251.        *08064003
A05189******************************************************************08061003
A05189                                                                  
A05189 7975-RECALC-WORK-AREA.                                           
A05189                                                                  
A05189     MOVE '7975'                     TO WS-ACTIVE-PARAGRAPH.      
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       CALL CSR04251                                             
A05189*            (:VO-SERV-ORDER-NO,                                  
A05189*             'N',                                                
A05189*             'SYSTEM',                                           
A05189*             'AROP')                                             
A05189*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4251
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4251
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4251 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A05189                                                                  
A05189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
A05189        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05189        DISPLAY '***********************************'             
A05189        DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH    =  7975-RECALC-WORK-AREA'       
A05189        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A05189        DISPLAY '**  TIMESTAMP = ' WS-DATE-TODAY-TS1              
A05189        DISPLAY '**  PROCESSING TERMINATED        **'             
A05189        DISPLAY '***********************************'             
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       ASSOCIATE LOCATORS                                        
A05189*       (:LOC4251)                                                
A05189*       WITH PROCEDURE CSR04251                                   
A05189*    END-EXEC.                                                    
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       ALLOCATE RESULT_SET_CSR_4251 CURSOR FOR RESULT SET        
A05189*       :LOC4251                                                  
A05189*    END-EXEC.                                                    
A05189                                                                  
A05189     EXEC SQL                                                     
A05189        FETCH RESULT_SET_CSR_4251 INTO                            
A05189             :RETURN-CODE-4251,                                   
A05189             :OLD-WORK-AREA-4251,                                 
A05189             :OLD-WORK-AREA-TX-4251,                              
A05189             :NEW-WORK-AREA-4251,                                 
A05189             :LOCAL-OFFICE-4251,                                  
A05189             :CODE-UTIL-TYPE-4251,                                
A05189             :WORK-TYPE-CD-4251,                                  
A05189             :CRAWL-IND-4251,                                     
A05189             :METER-IND-4251,                                     
A05189             :ZIP-CODE-4251,                                      
A05189             :READ-ROUTE-4251,                                    
A05189             :POINT-ID-4251,                                      
A05189             :BUSINESS-UNIT-4251                                  
A05189     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05189        NEXT SENTENCE                                             
A05189     ELSE                                                         
A05189        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05189        DISPLAY '***********************************'             
A05189        DISPLAY '**  PROCESSING ERROR             **'             
A05189        DISPLAY '**  PARAGRAPH    =  7975-RECALC-WORK-AREA'       
A05189        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A05189        DISPLAY '**  TIMESTAMP = ' WS-DATE-TODAY-TS1              
A05189        DISPLAY '**  PROCESSING TERMINATED        **'             
A05189        DISPLAY '***********************************'             
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
A05189                                                                  
A05189 7975-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   8000-UPDATE-SO-DATA.                                         *08063003
      *        PUTS SO ON HOLD AND CHANGES WORK AREA                   *08064003
      ******************************************************************08061003
                                                                        
       8000-UPDATE-SO-DATA.                                             
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A05189     IF WS-REMOVE-AROP-IND = 'Y'                                  
A05189        MOVE 'A' TO WS-ORDER-STATE-CD                             
A05189        MOVE 'N' TO VO-PRINTED-IND                                
A05189     ELSE                                                         
A05189        MOVE 'H' TO WS-ORDER-STATE-CD                             
A05189        MOVE 'Y' TO VO-PRINTED-IND                                
A05189        MOVE SPACES TO VO-SO-BUSINESS-UNIT                        
A05189     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
A05189           SET ORDER_STATE_CD = :WS-ORDER-STATE-CD,               
A05189               WORK_AREA_ID = :VO-WORK-AREA-ID,                   
A05189               PRINTED_IND  = :VO-PRINTED-IND,                    
A05189               SO_BUSINESS_UNIT = :VO-SO-BUSINESS-UNIT            
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                       080693
MFA-TR*        UPDATE CSS_SO_DATA                                         080694
MFA-TR*          SET ORDER_STATE_CD = :WS-ORDER-STATE-CD,                 080694
MFA-TR*              WORK_AREA_ID = :VO-WORK-AREA-ID,                     080694
MFA-TR*              PRINTED_IND  = :VO-PRINTED-IND,                      080694
MFA-TR*              SO_BUSINESS_UNIT = :VO-SO-BUSINESS-UNIT              080694
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                    080694
MFA-TR*        QUERYNO 8000                                               080694
MFA-TR*    END-EXEC.                                                      080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1 TO WS-COUNT-TO-COMMIT WS-ROW-COUNT                  
              IF WS-COUNT-TO-COMMIT > WS-COMMIT-COUNT                   
                    EXEC SQL                                            
                        COMMIT                                          
                    END-EXEC                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    MOVE 0 TO WS-COUNT-TO-COMMIT                        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  8000-UPDATE-SO-DATA'         
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   8200-SO-UPDATE                                               *08063003
      *        PUTS RECORDS IN SO_UPDATE (USED IN AUDIT DISPLAY PANEL) *08064003
      ******************************************************************08061003
                                                                        
       8200-SO-UPDATE.                                                  
                                                                        
           MOVE '8200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            CALL CSR00064 (                                             
                        :VO-SERV-ORDER-NO,                              
                        'SYSTEM',                                       
                        :WS-TIME,                                       
                        :WS-APPL-PGM-ID,                                
                        'Y')                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  8200-SO-UPDATE'              
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  RETURN CODE  = ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   8250-SO-REMARKS                                              *08063003
      *        PUTS RECORDS IN SO_REMARKS AND SO_UPDATE                *08064003
      ******************************************************************08061003
                                                                        
       8250-SO-REMARKS.                                                 
                                                                        
           MOVE '8250'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A05189     IF WS-REMOVE-AROP-IND = 'Y'                                  
A05189        MOVE 'E' TO WS-ORDER-STATE-CD                             
A05189     ELSE                                                         
A05189        MOVE 'H' TO WS-ORDER-STATE-CD                             
A05189     END-IF.                                                      
                                                                        
           STRING WS-WA-COMMENTS                                        
              DELIMITED BY SIZE                                         
              I2-WORK-AREA-TX                                           
              DELIMITED BY SIZE                                         
              INTO WS-COMMENTS                                          
           END-STRING.                                                  
                                                                        
           EXEC SQL                                                     
            CALL CSR00068 (                                             
                        :VO-SERV-ORDER-NO,                              
A05189                  :WS-ORDER-STATE-CD,                             
                        :WS-COMMENTS,                                   
                        'SYSTEM')                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  8250-SO-REMARKS'             
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04684******************************************************************02630000
A04684*   8300-GET-LAST-BUSINESS-DAY                                   *08063003
A04684*        FINDS LAST BUSINESS DAY BEFORE TODAY'S DATE             *08064003
A04684******************************************************************08061003
A04684                                                                  
A04684 8300-GET-LAST-BUSINESS-DAY.                                      
A04684                                                                  
A04684     MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
A04684                                                                  
A04684*    EXEC SQL                                                     
A04684*         CALL CSR01416 (:WS-DATE-TODAY-TS,                       
A04684*                        :WS-LAST-BUSINESS-DAY)                   
A04684*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A04684                                                                  
A04684*    EXEC SQL                                                     
A04684*       ASSOCIATE LOCATORS                                        
A04684*       (:LOC1416)                                                
A04684*       WITH PROCEDURE CSR01416                                   
A04684*    END-EXEC.                                                    
A04684                                                                  
A04684*    EXEC SQL                                                     
A04684*       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
A04684*       :LOC1416                                                  
A04684*    END-EXEC.                                                    
A04684                                                                  
A04684     EXEC SQL                                                     
A04684        FETCH RESULT_SET_CSR_1416 INTO                            
A04684           :WS-OUTPUT-DATE-1416                                   
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684                                                                  
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684                                                                  
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04684        NEXT SENTENCE                                             
A04684     ELSE                                                         
A04684        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A04684        DISPLAY '***********************************'             
A04684        DISPLAY '**  PROCESSING ERROR             **'             
A04684        DISPLAY '**  PARAGRAPH    =  8300-GET-LAST-BUSINESS-DAY'  
A04684        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
A04684        DISPLAY '**  TIMESTAMP = ' WS-DATE-TODAY-TS1              
A04684        DISPLAY '**  PROCESSING TERMINATED        **'             
A04684        DISPLAY '***********************************'             
A04684        PERFORM 9900-ABEND           THRU 9900-EXIT               
A04684     END-IF.                                                      
A04684                                                                  
A04684 8300-EXIT.                                                       
A04684     EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   8500-INSERT-SO-AROP.                                         *08063003
      *        INSERTS ROWS INTO CSS_SO_AROP FOR REPORTING             *08064003
      ******************************************************************08061003
                                                                        
       8500-INSERT-SO-AROP.                                             
                                                                        
           MOVE '8500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_AROP                                  
                (SERV_ORDER_NO,                                         
                 ORIG_ASSIGN_DT)                                        
                 VALUES                                                 
                (:VO-SERV-ORDER-NO,                                     
                 IIF(TRY_CONVERT(DATE, :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ))                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                       080693
MFA-TR*        INSERT INTO CSS_SO_AROP                                    080694
MFA-TR*         (SERV_ORDER_NO,                                           080694
MFA-TR*          ORIG_ASSIGN_DT)                                          080694
MFA-TR*          VALUES                                                   080694
MFA-TR*         (:VO-SERV-ORDER-NO,                                       080694
MFA-TR*          :WS-ASSIGNED-DATE)                                       080694
MFA-TR*    END-EXEC.                                                      080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL -803                        
                PERFORM 8600-UPDATE-SO-AROP  THRU 8600-EXIT             
             ELSE                                                       
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO          
                DISPLAY '***********************************'           
                DISPLAY '**  PROCESSING ERROR             **'           
                DISPLAY '**  PARAGRAPH    =  8500-INSERT-SO-AROP'       
                DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE        
                DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO          
                DISPLAY '**  PROCESSING TERMINATED        **'           
                DISPLAY '***********************************'           
                PERFORM 9900-ABEND           THRU 9900-EXIT             
             END-IF                                                     
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   8600-UPDATE-SO-AROP.                                         *08063003
      *        UPDATES ROWS IN CSS_SO_AROP FOR REPORTING               *08064003
      ******************************************************************08061003
                                                                        
       8600-UPDATE-SO-AROP.                                             
                                                                        
           MOVE '8600'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_AROP                                       
                 SET ORIG_ASSIGN_DT = IIF(TRY_CONVERT(DATE, 
                                                      :WS-ASSIGNED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATE
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-ASSIGNED-DATE
              ), CONVERT(DATE, :WS-ASSIGNED-DATE) ),                
                     PRORATED_DAYS_NM = 0,                              
                     AROP_RELEASE_ST_CD = ' ',                          
                     AROP_RELEASE_DT = NULL                             
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
A03152                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                       080693
MFA-TR*        UPDATE CSS_SO_AROP                                         080694
MFA-TR*          SET ORIG_ASSIGN_DT = :WS-ASSIGNED-DATE,                  080694
MFA-TR*              PRORATED_DAYS_NM = 0,                                080694
MFA-TR*              AROP_RELEASE_ST_CD = ' ',                            080694
MFA-TR*              AROP_RELEASE_DT = NULL                               080694
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                    080694
MFA-TR*        QUERYNO 8600                                               080694
MFA-TR*    END-EXEC.                                                      080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  8600-UPDATE-SO-AROP'         
              DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03152******************************************************************02630000
A03152*   8700-INSERT-CAD-CANCEL.                                      *08063003
A03152*        SENDS CANCEL ROW TO CSS_SO_CAD_QUEUE                    *08064003
A03152******************************************************************08061003
A03152                                                                  
A03152 8700-INSERT-CAD-CANCEL.                                          
A03152                                                                  
A03152     MOVE '8700'                     TO WS-ACTIVE-PARAGRAPH.      
A03152                                                                  
A03152     EXEC SQL                                                     
A03152         INSERT INTO CSS_SO_CAD_QUEUE                             
A03152          (SERV_ORDER_NO,                                         
A03152           COMPANY_NO,                                            
A03152           LOCAL_OFFICE,                                          
A03152           WORK_GROUP_ID,                                         
A03152           WORK_AREA_ID,                                          
A03152           CREATED_TS,                                            
A03152           CAD_TS,                                                
A03152           CAD_PRIORITY,                                          
A03152           CREATED_BY_USER_ID,                                    
A03152           CAD_TRANS_TY_ACTN)                                     
A03152         VALUES                                                   
A03152          (:VO-SERV-ORDER-NO,                                     
A03152           :VO-COMPANY-NO,                                        
A03152           :VO-LOCAL-OFFICE,                                      
A03152           ' ',                                                   
A03152           ' ',                                                   
A03152           CIS.CHAR2TIMESTAMP(:WS-TIME),                                  
A03152           NULL,                                                  
A03152           '1',                                                   
A03152           'SYSTEM',                                              
A03152           'C')                                                   
A03152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08080693
MFA-TR*        INSERT INTO CSS_SO_CAD_QUEUE                             08080694
MFA-TR*         (SERV_ORDER_NO,                                         08080694
MFA-TR*          COMPANY_NO,                                            08080694
MFA-TR*          LOCAL_OFFICE,                                          08069203
MFA-TR*          WORK_GROUP_ID,                                         08069203
MFA-TR*          WORK_AREA_ID,                                          08069203
MFA-TR*          CREATED_TS,                                            08069203
MFA-TR*          CAD_TS,                                                08069203
MFA-TR*          CAD_PRIORITY,                                          08069203
MFA-TR*          CREATED_BY_USER_ID,                                    08069203
MFA-TR*          CAD_TRANS_TY_ACTN)                                     08069203
MFA-TR*        VALUES                                                   08080694
MFA-TR*         (:VO-SERV-ORDER-NO,                                     08080694
MFA-TR*          :VO-COMPANY-NO,                                        08080694
MFA-TR*          :VO-LOCAL-OFFICE,                                      08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          :WS-TIME,                                              08069203
MFA-TR*          NULL,                                                  08069203
MFA-TR*          '1',                                                   08069203
MFA-TR*          'SYSTEM',                                              08069203
MFA-TR*          'C')                                                   08069203
MFA-TR*    END-EXEC.                                                    08080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03152                                                                  
A03152     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03152                                                                  
A03152     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03152        NEXT SENTENCE                                             
A03152     ELSE                                                         
A03152       IF WS-ACTIVE-RETURN-CODE EQUAL -803                        
A03152          PERFORM 8600-UPDATE-SO-AROP  THRU 8600-EXIT             
A03152       ELSE                                                       
A03152          MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
A03152          MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO          
A03152          DISPLAY '***********************************'           
A03152          DISPLAY '**  PROCESSING ERROR             **'           
A03152          DISPLAY '**  PARAGRAPH    =  8700-INSERT-CAD-CANCEL'    
A03152          DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE        
A03152          DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO          
A03152          DISPLAY '**  PROCESSING TERMINATED        **'           
A03152          DISPLAY '***********************************'           
A03152          PERFORM 9900-ABEND           THRU 9900-EXIT             
A03152       END-IF                                                     
A03152     END-IF.                                                      
A03152                                                                  
A03152 8700-EXIT.                                                       
A03152     EXIT.                                                        
                                                                        
P00718******************************************************************02630000
P00718*   8800-CLICK-CANCEL.                                           *08063003
P00718*        SENDS CANCEL ROW TO CSS_SO_TASK_QUEUE                   *08064003
P00718******************************************************************08061003
P00718                                                                  
P00718 8800-CLICK-CANCEL.                                               
P00718                                                                  
P00718     MOVE '8800'                     TO WS-ACTIVE-PARAGRAPH.      
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         UPDATE CSS_SO_ORDER_INST                                 
P00718            SET TASK_STATUS_CD = 'C'                              
P00718          WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
P00718            AND TASK_STATUS_CD IN ('R','S')                       
P00718            AND WORK_TYPE_CD   > ' '                              
P00718     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00718        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
P00718        DISPLAY '***********************************'             
P00718        DISPLAY '**  PROCESSING ERROR             **'             
P00718        DISPLAY '**  PARAGRAPH    =  8800-CLICK-CANCEL'           
P00718        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
P00718        DISPLAY '**  SERV ORDER NO= ' VO-SERV-ORDER-NO            
P00718        DISPLAY '**  PROCESSING TERMINATED        **'             
P00718        DISPLAY '***********************************'             
P00718        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00718     END-IF.                                                      
P00718                                                                  
P00718 8800-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718******************************************************************02630000
P00718*   8810-CLICK-TASK.                                             *08063003
P00718*        SENDS CANCEL ROW TO CSS_SO_TASK_QUEUE                   *08064003
P00718******************************************************************08061003
P00718                                                                  
P00718 8810-CLICK-TASK.                                                 
P00718                                                                  
P00718     MOVE '8810'                     TO WS-ACTIVE-PARAGRAPH.      
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         INSERT INTO CSS_SO_TASK_QUEUE                            
P00718           (SERV_ORDER_NO,                                        
P00718            CREATED_TS,                                           
P00718            COMPANY_NO,                                           
P00718            TASK_PRIORITY,                                        
P00718            CREATED_BY_USER_ID,                                   
P00718            SO_BUSINESS_UNIT,                                     
P00718            CALL_ID,                                              
P00718            CALL_NUMBER)                                          
P00718         VALUES                                                   
P00718            (:VO-SERV-ORDER-NO,                                   
P00718             CIS.CURRENT$TIMESTAMP(),                                   
P00718             :VO-COMPANY-NO,                                      
P00718             '1',                                                 
P00718             'SYSTEM',                                            
P00718             :VO-SO-BUSINESS-UNIT,                                
P00718             1,                                                   
P00718             1)                                                   
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080693
MFA-TR*        INSERT INTO CSS_SO_TASK_QUEUE                            08080694
MFA-TR*          (SERV_ORDER_NO,                                        08080694
MFA-TR*           CREATED_TS,                                           08080694
MFA-TR*           COMPANY_NO,                                           08069203
MFA-TR*           TASK_PRIORITY,                                        08069203
MFA-TR*           CREATED_BY_USER_ID,                                   08069203
MFA-TR*           SO_BUSINESS_UNIT,                                     08069203
MFA-TR*           CALL_ID,                                              08069203
MFA-TR*           CALL_NUMBER)                                          08069203
MFA-TR*        VALUES                                                   08080694
MFA-TR*           (:VO-SERV-ORDER-NO,                                   08080694
MFA-TR*            CURRENT TIMESTAMP,                                   08080694
MFA-TR*            :VO-COMPANY-NO,                                      08080694
MFA-TR*            '1',                                                 08069203
MFA-TR*            'SYSTEM',                                            08069203
MFA-TR*            :VO-SO-BUSINESS-UNIT,                                08069203
MFA-TR*            1,                                                   08069203
MFA-TR*            1)                                                   08069203
MFA-TR*    END-EXEC.                                                    08080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00718        MOVE VO-SERV-ORDER-NO      TO WS-SERV-ORDER-NO            
P00718        DISPLAY '***********************************'             
P00718        DISPLAY '**  PROCESSING ERROR             **'             
P00718        DISPLAY '**  PARAGRAPH    =  8810-CLICK-TASK'             
P00718        DISPLAY '**  RETURN CODE  = ' WS-DISPLAY-SQLCODE          
P00718        DISPLAY '**  SERV ORDER NO= ' WS-SERV-ORDER-NO            
P00718        DISPLAY '**  PROCESSING TERMINATED        **'             
P00718        DISPLAY '***********************************'             
P00718        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00718     END-IF.                                                      
P00718                                                                  
P00718 8810-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9000-TERMINATE.                                              *10060000
      ******************************************************************08061003
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSSO105-FILE.                                         
                                                                        
           IF WS-FSO105-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSSO105  PROCESSING ERROR **'               
              DISPLAY '**  CLOSE ERROR OF FCSSO105 OUTPUT FILE'         
              DISPLAY '**  FILE STATUS = ' WS-FSO105-STATUS             
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
A05189     CLOSE FCSS105B-FILE.                                         
A05189                                                                  
A05189     IF WS-FSO105B-SUCCESSFUL                                     
A05189        CONTINUE                                                  
A05189        IF WS-RETURN-CODE = 1                                     
A05189           MOVE WS-RETURN-CODE       TO RETURN-CODE               
A05189        END-IF                                                    
A05189     ELSE                                                         
A05189        DISPLAY ' '                                               
A05189        DISPLAY '**  PCSSO105  PROCESSING ERROR **'               
A05189        DISPLAY '**  CLOSE ERROR OF FCSS105B OUTPUT FILE'         
A05189        DISPLAY '**  FILE STATUS = ' WS-FSO105B-STATUS            
A05189        DISPLAY '**  PROCESSING TERMINATED **'                    
A05189        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05189     END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *  M251-GET-FJC01-DATE                                           *10290000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************08061003
      *  7600-START-FCSJC01                                            *10370000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD09900                                         10520000
           END-EXEC.                                                    10530000
