       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO104                                          
COB303 DATE-WRITTEN.  JANUARY 25, 2007                                  
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSSO104                                           *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM DOWNLOADS ORDERS FROM CSS_SO_DATA_MF TO          *         
      * CSS_SO_DATA TABLE.                                            *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  01/25/07    MSR      PROCEDURE ORIGINALLY CODED.             *         
APL507*  02/11/09    MSR      DO NOT COPY READ ROUTE FROM UNMETERED   *         
APL507*                       ROWS.                                   *         
P00128*  03/23/09    SMS      IN SEB, IF ACCOUNT ALREADY HAS DNP01,   *         
P00128*                       CANCEL OLD AND ENTER NEW                *         
P00128*                       ALSO COMMENTED OUT CPD00067 AS CALL TO  *         
P00128*                       IT IS COMMENTED OUT AND IT REFERNCES    *         
P00128*                       9000-SEND-ERROR-RESULT WHICH HAD BEEN   *         
P00128*                       REMOVED PREVIOUSLY.                     *         
A1387 *  06/24/09    SC41135  CHANGES TO ACCOMODATE MORE METERS FOR   *         
A1387 *                       WORK AREA CALCULATIONS                  *         
A01016*  07/30/09    AW41078  INSERT SERVICE ORDER DNP CANCEL REMARKS *         
A01016*                       INTO NEW REMARK_TX COLUMN OF CSS_DNP_   *         
A01016*                       NOT_WORKED FOR REPORTING.               *         
A37741** 14/11/09    SB93596  DECLARED  S-RETURN-CODE                **         
A37741*                       RESPECTIVE TO CPD00067 CHANGES.        **         
A02059** 01/15/10    SS19371  ALLOW NOT-FOUND AS ACCEPTABLE RETURN   **         
A02059*                       CODE IN PARAGRAPH 7765                 **         
P00447*  09/07/10    SJ97149  ADD CHECK FOR CONSTANT = 0 FOR SENDING **         
P00447*                       'Y' FOR  METER-IND                     **         
A03308*  04/15/11    MSR      HANDLE TO DOWNLOAD MULTIPLE ORDER TYPES**         
A03468*  07/21/11    SC41135  PASS CODE-SIC-NO VALUE TO CSR00224     **         
P00541*  08/25/11    FMB      CREATE ALL BUT DNP ORDERS ON HOLD.     **         
P00471*  09/07/11    PK98692  ADDED 4 NEW ORDER REASONS FOR DPP DROP **         
P00471*                       J-NORMAL DPP;K-NORM DPP W/RET CHK     **          
P00471*                       U-DROPPED DPP;V-DROPPED DPP W/RET CHK **          
A04228*  08/07/12    SC41135  CREATE ORDER REMARK FOR FLEX DNP STA ORD*         
P00718*  02/19/14    VV90387  ADDTIONAL PARM FOR CSR00224 CALL        *         
A05020*  02/11/15    VV90387  INSERT INTO SO_TASK_QUEUE FOR CLICK     *         
ACT106*  05/21/15    RS7M249  DELETE  UNUSED COPYBOOK(S).             *         
A05020*  09/17/15    VV90387  DEFAULT GOP FOR PSNC FSV BUSINESS UNIT  *         
A05020*  11/11/15    VV90387  DEFAULT GOP FOR SCEG GAS ONLY DISTRICTS *         
A05317*  03/09/17    FMB      REMOVE REFERENCES TO                   **         
A05317*                       CSS_DNP_NOT_WORKED.                    **         
A05317*  03/23/17    FMB      ADD WHERE CLAUSE TO DELETE.            **         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO104'.
MSQ017     COPY MFASQLM.
                                                                        
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSSO104 STARTS HERE'.            
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO104'.     
       01  WS-PGRMNAME                  PIC X(08).                      
      *                                                                         
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-TEMP-ZIP-CODE        PIC X(05).                       
           05  WS-FORMATTED            PIC X(01) VALUE 'A'.             
           05  WS-FREEFORM             PIC X(01) VALUE 'B'.             
           05  WS-SUBDIV-PLAN          PIC X(03)    VALUE '064'.        
           05  WS-CURRENT-DATE         PIC X(10)    VALUE SPACES.       
           05  WS-CODE-UTIL-TYPE-WS    PIC X(1)     VALUE 'U'.          
           05  WS-RATE-PLAN-NO-WS      PIC X(03)    VALUE SPACES.       
           05  WS-REVENUE-CLASS-WS     PIC X(03)    VALUE SPACES.       
           05  WS-RATE-ITEM-CODE       PIC S9(4)    COMP VALUE 0.       
           05  WS-VERSION-NO-CNTRL     PIC S9(4)    COMP VALUE 0.       
           05  WS-PRICE-PER-SERVICE    PIC S9(3)V9(6) COMP-3 VALUE 0.   
           05  WS-CODE-STATUS          PIC X(1)     VALUE SPACES.       
           05  WS-CODE-UNMETERED       PIC X(01)    VALUE 'U'.          
           05  WS-MTR-PRESSURE         PIC 9(03).                       
A05020     05  WS-GAS-DISTRICT         PIC X(01)    VALUE SPACES.       
                                                                        
       01  WS-RETURN-VARIABLES.                                         
           05  WS-MSGNO                PIC S9(9) COMP VALUE +1.         
           05  WS-RETCODE              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-DATALEN              PIC S9(9) COMP SYNC VALUE +0.    
      *    05  WS-INDIC                PIC S9(9) COMP SYNC VALUE +0.            
           05  WS-NULL-IND             PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-VALUE           PIC S9(4) COMP VALUE -1.         
           05  WS-RETURN-STATUS        PIC S9(4) COMP VALUE +0.         
                                                                        
A05020 01  WS-SP4747-CALL-PARAMETERS.                                   
A05020     05  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
A05020     05  PRIORITY-4747            PIC X(01) VALUE SPACES.         
A05020     05  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
A05020     05  USER-ID-4747             PIC X(07) VALUE SPACES.         
A05020     05  WK-DISTRICT-4747         PIC X(40) VALUE SPACES.         
A05020                                                                  
A05020 01  CSR04747-RETURN-DATA.                                        
A05020     03  RETURN-CODE-4747         PIC S9(9) COMP VALUE 0.         
A05020     03  WORK-DISTRICT-4747       PIC X(40) VALUE SPACES.         
A05020                                                                  
       01  WS-SP224-CALL-PARAMETERS.                                    
           05  WS-WA-LOCAL-OFFICE       PIC X(03) VALUE SPACES.         
           05  WS-WA-CODE-UTIL-TYPE     PIC X(50) VALUE SPACES.         
           05  WS-WA-WORK-TYPE-CD       PIC X(150) VALUE SPACES.        
           05  WS-WA-METER-IND          PIC X(50) VALUE SPACES.         
           05  WS-WA-ZIP-CODE           PIC X(05) VALUE SPACES.         
           05  WS-WA-READ-ROUTE         PIC X(04) VALUE SPACES.         
           05  WS-WA-WORK-AREA          PIC X(12).                      
P00718     05  WS-WA-BUSINESS-UNIT      PIC X(03).                      
           05  WS-ROW-NO                PIC S9(04) COMP.                
           05  WS-PREMISE-NO            PIC X(10).                      
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-PRIOR      PIC X(13).                      
           05  WS-SERV-ORDER-NO         PIC X(13).                      
           05  WS-ORDER-TYPE-CD         PIC X(05).                      
           05  WS-LOCAL-OFFICE          PIC X(03).                      
           05  WS-PHONE-NO-EXT          PIC X(06).                      
           05  WS-PHONE-NO              PIC X(10).                      
           05  WS-ORDER-PLACED-BY       PIC X(25).                      
           05  WS-ORDER-RECVED-BY       PIC X(07).                      
           05  WS-WANTED-BY-DATE        PIC X(10).                      
           05  WS-DATE-FORECAST-DNP     PIC X(10).                      
           05  WS-ASSIGNED-DATETIME     PIC X(26).                      
           05  WS-ORDER-REASON          PIC X(01).                      
           05  WS-BACK-DATED-IND        PIC X(01).                      
           05  WS-RESP-AREA-ID          PIC X(03).                      
           05  WS-CALL-BEFORE-MIN       PIC X(03).                      
           05  WS-NOTIFY-CUST-IND       PIC X(01).                      
           05  WS-NOTIFY-CSR-IND        PIC X(01).                      
           05  WS-BREAKERS-OFF          PIC X(01).                      
           05  WS-DEPOSIT-AMT           PIC 9(11).                      
           05  WS-DEPOSIT-AMT-CHAR REDEFINES WS-DEPOSIT-AMT             
                                        PIC X(11).                      
           05  WS-AMT-DNP-AT-BILLING    PIC 9(11).                      
           05  WS-AMT-DNP-AT-BILL-CHAR REDEFINES WS-AMT-DNP-AT-BILLING  
                                        PIC X(11).                      
           05  WS-INIT-BY-CNTRCT        PIC X(01).                      
           05  WS-WORK-AREA-ID          PIC X(12).                      
P00718     05  WS-BUSINESS-UNIT         PIC X(03).                      
           05  WS-ORDER-PRIORITY        PIC S9(4) USAGE COMP.           
           05  WS-ORDER-STATE-CD        PIC X(01).                      
           05  WS-WORK-TYPE-CD          PIC X(03).                      
           05  WS-CODE-UTIL-TYPE        PIC X(01).                      
           05  WS-STD-CHG-AMT           PIC 9(09).                      
           05  WS-STD-CHG-AMT-CHAR REDEFINES WS-STD-CHG-AMT             
                                        PIC X(09).                      
           05  WS-HOLD-RELEASE          PIC X(01).                      
           05  WS-PER-TEMP-IND          PIC X(01).                      
           05  WS-RLSE-NO               PIC X(10).                      
           05  WS-RLSE-DATE             PIC X(10).                      
           05  WS-SO-INST-SEQ-NO        PIC S9(04) COMP.                
           05  WS-TABLE-ID              PIC X(02).                      
           05  WS-UT-CODE-UTIL-TYPE     PIC X(01).                      
           05  WS-IC-NO                 PIC S9(04) COMP.                
           05  WS-UT-READ-ROUTE         PIC S9(04) COMP.                
           05  WS-RATE-PLAN-NO          PIC X(03).                      
           05  WS-UT-CODE-REV-CLASS     PIC X(03).                      
           05  WS-UT-READ-CYCLE         PIC X(02).                      
           05  WS-UT-CODE-SIC-NO        PIC X(04).                      
           05  WS-METER-NO              PIC X(09).                      
           05  WS-MN-MTR-REF-NO         PIC S9(04) COMP.                
           05  WS-MN-CODE-TIME-PERIOD   PIC S9(04) COMP.                
           05  WS-MN-LAST-READ-VALUE    PIC 9(15).                      
           05  WS-MN-LAST-RD-VAL-CHAR REDEFINES WS-MN-LAST-READ-VALUE   
                                        PIC X(15).                      
           05  WS-MN-CODE-STATUS-REAS   PIC X(01).                      
           05  WS-MN-CODE-USAGE-TYPE    PIC X(01).                      
           05  WS-MN-CODE-USAGE-ID      PIC X(01).                      
           05  WS-MN-CODE-USAGE-SOURCE  PIC X(01).                      
           05  WS-CODE-METER-STATUS     PIC X(01).                      
           05  WS-METER-SUPPLYING       PIC X(15).                      
           05  WS-CODE-METER-LOC        PIC X(02).                      
           05  WS-MN-CONSTANT           PIC 9(09).                      
           05  WS-MN-CONSTANT-CHAR REDEFINES WS-MN-CONSTANT             
                                        PIC X(09).                      
           05  WS-MN-NO-DIALS           PIC S9(04) COMP.                
           05  WS-MN-POINT-ID           PIC X(10).                      
           05  WS-MN-SEAL-CODE-ID       PIC X(01).                      
           05  WS-MN-HEXAGRAM-LOCATION  PIC X(02).                      
           05  WS-MN-INSULATED-IND      PIC X(01).                      
           05  WS-MN-LOCK-TYPE-ID       PIC X(01).                      
           05  WS-MN-DELIVERY-LEVEL-CD  PIC X(01).                      
           05  WS-MN-UTILITY-SOURCE-CD  PIC X(01).                      
           05  WS-MN-IDR-RECIPIENT-CD   PIC X(01).                      
           05  WS-MN-PROGRAM-ID         PIC X(02).                      
           05  WS-MN-MTR-READ-SOURCE-CD PIC X(01).                      
           05  WS-MN-LAST-READ-DT       PIC X(10).                      
           05  WS-MN-REG-ID-NO          PIC S9(04) COMP.                
           05  WS-RG-CODE-REG-STATUS    PIC X(01).                      
           05  WS-RG-CODE-STATUS-REAS   PIC X(01).                      
           05  WS-RG-CODE-TIME-PERIOD   PIC S9(04) COMP.                
           05  WS-RG-CODE-USAGE-ID      PIC X(01).                      
           05  WS-RG-CODE-USAGE-SOURCE  PIC X(01).                      
           05  WS-RG-CODE-USAGE-TYPE    PIC X(01).                      
           05  WS-RG-LAST-READ-DT       PIC X(10).                      
           05  WS-RG-LAST-READ-VALUE    PIC 9(15).                      
           05  WS-RG-LAST-RD-VAL-CHAR REDEFINES WS-RG-LAST-READ-VALUE   
                                        PIC X(15).                      
           05  WS-RG-REG-ID-NO          PIC S9(04) COMP.                
           05  WS-CP-NO-UNITS           PIC S9(09) COMP.                
           05  WS-CP-CODE-PLAN-STATUS   PIC X(01).                      
           05  WS-CP-CODE-STAT-REASON   PIC X(01).                      
           05  WS-CP-CODE-SERVICE-TYPE  PIC X(01).                      
           05  WS-CP-MNTHLY-AMT-FIXED   PIC 9(11).                      
           05  WS-CP-MTLY-AMT-FIX-CHAR REDEFINES WS-CP-MNTHLY-AMT-FIXED 
                                        PIC X(11).                      
           05  WS-CP-RATE-ITEM-CODE     PIC S9(04) COMP.                
           05  WS-CP-LIGHT-NO           PIC S9(04) COMP.                
           05  WS-CP-POLE-NO            PIC X(07).                      
           05  WS-CP-DIST-NO            PIC X(03).                      
           05  WS-CP-USAGE-FIXED        PIC 9(09).                      
           05  WS-CP-USAGE-FIXED-CHAR REDEFINES WS-CP-USAGE-FIXED       
                                        PIC X(09).                      
           05  WS-CP-EQUIP-ID           PIC X(02).                      
           05  WS-APPLIANCE-CD          PIC X(03).                      
           05  WS-APPLIANCE-SEQ-NO      PIC S9(04) COMP.                
           05  WS-EQUIP-OWNER           PIC X(01).                      
           05  WS-MK-CODE-UTIL-TYPE     PIC X(01).                      
           05  WS-LEAK-IND              PIC X(01).                      
           05  WS-LIGHT-IND             PIC X(01).                      
           05  WS-REPAIR-IND            PIC X(01).                      
           05  WS-CUTOFF-IND            PIC X(01).                      
           05  WS-CAUTION-TAG-IND       PIC X(01).                      
           05  WS-IMPROPER-REASON       PIC X(25).                      
           05  WS-EQUIPMENT-UNQ         PIC X(20).                      
           05  WS-VERIFY-RATE           PIC X(01).                      
           05  WS-ORDER-INST-PRESENT    PIC X(01).                      
           05  WS-EQUIPMENT-PRESENT     PIC X(01).                      
           05  WS-UTIL-ENV-PRESENT      PIC X(01).                      
           05  WS-NEW-ORDER             PIC X(01).                      
           05  WS-PANEL-NO              PIC X(04).                      
           05  WS-INCLUDE-INST          PIC X(01).                      
           05  WS-REV-DIST-CD           PIC X(03).                      
           05  WS-USER-ID-SP            PIC X(07) VALUE 'SYSTEM'.       
           05  WS-SO-EST-LABOR-HR       PIC 9(03).                      
           05  WS-SO-EST-LABOR-HR-CHAR REDEFINES WS-SO-EST-LABOR-HR     
                                        PIC X(03).                      
           05  WS-ACCT-STATUS           PIC X(01).                      
           05  WS-PRICE-PER-SERV-ORDER  PIC 9(09).                      
           05  WS-PPS-ORDER-CHAR REDEFINES WS-PRICE-PER-SERV-ORDER      
                                        PIC X(09).                      
           05  WS-REORDER-FLAG          PIC X(01).                      
           05  WS-WA-LAST-CALL          PIC X(01) VALUE 'N'.            
           05  WS-COMPANY-NO            PIC X(02).                      
           05  WS-RLSE-REQUIRED-IND     PIC X(01).                      
           05  WS-OLD-ACCT-STATUS       PIC X(01).                      
           05  WS-DISC-BAL              PIC 9(11).                      
           05  WS-DISC-BAL-CHAR REDEFINES WS-DISC-BAL                   
                                        PIC X(11).                      
           05  WS-SECURITIES-TOT-AMT    PIC 9(11).                      
           05  WS-SEC-TOT-AMT-CHAR REDEFINES WS-SECURITIES-TOT-AMT      
                                        PIC X(11).                      
           05  WS-CUR-MTH-ARREARS-CD    PIC X(01)    VALUE SPACES.      
           05  WS-CREDIT-GROUP          PIC X(01)    VALUE SPACES.      
           05  WS-DNP-REC               PIC X(01)    VALUE 'N'.         
           05  WS-ACCOUNT-TYPE-CODE     PIC X(01).                      
           05  WS-INSTALL-IND           PIC X(01).                      
           05  WS-CP-ITEM-SEQ-NO        PIC S9(04) COMP.                
           05  WS-MN-METER-PRESSURE     PIC X(03).                      
       01  WS-REDEFINITIONS.                                            
           05  WS-PRIOR-ACCOUNT-NO     PIC X(13).                       
           05  WS-ACCOUNT-NO-PRIOR-DEC REDEFINES WS-PRIOR-ACCOUNT-NO    
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-PRIOR-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
                                                                        
           05  WS-PREMISE-NO-CHAR      PIC X(10).                       
           05  WS-PREMISE-NO-DEC REDEFINES WS-PREMISE-NO-CHAR           
                                       PIC 9(10).                       
COB305     05 WS-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
P00128     05  WS-DATABASE             PIC 9(01)  VALUE 0.              
P00128         88 CSR-DATABASE                    VALUE 1.              
P00128         88 SEB-DATABASE                    VALUE 2.              
P00128     05  WS-EXIST-DNP01          PIC X(01)  VALUE 'N'.            
P00128         88 ACTIVE-DNP01-PREEXISTS          VALUE 'Y'.            
P00128         88 NO-EXISTING-DNP01               VALUE 'N'.            
P00128     05  WS-CANCEL-REMARKS       PIC X(27)  VALUE                 
                   'DNP REPLACED DUE TO NEW DNP'.                       
A37741 01  S-RETURN-CODE               PIC S9(9) VALUE 0.               
       01  WS-ADDRESS-VARIABLES.                                        
COB305     05 WS-PR-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-PR-ADDRESS-FORMAT    PIC X(01).                       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-1                    PIC 9(01) VALUE 1.               
P00447     05  WS-0                    PIC 9(01) VALUE 0.               
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-SYSTEM               PIC X(09) VALUE 'SYSTEM'.        
           05  WS-2                    PIC X(01) VALUE '2'.             
           05  WS-3                    PIC X(01) VALUE '3'.             
P00128     05  WS-3I                   PIC X(02) VALUE '3I'.            
           05  WS-O                    PIC X(01) VALUE 'O'.             
           05  WS-I                    PIC X(01) VALUE 'I'.             
           05  WS-P                    PIC X(01) VALUE 'P'.             
           05  WS-UTIL                 PIC X(02) VALUE 'UT'.            
           05  WS-MTRD                 PIC X(02) VALUE 'MN'.            
           05  WS-UPDATE-REM           PIC X(22) VALUE                  
               'CREDIT HISTORY UPDATED'.                                
           05  WS-CURRENT-TS           PIC X(26).                       
           05  WS-REG                  PIC X(02) VALUE 'RG'.            
           05  WS-CUST                 PIC X(02) VALUE 'CP'.            
           05  WS-PARM-ERROR           PIC X(27) VALUE                  
                                       'TDRESULT - NO RPC PARM SENT'.   
           05  SCSCB068                PIC X(08) VALUE 'SCSCB068'.      
                                                                        
       01  WS-HOLDS.                                                    
           05  WS-ROW-NO-HOLD          PIC S9(04) COMP.                 
       01  WS-SERV-ORDER-NO-HOLD-01.                                    
           05  FILLER                  PIC S9(4) COMP.                  
           05  WS-SERV-ORDER-NO-HOLD   PIC X(13).                       
                                                                        
A1387      05  WS-WA-METER-IND-HOLD    PIC X(50).                       
           05  WS-WA-READ-ROUTE-HOLD   PIC X(04).                       
                                                                        
       01  WS-TEMPS.                                                    
           05  WS-SUB1                 PIC S9(04) COMP.                 
           05  WS-SUB2                 PIC S9(04) COMP.                 
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP      PIC S9(9) COMP VALUE 0.         
                                                                        
       COPY CCA00001.                                                           
       01  WS-WORK-AREA.                                                
           05  WS-SO-EXISTS                PIC X(01) VALUE 'Y'.         
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  SW-PROCESSING               PIC X(01) VALUE SPACES.      
           05  SW-RESULTS                  PIC X(01) VALUE 'Y'.         
               88 NO-MORE-RESULTS                    VALUE 'N'.         
               88 MORE-RESULTS                       VALUE 'Y'.         
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
           05  WS-RC                       PIC S9(4).                   
                                                                        
           05  WS-MV-FLAG                  PIC X  VALUE 'N'.            
               88  INSERT-MV      VALUE 'Y'.                            
           05  WS-ZERO                     PIC S9(09) COMP VALUE ZERO.  
           05  SW-UT-FETCH                 PIC X(01) VALUE 'N'.         
               88 SW-UT-FETCH-END          VALUE 'Y'.                   
           05  SW-MN-FETCH                 PIC X(01) VALUE 'N'.         
               88 SW-MN-FETCH-END          VALUE 'Y'.                   
           05  SW-RG-FETCH                 PIC X(01) VALUE 'N'.         
               88 SW-RG-FETCH-END          VALUE 'Y'.                   
           05  SW-CP-FETCH                 PIC X(01) VALUE 'N'.         
               88 SW-CP-FETCH-END          VALUE 'Y'.                   
           05  SW-WORK-FETCH               PIC X(01) VALUE 'N'.         
               88 SW-WORK-FETCH-END        VALUE 'Y'.                   
           05  SW-RELATED-SO-DATA          PIC X(01) VALUE 'N'.         
               88 SW-FOUND-NO-RELATED-SO   VALUE 'N'.                   
               88 SW-FOUND-RELATED-SO      VALUE 'Y'.                   
           05  WS-SUM-AMT-BOND         PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-SUM-AMT-GRNTD        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-SUM-AMT-DEPOSIT      PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-TOTAL-AMOUNT         PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND3            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND4            PIC S9(04) COMP VALUE +0.        
           05  WS-ARREARS-HIST         PIC X(24)    VALUE SPACES.       
           05  WS-DATE-CALC                  PIC X(10).                 
           05  WS-DATE-CTR                   PIC S9(04) COMP VALUE 0.   
           05  WS-DAY                        PIC S9(04) COMP VALUE +0.  
           05  WS-HOLD-INPUT-DATE            PIC X(10) VALUE SPACES.    
           05  WS-SWITCHES.                                             
               10  WS-BUSINESS-DAY-SW        PIC X(01) VALUE 'N'.       
                   88  NEXT-BUSINESS-DAY-NOT-FOUND     VALUE 'N'.       
                   88  NEXT-BUSINESS-DAY-FOUND         VALUE 'Y'.       
               10  WS-ROW-EXISTS             PIC X(01) VALUE 'N'.       
                   88  ROW-DOES-NOT-EXIST              VALUE 'N'.       
                   88  ROW-EXISTS                      VALUE 'Y'.       
           05  WS-EIBRESP                    PIC S9(8)                  
                                             COMP SYNC VALUE ZERO.      
           05  P-RETURN-PARM                 PIC S9(09) COMP VALUE +0.  
      *01 LOC-RESLTSET   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
A05020*01 LOC-RES04747   USAGE SQL TYPE IS                              
A05020*                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSSO104 ENDS HERE  '.            
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODTMF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFMT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRGREAD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRCAP                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSTPLN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOOIMF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRVDST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMODEL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCRTR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_UM_EQUIPMENT   >                                    
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_UNMTR_PLAN     >                                    
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_RATE_PLAN_DESC >                                    
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CRED_COLL      >                                    
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CUST_PREM_HIST >                                    
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_LANDLORD       >                                    
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_DEP_ON_HAND    >                                    
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SURETY_BOND    >                                    
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_GUARANTOR      >                                    
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CREDIT_PROFILE >                                    
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_BANKRUPTCY     >                                    
           EXEC SQL                                                             
              INCLUDE TBBNKRPT                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_DEP_INT_RATE   >                                    
           EXEC SQL                                                             
              INCLUDE TBDEPINT                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CUST_STATS     >                                    
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CUSTOMER       >                                    
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CWS00056           >                                    
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_MNT_TRANS_HIST >                                    
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_MT_TRANS_HIST >                                     
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_DELINQUENCY >                                       
P00128     EXEC SQL                                                             
P00128        INCLUDE TBDELQ                                                    
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_SO_DATA>                                            
P00128     EXEC SQL                                                             
P00128        INCLUDE TBSODAT                                                   
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_SO_REMARKS>                                         
P00128     EXEC SQL                                                             
P00128        INCLUDE TBSOREM                                                   
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_SO_REQUIREMENT>                                     
P00128     EXEC SQL                                                             
P00128        INCLUDE TBSOREQ                                                   
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_SO_UPDATE>                                          
P00128     EXEC SQL                                                             
P00128        INCLUDE TBSOUPD                                                   
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_SO_DNP>                                             
P00128     EXEC SQL                                                             
P00128        INCLUDE TBSODNP                                                   
P00128     END-EXEC.                                                            
                                                                        
P00128*-------< INCLUDE CSS_MKT_TRAN_OUTMF>                                     
P00128     EXEC SQL                                                             
P00128        INCLUDE TBMRKOMF                                                  
P00128     END-EXEC.                                                            
                                                                        
A05020*-------< INCLUDE CSS_LOCAL_OFFICE>                                       
A05020     EXEC SQL                                                             
A05020        INCLUDE TBLOCOFC                                                  
A05020     END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CWS00068           >                                    
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_HOLIDAY                           *           
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      * INCLUDE CSS_JOB_PARM                                        *           
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
           COPY CWS09900.                                                       
           COPY CWS0070B.                                                       
                                                                        
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
                                                                        
      * ERROR HANDLING                                                          
           COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      * SUPPORTS COMMUNICATION DATA FOR SERVICE ORDER                           
           COPY CCA00004.                                                       
      * LINKAGE SECTION VARIABLES FOR SCSCO068 .                                
      *    COPY CWS0068L.                                               01680000
                                                                        
      ******************************************************************        
      *       CWS00038 IS JC01 WORK DATA                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       CWS00039 IS CA00 WORK DATA                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   DB2 CURSOR DECLARATIONS                                    **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE SERV_ORDER_CURSOR CURSOR WITH HOLD FOR             
               SELECT PREMISE_NO             ,                          
                      ACCOUNT_NO             ,                          
                      COMPANY_NO             ,                          
                      ORDER_TYPE_CD          ,                          
                      LOCAL_OFFICE           ,                          
                      SERV_ORDER_STATUS      ,                          
                      WORK_INDICATOR         ,                          
                      ORDER_PLACED_BY        ,                          
                      ORDER_RECVED_BY        ,                          
                      WANTED_BY_AM_PM        ,                          
                      WANTED_BY_DATE         ,                          
                      DATE_FORECAST_DNP      ,                          
                      DATE_RECVED            ,                          
                      ORDER_REASON           ,                          
                      BACK_DATED             ,                          
                      RESP_AREA_ID           ,                          
                      MAKE_ARRANGEMENTS      ,                          
                      NOTIFY_CUST_IND        ,                          
                      NOTIFY_CSR_IND         ,                          
                      DEPOSIT_AMT            ,                          
                      INIT_BY_CONTRACT       ,                          
                      ORDER_PRIORITY_CD      ,                          
                      AMT_DNP_AT_BILLING     ,                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), SO_DATA_SEQ_NO
           , 121), ' ', '-'), ':', '.') SO_DATA_SEQ_NO         ,               
                      ORDER_STAT_REASON                                 
                 FROM CSS_SO_DATA_MF                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SERV_ORDER_CURSOR CURSOR WITH HOLD FOR                     
MFA-TR*        SELECT PREMISE_NO             ,                                  
MFA-TR*               ACCOUNT_NO             ,                                  
MFA-TR*               COMPANY_NO             ,                                  
MFA-TR*               ORDER_TYPE_CD          ,                                  
MFA-TR*               LOCAL_OFFICE           ,                                  
MFA-TR*               SERV_ORDER_STATUS      ,                                  
MFA-TR*               WORK_INDICATOR         ,                                  
MFA-TR*               ORDER_PLACED_BY        ,                                  
MFA-TR*               ORDER_RECVED_BY        ,                                  
MFA-TR*               WANTED_BY_AM_PM        ,                                  
MFA-TR*               WANTED_BY_DATE         ,                                  
MFA-TR*               DATE_FORECAST_DNP      ,                                  
MFA-TR*               DATE_RECVED            ,                                  
MFA-TR*               ORDER_REASON           ,                                  
MFA-TR*               BACK_DATED             ,                                  
MFA-TR*               RESP_AREA_ID           ,                                  
MFA-TR*               MAKE_ARRANGEMENTS      ,                                  
MFA-TR*               NOTIFY_CUST_IND        ,                                  
MFA-TR*               NOTIFY_CSR_IND         ,                                  
MFA-TR*               DEPOSIT_AMT            ,                                  
MFA-TR*               INIT_BY_CONTRACT       ,                                  
MFA-TR*               ORDER_PRIORITY_CD      ,                                  
MFA-TR*               AMT_DNP_AT_BILLING     ,                                  
MFA-TR*               SO_DATA_SEQ_NO         ,                                  
MFA-TR*               ORDER_STAT_REASON                                         
MFA-TR*          FROM CSS_SO_DATA_MF                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE UTILITY_CURSOR CURSOR FOR                          
               SELECT IC_NO                  ,                          
                      CODE_REVENUE_CLASS     ,                          
                      RATE_PLAN_NO           ,                          
                      READ_CYCLE             ,                          
                      READ_ROUTE             ,                          
                      CODE_SIC_NO            ,                          
                      CODE_UTIL_TYPE                                    
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
                  AND COMPANY_NO = :XE-COMPANY-NO                       
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE METER_CURSOR CURSOR FOR                            
               SELECT A.CODE_UTIL_TYPE        ,                         
                      A.IC_NO                 ,                         
                      A.METER_NO              ,                         
                      A.MTR_REF_NO            ,                         
                      A.CODE_TIME_PERIOD      ,                         
                      A.LAST_READ_VALUE       ,                         
                      A.LAST_REG_READ_DATE    ,                         
                      A.REG_ID_NO             ,                         
                      A.CODE_STATUS_REAS      ,                         
                      A.CODE_USAGE_TYPE       ,                         
                      A.CODE_USAGE_ID         ,                         
                      A.CODE_USAGE_SOURCE     ,                         
                      A.CODE_METER_STATUS     ,                         
                      A.METER_SUPPLYING       ,                         
                      A.CODE_METER_LOC        ,                         
                      B.CONSTANT              ,                         
                      B.NO_READ_DIALS         ,                         
                      B.CODE_CAP_TYPE         ,                         
                      A.POINT_ID              ,                         
                      A.SEAL_CODE_ID          ,                         
                      A.HEXAGRAM_LOCATION     ,                         
                      A.INSULATED_IND         ,                         
                      A.LOCK_TYPE_ID          ,                         
                      A.DELIVERY_LEVEL_CD     ,                         
                      A.UTILITY_SOURCE_CD     ,                         
                      A.IDR_RECIPIENT_CD      ,                         
                      A.PROGRAM_ID            ,                         
                      A.MTR_READ_SOURCE_CD    ,                         
                      A.GIS_POINT_ID          ,                         
                      A.METER_PRESSURE                                  
                 FROM CSS_MTRD_ENVRNMT A,                               
                      CSS_MTR_CAP      B                                
                WHERE A.ACCOUNT_NO     = :XE-ACCOUNT-NO                 
                  AND B.COMPANY_NO     = :MC-COMPANY-NO                 
                  AND B.METER_NO       = A.METER_NO                     
                  AND B.REG_ID_NO      = A.REG_ID_NO                    
                  AND B.CODE_UTIL_TYPE = A.CODE_UTIL_TYPE               
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE REGISTER_CURSOR CURSOR FOR                         
               SELECT RG.CODE_UTIL_TYPE      ,                          
                      RG.IC_NO               ,                          
                      RG.MTR_REF_NO          ,                          
                      MC.METER_NO            ,                          
                      RG.CODE_TIME_PERIOD    ,                          
                      RG.REG_ID_NO           ,                          
                      RG.LAST_READ_VALUE     ,                          
                      RG.LAST_REG_READ_DT    ,                          
                      RG.CODE_REG_STATUS     ,                          
                      RG.CODE_STATUS_REAS    ,                          
                      RG.CODE_USAGE_TYPE     ,                          
                      RG.CODE_USAGE_ID       ,                          
                      RG.CODE_USAGE_SOURCE   ,                          
                      MC.CONSTANT            ,                          
                      MC.NO_READ_DIALS                                  
                 FROM CSS_REGISTER_READ RG,                             
                      CSS_MTR_CAP       MC                              
                WHERE RG.ACCOUNT_NO     = :XE-ACCOUNT-NO                
                  AND MC.COMPANY_NO     = :MC-COMPANY-NO                
                  AND RG.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE             
                  AND RG.METER_NO       = MC.METER_NO                   
                  AND RG.REG_ID_NO      = MC.REG_ID_NO                  
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE CUST_PLAN_CURSOR CURSOR FOR                        
               SELECT CP.CODE_UTIL_TYPE        ,                        
                      CP.IC_NO                 ,                        
                      CP.CODE_PLAN_STATUS      ,                        
                      CP.CODE_STAT_REASON      ,                        
                      CP.CODE_SERVICE_TYPE     ,                        
                      CP.RATE_ITEM_CODE        ,                        
                      CP.MTHLY_AMOUNT_FIXED    ,                        
                      CP.LIGHT_NO              ,                        
                      CP.POLE_NO               ,                        
                      CP.USAGE_FIXED           ,                        
                      CP.NO_UNITS              ,                        
                      CP.DIST_NO               ,                        
                      UT.RATE_PLAN_NO          ,                        
                      UT.CODE_REVENUE_CLASS    ,                        
                      CP.ITEM_SEQ_NO                                    
                 FROM CSS_CUST_PLAN    CP,                              
                      CSS_UTIL_ENVRNMT UT                               
                WHERE CP.ACCOUNT_NO     = :XE-ACCOUNT-NO                
                  AND UT.ACCOUNT_NO     = :XE-ACCOUNT-NO                
                  AND CP.ACCOUNT_NO     = UT.ACCOUNT_NO                 
                  AND CP.IC_NO          = UT.IC_NO                      
                  AND UT.CODE_UTIL_TYPE = 'U'                           
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE ORDER_INST_CURSOR CURSOR FOR                       
              SELECT WB.CODE_UTIL_TYPE ,                                
                     WB.CODE_METER_LOC ,                                
                     WB.WORK_TYPE_CD   ,                                
                     MN.IC_NO          ,                                
                     WB.METER_NO       ,                                
                     WB.SO_INST_SEQ_NO ,                                
                     WB.METER_SUPPLYING,                                
                     MN.MTR_REF_NO     ,                                
                     MN.CODE_METER_STATUS                               
                FROM CSS_SO_ORD_INST_MF WB,                             
                     CSS_MTRD_ENVRNMT   MN                              
               WHERE MN.ACCOUNT_NO     = :XE-ACCOUNT-NO                 
A03308           AND SO_DATA_SEQ_NO    = CIS.CHAR2TIMESTAMP(
                                                     :XE-SO-DATA-SEQ-NO
              )             
                 AND WB.ACCOUNT_NO     = MN.ACCOUNT_NO                  
                 AND MN.CODE_UTIL_TYPE = WB.CODE_UTIL_TYPE              
                 AND MN.METER_NO       = WB.METER_NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ORDER_INST_CURSOR CURSOR FOR                               
MFA-TR*       SELECT WB.CODE_UTIL_TYPE ,                                        
MFA-TR*              WB.CODE_METER_LOC ,                                        
MFA-TR*              WB.WORK_TYPE_CD   ,                                        
MFA-TR*              MN.IC_NO          ,                                        
MFA-TR*              WB.METER_NO       ,                                        
MFA-TR*              WB.SO_INST_SEQ_NO ,                                        
MFA-TR*              WB.METER_SUPPLYING,                                        
MFA-TR*              MN.MTR_REF_NO     ,                                        
MFA-TR*              MN.CODE_METER_STATUS                                       
MFA-TR*         FROM CSS_SO_ORD_INST_MF WB,                                     
MFA-TR*              CSS_MTRD_ENVRNMT   MN                                      
MFA-TR*        WHERE MN.ACCOUNT_NO     = :XE-ACCOUNT-NO                         
MFA-TR*          AND SO_DATA_SEQ_NO    = :XE-SO-DATA-SEQ-NO                     
MFA-TR*          AND WB.ACCOUNT_NO     = MN.ACCOUNT_NO                          
MFA-TR*          AND MN.CODE_UTIL_TYPE = WB.CODE_UTIL_TYPE                      
MFA-TR*          AND MN.METER_NO       = WB.METER_NO                            
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
             DECLARE METER_IND_CURSOR CURSOR FOR                        
              SELECT CODE_CAP_TYPE,                                     
                     CONSTANT                                           
                FROM CSS_MTR_CAP                                        
               WHERE METER_NO = :WB-METER-NO                            
                 AND COMPANY_NO     = :MC-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :WB-CODE-UTIL-TYPE                
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE CRED_COLL_CURSOR CURSOR FOR                        
              SELECT CODE_NOTICE_TYPE                                   
                FROM CSS_CRED_COLL                                      
               WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                
                 AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                 :CL-DATE-CREDIT-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION) )        
                 AND CODE_NOTICE_TYPE IN ('D','G','H','I',              
                                          'C','F','S','U')              
                 ORDER BY CODE_NOTICE_TYPE                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CRED_COLL_CURSOR CURSOR FOR                                
MFA-TR*       SELECT CODE_NOTICE_TYPE                                           
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                        
MFA-TR*          AND DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION                
MFA-TR*          AND CODE_NOTICE_TYPE IN ('D','G','H','I',                      
MFA-TR*                                   'C','F','S','U')                      
MFA-TR*          ORDER BY CODE_NOTICE_TYPE                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE NON_UTIL_CURSOR CURSOR FOR                         
              SELECT CODE_NOTICE_TYPE                                   
                FROM CSS_CRED_COLL                                      
               WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                
                 AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                 :CL-DATE-CREDIT-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION) )        
                 AND CODE_NOTICE_TYPE IN ('S','U')                      
                 ORDER BY CODE_NOTICE_TYPE                              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NON_UTIL_CURSOR CURSOR FOR                                 
MFA-TR*       SELECT CODE_NOTICE_TYPE                                           
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                        
MFA-TR*          AND DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION                
MFA-TR*          AND CODE_NOTICE_TYPE IN ('S','U')                              
MFA-TR*          ORDER BY CODE_NOTICE_TYPE                                      
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR CURSOR
MSQ001          FOR CALL CSR00224 ( :WS-WA-LOCAL-OFFICE
                  , :WS-WA-CODE-UTIL-TYPE
                  , :WS-WA-WORK-TYPE-CD
                  , :WS-WA-METER-IND
                  , :WS-WA-ZIP-CODE
                  , :WS-WA-READ-ROUTE
                  , :WS-WA-WORK-AREA
                  , :WS-WA-BUSINESS-UNIT
                  , :WS-ROW-NO
                  , :WS-PREMISE-NO
                  , :WS-ACCOUNT-NO
                  , :WS-ACCOUNT-NO-PRIOR
                  , :WS-SERV-ORDER-NO
                  , :WS-ORDER-TYPE-CD
                  , :WS-LOCAL-OFFICE
                  , :WS-PHONE-NO-EXT
                  , :WS-PHONE-NO
                  , :WS-ORDER-PLACED-BY
                  , :WS-ORDER-RECVED-BY
                  , :WS-WANTED-BY-DATE
                  , :WS-DATE-FORECAST-DNP
                  , :WS-ASSIGNED-DATETIME
                  , :WS-ORDER-REASON
                  , :WS-BACK-DATED-IND
                  , :WS-RESP-AREA-ID
                  , :WS-CALL-BEFORE-MIN
                  , :WS-NOTIFY-CUST-IND
                  , :WS-NOTIFY-CSR-IND
                  , :WS-BREAKERS-OFF
                  , :WS-DEPOSIT-AMT-CHAR
                  , :WS-AMT-DNP-AT-BILL-CHAR
                  , :WS-INIT-BY-CNTRCT
                  , :WS-WORK-AREA-ID
                  , :WS-BUSINESS-UNIT
                  , :WS-ORDER-PRIORITY
                  , :WS-ORDER-STATE-CD
                  , :WS-WORK-TYPE-CD
                  , :WS-CODE-UTIL-TYPE
                  , :WS-STD-CHG-AMT-CHAR
                  , :WS-HOLD-RELEASE
                  , :WS-RLSE-REQUIRED-IND
                  , :WS-PER-TEMP-IND
                  , :WS-RLSE-NO
                  , :WS-RLSE-DATE
                  , :WS-SO-INST-SEQ-NO
                  , :WS-TABLE-ID
                  , :WS-UT-CODE-UTIL-TYPE
                  , :WS-IC-NO
                  , :WS-UT-READ-ROUTE
                  , :WS-RATE-PLAN-NO
                  , :WS-UT-CODE-REV-CLASS
                  , :WS-UT-READ-CYCLE
                  , :WS-UT-CODE-SIC-NO
                  , :WS-METER-NO
                  , :WS-MN-MTR-REF-NO
                  , :WS-MN-CODE-TIME-PERIOD
                  , :WS-MN-LAST-RD-VAL-CHAR
                  , :WS-MN-CODE-STATUS-REAS
                  , :WS-MN-CODE-USAGE-TYPE
                  , :WS-MN-CODE-USAGE-ID
                  , :WS-MN-CODE-USAGE-SOURCE
                  , :WS-CODE-METER-STATUS
                  , :WS-METER-SUPPLYING
                  , :WS-CODE-METER-LOC
                  , :WS-MN-CONSTANT-CHAR
                  , :WS-MN-NO-DIALS
                  , :WS-MN-POINT-ID
                  , :WS-MN-SEAL-CODE-ID
                  , :WS-MN-HEXAGRAM-LOCATION
                  , :WS-MN-INSULATED-IND
                  , :WS-MN-LOCK-TYPE-ID
                  , :WS-MN-DELIVERY-LEVEL-CD
                  , :WS-MN-UTILITY-SOURCE-CD
                  , :WS-MN-IDR-RECIPIENT-CD
                  , :WS-MN-PROGRAM-ID
                  , :WS-MN-MTR-READ-SOURCE-CD
                  , :WS-MN-LAST-READ-DT
                  , :WS-MN-REG-ID-NO
                  , :WS-RG-CODE-REG-STATUS
                  , :WS-RG-CODE-STATUS-REAS
                  , :WS-RG-CODE-TIME-PERIOD
                  , :WS-RG-CODE-USAGE-ID
                  , :WS-RG-CODE-USAGE-SOURCE
                  , :WS-RG-CODE-USAGE-TYPE
                  , :WS-RG-LAST-READ-DT
                  , :WS-RG-LAST-RD-VAL-CHAR
                  , :WS-RG-REG-ID-NO
                  , :WS-CP-NO-UNITS
                  , :WS-CP-CODE-PLAN-STATUS
                  , :WS-CP-CODE-STAT-REASON
                  , :WS-CP-CODE-SERVICE-TYPE
                  , :WS-CP-MTLY-AMT-FIX-CHAR
                  , :WS-CP-RATE-ITEM-CODE
                  , :WS-CP-LIGHT-NO
                  , :WS-CP-POLE-NO
                  , :WS-CP-DIST-NO
                  , :WS-CP-USAGE-FIXED-CHAR
                  , :WS-CP-EQUIP-ID
                  , :WS-APPLIANCE-CD
                  , :WS-APPLIANCE-SEQ-NO
                  , :WS-EQUIP-OWNER
                  , :WS-MK-CODE-UTIL-TYPE
                  , :WS-LEAK-IND
                  , :WS-LIGHT-IND
                  , :WS-REPAIR-IND
                  , :WS-CUTOFF-IND
                  , :WS-CAUTION-TAG-IND
                  , :WS-IMPROPER-REASON
                  , :WS-EQUIPMENT-UNQ
                  , :WS-VERIFY-RATE
                  , :WS-ORDER-INST-PRESENT
                  , :WS-EQUIPMENT-PRESENT
                  , :WS-UTIL-ENV-PRESENT
                  , :WS-NEW-ORDER
                  , :WS-PANEL-NO
                  , :WS-INCLUDE-INST
                  , :WS-REV-DIST-CD
                  , :WS-USER-ID-SP
                  , :WS-SO-EST-LABOR-HR-CHAR
                  , :WS-ACCT-STATUS
                  , :WS-PPS-ORDER-CHAR
                  , :WS-REORDER-FLAG
                  , :WS-WA-LAST-CALL
                  , :WS-COMPANY-NO
                  , :WS-OLD-ACCT-STATUS
                  , :WS-DISC-BAL-CHAR
                  , :WS-SEC-TOT-AMT-CHAR
                  , :WS-CUR-MTH-ARREARS-CD
                  , :WS-CREDIT-GROUP
                  , :WS-DNP-REC
                  , :WS-ACCOUNT-TYPE-CODE
                  , :WS-INSTALL-IND
                  , :WS-CP-ITEM-SEQ-NO
                  , :WS-MN-METER-PRESSURE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
      *01  DFHCOMMAREA.                                                         
      *    05  DFHCOMMAREA-CMN     PIC X(600).                                  
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *     0000-MAINLINE                                              *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0110-GET-NEXT-BUSINESS-DATE.                                            
      ******************************************************************        
       0110-GET-NEXT-BUSINESS-DATE.                                     
                                                                        
           MOVE '0110' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           PERFORM 7030-GET-NEXT-DAY                 THRU 7030-EXIT     
           VARYING WS-DATE-CTR FROM WS-DATE-CTR BY +1                   
             UNTIL WS-DAY NOT EQUAL ZEROES AND WS-DAY NOT EQUAL 6.      
                                                                        
           MOVE WS-HOLD-INPUT-DATE TO J8-HOLIDAY-DT.                    
           PERFORM 7040-SELECT-HOLIDAY               THRU 7040-EXIT.    
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
           PERFORM 5000-INSERT                THRU 5000-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-INSERT                                                    *        
      ******************************************************************        
       5000-INSERT.                                                     
                                                                        
           MOVE '5000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 5010-INITIALIZE-ROW        THRU 5010-EXIT.           
           INITIALIZE WS-WANTED-BY-DATE.                                
           PERFORM 7005-GET-CURRENT-DATE      THRU 7005-EXIT.           
           PERFORM 7010-OPEN-SO-CURSOR        THRU 7010-EXIT.           
           PERFORM 7020-FETCH-SO-CURSOR       THRU 7020-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN                    
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 PERFORM 5040-GET-RLSE-IND        THRU 5040-EXIT        
                 PERFORM 5050-GET-ACCT-INFO       THRU 5050-EXIT        
                 MOVE AT-COMPANY-NO               TO MC-COMPANY-NO      
                 MOVE WS-ACCT-STATUS              TO AT-CODE-ACCT-STAT  
                 PERFORM 5060-FETCH-SUBDIV-LIGHT  THRU 5060-EXIT        
                 IF XE-ORDER-TYPE-CD = 'DNP01'                          
P00128*            IF XE-ORDER-REASON = 'N' OR 'O'                              
P00471             IF XE-ORDER-REASON = 'N' OR 'O' OR 'J' OR 'K'        
P00471                                             OR 'U' OR 'V'        
P00128               PERFORM 7900-GET-DATABASE THRU 7900-EXIT           
P00128               IF SEB-DATABASE                                    
P00128                 PERFORM 5400-CHECK-FOR-EXIST-DNP01 THRU 5400-EXIT
P00128                 IF ACTIVE-DNP01-PREEXISTS                        
P00128                    PERFORM 7755-CANCEL-DNP01   THRU 7755-EXIT    
P00128                    PERFORM 7756-COMPUTE-STATUS-A THRU 7756-EXIT  
P00128                    IF EG-SERV-ORDER-STATUS = ' '                 
P00128                      PERFORM 7757-COMPUTE-STATUS-D THRU 7757-EXIT
P00128                    END-IF                                        
P00128                    PERFORM 7758-INSERT-SOUP    THRU 7758-EXIT    
P00128                                                                  
P00128     MOVE 'C'                           TO EF-REMARK-TYPE-CD      
P00128     MOVE 27                            TO EF-REMARK-TX-LEN       
P00128     MOVE WS-CANCEL-REMARKS             TO EF-REMARK-TX-TEXT      
P00128     MOVE VO-SERV-ORDER-NO              TO EF-SERV-ORDER-NO       
P00128                                                                  
P00128                    PERFORM 7759-INS-SO-REMARKS THRU 7759-EXIT    
P00128                    PERFORM 7760-UPD-SO-DNP     THRU 7760-EXIT    
P00128                 END-IF                                           
P00128               END-IF                                             
P00128             END-IF                                               
                   PERFORM 5011-INIT-CPD00068-FLDS THRU 5011-EXIT       
                   PERFORM 7994-GET-SO-DNP-DETLS   THRU 7994-EXIT       
                   MOVE WS-Y                       TO WS-DNP-REC        
                 END-IF                                                 
                 PERFORM 5020-INSERT-ROWS           THRU 5020-EXIT      
                 IF XE-ORDER-TYPE-CD = 'DNP01' OR 'NOT01'               
                    IF WS-SERV-ORDER-NO(1:1) = '0'                      
                      MOVE XE-DATE-RECVED TO CL-DATE-CREDIT-ACTION      
                      PERFORM 7880-UPDT-SO-FAILED-IND THRU 7880-EXIT    
                    ELSE                                                
                      PERFORM 5250-PROCESS-ACCT-UPD THRU 5250-EXIT      
                    END-IF                                              
                 END-IF                                                 
A04228          IF XE-ORDER-TYPE-CD = 'DNP01' AND                       
A04228               XE-ORDER-PLACED-BY NOT EQUAL 'SYSTEM' AND          
A04228                 WS-SERV-ORDER-NO(1:1) NOT EQUAL '0' THEN         
A04228     MOVE 'G'                           TO EF-REMARK-TYPE-CD      
A04228     MOVE 25                            TO EF-REMARK-TX-LEN       
A04228     MOVE XE-ORDER-PLACED-BY            TO EF-REMARK-TX-TEXT      
A04228     MOVE WS-SERV-ORDER-NO              TO EF-SERV-ORDER-NO       
A04228           PERFORM 7759-INS-SO-REMARKS THRU 7759-EXIT             
A04228           END-IF                                                 
A05020           IF CSR-DATABASE AND                                    
A05020              XE-ORDER-TYPE-CD = 'DNP01' AND                      
A05020              WS-SERV-ORDER-NO(1:1) NOT EQUAL '0'                 
A05020                 PERFORM 5300-INSERT-TASK-Q   THRU 5300-EXIT      
A05020           END-IF                                                 
A05020           IF CSR-DATABASE AND XE-COMPANY-NO = '26' AND           
A05020              WS-SERV-ORDER-NO(1:1) NOT EQUAL '0'                 
A05020                 PERFORM 8100-UPD-PSNC-BIZ-UNIT  THRU 8100-EXIT   
A05020           END-IF                                                 
A05020           IF CSR-DATABASE AND XE-COMPANY-NO = '01' AND           
A05020              WS-SERV-ORDER-NO(1:1) NOT EQUAL '0'                 
A05020                 MOVE SPACES                 TO WS-GAS-DISTRICT   
A05020                 PERFORM 7995-GET-GAS-DISTRICTS  THRU 7995-EXIT   
A05020                 IF WS-GAS-DISTRICT = 'Y'                         
A05020                    PERFORM 8200-UPD-SCEG-BIZ-UNIT THRU 8200-EXIT 
A05020                 END-IF                                           
A05020           END-IF                                                 
                 PERFORM 8000-DELETE-SO-DATA-MF     THRU 8000-EXIT      
                 PERFORM 9600-COMMIT-WORK           THRU 9600-EXIT      
                 PERFORM 7020-FETCH-SO-CURSOR       THRU 7020-EXIT      
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           PERFORM 7025-CLOSE-SO-CURSOR         THRU 7025-EXIT.         
                                                                        
           MOVE 0                               TO RS-RETURN-CODE.      
           MOVE 'DONE'                          TO ACTIVE-PARAGRAPH.    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5010-INITIALIZE-ROW                                            *        
      ******************************************************************        
       5010-INITIALIZE-ROW.                                             
                                                                        
           INITIALIZE                         WS-WA-WORK-AREA           
P00718                                        WS-WA-BUSINESS-UNIT       
                                              WS-ROW-NO                 
                                              WS-PREMISE-NO             
                                              WS-ACCOUNT-NO             
                                              WS-ACCOUNT-NO-PRIOR       
                                              WS-SERV-ORDER-NO          
                                              WS-ORDER-TYPE-CD          
                                              WS-LOCAL-OFFICE           
                                              WS-PHONE-NO-EXT           
                                              WS-PHONE-NO               
                                              WS-ORDER-PLACED-BY        
                                              WS-ORDER-RECVED-BY        
                                              WS-ORDER-REASON           
                                              WS-BACK-DATED-IND         
                                              WS-RESP-AREA-ID           
                                              WS-CALL-BEFORE-MIN        
                                              WS-NOTIFY-CUST-IND        
                                              WS-NOTIFY-CSR-IND         
                                              WS-BREAKERS-OFF           
                                              WS-DEPOSIT-AMT            
                                              WS-AMT-DNP-AT-BILLING     
                                              WS-INIT-BY-CNTRCT         
                                              WS-WORK-AREA-ID           
P00718                                        WS-BUSINESS-UNIT          
                                              WS-ORDER-PRIORITY         
                                              WS-ORDER-STATE-CD         
                                              WS-WORK-TYPE-CD           
                                              WS-CODE-UTIL-TYPE         
                                              WS-STD-CHG-AMT            
                                              WS-HOLD-RELEASE           
                                              WS-PER-TEMP-IND           
                                              WS-RLSE-NO                
                                              WS-RLSE-DATE              
                                              WS-SO-INST-SEQ-NO         
                                              WS-TABLE-ID               
                                              WS-UT-CODE-UTIL-TYPE      
                                              WS-IC-NO                  
                                              WS-UT-READ-ROUTE          
                                              WS-RATE-PLAN-NO           
                                              WS-UT-CODE-REV-CLASS      
                                              WS-UT-READ-CYCLE          
                                              WS-UT-CODE-SIC-NO         
                                              WS-METER-NO               
                                              WS-MN-MTR-REF-NO          
                                              WS-MN-CODE-TIME-PERIOD    
                                              WS-MN-LAST-READ-VALUE     
                                              WS-MN-CODE-STATUS-REAS    
                                              WS-MN-CODE-USAGE-TYPE     
                                              WS-MN-CODE-USAGE-ID       
                                              WS-MN-CODE-USAGE-SOURCE   
                                              WS-CODE-METER-STATUS      
                                              WS-METER-SUPPLYING        
                                              WS-CODE-METER-LOC         
                                              WS-MN-CONSTANT            
                                              WS-MN-NO-DIALS            
                                              WS-MN-POINT-ID            
                                              WS-MN-SEAL-CODE-ID        
                                              WS-MN-HEXAGRAM-LOCATION   
                                              WS-MN-INSULATED-IND       
                                              WS-MN-LOCK-TYPE-ID        
                                              WS-MN-DELIVERY-LEVEL-CD   
                                              WS-MN-UTILITY-SOURCE-CD   
                                              WS-MN-IDR-RECIPIENT-CD    
                                              WS-MN-PROGRAM-ID          
                                              WS-MN-MTR-READ-SOURCE-CD  
                                              WS-MN-LAST-READ-DT        
                                              WS-MN-METER-PRESSURE      
                                              WS-MN-REG-ID-NO           
                                              WS-RG-CODE-REG-STATUS     
                                              WS-RG-CODE-STATUS-REAS    
                                              WS-RG-CODE-TIME-PERIOD    
                                              WS-RG-CODE-USAGE-ID       
                                              WS-RG-CODE-USAGE-SOURCE   
                                              WS-RG-CODE-USAGE-TYPE     
                                              WS-RG-LAST-READ-DT        
                                              WS-RG-LAST-READ-VALUE     
                                              WS-RG-REG-ID-NO           
                                              WS-CP-NO-UNITS            
                                              WS-CP-CODE-PLAN-STATUS    
                                              WS-CP-CODE-STAT-REASON    
                                              WS-CP-CODE-SERVICE-TYPE   
                                              WS-CP-MNTHLY-AMT-FIXED    
                                              WS-CP-RATE-ITEM-CODE      
                                              WS-CP-LIGHT-NO            
                                              WS-CP-POLE-NO             
                                              WS-CP-DIST-NO             
                                              WS-CP-USAGE-FIXED         
                                              WS-CP-EQUIP-ID            
                                              WS-APPLIANCE-CD           
                                              WS-APPLIANCE-SEQ-NO       
                                              WS-EQUIP-OWNER            
                                              WS-MK-CODE-UTIL-TYPE      
                                              WS-LEAK-IND               
                                              WS-LIGHT-IND              
                                              WS-REPAIR-IND             
                                              WS-CUTOFF-IND             
                                              WS-INSTALL-IND            
                                              WS-CP-ITEM-SEQ-NO         
                                              WS-CAUTION-TAG-IND        
                                              WS-IMPROPER-REASON        
                                              WS-EQUIPMENT-UNQ          
                                              WS-VERIFY-RATE            
                                              WS-ORDER-INST-PRESENT     
                                              WS-EQUIPMENT-PRESENT      
                                              WS-UTIL-ENV-PRESENT       
                                              WS-NEW-ORDER              
                                              WS-PANEL-NO               
                                              WS-INCLUDE-INST           
                                              WS-REV-DIST-CD            
                                              WS-SO-EST-LABOR-HR        
                                              WS-ACCT-STATUS            
                                              WS-PRICE-PER-SERV-ORDER   
                                              WS-REORDER-FLAG           
                                              WS-COMPANY-NO             
                                              WS-DISC-BAL               
                                              WS-SECURITIES-TOT-AMT     
                                              WS-CUR-MTH-ARREARS-CD     
                                              WS-CREDIT-GROUP.          
              MOVE WS-NO                      TO WS-WA-LAST-CALL        
                                                 WS-DNP-REC.            
A00520        MOVE ZEROS                      TO WS-ORDER-PRIORITY.     
REARCH        MOVE '0'                        TO WS-PREMISE-NO          
REARCH                                           WS-ACCOUNT-NO          
REARCH                                           WS-ACCOUNT-NO-PRIOR    
REARCH*                                           WS-ORDER-PRIORITY             
REARCH                                           WS-DEPOSIT-AMT         
REARCH                                           WS-DISC-BAL            
REARCH                                           WS-SECURITIES-TOT-AMT  
REARCH                                           WS-AMT-DNP-AT-BILLING  
REARCH                                           WS-STD-CHG-AMT         
REARCH                                           WS-MN-LAST-READ-VALUE  
REARCH                                           WS-MN-CONSTANT         
REARCH                                           WS-RG-LAST-READ-VALUE  
REARCH                                           WS-CP-MNTHLY-AMT-FIXED 
REARCH                                           WS-CP-USAGE-FIXED      
REARCH                                           WS-SO-EST-LABOR-HR.    
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5011-INIT-CPD00068-FLDS                                        *        
      ******************************************************************        
       5011-INIT-CPD00068-FLDS.                                         
                                                                        
           INITIALIZE WS-DT-25-DAYS-AGO                                 
                      WS-DT-45-DAYS-AGO                                 
                      WS-HOLD-DATE                                      
                      WS-DATE-BILL-DUE                                  
                      WS-DATE-ARREARS-DUE                               
                      WS-DATE-CREDIT-ACTION-M                           
                      WS-DATE-NOTICE-DUE-M                              
                      WS-DATE-NOTICE-MAIL-M                             
                      WS-DATE-BILL-M                                    
                      WS-AMT-60-90-DAY                                  
                      WS-AMT-DNP-BAL                                    
                      WS-TOTAL-DISCONNECT-BAL                           
                      WS-AMT-NSF-DNP                                    
                      WS-AMT-DNP-TOTAL                                  
                      WS-AMT-DNP-RET-CHECK                              
                      WS-AMT-00-DAY-DPP                                 
                      WS-ITEM-ID-A                                      
                      WS-ITEM-ID-B                                      
                      WS-ITEM-ID-C                                      
                      WS-ITEM-ID-D                                      
                      WS-ITEM-ID-E                                      
                      WS-ITEM-ID-F                                      
                      WS-ITEM-ID-G                                      
                      WS-ITEM-ID-H                                      
                      WS-ITEM-ID-I                                      
                      WS-ITEM-ID-K                                      
                      WS-ITEM-ID-L                                      
                      WS-ITEM-ID-M                                      
                      WS-ITEM-ID-N                                      
                      WS-ITEM-ID-O                                      
                      WS-ITEM-ID-P                                      
                      WS-ITEM-ID-Q                                      
                      WS-ITEM-ID-R                                      
                      WS-ITEM-ID-S                                      
                      WS-ITEM-ID-T                                      
                      WS-ITEM-ID-U                                      
                      WS-ITEM-ID-V                                      
                      WS-ITEM-ID-W                                      
                      WS-ITEM-ID-X                                      
                      WS-HOLD-DNP-TYPE                                  
                      WS-CODE-FRCST-CR-GRP-A                            
                      WS-CODE-FRCST-CR-GRP-B                            
                      WS-CODE-FRCST-CR-GRP-C                            
                      WS-CODE-FRCST-CR-GRP-D                            
                      WS-CODE-FRCST-CR-GRP-E                            
                      WS-CODE-FRCST-CR-GRP-F                            
                      WS-CODE-FRCST-CR-GRP-G                            
                      WS-CODE-FRCST-CR-GRP-H                            
                      WS-CODE-FRCST-CR-GRP-I                            
                      WS-CODE-FRCST-CR-GRP-K                            
                      WS-CODE-FRCST-CR-GRP-L                            
                      WS-CODE-FRCST-CR-GRP-M                            
                      WS-CODE-FRCST-CR-GRP-N                            
                      WS-CODE-FRCST-CR-GRP-O                            
                      WS-CODE-FRCST-CR-GRP-P                            
                      WS-CODE-FRCST-CR-GRP-Q                            
                      WS-CODE-FRCST-CR-GRP-R                            
                      WS-CODE-FRCST-CR-GRP-S                            
                      WS-CODE-FRCST-CR-GRP-T                            
                      WS-CODE-FRCST-CR-GRP-U                            
                      WS-CODE-FRCST-CR-GRP-V                            
                      WS-CODE-FRCST-CR-GRP-W                            
                      WS-CODE-FRCST-CR-GRP-X.                           
                                                                        
       5011-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-INSERT-ROWS                                               *        
      ******************************************************************        
       5020-INSERT-ROWS.                                                
                                                                        
           MOVE '5020'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE                         WS-ROW-NO-HOLD            
                                              WS-SERV-ORDER-NO-HOLD     
                                              WS-SERV-ORDER-NO          
                                              WS-WA-METER-IND-HOLD      
                                              WS-WA-READ-ROUTE-HOLD.    
           MOVE '0'                           TO WS-SERV-ORDER-NO.      
                                                                        
           MOVE WS-1                          TO WS-ROW-NO              
                                                 WS-ROW-NO-HOLD.        
                                                                        
           MOVE WS-NO                         TO SW-UT-FETCH            
                                                 SW-MN-FETCH            
                                                 SW-RG-FETCH            
                                                 SW-CP-FETCH            
REARCH                                           SW-WORK-FETCH.         
                                                                        
           MOVE PROGRAM-NAME                  TO WS-PANEL-NO.           
                                                                        
           PERFORM 7110-OPEN-UTIL-CURSOR      THRU 7110-EXIT.           
           PERFORM 7120-FETCH-UTIL-CURSOR     THRU 7120-EXIT.           
                                                                        
           IF SW-UT-FETCH-END THEN                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '502A'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UT INFO NOT AVAI'         TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM UNTIL SW-UT-FETCH-END                                
              MOVE UT-IC-NO                   TO WS-IC-NO               
              MOVE UT-CODE-REVENUE-CLASS      TO WS-UT-CODE-REV-CLASS   
              MOVE UT-READ-CYCLE              TO WS-UT-READ-CYCLE       
              MOVE UT-RATE-PLAN-NO            TO WS-RATE-PLAN-NO        
A03468        MOVE UT-CODE-SIC-NO             TO WS-UT-CODE-SIC-NO      
              MOVE UT-READ-ROUTE              TO WS-UT-READ-ROUTE       
APL507*                                          WS-WA-READ-ROUTE-HOLD          
APL507        IF WS-WA-READ-ROUTE-HOLD EQUAL SPACES                     
APL507           MOVE WS-UT-READ-ROUTE        TO WS-WA-READ-ROUTE-HOLD  
APL507        END-IF                                                    
APL507*                                                                         
              MOVE UT-CODE-UTIL-TYPE          TO WS-UT-CODE-UTIL-TYPE   
                                                                        
              MOVE WS-YES                     TO WS-UTIL-ENV-PRESENT    
              MOVE WS-UTIL                    TO WS-TABLE-ID            
                                                                        
              PERFORM 7120-FETCH-UTIL-CURSOR THRU 7120-EXIT             
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7130-CLOSE-UTIL-CURSOR    THRU 7130-EXIT             
                                                                        
           PERFORM 7210-OPEN-MTRD-CURSOR     THRU 7210-EXIT.            
           PERFORM 7220-FETCH-MTRD-CURSOR    THRU 7220-EXIT.            
                                                                        
           IF SW-MN-FETCH-END THEN                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '502B'                     TO ACTIVE-PARAGRAPH       
              MOVE 'MN AND MC NOT AVAI'       TO TABLE-1                
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           INITIALIZE                         WS-SUB1.                  
                                                                        
           PERFORM UNTIL SW-MN-FETCH-END                                
                                                                        
              MOVE MN-IC-NO                  TO WS-IC-NO                
              MOVE MN-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE       
                                                WS-UT-CODE-UTIL-TYPE    
              MOVE MN-METER-NO               TO WS-METER-NO             
              MOVE MN-MTR-REF-NO             TO WS-MN-MTR-REF-NO        
              MOVE MN-CODE-TIME-PERIOD       TO WS-MN-CODE-TIME-PERIOD  
              MOVE MN-LAST-READ-VALUE        TO WS-MN-LAST-READ-VALUE   
              MOVE MN-LAST-REG-READ-DATE     TO WS-MN-LAST-READ-DT      
              MOVE MN-REG-ID-NO              TO WS-MN-REG-ID-NO         
              MOVE MN-CODE-STATUS-REAS       TO WS-MN-CODE-STATUS-REAS  
              MOVE MN-CODE-USAGE-TYPE        TO WS-MN-CODE-USAGE-TYPE   
              MOVE MN-CODE-USAGE-ID          TO WS-MN-CODE-USAGE-ID     
              MOVE MN-CODE-USAGE-SOURCE      TO WS-MN-CODE-USAGE-SOURCE 
              MOVE MN-CODE-METER-STATUS      TO WS-CODE-METER-STATUS    
              MOVE MN-METER-SUPPLYING        TO WS-METER-SUPPLYING      
              MOVE MN-CODE-METER-LOC         TO WS-CODE-METER-LOC       
              MOVE MC-CONSTANT               TO WS-MN-CONSTANT          
              MOVE MC-NO-READ-DIALS          TO WS-MN-NO-DIALS          
              MOVE MN-GIS-POINT-ID           TO WS-MN-POINT-ID          
              MOVE MN-SEAL-CODE-ID           TO WS-MN-SEAL-CODE-ID      
              MOVE MN-HEXAGRAM-LOCATION      TO WS-MN-HEXAGRAM-LOCATION 
              MOVE MN-INSULATED-IND          TO WS-MN-INSULATED-IND     
              MOVE MN-LOCK-TYPE-ID           TO WS-MN-LOCK-TYPE-ID      
              MOVE MN-DELIVERY-LEVEL-CD      TO WS-MN-DELIVERY-LEVEL-CD 
              MOVE MN-UTILITY-SOURCE-CD      TO WS-MN-UTILITY-SOURCE-CD 
              MOVE MN-IDR-RECIPIENT-CD       TO WS-MN-IDR-RECIPIENT-CD  
              MOVE MN-PROGRAM-ID             TO WS-MN-PROGRAM-ID        
              MOVE MN-MTR-READ-SOURCE-CD     TO WS-MN-MTR-READ-SOURCE-CD
              MOVE MN-METER-PRESSURE         TO WS-MTR-PRESSURE         
              MOVE WS-MTR-PRESSURE           TO WS-MN-METER-PRESSURE    
                                                                        
              MOVE WS-YES                    TO WS-UTIL-ENV-PRESENT     
              MOVE WS-MTRD                   TO WS-TABLE-ID             
                                                                        
              PERFORM 7220-FETCH-MTRD-CURSOR THRU 7220-EXIT             
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7230-CLOSE-MTRD-CURSOR    THRU 7230-EXIT.            
                                                                        
           PERFORM 7310-OPEN-REG-CURSOR      THRU 7310-EXIT.            
           PERFORM 7320-FETCH-REG-CURSOR     THRU 7320-EXIT.            
                                                                        
           PERFORM UNTIL SW-RG-FETCH-END                                
              MOVE RG-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE       
                                                WS-UT-CODE-UTIL-TYPE    
              MOVE RG-IC-NO                  TO WS-IC-NO                
              MOVE RG-MTR-REF-NO             TO WS-MN-MTR-REF-NO        
              MOVE MC-METER-NO               TO WS-METER-NO             
              MOVE RG-CODE-TIME-PERIOD       TO WS-RG-CODE-TIME-PERIOD  
              MOVE RG-REG-ID-NO              TO WS-RG-REG-ID-NO         
              MOVE RG-LAST-READ-VALUE        TO WS-RG-LAST-READ-VALUE   
              MOVE RG-LAST-REG-READ-DT       TO WS-RG-LAST-READ-DT      
              MOVE RG-CODE-REG-STATUS        TO WS-RG-CODE-REG-STATUS   
              MOVE RG-CODE-STATUS-REAS       TO WS-RG-CODE-STATUS-REAS  
              MOVE RG-CODE-USAGE-TYPE        TO WS-RG-CODE-USAGE-TYPE   
              MOVE RG-CODE-USAGE-ID          TO WS-RG-CODE-USAGE-ID     
              MOVE RG-CODE-USAGE-SOURCE      TO WS-RG-CODE-USAGE-SOURCE 
              MOVE MC-CONSTANT               TO WS-MN-CONSTANT          
              MOVE MC-NO-READ-DIALS          TO WS-MN-NO-DIALS          
                                                                        
              MOVE WS-YES                    TO WS-UTIL-ENV-PRESENT     
              MOVE WS-REG                    TO WS-TABLE-ID             
                                                                        
              PERFORM 7320-FETCH-REG-CURSOR  THRU 7320-EXIT             
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7330-CLOSE-REG-CURSOR     THRU 7330-EXIT.            
                                                                        
           PERFORM 7410-OPEN-CUST-CURSOR     THRU 7410-EXIT.            
           PERFORM 7420-FETCH-CUST-CURSOR    THRU 7420-EXIT.            
           PERFORM 7100-FETCH-VERSION-NO     THRU 7100-EXIT.            
           PERFORM 7101-FETCH-UMTR-DESC      THRU 7101-EXIT.            
                                                                        
           PERFORM UNTIL SW-CP-FETCH-END                                
              MOVE CP-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE       
                                                WS-UT-CODE-UTIL-TYPE    
              MOVE CP-IC-NO                  TO WS-IC-NO                
              MOVE CP-CODE-PLAN-STATUS       TO WS-CP-CODE-PLAN-STATUS  
              MOVE CP-CODE-STAT-REASON       TO WS-CP-CODE-STAT-REASON  
              MOVE CP-CODE-SERVICE-TYPE      TO WS-CP-CODE-SERVICE-TYPE 
              MOVE CP-RATE-ITEM-CODE         TO WS-CP-RATE-ITEM-CODE    
              MOVE CP-MTHLY-AMOUNT-FIXED     TO WS-CP-MNTHLY-AMT-FIXED  
              MOVE CP-LIGHT-NO               TO WS-CP-LIGHT-NO          
              MOVE CP-POLE-NO                TO WS-CP-POLE-NO           
              MOVE CP-USAGE-FIXED            TO WS-CP-USAGE-FIXED       
              MOVE CP-NO-UNITS               TO WS-CP-NO-UNITS          
              MOVE CP-DIST-NO                TO WS-CP-DIST-NO           
              MOVE L9-UM-EQUIP-ID            TO WS-CP-EQUIP-ID          
              MOVE CP-ITEM-SEQ-NO            TO WS-CP-ITEM-SEQ-NO       
              MOVE WS-YES                    TO WS-UTIL-ENV-PRESENT     
              MOVE WS-CUST                   TO WS-TABLE-ID             
              PERFORM 7420-FETCH-CUST-CURSOR THRU 7420-EXIT             
              PERFORM 7100-FETCH-VERSION-NO  THRU 7100-EXIT             
              PERFORM 7101-FETCH-UMTR-DESC   THRU 7101-EXIT             
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7430-CLOSE-CUST-CURSOR    THRU 7430-EXIT.            
                                                                        
           PERFORM 7500-GET-ADDR-INFORMATION   THRU 7500-EXIT.          
           PERFORM 7505-GET-WA-INFORMATION     THRU 7505-EXIT.          
           PERFORM 7510-OPEN-WORK-CURSOR       THRU 7510-EXIT.          
           PERFORM 7520-FETCH-WORK-CURSOR      THRU 7520-EXIT.          
                                                                        
           PERFORM VARYING WS-SUB1 FROM WS-1 BY WS-1                    
              UNTIL SW-WORK-FETCH-END                                   
                 OR WS-SUB1 > 20                                        
                                                                        
      *       IF MN-CODE-METER-STATUS = 'A' OR 'B' OR 'I'                       
                 COMPUTE WS-SUB2 = 1 + 3 * (WS-SUB1 - 1)                
                 MOVE WB-WORK-TYPE-CD   TO WS-WA-WORK-TYPE-CD(WS-SUB2:3)
                                           WS-WORK-TYPE-CD              
                 MOVE WB-CODE-UTIL-TYPE TO                              
                                        WS-WA-CODE-UTIL-TYPE(WS-SUB1:1) 
                                                                        
                 PERFORM 7050-OPEN-METER-IND-CURSOR      THRU 7050-EXIT 
                 PERFORM 7055-FETCH-METER-IND-CURSOR     THRU 7055-EXIT 
                 PERFORM 7060-CLOSE-METER-IND-CURSOR     THRU 7060-EXIT 
                                                                        
P00447           IF MC-CODE-CAP-TYPE = WS-A AND (MC-CONSTANT > WS-1 OR  
P00447                                          MC-CONSTANT = WS-0) THEN
                    MOVE WS-YES                  TO                     
                                      WS-WA-METER-IND(WS-SUB1:1)        
                 ELSE                                                   
                    MOVE WS-NO                   TO                     
                                      WS-WA-METER-IND(WS-SUB1:1)        
                 END-IF                                                 
                                                                        
              MOVE WS-YES                  TO WS-INCLUDE-INST           
                                              WS-ORDER-INST-PRESENT     
              MOVE WB-CODE-UTIL-TYPE       TO WS-UT-CODE-UTIL-TYPE      
                                              WS-CODE-UTIL-TYPE         
              MOVE WB-CODE-METER-LOC       TO WS-CODE-METER-LOC         
              MOVE WS-P                    TO WS-PER-TEMP-IND           
              MOVE MN-IC-NO                TO WS-IC-NO                  
              MOVE WB-METER-NO             TO WS-METER-NO               
              MOVE WB-SO-INST-SEQ-NO       TO WS-SO-INST-SEQ-NO         
              MOVE WB-METER-SUPPLYING      TO WS-METER-SUPPLYING        
              MOVE MN-MTR-REF-NO           TO WS-MN-MTR-REF-NO          
                                                                        
              PERFORM 7520-FETCH-WORK-CURSOR THRU 7520-EXIT             
                                                                        
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
                                                                        
              MOVE WS-NO                      TO WS-INCLUDE-INST        
                                              WS-ORDER-INST-PRESENT     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7530-CLOSE-WORK-CURSOR    THRU 7530-EXIT             
                                                                        
           MOVE WS-YES                       TO WS-WA-LAST-CALL.        
                                                                        
           IF WS-ROW-NO = 1                                             
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
              MOVE ZERO                      TO WS-ROW-NO               
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           ELSE                                                         
              MOVE ZERO                      TO WS-ROW-NO               
              PERFORM 5200-INSERT-ROW        THRU 5200-EXIT             
           END-IF.                                                      
                                                                        
P00128     IF ACTIVE-DNP01-PREEXISTS                                    
P00128        MOVE VO-ACCOUNT-NO TO TJ-SEB-ACCT-NO                      
P00128        PERFORM 7765-DELETE-SONP-ROW THRU 7765-EXIT               
P00128     END-IF.                                                      
A03308     MOVE SPACES                       TO WS-WA-WORK-TYPE-CD      
A03308                                          WS-WA-CODE-UTIL-TYPE    
A03308                                          WS-WA-METER-IND.        
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5040-GET-RLSE-IND                                              *        
      ******************************************************************        
       5040-GET-RLSE-IND.                                               
                                                                        
           MOVE '5040'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-PREMISE-NO                TO WS-PREMISE-NO-CHAR.     
           MOVE WS-PREMISE-NO-DEC            TO WS-PREMISE-NO-NUM.      
                                                                        
           EXEC SQL                                                     
              SELECT RLSE_REQUIRED_IND                                  
                INTO :A9-RLSE-REQUIRED-IND :WS-NULL-IND                  
                FROM CSS_PREMISE      A,                                
                     CSS_REV_DISTRICT B                                 
               WHERE A.PREMISE_NO      = :WS-PREMISE-NO-NUM             
                 AND A.REV_DISTRICT_CD = B.REV_DISTRICT_CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND = WS-NULL-VALUE                            
                 MOVE SPACES                  TO WS-RLSE-REQUIRED-IND   
              ELSE                                                      
                 MOVE A9-RLSE-REQUIRED-IND    TO WS-RLSE-REQUIRED-IND   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5040'                     TO ACTIVE-PARAGRAPH       
              MOVE 'GET-RLSE-IND'             TO ABEND-FUNCTION         
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'CSS_REV_DISTRICT'         TO TABLE-2                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
              MOVE WS-PREMISE-NO-NUM          TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       5040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050-GET-ACCT-INFO.                                            *        
      ******************************************************************        
       5050-GET-ACCT-INFO.                                              
                                                                        
           MOVE '5050'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-ACCOUNT-NO-PRIOR          TO WS-PRIOR-ACCOUNT-NO.    
           MOVE WS-ACCOUNT-NO-PRIOR-DEC      TO WS-ACCOUNT-NO-PRIOR-NUM.
           MOVE SPACES                       TO WS-ACCT-STATUS.         
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_STAT,                                    
                     ACCOUNT_TYPE_CODE,                                 
                     CREDIT_GROUP,                                      
                     ACCOUNT_NO,                                        
                     NOTICE_EXEMPT_CD,                                  
                     CODE_DISC_OK,                                      
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     CODES_DATA_PRESENT,                                
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     BANKRUPTCY_IND,                                    
                     IVR_EXEMPT_CD                                      
                INTO :WS-ACCT-STATUS,                                   
                     :WS-ACCOUNT-TYPE-CODE,                             
                     :AT-CREDIT-GROUP,                                  
                     :AT-ACCOUNT-NO,                                    
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-CODE-DISC-OK,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-IND1,                
                     :AT-DATE-BILL-DAY-30 :WS-NULL-IND2,                
                     :AT-DATE-BILL-DAY-60 :WS-NULL-IND3,                
                     :AT-DATE-BILL-DAY-90 :WS-NULL-IND4,                
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-IVR-EXEMPT-CD                                  
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-PRIOR-NUM              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
                 MOVE WS-ACCT-STATUS TO WS-OLD-ACCT-STATUS              
                 MOVE AT-CREDIT-GROUP TO WS-CREDIT-GROUP                
               IF WS-NULL-IND1 EQUAL -1                                 
                 MOVE SPACES            TO AT-DATE-BILL-DAY-00          
               END-IF                                                   
               IF WS-NULL-IND2 EQUAL -1                                 
                 MOVE SPACES            TO AT-DATE-BILL-DAY-30          
               END-IF                                                   
               IF WS-NULL-IND3 EQUAL -1                                 
                 MOVE SPACES            TO AT-DATE-BILL-DAY-60          
               END-IF                                                   
               IF WS-NULL-IND4 EQUAL -1                                 
                 MOVE SPACES            TO AT-DATE-BILL-DAY-90          
               END-IF                                                   
              ELSE                                                      
                 MOVE SPACES             TO WS-OLD-ACCT-STATUS          
                 MOVE SPACES             TO AT-CREDIT-GROUP             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'GET-ACCT-INFO'            TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO-PRIOR-NUM    TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5060-FETCH-SUBDIV-LIGHT.                                       *        
      *                                                                *        
      *     CALLS       7000-FETCH-RATE-ITEM-CODE                      *        
      *                 7100-FETCH-VERSION-NO                          *        
      *                 7200-FETCH-PRICE-PER-SERV                      *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *     FETCH PRICE PER SERVICE FOR SUBDIV. LIGHTING               *        
      ******************************************************************        
       5060-FETCH-SUBDIV-LIGHT.                                         
                                                                        
           MOVE '5060'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           MOVE WS-SUBDIV-PLAN                   TO WS-RATE-PLAN-NO-WS. 
                                                                        
           PERFORM 7000-FETCH-RATE-ITEM-CODE     THRU 7000-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7100-FETCH-VERSION-NO      THRU 7100-EXIT         
              PERFORM 7105-GET-CODE-STATUS       THRU 7105-EXIT         
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7200-FETCH-PRICE-PER-SERV  THRU 7200-EXIT         
           END-IF.                                                      
                                                                        
       5060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-INSERT-ROW                                                *        
      ******************************************************************        
       5200-INSERT-ROW.                                                 
                                                                        
           MOVE '5200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
      *    IF WS-ORDER-TYPE-CD = 'MC001' OR                                     
      *       WS-ORDER-TYPE-CD = 'FW004'                                        
      *           MOVE 'H'                    TO WS-ORDER-STATE-CD              
      *    ELSE                                                                 
      *        MOVE WS-A                      TO WS-ORDER-STATE-CD              
      *    END-IF.                                                              
           IF WS-ORDER-TYPE-CD = 'DNP01'                                
               MOVE 'A'                    TO WS-ORDER-STATE-CD         
           ELSE                                                         
               MOVE 'H'                    TO WS-ORDER-STATE-CD         
           END-IF.                                                      
                                                                        
           IF WS-ROW-NO = 0                                             
              MOVE WS-NO                      TO WS-NEW-ORDER           
           ELSE                                                         
              MOVE WS-YES                     TO WS-NEW-ORDER           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00224 (:WS-WA-LOCAL-OFFICE,                       
      *                      :WS-WA-CODE-UTIL-TYPE,                     
      *                      :WS-WA-WORK-TYPE-CD,                       
      *                      :WS-WA-METER-IND,                          
      *                      :WS-WA-ZIP-CODE,                           
      *                      :WS-WA-READ-ROUTE,                         
      *                      :WS-WA-WORK-AREA,                          
P00718*                      :WS-WA-BUSINESS-UNIT,                      
      *                      :WS-ROW-NO,                                
      *                      :WS-PREMISE-NO,                            
      *                      :WS-ACCOUNT-NO,                            
      *                      :WS-ACCOUNT-NO-PRIOR,                      
      *                      :WS-SERV-ORDER-NO,                         
      *                      :WS-ORDER-TYPE-CD,                         
      *                      :WS-LOCAL-OFFICE,                          
      *                      :WS-PHONE-NO-EXT,                          
      *                      :WS-PHONE-NO,                              
      *                      :WS-ORDER-PLACED-BY,                       
      *                      :WS-ORDER-RECVED-BY,                       
      *                      :WS-WANTED-BY-DATE,                        
      *                      :WS-DATE-FORECAST-DNP,                     
      *                      :WS-ASSIGNED-DATETIME,                     
      *                      :WS-ORDER-REASON,                          
      *                      :WS-BACK-DATED-IND,                        
      *                      :WS-RESP-AREA-ID,                          
      *                      :WS-CALL-BEFORE-MIN,                       
      *                      :WS-NOTIFY-CUST-IND,                       
      *                      :WS-NOTIFY-CSR-IND,                        
      *                      :WS-BREAKERS-OFF,                          
      *                      :WS-DEPOSIT-AMT-CHAR,                      
      *                      :WS-AMT-DNP-AT-BILL-CHAR,                  
      *                      :WS-INIT-BY-CNTRCT,                        
      *                      :WS-WORK-AREA-ID,                          
P00718*                      :WS-BUSINESS-UNIT,                         
      *                      :WS-ORDER-PRIORITY,                        
      *                      :WS-ORDER-STATE-CD,                        
      *                      :WS-WORK-TYPE-CD,                          
      *                      :WS-CODE-UTIL-TYPE,                        
      *                      :WS-STD-CHG-AMT-CHAR,                      
      *                      :WS-HOLD-RELEASE,                          
      *                      :WS-RLSE-REQUIRED-IND,                     
      *                      :WS-PER-TEMP-IND,                          
      *                      :WS-RLSE-NO,                               
      *                      :WS-RLSE-DATE,                             
      *                      :WS-SO-INST-SEQ-NO,                        
      *                      :WS-TABLE-ID,                              
      *                      :WS-UT-CODE-UTIL-TYPE,                     
      *                      :WS-IC-NO,                                 
      *                      :WS-UT-READ-ROUTE,                         
      *                      :WS-RATE-PLAN-NO,                          
      *                      :WS-UT-CODE-REV-CLASS,                     
      *                      :WS-UT-READ-CYCLE,                         
      *                      :WS-UT-CODE-SIC-NO,                        
      *                      :WS-METER-NO,                              
      *                      :WS-MN-MTR-REF-NO,                         
      *                      :WS-MN-CODE-TIME-PERIOD,                   
      *                      :WS-MN-LAST-RD-VAL-CHAR,                   
      *                      :WS-MN-CODE-STATUS-REAS,                   
      *                      :WS-MN-CODE-USAGE-TYPE,                    
      *                      :WS-MN-CODE-USAGE-ID,                      
      *                      :WS-MN-CODE-USAGE-SOURCE,                  
      *                      :WS-CODE-METER-STATUS,                     
      *                      :WS-METER-SUPPLYING,                       
      *                      :WS-CODE-METER-LOC,                        
      *                      :WS-MN-CONSTANT-CHAR,                      
      *                      :WS-MN-NO-DIALS,                           
      *                      :WS-MN-POINT-ID,                           
      *                      :WS-MN-SEAL-CODE-ID,                       
      *                      :WS-MN-HEXAGRAM-LOCATION,                  
      *                      :WS-MN-INSULATED-IND,                      
      *                      :WS-MN-LOCK-TYPE-ID,                       
      *                      :WS-MN-DELIVERY-LEVEL-CD,                  
      *                      :WS-MN-UTILITY-SOURCE-CD,                  
      *                      :WS-MN-IDR-RECIPIENT-CD,                   
      *                      :WS-MN-PROGRAM-ID,                         
      *                      :WS-MN-MTR-READ-SOURCE-CD,                 
      *                      :WS-MN-LAST-READ-DT,                       
      *                      :WS-MN-REG-ID-NO,                          
      *                      :WS-RG-CODE-REG-STATUS,                    
      *                      :WS-RG-CODE-STATUS-REAS,                   
      *                      :WS-RG-CODE-TIME-PERIOD,                   
      *                      :WS-RG-CODE-USAGE-ID,                      
      *                      :WS-RG-CODE-USAGE-SOURCE,                  
      *                      :WS-RG-CODE-USAGE-TYPE,                    
      *                      :WS-RG-LAST-READ-DT,                       
      *                      :WS-RG-LAST-RD-VAL-CHAR,                   
      *                      :WS-RG-REG-ID-NO,                          
      *                      :WS-CP-NO-UNITS,                           
      *                      :WS-CP-CODE-PLAN-STATUS,                   
      *                      :WS-CP-CODE-STAT-REASON,                   
      *                      :WS-CP-CODE-SERVICE-TYPE,                  
      *                      :WS-CP-MTLY-AMT-FIX-CHAR,                  
      *                      :WS-CP-RATE-ITEM-CODE,                     
      *                      :WS-CP-LIGHT-NO,                           
      *                      :WS-CP-POLE-NO,                            
      *                      :WS-CP-DIST-NO,                            
      *                      :WS-CP-USAGE-FIXED-CHAR,                   
      *                      :WS-CP-EQUIP-ID,                           
      *                      :WS-APPLIANCE-CD,                          
      *                      :WS-APPLIANCE-SEQ-NO,                      
      *                      :WS-EQUIP-OWNER,                           
      *                      :WS-MK-CODE-UTIL-TYPE,                     
      *                      :WS-LEAK-IND,                              
      *                      :WS-LIGHT-IND,                             
      *                      :WS-REPAIR-IND,                            
      *                      :WS-CUTOFF-IND,                            
      *                      :WS-CAUTION-TAG-IND,                       
      *                      :WS-IMPROPER-REASON,                       
      *                      :WS-EQUIPMENT-UNQ,                         
      *                      :WS-VERIFY-RATE,                           
      *                      :WS-ORDER-INST-PRESENT,                    
      *                      :WS-EQUIPMENT-PRESENT,                     
      *                      :WS-UTIL-ENV-PRESENT,                      
      *                      :WS-NEW-ORDER,                             
      *                      :WS-PANEL-NO,                              
      *                      :WS-INCLUDE-INST,                          
      *                      :WS-REV-DIST-CD,                           
      *                      :WS-USER-ID-SP,                            
      *                      :WS-SO-EST-LABOR-HR-CHAR,                  
      *                      :WS-ACCT-STATUS,                           
      *                      :WS-PPS-ORDER-CHAR,                        
      *                      :WS-REORDER-FLAG,                          
      *                      :WS-WA-LAST-CALL,                          
      *                      :WS-COMPANY-NO,                            
      *                      :WS-OLD-ACCT-STATUS,                       
      *                      :WS-DISC-BAL-CHAR,                         
      *                      :WS-SEC-TOT-AMT-CHAR,                      
      *                      :WS-CUR-MTH-ARREARS-CD,                    
      *                      :WS-CREDIT-GROUP,                          
      *                      :WS-DNP-REC,                               
      *                      :WS-ACCOUNT-TYPE-CODE,                     
      *                      :WS-INSTALL-IND,                           
      *                      :WS-CP-ITEM-SEQ-NO,                        
      *                      :WS-MN-METER-PRESSURE)                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO104 *******************'      
              DISPLAY '** 5200 :  RETURN CODE ERROR             '       
              DISPLAY '** 5200 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO104 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-RESLTSET)                                           
      *       WITH PROCEDURE CSR00224                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR CURSOR FOR RESULT SET             
      *       :LOC-RESLTSET                                             
      *    END-EXEC.                                                    
                                                                        
           MOVE ZEROS                    TO WS-SERV-ORDER-NO-HOLD.      
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR INTO                                 
                 :WS-SERV-ORDER-NO-HOLD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSSO104 *******************'      
              DISPLAY '** 5200 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR00224 RESULTSET FAILED' 
              DISPLAY '************* PCSSO104 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           IF P-RETURN-PARM = ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSSO104 *******************'      
              DISPLAY '** 5200 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' P-RETURN-PARM                  
              DISPLAY '**      :  CSR00224 RETURNED A BAD RETURN CODE'  
              DISPLAY '************* PCSSO104 *******************'      
              PERFORM 9900-ABEND                  THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
A03308     EXEC SQL                                                     
A03308        CLOSE RESULT_SET_CSR                                      
A03308     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 5010-INITIALIZE-ROW        THRU 5010-EXIT.           
                                                                        
           MOVE WS-SERV-ORDER-NO-HOLD         TO WS-SERV-ORDER-NO.      
                                                                        
           IF WS-SERV-ORDER-NO(1:1) = '0'                               
              GO TO 5020-EXIT                                           
           END-IF.                                                      
                                                                        
           ADD  WS-1                          TO WS-ROW-NO-HOLD.        
           MOVE WS-ROW-NO-HOLD                TO WS-ROW-NO.             
                                                                        
           MOVE WS-NO                         TO WS-UTIL-ENV-PRESENT.   
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020* 5300-INSERT-TASK-Q                                             *        
A05020******************************************************************        
A05020 5300-INSERT-TASK-Q.                                              
A05020                                                                  
A05020     MOVE '5300'                        TO ACTIVE-PARAGRAPH.      
A05020                                                                  
A05020     MOVE WS-SERV-ORDER-NO              TO SERV-ORDER-NO-4747.    
A05020     MOVE '1'                           TO PRIORITY-4747.         
A05020     MOVE 'I'                           TO ACTION-CD-4747.        
A05020     MOVE 'SYSTEM'                      TO USER-ID-4747.          
A05020     MOVE SPACES                        TO WK-DISTRICT-4747.      
A05020                                                                  
A05020*    EXEC SQL                                                     
A05020*       CALL CSR04747 (:SERV-ORDER-NO-4747,                       
A05020*                      :PRIORITY-4747,                            
A05020*                      :ACTION-CD-4747,                           
A05020*                      :USER-ID-4747,                             
A05020*                      :WK-DISTRICT-4747)                         
A05020*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A05020                                                                  
A05020     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
A05020     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        DISPLAY '** 5300 :  RETURN CODE ERROR             '       
A05020        DISPLAY '** 5300 :  RETURN CODE ERROR             '       
A05020        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
A05020        DISPLAY '**      :  NO RESULTSET RETURNED'                
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        PERFORM 9900-ABEND               THRU 9900-EXIT           
A05020     END-IF.                                                      
A05020                                                                  
A05020*    EXEC SQL                                                     
A05020*       ASSOCIATE LOCATORS                                        
A05020*       (:LOC-RES04747)                                           
A05020*       WITH PROCEDURE CSR04747                                   
A05020*    END-EXEC.                                                    
A05020                                                                  
A05020*    EXEC SQL                                                     
A05020*       ALLOCATE RESULT_CSR_4747 CURSOR FOR RESULT SET            
A05020*       :LOC-RES04747                                             
A05020*    END-EXEC.                                                    
A05020                                                                  
A05020     INITIALIZE RETURN-CODE-4747                                  
A05020                WORK-DISTRICT-4747.                               
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        FETCH RESULT_CSR_4747 INTO                                
A05020           :RETURN-CODE-4747,                                     
A05020           :WORK-DISTRICT-4747                                    
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A05020     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        DISPLAY '** 5300 :  RETURN CODE ERROR             '       
A05020        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
A05020        DISPLAY '**      :  FETCH FROM CSR04747 RESULTSET FAILED' 
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        PERFORM 9900-ABEND                THRU 9900-EXIT          
A05020     END-IF.                                                      
A05020                                                                  
A05020     IF P-RETURN-PARM = ZEROES                                    
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        DISPLAY '** 5300 :  RETURN CODE ERROR             '       
A05020        DISPLAY '**      :  RC = ' P-RETURN-PARM                  
A05020        DISPLAY '**      :  CSR04747 RETURNED A BAD RETURN CODE'  
A05020        DISPLAY '************* PCSSO104 *******************'      
A05020        PERFORM 9900-ABEND                  THRU 9900-EXIT        
A05020     END-IF.                                                      
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        CLOSE RESULT_CSR_4747                                     
A05020     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
A05020                                                                  
A05020 5300-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      * 5250-PROCESS-ACCT-UPD.                                         *        
      ******************************************************************        
       5250-PROCESS-ACCT-UPD.                                           
                                                                        
           MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT    
                                            MI-CHG-COLUMN-VALUE-TEXT.   
                                                                        
           PERFORM 7810-SELECT-CREDIT-HIST          THRU 7810-EXIT.     
                                                                        
           MOVE XE-DATE-RECVED           TO CL-DATE-CREDIT-ACTION.      
      *    PERFORM 7820-SELECT-DNP-CL-ROWS          THRU 7820-EXIT.             
           PERFORM 7821-OPEN-CRED-COLL THRU 7821-EXIT.                  
           PERFORM 7822-FETCH-CRED-COLL THRU 7822-EXIT.                 
           PERFORM 7823-CLOSE-CRED-COLL THRU 7823-EXIT.                 
                                                                        
           EVALUATE CL-CODE-NOTICE-TYPE                                 
              WHEN 'G'                                                  
              WHEN 'H'                                                  
              WHEN 'I'                                                  
                 MOVE CZ-DISC-EXCEPTN-HIST TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE +24                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-3                 TO CZ-DISC-EXCEPTN-HIST(1:1) 
                 MOVE CZ-DISC-EXCEPTN-HIST TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +24                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE 'DISC EXCPTN HIS'    TO MI-COLUMN-DESC            
                 IF MI-PRV-COLUMN-VALUE-TEXT(1:1) NOT EQUAL '4'         
                    PERFORM 7830-UPDATE-EXCEPT-CREDIT  THRU 7830-EXIT   
      *             PERFORM 5251-FORMAT-MNT-HIST       THRU 5251-EXIT           
                 END-IF                                                 
              WHEN 'D'                                                  
P00128           IF ACTIVE-DNP01-PREEXISTS                              
P00128              MOVE CZ-DISCONNECT-HIST TO MI-PRV-COLUMN-VALUE-TEXT 
P00128              MOVE +24             TO MI-PRV-COLUMN-VALUE-LEN     
P00128              MOVE WS-3I           TO CZ-DISCONNECT-HIST(1:2)     
P00128              MOVE CZ-DISCONNECT-HIST TO MI-CHG-COLUMN-VALUE-TEXT 
P00128              MOVE +24             TO MI-CHG-COLUMN-VALUE-LEN     
P00128              MOVE 'DISCONNECT HIST' TO MI-COLUMN-DESC            
P00128           ELSE                                                   
                    MOVE CZ-DISCONNECT-HIST TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE +24             TO MI-PRV-COLUMN-VALUE-LEN     
                    MOVE WS-3             TO CZ-DISCONNECT-HIST(1:1)    
                    MOVE CZ-DISCONNECT-HIST TO MI-CHG-COLUMN-VALUE-TEXT 
                    MOVE +24             TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE 'DISCONNECT HIST' TO MI-COLUMN-DESC            
P00128           END-IF                                                 
                 PERFORM 7840-UPDATE-NORMAL-CREDIT THRU 7840-EXIT       
      *          PERFORM 5251-FORMAT-MNT-HIST   THRU 5251-EXIT                  
              WHEN 'F'                                                  
                 MOVE WS-2              TO CZ-DISC-EXCEPTN-HIST(1:1)    
                 PERFORM 7830-UPDATE-EXCEPT-CREDIT THRU 7830-EXIT       
                 PERFORM 5310-CHECK-NONUTIL THRU 5310-EXIT              
              WHEN 'C'                                                  
                 MOVE WS-2              TO CZ-DISCONNECT-HIST(1:1)      
                 PERFORM 7840-UPDATE-NORMAL-CREDIT THRU 7840-EXIT       
                 PERFORM 5310-CHECK-NONUTIL THRU 5310-EXIT              
              WHEN 'U'                                                  
                 MOVE WS-2              TO CZ-NON-UTL-CR-HST-EX(1:1)    
                 PERFORM 7835-UPD-NONUTL-EXCEPT-CREDIT THRU 7835-EXIT   
              WHEN 'S'                                                  
                 MOVE WS-2              TO CZ-NON-UTL-CR-HST(1:1)       
                 PERFORM 7845-UPD-NONUTL-NORMAL-CREDIT THRU 7845-EXIT   
           END-EVALUATE.                                                
                                                                        
           PERFORM 7850-UPDATE-SERV-ORDER-PEND  THRU 7850-EXIT.         
           IF XE-ORDER-TYPE-CD = 'DNP01'                                
               MOVE WS-A            TO AT-CODES-DATA-PRESENT(29:1)      
               PERFORM 7870-UPD-CODES-DATE-PRESENT  THRU 7870-EXIT
           END-IF.     
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5251-FORMAT-MNT-HIST.                                          *        
      ******************************************************************        
      *5251-FORMAT-MNT-HIST.                                                    
      *                                                                         
      *    PERFORM 7860-SELECT-CURRENT-TS           THRU 7860-EXIT.             
      *    MOVE XE-ACCOUNT-NO            TO MH-ACCOUNT-NO.                      
      *    MOVE ZEROS                    TO MH-PREMISE-NO                       
      *                                     MH-CUSTOMER-NO.                     
      *    MOVE XE-DATE-RECVED           TO MH-DATE-TRANS.                      
      *    MOVE 'F'                      TO MH-CODE-TRAN-TYPE.                  
      *    MOVE SPACES                   TO MH-RESP-AREA-ID.                    
      *    MOVE PROGRAM-NAME             TO MH-APPL-PROGRAM-ID.                 
      *    MOVE WS-SYSTEM                TO MH-USER-ID.                         
      *    MOVE +22                      TO MH-TRAN-COMMENT-LEN.                
      *    MOVE WS-UPDATE-REM            TO MH-TRAN-COMMENT-TEXT.               
      *    MOVE WS-CURRENT-TS            TO MH-TRANS-HIST-SEQ-NO.               
      *    MOVE WS-CURRENT-TS            TO MI-TRANS-HIST-SEQ-NO.               
      *    MOVE +1                       TO MI-TRAN-APPL-NO.                    
      *    MOVE 'CZ'                     TO MI-TABLE-ID.                        
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.                 
      *                                                                         
      *5251-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 5310-CHECK-NONUTIL                                                      
      ******************************************************************        
       5310-CHECK-NONUTIL.                                              
                                                                        
           PERFORM 7825-OPEN-NON-UTIL THRU 7825-EXIT.                   
           PERFORM 7826-FETCH-NON-UTIL THRU 7826-EXIT.                  
           PERFORM 7827-CLOSE-NON-UTIL THRU 7827-EXIT.                  
                                                                        
           EVALUATE CL-CODE-NOTICE-TYPE                                 
              WHEN 'U'                                                  
                 MOVE WS-2              TO CZ-NON-UTL-CR-HST-EX(1:1)    
                 PERFORM 7835-UPD-NONUTL-EXCEPT-CREDIT THRU 7835-EXIT   
              WHEN 'S'                                                  
                 MOVE WS-2              TO CZ-NON-UTL-CR-HST(1:1)       
                 PERFORM 7845-UPD-NONUTL-NORMAL-CREDIT THRU 7845-EXIT   
           END-EVALUATE.                                                
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 5400-CHECK-FOR-EXIST-DNP01.                                             
      ******************************************************************PCS03730
       5400-CHECK-FOR-EXIST-DNP01.                                      
                                                                        
            MOVE '5400' TO ACTIVE-PARAGRAPH.                            
                                                                        
            MOVE WS-ACCOUNT-NO TO VO-ACCOUNT-NO.                        
            PERFORM 7750-SELECT-EXIST-DNP01 THRU 7750-EXIT.             
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * INCLUDE CPD00067.                                              *        
      ******************************************************************PCS03730
      *    EXEC SQL                                                             
      *        INCLUDE CPD00067                                                 
      *    END-EXEC.                                                            
                                                                        
      ******************************************************************PCS03730
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      *     CALLS 7620-START-FCSCA00                                   *        
      *           7621-READ-FCSCA00                                    *        
      *           7622-CLOSE-CA00-CSR                                  *        
      *           9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 7994-GET-SO-DNP-DETLS                          *        
      ******************************************************************PCS03730
       6240-GET-FCA00-COMMON-DATE.                                      
           MOVE WS-FCA00-COMMON-DATE-KEY TO E-FCA00-KEY.                
           PERFORM 7620-START-FCSCA00 THRU 7620-EXIT.                   
           PERFORM 7621-READ-FCSCA00  THRU 7621-EXIT.                   
      *                                                                         
           IF E-FCA00-KEY EQUAL WS-FCA00-COMMON-DATE-KEY                
               MOVE E-FCA00-DATA TO WS-FCA00-COMMON-DATE-RECORD         
               PERFORM 7622-CLOSE-CA00-CSR THRU 7622-EXIT               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6240'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                                            ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       6240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 6251-GET-FJC01-DATE                                            *        
      *     CALLS 7600-START-FCSJC01                                   *        
      *           7610-READ-FCSJC01                                    *        
      *           7611-CLOSE                                           *        
      *           9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 7994-GET-SO-DNP-DETLS                          *        
      ******************************************************************PCS03730
       6251-GET-FJC01-DATE.                                             
                                                                        
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-DATE     TO WS-COMMAND.                             
           MOVE  ZEROS       TO WS-SEQUENCE.                            
           MOVE  SPACES      TO WS-SYSIPT.                              
           MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           IF  END-OF-SYSIPT                                            
               MOVE WS-N TO WS-OVERRIDE-DATE-SW                         
           ELSE                                                         
               MOVE WS-Y TO WS-OVERRIDE-DATE-SW                         
               IF  WS-INPUT-RUN-DATE-MM  NUMERIC                        
               AND WS-INPUT-RUN-DATE-DD  NUMERIC                        
               AND WS-INPUT-RUN-DATE-YY  NUMERIC                        
                   PERFORM 7611-CLOSE THRU 7611-EXIT                    
                   MOVE  0                   TO    RS-RETURN-CODE       
                   MOVE  WS-INPUT-RUN-DATE   TO    WS-INPUT-DATE        
               ELSE                                                     
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '6251'                TO ACTIVE-PARAGRAPH       
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                                                 ABEND-FUNCTION         
                   MOVE 'CSS_JOB_PARM'        TO TABLE-1                
                   MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1      
                   MOVE +100                  TO WS-ACTIVE-RETURN-CODE  
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
               END-IF
           END-IF.                                                  
                                                                        
       6251-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-FETCH-RATE-ITEM-CODE                                      *        
      *     CALLS       9998-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 5000-FETCH-SUBDIV-LIGHT                        *        
      *     FETCH RATE ITEM CODE FROM UT AND CP                        *        
      ******************************************************************        
       7000-FETCH-RATE-ITEM-CODE.                                       
                                                                        
           MOVE '7000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           MOVE XE-ACCOUNT-NO                    TO CP-ACCOUNT-NO       
                                                    UT-ACCOUNT-NO.      
           EXEC SQL                                                     
               SELECT CP.RATE_ITEM_CODE,                                
                      UT.CODE_UTIL_TYPE                                 
                 INTO :WS-RATE-ITEM-CODE,                               
                      :WS-CODE-UTIL-TYPE-WS                             
                FROM CSS_CUST_PLAN CP, CSS_UTIL_ENVRNMT UT              
               WHERE CP.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND UT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND UT.RATE_PLAN_NO   = :WS-RATE-PLAN-NO-WS            
                 AND CP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE              
                 AND CP.IC_NO          = UT.IC_NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH RATE-ITEM-CODE'     TO TABLE-3                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-GET-CURRENT-DATE.                                         *        
      *     OBTAINS THE CURRENT DATE.                                  *        
      ******************************************************************        
       7005-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7005'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT_DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'GET-CURRENT-DATE'         TO TABLE-1                
              MOVE 'CSS_MODEL_SQL'            TO TABLE-2                
              MOVE 'CURRENT DATE'             TO TABLE-ELEMENT-1        
              MOVE WS-CURRENT-DATE            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-OPEN-SO-CURSOR                                            *        
      ******************************************************************        
       7010-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
                 OPEN SERV_ORDER_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN SO-CURSOR'           TO TABLE-1                
              MOVE 'CSS_SO_DATA_MF'           TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-FETCH-SO-CURSOR                                           *        
      ******************************************************************        
       7020-FETCH-SO-CURSOR.                                            
                                                                        
           MOVE ZEROES TO WS-NULL-IND.                                  
                                                                        
           EXEC SQL                                                     
              FETCH SERV_ORDER_CURSOR                                   
               INTO :XE-PREMISE-NO             ,                        
                    :XE-ACCOUNT-NO             ,                        
                    :XE-COMPANY-NO             ,                        
                    :XE-ORDER-TYPE-CD          ,                        
                    :XE-LOCAL-OFFICE           ,                        
                    :XE-SERV-ORDER-STATUS      ,                        
                    :XE-WORK-INDICATOR         ,                        
                    :XE-ORDER-PLACED-BY        ,                        
                    :XE-ORDER-RECVED-BY        ,                        
                    :XE-WANTED-BY-AM-PM        ,                        
                    :XE-WANTED-BY-DATE         ,                        
                    :XE-DATE-FORECAST-DNP :WS-NULL-IND,                 
                    :XE-DATE-RECVED            ,                        
                    :XE-ORDER-REASON           ,                        
                    :XE-BACK-DATED             ,                        
                    :XE-RESP-AREA-ID           ,                        
                    :XE-MAKE-ARRANGEMENTS      ,                        
                    :XE-NOTIFY-CUST-IND        ,                        
                    :XE-NOTIFY-CSR-IND         ,                        
                    :XE-DEPOSIT-AMT            ,                        
                    :XE-INIT-BY-CONTRACT       ,                        
                    :XE-ORDER-PRIORITY-CD      ,                        
                    :XE-AMT-DNP-AT-BILLING     ,                        
                    :XE-SO-DATA-SEQ-NO         ,                        
                    :XE-ORDER-STAT-REASON                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              MOVE XE-PREMISE-NO              TO WS-PREMISE-NO          
              MOVE XE-ACCOUNT-NO              TO WS-ACCOUNT-NO          
                                                 WS-ACCOUNT-NO-PRIOR    
              MOVE XE-ORDER-TYPE-CD           TO WS-ORDER-TYPE-CD       
              MOVE XE-LOCAL-OFFICE            TO WS-LOCAL-OFFICE        
              MOVE XE-ORDER-PLACED-BY         TO WS-ORDER-PLACED-BY     
              MOVE XE-ORDER-RECVED-BY         TO WS-ORDER-RECVED-BY     
              MOVE XE-WANTED-BY-DATE          TO WS-WANTED-BY-DATE      
              IF WS-NULL-IND = -1                                       
REARCH           MOVE '1900-01-01'  TO   WS-DATE-FORECAST-DNP           
              ELSE                                                      
                MOVE XE-DATE-FORECAST-DNP     TO WS-DATE-FORECAST-DNP   
              END-IF                                                    
              MOVE XE-DATE-RECVED             TO WS-ASSIGNED-DATETIME   
              MOVE XE-ORDER-REASON            TO WS-ORDER-REASON        
              MOVE XE-BACK-DATED              TO WS-BACK-DATED-IND      
              MOVE XE-RESP-AREA-ID            TO WS-RESP-AREA-ID        
              MOVE XE-NOTIFY-CUST-IND         TO WS-NOTIFY-CUST-IND     
              MOVE XE-NOTIFY-CSR-IND          TO WS-NOTIFY-CSR-IND      
              MOVE XE-DEPOSIT-AMT             TO WS-DEPOSIT-AMT         
              COMPUTE  XE-AMT-DNP-AT-BILLING =                          
                               ( XE-AMT-DNP-AT-BILLING  * 100 )         
              MOVE XE-AMT-DNP-AT-BILLING      TO WS-AMT-DNP-AT-BILLING  
              MOVE XE-INIT-BY-CONTRACT        TO WS-INIT-BY-CNTRCT      
              MOVE XE-ORDER-PRIORITY-CD       TO WS-ORDER-PRIORITY      
              MOVE XE-COMPANY-NO              TO WS-COMPANY-NO          
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH SO-CURSOR'          TO TABLE-1                
              MOVE 'CSS_SO_DATA_MF'           TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-CLOSE-SO-CURSOR                                           *        
      ******************************************************************        
       7025-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE SERV_ORDER_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7030'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE SO-CURSOR'          TO TABLE-1                
              MOVE 'CSS_SO_DATA_MF'           TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
T17078*   7030-GET-NEXT-DAY                                           *         
      *   SELECTS A DATE AND THE NUMERICAL REPRESENTATION FOR DAY OF  *         
      *   THE WEEK INTO WORKING STORAGE VARIABLES (WS-DATE-CTR DAYS   *         
      *   IN THE FUTURE)                                              *         
      *                                                               *         
      *     CALLS 9998-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *     CALLED FROM 0110-GET-NEXT-BUSINESS-DATE                   *         
      *****************************************************************         
       7030-GET-NEXT-DAY.                                               
      *                                                                         
           MOVE '7030' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, :WS-DATE-CTR, IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) )
            INTO
              :WS-HOLD-INPUT-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-HOLD-INPUT-DATE = (DATE(:WS-DATE-CALC) +                  
MFA-TR*                                       :WS-DATE-CTR DAYS)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                                            ABEND-FUNCTION              
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                SELECT
              CIS.DAYS (DATEADD( DAY, :WS-DATE-CTR, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) )) -           
                                   (CIS.DAYS(DATEADD( DAY, 
                                                         :WS-DATE-CTR, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) ))/7 * 7)
            INTO
              :WS-DAY     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DAY = DAYS (DATE(:WS-DATE-CALC) +                       
MFA-TR*                                  :WS-DATE-CTR DAYS) -                   
MFA-TR*                            (INTEGER(DAYS(DATE(:WS-DATE-CALC) +          
MFA-TR*                                  :WS-DATE-CTR DAYS)/7) * 7)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                                            ABEND-FUNCTION              
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *   7040-SELECT-HOLIDAY                                         *         
      *   DETERMINES WHETHER THE SELECTED DATE IS A SCE&G HOLIDAY     *         
      *                                                               *         
      *     CALLS 9998-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *     CALLED FROM 0110-GET-NEXT-BUSINESS-DATE                   *         
      *****************************************************************         
       7040-SELECT-HOLIDAY.                                             
                                                                        
           MOVE '7040' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT ('Y')                                     
                INTO :WS-ROW-EXISTS                                     
                FROM CSS_HOLIDAY                                        
               WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT ('Y')                                             
MFA-TR*         INTO :WS-ROW-EXISTS                                             
MFA-TR*         FROM CSS_HOLIDAY                                                
MFA-TR*        WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              SET NEXT-BUSINESS-DAY-NOT-FOUND TO TRUE                   
              MOVE ZEROES TO WS-DAY                                     
           ELSE                                                         
              IF SQLCODE EQUAL NOT-FOUND                                
                 SET NEXT-BUSINESS-DAY-FOUND TO TRUE                    
              ELSE                                                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                                            ABEND-FUNCTION              
              MOVE 'CSS_HOLIDAY'         TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-OPEN-METER-IND-CURSOR                                     *        
      ******************************************************************        
       7050-OPEN-METER-IND-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                 OPEN METER_IND_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_METER_CAP'            TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7055-FETCH-METER-IND-CURSOR                                    *        
      ******************************************************************        
       7055-FETCH-METER-IND-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH METER_IND_CURSOR                                    
               INTO :MC-CODE-CAP-TYPE  ,                                
                    :MC-CONSTANT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND THEN 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7055'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH METER_IND_CURSOR'   TO TABLE-1                
              MOVE 'CSS_METER_CAP'            TO TABLE-2                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7055-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7060-CLOSE-METER-IND-CURSOR                                    *        
      ******************************************************************        
       7060-CLOSE-METER-IND-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE METER_IND_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7060'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_METER_CAP'            TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7100-FETCH-VERSION-NO                                          *        
      *     CALLS       9998-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 5000-FETCH-SUBDIV-LIGHT                        *        
      *     FETCH VERSION NO CNTRL FROM CSS_RATE_CREATOR               *        
      ******************************************************************        
       7100-FETCH-VERSION-NO.                                           
                                                                        
           MOVE '7100'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           INITIALIZE WS-NULL-IND                                       
                      WS-VERSION-NO-CNTRL.                              
                                                                        
           EXEC SQL                                                     
               SELECT MAX(VERSION_NO_CNTRL)                             
                 INTO :WS-VERSION-NO-CNTRL :WS-NULL-IND                  
                 FROM CSS_RATE_CREATOR                                  
                WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE-WS        
                  AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO-WS          
                  AND CODE_STATUS IN ('A','I')                          
                  AND FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(VERSION_NO_CNTRL)                                     
MFA-TR*          INTO :WS-VERSION-NO-CNTRL:WS-NULL-IND                          
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE-WS                
MFA-TR*           AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO-WS                  
MFA-TR*           AND CODE_STATUS IN ('A','I')                                  
MFA-TR*           AND FROM_EFFECTIVE_DT <= :WS-CURRENT-DATE                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH VERSION-NO'         TO TABLE-1                
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7101-FETCH-UMTR-DESC.                                          *        
      ******************************************************************        
       7101-FETCH-UMTR-DESC.                                            
                                                                        
           MOVE '7101'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               SELECT L9.UM_EQUIP_ID                                    
                 INTO :L9-UM-EQUIP-ID                                   
                 FROM CSS_UNMTR_PLAN   UP,                              
                      CSS_UM_EQUIPMENT L9                               
                WHERE UP.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE-WS     
                  AND UP.RATE_PLAN_NO       = :WS-RATE-PLAN-NO-WS       
                  AND UP.VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL      
                  AND UP.RATE_ITEM_CODE     = :CP-RATE-ITEM-CODE        
                  AND UP.UM_EQUIP_ID        = L9.UM_EQUIP_ID            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH EQUIP ID'           TO TABLE-1                
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-2                
              MOVE 'CSS_UM_EQUIPMENT'         TO TABLE-3                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE CP-RATE-ITEM-CODE          TO HOSTVAR-ELEMENT-4      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7105-GET-CODE-STATUS.                                        *          
      * GET THE CODE STATUS AND CHECK WHETHER THE RATE IS ACTIVE     *          
      ****************************************************************          
       7105-GET-CODE-STATUS.                                            
                                                                        
           MOVE '7105'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               SELECT CODE_STATUS                                       
                 INTO :WS-CODE-STATUS                                   
                 FROM CSS_RATE_CREATOR                                  
                WHERE CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE-WS          
                  AND RATE_PLAN_NO     = :WS-RATE-PLAN-NO-WS            
                  AND VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL           
                  AND CODE_STATUS      = 'A'                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH CODE-STATUS'        TO TABLE-1                
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE 'A'                        TO HOSTVAR-ELEMENT-4      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-OPEN-UTIL-CURSOR                                          *        
      ******************************************************************        
       7110-OPEN-UTIL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN UTILITY_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN UTIL-CURSOR'         TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-FETCH-UTIL-CURSOR                                         *        
      ******************************************************************        
       7120-FETCH-UTIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH UTILITY_CURSOR                                      
               INTO :UT-IC-NO                  ,                        
                    :UT-CODE-REVENUE-CLASS     ,                        
                    :UT-RATE-PLAN-NO           ,                        
                    :UT-READ-CYCLE             ,                        
                    :UT-READ-ROUTE             ,                        
                    :UT-CODE-SIC-NO            ,                        
                    :UT-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN               
              SET SW-UT-FETCH-END             TO TRUE                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH UTIL-CURSOR'        TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-CLOSE-UTIL-CURSOR                                         *        
      ******************************************************************        
       7130-CLOSE-UTIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE UTILITY_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7130'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE UTIL-CURSOR'        TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-FETCH-PRICE-PER-SERV                                      *        
      *     CALLS       9998-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 5000-FETCH-SUBDIV-LIGHT                        *        
      *     FETCH PRICE PER SERVICE FROM CSS_UMTR_PLAN                 *        
      ******************************************************************        
       7200-FETCH-PRICE-PER-SERV.                                       
                                                                        
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE ZEROES TO WS-PRICE-PER-SERVICE                          
                          WS-PRICE-PER-SERV-ORDER.                      
                                                                        
           EXEC SQL                                                     
               SELECT PRICE_PER_SERV                                    
                 INTO :WS-PRICE-PER-SERVICE                             
                 FROM CSS_UNMTR_PLAN                                    
                WHERE CODE_UTIL_TYPE   = :WS-CODE-UNMETERED             
                  AND RATE_PLAN_NO     = :WS-RATE-PLAN-NO-WS            
                  AND VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL           
                  AND RATE_ITEM_CODE   = :WS-RATE-ITEM-CODE             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH PRICE_PER_SERV'     TO TABLE-1                
              MOVE 'CSS_UMTR_PLAN'            TO TABLE-2                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'RATE_ITEM_CD'             TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UNMETERED          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE WS-RATE-ITEM-CODE          TO HOSTVAR-ELEMENT-4      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-PRICE-PER-SERVICE TO WS-PRICE-PER-SERV-ORDER      
           ELSE                                                         
              MOVE ZEROES               TO WS-PRICE-PER-SERV-ORDER      
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-OPEN-MTRD-CURSOR                                          *        
      ******************************************************************        
       7210-OPEN-MTRD-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN METER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN MTRD-CURSOR'         TO TABLE-1                
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-2                
              MOVE 'CSS_MTRD_CAP'             TO TABLE-3                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-FETCH-MTRD-CURSOR                                         *        
      ******************************************************************        
       7220-FETCH-MTRD-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH METER_CURSOR                                        
               INTO :MN-CODE-UTIL-TYPE                ,                 
                    :MN-IC-NO                         ,                 
                    :MN-METER-NO                      ,                 
                    :MN-MTR-REF-NO                    ,                 
                    :MN-CODE-TIME-PERIOD              ,                 
                    :MN-LAST-READ-VALUE               ,                 
                    :MN-LAST-REG-READ-DATE :WS-NULL-IND,                 
                    :MN-REG-ID-NO                     ,                 
                    :MN-CODE-STATUS-REAS              ,                 
                    :MN-CODE-USAGE-TYPE               ,                 
                    :MN-CODE-USAGE-ID                 ,                 
                    :MN-CODE-USAGE-SOURCE             ,                 
                    :MN-CODE-METER-STATUS             ,                 
                    :MN-METER-SUPPLYING               ,                 
                    :MN-CODE-METER-LOC                ,                 
                    :MC-CONSTANT                      ,                 
                    :MC-NO-READ-DIALS                 ,                 
                    :MC-CODE-CAP-TYPE                 ,                 
                    :MN-POINT-ID                      ,                 
                    :MN-SEAL-CODE-ID                  ,                 
                    :MN-HEXAGRAM-LOCATION             ,                 
                    :MN-INSULATED-IND                 ,                 
                    :MN-LOCK-TYPE-ID                  ,                 
                    :MN-DELIVERY-LEVEL-CD             ,                 
                    :MN-UTILITY-SOURCE-CD             ,                 
                    :MN-IDR-RECIPIENT-CD              ,                 
                    :MN-PROGRAM-ID                    ,                 
                    :MN-MTR-READ-SOURCE-CD            ,                 
                    :MN-GIS-POINT-ID                  ,                 
                    :MN-METER-PRESSURE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN               
              SET SW-MN-FETCH-END             TO TRUE                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH MTRD-CURSOR'        TO TABLE-1                
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-2                
              MOVE 'CSS_MTRD_CAP'             TO TABLE-3                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230-CLOSE-MTRD-CURSOR                                         *        
      ******************************************************************        
       7230-CLOSE-MTRD-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE METER_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7230'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE MTRD-CURSOR'        TO TABLE-1                
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-2                
              MOVE 'CSS_MTRD_CAP'             TO TABLE-3                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-OPEN-REG-CURSOR                                           *        
      ******************************************************************        
       7310-OPEN-REG-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN REGISTER_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN REG-CURSOR'          TO TABLE-1                
              MOVE 'CSS_REGISTER_READ'        TO TABLE-2                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-FETCH-REG-CURSOR                                          *        
      ******************************************************************        
       7320-FETCH-REG-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH REGISTER_CURSOR                                     
               INTO :RG-CODE-UTIL-TYPE              ,                   
                    :RG-IC-NO                       ,                   
                    :RG-MTR-REF-NO                  ,                   
                    :MC-METER-NO                    ,                   
                    :RG-CODE-TIME-PERIOD            ,                   
                    :RG-REG-ID-NO                   ,                   
                    :RG-LAST-READ-VALUE             ,                   
                    :RG-LAST-REG-READ-DT :WS-NULL-IND,                   
                    :RG-CODE-REG-STATUS             ,                   
                    :RG-CODE-STATUS-REAS            ,                   
                    :RG-CODE-USAGE-TYPE             ,                   
                    :RG-CODE-USAGE-ID               ,                   
                    :RG-CODE-USAGE-SOURCE           ,                   
                    :MC-CONSTANT                    ,                   
                    :MC-NO-READ-DIALS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN                    
              SET SW-RG-FETCH-END             TO TRUE                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH REG-CURSOR'         TO TABLE-1                
              MOVE 'CSS_REGISTER_READ'        TO TABLE-2                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-CLOSE-REG-CURSOR                                          *        
      ******************************************************************        
       7330-CLOSE-REG-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE REGISTER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7330'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE REG-CURSOR'         TO TABLE-1                
              MOVE 'CSS_REGISTER_READ'        TO TABLE-2                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-OPEN-CUST-CURSOR                                          *        
      ******************************************************************        
       7410-OPEN-CUST-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                 OPEN CUST_PLAN_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN CUST-CURSOR'         TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-FETCH-CUST-CURSOR                                         *        
      ******************************************************************        
       7420-FETCH-CUST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH CUST_PLAN_CURSOR                                    
               INTO :CP-CODE-UTIL-TYPE    ,                             
                    :CP-IC-NO             ,                             
                    :CP-CODE-PLAN-STATUS  ,                             
                    :CP-CODE-STAT-REASON  ,                             
                    :CP-CODE-SERVICE-TYPE ,                             
                    :CP-RATE-ITEM-CODE    ,                             
                    :CP-MTHLY-AMOUNT-FIXED,                             
                    :CP-LIGHT-NO          ,                             
                    :CP-POLE-NO           ,                             
                    :CP-USAGE-FIXED       ,                             
                    :CP-NO-UNITS          ,                             
                    :CP-DIST-NO           ,                             
                    :WS-RATE-PLAN-NO-WS   ,                             
                    :WS-REVENUE-CLASS-WS  ,                             
                    :CP-ITEM-SEQ-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN               
              SET SW-CP-FETCH-END TO TRUE                               
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH CUST-CURSOR'        TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7430-CLOSE-CUST-CURSOR                                         *        
      ******************************************************************        
       7430-CLOSE-CUST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CUST_PLAN_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7430'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE CUST-CURSOR'        TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-OPEN-WORK-CURSOR                                          *        
      ******************************************************************        
       7510-OPEN-WORK-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                 OPEN ORDER_INST_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN WORK-CURSOR'         TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-FETCH-WORK-CURSOR                                         *        
      ******************************************************************        
       7520-FETCH-WORK-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH ORDER_INST_CURSOR                                   
               INTO :WB-CODE-UTIL-TYPE ,                                
                    :WB-CODE-METER-LOC ,                                
                    :WB-WORK-TYPE-CD   ,                                
                    :MN-IC-NO          ,                                
                    :WB-METER-NO       ,                                
                    :WB-SO-INST-SEQ-NO ,                                
                    :WB-METER-SUPPLYING,                                
                    :MN-MTR-REF-NO     ,                                
                    :MN-CODE-METER-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN                 
                 SET SW-WORK-FETCH-END        TO TRUE                   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH WORK-CURSOR'        TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7530-CLOSE-WORK-CURSOR                                         *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7530-CLOSE-WORK-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ORDER_INST_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7530'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE WORK-CURSOR'        TO TABLE-1                
              MOVE 'CSS_CUST_PLAN'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-ADDR-INFORMATION                                      *        
      ******************************************************************        
       7500-GET-ADDR-INFORMATION.                                       
                                                                        
           PERFORM 7630-SELECT-ACCT-ADDR             THRU 7630-EXIT.    
                                                                        
           IF WS-PR-ADDRESS-FORMAT = WS-FORMATTED                       
              PERFORM 7700-SELECT-FORMATTED-ZIP-CODE THRU 7700-EXIT     
           ELSE                                                         
              IF WS-PR-ADDRESS-FORMAT = WS-FREEFORM                     
                 PERFORM 7800-SELECT-FREE-ZIP-CODE   THRU 7800-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7505-GET-WA-INFORMATION                                        *        
      ******************************************************************        
       7505-GET-WA-INFORMATION.                                         
                                                                        
           IF SW-UT-FETCH-END AND                                       
              SW-MN-FETCH-END AND                                       
              SW-RG-FETCH-END AND                                       
              SW-CP-FETCH-END THEN                                      
                                                                        
              SET SW-FOUND-RELATED-SO         TO TRUE                   
      *       MOVE WS-WA-METER-IND-HOLD       TO WS-WA-METER-IND                
              MOVE WS-WA-READ-ROUTE-HOLD      TO WS-WA-READ-ROUTE       
              MOVE XE-LOCAL-OFFICE            TO WS-WA-LOCAL-OFFICE     
           END-IF.                                                      
                                                                        
       7505-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      *     START FCSJC01 FILE USING E-FJC01-KEY                       *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7600-START-FCSJC01.                                              
                                                                        
           EXEC SQL                                                     
              DECLARE PARM_CSR CURSOR FOR                               
              SELECT  PROGRAM_NAME                                      
                      ,COMPANY_NO                                       
                      ,CMND_CODE                                        
                      ,SEQ_NO                                           
                      ,STATUS                                           
                      ,PARM_DATA                                        
              FROM    CSS_JOB_PARM                                      
              WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                AND   CMND_CODE      = :G6-CMND-CODE                    
                AND   COMPANY_NO     = :G6-COMPANY-NO                   
              ORDER BY SEQ_NO                                           
           END-EXEC.                                                    
                                                                        
           MOVE WS-PROGRAM    TO G6-PROGRAM-NAME.                       
           MOVE WS-COMMAND    TO G6-CMND-CODE.                          
           MOVE '01'          TO G6-COMPANY-NO.                         
                                                                        
           EXEC SQL OPEN PARM_CSR END-EXEC.                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'DECLARE'             TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-READ-FCSJC01                                              *        
      *     READ SYSIPT PARAMETERS                                     *        
      *     VSAM FILE CONVERTED TO DB2 TABLE 10/94                     *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7610-READ-FCSJC01.                                               
                                                                        
           EXEC SQL FETCH PARM_CSR                                      
                INTO   :G6-PROGRAM-NAME                                 
                      ,:G6-COMPANY-NO                                   
                      ,:G6-CMND-CODE                                    
                      ,:G6-SEQ-NO                                       
                      ,:G6-STATUS                                       
                      ,:G6-PARM-DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE G6-SEQ-NO       TO E-FJC01-SEQ-NBR                  
                                       WS-SEQ-NBR                       
               MOVE G6-PROGRAM-NAME TO E-FJC01-PGRM-NAME                
               MOVE G6-CMND-CODE    TO E-FJC01-CMND-CODE                
               MOVE G6-STATUS       TO E-FJC01-STATUS                   
                                       WS-INPUT-STATUS                  
               MOVE G6-PARM-DATA    TO WS-INPUT-DATA-BREAKDOWN          
                                       E-FJC01-PARAMETER-DATA           
           ELSE                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE 'END' TO WS-SYSIPT                                  
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7611-CLOSE                                                     *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7611-CLOSE.                                                      
                                                                        
           EXEC SQL CLOSE PARM_CSR END-EXEC.                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7611'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7611-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6240-GET-FCA00-COMMON-DATE                     *        
      ******************************************************************        
       7620-START-FCSCA00.                                              
                                                                        
           EXEC SQL                                                     
              DECLARE CA00_CSR CURSOR FOR                               
              SELECT  PROGRAM_NAME                                      
                      ,COMPANY_NO                                       
                      ,CMND_CODE                                        
                      ,SEQ_NO                                           
                      ,STATUS                                           
                      ,PARM_DATA                                        
              FROM    CSS_JOB_PARM                                      
              WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                AND   CMND_CODE      = 'CA00'                           
                AND   COMPANY_NO     = :G6-COMPANY-NO                   
              ORDER BY SEQ_NO                                           
           END-EXEC.                                                    
                                                                        
           MOVE E-FCA00-KEY   TO G6-PROGRAM-NAME.                       
           MOVE 'PARM'        TO G6-CMND-CODE.                          
           MOVE '01'          TO G6-COMPANY-NO.                         
                                                                        
           EXEC SQL OPEN CA00_CSR END-EXEC.                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'DECLARE'             TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE E-FCA00-KEY           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7621-READ-FCSCA00                                              *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6240-GET-FCA00-COMMON-DATE                     *        
      ******************************************************************        
       7621-READ-FCSCA00.                                               
                                                                        
           EXEC SQL FETCH CA00_CSR                                      
                INTO   :G6-PROGRAM-NAME                                 
                      ,:G6-COMPANY-NO                                   
                      ,:G6-CMND-CODE                                    
                      ,:G6-SEQ-NO                                       
                      ,:G6-STATUS                                       
                      ,:G6-PARM-DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE G6-PROGRAM-NAME TO E-FCA00-KEY                      
               MOVE G6-PARM-DATA    TO E-FCA00-DATA                     
               MOVE '00'            TO WS-FCA00-STATUS                  
           ELSE                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE SPACES TO E-FCA00-KEY                               
               MOVE WS-Y   TO WS-FCA00-EOF-SW                           
               MOVE '23'   TO WS-FCA00-STATUS                           
               PERFORM 7622-CLOSE-CA00-CSR THRU 7622-EXIT               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7621'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE E-FCA00-KEY           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF
           END-IF.                                                      
      *                                                                         
       7621-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7622-CLOSE-CA00-CSR                                            *        
      *                                                                *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *     CALLED FROM 6240-GET-FCA00-COMMON-DATE                     *        
      ******************************************************************        
       7622-CLOSE-CA00-CSR.                                             
      *                                                                         
           EXEC SQL CLOSE CA00_CSR END-EXEC.                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7622'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE E-FCA00-KEY           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7622-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7630-SELECT-ACCT-ADDR                                          *        
      ******************************************************************        
       7630-SELECT-ACCT-ADDR.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_FORMAT,                                    
                     ADDRESS_ID                                         
                INTO :PR-ADDRESS-FORMAT,                                
                     :PR-ADDRESS-ID                                     
                FROM CSS_PREMISE                                        
               WHERE PREMISE_NO = :XE-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PR-ADDRESS-FORMAT          TO WS-PR-ADDRESS-FORMAT   
              MOVE PR-ADDRESS-ID              TO WS-PR-ADDRESS-ID       
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-ADDRESS-INFO'      TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE XE-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SELECT-FORMATTED-ZIP-CODE                                 *        
      ******************************************************************        
       7700-SELECT-FORMATTED-ZIP-CODE.                                  
                                                                        
           EXEC SQL                                                     
              SELECT ZIP_CODE                                           
                INTO :DY-ZIP-CODE                                       
                FROM CSS_ADDR_FORMATTED                                 
               WHERE ADDRESS_ID = :WS-PR-ADDRESS-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DY-ZIP-CODE                TO WS-WA-ZIP-CODE         
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-FORM-ZIPCODE'      TO TABLE-1                
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-2                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
              MOVE WS-PR-ADDRESS-ID           TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7750-SELECT-EXIST-DNP01                                        *        
P00128*     SEARCH FOR ANY ACTIVE DNP01 THAT ALREADY EXIST ON THE      *        
P00128*     ACCOUNT.                                                   *        
P00128******************************************************************        
P00128 7750-SELECT-EXIST-DNP01.                                         
P00128                                                                  
P00128     MOVE '7750' TO ACTIVE-PARAGRAPH.                             
P00128                                                                  
P00128     EXEC SQL                                                     
P00128        SELECT VO.SERV_ORDER_NO,                                  
P00128               REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                              
P00128               REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                             
P00128               AI.AMOUNT_DISC_BAL                                 
P00128          INTO :VO-SERV-ORDER-NO,                                 
P00128               :VO-ASSIGNED-DATETIME,                             
P00128               :VO-WANTED-BY-DATETIME,                            
P00128               :AI-AMOUNT-DISC-BAL                                
P00128          FROM CSS_SO_DATA VO,                                    
P00128               CSS_SO_DNP AI                                      
P00128         WHERE VO.ACCOUNT_NO = :VO-ACCOUNT-NO                     
P00128           AND VO.SERV_ORDER_NO = AI.SERV_ORDER_NO                
P00128           AND VO.ORDER_TYPE_CD = 'DNP01'                         
P00128           AND VO.ORDER_STATE_CD = 'A'                            
P00471           AND VO.ORDER_REASON IN ('N', 'O', 'J', 'K', 'U', 'V')  
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.SERV_ORDER_NO,                                          
MFA-TR*              VO.ASSIGNED_DATETIME,                                      
MFA-TR*              VO.WANTED_BY_DATETIME,                                     
MFA-TR*              AI.AMOUNT_DISC_BAL                                         
MFA-TR*         INTO :VO-SERV-ORDER-NO,                                         
MFA-TR*              :VO-ASSIGNED-DATETIME,                                     
MFA-TR*              :VO-WANTED-BY-DATETIME,                                    
MFA-TR*              :AI-AMOUNT-DISC-BAL                                        
MFA-TR*         FROM CSS_SO_DATA VO,                                            
MFA-TR*              CSS_SO_DNP AI                                              
MFA-TR*        WHERE VO.ACCOUNT_NO = :VO-ACCOUNT-NO                             
MFA-TR*          AND VO.SERV_ORDER_NO = AI.SERV_ORDER_NO                        
MFA-TR*          AND VO.ORDER_TYPE_CD = 'DNP01'                                 
MFA-TR*          AND VO.ORDER_STATE_CD = 'A'                                    
MFA-TR*          AND VO.ORDER_REASON IN ('N', 'O', 'J', 'K', 'U', 'V')          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00128                                           RS-RETURN-CODE.        
P00128                                                                  
P00128     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00128        WHEN SUCCESSFUL-CALL                                      
P00128           MOVE 'Y'                     TO WS-EXIST-DNP01         
P00128        WHEN NOT-FOUND                                            
P00128           MOVE 'N'                     TO WS-EXIST-DNP01         
P00128        WHEN OTHER                                                
P00128           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
P00128           MOVE '7750'                  TO ACTIVE-PARAGRAPH       
P00128           MOVE 'CSS_SO_DATA'           TO TABLE-1                
P00128           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
P00128           MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
P00128           PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
P00128     END-EVALUATE.                                                
P00128                                                                  
P00128 7750-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7755-CANCEL-DNP01.                                                      
P00128******************************************************************        
P00128 7755-CANCEL-DNP01.                                               
P00128                                                                  
P00128     EXEC SQL                                                     
P00128        UPDATE CSS_SO_DATA                                        
P00128           SET ORDER_STATE_CD = 'C'                               
P00128              ,COMPLETED_DATETIME = CIS.CURRENT$TIMESTAMP()             
P00128         WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO             
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*          SET ORDER_STATE_CD = 'C'                                       
MFA-TR*             ,COMPLETED_DATETIME = CURRENT TIMESTAMP                     
MFA-TR*        WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00128        NEXT SENTENCE                                             
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7755'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_DATA'              TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128                                                                  
P00128 7755-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7756-COMPUTE-STATUS-A.                                                  
P00128******************************************************************        
P00128 7756-COMPUTE-STATUS-A.                                           
                                                                        
P00128     EXEC SQL                                                     
P00128        SELECT TOP(1) SERV_ORDER_STATUS                                  
P00128          INTO :EG-SERV-ORDER-STATUS :WS-NULL-IND                  
P00128          FROM CSS_SO_REQUIREMENT WITH(READUNCOMMITTED)                   
P00128         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
P00128           AND (REQMNT_STAGE_CD = 'R'                             
P00128               OR  REQMNT_STAGE_CD = ' '                          
P00128               OR  REQMNT_STAGE_CD IS NULL)                       
P00128         ORDER BY SERV_ORDER_STATUS ASC                           
P00128                                    
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERV_ORDER_STATUS                                          
MFA-TR*         INTO :EG-SERV-ORDER-STATUS:WS-NULL-IND                          
MFA-TR*         FROM CSS_SO_REQUIREMENT                                         
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*          AND (REQMNT_STAGE_CD = 'R'                                     
MFA-TR*              OR  REQMNT_STAGE_CD = ' '                                  
MFA-TR*              OR  REQMNT_STAGE_CD IS NULL)                               
MFA-TR*        ORDER BY SERV_ORDER_STATUS ASC                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00128        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00128           MOVE SPACES                  TO EG-SERV-ORDER-STATUS   
P00128        ELSE                                                      
P00128           IF WS-NULL-IND = -1                                    
P00128              MOVE SPACES               TO EG-SERV-ORDER-STATUS   
P00128           END-IF                                                 
P00128        END-IF                                                    
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7756'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_REQUIREMENT'       TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128                                                                  
P00128 7756-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7757-COMPUTE-STATUS-D.                                                  
P00128******************************************************************        
P00128 7757-COMPUTE-STATUS-D.                                           
P00128                                                                  
P00128     EXEC SQL                                                     
P00128         SELECT TOP(1) SERV_ORDER_STATUS                                 
P00128           INTO :EG-SERV-ORDER-STATUS :WS-NULL-IND                 
P00128           FROM CSS_SO_REQUIREMENT WITH(READUNCOMMITTED)                  
P00128          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
P00128            AND (REQMNT_STAGE_CD = 'C'                            
P00128                 OR REQMNT_STAGE_CD = 'B')                        
P00128          ORDER BY SERV_ORDER_STATUS DESC                         
P00128                                    
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_STATUS                                         
MFA-TR*          INTO :EG-SERV-ORDER-STATUS:WS-NULL-IND                         
MFA-TR*          FROM CSS_SO_REQUIREMENT                                        
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND (REQMNT_STAGE_CD = 'C'                                    
MFA-TR*                OR REQMNT_STAGE_CD = 'B')                                
MFA-TR*         ORDER BY SERV_ORDER_STATUS DESC                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00128        NEXT SENTENCE                                             
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7757'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_REQUIREMENT'       TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128 7757-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7758-INSERT-SOUP.                                                       
P00128******************************************************************        
P00128 7758-INSERT-SOUP.                                                
P00128                                                                  
P00128     EXEC SQL                                                     
P00128        INSERT INTO CSS_SO_UPDATE                                 
P00128               (SERV_ORDER_NO                                     
P00128               ,USER_ID_UPDT_BY                                   
P00128               ,UPDATE_DATETIME                                   
P00128               ,PANEL_NO                                          
P00128               ,ASSIGNED_DATETIME                                 
P00128               ,ORDER_TYPE_CD                                     
P00128               ,SERV_ORDER_STATUS                                 
P00128               ,ORDER_STATE_CD                                    
P00128               ,WANTED_BY_DATETIME)                               
P00128        VALUES(                                                   
P00128               :VO-SERV-ORDER-NO                                  
P00128              ,'SYSTEM'                                           
P00128              ,CIS.CURRENT$TIMESTAMP()                                  
P00128              ,'U100'                                             
P00128              ,CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME)                  
P00128              ,'DNP01'                                            
P00128              ,:EG-SERV-ORDER-STATUS                              
P00128              ,'C'                                                
P00128              ,CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME))                
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SO_UPDATE                                         
MFA-TR*              (SERV_ORDER_NO                                             
MFA-TR*              ,USER_ID_UPDT_BY                                           
MFA-TR*              ,UPDATE_DATETIME                                           
MFA-TR*              ,PANEL_NO                                                  
MFA-TR*              ,ASSIGNED_DATETIME                                         
MFA-TR*              ,ORDER_TYPE_CD                                             
MFA-TR*              ,SERV_ORDER_STATUS                                         
MFA-TR*              ,ORDER_STATE_CD                                            
MFA-TR*              ,WANTED_BY_DATETIME)                                       
MFA-TR*       VALUES(                                                           
MFA-TR*              :VO-SERV-ORDER-NO                                          
MFA-TR*             ,'SYSTEM'                                                   
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,'U100'                                                     
MFA-TR*             ,:VO-ASSIGNED-DATETIME                                      
MFA-TR*             ,'DNP01'                                                    
MFA-TR*             ,:EG-SERV-ORDER-STATUS                                      
MFA-TR*             ,'C'                                                        
MFA-TR*             ,:VO-WANTED-BY-DATETIME)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00128        NEXT SENTENCE                                             
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7758'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_UPDATE'            TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128                                                                  
P00128 7758-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* EFEF-INS-SO-REMARKS.                                                    
P00128******************************************************************        
P00128 7759-INS-SO-REMARKS.                                             
P00128                                                                  
P00128*    MOVE 'C'                           TO EF-REMARK-TYPE-CD.             
P00128*    MOVE 27                            TO EF-REMARK-TX-LEN.              
P00128*    MOVE WS-CANCEL-REMARKS             TO EF-REMARK-TX-TEXT.             
P00128                                                                  
P00128     EXEC SQL                                                     
P00128        INSERT INTO CSS_SO_REMARKS                                
P00128               (SERV_ORDER_NO                                     
P00128               ,REMARK_TYPE_CD                                    
P00128               ,REMARK_DATETIME                                   
P00128               ,CHANGED_BY_USER_ID                                
P00128               ,REMARK_TX)                                        
P00128        VALUES (                                                  
P00128               :EF-SERV-ORDER-NO                                  
P00128              ,:EF-REMARK-TYPE-CD                                 
P00128              ,CIS.CURRENT$TIMESTAMP()                                  
P00128              ,'SYSTEM'                                           
P00128              ,:EF-REMARK-TX)                                     
P00128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SO_REMARKS                                        
MFA-TR*              (SERV_ORDER_NO                                             
MFA-TR*              ,REMARK_TYPE_CD                                            
MFA-TR*              ,REMARK_DATETIME                                           
MFA-TR*              ,CHANGED_BY_USER_ID                                        
MFA-TR*              ,REMARK_TX)                                                
MFA-TR*       VALUES (                                                          
MFA-TR*              :EF-SERV-ORDER-NO                                          
MFA-TR*             ,:EF-REMARK-TYPE-CD                                         
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,'SYSTEM'                                                   
MFA-TR*             ,:EF-REMARK-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00128        NEXT SENTENCE                                             
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7759'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_REMARKS'           TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE EF-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128                                                                  
P00128 7759-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7760-UPD-SO-DNP.                                                        
P00128******************************************************************        
P00128 7760-UPD-SO-DNP.                                                 
P00128                                                                  
P00128     EXEC SQL                                                     
P00128         UPDATE CSS_SO_DNP                                        
P00128            SET DNP_CNCL_REASON_CD = 'A'                          
P00128          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
P00128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00128        NEXT SENTENCE                                             
P00128     ELSE                                                         
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7760'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_SO_DNP'               TO TABLE-1                
P00128        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00128        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
P00128                                                                  
P00128 7760-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
P00128******************************************************************        
P00128* 7765-DELETE-SONP-ROW.                                                   
P00128******************************************************************        
P00128 7765-DELETE-SONP-ROW.                                            
                                                                        
P00128     EXEC SQL                                                     
P00128        DELETE FROM CSS_MKT_TRAN_OUTMF                            
P00128         WHERE TRANS_ID_CD = 'SONP'                               
P00128           AND SEB_ACCT_NO = :TJ-SEB-ACCT-NO                      
P00128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00128                                           RS-RETURN-CODE.        
P00128                                                                  
A02059     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00128        CONTINUE                                                  
P00128     ELSE                                                         
P00128        MOVE TJ-SEB-ACCT-NO             TO WS-ACCOUNT-NO          
P00128        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00128        MOVE '7765'                     TO ACTIVE-PARAGRAPH       
P00128        MOVE 'CSS_MKT_TRANS_OUTMF'      TO TABLE-1                
P00128        MOVE 'TRANS_ID_CD'              TO TABLE-ELEMENT-1        
P00128        MOVE 'SONP'                     TO HOSTVAR-ELEMENT-1      
P00128        MOVE 'SEB_ACCT_NO'              TO TABLE-ELEMENT-2        
P00128        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
P00128        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00128     END-IF.                                                      
                                                                        
P00128 7765-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-SELECT-FREE-ZIP-CODE                                      *        
      ******************************************************************        
       7800-SELECT-FREE-ZIP-CODE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_ZIP_CODE                                      
                INTO :DZ-ADDR-ZIP-CODE                                  
                FROM CSS_ADDR_FREEFORM                                  
               WHERE ADDRESS_ID = :WS-PR-ADDRESS-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DZ-ADDR-ZIP-CODE           TO WS-TEMP-ZIP-CODE       
              MOVE WS-TEMP-ZIP-CODE           TO WS-WA-ZIP-CODE         
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-FREE-ZIPCODE'      TO TABLE-1                
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-2                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
              MOVE WS-PR-ADDRESS-ID           TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7810-SELECT-CREDIT-HIST.                                       *PCS03750
      ******************************************************************PCS03780
       7810-SELECT-CREDIT-HIST.                                         
                                                                        
           EXEC SQL                                                     
               SELECT DISCONNECT_HIST,                                  
                      DISC_EXCEPTN_HIST,                                
                      NON_UTL_CR_HST,                                   
                      NON_UTL_CR_HST_EX                                 
                 INTO :CZ-DISCONNECT-HIST,                              
                      :CZ-DISC-EXCEPTN-HIST,                            
                      :CZ-NON-UTL-CR-HST,                               
                      :CZ-NON-UTL-CR-HST-EX                             
                 FROM CSS_CREDIT_PROFILE                                
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-CREDIT-HIST '      TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7820-SELECT-DNP-CL-ROWS.                                       *        
      ******************************************************************        
       7820-SELECT-DNP-CL-ROWS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT CODE_NOTICE_TYPE                                   
                INTO :CL-CODE-NOTICE-TYPE                               
                FROM CSS_CRED_COLL                                      
               WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                
                 AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                 :CL-DATE-CREDIT-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION) )        
                 AND CODE_NOTICE_TYPE IN ('D','G','H','I')              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_NOTICE_TYPE                                           
MFA-TR*         INTO :CL-CODE-NOTICE-TYPE                                       
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                        
MFA-TR*          AND DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION                
MFA-TR*          AND CODE_NOTICE_TYPE IN ('D','G','H','I')                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-CREDIT-HIST '      TO TABLE-1                
              MOVE 'CSS_CRED_COLL'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'D OR G OR H OR I'         TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7821-OPEN-CRED-COLL.                                           *        
      ******************************************************************        
       7821-OPEN-CRED-COLL.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CRED_COLL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7821'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN-CRED-COLL'           TO TABLE-1                
              MOVE 'CSS_CRED_COLL'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'D OR G OR H OR I'         TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7821-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7822-FETCH-CRED-COLL.                                          *        
      ******************************************************************        
       7822-FETCH-CRED-COLL.                                            
                                                                        
           EXEC SQL                                                     
              FETCH CRED_COLL_CURSOR                                    
               INTO :CL-CODE-NOTICE-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO CL-CODE-NOTICE-TYPE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7822'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH-CRED-COLL'     TO TABLE-1                
                   MOVE 'CSS_CRED_COLL'       TO TABLE-2                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-2        
                   MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-3        
                   MOVE XE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE CL-DATE-CREDIT-ACTION TO HOSTVAR-ELEMENT-2      
                   MOVE 'D OR G OR H OR I'    TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7822-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7823-CLOSE-CRED-COLL.                                          *        
      ******************************************************************        
       7823-CLOSE-CRED-COLL.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CRED_COLL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7821'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE-CRED-COLL'          TO TABLE-1                
              MOVE 'CSS_CRED_COLL'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'D OR G OR H OR I'         TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7823-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7825-OPEN-NON-UTIL.                                            *        
      ******************************************************************        
       7825-OPEN-NON-UTIL.                                              
                                                                        
           EXEC SQL                                                     
              OPEN NON_UTIL_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7825'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN-NON-UTIL'            TO TABLE-1                
              MOVE 'CSS_CRED_COLL'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'S OR U          '         TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7826-FETCH-NON-UTIL.                                          *         
      ******************************************************************        
       7826-FETCH-NON-UTIL.                                             
                                                                        
           EXEC SQL                                                     
              FETCH NON_UTIL_CURSOR                                     
               INTO :CL-CODE-NOTICE-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO CL-CODE-NOTICE-TYPE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7826'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH-NON-UTIL '     TO TABLE-1                
                   MOVE 'CSS_CRED_COLL'       TO TABLE-2                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-2        
                   MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-3        
                   MOVE XE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE CL-DATE-CREDIT-ACTION TO HOSTVAR-ELEMENT-2      
                   MOVE 'S OR U'              TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7826-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7827-CLOSE-NON-UTIL.                                           *        
      ******************************************************************        
       7827-CLOSE-NON-UTIL.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE NON_UTIL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7827'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE-NON-UTIL '          TO TABLE-1                
              MOVE 'CSS_CRED_COLL'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'S OR U'                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7827-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7830-UPDATE-EXCEPT-CREDIT.                                     *PCS03750
      ******************************************************************PCS03780
       7830-UPDATE-EXCEPT-CREDIT.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET DISC_EXCEPTN_HIST = :CZ-DISC-EXCEPTN-HIST         
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE-EXCEPT-CREDIT'     TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7835-UPD-NONUTL-EXCEPT-CREDIT                                  *PCS03750
      ******************************************************************PCS03780
       7835-UPD-NONUTL-EXCEPT-CREDIT.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET NON_UTL_CR_HST_EX = :CZ-NON-UTL-CR-HST-EX         
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7835'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPD-NONUTL-EXCEPT-CR'     TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7835-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7840-UPDATE-NORMAL-CREDIT.                                     *PCS03750
      ******************************************************************PCS03780
       7840-UPDATE-NORMAL-CREDIT.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET DISCONNECT_HIST = :CZ-DISCONNECT-HIST             
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7840'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE-NORMAL-CREDIT'     TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7840-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7845-UPD-NONUTL-NORMAL-CREDIT                                  *PCS03750
      ******************************************************************PCS03780
       7845-UPD-NONUTL-NORMAL-CREDIT.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET NON_UTL_CR_HST = :CZ-NON-UTL-CR-HST               
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7845'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPD NONUTL NORMAL CR'     TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7845-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7850-UPDATE-SERV-ORDER-PEND.                                   *PCS03750
      ******************************************************************PCS03780
       7850-UPDATE-SERV-ORDER-PEND.                                     
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SERV_ORDER_PEND = 'A'                             
                WHERE PREMISE_NO = :WS-PREMISE-NO-NUM                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE-SERV-ORDER-PEND'   TO TABLE-1                
              MOVE 'CSS_PREMISE'              TO TABLE-2                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO-NUM          TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7860-SELECT-CURRENT-TS.                                        *        
      ******************************************************************PCS03730
       7860-SELECT-CURRENT-TS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                 INTO :WS-CURRENT-TS                                    
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP                                         
MFA-TR*          INTO :WS-CURRENT-TS                                            
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7860'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT-CURRENT-TS'        TO TABLE-1                
              MOVE 'CSS_MODEL_SQL'            TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7870-UPD-CODES-DATE-PRESENT.                                   *PCS03750
      ******************************************************************PCS03780
       7870-UPD-CODES-DATE-PRESENT.                                     
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7870'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPD-CODES-DATE-PRESENT'   TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS03730
      * 7880-UPDT-SO-FAILED-IND.                                       *PCS03750
      ******************************************************************PCS03780
       7880-UPDT-SO-FAILED-IND.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
                  SET CODE_FRCST_CR_GRP  = :WS-O                        
                WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO               
                  AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                 :CL-DATE-CREDIT-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION) )       
                  AND CODE_NOTICE_TYPE IN ('D','G','H','I')             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CRED_COLL                                             
MFA-TR*           SET CODE_FRCST_CR_GRP  = :WS-O                                
MFA-TR*         WHERE ACCOUNT_NO         = :XE-ACCOUNT-NO                       
MFA-TR*           AND DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION               
MFA-TR*           AND CODE_NOTICE_TYPE IN ('D','G','H','I')                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7880'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-DATE-CREDIT-ACTION      TO HOSTVAR-ELEMENT-2      
              MOVE 'D OR G OR H OR I'         TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7880-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00128***************************************************************** *       
P00128* 7900-GET-DATABASE                                             *         
P00128***************************************************************** *       
P00128 7900-GET-DATABASE.                                               
                                                                        
P00128     MOVE '7900' TO ACTIVE-PARAGRAPH.                             
P00128     MOVE AT-COMPANY-NO      TO C8-COMPANY-NO.                    
P00128     MOVE 'DATABASE'         TO C8-DELINQ-CD.                     
                                                                        
P00128     EXEC SQL                                                     
P00128         SELECT DELINQ_VALUE                                      
P00128         INTO   :C8-DELINQ-VALUE                                  
P00128         FROM   CSS_DELINQUENCY                                   
P00128         WHERE  DELINQ_CD   = :C8-DELINQ-CD                       
P00128         AND    COMPANY_NO  = :C8-COMPANY-NO                      
P00128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00128                                                                  
P00128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00128     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00128        MOVE C8-DELINQ-VALUE    TO WS-DATABASE                    
P00128     ELSE                                                         
P00128        MOVE SPACES              TO ABEND-TABLES                  
P00128        MOVE SPACES              TO ABEND-SQL-PREDICATES          
P00128        MOVE 'PCSSO104'          TO ABEND-PROGRAM                 
P00128        MOVE 'SELECT'            TO ABEND-FUNCTION                
P00128        MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
P00128        MOVE 'DELINQ_CD'         TO TABLE-ELEMENT-1               
P00128        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-3               
P00128        MOVE C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1             
P00128        MOVE C8-COMPANY-NO       TO HOSTVAR-ELEMENT-3             
P00128        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00128     END-IF.                                                      
                                                                        
P00128 7900-EXIT.                                                       
P00128     EXIT.                                                        
                                                                        
      ***************************************************************** *       
      * 7992-FETCH-SECURITIES-AMT                                     *         
      *    CALLS       9998-SEND-ERROR-RESULT                         *         
      *                9900-SQL-ERROR-ROUTINE                         *         
      *                                                               *         
      *    CALLED FROM 2300-BUILD-RESULT                              *         
      *    COMPUTE TOTAL SECURITIES AMOUNT FOR THE ACCOUNT            *         
      ***************************************************************** *       
       7992-FETCH-SECURITIES-AMT.                                       
                                                                        
           MOVE '7992'                      TO ACTIVE-PARAGRAPH.        
           MOVE 0                           TO WS-SUM-AMT-BOND,         
                                               WS-SUM-AMT-GRNTD,        
                                               WS-SUM-AMT-DEPOSIT.      
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
                 INTO :WS-SUM-AMT-BOND :WS-NULL-IND                     
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO  = :XE-ACCOUNT-NO                      
                  AND CODE_STATUS = :WS-ACTIVE-CODE                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT SUM AMT_BOND'      TO TABLE-1                
              MOVE 'CSS_SURETY_BOND'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-CODE             TO HOSTVAR-ELEMENT-2      
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
           IF WS-NULL-IND = -1                                          
              MOVE 0                        TO WS-SUM-AMT-BOND          
           END-IF.                                                      
                                                                        
      *--FETCH AMOUNT GUARANTEED FROM CSS_GUARANTOR   -->                       
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMOUNT_GUARANTEED)                            
                 INTO :WS-SUM-AMT-GRNTD :WS-NULL-IND                    
                 FROM CSS_GUARANTOR                                     
                WHERE ACCOUNT_NO     = :XE-ACCOUNT-NO                   
                  AND GUAR_STATUS_CD = :WS-ACTIVE-CODE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT SUM AMT GRNTD'     TO TABLE-1                
              MOVE 'CSS_GUARANTOR'            TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
           IF WS-NULL-IND = -1                                          
              MOVE 0                          TO WS-SUM-AMT-GRNTD       
           END-IF.                                                      
                                                                        
      *--FETCH AMT_DEPOSIT FROM CSS_DEP_ON_HAND     -->                         
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                    INTO :WS-SUM-AMT-DEPOSIT :WS-NULL-IND               
               FROM CSS_DEP_ON_HAND                                     
               WHERE ACCOUNT_NO        = :XE-ACCOUNT-NO                 
               AND(DEPOSIT_STATUS_CD='A'                                
               OR DEPOSIT_STATUS_CD='P')                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT SUM AMT DEPOSIT'   TO TABLE-1                
              MOVE 'CSS_DEP_ON_HAND'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
           IF WS-NULL-IND = -1                                          
              MOVE 0                          TO WS-SUM-AMT-DEPOSIT     
           END-IF.                                                      
                                                                        
           COMPUTE WS-TOTAL-AMOUNT = WS-SUM-AMT-BOND  +                 
                                     WS-SUM-AMT-GRNTD +                 
                                     WS-SUM-AMT-DEPOSIT.                
           COMPUTE WS-TOTAL-AMOUNT = WS-TOTAL-AMOUNT * 100.             
           MOVE WS-TOTAL-AMOUNT TO WS-SECURITIES-TOT-AMT.               
                                                                        
       7992-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** *       
      * 7993-FETCH-ARREARS-CD                                         *         
      *    CALLS       9998-SEND-ERROR-RESULT                         *         
      *                9900-SQL-ERROR-ROUTINE                         *         
      *                                                               *         
      *    CALLED FROM 2300-BUILD-RESULT                              *         
      *    SELECT CURRENT MONTH ARREARS CODE FROM CSS_CREDIT_PROFILE  *         
      ***************************************************************** *       
       7993-FETCH-ARREARS-CD.                                           
                                                                        
           MOVE '7993'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           EXEC SQL                                                     
               SELECT ARREARS_HIST                                      
                 INTO :WS-ARREARS-HIST                                  
                 FROM CSS_CREDIT_PROFILE                                
                WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT ARREARS HIST'      TO TABLE-1                
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'N'                        TO SEND-DONE-SW           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-ARREARS-HIST(1:1) TO WS-CUR-MTH-ARREARS-CD.          
                                                                        
       7993-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** *       
      * 7994-GET-SO-DNP-DETLS                                         *         
      *    CALLS CPD00068 TO GET DISCONNECT BALANCE FOR DNP           *         
      *    OTHER BALANCE AND CREDIT GROUP.                            *         
      ***************************************************************** *       
       7994-GET-SO-DNP-DETLS.                                           
                                                                        
           MOVE '7994'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE PROGRAM-NAME                    TO WS-PGRMNAME.         
           PERFORM  6251-GET-FJC01-DATE         THRU 6251-EXIT.         
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE
           END-IF.               
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-DATE-CALC.                          
           SET NEXT-BUSINESS-DAY-NOT-FOUND TO TRUE.                     
           MOVE +1 TO WS-DATE-CTR.                                      
      *                                                                         
           PERFORM 0110-GET-NEXT-BUSINESS-DATE       THRU 0110-EXIT     
             UNTIL NEXT-BUSINESS-DAY-FOUND.                             
      *                                                                         
           MOVE WS-HOLD-INPUT-DATE TO WS-INPUT-DATE.                    
                                                                        
      *--CALLING CPD00068 TO GET DISCONNECT BALANCE FOR DNP -->                 
           MOVE WS-CURRENT-DATE         TO WS-CL-DATE-NOTICE-MAIL       
                                           WS-CL-DATE-NOTICE-DUE.       
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               MOVE WS-INPUT-DATE       TO WS-HOLD-DATE                 
               MOVE WS-YES              TO CALC-DNP-BAL-SW              
                                           CALC-ARREARS-SW              
                                           CALC-BALANCE-SW              
                                           CALC-PAST-DUE-SW             
               MOVE XE-ORDER-REASON     TO WS-HOLD-DNP-TYPE             
               MOVE PROGRAM-NAME        TO WS-CPD00068-CALLING-PGM      
      *        MOVE CWS00068-FIELDS          TO WS-CWS68-FIELDS-LK              
      *        MOVE WS-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT-LK        
      *        MOVE DCLCSS-ACCOUNT           TO WS-DCLCSS-ACCOUNT-LK            
      *        MOVE ABEND-FILE               TO WS-ABEND-FILE-LK                
      *        MOVE RS-RETURN-CODE           TO WS-RETURN-CODE-LK               
               MOVE SPACES                   TO ABEND-FUNCTION          
               PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT             
      *        MOVE WS-CWS68-FIELDS-LK       TO CWS00068-FIELDS                 
      *        MOVE WS-ABEND-FILE-LK         TO ABEND-FILE                      
      *        MOVE WS-DCLCSS-ACCOUNT-LK     TO DCLCSS-ACCOUNT                  
      *        MOVE WS-CODES-DATA-PRESENT-LK TO WS-CODES-DATA-PRESENT           
      *        MOVE WS-RETURN-CODE-LK        TO RS-RETURN-CODE                  
      *        MOVE RS-RETURN-CODE           TO WS-ACTIVE-RETURN-CODE,          
      *                                         SQLCODE                         
               IF ABEND-FUNCTION  > SPACES                              
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
               COMPUTE WS-AMT-DNP-BAL = ( WS-AMT-DNP-BAL * 100 )        
               MOVE WS-AMT-DNP-BAL      TO WS-DISC-BAL                  
           END-IF.                                                      
                                                                        
           PERFORM 7992-FETCH-SECURITIES-AMT   THRU 7992-EXIT.          
           PERFORM 7993-FETCH-ARREARS-CD       THRU 7993-EXIT.          
                                                                        
       7994-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05020***************************************************************** *       
A05020* 7995-GET-GAS-DISTRICTS                                        *         
A05020*    CALLS       9998-SEND-ERROR-RESULT                         *         
A05020*                9900-SQL-ERROR-ROUTINE                         *         
A05020*                                                               *         
A05020*    CALLED FROM 2300-BUILD-RESULT                              *         
A05020*    DETERMINES GAS ONLY DISTRICTS                              *         
A05020***************************************************************** *       
A05020 7995-GET-GAS-DISTRICTS.                                          
A05020                                                                  
A05020     MOVE '7995'                           TO ACTIVE-PARAGRAPH.   
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         SELECT 'Y'                                               
A05020           INTO :WS-GAS-DISTRICT                                  
A05020           FROM CSS_LOCAL_OFFICE                                  
A05020          WHERE LOCAL_OFFICE       = :XE-LOCAL-OFFICE             
A05020            AND COMPANY_NO         = :XE-COMPANY-NO               
A05020            AND SERV_ORDER_WORK_CD = 'GAS'                        
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
A05020                                                                  
A05020     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A05020        MOVE 'SELECT GAS DISTRICT'      TO TABLE-1                
A05020        MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-2                
A05020        MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-1        
A05020        MOVE XE-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
A05020        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05020     END-IF.                                                      
A05020                                                                  
A05020 7995-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      * 8000-DELETE-SO-DATA-MF                                         *        
      ******************************************************************        
       8000-DELETE-SO-DATA-MF.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SO_DATA_MF                                
A05317           WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                      
A05317             AND SO_DATA_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                     :XE-SO-DATA-SEQ-NO
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_SO_DATA_MF                                        
MFA-TR*          WHERE ACCOUNT_NO = :XE-ACCOUNT-NO                              
MFA-TR*            AND SO_DATA_SEQ_NO = :XE-SO-DATA-SEQ-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE TABLE'             TO TABLE-1                
              MOVE 'CSS_SO_DATA_MF'           TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020* 8100-UPD-PSNC-BIZ-UNIT                                         *        
A05020******************************************************************        
A05020 8100-UPD-PSNC-BIZ-UNIT.                                          
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        UPDATE CSS_SO_DATA                                        
A05020           SET SO_BUSINESS_UNIT = 'GOP'                           
A05020         WHERE SERV_ORDER_NO    = :WS-SERV-ORDER-NO               
A05020           AND SO_BUSINESS_UNIT = 'FSV'                           
A05020           AND COMPANY_NO       = '26'                            
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A05020                                           RS-RETURN-CODE.        
A05020                                                                  
A05020     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A05020        MOVE '8100'                     TO ACTIVE-PARAGRAPH       
A05020        MOVE 'UPDATE'                   TO TABLE-1                
A05020        MOVE 'CSS_SO_DATA'              TO TABLE-2                
A05020        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-2        
A05020        MOVE WS-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-2      
A05020        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05020     END-IF.                                                      
A05020                                                                  
A05020 8100-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020* 8200-UPD-SCEG-BIZ-UNIT                                         *        
A05020******************************************************************        
A05020 8200-UPD-SCEG-BIZ-UNIT.                                          
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        UPDATE CSS_SO_DATA                                        
A05020           SET SO_BUSINESS_UNIT = 'GOP'                           
A05020         WHERE SERV_ORDER_NO    = :WS-SERV-ORDER-NO               
A05020           AND COMPANY_NO       = '01'                            
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A05020                                           RS-RETURN-CODE.        
A05020                                                                  
A05020     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A05020        MOVE '8200'                     TO ACTIVE-PARAGRAPH       
A05020        MOVE 'UPDATE'                   TO TABLE-1                
A05020        MOVE 'CSS_SO_DATA'              TO TABLE-2                
A05020        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-2        
A05020        MOVE WS-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-2      
A05020        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05020     END-IF.                                                      
A05020                                                                  
A05020 8200-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************14880074
      * 9500-CALL-CPD00068.                                                     
      ******************************************************************14880074
       9500-CALL-CPD00068.                                              
                                                                        
           CALL SCSCB068  USING   CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           IF  ABEND-FUNCTION  > SPACES                                 
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '9500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CALL'                     TO ABEND-FUNCTION        
               MOVE 'CPD00068'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE XE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14880074
      * 9600-COMMIT-WORK                                               *14890074
      ******************************************************************14900074
       9600-COMMIT-WORK.                                                
                                                                        
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       9600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9000-SEND-ERROR-RESULT IS NOT BEING USED SINCE IT INITIALIZES *        
      *  TDS-RETURN-FIELDS. ALL RETURN FIELDS ARE REQUIRED TO SEND     *        
      *  BACK ERROR MESSAGES                                           *        
      ******************************************************************        
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
      *                                                                         
       9998-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
       9998-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           DISPLAY '*************************************'.             
           DISPLAY '**    PCSSO104 PROCESSING ERROR    **'.             
           DISPLAY '*************************************'.             
                                                                        
           IF WS-DB2-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' WS-DB2-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF WS-DB2-FUNCTION > SPACES                                  
               DISPLAY '**    FUNCTION  = ' WS-DB2-FUNCTION             
           END-IF.                                                      
                                                                        
           IF ACTIVE-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' ACTIVE-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               DISPLAY '**    FUNCTION  = ' ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           IF TABLE-1 > SPACES                                          
               DISPLAY '**    TABLE/FILE = ' TABLE-1                    
           END-IF.                                                      
                                                                        
           DISPLAY '*************************************'.             
      *                                                                         
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
      *                                                                         
