       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO103.                                            
       DATE-WRITTEN. FEBRUARY 26, 2007.                                 
       AUTHOR. ASHLEY WILSON.                                           
      ******************************************************************        
      *                                                                *        
      *               SOUTH CAROLINA ELECTRIC & GAS                    *        
      *                                                                *        
      *               CUSTOMER INFORMATION SYSTEM                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *    THIS IS A NON-CRITICAL PROGRAM WRITTEN TO REPLACE           *        
      *    CSR_CSO100.SQR PER REARCH.                                  *        
      *                                                                *        
      *    THIS PROBRAM WILL BE USED TO DELETE EXPIRED DNP/NOT SERVICE *        
      *    ORDERS OUT OF THE CSS_SO_DATA TABLE.  JOB WILL RUN NIGHTLY. *        
      *                                                                *        
      *                                                                *        
      *    Procedures :  CSR01416     CSR02122                         *        
      *                  CSR00125     CSR00556                         *        
      *                                                                *        
      *    Tables Used:  CSS_SO_DATA                                   *        
      *                  CSS_SO_DNP                                    *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -------------------------------------    *        
      * 12/13/95   J.A.H      CREATED SQR PROGRAM                      *        
T19720* 06/18/99   A.H.F      CHANGED PROGRAM TO CANCEL ACTIVE DNP     *        
T19720*                       ORDERS BY 2ND DAY INSTEAD OF THE 5TH.    *        
T19720* 07/26/99   A.H.F      CHANGED BACKED OUT UNTIL MORE TESTING    *        
T19720*                       CAN BE DONE.  WAS APPARENTLY CANX ALL    *        
T19720*                       THE DNPS.                                *        
C23235* 09-12-01   A.H.F      ADDED ADDITIONAL PARAMETER ORDER_TYPE_CD *        
C23235*                       TO EXEC OF PD_D0000235.                  *        
C23235* 09/17/01   A.H.F      ADDED CODE TO CANCEL NOTS.               *        
C25618* 11/08/01   A.H.F      CHAGNED CALL TO D125 AND D556 TO PASS    *        
C25618*                       SYSTEM INSTEAD WS-USER-ID-CPTD-BY.       *        
C25637* 11/12/01   A.H.F      CHANGED CODE TO SET REMARKS TO 'UNWORKED *        
C25637*                       WITHIN 5 DAY WINDOW' WHEN CANCEL NOTS.   *        
C35517* 02/26/07   AW41078    CONVERTED CSR_CSO100.SQR TO COBOL PRGM   *        
C35517*                       PCSSO103.                                *        
C37267* 05/06/08   SR82046    CORRECT SO POSTING AND UPDATING CREDIT   *        
C37267*                       HIST INCORRECTLY                         *        
A01016* 07/17/09   AW41078    1. ADD NEW ORDER TYPE CD RESULT SET      *        
A01016*                       COLUMN TO FETCH OF CSR00125.             *        
A01016*                       2.  PASS ORD TYPE RETURNED FROM CSR00125 *        
A01016*                       TO CSR02122 TO BE USED TO DETERMINE      *        
A01016*                       WHETHER TO INSERT INTO CSS_DNP_NOT_WORKED*        
A01016*                       3.  USE ORD TYPE RETURNED FROM CSR0125   *        
A01016*                       TO SET UPDATE PROFILE FLAG PASSED TO     *        
A01016*                       CSR02122. IF DNP01 IT SHOULD BE 'Y'      *        
A01016*                       4.  PASS SAME DNP CANCEL REMARKS TO      *        
A01016*                       CSR02122 FOR NEW REMARK_TX COLUMN IN     *        
A01016*                       CSS_DNP_NOT_WORKED TO BE USED FOR REPORT *        
A01016*                       5.WHEN CANCELING DNP DUE TO 'UNWORKED    *        
A01016*                       WHEN ACCOUNT BILLED' SCENARIO CANCEL WITH*        
A01016*                       DNP CANCEL RSN 'F'/BILLING               *        
A01016*                       6.WHEN CANCELING DNP DUE TO 'UNWORKED    *        
A01016*                       WITHIN 5 DAY WINDOW' SCENARIO CANCEL WITH*        
A01016*                       DNP CANCEL RSN 'G'/EXPIRED               *        
A01814* 02/25/10   DB18339    ADDED HANDLING FOR WHEN RC 5000 COMES    *        
A01814*                       BACK FROM CSR00125.                      *        
P00471* 06/22/11   PK98692    TO CHECK THE RETURN CODE OF CSR02122 TO  *        
P00471*                       SEE IF CALL TO CPD00335 FAILED. IF YES,  *        
P00471*                       MOVE 6 TO RETURN CODE AND SEND MAIL TO   *        
P00471*                       APPL SUPPORT. CSRPAGER STEP ADDED IN JCL *        
P00471*                       CSRS103 - RECHEDULED DNP CHANGES         *        
A03855* 12/27/11   PK98692    FIX QUERY                                *        
P00757* 11/18/13   MC95456    REPLACED CSR00028 CALL WITH SCSCB077     *        
A05136* 11/12/15   SS7F226    REMOVED THE CANCEL PENDING NOTICE ORDER. *        
A05136              ACT227                                             *
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH                                *        
      *  1000 - 1999  INITIALIZATION AND INPUT PROCESSING CONTROL PATH *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO103'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR PCSSO103 STARTS HERE'.                  
       01 PROGRAM-NAME                     PIC X(08) VALUE 'PCSSO103'.  
                                                                        
       01 WS-MISC.                                                      
          05 WS-CURRENT-TIMESTAMP          PIC X(26).                   
          05 WS-CURRENT-DATE               PIC X(10).                   
          05 WS-CHECK-TIMESTAMP            PIC X(26).                   
          05 WS-CHECK-DATE                 PIC X(10).                   
          05 WS-BIZNES-DAYS                PIC S9(02) COMP VALUE -4.    
          05 WS-DATE-RECVED                PIC X(26).                   
          05 WS-DATE-BILL-DAY-00           PIC X(26).                   
          05 WS-UNWK-ACCT-BILL-TX          PIC X(210) VALUE             
                                        'Unworked when account billed'. 
          05 WS-UNWK-CHECK-DT-TX           PIC X(210) VALUE             
                                        'Unworked within 5 day window'. 
          05 WS-COUNTER                    PIC S9(09) COMP VALUE 0.     
          05 WS-COUNT-DNP                  PIC S9(09) COMP VALUE 0.     
          05 WS-COUNT-NOT                  PIC S9(09) COMP VALUE 0.     
          05 WS-ORDER-CANCELED             PIC X(03)  VALUE 'NO'.       
          05 WS-COMMIT-COUNT               PIC S9(09) COMP VALUE 0.     
          05 WS-ACCOUNT-NO-CHAR            PIC X(13).                   
          05 WS-ACCOUNT-NO-NUM             REDEFINES WS-ACCOUNT-NO-CHAR 
                                               PIC 9(13).               
          05 WS-PREMISE-NO-CHAR            PIC X(10).                   
          05 WS-PREMISE-NO-NUM             REDEFINES WS-PREMISE-NO-CHAR 
                                               PIC 9(10).               
          05 WS-REMARKS-TX                 PIC X(210) VALUE SPACES.     
          05 WS-PANEL-NO                   PIC X(09) VALUE SPACES.      
          05 WS-CHK                        PIC X(04) VALUE 'CHK'.       
          05 WS-ORDER-TYPE-FLAG            PIC X(01).                   
          05 WS-ORDER-TYPE-CD              PIC X(05).                   
          05 WS-SERV-ORDER-CHAR            PIC X(13).                   
          05 WS-SERV-ORDER-NO              REDEFINES WS-SERV-ORDER-CHAR 
                                           PIC S9(13)V USAGE COMP-3.    
          05 WS-ORDER-REASON               PIC X(01).                   
          05 WS-ORDER-REASON-RET           PIC X(01).                   
          05 WS-RESP-AREA-ID               PIC X(03).                   
          05 WS-PENDING-SO-FLAG            PIC X(01) VALUE 'N'.         
          05 WS-INSERT-WORK-QUEUE          PIC X(01) VALUE 'N'.         
          05 WS-AMOUNT-DISC-BALZ-CHAR      PIC X(12) .                  
          05 WS-AMOUNT-DISC-BALZ.                                       
             10 WS-AMOUNT-DISC-BALZ-N      PIC X(09) JUSTIFIED RIGHT.   
             10 WS-AMOUNT-DISC-BALZ-D      PIC X(02).                   
          05 WS-AMOUNT-DISC-BALZ-PARM      PIC X(11).                   
A01016    05 WS-UPDATE-PROFILE             PIC X(01) VALUE 'N'.         
A01016    05 WS-DNP-CNCL-REASON-CD         PIC X(01).                   
P00471    05 WS-RESCH-DNP-ABEND            PIC X(01) VALUE 'N'.         
          05 WS-CSR02122-RET-CD            PIC S9(09) COMP VALUE 0.     
          05 WS-CSR01416-RET-CD            PIC S9(09) COMP VALUE 0.     
          05 WS-CSR00125-RET-CD            PIC S9(09) COMP VALUE 0.     
P00757    05 WS-SCSCB077-RET-CD            PIC S9(09) COMP VALUE 0.     
P00757    05 SCSCB077                      PIC X(08) VALUE 'SCSCB077'.  
A01814    05 WS-ITEM-ID                    PIC S9(10)V COMP-3 VALUE +0. 
A01814    05 WS-USER-ID-ASGN               PIC X(07).                   
A01814    05 WS-WQ-DNP-COMPLETE.                                        
A01814       10  WS-WQ-DNP-MSG1            PIC X(33) VALUE              
A01814        'DNP STATE IS COMPLETED OR HIGHER.'.                      
A01814       10  WS-WQ-DNP-MSG2            PIC X(46) VALUE              
A01814        ' PLEASE REVIEW ORDER FOR POSSIBLE CANCELLATION'.         
A01814       10  WS-WQ-DNP-MSG3            PIC X(42) VALUE              
A01814        ' AND UPDATE CREDIT HISTORY AS APPROPRIATE.'.             
                                                                        
       01 NULL-INDICATOR-FIELDS.                                        
          05 WS-DATE-FORECAST-DNP-NULL-IND PIC S9(4) COMP VALUE 0.      
          05 WS-DATE-RECVED-NULL-IND       PIC S9(4) COMP VALUE 0.      
          05 WS-DATE-BILL-DAY-00-NULL-IND  PIC S9(4) COMP VALUE 0.      
                                                                        
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE                PIC S9(4) COMP VALUE 0.      
          05 RS-RETURN-CODE-DISP           PIC +Z(4).                   
                                                                        
      ******************************************************************        
      * LOCATOR VARIABLES FOR RESULT SETS                              *        
      ******************************************************************        
                                                                        
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC2            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC3            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC4            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC5            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
A01814*01  LOC00028        USAGE SQL TYPE IS                            
A01814*                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
                                                                        
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
                                                                        
P00757******************************************************************        
P00757* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
P00757******************************************************************        
P00757*                                                                         
P00757     EXEC SQL                                                             
P00757        INCLUDE CWS00077                                                  
P00757     END-EXEC.                                                            
P00757*                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      *---<SQL COMMUNICATION AREA >                                             
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *---<CSS_SO_DATA      (PREFIX = VO) >                                     
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_SO_DNP       (PREFIX = AI) >                                     
           EXEC SQL                                                             
               INCLUDE TBSODNP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR FOR FETCHING DNP SERVICE ORDERS TO BE CANCELED          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO-DATA-DNP CURSOR WITH HOLD FOR                 
                 SELECT VO.SERV_ORDER_NO     ,                          
                        VO.ACCOUNT_NO        ,                          
                        VO.ORDER_TYPE_CD     ,                          
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.DATE_FORECAST_DNP, 121), ' ', '-'), ':', '.') 
           DATE_FORECAST_DNP ,                          
                        REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED       ,                    
                        VO.ORDER_REASON      ,                          
                        VO.SERV_ORDER_STATUS ,                          
                        VO.WORK_COMPLETED_IND,                          
                        VO.PREMISE_NO        ,                          
                        VO.USER_ID_CPTD_BY   ,                          
A01814                  VO.LOCAL_OFFICE      ,                          
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           AI.DATE_BILL_DAY_00, 121), ' ', '-'), ':', '.') 
           DATE_BILL_DAY_00                             
                 FROM CSS_SO_DATA VO         ,                          
                      CSS_SO_DNP AI                                     
                 WHERE VO.SERV_ORDER_NO = AI.SERV_ORDER_NO              
                   AND VO.COMPLETED_DATETIME IS NULL                    
                   AND VO.ORDER_TYPE_CD = 'DNP01'                       
                   AND VO.ORDER_STATE_CD NOT IN ('C','Z')               
                   AND (VO.PRINTED_IND = 'Y'                            
                    OR  VO.ASSIGNED_DATETIME IS NOT NULL)               
                   AND (CAST(VO.DATE_RECVED AS DATE) <=
              IIF(TRY_CONVERT(DATE, :WS-CHECK-TIMESTAMP
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-TIMESTAMP
              ) <> 0) OR (LEN(:WS-CHECK-TIMESTAMP
              ) <> 10), CIS.CHAR2DATE(:WS-CHECK-TIMESTAMP
              ), CONVERT(DATE, :WS-CHECK-TIMESTAMP) )
                    OR CAST(VO.DATE_RECVED AS DATE)<CAST(
           AI.DATE_BILL_DAY_00 AS DATE))  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO-DATA-DNP CURSOR WITH HOLD FOR                         
MFA-TR*          SELECT VO.SERV_ORDER_NO     ,                                  
MFA-TR*                 VO.ACCOUNT_NO        ,                                  
MFA-TR*                 VO.ORDER_TYPE_CD     ,                                  
MFA-TR*                 VO.DATE_FORECAST_DNP ,                                  
MFA-TR*                 VO.DATE_RECVED       ,                                  
MFA-TR*                 VO.ORDER_REASON      ,                                  
MFA-TR*                 VO.SERV_ORDER_STATUS ,                                  
MFA-TR*                 VO.WORK_COMPLETED_IND,                                  
MFA-TR*                 VO.PREMISE_NO        ,                                  
MFA-TR*                 VO.USER_ID_CPTD_BY   ,                                  
MFA-TR*                 VO.LOCAL_OFFICE      ,                                  
MFA-TR*                 AI.DATE_BILL_DAY_00                                     
MFA-TR*          FROM CSS_SO_DATA VO         ,                                  
MFA-TR*               CSS_SO_DNP AI                                             
MFA-TR*          WHERE VO.SERV_ORDER_NO = AI.SERV_ORDER_NO                      
MFA-TR*            AND VO.COMPLETED_DATETIME IS NULL                            
MFA-TR*            AND VO.ORDER_TYPE_CD = 'DNP01'                               
MFA-TR*            AND VO.ORDER_STATE_CD NOT IN ('C','Z')                       
MFA-TR*            AND (VO.PRINTED_IND = 'Y'                                    
MFA-TR*             OR  VO.ASSIGNED_DATETIME IS NOT NULL)                       
MFA-TR*            AND (DATE(VO.DATE_RECVED) <=DATE(:WS-CHECK-TIMESTAMP)        
MFA-TR*             OR DATE(VO.DATE_RECVED)<DATE(AI.DATE_BILL_DAY_00))          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * CURSOR FOR FETCHING NOT SERVICE ORDERS TO BE CANCELED          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO-DATA-NOT CURSOR WITH HOLD FOR                 
                 SELECT SERV_ORDER_NO     ,                             
                        ACCOUNT_NO        ,                             
                        ORDER_TYPE_CD     ,                             
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           DATE_FORECAST_DNP, 121), ' ', '-'), ':', '.') 
           DATE_FORECAST_DNP ,                             
                        REPLACE(REPLACE(CONVERT(CHAR(26), DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED       ,                    
                        ORDER_REASON      ,                             
                        SERV_ORDER_STATUS ,                             
                        WORK_COMPLETED_IND,                             
                        PREMISE_NO        ,                             
                        USER_ID_CPTD_BY                                 
                 FROM CSS_SO_DATA                                       
                 WHERE COMPLETED_DATETIME IS NULL                       
                   AND ORDER_TYPE_CD = 'NOT01'                          
                   AND ORDER_STATE_CD NOT IN ('C','Z')                  
                   AND (PRINTED_IND = 'Y'                               
                    OR  ASSIGNED_DATETIME IS NOT NULL)                  
                   AND CAST(DATE_RECVED AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-TIMESTAMP
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-TIMESTAMP
              ) <> 0) OR (LEN(:WS-CHECK-TIMESTAMP
              ) <> 10), CIS.CHAR2DATE(:WS-CHECK-TIMESTAMP
              ), CONVERT(DATE, :WS-CHECK-TIMESTAMP) )   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO-DATA-NOT CURSOR WITH HOLD FOR                         
MFA-TR*          SELECT SERV_ORDER_NO     ,                                     
MFA-TR*                 ACCOUNT_NO        ,                                     
MFA-TR*                 ORDER_TYPE_CD     ,                                     
MFA-TR*                 DATE_FORECAST_DNP ,                                     
MFA-TR*                 DATE_RECVED       ,                                     
MFA-TR*                 ORDER_REASON      ,                                     
MFA-TR*                 SERV_ORDER_STATUS ,                                     
MFA-TR*                 WORK_COMPLETED_IND,                                     
MFA-TR*                 PREMISE_NO        ,                                     
MFA-TR*                 USER_ID_CPTD_BY                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*          WHERE COMPLETED_DATETIME IS NULL                               
MFA-TR*            AND ORDER_TYPE_CD = 'NOT01'                                  
MFA-TR*            AND ORDER_STATE_CD NOT IN ('C','Z')                          
MFA-TR*            AND (PRINTED_IND = 'Y'                                       
MFA-TR*             OR  ASSIGNED_DATETIME IS NOT NULL)                          
MFA-TR*            AND DATE(DATE_RECVED) <= DATE(:WS-CHECK-TIMESTAMP)           
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE CSR01416-RS CURSOR
MSQ001          FOR CALL CSR01416                                       
               ( :WS-CURRENT-TIMESTAMP
                  , :WS-BIZNES-DAYS
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CSR00125-RS CURSOR
MSQ001          FOR CALL CSR00125                                       
               ( :WS-ACCOUNT-NO-CHAR
                  , :WS-PREMISE-NO-CHAR
                  , 'SYSTEM'
                  , :WS-REMARKS-TX
                  , 'Y'
                  , 'U'
                  , :WS-PANEL-NO
                  , :WS-ORDER-TYPE-FLAG
                  , :WS-DNP-CNCL-REASON-CD
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CSR02122-1-RS CURSOR
MSQ001          FOR CALL CSR02122                                       
               ( :WS-ACCOUNT-NO-CHAR
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , '00000000000'
                  , 'CHK'
                  , :WS-ORDER-TYPE-CD
                  , ' '
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CSR02122-2-RS CURSOR
MSQ001          FOR CALL CSR02122                                       
               ( :WS-ACCOUNT-NO-CHAR
                  , :WS-PREMISE-NO-CHAR
                  , :WS-ORDER-REASON
                  , :WS-DNP-CNCL-REASON-CD
                  , 'N'
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BALZ-CHAR
                  , :WS-PANEL-NO
                  , :WS-ORDER-TYPE-CD
                  , :WS-REMARKS-TX
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS MAIN PATH OF PROGRAM                           *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 1000-BEGIN-TIMING          THRU 1000-EXIT.          
            PERFORM 1200-GET-CHECK-DATE        THRU 1200-EXIT.          
            PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.          
            PERFORM 9600-END-TIMING            THRU 9600-EXIT.          
P00471      IF WS-RESCH-DNP-ABEND = 'Y'                                 
P00471         MOVE 6 TO RETURN-CODE                                    
P00471      END-IF                                                      
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-BEGIN-TIMING                                              *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       1000-BEGIN-TIMING.                                               
                                                                        
            DISPLAY '*************************************************'.
            DISPLAY '** PROGRAM NAME:  ' PROGRAM-NAME.                  
            DISPLAY '**  DESCRIPTION:  DNP/NOT SERVICE ORDER CANCEL'.   
                                                                        
            PERFORM 1100-GET-CURRENT-TIMESTAMP THRU 1100-EXIT.          
                                                                        
            DISPLAY '**   BEGIN TIME:  ' WS-CURRENT-TIMESTAMP.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-GET-CURRENT-TIMESTAMP                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       1100-GET-CURRENT-TIMESTAMP.                                      
                                                                        
            MOVE '1100'                     TO WS-ACTIVE-PARAGRAPH.     
                                                                        
            EXEC SQL                                                    
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE WS-CURRENT-TIMESTAMP    TO WS-CURRENT-DATE          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH      
               MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE 'CURRENT TIMESTAMP'        TO TABLE-ELEMENT-1       
               MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1200-GET-CHECK-DATE                                            *        
      *        OBTAIN THE DATE THAT IS 4 BUSINESS DAYS BEFORE THE      *        
      *        CURRENT DATE BY CALLING CSR01416.                       *        
      ******************************************************************        
       1200-GET-CHECK-DATE.                                             
                                                                        
           MOVE '1200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 1210-CALL-CSR01416      THRU 1210-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '**   CHECK DATE:  ' WS-CHECK-DATE                
              DISPLAY '***********************************************' 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1210-CALL-CSR01416                                             *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       1210-CALL-CSR01416.                                              
                                                                        
           MOVE '1210'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL CALL CSR01416                                       
      *        (:WS-CURRENT-TIMESTAMP                                   
      *        ,:WS-BIZNES-DAYS)                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR01416-RS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR01416-RS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR01416-RS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *          CSR01416                                               
      *       END-EXEC                                                  
      *       EXEC SQL                                                  
      *         ALLOCATE CSR01416-RS CURSOR FOR RESULT SET :LOC1        
      *       END-EXEC                                                  
              EXEC SQL                                                  
               FETCH CSR01416-RS                                        
                INTO :WS-CHECK-TIMESTAMP                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE             
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  MOVE WS-CHECK-TIMESTAMP TO WS-CHECK-DATE              
                  CONTINUE                                              
              ELSE                                                      
                  MOVE PROGRAM-NAME               TO ABEND-PROGRAM      
                  MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH   
                  MOVE 'FETCH CSR01416-RS'        TO ABEND-FUNCTION     
                  MOVE 'CSR01416'                 TO TABLE-1            
                  MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1    
                  MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1  
                  MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2    
                  MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2  
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
              END-IF                                                    
                                                                        
              EXEC SQL                                                  
                  CLOSE CSR01416-RS                                     
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE        
                                           RS-RETURN-CODE               
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  CONTINUE                                              
              ELSE                                                      
                  MOVE PROGRAM-NAME               TO ABEND-PROGRAM      
                  MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH   
                  MOVE 'CLOSE CSR01416-RS'        TO ABEND-FUNCTION     
                  MOVE 'CSR01416'                 TO TABLE-1            
                  MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1    
                  MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1  
                  MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2    
                  MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2  
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR01416'                 TO TABLE-1                
              MOVE 'V_INPUT_DATE_PARM'        TO TABLE-ELEMENT-1        
              MOVE WS-CURRENT-TIMESTAMP       TO HOSTVAR-ELEMENT-1      
              MOVE 'V_BIZNES_DAYS_PARM'       TO TABLE-ELEMENT-2        
              MOVE WS-BIZNES-DAYS             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MAIN-PROCESS                                              *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 2100-CANCEL-DNP-ORDERS  THRU 2100-EXIT.              
      *    NOT ORDERS, ONCE VALID FOR PSNC ARE NO LONGER BEING USED             
      *    PERFORM 2200-CANCEL-NOT-ORDERS  THRU 2200-EXIT.                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-CANCEL-DNP-ORDERS                                         *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2100-CANCEL-DNP-ORDERS.                                          
                                                                        
           DISPLAY '*********DNP CANCEL PROCESS BEGINS***************'. 
                                                                        
           PERFORM 7000-OPEN-SO-DATA-DNP-CURSOR   THRU 7000-EXIT.       
           PERFORM 7010-FETCH-SO-DATA-DNP-CURSOR  THRU 7010-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2300-UPDATE-DNP-SERV-ORDER  THRU 2300-EXIT        
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              DISPLAY '**>>THERE ARE NO EXPIRED DNP ORDERS TO CANCEL<<' 
           END-IF
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-SO-DATA-DNP-CURSOR  THRU 7020-EXIT.       
                                                                        
           DISPLAY '--------------------------'.                        
           DISPLAY '**RUNNING COUNT OF ORDERS PROCESSED: ' WS-COUNTER.  
           DISPLAY '**        TOTAL DNP ORDERS CANCELED: ' WS-COUNT-DNP.
           DISPLAY '*********DNP CANCEL PROCESS COMPLETE*************'. 
           DISPLAY ' '.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-PROCESS-DNP-CANCEL                                        *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2110-PROCESS-DNP-CANCEL.                                         
                                                                        
           MOVE AI-DATE-BILL-DAY-00        TO WS-DATE-BILL-DAY-00.      
           IF(WS-DATE-RECVED < WS-DATE-BILL-DAY-00) THEN                
              MOVE WS-UNWK-ACCT-BILL-TX    TO WS-REMARKS-TX             
A01016        MOVE 'F'                     TO WS-DNP-CNCL-REASON-CD     
           ELSE                                                         
              MOVE WS-UNWK-CHECK-DT-TX     TO WS-REMARKS-TX             
A01016        MOVE 'G'                     TO WS-DNP-CNCL-REASON-CD     
           END-IF.                                                      
                                                                        
           PERFORM 2120-CALL-CSR00125      THRU 2120-EXIT.              
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2120-CALL-CSR00125                                             *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2120-CALL-CSR00125.                                              
                                                                        
           MOVE '2120'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL CALL CSR00125                                       
      *        (:WS-ACCOUNT-NO-CHAR                                     
      *        ,:WS-PREMISE-NO-CHAR                                     
      *        ,'SYSTEM'                                                
      *        ,:WS-REMARKS-TX                                          
      *        ,'Y'                                                     
      *        ,'U'                                                     
      *        ,:WS-PANEL-NO                                            
      *        ,:WS-ORDER-TYPE-FLAG                                     
A01016*        ,:WS-DNP-CNCL-REASON-CD                                  
      *        )                                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR00125-RS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR00125-RS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR00125-RS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE         
      *          CSR00125                                               
      *       END-EXEC                                                  
      *       EXEC SQL                                                  
      *         ALLOCATE CSR00125-RS CURSOR FOR RESULT SET :LOC2        
      *       END-EXEC                                                  
              EXEC SQL                                                  
               FETCH CSR00125-RS                                        
                INTO :WS-CSR00125-RET-CD                                
                    ,:WS-SERV-ORDER-CHAR                                
                    ,:WS-ORDER-REASON-RET                               
                    ,:WS-RESP-AREA-ID                                   
                    ,:WS-PENDING-SO-FLAG                                
                    ,:WS-INSERT-WORK-QUEUE                              
                    ,:WS-AMOUNT-DISC-BALZ-CHAR                          
A01016              ,:WS-ORDER-TYPE-CD                                  
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE             
                                                                        
              IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND           
                 (WS-CSR00125-RET-CD = 0 OR WS-CSR00125-RET-CD = 100))  
                 CONTINUE                                               
A01814        ELSE IF WS-CSR00125-RET-CD = 5000                         
P00757           INITIALIZE CWS00077-FIELDS                             
P00757           MOVE '4'                   TO WS-77-ROUTE-CATEGORY     
P00757           MOVE VO-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE       
P00757           MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG       
P00757           MOVE SPACES                TO WS-77-RESP-AREA-ID       
P00757           MOVE 498                   TO WS-77-CATEGORY-ID        
P00757           MOVE VO-ACCOUNT-NO         TO WS-77-ACCOUNT-NO         
P00757           MOVE VO-PREMISE-NO         TO WS-77-PREMISE-NO         
P00757           MOVE 0                     TO WS-77-CUSTOMER-NO        
P00757           MOVE VO-SERV-ORDER-NO      TO WS-77-SERV-ORDER-NO      
P00757           MOVE +121                  TO WS-77-COMMENTS-LEN       
P00757           MOVE WS-WQ-DNP-COMPLETE    TO WS-77-COMMENTS-TEXT      
P00757           MOVE WS-CURRENT-TIMESTAMP  TO WS-77-DATE-REQUIRED      
P00757           MOVE WS-CURRENT-TIMESTAMP  TO WS-77-DATE-CREATED       
P00757           MOVE 'H'                   TO WS-77-PRIORITY           
P00757           MOVE PROGRAM-NAME          TO WS-77-CREATED-BY         
A01814           PERFORM 8200-INSERT-WQ-DNP THRU 8200-EXIT              
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'FETCH CSR00125-RS'        TO ABEND-FUNCTION      
                 MOVE 'CSR00125'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO'               TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
                                                                        
              EXEC SQL                                                  
                  CLOSE CSR00125-RS                                     
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE        
                                           RS-RETURN-CODE               
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'CLOSE CSR00125-RS'        TO ABEND-FUNCTION      
                 MOVE 'CSR00125'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO'               TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1      
              MOVE 'PREMISE NO'               TO TABLE-ELEMENT-2        
              MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-CANCEL-NOT-ORDERS                                         *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2200-CANCEL-NOT-ORDERS.                                          
                                                                        
           DISPLAY '*********NOT CANCEL PROCESS BEGINS***************'. 
                                                                        
           PERFORM 7100-OPEN-SO-DATA-NOT-CURSOR   THRU 7100-EXIT.       
           PERFORM 7110-FETCH-SO-DATA-NOT-CURSOR  THRU 7110-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2310-UPDATE-NOT-SERV-ORDER  THRU 2310-EXIT        
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              DISPLAY '**>>THERE ARE NO EXPIRED NOT ORDERS TO CANCEL<<' 
           END-IF
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-SO-DATA-NOT-CURSOR  THRU 7120-EXIT.       
                                                                        
           DISPLAY '--------------------------'.                        
           DISPLAY '**RUNNING COUNT OF ORDERS PROCESSED: ' WS-COUNTER.  
           DISPLAY '**        TOTAL NOT ORDERS CANCELED: ' WS-COUNT-NOT.
           DISPLAY '*********NOT CANCEL PROCESS COMPLETE*************'. 
           DISPLAY ' '.                                                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2300-UPDATE-DNP-SERV-ORDER                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2300-UPDATE-DNP-SERV-ORDER.                                      
                                                                        
           MOVE 'NO'                       TO WS-ORDER-CANCELED.        
           ADD 1                           TO WS-COUNTER.               
           MOVE VO-ACCOUNT-NO              TO WS-ACCOUNT-NO-NUM.        
           MOVE VO-ORDER-TYPE-CD           TO WS-ORDER-TYPE-CD.         
           MOVE 'P103'                     TO WS-PANEL-NO.              
           MOVE ' '                        TO WS-ORDER-TYPE-FLAG.       
           MOVE VO-PREMISE-NO              TO WS-PREMISE-NO-NUM         
                                                                        
           DISPLAY '--------------------------'                         
           DISPLAY '  RECORD # ' WS-COUNTER                             
           DISPLAY ' ACCOUNT # ' WS-ACCOUNT-NO-CHAR                     
           DISPLAY ' PREMISE # ' WS-PREMISE-NO-CHAR                     
           DISPLAY '      SO # ' VO-SERV-ORDER-NO                       
                                                                        
           PERFORM 2400-CALL-CSR02122-1 THRU 2400-EXIT                  
           IF WS-CSR02122-RET-CD = 0 THEN                               
                                                                        
              MOVE VO-ORDER-REASON            TO WS-ORDER-REASON        
              MOVE VO-DATE-RECVED             TO WS-DATE-RECVED         
                                                                        
C37267*       IF (WS-ORDER-REASON = 'A' OR WS-ORDER-REASON = 'M' OR             
C37267*           WS-ORDER-REASON = 'X') THEN                                   
C37267*           MOVE 'E'                     TO WS-ORDER-REASON               
C37267*       ELSE                                                              
C37267*           MOVE 'R'                     TO WS-ORDER-REASON               
C37267*       END-IF                                                            
                                                                        
              PERFORM 2110-PROCESS-DNP-CANCEL  THRU 2110-EXIT           
                                                                        
A01016        IF WS-ORDER-TYPE-CD = 'DNPFB' THEN                        
A01016          MOVE 'N' TO WS-UPDATE-PROFILE                           
A01016        ELSE                                                      
A01016          MOVE 'Y' TO WS-UPDATE-PROFILE                           
A01016        END-IF                                                    
                                                                        
              PERFORM 2410-CALL-CSR02122-2     THRU 2410-EXIT           
                                                                        
              IF WS-CSR00125-RET-CD = 0 AND WS-CSR02122-RET-CD = 0      
                 ADD 1                         TO WS-COUNT-DNP          
                 MOVE 'YES'                    TO WS-ORDER-CANCELED     
                 DISPLAY ' REMARKS : ' WS-REMARKS-TX                    
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
           DISPLAY 'CANCELED : ' WS-ORDER-CANCELED.                     
           PERFORM 7200-COMMIT-WORK         THRU 7200-EXIT              
           PERFORM 7010-FETCH-SO-DATA-DNP-CURSOR THRU 7010-EXIT.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2310-UPDATE-NOT-SERV-ORDER                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2310-UPDATE-NOT-SERV-ORDER.                                      
                                                                        
           MOVE 'NO'                       TO WS-ORDER-CANCELED.        
           ADD 1                           TO WS-COUNTER.               
           MOVE VO-ACCOUNT-NO              TO WS-ACCOUNT-NO-NUM.        
           MOVE VO-ORDER-TYPE-CD           TO WS-ORDER-TYPE-CD.         
           MOVE 'U100'                     TO WS-PANEL-NO.              
           MOVE ' '                        TO WS-ORDER-TYPE-FLAG.       
                                                                        
           DISPLAY '--------------------------'                         
           DISPLAY '  RECORD # ' WS-COUNTER                             
           DISPLAY ' ACCOUNT # ' WS-ACCOUNT-NO-CHAR                     
           DISPLAY ' PREMISE # ' WS-PREMISE-NO-CHAR                     
           DISPLAY '      SO # ' VO-SERV-ORDER-NO                       
                                                                        
           PERFORM 2400-CALL-CSR02122-1    THRU 2400-EXIT.              
           IF WS-CSR02122-RET-CD = 0 THEN                               
                                                                        
              MOVE VO-PREMISE-NO              TO WS-PREMISE-NO-NUM      
              MOVE VO-ORDER-REASON            TO WS-ORDER-REASON        
              MOVE VO-DATE-RECVED             TO WS-DATE-RECVED         
                                                                        
              IF (WS-ORDER-REASON = 'A' OR WS-ORDER-REASON = 'M' OR     
                  WS-ORDER-REASON = 'X') THEN                           
                  MOVE 'E'                     TO WS-ORDER-REASON       
              ELSE                                                      
                  MOVE 'R'                     TO WS-ORDER-REASON       
              END-IF                                                    
                                                                        
              PERFORM 2410-CALL-CSR02122-2     THRU 2410-EXIT           
                                                                        
              IF WS-CSR02122-RET-CD = 0                                 
                 ADD 1                         TO WS-COUNT-NOT          
                 MOVE 'YES'                    TO WS-ORDER-CANCELED     
                 DISPLAY ' REMARKS : ' WS-REMARKS-TX                    
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
           DISPLAY 'CANCELED : ' WS-ORDER-CANCELED.                     
           PERFORM 7200-COMMIT-WORK         THRU 7200-EXIT              
           PERFORM 7110-FETCH-SO-DATA-NOT-CURSOR  THRU 7110-EXIT.       
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-CALL-CSR02122-1                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2400-CALL-CSR02122-1.                                            
                                                                        
           MOVE '2400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL CALL CSR02122                                       
      *        (:WS-ACCOUNT-NO-CHAR                                     
      *        ,' '                                                     
      *        ,' '                                                     
      *        ,' '                                                     
      *        ,' '                                                     
      *        ,' '                                                     
      *        ,'00000000000'                                           
      *        ,'CHK'                                                   
      *        ,:WS-ORDER-TYPE-CD                                       
A01016*        ,' '                                                     
      *        )                                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR02122-1-RS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR02122-1-RS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR02122-1-RS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC4) WITH PROCEDURE         
      *          CSR02122                                               
      *       END-EXEC                                                  
      *       EXEC SQL                                                  
      *         ALLOCATE CSR02122-1-RS CURSOR FOR RESULT SET :LOC4      
      *       END-EXEC                                                  
              EXEC SQL                                                  
               FETCH CSR02122-1-RS                                      
                INTO :WS-CSR02122-RET-CD                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE             
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                 (WS-CSR02122-RET-CD = 0 OR WS-CSR02122-RET-CD = 1000)  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'FETCH CSR02122-1-RS'      TO ABEND-FUNCTION      
                 MOVE 'CSR02122'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3     
                 MOVE WS-CHK                     TO HOSTVAR-ELEMENT-3   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
                                                                        
                                                                        
              EXEC SQL                                                  
                  CLOSE CSR02122-1-RS                                   
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE        
                                           RS-RETURN-CODE               
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'CLOSE CSR02122-1-RS'      TO ABEND-FUNCTION      
                 MOVE 'CSR02122'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3     
                 MOVE WS-CHK                     TO HOSTVAR-ELEMENT-3   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1      
              MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2        
              MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2      
              MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3        
              MOVE WS-CHK                     TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  2410-CALL-CSR02122-2                                          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2410-CALL-CSR02122-2.                                            
                                                                        
           MOVE '2410'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL CALL CSR02122                                       
      *        (:WS-ACCOUNT-NO-CHAR                                     
      *        ,:WS-PREMISE-NO-CHAR                                     
      *        ,:WS-ORDER-REASON                                        
A01016*        ,:WS-DNP-CNCL-REASON-CD                                  
      *        ,'N'                                                     
A01016*        ,:WS-UPDATE-PROFILE                                      
      *        ,:WS-AMOUNT-DISC-BALZ-CHAR                               
      *        ,:WS-PANEL-NO                                            
      *        ,:WS-ORDER-TYPE-CD                                       
A01016*        ,:WS-REMARKS-TX                                          
      *        )                                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR02122-2-RS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR02122-2-RS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR02122-2-RS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC5) WITH PROCEDURE         
      *          CSR02122                                               
      *       END-EXEC                                                  
      *       EXEC SQL                                                  
      *         ALLOCATE CSR02122-2-RS CURSOR FOR RESULT SET :LOC5      
      *       END-EXEC                                                  
              EXEC SQL                                                  
               FETCH CSR02122-2-RS                                      
                INTO :WS-CSR02122-RET-CD                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE             
P00471*  CSR02122 RETURNS 4000 WHEN CALL TO CPD00335 FAILS                      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
P00471          (WS-CSR02122-RET-CD = 0 OR WS-CSR02122-RET-CD = 4000)   
P00471*          CONTINUE                                                       
P00471           IF WS-CSR02122-RET-CD = 4000                           
P00471                MOVE 'Y' TO WS-RESCH-DNP-ABEND                    
P00471                MOVE 0   TO WS-CSR02122-RET-CD                    
P00471           END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'FETCH CSR02122-2-RS'      TO ABEND-FUNCTION      
                 MOVE 'CSR02122'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3     
                 MOVE WS-PANEL-NO                TO HOSTVAR-ELEMENT-3   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
                                                                        
                                                                        
              EXEC SQL                                                  
                  CLOSE CSR02122-2-RS                                   
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE        
                                           RS-RETURN-CODE               
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH    
                 MOVE 'CLOSE CSR02122-2-RS'      TO ABEND-FUNCTION      
                 MOVE 'CSR02122'                 TO TABLE-1             
                 MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1   
                 MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2     
                 MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2   
                 MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3     
                 MOVE WS-PANEL-NO                TO HOSTVAR-ELEMENT-3   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'ACCOUNT NO PARM'          TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO-CHAR         TO HOSTVAR-ELEMENT-1      
              MOVE 'PREMISE NO PARM'          TO TABLE-ELEMENT-2        
              MOVE WS-PREMISE-NO-CHAR         TO HOSTVAR-ELEMENT-2      
              MOVE 'PANEL NO PARM'            TO TABLE-ELEMENT-3        
              MOVE WS-PANEL-NO                TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-SO-DATA-DNP-CURSOR                                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-SO-DATA-DNP-CURSOR.                                    
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN SO-DATA-DNP                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN SO-DATA-DNP'         TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CSS_SO_DNP'               TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-SO-DATA-DNP-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-SO-DATA-DNP-CURSOR.                                   
                                                                        
           MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH SO-DATA-DNP                                         
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-DATE-FORECAST-DNP :WS-DATE-FORECAST-DNP-NULL-IND 
                   ,:VO-DATE-RECVED :WS-DATE-RECVED-NULL-IND             
                   ,:VO-ORDER-REASON                                    
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-WORK-COMPLETED-IND                              
                   ,:VO-PREMISE-NO                                      
                   ,:VO-USER-ID-CPTD-BY                                 
A01814             ,:VO-LOCAL-OFFICE                                    
                   ,:AI-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL-IND   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH SO-DATA-DNP'        TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CSS_SO_DNP'               TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-SO-DATA-DNP-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7020-CLOSE-SO-DATA-DNP-CURSOR.                                   
                                                                        
           MOVE '7020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE SO-DATA-DNP                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE SO-DATA-DNP'        TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CSS_SO_DNP'               TO TABLE-2                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-SO-DATA-NOT-CURSOR                                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7100-OPEN-SO-DATA-NOT-CURSOR.                                    
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN SO-DATA-NOT                                        
          END-EXEC.                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN SO-DATA-NOT'         TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-SO-DATA-NOT-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7110-FETCH-SO-DATA-NOT-CURSOR.                                   
                                                                        
           MOVE '7110'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH SO-DATA-NOT                                         
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-DATE-FORECAST-DNP :WS-DATE-FORECAST-DNP-NULL-IND 
                   ,:VO-DATE-RECVED :WS-DATE-RECVED-NULL-IND             
                   ,:VO-ORDER-REASON                                    
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-WORK-COMPLETED-IND                              
                   ,:VO-PREMISE-NO                                      
                   ,:VO-USER-ID-CPTD-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH SO-DATA-NOT'        TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-SO-DATA-NOT-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7120-CLOSE-SO-DATA-NOT-CURSOR.                                   
                                                                        
           MOVE '7120'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE SO-DATA-NOT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE WS-ACTIVE-PARAGRAPH        TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE SO-DATA-NOT'        TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-COMMIT-WORK                                               *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7200-COMMIT-WORK.                                                
                                                                        
           ADD 1                               TO WS-COMMIT-COUNT       
           IF WS-COMMIT-COUNT > 24                                      
              EXEC SQL                                                  
                 COMMIT                                                 
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE 0                           TO WS-COMMIT-COUNT       
              DISPLAY '********************************************'    
              DISPLAY '* >>>COMMIT CHANGES FOR LAST 25 RECORDS<<< *'    
              DISPLAY '********************************************'    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01814******************************************************************        
A01814**  THIS PARAGRAPH IS USED TO INSERT A ROW IN THE               **        
A01814**  CSS_WQ_ITEMS TABLE.                                         **        
A01814******************************************************************        
A01814 8200-INSERT-WQ-DNP.                                              
A01814     MOVE '8200'               TO ACTIVE-PARAGRAPH.               
P00757     MOVE 0                    TO WS-77-ITEM-ID.                  
P00757     MOVE 'SYSTEM'             TO WS-77-USER-ID-ORIG.             
P00757     MOVE SPACES               TO WS-77-USER-ID-ASGN.             
P00757     MOVE 'PCSSO103 IS INSERTING THIS ROW' TO                     
P00757                                  WS-77-FREE-FORM-TXT.            
P00757     MOVE 33                   TO WS-77-FREE-FORM-LEN.            
A01814                                                                  
P00757        CALL SCSCB077 USING CWS00077-FIELDS,                      
P00757                            ABEND-FILE,                           
P00757                            WS-SCSCB077-RET-CD.                   
A01814                                                                  
P00757     MOVE WS-SCSCB077-RET-CD     TO WS-ACTIVE-RETURN-CODE         
A01814                                    RS-RETURN-CODE.               
A01814                                                                  
P00757     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A01814        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A01814        MOVE 'CALL'                     TO ABEND-FUNCTION         
A01814        MOVE 'SCSCB077'                 TO TABLE-1                
A01814        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
A01814        MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
A01814        MOVE 'SERV_ORDER_NO '           TO TABLE-ELEMENT-3        
A01814        MOVE 'SQL RETURN CODE'          TO TABLE-ELEMENT-4        
P00757        MOVE WS-77-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
P00757        MOVE WS-77-PREMISE-NO           TO HOSTVAR-ELEMENT-2      
P00757        MOVE WS-77-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-3      
A01814        MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-4      
A01814        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00757     ELSE                                                         
P00757        MOVE WS-77-WQ-ITEM-ID           TO WS-ITEM-ID             
A01814     END-IF.                                                      
A01814                                                                  
A01814 8200-EXIT.                                                       
A01814     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      *                                                                *        
      *     NOT USED                                                   *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           DISPLAY '>>>>ROLLED BACK CHANGES MADE SINCE LAST COMMIT<<<<'.
           DISPLAY '****************END PCSSO103*********************'. 
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  9600-END-TIMING                                               *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       9600-END-TIMING.                                                 
                                                                        
           DISPLAY '*******************SUMMARY***********************'. 
           DISPLAY '**  TOTAL RECORDS PROCESSED: ' WS-COUNTER.          
           DISPLAY '**TOTAL DNP ORDERS CANCELED: ' WS-COUNT-DNP.        
           DISPLAY '**TOTAL NOT ORDERS CANCELED: ' WS-COUNT-NOT.        
                                                                        
           PERFORM 1100-GET-CURRENT-TIMESTAMP THRU 1100-EXIT.           
                                                                        
           DISPLAY '**'.                                                
           DISPLAY '**END TIME: ' WS-CURRENT-TIMESTAMP.                 
           DISPLAY '****************END PCSSO103*********************'. 
           DISPLAY ' '.                                                 
                                                                        
       9600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *           
      ***************************************************************           
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      *    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *           
      ***************************************************************           
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
