       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO102.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00090000
      ******************************************************************00100000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *      DATE       INITIALS    REASON                             *00130000
      *    02/08/2007   VV90387     AUTOSYS JOB CSR_CSO102.SQR CONVERTED00140000
      *                             TO COBOL PROGRAM.                  *00140000
A01360*    12/22/2010   VV90387     INITIALIZE NULL INDICATOR          *00140000
P00718*    05/15/2014   VV90387     DO NOT INSERT INTO CSS_SO_CAD_QUEUE*00140000
P00718*                             FOR CLICK PREMISES                 *        
A05020*    09/29/2014   VV90387     INCREMENT SEQ NO FOR CLICK ORDERS  *00140000
A05020*                             THAT WERE CHANGED FROM HOLD        *00140000
A05020*    10/23/2014   VV90387     GAS CONSTR ORDERS NEED TO GO TO    *00140000
A05020*                             PRINT                              *00140000
A05020*    04/30/2015   MSR         FIX THE ISSUE WITH SKIPPING THE ROW*        
A05020*                             FROM TASK QUEUE TABLE              *        
A05020*    03/03/2015   VV          REMOVE MULTI REGISTER CHECK        *        
      ******************************************************************00221000
             REMARKS.                                                   
      ******************************************************************00240000
      *        THIS PROGRAM POPULATES THE SO_PRINT_QUEUE AND           *00250000
      *        SO_CAD_QUEUE TABLES. IT ALSO WRITES OUT A FILE WITH     *00260000
      *        DETAILS OF SERVICE ORDERS PROCESSED.                    *        
      ******************************************************************00320000
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSSO102-FILE ASSIGN  UT-S-FCSSO102                  
                   FILE STATUS IS WS-FSO102-STATUS.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSSO102-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSO102                           PIC X(133).                 
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO102'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)  VALUE            
           'WORKING STORAGE FOR PCSSO102 STARTS HERE'.                  
                                                                        
       01  WS-MISC1.                                                    
           05  WS-PGRMNAME                  PIC X(10)  VALUE 'SO102'.   
           05  PROGRAM-NAME                 PIC X(08)  VALUE 'PCSSO102'.
           05  WS-COMMON                    PIC X(10)  VALUE 'COMMON  '.
           05  WS-FSO102-STATUS             PIC X(02)  VALUE '00'.      
               88  WS-FSO102-SUCCESSFUL                VALUE '00'.      
           05 WS-WEEKEND-IND                PIC X(01)  VALUE 'N'.       
           05 WS-HOLIDAY-IND                PIC X(01)  VALUE 'N'.       
           05 WS-RLSE-INFO-REQ              PIC X(01)  VALUE 'N'.       
           05 WS-PRINT-ID-5-UP              PIC X(01)  VALUE 'N'.       
           05 WS-PRINT-LOC-SUCCESS          PIC X(01)  VALUE 'N'.       
           05 WS-PRINT-INSERTED             PIC X(01)  VALUE 'N'.       
           05 WS-CAD-INSERTED               PIC X(01)  VALUE 'N'.       
P00718     05 WS-CLICK-INSERTED             PIC X(01)  VALUE 'N'.       
A05020     05 WS-HOLD-TASK                  PIC X(01)  VALUE 'N'.       
           05 WS-CAD-LOCKOUT-IND            PIC X(01)  VALUE 'N'.       
           05 WS-CAD-WORKAREA-FL            PIC X(01)  VALUE 'N'.       
           05 WS-CAD                        PIC X(03)  VALUE 'CAD'.     
P00718     05 WS-WORK-DISTRICT              PIC X(40)  VALUE SPACES.    
P00718     05 WS-CLICK                      PIC X(05)  VALUE 'CLICK'.   
P00718     05 WS-CLICK-PREM                 PIC X(01)  VALUE 'N'.       
P00718     05 WS-RATE-EXIST                 PIC X(01)  VALUE 'N'.       
P00718     05 WS-RLSE-REQD                  PIC X(01)  VALUE 'N'.       
           05 WS-Y                          PIC X(01)  VALUE 'Y'.       
           05 WS-N                          PIC X(01)  VALUE 'N'.       
           05 WS-D                          PIC X(01)  VALUE 'D'.       
           05 WS-E                          PIC X(01)  VALUE 'E'.       
           05 WS-F                          PIC X(01)  VALUE 'F'.       
           05 WS-1                          PIC X(01)  VALUE '1'.       
           05 WS-2                          PIC X(01)  VALUE '2'.       
           05 WS-5                          PIC X(01)  VALUE '5'.       
           05 WS-01                         PIC X(02)  VALUE '01'.      
           05 WS-26                         PIC X(02)  VALUE '26'.      
           05 WS-811                        PIC S9(9)  VALUE -811 COMP. 
                                                                        
       01  WS-MISC2.                                                    
           05 WS-DAY-PARM                   PIC S9(02) COMP.            
           05 WS-DAYOFWEEK                  PIC S9(02) COMP.            
           05 WS-WANTED-BY-DT-NULL          PIC S9(04) COMP   VALUE 0.  
           05 WS-BIZ-DAY                    PIC S9(02) COMP.            
           05 WS-BIZ-CTR                    PIC S9(02).                 
           05 WS-WKNDHLDY-PRT-DEST          PIC X(01).                  
           05 WS-PRINT-PRIORITY             PIC X(01).                  
           05 WS-TIME                       PIC X(26).                  
           05 WS-PROCESS-DATE               PIC X(10).                  
           05 WS-DATE-TODAY                 PIC X(10).                  
           05 WS-ORDER-TYPE                 PIC X(03).                  
           05 WS-USE-PRINT-ID               PIC X(15).                  
           05 WS-HOLD-BATCH-PRINTER-ID      PIC X(15).                  
           05 WS-HOLD-AFTER-HRS             PIC X(15).                  
           05 WS-PRINT-ID-TEST              PIC X(15).                  
           05 WS-AFTER-HRS-TEST             PIC X(15).                  
           05 WS-SO-ROWS                    PIC 9(09).                  
           05 WS-WK-AREA-ROWS               PIC 9(09).                  
           05 WS-PRINT-ROWS                 PIC 9(09).                  
           05 WS-RECORD-COUNT               PIC 9(09).                  
           05 WS-COMMIT-COUNT               PIC S9(4) COMP VALUE 0.     
           05 WS-COMMIT-CTR                 PIC S9(4) COMP VALUE 0.     
           05 WS-COMMIT-PARM                PIC X(04).                  
                                                                        
      ******************************************************************        
      *     WORKING STORAGE FOR FILE VARIABLES                         *        
      ******************************************************************        
       01 WS-HEADER-LINES.                                              
          05 WS-HEADER-LINE1.                                           
             10 FILLER                  PIC X(72) VALUE                 
             'PCSSO102  -  Batch Summary Report (Populate so_print_queue        
      -      '/so_cad_queue)'.                                          01260000
             10 FILLER                  PIC X(61) VALUE SPACES.         
                                                                        
          05 WS-HEADER-LINE2.                                           
             10 FILLER                  PIC X(10) VALUE 'Run Date: '.   
             10 E-RUN-DATE              PIC X(26).                      
             10 FILLER                  PIC X(97) VALUE SPACES.         
                                                                        
          05 WS-HEADER-LINE3.                                           
             10 FILLER                  PIC X(12) VALUE 'Date_Today: '. 
             10 E-DATE-TODAY            PIC X(10).                      
             10 FILLER                  PIC X(111) VALUE SPACES.        
                                                                        
          05 WS-HEADER-LINE4.                                           
             10 FILLER                  PIC X(13) VALUE 'Weekend Ind: '.
             10 E-WEEKEND-IND           PIC X(01).                      
             10 FILLER                  PIC X(04) VALUE SPACES.         
             10 FILLER                  PIC X(13) VALUE 'Holiday Ind: '.
             10 E-HOLIDAY-IND           PIC X(01).                      
             10 FILLER                  PIC X(101) VALUE SPACES.        
                                                                        
       01 WS-DETAIL-LINE.                                               
          05 WS-DETAIL-LINE1.                                           
             10 FILLER                 PIC X(06) VALUE 'SO #: '.        
             10 E-SERV-ORDER-NO        PIC 9(13).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(09) VALUE 'COMPANY: '.     
             10 E-COMPANY-NO           PIC X(02).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(14) VALUE 'LOCAL OFFICE: '.
             10 E-LOCAL-OFFICE         PIC X(03).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(12) VALUE 'ORDER TYPE: '.  
             10 E-ORDER-TYPE           PIC X(05).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(11) VALUE 'WORK AREA: '.   
             10 E-WORK-AREA            PIC X(12).                       
             10 FILLER                 PIC X(30) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE2.                                           
             10 FILLER                 PIC X(16) VALUE                  
                                                 'CAD LOCKED OUT: '.    
             10 E-CAD-IND              PIC X(01).                       
             10 FILLER                 PIC X(116) VALUE SPACES.         
                                                                        
          05 WS-DETAIL-LINE3.                                           
             10 FILLER                 PIC X(12) VALUE 'NORMAL HRS: '.  
             10 E-NORMAL-HRS           PIC X(15).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(11) VALUE 'AFTER HRS: '.   
             10 E-AFTER-HRS            PIC X(15).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(07) VALUE 'BATCH: '.       
             10 E-BATCH                PIC X(15).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(14) VALUE 'CAD WORKAREA: '.
             10 E-CAD-WORKAREA         PIC X(01).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(22) VALUE                  
                                           'WKND/HLDY PRINT DEST: '.    
             10 E-PRINT-DEST           PIC X(01).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE4.                                           
             10 FILLER                 PIC X(19) VALUE                  
                                           'PRINT LOC SUCCESS: '.       
             10 E-PRINT-LOC-SUCCESS    PIC X(01).                       
             10 FILLER                 PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(12) VALUE                  
                                           'PRINT 5 UP: '.              
             10 E-PRINT-5-UP           PIC X(01).                       
             10 FILLER                 PIC X(96) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE5.                                           
             10 FILLER                 PIC X(51) VALUE                  
                'Inserting into the CAD Queue - with a priority of: '.  
             10 E-CAD-PRIORITY         PIC X(01).                       
             10 FILLER                 PIC X(81) VALUE SPACES.          
                                                                        
P00718    05 WS-DETAIL-LINE10.                                          
P00718       10 FILLER                 PIC X(51) VALUE                  
P00718          'Inserting into the TASK Queue- With a priority of: '.  
P00718       10 E-CLICK-PRIORITY       PIC X(01).                       
P00718       10 FILLER                 PIC X(81) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE6.                                           
             10 FILLER                 PIC X(50) VALUE                  
                'Inserting into the PRINT Queue - with printer id: '.   
             10 E-PRINTER-ID           PIC X(15).                       
             10 FILLER                 PIC X(02) VALUE SPACES.          
             10 FILLER                 PIC X(19) VALUE                  
                                       'and a priority of: '.           
             10 E-PRINT-PRIORITY       PIC X(01).                       
             10 FILLER                 PIC X(48) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE7.                                           
             10 FILLER                 PIC X(53) VALUE                  
                '******  Invalid - No Match for Printer Found on Table'.
             10 FILLER                 PIC X(28) VALUE                  
                ' Based on Work Area  ****** '.                         
             10 FILLER                 PIC X(52) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE8.                                           
             10 FILLER                 PIC X(53) VALUE                  
                'Unspecified Condition - Using the After Hours Printer'.
             10 FILLER                 PIC X(17) VALUE                  
                ' as the Default: '.                                    
             10 E-USE-PRINT-ID         PIC X(15).                       
             10 FILLER                 PIC X(48) VALUE SPACES.          
                                                                        
          05 WS-DETAIL-LINE9.                                           
             10 FILLER                 PIC X(18) VALUE                  
                                                 'RELEASE REQUIRED: '.  
             10 E-RLSE-INFO-REQ        PIC X(01).                       
             10 FILLER                 PIC X(114) VALUE SPACES.         
                                                                        
       01 WS-END-DATA-LINE.                                             
          05 WS-END-DATA-LINE1.                                         
             10 FILLER                 PIC X(25) VALUE                  
                                           'Total Records Processed: '. 
             10 E-RECORD-COUNT         PIC 9(09).                       
             10 FILLER                 PIC X(99) VALUE SPACES.          
                                                                        
          05 WS-END-DATA-LINE2.                                         
             10 FILLER                      PIC X(17) VALUE             
                                                'Report End Time: '.    
             10 E-END-TIME                  PIC X(26).                  
             10 FILLER                      PIC X(90) VALUE SPACES.     
                                                                        
       01  WS-BLANK-LINE                    PIC X(133) VALUE SPACES.    
                                                                        
       COPY CWS00038.                                                   01270000
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
       COPY FIOJC01.                                                    01300000
                                                                        
      ***************************************************************** 01320000
      * SQL COMMUNICATION AREA                                        * 01330000
      ***************************************************************** 01320000
           EXEC SQL                                                     01350000
                INCLUDE SQLCA                                           01360000
           END-EXEC.                                                    01370000
                                                                        
      ***************************************************************** 01320000
      * CSS_JOB_PARM       (PREFIX = G6)                              * 01470000
      ***************************************************************** 01320000
           EXEC SQL                                                     01490000
                INCLUDE TBJBPARM                                        01500000
           END-EXEC.                                                    01510000
                                                                        
      ***************************************************************** 01320000
      * CSS_DELINQUENCY    (PREFIX = C8)                              * 01520000
      ***************************************************************** 01320000
           EXEC SQL                                                     01520000
               INCLUDE TBDELQ                                           01520000
           END-EXEC.                                                    01520000
                                                                        
P00718***************************************************************** 01320000
P00718* CSS_SO_TASK_QUEUE  (PREFIX = TQ)                              * 01520000
P00718***************************************************************** 01320000
P00718     EXEC SQL                                                     01520000
P00718         INCLUDE TBTSKQUE                                         01520000
P00718     END-EXEC.                                                    01520000
P00718                                                                  
P00718***************************************************************** 01320000
P00718* CSS_REGISTER_READ  (PREFIX = RG)                              * 01520000
P00718***************************************************************** 01320000
P00718     EXEC SQL                                                     01520000
P00718         INCLUDE TBRGREAD                                         01520000
P00718     END-EXEC.                                                    01520000
P00718                                                                  
P00718***************************************************************** 01320000
P00718* CSS_PREMISE        (PREFIX = PR)                              * 01520000
P00718***************************************************************** 01320000
P00718     EXEC SQL                                                     01520000
P00718         INCLUDE TBPREM                                           01520000
P00718     END-EXEC.                                                    01520000
P00718                                                                  
P00718***************************************************************** 01320000
P00718* CSS_SO_UTL_CHG     (PREFIX = VE)                              * 01520000
P00718***************************************************************** 01320000
P00718     EXEC SQL                                                     01520000
P00718         INCLUDE TBSOUTG                                          01520000
P00718     END-EXEC.                                                    01520000
P00718                                                                  
      ***************************************************************** 01320000
      * CSS_SO_UTILITY     (PREFIX = VT)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOUTL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_MODEL_SQL      (PREFIX = MS)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_HOLIDAY        (PREFIX = J8)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_ORDER_TYPE     (PREFIX = C2)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBORTYP                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_PRINT_LOC   (PREFIX = C4)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOLOC                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_CAD_CNTL    (PREFIX = C6)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCDCNT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_ORDER_INST  (PREFIX = VI)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_PRINT_QUEUE (PREFIX = VP)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSOPRT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_CAD_QUEUE   (PREFIX = QP)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCADPQU                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_SO_DATA        (PREFIX = VO)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------* 02016203
      * CURSOR FOR FETCHING THE WEEKEND/HOLIDAY ORDERS                * 02016303
      *---------------------------------------------------------------* 02016503
           EXEC SQL                                                     
                DECLARE WKND-HLDY CURSOR WITH HOLD FOR                  
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           D.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME   ,                         
                        D.SERV_ORDER_NO       ,                         
                        D.COMPANY_NO          ,                         
                        D.LOCAL_OFFICE        ,                         
                        D.ORDER_TYPE_CD       ,                         
                        D.ORDER_RECVED_BY     ,                         
                        D.ORDER_PRIORITY_CD   ,                         
                        D.WORK_AREA_ID        ,                         
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           D.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME  ,                         
                        O.SO_PRINT_FORM_CD    ,                         
P00718                  O.ORDER_GROUP_CD                                
                   FROM CSS_SO_DATA     D     ,                         
                        CSS_ORDER_TYPE  O                               
                   WHERE CAST(D.ASSIGNED_DATETIME AS DATE)                      
                                              <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-TODAY
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TODAY
              ) <> 0) OR (LEN(:WS-DATE-TODAY) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TODAY
              ), CONVERT(DATE, :WS-DATE-TODAY) )         
                   AND   D.ORDER_STATE_CD      = 'A'                    
                   AND   D.PRINTED_IND         = 'N'                    
                   AND   D.BACK_DATED_IND     <> 'Y'                    
                   AND   O.ORDER_TYPE_CD       = D.ORDER_TYPE_CD        
                   AND   O.COMPANY_NO          = D.COMPANY_NO           
                   AND   O.WKND_HLDY_PRT_FL    = 'Y'                    
                   AND   O.SO_PRINT_FORM_CD BETWEEN '1' AND '5'         
                   ORDER BY D.WORK_AREA_ID, D.ORDER_PRIORITY_CD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02016603
MFA-TR*         DECLARE WKND-HLDY CURSOR WITH HOLD FOR                  02016703
MFA-TR*          SELECT D.ASSIGNED_DATETIME   ,                         02016803
MFA-TR*                 D.SERV_ORDER_NO       ,                                 
MFA-TR*                 D.COMPANY_NO          ,                                 
MFA-TR*                 D.LOCAL_OFFICE        ,                                 
MFA-TR*                 D.ORDER_TYPE_CD       ,                                 
MFA-TR*                 D.ORDER_RECVED_BY     ,                                 
MFA-TR*                 D.ORDER_PRIORITY_CD   ,                                 
MFA-TR*                 D.WORK_AREA_ID        ,                                 
MFA-TR*                 D.WANTED_BY_DATETIME  ,                                 
MFA-TR*                 O.SO_PRINT_FORM_CD    ,                                 
MFA-TR*                 O.ORDER_GROUP_CD                                        
MFA-TR*            FROM CSS_SO_DATA     D     ,                                 
MFA-TR*                 CSS_ORDER_TYPE  O                                       
MFA-TR*            WHERE DATE(D.ASSIGNED_DATETIME)                              
MFA-TR*                                       <= :WS-DATE-TODAY                 
MFA-TR*            AND   D.ORDER_STATE_CD      = 'A'                            
MFA-TR*            AND   D.PRINTED_IND         = 'N'                            
MFA-TR*            AND   D.BACK_DATED_IND     <> 'Y'                            
MFA-TR*            AND   O.ORDER_TYPE_CD       = D.ORDER_TYPE_CD                
MFA-TR*            AND   O.COMPANY_NO          = D.COMPANY_NO                   
MFA-TR*            AND   O.WKND_HLDY_PRT_FL    = 'Y'                            
MFA-TR*            AND   O.SO_PRINT_FORM_CD BETWEEN '1' AND '5'                 
MFA-TR*            ORDER BY D.WORK_AREA_ID, D.ORDER_PRIORITY_CD                 
MFA-TR*    END-EXEC.                                                    02017603
                                                                        
      *---------------------------------------------------------------* 02016203
      * CURSOR FOR FETCHING THE BUSINESS DAY ORDERS                   * 02016303
      *---------------------------------------------------------------* 02016503
           EXEC SQL                                                     
                DECLARE BIZ-DAY CURSOR WITH HOLD FOR                    
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           D.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME   ,                         
                        D.SERV_ORDER_NO       ,                         
                        D.COMPANY_NO          ,                         
                        D.LOCAL_OFFICE        ,                         
                        D.ORDER_TYPE_CD       ,                         
                        D.ORDER_RECVED_BY     ,                         
                        D.ORDER_PRIORITY_CD   ,                         
                        D.WORK_AREA_ID        ,                         
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           D.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME  ,                         
                        O.SO_PRINT_FORM_CD    ,                         
P00718                  O.ORDER_GROUP_CD                                
                   FROM CSS_SO_DATA         D ,                         
                        CSS_ORDER_TYPE      O                           
                   WHERE CAST(D.ASSIGNED_DATETIME AS DATE)                      
                                               <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-TODAY
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TODAY
              ) <> 0) OR (LEN(:WS-DATE-TODAY) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TODAY
              ), CONVERT(DATE, :WS-DATE-TODAY) )        
                   AND   D.ORDER_STATE_CD       = 'A'                   
                   AND   D.PRINTED_IND          = 'N'                   
                   AND   D.BACK_DATED_IND      <> 'Y'                   
                   AND   O.ORDER_TYPE_CD        = D.ORDER_TYPE_CD       
                   AND   O.COMPANY_NO           = D.COMPANY_NO          
                   AND   O.SO_PRINT_FORM_CD BETWEEN '1' AND '5'         
                   ORDER BY D.WORK_AREA_ID, D.ORDER_PRIORITY_CD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02016603
MFA-TR*         DECLARE BIZ-DAY CURSOR WITH HOLD FOR                    02016703
MFA-TR*          SELECT D.ASSIGNED_DATETIME   ,                         02016803
MFA-TR*                 D.SERV_ORDER_NO       ,                                 
MFA-TR*                 D.COMPANY_NO          ,                                 
MFA-TR*                 D.LOCAL_OFFICE        ,                                 
MFA-TR*                 D.ORDER_TYPE_CD       ,                                 
MFA-TR*                 D.ORDER_RECVED_BY     ,                                 
MFA-TR*                 D.ORDER_PRIORITY_CD   ,                                 
MFA-TR*                 D.WORK_AREA_ID        ,                                 
MFA-TR*                 D.WANTED_BY_DATETIME  ,                                 
MFA-TR*                 O.SO_PRINT_FORM_CD    ,                                 
MFA-TR*                 O.ORDER_GROUP_CD                                        
MFA-TR*            FROM CSS_SO_DATA         D ,                                 
MFA-TR*                 CSS_ORDER_TYPE      O                                   
MFA-TR*            WHERE DATE(D.ASSIGNED_DATETIME)                              
MFA-TR*                                        <= :WS-DATE-TODAY                
MFA-TR*            AND   D.ORDER_STATE_CD       = 'A'                           
MFA-TR*            AND   D.PRINTED_IND          = 'N'                           
MFA-TR*            AND   D.BACK_DATED_IND      <> 'Y'                           
MFA-TR*            AND   O.ORDER_TYPE_CD        = D.ORDER_TYPE_CD               
MFA-TR*            AND   O.COMPANY_NO           = D.COMPANY_NO                  
MFA-TR*            AND   O.SO_PRINT_FORM_CD BETWEEN '1' AND '5'                 
MFA-TR*            ORDER BY D.WORK_AREA_ID, D.ORDER_PRIORITY_CD                 
MFA-TR*    END-EXEC.                                                    02017603
                                                                        
                                                                        
       01  WS-END                           PIC X(40) VALUE             
          'WORKING STORAGE FOR PCSSO102 ENDS HERE  '.                   
                                                                        
                                                                        
      ******************************************************************02630000
      *   0000-MAINLINE.                                               *02650000
      *        CONTROLS MAIN PATH OF PROGRAM                           *02660000
      ******************************************************************02630000
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION     THRU 1000-EXIT.              
                                                                        
           PERFORM 2000-MAIN-PROCESS       THRU 2000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    1000-INITIALIZATION.                                        *03000000
      *         GETS JOB PARM DATE AND OPENS FSCSO102-FILE             *03010000
      ******************************************************************02630000
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: ' PROGRAM-NAME.                    
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN OUTPUT  FCSSO102-FILE.                                  
                                                                        
           IF WS-FSO102-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSSO102 PROCESSING ERROR         **'   
              DISPLAY '     OPEN ERROR OF FCSSO102 OUTPUT FILE '        
              DISPLAY '     FILE STATUS = ' WS-FSO102-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           INITIALIZE WS-MISC2.                                         
                                                                        
           PERFORM 7500-GET-TIMESTAMP      THRU 7500-EXIT.              
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
           IF COMMON-DATE-NEEDED                                        
              MOVE WS-COMMON               TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE 'PCSSO102'              TO WS-PGRMNAME               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE              TO WS-DATE-TODAY             
                                              WS-PROCESS-DATE.          
                                                                        
           PERFORM 7650-GET-COMMIT-CTR     THRU 7650-EXIT.              
           MOVE WS-COMMIT-PARM             TO WS-COMMIT-CTR.            
                                                                        
           MOVE WS-N                       TO WS-WEEKEND-IND            
                                              WS-HOLIDAY-IND.           
           PERFORM 7550-CHECK-WEEKEND      THRU 7550-EXIT.              
           PERFORM 7575-CHECK-HOLIDAY      THRU 7575-EXIT.              
           PERFORM 8000-WRITE-HEADER       THRU 8000-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2000-MAIN-PROCESS                                           *03963003
      *         DETERMINES WEEKEND/HOLIDAY OR BUSINESS DAY PROCESSING  *03964003
      ******************************************************************02630000
       2000-MAIN-PROCESS.                                               
                                                                        
           IF WS-WEEKEND-IND = WS-Y OR WS-HOLIDAY-IND = WS-Y            
              PERFORM 2100-WKNDHLDY-SODATA-SELECT     THRU 2100-EXIT    
           ELSE                                                         
              PERFORM 2200-SODATA-SELECT              THRU 2200-EXIT    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2100-WKNDHLDY-SODATA-SELECT                                 *03975505
      *    THIS RETRIEVES SO_DATA INFO AND POPULATES OTHER TABLES ON   *        
      *    WEEKEND AND HOLIDAY BATCH PRINT RUNS.                       *        
      ******************************************************************02630000
       2100-WKNDHLDY-SODATA-SELECT.                                     
                                                                        
           PERFORM 7700-OPEN-WKNDHLDY-CURSOR         THRU 7700-EXIT.    
                                                                        
           PERFORM 7725-FETCH-WKNDHLDY-CURSOR        THRU 7725-EXIT.    
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              INITIALIZE    WS-SO-ROWS                                  
                            WS-WK-AREA-ROWS                             
                            WS-PRINT-ROWS                               
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                  IF WS-WANTED-BY-DT-NULL = -1                          
                     MOVE VO-ASSIGNED-DATETIME  TO VO-WANTED-BY-DATETIME
A01360               MOVE ZERO                  TO WS-WANTED-BY-DT-NULL 
                  END-IF                                                
                  MOVE VO-SERV-ORDER-NO         TO E-SERV-ORDER-NO      
                  MOVE VO-COMPANY-NO            TO E-COMPANY-NO         
                  MOVE VO-LOCAL-OFFICE          TO E-LOCAL-OFFICE       
                  MOVE VO-ORDER-TYPE-CD         TO E-ORDER-TYPE         
                  MOVE VO-WORK-AREA-ID          TO E-WORK-AREA          
                                                                        
                  WRITE FSO102                  FROM WS-BLANK-LINE      
                  WRITE FSO102                  FROM WS-DETAIL-LINE1    
                                                                        
                  MOVE WS-N                     TO WS-RLSE-INFO-REQ     
                  PERFORM 7900-VALIDATE-RLSE-INFO    THRU 7900-EXIT     
                  IF WS-RLSE-INFO-REQ = WS-Y                            
                     MOVE WS-RLSE-INFO-REQ      TO E-RLSE-INFO-REQ      
                     WRITE FSO102               FROM WS-DETAIL-LINE9    
                  END-IF                                                
                  IF WS-RLSE-INFO-REQ = WS-N                            
                     PERFORM 2110-WKNDHLDY-PROCESS   THRU 2110-EXIT     
                  END-IF                                                
                  PERFORM 7725-FETCH-WKNDHLDY-CURSOR THRU 7725-EXIT     
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           PERFORM 7750-CLOSE-WKNDHLDY-CURSOR      THRU 7750-EXIT.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2110-WKNDHLDY-PROCESS.                                      *03975505
      *    WEEKEND/HOLIDAY PROCESS                                     *03975605
      ******************************************************************02630000
       2110-WKNDHLDY-PROCESS.                                           
                                                                        
           ADD 1                              TO   WS-SO-ROWS.          
           MOVE WS-N                          TO   WS-PRINT-ID-5-UP     
                                                   WS-PRINT-LOC-SUCCESS.
                                                                        
           PERFORM 2310-FETCH-PRINTER-ID         THRU 2310-EXIT.        
P00718     IF WS-CAD-WORKAREA-FL = WS-Y                                 
P00718        PERFORM 2330-GET-WORK-DISTRICT     THRU 2330-EXIT         
P00718     ELSE                                                         
P00718        MOVE 'N'                           TO WS-CLICK-PREM       
P00718     END-IF.                                                      
                                                                        
           IF WS-CAD-LOCKOUT-IND = WS-N AND WS-CAD-WORKAREA-FL = WS-Y   
P00718        IF WS-CLICK-PREM = 'Y'                                    
P00718           MOVE WS-CLICK                   TO WS-USE-PRINT-ID     
P00718                                               E-USE-PRINT-ID     
P00718        ELSE                                                      
                 MOVE WS-CAD                     TO WS-USE-PRINT-ID     
                                                     E-USE-PRINT-ID     
                                                    VP-PRINT-ID         
P00718        END-IF                                                    
              PERFORM 2320-PRINT-ORDER           THRU 2320-EXIT         
           ELSE                                                         
              EVALUATE WS-WKNDHLDY-PRT-DEST                             
                  WHEN WS-A                                             
                      MOVE C4-PRINTER-AFTER-HRS  TO WS-USE-PRINT-ID     
                  WHEN WS-B                                             
                      MOVE C4-BATCH-PRINTER-ID   TO WS-USE-PRINT-ID     
                  WHEN WS-C                                             
                      MOVE C4-PRINTER-AFTER-HRS  TO WS-USE-PRINT-ID     
                      PERFORM 2320-PRINT-ORDER   THRU 2320-EXIT         
                      MOVE C4-BATCH-PRINTER-ID   TO WS-USE-PRINT-ID     
                  WHEN WS-D                                             
                      MOVE C4-PRINTER-NRML-HRS   TO WS-USE-PRINT-ID     
                      PERFORM 2320-PRINT-ORDER   THRU 2320-EXIT         
                      MOVE C4-BATCH-PRINTER-ID   TO WS-USE-PRINT-ID     
                  WHEN WS-E                                             
                      MOVE C4-PRINTER-NRML-HRS   TO WS-USE-PRINT-ID     
                      PERFORM 2320-PRINT-ORDER   THRU 2320-EXIT         
                      MOVE C4-PRINTER-AFTER-HRS  TO WS-USE-PRINT-ID     
                  WHEN WS-F                                             
                      MOVE C4-PRINTER-NRML-HRS   TO WS-USE-PRINT-ID     
                      PERFORM 2320-PRINT-ORDER   THRU 2320-EXIT         
                      MOVE C4-PRINTER-AFTER-HRS  TO WS-USE-PRINT-ID     
                      PERFORM 2320-PRINT-ORDER   THRU 2320-EXIT         
                      MOVE C4-BATCH-PRINTER-ID   TO WS-USE-PRINT-ID     
                  WHEN WS-N                                             
                      MOVE C4-PRINTER-NRML-HRS   TO WS-USE-PRINT-ID     
                  WHEN OTHER                                            
                      MOVE C4-PRINTER-AFTER-HRS  TO WS-USE-PRINT-ID     
                                                     E-USE-PRINT-ID     
                      WRITE FSO102               FROM WS-DETAIL-LINE8   
              END-EVALUATE                                              
              MOVE WS-USE-PRINT-ID               TO E-USE-PRINT-ID      
                                                    VP-PRINT-ID         
              PERFORM 2320-PRINT-ORDER           THRU 2320-EXIT         
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2200-SODATA-SELECT                                          *03975505
      *    THIS RETRIEVES SO_DATA INFO AND POPULATES OTHER TABLES      *        
      *    FOR NORMAL (WEEKDAY) BATCH PRINT RUNS.                      *        
      ******************************************************************02630000
       2200-SODATA-SELECT.                                              
                                                                        
           PERFORM 7800-OPEN-BIZDAY-CURSOR       THRU 7800-EXIT.        
                                                                        
           PERFORM 7825-FETCH-BIZDAY-CURSOR      THRU 7825-EXIT.        
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              INITIALIZE    WS-SO-ROWS                                  
                            WS-WK-AREA-ROWS                             
                            WS-PRINT-ROWS                               
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                  IF WS-WANTED-BY-DT-NULL = -1                          
                     MOVE VO-ASSIGNED-DATETIME  TO VO-WANTED-BY-DATETIME
A01360               MOVE ZERO                  TO WS-WANTED-BY-DT-NULL 
                  END-IF                                                
                  MOVE VO-SERV-ORDER-NO         TO E-SERV-ORDER-NO      
                  MOVE VO-COMPANY-NO            TO E-COMPANY-NO         
                  MOVE VO-LOCAL-OFFICE          TO E-LOCAL-OFFICE       
                  MOVE VO-ORDER-TYPE-CD         TO E-ORDER-TYPE         
                  MOVE VO-WORK-AREA-ID          TO E-WORK-AREA          
                                                                        
                  WRITE FSO102                  FROM WS-BLANK-LINE      
                  WRITE FSO102                  FROM WS-DETAIL-LINE1    
                                                                        
                  MOVE WS-N                     TO WS-RLSE-INFO-REQ     
                  PERFORM 7900-VALIDATE-RLSE-INFO  THRU 7900-EXIT       
                  IF WS-RLSE-INFO-REQ = WS-Y                            
                     MOVE WS-RLSE-INFO-REQ      TO E-RLSE-INFO-REQ      
                     WRITE FSO102               FROM WS-DETAIL-LINE9    
                  END-IF                                                
                  IF WS-RLSE-INFO-REQ = WS-N                            
                     ADD 1                      TO WS-SO-ROWS           
                     MOVE WS-N                  TO WS-PRINT-ID-5-UP     
                                                   WS-PRINT-LOC-SUCCESS 
                     PERFORM 2310-FETCH-PRINTER-ID THRU 2310-EXIT       
P00718               IF WS-CAD-WORKAREA-FL = WS-Y                       
P00718                  PERFORM 2330-GET-WORK-DISTRICT  THRU 2330-EXIT  
P00718               ELSE                                               
P00718                  MOVE 'N'                    TO WS-CLICK-PREM    
P00718               END-IF                                             
P00718               IF C6-CAD-LOCKOUT-IND = WS-N AND                   
P00718                  WS-CAD-WORKAREA-FL = WS-Y                       
P00718                  IF WS-CLICK-PREM = 'Y'                          
P00718                     MOVE WS-CLICK            TO WS-USE-PRINT-ID  
P00718                                                 E-USE-PRINT-ID   
P00718                  ELSE                                            
P00718                     MOVE WS-CAD              TO WS-USE-PRINT-ID  
P00718                                                 E-USE-PRINT-ID   
P00718                                                 VP-PRINT-ID      
P00718                  END-IF                                          
                     END-IF                                             
                     PERFORM 2320-PRINT-ORDER      THRU 2320-EXIT       
                  END-IF                                                
                  PERFORM 7825-FETCH-BIZDAY-CURSOR THRU 7825-EXIT       
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           PERFORM 7850-CLOSE-BIZDAY-CURSOR        THRU 7850-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2310-FETCH-PRINTER-ID                                       *03975505
      *    THIS RETRIEVES THE CORRECT PRINTER ID FOR THE DATE          *03975605
      ******************************************************************02630000
       2310-FETCH-PRINTER-ID.                                           
                                                                        
           PERFORM 7910-CAD-LOCKOUT-IND   THRU 7910-EXIT.               
           PERFORM 7920-PRINT-DTLS        THRU 7920-EXIT.               
                                                                        
           MOVE C6-CAD-LOCKOUT-IND        TO WS-CAD-LOCKOUT-IND         
                                             E-CAD-IND.                 
           MOVE C4-PRINTER-NRML-HRS       TO E-NORMAL-HRS.              
           MOVE C4-PRINTER-AFTER-HRS      TO E-AFTER-HRS.               
           MOVE C4-BATCH-PRINTER-ID       TO E-BATCH.                   
           MOVE C4-CAD-WORKAREA-FL        TO WS-CAD-WORKAREA-FL         
                                             E-CAD-WORKAREA.            
           MOVE C4-PRINT-5-UP             TO WS-PRINT-ID-5-UP           
                                             E-PRINT-5-UP.              
           MOVE C4-WKND-HLDY-PRT-DEST     TO WS-WKNDHLDY-PRT-DEST       
                                             E-PRINT-DEST.              
           WRITE FSO102                   FROM WS-DETAIL-LINE2.         
           WRITE FSO102                   FROM WS-DETAIL-LINE3.         
                                                                        
           MOVE WS-Y                      TO WS-PRINT-LOC-SUCCESS.      
           MOVE C4-BATCH-PRINTER-ID       TO WS-HOLD-BATCH-PRINTER-ID.  
           MOVE C4-PRINTER-AFTER-HRS      TO WS-HOLD-AFTER-HRS.         
      *    COMMENTED THIS                                                       
      *    IF (WS-SO-ROWS NOT EQUAL WS-PRINT-ROWS) OR                           
           IF (WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL)     AND    
              ((WS-HOLD-BATCH-PRINTER-ID  = SPACES OR LOW-VALUES) OR    
              (WS-HOLD-AFTER-HRS          = SPACES OR LOW-VALUES))      
              WRITE FSO102                FROM WS-DETAIL-LINE7          
              MOVE WS-N                   TO WS-PRINT-LOC-SUCCESS       
           END-IF.                                                      
                                                                        
           IF WS-WEEKEND-IND = WS-N AND WS-HOLIDAY-IND = WS-N           
              MOVE C4-BATCH-PRINTER-ID    TO WS-USE-PRINT-ID            
                                              E-USE-PRINT-ID            
                                             VP-PRINT-ID                
           END-IF.                                                      
                                                                        
           IF (VO-COMPANY-NO = WS-26 AND (VO-ORDER-TYPE-CD = 'FW022'    
              OR VO-ORDER-TYPE-CD = 'FM007')) OR                        
A05020        (VO-ORDER-TYPE-CD = 'FW024')                              
              MOVE WS-N                   TO WS-CAD-WORKAREA-FL         
           END-IF.                                                      
                                                                        
           IF C6-CAD-LOCKOUT-IND = WS-N AND WS-CAD-WORKAREA-FL = WS-Y   
P00718*       IF WS-CLICK-PREM = 'Y'                                            
P00718*          MOVE WS-CLICK            TO WS-USE-PRINT-ID                    
P00718*                                       E-USE-PRINT-ID                    
P00718*       ELSE                                                              
                 MOVE WS-CAD              TO WS-USE-PRINT-ID            
                                              E-USE-PRINT-ID            
                                             VP-PRINT-ID                
P00718*       END-IF                                                            
           END-IF.                                                      
                                                                        
      *    COMMENTED CODE IN SQR JOB TO IDENTIFY IF THIS WAS A                  
      *    4.00 PM PRINT TO NOT ALLOW CAD ORDERS TO BE PRINTED                  
      *    IF UPPER(RUNVER) = 'SO102E' AND                                      
      *       RTRIM(USE-PRINT-ID,' ') ='CAD'                                    
      *       MOVE WS-N                   TO WS-PRINT-LOC-SUCCESS               
      *    END-IF.                                                              
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2320-PRINT-ORDER                                            *03975505
      *    PRINTS THE ORDER                                            *03975605
      ******************************************************************02630000
       2320-PRINT-ORDER.                                                
                                                                        
           MOVE VO-ORDER-TYPE-CD (1:3)          TO WS-ORDER-TYPE.       
                                                                        
           IF VO-COMPANY-NO = WS-26 AND (WS-ORDER-TYPE = 'NOT' OR       
              WS-ORDER-TYPE = 'DNP') AND WS-CAD-WORKAREA-FL = WS-N      
              MOVE WS-5                         TO WS-PRINT-PRIORITY    
           ELSE                                                         
              MOVE WS-2                         TO WS-PRINT-PRIORITY    
           END-IF.                                                      
           MOVE WS-PRINT-PRIORITY               TO E-CAD-PRIORITY       
                                                   E-PRINT-PRIORITY.    
P00718     MOVE '1'                             TO E-CLICK-PRIORITY     
           MOVE WS-PRINT-LOC-SUCCESS            TO E-PRINT-LOC-SUCCESS. 
           WRITE FSO102                         FROM WS-DETAIL-LINE4.   
                                                                        
           IF (WS-PRINT-LOC-SUCCESS = WS-Y AND NOT                      
              (WS-PRINT-ID-5-UP     = WS-Y))                            
              IF (WS-USE-PRINT-ID   = WS-CAD OR                         
                  WS-USE-PRINT-ID   = WS-CLICK)                         
                 IF (WS-USE-PRINT-ID = WS-CLICK  AND                    
                     WS-CLICK-PREM = 'Y')                               
                    MOVE WS-N                      TO WS-CLICK-INSERTED 
                    PERFORM 7935-CHECK-CLICK-INSERTED  THRU 7935-EXIT   
                    IF (WS-CLICK-INSERTED = WS-N  AND                   
                      (WS-RATE-EXIST     = WS-Y   OR                    
                      C2-ORDER-GROUP-CD  = 'A')  AND                    
                      WS-RLSE-REQD NOT EQUAL WS-Y )                     
A05020                MOVE 'N'                     TO WS-HOLD-TASK      
A05020                PERFORM 7990-CHECK-HOLD-TASK THRU 7990-EXIT       
A05020                IF WS-HOLD-TASK = 'Y'                             
A05020                   PERFORM 8500-UPD-SEQ-NO   THRU 8500-EXIT       
A05020                END-IF                                            
                      PERFORM 8300-TASK-Q-INS      THRU 8300-EXIT       
                      IF WS-ACTIVE-RETURN-CODE     EQUAL SUCCESSFUL-CALL
                         PERFORM 8400-UPD-PRINTED-IND  THRU 8400-EXIT   
                         ADD 1                     TO WS-RECORD-COUNT   
                                                      WS-COMMIT-COUNT   
                         WRITE FSO102              FROM WS-DETAIL-LINE10
                      END-IF                                            
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 7500-GET-TIMESTAMP     THRU 7500-EXIT       
                    MOVE WS-N                      TO WS-CAD-INSERTED   
                    PERFORM 7930-CHECK-CAD-INSERTED  THRU 7930-EXIT     
                    IF WS-CAD-INSERTED = WS-N                           
                       PERFORM 8100-CAD-Q-INS      THRU 8100-EXIT       
                       IF WS-ACTIVE-RETURN-CODE    EQUAL SUCCESSFUL-CALL
                          ADD 1                    TO WS-RECORD-COUNT   
                                                      WS-COMMIT-COUNT   
                          WRITE FSO102             FROM WS-DETAIL-LINE5 
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-N                         TO WS-PRINT-INSERTED 
                 PERFORM 7940-CHECK-PRINT-INSERTED THRU 7940-EXIT       
                 IF WS-PRINT-INSERTED = WS-N                            
                    PERFORM 8200-PRINT-Q-INS       THRU 8200-EXIT       
                    IF WS-ACTIVE-RETURN-CODE       EQUAL SUCCESSFUL-CALL
                       ADD 1                       TO WS-RECORD-COUNT   
                                                      WS-COMMIT-COUNT   
                       WRITE FSO102                FROM WS-DETAIL-LINE6 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              IF WS-COMMIT-COUNT > WS-COMMIT-CTR                        
                 EXEC SQL                                               
                    COMMIT                                              
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE ZERO                      TO WS-COMMIT-COUNT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
P00718                                                                  
P00718 2330-GET-WORK-DISTRICT.                                          
P00718                                                                  
P00718     MOVE SPACES                       TO WS-WORK-DISTRICT.       
P00718     MOVE WS-N                         TO WS-RATE-EXIST.          
P00718     MOVE WS-N                         TO WS-RLSE-REQD.           
P00718     MOVE WS-N                         TO WS-CLICK-PREM.          
 00718     IF C2-ORDER-GROUP-CD NOT EQUAL 'A'                           
P00718        PERFORM 7970-GET-RATE          THRU 7970-EXIT             
P00718     END-IF.                                                      
P00718     PERFORM 7980-GET-RLSE-REQMNT      THRU 7980-EXIT.            
P00718     PERFORM 7950-GET-BUSINESS-UNIT    THRU 7950-EXIT.            
P00718     PERFORM 7960-GET-PREMISE-DTLS     THRU 7960-EXIT.            
P00718                                                                  
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN VO-SO-BUSINESS-UNIT = 'EOP'                          
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > SPACES                  
P00718         AND PR-FM-ELEC-SVC-WKDIST-LEN  > 0                       
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT  TO WS-WORK-DISTRICT 
P00718        WHEN VO-SO-BUSINESS-UNIT = 'GOP'                          
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > SPACES                  
P00718         AND PR-FM-GAS-OPS-WKDIST-LEN   > 0                       
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT   TO WS-WORK-DISTRICT 
P00718        WHEN VO-SO-BUSINESS-UNIT = 'FSV'                          
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > SPACES                  
P00718         AND PR-FM-FLD-SVCS-WKDIST-LEN  > 0                       
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT  TO WS-WORK-DISTRICT 
P00718        WHEN VO-SO-BUSINESS-UNIT = 'RVP'                          
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > SPACES                  
P00718         AND PR-FM-REV-PRT-WKDIST-LEN   > 0                       
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT   TO WS-WORK-DISTRICT 
P00718        WHEN VO-SO-BUSINESS-UNIT = 'DSM'                          
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > SPACES                  
P00718         AND PR-FM-DSM-ESVC-WKDIST-LEN  > 0                       
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT  TO WS-WORK-DISTRICT 
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718*    IF WS-RATE-EXIST = WS-Y AND WS-RLSE-REQD NOT EQUAL WS-Y              
P00718*       MOVE WS-WORK-DISTRICT         TO  WS-WORK-DISTRICT                
P00718*    ELSE                                                                 
P00718*       MOVE SPACES                   TO  WS-WORK-DISTRICT                
P00718*    END-IF.                                                              
P00718                                                                  
P00718     IF WS-WORK-DISTRICT > SPACES                                 
P00718        MOVE 'Y'                      TO WS-CLICK-PREM            
P00718     ELSE                                                         
P00718        MOVE 'N'                      TO WS-CLICK-PREM            
P00718     END-IF.                                                      
P00718                                                                  
P00718 2330-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
      ******************************************************************02630000
      *   7500-GET-TIMESTAMP.                                          *08063003
      *        GETS THE START AND END TIME.                            *08064003
      ******************************************************************08061003
                                                                        
       7500-GET-TIMESTAMP.                                              
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*         SET :WS-TIME = CURRENT TIMESTAMP                        08069403
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7500-GET-TIMESTAMP'          
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7525-GET-DAY-PARM                                            *08063003
      *        GETS THE NUMBER OF DAYS                                 *08064003
      ******************************************************************08061003
                                                                        
       7525-GET-DAY-PARM.                                               
                                                                        
           MOVE '7525'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT C8.DELINQ_VALUE                                  
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY C8                               
                 WHERE C8.DELINQ_CD  = 'NBR-BIZ-DAYS'                   
                   AND C8.COMPANY_NO = '01'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH       =  7525-GET-DAY-PARM'        
              DISPLAY '**  RETURN CODE     = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**  C8-DELINQ-VALUE = ' C8-DELINQ-VALUE          
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7550-CHECK-WEEKEND                                           *08076303
      *        THIS CHECKS TO SEE IF THE RUN DAY IS ON A WEEKEND       *08076403
      ******************************************************************08061003
                                                                        
       7550-CHECK-WEEKEND.                                              
                                                                        
           MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-WEEKEND-IND                                  
                  FROM CSS_MODEL_SQL                                    
                 WHERE CIS.DAYOFWEEK(IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) )) IN (1,7)       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     08077203
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-WEEKEND-IND                                          
MFA-TR*           FROM CSS_MODEL_SQL                                            
MFA-TR*          WHERE DAYOFWEEK(DATE(:WS-PROCESS-DATE)) IN (1,7)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7550-CHECK-WEEKEND'           
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESS DATE = ' WS-PROCESS-DATE             
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7575-CHECK-HOLIDAY.                                          *08090000
      *        CHECKS IF IT IS A HOLIDAY                               *08100000
      ******************************************************************08061003
                                                                        
       7575-CHECK-HOLIDAY.                                              
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-HOLIDAY-IND                                   
                 FROM CSS_HOLIDAY                                       
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) )               
                  AND COMPANY_NO = '01'                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-HOLIDAY-IND                                           
MFA-TR*          FROM CSS_HOLIDAY                                               
MFA-TR*         WHERE HOLIDAY_DT = DATE(:WS-PROCESS-DATE)                       
MFA-TR*           AND COMPANY_NO = '01'                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7575-CHECK-HOLIDAY'         
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESS DATE   = ' WS-PROCESS-DATE           
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7575-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7650-GET-COMMIT-CTR                                          *08090000
      *        GETS THE COMMIT COUNTER VALUE FROM JOB PARM.            *08100000
      ******************************************************************08061003
                                                                        
       7650-GET-COMMIT-CTR.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CIS.SUBSTR3(PARM_DATA,10,4)                            
                 INTO :WS-COMMIT-PARM                                   
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = 'PCSSO102'                         
                  AND COMPANY_NO   = '01'                               
                  AND CMND_CODE    = 'PARM'                             
                  AND SEQ_NO       = 1                                  
                  AND STATUS       = 'A'                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(PARM_DATA,10,4)                                    
MFA-TR*          INTO :WS-COMMIT-PARM                                           
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'PCSSO102'                                 
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND CMND_CODE    = 'PARM'                                     
MFA-TR*           AND SEQ_NO       = 1                                          
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7650-GET-COMMIT-CTR'        
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PARM DATA      = ' G6-PARM-DATA              
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7700-OPEN-WKNDHLDY-CURSOR                                    *08063003
      *        OPENS THE WKNDHLDY CURSOR TO FETCH ROWS                 *08064003
      ******************************************************************08061003
       7700-OPEN-WKNDHLDY-CURSOR.                                       
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN WKND-HLDY                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7700-OPEN-WKNDHLDY-CURSOR'   
              DISPLAY '**  OPEN WKNDHLDY CURSOR'                        
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7725-FETCH-WKNDHLDY-CURSOR                                   *08071703
      *        GETS THE ORDER INFO                                     *08071803
      ******************************************************************08061003
                                                                        
       7725-FETCH-WKNDHLDY-CURSOR.                                      
                                                                        
           MOVE '7725'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH WKND-HLDY                                           
               INTO :VO-ASSIGNED-DATETIME   ,                           
                    :VO-SERV-ORDER-NO       ,                           
                    :VO-COMPANY-NO          ,                           
                    :VO-LOCAL-OFFICE        ,                           
                    :VO-ORDER-TYPE-CD       ,                           
                    :VO-ORDER-RECVED-BY     ,                           
                    :VO-ORDER-PRIORITY-CD   ,                           
                    :VO-WORK-AREA-ID        ,                           
                    :VO-WANTED-BY-DATETIME :WS-WANTED-BY-DT-NULL,       
                    :C2-SO-PRINT-FORM-CD,                               
P00718              :C2-ORDER-GROUP-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7725-FETCH-WKNDHLDY-CURSOR'   
              DISPLAY '**  FETCH WKNDHLDY CURSOR'                       
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7750-CLOSE-WKNDHLDY-CURSOR                                   *08076303
      *        CLOSING WKNDHLDY CURSOR                                 *08076403
      ******************************************************************08061003
                                                                        
       7750-CLOSE-WKNDHLDY-CURSOR.                                      
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE WKND-HLDY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7750-CLOSE-WKNDHLDY-CURSOR'   
              DISPLAY '**  CLOSE WKNDHLDY CURSOR '                      
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7800-OPEN-BIZDAY CURSOR                                      *08063003
      *        OPENS THE BIZDAY CURSOR TO FETCH ROWS                   *08064003
      ******************************************************************08061003
       7800-OPEN-BIZDAY-CURSOR.                                         
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN BIZ-DAY                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7800-OPEN-BIZDAY-CURSOR'     
              DISPLAY '**  OPEN BIZDAY CURSOR'                          
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7825-FETCH-BIZDAY-CURSOR                                     *08071703
      *        GETS THE ORDER INFO                                     *08071803
      ******************************************************************08061003
                                                                        
       7825-FETCH-BIZDAY-CURSOR.                                        
                                                                        
           MOVE '7825'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH BIZ-DAY                                             
               INTO :VO-ASSIGNED-DATETIME   ,                           
                    :VO-SERV-ORDER-NO       ,                           
                    :VO-COMPANY-NO          ,                           
                    :VO-LOCAL-OFFICE        ,                           
                    :VO-ORDER-TYPE-CD       ,                           
                    :VO-ORDER-RECVED-BY     ,                           
                    :VO-ORDER-PRIORITY-CD   ,                           
                    :VO-WORK-AREA-ID        ,                           
                    :VO-WANTED-BY-DATETIME :WS-WANTED-BY-DT-NULL,       
                    :C2-SO-PRINT-FORM-CD,                               
P00718              :C2-ORDER-GROUP-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7825-FETCH-BIZDAY-CURSOR'     
              DISPLAY '**  FETCH BIZDAY CURSOR'                         
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7850-CLOSE-BIZDAY-CURSOR                                     *08076303
      *        CLOSING BIZDAY CURSOR                                   *08076403
      ******************************************************************08061003
                                                                        
       7850-CLOSE-BIZDAY-CURSOR.                                        
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE BIZ-DAY                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7850-CLOSE-BIZDAY-CURSOR'     
              DISPLAY '**  CLOSE BIZDAY CURSOR '                        
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7900-VALIDATE-RLSE-INFO.                                     *08090000
      *   DETERMINES IF RELEASE IS REQUIRED OR NOT THIS CHECKS IF THE  *08100000
      *   ORDER REQUIRES A RELEASE AND IF IT DOES MAKE SURE THE RELEASE*        
      *   NUMBER IS PRESENT -- THIS MEANS THAT THE RELEASE REQUIREMENT *        
      *   HAS BEEN COMPLETED.                                          *        
      ******************************************************************08061003
                                                                        
       7900-VALIDATE-RLSE-INFO.                                         
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'              ,                                
                      HOLD_RELEASE     ,                                
                      RLSE_NO                                           
                 INTO :WS-RLSE-INFO-REQ,                                
                      :VI-HOLD-RELEASE ,                                
                      :VI-RLSE-NO                                       
                 FROM CSS_SO_ORDER_INST                                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD  > ' '                               
                  AND HOLD_RELEASE  = :WS-Y                             
                  AND RLSE_NO       = ' '                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR WS-811                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7900-VALIDATE-RLSE-INFO'  
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7910-CAD-LOCKOUT-IND.                                        *08090000
      *        RETRIEVE_CAD_LOCKOUT_IND                                *08100000
      ******************************************************************08061003
                                                                        
       7910-CAD-LOCKOUT-IND.                                            
                                                                        
           EXEC SQL                                                     
               SELECT CAD_LOCKOUT_IND                                   
                 INTO :C6-CAD-LOCKOUT-IND                               
                 FROM CSS_SO_CAD_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH       = 7910-CAD-LOCKOUT-IND'      
              DISPLAY '**  RETURN CODE     = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**  CAD LOCKOUT IND = ' C6-CAD-LOCKOUT-IND       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7920-PRINT-DTLS                                              *08090000
      *        RETRIEVES PRINT DETAILS                                 *08100000
      ******************************************************************08061003
                                                                        
       7920-PRINT-DTLS.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT PRINTER_NRML_HRS       ,                          
                      PRINTER_AFTER_HRS      ,                          
                      BATCH_PRINTER_ID       ,                          
                      CAD_WORKAREA_FL        ,                          
                      WKND_HLDY_PRT_DEST     ,                          
                      PRINT_5_UP                                        
                 INTO :C4-PRINTER-NRML-HRS   ,                          
                      :C4-PRINTER-AFTER-HRS  ,                          
                      :C4-BATCH-PRINTER-ID   ,                          
                      :C4-CAD-WORKAREA-FL    ,                          
                      :C4-WKND-HLDY-PRT-DEST ,                          
                      :C4-PRINT-5-UP                                    
                 FROM CSS_SO_PRINT_LOC                                  
                 WHERE WORK_AREA_ID  = :VO-WORK-AREA-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 ADD 1                     TO WS-PRINT-ROWS             
              ELSE                                                      
                 WRITE FSO102              FROM WS-DETAIL-LINE7         
                 MOVE WS-N                 TO WS-PRINT-LOC-SUCCESS      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7920-PRINT-DTLS'          
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  WORK AREA ID=    = ' VO-WORK-AREA-ID         
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7930-CHECK-CAD-INSERTED                                      *08090000
      *        VERIFIES IF A ROW IS INSERTED FOR THIS SO# FOR WHICH THE*08100000
      *        THE PRINT IS PENDING. IF SO PREVENTS RE-INSERTING TO    *        
      *        AVOID DUPLICATE ORDERS BEING PRINTED.                            
      ******************************************************************08061003
                                                                        
       7930-CHECK-CAD-INSERTED.                                         
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-CAD-INSERTED                                  
                 FROM CSS_SO_CAD_QUEUE                                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND CAD_TS        IS NULL                             
                  AND CAD_PRIORITY  = :WS-PRINT-PRIORITY                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR WS-811                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7930-CHECK-CAD-INSERTED'  
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00718******************************************************************08061003
P00718*   7935-CHECK-CLICK-INSERTED                                    *08090000
P00718*        VERIFIES IF A ROW IS INSERTED FOR THIS SO# FOR WHICH THE*08100000
P00718*        THE PRINT IS PENDING. IF SO PREVENTS RE-INSERTING TO    *        
P00718*        AVOID DUPLICATE ORDERS BEING PRINTED.                            
P00718******************************************************************08061003
P00718                                                                  
P00718 7935-CHECK-CLICK-INSERTED.                                       
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT TOP(1) 'Y'                                               
P00718           INTO :WS-CLICK-INSERTED                                
P00718           FROM CSS_SO_TASK_QUEUE                                 
P00718          WHERE SERV_ORDER_NO     = :VO-SERV-ORDER-NO             
A05020            AND TASK_QUEUED_TS IS NULL                            
P00718                                            
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CLICK-INSERTED                                        
MFA-TR*          FROM CSS_SO_TASK_QUEUE                                         
MFA-TR*         WHERE SERV_ORDER_NO     = :VO-SERV-ORDER-NO                     
MFA-TR*           AND TASK_QUEUED_TS IS NULL                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00718                                    OR WS-811                     
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        DISPLAY '***********************************'             
P00718        DISPLAY '**  PROCESSING ERROR             **'             
P00718        DISPLAY '**  PARAGRAPH        = 7935-CHECK-CLICK-INSERTED'
P00718        DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
P00718        DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
P00718        DISPLAY '**  PROCESSING TERMINATED        **'             
P00718        DISPLAY '***********************************'             
P00718        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00718     END-IF.                                                      
P00718                                                                  
P00718 7935-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
      ******************************************************************08061003
      *   7940-CHECK-PRINT-INSERTED                                    *08090000
      *        VERIFIES IF A ROW IS INSERTED FOR THIS SO# FOR WHICH THE*08100000
      *        THE PRINT IS PENDING. IF SO PREVENTS RE-INSERTING TO    *        
      *        AVOID DUPLICATE ORDERS BEING PRINTED.                            
      ******************************************************************08061003
                                                                        
       7940-CHECK-PRINT-INSERTED.                                       
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-PRINT-INSERTED                                
                 FROM CSS_SO_PRINT_QUEUE                                
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND PRINTED_TS     IS NULL                            
                  AND PRINT_PRIORITY = :WS-PRINT-PRIORITY               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR WS-811                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7940-CHECK-PRINT-INSERTED'
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7950-GET-BUSINESS-UNIT                                       *08090000
      *        GETS THE ORDER DETAILS                                  *08100000
      ******************************************************************08061003
                                                                        
       7950-GET-BUSINESS-UNIT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SO_BUSINESS_UNIT                                   
                    ,PREMISE_NO                                         
                    ,WORK_AREA_ID                                       
                    ,COMPANY_NO                                         
                    ,ORDER_TYPE_CD                                      
                INTO :VO-SO-BUSINESS-UNIT                               
                    ,:VO-PREMISE-NO                                     
                    ,:VO-WORK-AREA-ID                                   
                    ,:VO-COMPANY-NO                                     
                    ,:VO-ORDER-TYPE-CD                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SO_BUSINESS_UNIT                                           
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,WORK_AREA_ID                                               
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,ORDER_TYPE_CD                                              
MFA-TR*         INTO :VO-SO-BUSINESS-UNIT                                       
MFA-TR*             ,:VO-PREMISE-NO                                             
MFA-TR*             ,:VO-WORK-AREA-ID                                           
MFA-TR*             ,:VO-COMPANY-NO                                             
MFA-TR*             ,:VO-ORDER-TYPE-CD                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7950                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7950-GET-BUSINESS-UNIT'   
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7960-GET-PREMISE-DTLS                                        *08090000
      *        GETS THE ORDER DETAILS                                  *08100000
      ******************************************************************08061003
                                                                        
       7960-GET-PREMISE-DTLS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT LTRIM(RTRIM(FM_ELEC_SVC_WKDIST))                          
                    ,LTRIM(RTRIM(FM_GAS_OPS_WKDIST))                           
                    ,LTRIM(RTRIM(FM_FLD_SVCS_WKDIST))                          
                    ,LTRIM(RTRIM(FM_REV_PRT_WKDIST))                           
                    ,LTRIM(RTRIM(FM_DSM_ESVC_WKDIST))                          
                INTO :PR-FM-ELEC-SVC-WKDIST                             
                    ,:PR-FM-GAS-OPS-WKDIST                              
                    ,:PR-FM-FLD-SVCS-WKDIST                             
                    ,:PR-FM-REV-PRT-WKDIST                              
                    ,:PR-FM-DSM-ESVC-WKDIST                             
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :VO-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STRIP(FM_ELEC_SVC_WKDIST)                                  
MFA-TR*             ,STRIP(FM_GAS_OPS_WKDIST)                                   
MFA-TR*             ,STRIP(FM_FLD_SVCS_WKDIST)                                  
MFA-TR*             ,STRIP(FM_REV_PRT_WKDIST)                                   
MFA-TR*             ,STRIP(FM_DSM_ESVC_WKDIST)                                  
MFA-TR*         INTO :PR-FM-ELEC-SVC-WKDIST                                     
MFA-TR*             ,:PR-FM-GAS-OPS-WKDIST                                      
MFA-TR*             ,:PR-FM-FLD-SVCS-WKDIST                                     
MFA-TR*             ,:PR-FM-REV-PRT-WKDIST                                      
MFA-TR*             ,:PR-FM-DSM-ESVC-WKDIST                                     
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :VO-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7960-GET-PREMISE-DTLS'    
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PREMISE NO       = ' VO-PREMISE-NO           
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7970-GET-RATE                                                *08090000
      *        GETS THE ORDER DETAILS                                  *08100000
      ******************************************************************08061003
                                                                        
       7970-GET-RATE.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RATE-EXIST                                    
                 FROM CSS_SO_UTL_CHG VE WITH(READUNCOMMITTED)                   
                     ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VE.SERV_ORDER_NO  = :VO-SERV-ORDER-NO             
                  AND VI.SERV_ORDER_NO  = VE.SERV_ORDER_NO              
                  AND VI.WORK_TYPE_CD   > ''                            
                  AND VI.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE             
                  AND VI.IC_NO          = VE.IC_NO                      
                  AND VE.RATE_PLAN_NO   > ''                            
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RATE-EXIST                                            
MFA-TR*          FROM CSS_SO_UTL_CHG VE                                         
MFA-TR*              ,CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VE.SERV_ORDER_NO  = :VO-SERV-ORDER-NO                     
MFA-TR*           AND VI.SERV_ORDER_NO  = VE.SERV_ORDER_NO                      
MFA-TR*           AND VI.WORK_TYPE_CD   > ''                                    
MFA-TR*           AND VI.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE                     
MFA-TR*           AND VI.IC_NO          = VE.IC_NO                              
MFA-TR*           AND VE.RATE_PLAN_NO   > ''                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7970                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 7975-GET-RATE-DTLS  THRU 7975-EXIT             
              ELSE                                                      
                 DISPLAY '***********************************'          
                 DISPLAY '**  PROCESSING ERROR             **'          
                 DISPLAY '**  PARAGRAPH        = 7970-GET-RATE'         
                 DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE
                 DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO     
                 DISPLAY '**  PROCESSING TERMINATED        **'          
                 DISPLAY '***********************************'          
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7975-GET-RATE-DTLS                                           *08090000
      *        GETS THE ORDER DETAILS                                  *08100000
      ******************************************************************08061003
                                                                        
       7975-GET-RATE-DTLS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RATE-EXIST                                    
                 FROM CSS_SO_UTILITY VT WITH(READUNCOMMITTED)                   
                     ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VT.SERV_ORDER_NO    = :VO-SERV-ORDER-NO           
                  AND VI.SERV_ORDER_NO   = VT.SERV_ORDER_NO             
                  AND VI.WORK_TYPE_CD    > ''                           
                  AND VI.CODE_UTIL_TYPE  = VT.CODE_UTIL_TYPE            
                  AND VI.IC_NO           = VT.IC_NO                     
                  AND VT.RATE_PLAN_NO    > ''                           
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RATE-EXIST                                            
MFA-TR*          FROM CSS_SO_UTILITY VT                                         
MFA-TR*              ,CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VT.SERV_ORDER_NO    = :VO-SERV-ORDER-NO                   
MFA-TR*           AND VI.SERV_ORDER_NO   = VT.SERV_ORDER_NO                     
MFA-TR*           AND VI.WORK_TYPE_CD    > ''                                   
MFA-TR*           AND VI.CODE_UTIL_TYPE  = VT.CODE_UTIL_TYPE                    
MFA-TR*           AND VI.IC_NO           = VT.IC_NO                             
MFA-TR*           AND VT.RATE_PLAN_NO    > ''                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7975                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR -811                                                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7975-GET-RATE-DTLS'       
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7975-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7980-GET-RLSE-REQMNT                                         *08090000
      *        GETS THE ORDER DETAILS                                  *08100000
      ******************************************************************08061003
                                                                        
       7980-GET-RLSE-REQMNT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RLSE-REQD                                      
                FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                    
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                 AND WORK_TYPE_CD  <> ''                                
                 AND HOLD_RELEASE  = 'Y'                                
                 AND RLSE_NO       = ''                                 
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RLSE-REQD                                              
MFA-TR*         FROM CSS_SO_ORDER_INST                                          
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*          AND WORK_TYPE_CD  <> ''                                        
MFA-TR*          AND HOLD_RELEASE  = 'Y'                                        
MFA-TR*          AND RLSE_NO       = ''                                         
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7980                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR WS-811                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 7980-GET-RLSE-REQMNT'     
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7990-CHECK-HOLD-TASK                                         *08090000
      *        CHECK HOLD TASK FOR CLICK PREMISES                      *08100000
      ******************************************************************08061003
A05020                                                                  
A05020 7990-CHECK-HOLD-TASK.                                            
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT TOP(1) 'Y'                                                
A05020          INTO :WS-HOLD-TASK                                      
A05020          FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
A05020         WHERE VI.SERV_ORDER_NO    = :VO-SERV-ORDER-NO            
A05020           AND VI.WORK_TYPE_CD    <> ''                           
A05020           AND VI.TASK_STATUS_CD   = 'I'                          
A05020                                            
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-HOLD-TASK                                              
MFA-TR*         FROM CSS_SO_ORDER_INST VI                                       
MFA-TR*        WHERE VI.SERV_ORDER_NO    = :VO-SERV-ORDER-NO                    
MFA-TR*          AND VI.WORK_TYPE_CD    <> ''                                   
MFA-TR*          AND VI.TASK_STATUS_CD   = 'I'                                  
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7990                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05020                                                                  
A05020     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A05020           MOVE 'N'                  TO WS-HOLD-TASK              
A05020        ELSE                                                      
A05020           DISPLAY '***********************************'          
A05020           DISPLAY '**  PROCESSING ERROR             **'          
A05020           DISPLAY '**  PARAGRAPH        = 7990-CHECK-HOLD-TASK'  
A05020           DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE
A05020           DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO     
A05020           DISPLAY '**  PROCESSING TERMINATED        **'          
A05020           DISPLAY '***********************************'          
A05020           PERFORM 9900-ABEND           THRU 9900-EXIT            
A05020        END-IF                                                    
A05020     END-IF.                                                      
A05020                                                                  
A05020 7990-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************08061003
      *   8000-WRITE-HEADER                                            *08090000
      *   WRITES THE RUN DETAILS TO THE FILE                           *08100000
      ******************************************************************08061003
                                                                        
       8000-WRITE-HEADER.                                               
                                                                        
           WRITE FSO102 FROM WS-HEADER-LINE1.                           
           MOVE  WS-TIME                   TO E-RUN-DATE.               
           WRITE FSO102 FROM WS-HEADER-LINE2.                           
           WRITE FSO102 FROM WS-BLANK-LINE.                             
                                                                        
           MOVE WS-DATE-TODAY              TO E-DATE-TODAY.             
           WRITE FSO102 FROM WS-HEADER-LINE3.                           
           WRITE FSO102 FROM WS-BLANK-LINE.                             
                                                                        
           MOVE WS-WEEKEND-IND             TO E-WEEKEND-IND.            
           MOVE WS-HOLIDAY-IND             TO E-HOLIDAY-IND.            
           WRITE FSO102                    FROM WS-HEADER-LINE4.        
           WRITE FSO102                    FROM WS-BLANK-LINE.          
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   8100-CAD-Q-INS.                                              *08090000
      *        THIS INSERTS THE DATA TO SO_CAD_QUEUE                   *08100000
      ******************************************************************08061003
                                                                        
       8100-CAD-Q-INS.                                                  
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_SO_CAD_QUEUE                            
                       (SERV_ORDER_NO      ,                            
                       COMPANY_NO          ,                            
                       LOCAL_OFFICE        ,                            
                       WORK_GROUP_ID       ,                            
                       WORK_AREA_ID        ,                            
                       CREATED_TS          ,                            
                       CAD_TS              ,                            
                       CAD_PRIORITY        ,                            
                       CREATED_BY_USER_ID  ,                            
                       CAD_TRANS_TY_ACTN   )                            
      *                CAD_TRANS_MESSAGE)                                       
                VALUES                                                  
                      (:VO-SERV-ORDER-NO   ,                            
                       :VO-COMPANY-NO      ,                            
                       :VO-LOCAL-OFFICE    ,                            
                       ' '                 ,                            
                       ' '                 ,                            
                       CIS.CHAR2TIMESTAMP(:WS-TIME)            ,                
                       NULL                ,                            
                       :WS-PRINT-PRIORITY  ,                            
                       'SYSTEM'            ,                            
                       'A'                 )                            
      *                ' ')                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SO_CAD_QUEUE                                    
MFA-TR*                (SERV_ORDER_NO      ,                                    
MFA-TR*                COMPANY_NO          ,                                    
MFA-TR*                LOCAL_OFFICE        ,                                    
MFA-TR*                WORK_GROUP_ID       ,                                    
MFA-TR*                WORK_AREA_ID        ,                                    
MFA-TR*                CREATED_TS          ,                                    
MFA-TR*                CAD_TS              ,                                    
MFA-TR*                CAD_PRIORITY        ,                                    
MFA-TR*                CREATED_BY_USER_ID  ,                                    
MFA-TR*                CAD_TRANS_TY_ACTN   )                                    
MFA-TR*                CAD_TRANS_MESSAGE)                                       
MFA-TR*         VALUES                                                          
MFA-TR*               (:VO-SERV-ORDER-NO   ,                                    
MFA-TR*                :VO-COMPANY-NO      ,                                    
MFA-TR*                :VO-LOCAL-OFFICE    ,                                    
MFA-TR*                ' '                 ,                                    
MFA-TR*                ' '                 ,                                    
MFA-TR*                :WS-TIME            ,                                    
MFA-TR*                NULL                ,                                    
MFA-TR*                :WS-PRINT-PRIORITY  ,                                    
MFA-TR*                'SYSTEM'            ,                                    
MFA-TR*                'A'                 )                                    
MFA-TR*                ' ')                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 8100-CAD-Q-INS'           
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   8200-PRINT-Q-INS                                             *08090000
      *        THIS INSERTS THE DATA TO SO_PRINT_QUEUE                 *08100000
      ******************************************************************08061003
                                                                        
       8200-PRINT-Q-INS.                                                
                                                                        
           IF VO-WANTED-BY-DATETIME = SPACES OR LOW-VALUES              
              MOVE -1 TO WS-WANTED-BY-DT-NULL                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_SO_PRINT_QUEUE                          
                       (SERV_ORDER_NO          ,                        
                       LOCAL_OFFICE            ,                        
                       COMPANY_NO              ,                        
                       CREATED_BY_USER_ID      ,                        
                       PRINT_ID                ,                        
                       PRINT_PRIORITY          ,                        
                       WANTED_BY_DATE)                                  
                VALUES                                                  
                      (:VO-SERV-ORDER-NO       ,                        
                       :VO-LOCAL-OFFICE        ,                        
                       :VO-COMPANY-NO          ,                        
                       'SYSTEM'                ,                        
                       :VP-PRINT-ID            ,                        
                       :WS-PRINT-PRIORITY      ,                        
                       CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME 
                                          :WS-WANTED-BY-DT-NULL))    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SO_PRINT_QUEUE                                  
MFA-TR*                (SERV_ORDER_NO          ,                                
MFA-TR*                LOCAL_OFFICE            ,                                
MFA-TR*                COMPANY_NO              ,                                
MFA-TR*                CREATED_BY_USER_ID      ,                                
MFA-TR*                PRINT_ID                ,                                
MFA-TR*                PRINT_PRIORITY          ,                                
MFA-TR*                WANTED_BY_DATE)                                          
MFA-TR*         VALUES                                                          
MFA-TR*               (:VO-SERV-ORDER-NO       ,                                
MFA-TR*                :VO-LOCAL-OFFICE        ,                                
MFA-TR*                :VO-COMPANY-NO          ,                                
MFA-TR*                'SYSTEM'                ,                                
MFA-TR*                :VP-PRINT-ID            ,                                
MFA-TR*                :WS-PRINT-PRIORITY      ,                                
MFA-TR*                :VO-WANTED-BY-DATETIME :WS-WANTED-BY-DT-NULL)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH        = 8200-PRINT-Q-INS'         
              DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00718******************************************************************08061003
P00718*   8300-TASK-Q-INS.                                             *08090000
P00718*        THIS INSERTS THE DATA TO SO_TASK_QUEUE                  *08100000
P00718******************************************************************08061003
P00718                                                                  
P00718 8300-TASK-Q-INS.                                                 
P00718                                                                  
P00718     EXEC SQL                                                     
P00718          INSERT INTO CSS_SO_TASK_QUEUE                           
P00718                   (SERV_ORDER_NO,                                
P00718                    CREATED_TS,                                   
P00718                    COMPANY_NO,                                   
P00718                    TASK_PRIORITY,                                
P00718                    CREATED_BY_USER_ID,                           
P00718                    SO_BUSINESS_UNIT,                             
P00718                    CALL_ID,                                      
P00718                    CALL_NUMBER)                                  
P00718            VALUES (:VO-SERV-ORDER-NO,                            
P00718                    CIS.CURRENT$TIMESTAMP(),                            
P00718                    :VO-COMPANY-NO,                               
P00718                    1,                                            
P00718                    'SYSTEM',                                     
P00718                    :VO-SO-BUSINESS-UNIT,                         
P00718                    1,                                            
P00718                    1)                                            
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SO_TASK_QUEUE                                   
MFA-TR*                  (SERV_ORDER_NO,                                        
MFA-TR*                   CREATED_TS,                                           
MFA-TR*                   COMPANY_NO,                                           
MFA-TR*                   TASK_PRIORITY,                                        
MFA-TR*                   CREATED_BY_USER_ID,                                   
MFA-TR*                   SO_BUSINESS_UNIT,                                     
MFA-TR*                   CALL_ID,                                              
MFA-TR*                   CALL_NUMBER)                                          
MFA-TR*           VALUES (:VO-SERV-ORDER-NO,                                    
MFA-TR*                   CURRENT TIMESTAMP,                                    
MFA-TR*                   :VO-COMPANY-NO,                                       
MFA-TR*                   1,                                                    
MFA-TR*                   'SYSTEM',                                             
MFA-TR*                   :VO-SO-BUSINESS-UNIT,                                 
MFA-TR*                   1,                                                    
MFA-TR*                   1)                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        DISPLAY '***********************************'             
P00718        DISPLAY '**  PROCESSING ERROR             **'             
P00718        DISPLAY '**  PARAGRAPH        = 8300-TASK-Q-INS'          
P00718        DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
P00718        DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
P00718        DISPLAY '**  PROCESSING TERMINATED        **'             
P00718        DISPLAY '***********************************'             
P00718        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00718     END-IF.                                                      
P00718                                                                  
P00718 8300-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
P00718******************************************************************08061003
P00718*   8400-UPD-PRINTED-IND.                                        *08090000
P00718*        UPDATES THE PRINTED INDICATOR                           *08100000
P00718******************************************************************08061003
P00718                                                                  
P00718 8400-UPD-PRINTED-IND.                                            
P00718                                                                  
P00718     EXEC SQL                                                     
P00718          UPDATE CSS_SO_DATA                                      
P00718             SET PRINTED_IND = 'Y'                                
P00718           WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
P00718     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00718                                                                  
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        DISPLAY '***********************************'             
P00718        DISPLAY '**  PROCESSING ERROR             **'             
P00718        DISPLAY '**  PARAGRAPH        = 8400-UPD-PRINTED-IND'     
P00718        DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
P00718        DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
P00718        DISPLAY '**  PROCESSING TERMINATED        **'             
P00718        DISPLAY '***********************************'             
P00718        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00718     END-IF.                                                      
P00718                                                                  
P00718 8400-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
A05020******************************************************************08061003
A05020*   8500-UPD-SEQ-NO.                                             *08090000
A05020*   UPDATES THE SEQ NO FOR CLICK ORDERS CHANGED FROM HOLD STATUS *08100000
A05020******************************************************************08061003
A05020                                                                  
A05020 8500-UPD-SEQ-NO.                                                 
A05020                                                                  
A05020     EXEC SQL                                                     
A05020          UPDATE SI                              
A05020             SET SO_INST_SEQ_NO = (                               
A05020          SELECT ROW_ID FROM (                                    
A05020                   SELECT ROW_NUMBER() 
                         OVER(ORDER BY (SELECT 1)) AS ROW_ID,          
A05020                          SERV_ORDER_NO,                          
A05020                          SO_INST_SEQ_NO,                         
A05020                          CODE_UTIL_TYPE                          
A05020                     FROM CSS_SO_ORDER_INST S1                    
A05020                    WHERE S1.SERV_ORDER_NO = :VO-SERV-ORDER-NO)   
A05020                                           AS TT                  
A05020             WHERE TT.SERV_ORDER_NO = SI.SERV_ORDER_NO            
A05020               AND TT.SO_INST_SEQ_NO = SI.SO_INST_SEQ_NO          
A05020               AND TT.CODE_UTIL_TYPE = SI.CODE_UTIL_TYPE) +       
A05020               (SELECT MAX(SO_INST_SEQ_NO)                        
A05020                 FROM CSS_SO_ORDER_INST S2                        
A05020                WHERE S2.SERV_ORDER_NO = :VO-SERV-ORDER-NO )      
                FROM CSS_SO_ORDER_INST SI
A05020      WHERE SI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
A05020                                                                  
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ047
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SO_ORDER_INST SI                                     
MFA-TR*            SET SO_INST_SEQ_NO = (                                       
MFA-TR*         SELECT ROW_ID FROM (                                            
MFA-TR*                  SELECT ROW_NUMBER() OVER() AS ROW_ID,                  
MFA-TR*                         SERV_ORDER_NO,                                  
MFA-TR*                         SO_INST_SEQ_NO,                                 
MFA-TR*                         CODE_UTIL_TYPE                                  
MFA-TR*                    FROM CSS_SO_ORDER_INST S1                            
MFA-TR*                   WHERE S1.SERV_ORDER_NO = :VO-SERV-ORDER-NO)           
MFA-TR*                                          AS TT                          
MFA-TR*            WHERE TT.SERV_ORDER_NO = SI.SERV_ORDER_NO                    
MFA-TR*              AND TT.SO_INST_SEQ_NO = SI.SO_INST_SEQ_NO                  
MFA-TR*              AND TT.CODE_UTIL_TYPE = SI.CODE_UTIL_TYPE) +               
MFA-TR*              (SELECT MAX(SO_INST_SEQ_NO)                                
MFA-TR*                FROM CSS_SO_ORDER_INST S2                                
MFA-TR*               WHERE S2.SERV_ORDER_NO = :VO-SERV-ORDER-NO )              
MFA-TR*     WHERE SI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A05020                                                                  
A05020     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        DISPLAY '***********************************'             
A05020        DISPLAY '**  PROCESSING ERROR             **'             
A05020        DISPLAY '**  PARAGRAPH        = 8500-UPD-SEQ-NO'          
A05020        DISPLAY '**  RETURN CODE      = ' WS-ACTIVE-RETURN-CODE   
A05020        DISPLAY '**  SERVICE ORDER NO = ' VO-SERV-ORDER-NO        
A05020        DISPLAY '**  PROCESSING TERMINATED        **'             
A05020        DISPLAY '***********************************'             
A05020        PERFORM 9900-ABEND           THRU 9900-EXIT               
A05020     END-IF.                                                      
A05020                                                                  
A05020 8500-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *   9000-TERMINATE.                                              *10060000
      ******************************************************************08061003
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           PERFORM 7500-GET-TIMESTAMP      THRU 7500-EXIT.              
                                                                        
           MOVE WS-RECORD-COUNT            TO E-RECORD-COUNT.           
           MOVE WS-TIME                    TO E-END-TIME.               
                                                                        
           WRITE FSO102 FROM WS-BLANK-LINE.                             
           WRITE FSO102 FROM WS-BLANK-LINE.                             
           WRITE FSO102 FROM WS-END-DATA-LINE1.                         
           WRITE FSO102 FROM WS-END-DATA-LINE2.                         
           WRITE FSO102 FROM WS-BLANK-LINE.                             
                                                                        
           CLOSE FCSSO102-FILE.                                         
                                                                        
           IF WS-FSO102-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSSO102  PROCESSING ERROR **'               
              DISPLAY '**  CLOSE ERROR OF FCSSO102 OUTPUT FILE'         
              DISPLAY '**  FILE STATUS = ' WS-FSO102-STATUS             
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *  6251-GET-FJC01-DATE                                           *10290000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************08061003
      *  7600-START-FCSJC01                                            *10370000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD09900                                         10520000
           END-EXEC.                                                    10530000
