       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRR200.                                        
       DATE-WRITTEN.   06/29/2015.                                      
       DATE-COMPILED.                                                   
       AUTHOR.         MC95456.                                         
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** PCSRR200 GENERATES A REPORT FOR ACTIVE ACCOUNTS WITH CREDIT **         
      ** BALANCES THAT HAVE ACTIVE CONTRACTS.                        **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **             PROGRAM  MODIFICATION  LOG                      **         
      **                                                             **         
      **   DATE     INITIALS  REASON                                 **         
      **   ----     --------  ------                                 **         
      **   06/15    MC95456   EZTR TO COBOL CONVERSION FOR CSR200    **         
      **   10/15    MC95456   CHANGES TO REPORT HEADER.              **         
ACT171**   05/16    MC95456   NULL-IND CHECK TO AR-AMT-BILLED-UNPAID **         
ACT225**   07/16    BD09555   ADD PREPAY FLAG TO REPORT              **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **  9000 - 9799  TERMINATION MODULES                           **         
      **  9900 - 9999  ABEND / ABORT MODULES                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT PRNTFILE    ASSIGN TO UT-S-PRNTFILE.                  
           SELECT PRTFILE     ASSIGN TO UT-S-PRTFILE.                   
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  PRNTFILE                                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 200 CHARACTERS                               
           DATA RECORD IS PRNTFILE-REC.                                 
       01 PRNTFILE-REC                 PIC X(200).                      
                                                                        
       FD  PRTFILE                                                      
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 200 CHARACTERS                               
           DATA RECORD IS PRTFILE-REC.                                  
                                                                        
       01 PRTFILE-REC                  PIC X(200).                      
                                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
                                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRR200'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRR200 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-LEN                  PIC 9(4)     COMP.               
           05  WS-REVENUE-MONTH        PIC 9(6).                        
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10 WS-REV-CCYY          PIC 9(4).                        
               10 WS-REV-MM            PIC 9(2).                        
           05  WS-PREV-ACCOUNT-NO      PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NUM          REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  WS-FILE-TO-PROCESS      PIC X(8) VALUE SPACES.           
           05  WS-PYMT-AMT             PIC S9(09)V99.                   
           05  WS-AR-BALANCE           PIC S9(09)V99.                   
           05  WS-CNT-BALANCE          PIC S9(09)V99.                   
           05  WS-LAST-BILL-AMOUNT     PIC S9(09)V99.                   
           05  WS-LAST-BILL-PAYMNT     PIC S9(09)V99.                   
           05  WS-HOLD-COMP-NO         PIC X(02).                       
           05  WS-REV-MONTH-NUM        PIC 9(06) VALUE ZEROES.          
           05  WS-REV-MONTH-CHAR       REDEFINES WS-REV-MONTH-NUM       
                                       PIC X(06).                       
           05  WS-BBP-ANNIV-FL         PIC X(01) VALUE 'N'.             
           05  WS-BBP-FL               PIC X(01) VALUE 'N'.             
           05  WS-NULL-IND             PIC S9(4) COMP.                  
           05  WS-TOTAL-MED-CERT       PIC 9(04).                       
           05  WS-ARREARS-AMT          PIC S9(9)V99 VALUE ZERO.         
           05  WS-TOTAL-ARREARS-AMT    PIC S9(9)V99 VALUE ZERO.         
           05  WS-ACCOUNT-BAL          PIC S9(9)V99 VALUE ZERO.         
           05  WS-TOTAL-ACCOUNT-BAL    PIC S9(9)V99 VALUE ZERO.         
           05  WS-NULL-IND-1           PIC S9(4) COMP.                  
ACT171     05  WS-NULL-IND-2           PIC S9(4) COMP.                  
           05  WS-CHECK-MM             PIC XX.                          
           05  WS-LONG-MM              PIC X(9).                        
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-HDR-1.                                             
           05 FILLER                   pic X(02) VALUE                  
              'CO'.                                                     
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   pic X(03) VALUE                  
              'BBP'.                                                    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   pic X(05) VALUE                  
              'BBP A'.                                                  
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   pic X(06) VALUE                  
              'UTIL A'.                                                 
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   pic X(06) VALUE                  
              'PREPAY'.                                                 
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   pic X(05) VALUE                  
              'ADV C'.                                                  
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(08) VALUE                  
             'ACCT NUM'.                                                
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(03) VALUE                  
             'CYC'.                                                     
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(11) VALUE                  
             'MONTH PAYMT'.                                             
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(06) VALUE                  
             'AR BAL'.                                                  
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(03) VALUE                  
             'CNT'.                                                     
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(09) VALUE                  
             'LAST BILL'.                                               
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(09) VALUE                  
             'LAST PYMT'.                                               
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(14) VALUE                  
             'LAST PYMT DATE'.                                          
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(07) VALUE                  
             'ITEM ID'.                                                 
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(05) VALUE                  
             'DESCR'.                                                   
           05 FILLER                   PIC X(01) VALUE ','.             
           05 FILLER                   PIC X(09) VALUE                  
             'CUST NAME'.                                               
      *                                                                         
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  WS-COMPANY-NO       PIC X(02).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-BBP              PIC X(01).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-BBP-ANNV         PIC X(01).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-UTIL-ACCT        PIC X(01).                       
               10 FILLER               PIC X(01) VALUE ','.             
ACT225         10  WS-PREPAY-FLAG      PIC X(01).                       
ACT225         10 FILLER               PIC X(01) VALUE ','.             
               10  WS-ADV-COLL         PIC X(01).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-RPT-ACCT-NO      PIC 9/9999/9999/9999.            
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-BILL-CYCLE       PIC X(02).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-AMT-MO-PYMT      PIC ZZZZZ9.99-.                  
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-AMT-AR-BALANCE   PIC ZZZZZ9.99-.                  
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-AMT-CNT-BALANCE  PIC ZZZZZ9.99-.                  
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-LAST-BILL-AMT    PIC ZZZZZ9.99-.                  
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-LAST-PAY-AMT     PIC ZZZZZ9.99-.                  
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-LAST-PAY-DATE    PIC X(10).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-ITEM-ID          PIC ZZZZZZZZ9.                   
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-CNT-NAME-DESC    PIC X(20).                       
               10 FILLER               PIC X(01) VALUE ','.             
               10  WS-CUST-NAME        PIC X(25).                       
      *                                                                         
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-UTIL-ROWS     PIC  X(01).                     
               88 NO-MORE-UTIL-ROWS         VALUE 'Y'.                  
           05  WS-NO-MORE-NON-UTIL-ROWS PIC  X(01).                     
               88 NO-MORE-NON-UTIL-ROWS     VALUE 'Y'.                  
           05  WS-NO-MORE-BBP-ROWS      PIC  X(01).                     
               88 NO-MORE-BBP-ROWS          VALUE 'Y'.                  
           05  WS-NO-MORE-UNESTB-ROWS   PIC  X(01).                     
               88 NO-MORE-UNESTB-ROWS       VALUE 'Y'.                  
      *                                                                         
       COPY CWS00011.                                                           
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00056.                                                           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-SCEG                 PIC X(02)    VALUE '01'.         
      *                                                                         
      ***************** PCSRR200 REPORT HEADERS **********************          
      *                                                                         
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
      * copy book for error handling                                            
       COPY CWS00010.                                                           
      *                                                                         
      *****************************************************************         
      *    JOB PARM.                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_ACCOUNT.                                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_AR_CNTL.                                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BUDGET_PLAN.                                          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_COMPANY.                                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_LOCAL_OFFICE.                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_NAME.                                                 
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_CONTRACT.                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BILL_WINDOW.                                          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_CONTRACT_INFO.                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_NAME_ACCT_XREF.                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_AR_TRANS_HIST.                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_AR_TRN_HST_DET.                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      *****************************************************************         
      *    SQL COMMUNICATION AREA.                                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   DECLARE THE DRIVING CURSOR                                  *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE UTIL_CSR   CURSOR FOR                              
              SELECT AT.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
                     DQ.FULL_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     AT.BILL_CYCLE,                                     
                     AT.DATE_BILL_DAY_00,                               
                     CT.CNT_ITEM_ID,                                    
                     CT.CNT_NAME_CD,                                    
                     K6.CNT_NAME_DESC,                                  
                     AT.TOTAL_AR_BALANCE,                               
                     CT.AMT_MO_PYMT,                                    
                     AC.AMT_TRAN_BALANCE,                               
                     AT.CREDIT_GROUP,                                   
                     AT.LOCAL_OFFICE,                                   
                     B1.REGULATED_CD,                                   
                     AT.CODES_DATA_PRESENT,                             
                     AT.REV_MTH_LST_NRML                                
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_AR_CNTL AC WITH(READUNCOMMITTED),                      
                     CSS_CONTRACT CT WITH(READUNCOMMITTED),                     
                     CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED),                
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),               
                     CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.CODE_ACCT_STAT      = 'A'                       
                 AND AT.CREDIT_GROUP NOT IN ('D')                       
                 AND                                                    
                    (AT.TOTAL_AR_BALANCE    <= -25.00                   
                 AND AT.DATE_BILL_DAY_00    < (DATEADD( DAY, -7, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
                 AND CT.CNT_STATUS_CD      IN ('A', 'B')                
                 AND    ((CT.CODE_CONTRACT_TYPE IN ('A', 'B')           
                          AND CT.CNT_NAME_CD NOT IN(1099, 1199))        
                     OR   CT.CODE_CONTRACT_TYPE = 'F'        AND        
                          CT.CNT_NAME_CD IN (630,631)))                 
                 AND DQ.NAME_TYPE           = 'CN'                      
                 AND AC.PYMT_PRIORITY_LVL   = 100                       
                 AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'       
                 AND AT.CREDIT_GROUP        <> 'M'                      
                 AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO             
                 AND AC.ITEM_ID             = CT.CNT_ITEM_ID            
                 AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD            
                 AND DQ.NAME_ID             = HT.NAME_ID                
                 AND AT.COMPANY_NO          = B1.COMPANY_NO             
                 AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE           
               ORDER BY AT.COMPANY_NO,                                  
                        AT.BILL_CYCLE,                                  
                        AT.ACCOUNT_NO,                                  
                        CT.CNT_ITEM_ID                                  
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UTIL_CSR   CURSOR FOR                                      
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              DQ.FULL_NAME,                                              
MFA-TR*              DQ.FIRST_NAME,                                             
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              CT.CNT_ITEM_ID,                                            
MFA-TR*              CT.CNT_NAME_CD,                                            
MFA-TR*              K6.CNT_NAME_DESC,                                          
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              CT.AMT_MO_PYMT,                                            
MFA-TR*              AC.AMT_TRAN_BALANCE,                                       
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              B1.REGULATED_CD,                                           
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.REV_MTH_LST_NRML                                        
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_AR_CNTL AC,                                            
MFA-TR*              CSS_CONTRACT CT,                                           
MFA-TR*              CSS_CONTRACT_INFO K6,                                      
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_NAME_ACCT_XREF HT,                                     
MFA-TR*              CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.CODE_ACCT_STAT      = 'A'                               
MFA-TR*          AND AT.CREDIT_GROUP NOT IN ('D')                               
MFA-TR*          AND                                                            
MFA-TR*             (AT.TOTAL_AR_BALANCE    <= -25.00                           
MFA-TR*          AND AT.DATE_BILL_DAY_00    < (CURRENT DATE - 7 DAYS)           
MFA-TR*          AND CT.CNT_STATUS_CD      IN ('A', 'B')                        
MFA-TR*          AND    ((CT.CODE_CONTRACT_TYPE IN ('A', 'B')                   
MFA-TR*                   AND CT.CNT_NAME_CD NOT IN(1099, 1199))                
MFA-TR*              OR   CT.CODE_CONTRACT_TYPE = 'F'        AND                
MFA-TR*                   CT.CNT_NAME_CD IN (630,631)))                         
MFA-TR*          AND DQ.NAME_TYPE           = 'CN'                              
MFA-TR*          AND AC.PYMT_PRIORITY_LVL   = 100                               
MFA-TR*          AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'               
MFA-TR*          AND AT.CREDIT_GROUP        <> 'M'                              
MFA-TR*          AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO                     
MFA-TR*          AND AC.ITEM_ID             = CT.CNT_ITEM_ID                    
MFA-TR*          AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD                    
MFA-TR*          AND DQ.NAME_ID             = HT.NAME_ID                        
MFA-TR*          AND AT.COMPANY_NO          = B1.COMPANY_NO                     
MFA-TR*          AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE                   
MFA-TR*        ORDER BY AT.COMPANY_NO,                                          
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 CT.CNT_ITEM_ID                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * NON-UTIL-CURSOR                                                         
           EXEC SQL                                                     
             DECLARE NON_UTIL_CSR   CURSOR FOR                          
              SELECT AT.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
                     DQ.FULL_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     AT.BILL_CYCLE,                                     
                     AT.DATE_BILL_DAY_00,                               
                     CT.CNT_ITEM_ID,                                    
                     CT.CNT_NAME_CD,                                    
                     K6.CNT_NAME_DESC,                                  
                     AT.TOTAL_AR_BALANCE,                               
                     CT.AMT_MO_PYMT,                                    
                     AC.AMT_TRAN_BALANCE,                               
                     AT.CREDIT_GROUP,                                   
                     AT.LOCAL_OFFICE,                                   
                     B1.REGULATED_CD,                                   
                     AT.CODES_DATA_PRESENT                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_AR_CNTL AC WITH(READUNCOMMITTED),                      
                     CSS_CONTRACT CT WITH(READUNCOMMITTED),                     
                     CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED),                
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),               
                     CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.CODE_ACCT_STAT      = 'A'                       
                 AND AT.CREDIT_GROUP        = 'D'                       
                 AND                                                    
                    (AT.TOTAL_AR_BALANCE    <= -25.00                   
                 AND AT.DATE_BILL_DAY_00    < (DATEADD( DAY, -7, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
                 AND CT.CNT_STATUS_CD      IN ('A', 'B')                
                 AND    ((CT.CODE_CONTRACT_TYPE IN ('A', 'B')           
                          AND CT.CNT_NAME_CD NOT IN(1099, 1199))        
                     OR   CT.CODE_CONTRACT_TYPE = 'F'        AND        
                          CT.CNT_NAME_CD IN (630,631)))                 
                 AND DQ.NAME_TYPE           = 'CN'                      
                 AND AC.PYMT_PRIORITY_LVL   = 100                       
                 AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'       
                 AND AT.CREDIT_GROUP        <> 'M'                      
                 AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO             
                 AND AC.ITEM_ID             = CT.CNT_ITEM_ID            
                 AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD            
                 AND DQ.NAME_ID             = HT.NAME_ID                
                 AND AT.COMPANY_NO          = B1.COMPANY_NO             
                 AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE           
               ORDER BY AT.COMPANY_NO,                                  
                        AT.BILL_CYCLE,                                  
                        AT.ACCOUNT_NO,                                  
                        CT.CNT_ITEM_ID                                  
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NON_UTIL_CSR   CURSOR FOR                                  
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              DQ.FULL_NAME,                                              
MFA-TR*              DQ.FIRST_NAME,                                             
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              CT.CNT_ITEM_ID,                                            
MFA-TR*              CT.CNT_NAME_CD,                                            
MFA-TR*              K6.CNT_NAME_DESC,                                          
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              CT.AMT_MO_PYMT,                                            
MFA-TR*              AC.AMT_TRAN_BALANCE,                                       
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              B1.REGULATED_CD,                                           
MFA-TR*              AT.CODES_DATA_PRESENT                                      
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_AR_CNTL AC,                                            
MFA-TR*              CSS_CONTRACT CT,                                           
MFA-TR*              CSS_CONTRACT_INFO K6,                                      
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_NAME_ACCT_XREF HT,                                     
MFA-TR*              CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.CODE_ACCT_STAT      = 'A'                               
MFA-TR*          AND AT.CREDIT_GROUP        = 'D'                               
MFA-TR*          AND                                                            
MFA-TR*             (AT.TOTAL_AR_BALANCE    <= -25.00                           
MFA-TR*          AND AT.DATE_BILL_DAY_00    < (CURRENT DATE - 7 DAYS)           
MFA-TR*          AND CT.CNT_STATUS_CD      IN ('A', 'B')                        
MFA-TR*          AND    ((CT.CODE_CONTRACT_TYPE IN ('A', 'B')                   
MFA-TR*                   AND CT.CNT_NAME_CD NOT IN(1099, 1199))                
MFA-TR*              OR   CT.CODE_CONTRACT_TYPE = 'F'        AND                
MFA-TR*                   CT.CNT_NAME_CD IN (630,631)))                         
MFA-TR*          AND DQ.NAME_TYPE           = 'CN'                              
MFA-TR*          AND AC.PYMT_PRIORITY_LVL   = 100                               
MFA-TR*          AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'               
MFA-TR*          AND AT.CREDIT_GROUP        <> 'M'                              
MFA-TR*          AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO                     
MFA-TR*          AND AC.ITEM_ID             = CT.CNT_ITEM_ID                    
MFA-TR*          AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD                    
MFA-TR*          AND DQ.NAME_ID             = HT.NAME_ID                        
MFA-TR*          AND AT.COMPANY_NO          = B1.COMPANY_NO                     
MFA-TR*          AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE                   
MFA-TR*        ORDER BY AT.COMPANY_NO,                                          
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 CT.CNT_ITEM_ID                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * UN ESTABLISHED CONTRACTS                                                
      *                                                                         
           EXEC SQL                                                     
             DECLARE UNESTB_CSR  CURSOR FOR                             
              SELECT AT.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
                     DQ.FULL_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     AT.BILL_CYCLE,                                     
                     AT.DATE_BILL_DAY_00,                               
                     CT.CNT_ITEM_ID,                                    
                     CT.CNT_NAME_CD,                                    
                     K6.CNT_NAME_DESC,                                  
                     AT.TOTAL_AR_BALANCE,                               
                     CT.AMT_MO_PYMT,                                    
                     AC.AMT_TRAN_BALANCE,                               
                     AT.CREDIT_GROUP,                                   
                     AT.LOCAL_OFFICE,                                   
                     B1.REGULATED_CD,                                   
                     AT.CODES_DATA_PRESENT                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_AR_CNTL AC WITH(READUNCOMMITTED),                      
                     CSS_CONTRACT CT WITH(READUNCOMMITTED),                     
                     CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED),                
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),               
                     CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.CODE_ACCT_STAT      = 'A'                       
                 AND AT.DATE_BILL_DAY_00    < (DATEADD( DAY, -7, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
                 AND CT.CNT_STATUS_CD      IN ('A', 'B')                
                 AND  (CT.CODE_CONTRACT_TYPE IN ('A', 'B', 'F')         
                 AND CT.CNT_NAME_CD  IN (1099, 1199))                   
                 AND DQ.NAME_TYPE           = 'CN'                      
                 AND AC.PYMT_PRIORITY_LVL   = 100                       
                 AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'       
                 AND AT.CREDIT_GROUP        <> 'M'                      
                 AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO             
                 AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO             
                 AND AC.ITEM_ID             = CT.CNT_ITEM_ID            
                 AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD            
                 AND DQ.NAME_ID             = HT.NAME_ID                
                 AND AT.COMPANY_NO          = B1.COMPANY_NO             
                 AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE           
               ORDER BY AT.COMPANY_NO,                                  
                        AT.BILL_CYCLE,                                  
                        AT.ACCOUNT_NO,                                  
                        CT.CNT_ITEM_ID                                  
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UNESTB_CSR  CURSOR FOR                                     
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              DQ.FULL_NAME,                                              
MFA-TR*              DQ.FIRST_NAME,                                             
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              CT.CNT_ITEM_ID,                                            
MFA-TR*              CT.CNT_NAME_CD,                                            
MFA-TR*              K6.CNT_NAME_DESC,                                          
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              CT.AMT_MO_PYMT,                                            
MFA-TR*              AC.AMT_TRAN_BALANCE,                                       
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              B1.REGULATED_CD,                                           
MFA-TR*              AT.CODES_DATA_PRESENT                                      
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_AR_CNTL AC,                                            
MFA-TR*              CSS_CONTRACT CT,                                           
MFA-TR*              CSS_CONTRACT_INFO K6,                                      
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_NAME_ACCT_XREF HT,                                     
MFA-TR*              CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.CODE_ACCT_STAT      = 'A'                               
MFA-TR*          AND AT.DATE_BILL_DAY_00    < (CURRENT DATE - 7 DAYS)           
MFA-TR*          AND CT.CNT_STATUS_CD      IN ('A', 'B')                        
MFA-TR*          AND  (CT.CODE_CONTRACT_TYPE IN ('A', 'B', 'F')                 
MFA-TR*          AND CT.CNT_NAME_CD  IN (1099, 1199))                           
MFA-TR*          AND DQ.NAME_TYPE           = 'CN'                              
MFA-TR*          AND AC.PYMT_PRIORITY_LVL   = 100                               
MFA-TR*          AND HT.CUSTOMER_ROLE_CD  NOT BETWEEN 'A' AND 'Z'               
MFA-TR*          AND AT.CREDIT_GROUP        <> 'M'                              
MFA-TR*          AND AT.ACCOUNT_NO          = AC.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = CT.ACCOUNT_NO                     
MFA-TR*          AND AT.ACCOUNT_NO          = HT.ACCOUNT_NO                     
MFA-TR*          AND AC.ITEM_ID             = CT.CNT_ITEM_ID                    
MFA-TR*          AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD                    
MFA-TR*          AND DQ.NAME_ID             = HT.NAME_ID                        
MFA-TR*          AND AT.COMPANY_NO          = B1.COMPANY_NO                     
MFA-TR*          AND AT.LOCAL_OFFICE        = B1.LOCAL_OFFICE                   
MFA-TR*        ORDER BY AT.COMPANY_NO,                                          
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 CT.CNT_ITEM_ID                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRR200 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-ACCOUNTS     THRU 1000-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT PRNTFILE.                                        
           OPEN OUTPUT PRTFILE.                                         
           PERFORM 8100-PRINT-COLUMN-HEADERS  THRU 8100-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 1000-PROCESS-ACCOUNTS.                                     **          
      ****************************************************************          
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           PERFORM 7100-OPEN-UTIL-CSR      THRU 7100-EXIT.              
           PERFORM 7110-FETCH-UTIL-CSR     THRU 7110-EXIT.              
           PERFORM 2000-PROCESS-UTIL       THRU 2000-EXIT               
                                           UNTIL NO-MORE-UTIL-ROWS.     
           PERFORM 7120-CLOSE-UTIL-CSR     THRU 7120-EXIT.              
      *                                                                         
           PERFORM 7200-OPEN-NON-UTIL-CSR  THRU 7200-EXIT.              
           PERFORM 7210-FETCH-NON-UTIL-CSR THRU 7210-EXIT.              
           PERFORM 2100-PROCESS-NON-UTIL   THRU 2100-EXIT               
                                           UNTIL NO-MORE-NON-UTIL-ROWS. 
           PERFORM 7220-CLOSE-NON-UTIL-CSR THRU 7220-EXIT.              
      *                                                                         
           PERFORM 7400-OPEN-UNESTB-CSR    THRU 7400-EXIT.              
           PERFORM 7410-FETCH-UNESTB-CSR   THRU 7410-EXIT.              
           PERFORM 2300-PROCESS-UNESTB     THRU 2300-EXIT               
                                           UNTIL NO-MORE-UNESTB-ROWS.   
           PERFORM 7420-CLOSE-UNESTB-CSR   THRU 7420-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2000-PROCESS-UTIL.                                         **          
      ****************************************************************          
       2000-PROCESS-UTIL.                                               
           PERFORM 2400-PROCESS-ACCOUNTS THRU 2400-EXIT.                
           PERFORM 7110-FETCH-UTIL-CSR   THRU 7110-EXIT.                
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2100-PROCESS-NON-UTIL.                                     **          
      ****************************************************************          
       2100-PROCESS-NON-UTIL.                                           
           PERFORM 2400-PROCESS-ACCOUNTS   THRU 2400-EXIT.              
           PERFORM 7210-FETCH-NON-UTIL-CSR THRU 7210-EXIT.              
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2300-PROCESS-UNESTB.                                       **          
      ****************************************************************          
       2300-PROCESS-UNESTB.                                             
           PERFORM 2400-PROCESS-ACCOUNTS   THRU 2400-EXIT.              
           PERFORM 7410-FETCH-UNESTB-CSR   THRU 7410-EXIT.              
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2400-PROCESS-ACCOUNTS.                                     **          
      ****************************************************************          
       2400-PROCESS-ACCOUNTS.                                           
      *                                                                         
ACT171      DISPLAY 'PROCESSING ACCT# ' AT-ACCOUNT-NO.                  
            MOVE AT-ACCOUNT-NO                TO     WS-ACCOUNT-NO.     
            MOVE WS-ACCOUNT-NUM               TO     WS-RPT-ACCT-NO.    
            INSPECT WS-RPT-ACCT-NO REPLACING ALL '/' BY '-'.            
            IF WS-ACCOUNT-NO     NOT EQUAL WS-PREV-ACCOUNT-NO           
               PERFORM 7450-GET-PREV-MTH-BILL THRU 7450-EXIT            
               PERFORM 7500-GET-LAST-PAYMENT  THRU 7500-EXIT            
               MOVE    WS-ACCOUNT-NO          TO WS-PREV-ACCOUNT-NO     
            END-IF                                                      
            MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT. 
            IF WS-CODE-BUDGET = 'A'                                     
               MOVE  'Y'                      TO WS-BBP-FL              
            ELSE                                                        
               MOVE  'N'                      TO WS-BBP-FL              
            END-IF.                                                     
                                                                        
            MOVE  'N'                         TO WS-BBP-ANNIV-FL        
            IF WS-BBP-FL = 'Y'                                          
               PERFORM 2410-GET-BBP-ANNIV-FLAG   THRU 2410-EXIT         
            END-IF.                                                     
      *                                                                         
ACT225     PERFORM 7550-GET-ATTRIBUTE         THRU 7550-EXIT.           
           PERFORM 2500-WRITE-REPORT          THRU 2500-EXIT.           
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2410-GET-BBP-ANNIV-FLAG.                                   **          
      ****************************************************************          
       2410-GET-BBP-ANNIV-FLAG.                                         
      *                                                                         
               MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MONTH-NUM.       
               PERFORM 7035-SELECT-BUD-PLAN  THRU 7035-EXIT             
               IF BU-ANNIVERSARY-DATE(6:2) =                            
                  WS-REV-MONTH-CHAR(5:2)                                
                  MOVE 'Y'                   TO WS-BBP-ANNIV-FL         
               ELSE                                                     
                  MOVE 'N'                   TO WS-BBP-ANNIV-FL         
               END-IF.                                                  
      *                                                                         
       2410-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      ** 2500-WRITE-REPORT.                                         **          
      ****************************************************************          
       2500-WRITE-REPORT.                                               
      *                                                                         
           IF WS-BBP-FL       = 'Y'                                     
              MOVE  'Y'                      TO   WS-BBP                
           ELSE                                                         
              MOVE  SPACES                   TO   WS-BBP                
           END-IF.                                                      
      *                                                                         
           IF WS-BBP-ANNIV-FL = 'Y'                                     
              MOVE  'Y'                      TO   WS-BBP-ANNV           
           ELSE                                                         
              MOVE  SPACES                   TO   WS-BBP-ANNV           
           END-IF.                                                      
           IF  AT-CREDIT-GROUP = 'D'                                    
               MOVE ' '                      TO   WS-UTIL-ACCT          
           ELSE                                                         
               MOVE 'Y'                      TO   WS-UTIL-ACCT          
           END-IF.                                                      
           IF CT-CNT-NAME-CD = 1099 OR 1199                             
              MOVE 'Y' TO WS-ADV-COLL                                   
           ELSE                                                         
              MOVE ' ' TO WS-ADV-COLL                                   
           END-IF.                                                      
           MOVE  AT-COMPANY-NO               TO   WS-COMPANY-NO         
           MOVE  AT-ACCOUNT-NO               TO   WS-ACCOUNT-NO         
           MOVE  AT-BILL-CYCLE               TO   WS-BILL-CYCLE         
           MOVE  CT-CNT-ITEM-ID              TO   WS-ITEM-ID            
           MOVE  CT-AMT-MO-PYMT              TO   WS-PYMT-AMT           
           MOVE  WS-PYMT-AMT                 TO   WS-AMT-MO-PYMT        
           MOVE  AT-TOTAL-AR-BALANCE         TO   WS-AR-BALANCE         
           MOVE  WS-AR-BALANCE               TO   WS-AMT-AR-BALANCE     
           MOVE  AC-AMT-TRAN-BALANCE         TO   WS-CNT-BALANCE        
           MOVE  WS-CNT-BALANCE              TO   WS-AMT-CNT-BALANCE    
           MOVE  K6-CNT-NAME-DESC            TO   WS-CNT-NAME-DESC      
           MOVE  AU-AMT-POSTED               TO   WS-LAST-BILL-PAYMNT   
           MOVE  WS-LAST-BILL-PAYMNT         TO   WS-LAST-PAY-AMT       
           MOVE  AR-AMT-BILLED-UNPAID        TO   WS-LAST-BILL-AMOUNT   
           MOVE  WS-LAST-BILL-AMOUNT         TO   WS-LAST-BILL-AMT      
           MOVE  AR-DATE-TRANS               TO   WS-LAST-PAY-DATE      
           IF DQ-FULL-NAME > SPACES                                     
              MOVE  DQ-FULL-NAME             TO   WS-CUST-NAME          
           ELSE                                                         
              MOVE  DQ-FIRST-NAME            TO   WS-CUST-NAME          
           END-IF.                                                      
           PERFORM 8200-PRINT-DETAIL-LINE    THRU 8200-EXIT.            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  6010-REDUCE-EMBEDDED-SPACE.                             *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00004                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7100-OPEN-UTIL-CSR.                                           *        
      ******************************************************************        
       7100-OPEN-UTIL-CSR.                                              
                                                                        
           EXEC SQL                                                     
              OPEN UTIL_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*        7100-OPEN-UTIL-CSR       *'             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7110-FETCH-UTIL-CSR.                                          *        
      ******************************************************************        
       7110-FETCH-UTIL-CSR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH UTIL_CSR                                            
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:DQ-FULL-NAME                                       
                   ,:DQ-FIRST-NAME                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:CT-CNT-ITEM-ID                                     
                   ,:CT-CNT-NAME-CD                                     
                   ,:K6-CNT-NAME-DESC                                   
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:CT-AMT-MO-PYMT                                     
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-LOCAL-OFFICE                                    
                   ,:B1-REGULATED-CD                                    
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-REV-MTH-LST-NRML                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE         EQUAL NOT-FOUND          
                 MOVE 'Y'                      TO WS-NO-MORE-UTIL-ROWS  
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*       7110-FETCH-UTIL-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT-NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRR200 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7120-CLOSE-UTIL-CSR.                                          *        
      ******************************************************************        
       7120-CLOSE-UTIL-CSR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE UTIL_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE       SQLCODE                 TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSRR200 ABORT **************'       
               DISPLAY '*       7120-CLOSE-UTIL-CSR            *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRR200  ABORT *************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7200-OPEN-NON-UTIL-CSR.                                       *        
      ******************************************************************        
       7200-OPEN-NON-UTIL-CSR.                                          
                                                                        
           EXEC SQL                                                     
              OPEN NON_UTIL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*        7200-OPEN-NON-UTIL-CSR       *'         
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7210-FETCH-NON-UTIL-CSR.                                      *        
      ******************************************************************        
       7210-FETCH-NON-UTIL-CSR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH NON_UTIL_CSR                                        
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:DQ-FULL-NAME                                       
                   ,:DQ-FIRST-NAME                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:CT-CNT-ITEM-ID                                     
                   ,:CT-CNT-NAME-CD                                     
                   ,:K6-CNT-NAME-DESC                                   
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:CT-AMT-MO-PYMT                                     
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-LOCAL-OFFICE                                    
                   ,:B1-REGULATED-CD                                    
                   ,:AT-CODES-DATA-PRESENT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND            
                 MOVE 'Y'                    TO WS-NO-MORE-NON-UTIL-ROWS
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*       7210-FETCH-NON-UTIL-CSR            *'    
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT-NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRR200 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7220-CLOSE-NON-UTIL-CSR.                                      *        
      ******************************************************************        
       7220-CLOSE-NON-UTIL-CSR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE NON_UTIL_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE       SQLCODE                 TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSRR200 ABORT **************'       
               DISPLAY '*       7220-CLOSE-NON-UTIL-CSR        *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRR200  ABORT *************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  7035-SELECT-BUD-PLAN.                                         *        
      ******************************************************************        
       7035-SELECT-BUD-PLAN.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AMT_MO_PYMT,
              ANNIVERSARY_DATE,
              DATE_PYMT_STRT                                    
                INTO :BU-AMT-MO-PYMT,                                   
                     :BU-ANNIVERSARY-DATE,                              
                     :BU-DATE-PYMT-STRT                                 
                FROM  CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND PYMT_PRIORITY_LVL = 50                             
                 AND BP_ITEM_ID = 1                                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AMT_MO_PYMT,                                              
MFA-TR*               ANNIVERSARY_DATE,                                         
MFA-TR*               DATE_PYMT_STRT                                            
MFA-TR*         INTO :BU-AMT-MO-PYMT,                                           
MFA-TR*              :BU-ANNIVERSARY-DATE,                                      
MFA-TR*              :BU-DATE-PYMT-STRT                                         
MFA-TR*         FROM  CSS_BUDGET_PLAN                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND PYMT_PRIORITY_LVL = 50                                     
MFA-TR*          AND BP_ITEM_ID = 1                                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7035                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSRR200 PROCESSING ERROR ***'         
                    DISPLAY '*** 7035-SELECT-BUD-PLAN.     ***'         
                    DISPLAY 'ERROR ON SELECT CSS_BUDGET_PLAN  '         
                    DISPLAY '*** ACCOUNT_NO   ' AT-ACCOUNT-NO           
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      *  7400-OPEN-UNESTB-CSR.                                         *        
      ******************************************************************        
       7400-OPEN-UNESTB-CSR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN UNESTB_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*        7400-OPEN-UNESTB-CSR.        *'         
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7410-FETCH-UNESTB-CSR.                                        *        
      ******************************************************************        
       7410-FETCH-UNESTB-CSR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH UNESTB_CSR                                          
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:DQ-FULL-NAME                                       
                   ,:DQ-FIRST-NAME                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:CT-CNT-ITEM-ID                                     
                   ,:CT-CNT-NAME-CD                                     
                   ,:K6-CNT-NAME-DESC                                   
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:CT-AMT-MO-PYMT                                     
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-LOCAL-OFFICE                                    
                   ,:B1-REGULATED-CD                                    
                   ,:AT-CODES-DATA-PRESENT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND            
                 MOVE 'Y'                    TO WS-NO-MORE-UNESTB-ROWS  
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSRR200 ABORT **************'        
              DISPLAY '*       7410-FETCH-UNESTB-CSR.             *'    
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT-NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRR200 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7420-CLOSE-UNESTB-CSR.                                        *        
      ******************************************************************        
       7420-CLOSE-UNESTB-CSR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE UNESTB_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.          
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSRR200 ABORT **************'       
               DISPLAY '*       7420-CLOSE-UNESTB-CSR.         *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRR200  ABORT *************'       
               PERFORM 9900-ABEND    THRU 9900-EXIT                     
            END-IF.                                                     
                                                                        
       7420-EXIT.                                                       
            EXIT.                                                       
      ************************************************************              
      * 7450-GET-PREV-MTH-BILL.                                  *              
      * GET PREVIOUS MONTH BILL DETAILS                          *              
      ************************************************************              
       7450-GET-PREV-MTH-BILL.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.'),                     
                    AMT_BILLED_UNPAID                                   
               INTO :AR-TRANS-HIST-SEQ-NO                               
ACT171             ,:AR-AMT-BILLED-UNPAID :WS-NULL-IND-2                 
               FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO               = :AT-ACCOUNT-NO           
                AND APPL_PROGRAM_ID          = 'PCSCA100 '              
                AND CAST(TRANS_HIST_SEQ_NO AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )     
              GROUP BY TRANS_HIST_SEQ_NO, AMT_BILLED_UNPAID             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(TRANS_HIST_SEQ_NO),                                     
MFA-TR*             AMT_BILLED_UNPAID                                           
MFA-TR*        INTO :AR-TRANS-HIST-SEQ-NO                                       
MFA-TR*            ,:AR-AMT-BILLED-UNPAID:WS-NULL-IND-2                         
MFA-TR*        FROM CSS_AR_TRANS_HIST                                           
MFA-TR*       WHERE ACCOUNT_NO               = :AT-ACCOUNT-NO                   
MFA-TR*         AND APPL_PROGRAM_ID          = 'PCSCA100 '                      
MFA-TR*         AND DATE(TRANS_HIST_SEQ_NO) >= :AT-DATE-BILL-DAY-00             
MFA-TR*       GROUP BY TRANS_HIST_SEQ_NO, AMT_BILLED_UNPAID                     
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7450                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT171              IF WS-NULL-IND-2 < 0                                
ACT171                 MOVE ZEROS TO AR-AMT-BILLED-UNPAID               
ACT171              END-IF                                              
               WHEN NOT-FOUND                                           
ACT171              MOVE ZEROS TO AR-AMT-BILLED-UNPAID                  
               WHEN OTHER                                               
                    DISPLAY '*** PCSRR200 PROCESSING ERROR ***'         
                    DISPLAY '*** 7450-GET-PREV-MTH-BILL.   ***'         
                    DISPLAY 'ERROR ON SELECT CSS_AR_TRANS_HIST'         
                    DISPLAY '*** ACCOUNT_NO   ' AT-ACCOUNT-NO           
                    DISPLAY '*** BILL_DAY_00  ' AT-DATE-BILL-DAY-00     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 7500-GET-LAST-PAYMENT.                                   *              
      * GET LAST PAYMENT DETAILS                                 *              
      ************************************************************              
       7500-GET-LAST-PAYMENT.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) AR.DATE_TRANS,
              AU.AMT_POSTED                                       
               INTO :AR-DATE-TRANS                                      
                   ,:AU-AMT-POSTED :WS-NULL-IND-1                        
               FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED),                 
                    CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                 
              WHERE AR.ACCOUNT_NO         = :AT-ACCOUNT-NO              
                AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                
                AND AR.CODE_TRAN_TYPE    = 'P'                          
                AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO         
              ORDER BY AR.DATE_TRANS    DESC                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AR.DATE_TRANS,                                              
MFA-TR*             AU.AMT_POSTED                                               
MFA-TR*        INTO :AR-DATE-TRANS                                              
MFA-TR*            ,:AU-AMT-POSTED:WS-NULL-IND-1                                
MFA-TR*        FROM CSS_AR_TRANS_HIST AR,                                       
MFA-TR*             CSS_AR_TRN_HST_DET AU                                       
MFA-TR*       WHERE AR.ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*         AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                        
MFA-TR*         AND AR.CODE_TRAN_TYPE    = 'P'                                  
MFA-TR*         AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO                 
MFA-TR*       ORDER BY AR.DATE_TRANS    DESC                                    
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-1 < 0                                
                       MOVE ZEROS TO AU-AMT-POSTED                      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE ZEROS TO AU-AMT-POSTED                         
               WHEN OTHER                                               
                    DISPLAY '*** PCSRR200 PROCESSING ERROR ***'         
                    DISPLAY '*** 7500-GET-LAST-PAYMENT     ***'         
                    DISPLAY 'ERROR ON SELECT CSS_AR_TRANS_HIST'         
                    DISPLAY '*** ACCOUNT_NO   ' AT-ACCOUNT-NO           
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT225 7550-GET-ATTRIBUTE.                                              
ACT225                                                                  
ACT225     MOVE ' ' TO WS-PREPAY-FLAG.                                  
ACT225     EXEC SQL                                                     
ACT225       SELECT TOP(1) 'Y'                                                 
ACT225         INTO :WS-PREPAY-FLAG                                     
ACT225         FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
ACT225        WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO AND           
ACT225              STATUS_CD            = 'A'            AND           
ACT225              ATTRIBUTE_DESC       = 'CONTRACT_PREPAY'            
ACT225                                              
ACT225                                                           
ACT225                                                      
ACT225     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-PREPAY-FLAG                                             
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO AND                   
MFA-TR*             status_cd            = 'A'            AND                   
MFA-TR*             ATTRIBUTE_DESC       = 'CONTRACT_PREPAY'                    
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7550                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT225                                                                  
ACT225     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
ACT225     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL AND NOT-FOUND 
ACT225              DISPLAY '*** PCSRR200 PROCESSING ERROR ***'         
ACT225              DISPLAY '*** 7550-GET-ATTRIBUTE        ***'         
ACT225              DISPLAY 'ERROR ON SELECT CSS_ACCT_ATTRIBUTE'        
ACT225              DISPLAY '*** ACCOUNT_NO   ' AT-ACCOUNT-NO           
ACT225              DISPLAY '*** SQLCODE      ' SQLCODE                 
ACT225              PERFORM 9900-ABEND THRU 9900-EXIT                   
ACT225     END-IF.                                                      
ACT225                                                                  
ACT225 7550-EXIT.                                                       
ACT225     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8100-PRINT-COLUMN-HEADERS.                               **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      ****************************************************************          
       8100-PRINT-COLUMN-HEADERS.                                       
      *                                                                         
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-1.                    
           WRITE PRTFILE-REC   FROM WS-DETAIL-HDR-1.                    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8200-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      ****************************************************************          
       8200-PRINT-DETAIL-LINE.                                          
      *                                                                         
              IF WS-COMPANY-NO = WS-SCEG                                
                 WRITE PRNTFILE-REC  FROM WS-DETAIL-LINE-1              
              ELSE                                                      
                 WRITE PRTFILE-REC   FROM WS-DETAIL-LINE-1              
              END-IF.                                                   
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE PRNTFILE.                                              
           CLOSE PRTFILE.                                               
      *                                                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  9700-PROCESS-ABEND                                      *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
