       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP977.                                      
COB303 DATE-WRITTEN.     JUN 02, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  06/02/2015    VK7L032     ACTIVITY #003.CONVERTED THE EZT --*        
ACT003*--                            PGM SEB977 TO COBOL.            --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP977'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CREDIT_PROFILE, CZ                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BILL_WINDOW, BN                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUST_STATS, CE                                       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUSTOMER, CU                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_SPCL_FCTR, SF                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCT_RTPK_AGR,  DF                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_FIXED_FCTR, FF                                       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBFXDFCT                                                
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_REG_PROFILE, LR                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBREGPRF                                                
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BUDGET_PLAN, BU                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_RATE_PLAN_DESC, RD                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CRM_OPT_ATTR_INCTV, HQ                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CRM_RT_PKG_OPTION, FI                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
       COPY CWS00329.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP977'.     
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-COMMA                  PIC X(01) VALUE ','.            
           05 WS-ONE-N                  PIC 9(01) VALUE 1.              
           05 WS-ONE                    PIC X(02) VALUE '01'.           
           05 WS-SIX                    PIC 9(01) VALUE 6.              
      *                                                                         
       01 WS-RP77-HDR-REC.                                              
           05 HDR-TEST-DESCRIPTION      PIC X(16)                       
                                        VALUE 'TEST-DESCRIPTION'.       
           05 FILLER                    PIC X(01) VALUE ','.            
           05 HDR-ACCOUNT-NO            PIC X(10) VALUE 'ACCOUNT-NO'.   
           05 FILLER                    PIC X(01) VALUE ','.            
           05 HDR-OPTION-CD             PIC X(11) VALUE 'OPTION-CODE'.  
           05 FILLER                    PIC X(01) VALUE ','.            
           05 HDR-BILL-STATUS           PIC X(11) VALUE 'BILL-STATUS'.  
           05 FILLER                    PIC X(01) VALUE ','.            
           05 HDR-ESTIMATE-STATUS       PIC X(13)                       
                                        VALUE 'ESTIMATION-OK'.          
      *                                                                         
       01 WS-DREG-REC.                                                  
          05 WS-DREG-TEST-DESCRIPTION   PIC X(50) VALUE SPACES.         
          05 WS-FILLER5                 PIC X(01) VALUE ','.            
          05 WS-DREG-ACCOUNT-NO         PIC X(13) VALUE SPACES.         
          05 WS-FILLER6                 PIC X(01) VALUE ','.            
          05 WS-DREG-OPTION-CD          PIC X(12) VALUE SPACES.         
          05 WS-FILLER7                 PIC X(01) VALUE ','.            
          05 WS-DREG-BILL-STATUS        PIC X(22) VALUE SPACES.         
          05 WS-FILLER8                 PIC X(01) VALUE ','.            
          05 WS-DREG-ESTIMATE-STATUS    PIC X(22) VALUE SPACES.         
      *                                                                         
       01 WS-REG-REC.                                                   
          05 WS-REG-TEST-DESCRIPTION    PIC X(50) VALUE SPACES.         
          05 WS-FILLER1                 PIC X(01) VALUE ','.            
          05 WS-REG-ACCOUNT-NO          PIC X(13) VALUE SPACES.         
          05 WS-FILLER2                 PIC X(01) VALUE ','.            
          05 WS-REG-OPTION-CD           PIC X(12) VALUE SPACES.         
          05 WS-FILLER3                 PIC X(01) VALUE ','.            
          05 WS-REG-BILL-STATUS         PIC X(22) VALUE SPACES.         
          05 WS-FILLER4                 PIC X(01) VALUE ','.            
          05 WS-REG-ESTIMATE-STATUS     PIC X(22) VALUE SPACES.         
      *                                                                         
       01 WS-MISC.                                                      
      *                                                                         
          05 WS-PARM-REV-MTH            PIC S9(09)V USAGE COMP.         
          05 WS-PARM-REV-MTH-N          PIC 9(06).                      
          05 WS-PARM-TEST-LIMIT-N       PIC 9(02).                      
          05 WS-COMMON-REV-MTH          PIC X(06).                      
          05 WS-REV-MTH-LST-NRML-N      PIC 9(06).                      
          05 WS-TEMP-OPTION-CD          PIC X(12).                      
          05 WS-DURATION-REMAIN-NO      PIC 9(09).                      
          05 WS-DURATION-NO             PIC S9(04) COMP.                
          05 WS-RENEWED-DUR-NO          PIC S9(04) COMP.                
          05 WS-CUST-AGE                PIC S9(04) COMP.                
          05 WS-TEST-DESCRIPTION        PIC X(50).                      
          05 WS-TEST-CASE2-DESC         PIC X(50).                      
          05 WS-ACCOUNT-NO              PIC X(13).                      
          05 WS-NEXT5-BUSINESS-CYCLE    PIC X(02).                      
          05 WS-TEMP-CYCLE-N            PIC 9(02).                      
          05 WS-BILL-STATUS             PIC X(22).                      
          05 WS-ESTIMATE-STATUS         PIC X(22).                      
          05 WS-FCA331-STATUS           PIC X(02)  VALUE SPACES.        
      ***************************************************************   01720000
      * COUNTER VARIABLES                                           *   01730000
      ***************************************************************   01740000
      *                                                                 01750000
          05 WS-TEST-CASE-CNT1          PIC 9(09) VALUE 0.              
          05 WS-TEST-CASE-CNT2          PIC 9(09) VALUE 0.              
          05 WS-DUR-2-CNT               PIC 9(09) VALUE 0.              
          05 WS-DUR-3-CNT               PIC 9(09) VALUE 0.              
          05 WS-DUR-1-CNT               PIC 9(09) VALUE 0.              
          05 WS-DUR-0-CNT               PIC 9(09) VALUE 0.              
          05 WS-DUR-10-CNT              PIC 9(09) VALUE 0.              
          05 WS-HIST-CNT                PIC 9(03) VALUE 0.              
          05 WS-CNTR                    PIC 9(09) VALUE 0.              
      *                                                                 01390000
      ***************************************************************   01860000
      * FLAG VARIABLES                                              *   01870000
      ***************************************************************   01880000
      *                                                                 01890000
          05 WS-ALL-DATA-FOUND          PIC X(01).                      
          05 WS-GRP1-SR-FLAG            PIC X(01).                      
          05 WS-FIXED-RATE-FL           PIC X(01).                      
          05 WS-RENEWED-FL              PIC X(01).                      
          05 WS-NO-DATA-FLAG            PIC X(01).                      
      *                                                                 01950000
      ***************************************************************   01960000
      * NULL INDICATOR VARIABLES                                    *   01970000
      ***************************************************************   01980000
      *                                                                 01990000
          05 WS-NULL-IND                PIC S9(04) COMP VALUE 0.        
          05 WS-NULL-IND1               PIC S9(04) COMP VALUE 0.        
      *                                                                 02020000
      ***************************************************************   01400000
      * DATE AND MONTH VARIABLES                                    *   01410001
      ***************************************************************   01420000
      *                                                                 01430000
          05 WS-12-MONTH-ANNIV          PIC X(10).                      
          05 WS-6-MONTH-ANNIV           PIC X(10).                      
          05 WS-30-DAY-ANNIV            PIC X(10).                      
          05 WS-60-DAY-ANNIV            PIC X(10).                      
          05 WS-ANNIVERSARY-DATE        PIC X(10).                      
          05 WS-MONTHLY-REMINDER-DATE   PIC X(10).                      
          05 WS-YEARLY-REMINDER-DATE    PIC X(10).                      
          05 WS-TEMP-REV-MTH.                                           
             10 WS-TEMP-REV-CCYY        PIC 9(04).                      
             10 WS-TEMP-REV-MM          PIC 9(02).                      
                                                                        
          05 WS-DT-1                    PIC X(10).                      
          05 WS-DT-2                    PIC X(10).                      
                                                                        
          05 WS-TEMP-DATE.                                              
             10 WS-TEMP-DATE-YY         PIC X(04).                      
             10 FILLER                  PIC X(01) VALUE '-'.            
             10 WS-TEMP-DATE-MM         PIC X(02).                      
             10 FILLER                  PIC X(01) VALUE '-'.            
             10 WS-TEMP-DATE-DD         PIC X(02).                      
      *                                                                         
      ***************************************************************   01660000
      * LITERALS                                                    *   01670000
      ***************************************************************   01680000
       01 WS-LITERALS.                                                  
          05 WS-TEST-CASE-LIMIT         PIC 9(09) VALUE 10.             
          05 WS-DUR-LIMIT               PIC 9(09) VALUE 2.              
      *                                                                 01710000
      ***************************************************************           
      * DE REGULATED QUERIES                                        *           
      ***************************************************************           
      *                                                                         
      ***************************************************************           
      * 1) 60 DAY + WEB(PRE-RENEWAL MESSAGE AND LETTER)             *           
      *      3 MONTHS REMAINING ON FIXED RATE                       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY01 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD          = 'A'                     
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 3                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND NOT EXISTS (SELECT 1                            
                                     FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)            
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY01 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 3                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                              FROM CSS_REG_PROFILE LR                    
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *2) NEW 30 DAY + WEB (RENEWAL MESSAGE AND LETTER) W/BBP IN SYNC*          
      *   2 MONTHS REMAIN ON FIXED RATE WITH BBP IN SYNC             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY02 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND BU.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD          = 'A'                     
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :WS-60-DAY-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :WS-60-DAY-ANNIV
              ) <> 0) OR (LEN(:WS-60-DAY-ANNIV) <> 10), CIS.CHAR2DATE(
                                                       :WS-60-DAY-ANNIV
              ), CONVERT(DATE, :WS-60-DAY-ANNIV) )          
                    AND AT.BILL_CYCLE       = :AT-BILL-CYCLE            
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY02 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND BU.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE = :WS-60-DAY-ANNIV                  
MFA-TR*             AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                    
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *3)NEW 30 DAY + WEB (RENEWAL MESSAGE AND LETTER) W/BBP OUT OF SYNC        
      *   2 MONTHS REMAIN ON FIXED RATE WITH BBP NOT IN SYNC                    
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY03 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND BU.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD          = 'A'                     
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE   > IIF(TRY_CONVERT(DATE, 
                                                       :WS-60-DAY-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :WS-60-DAY-ANNIV
              ) <> 0) OR (LEN(:WS-60-DAY-ANNIV) <> 10), CIS.CHAR2DATE(
                                                       :WS-60-DAY-ANNIV
              ), CONVERT(DATE, :WS-60-DAY-ANNIV) )        
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY03 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND BU.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE   > :WS-60-DAY-ANNIV                
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7090                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *4) NEW 30 DAY + WEB (RENEWAL MESSAGE AND LETTER) W/OUT BBP   *           
      *   2 MONTHS REMAINING ON FIXED RATE WITH NO BBP              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY04 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD          = 'A'                     
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY04 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *5) 1 MONTH REMAINING ON FIXED RATE - RENEWAL REMINDER MESSAGE   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY05 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD         IN ('O','A')               
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 1                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY05 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD         IN ('O','A')                       
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 1                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *6) 1 MONTH REMAINING ON FIXED RATE AND PENDING OPTION ESTABLISHED        
      *   PENDING RENEWAL MESSAGE                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY06 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD         IN ('R')                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 1                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY06 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD         IN ('R')                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 1                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7180                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *07) LAST MONTH ON CURRENT FIXED RATE - RENEWAL MESSAGE          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY07 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                  WHERE AT.ACCOUNT_NO       = DF.ACCOUNT_NO             
                    AND UT.ACCOUNT_NO       = AT.ACCOUNT_NO             
                    AND AT.CODE_ACCT_STAT   = 'A'                       
                    AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML      
                    AND DF.STATUS_CD        = 'R'                       
                    AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH        
                    AND EXISTS (                                        
                 SELECT 1                                               
                   FROM CSS_ACCT_RTPK_AGR DF1 WITH(READUNCOMMITTED)             
                  WHERE DF1.STATUS_CD = 'A'                             
                    AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00      
                    AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH       
                               )                                        
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY07 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE AT.ACCOUNT_NO       = DF.ACCOUNT_NO                     
MFA-TR*             AND UT.ACCOUNT_NO       = AT.ACCOUNT_NO                     
MFA-TR*             AND AT.CODE_ACCT_STAT   = 'A'                               
MFA-TR*             AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML              
MFA-TR*             AND DF.STATUS_CD        = 'R'                               
MFA-TR*             AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                
MFA-TR*             AND EXISTS (                                                
MFA-TR*          SELECT 1                                                       
MFA-TR*            FROM CSS_ACCT_RTPK_AGR DF1                                   
MFA-TR*           WHERE DF1.STATUS_CD = 'A'                                     
MFA-TR*             AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00              
MFA-TR*             AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH               
MFA-TR*                        )                                                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *08) LAST MONTH ON CURRENT FIXED RATE - DROP MESSAGE             *        
      *    WITH BBP IN SYNC                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY08 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT   = 'A'                       
                    AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML      
                    AND DF.STATUS_CD        = 'O'                       
                    AND FI.OPTION_CD        = DF.OPTION_CD              
                    AND FI.OPT_CALC_TYPE_CD = 'FP'                      
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD        = FI.OPTION_CD              
                    AND HQ.DURATION_NO      = :WS-DURATION-NO           
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO     
                    AND FF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO     
                    AND FF.FACTOR_ID         = HQ.FACTOR_ID             
                    AND FF.DURATION_REMAIN_NO = 0                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE   = IIF(TRY_CONVERT(DATE, 
                                                   :WS-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:WS-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ANNIVERSARY-DATE
              ), CONVERT(DATE, :WS-ANNIVERSARY-DATE) )    
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY08 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT   = 'A'                               
MFA-TR*             AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML              
MFA-TR*             AND DF.STATUS_CD        = 'O'                               
MFA-TR*             AND FI.OPTION_CD        = DF.OPTION_CD                      
MFA-TR*             AND FI.OPT_CALC_TYPE_CD = 'FP'                              
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD        = FI.OPTION_CD                      
MFA-TR*             AND HQ.DURATION_NO      = :WS-DURATION-NO                   
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.FACTOR_ID         = HQ.FACTOR_ID                     
MFA-TR*             AND FF.DURATION_REMAIN_NO = 0                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE   = :WS-ANNIVERSARY-DATE            
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *09) LAST MONTH ON CURRENT FIXED RATE - DROP MESSAGE             *        
      *    WITH BBP OUT OF SYNC                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY09 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT   = 'A'                       
                    AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML      
                    AND DF.STATUS_CD        = 'O'                       
                    AND FI.OPTION_CD        = DF.OPTION_CD              
                    AND FI.OPT_CALC_TYPE_CD = 'FP'                      
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD        = FI.OPTION_CD              
                    AND HQ.DURATION_NO      = :WS-DURATION-NO           
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO     
                    AND FF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO     
                    AND FF.FACTOR_ID         = HQ.FACTOR_ID             
                    AND FF.DURATION_REMAIN_NO = 0                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE   > IIF(TRY_CONVERT(DATE, 
                                                   :WS-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:WS-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ANNIVERSARY-DATE
              ), CONVERT(DATE, :WS-ANNIVERSARY-DATE) )    
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY09 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT   = 'A'                               
MFA-TR*             AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML              
MFA-TR*             AND DF.STATUS_CD        = 'O'                               
MFA-TR*             AND FI.OPTION_CD        = DF.OPTION_CD                      
MFA-TR*             AND FI.OPT_CALC_TYPE_CD = 'FP'                              
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD        = FI.OPTION_CD                      
MFA-TR*             AND HQ.DURATION_NO      = :WS-DURATION-NO                   
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.FACTOR_ID         = HQ.FACTOR_ID                     
MFA-TR*             AND FF.DURATION_REMAIN_NO = 0                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE   > :WS-ANNIVERSARY-DATE            
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7240                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *10) LAST MONTH ON CURRENT FIXED RATE - DROP MESSAGE             *        
      *    WITH OUT BBP                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
         DECLARE DREG_QRY10 CURSOR FOR                                  
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'O'                     
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 0                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*  DECLARE DREG_QRY10 CURSOR FOR                                          
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'O'                             
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 0                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7270                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *11) A. FREE CSC MESSAGE                                         *        
      *    B. DISPERSED CREDIT MESSAGE                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY11 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,FF.DURATION_REMAIN_NO                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                 WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                    
                   AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                    
                   AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                    
                   AND AT.CODE_ACCT_STAT     = 'A'                      
                   AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML     
                   AND DF.STATUS_CD          = 'A'                      
                   AND FI.OPTION_CD          = DF.OPTION_CD             
                   AND FI.OPT_CALC_TYPE_CD   = 'FP'                     
                   AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()       
                   AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()       
                   AND FI.PROC_STATUS_CD      = 'AC'                    
                   AND HQ.OPTION_CD          = FI.OPTION_CD             
                   AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'            
                   AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()       
                   AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()       
                   AND HQ.PROC_STATUS_CD      = 'AC'                    
                   AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO     
                   AND FF.FACTOR_ID          = HQ.FACTOR_ID             
                   AND FF.DURATION_REMAIN_NO >= 0                       
                   AND NOT EXISTS (SELECT 1                             
                                     FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)            
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                   AND EXISTS ( SELECT 1                                
                                  FROM CSS_FIXED_FCTR FF1
                           WITH(READUNCOMMITTED)               
                                 WHERE FF1.ACCOUNT_NO = AT.ACCOUNT_NO   
                                   AND FF1.FACTOR_ID = :FF-FACTOR-ID    
                                   AND FF1.DURATION_REMAIN_NO = 2       
                              )                                         
                   AND AT.BILL_CYCLE = :AT-BILL-CYCLE                   
                 ORDER BY AT.ACCOUNT_NO DESC                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY11 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*          WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                            
MFA-TR*            AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                            
MFA-TR*            AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                            
MFA-TR*            AND AT.CODE_ACCT_STAT     = 'A'                              
MFA-TR*            AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML             
MFA-TR*            AND DF.STATUS_CD          = 'A'                              
MFA-TR*            AND FI.OPTION_CD          = DF.OPTION_CD                     
MFA-TR*            AND FI.OPT_CALC_TYPE_CD   = 'FP'                             
MFA-TR*            AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP               
MFA-TR*            AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP               
MFA-TR*            AND FI.PROC_STATUS_CD      = 'AC'                            
MFA-TR*            AND HQ.OPTION_CD          = FI.OPTION_CD                     
MFA-TR*            AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                    
MFA-TR*            AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP               
MFA-TR*            AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP               
MFA-TR*            AND HQ.PROC_STATUS_CD      = 'AC'                            
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO             
MFA-TR*            AND FF.FACTOR_ID          = HQ.FACTOR_ID                     
MFA-TR*            AND FF.DURATION_REMAIN_NO >= 0                               
MFA-TR*            AND NOT EXISTS (SELECT 1                                     
MFA-TR*                              FROM CSS_REG_PROFILE LR                    
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*            AND EXISTS ( SELECT 1                                        
MFA-TR*                           FROM CSS_FIXED_FCTR FF1                       
MFA-TR*                          WHERE FF1.ACCOUNT_NO = AT.ACCOUNT_NO           
MFA-TR*                            AND FF1.FACTOR_ID = :FF-FACTOR-ID            
MFA-TR*                            AND FF1.DURATION_REMAIN_NO = 2               
MFA-TR*                       )                                                 
MFA-TR*            AND AT.BILL_CYCLE = :AT-BILL-CYCLE                           
MFA-TR*          ORDER BY AT.ACCOUNT_NO DESC                                    
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7430                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *12) RENEWED ON LAST MONTH ( BBP IN SYNC )                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY12 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'R'                     
                    AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH        
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.DURATION_NO        = :WS-DURATION-NO         
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND EXISTS (                                        
                 SELECT 1                                               
                   FROM CSS_ACCT_RTPK_AGR DF1 WITH(READUNCOMMITTED)             
                  WHERE DF1.STATUS_CD = 'A'                             
                    AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00      
                    AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH       
                                )                                       
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE = IIF(TRY_CONVERT(DATE, 
                                                   :WS-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:WS-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ANNIVERSARY-DATE
              ), CONVERT(DATE, :WS-ANNIVERSARY-DATE) )      
                    AND AT.BILL_CYCLE       = :AT-BILL-CYCLE            
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY12 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'R'                             
MFA-TR*             AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.DURATION_NO        = :WS-DURATION-NO                 
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND EXISTS (                                                
MFA-TR*          SELECT 1                                                       
MFA-TR*            FROM CSS_ACCT_RTPK_AGR DF1                                   
MFA-TR*           WHERE DF1.STATUS_CD = 'A'                                     
MFA-TR*             AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00              
MFA-TR*             AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH               
MFA-TR*                         )                                               
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE = :WS-ANNIVERSARY-DATE              
MFA-TR*             AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                    
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7330                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *13) RENEWED ON LAST MONTH ( BBP OUT OF SYNC )                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY13 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'R'                     
                    AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH        
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.DURATION_NO        = :WS-DURATION-NO         
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND EXISTS (                                        
                 SELECT 1                                               
                   FROM CSS_ACCT_RTPK_AGR DF1 WITH(READUNCOMMITTED)             
                  WHERE DF1.STATUS_CD = 'A'                             
                    AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00      
                    AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH       
                                )                                       
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND BU.ANNIVERSARY_DATE > IIF(TRY_CONVERT(DATE, 
                                                   :WS-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:WS-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ANNIVERSARY-DATE
              ), CONVERT(DATE, :WS-ANNIVERSARY-DATE) )      
                    AND AT.BILL_CYCLE       = :AT-BILL-CYCLE            
                   ORDER BY AT.ACCOUNT_NO DESC                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY13 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'R'                             
MFA-TR*             AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.DURATION_NO        = :WS-DURATION-NO                 
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND EXISTS (                                                
MFA-TR*          SELECT 1                                                       
MFA-TR*            FROM CSS_ACCT_RTPK_AGR DF1                                   
MFA-TR*           WHERE DF1.STATUS_CD = 'A'                                     
MFA-TR*             AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00              
MFA-TR*             AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH               
MFA-TR*                         )                                               
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND BU.ANNIVERSARY_DATE > :WS-ANNIVERSARY-DATE              
MFA-TR*             AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                    
MFA-TR*            ORDER BY AT.ACCOUNT_NO DESC                                  
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7370                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *14) RENEWED ON LAST MONTH ( WITH OUT BBP )                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DREG_QRY14 CURSOR FOR                             
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'R'                     
                    AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH        
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.DURATION_NO        = :WS-DURATION-NO         
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND EXISTS (                                        
                 SELECT 1                                               
                   FROM CSS_ACCT_RTPK_AGR DF1 WITH(READUNCOMMITTED)             
                  WHERE DF1.STATUS_CD = 'A'                             
                    AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00      
                    AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH       
                                )                                       
                    AND NOT EXISTS (SELECT 1                            
                                      FROM CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)           
                                    WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)
                    AND AT.BILL_CYCLE       = :AT-BILL-CYCLE            
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DREG_QRY14 CURSOR FOR                                     
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'R'                             
MFA-TR*             AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.DURATION_NO        = :WS-DURATION-NO                 
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND EXISTS (                                                
MFA-TR*          SELECT 1                                                       
MFA-TR*            FROM CSS_ACCT_RTPK_AGR DF1                                   
MFA-TR*           WHERE DF1.STATUS_CD = 'A'                                     
MFA-TR*             AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00              
MFA-TR*             AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH               
MFA-TR*                         )                                               
MFA-TR*             AND NOT EXISTS (SELECT 1                                    
MFA-TR*                               FROM CSS_REG_PROFILE LR                   
MFA-TR*                             WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO)        
MFA-TR*             AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                    
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * REGULATED QUERIES                                              *        
      ******************************************************************        
      *                                                                *        
      ******************************************************************        
      *01) REGULATED 60 DAY (PRE-RENEWAL MESSAGE AND LETTER)           *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 SR $1.95 CSC     OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY01 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = LR.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'A'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 3                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY01 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = LR.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 3                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7460                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *02) REGULATED ACCT WITH BBP - NEW 30 DAY (RENEWAL MSG AND LETTER)        
      *  BBP AND FIXED RATE IN SYNC                                    *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY02 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'A'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND BU.ANNIVERSARY_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :WS-60-DAY-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :WS-60-DAY-ANNIV
              ) <> 0) OR (LEN(:WS-60-DAY-ANNIV) <> 10), CIS.CHAR2DATE(
                                                       :WS-60-DAY-ANNIV
              ), CONVERT(DATE, :WS-60-DAY-ANNIV) )          
                    AND AT.BILL_CYCLE       = :AT-BILL-CYCLE            
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY02 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND BU.ANNIVERSARY_DATE = :WS-60-DAY-ANNIV                  
MFA-TR*             AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                    
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7490                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *03) REGULATED ACCT WITH BBP - NEW 30 DAY (RENEWAL MSG AND LETTER)        
      *    BBP AND FIXED RATE OUT OF SYNC                              *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY03 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'A'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND BU.ANNIVERSARY_DATE > IIF(TRY_CONVERT(DATE, 
                                                       :WS-60-DAY-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :WS-60-DAY-ANNIV
              ) <> 0) OR (LEN(:WS-60-DAY-ANNIV) <> 10), CIS.CHAR2DATE(
                                                       :WS-60-DAY-ANNIV
              ), CONVERT(DATE, :WS-60-DAY-ANNIV) )          
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY03 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_BUDGET_PLAN BU                                      
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND BU.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND BU.ANNIVERSARY_DATE > :WS-60-DAY-ANNIV                  
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7520                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *04) REGULATED ACCT WITH BBP - NEW 30 DAY (RENEWAL MSG AND LETTER)        
      *    WITH OUT BBP                                                *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY04 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'A'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 2                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY04 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'A'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 2                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *5) 1 MONTH REMAINING ON FIXED RATE  - RENEWAL REMINDER MESSAGE  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY05 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = LR.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND DF.STATUS_CD          = 'O'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 1                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY05 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = LR.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND DF.STATUS_CD          = 'O'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 1                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7580                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *06) LAST MONTH ON CURRENT FIXED RATE - RENEWAL MESSAGE          *        
      *    WITH OUT BBP                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY06 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = LR.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT = 'A'                         
                    AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML      
                    AND DF.STATUS_CD      = 'R'                         
                    AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH        
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND EXISTS (                                        
                 SELECT 1                                               
                   FROM CSS_ACCT_RTPK_AGR DF1 WITH(READUNCOMMITTED)             
                  WHERE DF1.STATUS_CD = 'A'                             
                    AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00      
                    AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH       
                                )                                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY06 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = LR.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML              
MFA-TR*             AND DF.STATUS_CD      = 'R'                                 
MFA-TR*             AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND EXISTS (                                                
MFA-TR*          SELECT 1                                                       
MFA-TR*            FROM CSS_ACCT_RTPK_AGR DF1                                   
MFA-TR*           WHERE DF1.STATUS_CD = 'A'                                     
MFA-TR*             AND DF1.OPT_AGRMT_EFF_DT > AT.DATE_BILL_DAY_00              
MFA-TR*             AND DF1.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH               
MFA-TR*                         )                                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7640                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *07) LAST MONTH ON CURRENT FIXED RATE - DROP MESSAGE             *        
      *    WITH OUT BBP                                                *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY07 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'O'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 0                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY07 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'O'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 0                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7670                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *08) LAST MONTH ON CURRENT FIXED RATE - DROP MESSAGE             *        
      *    WITH BBP                                                    *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG301C02XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG307C02XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG309C02XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG305C02XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY08 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                   
                    AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                   
                    AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND DF.STATUS_CD          = 'O'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 0                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) = 'A'         
                    AND AT.BILL_CYCLE         = :AT-BILL-CYCLE          
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY08 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = DF.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = FF.ACCOUNT_NO                           
MFA-TR*             AND LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND DF.STATUS_CD          = 'O'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 0                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) = 'A'                 
MFA-TR*             AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                  
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *09) VARIABLE RATE CUSTOMERS                                     *        
      *                                                                *        
      * A. GRP 1 $3.95 CSC        OPTION_CD = RG101C01XXXX             *        
      * B. GRP 1 $1.95 CSC        OPTION_CD = RG107C01XXXX             *        
      * C. GRP 2 $9.95 CSC        OPTION_CD = RG109C01XXXX             *        
      * D. GRP 2 $6.95 CSC        OPTION_CD = RG105C01XXXX             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY09 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE AT.ACCOUNT_NO     = DF.ACCOUNT_NO                
                   AND UT.ACCOUNT_NO     = AT.ACCOUNT_NO                
                   AND DF.STATUS_CD      = 'A'                          
                   AND DF.OPTION_CD      = :WS-TEMP-OPTION-CD           
                   AND AT.CODE_ACCT_STAT = 'A'                          
                   AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML       
                   AND AT.BILL_CYCLE       = :AT-BILL-CYCLE             
                 ORDER BY AT.ACCOUNT_NO DESC                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY09 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*          WHERE AT.ACCOUNT_NO     = DF.ACCOUNT_NO                        
MFA-TR*            AND UT.ACCOUNT_NO     = AT.ACCOUNT_NO                        
MFA-TR*            AND DF.STATUS_CD      = 'A'                                  
MFA-TR*            AND DF.OPTION_CD      = :WS-TEMP-OPTION-CD                   
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND AT.REV_MTH_LST_NRML = :AT-REV-MTH-LST-NRML               
MFA-TR*            AND AT.BILL_CYCLE       = :AT-BILL-CYCLE                     
MFA-TR*          ORDER BY AT.ACCOUNT_NO DESC                                    
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *10) 1 MONTH REMAINING ON FIXED RATE  - PENDING RENEWAL MESSAGE  *        
      *    PENDING OPTION ESTABLISHED                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY10 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,DF.OPTION_CD                                    
                       ,UT.GAS_BASE_LAST_UPDT                           
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)              
                       ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO           
                    AND AT.ACCOUNT_NO         = LR.ACCOUNT_NO           
                    AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO           
                    AND DF.STATUS_CD          = 'R'                     
                    AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD      
                    AND AT.CODE_ACCT_STAT     = 'A'                     
                    AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML    
                    AND FI.OPTION_CD          = DF.OPTION_CD            
                    AND FI.OPT_CALC_TYPE_CD   = 'FP'                    
                    AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()      
                    AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()      
                    AND FI.PROC_STATUS_CD      = 'AC'                   
                    AND HQ.OPTION_CD          = FI.OPTION_CD            
                    AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'           
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()      
                    AND HQ.PROC_STATUS_CD      = 'AC'                   
                    AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO    
                    AND FF.FACTOR_ID          = HQ.FACTOR_ID            
                    AND FF.DURATION_REMAIN_NO = 1                       
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1) <> 'A'        
                    AND AT.BILL_CYCLE = :AT-BILL-CYCLE                  
                  ORDER BY AT.ACCOUNT_NO DESC                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY10 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,UT.GAS_BASE_LAST_UPDT                                   
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CRM_RT_PKG_OPTION FI                                    
MFA-TR*                ,CRM_OPT_ATTR_INCTV HQ                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = DF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                   
MFA-TR*             AND AT.ACCOUNT_NO         = LR.ACCOUNT_NO                   
MFA-TR*             AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                   
MFA-TR*             AND DF.STATUS_CD          = 'R'                             
MFA-TR*             AND DF.OPTION_CD          = :WS-TEMP-OPTION-CD              
MFA-TR*             AND AT.CODE_ACCT_STAT     = 'A'                             
MFA-TR*             AND AT.REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML            
MFA-TR*             AND FI.OPTION_CD          = DF.OPTION_CD                    
MFA-TR*             AND FI.OPT_CALC_TYPE_CD   = 'FP'                            
MFA-TR*             AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP              
MFA-TR*             AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP              
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND HQ.OPTION_CD          = FI.OPTION_CD                    
MFA-TR*             AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                   
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP              
MFA-TR*             AND HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO            
MFA-TR*             AND FF.FACTOR_ID          = HQ.FACTOR_ID                    
MFA-TR*             AND FF.DURATION_REMAIN_NO = 1                               
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,3,1) <> 'A'                
MFA-TR*             AND AT.BILL_CYCLE = :AT-BILL-CYCLE                          
MFA-TR*           ORDER BY AT.ACCOUNT_NO DESC                                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7610                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *11) GROUP 2 NON DHR QUALIFIED CUSTOMERS                         *        
      *   MONTHLY AND YEARLY REMINDER LETTERS FOR THE LOW RATE CUSTOMERS        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY11 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
                       ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
                  WHERE AT.CODE_ACCT_STAT      = 'A'                    
                    AND AT.BILL_CYCLE          = :AT-BILL-CYCLE         
                    AND AT.ACCOUNT_NO          = UT.ACCOUNT_NO          
                    AND UT.CODE_UTIL_TYPE      = 'G'                    
                    AND UT.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE      
                    AND UT.RATE_PLAN_NO        = RD.RATE_PLAN_NO        
                    AND UT.GAS_BASE_LAST_UPDT  = IIF(TRY_CONVERT(DATE, 
                                                 :UT-GAS-BASE-LAST-UPDT
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT) ) 
                    AND RD.MKT_PROGRAM_CD IN ('2L')                     
                    AND RD.REG_GROUP_CD      = '200'                    
                    AND CU.CUSTOMER_NO       = AT.CUSTOMER_NO           
                    AND CU.DHR_FL           <> 'Y'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY11 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                                   
MFA-TR*                ,CSS_CUSTOMER CU                                         
MFA-TR*           WHERE AT.CODE_ACCT_STAT      = 'A'                            
MFA-TR*             AND AT.BILL_CYCLE          = :AT-BILL-CYCLE                 
MFA-TR*             AND AT.ACCOUNT_NO          = UT.ACCOUNT_NO                  
MFA-TR*             AND UT.CODE_UTIL_TYPE      = 'G'                            
MFA-TR*             AND UT.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE              
MFA-TR*             AND UT.RATE_PLAN_NO        = RD.RATE_PLAN_NO                
MFA-TR*             AND UT.GAS_BASE_LAST_UPDT  = :UT-GAS-BASE-LAST-UPDT         
MFA-TR*             AND RD.MKT_PROGRAM_CD IN ('2L')                             
MFA-TR*             AND RD.REG_GROUP_CD      = '200'                            
MFA-TR*             AND CU.CUSTOMER_NO       = AT.CUSTOMER_NO                   
MFA-TR*             AND CU.DHR_FL           <> 'Y'                              
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7730                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *12) GROUP 2 NON DHR QUALIFIED CUSTOMERS                         *        
      *    INITIAL OPTION LETTER FOR THE HIGH RATE CUSTOMERS           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_QRY12 CURSOR FOR                              
                 SELECT AT.ACCOUNT_NO                                   
                       ,UT.IC_NO                                        
                       ,AT.CODE_ACCT_BILLED                             
                       ,UT.CODE_ESTIMATE_OK                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
                       ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
                  WHERE AT.CODE_ACCT_STAT      = 'A'                    
                    AND AT.BILL_CYCLE         = :WS-NEXT5-BUSINESS-CYCLE
                    AND AT.ACCOUNT_NO          = UT.ACCOUNT_NO          
                    AND UT.CODE_UTIL_TYPE      = 'G'                    
                    AND UT.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE      
                    AND UT.RATE_PLAN_NO        = RD.RATE_PLAN_NO        
                    AND UT.GAS_BASE_LAST_UPDT  IS NULL                  
                    AND RD.MKT_PROGRAM_CD IN ('2L','2H')                
                    AND RD.REG_GROUP_CD      = '200'                    
                    AND CU.CUSTOMER_NO       = AT.CUSTOMER_NO           
                    AND CU.DHR_FL           <> 'Y'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_QRY12 CURSOR FOR                                      
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,UT.IC_NO                                                
MFA-TR*                ,AT.CODE_ACCT_BILLED                                     
MFA-TR*                ,UT.CODE_ESTIMATE_OK                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                                   
MFA-TR*                ,CSS_CUSTOMER CU                                         
MFA-TR*           WHERE AT.CODE_ACCT_STAT      = 'A'                            
MFA-TR*             AND AT.BILL_CYCLE         = :WS-NEXT5-BUSINESS-CYCLE        
MFA-TR*             AND AT.ACCOUNT_NO          = UT.ACCOUNT_NO                  
MFA-TR*             AND UT.CODE_UTIL_TYPE      = 'G'                            
MFA-TR*             AND UT.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE              
MFA-TR*             AND UT.RATE_PLAN_NO        = RD.RATE_PLAN_NO                
MFA-TR*             AND UT.GAS_BASE_LAST_UPDT  IS NULL                          
MFA-TR*             AND RD.MKT_PROGRAM_CD IN ('2L','2H')                        
MFA-TR*             AND RD.REG_GROUP_CD      = '200'                            
MFA-TR*             AND CU.CUSTOMER_NO       = AT.CUSTOMER_NO                   
MFA-TR*             AND CU.DHR_FL           <> 'Y'                              
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7770                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-LENGTH                PIC S9(04) COMP.                   
       01 PARM-BILL-CYCL             PIC X(02).                         
       01 PARM-REV-MTH               PIC X(06).                         
       01 PARM-TEST-LIMIT            PIC X(02).                         
      *                                                                         
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION USING PARM-LENGTH,                            
                                PARM-BILL-CYCL,                         
                                PARM-REV-MTH,                           
                                PARM-TEST-LIMIT.                        
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2040-DREG-QUERIES                THRU  2040-EXIT.    
           PERFORM 2070-REG-QUERIES                 THRU  2070-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
      *                                                                         
      *WRITE THE HEADER RECORD                                                  
           WRITE PRT33-RECORD  FROM WS-RP77-HDR-REC.                    
           WRITE PRT331-RECORD FROM WS-RP77-HDR-REC.                    
      *                                                                         
      *INITIALIZE THE FILE VARAIABLES AFTER WRITING THE HEADER RECORD           
           INITIALIZE PRT33-RECORD.                                     
           INITIALIZE PRT331-RECORD.                                    
      *                                                                         
           PERFORM 2000-GET-PARM-DATA               THRU 2000-EXIT.     
           PERFORM 2010-CALC-DATA                   THRU 2010-EXIT.     
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-GET-PARM-DATA.                                          **        
      ******************************************************************        
      *                                                                         
       2000-GET-PARM-DATA.                                              
      *                                                                         
           IF PARM-BILL-CYCL > SPACES AND PARM-REV-MTH > SPACES AND     
              PARM-TEST-LIMIT > SPACES                                  
              MOVE PARM-BILL-CYCL         TO AT-BILL-CYCLE              
              MOVE PARM-REV-MTH           TO WS-PARM-REV-MTH-N          
              MOVE PARM-TEST-LIMIT        TO WS-PARM-TEST-LIMIT-N       
              MOVE WS-PARM-REV-MTH-N      TO WS-PARM-REV-MTH            
              MOVE WS-PARM-TEST-LIMIT-N   TO WS-TEST-CASE-LIMIT         
           ELSE                                                         
              PERFORM 7000-GET-REV-MTH              THRU 7000-EXIT      
              DISPLAY 'WS-COMMON-REV-MTH = ' WS-COMMON-REV-MTH          
              MOVE WS-COMMON-REV-MTH      TO WS-PARM-REV-MTH-N          
              MOVE WS-PARM-REV-MTH-N      TO WS-PARM-REV-MTH            
              PERFORM 7010-GET-BILL-CYCLE           THRU 7010-EXIT      
              DISPLAY 'BN-BILL-CYCLE = ' BN-BILL-CYCLE                  
              MOVE BN-BILL-CYCLE          TO AT-BILL-CYCLE              
              MOVE WS-TEST-CASE-LIMIT     TO WS-PARM-TEST-LIMIT-N       
           END-IF.                                                      
                                                                        
           DISPLAY ' PARM BILL CYCLE : ' AT-BILL-CYCLE.                 
           DISPLAY ' PARM REV MONTH  : ' WS-PARM-REV-MTH-N.             
           DISPLAY ' PARM TEST ACCT LIMIT : ' WS-PARM-TEST-LIMIT-N.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2010-CALC-DATA                                               **        
      ** CALCULATE ALL THE REQUIRED DATES AND REVENUE MONTH VALUES    **        
      ******************************************************************        
      *                                                                         
       2010-CALC-DATA.                                                  
      *                                                                         
      *** FIND LAST REVENUE MONTH NORMAL                                        
           MOVE WS-PARM-REV-MTH-N         TO WS-TEMP-REV-MTH.           
           PERFORM 2020-STEP-DOWN-MONTH             THRU 2020-EXIT.     
           MOVE WS-TEMP-REV-MTH           TO WS-REV-MTH-LST-NRML-N.     
           MOVE WS-REV-MTH-LST-NRML-N     TO AT-REV-MTH-LST-NRML.       
                                                                        
      *** SET 12 MONTH ANNIVERSARY DATE VALUE                                   
           MOVE WS-REV-MTH-LST-NRML-N     TO WS-TEMP-REV-MTH.           
           COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY + 1.             
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
           MOVE WS-TEMP-DATE              TO WS-12-MONTH-ANNIV.         
                                                                        
      *** SET 6 MONTH ANNIVERSARY DATE VALUE                                    
           MOVE WS-REV-MTH-LST-NRML-N     TO WS-TEMP-REV-MTH.           
           MOVE WS-ONE-N                  TO WS-CNTR                    
           PERFORM UNTIL WS-CNTR >= 7                                   
             PERFORM 2030-STEP-UP-MONTH             THRU 2030-EXIT      
             COMPUTE WS-CNTR = WS-CNTR + 1                              
           END-PERFORM.                                                 
                                                                        
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
           MOVE WS-TEMP-DATE              TO WS-6-MONTH-ANNIV.          
                                                                        
      *** SET 30 DAY ANNIVERSARY DATE VALUE                                     
           MOVE WS-PARM-REV-MTH-N         TO WS-TEMP-REV-MTH.           
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
           MOVE WS-TEMP-DATE              TO WS-30-DAY-ANNIV.           
                                                                        
      *** SET 60 DAY ANNIVERSARY DATE VALUE                                     
           MOVE WS-PARM-REV-MTH-N         TO WS-TEMP-REV-MTH.           
           PERFORM 2030-STEP-UP-MONTH               THRU 2030-EXIT      
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
           MOVE WS-TEMP-DATE              TO WS-60-DAY-ANNIV.           
                                                                        
           DISPLAY 'AT-REV-MTH-LST-NRML ' WS-REV-MTH-LST-NRML-N.        
           DISPLAY 'WS-12-MONTH-ANNIV  '  WS-12-MONTH-ANNIV.            
           DISPLAY 'WS-6-MONTH-ANNIV   '  WS-6-MONTH-ANNIV.             
           DISPLAY 'WS-30-DAY-ANNIV '     WS-30-DAY-ANNIV.              
           DISPLAY 'WS-60-DAY-ANNIV '     WS-60-DAY-ANNIV.              
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2020-STEP-DOWN-MONTH.                                        **        
      ******************************************************************        
      *                                                                         
       2020-STEP-DOWN-MONTH.                                            
      *                                                                         
           COMPUTE WS-TEMP-REV-MM = WS-TEMP-REV-MM - 1.                 
           IF WS-TEMP-REV-MM = 0                                        
              COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY - 1           
              MOVE 12                     TO  WS-TEMP-REV-MM            
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2030-STEP-UP-MONTH                                           **        
      ******************************************************************        
      *                                                                         
       2030-STEP-UP-MONTH.                                              
      *                                                                         
           COMPUTE WS-TEMP-REV-MM = WS-TEMP-REV-MM + 1.                 
           IF WS-TEMP-REV-MM > 12                                       
              COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY + 1           
              MOVE WS-ONE-N               TO  WS-TEMP-REV-MM            
           END-IF.                                                      
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2040-DREG-QUERIES                                            **        
      ******************************************************************        
      *                                                                         
       2040-DREG-QUERIES.                                               
      *                                                                         
           PERFORM 2045-DREG-60DAY-LETTER           THRU 2045-EXIT.     
           PERFORM 2050-DREG-30DAY-LETTER           THRU 2050-EXIT.     
           PERFORM 2055-DREG-1MONTH-MESSAGE         THRU 2055-EXIT.     
           PERFORM 2060-DREG-ON-LAST-MONTH          THRU 2060-EXIT.     
           PERFORM 2065-DREG-CREDIT-MESSAGE         THRU 2065-EXIT.     
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2045-DREG-60DAY-LETTER                                       **        
      * DE-REGULATED-PROCESS 60 DAY +(PRE-RENEWAL MESSAGES AND LETTER) *        
      ******************************************************************        
      *                                                                         
       2045-DREG-60DAY-LETTER.                                          
      *                                                                         
           MOVE 'DE-REG - 60 DAY PRE RENEWAL MSG AND LETTER'            
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7020-OPEN-DREG-QRY01-CSR         THRU 7020-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7030-FETCH-DREG-QRY01-CSR     THRU 7030-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7040-CLOSE-DREG-QRY01-CSR        THRU 7040-EXIT.     
      *                                                                         
       2045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-DREG-30DAY-LETTER                                       **        
      * DE-REGULATED - PROCESS 30 DAY +(PRE-RENEWAL MESSAGES AND LETTER)        
      ******************************************************************        
      *                                                                         
       2050-DREG-30DAY-LETTER.                                          
      *                                                                         
           PERFORM 2051-DREG-30DAY-BBP-IN-SYNC      THRU 2051-EXIT.     
           PERFORM 2052-DREG-30DAY-BBP-OUT-SYNC     THRU 2052-EXIT.     
           PERFORM 2053-DREG-30DAY-WITH-OUT-BBP     THRU 2053-EXIT.     
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2051-DREG-30DAY-BBP-IN-SYNC.                                 **        
      * DREG - 30 DAY RENEWAL MSG WITH BBP IN SYNC                     *        
      ******************************************************************        
      *                                                                         
       2051-DREG-30DAY-BBP-IN-SYNC.                                     
      *                                                                         
           MOVE 'DE-REG 30 DAY LETTER - BBP IN SYNC'                    
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7050-OPEN-DREG-QRY02-CSR         THRU 7050-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7060-FETCH-DREG-QRY02-CSR     THRU 7060-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7070-CLOSE-DREG-QRY02-CSR        THRU 7070-EXIT.     
      *                                                                         
       2051-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2052-DREG-30DAY-BBP-OUT-SYNC.                                **        
      * DREG - 30 DAY RENEWAL MSG WITH BBP OUT OF SYNC                 *        
      ******************************************************************        
      *                                                                         
       2052-DREG-30DAY-BBP-OUT-SYNC.                                    
      *                                                                         
           MOVE 'DE-REG 30 DAY LETTER - BBP NOT IN SYNC'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7080-OPEN-DREG-QRY03-CSR         THRU 7080-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7090-FETCH-DREG-QRY03-CSR     THRU 7090-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7100-CLOSE-DREG-QRY03-CSR        THRU 7100-EXIT.     
      *                                                                         
       2052-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2053-DREG-30DAY-BBP-IN-SYNC.                                 **        
      * DREG - 30 DAY RENEWAL MSG WITH OUT BBP                         *        
      ******************************************************************        
      *                                                                         
       2053-DREG-30DAY-WITH-OUT-BBP.                                    
      *                                                                         
           MOVE 'DE-REG 30 DAY LETTER - WITH OUT BBP'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7110-OPEN-DREG-QRY04-CSR         THRU 7110-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7120-FETCH-DREG-QRY04-CSR     THRU 7120-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7130-CLOSE-DREG-QRY04-CSR        THRU 7130-EXIT.     
      *                                                                         
       2053-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2055-DREG-1MONTH-MESSAGE.                                    **        
      * DE-REGULATED - 1 MONTH REMAINS ON FIXED RATE                   *        
      ******************************************************************        
      *                                                                         
       2055-DREG-1MONTH-MESSAGE.                                        
      *                                                                         
            PERFORM 2056-DREG-RENWAL-REMINDER       THRU 2056-EXIT.     
            PERFORM 2057-DREG-PENDING-RENEWAL       THRU 2057-EXIT.     
      *                                                                         
       2055-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * DREG - 1 MONTH RENEWAL REMINDER MSG                           *         
      * 2056-DREG-RENWAL-REMINDER.                                    *         
      *****************************************************************         
      *                                                                         
       2056-DREG-RENWAL-REMINDER.                                       
      *                                                                         
           MOVE 'DE-REG - 1 MONTH REMAINING (RENEWAL REMINDER)'         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7140-OPEN-DREG-QRY05-CSR         THRU 7140-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7150-FETCH-DREG-QRY05-CSR     THRU 7150-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7160-CLOSE-DREG-QRY05-CSR        THRU 7160-EXIT.     
      *                                                                         
       2056-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DREG - 1 MONTH PENDING RENEWAL MSG                            *         
      * 2057-DREG-PENDING-RENEWAL.                                    *         
      *****************************************************************         
      *                                                                         
       2057-DREG-PENDING-RENEWAL.                                       
      *                                                                         
           MOVE 'DE-REG - 1 MONTH REMAINING (PENDING RENEWAL)'          
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7170-OPEN-DREG-QRY06-CSR         THRU 7170-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7180-FETCH-DREG-QRY06-CSR     THRU 7180-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7190-CLOSE-DREG-QRY06-CSR        THRU 7190-EXIT.     
      *                                                                         
       2057-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2060-DREG-ON-LAST-MONTH.                                     **        
      * DE-REGULATED - LAST MONTH MESSAGES                             *        
      ******************************************************************        
      *                                                                         
       2060-DREG-ON-LAST-MONTH.                                         
      *                                                                         
            PERFORM 2061-LAST-MONTH-BBP-IN-SYNC     THRU 2061-EXIT.     
            PERFORM 2062-LAST-MONTH-BBP-OUT-SYNC    THRU 2062-EXIT.     
            PERFORM 2063-LAST-MONTH-WITH-OUT-BBP    THRU 2063-EXIT.     
            PERFORM 2064-RENEWED-ON-LAST-MONTH      THRU 2064-EXIT.     
      *                                                                         
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DE-REGULATED - LAST MONTH DROP MESSAGE ( BBP IN SYNC )         *        
      * 2061-LAST-MONTH-BBP-IN-SYNC                                    *        
      ******************************************************************        
      *                                                                         
       2061-LAST-MONTH-BBP-IN-SYNC.                                     
      *                                                                         
            MOVE  'DE-REG DROP MESSAGE - 12 MONTHS (BBP SYNC)'          
                                          TO WS-TEST-DESCRIPTION.       
            MOVE 12                       TO WS-DURATION-NO.            
            MOVE WS-12-MONTH-ANNIV        TO WS-ANNIVERSARY-DATE.       
            PERFORM 2061A-PROCESS-BBP-SYNC          THRU 2061A-EXIT.    
                                                                        
            MOVE 'DE-REG DROP MESSAGE - 06 MONTHS (BBP SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
            MOVE 06                       TO WS-DURATION-NO.            
            MOVE WS-6-MONTH-ANNIV         TO WS-ANNIVERSARY-DATE.       
            PERFORM 2061A-PROCESS-BBP-SYNC          THRU 2061A-EXIT.    
      *                                                                         
       2061-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2061A-PROCESS-BBP-SYNC                                         *        
      * DREG - LAST MONTH DROP MSG WITH BBP IN SYNC                    *        
      ******************************************************************        
      *                                                                         
       2061A-PROCESS-BBP-SYNC.                                          
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7200-OPEN-DREG-QRY08-CSR         THRU 7200-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
               PERFORM 7210-FETCH-DREG-QRY08-CSR    THRU 7210-EXIT      
               PERFORM 2300-WRITE-DREG-REPORT       THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7220-CLOSE-DREG-QRY08-CSR        THRU 7220-EXIT.     
      *                                                                         
       2061A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DE-REGULATED - LAST MONTH DROP MESSAGE ( BBP OUT OF SYNC )              
      * 2062-LAST-MONTH-BBP-OUT-SYNC                                            
      ******************************************************************        
      *                                                                         
       2062-LAST-MONTH-BBP-OUT-SYNC.                                    
      *                                                                         
           MOVE 'DE-REG DROP MESSAGE-12 MONTHS (BBP OUT SYNC)'          
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE WS-12-MONTH-ANNIV         TO WS-ANNIVERSARY-DATE.       
           PERFORM 2062A-PROCESS-BBP-OUT-SYNC       THRU 2062A-EXIT.    
           MOVE 'DE-REG DROP MESSAGE-06 MONTHS (BBP OUT SYNC)'          
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 06                        TO WS-DURATION-NO.            
           MOVE WS-6-MONTH-ANNIV          TO WS-ANNIVERSARY-DATE.       
           PERFORM 2062A-PROCESS-BBP-OUT-SYNC       THRU 2062A-EXIT.    
      *                                                                         
       2062-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DREG - LAST MONTH DROP MSG WITH BBP OUT OF SYNC               *         
      * 2062A-PROCESS-BBP-OUT-SYNC.                                   *         
      ******************************************************************        
      *                                                                         
       2062A-PROCESS-BBP-OUT-SYNC.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7230-OPEN-DREG-QRY09-CSR         THRU 7230-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7240-FETCH-DREG-QRY09-CSR     THRU 7240-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7250-CLOSE-DREG-QRY09-CSR        THRU 7250-EXIT.     
      *                                                                         
       2062A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DE-REGULATED - LAST MONTH DROP MESSAGE ( WITH OUT BBP )                 
      * 2063-LAST-MONTH-WITH-OUT-BBP.                                           
      ******************************************************************        
      *                                                                         
       2063-LAST-MONTH-WITH-OUT-BBP.                                    
      *                                                                         
           MOVE 'DE-REG DROP MSG- 12/06 MONTHS (WITH OUT BBP)'          
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2063A-PROCESS-WITH-OUT-BBP       THRU 2063A-EXIT.    
      *                                                                         
       2063-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DREG - LAST MONTH DROP MSG WITH OUT BBP                       *         
      * 2063A-PROCESS-WITH-OUT-BBP                                    *         
      *****************************************************************         
      *                                                                         
       2063A-PROCESS-WITH-OUT-BBP.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7260-OPEN-DREG-QRY10-CSR         THRU 7260-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7270-FETCH-DREG-QRY10-CSR     THRU 7270-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7280-CLOSE-DREG-QRY10-CSR        THRU 7280-EXIT.     
      *                                                                         
       2063A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DE-REGULATED - RENEWED DURING LAST MONTH                      *         
      *****************************************************************         
      *                                                                         
       2064-RENEWED-ON-LAST-MONTH.                                      
      *                                                                         
           MOVE 'DE-REG ACCOUNT RENEWED DURING LAST MONTH'              
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2064A-PROCESS-RENEWED-LAST       THRU 2064A-EXIT.    
                                                                        
           MOVE WS-12-MONTH-ANNIV         TO WS-ANNIVERSARY-DATE.       
           MOVE 'DE-REG RENEWED LAST MTH 12 TO 12 (BBP SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064B-RENEWED-BBP-SYNC           THRU 2064B-EXIT.    
           MOVE 'DE-REG RENEWED LAST MTH 12 TO 06 (BBP SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064B-RENEWED-BBP-SYNC           THRU 2064B-EXIT.    
           MOVE 'DE-REG RENEWED LAST 12 TO 12 (BBP NOT SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064C-RENEWED-BBP-NOT-SYNC       THRU 2064C-EXIT.    
           MOVE 'DE-REG RENEWED LAST 12 TO 06 (BBP NOT SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064C-RENEWED-BBP-NOT-SYNC       THRU 2064C-EXIT.    
           MOVE 'DE-REG RENEWED LAST 12 TO 12 (WITH OUT BBP)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064D-RENEWED-WITH-OUT-BBP       THRU 2064D-EXIT.    
           MOVE 'DE-REG RENEWED LAST 12 TO 06 (WITH OUT BBP)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 12                        TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064D-RENEWED-WITH-OUT-BBP       THRU 2064D-EXIT.    
                                                                        
           MOVE WS-6-MONTH-ANNIV          TO WS-ANNIVERSARY-DATE.       
           MOVE 'DE-REG RENEWED LAST MTH 06 TO 12 (BBP SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064B-RENEWED-BBP-SYNC           THRU 2064B-EXIT.    
           MOVE 'DE-REG RENEWED LAST MTH 06 TO 06 (BBP SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064B-RENEWED-BBP-SYNC           THRU 2064B-EXIT.    
           MOVE 'DE-REG RENEWED LAST 06 TO 12 (BBP NOT SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064C-RENEWED-BBP-NOT-SYNC       THRU 2064C-EXIT.    
           MOVE 'DE-REG RENEWED LAST 06 TO 06 (BBP NOT SYNC)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064C-RENEWED-BBP-NOT-SYNC       THRU 2064C-EXIT.    
           MOVE 'DE-REG RENEWED LAST 06 TO 12 (WITH OUT BBP)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 12                        TO WS-RENEWED-DUR-NO.         
           PERFORM 2064D-RENEWED-WITH-OUT-BBP       THRU 2064D-EXIT.    
           MOVE 'DE-REG RENEWED LAST 06 TO 06 (WITH OUT BBP)'           
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 6                         TO WS-DURATION-NO.            
           MOVE 6                         TO WS-RENEWED-DUR-NO.         
           PERFORM 2064D-RENEWED-WITH-OUT-BBP       THRU 2064D-EXIT.    
      *                                                                         
       2064-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DREG - LAST MONTH RENEWAL MSG                                  *        
      * 2064A-PROCESS-RENEWED-LAST.                                    *        
      ******************************************************************        
      *                                                                         
       2064A-PROCESS-RENEWED-LAST.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7290-OPEN-DREG-QRY07-CSR         THRU 7290-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7300-FETCH-DREG-QRY07-CSR     THRU 7300-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7310-CLOSE-DREG-QRY07-CSR        THRU 7310-EXIT.     
      *                                                                         
       2064A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DREG - LAST MONTH RENEWED ( BBP IN SYNC )                      *        
      * 2064B-RENEWED-BBP-SYNC.                                        *        
      ******************************************************************        
      *                                                                         
       2064B-RENEWED-BBP-SYNC.                                          
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7320-OPEN-DREG-QRY12-CSR         THRU 7320-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7330-FETCH-DREG-QRY12-CSR     THRU 7330-EXIT      
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE AT-ACCOUNT-NO     TO DF-ACCOUNT-NO              
                   PERFORM 7350-CHECK-RENEWED-RATE  THRU 7350-EXIT      
                   IF WS-RENEWED-FL = WS-YES                            
                      PERFORM 2300-WRITE-DREG-REPORT THRU 2300-EXIT     
                   END-IF                                               
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7340-CLOSE-DREG-QRY12-CSR        THRU 7340-EXIT.     
      *                                                                         
       2064B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DREG - LAST MONTH RENEWED ( BBP OUT OF SYNC )                  *        
      * 2064C-RENEWED-BBP-NOT-SYNC.                                    *        
      ******************************************************************        
      *                                                                         
       2064C-RENEWED-BBP-NOT-SYNC.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7360-OPEN-DREG-QRY13-CSR         THRU 7360-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7370-FETCH-DREG-QRY13-CSR     THRU 7370-EXIT      
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE AT-ACCOUNT-NO     TO DF-ACCOUNT-NO              
                   PERFORM 7350-CHECK-RENEWED-RATE  THRU 7350-EXIT      
                   IF WS-RENEWED-FL = WS-YES                            
                      PERFORM 2300-WRITE-DREG-REPORT THRU 2300-EXIT     
                   END-IF                                               
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7380-CLOSE-DREG-QRY13-CSR        THRU 7380-EXIT.     
      *                                                                         
       2064C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DREG - LAST MONTH RENEWED ( WITH OUT BBP )                     *        
      * 2064D-RENEWED-WITH-OUT-BBP.                                    *        
      ******************************************************************        
      *                                                                         
       2064D-RENEWED-WITH-OUT-BBP.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7390-OPEN-DREG-QRY14-CSR         THRU 7390-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7400-FETCH-DREG-QRY14-CSR     THRU 7400-EXIT      
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE AT-ACCOUNT-NO     TO DF-ACCOUNT-NO              
                   PERFORM 7350-CHECK-RENEWED-RATE  THRU 7350-EXIT      
                   IF WS-RENEWED-FL = WS-YES                            
                      PERFORM 2300-WRITE-DREG-REPORT THRU 2300-EXIT     
                   END-IF                                               
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7410-CLOSE-DREG-QRY14-CSR        THRU 7410-EXIT.     
      *                                                                         
       2064D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DE-REGULATED - 2 MONTHS REMAINING ON FREE CSC,                 *        
      * DISPERSED CREDIT MSG                                           *        
      * 2065-DREG-CREDIT-MESSAGE.                                      *        
      ******************************************************************        
      *                                                                         
       2065-DREG-CREDIT-MESSAGE.                                        
      *                                                                         
           MOVE 'DE-REG ACCOUNTS WITH 2 MONTHS (CSCCREDIT)'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'CSCCREDIT'               TO FF-FACTOR-ID.              
           PERFORM 2065A-PROCESS-CREDIT-MSG         THRU 2065A-EXIT.    
           MOVE 'DE-REG ACCOUNTS WITH 2 MONTHS (DISP CRED)'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DISP CRED'               TO FF-FACTOR-ID.              
           PERFORM 2065A-PROCESS-CREDIT-MSG         THRU 2065A-EXIT.    
      *                                                                         
       2065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DREG - FREE CSC AND DISPERSED CREDIT MESSAGES                  *        
      * 2065A-PROCESS-CREDIT-MSG.                                      *        
      ******************************************************************        
      *                                                                         
       2065A-PROCESS-CREDIT-MSG.                                        
      *                                                                         
           MOVE WS-NO                         TO WS-ALL-DATA-FOUND.     
           MOVE ZEROES                        TO WS-DUR-10-CNT.         
           MOVE ZEROES                        TO WS-DUR-3-CNT.          
           MOVE ZEROES                        TO WS-DUR-2-CNT.          
           MOVE ZEROES                        TO WS-DUR-1-CNT.          
           MOVE ZEROES                        TO WS-DUR-0-CNT.          
           PERFORM 7420-OPEN-DREG-QRY11-CSR         THRU 7420-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7430-FETCH-DREG-QRY11-CSR     THRU 7430-EXIT      
              PERFORM 2300-WRITE-DREG-REPORT        THRU 2300-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2900-CHECK-NO-DATA-CREDIT-MSG    THRU 2900-EXIT.     
           PERFORM 7440-CLOSE-DREG-QRY11-CSR        THRU 7440-EXIT.     
      *                                                                         
       2065A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * * REGULATED - GENERATE TEST ACCOUNTS FOR EACH TEMPLATE         *        
      * 2070-REG-QUERIES.                                              *        
      ******************************************************************        
      *                                                                         
       2070-REG-QUERIES.                                                
      *                                                                         
           PERFORM 2075-60DAY-LETTER                THRU 2075-EXIT.     
           PERFORM 2080-30DAY-LETTER                THRU 2080-EXIT.     
           PERFORM 2110-1MONTH-MESSAGE              THRU 2110-EXIT.     
           PERFORM 2125-ON-LAST-MONTH               THRU 2125-EXIT.     
           PERFORM 2145-VARIABLE-MESSAGE            THRU 2145-EXIT.     
      *                                                                         
       2070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - 60 DAY LETTER TEST ACCOUNT GENERATION              *        
      * 2075-60DAY-LETTER.                                             *        
      ******************************************************************        
      *                                                                         
       2075-60DAY-LETTER.                                               
      *                                                                         
           MOVE '60 DAY LETTER -  GRP 1 SR $1.95 CSC'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2075A-PROCESS-60DAY-LETTER       THRU 2075A-EXIT.    
           MOVE '60 DAY LETTER -  GRP 1 $3.95 CSC'                      
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2075A-PROCESS-60DAY-LETTER       THRU 2075A-EXIT.    
           MOVE '60 DAY LETTER -  GRP 2 $6.95 CSC'                      
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG305C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2075A-PROCESS-60DAY-LETTER       THRU 2075A-EXIT.    
           MOVE '60 DAY LETTER -  GRP 2 $9.95 CSC'                      
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2075A-PROCESS-60DAY-LETTER       THRU 2075A-EXIT.    
      *                                                                         
       2075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO WRITE 60 DAY LETTER LIST            *        
      * 2075A-PROCESS-60DAY-LETTER.                                    *        
      ******************************************************************        
      *                                                                         
       2075A-PROCESS-60DAY-LETTER.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           PERFORM 7450-OPEN-REG-QRY01-CSR          THRU 7450-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7460-FETCH-REG-QRY01-CSR      THRU 7460-EXIT      
              PERFORM 2400-WRITE-REPORT             THRU 2400-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 2800-CHECK-NO-DATA-DREG          THRU 2800-EXIT.     
           PERFORM 7470-CLOSE-REG-QRY01-CSR         THRU 7470-EXIT.     
      *                                                                         
       2075A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * *  REGULATED - 30 DAY LETTER TEST ACCOUNT GENERATION           *        
      * 2080-30DAY-LETTER.                                             *        
      ******************************************************************        
      *                                                                         
       2080-30DAY-LETTER.                                               
      *                                                                         
           PERFORM 2085-PROCESS-GRP1-195            THRU 2085-EXIT.     
           PERFORM 2090-PROCESS-GRP1-395            THRU 2090-EXIT.     
           PERFORM 2095-PROCESS-GRP2-695            THRU 2095-EXIT.     
           PERFORM 2100-PROCESS-GRP2-995            THRU 2100-EXIT.     
      *                                                                         
       2080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS BBP IN SYNC                 *        
      * 2080A-PROCESS-BBP-SYNC.                                        *        
      ******************************************************************        
      *                                                                         
       2080A-PROCESS-BBP-SYNC.                                          
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7480-OPEN-REG-QRY02-CSR          THRU 7480-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7490-FETCH-REG-QRY02-CSR      THRU 7490-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7500-CLOSE-REG-QRY02-CSR         THRU 7500-EXIT.     
      *                                                                         
       2080A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS BBP OUT OF SYNC             *        
      * 2080B-PROCESS-BBP-NOT-SYNC.                                    *        
      ******************************************************************        
      *                                                                         
       2080B-PROCESS-BBP-NOT-SYNC.                                      
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7510-OPEN-REG-QRY03-CSR          THRU 7510-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7520-FETCH-REG-QRY03-CSR      THRU 7520-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7530-CLOSE-REG-QRY03-CSR         THRU 7530-EXIT.     
      *                                                                         
       2080B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS WITH OUT BBP                *        
      * 2080C-PROCESS-NO-BBP.                                          *        
      ******************************************************************        
      *                                                                         
       2080C-PROCESS-NO-BBP.                                            
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7540-OPEN-REG-QRY04-CSR          THRU 7540-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7550-FETCH-REG-QRY04-CSR      THRU 7550-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7560-CLOSE-REG-QRY04-CSR         THRU 7560-EXIT.     
      *                                                                         
       2080C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCOUNTS ON GRP1 SR $1.95                                      *        
      * 2085-PROCESS-GRP1-195                                          *        
      ******************************************************************        
      *                                                                         
       2085-PROCESS-GRP1-195.                                           
      *                                                                         
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE 'REG 30 DAY - GRP1 $1.95 (BBP IN SYNC)'                 
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2080A-PROCESS-BBP-SYNC           THRU 2080A-EXIT.    
           MOVE 'REG 30 DAY - GPR1 $1.95 (BBP NOT IN SYNC)'             
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2080B-PROCESS-BBP-NOT-SYNC       THRU 2080B-EXIT.    
           MOVE 'REG 30 DAY - GPR1 $1.95 (WITH OUT BBP)'                
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2080C-PROCESS-NO-BBP             THRU 2080C-EXIT.    
      *                                                                         
       2085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCOUNTS ON GRP1 $3.95                                         *        
      * 2090-PROCESS-GRP1-395                                          *        
      ******************************************************************        
      *                                                                         
       2090-PROCESS-GRP1-395.                                           
      *                                                                         
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE WS-60-DAY-ANNIV           TO WS-DT-1.                   
           MOVE 'REG 30 DAY - GPR1 $3.95 (BBP IN SYNC)'                 
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GPR1 $3.95 TO $1.95 (BBP IN SYNC)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080A-PROCESS-BBP-SYNC           THRU 2080A-EXIT.    
           MOVE 'REG 30 DAY - GPR1 $3.95 (BBP NOT IN SYNC)'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY- GPR1 $3.95 TO $1.95 (BBP NOT SYNC)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080B-PROCESS-BBP-NOT-SYNC       THRU 2080B-EXIT.    
           MOVE 'REG 30 DAY - GPR1 $3.95 (WITH OUT BBP)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY- GPR1 $3.95 TO $1.95 (WITH OUT BBP)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080C-PROCESS-NO-BBP             THRU 2080C-EXIT.    
      *                                                                         
       2090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * ACCOUNTS ON GRP1 $6.95                                        *         
      * 2095-PROCESS-GRP2-695.                                        *         
      *****************************************************************         
      *                                                                         
       2095-PROCESS-GRP2-695.                                           
      *                                                                         
           MOVE  'RG305C02XXXX'           TO WS-TEMP-OPTION-CD.         
           MOVE 'REG 30 DAY - GPR2 $6.95 (BBP IN SYNC)'                 
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GPR1 $6.95 TO $9.95 (BBP IN SYNC)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080A-PROCESS-BBP-SYNC           THRU 2080A-EXIT.    
           MOVE 'REG 30 DAY - GRP2 $6.95 (BBP NOT IN SYNC)'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY- GRP2 $6.95 TO $9.95(BBP NOT SYNC)'         
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080B-PROCESS-BBP-NOT-SYNC       THRU 2080B-EXIT.    
           MOVE 'REG 30 DAY - GRP2 $6.95 (WITH OUT BBP)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GRP2 $6.95 - $9.95 (WITH OUT BBP)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080C-PROCESS-NO-BBP             THRU 2080C-EXIT.    
      *                                                                         
       2095-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCOUNTS ON GRP1 $9.95                                         *        
      * 2100-PROCESS-GRP2-995.                                         *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-GRP2-995.                                           
      *                                                                         
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE 'REG 30 DAY - GRP2 $9.95 (BBP IN SYNC)'                 
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GRP2 $9.95 - $6.95 (BBP IN SYNC)'         
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080A-PROCESS-BBP-SYNC           THRU 2080A-EXIT.    
           MOVE 'REG 30 DAY - GRP2 $9.95 (BBP NOT IN SYNC)'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GRP2 $9.95 - $6.95 (BBP NOT SYNC)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080B-PROCESS-BBP-NOT-SYNC       THRU 2080B-EXIT.    
           MOVE 'REG 30 DAY - GRP2 $9.95 (WITH OUT BBP)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'REG 30 DAY - GRP2 $9.95 - $6.95 (WITH OUT BBP)'        
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2080C-PROCESS-NO-BBP             THRU 2080C-EXIT.    
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *REGULATED - 1 MONTH REMAINS ON CURRENT FIXED RATE RENEWAL MESSAGE        
      ******************************************************************        
      *                                                                         
       2110-1MONTH-MESSAGE.                                             
      *                                                                         
           PERFORM 2115-1MONTH-RENWAL-REMIND        THRU 2115-EXIT.     
           PERFORM 2120-1MONTH-PEND-RENEWAL         THRU 2120-EXIT.     
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - GET ACCOUNTS FOR RENEWAL REMINDER MESSAGES                  
      ******************************************************************        
      *                                                                         
       2115-1MONTH-RENWAL-REMIND.                                       
      *                                                                         
           MOVE '1 MONTH - GRP1 $1.95 (RENWEWAL REMINDER)'              
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2115A-PROCESS-DATA               THRU 2115A-EXIT.    
           MOVE '1 MONTH - GRP1 $3.95 (RENWEWAL REMINDER)'              
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP1 $3.95 TO $1.95 (REN REMINDER)'          
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2115A-PROCESS-DATA               THRU 2115A-EXIT.    
           MOVE '1 MONTH - GRP2 $6.95 (RENWEWAL REMINDER)'              
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP2 $6.95 TO GRP2 $9.95 (REN REMINDER)'     
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG305C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2115A-PROCESS-DATA               THRU 2115A-EXIT.    
           MOVE '1 MONTH - GRP2 $9.95 (RENWEWAL REMINDER)'              
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP2 $9.95 TO GRP2 $6.95 (REN REMINDER)'     
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM  2115A-PROCESS-DATA              THRU 2115A-EXIT.    
      *                                                                         
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - PROCESS RENWAL REMINDER MESSAGE ACCOUNTS           *        
      * 2115A-PROCESS-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2115A-PROCESS-DATA.                                              
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7570-OPEN-REG-QRY05-CSR          THRU 7570-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7580-FETCH-REG-QRY05-CSR      THRU 7580-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7590-CLOSE-REG-QRY05-CSR         THRU 7590-EXIT.     
      *                                                                         
       2115A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - GET ACCOUNTS FOR PENDING RENEWAL MESSAGES                   
      ******************************************************************        
      *                                                                         
       2120-1MONTH-PEND-RENEWAL.                                        
      *                                                                         
           MOVE '1 MONTH - GRP1 $1.95 (PENDING RENEWAL)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2120A-PROCESS-DATA               THRU 2120A-EXIT.    
           MOVE '1 MONTH - GRP1 $3.95 (PENDING RENEWAL)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP1 $3.95 TO $1.95 (PEND RENEWAL)'          
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2120A-PROCESS-DATA               THRU 2120A-EXIT.    
           MOVE '1 MONTH - GRP2 $6.95 (PENDING RENEWAL)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP2 $6.95 TO GRP2 $9.95 (PEND RENEWAL)'     
                                          TO WS-TEST-CASE2-DESC.        
                                                                        
           MOVE 'RG305C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2120A-PROCESS-DATA               THRU 2120A-EXIT.    
           MOVE '1 MONTH - GRP2 $9.95 (PENDING RENEWAL)'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE '1 MONTH - GRP2 $9.95 TO GRP2 $6.95 (PEND RENEWAL)'     
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2120A-PROCESS-DATA               THRU 2120A-EXIT.    
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - PROCESS PENDING RENEWAL MESSAGE ACCOUNTS           *        
      * 2120A-PROCESS-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2120A-PROCESS-DATA.                                              
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7600-OPEN-REG-QRY10-CSR          THRU 7600-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7610-FETCH-REG-QRY10-CSR      THRU 7610-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7620-CLOSE-REG-QRY10-CSR         THRU 7620-EXIT.     
      *                                                                         
       2120A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - ACCOUNTS ON THEIR LAST MONTH                                
      ******************************************************************        
      *                                                                         
       2125-ON-LAST-MONTH.                                              
      *                                                                         
           PERFORM 2130-LAST-MONTH-RENWAL-MSG       THRU 2130-EXIT.     
           PERFORM 2135-LAST-MONTH-DROP-MSG         THRU 2135-EXIT.     
           PERFORM 2140-LAST-MONTH-DROP-BBP         THRU 2140-EXIT.     
      *                                                                         
       2125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - LAST MONTH RENEWAL MESSAGE                                  
      ******************************************************************        
      *                                                                         
       2130-LAST-MONTH-RENWAL-MSG.                                      
      *                                                                         
           MOVE 'RENEWED ON LAST MONTH - $1.95'                         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2130A-PROCESS-DATA               THRU 2130A-EXIT.    
           MOVE 'RENEWED ON LAST MONTH - $3.95'                         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RENEWED ON LAST MONTH - $3.95 TO $1.95'                
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2130A-PROCESS-DATA               THRU 2130A-EXIT.    
                                                                        
           MOVE 'RENEWED ON LAST MONTH - $6.95'                         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RENEWED ON LAST MONTH - $6.95 TO $9.95'                
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG305C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2130A-PROCESS-DATA               THRU 2130A-EXIT.    
           MOVE 'RENEWED ON LAST MONTH - $9.95'                         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RENEWED ON LAST MONTH - $9.95 TO $6.95'                
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2130A-PROCESS-DATA               THRU 2130A-EXIT.    
      *                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS LAST MONTH RENEWAL MESSAGE  *        
      * 2130A-PROCESS-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2130A-PROCESS-DATA.                                              
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7630-OPEN-REG-QRY06-CSR          THRU 7630-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7640-FETCH-REG-QRY06-CSR      THRU 7640-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7650-CLOSE-REG-QRY06-CSR         THRU 7650-EXIT.     
      *                                                                         
       2130A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - LAST MONTH DROP MESSAGES WITH OUT BBP                       
      ******************************************************************        
      *                                                                         
       2135-LAST-MONTH-DROP-MSG.                                        
      *                                                                         
           MOVE 'DROP ON LAST MONTH - $1.95 (NO BBP)'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2135A-PROCESS-DATA               THRU 2135A-EXIT.    
           MOVE 'DROP ON LAST MONTH - $3.95 (NO BBP)'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DROP ON LAST MONTH - $3.95 TO $1.95 (NO BBP)'          
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2135A-PROCESS-DATA               THRU 2135A-EXIT.    
           MOVE 'DROP ON LAST MONTH - $6.95 (NO BBP)'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DROP ON LAST MONTH - $6.95 TO $9.95 (NO BBP)'          
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG305C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2135A-PROCESS-DATA               THRU 2135A-EXIT.    
           MOVE 'DROP ON LAST MONTH - $9.95 (NO BBP)'                   
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DROP ON LAST MONTH - $9.95 TO $6.95 (NO BBP)'          
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2135A-PROCESS-DATA               THRU 2135A-EXIT.    
      *                                                                         
       2135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS LAST MONTH DROP MESSAGE     *        
      * 2135A-PROCESS-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2135A-PROCESS-DATA.                                              
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7660-OPEN-REG-QRY07-CSR          THRU 7660-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7670-FETCH-REG-QRY07-CSR      THRU 7670-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7680-CLOSE-REG-QRY07-CSR         THRU 7680-EXIT.     
      *                                                                         
       2135A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - LAST MONTH DROP MESSAGES WITH BBP                           
      ******************************************************************        
      *                                                                         
       2140-LAST-MONTH-DROP-BBP.                                        
      *                                                                         
           MOVE 'RG307C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE 'DROP ON LAST MONTH - $1.95 (WITH BBP)'                 
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2140A-PROCESS-WITH-BBP           THRU 2140A-EXIT.    
                                                                        
           MOVE 'RG301C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE 'DROP ON LAST MONTH - $3.95 (WITH BBP)'                 
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DROP ON LAST MONTH - $3.95 TO $1.95(WITH BBP)'         
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2140A-PROCESS-WITH-BBP           THRU 2140A-EXIT.    
                                                                        
           MOVE 'RG309C02XXXX'            TO WS-TEMP-OPTION-CD.         
           MOVE 'DROP ON LAST MONTH - $9.95 (WITH BBP)'                 
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'DROP ON LAST MONTH - $9.95 TO $6.95(WITH BBP)'         
                                          TO WS-TEST-CASE2-DESC.        
           PERFORM 2140A-PROCESS-WITH-BBP           THRU 2140A-EXIT.    
      *                                                                         
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - COMMON PROC TO PROCESS LAST MONTH DROP MESSAGE WITH*        
      * BBP.                                                           *        
      * 2140A-PROCESS-WITH-BBP.                                        *        
      ******************************************************************        
      *                                                                         
       2140A-PROCESS-WITH-BBP.                                          
      *                                                                         
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7690-OPEN-REG-QRY08-CSR          THRU 7690-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7700-FETCH-REG-QRY08-CSR      THRU 7700-EXIT      
              PERFORM 2200-WRITE-OPTION-REPORT      THRU 2200-EXIT      
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG307C02XXXX'                        
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           ELSE                                                         
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           END-IF.                                                      
           PERFORM 7710-CLOSE-REG-QRY08-CSR         THRU 7710-EXIT.     
      *                                                                         
       2140A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************25100000
      * REGULATED - VARIABLE RATE MESSAGES                             *25110000
      ******************************************************************25120000
      *                                                                         
       2145-VARIABLE-MESSAGE.                                           
      *                                                                 25140000
           MOVE 'VARIABLE ON $6.95 - MISSED PAY'                        
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG105C01XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2145A-PROCESS-DATA               THRU 2145A-EXIT.    
           MOVE 'VARIABLE GRP1 SR MOVE TO GRP2'                         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE  'RG107C01XXXX'           TO WS-TEMP-OPTION-CD.         
           MOVE WS-30-DAY-ANNIV           TO WS-DT-1.                   
           PERFORM 2145A-PROCESS-DATA               THRU 2145A-EXIT.    
           MOVE 'VARIABLE GRP1 $3.95 MOVE TO GRP1 SR $1.95'             
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'RG101C01XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2145A-PROCESS-DATA               THRU 2145A-EXIT.    
           MOVE 'VARIABLE CONGRATS MSG $9.95 - GOOD PAY'                
                                          TO WS-TEST-DESCRIPTION.       
           MOVE 'VARIABLE GOOD PAY INSERT'                              
                                          TO WS-TEST-CASE2-DESC.        
           MOVE 'RG109C01XXXX'            TO WS-TEMP-OPTION-CD.         
           PERFORM 2145A-PROCESS-DATA               THRU 2145A-EXIT.    
                                                                        
           PERFORM 2150-DREG-SWITCH-LETTERS         THRU 2150-EXIT.     
      *                                                                         
       2145-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************28840000
      * REGULATED - COMMON PROC TO PROCESS VARIABLE RATE CUSTOMERS     *28850000
      ******************************************************************28860000
      *                                                                         
       2145A-PROCESS-DATA.                                              
      *                                                                 28880000
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT2.         
           PERFORM 7800-OPEN-REG-QRY09-CSR          THRU 7800-EXIT.     
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
                   PERFORM 7810-FETCH-REG-QRY09-CSR THRU 7810-EXIT      
             EVALUATE WS-TEMP-OPTION-CD                                 
                WHEN 'RG107C01XXXX'                                     
                  PERFORM 2940-WRITE-MISSED-MESSAGE THRU 2940-EXIT      
                WHEN 'RG101C01XXXX'                                     
                  PERFORM 2950-WRITE-SR-MOVE        THRU 2950-EXIT      
                WHEN 'RG105C01XXXX'                                     
                  PERFORM 2940-WRITE-MISSED-MESSAGE THRU 2940-EXIT      
                WHEN 'RG109C01XXXX'                                     
                  PERFORM 2960-WRITE-995-GOOD-PAY   THRU 2960-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           IF WS-TEMP-OPTION-CD = 'RG109C01XXXX'                        
              PERFORM 2700-CHECK-NO-DATA-REG        THRU 2700-EXIT      
           ELSE                                                         
              PERFORM 2600-CHECK-NO-DATA-REG        THRU 2600-EXIT      
           END-IF.                                                      
           PERFORM 7820-CLOSE-REG-QRY09-CSR         THRU 7820-EXIT.     
      *                                                                         
       2145A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************29290000
      * DE REGULATED SWITCH INITIAL OPITON AND REMINDER LETTERS        *29300000
      ******************************************************************29310000
      *                                                                         
       2150-DREG-SWITCH-LETTERS.                                        
      *                                                                       29
           PERFORM 2155-INIT-DATA                   THRU 2155-EXIT.     
           PERFORM 2160-REMINDER-LETTERS            THRU 2160-EXIT.     
           PERFORM 2165-INITIAL-OPTION-LETTERS      THRU 2165-EXIT.     
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************29400000
      * SET GROUP_MOVE DATE AND NEXT 5 BUSINESS DAY CYCLE              *29410000
      ******************************************************************29420000
      *                                                                         
       2155-INIT-DATA.                                                  
      *                                                                 29440000
      *** SET TO CHECK LAST GROUP MOVE DATE - MONTHLY REMINDER          29450000
           MOVE WS-PARM-REV-MTH-N         TO WS-TEMP-REV-MTH.           
           PERFORM 2020-STEP-DOWN-MONTH             THRU 2020-EXIT.     
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
           MOVE WS-TEMP-DATE              TO WS-MONTHLY-REMINDER-DATE.  
                                                                        
      *** SET TO CHECK LAST GROUP MOVE DATE - YEARLY REMINDER           29540000
           MOVE WS-PARM-REV-MTH-N         TO WS-TEMP-REV-MTH.           
           COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY - 1.             
                                                                        
           MOVE WS-TEMP-REV-CCYY          TO WS-TEMP-DATE-YY.           
           MOVE WS-TEMP-REV-MM            TO WS-TEMP-DATE-MM.           
           MOVE WS-ONE                    TO WS-TEMP-DATE-DD.           
                                                                        
           MOVE WS-TEMP-DATE              TO WS-YEARLY-REMINDER-DATE.   
                                                                        
      *** CALCULATE NEXT 5 BUSINESS CYCLE                               29640000
           MOVE AT-BILL-CYCLE         TO WS-TEMP-CYCLE-N.               
                                                                        
           COMPUTE WS-TEMP-CYCLE-N = WS-TEMP-CYCLE-N + 5.               
           DISPLAY ' NEXT 5 BUSINESS CYCLE ' WS-TEMP-CYCLE-N.           
           IF WS-TEMP-CYCLE-N > 20                                      
              COMPUTE WS-TEMP-CYCLE-N = WS-TEMP-CYCLE-N - 20            
           END-IF.                                                      
                                                                        
           MOVE WS-TEMP-CYCLE-N       TO WS-NEXT5-BUSINESS-CYCLE.       
           DISPLAY ' MONTHLY DATE' WS-MONTHLY-REMINDER-DATE.            
           DISPLAY ' YEARLY  DATE' WS-YEARLY-REMINDER-DATE.             
           DISPLAY ' NEXT5 CYCLE ' WS-NEXT5-BUSINESS-CYCLE.             
      *                                                                         
       2155-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************29800000
      * PROCESS REMINDER LETTERS FOR DE-REG SWITCH                     *29810000
      ******************************************************************29820000
      *                                                                         
       2160-REMINDER-LETTERS.                                           
      *                                                                         
           MOVE WS-MONTHLY-REMINDER-DATE  TO UT-GAS-BASE-LAST-UPDT.     
           MOVE 'MONTHLY REMINDER - VARIABLE GRP2 NON DHR'              
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2160A-PROCESS-REMINDER-LTR       THRU 2160A-EXIT.    
                                                                        
           MOVE WS-YEARLY-REMINDER-DATE   TO UT-GAS-BASE-LAST-UPDT.     
           MOVE 'YEARLY REMINDER - VARIABLE GRP2 NON DHR'               
                                          TO WS-TEST-DESCRIPTION.       
           PERFORM 2160A-PROCESS-REMINDER-LTR       THRU 2160A-EXIT.    
      *                                                                         
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************29950000
      * COMMON PROC TO PROCESS REMINDER LETTERS                        *29960000
      ******************************************************************29970000
      *                                                                         
       2160A-PROCESS-REMINDER-LTR.                                      
      *                                                                 29990000
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE SPACES                    TO DF-OPTION-CD.              
           PERFORM 7720-OPEN-REG-QRY11-CSR          THRU 7720-EXIT.     
                                                                        
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7730-FETCH-REG-QRY11-CSR      THRU 7730-EXIT      
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                MOVE  WS-NO               TO WS-FIXED-RATE-FL           
                MOVE AT-ACCOUNT-NO        TO DF-ACCOUNT-NO              
                MOVE UT-IC-NO             TO DF-IC-NO                   
                PERFORM 7750-CHECK-RATE-TYPE        THRU 7750-EXIT      
                IF WS-FIXED-RATE-FL = WS-NO                             
                   MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE      
                   PERFORM 2400-WRITE-REPORT        THRU 2400-EXIT      
                END-IF                                                  
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM 2600-CHECK-NO-DATA-REG           THRU 2600-EXIT.     
           PERFORM 7740-CLOSE-REG-QRY11-CSR         THRU 7740-EXIT.     
      *                                                                         
       2160A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************29950000
      * INITIAL OPITON LETTER FOR GRP2 NON DHR CUSTOMERS WITH 6 GOOD PAY29960000
      ******************************************************************29970000
      *                                                                         
       2165-INITIAL-OPTION-LETTERS.                                     
      *                                                                 29990000
           MOVE 'INITIAL OPTION LETTER - VARIABLE GRP2 NON DHR'         
                                          TO WS-TEST-DESCRIPTION.       
           MOVE WS-NO                     TO WS-ALL-DATA-FOUND.         
           MOVE ZEROES                    TO WS-TEST-CASE-CNT1.         
           MOVE SPACES                    TO DF-OPTION-CD.              
           PERFORM 7760-OPEN-REG-QRY12-CSR          THRU 7760-EXIT.     
                                                                        
           PERFORM UNTIL WS-ALL-DATA-FOUND = WS-YES                     
              PERFORM 7770-FETCH-REG-QRY12-CSR      THRU 7770-EXIT      
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                MOVE  WS-NO               TO WS-FIXED-RATE-FL           
                MOVE AT-ACCOUNT-NO        TO DF-ACCOUNT-NO              
                MOVE UT-IC-NO             TO DF-IC-NO                   
                PERFORM 7750-CHECK-RATE-TYPE        THRU 7750-EXIT      
                IF WS-FIXED-RATE-FL = WS-NO                             
                   MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE      
                   PERFORM 2500-WRITE-GOOD-PAY      THRU 2500-EXIT      
                END-IF                                                  
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM 2600-CHECK-NO-DATA-REG           THRU 2600-EXIT.     
           PERFORM 7780-CLOSE-REG-QRY12-CSR         THRU 7780-EXIT.     
      *                                                                         
       2165-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************30930000
      *COMMON PROC TO CALCULATE GOOD/MISSED PAYMENT OF AN ACCOUNT      *30940000
      ******************************************************************30950000
      *                                                                 30970000
       2170-CALC-GOOD-MISS-PAY.                                         
      *                                                                 30970000
           MOVE AT-ACCOUNT-NO             TO CZ-ACCOUNT-NO.             
                                                                        
           IF WS-NULL-IND < 0                                           
              MOVE SPACES                 TO UT-GAS-BASE-LAST-UPDT      
           END-IF.                                                      
                                                                        
           PERFORM 7790-FETCH-CRED-PROF             THRU 7790-EXIT.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2175-PERFORM-CALC             THRU 2175-EXIT      
           ELSE                                                         
              DISPLAY  'ACCOUNT   : ' CZ-ACCOUNT-NO                     
              DISPLAY  'SQLCODE   : ' WS-ACTIVE-RETURN-CODE             
              DISPLAY  'CRED_PROF FETCH'                                
           END-IF.                                                      
      *                                                                         
       2170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************31440000
      *PERFORM THE CALCULATIONS BASED ON RETREIVED VALUES              *31450000
      ******************************************************************31460000
      *                                                                         
       2175-PERFORM-CALC.                                               
      *                                                                 31480000
           MOVE AT-REV-MTH-LST-NRML       TO WS-REV-YR-MM.              
           MOVE CZ-DISCONNECT-HIST        TO WS-UTL-CR-HST.             
           MOVE CZ-DISC-EXCEPTN-HIST      TO WS-UTL-EXP-HST.            
           MOVE CZ-ARREARS-HIST           TO WS-UTL-ARRS-HST.           
           MOVE CZ-NON-UTL-CR-HST         TO WS-NON-UTL-CR-HST.         
           MOVE CZ-NON-UTL-CR-HST-EX      TO WS-NON-UTL-EXP-HST.        
           MOVE CZ-NON-UTL-ARRER-HIST     TO WS-NON-UTL-ARRS-HST.       
           MOVE UT-GAS-BASE-LAST-UPDT     TO WS-GAS-BASE-LAST-UPDT.     
           MOVE WS-ONE-N                  TO WS-MTH-INDEX.              
           MOVE WS-SIX                    TO WS-HIST-EVAL-MONTHS.       
           PERFORM 6896-CHECK-PAYMENT-HISTORY       THRU 6896-EXIT.     
      *                                                                         
       2175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************31440000
      *COPYBOOK CPD00329                                               *31450000
      ******************************************************************31460000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00329                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * REGULATED - WRITES REPORT BASED ON THE OPTION                  *        
      ******************************************************************        
      *                                                                         
       2200-WRITE-OPTION-REPORT.                                        
      *                                                                         
           EVALUATE WS-TEMP-OPTION-CD                                   
             WHEN 'RG307C02XXXX'                                        
                PERFORM 2400-WRITE-REPORT           THRU 2400-EXIT      
             WHEN 'RG301C02XXXX'                                        
                PERFORM 2910-WRITE-395-REPORT       THRU 2910-EXIT      
             WHEN 'RG305C02XXXX'                                        
                PERFORM 2920-WRITE-695-REPORT       THRU 2920-EXIT      
             WHEN 'RG309C02XXXX'                                        
                PERFORM 2930-WRITE-995-REPORT       THRU 2930-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2300-WRITE-DREG-REPORT                                        *         
      * COMMON PROC TO WRITE DREG REPORT                              *         
      *****************************************************************         
      *                                                                         
       2300-WRITE-DREG-REPORT.                                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
            IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                   
               COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1        
               PERFORM 2970-MOVE-PARA               THRU 2970-EXIT      
               PERFORM 8000-WRITE-FCSPT33           THRU 8000-EXIT      
            END-IF                                                      
            IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                   
               MOVE WS-YES                TO WS-ALL-DATA-FOUND          
            END-IF                                                      
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * COMMON PROC TO WRITE REG REPORT                               *         
      *****************************************************************         
      *                                                                         
       2400-WRITE-REPORT.                                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1      
                 PERFORM 2980-MOVE-PARA             THRU 2980-EXIT      
                 PERFORM 8100-WRITE-FCSPT331        THRU 8100-EXIT      
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 36160000
      * VARIABLE RATE CUSTOMER WITH 6 MONTHS GOOD PAYMENT             * 36170000
      ***************************************************************** 36180000
      *                                                                         
       2500-WRITE-GOOD-PAY.                                             
      *                                                                 36200000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              PERFORM 2170-CALC-GOOD-MISS-PAY       THRU 2170-EXIT      
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 IF WS-NBR-GOOD-PAYMENT >= 6                            
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REGULATED - WRITE NO DATA FOUND FOR TEST CASE 1                *        
      ******************************************************************        
      *                                                                         
       2600-CHECK-NO-DATA-REG.                                          
      *                                                                         
           IF WS-TEST-CASE-CNT1 = 0                                     
              MOVE 'NO DATA FOUND'        TO WS-ACCOUNT-NO              
              MOVE SPACES                 TO DF-OPTION-CD               
              MOVE WS-YES                 TO WS-NO-DATA-FLAG            
              PERFORM 2980-MOVE-PARA                THRU 2980-EXIT      
              PERFORM 8100-WRITE-FCSPT331           THRU 8100-EXIT      
           END-IF.                                                      
           MOVE WS-NO                     TO WS-NO-DATA-FLAG.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * REGULATED - WRITE NO DATA FOUND FOR TEST CASE 1 AND 2         *         
      *****************************************************************         
      *                                                                         
       2700-CHECK-NO-DATA-REG.                                          
      *                                                                         
           IF WS-TEST-CASE-CNT1 = 0                                     
              MOVE 'NO DATA FOUND'        TO WS-ACCOUNT-NO              
              MOVE SPACES                 TO DF-OPTION-CD               
              MOVE WS-YES                 TO WS-NO-DATA-FLAG            
              PERFORM 2980-MOVE-PARA                 THRU 2980-EXIT     
              PERFORM 8100-WRITE-FCSPT331            THRU 8100-EXIT     
           END-IF.                                                      
                                                                        
           MOVE WS-NO                     TO WS-NO-DATA-FLAG.           
                                                                        
           IF WS-TEST-CASE-CNT2 = 0                                     
              MOVE WS-TEST-CASE2-DESC     TO WS-TEST-DESCRIPTION        
              MOVE 'NO DATA FOUND'        TO WS-ACCOUNT-NO              
              MOVE SPACES                 TO DF-OPTION-CD               
              MOVE WS-YES                 TO WS-NO-DATA-FLAG            
              PERFORM 2980-MOVE-PARA                THRU 2980-EXIT      
              PERFORM 8100-WRITE-FCSPT331           THRU 8100-EXIT      
           END-IF.                                                      
           MOVE WS-NO                     TO WS-NO-DATA-FLAG.           
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2800-CHECK-NO-DATA-DREG.                                      *         
      * DE-REGULATED - WRITE NO DATA FOUND FOR TEST CASE 1            *         
      *****************************************************************         
      *                                                                         
       2800-CHECK-NO-DATA-DREG.                                         
      *                                                                         
           IF WS-TEST-CASE-CNT1 = 0                                     
              MOVE 'NO DATA FOUND'        TO WS-ACCOUNT-NO              
              MOVE SPACES                 TO DF-OPTION-CD               
              MOVE WS-YES                 TO WS-NO-DATA-FLAG            
              PERFORM 2970-MOVE-PARA                THRU 2970-EXIT      
              PERFORM 8000-WRITE-FCSPT33            THRU 8000-EXIT      
           END-IF.                                                      
           MOVE WS-NO                     TO WS-NO-DATA-FLAG.           
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DE-REGULATED - WRITE NO DATA FOR CREDIT MSG TEST CASES        *         
      *****************************************************************         
      *                                                                         
       2900-CHECK-NO-DATA-CREDIT-MSG.                                   
      *                                                                         
           IF WS-DUR-10-CNT = 0  AND                                    
              WS-DUR-3-CNT  = 0  AND                                    
              WS-DUR-2-CNT  = 0  AND                                    
              WS-DUR-1-CNT  = 0  AND                                    
              WS-DUR-0-CNT  = 0                                         
                                                                        
              MOVE 'NO DATA FOUND'        TO WS-ACCOUNT-NO              
              MOVE SPACES                 TO DF-OPTION-CD               
              MOVE WS-YES                 TO WS-NO-DATA-FLAG            
              PERFORM 2970-MOVE-PARA                THRU 2970-EXIT      
              PERFORM 8000-WRITE-FCSPT33            THRU 8000-EXIT      
           END-IF.                                                      
           MOVE WS-NO                     TO WS-NO-DATA-FLAG.           
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 34390000
      * COMMON PROC TO WRITE REG REPORT FOR GRP1 $3.95                * 34400000
      ***************************************************************** 34410000
      *                                                                         
       2910-WRITE-395-REPORT.                                           
      *                                                                 34430000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1      
                 PERFORM 2980-MOVE-PARA             THRU 2980-EXIT      
                 PERFORM 8100-WRITE-FCSPT331        THRU 8100-EXIT      
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                AND WS-TEST-CASE-CNT2 < WS-TEST-CASE-LIMIT              
                 PERFORM 2910A-QUALIFY-GRP1-SR      THRU 2910A-EXIT     
                 IF WS-GRP1-SR-FLAG = WS-YES                            
                    MOVE  WS-TEST-CASE2-DESC TO WS-TEST-DESCRIPTION     
                    COMPUTE WS-TEST-CASE-CNT2 = WS-TEST-CASE-CNT2 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 AND WS-TEST-CASE-CNT2 = WS-TEST-CASE-LIMIT             
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 32590000
      * SET FLAG FOR GRP1 SENIOR                                      * 32600000
      ***************************************************************** 32610000
      *                                                                         
       2910A-QUALIFY-GRP1-SR.                                           
      *                                                                 32630000
           MOVE WS-NO                     TO WS-GRP1-SR-FLAG.           
           PERFORM 7830-GET-CUST-DOB                THRU 7830-EXIT.     
           IF WS-NULL-IND1 = 0 AND CE-DOB-VERIFIED-CD > ' '             
              MOVE CE-DATE-OF-BIRTH       TO WS-DT-2                    
              PERFORM 7840-GET-CUST-AGE             THRU 7840-EXIT      
              IF WS-CUST-AGE >= 65                                      
                 MOVE WS-YES              TO WS-GRP1-SR-FLAG            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2910A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 34710000
      * COMMON PROC TO WRITE REG REPORT FOR GRP2 $6.95                * 34720000
      ***************************************************************** 34730000
      *                                                                         
       2920-WRITE-695-REPORT.                                           
      *                                                                 34750000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              PERFORM 2170-CALC-GOOD-MISS-PAY       THRU 2170-EXIT      
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 IF WS-NBR-MISSED-PAYMENT < 2                           
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                AND WS-TEST-CASE-CNT2 < WS-TEST-CASE-LIMIT              
                 IF WS-NBR-MISSED-PAYMENT > 1                           
                    MOVE WS-TEST-CASE2-DESC TO WS-TEST-DESCRIPTION      
                    COMPUTE WS-TEST-CASE-CNT2 = WS-TEST-CASE-CNT2 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                AND WS-TEST-CASE-CNT2 = WS-TEST-CASE-LIMIT              
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35040000
      * COMMON PROC TO WRITE REG REPORT FOR GRP2 $9.95                * 35050000
      ***************************************************************** 35060000
      *                                                                 35080000
       2930-WRITE-995-REPORT.                                           
      *                                                                 35080000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              PERFORM 2170-CALC-GOOD-MISS-PAY       THRU 2170-EXIT      
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 IF WS-NBR-GOOD-PAYMENT < 6                             
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                AND WS-TEST-CASE-CNT2 < WS-TEST-CASE-LIMIT              
                 IF WS-NBR-GOOD-PAYMENT >= 6                            
                    MOVE WS-TEST-CASE2-DESC  TO WS-TEST-DESCRIPTION     
                    COMPUTE WS-TEST-CASE-CNT2 = WS-TEST-CASE-CNT2 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 AND WS-TEST-CASE-CNT2 = WS-TEST-CASE-LIMIT             
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35700000
      * VARIABLE CUSTOMER ON $6.95 MISSED PAY                         * 35710000
      ***************************************************************** 35720000
      *                                                                 35740000
       2940-WRITE-MISSED-MESSAGE.                                       
      *                                                                 35740000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              PERFORM 2170-CALC-GOOD-MISS-PAY       THRU 2170-EXIT      
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 IF WS-NBR-MISSED-PAYMENT > 1                           
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35930000
      * VARIABLE CUSTOMER ON $3.95 MOVES TO GPR1 SR $1.95             * 35940000
      ***************************************************************** 35950000
      *                                                                 35970000
       2950-WRITE-SR-MOVE.                                              
      *                                                                 35970000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 PERFORM 2910A-QUALIFY-GRP1-SR      THRU 2910A-EXIT     
                 IF WS-GRP1-SR-FLAG = WS-YES                            
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35370000
      * VARIABLE CUSTOMER ON $9.95 GOOD PAY MESSAGE                   * 35380000
      ***************************************************************** 35390000
      *                                                                 35410000
       2960-WRITE-995-GOOD-PAY.                                         
      *                                                                 35410000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO              
              PERFORM 2170-CALC-GOOD-MISS-PAY       THRU 2170-EXIT      
                                                                        
              IF WS-TEST-CASE-CNT1 < WS-TEST-CASE-LIMIT                 
                 IF WS-NBR-GOOD-PAYMENT >= 6                            
                    COMPUTE WS-TEST-CASE-CNT1 = WS-TEST-CASE-CNT1 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                AND WS-TEST-CASE-CNT2 < WS-TEST-CASE-LIMIT              
                 IF WS-NBR-GOOD-PAYMENT >= 5                            
                    MOVE WS-TEST-CASE2-DESC  TO WS-TEST-DESCRIPTION     
                    COMPUTE WS-TEST-CASE-CNT2 = WS-TEST-CASE-CNT2 + 1   
                    PERFORM 2980-MOVE-PARA          THRU 2980-EXIT      
                    PERFORM 8100-WRITE-FCSPT331     THRU 8100-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-TEST-CASE-CNT1 = WS-TEST-CASE-LIMIT                 
                 AND WS-TEST-CASE-CNT2 = WS-TEST-CASE-LIMIT             
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35370000
      * 2970-MOVE-PARA                                                * 35380000
      ***************************************************************** 35390000
      *                                                                 35410000
       2970-MOVE-PARA.                                                  
      *                                                                 35410000
           MOVE SPACES                    TO WS-BILL-STATUS.            
           MOVE SPACES                    TO WS-ESTIMATE-STATUS.        
           MOVE WS-COMMA                  TO WS-FILLER1                 
                                             WS-FILLER2                 
                                             WS-FILLER3                 
                                             WS-FILLER4                 
                                             WS-FILLER5                 
                                             WS-FILLER6                 
                                             WS-FILLER7                 
                                             WS-FILLER8.                
           IF WS-NO-DATA-FLAG = WS-NO                                   
                                                                        
             EVALUATE AT-CODE-ACCT-BILLED                               
              WHEN SPACES                                               
                  MOVE 'WAITING FOR READ'      TO WS-BILL-STATUS        
              WHEN 'B'                                                  
                  MOVE 'HELD(READ POSTED)'     TO WS-BILL-STATUS        
              WHEN 'H'                                                  
                  MOVE 'HELD(READ NOT POSTED)' TO WS-BILL-STATUS        
              WHEN 'R'                                                  
                  MOVE 'READ POSTED'           TO WS-BILL-STATUS        
              WHEN 'U'                                                  
                  MOVE 'HELD(READ CORRECTION)' TO WS-BILL-STATUS        
              WHEN 'Y'                                                  
                  MOVE 'ACCOUNT BILLED'        TO WS-BILL-STATUS        
             END-EVALUATE                                               
                                                                        
             EVALUATE UT-CODE-ESTIMATE-OK                               
              WHEN SPACES                                               
                  MOVE 'Okay to est.'          TO WS-ESTIMATE-STATUS    
              WHEN 'A'                                                  
                  MOVE 'Do not manually est.'  TO WS-ESTIMATE-STATUS    
              WHEN 'B'                                                  
                  MOVE 'Do not machine est.'   TO WS-ESTIMATE-STATUS    
              WHEN 'C'                                                  
                  MOVE 'Do not estimate'       TO WS-ESTIMATE-STATUS    
             END-EVALUATE                                               
           END-IF.                                                      
           MOVE WS-TEST-DESCRIPTION       TO WS-DREG-TEST-DESCRIPTION.  
           MOVE WS-ACCOUNT-NO             TO WS-DREG-ACCOUNT-NO.        
           MOVE DF-OPTION-CD              TO WS-DREG-OPTION-CD.         
           MOVE WS-BILL-STATUS            TO WS-DREG-BILL-STATUS.       
           MOVE WS-ESTIMATE-STATUS        TO WS-DREG-ESTIMATE-STATUS.   
           MOVE WS-DREG-REC               TO PRT33-RECORD.              
      *                                                                         
       2970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 35370000
      * 2980-MOVE-PARA                                                * 35380000
      ***************************************************************** 35390000
      *                                                                 35410000
       2980-MOVE-PARA.                                                  
      *                                                                 35410000
           MOVE SPACES                    TO WS-BILL-STATUS.            
           MOVE SPACES                    TO WS-ESTIMATE-STATUS.        
                                                                        
           IF WS-NO-DATA-FLAG = WS-NO                                   
                                                                        
             EVALUATE AT-CODE-ACCT-BILLED                               
              WHEN SPACES                                               
                  MOVE 'WAITING FOR READ'      TO WS-BILL-STATUS        
              WHEN 'B'                                                  
                  MOVE 'HELD(READ POSTED)'     TO WS-BILL-STATUS        
              WHEN 'H'                                                  
                  MOVE 'HELD(READ NOT POSTED)' TO WS-BILL-STATUS        
              WHEN 'R'                                                  
                  MOVE 'READ POSTED'           TO WS-BILL-STATUS        
              WHEN 'U'                                                  
                  MOVE 'HELD(READ CORRECTION)' TO WS-BILL-STATUS        
              WHEN 'Y'                                                  
                  MOVE 'ACCOUNT BILLED'        TO WS-BILL-STATUS        
             END-EVALUATE                                               
                                                                        
             EVALUATE UT-CODE-ESTIMATE-OK                               
              WHEN SPACES                                               
                  MOVE 'Okay to est.'          TO WS-ESTIMATE-STATUS    
              WHEN 'A'                                                  
                  MOVE 'Do not manually est.'  TO WS-ESTIMATE-STATUS    
              WHEN 'B'                                                  
                  MOVE 'Do not machine est.'   TO WS-ESTIMATE-STATUS    
              WHEN 'C'                                                  
                  MOVE 'Do not estimate'       TO WS-ESTIMATE-STATUS    
             END-EVALUATE                                               
                                                                        
           END-IF.                                                      
           MOVE WS-TEST-DESCRIPTION       TO WS-REG-TEST-DESCRIPTION.   
           MOVE WS-ACCOUNT-NO             TO WS-REG-ACCOUNT-NO.         
           MOVE DF-OPTION-CD              TO WS-REG-OPTION-CD.          
           MOVE WS-BILL-STATUS            TO WS-REG-BILL-STATUS.        
           MOVE WS-ESTIMATE-STATUS        TO WS-REG-ESTIMATE-STATUS.    
           MOVE WS-REG-REC                TO PRT331-RECORD.             
      *                                                                         
       2980-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-GET-REV-MTH.                                           **        
      ** GET COMMON REVENUE MONTH FROM JOB_PARM TABLE                 **        
      ******************************************************************        
      *                                                                         
        7000-GET-REV-MTH.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,15,6)                             
                INTO :WS-COMMON-REV-MTH                                 
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'COMMON'                            
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 20                                  
                 AND STATUS       = 'A'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,15,6)                                     
MFA-TR*         INTO :WS-COMMON-REV-MTH                                         
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'COMMON'                                    
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'DATE'                                      
MFA-TR*          AND SEQ_NO       = 20                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7000-GET-REV-MTH       **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7010-GET-BILL-CYCLE                                         **        
      ** GET CURRENT BILL CYCLE FROM BILL_WINDOW TABLE                **        
      ******************************************************************        
      *                                                                         
        7010-GET-BILL-CYCLE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT BN.BILL_CYCLE                                      
                INTO :BN-BILL-CYCLE                                     
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE BN.DATE_EXTRACT = CAST(SYSDATETIMEOFFSET() AS DATE)        
                 AND BN.DATE_EXTRACT =                                  
              (SELECT MIN(B1.DATE_EXTRACT)                              
                FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)                   
               WHERE B1.BILL_CYCLE    = BN.BILL_CYCLE                   
                 AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BN.BILL_CYCLE                                              
MFA-TR*         INTO :BN-BILL-CYCLE                                             
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.DATE_EXTRACT = CURRENT DATE                             
MFA-TR*          AND BN.DATE_EXTRACT =                                          
MFA-TR*       (SELECT MIN(B1.DATE_EXTRACT)                                      
MFA-TR*         FROM CSS_BILL_WINDOW B1                                         
MFA-TR*        WHERE B1.BILL_CYCLE    = BN.BILL_CYCLE                           
MFA-TR*          AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7010-GET-BILL-CYCLE    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-OPEN-DREG-QRY01-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7020-OPEN-DREG-QRY01-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY01                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7020-OPEN-DREG-QRY01-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-FETCH-DREG-QRY01-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7030-FETCH-DREG-QRY01-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY01                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7030-FETCH-DREG-QRY01-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-CLOSE-DREG-QRY01-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7040-CLOSE-DREG-QRY01-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY01                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7200-CLOSE-DREG-QRY01-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-OPEN-DREG-QRY02-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7050-OPEN-DREG-QRY02-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY02                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7050-OPEN-DREG-QRY02-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7060-FETCH-DREG-QRY02-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7060-FETCH-DREG-QRY02-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY02                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7060-FETCH-DREG-QRY02-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7070-CLOSE-DREG-QRY02-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7070-CLOSE-DREG-QRY02-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY02                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7070-CLOSE-DREG-QRY02-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7080-OPEN-DREG-QRY03-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7080-OPEN-DREG-QRY03-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY03                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7080-OPEN-DREG-QRY03-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7090-FETCH-DREG-QRY03-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7090-FETCH-DREG-QRY03-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY03                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7090-FETCH-DREG-QRY03-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-CLOSE-DREG-QRY03-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7100-CLOSE-DREG-QRY03-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY03                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7100-CLOSE-DREG-QRY03-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7110-OPEN-DREG-QRY04-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7110-OPEN-DREG-QRY04-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY04                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7110-OPEN-DREG-QRY04-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-FETCH-DREG-QRY04-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-DREG-QRY04-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY04                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7120-FETCH-DREG-QRY04-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-CLOSE-DREG-QRY04-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7130-CLOSE-DREG-QRY04-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY04                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7130-CLOSE-DREG-QRY04-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7140-OPEN-DREG-QRY05-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7140-OPEN-DREG-QRY05-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY05                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7140-OPEN-DREG-QRY05-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-FETCH-DREG-QRY05-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7150-FETCH-DREG-QRY05-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY05                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7150-FETCH-DREG-QRY05-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7160-CLOSE-DREG-QRY05-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7160-CLOSE-DREG-QRY05-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY05                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7160-CLOSE-DREG-QRY05-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-OPEN-DREG-QRY06-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7170-OPEN-DREG-QRY06-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY06                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7170-OPEN-DREG-QRY06-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7180-FETCH-DREG-QRY06-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7180-FETCH-DREG-QRY06-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY06                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7180-FETCH-DREG-QRY06-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7190-CLOSE-DREG-QRY06-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7190-CLOSE-DREG-QRY06-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY06                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7190-CLOSE-DREG-QRY06-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-DREG-QRY08-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-DREG-QRY08-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY08                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7200-OPEN-DREG-QRY08-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7210-FETCH-DREG-QRY08-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7210-FETCH-DREG-QRY08-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY08                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7210-FETCH-DREG-QRY08-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7220-CLOSE-DREG-QRY08-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7220-CLOSE-DREG-QRY08-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY08                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7220-CLOSE-DREG-QRY08-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-OPEN-DREG-QRY09-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7230-OPEN-DREG-QRY09-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY09                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7230-OPEN-DREG-QRY09-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7240-FETCH-DREG-QRY09-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7240-FETCH-DREG-QRY09-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY09                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7240-FETCH-DREG-QRY09-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-CLOSE-DREG-QRY09-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7250-CLOSE-DREG-QRY09-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY09                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7250-CLOSE-DREG-QRY09-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7260-OPEN-DREG-QRY10-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7260-OPEN-DREG-QRY10-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY10                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7260-OPEN-DREG-QRY10-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7270-FETCH-DREG-QRY10-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7270-FETCH-DREG-QRY10-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY10                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7270-FETCH-DREG-QRY10-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7280-CLOSE-DREG-QRY10-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7280-CLOSE-DREG-QRY10-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY10                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7280-CLOSE-DREG-QRY10-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7290-OPEN-DREG-QRY07-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7290-OPEN-DREG-QRY07-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY07                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7290-OPEN-DREG-QRY07-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-FETCH-DREG-QRY07-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7300-FETCH-DREG-QRY07-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY07                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7300-FETCH-DREG-QRY07-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7310-CLOSE-DREG-QRY07-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7310-CLOSE-DREG-QRY07-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY07                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7310-CLOSE-DREG-QRY07-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-OPEN-DREG-QRY12-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7320-OPEN-DREG-QRY12-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY12                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7320-OPEN-DREG-QRY12-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7330-FETCH-DREG-QRY12-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7330-FETCH-DREG-QRY12-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY12                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7330-FETCH-DREG-QRY12-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7340-CLOSE-DREG-QRY12-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7340-CLOSE-DREG-QRY12-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY12                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7340-CLOSE-DREG-QRY12-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7350-CHECK-RENEWED-RATE.                                       *        
      * CHECK RENEWED RATE EXISTENCE FOR A SPECIFIC DURATION           *        
      ******************************************************************        
      *                                                                         
       7350-CHECK-RENEWED-RATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-RENEWED-FL                                     
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
                    ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.STATUS_CD          = 'A'                        
                 AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH           
                 AND DF.OPTION_CD          = FI.OPTION_CD               
                 AND HQ.OPTION_CD          = DF.OPTION_CD               
                 AND HQ.DURATION_NO        = :WS-RENEWED-DUR-NO         
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
                 AND FI.OPT_CALC_TYPE_CD   = 'FP'                       
                 AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()         
                 AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()         
                 AND FI.PROC_STATUS_CD      = 'AC'                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RENEWED-FL                                             
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.STATUS_CD          = 'A'                                
MFA-TR*          AND DF.STATUS_EFF_REV_MTH = :WS-PARM-REV-MTH                   
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND HQ.OPTION_CD          = DF.OPTION_CD                       
MFA-TR*          AND HQ.DURATION_NO        = :WS-RENEWED-DUR-NO                 
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND FI.OPT_CALC_TYPE_CD   = 'FP'                               
MFA-TR*          AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP                 
MFA-TR*          AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP                 
MFA-TR*          AND FI.PROC_STATUS_CD      = 'AC'                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             CONTINUE                                                   
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7350-CHECK-RENEWED-RATE **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  DF-ACCOUNT-NO = ' DF-ACCOUNT-NO              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-RENEWED-DUR-NO = ' WS-RENEWED-DUR-NO      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7360-OPEN-DREG-QRY13-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7360-OPEN-DREG-QRY13-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY13                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7360-OPEN-DREG-QRY13-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7370-FETCH-DREG-QRY13-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7370-FETCH-DREG-QRY13-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY13                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7370-FETCH-DREG-QRY13-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7380-CLOSE-DREG-QRY13-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7380-CLOSE-DREG-QRY13-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY13                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7380-CLOSE-DREG-QRY13-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  WS-ANNIVERSARY-DATE = ' WS-ANNIVERSARY-DATE  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7390-OPEN-DREG-QRY14-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7390-OPEN-DREG-QRY14-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY14                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7390-OPEN-DREG-QRY14-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7390-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-FETCH-DREG-QRY14-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7400-FETCH-DREG-QRY14-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY14                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7400-FETCH-DREG-QRY14-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7410-CLOSE-DREG-QRY14-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7410-CLOSE-DREG-QRY14-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY14                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7410-CLOSE-DREG-QRY14-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-DURATION-NO = ' WS-DURATION-NO            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7420-OPEN-DREG-QRY11-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7420-OPEN-DREG-QRY11-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN DREG_QRY11                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7420-OPEN-DREG-QRY11-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  FF-FACTOR-ID = ' FF-FACTOR-ID                
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7430-FETCH-DREG-QRY11-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7430-FETCH-DREG-QRY11-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH DREG_QRY11                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:FF-DURATION-REMAIN-NO                              
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7430-FETCH-DREG-QRY11-CSR*'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  FF-FACTOR-ID = ' FF-FACTOR-ID                
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7440-CLOSE-DREG-QRY11-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7440-CLOSE-DREG-QRY11-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE DREG_QRY11                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7440-CLOSE-DREG-QRY11-CSR'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  FF-FACTOR-ID = ' FF-FACTOR-ID                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-OPEN-REG-QRY01-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7450-OPEN-REG-QRY01-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY01                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7450-OPEN-REG-QRY01-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7460-FETCH-REG-QRY01-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7460-FETCH-REG-QRY01-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY01                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7460-FETCH-REG-QRY01-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7470-CLOSE-REG-QRY01-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7470-CLOSE-REG-QRY01-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY01                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7470-CLOSE-REG-QRY01-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7480-OPEN-REG-QRY02-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7480-OPEN-REG-QRY02-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY02                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7480-OPEN-REG-QRY02-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7480-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7490-FETCH-REG-QRY02-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7490-FETCH-REG-QRY02-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY02                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7490-FETCH-REG-QRY02-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7490-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-CLOSE-REG-QRY02-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7500-CLOSE-REG-QRY02-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY02                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7500-CLOSE-REG-QRY02-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7510-OPEN-REG-QRY03-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7510-OPEN-REG-QRY03-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY03                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7510-OPEN-REG-QRY03-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7520-FETCH-REG-QRY03-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7520-FETCH-REG-QRY03-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY03                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7520-FETCH-REG-QRY03-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7530-CLOSE-REG-QRY03-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7530-CLOSE-REG-QRY03-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY03                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7530-CLOSE-REG-QRY03-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  WS-60-DAY-ANNIV = ' WS-60-DAY-ANNIV          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7540-OPEN-REG-QRY04-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7540-OPEN-REG-QRY04-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY04                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7540-OPEN-REG-QRY04-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7550-FETCH-REG-QRY04-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7550-FETCH-REG-QRY04-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY04                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7550-FETCH-REG-QRY04-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7560-CLOSE-REG-QRY04-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7560-CLOSE-REG-QRY04-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY04                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7560-CLOSE-REG-QRY04-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7570-OPEN-REG-QRY05-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7570-OPEN-REG-QRY05-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY05                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7570-OPEN-REG-QRY05-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7580-FETCH-REG-QRY05-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7580-FETCH-REG-QRY05-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY05                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7580-FETCH-REG-QRY05-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7590-CLOSE-REG-QRY05-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7590-CLOSE-REG-QRY05-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY05                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7590-CLOSE-REG-QRY05-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-OPEN-REG-QRY10-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7600-OPEN-REG-QRY10-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY10                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7600-OPEN-REG-QRY10-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7610-FETCH-REG-QRY10-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7610-FETCH-REG-QRY10-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY10                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7610-FETCH-REG-QRY10-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7620-CLOSE-REG-QRY10-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7620-CLOSE-REG-QRY10-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY10                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7620-CLOSE-REG-QRY10-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7630-OPEN-REG-QRY06-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7630-OPEN-REG-QRY06-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY06                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7630-OPEN-REG-QRY06-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7640-FETCH-REG-QRY06-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7640-FETCH-REG-QRY06-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY06                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7640-FETCH-REG-QRY06-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7650-CLOSE-REG-QRY06-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7650-CLOSE-REG-QRY06-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY06                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7650-CLOSE-REG-QRY06-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7660-OPEN-REG-QRY07-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7660-OPEN-REG-QRY07-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY07                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7660-OPEN-REG-QRY07-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7670-FETCH-REG-QRY07-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7670-FETCH-REG-QRY07-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY07                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7670-FETCH-REG-QRY07-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD  = ' WS-TEMP-OPTION-CD     
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7670-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7680-CLOSE-REG-QRY07-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7680-CLOSE-REG-QRY07-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY07                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7680-CLOSE-REG-QRY07-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD  = ' WS-TEMP-OPTION-CD     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7680-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7690-OPEN-REG-QRY08-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7690-OPEN-REG-QRY08-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY08                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7690-OPEN-REG-QRY08-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7690-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-FETCH-REG-QRY08-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7700-FETCH-REG-QRY08-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY08                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7700-FETCH-REG-QRY08-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7710-CLOSE-REG-QRY08-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7710-CLOSE-REG-QRY08-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY08                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7710-CLOSE-REG-QRY08-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7720-OPEN-REG-QRY11-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7720-OPEN-REG-QRY11-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY11                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7720-OPEN-REG-QRY11-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**UT-GAS-BASE-LAST-UPDT = ' UT-GAS-BASE-LAST-UPDT
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7730-FETCH-REG-QRY11-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7730-FETCH-REG-QRY11-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY11                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7730-FETCH-REG-QRY11-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**UT-GAS-BASE-LAST-UPDT = ' UT-GAS-BASE-LAST-UPDT
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7740-CLOSE-REG-QRY11-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7740-CLOSE-REG-QRY11-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY11                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7740-CLOSE-REG-QRY11-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**UT-GAS-BASE-LAST-UPDT = ' UT-GAS-BASE-LAST-UPDT
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7750-CHECK-RATE-TYPE.                                          *        
      * SELECT THE RATE TYPE OF AN ACCOUNT                             *        
      ******************************************************************        
      *                                                                         
       7750-CHECK-RATE-TYPE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-FIXED-RATE-FL                                  
                FROM CSS_SPCL_FCTR           SF WITH(READUNCOMMITTED)           
                    ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
                    ,CSS_UTIL_ENVRNMT        UT WITH(READUNCOMMITTED)           
                    ,CSS_ACCT_RTPK_AGR       DF WITH(READUNCOMMITTED)           
               WHERE SF.FACTOR_ID          = HQ.FACTOR_ID               
                 AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO              
                 AND UT.COMPANY_NO         = DF.COMPANY_NO              
                 AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE          
                 AND UT.IC_NO              = DF.IC_NO                   
                 AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO       
                 AND HQ.COMPANY_NO         = DF.COMPANY_NO              
                 AND HQ.OPTION_CD          = DF.OPTION_CD               
                 AND DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.IC_NO              = 1                          
                 AND DF.CODE_UTIL_TYPE     = 'G'                        
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
                 AND SF.OVR_RT_CALC_TYP_CD  = '02'                      
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-FIXED-RATE-FL                                          
MFA-TR*         FROM CSS_SPCL_FCTR           SF                                 
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CSS_UTIL_ENVRNMT        UT                                 
MFA-TR*             ,CSS_ACCT_RTPK_AGR       DF                                 
MFA-TR*        WHERE SF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO                      
MFA-TR*          AND UT.COMPANY_NO         = DF.COMPANY_NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                  
MFA-TR*          AND UT.IC_NO              = DF.IC_NO                           
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO               
MFA-TR*          AND HQ.COMPANY_NO         = DF.COMPANY_NO                      
MFA-TR*          AND HQ.OPTION_CD          = DF.OPTION_CD                       
MFA-TR*          AND DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.IC_NO              = 1                                  
MFA-TR*          AND DF.CODE_UTIL_TYPE     = 'G'                                
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND SF.OVR_RT_CALC_TYP_CD  = '02'                              
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7750-CHECK-RATE-TYPE    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  DF-ACCOUNT-NO = ' DF-ACCOUNT-NO              
              DISPLAY '**  WS-PARM-REV-MTH = ' WS-PARM-REV-MTH          
              DISPLAY '**  WS-RENEWED-DUR-NO = ' WS-RENEWED-DUR-NO      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7760-OPEN-REG-QRY12-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7760-OPEN-REG-QRY12-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY12                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7760-OPEN-REG-QRY12-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-NEXT5-BUSINESS-CYCLE = '                  
                           WS-NEXT5-BUSINESS-CYCLE                      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7770-FETCH-REG-QRY12-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7770-FETCH-REG-QRY12-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY12                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:UT-IC-NO                                           
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7770-FETCH-REG-QRY12-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  WS-NEXT5-BUSINESS-CYCLE = '                  
                           WS-NEXT5-BUSINESS-CYCLE                      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7780-CLOSE-REG-QRY12-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7780-CLOSE-REG-QRY12-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY12                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7780-CLOSE-REG-QRY12-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-NEXT5-BUSINESS-CYCLE = '                  
                           WS-NEXT5-BUSINESS-CYCLE                      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7780-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7790-FETCH-CRED-PROF.                                          *        
      ******************************************************************        
      *                                                                         
       7790-FETCH-CRED-PROF.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT ARREARS_HIST                                       
                    ,DISCONNECT_HIST                                    
                    ,DISC_EXCEPTN_HIST                                  
                    ,NON_UTL_CR_HST                                     
                    ,NON_UTL_CR_HST_EX                                  
                    ,NON_UTL_ARRER_HIST                                 
                INTO :CZ-ARREARS-HIST                                   
                    ,:CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                    ,:CZ-NON-UTL-CR-HST                                 
                    ,:CZ-NON-UTL-CR-HST-EX                              
                    ,:CZ-NON-UTL-ARRER-HIST                             
                FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ARREARS_HIST                                               
MFA-TR*             ,DISCONNECT_HIST                                            
MFA-TR*             ,DISC_EXCEPTN_HIST                                          
MFA-TR*             ,NON_UTL_CR_HST                                             
MFA-TR*             ,NON_UTL_CR_HST_EX                                          
MFA-TR*             ,NON_UTL_ARRER_HIST                                         
MFA-TR*         INTO :CZ-ARREARS-HIST                                           
MFA-TR*             ,:CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*             ,:CZ-NON-UTL-CR-HST                                         
MFA-TR*             ,:CZ-NON-UTL-CR-HST-EX                                      
MFA-TR*             ,:CZ-NON-UTL-ARRER-HIST                                     
MFA-TR*         FROM CSS_CREDIT_PROFILE CZ                                      
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7790-FETCH-CRED-PROF     *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  CZ-ACCOUNT-NO = ' CZ-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7790-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-OPEN-REG-QRY09-CSR.                                       *        
      ******************************************************************        
      *                                                                         
       7800-OPEN-REG-QRY09-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REG_QRY09                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7800-OPEN-REG-QRY09-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7810-FETCH-REG-QRY09-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7810-FETCH-REG-QRY09-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REG_QRY09                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:DF-OPTION-CD                                       
                   ,:UT-GAS-BASE-LAST-UPDT :wS-NULL-IND                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:UT-CODE-ESTIMATE-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-ALL-DATA-FOUND          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7810-FETCH-REG-QRY09-CSR *'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7820-CLOSE-REG-QRY09-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7820-CLOSE-REG-QRY09-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REG_QRY09                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT *****'                   
              DISPLAY '**  7820-CLOSE-REG-QRY09-CSR '                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-REV-MTH-LST-NRML = ' AT-REV-MTH-LST-NRML  
              DISPLAY '**  AT-BILL-CYCLE = ' AT-BILL-CYCLE              
              DISPLAY '**  WS-TEMP-OPTION-CD = ' WS-TEMP-OPTION-CD      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7830-GET-CUST-DOB.                                             *        
      ******************************************************************        
      *                                                                         
       7830-GET-CUST-DOB.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CE.DOB_VERIFIED_CD,
              CE.DATE_OF_BIRTH                                   
                INTO :CE-DOB-VERIFIED-CD                                
                    ,:CE-DATE-OF-BIRTH :WS-NULL-IND1                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                 AND CU.CUSTOMER_NO = AT.CUSTOMER_NO                    
                 AND CE.CUSTOMER_NO = CU.CUSTOMER_NO                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CE.DOB_VERIFIED_CD                                         
MFA-TR*             ,CE.DATE_OF_BIRTH                                           
MFA-TR*         INTO :CE-DOB-VERIFIED-CD                                        
MFA-TR*             ,:CE-DATE-OF-BIRTH:WS-NULL-IND1                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_CUST_STATS CE                                          
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*          AND CU.CUSTOMER_NO = AT.CUSTOMER_NO                            
MFA-TR*          AND CE.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7830-GET-CUST-DOB       **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7840-GET-CUST-AGE.                                             *        
      ******************************************************************        
      *                                                                         
       7840-GET-CUST-AGE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                   ( 12 *  CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT LTRIM(
                                                            :WS-DT-1 + 
           ' ') E) T), (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT LTRIM(
                                                            :WS-DT-2 + 
           ' ') E) T) ) )          
                        + CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT LTRIM(
                                                            :WS-DT-1 + 
           ' ') E) T), (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT LTRIM(
                                                            :WS-DT-2 + 
           ' ') E) T) ) ) ) / 12   
                INTO :WS-CUST-AGE                                       
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            ( 12 *  YEAR(DATE(LTRIM(:WS-DT-1 || ' '))                    
MFA-TR*                       - DATE(LTRIM(:WS-DT-2 || ' ')) )                  
MFA-TR*                 + MONTH(DATE(LTRIM(:WS-DT-1 || ' '))                    
MFA-TR*                       - DATE(LTRIM(:WS-DT-2 || ' ')) ) ) / 12           
MFA-TR*         INTO :WS-CUST-AGE                                               
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP977 ABORT ******'                  
              DISPLAY '**  7840-GET-CUST-AGE       **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
           DISPLAY '9000-TERMINATE'.                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
