       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP917.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  05/27/08  RV           INITIAL VERSION                                
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSRP917 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM REPORTS THE TOTAL NUMBER OF BILLS PRINTED FOR **         
      **  THE COMPANY IN THE CYCLE WITH THE SPLIT UP OF GROUP1,      **         
      **  GROUP2, NUMBER OF ACCOUNTS WITH PULLCODES, CANCEL/REBILLS, **         
      **  GROUP4, GROUP5,  PAPERLESS BILLS, CONS, SECURED, PCOMP,    **         
      **  DUPS, INT'L AND CODEZ. IT ALSO SHOWS THE COUNT ON DIFFERENT**         
      **  PULLCODES THE ACCOUNTS WERE BILLED AND PRINTED.            **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA912.                                                       
      ******************************************************************CSS00010
      * SELECT STATEMENT FOR SECURED SORT INDEX FILE                   *CSS00020
      ******************************************************************CSS00040
           SELECT FCSSEC-FILE                                           
               ASSIGN UT-S-FCSSECRD                                     
               FILE STATUS IS WS-SECURED-STATUS.                        
      ******************************************************************CSS00010
      * SELECT STATEMENT FOR BE51 FILE                                 *CSS00020
      ******************************************************************CSS00040
           SELECT FCSBE51-FILE                                          
               ASSIGN UT-S-FCSBE51                                      
               FILE STATUS IS WS-BE51-STATUS.                           
           COPY CSSPT33.                                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA912.                                                       
           COPY SORTINDX.                                                       
      ******************************************************************        
      * FD STATEMENT FOR A BE51 FILE                                   *        
      ******************************************************************        
       FD  FCSBE51-FILE                                                 
            BLOCK CONTAINS 0 RECORDS                                    
            RECORD CONTAINS 80 CHARACTERS                               
            RECORDING MODE IS F                                         
            LABEL RECORDS ARE STANDARD.                                 
       01  FCSBE51-REC                PIC X(80).                        
      ******************************************************************        
      * FD STATEMENT FOR A SECURED SORT INDEX FILE                     *        
      ******************************************************************        
       FD  FCSSEC-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FCSSEC-SORTIDX-FILE              PIC X(800).                 
           COPY CFDPT33.                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP917'.
MSQ017     COPY MFASQLM.
      *                                                                         
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00004.                                                       
           COPY CWS00010.                                                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DIFF-PULLCODE              PIC 9(2)  VALUE ZERO.      
           05  WS-DIFF-PULLCODE1             PIC 9(2)  VALUE ZERO.      
           05  SUB1                          PIC 9(2)  VALUE ZERO.      
           05  SUB2                          PIC 9(2)  VALUE ZERO.      
           05  WS-CYCLE                      PIC X(2)  VALUE SPACES.    
           05  WS-TOTAL                      PIC 9(5)  VALUE ZEROES.    
           05  WS-GROUP1                     PIC 9(5)  VALUE ZEROES.    
           05  WS-GROUP2                     PIC 9(5)  VALUE ZEROES.    
           05  WS-PULL-CODES                 PIC 9(5)  VALUE ZEROES.    
           05  WS-CORRECTED                  PIC 9(5)  VALUE ZEROES.    
           05  WS-GROUP4                     PIC 9(5)  VALUE ZEROES.    
           05  WS-GROUP5                     PIC 9(5)  VALUE ZEROES.    
           05  WS-PAPERLESS                  PIC 9(5)  VALUE ZEROES.    
           05  WS-CONS                       PIC 9(5)  VALUE ZEROES.    
           05  WS-SECURED                    PIC 9(5)  VALUE ZEROES.    
           05  WS-PCOMP                      PIC 9(5)  VALUE ZEROES.    
           05  WS-DUPS                       PIC 9(5)  VALUE ZEROES.    
           05  WS-INTL                       PIC 9(5)  VALUE ZEROES.    
           05  WS-CODEZ                      PIC 9(5)  VALUE ZEROES.    
           05  P-RUN-DATE                    PIC X(10).                 
           05  WS-NULL-IND                   PIC S9(4) COMP.            
           05  WS-SUBSID-ID                  PIC X(05) VALUE SPACES.    
           05  WS-HOLD-ACCOUNT-NO            PIC X(13) VALUE SPACES.    
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY           PIC 9(04).                 
               10  WS-CURRENT-MM             PIC 9(02).                 
               10  WS-CURRENT-DD             PIC 9(02).                 
               10  WS-CURRENT-HH             PIC 9(02).                 
               10  WS-CURRENT-MS             PIC 9(02).                 
               10  WS-CURRENT-SS             PIC 9(02).                 
           05  WS-REVENUE-MONTH              PIC 9(6).                  
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10 WS-REV-CCYY                PIC 9(4).                  
               10 WS-REV-MM                  PIC 9(2).                  
                                                                        
           05  WS-LINE-COUNT-01             PIC S9(03) COMP-3 VALUE +99.
           05  WS-PAGE-COUNT-01              PIC S9(05) COMP-3 VALUE +0.
                                                                        
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MONTH           PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-DAY             PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-YEAR            PIC X(4).                  
                                                                        
           05  WS-TODAYS-DATE                PIC 9(08)    VALUE  0.     
           05  WS-TIME-OF-DAY                PIC 9(08)    VALUE  0.     
           05  WS-RUN-DATE                   PIC X(10).                 
           05  WS-SYS-DATE                   PIC 9(06) VALUE ZEROES.    
           05  FILLER                  REDEFINES                        
               WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY            PIC 9(02).                 
               10  WS-SYS-DATE-MM            PIC 9(02).                 
               10  WS-SYS-DATE-DD            PIC 9(02).                 
           05  WS-SYSTEM-DATE.                                          
               10  WS-SYST-YY                PIC 99.                    
               10  WS-SYST-MM                PIC 99.                    
               10  WS-SYST-DD                PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-SYSTEM-TIME.                                          
               10  WS-SYSTEM-HH              PIC 99.                    
               10  WS-SYSTEM-MM              PIC 99.                    
               10  WS-SYSTEM-SS              PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-RUN-TIME.                                             
               10  WS-RUN-HH                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-MM                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-SS                 PIC 99.                    
      *                                                                         
      *                                                                         
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  WS-DET-SUBSID-ID    PIC X(05).                       
               10  WS-DET-REV-MONTH    PIC X(06).                       
               10  WS-DET-BILL-CYCLE   PIC X(02).                       
               10  WS-DET-DATE-BILLED  PIC X(10).                       
               10  WS-DET-DEST-CODE    PIC X(01).                       
               10  WS-DET-PULL-CODE    PIC X(01).                       
               10  WS-DET-CD-COUNT     PIC 9(05).                       
      *                                                                         
       01  WS-PULLCODE-TABLE.                                           
           05 WS-PULLCODE-TAB                 OCCURS 100 TIMES.         
              10  WS-EXCP-CD.                                           
                  15  WS-DEST-CD              PIC X(1) VALUE SPACES.    
                  15  WS-PULL-CD              PIC X(1) VALUE SPACES.    
              10  WS-PULL-CT                  PIC 9(5) VALUE ZEROES.    
      *                                                                         
*******TO STORE PULL CODES WHICH HAVE DESTINATION CODE OTHER THAN 'C'           
       01  WS-PULLCODE-TABLE-WC.                                        
           05 WS-PULLCODE-TAB-WC              OCCURS 100 TIMES.         
              10  WS-EXCP-CD-WC.                                        
                  15  WS-DEST-CD-WC           PIC X(1) VALUE SPACES.    
                  15  WS-PULL-CD-WC           PIC X(1) VALUE SPACES.    
              10  WS-PULL-CT-WC               PIC 9(5) VALUE ZEROES.    
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-CA912               PIC X     VALUE 'N'.       
               88  END-OF-CA912                        VALUE 'Y'.       
           05  WS-END-OF-SECURED             PIC X     VALUE 'N'.       
               88  END-OF-SECURED                      VALUE 'Y'.       
           05  WS-CA912-STATUS               PIC XX    VALUE '  '.      
               88  CA912-SUCCESSFUL                    VALUE '00'.      
           05  WS-SECURED-STATUS             PIC XX    VALUE '  '.      
               88  SECURED-SUCCESSFUL                  VALUE '00'.      
           05  WS-BE51-STATUS                PIC  X(02).                
               88 BE51-SUCCESSFUL                      VALUE '00'.      
           05  WS-FCA32-STATUS               PIC XX    VALUE '00'.      
               88  FCA32-SUCCESSFUL                    VALUE '00'.      
           05  WS-FOUND-FLAG                 PIC X(1)  VALUE 'N'.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC X(12)  VALUE 'PCSRP917-001'.
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-RPT1-HEAD                  PIC X(50) VALUE            
               '         TOTAL NUMBER OF BILLS PRINTED            '.    
           05  WS-RPT1-SCEG-TITLE            PIC X(50)     VALUE        
               '         SOUTH CAROLINA ELECTRIC AND GAS          '.    
           05  WS-RPT1-PSNC-TITLE            PIC X(50)     VALUE        
               '                   PSNC ENERGY                    '.    
           05  WS-RPT1-SEB-TITLE             PIC X(50)     VALUE        
               '                   SCANA ENERGY                   '.    
           05  WS-RPT1-SEBR-TITLE            PIC X(50)     VALUE        
               '          SCANA ENERGY REGULATED DIVISION         '.    
           05  WS-RPT1-SVC-TITLE             PIC X(50)     VALUE        
               '                    SERVICECARE                   '.    
                                                                        
       01  WS-BLANK-LINE                   PIC X(132) VALUE SPACES.     
                                                                        
       01  P-HEADER-LINE-1.                                             
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(07)  VALUE 'DATE: '.      
           05  P-REPORT-DATE            PIC X(10).                      
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(11)  VALUE 'RUN TIME:  '. 
           05  P-RUN-TIME               PIC X(08).                      
           05  P-RPT1-TITLE             PIC X(50).                      
           05  FILLER                   PIC X(27)  VALUE SPACES.        
           05  FILLER                   PIC X(09)  VALUE 'PAGE:    '.   
           05  P-PAGE-NO                PIC X      VALUE '1'.           
                                                                        
       01  P-HEADER-LINE-2.                                             
           05  FILLER                   PIC X(02)  VALUE SPACES.        
           05  P-RPT1-NAME              PIC X(12).                      
           05  FILLER                   PIC X(30) VALUE SPACES.         
           05  P-RPT1-HEAD              PIC X(50).                      
           05  FILLER                   PIC X(24) VALUE SPACES.         
           05  FILLER                   PIC X(09) VALUE 'CYCLE:   '.    
           05  P-PRT-CYCLE              PIC Z9.                         
                                                                        
       01  P-HEADER-LINE-3.                                             
           05  FILLER                      PIC X(2) VALUE SPACES.       
           05  FILLER                      PIC X(05) VALUE 'TOTAL'.     
           05  FILLER                      PIC X(05) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'GRP1'.      
           05  FILLER                      PIC X(05) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'GRP2'.      
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(09) VALUE 'PULLCODES'. 
           05  FILLER                      PIC X(03) VALUE SPACES.      
           05  FILLER                      PIC X(10) VALUE 'CAN/REBILL'.
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'GRP4'.      
           05  FILLER                      PIC X(05) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'GRP5'.      
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(09) VALUE 'PAPERLESS'. 
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'CONS'.      
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(07) VALUE 'SECURED'.   
           05  FILLER                      PIC X(03) VALUE SPACES.      
           05  FILLER                      PIC X(05) VALUE 'PCOMP'.     
           05  FILLER                      PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(04) VALUE 'DUPS'.      
           05  FILLER                      PIC X(02) VALUE SPACES.      
           05  FILLER                      PIC X(05) VALUE "INT'L".     
           05  FILLER                      PIC X(03) VALUE SPACES.      
           05  FILLER                      PIC X(05) VALUE 'CODEZ'.     
                                                                        
       01  P-DETAIL-LINE-1.                                             
           05  FILLER                      PIC X(1)   VALUE SPACE.      
           05  WS-TOTAL-ED                 PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACE.      
           05  WS-GROUP1-ED                PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACES.     
           05  WS-GROUP2-ED                PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(04)  VALUE SPACES.     
           05  WS-PULL-CODES-ED            PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(05)  VALUE SPACES.     
           05  WS-CORRECTED-ED             PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(07)  VALUE SPACES.     
           05  WS-GROUP4-ED                PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACES.     
           05  WS-GROUP5-ED                PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(04)  VALUE SPACES.     
           05  WS-PAPERLESS-ED             PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(05)  VALUE SPACES.     
           05  WS-CONS-ED                  PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACES.     
           05  WS-SECURED-ED               PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACES.     
           05  WS-PCOMP-ED                 PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(03)  VALUE SPACES.     
           05  WS-DUPS-ED                  PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(01)  VALUE SPACES.     
           05  WS-INTL-ED                  PIC ZZ,ZZ9 VALUE ZEROES.     
           05  FILLER                      PIC X(02)  VALUE SPACES.     
           05  WS-CODEZ-ED                 PIC ZZ,ZZ9 VALUE ZEROES.     
                                                                        
       01  P-HEADER-LINE-4.                                             
           05  FILLER                   PIC X(61)    VALUE SPACES.      
           05  FILLER                   PIC X(10)    VALUE 'PULL CODES'.
           05  FILLER                   PIC X(62)    VALUE SPACES.      
                                                                        
       01  P-HEADER-LINE-5.                                             
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(07)    VALUE SPACES.      
           05  FILLER                   PIC X(09)    VALUE 'CD  /  CT'. 
           05  FILLER                   PIC X(10)    VALUE SPACES.      
                                                                        
       01  P-DETAIL-LINE-6N.                                            
           05  FILLER                   PIC X(02)    VALUE SPACES.      
           05  WS-CD-1                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-1                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-2                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-2                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-3                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-3                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-4                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-4                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-5                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-5                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-6                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-6                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-7                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-7                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(08)    VALUE SPACES.      
           05  WS-CD-8                  PIC X(01).                      
           05  FILLER                   PIC X(01)    VALUE SPACES.      
           05  WS-CT-8                  PIC ZZ,ZZZ.                     
           05  FILLER                   PIC X(10)    VALUE SPACES.      
      *                                                                         
      *****SQL COMMUNICATION AREA**************************                     
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *****JOB PARM****************************************                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *****DCLGEN FOR CSS_BILL_WINDOW.*********************                     
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM.                                                        
           05 LNGTH                        PIC S9(04) COMP.             
           05 WS-COMPANY                   PIC X(04).                   
           05  WS-JCL-PARM-DATE            PIC X(10).                   
      *                                                                         
       PROCEDURE DIVISION USING PARM.                                   
      *                                                                         
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    ** 00065600
      ***************************************************************** 00065700
       0000-MAINLINE.                                                   
      *                                                                         
           DISPLAY '*****PCSRP917 EXECUTING********'                    
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-FILES       THRU 1000-EXIT.             
           PERFORM 8000-WRITE-CA32-REPORT   THRU 8000-EXIT.             
           PERFORM 8200-WRITE-BE51-REPORT   THRU 8200-EXIT.             
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  GET DATES, TIMES, TITLES FOR REPORT HEADERS.                 *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE                     WS-PULLCODE-TABLE             
                                          WS-PULLCODE-TABLE-WC.         
      *                                                                         
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                       TO WS-CURRENT-DATE.              
           STRING    WS-CURRENT-MM                                      
                     '-'                                                
                     WS-CURRENT-DD                                      
                     '-'                                                
                     WS-CURRENT-CCYY                                    
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-DATE.                 
           MOVE P-RUN-DATE             TO P-REPORT-DATE.                
                                                                        
           STRING    WS-CURRENT-HH                                      
                     ':'                                                
                     WS-CURRENT-MS                                      
                     ':'                                                
                     WS-CURRENT-SS                                      
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-TIME.                 
      *                                                                         
      *** GET THE REVENUE MONTH USING JOB PARM.                                 
           MOVE 'COMMON'               TO G6-PROGRAM-NAME.              
           MOVE 20                     TO G6-SEQ-NO.                    
           MOVE '01'                   TO G6-COMPANY-NO.                
           MOVE 'A'                    TO G6-STATUS.                    
           MOVE 'DATE'                 TO G6-CMND-CODE.                 
           PERFORM 7700-GET-REVMON-DTBILL THRU 7700-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  AND              
              G6-PARM-DATA (1:14) = 'REVENUE-MONTH='                    
               MOVE G6-PARM-DATA(15:6) TO WS-REVENUE-MONTH              
            ELSE                                                        
               MOVE ZEROS              TO WS-REVENUE-MONTH              
           END-IF.                                                      
           MOVE 10                     TO G6-SEQ-NO.                    
           PERFORM 7700-GET-REVMON-DTBILL THRU 7700-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  AND              
              G6-PARM-DATA (1:9) = 'RUN DATE='                          
               MOVE G6-PARM-DATA(10:10) TO WS-CURRENT-DATE              
            ELSE                                                        
               MOVE SPACES              TO WS-CURRENT-DATE              
           END-IF.                                                      
           IF WS-JCL-PARM-DATE NOT = 'CCYY-MM-DD'                       
               MOVE WS-JCL-PARM-DATE    TO WS-CURRENT-DATE              
               DISPLAY 'PCSRP917 USING JCL PARM DATE =' WS-JCL-PARM-DATE
           END-IF.                                                      
      *                                                                         
           MOVE WS-CURRENT-DATE         TO BN-DATE-EXTRACT.             
           MOVE 'R'                     TO BN-CODE-BILL-COND.           
           MOVE WS-REVENUE-MONTH        TO BN-REVENUE-MONTH.            
           IF WS-COMPANY = 'SCEG' OR 'PSNC'                             
              PERFORM 7500-CSR-BILL-CYCLE     THRU 7500-EXIT            
           ELSE                                                         
              PERFORM 7600-SEB-BILL-CYCLE     THRU 7600-EXIT            
           END-IF.                                                      
      *                                                                         
           EVALUATE WS-COMPANY                                          
              WHEN 'SCEG'                                               
              MOVE WS-RPT1-SCEG-TITLE   TO P-RPT1-TITLE                 
              MOVE 'SCE&G'              TO WS-SUBSID-ID                 
              WHEN 'PSNC'                                               
              MOVE WS-RPT1-PSNC-TITLE   TO P-RPT1-TITLE                 
              MOVE 'PSNC '              TO WS-SUBSID-ID                 
              WHEN 'SEB '                                               
              MOVE WS-RPT1-SEB-TITLE    TO P-RPT1-TITLE                 
              MOVE 'SEB  '              TO WS-SUBSID-ID                 
              WHEN 'SEBR'                                               
              MOVE WS-RPT1-SEBR-TITLE   TO P-RPT1-TITLE                 
              MOVE 'SEBR '              TO WS-SUBSID-ID                 
              WHEN 'SVC'                                                
              MOVE WS-RPT1-SVC-TITLE    TO P-RPT1-TITLE                 
              MOVE 'SVC  '              TO WS-SUBSID-ID                 
              WHEN OTHER                                                
              DISPLAY WS-COMPANY                                        
           END-EVALUATE.                                                
           MOVE  WS-COMPANY           TO WS-DET-SUBSID-ID.              
      *                                                                         
           MOVE WS-REVENUE-MONTH        TO WS-DET-REV-MONTH.            
           MOVE WS-CURRENT-DATE         TO WS-DET-DATE-BILLED.          
           MOVE WS-SUBSID-ID            TO WS-DET-SUBSID-ID.            
           MOVE BN-BILL-CYCLE           TO WS-DET-BILL-CYCLE            
                                           WS-CYCLE.                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MAIN PROCESSING MODULE                                         *        
      ******************************************************************        
       1000-PROCESS-FILES.                                              
      *                                                                         
           OPEN INPUT  FCSCA912-FILE                                    
           IF NOT CA912-SUCCESSFUL                                      
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING GROUP1 FILE      **'         
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
           PERFORM 2000-PROCESS-CA912   THRU 2000-EXIT                  
                                         UNTIL END-OF-CA912.            
      *                                                                         
           OPEN INPUT  FCSSEC-FILE                                      
           IF WS-SECURED-STATUS NOT = '00'                              
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING SECURED FILE'                
               DISPLAY '**   FILE STATUS = ' WS-SECURED-STATUS          
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
           PERFORM 2200-PROCESS-SECURED  THRU 2200-EXIT                 
                                         UNTIL END-OF-SECURED.          
      *                                                                         
           OPEN OUTPUT FCSBE51-FILE.                                    
           IF WS-BE51-STATUS NOT = '00'                                 
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING FCSBE51'                     
               DISPLAY '**   FILE STATUS = ' WS-BE51-STATUS             
               DISPLAY '**************************************'         
               MOVE 12                  TO RETURN-CODE                  
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCA32-SUCCESSFUL                                      
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING REPORT FILE'                 
               DISPLAY '**   FILE STATUS = ' WS-FCA32-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
           COMPUTE WS-GROUP2 = WS-PULL-CODES + WS-GROUP4 + WS-GROUP5 +  
                               WS-PAPERLESS  + WS-CONS   + WS-CODEZ  +  
                               WS-CORRECTED  + WS-PCOMP  + WS-INTL.     
      *                                                                         
           COMPUTE WS-TOTAL  = WS-GROUP1 + WS-GROUP2   + WS-SECURED +   
                                                         WS-DUPS.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2000-PROCESS-CA912.                                              
      *                                                                         
           PERFORM 7000-READ-CA912 THRU 7000-EXIT.                      
                                                                        
           IF NOT END-OF-CA912                                          
              IF EXT-BILL-BILL-DEST-CODE = 'P'                          
                 ADD +1                               TO WS-CONS        
              ELSE                                                      
                 IF EXT-BILL-NO-BILL-COPIES = 0                         
                    ADD +1                               TO WS-PAPERLESS
                 END-IF                                                 
                 IF EXT-BILL-NO-BILL-COPIES > 1                         
                  IF EXT-ACCT-ACCOUNT-NO NOT EQUAL TO WS-HOLD-ACCOUNT-NO
                      ADD EXT-BILL-NO-BILL-COPIES          TO WS-DUPS   
                  END-IF                                                
                 END-IF                                                 
                 IF EXT-BILL-NO-BILL-COPIES = 1                         
                    IF EXT-BILL-EXCEPTION-CODE = SPACES                 
                       IF EXT-SRT-GROUP-ID = 'G4'                       
                          ADD EXT-BILL-NO-BILL-COPIES       TO WS-GROUP4
                       ELSE                                             
                          IF EXT-SRT-GROUP-ID = 'G5'                    
                             ADD EXT-BILL-NO-BILL-COPIES    TO WS-GROUP5
                           ELSE                                         
                             ADD  EXT-BILL-NO-BILL-COPIES   TO WS-GROUP1
                           END-IF                                       
                       END-IF                                           
                    ELSE                                                
                       EVALUATE EXT-BILL-BILL-DEST-CODE                 
                       WHEN 'A'                                         
                        ADD +1                           TO WS-CORRECTED
                       WHEN 'C'                                         
                        PERFORM 2500-SAVE-COUNT-PULLCODES THRU 2500-EXIT
                       WHEN 'H'                                         
                        ADD +1                           TO WS-PCOMP    
                       WHEN 'Z'                                         
                        ADD +1                           TO WS-CODEZ    
                       WHEN OTHER                                       
                        PERFORM 2510-SAVE-COUNT-PULLCODES THRU 2510-EXIT
                       END-EVALUATE                                     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
               MOVE EXT-ACCT-ACCOUNT-NO         TO WS-HOLD-ACCOUNT-NO   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-PROCESS-SECURED.                                            
      *                                                                         
           PERFORM 7200-READ-SECURED THRU 7200-EXIT.                    
                                                                        
           IF NOT END-OF-SECURED                                        
               MOVE FCSSEC-SORTIDX-FILE             TO EXT-SORTIDX-FILE 
               ADD  EXT-BILL-NO-BILL-COPIES         TO WS-SECURED       
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     ** THIS ROUTINE SAVES THE PULLOCDES IF IT IS ALREADY NOT        *          
     ** ALREADY IN THE TABLE AND ALSO COUNTS THE NUMBER OF           *          
     ** OCCURRENCES OF SAME PULL CODE FOR BILL DESTIANATION CODE C.  *          
     *****************************************************************          
       2500-SAVE-COUNT-PULLCODES.                                       
      *                                                                         
           IF EXT-BILL-PULL-CODE > ' '                                  
              IF EXT-BILL-PULL-CODE  = 'I'                              
                 ADD +1                          TO WS-INTL             
              ELSE                                                      
                MOVE 'N'                         TO WS-FOUND-FLAG       
                PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL                  
                                             SUB2 > WS-DIFF-PULLCODE  OR
                                             WS-FOUND-FLAG = 'Y'        
                        IF WS-EXCP-CD(SUB2) = EXT-BILL-EXCEPTION-CODE   
                           ADD  +1               TO WS-PULL-CT(SUB2)    
                           MOVE 'Y'              TO WS-FOUND-FLAG       
                        END-IF                                          
                END-PERFORM                                             
                IF WS-FOUND-FLAG = 'N'                                  
                   ADD  +1                       TO WS-DIFF-PULLCODE    
                   MOVE EXT-BILL-EXCEPTION-CODE  TO                     
                                            WS-EXCP-CD(WS-DIFF-PULLCODE)
                   ADD  +1                       TO                     
                                            WS-PULL-CT(WS-DIFF-PULLCODE)
                END-IF                                                  
                ADD +1                           TO WS-PULL-CODES       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     ** THIS ROUTINE SAVES THE PULLOCDES IF IT IS ALREADY NOT        *          
     ** ALREADY IN THE TABLE AND ALSO COUNTS THE NUMBER OF           *          
     ** OCCURRENCES OF SAME PULL CODE FOR BILL DESTIANATION NOT C.   *          
     *****************************************************************          
       2510-SAVE-COUNT-PULLCODES.                                       
      *                                                                         
           MOVE 'N'                         TO WS-FOUND-FLAG            
           PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL                       
                                             SUB2 > WS-DIFF-PULLCODE1 OR
                                             WS-FOUND-FLAG = 'Y'        
               IF WS-EXCP-CD-WC(SUB2) = EXT-BILL-EXCEPTION-CODE         
                  ADD  +1               TO WS-PULL-CT-WC(SUB2)          
                  MOVE 'Y'              TO WS-FOUND-FLAG                
               END-IF                                                   
           END-PERFORM.                                                 
           IF WS-FOUND-FLAG = 'N'                                       
              ADD  +1                       TO WS-DIFF-PULLCODE1        
              MOVE EXT-BILL-EXCEPTION-CODE  TO                          
                                        WS-EXCP-CD-WC(WS-DIFF-PULLCODE1)
              ADD  +1                       TO                          
                                        WS-PULL-CT-WC(WS-DIFF-PULLCODE1)
           END-IF.                                                      
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  READS THE CA912  INPUT FILE                             *              
      ************************************************************              
       7000-READ-CA912.                                                 
      *                                                                         
           READ FCSCA912-FILE AT END                                    
                MOVE WS-Y TO WS-END-OF-CA912.                           
           IF CA912-SUCCESSFUL OR END-OF-CA912                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '****************************************'        
              DISPLAY '**     PCSRP917 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING CA912 FILE     **'        
              DISPLAY '**     FILE STATUS = ' WS-CA912-STATUS           
              DISPLAY '****************************************'        
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-READ-SECURED.                                               
      ************************************************************              
      *  READ THE SECURED INPUT FILE AND ADD TOTAL NUMBER        *              
      *  OF BILLS PRINTED.                                       *              
      ************************************************************              
           READ FCSSEC-FILE AT END                                      
               MOVE WS-Y TO WS-END-OF-SECURED.                          
           IF SECURED-SUCCESSFUL OR END-OF-SECURED                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '****************************************'        
              DISPLAY '**     PCSRP917 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING SECURED FILE   **'        
              DISPLAY '**     FILE STATUS = ' WS-SECURED-STATUS         
              DISPLAY '****************************************'        
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * EXTRACT CSR BILL CYCLE, IN CSR WE HAVE 20 CYCLES.        *              
      ************************************************************              
      *                                                                         
       7500-CSR-BILL-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT MAX(BILL_CYCLE)                                  
                  INTO :BN-BILL-CYCLE :WS-NULL-IND                      
                  FROM CSS_BILL_WINDOW BN                               
                 WHERE BN.DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
                   AND BN.CODE_BILL_COND = :BN-CODE-BILL-COND           
                   AND BN.BILL_CYCLE    <> '21'                         
                   AND BN.REVENUE_MONTH  = :BN-REVENUE-MONTH            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(BILL_CYCLE)                                          
MFA-TR*           INTO :BN-BILL-CYCLE :WS-NULL-IND                              
MFA-TR*           FROM CSS_BILL_WINDOW BN                                       
MFA-TR*          WHERE BN.DATE_EXTRACT   = :BN-DATE-EXTRACT                     
MFA-TR*            AND BN.CODE_BILL_COND = :BN-CODE-BILL-COND                   
MFA-TR*            AND BN.BILL_CYCLE    <> '21'                                 
MFA-TR*            AND BN.REVENUE_MONTH  = :BN-REVENUE-MONTH                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND < 0                                  
                       INITIALIZE BN-BILL-CYCLE                         
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    INITIALIZE BN-BILL-CYCLE                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSRP917 PROCESSING ERROR ***'         
                    DISPLAY '*** 7500-CSR-BILL-CYCLE       ***'         
                    DISPLAY 'ERROR ON SELECT CSS_BILL_WINDOW *'         
                    DISPLAY '*** DATE_EXTRACT   ' BN-DATE-EXTRACT       
                    DISPLAY '*** CODE_BILL_COND ' BN-CODE-BILL-COND     
                    DISPLAY '*** REVENUE_MONTH  ' BN-REVENUE-MONTH      
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * EXTRACT SEB BILL CYCLE, IN SEB WE HAVE 21 CYCLES.        *              
      ************************************************************              
      *                                                                         
       7600-SEB-BILL-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT MAX(BILL_CYCLE)                                  
                  INTO :BN-BILL-CYCLE :WS-NULL-IND                      
                  FROM CSS_BILL_WINDOW BN                               
                 WHERE BN.DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
                   AND BN.CODE_BILL_COND = :BN-CODE-BILL-COND           
                   AND BN.REVENUE_MONTH  = :BN-REVENUE-MONTH            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(BILL_CYCLE)                                          
MFA-TR*           INTO :BN-BILL-CYCLE :WS-NULL-IND                              
MFA-TR*           FROM CSS_BILL_WINDOW BN                                       
MFA-TR*          WHERE BN.DATE_EXTRACT   = :BN-DATE-EXTRACT                     
MFA-TR*            AND BN.CODE_BILL_COND = :BN-CODE-BILL-COND                   
MFA-TR*            AND BN.REVENUE_MONTH  = :BN-REVENUE-MONTH                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND < 0                                  
                       INITIALIZE BN-BILL-CYCLE                         
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    INITIALIZE BN-BILL-CYCLE                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSRP917 PROCESSING ERROR ***'         
                    DISPLAY '*** 7600-SEB-BILL-CYCLE       ***'         
                    DISPLAY 'ERROR ON SELECT CSS_BILL_WINDOW *'         
                    DISPLAY '*** DATE_EXTRACT   ' BN-DATE-EXTRACT       
                    DISPLAY '*** CODE_BILL_COND ' BN-CODE-BILL-COND     
                    DISPLAY '*** REVENUE_MONTH  ' BN-REVENUE-MONTH      
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * EXTRACT THE REVENUE MONTH FROM CSS_JOB_PARM              *              
      ************************************************************              
      *                                                                         
       7700-GET-REVMON-DTBILL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND SEQ_NO       = :G6-SEQ-NO                         
                  AND STATUS       = :G6-STATUS                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSRP917 PROCESSING ERROR ***'         
                    DISPLAY '*** 7700-GET-REVMON-DTBILL    ***'         
                    DISPLAY 'ERROR ON SELECT CSS_JOB_PARM  ***'         
                    DISPLAY '*** PROGRAM NAME ' G6-PROGRAM-NAME         
                    DISPLAY '*** CONMANY NO   ' G6-COMPANY-NO           
                    DISPLAY '*** CMND_CODE    ' G6-CMND-CODE            
                    DISPLAY '*** SEQ_NO       ' G6-SEQ-NO               
                    DISPLAY '*** STATUS       ' G6-STATUS               
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     ** THIS ROUTINE PRINTS THE TOTAL NUMBER OF BILLS PRINTED REPORT *          
     *****************************************************************          
       8000-WRITE-CA32-REPORT.                                          
      *                                                                         
           WRITE PRT33-RECORD       FROM P-HEADER-LINE-1                
                                      AFTER ADVANCING PAGE.             
           MOVE WS-PGRMNAME           TO P-RPT1-NAME.                   
           MOVE WS-RPT1-HEAD          TO P-RPT1-HEAD.                   
           MOVE WS-CYCLE              TO P-PRT-CYCLE.                   
           WRITE PRT33-RECORD       FROM P-HEADER-LINE-2                
                                      AFTER ADVANCING 1 LINE.           
           WRITE PRT33-RECORD         FROM P-HEADER-LINE-3              
                                      AFTER ADVANCING 2 LINES.          
           MOVE  WS-TOTAL             TO   WS-TOTAL-ED.                 
           MOVE  WS-GROUP1            TO   WS-GROUP1-ED.                
           MOVE  WS-GROUP2            TO   WS-GROUP2-ED.                
           MOVE  WS-PULL-CODES        TO   WS-PULL-CODES-ED.            
           MOVE  WS-CORRECTED         TO   WS-CORRECTED-ED.             
           MOVE  WS-GROUP4            TO   WS-GROUP4-ED.                
           MOVE  WS-GROUP5            TO   WS-GROUP5-ED.                
           MOVE  WS-PAPERLESS         TO   WS-PAPERLESS-ED.             
           MOVE  WS-CONS              TO   WS-CONS-ED.                  
           MOVE  WS-SECURED           TO   WS-SECURED-ED.               
           MOVE  WS-PCOMP             TO   WS-PCOMP-ED.                 
           MOVE  WS-DUPS              TO   WS-DUPS-ED.                  
           MOVE  WS-INTL              TO   WS-INTL-ED.                  
           MOVE  WS-CODEZ             TO   WS-CODEZ-ED.                 
           WRITE PRT33-RECORD         FROM P-DETAIL-LINE-1              
                                      AFTER ADVANCING 1 LINE.           
           WRITE PRT33-RECORD         FROM P-HEADER-LINE-4              
                                      AFTER ADVANCING 2 LINES.          
           WRITE PRT33-RECORD         FROM P-HEADER-LINE-5              
                                      AFTER ADVANCING 1 LINE.           
           MOVE  ZERO                 TO   SUB1.                        
           PERFORM 8100-WRITE-PULLCODES THRU 8100-EXIT UNTIL            
                                             SUB1 > WS-DIFF-PULLCODE.   
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  THIS ROUTINE WRITES THE DIFFERENT PULLCODES AND THEIR COUNTS *         
      *  TO THE REPORT.                                               *         
      *****************************************************************         
       8100-WRITE-PULLCODES.                                            
      *                                                                         
           ADD   +1                     TO SUB1.                        
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-1                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-1                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-2                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-2                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-3                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-3                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-4                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-4                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-5                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-5                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-6                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-6                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-7                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-7                    
      *                                                                         
           ADD  +1                    TO     SUB1                       
           MOVE WS-PULL-CD(SUB1)      TO     WS-CD-8                    
           MOVE WS-PULL-CT(SUB1)      TO     WS-CT-8                    
      *                                                                         
           WRITE PRT33-RECORD         FROM P-DETAIL-LINE-6N             
                                      AFTER ADVANCING 1 LINE.           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  THIS ROUTINE WRITES THE TOTAL TO BE51 FILE.                  *         
      *****************************************************************         
       8200-WRITE-BE51-REPORT.                                          
      *                                                                         
      * WRITE THE COUNT OF GROUP1 TO BE51 FILE.                                 
           MOVE WS-GROUP1             TO WS-DET-CD-COUNT.               
           MOVE SPACES                TO WS-DET-DEST-CODE               
                                         WS-DET-PULL-CODE.              
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF DUPLICATES TO BE51 FILE.                             
           MOVE WS-DUPS               TO WS-DET-CD-COUNT.               
           MOVE 'D'                   TO WS-DET-DEST-CODE.              
           MOVE SPACES                TO WS-DET-PULL-CODE.              
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF SECURED TO BE51 FILE.                                
           MOVE WS-SECURED                  TO WS-DET-CD-COUNT.         
           MOVE 'S'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF PAPERLESS TO BE51 FILE.                              
           MOVE WS-PAPERLESS                TO WS-DET-CD-COUNT.         
           MOVE '0'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT ON CANCEL REBILLS TO BE51 FILE.                         
           MOVE WS-CORRECTED                TO WS-DET-CD-COUNT.         
           MOVE 'A'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF GROUP 4 TO BE51 FILE.                                
           MOVE WS-GROUP4                   TO WS-DET-CD-COUNT.         
           MOVE 'G'                         TO WS-DET-DEST-CODE.        
           MOVE '4'                         TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF GROUP 5 TO BE51 FILE.                                
           MOVE WS-GROUP5                   TO WS-DET-CD-COUNT.         
           MOVE 'G'                         TO WS-DET-DEST-CODE.        
           MOVE '5'                         TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF P-COMP TO BE51 FILE.                                 
           MOVE WS-PCOMP                    TO WS-DET-CD-COUNT.         
           MOVE 'H'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF CONSOLIDATED TO BE51 FILE.                           
           MOVE WS-CONS                     TO WS-DET-CD-COUNT.         
           MOVE 'P'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      * WRITE THE COUNT OF INTERNATIONAL BILLS TO BE51 FILE.                    
           MOVE WS-INTL                     TO WS-DET-CD-COUNT.         
           MOVE 'I'                         TO WS-DET-DEST-CODE.        
           MOVE SPACES                      TO WS-DET-PULL-CODE.        
           PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT.               
      *                                                                         
      * PRINT THE COUNTS ON EXCEPTION.                                          
           PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                       
                           SUB1 > WS-DIFF-PULLCODE                      
              MOVE WS-DEST-CD     (SUB1)         TO WS-DET-DEST-CODE    
              MOVE WS-PULL-CD     (SUB1)         TO WS-DET-PULL-CODE    
              MOVE WS-PULL-CT     (SUB1)         TO WS-DET-CD-COUNT     
              PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT             
           END-PERFORM.                                                 
      *                                                                         
      * PRINT THE COUNTS ON EXCEPTION OTHER THAN DESTINATION C                  
           PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                       
                           SUB1 > WS-DIFF-PULLCODE1                     
              MOVE WS-DEST-CD-WC  (SUB1)         TO WS-DET-DEST-CODE    
              MOVE WS-PULL-CD-WC  (SUB1)         TO WS-DET-PULL-CODE    
              MOVE WS-PULL-CT-WC  (SUB1)         TO WS-DET-CD-COUNT     
              PERFORM 8400-PRINT-DETAIL-LINE THRU 8400-EXIT             
           END-PERFORM.                                                 
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
       8400-PRINT-DETAIL-LINE.                                          
      *                                                                         
           WRITE FCSBE51-REC FROM WS-DETAIL-LINE-1.                     
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES                                                *00300600
      ******************************************************************00300700
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA912-FILE                                          
                 FCSSEC-FILE                                            
                 FCSBE51-FILE                                           
                 FCSPT33-FILE.                                          
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM PROBLEM OCCURS.                          *        
      ******************************************************************        
       9900-ABEND.                                                      
010590     DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
      *                                                                         
