HPCCDM*       CBL NOADV                                                        0
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP910.                                        
       AUTHOR.         VAISHNAVI.                                       
       DATE-WRITTEN.   MAY 2008.                                        
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00070000
      **                                                             ** 00080000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00090000
      **                                                             ** 00100000
      ***************************************************************** 00110000
      **               P R O G R A M  S U M M A R Y                  ** 00120000
      **                                                             ** 00130000
      ** PCSRP910 WILL REPORT THE BILLS PROCESSED. THIS PROGRAM TAKES** 00140000
      ** 0300 RECORD FROM FCSCA31 AND FCSBE32 AS ONE INPUT. THE OTHER** 00150000
      ** INPUT IS THE 002BILLRECORD FROM FCSBE28 FILE.               ** 00160000
      ** FROM FCSCA31 AND FCSBE32 FILE.                              ** 00170000
      **  PAPERLESS -> WS-NO-BILL-COPIES-AT = 0 AND                  ** 00180000
      **               WS-MST-SUB-ACCT-IND-AT =  SPACES              ** 00190000
      **  DEADHEADS -> WS-CODE-COMPANY-ACCT-AT = 'B'                 ** 00200000
      **  DUPLICATE ->  WS-NO-BILL-COPIES-AT > 1 AND                 ** 00210000
      **               WS-MST-SUB-ACCT-IND-AT =  SPACES              ** 00220000
      **  MASTER PAPERLESS    -> WS-MST-SUB-ACCT-IND-AT = 'M' AND    ** 00230000
      **                         WS-NO-BILL-COPIES-AT = 0            ** 00240000
      **  SUB PAPERLESS       ->(WS-MST-SUB-ACCT-IND-AT = 'S' AND    ** 00250000
      **                         WS-NO-BILL-COPIES-AT = 0) OR        ** 00260000
      **  PRINT MASTER ONLY SUBS THAT GETS BILLED THE SAME DAY ITS   ** 00270000
      **  MASTER IS BILLED.                                             00280000
      **                        (WS-MST-SUB-ACCT-IND-AT = 'S' AND    ** 00290000
      **                         WS-CODE-PRNT-BLL-MST-AT = 'A' AND   ** 00300000
      **                         WS-NO-BILL-COPIES-AT > 0 AND        ** 00310000
      **               WS-DATE-BILL-DAY-00-AT = WS-MSTR-DATE-BILLED) ** 00320000
      **  PRINT MASTER ONLY SUB  -> (WS-MST-SUB-ACCT-IND-AT = 'S' AND** 00330000
      **                         WS-CODE-PRNT-BLL-MST-AT = 'A' AND   ** 00340000
      **                         WS-NO-BILL-COPIES-AT > 0 AND        ** 00350000
      **               WS-DATE-BILL-DAY-00-AT <> WS-MSTR-DATE-BILLED)** 00360000
      **  MASTER ACCOUNTS     -> WS-MST-SUB-ACCT-IND-AT = 'M' AND    ** 00370000
      **                         WS-NO-BILL-COPIES-AT > 0            ** 00380000
      **  SUB ACCOUNTS        -> WS-MST-SUB-ACCT-IND-AT = 'S' AND    ** 00390000
      **                         WS-NO-BILL-COPIES-AT > 0            ** 00400000
      **  OTHER BILLS.                                               ** 00410000
      **                                                             ** 00420000
      ** FROM FCSBE28 FILE.                                          ** 00430000
      **  PAPERLESS -> EXT-BILL-NO-BILL-COPIES = 0 AND               ** 00440000
      **               EXT-BILL-MASTER-SUB-FLAG  = SPACES            ** 00450000
      **  MASTER ACCOUNTS -> EXT-BILL-MASTER-SUB-FLAG= 'M' AND       ** 00460000
      **               EXT-BILL-NO-BILL-COPIES > 0                   ** 00470000
      **  MASTER PAPERLESS-> EXT-BILL-MASTER-SUB-FLAG= 'M' AND       ** 00480000
      **               EXT-BILL-NO-BILL-COPIES = 0                   ** 00490000
      **  SUB ACCOUNTS    -> EXT-BILL-MASTER-SUB-FLAG= 'S' AND       ** 00500000
      **               EXT-BILL-NO-BILL-COPIES > 0                   ** 00510000
      **  SUB PAPERLESS   -> EXT-BILL-MASTER-SUB-FLAG= 'S' AND       ** 00520000
      **               EXT-BILL-NO-BILL-COPIES = 0                   ** 00530000
      **  DUPLICATE ->  EXT-BILL-NO-BILL-COPIES > 1 AND              ** 00540000
      **               EXT-BILL-MASTER-SUB-FLAG  = SPACES            ** 00550000
      **  OTHER BILLS.                                               ** 00560000
      **  THE DEADHEADS AND PRINT MASTER ONLY SUBS THAT DOES NOT COME** 00570000
      **  ALONG WITH ITS MASTER CANNOT BE SEEN IN BE28 FILE.         ** 00580000
      **                                                             ** 00590000
      ***************************************************************** 00600000
      *                                                              ** 00610000
      *              PROGRAM  MODIFICATION  LOG                      ** 00620000
      *                                                              ** 00630000
      *    DATE     INITIALS  REASON                                 ** 00640000
      *    ----     --------  ------                                 ** 00650000
      *  05/2008    SV82012   NEW REPORT PROGRAM                     ** 00660000
T35152*  10/2008    SDHAL     FIX FOR PROGRAM NAME LISTED IN HEADING ** 00670000
T35152*  11/2008    SV82012   FIX MASTER SUB PAPERLESS INPUT COUNT   ** 00680000
A01489*  08/2009    SV82012   FIX MASTER SUB PAPERLESS INPUT COUNT   ** 00690000
A03876*  03/2012    EM19682   REMOVE DEADHEAD FROM COUNT             ** 00691000
      ***************************************************************** 00700000
      ***************************************************************** 00710000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00720000
      **                                                             ** 00730000
      **  0000         MODULE CONTROL                                ** 00740000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00750000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00760000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00770000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00780000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00790000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00800000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00810000
      **                                                             ** 00820000
      ***************************************************************** 00830000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00870000
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00890000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE26.                                                    00930000
       COPY CSSBE32.                                                    00940000
           SELECT FCSBE28-FILE                                          
               ASSIGN UT-S-FCSBE28                                      
               FILE STATUS IS WS-FBE28-STATUS.                          
           SELECT PCSRP910-FILE   ASSIGN TO UT-S-PCSRP910               
               FILE STATUS IS WS-RP910-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDBE26.                                                    01040000
       COPY FIOBE26A.                                                   01050000
       COPY CFDBE32.                                                    01060000
       COPY FIOBE32A.                                                   01070000
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28.                                                     
           02  FIOBE28-DATA-REC.                                        
               05  E-FBE28-SORT-KEY              PIC X(65).             
               05  E-FBE28-DATA                  PIC X(1135).           
                                                                        
       FD  PCSRP910-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  PCSRP910-REC                PIC X(80).                       
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP910'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBE26-STATUS                 PIC X(02).               
               88 FBE26-SUCCESSFUL                   VALUE '00'.        
           05  WS-FBE32-STATUS                 PIC X(02).               
               88 FBE32-SUCCESSFUL                   VALUE '00'.        
           05  WS-FBE28-STATUS                 PIC X(02).               
               88 FBE28-SUCCESSFUL                   VALUE '00'.        
           05  WS-RP910-STATUS                 PIC X(02).               
               88 RP910-SUCCESSFUL                   VALUE '00'.        
           05  WS-END-OF-BE26                  PIC X VALUE 'N'.         
               88  END-OF-BE26                       VALUE 'Y'.         
           05  WS-END-OF-BE32                  PIC X VALUE 'N'.         
               88  END-OF-BE32                       VALUE 'Y'.         
           05  WS-END-OF-BE28                  PIC X VALUE 'N'.         
               88  END-OF-BE28                       VALUE 'Y'.         
           05  WS-ACCOUNT-PROCESSED            PIC  X(01).              
               88  ACCOUNT-PROCESSED                VALUE 'Y'.          
               88  ACCOUNT-NOT-PROCESSED            VALUE 'N'.          
           05  WS-BEGIN-REC-SW                 PIC  X(01).              
               88  WS-BEGIN-RECS-PROCESSED          VALUE 'Y'.          
               88  WS-BEGIN-REC-NOT-PROCESSED       VALUE 'N'.          
           05  WS-FILE-TO-PROCESS              PIC X(04) VALUE SPACES.  
           05  WS-BEGIN-REC-PROCESSED          PIC X VALUE 'N'.         
           05  WS-END-REC-PROCESSED            PIC X VALUE 'N'.         
           05  WS-MORE-BEGIN-REC               PIC X VALUE 'N'.         
T37389     05  WS-CHK-MSTR-ACCT                PIC S9(13)V.             
T37389     05  WS-MST-CODE-PRNT                PIC X VALUE SPACES.      
T37389     05  WS-MSTR-DATE-BILLED             PIC X(10) VALUE SPACES.  
           05  WS-COMMON-DATE                  PIC X(10) VALUE SPACES.  
           05  WS-INPUT-PAPERLESS              PIC 9(5).                
           05  WS-INPUT-PRT-MST-ONLY           PIC 9(5).                
T37389     05  WS-INPUT-MAS-PAPERLESS          PIC 9(5).                
T37389     05  WS-INPUT-SUB-PAPERLESS          PIC 9(5).                
T37389     05  WS-INPUT-MASTER                 PIC 9(5).                
T37389     05  WS-INPUT-SUB                    PIC 9(5).                
           05  WS-INPUT-DUPLICATE              PIC 9(5).                
           05  WS-INPUT-OTHERS                 PIC 9(5).                
           05  WS-INPUT-ACCOUNTS               PIC 9(7).                
           05  WS-TOTAL-INPUT-ACCOUNTS         PIC 9(7).                
           05  WS-OUTPUT-PAPERLESS             PIC 9(5).                
T37389     05  WS-OUTPUT-MAS-PAPERLESS         PIC 9(5).                
T37389     05  WS-OUTPUT-SUB-PAPERLESS         PIC 9(5).                
T37389     05  WS-OUTPUT-MASTER                PIC 9(5).                
T37389     05  WS-OUTPUT-SUB                   PIC 9(5).                
           05  WS-OUTPUT-DUPLICATE             PIC 9(5).                
           05  WS-OUTPUT-OTHERS                PIC 9(5).                
           05  WS-OUTPUT-ACCOUNTS              PIC 9(7).                
           05  WS-TOTAL-OUTPUT-ACCOUNTS        PIC 9(7).                
           05  WS-PRT-INP-ACCOUNT              PIC X(18) VALUE          
                                          ' ACCOUNTS      '.            
           05  WS-PRT-INP-PAPERLESS            PIC X(18) VALUE          
                                          ' PAPERLESS     '.            
T37389     05  WS-PRT-INP-MASTER               PIC X(18) VALUE          
T37389                                    ' MASTER        '.            
T37389     05  WS-PRT-INP-SUBS                 PIC X(18) VALUE          
T37389                                    ' SUB           '.            
           05  WS-PRT-INP-PRINT-MST-ONLY-SUBS  PIC X(18) VALUE          
                                          ' PRT MST ONLY SUBS'.         
T37389     05  WS-PRT-INP-MASTER-PLESS         PIC X(18) VALUE          
T37389                                    ' MASTER PAPERLESS '.         
T37389     05  WS-PRT-INP-SUB-PLESS            PIC X(18) VALUE          
T37389                                    ' SUB PAPERLESS '.            
           05  WS-PRT-INP-DUPLICATE            PIC X(18) VALUE          
                                          ' DUPLICATE     '.            
           05  WS-PRT-INP-OTHERS               PIC X(18) VALUE          
                                          ' OTHERS        '.            
T37389     05  WS-PRT-IO-INPUT                 PIC X(30) VALUE          
T37389         ' INPUT                        '.                        
T37389     05  WS-PRT-IO-MISMATCH              PIC X(30) VALUE          
T37389         ' PRT MST ONLY SUBS            '.                        
           05  WS-BLANK-LINE-80                PIC X(80) VALUE SPACES.  
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                          PIC  X(01) VALUE 'Y'.    
           05  WS-Y                            PIC  X(01) VALUE 'Y'.    
           05  WS-NO                           PIC  X(01) VALUE 'N'.    
           05  WS-N                            PIC  X(01) VALUE 'N'.    
           05  WS-811                          PIC S9(9) COMP           
                                                  VALUE -811.           
           05  PROGRAM-NAME                    PIC  X(08)               
                                                  VALUE 'PCSRP910'.     
           05  WS-PGRMNAME                     PIC  X(08)               
                                                  VALUE 'PCSRP910'.     
                                                                        
       01  WS-11-TABLES.                                                
           05  WS-EMB-INPUT.                                            
               10  WS-EMB-CHAR                 PIC X(01)                
                                                 OCCURS 255 TIMES       
                                                 INDEXED BY WS-EMB-INDX.
           05  WS-EMB-TBL-LENG                 PIC S9(03) VALUE +255.   
           05  WS-EMB-LENG                     PIC S9(03) VALUE ZERO.   
           05  WS-EMB-LAST-CHAR                PIC X(01).               
           05  WS-CMP-TABLE.                                            
               10  WS-CMP-CHAR                 PIC X(01)                
                                                 OCCURS 255 TIMES       
                                                 INDEXED BY WS-CMP-INDX.
       01  WS-EXT-IO-AREA.                                              
           05  SORT-KEY.                                                
               10  LEVEL-1-SORT-FLDS.                                   
                   15  KEY-L1-COMP-NO          PIC 9(2).                
               10  LEVEL-2-SORT-FLDS.                                   
                   15  KEY-L2-ACCOUNT-NO       PIC X(13).               
                   15  KEY-L2-DATE-BILLED      PIC X(10).               
               10  LEVEL-3-SORT-FLDS.                                   
                   15  KEY-L3-REC-SEQ          PIC X(3).                
                   15  KEY-L3-RECORD-ID        PIC X(10).               
                   15  KEY-L3-TIE-BREAKER      PIC 9(4).                
               10  LEVEL-4-SORT-FLDS.                                   
                   15  KEY-L4-SUB-ACCOUNT      PIC X(13).               
                   15  KEY-L4-SUB-DATE-BILLED  PIC X(10).               
           05  WS-BILL-DATA                    PIC X(1135).             
                                                                        
       01  WS-BILL-WORK-AREA.                                           
       COPY FIOEXT02.                                                   02440000
       01  MAILHEAD-1.                                                  
           05  FILLER                  PIC X(22) VALUE                  
               'HELO DOMAIN:     SCANA'.                                
      *                                                                 02480000
       01  MAILHEAD-2.                                                  
           05  FILLER                      PIC X(14) VALUE              
               'MAIL FROM:   <'.                                        
           05  MAIL2-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                 02550000
       01  MAILHEAD-3.                                                  
           05  FILLER                      PIC X(39) VALUE              
               'RCPT TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                 
      *                                                                 02590000
       01  MAILHEAD-4.                                                  
           05  FILLER                      PIC X(04) VALUE              
               'DATA'.                                                  
      *                                                                 02630000
       01  MAILHEAD-5.                                                  
           05  FILLER                      PIC X(18) VALUE              
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                 02700000
       01  MAILHEAD-6.                                                  
           05  FILLER                      PIC X(34) VALUE              
               'TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                      
      *                                                                 02740000
       01  MAILHEAD-7.                                                  
           05  FILLER                      PIC X(10) VALUE              
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT               PIC X(30).                   
      *                                                                 02790000
       01  MAILHEAD-8.                                                  
           05  FILLER                      PIC X(80) VALUE SPACES.      
      *                                                                 02820000
      ****************************************************************  02830000
      **       COMMON WORKING STORAGE FOR REPORT HEADERS            **  02840000
      ****************************************************************  02850000
      *                                                                 02860000
       01  WS-REPORT-HEADER.                                            
           05  FILLER              PIC X(26)    VALUE SPACES.           
           05  P-RPT-COMP          PIC X(28).                           
           05  FILLER              PIC X(26)    VALUE SPACES.           
      *                                                                 02910000
       01  WS-REPORT-HEADER-1.                                          
           05  FILLER                  PIC X(26)    VALUE SPACES.       
           05  FILLER                  PIC X(27)    VALUE               
               'PCSCA910 I/O CONTROL REPORT'.                           
           05  FILLER                  PIC X(27)    VALUE SPACES.       
      *                                                                 02970000
       01  WS-REPORT-HEADER-2.                                          
           05  FILLER                  PIC X(25)    VALUE SPACES.       
           05  FILLER                  PIC X(31)    VALUE               
               'PCSCA910 INPUT / OUTPUT DETAILS'.                       
           05  FILLER                  PIC X(24)    VALUE SPACES.       
      *                                                                 03030000
       01  WS-REPORT-HEADER-3.                                          
           05  FILLER                  PIC X(33)    VALUE SPACES.       
           05  FILLER                  PIC X(06)    VALUE ' INPUT'.     
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(06)    VALUE 'OUTPUT'.     
           05  FILLER                  PIC X(25)    VALUE SPACES.       
      *                                                                 03100000
      ****************************************************************  03110000
      **       COMMON WORKING STORAGE FOR LINE TOTALS               **  03120000
      ****************************************************************  03130000
      *                                                                 03140000
T37389 01  WS-FLOWER-BOX.                                               
T37389     05  FILLER                  PIC X(14)    VALUE SPACES.       
T37389     05  FILLER                  PIC X(53)    VALUE               
T37389        ' ********************************************** '.       
T37389     05  FILLER                  PIC X(13)    VALUE SPACES.       
T37389 01  WS-ALERT-MSG.                                                
T37389     05  FILLER                  PIC X(14)    VALUE SPACES.       
T37389     05  FILLER                  PIC X(53)    VALUE               
T37389        ' *** INPUT AND OUTPUT ACCOUNTS DO NOT MATCH *** '.       
T37389     05  FILLER                  PIC X(13)    VALUE SPACES.       
T37389 01  WS-ALERT-MSG1.                                               
T37389     05  FILLER                  PIC X(14)    VALUE SPACES.       
T37389     05  FILLER                  PIC X(53)    VALUE               
T37389        ' *** PLEASE CHECK FOR ITS ACCURACY          *** '.       
T37389     05  FILLER                  PIC X(13)    VALUE SPACES.       
      *                                                                 03300000
       01  WS-LINE-TOTAL.                                               
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  LT-TITLE                PIC X(18)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  LT-INPUT-ACCTS          PIC ZZ,ZZ9.                      
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  LT-OUTPUT-ACCTS         PIC ZZ,ZZ9.                      
           05  FILLER                  PIC X(25)    VALUE SPACES.       
      *                                                                 03390000
       01  WS-REPORT-DASH-DETAIL.                                       
T37389     05  FILLER                  PIC X(33)    VALUE SPACES.       
           05  FILLER                  PIC X(06)    VALUE ALL '-'.      
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(06)    VALUE ALL '-'.      
T37389     05  FILLER                  PIC X(25)    VALUE SPACES.       
      *                                                                 03460000
       01  WS-IO-MISMATCH-DETAIL.                                       
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  IO-TITLE                PIC X(30)    VALUE SPACES.       
           05  FILLER                  PIC X(09)    VALUE SPACES.       
           05  IO-OPEN-P               PIC X(01)    VALUE SPACES.       
           05  IO-ACCTS                PIC ZZ,ZZ9.                      
           05  IO-CLOSE-P              PIC X(01)    VALUE SPACES.       
           05  FILLER                  PIC X(28)    VALUE SPACES.       
      *                                                                 03550000
       01  WS-IO-DIFF-DETAIL.                                           
           05  FILLER                  PIC X(30)    VALUE SPACES.       
           05  FILLER                  PIC X(15)    VALUE               
               ' DIFFERENCE    '.                                       
           05  IO-DIFF-ACCTS           PIC ZZ,ZZ9.                      
           05  FILLER                  PIC X(30)    VALUE SPACES.       
      *                                                                 03620000
       01  WS-IO-DASH-DETAIL.                                           
           05  FILLER                  PIC X(30)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE ALL '-'.      
           05  FILLER                  PIC X(28)    VALUE SPACES.       
      *                                                                 03670000
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                 03730000
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                 03780000
       01  WS-SUBJECT.                                                  
           05  FILLER                  PIC X(13)    VALUE               
                                       'PCSRP910 FOR '.                 
           05  WS-SUB-DATE             PIC X(10).                       
      *                                                                 03830000
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                 03900000
      ** CWS10000 WAS SPLIT INTO CWS1000A & CWS1000B.                   03910000
       COPY CWS1000A.                                                   03920000
       COPY CWS1000B.                                                   03930000
      *                                                                 03940000
       COPY CWS09900.                                                   03950000
       COPY FIOCA00.                                                    03960000
       COPY FIOJC01.                                                    03970000
      *                                                                 03980000
           EXEC SQL                                                     03990000
               INCLUDE SQLCA                                            04000000
           END-EXEC.                                                    04010000
           EXEC SQL                                                     04020000
               INCLUDE TBJBPARM                                         04030000
           END-EXEC.                                                    04040000
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           05  WS-PARMVAL-LENGTH               PIC S9(04) COMP.         
           05  WS-PARM-COMPANY-NAME            PIC X(03).               
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***********************************************************       04130000
      *  PERFORM THE PROCESSING ROUTINE FOR EACH INPUT FILE:    *       04140000
      *  BE26 (REGULAR BILLS), BE32 (CONSOLIDATED BILLS)        *       04150000
      ***********************************************************       04160000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           DISPLAY 'BE26'.                                              
           MOVE 'BE26' TO WS-FILE-TO-PROCESS.                           
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           MOVE WS-YES                    TO WS-MORE-BEGIN-REC.         
           MOVE WS-NO                     TO WS-BEGIN-REC-PROCESSED.    
           PERFORM 0200-PROCESS-BEGIN-REC THRU 0200-EXIT UNTIL          
               WS-MORE-BEGIN-REC = WS-NO.                               
           IF END-OF-BE26                                               
               MOVE 12                    TO RETURN-CODE                
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       FCSBE26 FILE IS EMPTY        **'       
               DISPLAY '**       PROCESSING TERMINATED        **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
               END-OF-BE26.                                             
                                                                        
           DISPLAY 'BE32'.                                              
           MOVE WS-N                      TO WS-END-OF-BE32.            
           MOVE WS-NO                     TO WS-END-REC-PROCESSED.      
           MOVE 'BE32'                    TO WS-FILE-TO-PROCESS.        
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           MOVE WS-YES                    TO WS-MORE-BEGIN-REC.         
           MOVE WS-NO                     TO WS-BEGIN-REC-PROCESSED.    
           PERFORM 0200-PROCESS-BEGIN-REC THRU 0200-EXIT UNTIL          
               WS-MORE-BEGIN-REC = WS-NO.                               
           IF END-OF-BE32                                               
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       FCSBE32 FILE IS EMPTY        **'       
               DISPLAY '**       PROCESSING TERMINATED        **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           MOVE WS-NO TO WS-END-REC-PROCESSED.                          
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
               END-OF-BE32.                                             
                                                                        
      * NO NEED TO CHECK BE28 FILE FOR HEADER RECORD PROCESSING         04610000
      *                                                                 04620000
           DISPLAY 'BE28'.                                              
           MOVE 'BE28' TO WS-FILE-TO-PROCESS.                           
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           PERFORM 7990-READ-INPUT THRU 7990-EXIT.                      
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
               END-OF-BE28.                                             
                                                                        
                                                                        
           PERFORM 2000-WRITE-REPORT            THRU 2000-EXIT.         
           PERFORM 5400-VALIDATE-ACCOUNT-TOTALS THRU 5400-EXIT.         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       04790000
      *  OPEN INPUT FILES.  CALL THE CSF AFAPLINT PROGRAM TO    *       04800000
      *  OPEN THE OUTPUT FILES.                                 *       04810000
      ***********************************************************       04820000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSBE26-FILE.                                     
           IF NOT FBE26-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE26           **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE26-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           OPEN INPUT FCSBE32-FILE.                                     
           IF NOT FBE32-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE32           **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE32-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN INPUT  FCSBE28-FILE.                                    
           IF NOT FBE28-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE28           **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE28-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT PCSRP910-FILE.                                   
           IF   RP910-SUCCESSFUL                                        
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY ' WS-RP910-STATUS ' WS-RP910-STATUS             
                PERFORM 9900-ABEND     THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
      *                                                                 05230000
           MOVE SPACES                 TO P-RPT-COMP.                   
T37389     INITIALIZE WS-CHK-MSTR-ACCT.                                 
      *                                                                 05260000
           EVALUATE WS-PARM-COMPANY-NAME                                
               WHEN 'CSR'                                               
                    MOVE 'SCE&G '                     TO P-RPT-COMP     
               WHEN 'PNC'                                               
                    MOVE 'PSNC  '                     TO P-RPT-COMP     
               WHEN 'SEB'                                               
                    MOVE 'SCANA ENERGY - DEREGULATED' TO P-RPT-COMP     
               WHEN 'SBR'                                               
                    MOVE 'SCANA ENERGY - REGULATED'   TO P-RPT-COMP     
               WHEN 'SVC'                                               
                    MOVE 'SERVICE CARE'               TO P-RPT-COMP     
           END-EVALUATE.                                                
      *                                                                 05390000
T35152     IF WS-PARM-COMPANY-NAME='CSR' OR WS-PARM-COMPANY-NAME='PNC'  
T35152         INSPECT WS-REPORT-HEADER-1 REPLACING ALL                 
T35152                 'PCSCA910' BY 'PCSCA925'                         
T35152         INSPECT WS-REPORT-HEADER-2 REPLACING ALL                 
T35152                 'PCSCA910' BY 'PCSCA925'                         
T35152     END-IF.                                                      
      *                                                                 05460000
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
      *                                                                 05510000
           MOVE 'PCSRP910'              TO MAIL2-JOB-NAME               
                                           MAIL5-JOB-NAME.              
           MOVE WS-RUN-DATE            TO WS-SUB-DATE.                  
           MOVE WS-SUBJECT             TO MAIL7-SUBJECT.                
           WRITE PCSRP910-REC FROM MAILHEAD-1.                          
           WRITE PCSRP910-REC FROM MAILHEAD-2.                          
           WRITE PCSRP910-REC FROM MAILHEAD-3.                          
           WRITE PCSRP910-REC FROM MAILHEAD-4.                          
           WRITE PCSRP910-REC FROM MAILHEAD-5.                          
           WRITE PCSRP910-REC FROM MAILHEAD-6.                          
           WRITE PCSRP910-REC FROM MAILHEAD-7.                          
           WRITE PCSRP910-REC FROM MAILHEAD-8.                          
      *                                                                 05640000
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05680000
      *  MAKE SURE THE FIRST RECORD OF THE INPUT FILE IS A       *      05690000
      *  BEGINNING CONTROL RECORD (KEY = LOW-VALUES).  THERE CAN *      05700000
      *  BE MORE THAN ONE BEGINNING CONTROL RECORD.              *      05710000
      ************************************************************      05720000
                                                                        
       0200-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7990-READ-INPUT THRU 7990-EXIT.                      
           EVALUATE WS-FILE-TO-PROCESS                                  
               WHEN 'BE26'                                              
                   IF END-OF-BE26                                       
                       MOVE 12 TO RETURN-CODE                           
                       DISPLAY '********************************'       
                       DISPLAY '** PCSRP910 PROCESSING ERROR  **'       
                       DISPLAY '**   FCSBE26 FILE IS EMPTY    **'       
                       DISPLAY '**   PROCESSING TERMINATED    **'       
                       DISPLAY '********************************'       
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                   END-IF                                               
               WHEN 'BE32'                                              
                   IF END-OF-BE32                                       
                       MOVE 12 TO RETURN-CODE                           
                       DISPLAY '********************************'       
                       DISPLAY '** PCSRP910 PROCESSING ERROR  **'       
                       DISPLAY '**   FCSBE32 FILE IS EMPTY    **'       
                       DISPLAY '**   PROCESSING TERMINATED    **'       
                       DISPLAY '********************************'       
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                   END-IF                                               
               WHEN 'BE28'                                              
                   IF END-OF-BE28                                       
                       MOVE 12 TO RETURN-CODE                           
                       DISPLAY '********************************'       
                       DISPLAY '** PCSRP910 PROCESSING ERROR  **'       
                       DISPLAY '**   FCSBE28 FILE IS EMPTY    **'       
                       DISPLAY '**   PROCESSING TERMINATED    **'       
                       DISPLAY '********************************'       
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE 12 TO RETURN-CODE                               
                   DISPLAY '********************************'           
                   DISPLAY '** PCSRP910 PROCESSING ERROR  **'           
                   DISPLAY '** FILE TO PROCESS = ' WS-FILE-TO-PROCESS   
                   DISPLAY '********************************'           
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           IF E-FBE26-KEY-BREC = LOW-VALUES                             
               MOVE E-FBE26-CREATE-DATE-BREC TO WS-COMMON-DATE          
               MOVE WS-YES                   TO WS-BEGIN-REC-PROCESSED  
           ELSE                                                         
              IF WS-BEGIN-REC-PROCESSED = WS-YES                        
                  MOVE WS-NO                 TO WS-MORE-BEGIN-REC       
                  GO TO 0200-EXIT                                       
              ELSE                                                      
                  MOVE 12 TO RETURN-CODE                                
                  DISPLAY '*******************************************' 
                  DISPLAY '**       PCSRP910 PROCESSING ERROR       **' 
                  DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD **' 
                  DISPLAY '**  FILE TO PROCESS = ' WS-FILE-TO-PROCESS   
                  DISPLAY '**         PROCESSING TERMINATED         **' 
                  DISPLAY '********************************************'
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      06390000
      *  ACCUMULATE ALL DATA FOR AN ACCOUNT INTO THE CWS10000,   *      06400000
      *  CWS10001, AND CWS10009 COPYBOOKS.  REFORMAT THIS DATA   *      06410000
      *  INTO THE CSF FORMAT FOR THIS ACCOUNT.  NOTE THAT THE    *      06420000
      *  OUTPUT COMPANY RECORD IS WRITTEN ONLY ONCE.  WRITE      *      06430000
      *  WORK QUEUE ENTRIES FOR ANY ERRORS.                      *      06440000
      ************************************************************      06450000
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           EVALUATE WS-FILE-TO-PROCESS                                  
               WHEN 'BE26'                                              
               WHEN 'BE32'                                              
                  PERFORM 1100-PROCESS-INPUT   THRU 1100-EXIT           
               WHEN 'BE28'                                              
                  PERFORM 1200-PROCESS-OUTPUT  THRU 1200-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 7990-READ-INPUT             THRU 7990-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      06620000
      *  PROCESS INPUT BE26 AND BE32 FILES.                      *      06630000
      ************************************************************      06640000
       1100-PROCESS-INPUT.                                              
                                                                        
           IF E-FBE26-KEY-BREC = HIGH-VALUES                            
              GO TO 1100-EXIT                                           
           END-IF.                                                      
T37389     IF WS-FILE-TO-PROCESS = 'BE32'                               
T37389        IF WS-MST-SUB-ACCT-IND-AT = 'M'                           
T37389           MOVE WS-ACCOUNT-NO-AT        TO WS-CHK-MSTR-ACCT       
T37389           MOVE WS-CODE-PRNT-BLL-MST-AT TO WS-MST-CODE-PRNT       
T37389           MOVE WS-DATE-BILL-DAY-00-AT  TO WS-MSTR-DATE-BILLED    
T37389        END-IF                                                    
T37389                                                                  
T37389* IF THE SUB ACCOUNT HAVE THE CODE-PRNT-BLL-MST AS SPACES , LOAD  06770000
T37389* THE VALUE FROM ITS MASTER.                                      06780000
T37389        IF WS-MST-SUB-ACCT-IND-AT = 'S' AND                       
T37389           WS-ACCT-XFER-TO-AT  = WS-CHK-MSTR-ACCT AND             
T37389           WS-CODE-PRNT-BLL-MST-AT = ' '                          
T37389           MOVE WS-MST-CODE-PRNT    TO WS-CODE-PRNT-BLL-MST-AT    
T37389        END-IF                                                    
T37389     END-IF.                                                      
           MOVE 'N'                     TO WS-ACCOUNT-PROCESSED.        
           ADD 1                        TO WS-INPUT-ACCOUNTS.           
           IF WS-NO-BILL-COPIES-AT > 1 AND                              
T37389        WS-MST-SUB-ACCT-IND-AT = SPACES AND                       
T37389        ACCOUNT-NOT-PROCESSED                                     
              ADD 1                     TO WS-INPUT-DUPLICATE           
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
           IF WS-NO-BILL-COPIES-AT = 0 AND                              
              WS-MST-SUB-ACCT-IND-AT = SPACES AND                       
T37389        ACCOUNT-NOT-PROCESSED                                     
              ADD 1                     TO WS-INPUT-PAPERLESS           
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
T37389     IF WS-MST-SUB-ACCT-IND-AT = 'M' AND                          
T37389        ACCOUNT-NOT-PROCESSED                                     
T37389        IF WS-NO-BILL-COPIES-AT = 0                               
                 ADD 1                  TO WS-INPUT-MAS-PAPERLESS       
              ELSE                                                      
                 ADD 1                  TO WS-INPUT-MASTER              
              END-IF                                                    
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
T37389     IF WS-MST-SUB-ACCT-IND-AT = 'S' AND                          
T37389        ACCOUNT-NOT-PROCESSED                                     
T37389        IF WS-NO-BILL-COPIES-AT = 0                               
A01489           AND WS-CODE-PRNT-BLL-MST-AT = 'B' OR 'I'               
                 ADD 1                  TO WS-INPUT-SUB-PAPERLESS       
              ELSE                                                      
T37389           IF  WS-NO-BILL-COPIES-AT >= 0 AND                      
A01489               WS-CODE-PRNT-BLL-MST-AT = 'A' OR 'E' OR 'C'        
T37389               IF WS-DATE-BILL-DAY-00-AT = WS-MSTR-DATE-BILLED    
T37389                  ADD 1          TO WS-INPUT-SUB-PAPERLESS        
T37389               ELSE                                               
T37389                  ADD 1          TO WS-INPUT-PRT-MST-ONLY         
T37389               END-IF                                             
T37389           ELSE                                                   
                    ADD 1               TO WS-INPUT-SUB                 
T37389           END-IF                                                 
              END-IF                                                    
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
           IF ACCOUNT-NOT-PROCESSED                                     
              ADD 1                     TO WS-INPUT-OTHERS              
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07380000
      *  PROCESS OUTPUT BE28 FILE.                               *      07390000
      ************************************************************      07400000
       1200-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'N'                     TO WS-ACCOUNT-PROCESSED.        
           ADD 1                        TO WS-OUTPUT-ACCOUNTS.          
           IF EXT-BILL-NO-BILL-COPIES   > 1 AND                         
T37389        EXT-BILL-MASTER-SUB-FLAG = SPACES                         
              ADD 1                     TO WS-OUTPUT-DUPLICATE          
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
           IF EXT-BILL-NO-BILL-COPIES   = 0 AND                         
T37389        EXT-BILL-MASTER-SUB-FLAG = SPACES AND                     
T37389        ACCOUNT-NOT-PROCESSED                                     
              ADD 1                     TO WS-OUTPUT-PAPERLESS          
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
T37389      IF EXT-BILL-MASTER-SUB-FLAG = 'M' AND                       
T37389        ACCOUNT-NOT-PROCESSED                                     
              IF EXT-BILL-NO-BILL-COPIES   = 0                          
                 ADD 1                  TO WS-OUTPUT-MAS-PAPERLESS      
              ELSE                                                      
                 ADD 1                  TO WS-OUTPUT-MASTER             
              END-IF                                                    
              MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
           END-IF.                                                      
T37389                                                                  
T37389      IF EXT-BILL-MASTER-SUB-FLAG = 'S' AND                       
T37389        ACCOUNT-NOT-PROCESSED                                     
T37389        IF EXT-BILL-NO-BILL-COPIES   = 0                          
T37389           ADD 1                  TO WS-OUTPUT-SUB-PAPERLESS      
T37389        ELSE                                                      
T37389           ADD 1                  TO WS-OUTPUT-SUB                
T37389        END-IF                                                    
T37389        MOVE 'Y'                  TO WS-ACCOUNT-PROCESSED         
T37389     END-IF.                                                      
           IF ACCOUNT-NOT-PROCESSED                                     
              ADD 1                     TO WS-OUTPUT-OTHERS             
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07820000
      *  GENERATE THE REPORT DATA!                               *      07830000
      ************************************************************      07840000
       2000-WRITE-REPORT.                                               
                                                                        
           PERFORM 8000-WRITE-RPT-HEADER THRU 8000-EXIT.                
           PERFORM 8100-WRITE-IO-HEADER  THRU 8100-EXIT.                
           PERFORM 8200-WRITE-IO-DETAIL  THRU 8200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07940000
      *  VALIDATE ACCOUNT TOTALS                                 *      07950000
      ************************************************************      07960000
       5400-VALIDATE-ACCOUNT-TOTALS.                                    
                                                                        
           COMPUTE WS-TOTAL-INPUT-ACCOUNTS =                            
                   WS-INPUT-PAPERLESS      +                            
                   WS-INPUT-MASTER         +                            
                   WS-INPUT-SUB            +                            
                   WS-INPUT-MAS-PAPERLESS  +                            
                   WS-INPUT-SUB-PAPERLESS  +                            
T37389             WS-INPUT-PRT-MST-ONLY   +                            
                   WS-INPUT-DUPLICATE      +                            
                   WS-INPUT-OTHERS                                      
                                                                        
           IF WS-TOTAL-INPUT-ACCOUNTS = WS-INPUT-ACCOUNTS               
              DISPLAY 'INPUT ACCOUNT TOTALS MATCH'                      
           ELSE                                                         
              DISPLAY 'INPUT ACCOUNT TOTALS MISMATCH'                   
T37389        DISPLAY ' WS-TOTAL-INPUT-ACCOUNTS '                       
T37389                WS-TOTAL-INPUT-ACCOUNTS                           
T37389        DISPLAY ' WS-INPUT-ACCOUNTS ' WS-INPUT-ACCOUNTS           
           END-IF.                                                      
                                                                        
           COMPUTE WS-TOTAL-OUTPUT-ACCOUNTS =                           
                   WS-OUTPUT-PAPERLESS      +                           
                   WS-OUTPUT-MAS-PAPERLESS  +                           
                   WS-OUTPUT-SUB-PAPERLESS  +                           
                   WS-OUTPUT-MASTER         +                           
                   WS-OUTPUT-SUB            +                           
                   WS-OUTPUT-DUPLICATE      +                           
                   WS-OUTPUT-OTHERS                                     
                                                                        
           IF WS-TOTAL-OUTPUT-ACCOUNTS = WS-OUTPUT-ACCOUNTS             
              DISPLAY 'OUTPUT ACCOUNT TOTALS MATCH'                     
           ELSE                                                         
              DISPLAY 'OUTPUT ACCOUNT TOTALS MISMATCH'                  
T37389        DISPLAY ' WS-TOTAL-OUTPUT-ACCOUNTS '                      
T37389                WS-TOTAL-OUTPUT-ACCOUNTS                          
T37389        DISPLAY ' WS-OUTPUT-ACCOUNTS ' WS-OUTPUT-ACCOUNTS         
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08400000
      *  DETERMINE THE CORRECT INPUT FILE                        *      08410000
      ************************************************************      08420000
                                                                        
       7990-READ-INPUT.                                                 
                                                                        
           EVALUATE WS-FILE-TO-PROCESS                                  
               WHEN 'BE26'                                              
                   PERFORM 7991-READ-FCSBE26 THRU 7991-EXIT             
               WHEN 'BE32'                                              
                   PERFORM 7993-READ-FCSBE32 THRU 7993-EXIT             
               WHEN 'BE28'                                              
                   PERFORM 7995-READ-FCSBE28 THRU 7995-EXIT             
               WHEN OTHER                                               
                   MOVE 12 TO RETURN-CODE                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP910 PROCESSING ERROR      **'   
                   DISPLAY '**       ERROR READING INPUT FILE     **'   
                   DISPLAY '**  FILE TO PROCESS = ' WS-FILE-TO-PROCESS  
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08660000
      *  READ THE REGULAR BILL FILE                              *      08670000
      ************************************************************      08680000
                                                                        
       7991-READ-FCSBE26.                                               
                                                                        
           READ FCSBE26-FILE AT END                                     
               MOVE WS-Y                  TO WS-END-OF-BE26.            
           IF FBE26-SUCCESSFUL OR END-OF-BE26                           
               MOVE E-FBE26-DATA          TO WS-ACCOUNT-AT              
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE26        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE26-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       7991-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08880000
      *      READ THE CONSOLIDATED BILL FILE                     *      08890000
      ************************************************************      08900000
                                                                        
       7993-READ-FCSBE32.                                               
                                                                        
           READ FCSBE32-FILE AT END                                     
               MOVE WS-Y TO WS-END-OF-BE32.                             
           IF FBE32-SUCCESSFUL OR END-OF-BE32                           
               MOVE E-FBE32-DATA          TO WS-ACCOUNT-AT              
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE32        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE32-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           IF FBE32-SUCCESSFUL                                          
               MOVE FIOBE32 TO FIOBE26
           END-IF.                                 
                                                                        
       7993-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09120000
      *      READ THE OUTPUT BILL FILE                           *      09130000
      ************************************************************      09140000
                                                                        
       7995-READ-FCSBE28.                                               
                                                                        
           READ FCSBE28-FILE INTO WS-EXT-IO-AREA AT END                 
               MOVE WS-Y TO WS-END-OF-BE28.                             
           IF FBE28-SUCCESSFUL OR END-OF-BE28                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           IF FBE28-SUCCESSFUL                                          
               MOVE WS-BILL-DATA     TO EXT-BILL-REC                    
           END-IF.                                                      
                                                                        
       7995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09380000
      *  WRITE REPORT HEADER                                     *      09390000
      ************************************************************      09400000
                                                                        
       8000-WRITE-RPT-HEADER.                                           
                                                                        
T37389     IF WS-INPUT-ACCOUNTS  = WS-OUTPUT-ACCOUNTS OR                
T37389        WS-OUTPUT-ACCOUNTS = WS-INPUT-ACCOUNTS -                  
T37389                             WS-INPUT-PRT-MST-ONLY                
T37389        CONTINUE                                                  
T37389     ELSE                                                         
T37389        WRITE PCSRP910-REC FROM WS-FLOWER-BOX                     
T37389        WRITE PCSRP910-REC FROM WS-ALERT-MSG                      
T37389        WRITE PCSRP910-REC FROM WS-ALERT-MSG1                     
T37389        WRITE PCSRP910-REC FROM WS-FLOWER-BOX                     
T37389        WRITE PCSRP910-REC FROM WS-BLANK-LINE-80                  
T37389     END-IF.                                                      
T37389*                                                                 09560000
           WRITE PCSRP910-REC FROM WS-REPORT-HEADER.                    
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
           WRITE PCSRP910-REC FROM WS-REPORT-HEADER-1.                  
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 09610000
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09650000
      *  WRITE INPUT HEADER                                      *      09660000
      ************************************************************      09670000
                                                                        
       8100-WRITE-IO-HEADER.                                            
                                                                        
           WRITE PCSRP910-REC FROM WS-REPORT-HEADER-2.                  
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 09730000
           WRITE PCSRP910-REC FROM WS-REPORT-HEADER-3.                  
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 09760000
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09800000
      *  WRITE INPUT AND OUTPUT ACCOUNT DETAILS                  *      09810000
      ************************************************************      09820000
                                                                        
       8200-WRITE-IO-DETAIL.                                            
      *                                                                 09850000
      *                                                                 09860000
           MOVE WS-PRT-INP-PAPERLESS   TO LT-TITLE.                     
           MOVE WS-INPUT-PAPERLESS     TO LT-INPUT-ACCTS.               
           MOVE WS-OUTPUT-PAPERLESS    TO LT-OUTPUT-ACCTS.              
           WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 09920000
           MOVE WS-PRT-INP-MASTER      TO LT-TITLE.                     
           MOVE WS-INPUT-MASTER        TO LT-INPUT-ACCTS.               
           MOVE WS-OUTPUT-MASTER       TO LT-OUTPUT-ACCTS.              
           WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
T37389*                                                                 09980000
T37389     MOVE WS-PRT-INP-SUBS        TO LT-TITLE.                     
T37389     MOVE WS-INPUT-SUB           TO LT-INPUT-ACCTS.               
T37389     MOVE WS-OUTPUT-SUB          TO LT-OUTPUT-ACCTS.              
T37389     WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
T37389     WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
T37389*                                                                 10040000
T37389     MOVE WS-PRT-INP-MASTER-PLESS TO LT-TITLE.                    
T37389     MOVE WS-INPUT-MAS-PAPERLESS  TO LT-INPUT-ACCTS.              
T37389     MOVE WS-OUTPUT-MAS-PAPERLESS TO LT-OUTPUT-ACCTS.             
T37389     WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
T37389     WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
T37389                                                                  
T37389     MOVE WS-PRT-INP-SUB-PLESS    TO LT-TITLE.                    
T37389     MOVE WS-INPUT-SUB-PAPERLESS  TO LT-INPUT-ACCTS.              
T37389     MOVE WS-OUTPUT-SUB-PAPERLESS TO LT-OUTPUT-ACCTS.             
T37389     WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
T37389     WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
T37389*                                                                 10160000
T37389     MOVE WS-PRT-INP-PRINT-MST-ONLY-SUBS TO LT-TITLE.             
T37389     MOVE WS-INPUT-PRT-MST-ONLY   TO LT-INPUT-ACCTS.              
T37389     MOVE ZERO                    TO LT-OUTPUT-ACCTS.             
T37389     WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
T37389     WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 10220000
           MOVE WS-PRT-INP-DUPLICATE   TO LT-TITLE.                     
           MOVE WS-INPUT-DUPLICATE     TO LT-INPUT-ACCTS.               
           MOVE WS-OUTPUT-DUPLICATE    TO LT-OUTPUT-ACCTS.              
           WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 10340000
           MOVE WS-PRT-INP-OTHERS      TO LT-TITLE.                     
           MOVE WS-INPUT-OTHERS        TO LT-INPUT-ACCTS.               
           MOVE WS-OUTPUT-OTHERS       TO LT-OUTPUT-ACCTS.              
           WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
           WRITE PCSRP910-REC FROM WS-REPORT-DASH-DETAIL.               
      *                                                                 10400000
           MOVE WS-PRT-INP-ACCOUNT     TO LT-TITLE.                     
           MOVE WS-INPUT-ACCOUNTS      TO LT-INPUT-ACCTS.               
           MOVE WS-OUTPUT-ACCOUNTS     TO LT-OUTPUT-ACCTS.              
           WRITE PCSRP910-REC FROM WS-LINE-TOTAL.                       
           WRITE PCSRP910-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 10460000
           IF WS-INPUT-ACCOUNTS  NOT = WS-OUTPUT-ACCOUNTS               
              MOVE WS-PRT-IO-INPUT     TO IO-TITLE                      
              MOVE WS-INPUT-ACCOUNTS   TO IO-ACCTS                      
              MOVE SPACES              TO IO-OPEN-P                     
                                          IO-CLOSE-P                    
              WRITE PCSRP910-REC FROM WS-IO-MISMATCH-DETAIL             
              MOVE WS-PRT-IO-MISMATCH  TO IO-TITLE                      
A03876        MOVE WS-INPUT-PRT-MST-ONLY TO IO-ACCTS                    
              MOVE '('                 TO IO-OPEN-P                     
              MOVE ')'                 TO IO-CLOSE-P                    
              WRITE PCSRP910-REC FROM WS-IO-MISMATCH-DETAIL             
              WRITE PCSRP910-REC FROM WS-IO-DASH-DETAIL                 
              COMPUTE IO-DIFF-ACCTS = WS-INPUT-ACCOUNTS -               
                                   WS-INPUT-PRT-MST-ONLY                
              WRITE PCSRP910-REC FROM WS-IO-DIFF-DETAIL                 
              WRITE PCSRP910-REC FROM WS-IO-DASH-DETAIL                 
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
                                                                        
           CLOSE FCSBE26-FILE                                           
                 FCSBE32-FILE                                           
                 FCSBE28-FILE                                           
                 PCSRP910-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     10800000
             INCLUDE CPD09900                                           10810000
           END-EXEC.                                                    10820000
                                                                        
