       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP903.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     DEC 22,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      **     THIS PROGRAM UPDATES THE FIRST CHARACTER OF THE CODE    ***        
      **     REVENUE CLASS TO '9' FOR THE PASSED INPUT FILE'S        ***        
      **     PREMISE NO LIST                                         ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    ---------------------------------**        
ACT051***  03/03/2015    MS7M727     EZT TO COBOL CONVERSION CSR903  ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT PREMFILE                                              
               ASSIGN  TO UT-S-PREMFILE                                 
               FILE STATUS IS WS-PREMFILE-STATUS.                       
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN  TO UT-S-FCSPT33                                  
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN UT-S-FCSPT331                                     
               FILE STATUS IS WS-FCSPT331-STATUS.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       FD  PREMFILE                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  PREMFILE-REC.                                                
           05 WS-IN-PREM-NO                PIC X(10)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE SPACES.     
           05 PREM-OLD-REV-CL              PIC X(01)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE SPACES.     
           05 PREM-NEW-REV-CL              PIC X(01)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE SPACES.     
                                                                        
       COPY CFDPT33.                                                            
      *                                                                         
       COPY CFDPT331 .                                                          
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP903'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT          (PREFIX = AT)                                   
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_DET      (PREFIX = BG)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_HDR      (PREFIX = BI)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS-MNT-TRANS-HIST   (PREFIX = MH)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS-MT-TRN-HST-DET   (PREFIX = MI)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT     (PREFIX = UT)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_PREM_HIST   (PREFIX = CH)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_CLS_RATE     (PREFIX = Q8)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRVCLS                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    ABEND SWITCH COPYBOOK                                                
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWS0070B.                                                           
      *                                                                         
       01  WS-LITERL.                                                   
           05  WS-PROGRAM-NAME             PIC X(08) VALUE 'PCSRP903'.  
                                                                        
       01  WS-CPD00099-WORK.                                            
           05  WS-CPD99-ACCOUNT-NO         PIC S9(13) COMP-3 VALUE ZERO.
           05  WS-CPD99-PREMISE-NO         PIC S9(10) COMP-3 VALUE ZERO.
           05  WS-CPD99-DATE-SVC-END       PIC X(10)  VALUE SPACES.     
           05  WS-CPD99-NULL-IND           PIC S9(4)  USAGE COMP.       
           05  WS-CPD99-MAX-AT-FINAL-DT    PIC X(26)  VALUE SPACES.     
           05  WS-CPD99-MAX-AT-CREATE-DT   PIC X(26)  VALUE SPACES.     
           05  WS-CPD99-DUP-ROWS           PIC S9(4)  COMP   VALUE -811.
           05  WS-CPD99-RETURN-CODE        PIC -ZZZZZZZZ9.9.            
                                                                        
       01  WS-NULL-INDICATOR-1             PIC S9(04) COMP.             
                                                                        
       01  WS-COUNTER.                                                  
           05 WS-IN-REC-CNT              PIC 9(09) VALUE ZERO.          
           05 WS-TOT-UPD-CNT             PIC 9(09) VALUE ZERO.          
           05 WS-TOT-UTIL-SKIP-CNT       PIC 9(09) VALUE ZERO.          
           05 WS-TOT-BG-SKIP-CNT         PIC 9(09) VALUE ZERO.          
           05 WS-TOT-530-CNT             PIC 9(09) VALUE ZERO.          
           05 WS-TOT-PREM-NOT-FOUND-CNT  PIC 9(09) VALUE ZERO.          
           05 WS-TOT-NON-WNA-CNT         PIC 9(09) VALUE ZERO.          
           05 WS-RECORD-COUNT            PIC 9(09) VALUE ZERO.          
           05 WS-COMMIT-COUNT            PIC 9(09) VALUE ZERO.          
           05 WS-ERR-LINE-COUNT          PIC 9(01) VALUE ZERO.          
           05 WS-UPT-LINE-COUNT          PIC 9(01) VALUE ZERO.          
      *                                                                         
       01 WS-FILE-STATUS.                                               
           05 WS-FCSPT33-STATUS          PIC X(02) VALUE SPACES.        
              88 FCSPT33-SUCCESSFUL                VALUE '00'.          
           05 WS-FCSPT331-STATUS         PIC X(02) VALUE SPACES.        
              88 FCSPT331-SUCCESSFUL               VALUE '00'.          
           05 WS-PREMFILE-STATUS         PIC X(02) VALUE SPACES.        
              88 PREMFILE-SUCCESSFUL               VALUE '00'.          
              88 END-OF-REC                        VALUE '10'.          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                     PIC 9(02) VALUE ZERO.          
           05  WS-MM                     PIC 9(02) VALUE ZERO.          
           05  WS-SS                     PIC 9(02) VALUE ZERO.          
           05  WS-TT                     PIC 9(02) VALUE ZERO.          
      *                                                                         
       01 WS-RUN-TIME.                                                  
           05  WS-RT-HH                  PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE '.'.           
           05  WS-RT-MM                  PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE '.'.           
           05  WS-RT-SS                  PIC X(02) VALUE SPACES.        
      *                                                                         
       01 WS-RUN-DATE.                                                  
           05  WS-RD-MM                  PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-DD                  PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-YY                  PIC X(02) VALUE SPACES.        
      *                                                                         
       01 WS-CURRENT-DATE1.                                             
           05  WS-CY                     PIC X(04) VALUE SPACES.        
           05  WS-CM                     PIC X(02) VALUE SPACES.        
           05  WS-CD                     PIC X(02) VALUE SPACES.        
      *                                                                         
                                                                        
       01  WS-MISC.                                                     
           05 WS-ACCOUNT-NO              PIC 9(13) VALUE ZERO.          
           05 WS-EWNA-GROUP              PIC 9(02) VALUE ZERO.          
           05 WS-PARAGRAPH               PIC X(04) VALUE SPACES.        
           05 WS-ACTION                  PIC X(06) VALUE SPACES.        
           05 WS-TABLE                   PIC X(20) VALUE SPACES.        
           05 WS-TRAN-APPL-NO            PIC 9(03) VALUE ZERO.          
           05 WS-ERR-MSG                 PIC X(40) VALUE SPACES.        
           05 WS-ALL-IC-PROCESD          PIC X(01) VALUE SPACES.        
           05 WS-ELEC-WNA-GROUP-NO       PIC S9(4) USAGE COMP.          
           05 WS-ELEC-WNA-GROUP-NO-C     PIC S9(04) VALUE ZERO.         
           05 WS-FIRST-REC-ERR-RPT       PIC X(01) VALUE 'Y'.           
           05 WS-FIRST-REC-UPT-RPT       PIC X(01) VALUE 'Y'.           
           05 WS-PAGE-NO                 PIC 9(03) VALUE ZEROES.        
                                                                        
       01  WS-COMMENTS-TRANS.                                           
           05 WS-COMMENT-LINE1           PIC X(65) VALUE                
           'REV CLASS CHANGED BY DATA FROM RESOURCE PLANNING GROUP              
      -                                                   'BASED'.              
           05 WS-COMMENT-LINE2           PIC X(39) VALUE                
                  ' on usage trend for this premise   '.                
                                                                        
       01  WS-NEW-CODE-REV-CLASS         PIC X(03) VALUE SPACES.        
                                                                        
       01  WS-NEW-CODE-REV-CLASS1 REDEFINES WS-NEW-CODE-REV-CLASS.      
           05 WS-CODE-REV-1ST-DIGIT      PIC X(01).                     
           05 WS-CODE-REV-2ND-DIGIT      PIC X(01).                     
           05 WS-CODE-REV-3RD-DIGIT      PIC X(01).                     
                                                                        
       01  WS-TIMESTAMP                  PIC X(26) VALUE SPACES.        
                                                                        
       01  WS-TIMESTAMP1 REDEFINES WS-TIMESTAMP.                        
           05 WS-TIMESTAMP10             PIC X(10).                     
           05 WS-TIMESTAMP-REST          PIC X(16).                     
                                                                        
       01  WS-REPORT-HDR1.                                              
           05 FILLER                     PIC X(49) VALUE SPACES.        
           05 P-RPT-DESC-HDR             PIC X(37) VALUE                
                         'PREMISE FILE UPDATE - UT AND BG TABLE'.       
           05 FILLER                     PIC X(35) VALUE SPACES.        
           05 P-RPT-PAGE-HDR             PIC X(05) VALUE 'PAGE '.       
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-PAGE-NO              PIC zz9   VALUE ZEROES.        
           05 FILLER                     PIC X(03) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR2.                                              
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-RUN-DATE-HDR         PIC X(10) VALUE 'RUN DATE:'.   
           05 P-RPT-RUN-DATE             PIC X(08) VALUE SPACES.        
           05 FILLER                     PIC X(84) VALUE SPACES.        
           05 P-RPT-RUN-TIME-HDR         PIC X(10) VALUE 'RUN TIME :'.  
           05 P-RPT-RUN-TIME             PIC X(08) VALUE SPACES.        
           05 FILLER                     PIC X(10) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR3.                                              
           05 FILLER                     PIC X(41) VALUE SPACES.        
           05 P-RPT-OLD-REV-CLASS-HDR    PIC X(07) VALUE 'OLD REV'.     
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-NEW-REV-CLASS-HDR    PIC X(07) VALUE 'NEW REV'.     
           05 FILLER                     PIC X(74) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR4.                                              
           05 FILLER                     PIC X(02) VALUE SPACES.        
           05 P-RPT-PREM-NO-HDR          PIC X(08) VALUE 'PREM NO '.    
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-ACCT-NO-HDR          PIC X(08) VALUE 'ACCT NO '.    
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-IC-NO-HDR            PIC X(06) VALUE 'IC_NO '.      
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-OLD-REV-CLASS-HDR1   PIC X(05) VALUE 'CLASS'.       
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-NEW-REV-CLASS-HDR1   PIC X(05) VALUE 'CLASS'.       
                                                                        
       01  WS-REPORT-HDR5.                                              
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-PREM-NO              PIC X(10) VALUE SPACES.        
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-ACCT-NO              PIC X(13) VALUE SPACES.        
           05 FILLER                     PIC X(02) VALUE SPACES.        
           05 P-RPT-IC-NO                PIC ZZZ9  VALUE ZEROES.        
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-OLD-REV-CLASS        PIC X(03) VALUE SPACES.        
           05 FILLER                     PIC X(08) VALUE SPACES.        
           05 P-RPT-NEW-REV-CLASS        PIC X(03) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR6.                                              
           05 FILLER                     PIC X(49) VALUE SPACES.        
           05 P-RPT-DESC-HDR1            PIC X(41) VALUE                
                         'ELECTRIC WNA PREMISE FILE - ERROR MESSAGE'.   
           05 FILLER                     PIC X(43) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR7.                                              
           05 FILLER                     PIC X(45) VALUE SPACES.        
           05 P-RPT-RATE-PLAN-NO-HDR     PIC X(04) VALUE 'RATE'.        
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-CURR-REV-CLASS-HDR   PIC X(08) VALUE 'CURR REV'.    
           05 FILLER                     PIC X(74) VALUE SPACES.        
                                                                        
                                                                        
       01  WS-REPORT-HDR8.                                              
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-PREM-NO-HDR          PIC X(08) VALUE 'PREM NO '.    
           05 FILLER                     PIC X(09) VALUE SPACES.        
           05 P-RPT-ACCT-NO-HDR          PIC X(08) VALUE 'ACCT NO '.    
           05 FILLER                     PIC X(08) VALUE SPACES.        
           05 P-RPT-IC-NO-HDR            PIC X(06) VALUE 'IC_NO '.      
           05 FILLER                     PIC X(02) VALUE SPACES.        
           05 P-RPT-RATE-PLAN-NO-HDR1    PIC X(07) VALUE 'PLAN NO'.     
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-CURR-REV-CLASS-HDR1  PIC X(05) VALUE 'CLASS'.       
           05 FILLER                     PIC X(14) VALUE SPACES.        
           05 P-RPT-ERR-MSG-DESC-HDR     PIC X(17) VALUE                
                                                  'ERROR DESCRIPTION'.  
           05 FILLER                     PIC X(41) VALUE SPACES.        
                                                                        
       01  WS-REPORT-HDR9.                                              
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-PREM-NO1             PIC X(10) VALUE SPACES.        
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-ACCT-NO1             PIC X(13) VALUE SPACES.        
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-IC-NO1               PIC ZZZ9  VALUE ZEROES.        
           05 FILLER                     PIC X(08) VALUE SPACES.        
           05 P-RPT-RATE-PLAN-NO         PIC X(03) VALUE SPACES.        
           05 FILLER                     PIC X(08) VALUE SPACES.        
           05 P-RPT-CURR-REV-CLASS       PIC X(03) VALUE SPACES.        
           05 FILLER                     PIC X(12) VALUE SPACES.        
           05 P-RPT-ERR0R-MSG-DESC       PIC X(40) VALUE SPACES.        
      *                                                                         
       01  WS-REPORT-HDR10               PIC X(133) VALUE SPACES.       
      *                                                                         
       01  S-RETURN-CODE                 PIC S9(09) VALUE +000 COMP.    
      *                                                                         
      *****************************************************************         
      * CURSOR FOR GETTING RECORDS                                              
      *****************************************************************         
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU  0100-EXIT.        
                                                                        
           PERFORM 1000-PROCESS-INPUT           THRU  1000-EXIT.        
                                                                        
           PERFORM 9000-TERMINATE               THRU  9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME.             
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY(3:2)               TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE.             
      *                                                                         
           OPEN INPUT PREMFILE.                                         
           IF NOT PREMFILE-SUCCESSFUL                                   
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP903******************'         
               DISPLAY '**  0100-INITIALIZATION             **'         
               DISPLAY '**  ERROR OPENING PREMFILE          **'         
               DISPLAY '**  FILE STATUS = ' WS-PREMFILE-STATUS          
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
           IF NOT FCSPT331-SUCCESSFUL                                   
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP903******************'         
               DISPLAY '**  0100-INITIALIZATION             **'         
               DISPLAY '**  ERROR OPENING FCSBW04 FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT331-STATUS          
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP903******************'         
               DISPLAY '**  ERROR OPENING FCSPT331          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-READ-PREMFILE           THRU 7000-EXIT.         
           PERFORM 2000-PROCESS-ACCOUNTS        THRU 2000-EXIT          
           UNTIL END-OF-REC.                                            
           PERFORM 2450-SUMMARY-DETAIL          THRU 2450-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-ACCOUNTS                                                  
      ******************************************************************        
      *                                                                         
       2000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           IF PREM-OLD-REV-CL NOT EQUAL PREM-NEW-REV-CL                 
              PERFORM 2050-PROCESS-PREM-RECORD  THRU 2050-EXIT          
           END-IF.                                                      
           PERFORM 7000-READ-PREMFILE           THRU 7000-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-PROCESS-PREM-RECORD                                               
      ******************************************************************        
      *                                                                         
       2050-PROCESS-PREM-RECORD.                                        
      *                                                                         
           COMPUTE WS-RECORD-COUNT = WS-RECORD-COUNT + 1.               
                                                                        
           PERFORM 2100-GET-CURR-PREM-ACCT      THRU 2100-EXIT.         
                                                                        
           IF WS-CPD99-ACCOUNT-NO EQUAL 0                               
              COMPUTE WS-TOT-PREM-NOT-FOUND-CNT =                       
                      WS-TOT-PREM-NOT-FOUND-CNT + 1                     
              MOVE 'PREMISE DOES NOT HAVE CURRENT ACCOUNT'              
                                         TO WS-ERR-MSG                  
              MOVE WS-CPD99-ACCOUNT-NO   TO WS-ACCOUNT-NO               
              MOVE 0                     TO UT-IC-NO                    
              MOVE SPACES                TO UT-CODE-REVENUE-CLASS       
              PERFORM 2500-WRITE-ERR-RPT-PROCESS THRU 2500-EXIT         
           ELSE                                                         
              PERFORM 2150-PROCESS-ALL-ICS      THRU 2150-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-RECORD-COUNT >= 100                                    
                                                                        
              EXEC SQL                                                  
                   COMMIT                                               
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              COMPUTE WS-COMMIT-COUNT = WS-COMMIT-COUNT + 1             
              DISPLAY 'COMMIT POINT # ' WS-COMMIT-COUNT                 
                      ' LAST COMMITED PREMISE-NO = ' WS-IN-PREM-NO      
                      ' ACCOUN-NO  = ' WS-ACCOUNT-NO                    
              MOVE ZERO                  TO  WS-RECORD-COUNT            
           END-IF.                                                      
                                                                        
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-GET-CURR-PREM-ACCT                                                
      ******************************************************************        
      *                                                                         
       2100-GET-CURR-PREM-ACCT.                                         
      *                                                                         
           MOVE SPACES                   TO WS-ERR-MSG.                 
           MOVE ZERO                     TO WS-CPD99-ACCOUNT-NO.        
           MOVE WS-IN-PREM-NO            TO WS-CPD99-PREMISE-NO.        
           COMPUTE WS-IN-REC-CNT = WS-IN-REC-CNT + 1.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT       THRU 6990-EXIT.         
                                                                        
           IF WS-CPD99-ACCOUNT-NO NOT EQUAL ZERO                        
              MOVE WS-CPD99-ACCOUNT-NO   TO UT-ACCOUNT-NO               
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2150-PROCESS-ALL-ICS *                                                 
      ******************************************************************        
      *                                                                         
       2150-PROCESS-ALL-ICS.                                            
      *                                                                         
           MOVE UT-ACCOUNT-NO            TO WS-ACCOUNT-NO               
           MOVE ZERO                     TO Q8-ELEC-WNA-GROUP-NO.       
           PERFORM 7200-FETCH-GET-UTIL          THRU 7200-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              COMPUTE WS-TOT-UTIL-SKIP-CNT = WS-TOT-UTIL-SKIP-CNT + 1   
              MOVE 'ACCOUNT NOT FOUND IN UTIL TABLE'                    
                                         TO WS-ERR-MSG                  
              PERFORM 2500-WRITE-ERR-RPT-PROCESS                        
                                                THRU 2500-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 2200-CHECK-AND-UPD-WNA       THRU 2200-EXIT.         
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  CHECK AND UPDATE IF ELECTRIC WNA IS APPLICABLE                         
      *  2200-CHECK-AND-UPD-WNA                                                 
      ******************************************************************        
      *                                                                         
       2200-CHECK-AND-UPD-WNA.                                          
      *                                                                         
           PERFORM 2250-PROCESS-UPDATE          THRU 2250-EXIT.         
           MOVE ZERO                     TO Q8-ELEC-WNA-GROUP-NO.       
           PERFORM 7200-FETCH-GET-UTIL          THRU 7200-EXIT.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2250-PROCESS-UPDATE                                                    
      ******************************************************************        
      *                                                                         
       2250-PROCESS-UPDATE.                                             
      *                                                                         
           MOVE UT-CODE-REVENUE-CLASS    TO WS-NEW-CODE-REV-CLASS.      
                                                                        
           IF Q8-ELEC-WNA-GROUP-NO > 0                                  
              MOVE PREM-NEW-REV-CL       TO WS-CODE-REV-1ST-DIGIT       
              PERFORM 7600-UPDATE-REV-CLASS-UT                          
                                                THRU 7600-EXIT          
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                  MOVE UT-ACCOUNT-NO     TO BG-ACCOUNT-NO               
                  MOVE UT-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE           
                  MOVE UT-IC-NO          TO BG-IC-NO                    
                  MOVE UT-ACCOUNT-NO     TO BI-ACCOUNT-NO               
                  PERFORM 7700-UPDATE-REV-CLASS-BG                      
                                                THRU 7700-EXIT          
              END-IF                                                    
           ELSE                                                         
             COMPUTE WS-TOT-NON-WNA-CNT = WS-TOT-NON-WNA-CNT + 1        
             MOVE 'ELECTRIC WNA NOT APPLICABLE'                         
                                         TO WS-ERR-MSG                  
             PERFORM 2500-WRITE-ERR-RPT-PROCESS                         
                                                THRU 2500-EXIT          
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2300-FORMAT-MNT-ROWS.                                                  
      ******************************************************************        
      *                                                                         
       2300-FORMAT-MNT-ROWS.                                            
      *                                                                         
           PERFORM 7500-GET-TIMESTAMP           THRU 7500-EXIT.         
           MOVE WS-TIMESTAMP             TO MH-TRANS-HIST-SEQ-NO.       
           MOVE WS-TIMESTAMP10           TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE '   '                    TO MH-RESP-AREA-ID.            
           MOVE UT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 0                        TO MH-CUSTOMER-NO.             
           MOVE 'CSR903'                 TO MH-APPL-PROGRAM-ID.         
           MOVE 0                        TO MH-PREMISE-NO.              
           MOVE 'SYSTEM '                TO MH-USER-ID.                 
           MOVE MH-TRAN-COMMENT          TO WS-COMMENTS-TRANS.          
           MOVE SPACES                   TO MH-ENTITY-KEY-DESC.         
           MOVE 1                        TO WS-TRAN-APPL-NO.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2350-INSERT-TRANSHIST                                                  
      ******************************************************************        
      *                                                                         
       2350-INSERT-TRANSHIST.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE LENGTH OF  WS-NEW-CODE-REV-CLASS                        
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE WS-NEW-CODE-REV-CLASS    TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF  UT-CODE-REVENUE-CLASS                        
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE UT-CODE-REVENUE-CLASS    TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE 'CODE REVENUE CLASS'     TO MI-COLUMN-DESC.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
                                                                        
           IF Q8-ELEC-WNA-GROUP-NO NOT EQUAL                            
              WS-ELEC-WNA-GROUP-NO                                      
                                                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE Q8-ELEC-WNA-GROUP-NO  TO WS-EWNA-GROUP               
              MOVE LENGTH OF  WS-EWNA-GROUP                             
                                         TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-EWNA-GROUP         TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-ELEC-WNA-GROUP-NO-C TO WS-EWNA-GROUP              
              MOVE LENGTH OF  WS-EWNA-GROUP                             
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-EWNA-GROUP         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'EWNA GROUP'          TO MI-COLUMN-DESC              
              COMPUTE MI-TRAN-APPL-NO = MI-TRAN-APPL-NO + 1             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
           END-IF.                                                      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2450-SUMMARY-DETAIL                                                    
      ******************************************************************        
      *                                                                         
       2450-SUMMARY-DETAIL.                                             
      *                                                                         
           DISPLAY '********** SUMMARY DETAIL *************'.           
           DISPLAY '*                                     *'.           
           DISPLAY '*  INPUT FILE RECORDS = ' WS-IN-REC-CNT.            
           DISPLAY '*  UPDATE COUNT       = ' WS-TOT-UPD-CNT.           
           DISPLAY '*                                     *'.           
           DISPLAY '*            SKIP COUNT               *'.           
           DISPLAY '*  NON ELECTRIC WNA   = ' WS-TOT-NON-WNA-CNT.       
           DISPLAY '*  REFERENTIAL (-530) = ' WS-TOT-530-CNT.           
           DISPLAY '*  PREMISE NOT FOUND  = ' WS-TOT-PREM-NOT-FOUND-CNT.
           DISPLAY '*  UTIL UPDATE SKIP   = ' WS-TOT-UTIL-SKIP-CNT.     
           DISPLAY '*  BG UPDATE SKIP     = ' WS-TOT-BG-SKIP-CNT.       
           DISPLAY '*                                     *'.           
           DISPLAY '********** SUMMARY DETAIL *************'.           
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2500-WRITE-ERR-RPT-PROCESS                                             
      ******************************************************************        
      *                                                                         
       2500-WRITE-ERR-RPT-PROCESS.                                      
      *                                                                         
           IF WS-FIRST-REC-ERR-RPT  EQUAL 'Y'                           
              OR WS-ERR-LINE-COUNT > 50                                 
                                                                        
              IF WS-ERR-LINE-COUNT > 50                                 
                 MOVE ZERO               TO WS-ERR-LINE-COUNT           
              END-IF                                                    
              MOVE WS-REPORT-HDR6        TO PRT33-RECORD                
              PERFORM 8700-WRITE-FCSPT33        THRU 8700-EXIT          
              MOVE WS-REPORT-HDR2        TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              MOVE WS-REPORT-HDR10       TO PRT33-RECORD                
              PERFORM 8400-WRITE-FCSPT33        THRU 8400-EXIT          
              MOVE WS-REPORT-HDR7        TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              MOVE WS-REPORT-HDR8        TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              PERFORM 2550-MOVE-ERR-RPT         THRU 2550-EXIT          
              MOVE 'N'                   TO WS-FIRST-REC-ERR-RPT        
           ELSE                                                         
              PERFORM 2550-MOVE-ERR-RPT         THRU 2550-EXIT          
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2550-MOVE-ERR-RPT                                                      
      ******************************************************************        
      *                                                                         
       2550-MOVE-ERR-RPT.                                               
      *                                                                         
           MOVE WS-IN-PREM-NO         TO P-RPT-PREM-NO1.                
           MOVE WS-ACCOUNT-NO         TO P-RPT-ACCT-NO1.                
           MOVE UT-IC-NO              TO P-RPT-IC-NO1.                  
           MOVE UT-RATE-PLAN-NO       TO P-RPT-RATE-PLAN-NO.            
           MOVE UT-CODE-REVENUE-CLASS TO P-RPT-CURR-REV-CLASS.          
           MOVE WS-ERR-MSG            TO P-RPT-ERR0R-MSG-DESC.          
           MOVE WS-REPORT-HDR9        TO PRT33-RECORD.                  
           IF WS-FIRST-REC-ERR-RPT  EQUAL 'Y'                           
              OR WS-ERR-LINE-COUNT > 50                                 
              PERFORM 8200-WRITE-FCSPT33        THRU 8200-EXIT          
           ELSE                                                         
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-MOVE-UPDATE-RPT                                                   
      ******************************************************************        
      *                                                                         
       2600-MOVE-UPDATE-RPT.                                            
      *                                                                         
           MOVE WS-IN-PREM-NO         TO P-RPT-PREM-NO.                 
           MOVE WS-ACCOUNT-NO         TO P-RPT-ACCT-NO.                 
           MOVE UT-IC-NO              TO P-RPT-IC-NO.                   
           MOVE UT-CODE-REVENUE-CLASS TO P-RPT-OLD-REV-CLASS.           
           MOVE WS-NEW-CODE-REV-CLASS TO P-RPT-NEW-REV-CLASS.           
           MOVE WS-REPORT-HDR5        TO PRT331-RECORD.                 
                                                                        
           IF WS-FIRST-REC-UPT-RPT    EQUAL 'Y'                         
              OR WS-UPT-LINE-COUNT > 50                                 
              PERFORM 8300-WRITE-FCSPT331        THRU 8300-EXIT         
           ELSE                                                         
              PERFORM 8100-WRITE-FCSPT331       THRU 8100-EXIT          
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2650-WRITE-UPT-RPT-PROCESS                                             
      ******************************************************************        
      *                                                                         
       2650-WRITE-UPT-RPT-PROCESS.                                      
      *                                                                         
           IF WS-FIRST-REC-UPT-RPT    EQUAL 'Y'                         
              OR WS-UPT-LINE-COUNT > 50                                 
                                                                        
              IF WS-UPT-LINE-COUNT > 50                                 
                 MOVE ZERO               TO WS-UPT-LINE-COUNT           
              END-IF                                                    
              COMPUTE WS-PAGE-NO    = WS-PAGE-NO     +  1               
              MOVE WS-PAGE-NO            TO P-RPT-PAGE-NO               
              MOVE WS-REPORT-HDR1        TO PRT331-RECORD               
              PERFORM 8600-WRITE-FCSPT331       THRU 8600-EXIT          
              MOVE WS-REPORT-HDR2        TO PRT331-RECORD               
              PERFORM 8100-WRITE-FCSPT331       THRU 8100-EXIT          
              MOVE WS-REPORT-HDR10       TO PRT331-RECORD               
              PERFORM 8500-WRITE-FCSPT331       THRU 8500-EXIT          
              MOVE WS-REPORT-HDR3        TO PRT331-RECORD               
              PERFORM 8100-WRITE-FCSPT331       THRU 8100-EXIT          
              MOVE WS-REPORT-HDR4        TO PRT331-RECORD               
              PERFORM 8100-WRITE-FCSPT331       THRU 8100-EXIT          
              PERFORM 2600-MOVE-UPDATE-RPT      THRU 2600-EXIT          
              MOVE 'N'                   TO WS-FIRST-REC-UPT-RPT        
           ELSE                                                         
              PERFORM 2600-MOVE-UPDATE-RPT      THRU 2600-EXIT          
           END-IF.                                                      
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  6530-LOAD-MNT-TRANS-HIST                                               
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00099                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *6995-CPD99-ERROR-ROUTINE                                        *        
      ******************************************************************        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM.              
           PERFORM 9900-ABEND                   THRU 9900-EXIT.         
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7000-READ-PREMFILE                                                     
      ******************************************************************        
      *                                                                         
       7000-READ-PREMFILE.                                              
      *                                                                         
           READ PREMFILE                                                
                                                                        
           IF PREMFILE-SUCCESSFUL OR END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP903 ABORT *********'          
               DISPLAY '**ERROR IN READING PREMFILE FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS '  WS-PREMFILE-STATUS         
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-FETCH-GET-UTIL                                                    
      ******************************************************************        
      *                                                                         
       7200-FETCH-GET-UTIL.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT UT.ACCOUNT_NO                                      
                    ,UT.IC_NO                                           
                    ,UT.CODE_UTIL_TYPE                                  
                    ,UT.CODE_REVENUE_CLASS                              
                    ,UT.RATE_PLAN_NO                                    
                    ,Q8.ELEC_WNA_GROUP_NO                               
                    ,Q8A.ELEC_WNA_GROUP_NO                              
               INTO :UT-ACCOUNT-NO                                      
                   ,:UT-IC-NO                                           
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-CODE-REVENUE-CLASS                              
                   ,:UT-RATE-PLAN-NO                                    
                   ,:Q8-ELEC-WNA-GROUP-NO                               
                   ,:WS-ELEC-WNA-GROUP-NO                               
               FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
                   ,CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                   
                   ,CSS_REV_CLS_RATE Q8A WITH(READUNCOMMITTED)                  
              WHERE UT.COMPANY_NO     = '01'                            
                AND UT.CODE_UTIL_TYPE = 'E'                             
                AND UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
                AND Q8.COMPANY_NO     = UT.COMPANY_NO                   
                AND Q8.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE           
                AND Q8.RATE_PLAN_NO       = UT.RATE_PLAN_NO             
                AND Q8.CODE_REVENUE_CLASS = UT.CODE_REVENUE_CLASS       
                AND Q8A.COMPANY_NO     = UT.COMPANY_NO                  
                AND Q8A.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE          
                AND Q8A.RATE_PLAN_NO       = UT.RATE_PLAN_NO            
                AND Q8A.CODE_REVENUE_CLASS =                            
              (:PREM-NEW-REV-CL + CIS.SUBSTR3(
           Q8.CODE_REVENUE_CLASS,2,2))   
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.ACCOUNT_NO                                              
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*             ,UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,Q8.ELEC_WNA_GROUP_NO                                       
MFA-TR*             ,Q8A.ELEC_WNA_GROUP_NO                                      
MFA-TR*        INTO :UT-ACCOUNT-NO                                              
MFA-TR*            ,:UT-IC-NO                                                   
MFA-TR*            ,:UT-CODE-UTIL-TYPE                                          
MFA-TR*            ,:UT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*            ,:Q8-ELEC-WNA-GROUP-NO                                       
MFA-TR*            ,:WS-ELEC-WNA-GROUP-NO                                       
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_REV_CLS_RATE Q8                                         
MFA-TR*            ,CSS_REV_CLS_RATE Q8A                                        
MFA-TR*       WHERE UT.COMPANY_NO     = '01'                                    
MFA-TR*         AND UT.CODE_UTIL_TYPE = 'E'                                     
MFA-TR*         AND UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*         AND Q8.COMPANY_NO     = UT.COMPANY_NO                           
MFA-TR*         AND Q8.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                   
MFA-TR*         AND Q8.RATE_PLAN_NO       = UT.RATE_PLAN_NO                     
MFA-TR*         AND Q8.CODE_REVENUE_CLASS = UT.CODE_REVENUE_CLASS               
MFA-TR*         AND Q8A.COMPANY_NO     = UT.COMPANY_NO                          
MFA-TR*         AND Q8A.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                  
MFA-TR*         AND Q8A.RATE_PLAN_NO       = UT.RATE_PLAN_NO                    
MFA-TR*         AND Q8A.CODE_REVENUE_CLASS =                                    
MFA-TR*       (:PREM-NEW-REV-CL || SUBSTR(Q8.CODE_REVENUE_CLASS,2,2))           
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7200                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
                                                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP903 ABORT ******'                  
              DISPLAY '**  7200-FETCH-GET-UTIL     **'                  
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  ACCOUTN NO          = ' UT-ACCOUNT-NO        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  7500-GET-TIMESTAMP                                                     
      ******************************************************************        
      *                                                                         
       7500-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :WS-TIMESTAMP                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT_TIMESTAMP                                          
MFA-TR*         INTO :WS-TIMESTAMP                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP903   ABORT *****'                 
              DISPLAY '**  7500-GET-TIMESTAMP     ***'                  
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7600-UPDATE-REV-CLASS-UT                                               
      ******************************************************************        
      *                                                                         
       7600-UPDATE-REV-CLASS-UT.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE UT                                
                  SET UT.CODE_REVENUE_CLASS = :WS-NEW-CODE-REV-CLASS    
               FROM CSS_UTIL_ENVRNMT UT
                WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              
                  AND UT.IC_NO            = :UT-IC-NO                   
                  AND UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_UTIL_ENVRNMT UT                                       
MFA-TR*           SET UT.CODE_REVENUE_CLASS = :WS-NEW-CODE-REV-CLASS            
MFA-TR*         WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                      
MFA-TR*           AND UT.IC_NO            = :UT-IC-NO                           
MFA-TR*           AND UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
               WHEN SUCCESSFUL-CALL                                     
                  COMPUTE WS-TOT-UPD-CNT = WS-TOT-UPD-CNT + 1           
                  PERFORM 2300-FORMAT-MNT-ROWS  THRU 2300-EXIT          
                  PERFORM 2350-INSERT-TRANSHIST THRU 2350-EXIT          
                                                                        
               WHEN NOT-FOUND                                           
                  COMPUTE WS-TOT-UTIL-SKIP-CNT =                        
                                     WS-TOT-UTIL-SKIP-CNT + 1           
                  MOVE 'NOT FOUND IN UTIL TABLE'                        
                                         TO WS-ERR-MSG                  
                  PERFORM 2500-WRITE-ERR-RPT-PROCESS                    
                                                THRU 2500-EXIT          
                                                                        
               WHEN -530                                                
                  COMPUTE WS-TOT-530-CNT = WS-TOT-530-CNT + 1           
                  MOVE 'REFERENTIAL INTEGRITY' TO WS-ERR-MSG            
                  PERFORM 2500-WRITE-ERR-RPT-PROCESS                    
                                                THRU 2500-EXIT          
                                                                        
               WHEN OTHER                                               
                  DISPLAY '******** PCSRP903   ABORT *****'             
                  DISPLAY '**  7600-UPDATE-REV-CLASS-UT**'              
                  DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE 
                  DISPLAY '**  ACCOUTN NO     = ' UT-ACCOUNT-NO         
                  DISPLAY '**  PROCESSING TERMINATED  **'               
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7700-UPDATE-REV-CLASS-BG                                               
      ******************************************************************        
      *                                                                         
       7700-UPDATE-REV-CLASS-BG.                                        
      *                                                                         
           EXEC SQL                                                     
             UPDATE BG                                   
                SET BG.CODE_REVENUE_CLASS = :WS-NEW-CODE-REV-CLASS      
             FROM CSS_BILLING_DET BG
              WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO              
                AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE          
                AND BG.IC_NO              = :BG-IC-NO                   
                AND BG.REV_MTH_ORIG_BILL  = 0                           
                AND BG.CODE_BILL_ITM_TYPE <> 'B'                        
                AND BG.REBILL_IND         <> 'Y'                        
                AND BG.BILL_NO            IN                            
                    ( SELECT BI.BILL_NO                                 
                        FROM CSS_BILLING_HDR BI                         
                       WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO             
                         AND BI.DATE_BILLED IS NULL         )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_BILLING_DET BG                                          
MFA-TR*         SET BG.CODE_REVENUE_CLASS = :WS-NEW-CODE-REV-CLASS              
MFA-TR*       WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*         AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                  
MFA-TR*         AND BG.IC_NO              = :BG-IC-NO                           
MFA-TR*         AND BG.REV_MTH_ORIG_BILL  = 0                                   
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE <> 'B'                                
MFA-TR*         AND BG.REBILL_IND         <> 'Y'                                
MFA-TR*         AND BG.BILL_NO            IN                                    
MFA-TR*             ( SELECT BI.BILL_NO                                         
MFA-TR*                 FROM CSS_BILLING_HDR BI                                 
MFA-TR*                WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                     
MFA-TR*                  AND BI.DATE_BILLED IS NULL         )                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
              PERFORM 2650-WRITE-UPT-RPT-PROCESS                        
                                               THRU 2650-EXIT           
              DISPLAY 'ACCOUNT-NO       :' WS-ACCOUNT-NO                
              DISPLAY 'IC-NO            :' UT-IC-NO                     
              DISPLAY 'RATE-PLAN-NO     :' UT-RATE-PLAN-NO              
              DISPLAY 'REVENUE CLASS    :' UT-CODE-REVENUE-CLASS        
              DISPLAY 'NEW REVENUE CLASS:' WS-NEW-CODE-REV-CLASS        
           ELSE                                                         
              MOVE UT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
              COMPUTE WS-TOT-BG-SKIP-CNT = WS-TOT-BG-SKIP-CNT + 1       
              MOVE 'BILL HOOK NOT FOUND' TO WS-ERR-MSG                  
              PERFORM 2500-WRITE-ERR-RPT-PROCESS                        
                                               THRU 2500-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           COMPUTE WS-ERR-LINE-COUNT = WS-ERR-LINE-COUNT + 1.           
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
           COMPUTE WS-UPT-LINE-COUNT = WS-UPT-LINE-COUNT + 1.           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           COMPUTE WS-ERR-LINE-COUNT = WS-ERR-LINE-COUNT + 1.           
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           COMPUTE WS-UPT-LINE-COUNT = WS-UPT-LINE-COUNT + 1.           
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8400-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8400-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           COMPUTE WS-ERR-LINE-COUNT = WS-ERR-LINE-COUNT + 1.           
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8500-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8500-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           COMPUTE WS-UPT-LINE-COUNT = WS-UPT-LINE-COUNT + 1.           
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 8600-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8600-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           COMPUTE WS-UPT-LINE-COUNT = WS-UPT-LINE-COUNT + 1.           
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8700-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8700-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           COMPUTE WS-ERR-LINE-COUNT = WS-ERR-LINE-COUNT + 1.           
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  25890000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  25900000
      ****************************************************************  25910000
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 25950000
      *****************************************************************         
      * 9000-TERMINATE.                                                         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  26130000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *  26140000
      ****************************************************************  26150000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 26170000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                 26470000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
