       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP827.                                        
       DATE-WRITTEN.   05/05/04.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
T31270**  09/21/04    SJB        INITIAL PROGRAM WRITTEN TO PRODUCE  **         
      **                         DAILY DEPOSITS AND INTEREST REPORT. **         
      **                         (DUPLICATE OF PCSRP827;ACTIVE DEP.  **         
      **                          INSTEAD OF PAID DEP.)              **         
      **                                                             **         
A05136**  29 DEC 2015 RF10596    CHANGE PRINTER LENGTHS              **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP827 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP827.                                                           
A05136 COPY CSSPT33.                                                            
A05136 COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP827.                                                           
       COPY FIORP827.                                                           
A05136 COPY CFDPT33.                                                            
A05136 COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP827'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(50)     VALUE              
               '   BILLED DEPOSITS/INTEREST LIABILITY             '.    
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE2.                                  
               10  FILLER              PIC X(18)     VALUE SPACES.      
               10  WS-DEFAULT-RPT1-TITLE2-TP PIC X(07).                 
               10  FILLER              PIC X(07)     VALUE ' REPORT'.   
               10  FILLER              PIC X(18)     VALUE SPACES.      
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE3.                                  
               10  FILLER              PIC X(07)     VALUE SPACES.      
               10  FILLER              PIC X(19)     VALUE              
                                          '      CURRENT AS OF'.        
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  WS-DEFAULT-RPT1-TITLE3-DT PIC X(08).                 
               10  FILLER              PIC X(15)     VALUE SPACES.      
      *                                                                         
           05  WS-MORE-DATA-SW         PIC X(01)     VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-END-REC-PROCESSED    PIC X(01)     VALUE 'N'.         
               88  END-REC-WAS-PROCESSED             VALUE 'Y'.         
      *                                                                         
           05  WS-COMP-REC-CNTR        PIC S9(07)    VALUE ZERO COMP-3. 
           05  WS-FRP827-REC-CNTR      PIC S9(07)    VALUE ZERO COMP-3. 
           05  WS-FRP827-STATUS        PIC X(02).                       
               88  FRP827-SUCCESSFUL                 VALUE '00'.        
A05136     05  WS-FCA33-STATUS         PIC X(02).                       
A05136         88  FCA33-SUCCESSFUL                  VALUE '00'.        
A05136     05  WS-FCA331-STATUS        PIC X(02).                       
A05136         88  FCA331-SUCCESSFUL                 VALUE '00'.        
      *                                                                         
           05  WS-PREV-ACCOUNT-TYPE    PIC X(01)     VALUE SPACE.       
           05  WS-CURR-REV-CLASS-SORT  PIC X(01)     VALUE SPACE.       
           05  WS-CURR-DATE-DEP-SORT   PIC X(01)     VALUE SPACE.       
           05  WS-CURRENT-CUST-NO      PIC 9(10)     VALUE ZEROES.      
           05  WS-CURRENT-REV-CLASS    PIC X(01)     VALUE SPACES.      
           05  WS-CURRENT-COMP-NO      PIC X(02)     VALUE SPACES.      
           05  WS-CURRENT-REG-GRP      PIC X(02)     VALUE SPACES.      
           05  WS-HEADER-COMP-NO       PIC X(02)     VALUE SPACES.      
      *                                                                         
       01  WS-COMPANY-TOTAL-LINE.                                       
           05  WS-AC-TOTAL-COUNT       PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-AC-TOTAL-NO-CUSTS    PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-AC-TOTAL-DEPOSIT     PIC S9(11)V99 VALUE ZEROS COMP-3.
           05  WS-AC-TOTAL-INTEREST    PIC S9(11)V99 VALUE ZEROS COMP-3.
           05  WS-CO-TOTAL-COUNT       PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-CO-TOTAL-NO-CUSTS    PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-CO-TOTAL-DEPOSIT     PIC S9(11)V99 VALUE ZEROS COMP-3.
           05  WS-CO-TOTAL-INTEREST    PIC S9(11)V99 VALUE ZEROS COMP-3.
           05  WS-GR-TOTAL-COUNT       PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-GR-TOTAL-NO-CUSTS    PIC S9(10)    VALUE ZEROS COMP-3.
           05  WS-GR-TOTAL-DEPOSIT     PIC S9(11)V99 VALUE ZEROS COMP-3.
           05  WS-GR-TOTAL-INTEREST    PIC S9(11)V99 VALUE ZEROS COMP-3.
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(03)     VALUE 63   COMP-3. 
       01  WS-RPT2-LINE-NO             PIC 9(03)     VALUE 63   COMP-3. 
       01  WS-RPT1-PAGE-NO             PIC 9(05)     VALUE ZERO COMP-3. 
       01  WS-RPT2-PAGE-NO             PIC 9(05)     VALUE ZERO COMP-3. 
      *                                                                         
      *                                                                         
       01  WS-PRINT-DATE.                                               
           05  WS-PR-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-PR-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-PR-CC                PIC X(02).                       
           05  WS-PR-YY                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSRP827'.  
           05  WS-SPC                  PIC X(01)     VALUE ' '.         
           05  WS-SPC-3                PIC X(03)     VALUE '   '.       
           05  WS-52                   PIC 9(02)     VALUE 52.          
           05  WS-42                   PIC 9(02)     VALUE 42.          
           05  WS-62                   PIC 9(02)     VALUE 62.          
           05  WS-ZERO                 PIC 9(01)     VALUE 0.           
           05  WS-25                   PIC 9(02)     VALUE 25.          
           05  WS-100                  PIC 9(03)     VALUE 100.         
           05  WS-250                  PIC 9(03)     VALUE 250.         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X         VALUE ' '.         
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  P-RPT1-TITLE-RPTN   PIC X(01).                       
               10  FILLER              PIC X(48)     VALUE SPACES.      
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(29)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-DATE: '.
               10  P-RPT1-RUN-DATE     PIC X(08).                       
               10  FILLER              PIC X(02)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X         VALUE ' '.         
               10  FILLER              PIC X(06)     VALUE 'DATE: '.    
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(27)     VALUE SPACES.      
               10  P-RPT1-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(21)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-TIME: '.
               10  P-RPT1-RUN-TIME     PIC X(08).                       
               10  FILLER              PIC X(02)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X         VALUE ' '.         
               10  FILLER              PIC X(38)     VALUE SPACES.      
               10  P-RPT1-HEAD2        PIC X(50).                       
               10  FILLER              PIC X(28)     VALUE SPACES.      
               10  FILLER              PIC X(08)     VALUE 'PAGE:   '.  
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(02)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER3        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER              PIC X         VALUE ' '.         
               10  FILLER              PIC X(41)     VALUE SPACES.      
               10  P-RPT1-HEAD3        PIC X(50).                       
               10  FILLER              PIC X(41)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER4        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10  FILLER              PIC X         VALUE ' '.         
               10  FILLER              PIC X(10)     VALUE SPACES.      
               10  FILLER              PIC X(16)     VALUE              
                                                    'REVENUE CLASS: '.  
               10  P-RPT1-REV-CLASS    PIC X(13).                       
               10  FILLER              PIC X(93)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X(15)     VALUE              
                                                    'ACCOUNT NUMBER'.   
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(15)     VALUE              
                                                    'NAME'.             
               10  FILLER              PIC X(18)     VALUE SPACES.      
               10  FILLER              PIC X(11)     VALUE              
                                                    'CUSTOMER NO'.      
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  FILLER              PIC X(14)     VALUE              
                                                    'CREDIT GROUP  '.   
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  FILLER              PIC X(15)     VALUE              
                                                    'DEPOSIT DATE   '.  
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(13)     VALUE              
                                                    'DEPOSIT AMNT '.    
               10  FILLER              PIC X(05)     VALUE SPACES.      
               10  FILLER              PIC X(16)     VALUE              
                                                    'DEPOSIT INTEREST'. 
               10  FILLER              PIC X(01)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER5        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10  FILLER              PIC X         VALUE ' '.         
               10  FILLER              PIC X(10) VALUE '********* '.    
               10  P-RPT1-HEAD5        PIC X(32).                       
               10  FILLER              PIC X(90) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  P-ACCOUNT-NO        PIC 9(13).                       
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  P-NAME              PIC X(30).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P-CUST-NO           PIC X(10).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P-CREDIT-GROUP      PIC X(14).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P-DEPOSIT-DATE      PIC X(10).                       
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  P-DEPOSIT-AMT       PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(08)     VALUE SPACES.      
               10  P-INTEREST-AMT      PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(01)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **        COMMON WORKING STORAGE FOR REPORT TOTAL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-TOTAL-LINES.                                              
      *                                                                         
           05  WS-TOTAL-LINE-1A.                                        
               10  FILLER              PIC X(02)     VALUE SPACES.      
               10  P-TOT-LINE-WHAT     PIC X(26).                       
               10  FILLER              PIC X(01)     VALUE '='.         
               10  P-TOT-TOTAL-COUNT   PIC ZZZ,ZZZ,ZZ9.                 
               10  FILLER              PIC X(09)     VALUE ' DEPOSITS'. 
               10  P-TOT-NO-CUSTS      PIC ZZZ,ZZZ,ZZ9.                 
               10  FILLER              PIC X(11)     VALUE ' CUSTOMERS'.
               10  FILLER              PIC X(11)     VALUE SPACES.      
               10  P-TOT-FILLER2       PIC X(10)     VALUE SPACES.      
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  P-TOT-DEPOSIT-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(08)     VALUE SPACES.      
               10  P-TOT-INTEREST-AMT  PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(01)     VALUE SPACES.      
      *                                                                         
                                                                        
       01  WS-LINE                     PIC X(132)    VALUE ALL '-'.     
       01  WS-BLANK-LINE               PIC X(132)    VALUE SPACES.      
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSRP827 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-BEGIN-REC    THRU 1000-EXIT.            
           PERFORM 7100-READ-FCSRP827        THRU 7100-EXIT.            
           MOVE E-FRP827-COMPANY-NO     TO WS-CURRENT-COMP-NO.          
           MOVE E-FRP827-REG-GROUP      TO WS-CURRENT-REG-GRP.          
           MOVE E-FRP827-REV-CLASS      TO WS-CURRENT-REV-CLASS.        
           MOVE E-FRP827-CUST-NO        TO WS-CURRENT-CUST-NO.          
           MOVE E-FRP827-REV-CLASS-SORT TO WS-CURR-REV-CLASS-SORT.      
           MOVE E-FRP827-DATE-DEP-SORT  TO WS-CURR-DATE-DEP-SORT.       
           PERFORM 8110-PRINT-COMP-NAME      THRU 8110-EXIT.            
           PERFORM 8210-PRINT-TITLE          THRU 8210-EXIT.            
           PERFORM 8310-PRINT-HEADERS        THRU 8310-EXIT.            
           PERFORM 8315-PRINT-HEADER5        THRU 8315-EXIT.            
           PERFORM 1100-PRODUCE-REPORTS      THRU 1100-EXIT             
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
           PERFORM 2520-FORMAT-REV-CLASS-TOT THRU 2520-EXIT.            
           PERFORM 8420-PRINT-TOTAL-LINE     THRU 8420-EXIT.            
           PERFORM 2500-FORMAT-COMPANY-TOTAL THRU 2500-EXIT.            
           PERFORM 8420-PRINT-TOTAL-LINE     THRU 8420-EXIT.            
      *                                                                         
           MOVE SPACES              TO C7-COMPANY-NAME.                 
           MOVE 'SCANA CORPORATION' TO C7-COMPANY-NAME.                 
           MOVE C7-COMPANY-NAME     TO P-RPT1-COMP-NAME.                
           MOVE 1                   TO WS-RPT1-PAGE-NO.                 
           MOVE WS-PGRMNAME         TO P-RPT1-TITLE-PGNM.               
           MOVE WS-ZERO             TO WS-HEADER-COMP-NO.               
           MOVE '1'                 TO P-RPT1-TITLE-RPTN.               
           MOVE  WS-RPT1-TITLE      TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT33-RECORD.                    
A05136     WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           ADD 1                    TO WS-RPT2-PAGE-NO.                 
           MOVE '2'                 TO P-RPT1-TITLE-RPTN.               
           MOVE  WS-RPT1-TITLE      TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT331-RECORD                    
A05136     WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           PERFORM 8200-PRINT-TITLE        THRU 8200-EXIT.              
           PERFORM 8300-PRINT-HEADERS      THRU 8300-EXIT               
           PERFORM 8210-PRINT-TITLE        THRU 8210-EXIT.              
           PERFORM 8310-PRINT-HEADERS      THRU 8310-EXIT               
           PERFORM 2510-FORMAT-GRAND-TOTAL THRU 2510-EXIT.              
           PERFORM 8420-PRINT-TOTAL-LINE   THRU 8420-EXIT.              
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP827 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       OPEN INPUT/OUTPUT FILES, ACCEPT SYSTEM TIME & DATE,  **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
A05136     OPEN OUTPUT FCSPT33-FILE.                                    
A05136     OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
           OPEN INPUT FCSRP827-FILE.                                    
           IF FRP827-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      FCSRP827 PROCESSING ERROR       **'     
               DISPLAY '**  OPEN ERROR OF FCSRP827- INPUT FILE  **'     
               DISPLAY '**        FILE STATUS = ' WS-FRP827-STATUS      
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       CHECK FOR BEGINNING CONTROL RECORD OF FCSRP827 FILE  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSRP827            THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP827-KEY-BREC EQUAL LOW-VALUES                        
               SUBTRACT 1 FROM WS-FRP827-REC-CNTR                       
               MOVE E-FRP827-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
               MOVE WS-DATE-8          TO WS-DEFAULT-RPT1-TITLE3-DT     
           ELSE                                                         
               DISPLAY '**       PCSRP827 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROL THE MAIN FLOW OF REPORT PROGRAM PCSRP827     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**       FCSRP827 PROCESSING ERROR     **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF E-FRP827-KEY-EREC    EQUAL HIGH-VALUES                
                   PERFORM 1700-CHECK-END-REC THRU 1700-EXIT            
               ELSE                                                     
                   PERFORM 2100-CHECK-COMP-NO THRU 2100-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSRP827 THRU 7100-EXIT.                   
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       CHECK WHETHER TO PROCESS END OF FILE RECORD OR       **          
      **       COMPANY END RECORD                                   **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           IF E-FRP827-KEY-EREC EQUAL HIGH-VALUES                       
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       CHECK FOR ACCURATE RECORD COUNT, SET END-REC SWITCH  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FRP827-REC-CNTR.                          
      *                                                                         
           IF WS-FRP827-REC-CNTR EQUAL E-FRP827-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         FCSRP827 PROCESSING ERROR       **'  
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP827-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP827-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y TO WS-END-REC-PROCESSED.                           
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECK COMP-NO - IF COMP CHANGES, DO END TOTALS (IF   **          
      **       PROG IS PROCESSING ALL COMPS), ELSE PRODUCE REPORT   **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           IF E-FRP827-CUST-NO NOT EQUAL WS-CURRENT-CUST-NO             
               MOVE E-FRP827-CUST-NO TO WS-CURRENT-CUST-NO              
               ADD 1 TO WS-AC-TOTAL-NO-CUSTS                            
           END-IF.                                                      
           IF E-FRP827-REV-CLASS-SORT NOT EQUAL WS-CURR-REV-CLASS-SORT  
               PERFORM 2520-FORMAT-REV-CLASS-TOT THRU 2520-EXIT         
               PERFORM 8420-PRINT-TOTAL-LINE THRU 8420-EXIT             
               IF E-FRP827-DATE-DEP-SORT NOT = WS-CURR-DATE-DEP-SORT    
                   MOVE E-FRP827-DATE-DEP-SORT TO WS-CURR-DATE-DEP-SORT 
                   MOVE 0                      TO WS-RPT1-PAGE-NO       
                   IF E-FRP827-COMPANY-NO EQUAL WS-CURRENT-COMP-NO AND  
                      E-FRP827-REG-GROUP  EQUAL WS-CURRENT-REG-GRP      
                       PERFORM 8315-PRINT-HEADER5  THRU 8315-EXIT       
                   END-IF                                               
               END-IF                                                   
               IF E-FRP827-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO OR   
                  E-FRP827-REG-GROUP  NOT EQUAL WS-CURRENT-REG-GRP      
                   PERFORM 2500-FORMAT-COMPANY-TOTAL THRU 2500-EXIT     
                   PERFORM 8420-PRINT-TOTAL-LINE THRU 8420-EXIT         
                   MOVE E-FRP827-COMPANY-NO      TO WS-CURRENT-COMP-NO  
                   MOVE E-FRP827-REG-GROUP       TO WS-CURRENT-REG-GRP  
                   PERFORM 8110-PRINT-COMP-NAME  THRU 8110-EXIT         
                   PERFORM 8210-PRINT-TITLE      THRU 8210-EXIT         
                   PERFORM 8310-PRINT-HEADERS    THRU 8310-EXIT         
                   PERFORM 8315-PRINT-HEADER5    THRU 8315-EXIT         
               END-IF                                                   
               MOVE E-FRP827-REV-CLASS-SORT TO WS-CURR-REV-CLASS-SORT   
               MOVE E-FRP827-REV-CLASS      TO WS-CURRENT-REV-CLASS     
               PERFORM 8100-PRINT-COMP-NAME THRU 8100-EXIT              
               PERFORM 8200-PRINT-TITLE     THRU 8200-EXIT              
               PERFORM 8250-PRINT-REV-CLASS THRU 8250-EXIT              
               PERFORM 8300-PRINT-HEADERS   THRU 8300-EXIT              
               PERFORM 8305-PRINT-HEADER5   THRU 8305-EXIT              
           END-IF.                                                      
      *                                                                         
           IF E-FRP827-DATE-DEP-SORT NOT EQUAL WS-CURR-DATE-DEP-SORT    
               PERFORM 2520-FORMAT-REV-CLASS-TOT THRU 2520-EXIT         
               PERFORM 8420-PRINT-TOTAL-LINE THRU 8420-EXIT             
               MOVE E-FRP827-DATE-DEP-SORT TO WS-CURR-DATE-DEP-SORT     
               IF E-FRP827-COMPANY-NO EQUAL WS-CURRENT-COMP-NO AND      
                  E-FRP827-REG-GROUP  EQUAL WS-CURRENT-REG-GRP          
                   PERFORM 8315-PRINT-HEADER5  THRU 8315-EXIT           
               END-IF                                                   
               IF E-FRP827-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO OR   
                  E-FRP827-REG-GROUP  NOT EQUAL WS-CURRENT-REG-GRP      
                   PERFORM 2500-FORMAT-COMPANY-TOTAL THRU 2500-EXIT     
                   PERFORM 8420-PRINT-TOTAL-LINE THRU 8420-EXIT         
                   MOVE E-FRP827-COMPANY-NO      TO WS-CURRENT-COMP-NO  
                   MOVE E-FRP827-REG-GROUP       TO WS-CURRENT-REG-GRP  
                   PERFORM 8110-PRINT-COMP-NAME  THRU 8110-EXIT         
                   PERFORM 8210-PRINT-TITLE      THRU 8210-EXIT         
                   PERFORM 8310-PRINT-HEADERS    THRU 8310-EXIT         
                   PERFORM 8315-PRINT-HEADER5    THRU 8315-EXIT         
               END-IF                                                   
               MOVE E-FRP827-REV-CLASS-SORT TO WS-CURR-REV-CLASS-SORT   
               MOVE E-FRP827-REV-CLASS      TO WS-CURRENT-REV-CLASS     
               PERFORM 8100-PRINT-COMP-NAME THRU 8100-EXIT              
               PERFORM 8200-PRINT-TITLE     THRU 8200-EXIT              
               PERFORM 8250-PRINT-REV-CLASS THRU 8250-EXIT              
               PERFORM 8300-PRINT-HEADERS   THRU 8300-EXIT              
               PERFORM 8305-PRINT-HEADER5   THRU 8305-EXIT              
           END-IF.                                                      
      *                                                                         
           IF E-FRP827-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO OR       
              E-FRP827-REG-GROUP  NOT EQUAL WS-CURRENT-REG-GRP          
               PERFORM 2520-FORMAT-REV-CLASS-TOT THRU 2520-EXIT         
               PERFORM 8420-PRINT-TOTAL-LINE     THRU 8420-EXIT         
               PERFORM 2500-FORMAT-COMPANY-TOTAL THRU 2500-EXIT         
               PERFORM 8420-PRINT-TOTAL-LINE     THRU 8420-EXIT         
               MOVE E-FRP827-COMPANY-NO      TO WS-CURRENT-COMP-NO      
               MOVE E-FRP827-REG-GROUP       TO WS-CURRENT-REG-GRP      
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8250-PRINT-REV-CLASS      THRU 8250-EXIT         
               PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT         
               PERFORM 8305-PRINT-HEADER5        THRU 8305-EXIT         
               PERFORM 8110-PRINT-COMP-NAME      THRU 8110-EXIT         
               PERFORM 8210-PRINT-TITLE          THRU 8210-EXIT         
               PERFORM 8310-PRINT-HEADERS        THRU 8310-EXIT         
               PERFORM 8315-PRINT-HEADER5        THRU 8315-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-PRODUCE-RPT THRU 2200-EXIT.                     
           ADD 1 TO WS-COMP-REC-CNTR.                                   
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-62                        
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8250-PRINT-REV-CLASS      THRU 8250-EXIT         
               PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT         
               PERFORM 8305-PRINT-HEADER5        THRU 8305-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-FORMAT-DETAIL-LINE       THRU 2300-EXIT.        
           PERFORM 8900-PRINT-DETAIL-LINE        THRU 8900-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP827       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FRP827-ACCOUNT-NO     TO P-ACCOUNT-NO.                
           MOVE E-FRP827-CUST-NO        TO P-CUST-NO.                   
           MOVE E-FRP827-CUST-NAME      TO P-NAME.                      
           MOVE E-FRP827-LIABLE-AMT     TO P-DEPOSIT-AMT.               
           MOVE E-FRP827-AMT-INTEREST   TO P-INTEREST-AMT.              
      *                                                                         
           EVALUATE E-FRP827-CREDIT-GROUP                               
              WHEN 'A'                                                  
                MOVE '  ARREARS  '             TO P-CREDIT-GROUP        
              WHEN 'B'                                                  
                MOVE '  BALANCE  '             TO P-CREDIT-GROUP        
              WHEN 'C'                                                  
                MOVE '   EXEMPT  '             TO P-CREDIT-GROUP        
              WHEN 'N'                                                  
                MOVE '     NEW   '             TO P-CREDIT-GROUP        
              WHEN OTHER                                                
                MOVE SPACES                    TO P-CREDIT-GROUP        
           END-EVALUATE.                                                
      *                                                                         
           IF E-FRP827-DATE-DEPOSIT-RECD EQUAL SPACES OR LOW-VALUES     
               MOVE SPACES             TO P-DEPOSIT-DATE                
           ELSE                                                         
               MOVE E-FRP827-DATE-DEPOSIT-RECD                          
                                       TO WS-DATE-10                    
               MOVE WS-D10-DD          TO WS-PR-DD                      
               MOVE WS-D10-MM          TO WS-PR-MM                      
               MOVE WS-D10-CC          TO WS-PR-CC                      
               MOVE WS-D10-YY          TO WS-PR-YY                      
               MOVE WS-PRINT-DATE      TO P-DEPOSIT-DATE                
           END-IF.                                                      
      *                                                                         
           PERFORM 2310-ADD-DETAIL               THRU 2310-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    2310-ADD-DETAIL                                         **          
      **                                                            **          
      ****************************************************************          
       2310-ADD-DETAIL.                                                 
      *                                                                         
           ADD 1                     TO WS-AC-TOTAL-COUNT               
                                        WS-CO-TOTAL-COUNT               
                                        WS-GR-TOTAL-COUNT.              
           ADD E-FRP827-LIABLE-AMT   TO WS-AC-TOTAL-DEPOSIT             
                                        WS-CO-TOTAL-DEPOSIT             
                                        WS-GR-TOTAL-DEPOSIT.            
           ADD E-FRP827-AMT-INTEREST TO WS-AC-TOTAL-INTEREST            
                                        WS-CO-TOTAL-INTEREST            
                                        WS-GR-TOTAL-INTEREST.           
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    2500-FORMAT-COMPANY-TOTAL                               **          
      **         TOTAL LINE VALUE WILL BE MOVED FOR COMPANY         **          
      **                                                            **          
      ****************************************************************          
       2500-FORMAT-COMPANY-TOTAL.                                       
      *                                                                         
           MOVE WS-CO-TOTAL-COUNT    TO P-TOT-TOTAL-COUNT.              
           MOVE WS-CO-TOTAL-NO-CUSTS TO P-TOT-NO-CUSTS.                 
           MOVE C7-COMPANY-NAME      TO P-TOT-LINE-WHAT.                
           MOVE WS-CO-TOTAL-DEPOSIT  TO P-TOT-DEPOSIT-AMT.              
           MOVE WS-CO-TOTAL-INTEREST TO P-TOT-INTEREST-AMT.             
           ADD  WS-CO-TOTAL-NO-CUSTS TO WS-GR-TOTAL-NO-CUSTS.           
           MOVE 0                    TO WS-CO-TOTAL-COUNT               
                                        WS-CO-TOTAL-NO-CUSTS            
                                        WS-CO-TOTAL-DEPOSIT             
                                        WS-CO-TOTAL-INTEREST            
                                        WS-RPT1-PAGE-NO.                
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    2510-FORMAT-GRAND-TOTAL                                 **          
      **         TOTAL LINE VALUE WILL BE MOVED FOR SCANA CORP.     **          
      **                                                            **          
      ****************************************************************          
       2510-FORMAT-GRAND-TOTAL.                                         
      *                                                                         
           MOVE WS-GR-TOTAL-COUNT    TO P-TOT-TOTAL-COUNT.              
           MOVE WS-GR-TOTAL-NO-CUSTS TO P-TOT-NO-CUSTS.                 
           MOVE C7-COMPANY-NAME      TO P-TOT-LINE-WHAT.                
           MOVE WS-GR-TOTAL-DEPOSIT  TO P-TOT-DEPOSIT-AMT.              
           MOVE WS-GR-TOTAL-INTEREST TO P-TOT-INTEREST-AMT.             
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    2520-FORMAT-REV-CLASS-TOT                               **          
      **         TOTAL LINE VALUE WILL BE MOVED FOR REVENUE CLASS   **          
      **                                                            **          
      ****************************************************************          
       2520-FORMAT-REV-CLASS-TOT.                                       
      *                                                                         
           MOVE WS-AC-TOTAL-COUNT    TO P-TOT-TOTAL-COUNT.              
           MOVE WS-AC-TOTAL-NO-CUSTS TO P-TOT-NO-CUSTS.                 
           MOVE P-RPT1-REV-CLASS     TO P-TOT-LINE-WHAT.                
           MOVE WS-AC-TOTAL-DEPOSIT  TO P-TOT-DEPOSIT-AMT.              
           MOVE WS-AC-TOTAL-INTEREST TO P-TOT-INTEREST-AMT.             
           ADD  WS-AC-TOTAL-NO-CUSTS TO WS-CO-TOTAL-NO-CUSTS.           
           MOVE 0                    TO WS-AC-TOTAL-COUNT               
                                        WS-AC-TOTAL-NO-CUSTS            
                                        WS-AC-TOTAL-DEPOSIT             
                                        WS-AC-TOTAL-INTEREST.           
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP827                                       **          
      **       READ THE INPUT FILE FCSRP827                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP827.                                              
      *                                                                         
           READ FCSRP827-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP827-SUCCESSFUL                                         
               ADD 1                   TO WS-FRP827-REC-CNTR            
           ELSE                                                         
               DISPLAY '**   7100-ERROR ON FCSRP827 READ   **'          
               DISPLAY '**   STATUS IS ' WS-FRP827-STATUS               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           IF WS-CURRENT-REG-GRP NOT = '0'                              
               MOVE 'SCANA ENERGY REGULATED DIVISION'                   
                                                 TO P-RPT1-COMP-NAME    
                                                    C7-COMPANY-NAME     
               GO TO 7800-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   COMPANY_NAME                                    
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY                                         
               WHERE    COMPANY_NO = :C7-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '**         RETURN CODE = ' SQLCODE          
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           MOVE WS-CURRENT-COMP-NO                                      
                                       TO C7-COMPANY-NO,                
                                          WS-HEADER-COMP-NO             
           PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT.                
      *                                                                         
           MOVE '1'              TO P-RPT1-TITLE-RPTN.                  
           MOVE  WS-RPT1-TITLE   TO PRT33-DATA.                         
A05136     MOVE  PRT33-RECORD    TO PRT33-RECORD.                       
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8110-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8110-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT2-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           MOVE WS-CURRENT-COMP-NO                                      
                                       TO C7-COMPANY-NO,                
                                          WS-HEADER-COMP-NO             
           PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT.                
      *                                                                         
           MOVE '2'              TO P-RPT1-TITLE-RPTN.                  
           MOVE  WS-RPT1-TITLE   TO PRT33-DATA.                         
A05136     MOVE  PRT33-RECORD    TO PRT331-RECORD.                      
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           MOVE  WS-RPT1-HEADER-1   TO  PRT33-DATA                      
A05136     MOVE  PRT33-RECORD       TO PRT33-RECORD.                    
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE ' DETAIL'              TO WS-DEFAULT-RPT1-TITLE2-TP.    
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           MOVE  WS-RPT1-HEADER-2      TO  PRT33-DATA                   
A05136     MOVE  PRT33-RECORD          TO PRT33-RECORD.                 
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE3 TO P-RPT1-HEAD3.                 
           MOVE  WS-RPT1-HEADER-3      TO  PRT33-DATA                   
A05136     MOVE  PRT33-RECORD          TO PRT33-RECORD.                 
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 4                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8210-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8210-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           MOVE  WS-RPT1-HEADER-1   TO  PRT33-DATA                      
A05136     MOVE  PRT33-RECORD       TO PRT331-RECORD.                   
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 'SUMMARY'              TO WS-DEFAULT-RPT1-TITLE2-TP.    
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT2-PAGE-NO        TO P-RPT1-PAGE-NO.               
           MOVE  WS-RPT1-HEADER-2      TO PRT33-DATA                    
A05136     MOVE  PRT33-RECORD          TO PRT331-RECORD.                
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE3 TO P-RPT1-HEAD3.                 
           MOVE  WS-RPT1-HEADER-3      TO PRT33-DATA                    
A05136     MOVE  PRT33-RECORD          TO PRT331-RECORD.                
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 4                      TO WS-RPT2-LINE-NO.              
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8250-PRINT-REV-CLASS                                     **          
      **       PRINTS THE REVENUE CLASS HEADER ON THE REPORT        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8250-PRINT-REV-CLASS.                                            
      *                                                                         
           EVALUATE WS-CURRENT-REV-CLASS                                
              WHEN '1'                                                  
                MOVE 'RESIDENTIAL  '           TO P-RPT1-REV-CLASS      
              WHEN '2'                                                  
                MOVE 'COMMERCIAL   '           TO P-RPT1-REV-CLASS      
              WHEN '3'                                                  
                MOVE 'INDUSTRIAL   '           TO P-RPT1-REV-CLASS      
              WHEN '6'                                                  
                MOVE 'PUBLIC/ST LGT'           TO P-RPT1-REV-CLASS      
              WHEN '7'                                                  
                MOVE 'PUBLIC/ST LGT'           TO P-RPT1-REV-CLASS      
              WHEN '8'                                                  
                MOVE 'COMMERCIAL   '           TO P-RPT1-REV-CLASS      
              WHEN '9'                                                  
                MOVE 'WHOLESALE    '           TO P-RPT1-REV-CLASS      
              WHEN OTHER                                                
                MOVE 'OTHER        '           TO P-RPT1-REV-CLASS      
           END-EVALUATE.                                                
      *                                                                         
           MOVE  WS-RPT1-HEADER-4    TO PRT33-DATA                      
A05136     MOVE  PRT33-RECORD        TO PRT33-RECORD.                   
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
           MOVE  WS-RPT1-HEADER-32  TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT33-RECORD.                    
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
           MOVE WS-LINE       TO  PRT33-DATA.                           
A05136     MOVE  PRT33-RECORD TO PRT33-RECORD.                          
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 6                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8305-PRINT-HEADER5                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8305-PRINT-HEADER5.                                              
      *                                                                         
           IF WS-CURRENT-COMP-NO = '01'                                 
               IF WS-CURR-DATE-DEP-SORT = '1'                           
               MOVE 'DEPOSITS SEVEN MONTHS OR GREATER' TO P-RPT1-HEAD5  
               ELSE                                                     
               MOVE 'DEPOSITS LESS THAN SEVEN MONTHS ' TO P-RPT1-HEAD5  
               END-IF                                                   
           ELSE                                                         
               IF WS-CURR-DATE-DEP-SORT = '1'                           
               MOVE 'DEPOSITS FOUR MONTHS OR GREATER ' TO P-RPT1-HEAD5  
               ELSE                                                     
               MOVE 'DEPOSITS LESS THAN FOUR MONTHS  ' TO P-RPT1-HEAD5  
               END-IF                                                   
           END-IF.                                                      
           MOVE  WS-RPT1-HEADER-5   TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT33-RECORD.                    
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 2 LINES.                                
           MOVE  WS-BLANK-LINE      TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT33-RECORD.                    
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINES.                                
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8305-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8310-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8310-PRINT-HEADERS.                                              
      *                                                                         
           MOVE  WS-RPT1-HEADER-32  TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT331-RECORD.                   
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 3 LINES.                                
           MOVE WS-LINE       TO  PRT33-DATA.                           
A05136     MOVE  PRT33-RECORD TO PRT331-RECORD.                         
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 6                       TO WS-RPT2-LINE-NO.              
      *                                                                         
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8315-PRINT-HEADER5                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8315-PRINT-HEADER5.                                              
      *                                                                         
           IF WS-CURRENT-COMP-NO = '01'                                 
               IF WS-CURR-DATE-DEP-SORT = '1'                           
               MOVE 'DEPOSITS SEVEN MONTHS OR GREATER' TO P-RPT1-HEAD5  
               ELSE                                                     
               MOVE 'DEPOSITS LESS THAN SEVEN MONTHS ' TO P-RPT1-HEAD5  
               END-IF                                                   
           ELSE                                                         
               IF WS-CURR-DATE-DEP-SORT = '1'                           
               MOVE 'DEPOSITS FOUR MONTHS OR GREATER ' TO P-RPT1-HEAD5  
               ELSE                                                     
               MOVE 'DEPOSITS LESS THAN FOUR MONTHS  ' TO P-RPT1-HEAD5  
               END-IF                                                   
           END-IF.                                                      
           MOVE  WS-RPT1-HEADER-5   TO PRT33-DATA.                      
A05136     MOVE  PRT33-RECORD       TO PRT331-RECORD.                   
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 2 LINES.                                
      *                                                                         
           ADD 2                       TO WS-RPT2-LINE-NO.              
      *                                                                         
       8315-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8420-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE TOTAL LINES FOR THE COMPANY               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8420-PRINT-TOTAL-LINE.                                           
      *                                                                         
           MOVE  SPACES            TO P-TOT-FILLER2.                    
           MOVE  WS-TOTAL-LINE-1A  TO PRT33-DATA.                       
A05136     MOVE  PRT33-RECORD      TO PRT33-RECORD.                     
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
           MOVE  '  VARIOUS '      TO P-TOT-FILLER2.                    
           MOVE  WS-TOTAL-LINE-1A  TO PRT33-DATA.                       
A05136     MOVE  PRT33-RECORD      TO PRT331-RECORD.                    
A05136     WRITE PRT331-RECORD                                          
                AFTER ADVANCING 3 LINES.                                
      *                                                                         
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP827        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           MOVE  WS-DETAIL-LINE-1  TO PRT33-DATA.                       
A05136     MOVE  PRT33-RECORD      TO PRT33-RECORD.                     
A05136     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 1 TO WS-RPT1-LINE-NO.                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSE ALL OPEN FILES AND CHECK FOR ERROR             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP827-FILE.                                         
           IF FRP827-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP827 PROCESSING ERROR        **'   
               DISPLAY '**  CLOSE ERROR FOR FCSRP827 - INPUT FILE **'   
               DISPLAY '**       STATUS IS ' WS-FRP827-STATUS           
           END-IF.                                                      
      *                                                                         
A05136     CLOSE FCSPT33-FILE.                                          
A05136     CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    9900-ABEND    DB2 SQL ABEND MODULE                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
