       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP808.                                            
       DATE-WRITTEN. SEPTEMBER 2004.                                    
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *      PROGRAM MODIFICATION LOG                                  *        
      *                                                                *        
      *     DATE     USER ID  REASON                                   *        
      *   --------   -------  ---------------------------------------- *        
      *   09/16/04   KR19687  INITIAL CODING - PRODUCES THE BEHAVIOR   *        
      *                       SCORE RATING REPORT BY AGING BUCKET.     *        
      *                       THIS PROGRAM USES THE OUTPUT FILE        *        
      *                       FIOCA801 FROM SEBC801 AND SORTS BY       *        
      *                       MODEL ID, RATING & BILL CYCLE.           *        
T35434*   06/14/07   SP94986  REPLACED MODEL_SQL TO SET STMTS AND TO   *        
T35434*                       AVOID 911S ADDED WITH UR CHANGES TO CURSO*        
T35434*                       -RS AND FOR SINGLETON SELECT STATS.      *        
      *                                                                *        
A05154* 15 JAN 2015  RF10596  CLEAN UP PROGRAM                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FIOCA808-FILE   ASSIGN TO UT-S-FIOCA808               
               FILE STATUS IS WS-F808-STATUS.                           
           SELECT PRNTFILE ASSIGN TO UT-S-PRNTFILE.                     
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FIOCA808-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY FIOCA801.                                                           
      *                                                                         
       FD PRNTFILE                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01 PRNTFILE-RECORD.                                              
          05 PRNTFILE-CC              PIC X(01).                        
          05 PRNTFILE-DATA            PIC X(132).                       
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP808'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP808 STARTS HERE'.                  
      *                                                                         
       01 COMP-CODE                      PIC S9(4) COMP VALUE +0.       
      *                                                                         
       01 WORK-AREAS.                                                   
          05 WS-EOF-SW                     PIC X(01) VALUE SPACES.      
             88  END-OF-FILE                         VALUE 'Y'.         
          05 WS-RISK-SW                    PIC X(01) VALUE 'N'.         
             88  NO-RISK                             VALUE 'Y'.         
          05 WS-F808-STATUS                PIC X(02) VALUE '  '.        
             88 F808-SUCCESSFUL                      VALUE '00'.        
             88 F808-READ-OK                         VALUE '00' '04'.   
             88 END-OF-FCA808                     VALUE '10'.           
          05 SQL-ERROR-SW                PIC 9(01) VALUE 0.             
             88 SQL-ERROR                          VALUE 1.             
          05 WS-ACCT-EOF-SW              PIC 9(01) VALUE 0.             
             88 END-OF-ACCT                        VALUE 1.             
          05 WS-BHV-MODEL-STYLE          PIC X(01) VALUE SPACES.        
             88 MATRIX-MODEL                       VALUE 'M'.           
             88 WEIGHTAGE-MODEL                    VALUE 'W'.           
          05 WS-BILL-CYCLE-N             PIC 9(02).                     
          05 WS-BILL-CYCLE-N2            PIC 9(02).                     
COB305    05 WS-CURRENT-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-30-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-60-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-90-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-RISK-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-TOTAL-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-SEC-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-CURRENT-AMOUNT-TOT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-30-DAY-AMOUNT-TOT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-60-DAY-AMOUNT-TOT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-90-DAY-AMOUNT-TOT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-SEC-AMOUNT-TOT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-RISK-AMOUNT-TOT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-TOTAL-AMOUNT-TOT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-CURRENT-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-30-DAY-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-60-DAY-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-90-DAY-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-SEC-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-RISK-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-TOTAL-AMOUNT-MODEL        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-CURRENT-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-30-DAY-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-60-DAY-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-90-DAY-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-SEC-AMOUNT-COMP        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 WS-RISK-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-TOTAL-AMOUNT-COMP        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-00-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-30-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-60-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-90-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-RISK-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-TOTAL-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-SEC-COUNT-TOT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-00-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-30-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-60-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-90-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-RISK-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-TOTAL-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-SEC-COUNT-COMP        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-00-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-30-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-60-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-90-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-RISK-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-TOTAL-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-SEC-COUNT-MODEL        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-30-DAY-PERC        PIC S999V99 COMP-3 VALUE 0.        
COB305    05 WS-60-DAY-PERC        PIC S999V99 COMP-3 VALUE 0.        
COB305    05 WS-90-DAY-PERC        PIC S999V99 COMP-3 VALUE 0.        
COB305    05 WS-RISK-PERC        PIC S999V99 COMP-3 VALUE 0.        
COB305    05 WS-SEC-PERC        PIC S999V99 COMP-3 VALUE 0.        
COB305    05 WS-00-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-SEC-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 ADD-SECURITY-AMOUNT        PIC S999999999V99 COMP-3 
COB305       VALUE 0.     
COB305    05 WS-SECURITY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
          05 WS-SEB-BREAK                PIC X VALUE 'N'.               
COB305    05 WS-30-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-60-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-90-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-RISK-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 WS-TOTAL-COUNT        PIC S999999 COMP-3 VALUE 0.        
COB305    05 ADD-CURRENT-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 ADD-30-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 ADD-60-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
COB305    05 ADD-90-DAY-AMOUNT        PIC S999999999V99 COMP-3 VALUE 0.     
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-RPT1-PAGE-NO             PIC 9(04) VALUE ZERO.          
          05 WS-PROGRAM                  PIC X(08) VALUE 'PCSRP808'.    
          05 WS-PREV-BHV-MODEL-ID        PIC X(04) VALUE SPACES.        
          05 WS-PREV-BHV-SCORE-RATING    PIC X(01) VALUE SPACES.        
          05 WS-ACCOUNT-NO               PIC 9(13).                     
COB305    05 WS-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.           
          05 WS-LST-PYMT-DT              PIC X(10) VALUE SPACES.        
COB305    05 WS-LST-PYMT-AMT        PIC S9(09)V9(02) COMP-3 VALUE 0.      
          05 WS-COLL-AGY                 PIC X(03) VALUE SPACES.        
COB305    05 WS-ORIG-AMT        PIC S9(07)V9(02) COMP-3 VALUE 0.      
          05 WS-CURRENT-DT               PIC X(10) VALUE SPACES.        
          05 WS-CURR-DT                  PIC X(10) VALUE SPACES.        
          05 WS-HOLD-DT.                                                
             10 WS-HOLD-YR               PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-MO               PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-DY               PIC X(02) VALUE SPACES.        
          05 WS-HOLD-LST-PYMT-DT.                                       
             10 WS-HOLD-LST-YR           PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-LST-MO           PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-LST-DY           PIC X(02) VALUE SPACES.        
          05 WS-COMPANY-NAME             PIC X(26) VALUE SPACES.        
          05 WS-CURRENT-TIMESTAMP        PIC X(26).                     
          05 FILLER REDEFINES WS-CURRENT-TIMESTAMP.                     
             10 WS-PROGRAM-RUN-YYYY      PIC X(04).                     
             10 FILLER                   PIC X(01).                     
             10 WS-PROGRAM-RUN-MM        PIC X(02).                     
             10 FILLER                   PIC X(01).                     
             10 WS-PROGRAM-RUN-DD        PIC X(02).                     
             10 FILLER                   PIC X(01).                     
             10 WS-PROGRAM-RUN-TIME      PIC X(08).                     
             10 FILLER                   PIC X(07).                     
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
      *                                                                         
       01 WS-PRINTER-CONTROL.                                           
          05 WS-RPT1-LINE-NO             PIC 9(02) VALUE ZERO.          
          05 WS-52                       PIC 9(02) VALUE 52.            
      *                                                                         
       01 WS-HEADER-1.                                                  
          05 FILLER                      PIC X(17) VALUE                
             'PCSRP808-PCSR8081'.                                       
          05 FILLER                      PIC X(35) VALUE SPACES.        
          05 WS-RPRT-COMPANY             PIC X(41) VALUE SPACES.        
          05 FILLER                      PIC X(18) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE 'RUN DATE:'.   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RPRT-MM                  PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-DD                  PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-YYYY                PIC X(04) VALUE SPACES.        
      *                                                                         
       01 WS-HEADER-2.                                                  
          05 FILLER                      PIC X(06) VALUE 'DATE: '.      
          05 WS-RPRT-MM-H2               PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-DD-H2               PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-YYYY-H2             PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(30) VALUE SPACES.        
          05 FILLER                      PIC X(45) VALUE                
             'BEHAVIOR SCORE RATING REPORT BY AGING BUCKET'.            
          05 FILLER                      PIC X(20) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE 'RUN TIME:'.   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RPRT-TIME                PIC X(08) VALUE SPACES.        
      *                                                                         
       01 WS-HEADER-3.                                                  
          05 FILLER                      PIC X(62) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AS OF '.      
          05 WS-RPRT-MONTH               PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-DAY                 PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-YR                  PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(37) VALUE SPACES.        
          05 FILLER                      PIC X(05) VALUE 'PAGE:'.       
          05 FILLER                      PIC X(08) VALUE SPACES.        
          05 WS-RPRT-PAGE-NO             PIC ZZZ9.                      
      *                                                                         
       01 WS-MODEL-ID-HEADER.                                           
          05 FILLER                      PIC X(09) VALUE                
             'MODEL:   '.                                               
          05 WS-BHV-MODEL-ID             PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(03) VALUE ' - '.         
          05 WS-BHV-MODEL-DESC           PIC X(25) VALUE SPACES.        
          05 FILLER                      PIC X(91) VALUE SPACES.        
      *                                                                         
       01 WS-SCORE-RATING-HEADER.                                       
          05 FILLER                      PIC X(12) VALUE                
             'RATING:     '.                                            
          05 WS-BHV-SCORE-RATING         PIC X(01) VALUE SPACES.        
          05 WS-SEPARATOR                PIC X(03) VALUE ' - '.         
          05 WS-BHV-SCORE-MIN            PIC X(06) VALUE SPACES.        
          05 WS-BHV-SCORE-DASH           PIC X(03) VALUE ' - '.         
          05 WS-BHV-SCORE-MAX            PIC X(06) VALUE SPACES.        
          05 FILLER                      PIC X(91) VALUE SPACES.        
      *                                                                         
       01 WS-HEADER-4.                                                  
          05 FILLER                      PIC X(09) VALUE SPACES.        
          05 FILLER                      PIC X(08) VALUE '0-DAY NO'.    
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE '30-DAY NO'.   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(08) VALUE '30-DAY %'.    
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE '60-DAY NO'.   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(08) VALUE '60-DAY %'.    
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE '90-DAY NO'.   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(08) VALUE '90-DAY %'.    
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(11) VALUE 'SECURITY NO'. 
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(10) VALUE 'SECURITY %'.  
          05 FILLER                      PIC X(01) VALUE SPACES.        
          05 FILLER                      PIC X(07) VALUE 'RISK NO'.     
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(11) VALUE 'TTL BILL NO'. 
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(04) VALUE '% AT'.        
      *                                                                         
       01 WS-HEADER-5.                                                  
          05 FILLER                      PIC X(01) VALUE SPACES.        
          05 FILLER                      PIC X(05) VALUE 'CYCLE'.       
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'CY TTL'.      
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'CY TTL'.      
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'CY TTL'.      
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'CY TTL'.      
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 FILLER                      PIC X(06) VALUE 'AMOUNT'.      
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 FILLER                      PIC X(04) VALUE 'RISK'.        
      *                                                                         
       01 WS-DETAIL-1.                                                  
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-BILL-CYCLE               PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(4) VALUE SPACES.         
          05 WS-00-COUNT-Z               PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-COUNT-Z               PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-PERC-Z                PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-60-COUNT-Z               PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-60-PERC-Z                PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-90-COUNT-Z               PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-90-PERC-Z                PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-SEC-COUNT-Z              PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-SEC-PERC-Z               PIC ZZ9.99.                    
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RISK-COUNT-Z             PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-TOTAL-COUNT-Z            PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RISK-PERC-Z              PIC ZZ9.99.                    
      *                                                                         
       01 WS-DETAIL-2.                                                  
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-CURRENT-AMOUNT-Z         PIC ZZZ,ZZZ,ZZ9.               
          05 WS-30-DAY-AMOUNT-Z          PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(11) VALUE SPACES.        
          05 WS-60-DAY-AMOUNT-Z          PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-90-DAY-AMOUNT-Z          PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-SEC-AMOUNT-Z             PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(12) VALUE SPACES.        
          05 WS-RISK-AMOUNT-Z            PIC ZZZ,ZZZ,ZZ9.               
          05 WS-TOTAL-AMOUNT-Z           PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(09) VALUE SPACES.        
      *                                                                         
       01 WS-FOOTER-1.                                                  
          05 FILLER                      PIC X(06) VALUE 'RATING'.      
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-00-COUNT-TOT-Z           PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-COUNT-TOT-Z           PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-PERC-TOT-Z            PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-60-COUNT-TOT-Z           PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-60-PERC-TOT-Z            PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-90-COUNT-TOT-Z           PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-90-PERC-TOT-Z            PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-SEC-COUNT-TOT-Z          PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-SEC-PERC-TOT-Z           PIC ZZ9.99.                    
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RISK-COUNT-TOT-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-TOTAL-COUNT-TOT-Z        PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RISK-PERC-TOT-Z          PIC ZZ9.99.                    
      *                                                                         
       01 WS-FOOTER-2.                                                  
          05 FILLER                      PIC X(04) VALUE 'TOTL'.        
          05 WS-CURRENT-AMOUNT-TOT-Z     PIC ZZZ,ZZZ,ZZ9.               
          05 WS-30-DAY-AMOUNT-TOT-Z      PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(11) VALUE SPACES.        
          05 WS-60-DAY-AMOUNT-TOT-Z      PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-90-DAY-AMOUNT-TOT-Z      PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-SEC-AMOUNT-TOT-Z         PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(12) VALUE SPACES.        
          05 WS-RISK-AMOUNT-TOT-Z        PIC ZZZ,ZZZ,ZZ9.               
          05 WS-TOTAL-AMOUNT-TOT-Z       PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(05) VALUE SPACES.        
      *                                                                         
       01 WS-FOOTER1-MODEL.                                             
          05 FILLER                      PIC X(07) VALUE 'MODEL  '.     
          05 FILLER                      PIC X(1) VALUE SPACES.         
          05 WS-00-COUNT-MODEL-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-COUNT-MODEL-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-PERC-MODEL-Z          PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-60-COUNT-MODEL-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-60-PERC-MODEL-Z          PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-90-COUNT-MODEL-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-90-PERC-MODEL-Z          PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-SEC-COUNT-MODEL-Z        PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-SEC-PERC-MODEL-Z         PIC ZZ9.99.                    
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RISK-COUNT-MODEL-Z       PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-TOTAL-COUNT-MODEL-Z      PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RISK-PERC-MODEL-Z        PIC ZZ9.99.                    
      *                                                                         
       01 WS-FOOTER2-MODEL.                                             
          05 FILLER                      PIC X(04) VALUE 'TOTL'.        
          05 WS-CURRENT-AMOUNT-MODEL-Z   PIC ZZZ,ZZZ,ZZ9.               
          05 WS-30-DAY-AMOUNT-MODEL-Z    PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(11) VALUE SPACES.        
          05 WS-60-DAY-AMOUNT-MODEL-Z    PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-90-DAY-AMOUNT-MODEL-Z    PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-SEC-AMOUNT-MODEL-Z       PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(12) VALUE SPACES.        
          05 WS-RISK-AMOUNT-MODEL-Z      PIC ZZZ,ZZZ,ZZ9.               
          05 WS-TOTAL-AMOUNT-MODEL-Z     PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(05) VALUE SPACES.        
      *                                                                         
       01 WS-FOOTER1-COMP.                                              
          05 FILLER                      PIC X(07) VALUE 'COMPANY'.     
          05 FILLER                      PIC X(1) VALUE SPACES.         
          05 WS-00-COUNT-COMP-Z          PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-COUNT-COMP-Z          PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-30-PERC-COMP-Z           PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-60-COUNT-COMP-Z          PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-60-PERC-COMP-Z           PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-90-COUNT-COMP-Z          PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-90-PERC-COMP-Z           PIC ZZ9.99.                    
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-SEC-COUNT-COMP-Z         PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-SEC-PERC-COMP-Z          PIC ZZ9.99.                    
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RISK-COUNT-COMP-Z        PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-TOTAL-COUNT-COMP-Z       PIC ZZZ,ZZ9.                   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RISK-PERC-COMP-Z         PIC ZZ9.99.                    
      *                                                                         
       01 WS-FOOTER2-COMP.                                              
          05 FILLER                      PIC X(04) VALUE 'TOTL'.        
          05 WS-CURRENT-AMOUNT-COMP-Z    PIC ZZZ,ZZZ,ZZ9.               
          05 WS-30-DAY-AMOUNT-COMP-Z     PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(11) VALUE SPACES.        
          05 WS-60-DAY-AMOUNT-COMP-Z     PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-90-DAY-AMOUNT-COMP-Z     PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-SEC-AMOUNT-COMP-Z        PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(12) VALUE SPACES.        
          05 WS-RISK-AMOUNT-COMP-Z       PIC ZZZ,ZZZ,ZZ9.               
          05 WS-TOTAL-AMOUNT-COMP-Z      PIC ZZZ,ZZZ,ZZ9.               
          05 FILLER                      PIC X(05) VALUE SPACES.        
      *                                                                         
       01 WS-NO-DATA-LINE.                                              
          05  FILLER                     PIC X(55) VALUE SPACES.        
          05  FILLER                     PIC X(22) VALUE                
                    '** NO DATA THIS RUN **'.                           
          05  FILLER                     PIC X(55) VALUE SPACES.        
      *                                                                         
       01 WS-END-DATA-LINE.                                             
          05  FILLER                     PIC X(55) VALUE SPACES.        
          05  FILLER                     PIC X(22) VALUE                
                    '*** END OF REPORT ***'.                            
          05  FILLER                     PIC X(55) VALUE SPACES.        
      *                                                                         
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PCSRP808 ENDS HERE'.                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      * CSS_JOB_PARM TABLE                                                      
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_DELINQUENCY TABLE                                                   
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
       LINKAGE SECTION.                                                 
       01 WS-PARM-VALUE.                                                
          05 WS-PARMVAL-LENGTH           PIC S9(04) COMP.               
          05 WS-PARM-COMPANY             PIC X(02).                     
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ******************************************************************        
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE.                                     
      *                                                                         
           MOVE WS-CURRENT-DT              TO WS-HOLD-DT.               
           MOVE WS-HOLD-MO                 TO WS-RPRT-MONTH.            
           MOVE WS-HOLD-DY                 TO WS-RPRT-DAY.              
           MOVE WS-HOLD-YR                 TO WS-RPRT-YR.               
           MOVE WS-52                      TO WS-RPT1-LINE-NO.          
      *                                                                         
           PERFORM 0020-READ-FCSCA808 THRU 0020-EXIT.                   
           MOVE E-FCA801-BHV-MODEL-ID TO WS-PREV-BHV-MODEL-ID.          
           PERFORM 0300-CNVT-BILL-CYCLE THRU 0300-EXIT.                 
           IF END-OF-FCA808                                             
              PERFORM 8000-PRINT-HEADER    THRU 8000-EXIT               
              MOVE SPACES                  TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
              MOVE WS-NO-DATA-LINE         TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL END-OF-FCA808                                  
              IF WS-BILL-CYCLE-N NOT EQUAL WS-BILL-CYCLE-N2             
                 PERFORM UNTIL WS-BILL-CYCLE-N EQUAL                    
                               WS-BILL-CYCLE-N2                         
                    PERFORM 0400-CNVT-BACK-CYCLE THRU 0400-EXIT         
                    PERFORM 8500-PRINT-DETAIL    THRU 8500-EXIT         
                    ADD 1 TO WS-BILL-CYCLE-N                            
                 END-PERFORM                                            
              END-IF                                                    
              PERFORM 2000-PROCESS-ACCT    THRU 2000-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-END-DATA-LINE           TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0020-READ-FCSCA808.                                              
      *                                                                         
           READ FIOCA808-FILE AT END                                    
               GO TO 0020-EXIT.                                         
      *                                                                         
           IF F808-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 0020-READ-FCSCA808             '             
               DISPLAY '** ERROR READING FCA808'                        
               DISPLAY '** FILE STATUS = ' WS-F808-STATUS               
               DISPLAY '******************************************'     
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
                                                                        
       0020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *      OPEN OUTPUT FILE PRNTFILE.                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
           MOVE 0                          TO WS-ACCT-EOF-SW.           
A05154     MOVE ZEROES                     TO ADD-CURRENT-AMOUNT        
                                              ADD-30-DAY-AMOUNT         
                                              ADD-60-DAY-AMOUNT         
                                              ADD-90-DAY-AMOUNT         
                                              WS-CURRENT-AMOUNT         
                                              WS-30-DAY-AMOUNT          
                                              WS-60-DAY-AMOUNT          
                                              WS-90-DAY-AMOUNT          
                                              WS-TOTAL-AMOUNT           
                                              WS-RISK-AMOUNT            
                                              WS-30-COUNT               
                                              WS-60-COUNT               
                                              WS-90-COUNT               
                                              WS-TOTAL-COUNT            
                                              WS-RISK-COUNT             
                                              WS-00-COUNT               
                                              WS-SEC-AMOUNT             
                                              WS-CURRENT-AMOUNT-TOT     
                                              WS-30-DAY-AMOUNT-TOT      
                                              WS-60-DAY-AMOUNT-TOT      
                                              WS-90-DAY-AMOUNT-TOT      
                                              WS-RISK-AMOUNT-TOT        
                                              WS-SEC-AMOUNT-TOT         
                                              WS-TOTAL-AMOUNT-TOT       
                                              WS-CURRENT-AMOUNT-MODEL   
                                              WS-30-DAY-AMOUNT-MODEL    
                                              WS-60-DAY-AMOUNT-MODEL    
                                              WS-90-DAY-AMOUNT-MODEL    
                                              WS-SEC-AMOUNT-MODEL       
                                              WS-RISK-AMOUNT-MODEL      
                                              WS-TOTAL-AMOUNT-MODEL     
                                              WS-CURRENT-AMOUNT-COMP    
                                              WS-30-DAY-AMOUNT-COMP     
                                              WS-60-DAY-AMOUNT-COMP     
                                              WS-90-DAY-AMOUNT-COMP     
                                              WS-SEC-AMOUNT-COMP        
                                              WS-RISK-AMOUNT-COMP       
                                              WS-TOTAL-AMOUNT-COMP      
                                              WS-00-COUNT-TOT           
                                              WS-30-COUNT-TOT           
                                              WS-60-COUNT-TOT           
                                              WS-90-COUNT-TOT           
                                              WS-RISK-COUNT-TOT         
                                              WS-TOTAL-COUNT-TOT        
                                              WS-SEC-COUNT              
                                              WS-SEC-COUNT-TOT          
                                              WS-00-COUNT-MODEL         
                                              WS-30-COUNT-MODEL         
                                              WS-60-COUNT-MODEL         
                                              WS-90-COUNT-MODEL         
                                              WS-RISK-COUNT-MODEL       
                                              WS-TOTAL-COUNT-MODEL      
                                              WS-SEC-COUNT-MODEL        
                                              WS-00-COUNT-COMP          
                                              WS-30-COUNT-COMP          
                                              WS-60-COUNT-COMP          
                                              WS-90-COUNT-COMP          
                                              WS-RISK-COUNT-COMP        
                                              WS-TOTAL-COUNT-COMP       
                                              WS-SEC-COUNT-COMP         
                                              WS-30-DAY-PERC            
                                              WS-60-DAY-PERC            
                                              WS-90-DAY-PERC            
                                              WS-RISK-PERC              
                                              WS-SEC-PERC               
                                              WS-SECURITY-AMOUNT        
                                              ADD-SECURITY-AMOUNT.      
           MOVE 1                          TO WS-BILL-CYCLE-N           
                                              WS-BILL-CYCLE-N2.         
           OPEN INPUT  FIOCA808-FILE.                                   
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                         
           PERFORM 0110-GET-CURR-DATE      THRU 0110-EXIT.              
           PERFORM 0120-GET-COMPANY        THRU 0120-EXIT.              
           MOVE WS-COMPANY-NAME            TO WS-RPRT-COMPANY.          
           PERFORM 0130-GET-TIMESTAMP      THRU 0130-EXIT.              
           MOVE WS-PROGRAM-RUN-YYYY        TO WS-RPRT-YYYY              
                                              WS-RPRT-YYYY-H2.          
           MOVE WS-PROGRAM-RUN-MM          TO WS-RPRT-MM                
                                              WS-RPRT-MM-H2.            
           MOVE WS-PROGRAM-RUN-DD          TO WS-RPRT-DD                
                                              WS-RPRT-DD-H2.            
           MOVE WS-PROGRAM-RUN-TIME        TO WS-RPRT-TIME.             
           MOVE ':'                        TO WS-RPRT-TIME(3:1)         
                                              WS-RPRT-TIME(6:1).        
           MOVE '01'                     TO C8-COMPANY-NO.              
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           PERFORM 7500-GET-DATABASE     THRU 7500-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0101-RE-INITIALIZE.                                              
           MOVE ZEROES                     TO WS-CURRENT-AMOUNT         
                                              WS-30-DAY-AMOUNT          
                                              WS-60-DAY-AMOUNT          
                                              WS-90-DAY-AMOUNT          
                                              ADD-CURRENT-AMOUNT        
                                              ADD-30-DAY-AMOUNT         
                                              ADD-60-DAY-AMOUNT         
                                              ADD-90-DAY-AMOUNT         
                                              WS-TOTAL-AMOUNT           
                                              WS-RISK-AMOUNT            
                                              WS-30-COUNT               
                                              WS-60-COUNT               
                                              WS-90-COUNT               
                                              WS-TOTAL-COUNT            
                                              WS-RISK-COUNT             
                                              WS-00-COUNT               
                                              WS-SEC-COUNT              
                                              WS-30-DAY-PERC            
                                              WS-60-DAY-PERC            
                                              WS-90-DAY-PERC            
                                              WS-RISK-PERC              
                                              WS-SEC-PERC               
                                              WS-SEC-AMOUNT             
                                              WS-SECURITY-AMOUNT        
                                              ADD-SECURITY-AMOUNT.      
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *       0110-GET-CURR-DATE.                                      *        
      *                                                                *        
      ******************************************************************        
       0110-GET-CURR-DATE.                                              
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,10,10)                            
                    ,CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() 
           AS DATE),'USA')                             
                INTO :WS-CURRENT-DT                                     
                    ,:WS-CURR-DT                                        
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = 'COMMON'                            
                AND  COMPANY_NO     = '01'                              
                AND  CMND_CODE      = 'DATE'                            
                AND  SEQ_NO         = 10                                
                AND  STATUS         = 'A'                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,10,10)                                    
MFA-TR*             ,CHAR(CURRENT DATE,USA)                                     
MFA-TR*         INTO :WS-CURRENT-DT                                             
MFA-TR*             ,:WS-CURR-DT                                                
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = 'COMMON'                                    
MFA-TR*         AND  COMPANY_NO     = '01'                                      
MFA-TR*         AND  CMND_CODE      = 'DATE'                                    
MFA-TR*         AND  SEQ_NO         = 10                                        
MFA-TR*         AND  STATUS         = 'A'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 0110-GET-CURR-DATE              **'      
              DISPLAY '** ERROR DURING SELECT OF DATE          **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0120-GET-COMPANY.                                        *        
      *                                                                *        
      ******************************************************************        
       0120-GET-COMPANY.                                                
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
              WHERE  COMPANY_NO = :WS-PARM-COMPANY                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*       WHERE  COMPANY_NO = :WS-PARM-COMPANY                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 0120-GET-COMPANY                **'      
              DISPLAY '** ERROR DURING SELECT OF COMPANY NAME  **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0130-GET-TIMESTAMP                                       *        
      *                                                                *        
      ******************************************************************        
       0130-GET-TIMESTAMP.                                              
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 0130-GET-TIMESTAMP              **'      
              DISPLAY '** ERROR DURING SELECT OF TIMESTAMP     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0140-GET-BHV-MODEL-STYLE                                 *        
      *                                                                *        
      ******************************************************************        
       0140-GET-BHV-MODEL-STYLE.                                        
           EXEC SQL                                                     
                SELECT BHV_MODEL_STYLE                                  
                  INTO :WS-BHV-MODEL-STYLE                              
                  FROM CSS_BHV_MODEL WITH(READUNCOMMITTED)                      
                 WHERE BHV_MODEL_ID = :WS-BHV-MODEL-ID                  
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT BHV_MODEL_STYLE                                          
MFA-TR*           INTO :WS-BHV-MODEL-STYLE                                      
MFA-TR*           FROM CSS_BHV_MODEL                                            
MFA-TR*          WHERE BHV_MODEL_ID = :WS-BHV-MODEL-ID                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 0140-GET-BHV-MODEL-STYLE        **'      
              DISPLAY '** ERROR DURING SELECT OF MODEL STYLE   **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0150-GET-SCORE-RATING-WEIGHT                             *        
      *                                                                *        
      ******************************************************************        
       0150-GET-SCORE-RATING-WEIGHT.                                    
           EXEC SQL                                                     
                SELECT CIS.SUBSTR3$(CIS.DECIMAL2CHAR(BHV_SCORE_MIN), 7, 
           6),                 
                       CIS.SUBSTR3$(CIS.DECIMAL2CHAR(BHV_SCORE_MAX), 7, 
           6)                  
                  INTO :WS-BHV-SCORE-MIN,                               
                       :WS-BHV-SCORE-MAX                                
                  FROM CSS_BHV_SCOR_RATNG WITH(READUNCOMMITTED)                 
                 WHERE BHV_MODEL_ID = :WS-BHV-MODEL-ID                  
                   AND BHV_SCORE_RATING = :WS-BHV-SCORE-RATING          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUBSTR(CHAR(BHV_SCORE_MIN),7,6),                         
MFA-TR*                SUBSTR(CHAR(BHV_SCORE_MAX),7,6)                          
MFA-TR*           INTO :WS-BHV-SCORE-MIN,                                       
MFA-TR*                :WS-BHV-SCORE-MAX                                        
MFA-TR*           FROM CSS_BHV_SCOR_RATNG                                       
MFA-TR*          WHERE BHV_MODEL_ID = :WS-BHV-MODEL-ID                          
MFA-TR*            AND BHV_SCORE_RATING = :WS-BHV-SCORE-RATING                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 0150-GET-SCORE-RATING-WEIGHT    **'      
              DISPLAY '** ERROR DURING SELECT OF RATING RANGE  **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0200-CNVT-BILL-CYCLE                                     *        
      *                                                                *        
      ******************************************************************        
       0200-CNVT-BILL-CYCLE.                                            
           IF E-FCA801-BILL-CYCLE EQUAL '01'                            
              MOVE 01 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '02'                       
              MOVE 02 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '03'                       
              MOVE 03 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '04'                       
              MOVE 04 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '05'                       
              MOVE 05 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '06'                       
              MOVE 06 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '07'                       
              MOVE 07 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '08'                       
              MOVE 08 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '09'                       
              MOVE 09 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '10'                       
              MOVE 10 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '11'                       
              MOVE 11 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '12'                       
              MOVE 12 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '13'                       
              MOVE 13 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '14'                       
              MOVE 14 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '15'                       
              MOVE 15 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '16'                       
              MOVE 16 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '17'                       
              MOVE 17 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '18'                       
              MOVE 18 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '19'                       
              MOVE 19 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '20'                       
              MOVE 20 TO WS-BILL-CYCLE-N                                
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '21'                       
              MOVE 21 TO WS-BILL-CYCLE-N                                
           ELSE                                                         
              MOVE 00 TO WS-BILL-CYCLE-N                                
           END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0300-CNVT-BILL-CYCLE                                     *        
      *                                                                *        
      ******************************************************************        
       0300-CNVT-BILL-CYCLE.                                            
           IF E-FCA801-BILL-CYCLE EQUAL '01'                            
              MOVE 01 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '02'                       
              MOVE 02 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '03'                       
              MOVE 03 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '04'                       
              MOVE 04 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '05'                       
              MOVE 05 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '06'                       
              MOVE 06 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '07'                       
              MOVE 07 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '08'                       
              MOVE 08 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '09'                       
              MOVE 09 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '10'                       
              MOVE 10 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '11'                       
              MOVE 11 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '12'                       
              MOVE 12 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '13'                       
              MOVE 13 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '14'                       
              MOVE 14 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '15'                       
              MOVE 15 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '16'                       
              MOVE 16 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '17'                       
              MOVE 17 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '18'                       
              MOVE 18 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '19'                       
              MOVE 19 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '20'                       
              MOVE 20 TO WS-BILL-CYCLE-N2                               
           ELSE IF E-FCA801-BILL-CYCLE EQUAL '21'                       
              MOVE 21 TO WS-BILL-CYCLE-N2                               
           ELSE                                                         
              MOVE 00 TO WS-BILL-CYCLE-N2                               
           END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       0400-CNVT-BACK-CYCLE                                     *        
      *                                                                *        
      ******************************************************************        
       0400-CNVT-BACK-CYCLE.                                            
           IF WS-BILL-CYCLE-N = 1                                       
              MOVE '01' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 2                                  
              MOVE '02' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 3                                  
              MOVE '03' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 4                                  
              MOVE '04' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 5                                  
              MOVE '05' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 6                                  
              MOVE '06' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 7                                  
              MOVE '07' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 8                                  
              MOVE '08' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 9                                  
              MOVE '09' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 10                                 
              MOVE '10' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 11                                 
              MOVE '11' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 12                                 
              MOVE '12' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 13                                 
              MOVE '13' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 14                                 
              MOVE '14' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 15                                 
              MOVE '15' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 16                                 
              MOVE '16' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 17                                 
              MOVE '17' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 18                                 
              MOVE '18' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 19                                 
              MOVE '19' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 20                                 
              MOVE '20' TO WS-BILL-CYCLE                                
           ELSE IF WS-BILL-CYCLE-N = 21                                 
              MOVE '21' TO WS-BILL-CYCLE                                
           ELSE                                                         
              MOVE '  ' TO WS-BILL-CYCLE                                
           END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
           END-IF.                                                      
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       2000-PROCESS-ACCT                                        *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-ACCT.                                               
      *                                                                         
           MOVE E-FCA801-BHV-MODEL-ID      TO WS-PREV-BHV-MODEL-ID      
           MOVE E-FCA801-BHV-SCORE-RATING  TO WS-PREV-BHV-SCORE-RATING  
           MOVE E-FCA801-BILL-CYCLE        TO WS-BILL-CYCLE             
                                                                        
           PERFORM UNTIL E-FCA801-BHV-MODEL-ID NOT EQUAL                
                         WS-PREV-BHV-MODEL-ID OR                        
                         E-FCA801-BILL-CYCLE NOT EQUAL                  
                         WS-BILL-CYCLE OR                               
                         E-FCA801-BHV-SCORE-RATING NOT EQUAL            
                         WS-PREV-BHV-SCORE-RATING OR                    
                         END-OF-FCA808                                  
      *                                                                         
              MOVE E-FCA801-AR-DAY-00     TO   ADD-CURRENT-AMOUNT       
              MOVE E-FCA801-AR-DAY-30     TO   ADD-30-DAY-AMOUNT        
              MOVE E-FCA801-AR-DAY-60     TO   ADD-60-DAY-AMOUNT        
              MOVE E-FCA801-AR-DAY-90     TO   ADD-90-DAY-AMOUNT        
              MOVE E-FCA801-SECURITY-AMT  TO   ADD-SECURITY-AMOUNT      
                                               WS-SECURITY-AMOUNT       
              IF (ADD-30-DAY-AMOUNT EQUAL ZERO AND                      
                  ADD-60-DAY-AMOUNT EQUAL ZERO AND                      
                  ADD-90-DAY-AMOUNT EQUAL ZERO)                         
                 COMPUTE WS-CURRENT-AMOUNT = WS-CURRENT-AMOUNT +        
                                             ADD-CURRENT-AMOUNT         
                 COMPUTE WS-00-COUNT = WS-00-COUNT + 1                  
                 MOVE 'Y'            TO WS-RISK-SW                      
              ELSE                                                      
                 MOVE 'N'            TO WS-RISK-SW                      
              IF ADD-60-DAY-AMOUNT EQUAL ZERO AND                       
               ADD-90-DAY-AMOUNT EQUAL ZERO                             
                 COMPUTE WS-30-DAY-AMOUNT  = WS-30-DAY-AMOUNT +         
                                             ADD-30-DAY-AMOUNT +        
                                             ADD-CURRENT-AMOUNT         
                 COMPUTE WS-30-COUNT = WS-30-COUNT + 1                  
              ELSE IF ADD-90-DAY-AMOUNT EQUAL ZERO                      
                 COMPUTE WS-60-DAY-AMOUNT  = WS-60-DAY-AMOUNT +         
                                             ADD-60-DAY-AMOUNT +        
                                             ADD-30-DAY-AMOUNT +        
                                             ADD-CURRENT-AMOUNT         
                 COMPUTE WS-60-COUNT = WS-60-COUNT + 1                  
              ELSE                                                      
                 COMPUTE WS-90-DAY-AMOUNT  = WS-90-DAY-AMOUNT +         
                                             ADD-90-DAY-AMOUNT +        
                                             ADD-60-DAY-AMOUNT +        
                                             ADD-30-DAY-AMOUNT +        
                                             ADD-CURRENT-AMOUNT         
                 COMPUTE WS-90-COUNT = WS-90-COUNT + 1                  
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
              COMPUTE WS-TOTAL-AMOUNT  =    WS-CURRENT-AMOUNT +         
                                            WS-30-DAY-AMOUNT  +         
                                            WS-60-DAY-AMOUNT  +         
                                            WS-90-DAY-AMOUNT            
              COMPUTE WS-TOTAL-COUNT = WS-TOTAL-COUNT + 1               
              IF WS-RISK-SW = 'N'                                       
              IF WS-SECURITY-AMOUNT > 0                                 
                IF (((ADD-SECURITY-AMOUNT) >                            
                    (ADD-CURRENT-AMOUNT + ADD-30-DAY-AMOUNT +           
                     ADD-60-DAY-AMOUNT + ADD-90-DAY-AMOUNT)) OR         
                    (WS-SECURITY-AMOUNT = 999999999.99))                
                   COMPUTE WS-SEC-AMOUNT     = (WS-SEC-AMOUNT +         
                         (ADD-CURRENT-AMOUNT + ADD-30-DAY-AMOUNT +      
                          ADD-60-DAY-AMOUNT + ADD-90-DAY-AMOUNT))       
                ELSE                                                    
                   COMPUTE WS-SEC-AMOUNT     = WS-SECURITY-AMOUNT +     
                                               WS-SEC-AMOUNT            
                   COMPUTE WS-RISK-AMOUNT  =  WS-RISK-AMOUNT +          
                     ((ADD-CURRENT-AMOUNT + ADD-30-DAY-AMOUNT +         
                       ADD-60-DAY-AMOUNT + ADD-90-DAY-AMOUNT) -         
                                        (ADD-SECURITY-AMOUNT))          
                   COMPUTE WS-RISK-COUNT = WS-RISK-COUNT + 1            
                END-IF                                                  
                COMPUTE WS-SEC-COUNT = WS-SEC-COUNT + 1                 
              ELSE                                                      
                COMPUTE WS-RISK-AMOUNT  =  WS-RISK-AMOUNT +             
                     ((ADD-CURRENT-AMOUNT + ADD-30-DAY-AMOUNT +         
                       ADD-60-DAY-AMOUNT + ADD-90-DAY-AMOUNT) -         
                                        (ADD-SECURITY-AMOUNT))          
                 COMPUTE WS-RISK-COUNT = WS-RISK-COUNT + 1              
              END-IF                                                    
              END-IF                                                    
              MOVE E-FCA801-BHV-MODEL-ID      TO WS-PREV-BHV-MODEL-ID   
              MOVE 'N'            TO WS-RISK-SW                         
              PERFORM 0020-READ-FCSCA808 THRU 0020-EXIT                 
           END-PERFORM                                                  
      *                                                                         
           PERFORM 8500-PRINT-DETAIL       THRU 8500-EXIT.              
      *                                                                         
           IF E-FCA801-BHV-MODEL-ID NOT EQUAL WS-PREV-BHV-MODEL-ID      
              IF WS-BILL-CYCLE-N NOT EQUAL 21                           
                 PERFORM UNTIL WS-BILL-CYCLE-N EQUAL TO 21              
                    ADD 1 TO WS-BILL-CYCLE-N                            
                    PERFORM 0400-CNVT-BACK-CYCLE THRU 0400-EXIT         
                    PERFORM 8500-PRINT-DETAIL    THRU 8500-EXIT         
                 END-PERFORM                                            
                 PERFORM 8600-PRINT-FOOTER       THRU 8600-EXIT         
                 PERFORM 8650-PRINT-MODEL-FOOTER THRU 8650-EXIT         
                 MOVE 1 TO WS-BILL-CYCLE-N                              
                 PERFORM 0300-CNVT-BILL-CYCLE    THRU 0300-EXIT         
                 MOVE WS-52 TO WS-RPT1-LINE-NO                          
              ELSE IF WS-BILL-CYCLE-N EQUAL 21                          
                 PERFORM 8600-PRINT-FOOTER       THRU 8600-EXIT         
                 PERFORM 8650-PRINT-MODEL-FOOTER THRU 8650-EXIT         
                 MOVE 1 TO WS-BILL-CYCLE-N                              
                 PERFORM 0300-CNVT-BILL-CYCLE    THRU 0300-EXIT         
                 MOVE WS-52 TO WS-RPT1-LINE-NO                          
              END-IF
              END-IF                                                    
           ELSE IF E-FCA801-BHV-SCORE-RATING NOT EQUAL                  
                   WS-PREV-BHV-SCORE-RATING                             
              IF WS-BILL-CYCLE-N NOT EQUAL 21                           
                 PERFORM UNTIL WS-BILL-CYCLE-N EQUAL TO 21              
                    ADD 1 TO WS-BILL-CYCLE-N                            
                    PERFORM 0400-CNVT-BACK-CYCLE THRU 0400-EXIT         
                    PERFORM 8500-PRINT-DETAIL   THRU 8500-EXIT          
                 END-PERFORM                                            
                 PERFORM 8600-PRINT-FOOTER THRU 8600-EXIT               
                 MOVE 1 TO WS-BILL-CYCLE-N                              
                 PERFORM 0300-CNVT-BILL-CYCLE THRU 0300-EXIT            
                 MOVE WS-52 TO WS-RPT1-LINE-NO                          
              ELSE IF WS-BILL-CYCLE-N EQUAL 21                          
                 PERFORM 8600-PRINT-FOOTER THRU 8600-EXIT               
                 MOVE 1 TO WS-BILL-CYCLE-N                              
                 PERFORM 0300-CNVT-BILL-CYCLE THRU 0300-EXIT            
                 MOVE WS-52 TO WS-RPT1-LINE-NO                          
              END-IF
              END-IF                                                    
           ELSE IF E-FCA801-BILL-CYCLE NOT EQUAL WS-BILL-CYCLE          
              AND WS-BILL-CYCLE-N LESS THAN 21                          
              ADD 1 TO WS-BILL-CYCLE-N                                  
              PERFORM 0300-CNVT-BILL-CYCLE THRU 0300-EXIT               
           ELSE IF END-OF-FCA808 AND WS-BILL-CYCLE-N NOT EQUAL 21       
              PERFORM UNTIL WS-BILL-CYCLE-N EQUAL TO 21                 
                 ADD 1 TO WS-BILL-CYCLE-N                               
                 PERFORM 0400-CNVT-BACK-CYCLE THRU 0400-EXIT            
                 PERFORM 8500-PRINT-DETAIL   THRU 8500-EXIT             
              END-PERFORM                                               
              END-IF                                                    
              IF END-OF-FCA808                                          
                 PERFORM 8600-PRINT-FOOTER      THRU 8600-EXIT          
                 PERFORM 8650-PRINT-MODEL-FOOTER THRU 8650-EXIT         
                 PERFORM 8700-PRINT-COMP-FOOTER THRU 8700-EXIT          
              END-IF                                                    
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *        
      ******************************************************************        
       7500-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7500-GET-DATABASE'                            
               DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *            8000-PRINT-HEADER                                  *         
      *             PRINTS THE REPORT HEADER                          *         
      *                                                               *         
      *****************************************************************         
       8000-PRINT-HEADER.                                               
      *                                                                         
           MOVE E-FCA801-BHV-MODEL-ID  TO WS-BHV-MODEL-ID               
           MOVE E-FCA801-BHV-SCORE-RATING  TO WS-BHV-SCORE-RATING       
      *                                                                         
           EXEC SQL                                                     
              SELECT BHV_MODEL_NA                                       
                INTO :WS-BHV-MODEL-DESC                                 
                FROM CSS_BHV_MODEL WITH(READUNCOMMITTED)                        
              WHERE  BHV_MODEL_ID = :WS-BHV-MODEL-ID                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BHV_MODEL_NA                                               
MFA-TR*         INTO :WS-BHV-MODEL-DESC                                         
MFA-TR*         FROM CSS_BHV_MODEL                                              
MFA-TR*       WHERE  BHV_MODEL_ID = :WS-BHV-MODEL-ID                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '** PARA 8000-PRINT-HEADER               **'      
              DISPLAY '** ERROR DURING SELECT OF BHV DESC      **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
           PERFORM 0140-GET-BHV-MODEL-STYLE   THRU 0140-EXIT.           
      *                                                                         
           IF MATRIX-MODEL                                              
              MOVE SPACES         TO  WS-SEPARATOR                      
                                      WS-BHV-SCORE-MIN                  
                                      WS-BHV-SCORE-DASH                 
                                      WS-BHV-SCORE-MAX                  
           ELSE IF WEIGHTAGE-MODEL                                      
              MOVE ' - '          TO  WS-SEPARATOR                      
                                      WS-BHV-SCORE-DASH                 
              PERFORM 0150-GET-SCORE-RATING-WEIGHT  THRU 0150-EXIT      
           END-IF
           END-IF.                                                      
      *                                                                         
           IF  SEB-DATABASE                                             
               MOVE '          SCANA ENERGY'  TO WS-RPRT-COMPANY        
           END-IF                                                       
      *                                                                         
           IF  CSR-DATABASE                                             
               MOVE '          PSNC  ENERGY'  TO WS-RPRT-COMPANY        
           END-IF.                                                      
      *                                                                         
           MOVE ZEROES                     TO WS-RPT1-LINE-NO.          
           MOVE WS-HEADER-1                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
           MOVE WS-HEADER-2                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 1                           TO WS-RPT1-PAGE-NO.          
           MOVE WS-RPT1-PAGE-NO            TO WS-RPRT-PAGE-NO.          
           MOVE WS-HEADER-3                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-MODEL-ID-HEADER         TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE E-FCA801-BHV-SCORE-RATING TO WS-BHV-SCORE-RATING.       
           MOVE WS-SCORE-RATING-HEADER    TO PRNTFILE-DATA.             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-HEADER-4                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-HEADER-5                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 7                           TO WS-RPT1-LINE-NO.          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *            8500-PRINT-DETAIL                                  *         
      *   PRINTS DETAIL LINE                                          *         
      *                                                               *         
      *****************************************************************         
       8500-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-RPT1-LINE-NO NOT < WS-52                               
              PERFORM 8000-PRINT-HEADER          THRU 8000-EXIT         
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-CURRENT-AMOUNT ROUNDED = WS-CURRENT-AMOUNT + 0    
           MOVE WS-CURRENT-AMOUNT    TO WS-CURRENT-AMOUNT-Z             
           COMPUTE WS-CURRENT-AMOUNT-TOT ROUNDED =                      
                         WS-CURRENT-AMOUNT-TOT + WS-CURRENT-AMOUNT      
      *                                                                         
           COMPUTE WS-30-DAY-AMOUNT ROUNDED = WS-30-DAY-AMOUNT + 0      
           MOVE WS-30-DAY-AMOUNT     TO WS-30-DAY-AMOUNT-Z              
           COMPUTE WS-30-DAY-AMOUNT-TOT ROUNDED =                       
                         WS-30-DAY-AMOUNT-TOT + WS-30-DAY-AMOUNT        
      *                                                                         
           COMPUTE WS-60-DAY-AMOUNT ROUNDED = WS-60-DAY-AMOUNT + 0      
           MOVE WS-60-DAY-AMOUNT     TO WS-60-DAY-AMOUNT-Z              
           COMPUTE WS-60-DAY-AMOUNT-TOT ROUNDED =                       
                         WS-60-DAY-AMOUNT-TOT + WS-60-DAY-AMOUNT        
      *                                                                         
           COMPUTE WS-90-DAY-AMOUNT ROUNDED = WS-90-DAY-AMOUNT + 0      
           MOVE WS-90-DAY-AMOUNT     TO WS-90-DAY-AMOUNT-Z              
           COMPUTE WS-90-DAY-AMOUNT-TOT ROUNDED =                       
                         WS-90-DAY-AMOUNT-TOT + WS-90-DAY-AMOUNT        
      *                                                                         
           COMPUTE WS-SEC-AMOUNT  ROUNDED = WS-SEC-AMOUNT  + 0          
           MOVE WS-SEC-AMOUNT        TO WS-SEC-AMOUNT-Z                 
           COMPUTE WS-SEC-AMOUNT-TOT =                                  
                   WS-SEC-AMOUNT-TOT + WS-SEC-AMOUNT                    
      *                                                                         
           IF WS-TOTAL-AMOUNT > 0                                       
               COMPUTE WS-30-DAY-PERC ROUNDED =                         
                      (WS-30-DAY-AMOUNT * 100 / WS-TOTAL-AMOUNT)        
      *                                                                         
               COMPUTE WS-60-DAY-PERC ROUNDED =                         
                      (WS-60-DAY-AMOUNT * 100 / WS-TOTAL-AMOUNT)        
      *                                                                         
               COMPUTE WS-90-DAY-PERC ROUNDED =                         
                     (WS-90-DAY-AMOUNT * 100  / WS-TOTAL-AMOUNT)        
      *                                                                         
               COMPUTE WS-RISK-PERC ROUNDED =                           
                     (WS-RISK-AMOUNT * 100 / WS-TOTAL-AMOUNT)           
      *                                                                         
               COMPUTE WS-SEC-PERC ROUNDED =                            
                     (WS-SEC-AMOUNT * 100 / WS-TOTAL-AMOUNT)            
           ELSE                                                         
               MOVE ZEROS                    TO WS-30-DAY-PERC          
                                                WS-60-DAY-PERC          
                                                WS-90-DAY-PERC          
                                                WS-RISK-PERC            
                                                WS-SEC-PERC             
           END-IF                                                       
      *                                                                         
           MOVE WS-30-DAY-PERC       TO WS-30-PERC-Z                    
           MOVE WS-60-DAY-PERC       TO WS-60-PERC-Z                    
           MOVE WS-90-DAY-PERC       TO WS-90-PERC-Z                    
           MOVE WS-RISK-PERC         TO WS-RISK-PERC-Z                  
           MOVE WS-SEC-PERC          TO WS-SEC-PERC-Z                   
      *                                                                         
           MOVE WS-RISK-AMOUNT       TO WS-RISK-AMOUNT-Z                
           COMPUTE WS-RISK-AMOUNT-TOT =                                 
                   WS-RISK-AMOUNT-TOT + WS-RISK-AMOUNT                  
      *                                                                         
           MOVE WS-TOTAL-AMOUNT      TO WS-TOTAL-AMOUNT-Z               
           COMPUTE WS-TOTAL-AMOUNT-TOT =                                
                   WS-TOTAL-AMOUNT-TOT + WS-TOTAL-AMOUNT                
      *                                                                         
           MOVE WS-00-COUNT          TO WS-00-COUNT-Z                   
           MOVE WS-30-COUNT          TO WS-30-COUNT-Z                   
           MOVE WS-60-COUNT          TO WS-60-COUNT-Z                   
           MOVE WS-90-COUNT          TO WS-90-COUNT-Z                   
           MOVE WS-RISK-COUNT        TO WS-RISK-COUNT-Z                 
           MOVE WS-TOTAL-COUNT       TO WS-TOTAL-COUNT-Z                
           MOVE WS-SEC-COUNT         TO WS-SEC-COUNT-Z                  
      *                                                                         
           COMPUTE WS-00-COUNT-TOT =                                    
                   WS-00-COUNT-TOT + WS-00-COUNT                        
           COMPUTE WS-30-COUNT-TOT =                                    
                   WS-30-COUNT-TOT + WS-30-COUNT                        
           COMPUTE WS-60-COUNT-TOT =                                    
                   WS-60-COUNT-TOT + WS-60-COUNT                        
           COMPUTE WS-90-COUNT-TOT =                                    
                   WS-90-COUNT-TOT + WS-90-COUNT                        
           COMPUTE WS-RISK-COUNT-TOT =                                  
                   WS-RISK-COUNT-TOT + WS-RISK-COUNT                    
           COMPUTE WS-TOTAL-COUNT-TOT =                                 
                   WS-TOTAL-COUNT-TOT + WS-TOTAL-COUNT                  
           COMPUTE WS-SEC-COUNT-TOT =                                   
                   WS-SEC-COUNT-TOT + WS-SEC-COUNT                      
      *                                                                         
           PERFORM 0101-RE-INITIALIZE THRU 0101-EXIT.                   
      *                                                                         
           MOVE WS-DETAIL-1            TO PRNTFILE-DATA.                
            WRITE PRNTFILE-RECORD                                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
              ADD 1                       TO WS-RPT1-LINE-NO.           
      *                                                                         
           MOVE WS-DETAIL-2            TO PRNTFILE-DATA.                
            WRITE PRNTFILE-RECORD                                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
              ADD 1                       TO WS-RPT1-LINE-NO.           
      *                                                                         
           IF E-FCA801-BHV-MODEL-ID NOT EQUAL WS-PREV-BHV-MODEL-ID      
           AND WS-SEB-BREAK = 'N'                                       
              MOVE 'Y'                   TO WS-SEB-BREAK                
              IF WS-BILL-CYCLE-N NOT EQUAL 21                           
                 PERFORM UNTIL WS-BILL-CYCLE-N EQUAL TO 21              
                    ADD 1 TO WS-BILL-CYCLE-N                            
                    PERFORM 0400-CNVT-BACK-CYCLE THRU 0400-EXIT         
                    PERFORM 8500-PRINT-DETAIL   THRU 8500-EXIT          
                 END-PERFORM                                            
              END-IF                                                    
              MOVE E-FCA801-BHV-MODEL-ID        TO WS-PREV-BHV-MODEL-ID 
              MOVE E-FCA801-BHV-SCORE-RATING TO WS-PREV-BHV-SCORE-RATING
              MOVE E-FCA801-BILL-CYCLE          TO WS-BILL-CYCLE        
              MOVE 1                            TO WS-BILL-CYCLE-N      
              PERFORM 0300-CNVT-BILL-CYCLE      THRU 0300-EXIT          
              PERFORM 8600-PRINT-FOOTER         THRU 8600-EXIT          
              PERFORM 8650-PRINT-MODEL-FOOTER   THRU 8650-EXIT          
              PERFORM 8000-PRINT-HEADER         THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *            8600-PRINT-FOOTER                                  *         
      *   PRINTS FOOTER LINE                                          *         
      *                                                               *         
      *****************************************************************         
       8600-PRINT-FOOTER.                                               
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE WS-CURRENT-AMOUNT-TOT  TO                               
                                       WS-CURRENT-AMOUNT-TOT-Z          
           COMPUTE WS-CURRENT-AMOUNT-MODEL =                            
                   WS-CURRENT-AMOUNT-MODEL + WS-CURRENT-AMOUNT-TOT      
           COMPUTE WS-CURRENT-AMOUNT-COMP =                             
                   WS-CURRENT-AMOUNT-COMP + WS-CURRENT-AMOUNT-TOT       
      *                                                                         
           MOVE WS-30-DAY-AMOUNT-TOT   TO                               
                                       WS-30-DAY-AMOUNT-TOT-Z           
           COMPUTE WS-30-DAY-AMOUNT-MODEL =                             
                   WS-30-DAY-AMOUNT-MODEL + WS-30-DAY-AMOUNT-TOT        
           COMPUTE WS-30-DAY-AMOUNT-COMP =                              
                   WS-30-DAY-AMOUNT-COMP + WS-30-DAY-AMOUNT-TOT         
      *                                                                         
           MOVE WS-60-DAY-AMOUNT-TOT   TO                               
                                       WS-60-DAY-AMOUNT-TOT-Z           
           COMPUTE WS-60-DAY-AMOUNT-MODEL =                             
                   WS-60-DAY-AMOUNT-MODEL + WS-60-DAY-AMOUNT-TOT        
           COMPUTE WS-60-DAY-AMOUNT-COMP =                              
                   WS-60-DAY-AMOUNT-COMP + WS-60-DAY-AMOUNT-TOT         
      *                                                                         
           MOVE WS-90-DAY-AMOUNT-TOT   TO                               
                                       WS-90-DAY-AMOUNT-TOT-Z           
           COMPUTE WS-90-DAY-AMOUNT-MODEL =                             
                   WS-90-DAY-AMOUNT-MODEL + WS-90-DAY-AMOUNT-TOT        
           COMPUTE WS-90-DAY-AMOUNT-COMP =                              
                   WS-90-DAY-AMOUNT-COMP + WS-90-DAY-AMOUNT-TOT         
      *                                                                         
           MOVE WS-SEC-AMOUNT-TOT      TO                               
                                       WS-SEC-AMOUNT-TOT-Z              
           COMPUTE WS-SEC-AMOUNT-MODEL =                                
                   WS-SEC-AMOUNT-MODEL + WS-SEC-AMOUNT-TOT              
           COMPUTE WS-SEC-AMOUNT-COMP =                                 
                   WS-SEC-AMOUNT-COMP + WS-SEC-AMOUNT-TOT               
      *                                                                         
           MOVE WS-TOTAL-AMOUNT-TOT    TO                               
                                       WS-TOTAL-AMOUNT-TOT-Z            
           COMPUTE WS-TOTAL-AMOUNT-MODEL =                              
                   WS-TOTAL-AMOUNT-MODEL + WS-TOTAL-AMOUNT-TOT          
           COMPUTE WS-TOTAL-AMOUNT-COMP =                               
                   WS-TOTAL-AMOUNT-COMP + WS-TOTAL-AMOUNT-TOT           
      *                                                                         
           MOVE WS-RISK-AMOUNT-TOT     TO                               
                                       WS-RISK-AMOUNT-TOT-Z             
           COMPUTE WS-RISK-AMOUNT-MODEL =                               
                   WS-RISK-AMOUNT-MODEL + WS-RISK-AMOUNT-TOT            
           COMPUTE WS-RISK-AMOUNT-COMP =                                
                   WS-RISK-AMOUNT-COMP + WS-RISK-AMOUNT-TOT             
      *                                                                         
           MOVE  WS-00-COUNT-TOT       TO                               
                                       WS-00-COUNT-TOT-Z                
           COMPUTE WS-00-COUNT-MODEL =                                  
                   WS-00-COUNT-MODEL + WS-00-COUNT-TOT                  
           COMPUTE WS-00-COUNT-COMP =                                   
                   WS-00-COUNT-COMP + WS-00-COUNT-TOT                   
      *                                                                         
           MOVE WS-30-COUNT-TOT        TO                               
                                       WS-30-COUNT-TOT-Z                
           COMPUTE WS-30-COUNT-MODEL =                                  
                   WS-30-COUNT-MODEL + WS-30-COUNT-TOT                  
           COMPUTE WS-30-COUNT-COMP =                                   
                   WS-30-COUNT-COMP + WS-30-COUNT-TOT                   
      *                                                                         
           MOVE WS-60-COUNT-TOT        TO                               
                                       WS-60-COUNT-TOT-Z                
           COMPUTE WS-60-COUNT-MODEL =                                  
                   WS-60-COUNT-MODEL + WS-60-COUNT-TOT                  
           COMPUTE WS-60-COUNT-COMP =                                   
                   WS-60-COUNT-COMP + WS-60-COUNT-TOT                   
      *                                                                         
           MOVE WS-90-COUNT-TOT        TO                               
                                       WS-90-COUNT-TOT-Z                
           COMPUTE WS-90-COUNT-MODEL =                                  
                   WS-90-COUNT-MODEL + WS-90-COUNT-TOT                  
           COMPUTE WS-90-COUNT-COMP =                                   
                   WS-90-COUNT-COMP + WS-90-COUNT-TOT                   
      *                                                                         
           MOVE WS-RISK-COUNT-TOT      TO                               
                                       WS-RISK-COUNT-TOT-Z              
           COMPUTE WS-RISK-COUNT-MODEL =                                
                   WS-RISK-COUNT-MODEL + WS-RISK-COUNT-TOT              
           COMPUTE WS-RISK-COUNT-COMP =                                 
                   WS-RISK-COUNT-COMP + WS-RISK-COUNT-TOT               
      *                                                                         
           MOVE WS-SEC-COUNT-TOT       TO                               
                                       WS-SEC-COUNT-TOT-Z               
           COMPUTE WS-SEC-COUNT-MODEL =                                 
                   WS-SEC-COUNT-MODEL + WS-SEC-COUNT-TOT                
           COMPUTE WS-SEC-COUNT-COMP =                                  
                   WS-SEC-COUNT-COMP + WS-SEC-COUNT-TOT                 
      *                                                                         
           MOVE WS-TOTAL-COUNT-TOT     TO                               
                                       WS-TOTAL-COUNT-TOT-Z             
           COMPUTE WS-TOTAL-COUNT-MODEL =                               
                   WS-TOTAL-COUNT-MODEL + WS-TOTAL-COUNT-TOT            
           COMPUTE WS-TOTAL-COUNT-COMP =                                
                   WS-TOTAL-COUNT-COMP + WS-TOTAL-COUNT-TOT             
      *                                                                         
           IF WS-TOTAL-AMOUNT-TOT   > 0                                 
              COMPUTE WS-30-DAY-PERC ROUNDED =                          
                   (WS-30-DAY-AMOUNT-TOT * 100 / WS-TOTAL-AMOUNT-TOT)   
              COMPUTE WS-60-DAY-PERC ROUNDED =                          
                   (WS-60-DAY-AMOUNT-TOT * 100 / WS-TOTAL-AMOUNT-TOT)   
              COMPUTE WS-90-DAY-PERC ROUNDED =                          
                   (WS-90-DAY-AMOUNT-TOT * 100 / WS-TOTAL-AMOUNT-TOT)   
              COMPUTE WS-SEC-PERC    ROUNDED =                          
                   (WS-SEC-AMOUNT-TOT * 100 / WS-TOTAL-AMOUNT-TOT)      
              COMPUTE WS-RISK-PERC  ROUNDED =                           
                   (WS-RISK-AMOUNT-TOT * 100 / WS-TOTAL-AMOUNT-TOT)     
           ELSE                                                         
              MOVE      ZEROS                TO WS-30-DAY-PERC          
                                                WS-60-DAY-PERC          
                                                WS-90-DAY-PERC          
                                                WS-SEC-PERC             
                                                WS-RISK-PERC            
           END-IF                                                       
      *                                                                         
              MOVE WS-30-DAY-PERC    TO WS-30-PERC-TOT-Z                
              MOVE WS-60-DAY-PERC    TO WS-60-PERC-TOT-Z                
              MOVE WS-90-DAY-PERC    TO WS-90-PERC-TOT-Z                
              MOVE WS-SEC-PERC       TO WS-SEC-PERC-TOT-Z               
              MOVE WS-RISK-PERC      TO WS-RISK-PERC-TOT-Z              
      *                                                                         
           MOVE WS-FOOTER-1            TO PRNTFILE-DATA                 
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 2 LINES                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA             
           ADD 1                           TO WS-RPT1-LINE-NO           
      *                                                                         
           MOVE WS-FOOTER-2                TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
                                                                        
           MOVE ZEROS                  TO                               
                                       WS-CURRENT-AMOUNT-TOT-Z          
                                       WS-30-DAY-AMOUNT-TOT-Z           
                                       WS-60-DAY-AMOUNT-TOT-Z           
                                       WS-90-DAY-AMOUNT-TOT-Z           
                                       WS-SEC-AMOUNT-TOT-Z              
                                       WS-TOTAL-AMOUNT-TOT-Z            
                                       WS-RISK-AMOUNT-TOT-Z             
                                       WS-00-COUNT-TOT-Z                
                                       WS-30-COUNT-TOT-Z                
                                       WS-60-COUNT-TOT-Z                
                                       WS-90-COUNT-TOT-Z                
                                       WS-RISK-COUNT-TOT-Z              
                                       WS-SEC-COUNT-TOT-Z               
                                       WS-TOTAL-COUNT-TOT-Z             
                                       WS-30-PERC-TOT-Z                 
                                       WS-60-PERC-TOT-Z                 
                                       WS-90-PERC-TOT-Z                 
                                       WS-SEC-PERC-TOT-Z                
                                       WS-RISK-PERC-TOT-Z               
                                       WS-CURRENT-AMOUNT-TOT            
                                       WS-30-DAY-AMOUNT-TOT             
                                       WS-60-DAY-AMOUNT-TOT             
                                       WS-90-DAY-AMOUNT-TOT             
                                       WS-SEC-AMOUNT-TOT                
                                       WS-TOTAL-AMOUNT-TOT              
                                       WS-RISK-AMOUNT-TOT               
                                       WS-00-COUNT-TOT                  
                                       WS-30-COUNT-TOT                  
                                       WS-60-COUNT-TOT                  
                                       WS-90-COUNT-TOT                  
                                       WS-RISK-COUNT-TOT                
                                       WS-SEC-COUNT-TOT                 
                                       WS-TOTAL-COUNT-TOT               
                                       WS-30-DAY-PERC                   
                                       WS-60-DAY-PERC                   
                                       WS-90-DAY-PERC                   
                                       WS-SEC-PERC                      
                                       WS-RISK-PERC.                    
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *            8650-PRINT-MODEL-FOOTER                            *         
      *   PRINTS MODEL FOOTER LINE                                    *         
      *                                                               *         
      *****************************************************************         
       8650-PRINT-MODEL-FOOTER.                                         
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE WS-CURRENT-AMOUNT-MODEL TO                              
                                       WS-CURRENT-AMOUNT-MODEL-Z        
           MOVE WS-30-DAY-AMOUNT-MODEL TO                               
                                       WS-30-DAY-AMOUNT-MODEL-Z         
           MOVE WS-60-DAY-AMOUNT-MODEL TO                               
                                       WS-60-DAY-AMOUNT-MODEL-Z         
           MOVE WS-90-DAY-AMOUNT-MODEL TO                               
                                       WS-90-DAY-AMOUNT-MODEL-Z         
           MOVE WS-SEC-AMOUNT-MODEL    TO                               
                                       WS-SEC-AMOUNT-MODEL-Z            
           MOVE WS-TOTAL-AMOUNT-MODEL  TO                               
                                       WS-TOTAL-AMOUNT-MODEL-Z          
           MOVE WS-RISK-AMOUNT-MODEL   TO                               
                                       WS-RISK-AMOUNT-MODEL-Z           
           MOVE WS-00-COUNT-MODEL      TO                               
                                       WS-00-COUNT-MODEL-Z              
           MOVE WS-30-COUNT-MODEL      TO                               
                                       WS-30-COUNT-MODEL-Z              
           MOVE WS-60-COUNT-MODEL      TO                               
                                       WS-60-COUNT-MODEL-Z              
           MOVE WS-90-COUNT-MODEL      TO                               
                                       WS-90-COUNT-MODEL-Z              
           MOVE WS-RISK-COUNT-MODEL    TO                               
                                       WS-RISK-COUNT-MODEL-Z            
           MOVE WS-SEC-COUNT-MODEL     TO                               
                                       WS-SEC-COUNT-MODEL-Z             
           MOVE WS-TOTAL-COUNT-MODEL   TO                               
                                       WS-TOTAL-COUNT-MODEL-Z           
           IF WS-TOTAL-AMOUNT-MODEL > 0                                 
              COMPUTE WS-30-DAY-PERC ROUNDED =                          
                 (WS-30-DAY-AMOUNT-MODEL * 100 / WS-TOTAL-AMOUNT-MODEL) 
              COMPUTE WS-60-DAY-PERC ROUNDED =                          
                 (WS-60-DAY-AMOUNT-MODEL * 100 / WS-TOTAL-AMOUNT-MODEL) 
              COMPUTE WS-90-DAY-PERC ROUNDED =                          
                 (WS-90-DAY-AMOUNT-MODEL * 100 / WS-TOTAL-AMOUNT-MODEL) 
              COMPUTE WS-SEC-PERC   ROUNDED =                           
                 (WS-SEC-AMOUNT-MODEL * 100 / WS-TOTAL-AMOUNT-MODEL)    
              COMPUTE WS-RISK-PERC  ROUNDED =                           
                   (WS-RISK-AMOUNT-MODEL * 100 / WS-TOTAL-AMOUNT-MODEL) 
           ELSE                                                         
              MOVE      ZEROS                TO WS-30-DAY-PERC          
                                                WS-60-DAY-PERC          
                                                WS-90-DAY-PERC          
                                                WS-SEC-PERC             
                                                WS-RISK-PERC            
           END-IF                                                       
      *                                                                         
              MOVE WS-30-DAY-PERC       TO WS-30-PERC-MODEL-Z           
              MOVE WS-60-DAY-PERC       TO WS-60-PERC-MODEL-Z           
              MOVE WS-90-DAY-PERC       TO WS-90-PERC-MODEL-Z           
              MOVE WS-SEC-PERC          TO WS-SEC-PERC-MODEL-Z          
              MOVE WS-RISK-PERC         TO WS-RISK-PERC-MODEL-Z         
      *                                                                         
           MOVE WS-FOOTER1-MODEL       TO PRNTFILE-DATA                 
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 2 LINES                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA             
           ADD 1                           TO WS-RPT1-LINE-NO           
      *                                                                         
           MOVE WS-FOOTER2-MODEL           TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA             
      *                                                                         
           MOVE ZEROS                        TO PRNTFILE-DATA           
                                              WS-CURRENT-AMOUNT-MODEL   
                                              WS-CURRENT-AMOUNT-MODEL-Z 
                                              WS-30-DAY-AMOUNT-MODEL    
                                              WS-30-DAY-AMOUNT-MODEL-Z  
                                              WS-60-DAY-AMOUNT-MODEL    
                                              WS-60-DAY-AMOUNT-MODEL-Z  
                                              WS-90-DAY-AMOUNT-MODEL    
                                              WS-90-DAY-AMOUNT-MODEL-Z  
                                              WS-SEC-AMOUNT-MODEL       
                                              WS-SEC-AMOUNT-MODEL-Z     
                                              WS-TOTAL-AMOUNT-MODEL     
                                              WS-TOTAL-AMOUNT-MODEL-Z   
                                              WS-RISK-AMOUNT-MODEL      
                                              WS-RISK-AMOUNT-MODEL-Z    
                                              WS-00-COUNT-MODEL         
                                              WS-00-COUNT-MODEL-Z       
                                              WS-30-COUNT-MODEL         
                                              WS-30-COUNT-MODEL-Z       
                                              WS-60-COUNT-MODEL         
                                              WS-60-COUNT-MODEL-Z       
                                              WS-90-COUNT-MODEL         
                                              WS-90-COUNT-MODEL-Z       
                                              WS-RISK-COUNT-MODEL       
                                              WS-RISK-COUNT-MODEL-Z     
                                              WS-SEC-COUNT-MODEL        
                                              WS-SEC-COUNT-MODEL-Z      
                                              WS-TOTAL-COUNT-MODEL      
                                              WS-TOTAL-COUNT-MODEL-Z    
                                              WS-30-PERC-MODEL-Z        
                                              WS-60-PERC-MODEL-Z        
                                              WS-90-PERC-MODEL-Z        
                                              WS-SEC-PERC-MODEL-Z       
                                              WS-RISK-PERC-MODEL-Z      
                                              WS-30-DAY-PERC            
                                              WS-60-DAY-PERC            
                                              WS-90-DAY-PERC            
                                              WS-SEC-PERC               
                                              WS-RISK-PERC.             
           ADD 1                           TO WS-RPT1-LINE-NO.          
                                                                        
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *            8700-PRINT-COMP-FOOTER                             *         
      *   PRINTS COMPANY FOOTER LINE                                  *         
      *                                                               *         
      *****************************************************************         
       8700-PRINT-COMP-FOOTER.                                          
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE WS-CURRENT-AMOUNT-COMP TO                               
                                       WS-CURRENT-AMOUNT-COMP-Z         
           MOVE WS-30-DAY-AMOUNT-COMP  TO                               
                                       WS-30-DAY-AMOUNT-COMP-Z          
           MOVE WS-60-DAY-AMOUNT-COMP  TO                               
                                       WS-60-DAY-AMOUNT-COMP-Z          
           MOVE WS-90-DAY-AMOUNT-COMP  TO                               
                                       WS-90-DAY-AMOUNT-COMP-Z          
           MOVE WS-SEC-AMOUNT-COMP     TO                               
                                       WS-SEC-AMOUNT-COMP-Z             
           MOVE WS-TOTAL-AMOUNT-COMP   TO                               
                                       WS-TOTAL-AMOUNT-COMP-Z           
           MOVE WS-RISK-AMOUNT-COMP    TO                               
                                       WS-RISK-AMOUNT-COMP-Z            
           MOVE WS-00-COUNT-COMP       TO                               
                                       WS-00-COUNT-COMP-Z               
           MOVE WS-30-COUNT-COMP       TO                               
                                       WS-30-COUNT-COMP-Z               
           MOVE WS-60-COUNT-COMP       TO                               
                                       WS-60-COUNT-COMP-Z               
           MOVE WS-90-COUNT-COMP       TO                               
                                       WS-90-COUNT-COMP-Z               
           MOVE WS-RISK-COUNT-COMP     TO                               
                                       WS-RISK-COUNT-COMP-Z             
           MOVE WS-SEC-COUNT-COMP      TO                               
                                       WS-SEC-COUNT-COMP-Z              
           MOVE WS-TOTAL-COUNT-COMP    TO                               
                                       WS-TOTAL-COUNT-COMP-Z            
           IF WS-TOTAL-AMOUNT-COMP  > 0                                 
              COMPUTE WS-30-DAY-PERC ROUNDED =                          
                   (WS-30-DAY-AMOUNT-COMP * 100 / WS-TOTAL-AMOUNT-COMP) 
              COMPUTE WS-60-DAY-PERC ROUNDED =                          
                   (WS-60-DAY-AMOUNT-COMP * 100 / WS-TOTAL-AMOUNT-COMP) 
              COMPUTE WS-90-DAY-PERC ROUNDED =                          
                   (WS-90-DAY-AMOUNT-COMP * 100 / WS-TOTAL-AMOUNT-COMP) 
              COMPUTE WS-SEC-PERC    ROUNDED =                          
                   (WS-SEC-AMOUNT-COMP * 100 / WS-TOTAL-AMOUNT-COMP)    
              COMPUTE WS-RISK-PERC   ROUNDED =                          
                   (WS-RISK-AMOUNT-COMP * 100 / WS-TOTAL-AMOUNT-COMP)   
           ELSE                                                         
              MOVE      ZEROS                TO WS-30-DAY-PERC          
                                                WS-60-DAY-PERC          
                                                WS-90-DAY-PERC          
                                                WS-SEC-PERC             
                                                WS-RISK-PERC            
           END-IF                                                       
      *                                                                         
              MOVE WS-30-DAY-PERC       TO WS-30-PERC-COMP-Z            
              MOVE WS-60-DAY-PERC       TO WS-60-PERC-COMP-Z            
              MOVE WS-90-DAY-PERC       TO WS-90-PERC-COMP-Z            
              MOVE WS-SEC-PERC          TO WS-SEC-PERC-COMP-Z           
              MOVE WS-RISK-PERC         TO WS-RISK-PERC-COMP-Z          
      *                                                                         
           MOVE WS-FOOTER1-COMP        TO PRNTFILE-DATA                 
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 2 LINES                                
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA             
           ADD 1                           TO WS-RPT1-LINE-NO           
      *                                                                         
           MOVE WS-FOOTER2-COMP            TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
      *                                                                         
           MOVE SPACES                     TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE                                 
      *                                                                         
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
      *                                                                         
           MOVE ZEROS                        TO PRNTFILE-DATA           
                                              WS-CURRENT-AMOUNT-COMP    
                                              WS-CURRENT-AMOUNT-COMP-Z  
                                              WS-30-DAY-AMOUNT-COMP     
                                              WS-30-DAY-AMOUNT-COMP-Z   
                                              WS-60-DAY-AMOUNT-COMP     
                                              WS-60-DAY-AMOUNT-COMP-Z   
                                              WS-90-DAY-AMOUNT-COMP     
                                              WS-90-DAY-AMOUNT-COMP-Z   
                                              WS-SEC-AMOUNT-COMP        
                                              WS-SEC-AMOUNT-COMP-Z      
                                              WS-TOTAL-AMOUNT-COMP      
                                              WS-TOTAL-AMOUNT-COMP-Z    
                                              WS-RISK-AMOUNT-COMP       
                                              WS-RISK-AMOUNT-COMP-Z     
                                              WS-00-COUNT-COMP          
                                              WS-00-COUNT-COMP-Z        
                                              WS-30-COUNT-COMP          
                                              WS-30-COUNT-COMP-Z        
                                              WS-60-COUNT-COMP          
                                              WS-60-COUNT-COMP-Z        
                                              WS-90-COUNT-COMP          
                                              WS-90-COUNT-COMP-Z        
                                              WS-RISK-COUNT-COMP        
                                              WS-RISK-COUNT-COMP-Z      
                                              WS-SEC-COUNT-COMP         
                                              WS-SEC-COUNT-COMP-Z       
                                              WS-TOTAL-COUNT-COMP       
                                              WS-TOTAL-COUNT-COMP-Z     
                                              WS-30-PERC-COMP-Z         
                                              WS-60-PERC-COMP-Z         
                                              WS-90-PERC-COMP-Z         
                                              WS-SEC-PERC-COMP-Z        
                                              WS-RISK-PERC-COMP-Z       
                                              WS-30-DAY-PERC            
                                              WS-60-DAY-PERC            
                                              WS-90-DAY-PERC            
                                              WS-SEC-PERC               
                                              WS-RISK-PERC.             
           ADD 1                           TO WS-RPT1-LINE-NO.          
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *       9000-TERMINATE                                           *        
      *                                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
           OPEN INPUT  FIOCA808-FILE.                                   
           CLOSE PRNTFILE.                                              
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP808 **'      
              DISPLAY '**   PARA 9000-TERMINATE                **'      
              DISPLAY '**  ERROR DURING CLOSE OF FILES         **'      
              DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
              DISPLAY '**   PROCESSING TERMINATED              **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    9900-ABEND                                              **          
      ****************************************************************          
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           MOVE 12                     TO RETURN-CODE.                  
           MOVE 'YES'                  TO WS-ABEND-SWITCH.              
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
      *                                                                         
