       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP805.                                            
       DATE-WRITTEN. JUNE 2003.                                         
       DATE-COMPILED.                                                   
      *                                                                 00050002
      ******************************************************************00060002
      *                                                                *00070002
      *      PROGRAM MODIFICATION LOG                                  *00080002
      *                                                                *00090002
      *     DATE     USER ID  REASON                                   *00100002
      *   --------   -------  ---------------------------------------- *00110002
      *   06/26/03   SM19366  INITIAL CODING                           *00120002
      *   08/28/03   SM19366  CHANGE REPORT CRITERIA                   *00120002
T35434*   05/24/07   MC95456  REPLACED CSS_MODEL_SQL WITH SET STATEMENT*        
T35434*              ADDED FOR FETCH ONLY WITH UR TO THE CURSOR TO *            
T35434*              AVOID -911.                                       *        
A03303*   08/31/11   FIXED FACTOR PRECISION CHANGES                    *        
A03303*              FROM 4 TO 6 DECIMAL                               *        
A03303*              POINTS FORINDUSTRIAL BILLING.                     *        
      *                                                                *        
A05154* 15 JAN 2015  RF10596   CLEAN UP PROGRAM                        *        
      *                                                                *        
      ******************************************************************00130002
      *                                                                 00140002
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00200002
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FIOCA805-FILE   ASSIGN TO UT-S-FIOCA805               
               FILE STATUS IS WS-F805-STATUS.                           
           SELECT PRNTFILE ASSIGN TO UT-S-PRNTFILE.                     
      *                                                                 00240002
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FIOCA805-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY FIOCA805.                                                   00261036
      *                                                                 00270035
       FD PRNTFILE                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01 PRNTFILE-RECORD.                                              
          05 PRNTFILE-CC              PIC X(01).                        
          05 PRNTFILE-DATA            PIC X(132).                       
                                                                        
HPCCDM*EJECT                                                            00370002
                                                                        
      *                                                                 00390002
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP805'.
MSQ017     COPY MFASQLM.
      *                                                                 00410002
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP805 STARTS HERE'.                  
      *                                                                 00440002
       01 COMP-CODE                      PIC S9(4) COMP VALUE +0.       
      *                                                                 00460002
       01 WORK-AREAS.                                                   
          05 WS-EOF-SW                     PIC X(01) VALUE SPACES.      
             88  END-OF-FILE                         VALUE 'Y'.         
          05 WS-F805-STATUS                PIC X(02) VALUE '  '.        
             88 F805-SUCCESSFUL                      VALUE '00'.        
             88 F805-READ-OK                         VALUE '00' '04'.   
             88 END-OF-FCA805                     VALUE '10'.           
          05 SQL-ERROR-SW                PIC 9(01) VALUE 0.             
             88 SQL-ERROR                          VALUE 1.             
          05 WS-ACCT-EOF-SW              PIC 9(01) VALUE 0.             
             88 END-OF-ACCT                        VALUE 1.             
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-RPT1-PAGE-NO             PIC 9(04) VALUE ZERO.          
          05 WS-PROGRAM                  PIC X(08) VALUE 'PCSRP805'.    
          05 WS-ACCOUNT-NO               PIC 9(13).                     
COB305    05 WS-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
          05 WS-CURRENT-DT               PIC X(10) VALUE SPACES.        
          05 WS-CURR-DT                  PIC X(10) VALUE SPACES.        
          05 WS-HOLD-DT.                                                
             10 WS-HOLD-YR               PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-MO               PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-DY               PIC X(02) VALUE SPACES.        
          05 WS-COMPANY-NAME             PIC X(26) VALUE SPACES.        
          05 WS-CURRENT-TIMESTAMP        PIC X(26).                     
          05 FILLER REDEFINES WS-CURRENT-TIMESTAMP.                     
             10 WS-PROGRAM-RUN-DATE      PIC X(10).                     
             10 FILLER                   PIC X(01).                     
             10 WS-PROGRAM-RUN-TIME      PIC X(08).                     
             10 FILLER                   PIC X(07).                     
      *                                                                 00970002
       01 WS-PRINTER-CONTROL.                                           
          05 WS-RPT1-LINE-NO             PIC 9(02) VALUE ZERO.          
          05 WS-52                       PIC 9(02) VALUE 52.            
      *                                                                 01010002
       01 WS-HEADER-1.                                                  
          05 FILLER                      PIC X(08) VALUE 'PCSR8051'.    
          05 FILLER                      PIC X(45) VALUE SPACES.        
          05 WS-RPRT-COMPANY             PIC X(26) VALUE SPACES.        
          05 FILLER                      PIC X(03) VALUE 'FOR'.         
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RPRT-EXP-MONTH           PIC X(10) VALUE SPACES.        
          05 FILLER                      PIC X(17) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE 'RUN DATE:'.   
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RPRT-DATE                PIC X(10) VALUE SPACES.        
      *                                                                 01100002
       01 WS-HEADER-2.                                                  
          05 FILLER                      PIC X(51) VALUE SPACES.        
          05 FILLER                      PIC X(36) VALUE                
             'FIXED FACTOR EXPIRATION DATE REPORT'.                     
          05 FILLER                      PIC X(24) VALUE SPACES.        
          05 FILLER                      PIC X(09) VALUE 'RUN TIME:'.   
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-RPRT-TIME                PIC X(08) VALUE SPACES.        
      *                                                                 01190002
       01 WS-HEADER-3.                                                  
          05 FILLER                      PIC X(61) VALUE SPACES.        
          05 WS-RPRT-MONTH               PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-DAY                 PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(01) VALUE '/'.           
          05 WS-RPRT-YR                  PIC X(04) VALUE SPACES.        
          05 FILLER                      PIC X(44) VALUE SPACES.        
          05 FILLER                      PIC X(05) VALUE 'PAGE:'.       
          05 FILLER                      PIC X(08) VALUE SPACES.        
          05 WS-RPRT-PAGE-NO             PIC ZZZ9.                      
      *                                                                 01411050
       01 WS-HEADER-4.                                                  
          05 FILLER                  PIC X(02) VALUE SPACES.            
          05 FILLER                  PIC X(10) VALUE 'ACCOUNT NO'.      
          05 FILLER                  PIC X(06) VALUE SPACES.            
          05 FILLER                  PIC X(05) VALUE 'IC-NO'.           
          05 FILLER                  PIC X(04) VALUE SPACES.            
          05 FILLER                  PIC X(09) VALUE 'UTIL-TYPE'.       
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(09) VALUE 'RATE PLAN'.       
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(09) VALUE 'FACTOR ID'.       
          05 FILLER                  PIC X(12) VALUE SPACES.            
          05 FILLER                  PIC X(06) VALUE 'FACTOR'.          
          05 FILLER                  PIC X(11) VALUE SPACES.            
          05 FILLER                  PIC X(10) VALUE 'START DATE'.      
          05 FILLER                  PIC X(06) VALUE SPACES.            
          05 FILLER                  PIC X(08) VALUE 'END DATE'.        
          05 FILLER                  PIC X(15) VALUE SPACES.            
      *                                                                 01421002
       01 WS-HEADER-EQUALS.                                             
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 FILLER                      PIC X(53) VALUE                
             '====================================================='.   
          05 FILLER                      PIC X(53) VALUE                
             '====================================================='.   
          05 FILLER                      PIC X(09) VALUE                
             '========='.                                               
          05 FILLER                  PIC X(15) VALUE SPACES.            
      *                                                                 01421002
       01 WS-HEADER-SPACES.                                             
          05 FILLER                      PIC X(132) VALUE SPACES.       
      *                                                                 01421002
       01 WS-DETAIL-1.                                                  
          05 WS-ACCOUNT-NO-RPT           PIC 9(13).                     
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-IC-NO                    PIC 9(02).                     
          05 FILLER                      PIC X(10) VALUE SPACES.        
          05 WS-UTIL-TYPE                PIC X(01).                     
          05 FILLER                      PIC X(12) VALUE SPACES.        
          05 WS-RATE-PLAN                PIC X(03) VALUE SPACES.        
          05 FILLER                      PIC X(08) VALUE SPACES.        
          05 WS-FACTOR-ID                PIC X(09).                     
          05 FILLER                      PIC X(05) VALUE SPACES.        
A03303    05 WS-FACTOR                   PIC 99999999999.999999.        
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-FROM-DATE                PIC X(10).                     
          05 FILLER                      PIC X(05) VALUE SPACES.        
          05 WS-TO-DATE                  PIC X(10).                     
          05 FILLER                      PIC X(15) VALUE SPACES.        
      *                                                                 01850002
       01 WS-NO-DATA-LINE.                                              
          05  FILLER                     PIC X(55) VALUE SPACES.        
          05  FILLER                     PIC X(22) VALUE                
                    '** NO DATA THIS RUN **'.                           
          05  FILLER                     PIC X(55) VALUE SPACES.        
      *                                                                 01910002
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PCSRP805 ENDS HERE'.                    
      *                                                                 01940002
           EXEC SQL                                                     01950002
             INCLUDE SQLCA                                              01960002
           END-EXEC.                                                    01970002
      *                                                                 01940002
      * CSS_JOB_PARM TABLE                                              02140002
           EXEC SQL                                                     02150002
             INCLUDE TBJBPARM                                           02160002
           END-EXEC.                                                    02170002
      *                                                                 02175007
       COPY CWS00010.                                                   02391002
       COPY CWS09900.                                                   02392002
       COPY CWS00303.                                                   02393002
      *                                                                 02394002
       LINKAGE SECTION.                                                 
       01 WS-PARM-VALUE.                                                
          05 WS-PARMVAL-LENGTH           PIC S9(04) COMP.               
          05 WS-PARM-COMPANY             PIC X(02).                     
      *                                                                 02399002
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ******************************************************************02410002
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *02420002
      ******************************************************************02430002
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE.                                     
      *                                                                 02460002
           MOVE WS-CURRENT-DT              TO WS-HOLD-DT.               
           MOVE WS-HOLD-MO                 TO WS-RPRT-MONTH.            
           MOVE WS-HOLD-DY                 TO WS-RPRT-DAY.              
           MOVE WS-HOLD-YR                 TO WS-RPRT-YR.               
           PERFORM 0140-DETERMINE-EXP-MONTH THRU 0140-EXIT.             
           MOVE WS-52                      TO WS-RPT1-LINE-NO.          
      *                                                                 02520002
           PERFORM 0020-READ-FCSCA805 THRU 0020-EXIT.                   
           IF END-OF-FCA805                                             
              PERFORM 8000-PRINT-HEADER    THRU 8000-EXIT               
              MOVE SPACES                  TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
              MOVE WS-NO-DATA-LINE         TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
      *                                                                 02640002
           PERFORM UNTIL END-OF-FCA805                                  
              PERFORM 2000-PROCESS-ACCT    THRU 2000-EXIT               
           END-PERFORM.                                                 
      *                                                                 02690002
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
           STOP RUN.                                                    
      *                                                                 02720002
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02740137
       0020-READ-FCSCA805.                                              
      *                                                                 02740337
           READ FIOCA805-FILE AT END                                    
               GO TO 0020-EXIT.                                         
      *                                                                 02740637
           IF F805-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 0020-READ-FCSCA805             '             
               DISPLAY '** ERROR READING FCA805'                        
               DISPLAY '** FILE STATUS = ' WS-F805-STATUS               
               DISPLAY '******************************************'     
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 02742764
                                                                        
       0020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02750002
      *                                                                *02760002
      *      OPEN OUTPUT FILE PRNTFILE.                                *02770002
      *                                                                *02780002
      ******************************************************************02790002
       0100-INITIALIZE.                                                 
           MOVE 0                          TO WS-ACCT-EOF-SW.           
           OPEN INPUT  FIOCA805-FILE.                                   
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                 02870002
           PERFORM 0110-GET-CURR-DATE      THRU 0110-EXIT.              
           PERFORM 0120-GET-COMPANY        THRU 0120-EXIT.              
           MOVE WS-COMPANY-NAME            TO WS-RPRT-COMPANY.          
           PERFORM 0130-GET-TIMESTAMP      THRU 0130-EXIT.              
           MOVE WS-PROGRAM-RUN-DATE        TO WS-RPRT-DATE.             
           MOVE WS-PROGRAM-RUN-TIME        TO WS-RPRT-TIME.             
      *                                                                 02940002
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02970002
      ******************************************************************02982002
      *                                                                *02990002
      *       0110-GET-CURR-DATE.                                      *03000002
      *                                                                *03010002
      ******************************************************************03020002
       0110-GET-CURR-DATE.                                              
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,10,10)                            
                    ,CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() 
           AS DATE),'USA')                             
                INTO :WS-CURRENT-DT                                     
                    ,:WS-CURR-DT                                        
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = 'COMMON'                            
                AND  COMPANY_NO     = '01'                              
                AND  CMND_CODE      = 'DATE'                            
                AND  SEQ_NO         = 10                                
                AND  STATUS         = 'A'                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     03040002
MFA-TR*       SELECT SUBSTR(PARM_DATA,10,10)                            03050002
MFA-TR*             ,CHAR(CURRENT DATE,USA)                             03060002
MFA-TR*         INTO :WS-CURRENT-DT                                     03070002
MFA-TR*             ,:WS-CURR-DT                                        03080002
MFA-TR*         FROM CSS_JOB_PARM                                       03090002
MFA-TR*       WHERE  PROGRAM_NAME = 'COMMON'                            03100002
MFA-TR*         AND  COMPANY_NO     = '01'                              03110002
MFA-TR*         AND  CMND_CODE      = 'DATE'                            03120002
MFA-TR*         AND  SEQ_NO         = 10                                03130002
MFA-TR*         AND  STATUS         = 'A'                               03140002
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    03150002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03160002
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 03180002
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP805 **'      
              DISPLAY '** PARA 0110-GET-CURR-DATE              **'      
              DISPLAY '** ERROR DURING SELECT OF DATE          **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 03290002
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03320002
      ******************************************************************03330002
      *                                                                *03340002
      *       0120-GET-COMPANY.                                        *03350002
      *                                                                *03360002
      ******************************************************************03370002
       0120-GET-COMPANY.                                                
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
              WHERE  COMPANY_NO = :WS-PARM-COMPANY                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03390002
MFA-TR*       SELECT COMPANY_NAME                                       03400002
MFA-TR*         INTO :WS-COMPANY-NAME                                   03410002
MFA-TR*         FROM CSS_COMPANY                                        03420002
MFA-TR*       WHERE  COMPANY_NO = :WS-PARM-COMPANY                      03430002
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    03440002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03450002
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 03470002
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP805 **'      
              DISPLAY '** PARA 0120-GET-COMPANY                **'      
              DISPLAY '** ERROR DURING SELECT OF COMPANY NAME  **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 03580002
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03610002
      ******************************************************************03620002
      *                                                                *03630002
      *       0130-GET-TIMESTAMP                                       *03640002
      *                                                                *03650002
      ******************************************************************03660002
       0130-GET-TIMESTAMP.                                              
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03680002
MFA-TR*         SET  :WS-CURRENT-TIMESTAMP   =  CURRENT TIMESTAMP               
MFA-TR*    END-EXEC.                                                    03720002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP805 **'      
              DISPLAY '** PARA 0130-GET-TIMESTAMP              **'      
T35434        DISPLAY '** ERROR DURING SETTING OF TIMESTAMP    **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 03850002
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03880063
      ******************************************************************03620002
      *                                                                *03630002
      *       0140-DETERMINE-EXP-MONTH.                                *03640002
      *                                                                *03650002
      ******************************************************************03660002
       0140-DETERMINE-EXP-MONTH.                                        
           IF WS-RPRT-MONTH EQUAL '01'                                  
              MOVE 'FEBRUARY ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '02'                             
              MOVE 'MARCH    ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '03'                             
              MOVE 'APRIL    ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '04'                             
              MOVE 'MAY      ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '05'                             
              MOVE 'JUNE     ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '06'                             
              MOVE 'JULY     ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '07'                             
              MOVE 'AUGUST   ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '08'                             
              MOVE 'SEPTEMBER' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '09'                             
              MOVE 'OCTOBER  ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '10'                             
              MOVE 'NOVEMBER ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '11'                             
              MOVE 'DECEMBER ' TO WS-RPRT-EXP-MONTH                     
           ELSE IF WS-RPRT-MONTH EQUAL '12'                             
              MOVE 'JANUARY  ' TO WS-RPRT-EXP-MONTH                     
           END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
                END-IF
           END-IF.                                                      
      *                                                                 03850002
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03880063
      ******************************************************************03899464
      *                                                                *03900002
      *       2000-PROCESS-ACCT                                        *03910002
      *                                                                *03920002
      ******************************************************************03930002
       2000-PROCESS-ACCT.                                               
      *                                                                 04030002
           MOVE E-FCA805-ACCOUNT-NO           TO WS-ACCOUNT-NO-RPT.     
           MOVE E-FCA805-EFF-DATE-FR          TO WS-FROM-DATE.          
           MOVE E-FCA805-EFF-DATE-TO          TO WS-TO-DATE.            
           MOVE E-FCA805-FACTOR-ID            TO WS-FACTOR-ID.          
           MOVE E-FCA805-FACTOR               TO WS-FACTOR.             
           MOVE E-FCA805-RATE-PLAN            TO WS-RATE-PLAN.          
           MOVE E-FCA805-IC-NO                TO WS-IC-NO.              
           MOVE E-FCA805-UTIL-TYPE            TO WS-UTIL-TYPE.          
           PERFORM 0020-READ-FCSCA805 THRU 0020-EXIT                    
      *                                                                 04049672
           PERFORM 8500-PRINT-DETAIL       THRU 8500-EXIT.              
      *                                                                 04050066
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04320002
      ***************************************************************** 05810002
      *                                                               * 05820002
      *            8000-PRINT-HEADER                                  * 05830002
      *             PRINTS THE REPORT HEADER                          * 05840002
      *                                                               * 05850002
      ***************************************************************** 05860002
       8000-PRINT-HEADER.                                               
           MOVE ZEROES                     TO WS-RPT1-LINE-NO.          
           MOVE WS-HEADER-1                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                 05920002
           MOVE WS-HEADER-2                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 05960002
           ADD 1                           TO WS-RPT1-PAGE-NO.          
           MOVE WS-RPT1-PAGE-NO            TO WS-RPRT-PAGE-NO.          
           MOVE WS-HEADER-3                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06020002
           MOVE SPACES                     TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-4                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-EQUALS           TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-SPACES           TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           ADD 6                           TO WS-RPT1-LINE-NO.          
      *                                                                 06160002
       8000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 06190002
      *                                                               * 06200002
      *            8500-PRINT-DETAIL                                  * 06210002
      *   PRINTS DETAIL LINE                                          * 06220002
      *                                                               * 06230002
      ***************************************************************** 06240002
       8500-PRINT-DETAIL.                                               
           IF WS-RPT1-LINE-NO NOT < WS-52                               
              PERFORM 8000-PRINT-HEADER          THRU 8000-EXIT         
           END-IF.                                                      
      *                                                                 06543030
           MOVE WS-DETAIL-1            TO PRNTFILE-DATA.                
            WRITE PRNTFILE-RECORD                                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06580002
           MOVE ZEROES                     TO PRNTFILE-DATA.            
              ADD 1                       TO WS-RPT1-LINE-NO.           
      *                                                                 06600002
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07020002
      ******************************************************************07030002
      *                                                                *07040002
      *       9000-TERMINATE                                           *07050002
      *                                                                *07060002
      ******************************************************************07070002
       9000-TERMINATE.                                                  
           OPEN INPUT  FIOCA805-FILE.                                   
           CLOSE PRNTFILE.                                              
      *                                                                 07140002
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP805 **'      
              DISPLAY '**   PARA 9000-TERMINATE                **'      
              DISPLAY '**  ERROR DURING CLOSE OF FILES         **'      
              DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
              DISPLAY '**   PROCESSING TERMINATED              **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 07270002
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07300002
      ****************************************************************  07310002
      **    9900-ABEND                                              **  07320002
      ****************************************************************  07330002
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           MOVE 12                     TO RETURN-CODE.                  
           MOVE 'YES'                  TO WS-ABEND-SWITCH.              
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
      *                                                                 07420002
