       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSRP789.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. MAR 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **        REGULATED GROUP 2 RATE PLAN MOVEMENT REPORT           **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES THE SEB789 REPORT FOR THE REGULATED   **        
      **   GROUP 2 RATE PLAN MOVEMENT.THIS IS A NEW REPORT REQUIREMENT**        
      **   FOR THE SEB RATE RE-ENGINEERING PROJECT.                   **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 03/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FIOCA789-FILE   ASSIGN TO UT-S-FIOCA789               
               FILE STATUS IS WS-F789-STATUS.                           
                                                                        
           SELECT GRPMVMNT-FILE   ASSIGN TO UT-S-GRPMVMNT               
               FILE STATUS IS WS-GRPMNT-STATUS.                         
                                                                        
           SELECT PRNTFILE        ASSIGN TO UT-S-PRNTFILE.              
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FIOCA789-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR INPUT FILE FIOCA789            *          
      ****************************************************************          
      *                                                                         
       01  FIOCA789.                                                    
         02  E-FCA789-DATA-REC.                                         
           05  E-FCA789-ACCOUNT-NO          PIC 9(13).                  
           05  E-FCA789-OPTION-CODE         PIC X(12).                  
           05  E-FCA789-OPT-DESC            PIC X(50).                  
           05  E-FCA789-SORT-GRP-CD         PIC X(01).                  
           05  E-FCA789-SORT-GRP-ORD-CD     PIC X(03).                  
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
      *                                                                         
       FD  GRPMVMNT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR INPUT FILE GRPMVMNT            *          
      ****************************************************************          
      *                                                                         
       01  GRPMVMNT.                                                    
         02  E-GRPMNT-DATA-REC.                                         
           05  E-GRPMNT-ACCOUNT-NO          PIC 9(13).                  
           05  E-GRPMNT-OPTION-CODE         PIC X(12).                  
           05  E-GRPMNT-OPT-DESC            PIC X(50).                  
           05  E-GRPMNT-AGR-SRC-CD          PIC X(03).                  
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
      *                                                                         
       FD  PRNTFILE                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 104 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  PRNTFILE-RECORD                  PIC X(104).                 
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP789'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40)    VALUE          
           'WORKING STORAGE FOR PCSRP789 STARTS HERE'.                  
      *                                                                         
       01 COMP-CODE                         PIC S9(4) COMP VALUE +0.    
       01 WS-DAY                            PIC S9(4) COMP VALUE +0.    
      *                                                                         
       01 WORK-AREAS.                                                   
          05 PROGRAM-NAME                   PIC X(08) VALUE 'PCSRP789'. 
          05 WS-PGRMNAME                    PIC X(08) VALUE 'PCSRP789'. 
          05 WS-EOF-SW                      PIC X(01) VALUE SPACES.     
             88  END-OF-FILE                          VALUE 'Y'.        
          05 WS-F789-STATUS                 PIC X(02) VALUE '  '.       
             88 F789-SUCCESSFUL                       VALUE '00'.       
             88 F789-READ-OK                          VALUE '00' '04'.  
             88 END-OF-FCA789                         VALUE '10'.       
          05 WS-GRPMNT-STATUS               PIC X(02) VALUE '  '.       
             88 GRPMNT-SUCCESSFUL                     VALUE '00'.       
             88 GRPMNT-READ-OK                        VALUE '00' '04'.  
             88 END-OF-GRPMNT                         VALUE '10'.       
          05 WS-HEADER-1-SW                 PIC X(01) VALUE SPACES.     
             88 HEADER-1-YES                          VALUE 'Y'.        
             88 HEADER-1-NO                           VALUE 'N'.        
          05 WS-HEADER-2-SW                 PIC X(01) VALUE SPACES.     
             88 HEADER-2-YES                          VALUE 'Y'.        
             88 HEADER-2-NO                           VALUE 'N'.        
          05 WS-HLD-SORT-GRP-CD             PIC X(01).                  
          05 WS-HLD-SORT-GRP-ORD-CD         PIC X(03).                  
          05 WS-HLD-OPTION-CODE             PIC X(12).                  
          05 WS-HLD-OPTION-DESC             PIC X(50).                  
          05 WS-HLD-AGR-SRC-CD              PIC X(03).                  
          05 WS-OPTION-CODE-COUNT           PIC 9(07).                  
          05 WS-SUB-TOTAL-COUNT             PIC 9(07).                  
          05 WS-TOTAL-COUNT                 PIC 9(07).                  
          05 WS-GRAND-TOTAL-COUNT           PIC 9(07).                  
          05 WS-GRPMVMNT-CNT                PIC 9(07).                  
          05 WS-COMPANY-NAME                PIC X(26) VALUE SPACES.     
          05 WS-CURRENT-TIMESTAMP           PIC X(26).                  
          05 FILLER REDEFINES WS-CURRENT-TIMESTAMP.                     
             10 WS-PROGRAM-RUN-DATE         PIC X(10).                  
             10 FILLER                      PIC X(01).                  
             10 WS-PROGRAM-RUN-TIME         PIC X(08).                  
             10 FILLER                      PIC X(07).                  
          05 WS-SUBJECT.                                                
             10 FILLER                      PIC X(13) VALUE             
                                                      'SEBC 789 FOR '.  
             10 WS-SUB-DATE                 PIC X(10).                  
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-HDR-AUTOMATED               PIC X(19) VALUE             
                                      'AUTOMATED MOVEMENT '.            
          05 WS-HDR-FP-RENEWAL              PIC X(19) VALUE             
                                      'FIXED PRICE RENEWAL'.            
          05 WS-HDR-MANUAL                  PIC X(19) VALUE             
                                      'MANUAL MOVEMENT    '.            
          05 WS-HDR-H-MOVE                  PIC X(24) VALUE             
                                      'GROUP2 $10.95 MOVED TO  '.       
          05 WS-HDR-M-MOVE                  PIC X(24) VALUE             
                                      'GROUP2  $8.95 MOVED TO  '.       
          05 WS-HDR-L-MOVE                  PIC X(24) VALUE             
                                      'GROUP2  $6.95 MOVED TO  '.       
          05 WS-TOT-H-MOVE                  PIC X(31) VALUE             
                                      'TOTAL MOVED FROM $10.95        '.
          05 WS-TOT-M-MOVE                  PIC X(31) VALUE             
                                      'TOTAL MOVED FROM  $8.95        '.
          05 WS-TOT-L-MOVE                  PIC X(31) VALUE             
                                      'TOTAL MOVED FROM  $6.95        '.
          05 WS-HDR-1T2-MOVE                PIC X(24) VALUE             
                                      'GROUP1 TO GROUP2        '.       
          05 WS-HDR-12S-MOVE                PIC X(24) VALUE             
                                      'GROUP1 AGL SNR TO GROUP2'.       
          05 WS-HDR-2T1-MOVE                PIC X(24) VALUE             
                                      'GROUP2 TO GROUP1        '.       
          05 WS-HDR-21S-MOVE                PIC X(24) VALUE             
                                      'GROUP2 AGL SNR TO GROUP1'.       
          05 WS-TOT-1T2-MOVE                PIC X(31) VALUE             
                                      'TOTAL MOVED FROM GROUP1        '.
          05 WS-TOT-12S-MOVE                PIC X(31) VALUE             
                                      'TOTAL MOVED FROM GROUP1 AGL SNR'.
          05 WS-TOT-2T1-MOVE                PIC X(31) VALUE             
                                      'TOTAL MOVED FROM GROUP2        '.
          05 WS-TOT-21S-MOVE                PIC X(31) VALUE             
                                      'TOTAL MOVED FROM GROUP2 AGL SNR'.
      *                                                                         
       01 WS-RUN-DATE.                                                  
          05 WS-RD-MM                       PIC X(02).                  
          05 FILLER                         PIC X(01) VALUE '/'.        
          05 WS-RD-DD                       PIC X(02).                  
          05 FILLER                         PIC X(01) VALUE '/'.        
          05 WS-RD-YY                       PIC X(02).                  
      *                                                                         
       01 WS-HEADER-1.                                                  
          05 FILLER                         PIC X(08) VALUE 'PCSRP789'. 
          05 FILLER                         PIC X(03) VALUE '-01'.      
          05 FILLER                         PIC X(31) VALUE SPACES.     
          05 WS-RPRT-COMPANY                PIC X(26) VALUE SPACES.     
          05 FILLER                         PIC X(15) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'RUN DATE:'.
          05 FILLER                         PIC X(02) VALUE SPACES.     
          05 WS-RPRT-DATE                   PIC X(10) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-2.                                                  
          05 FILLER                         PIC X(18) VALUE SPACES.     
          05 FILLER                         PIC X(54) VALUE             
            'REGULATED GROUP MOVEMENT REPORT FOR CALENDER MONTH OF '.   
          05 WS-CALENDER-MNTH               PIC X(02) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE '/'.        
          05 WS-CALENDER-YEAR               PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'RUN TIME:'.
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 WS-RPRT-TIME                   PIC X(08) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-3.                                                  
          05 WS-MOVEMENT-TYPE               PIC X(19) VALUE SPACES.     
          05 FILLER                         PIC X(85) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-4.                                                  
          05 WS-MOVMENT-LEVEL               PIC X(24) VALUE SPACES.     
          05 FILLER                         PIC X(82) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-5.                                                  
          05 FILLER                         PIC X(47) VALUE SPACES.     
          05 FILLER                         PIC X(06) VALUE 'OPTION'.   
          05 FILLER                         PIC X(01) VALUE '-'.        
          05 FILLER                         PIC X(11) VALUE             
                                                       'DESCRIPTION'.   
          05 FILLER                         PIC X(34) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE 'COUNT'.    
      *                                                                         
       01 WS-DETAIL-1.                                                  
          05 FILLER                         PIC X(23) VALUE SPACES.     
          05 WS-DET-OPTION-CODE             PIC X(12) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE '-'.        
          05 WS-DET-OPTION-DESC             PIC X(50) VALUE SPACES.     
          05 FILLER                         PIC X(11) VALUE SPACES.     
          05 WS-DET-COUNT                   PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-DETAIL-SUB-TOTAL.                                          
          05 FILLER                         PIC X(13) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'SUB-TOTAL'.
          05 FILLER                         PIC X(75) VALUE SPACES.     
          05 WS-DET-SUB-TOTAL-CNT           PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-DETAIL-TOTAL.                                              
          05 FILLER                         PIC X(17) VALUE SPACES.     
          05 WS-DET-TOTAL-LEVEL             PIC X(31) VALUE SPACES.     
          05 FILLER                         PIC X(49) VALUE SPACES.     
          05 WS-DET-TOTAL-CNT               PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-DETAIL-GRAND-TOTAL.                                        
          05 FILLER                         PIC X(11) VALUE SPACES.     
          05 FILLER                         PIC X(11) VALUE             
                                                'GRAND-TOTAL'.          
          05 FILLER                         PIC X(75) VALUE SPACES.     
          05 WS-DET-GRAND-TOT-CNT           PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-FOOTER-NOTE.                                               
          05 FILLER                         PIC X(37) VALUE             
            '**THE REPORT COUNTS REFLECT ONLY THE '.                    
          05 FILLER                         PIC X(38) VALUE             
            'LATEST MOVEMENT FOR THE CALENDER MONTH'.                   
          05 FILLER                         PIC X(29) VALUE SPACES.     
      *                                                                         
       01 WS-DASHES.                                                    
          05 FILLER                         PIC X(104) VALUE ALL '-'.   
      *                                                                         
       01 WS-EQUALS.                                                    
          05 FILLER                         PIC X(104) VALUE ALL '='.   
      *                                                                         
       01 WS-STARS.                                                     
          05 FILLER                         PIC X(104) VALUE ALL '*'.   
      *                                                                         
       01 WS-BLANK-LINE-104                 PIC X(104) VALUE SPACES.    
      *                                                                         
       01 MAILHEAD-1.                                                   
          05 FILLER                         PIC X(22) VALUE             
               'HELO DOMAIN:     SCANA'.                                
      *                                                                         
       01 MAILHEAD-2.                                                   
          05 FILLER                         PIC X(14) VALUE             
               'MAIL FROM:   <'.                                        
          05 MAIL2-JOB-NAME                 PIC X(07).                  
          05 FILLER                         PIC X(20) VALUE             
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01 MAILHEAD-3.                                                   
          05 FILLER                         PIC X(38) VALUE             
               'RCPT TO: <SEBREGGRP2MVNTRPT@SCANA.COM>'.                
      *                                                                         
       01 MAILHEAD-4.                                                   
          05 FILLER                         PIC X(04) VALUE             
               'DATA'.                                                  
      *                                                                         
       01 MAILHEAD-5.                                                   
          05 FILLER                         PIC X(18) VALUE             
               'FROM: CSR PAGING <'.                                    
          05 MAIL5-JOB-NAME                 PIC X(07).                  
          05 FILLER                         PIC X(20) VALUE             
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01 MAILHEAD-6.                                                   
          05 FILLER                         PIC X(33) VALUE             
               'TO: <SEBREGGRP2MVNTRPT@SCANA.COM>'.                     
      *                                                                         
       01 MAILHEAD-7.                                                   
          05 FILLER                         PIC X(10) VALUE             
               'SUBJECT:  '.                                            
          05 MAIL7-SUBJECT                  PIC X(30).                  
      *                                                                         
       01 MAILHEAD-8.                                                   
          05 FILLER                         PIC X(80) VALUE SPACES.     
      *                                                                         
       01 WS-NO-DATA-LINE.                                              
          05 FILLER                         PIC X(37) VALUE SPACES.     
          05 FILLER                         PIC X(22) VALUE             
                    '** NO DATA THIS RUN **'.                           
          05 FILLER                         PIC X(45) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
      *                                                                         
       01 WS-END                            PIC X(38) VALUE             
           'WORKING STORAGE FOR PCSRP789 ENDS HERE'.                    
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * FCA00-KEY                                                               
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
                                                                        
      * IO AREA FOR PARM INPUT FILE 'A'                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
      * FCA00 MISC INPUT                                                        
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_COMPANY TABLE                                                       
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM TABLE                                                      
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **  0000-MAILINE.                                               **        
      **  CONTROLS THE MAIN PROCESSING OF THE PROGRAM.                **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE.                                     
      *                                                                         
           PERFORM UNTIL END-OF-FCA789                                  
              MOVE E-FCA789-SORT-GRP-CD    TO WS-HLD-SORT-GRP-CD        
              PERFORM 2000-PROCESS-RECORDS THRU 2000-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 0200-RE-INITIALIZE      THRU 0200-EXIT.              
                                                                        
           PERFORM UNTIL END-OF-GRPMNT                                  
              MOVE E-GRPMNT-AGR-SRC-CD     TO WS-HLD-AGR-SRC-CD         
              PERFORM 2100-PROCESS-RECORDS THRU 2100-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           IF WS-GRPMVMNT-CNT > 0 AND WS-GRAND-TOTAL-COUNT > 0          
              PERFORM 3350-MANUAL-GRAND-TOTAL THRU 3350-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
           WRITE PRNTFILE-RECORD           FROM WS-BLANK-LINE-104.      
           WRITE PRNTFILE-RECORD           FROM WS-FOOTER-NOTE.         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZE.                                            **        
      **  PROGRAM INITIALIZATION.                                     **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE ZEROES                     TO WS-OPTION-CODE-COUNT      
                                              WS-SUB-TOTAL-COUNT        
                                              WS-TOTAL-COUNT            
                                              WS-GRPMVMNT-CNT           
                                              WS-GRAND-TOTAL-COUNT.     
                                                                        
           MOVE SPACES                     TO WS-HLD-SORT-GRP-CD        
                                              WS-HLD-SORT-GRP-ORD-CD    
                                              WS-HLD-OPTION-CODE        
                                              WS-HLD-OPTION-DESC        
                                              WS-HLD-AGR-SRC-CD.        
                                                                        
           SET HEADER-1-YES                TO TRUE.                     
           SET HEADER-2-YES                TO TRUE.                     
      *                                                                         
           OPEN INPUT  FIOCA789-FILE                                    
                       GRPMVMNT-FILE.                                   
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                         
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN.  
           MOVE 'REPORTDATE'               TO WS-PROGRAM.               
           MOVE WS-DATE                    TO WS-COMMAND.               
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
                  UNTIL INPUT-ACTIVE                                    
                     OR END-OF-SYSIPT.                                  
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**      PCSRP789 PROCESSING ERROR  **'        
                 DISPLAY '**  NO ACTIVE REPORTDATE REVENUE MNTH'        
                 DISPLAY '**        PROCESSING TERMINATED    **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (13:4)                               
                                       TO WS-CALENDER-YEAR              
                 MOVE G6-PARM-DATA (17:2)                               
                                       TO WS-CALENDER-MNTH              
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
      ** GET COMMON DATE FROM THE CSS_JOB_PARM                                  
           MOVE SPACES                     TO WS-SYSIPT                 
           MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN   
           MOVE 'COMMON'                   TO WS-PROGRAM                
           MOVE WS-DATE                    TO WS-COMMAND                
           MOVE ZEROS                      TO WS-SEQUENCE               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY               
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
                   UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
                              OR  END-OF-SYSIPT                         
           IF WS-INPUT-RUN-DATE-MM  NUMERIC AND                         
              WS-INPUT-RUN-DATE-DD  NUMERIC AND                         
              WS-INPUT-RUN-DATE-YY  NUMERIC                             
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'         
              DISPLAY '**  COMMON IS NOT ACTIVE'                        
              DISPLAY '**    KEY = ' E-FJC01-KEY                        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-RUN-DATE-YY       TO WS-RD-YY.                 
           MOVE WS-INPUT-RUN-DATE-MM       TO WS-RD-MM.                 
           MOVE WS-INPUT-RUN-DATE-DD       TO WS-RD-DD.                 
                                                                        
           PERFORM 7100-GET-COMPANY        THRU 7100-EXIT.              
           MOVE WS-COMPANY-NAME            TO WS-RPRT-COMPANY.          
                                                                        
           PERFORM 7200-GET-TIMESTAMP      THRU 7200-EXIT.              
           MOVE WS-PROGRAM-RUN-DATE        TO WS-RPRT-DATE.             
           MOVE WS-PROGRAM-RUN-TIME        TO WS-RPRT-TIME.             
      *                                                                         
           MOVE 'SEBP789'                  TO MAIL2-JOB-NAME            
                                              MAIL5-JOB-NAME.           
           MOVE WS-RUN-DATE                TO WS-SUB-DATE.              
           MOVE WS-SUBJECT                 TO MAIL7-SUBJECT.            
           WRITE PRNTFILE-RECORD FROM MAILHEAD-1.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-2.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-3.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-4.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-5.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-6.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-7.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-8.                       
      *                                                                         
           PERFORM 7000-READ-FCSCA789      THRU 7000-EXIT.              
                                                                        
           PERFORM 7050-READ-GRPMVMNT      THRU 7050-EXIT.              
                                                                        
           PERFORM 8000-PRINT-HEADER       THRU 8000-EXIT.              
                                                                        
           IF END-OF-FCA789 AND END-OF-GRPMNT                           
              WRITE PRNTFILE-RECORD FROM WS-BLANK-LINE-104              
              WRITE PRNTFILE-RECORD FROM WS-NO-DATA-LINE                
           ELSE                                                         
              WRITE PRNTFILE-RECORD FROM WS-HEADER-5                    
              WRITE PRNTFILE-RECORD FROM WS-DASHES                      
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0200-RE-INITIALIZE.                                         **        
      **  PROGRAM INITIALIZATION.                                     **        
      ******************************************************************        
      *                                                                         
       0200-RE-INITIALIZE.                                              
      *                                                                         
           MOVE ZEROES                     TO WS-OPTION-CODE-COUNT      
                                              WS-SUB-TOTAL-COUNT        
                                              WS-TOTAL-COUNT            
                                              WS-GRPMVMNT-CNT           
                                              WS-GRAND-TOTAL-COUNT.     
                                                                        
           MOVE SPACES                     TO WS-HLD-SORT-GRP-CD        
                                              WS-HLD-SORT-GRP-ORD-CD    
                                              WS-HLD-OPTION-CODE        
                                              WS-HLD-OPTION-DESC        
                                              WS-HLD-AGR-SRC-CD.        
                                                                        
           SET HEADER-1-YES                TO TRUE.                     
           SET HEADER-2-YES                TO TRUE.                     
                                                                        
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2000-PROCESS-RECORDS.                                       **        
      **  CONTROL BREAK LOGIC FOR THE REPORT.                         **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-RECORDS.                                            
      *                                                                         
           PERFORM UNTIL E-FCA789-SORT-GRP-CD NOT EQUAL                 
                         WS-HLD-SORT-GRP-CD                             
                      OR END-OF-FCA789                                  
              MOVE E-FCA789-SORT-GRP-ORD-CD TO WS-HLD-SORT-GRP-ORD-CD   
              PERFORM UNTIL E-FCA789-SORT-GRP-CD NOT EQUAL              
                            WS-HLD-SORT-GRP-CD                          
                         OR E-FCA789-SORT-GRP-ORD-CD (1:1) NOT EQUAL    
                            WS-HLD-SORT-GRP-ORD-CD (1:1)                
                         OR END-OF-FCA789                               
                 MOVE E-FCA789-SORT-GRP-ORD-CD                          
                                            TO WS-HLD-SORT-GRP-ORD-CD   
                 MOVE E-FCA789-OPTION-CODE  TO WS-HLD-OPTION-CODE       
                 MOVE E-FCA789-OPT-DESC     TO WS-HLD-OPTION-DESC       
                 PERFORM UNTIL E-FCA789-SORT-GRP-CD NOT EQUAL           
                               WS-HLD-SORT-GRP-CD                       
                            OR E-FCA789-SORT-GRP-ORD-CD (1:1) NOT EQUAL 
                               WS-HLD-SORT-GRP-ORD-CD (1:1)             
                            OR E-FCA789-SORT-GRP-ORD-CD (3:1) NOT EQUAL 
                               WS-HLD-SORT-GRP-ORD-CD (3:1)             
                            OR END-OF-FCA789                            
                    MOVE E-FCA789-OPTION-CODE TO WS-HLD-OPTION-CODE     
                    MOVE E-FCA789-OPT-DESC    TO WS-HLD-OPTION-DESC     
                    PERFORM UNTIL E-FCA789-SORT-GRP-CD NOT EQUAL        
                                  WS-HLD-SORT-GRP-CD                    
                               OR E-FCA789-SORT-GRP-ORD-CD (1:1)        
                                  NOT EQUAL WS-HLD-SORT-GRP-ORD-CD (1:1)
                               OR E-FCA789-SORT-GRP-ORD-CD (3:1)        
                                  NOT EQUAL WS-HLD-SORT-GRP-ORD-CD (3:1)
                               OR E-FCA789-OPTION-CODE NOT EQUAL        
                                  WS-HLD-OPTION-CODE                    
                               OR END-OF-FCA789                         
                       COMPUTE WS-OPTION-CODE-COUNT =                   
                               WS-OPTION-CODE-COUNT + 1                 
                       COMPUTE WS-SUB-TOTAL-COUNT =                     
                               WS-SUB-TOTAL-COUNT + 1                   
                       COMPUTE WS-TOTAL-COUNT =                         
                               WS-TOTAL-COUNT + 1                       
                       COMPUTE WS-GRAND-TOTAL-COUNT =                   
                               WS-GRAND-TOTAL-COUNT + 1                 
                       PERFORM 7000-READ-FCSCA789  THRU 7000-EXIT       
                    END-PERFORM                                         
                    PERFORM 3000-OPTN-CD-TOTALS THRU 3000-EXIT          
                 END-PERFORM                                            
                 PERFORM 3100-SUB-TOTALS THRU 3100-EXIT                 
              END-PERFORM                                               
              PERFORM 3200-GRP-ORD-CD-TOTALS THRU 3200-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 3300-GRP-CD-TOTALS THRU 3300-EXIT.                   
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2100-PROCESS-RECORDS.                                       **        
      **  CONTROL BREAK LOGIC FOR THE REPORT.                         **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-RECORDS.                                            
      *                                                                         
           PERFORM UNTIL E-GRPMNT-AGR-SRC-CD NOT EQUAL                  
                         WS-HLD-AGR-SRC-CD                              
                      OR END-OF-GRPMNT                                  
              MOVE E-GRPMNT-OPTION-CODE TO WS-HLD-OPTION-CODE           
              MOVE E-GRPMNT-OPT-DESC    TO WS-HLD-OPTION-DESC           
              PERFORM UNTIL E-GRPMNT-AGR-SRC-CD NOT EQUAL               
                            WS-HLD-AGR-SRC-CD                           
                         OR E-GRPMNT-OPTION-CODE NOT EQUAL              
                            WS-HLD-OPTION-CODE                          
                         OR END-OF-GRPMNT                               
                 COMPUTE WS-OPTION-CODE-COUNT =                         
                         WS-OPTION-CODE-COUNT + 1                       
                 COMPUTE WS-TOTAL-COUNT =                               
                         WS-TOTAL-COUNT + 1                             
                 COMPUTE WS-GRAND-TOTAL-COUNT =                         
                         WS-GRAND-TOTAL-COUNT + 1                       
                 PERFORM 7050-READ-GRPMVMNT  THRU 7050-EXIT             
              END-PERFORM                                               
              PERFORM 3050-OPTN-CD-TOTALS THRU 3050-EXIT                
           END-PERFORM.                                                 
                                                                        
           PERFORM 3250-AGR-SRC-CD-TOTALS THRU 3250-EXIT.               
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3000-OPTN-CD-TOTALS.                                        **        
      **  PRINT THE TOTALS FOR EACH OPTION CODE                       **        
      ******************************************************************        
      *                                                                         
       3000-OPTN-CD-TOTALS.                                             
      *                                                                         
           IF HEADER-1-YES                                              
              IF WS-HLD-SORT-GRP-CD = 'A'                               
                 MOVE WS-HDR-AUTOMATED TO WS-MOVEMENT-TYPE              
              ELSE                                                      
                 IF WS-HLD-SORT-GRP-CD = 'R'                            
                    MOVE WS-HDR-FP-RENEWAL TO WS-MOVEMENT-TYPE          
                 END-IF                                                 
              END-IF                                                    
              WRITE PRNTFILE-RECORD    FROM WS-HEADER-3                 
              WRITE PRNTFILE-RECORD    FROM WS-DASHES                   
              SET HEADER-1-NO          TO TRUE                          
           END-IF.                                                      
                                                                        
           IF HEADER-2-YES                                              
              EVALUATE WS-HLD-SORT-GRP-ORD-CD (1:1)                     
                  WHEN 'A'                                              
                    MOVE WS-HDR-H-MOVE TO WS-MOVMENT-LEVEL              
                  WHEN 'B'                                              
                    MOVE WS-HDR-M-MOVE TO WS-MOVMENT-LEVEL              
                  WHEN 'C'                                              
                    MOVE WS-HDR-L-MOVE TO WS-MOVMENT-LEVEL              
                  WHEN OTHER                                            
                    MOVE SPACES        TO WS-MOVMENT-LEVEL              
              END-EVALUATE                                              
              WRITE PRNTFILE-RECORD    FROM WS-HEADER-4                 
              SET HEADER-2-NO          TO TRUE                          
           END-IF.                                                      
                                                                        
           MOVE WS-HLD-OPTION-CODE     TO WS-DET-OPTION-CODE.           
           MOVE WS-HLD-OPTION-DESC     TO WS-DET-OPTION-DESC.           
           MOVE WS-OPTION-CODE-COUNT   TO WS-DET-COUNT.                 
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-1.                
           MOVE ZEROES                 TO WS-OPTION-CODE-COUNT.         
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3050-OPTN-CD-TOTALS.                                        **        
      **  PRINT THE TOTALS FOR EACH OPTION CODE                       **        
      ******************************************************************        
      *                                                                         
       3050-OPTN-CD-TOTALS.                                             
      *                                                                         
           IF HEADER-1-YES                                              
              MOVE WS-HDR-MANUAL       TO WS-MOVEMENT-TYPE              
              WRITE PRNTFILE-RECORD    FROM WS-HEADER-3                 
              WRITE PRNTFILE-RECORD    FROM WS-DASHES                   
              SET HEADER-1-NO          TO TRUE                          
           END-IF.                                                      
                                                                        
           IF HEADER-2-YES                                              
              EVALUATE WS-HLD-AGR-SRC-CD                                
                  WHEN '1T2'                                            
                    MOVE WS-HDR-1T2-MOVE TO WS-MOVMENT-LEVEL            
                  WHEN '12S'                                            
                    MOVE WS-HDR-12S-MOVE TO WS-MOVMENT-LEVEL            
                  WHEN '2T1'                                            
                    MOVE WS-HDR-2T1-MOVE TO WS-MOVMENT-LEVEL            
                  WHEN '21S'                                            
                    MOVE WS-HDR-21S-MOVE TO WS-MOVMENT-LEVEL            
                  WHEN OTHER                                            
                    MOVE SPACES          TO WS-MOVMENT-LEVEL            
              END-EVALUATE                                              
              WRITE PRNTFILE-RECORD    FROM WS-HEADER-4                 
              SET HEADER-2-NO          TO TRUE                          
           END-IF.                                                      
                                                                        
           MOVE WS-HLD-OPTION-CODE     TO WS-DET-OPTION-CODE.           
           MOVE WS-HLD-OPTION-DESC     TO WS-DET-OPTION-DESC.           
           MOVE WS-OPTION-CODE-COUNT   TO WS-DET-COUNT.                 
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-1.                
           MOVE ZEROES                 TO WS-OPTION-CODE-COUNT.         
      *                                                                         
       3050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3100-SUB-TOTAL.                                             **        
      **  PRINT THE SUB TOTALS FOR EACH GROUP                         **        
      ******************************************************************        
      *                                                                         
       3100-SUB-TOTALS.                                                 
      *                                                                         
           MOVE WS-SUB-TOTAL-COUNT     TO WS-DET-SUB-TOTAL-CNT.         
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-SUB-TOTAL.        
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
                                                                        
           MOVE ZEROES                 TO WS-SUB-TOTAL-COUNT.           
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3200-GRP-ORD-CD-TOTALS.                                     **        
      **  PRINT THE TOTALS FOR EACH SORT GROUP ORDER CODE             **        
      ******************************************************************        
      *                                                                         
       3200-GRP-ORD-CD-TOTALS.                                          
      *                                                                         
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
                                                                        
           EVALUATE WS-HLD-SORT-GRP-ORD-CD (1:1)                        
               WHEN 'A'                                                 
                 MOVE WS-TOT-H-MOVE    TO WS-DET-TOTAL-LEVEL            
               WHEN 'B'                                                 
                 MOVE WS-TOT-M-MOVE    TO WS-DET-TOTAL-LEVEL            
               WHEN 'C'                                                 
                 MOVE WS-TOT-L-MOVE    TO WS-DET-TOTAL-LEVEL            
               WHEN OTHER                                               
                 MOVE SPACES           TO WS-DET-TOTAL-LEVEL            
           END-EVALUATE.                                                
                                                                        
           MOVE WS-TOTAL-COUNT         TO WS-DET-TOTAL-CNT.             
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-TOTAL.            
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
                                                                        
           MOVE ZEROES                 TO WS-TOTAL-COUNT.               
           SET HEADER-2-YES            TO TRUE.                         
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3250-AGR-SRC-CD-TOTALS.                                     **        
      **  PRINT THE TOTALS FOR EACH AGREEMNT SOURCE CODE              **        
      ******************************************************************        
      *                                                                         
       3250-AGR-SRC-CD-TOTALS.                                          
      *                                                                         
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
                                                                        
           EVALUATE WS-HLD-AGR-SRC-CD                                   
               WHEN '1T2'                                               
                 MOVE WS-TOT-1T2-MOVE  TO WS-DET-TOTAL-LEVEL            
               WHEN '12S'                                               
                 MOVE WS-TOT-12S-MOVE  TO WS-DET-TOTAL-LEVEL            
               WHEN '2T1'                                               
                 MOVE WS-TOT-2T1-MOVE  TO WS-DET-TOTAL-LEVEL            
               WHEN '21S'                                               
                 MOVE WS-TOT-21S-MOVE  TO WS-DET-TOTAL-LEVEL            
               WHEN OTHER                                               
                 MOVE SPACES           TO WS-DET-TOTAL-LEVEL            
           END-EVALUATE.                                                
                                                                        
           MOVE WS-TOTAL-COUNT         TO WS-DET-TOTAL-CNT.             
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-TOTAL.            
           WRITE PRNTFILE-RECORD       FROM WS-DASHES.                  
                                                                        
           MOVE ZEROES                 TO WS-TOTAL-COUNT.               
           SET HEADER-2-YES            TO TRUE.                         
      *                                                                         
       3250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3300-GRP-CD-TOTALS.                                         **        
      **  PRINT THE TOTALS FOR EACH GROUP CODE                        **        
      ******************************************************************        
      *                                                                         
       3300-GRP-CD-TOTALS.                                              
      *                                                                         
           MOVE WS-GRAND-TOTAL-COUNT   TO WS-DET-GRAND-TOT-CNT.         
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-EQUALS.                  
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-GRAND-TOTAL.      
           WRITE PRNTFILE-RECORD       FROM WS-EQUALS.                  
                                                                        
           MOVE ZEROES                 TO WS-GRAND-TOTAL-COUNT.         
           SET HEADER-1-YES            TO TRUE.                         
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3350-MANUAL-GRAND-TOTAL.                                    **        
      **  PRINT THE GRAND TOTAL FOR THE MANUAL MOVEMENTS              **        
      ******************************************************************        
      *                                                                         
       3350-MANUAL-GRAND-TOTAL.                                         
      *                                                                         
           MOVE WS-GRAND-TOTAL-COUNT   TO WS-DET-GRAND-TOT-CNT.         
                                                                        
           WRITE PRNTFILE-RECORD       FROM WS-EQUALS.                  
           WRITE PRNTFILE-RECORD       FROM WS-DETAIL-GRAND-TOTAL.      
           WRITE PRNTFILE-RECORD       FROM WS-EQUALS.                  
                                                                        
           MOVE ZEROES                 TO WS-GRAND-TOTAL-COUNT.         
      *                                                                         
       3350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-READ-FCSCA789.                                         **        
      **  READ THE INPUT FILE.                                        **        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSCA789.                                              
      *                                                                         
           READ FIOCA789-FILE AT END                                    
                GO TO 7000-EXIT.                                        
      *                                                                         
           IF F789-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**     7000-READ-FCSCA789    **'                 
              DISPLAY '**    ERROR READING FCA789   **'                 
              DISPLAY '**        FILE STATUS = ' WS-F789-STATUS         
              DISPLAY '******************************************'      
              MOVE 12                 TO RETURN-CODE                    
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7050-READ-GRPMVMNT.                                         **        
      **  READ THE INPUT FILE.                                        **        
      ******************************************************************        
      *                                                                         
       7050-READ-GRPMVMNT.                                              
      *                                                                         
           READ GRPMVMNT-FILE AT END                                    
                GO TO 7050-EXIT.                                        
      *                                                                         
           IF GRPMNT-SUCCESSFUL                                         
              ADD +1                  TO WS-GRPMVMNT-CNT                
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**     7050-READ-GRPMVMNT    **'                 
              DISPLAY '**   ERROR READING GRPMVMNT  **'                 
              DISPLAY '**        FILE STATUS = ' WS-GRPMNT-STATUS       
              DISPLAY '******************************************'      
              MOVE 12                 TO RETURN-CODE                    
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-COMPANY.                                           **        
      ******************************************************************        
      *                                                                         
       7100-GET-COMPANY.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE COMPANY_NO = '01'                                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP789 **'      
              DISPLAY '**       PARA 7100-GET-COMPANY          **'      
              DISPLAY '**  ERROR DURING SELECT OF COMPANY NAME **'      
              DISPLAY '**             RC = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED          **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-GET-TIMESTAMP.                                         **        
      ******************************************************************        
      *                                                                         
       7200-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP789 **'      
              DISPLAY '**       PARA 7200-GET-TIMESTAMP        **'      
              DISPLAY '**   ERROR DURING SELECT OF TIMESTAMP   **'      
              DISPLAY '**              RC = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**        PROCESSING TERMINATED         **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      **  8000-PRINT-HEADER.                                         **         
      **  PRINTS THE REPORT HEADER LINES                             **         
      *****************************************************************         
      *                                                                         
       8000-PRINT-HEADER.                                               
      *                                                                         
           WRITE PRNTFILE-RECORD       FROM WS-HEADER-1.                
           WRITE PRNTFILE-RECORD       FROM WS-HEADER-2.                
           WRITE PRNTFILE-RECORD       FROM WS-STARS.                   
           WRITE PRNTFILE-RECORD       FROM WS-BLANK-LINE-104.          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FIOCA789-FILE                                          
                 GRPMVMNT-FILE                                          
                 PRNTFILE.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM***************************          
