       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSRP752.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. JAN 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **              NON-STANDARD RATE REPORT PROGRAM                **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES THE SEB751 REPORT FROM NON-STANDARD   **        
      **   RATE REPORT EXTRACT. THIS PROGRAM REPLACES EXISTING PGM    **        
      **   PCSRP752 TO ACCOMODATE THE NEW RATE STRUCTURE IN THE SEB   **        
      **   RATE RE-ENGINEERING PROJECT.                               **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID    REASON                                   **        
      ** -------  -------    ------                                   **        
      ** 01/2008  SS97726    INITIAL IMPLEMENTATION.                  **        
      **                                                              **        
A01673** 07 OCT 2009 RF10596 CREATE OUTPUT AS AN ATTACHMENT           **        
A02842** 07 DEC 2010 SV95326 COMBINING JCLS SEBC729 AND SEBC751.      **        
A04527** 30 DEC 2013 MS93554 ADDED PRICE DSCNT & CSC DSCNT DETAILS    **        
      **             ACT-247 IN THE REPORT.                           **        
      **                     INCLUDED OPTION DURATION AND ACCT TYPE   **        
      **                     CODE IN THE REPORT TO USE FIX RATE RPT.  **        
      **                     OUTPUT LAYOUT CHANGED TO 134 FROM 104.   **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FIOCA752-FILE   ASSIGN TO UT-S-FIOCA752               
               FILE STATUS IS WS-F751-STATUS.                           
                                                                        
           SELECT PRNTFILE        ASSIGN TO UT-S-PRNTFILE.              
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FIOCA752-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE FCSCA752           *          
      ****************************************************************          
      *                                                                         
       01  FIOCA752.                                                    
         02  E-FCA752-DATA-REC.                                         
           05  E-FCA752-OPTION-CODE         PIC X(12).                  
           05  E-FCA752-ACCT-STAT-CODE      PIC X(01).                  
           05  E-FCA752-THERM-PRICE         PIC 9(05)V9(06).            
           05  E-FCA752-ACCOUNT-NO          PIC 9(13).                  
           05  E-FCA752-ANNV-MONTH          PIC X(06).                  
A04527     05  E-FCA752-TIER-ACCT-TYP-CODE  PIC X(01).                  
           05  E-FCS752-RATE-TYP-FLAG       PIC X(01).                  
           05  E-FCS752-CORE-RT-PLAN        PIC X(03).                  
           05  E-FCA752-OPT-DESC            PIC X(50).                  
A04527     05  E-FCA752-CSC-AMT             PIC 999.9999.               
A04527     05  E-FCA752-REAL-ACCT-TYP-CODE  PIC X.                      
A04527     05  E-FCA752-THRM-PRC-DSCNT      PIC S9(05)V9(06) VALUE 0.   
A04527     05  E-FCA752-NET-THRM-PRC        PIC S9(05)V9(06) VALUE 0.   
A04527     05  E-FCA752-CSC-DSCNT           PIC S9(05)V9(06) VALUE 0.   
A04527     05  E-FCA752-NET-CSC             PIC S9(05)V9(06) VALUE 0.   
A04527     05  E-FCA752-DURATION-NO         PIC S9(04) VALUE 0.         
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
      *                                                                         
       FD  PRNTFILE                                                     
           BLOCK CONTAINS 0 RECORDS                                     
A04527     RECORD CONTAINS 134 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
A04527 01  PRNTFILE-RECORD                  PIC X(134).                 
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP752'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                         PIC X(40)    VALUE          
           'WORKING STORAGE FOR PCSRP752 STARTS HERE'.                  
      *                                                                         
       01 COMP-CODE                         PIC S9(4) COMP VALUE +0.    
      *                                                                         
       01 WORK-AREAS.                                                   
          05 WS-PGRMNAME                    PIC X(08) VALUE 'PCSRP752'. 
          05 PROGRAM-NAME                   PIC X(08) VALUE 'PCSRP752'. 
          05 WS-HEADER                      PIC X(01) VALUE 'Y'.        
             88  WS-HEAD-Y                            VALUE 'Y'.        
             88  WS-HEAD-N                            VALUE 'N'.        
          05 WS-REGULATED-Y                 PIC X(01) VALUE 'Y'.        
             88  WS-REG-FIRST                         VALUE 'Y'.        
          05 WS-EOF-SW                      PIC X(01) VALUE SPACES.     
             88  END-OF-FILE                          VALUE 'Y'.        
          05 WS-F751-STATUS                 PIC X(02) VALUE '  '.       
             88 F751-SUCCESSFUL                       VALUE '00'.       
             88 F751-READ-OK                          VALUE '00' '04'.  
             88 END-OF-FCA751                         VALUE '10'.       
          05 SQL-ERROR-SW                   PIC 9(01) VALUE 0.          
             88 SQL-ERROR                             VALUE 1.          
          05 WS-RATE-FACT                   PIC 9(09)V9(04).            
          05 WS-ACT-ACCTS                   PIC 9(07).                  
          05 WS-PEND-ACCTS                  PIC 9(07).                  
          05 WS-ALL-ACCTS                   PIC 9(07).                  
          05 WS-TOT-ACTIVE                  PIC 9(07).                  
          05 WS-TOT-PENDING                 PIC 9(07).                  
          05 WS-TOT-ALL                     PIC 9(07).                  
          05 WS-OPTION-CD-PEN               PIC 9(07).                  
          05 WS-OPTION-CD-ACT               PIC 9(07).                  
          05 WS-OPTION-CD-TOT               PIC 9(07).                  
          05 WS-NON-REG-FIX-PEN-H           PIC 9(07).                  
          05 WS-NON-REG-FIX-ACT-H           PIC 9(07).                  
          05 WS-NON-REG-FIX-TOT-H           PIC 9(07).                  
          05 WS-NON-REG-VAR-PEN-H           PIC 9(07).                  
          05 WS-NON-REG-VAR-ACT-H           PIC 9(07).                  
          05 WS-NON-REG-VAR-TOT-H           PIC 9(07).                  
          05 WS-NON-REG-PEN-H               PIC 9(07).                  
          05 WS-NON-REG-ACT-H               PIC 9(07).                  
          05 WS-NON-REG-TOT-H               PIC 9(07).                  
          05 WS-REG-TOT-PEN                 PIC 9(07).                  
          05 WS-REG-TOT-ACT                 PIC 9(07).                  
          05 WS-REG-TOT                     PIC 9(07).                  
          05 WS-REPORT-TOT-PEN              PIC 9(07).                  
          05 WS-REPORT-TOT-ACT              PIC 9(07).                  
          05 WS-REPORT-TOT                  PIC 9(07).                  
A04527    05 WS-GET-THRM-PRC-DSCNT-SIGN     PIC S9(05)V9(06) VALUE 0.   
A04527    05 WS-HOLD-THRM-PRC-DSCNT         PIC ZZ9.9999.               
A04527    05 WS-OPERAND                     PIC X(01) VALUE '-'.        
          05 WS-ANNIV-DATE.                                             
             10 WS-ANNIV-YEAR               PIC X(04).                  
             10 WS-ANNIV-MONTH              PIC X(02).                  
          05 WS-RPT1-PAGE-NO                PIC 9(04) VALUE ZERO.       
          05 WS-2-PER-PAGE                  PIC 9(01) VALUE 2.          
          05 WS-COMPANY-NAME                PIC X(26) VALUE SPACES.     
          05 WS-CURRENT-TIMESTAMP           PIC X(26).                  
          05 FILLER REDEFINES WS-CURRENT-TIMESTAMP.                     
             10 WS-PROGRAM-RUN-DATE         PIC X(10).                  
             10 FILLER                      PIC X(01).                  
             10 WS-PROGRAM-RUN-TIME         PIC X(08).                  
             10 FILLER                      PIC X(07).                  
          05 WS-SUBJECT.                                                
             10 FILLER                      PIC X(13) VALUE             
                                                      'SEBC 751 FOR '.  
             10 WS-SUB-DATE                 PIC X(10).                  
          05 WS-ACCT-TYPE-CODE              PIC X(01).                  
          05 FILLER REDEFINES WS-ACCT-TYPE-CODE.                        
             10 WS-ACCT-TYPE-CODE-NONREG    PIC X(01).                  
                88 WS-NON-REG   VALUE '1' '2' '3' '4'.                  
          05 FILLER REDEFINES WS-ACCT-TYPE-CODE.                        
             10 WS-ACCT-TYPE-CODE-REG       PIC X(01).                  
                88 WS-REGULATED VALUE '5' '6'.                          
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                     PIC X(02).                  
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RD-DD                     PIC X(02).                  
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RD-YY                     PIC X(02).                  
      *                                                                         
       01 WS-HEADER-1.                                                  
          05 FILLER                         PIC X(08) VALUE 'PCSR7522'. 
A04527    05 FILLER                         PIC X(49) VALUE SPACES.     
          05 WS-RPRT-COMPANY                PIC X(26) VALUE SPACES.     
A04527    05 FILLER                         PIC X(30) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'RUN DATE:'.
          05 FILLER                         PIC X(02) VALUE SPACES.     
          05 WS-RPRT-DATE                   PIC X(10) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-1-REG.                                              
          05 FILLER                         PIC X(08) VALUE 'PCSR7521'. 
A04527    05 FILLER                         PIC X(49) VALUE SPACES.     
A04527    05 WS-RPRT-COMPANY-R              PIC X(41) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'REGULATED'.
A04527    05 FILLER                         PIC X(06) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'RUN DATE:'.
          05 FILLER                         PIC X(02) VALUE SPACES.     
          05 WS-RPRT-DATE-R                 PIC X(10) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-2.                                                  
A04527    05 FILLER                         PIC X(52) VALUE SPACES.     
          05 FILLER                         PIC X(24) VALUE             
                   'NON-STANDARD RATE REPORT'.                          
A04527    05 FILLER                         PIC X(37) VALUE SPACES.     
          05 FILLER                         PIC X(09) VALUE 'RUN TIME:'.
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 WS-RPRT-TIME                   PIC X(08) VALUE SPACES.     
      *                                                                         
       01 WS-HEADER-3.                                                  
A04527    05 FILLER                         PIC X(58) VALUE SPACES.     
          05 WS-RPRT-MONTH                  PIC X(02) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE '/'.        
          05 WS-RPRT-DAY                    PIC X(02) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE '/'.        
          05 WS-RPRT-YR                     PIC X(04) VALUE SPACES.     
A04527    05 FILLER                         PIC X(49) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE 'PAGE:'.    
          05 FILLER                         PIC X(08) VALUE SPACES.     
          05 WS-RPRT-PAGE-NO                PIC ZZZ9.                   
      *                                                                         
       01 WS-HEADER-4.                                                  
          05 FILLER                         PIC X(06) VALUE 'OPTION'.   
          05 FILLER                         PIC X(05) VALUE ' CODE'.    
          05 FILLER                         PIC X(20) VALUE SPACES.     
          05 FILLER                         PIC X(11) VALUE             
                                                      'DESCRIPTION'.    
A04527    05 FILLER                         PIC X(32) VALUE SPACES.     
A04527    05 FILLER                         PIC X(05) VALUE 'PRICE'.    
A04527    05 FILLER                         PIC X(05) VALUE SPACES.     
A04527    05 FILLER                         PIC X(03) VALUE 'NET'.      
A04527    05 FILLER                         PIC X(03) VALUE SPACES.     
A04527    05 FILLER                         PIC X(04) VALUE 'ACCT'.     
A04527    05 FILLER                         PIC X(01) VALUE SPACES.     
A04527    05 FILLER                         PIC X(06) VALUE 'DURATN'.   
A04527    05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'ANNIV  '.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'PENDING'.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'ACTIVE '.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(08) VALUE '  TOTAL '. 
      *                                                                         
       01 WS-HEADER-5.                                                  
          05 FILLER                         PIC X(64) VALUE SPACES.     
          05 FILLER                         PIC X(06) VALUE 'PRICE '.   
A04527    05 FILLER                         PIC X(04) VALUE SPACES.     
A04527    05 FILLER                         PIC X(05) VALUE 'DSCNT'.    
A04527    05 FILLER                         PIC X(04) VALUE SPACES.     
A04527    05 FILLER                         PIC X(05) VALUE 'PRICE'.    
A04527    05 FILLER                         PIC X(02) VALUE SPACES.     
A04527    05 FILLER                         PIC X(04) VALUE 'TYPE'.     
A04527    05 FILLER                         PIC X(03) VALUE SPACES.     
A04527    05 FILLER                         PIC X(02) VALUE 'NO'.       
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'DATE   '.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'ACCOUNT'.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE 'ACCOUNT'.  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(08) VALUE ' ACCOUNT'. 
      *                                                                         
       01 WS-DETAIL-1.                                                  
          05 WS-OPTION-CD                   PIC X(12) VALUE SPACES.     
          05 WS-RATE-DASH                   PIC X(01) VALUE '-'.        
          05 WS-RATE-DESC                   PIC X(50) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-RATE-FACT-Z                 PIC Z.ZZZZ.                 
A04527    05 FILLER                         PIC X(01) VALUE SPACES.     
A04527    05 WS-PRC-DISCOUNT                PIC X(09) VALUE SPACES.     
A04527    05 FILLER                         PIC X(01) VALUE SPACES.     
A04527    05 WS-NET-PRICE                   PIC ZZ9.9999.               
A04527    05 FILLER                         PIC X(02) VALUE SPACES.     
A04527    05 WS-ACCOUNT-TYPE-CODE           PIC X(01) VALUE SPACES.     
A04527    05 FILLER                         PIC X(03) VALUE SPACES.     
A04527    05 WS-DURATION-NO                 PIC ZZZ9.                   
A04527    05 FILLER                         PIC X(02) VALUE SPACES.     
          05 WS-ANNIV-DATE-DASH.                                        
             10 WS-ANNIV-MTH-DASH           PIC X(02).                  
             10 FILLER                      PIC X(01) VALUE '/'.        
             10 WS-ANNIV-YR-DASH            PIC X(04).                  
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-PEND-ACCTS-Z                PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-ACT-ACCTS-Z                 PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 WS-ALL-ACCTS-Z                 PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-DETAIL-TOTAL.                                              
          05 WS-OPTION-CD-SUB               PIC X(12) VALUE SPACES.     
          05 WS-RATE-DASH-SUB               PIC X(01) VALUE '-'.        
          05 WS-RATE-DESC-SUB               PIC X(50) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-RATE-FACTOR-Z2              PIC Z.ZZZZ.                 
A04527    05 FILLER                         PIC X(31) VALUE SPACES.     
          05 FILLER                         PIC X(08) VALUE 'SUBTOTAL'. 
          05 WS-TOT-PENDING-Z               PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-TOT-ACTIVE-Z                PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 WS-TOT-ALL-Z                   PIC ZZZ,ZZ9.                
      *                                                                         
       01 WS-DASHES.                                                    
          05 FILLER                         PIC X(53) VALUE             
             '-----------------------------------------------------'.   
          05 FILLER                         PIC X(27) VALUE             
             '---------------------------'.                             
          05 FILLER                         PIC X(15) VALUE             
             '---------------'.                                         
A04527    05 FILLER                         PIC X(39) VALUE             
A04527       '---------------------------------------'.                 
      *                                                                         
       01 WS-OPTION-CD-TOTAL.                                           
          05 WS-OPTION-CD-TOTAL2            PIC X(12) VALUE SPACES.     
          05 WS-RATE-DASH-TOT               PIC X(01) VALUE '-'.        
          05 WS-RATE-DESC-TOT               PIC X(50) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE 'ALL'.      
A04527    05 FILLER                         PIC X(34) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE 'TOTAL'.    
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 WS-OPTION-CD-PEN-Z             PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-OPTION-CD-ACT-Z             PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-OPTION-CD-TOT-Z             PIC Z,ZZZ,ZZ9.              
      *                                                                         
       01 WS-NON-REG-TOTAL.                                             
          05 FILLER                         PIC X(20) VALUE             
             'NON REGULATED TOTAL'.                                     
A04527    05 FILLER                         PIC X(47) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE '***'.      
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE '*****'.    
A04527    05 FILLER                         PIC X(31) VALUE SPACES.     
          05 WS-NON-REG-PEN-Z               PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-ACT-Z               PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-TOT-Z               PIC Z,ZZZ,ZZ9.              
      *                                                                         
       01 WS-NON-REG-VAR-TOTAL.                                         
          05 FILLER                         PIC X(28) VALUE             
             'NON REGULATED VARIABLE TOTAL'.                            
A04527    05 FILLER                         PIC X(38) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE '***'.      
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE '*****'.    
A04527    05 FILLER                         PIC X(31) VALUE SPACES.     
          05 WS-NON-REG-VAR-PEN-Z           PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-VAR-ACT-Z           PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-VAR-TOT-Z           PIC Z,ZZZ,ZZ9.              
      *                                                                         
       01 WS-NON-REG-FIX-TOTAL.                                         
          05 FILLER                         PIC X(25) VALUE             
             'NON REGULATED FIXED TOTAL'.                               
A04527    05 FILLER                         PIC X(41) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE '***'.      
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE '*****'.    
A04527    05 FILLER                         PIC X(31) VALUE SPACES.     
          05 WS-NON-REG-FIX-PEN-Z           PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-FIX-ACT-Z           PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-NON-REG-FIX-TOT-Z           PIC Z,ZZZ,ZZ9.              
      *                                                                         
       01 WS-REG-TOTAL.                                                 
          05 FILLER                         PIC X(15) VALUE             
             'REGULATED TOTAL'.                                         
A04527    05 FILLER                         PIC X(51) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE '***'.      
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE '*****'.    
A04527    05 FILLER                         PIC X(31) VALUE SPACES.     
          05 WS-REG-PEN-Z                   PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-REG-ACT-Z                   PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-REG-TOT-Z                   PIC Z,ZZZ,ZZ9.              
      *                                                                         
       01 WS-EQUALS.                                                    
          05 FILLER                         PIC X(53) VALUE             
             '====================================================='.   
          05 FILLER                         PIC X(27) VALUE             
             '==========================='.                             
          05 FILLER                         PIC X(15) VALUE             
             '==============='.                                         
A04527    05 FILLER                         PIC X(39) VALUE             
A04527       '======================================='.                 
      *                                                                         
       01 WS-REPORT-TOTAL.                                              
          05 FILLER                         PIC X(03) VALUE 'ALL'.      
          05 FILLER                         PIC X(63) VALUE SPACES.     
          05 FILLER                         PIC X(03) VALUE 'ALL'.      
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 FILLER                         PIC X(11) VALUE             
             'GRAND TOTAL'.                                             
A04527    05 FILLER                         PIC X(28) VALUE SPACES.     
          05 WS-REPORT-TOT-PEN-Z            PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-REPORT-TOT-ACT-Z            PIC ZZZ,ZZ9.                
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-REPORT-TOT-Z                PIC Z,ZZZ,ZZ9.              
      *                                                                         
A04527 01  WS-BLANK-LINE-80                 PIC X(134)   VALUE SPACES.  
      *                                                                         
       01  MAILHEAD-1.                                                  
           05  FILLER                       PIC X(22) VALUE             
               'HELO DOMAIN:     SCANA'.                                
      *                                                                         
       01  MAILHEAD-2.                                                  
           05  FILLER                       PIC X(14) VALUE             
               'MAIL FROM:   <'.                                        
           05  MAIL2-JOB-NAME               PIC X(07).                  
           05  FILLER                       PIC X(20) VALUE             
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01  MAILHEAD-3.                                                  
           05  FILLER                       PIC X(39) VALUE             
               'RCPT TO: <SEBNONSTANDRATERPT@SCANA.COM>'.               
       01  MAILHEAD-4.                                                  
           05  FILLER                       PIC X(04) VALUE             
               'DATA'.                                                  
      *                                                                         
       01  MAILHEAD-5.                                                  
           05  FILLER                       PIC X(18) VALUE             
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME               PIC X(07).                  
           05  FILLER                       PIC X(20) VALUE             
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01  MAILHEAD-6.                                                  
           05  FILLER                       PIC X(34) VALUE             
               'TO: <SEBNONSTANDRATERPT@SCANA.COM>'.                    
      *                                                                         
       01  MAILHEAD-7.                                                  
           05  FILLER                       PIC X(10) VALUE             
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT                PIC X(30).                  
      *                                                                         
A01673 01  MAILHEAD-7A.                                                 
A01673     05  FILLER                      PIC X(17) VALUE              
A01673         'MIME-VERSION: 1.0'.                                     
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7B.                                                 
A01673     05  FILLER                      PIC X(47) VALUE              
A01673         'CONTENT-TYPE: MULTIPART/MIXED;"SIMPLE BOUNDARY"'.       
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7C.                                                 
A01673     05  FILLER                      PIC X(20) VALUE              
A01673         'CONTENT-DISPOSITION:'.                                  
A01673     05  FILLER                      PIC X(41) VALUE              
A01673         'ATTACHMENT;FILENAME="NONSTANDARDRATE.TXT"'.             
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7D.                                                 
A01673     05  FILLER                      PIC X(24) VALUE              
A01673         'CONTENT-TYPE: TEXT/PLAIN'.                              
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
       01  MAILHEAD-8.                                                  
           05  FILLER                       PIC X(80) VALUE SPACES.     
      *                                                                         
       01 WS-NO-DATA-LINE.                                              
          05  FILLER                        PIC X(41) VALUE SPACES.     
          05  FILLER                        PIC X(22) VALUE             
                    '** NO DATA THIS RUN **'.                           
          05  FILLER                        PIC X(41) VALUE SPACES.     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * IO AREA FOR PARM INPUT FILE 'A'                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
      * FCA00 MISC INPUT                                                        
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_COMPANY TABLE                                                       
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM TABLE                                                      
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
       01  WS-END                           PIC X(38) VALUE             
           'WORKING STORAGE FOR PCSRP752 ENDS HERE'.                    
      *                                                                         
       LINKAGE SECTION.                                                 
       01 WS-PARM-VALUE.                                                
          05 WS-PARMVAL-LENGTH           PIC S9(04) COMP.               
          05 WS-PARM-COMPANY             PIC X(02).                     
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
      ******************************************************************        
      **  0000-MAILINE.                                               **        
      **  CONTROLS THE MAIN PROCESSING OF THE PROGRAM.                **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE.                                     
      *                                                                         
           PERFORM UNTIL END-OF-FCA751                                  
              MOVE E-FCA752-OPTION-CODE   TO WS-OPTION-CD               
                                             WS-OPTION-CD-SUB           
                                             WS-OPTION-CD-TOTAL2        
              MOVE E-FCA752-THERM-PRICE   TO WS-RATE-FACT               
                                             WS-RATE-FACT-Z             
                                             WS-RATE-FACTOR-Z2          
A04527        MOVE E-FCA752-TIER-ACCT-TYP-CODE                          
                                          TO WS-ACCT-TYPE-CODE          
A04527                                                                  
A04527       EVALUATE E-FCA752-TIER-ACCT-TYP-CODE                       
A04527         WHEN '1'                                                 
A04527            MOVE 'D'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN '2'                                                 
A04527            MOVE 'A'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN '3'                                                 
A04527            MOVE 'B'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN '4'                                                 
A04527            MOVE 'S'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN '5'                                                 
A04527            MOVE '1'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN '6'                                                 
A04527            MOVE '2'            TO WS-ACCOUNT-TYPE-CODE           
A04527         WHEN OTHER                                               
A04527            MOVE SPACES         TO WS-ACCOUNT-TYPE-CODE           
A04527       END-EVALUATE                                               
A04527                                                                  
              MOVE E-FCA752-OPT-DESC      TO WS-RATE-DESC               
                                             WS-RATE-DESC-SUB           
                                             WS-RATE-DESC-TOT           
A04527        MOVE E-FCA752-THRM-PRC-DSCNT                              
A04527                                    TO WS-HOLD-THRM-PRC-DSCNT     
A04527                                       WS-GET-THRM-PRC-DSCNT-SIGN 
A04527        IF WS-GET-THRM-PRC-DSCNT-SIGN < 0                         
A04527           STRING WS-OPERAND DELIMITED BY SIZE                    
A04527                  WS-HOLD-THRM-PRC-DSCNT DELIMITED BY SIZE        
A04527                  INTO WS-PRC-DISCOUNT                            
A04527        ELSE                                                      
A04527           IF WS-GET-THRM-PRC-DSCNT-SIGN > 0                      
A04527              MOVE WS-HOLD-THRM-PRC-DSCNT TO WS-PRC-DISCOUNT      
A04527           ELSE                                                   
A04527              MOVE SPACES           TO WS-PRC-DISCOUNT            
A04527           END-IF                                                 
A04527        END-IF                                                    
A04527                                                                  
A04527        MOVE E-FCA752-NET-THRM-PRC  TO WS-NET-PRICE               
A04527        MOVE E-FCA752-DURATION-NO   TO WS-DURATION-NO             
                                                                        
              PERFORM 2000-PROCESS-RATE-PLAN THRU 2000-EXIT             
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZE.                                            **        
      **  PROGRAM INITIALIZATION.                                     **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE ZEROES                     TO WS-ACT-ACCTS              
                                              WS-TOT-ACTIVE             
                                              WS-PEND-ACCTS             
                                              WS-TOT-PENDING            
                                              WS-ALL-ACCTS              
                                              WS-TOT-ALL                
                                              WS-REPORT-TOT             
                                              WS-REPORT-TOT-ACT         
                                              WS-REPORT-TOT-PEN         
                                              WS-OPTION-CD-TOT          
                                              WS-OPTION-CD-ACT          
                                              WS-OPTION-CD-PEN.         
      *                                                                         
           PERFORM 7100-GET-COMPANY        THRU 7100-EXIT.              
           MOVE WS-COMPANY-NAME            TO WS-RPRT-COMPANY           
                                              WS-RPRT-COMPANY-R.        
      ** GET COMMON DATE FROM THE CSS_JOB_PARM                                  
           MOVE SPACES                     TO WS-SYSIPT                 
           MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN   
           MOVE 'COMMON'                   TO WS-PROGRAM                
           MOVE WS-DATE                    TO WS-COMMAND                
           MOVE ZEROS                      TO WS-SEQUENCE               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY               
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
                   UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
                              OR  END-OF-SYSIPT                         
           IF WS-INPUT-RUN-DATE-MM  NUMERIC AND                         
              WS-INPUT-RUN-DATE-DD  NUMERIC AND                         
              WS-INPUT-RUN-DATE-YY  NUMERIC                             
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'         
              DISPLAY '**  COMMON IS NOT ACTIVE'                        
              DISPLAY '**    KEY = ' E-FJC01-KEY                        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-RUN-DATE(1:4)     TO WS-RPRT-YR.               
           MOVE WS-INPUT-RUN-DATE(3:2)     TO WS-RD-YY.                 
           MOVE WS-INPUT-RUN-DATE(6:2)     TO WS-RPRT-MONTH             
                                              WS-RD-MM.                 
           MOVE WS-INPUT-RUN-DATE(9:2)     TO WS-RPRT-DAY               
                                              WS-RD-DD.                 
                                                                        
      **GET THE DB2 TIME-STAMP                                                  
           PERFORM 7200-GET-TIMESTAMP      THRU 7200-EXIT.              
           MOVE WS-PROGRAM-RUN-DATE        TO WS-RPRT-DATE              
                                              WS-RPRT-DATE-R.           
           MOVE WS-PROGRAM-RUN-TIME        TO WS-RPRT-TIME.             
      *                                                                         
           OPEN INPUT  FIOCA752-FILE.                                   
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                         
A02842     MOVE 'SEBP729'                  TO MAIL2-JOB-NAME            
                                              MAIL5-JOB-NAME.           
           MOVE WS-RUN-DATE                TO WS-SUB-DATE.              
           MOVE WS-SUBJECT                 TO MAIL7-SUBJECT.            
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-1.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-2.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-3.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-4.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-5.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-6.             
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-7.             
      *                                                                         
A01673     WRITE PRNTFILE-RECORD           FROM MAILHEAD-7A.            
A01673     WRITE PRNTFILE-RECORD           FROM MAILHEAD-7B.            
A01673     WRITE PRNTFILE-RECORD           FROM MAILHEAD-7C.            
A01673     WRITE PRNTFILE-RECORD           FROM MAILHEAD-7D.            
      *                                                                         
           WRITE PRNTFILE-RECORD           FROM MAILHEAD-8.             
      *                                                                         
           MOVE WS-PROGRAM-RUN-DATE(6:2)   TO WS-RPRT-MONTH.            
           MOVE WS-PROGRAM-RUN-DATE(9:2)   TO WS-RPRT-DAY.              
           MOVE WS-PROGRAM-RUN-DATE(1:4)   TO WS-RPRT-YR.               
      *                                                                         
           PERFORM 7000-READ-FCSCA751      THRU 7000-EXIT.              
           IF END-OF-FCA751                                             
              MOVE ZEROES                  TO WS-RATE-FACT              
              PERFORM 8000-PRINT-HEADER    THRU 8000-EXIT               
              WRITE PRNTFILE-RECORD        FROM WS-BLANK-LINE-80        
              WRITE PRNTFILE-RECORD        FROM WS-NO-DATA-LINE         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0101-RE-INITIALIZE.                                         **        
      **  PROGRAM VARIABLES RE-INITIALIZATION.                        **        
      ******************************************************************        
      *                                                                         
       0101-RE-INITIALIZE.                                              
      *                                                                         
           MOVE ZEROES                     TO WS-ACT-ACCTS              
                                              WS-PEND-ACCTS             
                                              WS-ALL-ACCTS.             
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0102-RE-INITIALIZE.                                         **        
      **  PROGRAM VARIABLES RE-INITIALIZATION.                        **        
      ******************************************************************        
      *                                                                         
       0102-RE-INITIALIZE.                                              
      *                                                                         
           MOVE ZEROES                     TO WS-TOT-ACTIVE             
                                              WS-TOT-PENDING            
                                              WS-TOT-ALL.               
      *                                                                         
       0102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2000-PROCESS-RATE-PLAN.                                     **        
      **  CONTROL BREAK LOGIC FOR THE REPORT.                         **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-RATE-PLAN.                                          
      *                                                                         
           PERFORM UNTIL E-FCA752-THERM-PRICE NOT EQUAL WS-RATE-FACT    
                      OR E-FCA752-OPTION-CODE NOT EQUAL WS-OPTION-CD    
                      OR END-OF-FCA751                                  
              MOVE E-FCA752-ANNV-MONTH    TO WS-ANNIV-DATE              
              MOVE WS-ANNIV-YEAR          TO WS-ANNIV-YR-DASH           
              MOVE WS-ANNIV-MONTH         TO WS-ANNIV-MTH-DASH          
              IF WS-ANNIV-YR-DASH = SPACES AND                          
                 WS-ANNIV-MTH-DASH = SPACES                             
                 MOVE '0000'              TO WS-ANNIV-YR-DASH           
                 MOVE '00'                TO WS-ANNIV-MTH-DASH          
              END-IF                                                    
              PERFORM UNTIL E-FCA752-THERM-PRICE NOT EQUAL WS-RATE-FACT 
                         OR E-FCA752-ANNV-MONTH NOT EQUAL WS-ANNIV-DATE 
                         OR E-FCA752-OPTION-CODE NOT EQUAL WS-OPTION-CD 
                         OR END-OF-FCA751                               
                 IF E-FCA752-ACCT-STAT-CODE = 'A'                       
                    IF WS-NON-REG AND E-FCS752-RATE-TYP-FLAG = 'V'      
                       COMPUTE WS-NON-REG-VAR-ACT-H =                   
                               WS-NON-REG-VAR-ACT-H + 1                 
                       COMPUTE WS-NON-REG-VAR-TOT-H =                   
                               WS-NON-REG-VAR-TOT-H + 1                 
                    ELSE                                                
                       IF WS-NON-REG AND E-FCS752-RATE-TYP-FLAG = 'F   '
                          COMPUTE WS-NON-REG-FIX-ACT-H =                
                                  WS-NON-REG-FIX-ACT-H + 1              
                          COMPUTE WS-NON-REG-FIX-TOT-H =                
                                  WS-NON-REG-FIX-TOT-H + 1              
                      END-IF                                            
                    END-IF                                              
                    COMPUTE WS-ACT-ACCTS = WS-ACT-ACCTS + 1             
                    COMPUTE WS-OPTION-CD-ACT = WS-OPTION-CD-ACT + 1     
                    COMPUTE WS-REPORT-TOT-ACT = WS-REPORT-TOT-ACT +    1
                    COMPUTE WS-ALL-ACCTS = WS-ALL-ACCTS + 1             
                    COMPUTE WS-OPTION-CD-TOT = WS-OPTION-CD-TOT + 1     
                    COMPUTE WS-REPORT-TOT = WS-REPORT-TOT + 1           
                 ELSE                                                   
                    IF E-FCA752-ACCT-STAT-CODE = 'P'                    
                       IF WS-NON-REG AND                                
                          E-FCS752-RATE-TYP-FLAG = 'V'                  
                          COMPUTE WS-NON-REG-VAR-PEN-H =                
                                  WS-NON-REG-VAR-PEN-H + 1              
                          COMPUTE WS-NON-REG-VAR-TOT-H =                
                                  WS-NON-REG-VAR-TOT-H + 1              
                       ELSE                                             
                          IF WS-NON-REG AND                             
                             E-FCS752-RATE-TYP-FLAG = 'F'               
                             COMPUTE WS-NON-REG-FIX-PEN-H =             
                                     WS-NON-REG-FIX-PEN-H + 1           
                             COMPUTE WS-NON-REG-FIX-TOT-H =             
                                     WS-NON-REG-FIX-TOT-H + 1           
                          END-IF                                        
                       END-IF                                           
                       COMPUTE WS-PEND-ACCTS = WS-PEND-ACCTS + 1        
                       COMPUTE WS-OPTION-CD-PEN =                       
                               WS-OPTION-CD-PEN + 1                     
                       COMPUTE WS-REPORT-TOT-PEN =                      
                               WS-REPORT-TOT-PEN + 1                    
                       COMPUTE WS-ALL-ACCTS = WS-ALL-ACCTS + 1          
                       COMPUTE WS-OPTION-CD-TOT =                       
                               WS-OPTION-CD-TOT + 1                     
                       COMPUTE WS-REPORT-TOT = WS-REPORT-TOT + 1        
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 7000-READ-FCSCA751 THRU 7000-EXIT              
              END-PERFORM                                               
              COMPUTE WS-TOT-ACTIVE  = WS-TOT-ACTIVE +                  
                                       WS-ACT-ACCTS                     
              COMPUTE WS-TOT-PENDING = WS-TOT-PENDING +                 
                                       WS-PEND-ACCTS                    
              COMPUTE WS-TOT-ALL     = WS-TOT-ALL +                     
                                       WS-ALL-ACCTS                     
              IF WS-TOT-ALL NOT EQUAL ZERO                              
                 PERFORM 8500-PRINT-DETAIL THRU 8500-EXIT               
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3000-NON-REG-TOTALS.                                        **        
      **  PRINT THE TOTALS FOR ALL THE NON-REGULATED ACCOUNTS         **        
      ******************************************************************        
      *                                                                         
       3000-NON-REG-TOTALS.                                             
      *                                                                         
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
           COMPUTE WS-NON-REG-PEN-H = WS-NON-REG-VAR-PEN-H +            
                                      WS-NON-REG-FIX-PEN-H.             
           COMPUTE WS-NON-REG-ACT-H = WS-NON-REG-VAR-ACT-H +            
                                      WS-NON-REG-FIX-ACT-H.             
           COMPUTE WS-NON-REG-TOT-H = WS-NON-REG-VAR-TOT-H +            
                                      WS-NON-REG-FIX-TOT-H.             
           MOVE WS-NON-REG-PEN-H     TO WS-NON-REG-PEN-Z.               
           MOVE WS-NON-REG-ACT-H     TO WS-NON-REG-ACT-Z.               
           MOVE WS-NON-REG-TOT-H     TO WS-NON-REG-TOT-Z.               
           WRITE PRNTFILE-RECORD FROM WS-NON-REG-TOTAL.                 
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3100-NON-REG-VAR-TOTALS                                     **        
      **  PRINT REPORT TOTALS FOR THE NONREGULATED VARIABLE ACCOUNTS  **        
      ******************************************************************        
      *                                                                         
       3100-NON-REG-VAR-TOTALS.                                         
      *                                                                         
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
           MOVE WS-NON-REG-VAR-PEN-H   TO WS-NON-REG-VAR-PEN-Z.         
           MOVE WS-NON-REG-VAR-ACT-H   TO WS-NON-REG-VAR-ACT-Z.         
           MOVE WS-NON-REG-VAR-TOT-H   TO WS-NON-REG-VAR-TOT-Z.         
           WRITE PRNTFILE-RECORD FROM WS-NON-REG-VAR-TOTAL.             
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3200-NON-REG-FIX-TOTALS                                     **        
      **  PRINT REPORT TOTALS FOR THE NONREGULATED FIXED ACCOUNTS     **        
      ******************************************************************        
      *                                                                         
       3200-NON-REG-FIX-TOTALS.                                         
      *                                                                         
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
           MOVE WS-NON-REG-FIX-PEN-H   TO WS-NON-REG-FIX-PEN-Z.         
           MOVE WS-NON-REG-FIX-ACT-H   TO WS-NON-REG-FIX-ACT-Z.         
           MOVE WS-NON-REG-FIX-TOT-H   TO WS-NON-REG-FIX-TOT-Z.         
           WRITE PRNTFILE-RECORD FROM WS-NON-REG-FIX-TOTAL.             
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3500-REG-TOTALS.                                            **        
      **  PRINT THE REPORT TOTALS FOR THE REGULATED ACCOUNTS          **        
      ******************************************************************        
      *                                                                         
       3500-REG-TOTALS.                                                 
      *                                                                         
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
           COMPUTE WS-REG-TOT = WS-REPORT-TOT -                         
                               (WS-NON-REG-FIX-TOT-H +                  
                                WS-NON-REG-VAR-TOT-H).                  
           MOVE WS-REG-TOT             TO WS-REG-TOT-Z.                 
           COMPUTE WS-REG-TOT-PEN = WS-REPORT-TOT-PEN -                 
                                   (WS-NON-REG-FIX-PEN-H +              
                                    WS-NON-REG-VAR-PEN-H).              
           MOVE WS-REG-TOT-PEN         TO WS-REG-PEN-Z.                 
           COMPUTE WS-REG-TOT-ACT = WS-REPORT-TOT-ACT -                 
                                   (WS-NON-REG-FIX-ACT-H +              
                                    WS-NON-REG-VAR-ACT-H).              
           MOVE WS-REG-TOT-ACT         TO WS-REG-ACT-Z.                 
           WRITE PRNTFILE-RECORD FROM WS-REG-TOTAL.                     
           WRITE PRNTFILE-RECORD FROM WS-EQUALS.                        
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-READ-FCSCA751.                                         **        
      **  READ THE INPUT FILE.                                        **        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSCA751.                                              
      *                                                                         
           READ FIOCA752-FILE AT END                                    
                GO TO 7000-EXIT.                                        
      *                                                                         
           IF F751-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7000-READ-FCSCA751             '             
               DISPLAY '** ERROR READING FCA751'                        
               DISPLAY '** FILE STATUS = ' WS-F751-STATUS               
               DISPLAY '******************************************'     
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-COMPANY.                                           **        
      ******************************************************************        
      *                                                                         
       7100-GET-COMPANY.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO = :WS-PARM-COMPANY                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE COMPANY_NO = :WS-PARM-COMPANY                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP752 **'      
              DISPLAY '** PARA 7100-GET-COMPANY                **'      
              DISPLAY '** ERROR DURING SELECT OF COMPANY NAME  **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '** PROCESSING TERMINATED                **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-GET-TIMESTAMP.                                         **        
      ******************************************************************        
      *                                                                         
       7200-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP752 **'      
              DISPLAY '** PARA 7200-GET-TIMESTAMP              **'      
              DISPLAY '** ERROR DURING SELECT OF TIMESTAMP     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '** PROCESSING TERMINATED                **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      **  8000-PRINT-HEADER.                                         **         
      **  PRINTS THE REPORT HEADER LINES                             **         
      *****************************************************************         
      *                                                                         
       8000-PRINT-HEADER.                                               
      *                                                                         
           MOVE 'N' TO WS-HEADER.                                       
A04527     IF E-FCA752-TIER-ACCT-TYP-CODE = ('5' OR '6')                
              WRITE PRNTFILE-RECORD FROM WS-HEADER-1-REG                
           ELSE                                                         
              WRITE PRNTFILE-RECORD FROM WS-HEADER-1                    
           END-IF.                                                      
                                                                        
           WRITE PRNTFILE-RECORD FROM WS-HEADER-2.                      
                                                                        
           ADD 1                           TO WS-RPT1-PAGE-NO.          
           MOVE WS-RPT1-PAGE-NO            TO WS-RPRT-PAGE-NO.          
           WRITE PRNTFILE-RECORD FROM WS-HEADER-3.                      
                                                                        
           WRITE PRNTFILE-RECORD FROM WS-BLANK-LINE-80.                 
           WRITE PRNTFILE-RECORD FROM WS-HEADER-4.                      
           WRITE PRNTFILE-RECORD FROM WS-HEADER-5.                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  8500-PRINT-DETAIL.                                         **         
      **  PRINTS DETAIL LINES BASED ON THE ACCOUNT TYPE.             **         
      *****************************************************************         
      *                                                                         
       8500-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-HEAD-Y                                                 
              PERFORM 8000-PRINT-HEADER          THRU 8000-EXIT         
           ELSE                                                         
              IF (WS-REGULATED AND WS-REG-FIRST)                        
                 PERFORM 3100-NON-REG-VAR-TOTALS THRU 3100-EXIT         
                 PERFORM 3200-NON-REG-FIX-TOTALS THRU 3200-EXIT         
                 PERFORM 3000-NON-REG-TOTALS     THRU 3000-EXIT         
                 PERFORM 8000-PRINT-HEADER       THRU 8000-EXIT         
                 MOVE 'N' TO WS-REGULATED-Y                             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-ACT-ACCTS  TO WS-ACT-ACCTS-Z.                        
           MOVE WS-PEND-ACCTS TO WS-PEND-ACCTS-Z.                       
           MOVE WS-ALL-ACCTS  TO WS-ALL-ACCTS-Z.                        
      *                                                                         
           WRITE PRNTFILE-RECORD FROM WS-DETAIL-1.                      
      *                                                                         
           MOVE ZEROES           TO PRNTFILE-RECORD.                    
      *                                                                         
           PERFORM 0101-RE-INITIALIZE THRU 0101-EXIT.                   
      *                                                                         
           IF E-FCA752-THERM-PRICE NOT EQUAL WS-RATE-FACT OR            
              E-FCA752-OPTION-CODE NOT EQUAL WS-OPTION-CD OR            
              END-OF-FCA751                                             
              WRITE PRNTFILE-RECORD FROM WS-DASHES                      
              MOVE WS-TOT-ACTIVE          TO WS-TOT-ACTIVE-Z            
              MOVE WS-TOT-PENDING         TO WS-TOT-PENDING-Z           
              MOVE WS-TOT-ALL             TO WS-TOT-ALL-Z               
              WRITE PRNTFILE-RECORD FROM WS-DETAIL-TOTAL                
              WRITE PRNTFILE-RECORD FROM WS-DASHES                      
              PERFORM 0102-RE-INITIALIZE THRU 0102-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF E-FCA752-OPTION-CODE NOT EQUAL WS-OPTION-CD OR            
              END-OF-FCA751                                             
              WRITE PRNTFILE-RECORD FROM WS-EQUALS                      
              MOVE WS-OPTION-CD-TOT       TO WS-OPTION-CD-TOT-Z         
              MOVE WS-OPTION-CD-PEN       TO WS-OPTION-CD-PEN-Z         
              MOVE WS-OPTION-CD-ACT       TO WS-OPTION-CD-ACT-Z         
              WRITE PRNTFILE-RECORD FROM WS-OPTION-CD-TOTAL             
              WRITE PRNTFILE-RECORD FROM WS-EQUALS                      
              MOVE ZEROES                 TO WS-OPTION-CD-TOT           
              MOVE ZEROES                 TO WS-OPTION-CD-PEN           
              MOVE ZEROES                 TO WS-OPTION-CD-ACT           
           END-IF.                                                      
      *                                                                         
           IF END-OF-FCA751 AND WS-REGULATED                            
              PERFORM 3500-REG-TOTALS        THRU 3500-EXIT             
              MOVE WS-REPORT-TOT          TO WS-REPORT-TOT-Z            
              MOVE WS-REPORT-TOT-PEN      TO WS-REPORT-TOT-PEN-Z        
              MOVE WS-REPORT-TOT-ACT      TO WS-REPORT-TOT-ACT-Z        
              WRITE PRNTFILE-RECORD FROM  WS-REPORT-TOTAL               
           ELSE                                                         
              IF END-OF-FCA751                                          
                 MOVE WS-REPORT-TOT       TO WS-REPORT-TOT-Z            
                 MOVE WS-REPORT-TOT-PEN   TO WS-REPORT-TOT-PEN-Z        
                 MOVE WS-REPORT-TOT-ACT   TO WS-REPORT-TOT-ACT-Z        
                 WRITE PRNTFILE-RECORD FROM  WS-REPORT-TOTAL            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FIOCA752-FILE                                          
                 PRNTFILE.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM***************************          
