       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP751.                                      
COB303 DATE-WRITTEN.     SEP 01, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--THIS PROGRAM PRINTS ACH RETURN ITEM REPORT FOR ACTIVITY     --*        
      *--POSTED                                                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  09/01/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT018*--                            CSR751 TO COBOL.                --*        
A05268*--  03/08/2016    VK7L032     FIXED THE ISSUES IN OUTPUT FIELD--*        
ACT018*--                            P-REC-DFID,P-BANK-NAME.         --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      ******************************************************************        
      * CSSPT751- SELECT STATEMENT FOR A 94 VARIABLE INPUT FILE        *        
      ******************************************************************        
           SELECT FCSPT751-FILE                                         
               ASSIGN UT-S-FCSPT751                                     
               FILE STATUS IS WS-FCS751-STATUS.                         
      ******************************************************************        
      * CSSPT80 - SELECT STATEMENT FOR A 80 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
      *                                                                         
       COPY CSSPT80.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      ***************************************************************           
      ** CFDPT751- FILE DESCRIPTION FOR THE FILE FIOPT751          **           
      ***************************************************************           
       FD  FCSPT751-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIORP751 - FILE LAYOUT FOR PCSRP751                            *        
      ******************************************************************        
      *                                                                         
       01 FIORP751.                                                     
          05 HEADER1-REC.                                               
            10 REC1-CD                       PIC X(01).                 
            10 PRTY1-CD                      PIC X(02).                 
            10 DEST1-IM                      PIC X(10).                 
            10 ORIG1-IM                      PIC X(10).                 
            10 FDAT1-CR.                                                
               15 FDATY-CR                   PIC X(02).                 
               15 FDATM-CR                   PIC X(02).                 
               15 FDATD-CR                   PIC X(02).                 
            10 FTIM1-CR                      PIC 9(04).                 
            10 FMOD1-ID                      PIC X(01).                 
            10 RSIZ1-SZ                      PIC X(03).                 
            10 BFTR1-FT                      PIC X(02).                 
            10 FCOD1-CD                      PIC X(01).                 
            10 IDES1-NM                      PIC X(23).                 
            10 IORG1-NM                      PIC X(23).                 
            10 IREF1-CD                      PIC X(08).                 
      *****************************************************************         
      * COMPANY/BATCH HEADER FOR RETURNS                              *         
      *****************************************************************         
          05 BTHHDR-REC      REDEFINES HEADER1-REC.                     
            10 REC5-CD                       PIC X(01).                 
            10 SERV5-CD                      PIC X(03).                 
            10 COMP5-NM                      PIC X(16).                 
            10 CDIS5-DT                      PIC X(20).                 
            10 CIDN5-ID                      PIC X(10).                 
            10 SCLS5-EN                      PIC X(03).                 
            10 CDES5-DS                      PIC X(10).                 
            10 CDAT5-DT                      PIC X(06).                 
            10 EDAT5-DT.                                                
               15 EDAT5-YY                   PIC X(02).                 
               15 EDAT5-MM                   PIC X(02).                 
               15 EDAT5-DD                   PIC X(02).                 
            10 RESV5-VD                      PIC X(03).                 
            10 OSTD5-CD                      PIC X(01).                 
            10 ODFI5-ID                      PIC X(08).                 
            10 BATH5-NO                      PIC X(07).                 
      *****************************************************************         
      * ENTRY DETAIL FOR CORPORATE RETURNS                            *         
      *****************************************************************         
          05 ENTDET6-REC     REDEFINES HEADER1-REC.                     
            10 REC6-CD                       PIC X(01).                 
            10 TRAN6-CD                      PIC 9(02).                 
            10 DFII6-ID                      PIC X(09).                 
            10 DFIB6-NO                      PIC X(17).                 
            10 AMNT6-AM                      PIC 9(10).                 
            10 NUMB6-ID                      PIC X(15).                 
            10 NAME6-IC                      PIC X(22).                 
            10 DATA6-DS                      PIC X(02).                 
            10 ADDN6-IN                      PIC X(01).                 
            10 TRAC6-NO                      PIC X(15).                 
      *****************************************************************         
      * ADDENDA RECORD FOR RETURNS                                    *         
      *****************************************************************         
          05 EDETAD7-REC     REDEFINES HEADER1-REC.                     
            10 REC7-CD                       PIC X(01).                 
            10 TYPE7-CD                      PIC X(02).                 
            10 PAYI7-RI1.                                               
               15 RSON7-CD                   PIC X(03).                 
               15 PAYI7-RI                   PIC X(77).                 
            10 ADDN7-SN                      PIC X(04).                 
            10 DETL7-SN                      PIC X(07).                 
      *****************************************************************         
      *COMPANY/BATCH CONTROL FOR RETURNS                              *         
      *****************************************************************         
          05 BTRAIL8-REC     REDEFINES HEADER1-REC.                     
            10 REC8-CD                       PIC X(01).                 
            10 SRVC8-CD                      PIC X(03).                 
            10 NTRY8-CT                      PIC X(06).                 
            10 NTRH8-HS                      PIC X(10).                 
            10 DEBD8-AM                      PIC X(12).                 
            10 CRED8-AM                      PIC X(12).                 
            10 CIDN8-ID                      PIC X(10).                 
            10 MATH8-CD                      PIC X(19).                 
            10 RESR8-VD                      PIC X(06).                 
            10 DFII8-ID                      PIC X(08).                 
            10 BATH8-NO                      PIC X(07).                 
      *****************************************************************         
      * FILE TRAILER FOR RETURNS                                      *         
      *****************************************************************         
          05 FTRAIL9-REC     REDEFINES HEADER1-REC.                     
            10 REC9-CD                       PIC X(01).                 
            10 BATC9-CT                      PIC 9(06).                 
            10 BLOK9-CT                      PIC X(06).                 
            10 ACNT9-CT                      PIC X(08).                 
            10 NTRH9-HS                      PIC X(10).                 
            10 TDBE9-AM                      PIC 9(12).                 
            10 TCRE9-AM                      PIC X(12).                 
            10 RESV9-VD                      PIC X(39).                 
      ******************************************************************        
      * CFDPT80 - FD STATEMENT FOR A  80 CHAR/RECORD PRINT FILE        *        
      ******************************************************************        
      *                                                                         
       COPY CFDPT80.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP751'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK, D1                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01  WS-WORKIG-STORAGE-START      PIC X(40)       VALUE           
                        'WORKING STORAGE FOR PCSRP751 STARTS HERE'.     
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP751'.     
           05 WS-SCEG-COMP-ID           PIC X(10) VALUE '2086040100'.   
           05 WS-SEB-COMP-ID            PIC X(10) VALUE '2086040200'.   
           05 WS-HDR-EXIST              PIC X(01) VALUE 'Y'.            
           05 WS-TOTAL-HDR              PIC X(01) VALUE 'N'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-PRINT-DATA             PIC X(01) VALUE 'N'.            
           05 WS-SCEG-HEADER            PIC X(57) VALUE                 
           'SCEG/PSNC ACH RETURN ITEM REPORT FOR ACTIVITY POSTED: '.    
           05 WS-SEB-HEADER             PIC X(57) VALUE                 
           'SCANA ENERGY ACH RETURN ITEM REPORT FOR ACTIVITY POSTED: '. 
           05 WS-SCEG-DB-ITEM           PIC X(48)                       
              VALUE 'TOTAL SCEG/PSNC ACH DEBIT ITEMS CHARGED BACK:'.    
           05 WS-SCEG-DB-AMOUNT         PIC X(49)                       
              VALUE 'TOTAL SCEG/PSNC ACH DEBIT AMOUNT CHARGED BACK:'.   
           05 WS-SEB-DB-ITEM            PIC X(48)                       
              VALUE 'TOTAL SCANA ENERGY ACH DEBIT ITEMS CHARGED BACK:'. 
           05 WS-SEB-DB-AMOUNT          PIC X(49)                       
              VALUE 'TOTAL SCANA ENERGY ACH DEBIT AMOUNT CHARGED BACK:'.
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-LINE-COUNT             PIC 9(02) VALUE ZEROES.         
           05 WS-PAGE-NUM               PIC 9(03) VALUE ZEROES.         
           05 WS-FILE-CR-DATE           PIC X(08) VALUE SPACES.         
           05 WS-FILE-DR-TIME           PIC X(04) VALUE SPACES.         
           05 WS-FILE-CR-DT.                                            
              10 WS-FCR-MTH             PIC X(02) VALUE SPACES.         
              10 WS-FCR-SLS1            PIC X(01) VALUE '/'.            
              10 WS-FCR-DAY             PIC X(02) VALUE SPACES.         
              10 WS-FCR-SLS2            PIC X(01) VALUE '/'.            
              10 WS-FCR-YR              PIC X(02) VALUE SPACES.         
           05 WS-EFFECT-DT.                                             
              10 WS-EFF-MTH             PIC X(02) VALUE SPACES.         
              10 WS-EFF-SLS1            PIC X(01) VALUE '/'.            
              10 WS-EFF-DAY             PIC X(02) VALUE SPACES.         
              10 WS-EFF-SLS2            PIC X(01) VALUE '/'.            
              10 WS-EFF-YR              PIC X(02) VALUE SPACES.         
           05 WS-COMP-ID                PIC X(10) VALUE SPACES.         
           05 WS-COMP-ID1               PIC X(10) VALUE SPACES.         
           05 WS-COMP-ID-TMP            PIC X(10) VALUE SPACES.         
           05 WS-PREV-COMP-ID-TMP       PIC X(10) VALUE SPACES.         
           05 WS-AMOUNT                 PIC 9(08)V9(02) VALUE ZEROES.   
           05 WS-REC-DFID               PIC X(10) VALUE SPACES.         
           05 WS-BANK-NAME              PIC X(40) VALUE SPACES.         
           05 WS-SCEG-CNT6              PIC 9(06) VALUE ZEROES.         
           05 WS-SEB-CNT6               PIC 9(06) VALUE ZEROES.         
           05 WS-TOT-DB-AMT             PIC 9(12)V9(02) VALUE ZEROES.   
           05 WS-TOT-SCEG-DB-AMT        PIC 9(12)V9(02) VALUE ZEROES.   
           05 WS-TOT-SEB-DB-AMT         PIC 9(12)V9(02) VALUE ZEROES.   
           05 WS-TOT-ENTRY-CT           PIC 9(06) VALUE ZEROES.         
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCS751-STATUS         PIC X(02) VALUE '00'.           
               88 FCS751-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
           05  WS-FPT80-STATUS          PIC X(02) VALUE SPACES.         
      *                                                                         
      ***************** PCSRP751 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE 'CSRRP751'.     
               10  FILLER               PIC X(71) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'DATE:    '.    
               10  P-RPT-DATE           PIC X(08).                      
               10  FILLER               PIC X(40) VALUE SPACES.         
               10  FILLER               PIC X(06) VALUE 'PAGE: '.       
               10  P-RPT-PAGENM         PIC Z(03).                      
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'TIME:     '.   
               10  P-RPT-RUN-TIME.                                      
                   15 P-RPT-RUN-HH      PIC X(02) VALUE SPACES.         
                   15 FILLER            PIC X(01) VALUE ':'.            
                   15 P-RPT-RUN-MM      PIC X(02) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE '(EST)'.        
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER               PIC X(80) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-5.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  P-RPT-HEADER         PIC X(57) VALUE SPACES.         
               10  P-RPT-HDR-DATE       PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(14) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-6.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(16)                       
                                        VALUE '* BANK/ACCOUNT: '.       
               10  P-ORIG-DFIID1        PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(55) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-7.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(30)                       
                   VALUE '------------------------------'.              
               10  FILLER               PIC X(10) VALUE 'ACH DEBITS'.   
               10  FILLER               PIC X(30)                       
                   VALUE '------------------------------'.              
      *                                                                         
           05  WS-RPT-HEADER-8.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(14)                       
                                        VALUE 'COMPANY ID:   '.         
               10  P-COMP-ID-TMP        PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(16)                       
                                        VALUE 'COMPANY NAME:   '.       
               10  P-COMP-NAME          PIC X(16) VALUE SPACES.         
               10  FILLER               PIC X(15) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-9.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(15)                       
                                        VALUE 'ORIG EFFECT DT:'.        
               10  FILLER               PIC X(17) VALUE SPACES.         
               10  P-EFFECT-DATE        PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(39) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-10.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(19)                       
                                        VALUE 'CIS ACCOUNT NUMBER:'.    
               10  FILLER               PIC X(12) VALUE SPACES.         
               10  P-REC-COMPNY         PIC X(22) VALUE SPACES.         
               10  FILLER               PIC X(26) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-11.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(21)                       
                                        VALUE 'RETURN AMT/CURR CODE:'.  
               10  FILLER               PIC X(11) VALUE SPACES.         
               10  P-AMOUNT             PIC Z(05)9.9(02).               
               10  FILLER               PIC X(05) VALUE '(USD)'.        
      *                                                                         
           05  WS-RPT-HEADER-12.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(24)                       
                                       VALUE 'RETURN REASON CODE/DESC:'.
               10  FILLER               PIC X(08) VALUE SPACES.         
               10  P-PYMNTR-INFO        PIC X(40) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-13.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(10)                       
                                        VALUE 'RDFI NAME:'.             
               10  FILLER               PIC X(22) VALUE SPACES.         
               10  P-BANK-NAME          PIC X(40) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-14.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(15)                       
                                        VALUE 'RDFI TR NUMBER:'.        
               10  FILLER               PIC X(17) VALUE SPACES.         
               10  P-REC-DFID           PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(38) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-15.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(20)                       
                                        VALUE 'RDFI ACCOUNT NUMBER:'.   
               10  FILLER               PIC X(12) VALUE SPACES.         
               10  P-DFI-ACCT-NO        PIC X(17) VALUE SPACES.         
               10  FILLER               PIC X(30) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-16.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(23)                       
                                        VALUE 'ORIG DEPOSIT BANK/ACCT:'.
               10  FILLER               PIC X(09) VALUE SPACES.         
               10  P-ORIG-DFIID         PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(39) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-17.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(16)                       
                                        VALUE 'STD ENTRY CLASS:'.       
               10  FILLER               PIC X(16) VALUE SPACES.         
               10  P-STD-ENTCL-CODE     PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(39) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-18.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(15)                       
                                        VALUE 'TRAN CODE/DESC:'.        
               10  FILLER               PIC X(17) VALUE SPACES.         
               10  P-TRN-CODE           PIC 9(02) VALUE ZEROES.         
               10  FILLER               PIC X(45) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-19.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(19)                       
                                        VALUE 'COMPANY ENTRY DESC:'.    
               10  FILLER               PIC X(13) VALUE SPACES.         
               10  P-COMP-ENT-DESC      PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(47) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-20.                                        
               10  FILLER               PIC X(35)                       
               VALUE '-----------------------------------'.             
               10  FILLER               PIC X(35)                       
               VALUE '-----------------------------------'.             
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     '*** END OF REPORT ***'.                           
           05  FILLER                   PIC X(55) VALUE SPACES.         
      *                                                                         
       01  WS-TOTAL-SCEG-ITEM.                                          
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-SCEG-ITEM-HDR         PIC X(48) VALUE SPACES.         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  P-SCEG-CNT6              PIC Z(05)9.                     
      *                                                                         
       01  WS-TOTAL-SCEG-AMOUNT.                                        
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-SCEG-AMOUNT-HDR       PIC X(49) VALUE SPACES.         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  P-TOT-SCEG-DB-AMT        PIC Z(05)9.99.                  
      *                                                                         
       01  WS-TOTAL-SEB-ITEM.                                           
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-SEB-ITEM-HDR          PIC X(48) VALUE SPACES.         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  P-SEB-CNT6               PIC Z(05)9.                     
      *                                                                         
       01  WS-TOTAL-SEB-AMOUNT.                                         
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-SEB-AMOUNT-HDR        PIC X(49) VALUE SPACES.         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  P-TOT-SEB-DB-AMT         PIC Z(05)9.99.                  
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT  FCSPT751-FILE.                                   
           OPEN OUTPUT FCSPT80-FILE.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7200-READ-FCSPT751               THRU 7200-EXIT.     
           PERFORM 2000-PROCESS-DTLS                THRU 2000-EXIT      
             UNTIL END-OF-REC.                                          
           IF END-OF-REC                                                
              MOVE WS-PREV-COMP-ID-TMP    TO WS-COMP-ID1                
              PERFORM 2400-WRITE-TOTAL              THRU 2400-EXIT      
           END-IF.                                                      
           PERFORM 2500-WRITE-TRLR                  THRU 2500-EXIT.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS                                            **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           EVALUATE REC1-CD                                             
             WHEN '1'                                                   
               MOVE FDATM-CR              TO WS-FCR-MTH                 
               MOVE '/'                   TO WS-FCR-SLS1                
               MOVE FDATD-CR              TO WS-FCR-DAY                 
               MOVE '/'                   TO WS-FCR-SLS2                
               MOVE FDATY-CR              TO WS-FCR-YR                  
               MOVE WS-FILE-CR-DT         TO WS-FILE-CR-DATE            
               MOVE FTIM1-CR              TO WS-FILE-DR-TIME            
             WHEN '5'                                                   
               MOVE CIDN5-ID              TO WS-COMP-ID                 
               IF WS-COMP-ID NOT EQUAL WS-PREV-COMP-ID-TMP              
                  MOVE WS-PREV-COMP-ID-TMP TO WS-COMP-ID1               
                  MOVE CIDN5-ID           TO WS-PREV-COMP-ID-TMP        
                  MOVE WS-YES             TO WS-TOTAL-HDR               
               END-IF                                                   
               MOVE COMP5-NM              TO P-COMP-NAME                
               MOVE EDAT5-MM              TO WS-EFF-MTH                 
               MOVE '/'                   TO WS-EFF-SLS1                
               MOVE EDAT5-DD              TO WS-EFF-DAY                 
               MOVE '/'                   TO WS-EFF-SLS2                
               MOVE EDAT5-YY              TO WS-EFF-YR                  
               MOVE WS-EFFECT-DT          TO P-EFFECT-DATE              
               MOVE ODFI5-ID              TO P-ORIG-DFIID               
                                             P-ORIG-DFIID1              
               MOVE SCLS5-EN              TO P-STD-ENTCL-CODE           
               MOVE CDES5-DS              TO P-COMP-ENT-DESC            
               IF WS-COMP-ID EQUAL WS-SCEG-COMP-ID                      
                  MOVE WS-SCEG-HEADER     TO P-RPT-HEADER               
               END-IF                                                   
               IF WS-COMP-ID EQUAL WS-SEB-COMP-ID                       
                  MOVE WS-SEB-HEADER      TO P-RPT-HEADER               
               END-IF                                                   
               MOVE CIDN5-ID              TO WS-COMP-ID-TMP             
             WHEN '6'                                                   
               MOVE AMNT6-AM(1:8)         TO WS-AMOUNT(1:8)             
               MOVE AMNT6-AM(9:2)         TO WS-AMOUNT(9:2)             
               MOVE NAME6-IC              TO P-REC-COMPNY               
               MOVE DFII6-ID              TO WS-REC-DFID                
A05268                                       P-REC-DFID                 
               MOVE DFIB6-NO              TO P-DFI-ACCT-NO              
               MOVE TRAN6-CD              TO P-TRN-CODE                 
               PERFORM 7100-GET-BANK-NAME           THRU 7100-EXIT      
A05268         EVALUATE WS-ACTIVE-RETURN-CODE                           
A05268             WHEN NOT-FOUND                                       
A05268                  MOVE SPACES             TO P-BANK-NAME          
A05268             WHEN SUCCESSFUL-CALL                                 
A05268                  MOVE WS-BANK-NAME       TO P-BANK-NAME          
A05268         END-EVALUATE                                             
               IF WS-COMP-ID-TMP = WS-SCEG-COMP-ID                      
                 COMPUTE WS-SCEG-CNT6 = WS-SCEG-CNT6 + 1                
                 COMPUTE WS-TOT-SCEG-DB-AMT = WS-TOT-SCEG-DB-AMT +      
                                              WS-AMOUNT                 
               ELSE                                                     
                 COMPUTE WS-SEB-CNT6        = WS-SEB-CNT6 + 1           
                 COMPUTE WS-TOT-SEB-DB-AMT  = WS-TOT-SEB-DB-AMT +       
                                              WS-AMOUNT                 
               END-IF                                                   
             WHEN '7'                                                   
               MOVE RSON7-CD              TO P-PYMNTR-INFO              
               MOVE WS-YES                TO WS-PRINT-DATA              
               PERFORM 2300-WRITE-HEADER            THRU 2300-EXIT      
             WHEN '9'                                                   
               MOVE BATC9-CT              TO WS-TOT-ENTRY-CT            
               MOVE TDBE9-AM              TO WS-TOT-DB-AMT              
           END-EVALUATE.                                                
           PERFORM 7200-READ-FCSPT751               THRU 7200-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-WRITE-HEADER.                                             *        
      ******************************************************************        
      *                                                                         
       2300-WRITE-HEADER.                                               
      *                                                                         
           IF WS-HDR-EXIST EQUAL WS-YES     OR                          
              WS-LINE-COUNT GREATER THAN 54 OR                          
              (WS-TOTAL-HDR EQUAL WS-YES AND WS-HDR-EXIST EQUAL WS-NO)  
      *                                                                         
              IF WS-TOTAL-HDR EQUAL WS-YES AND WS-HDR-EXIST EQUAL WS-NO 
                 PERFORM 2400-WRITE-TOTAL        THRU 2400-EXIT         
                 MOVE WS-NO               TO WS-TOTAL-HDR               
              END-IF                                                    
      *                                                                         
               MOVE ZEROES                TO WS-LINE-COUNT              
               MOVE WS-NO                 TO WS-TOTAL-HDR               
               ADD +1                     TO WS-PAGE-NUM                
               MOVE WS-FILE-DR-TIME(1:2)  TO P-RPT-RUN-HH               
               MOVE WS-FILE-DR-TIME(3:2)  TO P-RPT-RUN-MM               
               MOVE WS-FILE-CR-DATE       TO P-RPT-DATE                 
                                             P-RPT-HDR-DATE             
               MOVE WS-PAGE-NUM           TO P-RPT-PAGENM               
               MOVE WS-RPT-HEADER-1       TO PRT80-RECORD               
               PERFORM 8000-WRITE-FCSPT80        THRU 8000-EXIT         
               MOVE WS-RPT-HEADER-2       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-3       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-4       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-5       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-4       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-6       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-4       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-7       TO PRT80-RECORD               
               PERFORM 8100-WRITE-FCSPT80        THRU 8100-EXIT         
               MOVE WS-RPT-HEADER-4       TO PRT80-RECORD               
               PERFORM 8200-WRITE-FCSPT80        THRU 8200-EXIT         
               MOVE WS-NO                 TO WS-HDR-EXIST               
           END-IF.                                                      
           MOVE WS-COMP-ID-TMP            TO P-COMP-ID-TMP.             
           MOVE WS-RPT-HEADER-8           TO PRT80-RECORD.              
           PERFORM 8300-WRITE-FCSPT80            THRU 8300-EXIT.        
           MOVE WS-RPT-HEADER-4           TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-9           TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-10          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-AMOUNT                 TO P-AMOUNT.                  
           MOVE WS-RPT-HEADER-11          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-12          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-13          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-14          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-15          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-16          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-17          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-18          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-19          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-20          TO PRT80-RECORD.              
           PERFORM 8100-WRITE-FCSPT80            THRU 8100-EXIT.        
           MOVE WS-RPT-HEADER-4           TO PRT80-RECORD.              
           PERFORM 8200-WRITE-FCSPT80            THRU 8200-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-WRITE-TOTAL.                                              *        
      ******************************************************************        
      *                                                                         
       2400-WRITE-TOTAL.                                                
      *                                                                         
           IF WS-COMP-ID1 = WS-SCEG-COMP-ID                             
              MOVE WS-SCEG-CNT6           TO P-SCEG-CNT6                
              MOVE WS-TOT-SCEG-DB-AMT     TO P-TOT-SCEG-DB-AMT          
              MOVE WS-SCEG-DB-ITEM        TO WS-SCEG-ITEM-HDR           
              MOVE WS-SCEG-DB-AMOUNT      TO WS-SCEG-AMOUNT-HDR         
              MOVE WS-TOTAL-SCEG-ITEM     TO PRT80-RECORD               
              PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT         
              MOVE WS-TOTAL-SCEG-AMOUNT   TO PRT80-RECORD               
              PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT         
              MOVE WS-RPT-HEADER-4        TO PRT80-RECORD               
              PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT         
           ELSE                                                         
              IF WS-COMP-ID1 > SPACES                                   
                 MOVE WS-SEB-CNT6            TO P-SEB-CNT6              
                 MOVE WS-TOT-SEB-DB-AMT      TO P-TOT-SEB-DB-AMT        
                 MOVE WS-SEB-DB-ITEM         TO WS-SEB-ITEM-HDR         
                 MOVE WS-SEB-DB-AMOUNT       TO WS-SEB-AMOUNT-HDR       
                 MOVE WS-TOTAL-SEB-ITEM      TO PRT80-RECORD            
                 PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT      
                 MOVE WS-TOTAL-SEB-AMOUNT    TO PRT80-RECORD            
                 PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT      
                 MOVE WS-RPT-HEADER-4        TO PRT80-RECORD            
                 PERFORM 8100-WRITE-FCSPT80         THRU 8100-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2500-WRITE-TRLR.                                                 
      *                                                                         
           EVALUATE WS-PRINT-DATA                                       
              WHEN WS-YES                                               
                   MOVE WS-END-DATA       TO PRT80-RECORD               
                   PERFORM 8100-WRITE-FCSPT80     THRU 8100-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-BANK-NAME.                                         **        
      ******************************************************************        
      *                                                                         
       7100-GET-BANK-NAME.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) D1.BANK_NAME                                       
                INTO :WS-BANK-NAME                                      
                FROM CSS_BANK D1 WITH(READUNCOMMITTED)                          
               WHERE D1.ROUTING_NUMBER = :WS-REC-DFID                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT D1.BANK_NAME                                               
MFA-TR*         INTO :WS-BANK-NAME                                              
MFA-TR*         FROM CSS_BANK D1                                                
MFA-TR*        WHERE D1.ROUTING_NUMBER = :WS-REC-DFID                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP751 ABORT *****'                   
              DISPLAY '**  7100-GET-BANK-NAME **'                       
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-REC-DFID = ' WS-REC-DFID                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSPT751 FILE FOR INPUT                                  *        
      ******************************************************************        
      *                                                                         
       7200-READ-FCSPT751.                                              
      *                                                                         
           READ FCSPT751-FILE                                           
                                                                        
           IF FCS751-SUCCESSFUL  OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP751 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSPT751 FILE ****'         
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCS751-STATUS            
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT80.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT80.                                              
      *                                                                         
           WRITE PRT80-RECORD AFTER ADVANCING PAGE.                     
                                                                        
           ADD +1                         TO WS-LINE-COUNT.             
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT80                                           **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT80.                                              
      *                                                                         
           WRITE PRT80-RECORD.                                          
                                                                        
           ADD +1                         TO WS-LINE-COUNT.             
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT80                                           **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT80.                                              
      *                                                                         
           WRITE PRT80-RECORD AFTER ADVANCING 3 LINES.                  
                                                                        
           ADD +1                         TO WS-LINE-COUNT.             
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT80                                           **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT80.                                              
      *                                                                         
           WRITE PRT80-RECORD AFTER ADVANCING 2 LINES.                  
                                                                        
           ADD +1                         TO WS-LINE-COUNT.             
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT80-FILE.                                          
                                                                        
           CLOSE FCSPT751-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
