       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSRP729.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. JAN 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **              NON-STANDARD RATE REPORT PROGRAM                **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES THE SEB729 REPORT FROM NON-STANDARD   **        
      **   RATE REPORT EXTRACT. THIS PROGRAM REPLACES EXISTING PGM    **        
      **   PCSRP729 TO ACCOMODATE THE NEW RATE STRUCTURE IN THE SEB   **        
      **   RATE RE-ENGINEERING PROJECT.                               **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 01/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
      **                                                              **        
A01673** 17 SEP 09 RF10596 ADDED CSC AMOUNT FROM PCSCA155.            **        
      **                   INCREASED OUTPUT FILE TO 138.              **        
A01673**  2 OCT 09 RF10596 CHANGED OUTPUT FILE TO 130.                **        
A01673**  5 OCT 09 RF10596 CHANGED OUTPUT FILE FOR ATTACHMENT         **        
A02842** 11 NOV 10 GD97441 1.FIX THE LENGTH ISSUE IN GRAND TOTALS.    **        
A02842**                   2.ADDED QUERYNO TO SQL STATEMENTS.         **        
A04527** 30 DEC 13 MS93554 1.ADDED PRICE DSCNT,CSC DSCNT,NET PRICE    **        
      **                     AND NET CSC DETAILS N THE REPORT.        **        
      **                   2.INCLUDED OPTION DURATION IN REPORT.      **        
      **                   3.OUTPUT LAYOUT CHANGED TO 172 FROM 130.   **        
      **                   4.E-FCA729-ACCT-TYP-CODE2 COLUMN NAME      **        
      **                     CHANGED TO E-FCA729-TIER-ACCT-TYP-CODE.  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FIOCA729-FILE   ASSIGN TO UT-S-FIOCA729               
               FILE STATUS IS WS-F729-STATUS.                           
           SELECT PCSRP729-FILE   ASSIGN TO UT-S-PCSRP729               
               FILE STATUS IS WS-P729-STATUS.                           
           SELECT EXCEP729-FILE   ASSIGN TO UT-S-EXCEP729               
               FILE STATUS IS WS-E729-STATUS.                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FIOCA729-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE FCSCA729           *          
      ****************************************************************          
      *                                                                         
       01 FIOCA729.                                                     
          03 E-FCA729-DATA-REC.                                         
             05 E-FCA729-OPTION-CODE        PIC X(12).                  
             05 E-FCA729-ACCT-STAT-CODE     PIC X.                      
             05 E-FCA729-THERM-PRICE        PIC 9(5)V9(6).              
             05 E-FCA729-ACCOUNT-NO         PIC 9(13).                  
             05 E-FCA729-ANNV-MONTH         PIC X(6).                   
             05 E-FCA729-TIER-ACCT-TYP-CODE PIC X.                      
             05 E-FCA729-RATE-TYP-FLAG      PIC X.                      
             05 E-FCA729-CORE-RT-PLAN       PIC X(3).                   
             05 E-FCA729-OPT-DESC           PIC X(50).                  
A01673       05 E-FCA729-CSC-AMT            PIC 999.9999.               
A01673       05 E-FCA729-REAL-ACCT-TYP-CODE PIC X.                      
A04527       05 E-FCA729-THRM-PRC-DSCNT     PIC S9(05)V9(06) VALUE 0.   
A04527       05 E-FCA729-NET-THRM-PRC       PIC S9(05)V9(06) VALUE 0.   
A04527       05 E-FCA729-CSC-DSCNT          PIC S9(05)V9(06) VALUE 0.   
A04527       05 E-FCA729-NET-CSC            PIC S9(05)V9(06) VALUE 0.   
A04527       05 E-DURATION-NO               PIC S9(04) VALUE 0.         
                                                                        
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
      *                                                                         
       FD  PCSRP729-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
A04527     RECORD CONTAINS 172 CHARACTERS                               
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
A04527 01  PCSRP729-REC                PIC X(172).                      
      *                                                                         
       FD  EXCEP729-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
A04527     RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  EXCEP729-REC.                                                
           05 EXCEP729-CC              PIC X(01).                       
           05 EXCEP729-DATA            PIC X(132).                      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP729'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP729 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-TOTAL-VARIABLE       PIC X(25)    VALUE               
                                  'TOTAL FOR VARIABLE RATES:'.          
           05  WS-NON-REGULATED        PIC X(25)    VALUE               
                                  'TOTAL FOR NON REGULATED: '.          
           05  WS-REGULATED            PIC X(25)    VALUE               
                                  'TOTAL FOR REGULATED:     '.          
           05  WS-TOTAL-FIXED          PIC X(25)    VALUE               
                                  'TOTAL FOR FIXED RATES:   '.          
           05  WS-TOTAL-ALL            PIC X(25)    VALUE               
                                  'TOTAL FOR ALL RATES:     '.          
      *                                                                         
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP729'.   
           05  WS-SQLCODE              PIC ZZZ999.                      
           05  DDC-CNT                 PIC S9(5)  COMP-3 VALUE +0.      
           05  WS-DISP-ACCT            PIC X(13)    VALUE SPACES.       
           05  WS-UTIL-TYPE            PIC X(01)    VALUE 'G'.          
           05  WS-EOF-SW               PIC X(01)    VALUE SPACES.       
               88  END-OF-FILE                      VALUE 'Y'.          
           05  WS-DEREG-TOT-SW         PIC X(01)    VALUE SPACES.       
               88  DEREG-TOTAL-Y                    VALUE 'Y'.          
               88  DEREG-TOTAL-N                    VALUE 'N'.          
           05  WS-TWO-PART-RT-PLAN-FL  PIC X(01)    VALUE SPACES.       
               88  TWO-PART-RT-Y                    VALUE 'Y'.          
               88  TWO-PART-RT-N                    VALUE 'N'.          
           05  WS-END-DDDC-CSR-SW      PIC X(1)     VALUE 'N'.          
               88  WS-END-DDDC-CSR                  VALUE 'Y'.          
               88  WS-NOT-END-DDDC-CSR              VALUE 'N'.          
           05  WS-EXC-RPT-SW           PIC X(01)    VALUE SPACES.       
               88  HAVE-EXC-RPT                     VALUE 'Y'.          
           05  WS-F729-STATUS          PIC X(02)    VALUE '  '.         
               88  F729-SUCCESSFUL                  VALUE '00'.         
               88  F729-READ-OK                     VALUE '00' '04'.    
           05  WS-P729-STATUS          PIC X(02)    VALUE '  '.         
               88  P729-SUCCESSFUL                  VALUE '00'.         
           05  WS-E729-STATUS          PIC X(02)    VALUE '  '.         
               88  E729-SUCCESSFUL                  VALUE '00'.         
           05  WS-HOLD-OPTION-CODE     PIC X(12)    VALUE SPACES.       
           05  WS-HOLD-RATE-PLAN       PIC X(03)    VALUE SPACES.       
A01673     05  WS-HOLD-CSC-AMT         PIC 999.9999.                    
A01673     05  WS-HOLD-REAL-ACCT-TYPE  PIC X.                           
A01673     05  WS-HOLD-ACCT-TYPE       PIC X.                           
A01673     05  WS-HOLD-RATE-TYPE       PIC X.                           
           05  WS-HOLD-FACTOR          PIC 9(05)V9(06) VALUE ZEROS.     
A04527     05  WS-HOLD-DDC             PIC ZZ9.99      VALUE ZEROS.     
           05  WS-HOLD-DESC            PIC X(50)       VALUE SPACES.    
A04527     05  WS-HOLD-THRM-PRC-DSCNT  PIC ZZ9.9999.                    
A04527     05  WS-HOLD-NET-THRM-PRC    PIC 9(05)V9(06).                 
A04527     05  WS-HOLD-CSC-DSCNT       PIC ZZ9.99.                      
A04527     05  WS-HOLD-NET-CSC         PIC 9(05)V9(06).                 
A04527     05  WS-GET-CSC-DSCNT-SIGN   PIC S9(05)V9(06) VALUE 0.        
A04527     05  WS-GET-THRM-PRC-DSCNT-SIGN                               
A04527                                 PIC S9(05)V9(06) VALUE 0.        
A04527     05  WS-CSC-DSCNT            PIC X(06) VALUE SPACES.          
A04527     05  WS-THRM-PRC-DSCNT       PIC X(08) VALUE SPACES.          
A04527     05  WS-OPERAND              PIC X(01) VALUE '-'.             
           05  WS-SUBJECT.                                              
               10  FILLER              PIC X(13)    VALUE               
                                       'SEBC 729 FOR '.                 
               10  WS-SUB-DATE         PIC X(10).                       
           05  WS-NULL-IND-01          PIC S9(4)  COMP VALUE 0.         
           05  WS-CURRENT-TIMESTAMP    PIC X(26).                       
           05  FILLER REDEFINES WS-CURRENT-TIMESTAMP.                   
               10  WS-PROGRAM-RUN-DATE PIC X(10).                       
               10  FILLER              PIC X(01).                       
               10  WS-PROGRAM-RUN-TIME PIC X(08).                       
               10  FILLER              PIC X(07).                       
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE ZERO.         
       01  WS-EXC1-LINE-NO             PIC 9(02)    VALUE ZERO.         
       01  WS-RPT1-PAGE-NO             PIC 9(04)    VALUE ZERO.         
       01  WS-EXC1-PAGE-NO             PIC 9(04)    VALUE ZERO.         
COB305 01 WS-ACTIVE-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-PEND-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-FINAL-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-TOT-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-F-ACTIVE-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-F-PEND-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-F-FINAL-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-F-TOT-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-V-ACTIVE-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-V-PEND-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-V-FINAL-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-V-TOT-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-R-ACTIVE-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-R-PEND-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-R-FINAL-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-R-TOT-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-G-ACTIVE-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-G-PEND-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-G-FINAL-CNT        PIC 9(07) COMP-3 VALUE 0.                
COB305 01 WS-G-TOT-CNT        PIC 9(07) COMP-3 VALUE 0.                
      ****************************************************************          
       01  WS-DDDC-TABLE.                                               
           05 WS-DDDC-TBL OCCURS 0 TO 999                               
                          DEPENDING ON DDC-CNT                          
                          ASCENDING KEY DDC-RATE-PLAN-NO                
                          INDEXED BY DDC-IND.                           
              10 DDC-RATE-PLAN-NO      PIC X(3).                        
              10 DDC-FACTOR            PIC S9(3)V99.                    
                                                                        
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-52                   PIC 9(02)    VALUE 52.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
      *                                                                         
      ***************** PCSRP729 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
A04527         10  FILLER              PIC X(62)    VALUE SPACES.       
               10  FILLER              PIC X(24)    VALUE               
                                       'NON STANDARD RATE REPORT'.      
A04527         10  FILLER              PIC X(72)    VALUE SPACES.       
      *                                                                         
           05  WS-EXC1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-EXC1-DATE         PIC X(08).                       
               10  FILLER              PIC X(37)    VALUE SPACES.       
               10  FILLER              PIC X(30)    VALUE               
                                   'ACCOUNTS WITH A FACTOR OF ZERO'.    
               10  FILLER              PIC X(51)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT HEADER2         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(08) VALUE 'PCSR7291'.      
               10  FILLER              PIC X(153) VALUE SPACES.         
               10  FILLER              PIC X(06) VALUE 'PAGE: '.        
A04527         10  P-RPT1-PAGE-NO      PIC Z,ZZ9.                       
      *                                                                         
           05  WS-EXC1-HEADER-2.                                        
               10  FILLER              PIC X(11) VALUE 'PCSRP729-02'.   
               10  FILLER              PIC X(107) VALUE SPACES.         
               10  FILLER              PIC X(08) VALUE 'PAGE:   '.      
               10  P-EXC1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
A01673     05  WS-RPT1-HEADER-31.                                       
A01673         10  FILLER            PIC X(6)   VALUE 'OPTION'.         
A01673         10  FILLER            PIC X(68)  VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'DDC'.            
A01673         10  FILLER            PIC X(5)   VALUE SPACES.           
A04527         10  FILLER            PIC X(8)   VALUE 'THRM PRC'.       
A04527         10  FILLER            PIC X(2)   VALUE SPACES.           
A04527         10  FILLER            PIC X(8)   VALUE 'NET THRM'.       
A04527         10  FILLER            PIC X(2)   VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'ACT'.            
A01673         10  FILLER            PIC X(1)   VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'RTE'.            
A01673         10  FILLER            PIC X(5)   VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'CSC'.            
A04527         10  FILLER            PIC X(5)   VALUE SPACES.           
A04527         10  FILLER            PIC X(3)   VALUE 'CSC'.            
A04527         10  FILLER            PIC X(7)   VALUE SPACES.           
A04527         10  FILLER            PIC X(3)   VALUE 'NET'.            
A04527         10  FILLER            PIC X(9)   VALUE SPACES.           
A01673         10  FILLER            PIC X(6)   VALUE 'ACTIVE'.         
A01673         10  FILLER            PIC X(4)   VALUE SPACES.           
A01673         10  FILLER            PIC X(7)   VALUE 'PENDING'.        
A01673         10  FILLER            PIC X(4)   VALUE SPACES.           
A01673         10  FILLER            PIC X(7)   VALUE 'FINALED'.        
      *                                                                         
A01673     05  WS-RPT1-HEADER-32.                                       
A01673         10  FILLER            PIC X(4)   VALUE 'CODE'.           
A01673         10  FILLER            PIC X(27)  VALUE SPACES.           
A01673         10  FILLER            PIC X(11)  VALUE 'DESCRIPTION'.    
A01673         10  FILLER            PIC X(22)  VALUE SPACES.           
A01673         10  FILLER            PIC X(6)   VALUE 'FACTOR'.         
A01673         10  FILLER            PIC X(3)   VALUE SPACES.           
A01673         10  FILLER            PIC X(6)   VALUE 'FACTOR'.         
A04527         10  FILLER            PIC X(5)   VALUE SPACES.           
A04527         10  FILLER            PIC X(5)   VALUE 'DSCNT'.          
A04527         10  FILLER            PIC X(5)   VALUE SPACES.           
A04527         10  FILLER            PIC X(5)   VALUE 'PRICE'.          
A04527         10  FILLER            PIC X(3)   VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'TYP'.            
A04527         10  FILLER            PIC X(1)   VALUE SPACES.           
A01673         10  FILLER            PIC X(3)   VALUE 'TYP'.            
A01673         10  FILLER            PIC X(3)   VALUE SPACES.           
A01673         10  FILLER            PIC X(6)   VALUE 'AMOUNT'.         
A01673         10  FILLER            PIC X(3)   VALUE SPACES.           
A04527         10  FILLER            PIC X(5)   VALUE 'DSCNT'.          
A04527         10  FILLER            PIC X(6)   VALUE SPACES.           
A04527         10  FILLER            PIC X(3)   VALUE 'CSC'.            
A04527         10  FILLER            PIC X(10)  VALUE SPACES.           
A04527         10  FILLER            PIC X(5)   VALUE 'ACCTS'.          
A04527         10  FILLER            PIC X(6)   VALUE SPACES.           
A04527         10  FILLER            PIC X(5)   VALUE 'ACCTS'.          
A04527         10  FILLER            PIC X(6)   VALUE SPACES.           
A01673         10  FILLER            PIC X(5)   VALUE 'ACCTS'.          
A01673*        10  FILLER            PIC X      VALUE SPACES.                   
      *                                                                         
           05  WS-EXC1-HEADER-31.                                       
               10  FILLER              PIC X(51)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                       'ACCOUNT NUMBER'.                
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                       'OPTION CODE'.                   
A01673         10  FILLER              PIC X(10)    VALUE SPACES.       
A01673         10  FILLER              PIC X(10)    VALUE               
A01673                                 'CSC AMOUNT'.                    
A01673         10  FILLER              PIC X(23)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR LINE TOTALS               **          
      ****************************************************************          
      *                                                                         
           05  WS-LINE-TOTAL.                                           
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  LT-TITLE            PIC X(25)    VALUE SPACES.       
A04527         10  FILLER              PIC X(104)   VALUE SPACES.       
               10  LT-NUM-ACTIVE       PIC Z,ZZZ,ZZ9.                   
A04527         10  FILLER              PIC X(2)     VALUE SPACES.       
               10  LT-NUM-PEND         PIC Z,ZZZ,ZZ9.                   
A04527         10  FILLER              PIC X(4)     VALUE SPACES.       
A02842         10  LT-NUM-FINAL        PIC   ZZZ,ZZ9.                   
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  D-OPTION-CODE       PIC X(12).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  D-DESC              PIC X(50)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  D-FACTOR            PIC 9.9999.                      
               10  D-OPERAND           PIC X(01)    VALUE SPACES.       
A04527         10  D-DDC               PIC X(06)    VALUE SPACES.       
A04527         10  FILLER              PIC X(04)    VALUE SPACES.       
A04527         10  D-THRM-PRC-DSCNT    PIC X(09)    VALUE SPACES.       
A04527         10  FILLER              PIC X(02)    VALUE SPACES.       
A04527         10  D-NET-THRM-PRC      PIC ZZ9.9999.                    
A04527         10  FILLER              PIC X(3)     VALUE SPACES.       
A01673         10  D-ACCT              PIC X        VALUE SPACES.       
A01673         10  FILLER              PIC X(3)     VALUE SPACES.       
A01673         10  D-RATE              PIC X        VALUE SPACES.       
A04527         10  FILLER              PIC X(4)     VALUE SPACES.       
A04527         10  D-CSC-AMT           PIC ZZ9.99   VALUE ZEROS.        
A04527         10  FILLER              PIC X(01)    VALUE SPACES.       
A04527         10  D-CSC-DSCNT         PIC X(09)    VALUE SPACES.       
A04527         10  FILLER              PIC X(02)    VALUE SPACES.       
A04527         10  D-NET-CSC           PIC ZZ9.99.                      
A04527         10  FILLER              PIC X(05)    VALUE SPACES.       
               10  D-NUM-ACTIVE        PIC Z,ZZZ,ZZ9.                   
A04527         10  FILLER              PIC X(02)    VALUE SPACES.       
               10  D-NUM-PEND          PIC Z,ZZZ,ZZ9.                   
A04527         10  FILLER              PIC X(02)    VALUE SPACES.       
               10  D-NUM-FINAL         PIC Z,ZZZ,ZZ9.                   
      *                                                                         
           05  WS-EXCP-LINE.                                            
               10  FILLER              PIC X(50)    VALUE SPACES.       
               10  EL-ACCT-NO          PIC X(16)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE SPACES.       
               10  EL-OPTION-CODE      PIC X(12)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE SPACES.       
A01673         10  EL-CSC-AMT          PIC 999.9(4) VALUE ZEROS.        
               10  FILLER              PIC X(28)    VALUE SPACES.       
      *                                                                         
       01  WS-LINE-132                 PIC X(132)   VALUE ALL '-'.      
A04527 01  WS-LINE-172                 PIC X(172)   VALUE ALL '-'.      
       01  WS-BLANK-LINE-132           PIC X(132)   VALUE SPACES.       
A04527 01  WS-BLANK-LINE-172           PIC X(172)   VALUE SPACES.       
      *                                                                         
       01  MAILHEAD-1.                                                  
           05  FILLER                  PIC X(22) VALUE                  
               'HELO DOMAIN:     SCANA'.                                
           05  FILLER                  PIC X(150) VALUE SPACES.         
      *                                                                         
       01  MAILHEAD-2.                                                  
           05  FILLER                      PIC X(14) VALUE              
               'MAIL FROM:   <'.                                        
           05  MAIL2-JOB-NAME              PIC X(07).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01  MAILHEAD-3.                                                  
           05  FILLER                      PIC X(39) VALUE              
               'RCPT TO: <SEBNONSTANDRATERPT@SCANA.COM>'.               
      *                                                                         
       01  MAILHEAD-4.                                                  
           05  FILLER                      PIC X(04) VALUE              
               'DATA'.                                                  
      *                                                                         
       01  MAILHEAD-5.                                                  
           05  FILLER                      PIC X(18) VALUE              
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME              PIC X(07).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
       01  MAILHEAD-6.                                                  
           05  FILLER                      PIC X(34) VALUE              
               'TO: <SEBNONSTANDRATERPT@SCANA.COM>'.                    
      *                                                                         
       01  MAILHEAD-7.                                                  
           05  FILLER                      PIC X(10) VALUE              
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT               PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7A.                                                 
A01673     05  FILLER                      PIC X(17) VALUE              
A01673         'MIME-VERSION: 1.0'.                                     
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7B.                                                 
A01673     05  FILLER                      PIC X(47) VALUE              
A01673         'CONTENT-TYPE: MULTIPART/MIXED;"SIMPLE BOUNDARY"'.       
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7C.                                                 
A01673     05  FILLER                      PIC X(20) VALUE              
A01673         'CONTENT-DISPOSITION:'.                                  
A01673     05  FILLER                      PIC X(41) VALUE              
A01673         'ATTACHMENT;FILENAME="NONSTANDARDRATE.TXT"'.             
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
A01673 01  MAILHEAD-7D.                                                 
A01673     05  FILLER                      PIC X(24) VALUE              
A01673         'CONTENT-TYPE: TEXT/PLAIN'.                              
A01673     05  FILLER                      PIC X(30).                   
      *                                                                         
       01  MAILHEAD-8.                                                  
           05  FILLER                      PIC X(80) VALUE SPACES.      
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(45)    VALUE SPACES.       
           05  FILLER                  PIC X(25)    VALUE               
                     '** NO DATA IN THIS RUN **'.                       
           05  FILLER                  PIC X(45)    VALUE SPACES.       
      *                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA729 START HERE '.               
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / FCA00-KEY                                                               
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / FCA00 MISC INPUT                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_SPCL_FCTR_APPL DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_SPCL_FCTR DCLGEN                                                    
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      /                                                                         
      **CURSOR TO GET THE TWO PART RATE PLANS                                   
           EXEC SQL                                                     
               DECLARE SPCL_FCTR_DDDC CURSOR FOR                        
                   SELECT DISTINCT(RATE_PLAN_NO)                        
                         ,FACTOR                                        
                     FROM CSS_SPCL_FCTR_APPL AP WITH(READUNCOMMITTED)           
                         ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)           
                    WHERE AP.CODE_UTIL_TYPE = 'G'                       
                      AND AP.CODE_STATUS    = 'A'                       
                      AND AP.FACTOR_ID      = SF.FACTOR_ID              
                      AND SF.SPCL_GROUP_CD  = 'DD'                      
                      AND AP.DATE_TO       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                      AND AP.DATE_FROM =                                
                          (SELECT MAX(DC.DATE_FROM)                     
                             FROM CSS_SPCL_FCTR_APPL DC
                           WITH(READUNCOMMITTED)                 
                            WHERE AP.RATE_PLAN_NO   = DC.RATE_PLAN_NO   
                              AND AP.CODE_UTIL_TYPE = DC.CODE_UTIL_TYPE 
                              AND AP.FACTOR_ID      = DC.FACTOR_ID      
                              AND DC.DATE_TO       >= 
           CAST(SYSDATETIMEOFFSET() AS DATE))     
                    ORDER BY RATE_PLAN_NO                               
                      FOR READ ONLY                             
A02842                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPCL_FCTR_DDDC CURSOR FOR                                
MFA-TR*            SELECT DISTINCT(RATE_PLAN_NO)                                
MFA-TR*                  ,FACTOR                                                
MFA-TR*              FROM CSS_SPCL_FCTR_APPL AP                                 
MFA-TR*                  ,CSS_SPCL_FCTR      SF                                 
MFA-TR*             WHERE AP.CODE_UTIL_TYPE = 'G'                               
MFA-TR*               AND AP.CODE_STATUS    = 'A'                               
MFA-TR*               AND AP.FACTOR_ID      = SF.FACTOR_ID                      
MFA-TR*               AND SF.SPCL_GROUP_CD  = 'DD'                              
MFA-TR*               AND AP.DATE_TO       >= CURRENT DATE                      
MFA-TR*               AND AP.DATE_FROM =                                        
MFA-TR*                   (SELECT MAX(DC.DATE_FROM)                             
MFA-TR*                      FROM CSS_SPCL_FCTR_APPL DC                         
MFA-TR*                     WHERE AP.RATE_PLAN_NO   = DC.RATE_PLAN_NO           
MFA-TR*                       AND AP.CODE_UTIL_TYPE = DC.CODE_UTIL_TYPE         
MFA-TR*                       AND AP.FACTOR_ID      = DC.FACTOR_ID              
MFA-TR*                       AND DC.DATE_TO       >= CURRENT DATE)             
MFA-TR*             ORDER BY RATE_PLAN_NO                                       
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*            QUERYNO 7300                                                 
MFA-TR*    END-EXEC.                                                            
      /                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET DDC-IND TO 1.
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 7100-READ-FCA729              THRU 7100-EXIT.        
           PERFORM 1100-PROCESS-RATE-PLAN        THRU 1100-EXIT         
                  UNTIL END-OF-FILE.                                    
           PERFORM 8700-REPORT-FINAL-TOTALS      THRU 8700-EXIT.        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE ZEROS                  TO WS-ACTIVE-CNT                 
                                          WS-PEND-CNT                   
                                          WS-FINAL-CNT                  
                                          WS-TOT-CNT                    
                                          WS-F-ACTIVE-CNT               
                                          WS-F-PEND-CNT                 
                                          WS-F-FINAL-CNT                
                                          WS-F-TOT-CNT                  
                                          WS-V-ACTIVE-CNT               
                                          WS-V-PEND-CNT                 
                                          WS-V-FINAL-CNT                
                                          WS-V-TOT-CNT                  
                                          WS-R-ACTIVE-CNT               
                                          WS-R-PEND-CNT                 
                                          WS-R-FINAL-CNT                
                                          WS-R-TOT-CNT                  
                                          WS-G-ACTIVE-CNT               
                                          WS-G-PEND-CNT                 
                                          WS-G-FINAL-CNT                
                                          WS-G-TOT-CNT.                 
           MOVE WS-52                  TO WS-RPT1-LINE-NO               
                                          WS-EXC1-LINE-NO.              
                                                                        
      ** GET COMMON DATE FROM THE CSS_JOB_PARM                                  
           MOVE SPACES                 TO WS-SYSIPT                     
           MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN       
           MOVE 'COMMON'               TO WS-PROGRAM                    
           MOVE WS-DATE                TO WS-COMMAND                    
           MOVE ZEROS                  TO WS-SEQUENCE                   
           MOVE WS-KEY-AREA            TO E-FJC01-KEY                   
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
                   UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
                              OR  END-OF-SYSIPT                         
           IF WS-INPUT-RUN-DATE-MM  NUMERIC AND                         
              WS-INPUT-RUN-DATE-DD  NUMERIC AND                         
              WS-INPUT-RUN-DATE-YY  NUMERIC                             
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'         
              DISPLAY '**  COMMON IS NOT ACTIVE'                        
              DISPLAY '**    KEY = ' E-FJC01-KEY                        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-RUN-DATE(3:2)     TO WS-RD-YY.                 
           MOVE WS-INPUT-RUN-DATE(6:2)     TO WS-RD-MM.                 
           MOVE WS-INPUT-RUN-DATE(9:2)     TO WS-RD-DD.                 
           MOVE WS-RUN-DATE                TO WS-SUB-DATE.              
                                                                        
           MOVE SPACES                     TO WS-RD-YY                  
                                              WS-RD-MM                  
                                              WS-RD-DD.                 
      **GET THE DB2 TIME-STAMP                                                  
           PERFORM 7200-GET-TIMESTAMP      THRU 7200-EXIT.              
           MOVE WS-PROGRAM-RUN-DATE (3:2)  TO WS-RD-YY.                 
           MOVE WS-PROGRAM-RUN-DATE (6:2)  TO WS-RD-MM.                 
           MOVE WS-PROGRAM-RUN-DATE (9:2)  TO WS-RD-DD.                 
           MOVE WS-RUN-DATE                TO P-RPT1-DATE               
                                              P-EXC1-DATE.              
                                                                        
      **   LOAD THE WS-TABLE WITH THE DDDC FACTORS                              
           MOVE 0                           TO DDC-CNT.                 
           SET WS-NOT-END-DDDC-CSR          TO TRUE.                    
           PERFORM 7300-OPEN-DDDC-FACTORS   THRU 7300-EXIT.             
           PERFORM 7400-FETCH-DDDC-FACTORS  THRU 7400-EXIT              
             UNTIL WS-END-DDDC-CSR.                                     
           PERFORM 7500-CLOSE-DDDC-FACTORS  THRU 7500-EXIT.             
                                                                        
           OPEN OUTPUT PCSRP729-FILE                                    
                       EXCEP729-FILE.                                   
      *                                                                         
           OPEN INPUT FIOCA729-FILE.                                    
      *                                                                         
           MOVE 'SEBP729'                  TO MAIL2-JOB-NAME            
                                              MAIL5-JOB-NAME.           
           MOVE WS-SUBJECT                 TO MAIL7-SUBJECT.            
           WRITE PCSRP729-REC              FROM MAILHEAD-1.             
           WRITE PCSRP729-REC              FROM MAILHEAD-2.             
           WRITE PCSRP729-REC              FROM MAILHEAD-3.             
           WRITE PCSRP729-REC              FROM MAILHEAD-4.             
           WRITE PCSRP729-REC              FROM MAILHEAD-5.             
           WRITE PCSRP729-REC              FROM MAILHEAD-6.             
           WRITE PCSRP729-REC              FROM MAILHEAD-7.             
A01673     WRITE PCSRP729-REC              FROM MAILHEAD-7A.            
A01673     WRITE PCSRP729-REC              FROM MAILHEAD-7B.            
A01673     WRITE PCSRP729-REC              FROM MAILHEAD-7C.            
A01673     WRITE PCSRP729-REC              FROM MAILHEAD-7D.            
           WRITE PCSRP729-REC              FROM MAILHEAD-8.             
           SET DEREG-TOTAL-Y               TO TRUE.                     
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PROCESS-RATE-PLAN                                   **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSRP729        **          
      **                                                            **          
      ****************************************************************          
       1100-PROCESS-RATE-PLAN.                                          
      *                                                                         
A0633      MOVE E-FCA729-OPTION-CODE   TO WS-HOLD-OPTION-CODE.          
A0633      MOVE E-FCA729-TIER-ACCT-TYP-CODE TO WS-HOLD-ACCT-TYPE.       
A0633      MOVE E-FCA729-REAL-ACCT-TYP-CODE TO WS-HOLD-REAL-ACCT-TYPE.  
A0633      MOVE E-FCA729-RATE-TYP-FLAG TO WS-HOLD-RATE-TYPE.            
           PERFORM 2000-PROCESS-FACTOR THRU 2000-EXIT                   
             UNTIL E-FCA729-OPTION-CODE NOT = WS-HOLD-OPTION-CODE       
                OR END-OF-FILE.                                         
      *                                                                         
A04527     IF E-FCA729-TIER-ACCT-TYP-CODE =                             
A04527                                    ('5' OR '6') AND DEREG-TOTAL-Y
              MOVE WS-NON-REGULATED    TO LT-TITLE                      
              PERFORM 8500-PRINT-TOTAL-LINE-R    THRU 8500-EXIT         
              MOVE ZEROES              TO WS-R-ACTIVE-CNT               
                                          WS-R-PEND-CNT                 
                                          WS-R-FINAL-CNT                
                                          WS-R-TOT-CNT                  
              SET DEREG-TOTAL-N        TO TRUE                          
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2000-PROCESS-FACTOR                                      **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-FACTOR.                                             
      *                                                                         
           MOVE E-FCA729-THERM-PRICE    TO WS-HOLD-FACTOR.              
           MOVE E-FCA729-OPT-DESC       TO WS-HOLD-DESC.                
           MOVE E-FCA729-CORE-RT-PLAN   TO WS-HOLD-RATE-PLAN.           
A01673     MOVE E-FCA729-CSC-AMT        TO WS-HOLD-CSC-AMT.             
A04527     MOVE E-FCA729-TIER-ACCT-TYP-CODE                             
A04527                                  TO WS-HOLD-ACCT-TYPE.           
A0633      MOVE E-FCA729-REAL-ACCT-TYP-CODE TO WS-HOLD-REAL-ACCT-TYPE.  
A0633      MOVE E-FCA729-RATE-TYP-FLAG  TO WS-HOLD-RATE-TYPE.           
A04527     MOVE E-FCA729-THRM-PRC-DSCNT TO WS-HOLD-THRM-PRC-DSCNT       
A04527                                     WS-GET-THRM-PRC-DSCNT-SIGN.  
A04527     MOVE E-FCA729-NET-THRM-PRC   TO WS-HOLD-NET-THRM-PRC         
A04527     MOVE E-FCA729-CSC-DSCNT      TO WS-HOLD-CSC-DSCNT            
A04527                                     WS-GET-CSC-DSCNT-SIGN.       
A04527     MOVE E-FCA729-NET-CSC        TO WS-HOLD-NET-CSC              
           PERFORM 3000-PROCESS-DATA    THRU 3000-EXIT                  
             UNTIL E-FCA729-THERM-PRICE NOT = WS-HOLD-FACTOR            
                OR E-FCA729-OPTION-CODE NOT = WS-HOLD-OPTION-CODE       
A01673          OR E-FCA729-CSC-AMT     NOT = WS-HOLD-CSC-AMT           
                OR END-OF-FILE.                                         
      *                                                                         
           IF WS-RPT1-LINE-NO NOT < WS-52                               
              PERFORM 8000-PRINT-TITLE   THRU 8000-EXIT                 
              PERFORM 8100-PRINT-HEADERS THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF WS-HOLD-FACTOR = 0                                        
              DISPLAY '*** FACTOR EQUAL ZERO ***'                       
           ELSE                                                         
              MOVE WS-HOLD-OPTION-CODE TO D-OPTION-CODE                 
              MOVE WS-HOLD-DESC        TO D-DESC                        
              SET TWO-PART-RT-N        TO TRUE                          
              SEARCH ALL WS-DDDC-TBL                                    
                  AT END                                                
                     CONTINUE                                           
                WHEN DDC-RATE-PLAN-NO(DDC-IND) = WS-HOLD-RATE-PLAN      
                     SET TWO-PART-RT-Y         TO TRUE                  
                     MOVE DDC-FACTOR(DDC-IND)  TO WS-HOLD-DDC           
              END-SEARCH                                                
              MOVE WS-HOLD-FACTOR      TO D-FACTOR                      
              IF TWO-PART-RT-Y                                          
                 IF DDC-FACTOR(DDC-IND) < 0                             
                    MOVE '-'           TO D-OPERAND                     
                 ELSE                                                   
                    MOVE '+'           TO D-OPERAND                     
                 END-IF                                                 
                 MOVE WS-HOLD-DDC      TO D-DDC                         
              ELSE                                                      
                 MOVE SPACES           TO D-OPERAND                     
                                          D-DDC                         
              END-IF                                                    
A01673        MOVE WS-HOLD-CSC-AMT     TO D-CSC-AMT                     
A01673        MOVE WS-HOLD-REAL-ACCT-TYPE TO D-ACCT                     
A01673        MOVE WS-HOLD-RATE-TYPE   TO D-RATE                        
              MOVE WS-ACTIVE-CNT       TO D-NUM-ACTIVE                  
              MOVE WS-PEND-CNT         TO D-NUM-PEND                    
              MOVE WS-FINAL-CNT        TO D-NUM-FINAL                   
                                                                        
A04527        IF WS-GET-THRM-PRC-DSCNT-SIGN < 0                         
A04527           MOVE WS-HOLD-THRM-PRC-DSCNT                            
A04527                                 TO WS-THRM-PRC-DSCNT             
A04527           STRING WS-OPERAND        DELIMITED BY SIZE             
A04527                  WS-THRM-PRC-DSCNT DELIMITED BY SIZE             
A04527                  INTO D-THRM-PRC-DSCNT                           
A04527        ELSE                                                      
A04527           IF WS-GET-THRM-PRC-DSCNT-SIGN > 0                      
A04527              MOVE WS-HOLD-THRM-PRC-DSCNT                         
2AKTHI                                 TO D-THRM-PRC-DSCNT              
A04527           ELSE                                                   
A04527              MOVE SPACES        TO D-THRM-PRC-DSCNT              
A04527           END-IF                                                 
A04527        END-IF                                                    
                                                                        
A04527        IF WS-GET-CSC-DSCNT-SIGN < 0                              
A04527           MOVE WS-HOLD-CSC-DSCNT TO WS-CSC-DSCNT                 
A04527        STRING WS-OPERAND    DELIMITED BY SIZE                    
A04527               WS-CSC-DSCNT  DELIMITED BY SIZE                    
A04527               INTO D-CSC-DSCNT                                   
A04527        ELSE                                                      
A04527          IF WS-GET-CSC-DSCNT-SIGN > 0                            
A04527             MOVE WS-HOLD-CSC-DSCNT                               
A04527                                 TO D-CSC-DSCNT                   
A04527          ELSE                                                    
A04527             MOVE SPACES         TO D-CSC-DSCNT                   
A04527          END-IF                                                  
A04527        END-IF                                                    
                                                                        
A04527        MOVE WS-HOLD-NET-THRM-PRC TO D-NET-THRM-PRC               
A04527        MOVE WS-HOLD-NET-CSC     TO  D-NET-CSC                    
                                                                        
              PERFORM 8200-PRINT-DETAIL-LINE     THRU 8200-EXIT         
              ADD WS-ACTIVE-CNT        TO WS-R-ACTIVE-CNT               
                                          WS-G-ACTIVE-CNT               
              ADD WS-PEND-CNT          TO WS-R-PEND-CNT                 
                                          WS-G-PEND-CNT                 
              ADD WS-FINAL-CNT         TO WS-R-FINAL-CNT                
                                          WS-G-FINAL-CNT                
              ADD WS-TOT-CNT           TO WS-R-TOT-CNT                  
                                          WS-G-TOT-CNT                  
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS                  TO WS-ACTIVE-CNT                 
                                          WS-PEND-CNT                   
                                          WS-FINAL-CNT                  
                                          WS-TOT-CNT.                   
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3000-PROCESS-DATA                                        **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3000-PROCESS-DATA.                                               
      *                                                                         
           IF E-FCA729-THERM-PRICE = 0                                  
              DISPLAY '*** ZERO FACTOR ***'                             
              DISPLAY '*** ACCOUNT NO  = ' E-FCA729-ACCOUNT-NO          
              DISPLAY '*** OPTION CODE = ' E-FCA729-OPTION-CODE         
A01673        DISPLAY '*** CSC AMOUNT  = ' E-FCA729-CSC-AMT             
              DISPLAY '*******************'                             
              PERFORM 4000-PROCESS-EXCEPTION     THRU 4000-EXIT         
           ELSE                                                         
              IF E-FCA729-ACCT-STAT-CODE = 'A'                          
                 ADD 1                 TO WS-ACTIVE-CNT                 
                 EVALUATE E-FCA729-RATE-TYP-FLAG                        
                     WHEN 'F'                                           
                        ADD 1              TO WS-F-ACTIVE-CNT           
                     WHEN 'V'                                           
                        ADD 1              TO WS-V-ACTIVE-CNT           
                 END-EVALUATE                                           
              ELSE                                                      
                 IF E-FCA729-ACCT-STAT-CODE = 'P'                       
                    ADD 1              TO WS-PEND-CNT                   
                    EVALUATE E-FCA729-RATE-TYP-FLAG                     
                        WHEN 'F'                                        
                           ADD 1       TO WS-F-PEND-CNT                 
                        WHEN 'V'                                        
                           ADD 1       TO WS-V-PEND-CNT                 
                    END-EVALUATE                                        
                 ELSE                                                   
                    IF E-FCA729-ACCT-STAT-CODE = 'B'                    
                       ADD 1           TO WS-FINAL-CNT                  
                       EVALUATE E-FCA729-RATE-TYP-FLAG                  
                           WHEN 'F'                                     
                              ADD 1       TO WS-F-FINAL-CNT             
                           WHEN 'V'                                     
                              ADD 1       TO WS-V-FINAL-CNT             
                       END-EVALUATE                                     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              ADD 1                    TO WS-TOT-CNT                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCA729              THRU 7100-EXIT.        
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4000-PROCESS-EXCEPTION                                   **          
      **      WRITE ACCOUNT INFO ZERO FACTOR ACCOUNTS.              **          
      **                                                            **          
      ****************************************************************          
       4000-PROCESS-EXCEPTION.                                          
      *                                                                         
           IF WS-EXC1-LINE-NO NOT < WS-52                               
              PERFORM 4100-EXC-TITLE             THRU 4100-EXIT         
              PERFORM 4200-EXC-HEADER            THRU 4200-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 4300-EXC-DETAIL               THRU 4300-EXIT.        
      *                                                                         
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4100-EXC-TITLE                                           **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
       4100-EXC-TITLE.                                                  
      *                                                                         
           MOVE ZEROES                 TO WS-EXC1-LINE-NO.              
           MOVE WS-EXC1-HEADER-1       TO EXCEP729-DATA.                
           WRITE EXCEP729-REC                                           
                AFTER ADVANCING TOP-OF-PAGE.                            
      *                                                                         
           ADD 1                       TO WS-EXC1-PAGE-NO.              
           MOVE WS-EXC1-PAGE-NO        TO P-EXC1-PAGE-NO.               
           MOVE WS-EXC1-HEADER-2       TO EXCEP729-DATA.                
           WRITE EXCEP729-REC                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 2                       TO WS-EXC1-LINE-NO.              
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4200-EXC-HEADER                                          **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4200-EXC-HEADER.                                                 
      *                                                                         
           MOVE WS-EXC1-HEADER-31      TO  EXCEP729-DATA                
           WRITE EXCEP729-REC                                           
                AFTER ADVANCING 3 LINES.                                
           MOVE WS-LINE-132            TO  EXCEP729-DATA                
           WRITE EXCEP729-REC                                           
                AFTER ADVANCING 1 LINE.                                 
                                                                        
           ADD 4                       TO WS-EXC1-LINE-NO.              
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4300-EXC-DETAIL                                          **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4300-EXC-DETAIL.                                                 
      *                                                                         
           STRING E-FCA729-ACCOUNT-NO(1:1), '-',                        
                  E-FCA729-ACCOUNT-NO(2:4), '-',                        
                  E-FCA729-ACCOUNT-NO(6:4), '-',                        
                  E-FCA729-ACCOUNT-NO(10:4), DELIMITED BY SIZE          
             INTO EL-ACCT-NO.                                           
           MOVE E-FCA729-OPTION-CODE   TO EL-OPTION-CODE.               
A01673     MOVE E-FCA729-CSC-AMT       TO EL-CSC-AMT.                   
           MOVE WS-EXCP-LINE           TO EXCEP729-DATA.                
           WRITE EXCEP729-REC                                           
                AFTER ADVANCING 1 LINE.                                 
                                                                        
           ADD 1                       TO WS-EXC1-LINE-NO.              
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCA729                                         **          
      **      READS THE INPUT FILE FIOCA729                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCA729.                                                
      *                                                                         
           READ FIOCA729-FILE                                           
               AT END                                                   
                   MOVE WS-Y           TO WS-EOF-SW.                    
                                                                        
           IF F729-SUCCESSFUL                                           
           OR END-OF-FILE                                               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7100-ERROR ON FIOCA729 READ.  STATUS IS '       
                        WS-F729-STATUS                                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-GET-TIMESTAMP.                                         **        
      ******************************************************************        
      *                                                                         
       7200-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP775 **'      
              DISPLAY '**       PARA 7200-GET-TIMESTAMP        **'      
              DISPLAY '**   ERROR DURING SELECT OF TIMESTAMP   **'      
              DISPLAY '**             RC =' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**        PROCESSING TERMINATED         **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7300-OPEN-DDDC-FACTORS.                                   **          
      **      OPEN THE SPCL_FCTR_DDDC CURSOR                        **          
      ****************************************************************          
      *                                                                         
       7300-OPEN-DDDC-FACTORS.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN SPCL_FCTR_DDDC                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '    7300-OPEN-DDDC-FACTORS '                    
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7400-FETCH-DDDC-FACTORS.                                  **          
      **      FETCH THE DDDC FACTORS TO LOAD WS-TABLE               **          
      ****************************************************************          
      *                                                                         
       7400-FETCH-DDDC-FACTORS.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH SPCL_FCTR_DDDC                                     
                INTO :SA-RATE-PLAN-NO                                   
                    ,:SA-FACTOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                    TO DDC-CNT                       
              MOVE SA-RATE-PLAN-NO     TO DDC-RATE-PLAN-NO(DDC-CNT)     
              COMPUTE DDC-FACTOR(DDC-CNT) ROUNDED = SA-FACTOR           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-DDDC-CSR   TO TRUE                          
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH ACCOUNT_CUR '                    
                 DISPLAY '    7400-FETCH-DDDC-FACTORS '                 
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7500-CLOSE-DDDC-FACTORS.                                  **          
      **      CLOSE THE DDDC FACTORS CURSOR                         **          
      ****************************************************************          
      *                                                                         
       7500-CLOSE-DDDC-FACTORS.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE SPCL_FCTR_DDDC                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '      CLOSE ACCOUNT_CUR '                        
              DISPLAY '   7500-CLOSE-DDDC-FACTORS '                     
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8000-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8000-PRINT-TITLE.                                                
      *                                                                         
           MOVE ZEROES                 TO WS-RPT1-LINE-NO.              
           WRITE PCSRP729-REC FROM WS-RPT1-HEADER-1.                    
                                                                        
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PCSRP729-REC FROM WS-RPT1-HEADER-2.                    
                                                                        
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8100-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-HEADERS.                                              
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-RPT1-HEADER-31.          
           WRITE PCSRP729-REC          FROM WS-RPT1-HEADER-32.          
           WRITE PCSRP729-REC          FROM WS-LINE-172.                
                                                                        
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-DETAIL-LINE.                                          
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-DETAIL-LINE-1.           
                                                                        
           ADD 1                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE LINE TOTAL OF THE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-TOTAL-LINE.                                           
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
           MOVE WS-F-ACTIVE-CNT        TO LT-NUM-ACTIVE.                
           MOVE WS-F-PEND-CNT          TO LT-NUM-PEND.                  
           MOVE WS-F-FINAL-CNT         TO LT-NUM-FINAL.                 
           WRITE PCSRP729-REC          FROM WS-LINE-TOTAL.              
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE LINE TOTAL OF THE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-TOTAL-LINE.                                           
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
           MOVE WS-V-ACTIVE-CNT        TO LT-NUM-ACTIVE.                
           MOVE WS-V-PEND-CNT          TO LT-NUM-PEND.                  
           MOVE WS-V-FINAL-CNT         TO LT-NUM-FINAL.                 
           WRITE PCSRP729-REC          FROM WS-LINE-TOTAL.              
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ***                                                           **          
      ***  8500-PRINT-TOTAL-LINE-R                                  **          
      ***      PRINTS THE LINE TOTAL OF THE REPORT                  **          
      ***                                                           **          
      *****************************************************************         
      *                                                                         
       8500-PRINT-TOTAL-LINE-R.                                         
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
           MOVE WS-R-ACTIVE-CNT        TO LT-NUM-ACTIVE.                
           MOVE WS-R-PEND-CNT          TO LT-NUM-PEND.                  
           MOVE WS-R-FINAL-CNT         TO LT-NUM-FINAL.                 
           WRITE PCSRP729-REC          FROM WS-LINE-TOTAL.              
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
                                                                        
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8600-GRAND-TOTAL-LINE                                    **          
      **       PRINTS THE GRAND TOTAL OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8600-GRAND-TOTAL-LINE.                                           
      *                                                                         
           WRITE PCSRP729-REC          FROM WS-BLANK-LINE-172.          
           WRITE PCSRP729-REC          FROM WS-LINE-172.                
           MOVE WS-TOTAL-ALL           TO LT-TITLE.                     
           MOVE WS-G-ACTIVE-CNT        TO LT-NUM-ACTIVE.                
           MOVE WS-G-PEND-CNT          TO LT-NUM-PEND.                  
           MOVE WS-G-FINAL-CNT         TO LT-NUM-FINAL.                 
           WRITE PCSRP729-REC          FROM WS-LINE-TOTAL.              
                                                                        
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8700-REPORT-FINAL-TOTALS.                                **          
      **       PRINTS THE FINAL TOTAL OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8700-REPORT-FINAL-TOTALS.                                        
      *                                                                         
           MOVE WS-TOTAL-FIXED              TO LT-TITLE.                
           PERFORM 8300-PRINT-TOTAL-LINE    THRU 8300-EXIT.             
           MOVE WS-TOTAL-VARIABLE           TO LT-TITLE.                
           PERFORM 8400-PRINT-TOTAL-LINE    THRU 8400-EXIT.             
           MOVE WS-REGULATED                TO LT-TITLE.                
           PERFORM 8500-PRINT-TOTAL-LINE-R  THRU 8500-EXIT.             
           PERFORM 8600-GRAND-TOTAL-LINE    THRU 8600-EXIT.             
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE PCSRP729-FILE.                                         
           IF P729-SUCCESSFUL                                           
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP729 PROCESSING ERROR       **'   
               DISPLAY '** CLOSE ERROR FOR PCSRP729 - OUTPUT FILE **'   
               DISPLAY '**      FILE STATUS = ' WS-P729-STATUS          
           END-IF.                                                      
                                                                        
           CLOSE EXCEP729-FILE.                                         
           IF E729-SUCCESSFUL                                           
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        EXCEP729 PROCESSING ERROR       **'   
               DISPLAY '** CLOSE ERROR FOR EXCEP729 - OUTPUT FILE **'   
               DISPLAY '**      FILE STATUS = ' WS-E729-STATUS          
           END-IF.                                                      
                                                                        
           CLOSE FIOCA729-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM****************************         
