       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSRP712.                                          
       AUTHOR.       BD09555.                                           
       DATE-WRITTEN. JANUARY 2016.                                      
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** PRINT LIST OF EXCEPTION BILLS TO BE PRINTED.                 **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE        USERID   REASON                                  **        
      ** -------     -------  ------                                  **        
      ** 2017-03-08  BD09555  CHANGE INPUT FROM FLAT FILE TO DB2      **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           SELECT SORTEXCP ASSIGN TO UT-S-SORTEXCP.                     
           SELECT PRINTER1 ASSIGN TO UT-S-PRINTER1.                     
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
      *                                                                         
       FD  PRINTER1                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRINT-LINE1                  PIC X(81).                      
      *                                                                         
       SD  SORTEXCP                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  SORTEXCP-RECORD.                                             
           05  FILLER                       PIC X(12).                  
           05  SORTEXCP-ACCOUNT-NO          PIC S9(13) COMP-3.          
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP712'.
MSQ017     COPY MFASQLM.
       77  WS-Y                      PIC X(01)  VALUE 'Y'.              
       77  WS-N                      PIC X(01)  VALUE 'N'.              
       77  WS-PGRMNAME               PIC X(08)  VALUE 'PCSRP712'.       
       77  WS-ACTION                 PIC X(10)  VALUE SPACES.           
       77  WS-CURRENT-DATE           PIC X(10)  VALUE SPACES.           
       77  WS-RETURN-CODE            PIC S9(5)  COMP VALUE +0.          
       77  WS-ACCOUNT-COUNT          PIC S9(5)  COMP VALUE +0.          
       77  WS-LINE-CT1               PIC S9(5)  COMP VALUE +99.         
       77  WS-PAGE-CT1               PIC S9(5)  COMP VALUE +00.         
       77  WS-TOTAL-PAGE-CT          PIC S9(5)  COMP VALUE +00.         
       77  WS-END-OF-FILE            PIC X      VALUE 'N'.              
           88  END-OF-FILE                      VALUE 'Y'.              
       77  WS-END-OF-SORT            PIC X      VALUE 'N'.              
           88  END-OF-SORT                      VALUE 'Y'.              
       77  WS-PROCESS-FLAG           PIC X      VALUE 'N'.              
       77  WS-SCEG-TITLE             PIC X(31)  VALUE                   
           'SOUTH CAROLINA ELECTRIC AND GAS'.                           
       77  WS-PSNC-TITLE             PIC X(31)  VALUE                   
           '          PSNC ENERGY          '.                           
       77  WS-SEB-TITLE              PIC X(31)  VALUE                   
           '         SCANA ENERGY          '.                           
       77  WS-SEBR-TITLE             PIC X(31)  VALUE                   
           '     SCANA ENERGY REGULATED    '.                           
       77  WS-PSNI-TITLE             PIC X(31)  VALUE                   
           '        PSNC INDUSTRIAL        '.                           
       77  WS-IND-TITLE               PIC X(31)  VALUE                  
           '       SCE&&G INDUSTRIAL       '.                           
       01  WS-HEADER1.                                                  
           05  FILLER                PIC X      VALUE SPACES.           
           05  WS-H1-DATE            PIC X(10).                         
           05  FILLER                PIC X(14)  VALUE SPACES.           
           05  WS-H1-COMPANY         PIC X(31).                         
           05  FILLER                PIC X(12)  VALUE SPACES.           
           05  FILLER                PIC X(4)   VALUE 'PAGE'.           
           05  WS-H1-PAGE-CT         PIC ZZ9.                           
           05  FILLER                PIC XXX    VALUE ' OF'.            
           05  WS-H1-TOTAL-PAGES     PIC ZZ9.                           
       01  WS-HEADER2.                                                  
           05  FILLER                PIC X(28)  VALUE ' PCSPR712-001'.  
           05  FILLER                PIC X(23)  VALUE                   
               'EXCEPTION BILLS PRINTED'.                               
       01  WS-HEADER3.                                                  
           05  FILLER                PIC X(33)  VALUE SPACES.           
           05  PILLER                PIC X(14)  VALUE 'ACCOUNT NUMBER'. 
       01  WS-DETAIL-LINE.                                              
           05  FILLER                PIC X(32)  VALUE SPACES.           
           05  WS-DET-ACCOUNT-NO     PIC 9B9999B9999B9999.              
           05  WS-DET-ACCOUNT-NO-A   REDEFINES WS-DET-ACCOUNT-NO        
                                     PIC X(16).                         
       01  WS-TOTAL-LINE.                                               
           05  FILLER                PIC X(29)  VALUE SPACES.           
           05  FILLER                PIC X(14)  VALUE 'TOTAL PRINTED:'. 
           05  WS-DET-TOTAL-COUNT    PIC ZZZZ9.                         
       01  WS-BLANK-LINE             PIC X      VALUE ' '.              
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    DCLGEN FOR CSS_JOB_PARM     (G6)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *    DCLGEN FOR CSS_EXCEPTION_BILL (JW)                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBILLEX                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
           COPY CWS00039.                                                       
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      *                                                                         
           EXEC SQL DECLARE EXCEPTION_CSR CURSOR FOR                    
               SELECT ACCOUNT_NO                                        
                     ,ACCOUNT_SEQ_NO                                    
                     ,BILL_DISP_CD                                      
                     ,BILL_IMAGE_SEQ                                    
                     ,BILL_NO                                           
                     ,COMPANY_NO                                        
                     ,COMPANY_TYPE_CD                                   
                     ,DATE_BILLED                                       
                     ,DEST_CD                                           
                     ,LAST_UPDATE_USERID                                
                     ,PULL_CD                                           
               FROM CSS_EXCEPTION_BILL                                  
           END-EXEC.                                                    
      ******************************************************************        
       LINKAGE SECTION.                                                 
       01  LINK-PARM.                                                   
           05  PARM-LENGTH     PIC S9(4) COMP.                          
           05  PARM-COMPANY    PIC X(4).                                
                                                                        
       PROCEDURE DIVISION USING LINK-PARM.                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION   THRU  0100-EXIT.               
           SORT SORTEXCP                                                
               ASCENDING KEY SORTEXCP-ACCOUNT-NO                        
               INPUT  PROCEDURE 1000-PROCESS-EXCPBILL THRU 1000-EXIT    
               OUTPUT PROCEDURE 2000-PRINT-LISTING    THRU 2000-EXIT.   
           MOVE WS-ACCOUNT-COUNT          TO   WS-DET-TOTAL-COUNT.      
           MOVE WS-TOTAL-LINE             TO   WS-DETAIL-LINE.          
           PERFORM 8000-PRINT-REPORT     THRU  8000-EXIT.               
           PERFORM  9000-TERMINATE                THRU  9000-EXIT.      
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZATION.                                            *        
      *    THE PARM WILL DETERMINE WHICH ACCOUNTS GO ONTO THE REPORT   *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
           EVALUATE PARM-COMPANY                                        
               WHEN 'SCEG'                                              
                   MOVE WS-SCEG-TITLE TO WS-H1-COMPANY                  
               WHEN 'IND '                                              
                   MOVE WS-IND-TITLE  TO WS-H1-COMPANY                  
               WHEN 'PSNC'                                              
                   MOVE WS-PSNC-TITLE TO WS-H1-COMPANY                  
               WHEN 'PSNI'                                              
                   MOVE WS-PSNI-TITLE TO WS-H1-COMPANY                  
               WHEN 'SEBD'                                              
                   MOVE WS-SEB-TITLE  TO WS-H1-COMPANY                  
               WHEN 'SEBR'                                              
                   MOVE WS-SEBR-TITLE TO WS-H1-COMPANY                  
               WHEN OTHER                                               
                   DISPLAY '*******************************************'
                   DISPLAY ' '                                          
                   DISPLAY 'PCSRP712 - INVALID PARM = ' WS-PARM         
                   DISPLAY ' '                                          
                   DISPLAY '*******************************************'
                   MOVE 'Y' TO WS-ERROR-FLAG                            
                   MOVE 12 TO WS-RETURN-CODE                            
                   PERFORM 9000-TERMINATE                               
               END-EVALUATE.                                            
           OPEN OUTPUT PRINTER1                                         
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
           MOVE WS-FCA00-COMMON-DATE (6:5)   TO WS-H1-DATE.             
           MOVE '-'                          TO WS-H1-DATE (6:1).       
           MOVE WS-FCA00-COMMON-DATE (1:4)   TO WS-H1-DATE (7:4).       
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * READ THE EXCEPTIONS FILE.  SELECT THOSE THAT MATCH THE PARM    *        
      * FOR PRINTING LATER.                                            *        
      ******************************************************************        
       1000-PROCESS-EXCPBILL.                                           
           EXEC SQL                                                     
               OPEN EXCEPTION_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               DISPLAY '** PCSRP712 PROCESSING ERROR       **'          
               DISPLAY '** OPEN ERROR ON CURSOR ACCOUNT    **'          
               DISPLAY '** PARA 1000-PROCESS-EXCPBILL      **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           PERFORM 7000-FETCH-EXCPBILL       THRU  7000-EXIT            
           IF SQLCODE = 0                                               
               PERFORM UNTIL SQLCODE NOT = 0                            
                   PERFORM 1200-CHECK-GROUP      THRU  1200-EXIT        
                   PERFORM 7000-FETCH-EXCPBILL   THRU  7000-EXIT        
               END-PERFORM                                              
           ELSE                                                         
               DISPLAY '** PCSRP712 PROCESSING ERROR       **'          
               DISPLAY '** FETCH ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 1000-PROCESS-EXCPBILL      **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE EXCEPTION_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               DISPLAY '** PCSRP712 PROCESSING ERROR       **'          
               DISPLAY '** CLOSE ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 1000-PROCESS-EXCPBILL      **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * 'S' (SECURED) AND 'G' (INDUSTRIAL GAS) ARE SPECIAL CASES THAT  *        
      * HAVE THEIR OWN REPORT RUNS.  WE DON'T PRINT 'P' (CONSOLIDATE). *        
      ******************************************************************        
       1200-CHECK-GROUP.                                                
           MOVE 'N' TO WS-PROCESS-FLAG                                  
           EVALUATE PARM-COMPANY                                        
               WHEN 'SCEG'                                              
                   IF JW-COMPANY-NO = '01'                              
                       IF JW-DEST-CD NOT = 'S' AND 'G' AND 'P'          
                           MOVE 'Y' TO WS-PROCESS-FLAG                  
                           END-IF                                       
                       END-IF                                           
               WHEN 'IND '                                              
                   IF JW-COMPANY-NO = '01'                              
                       IF JW-DEST-CD = 'S' OR 'G'                       
                           MOVE 'Y' TO WS-PROCESS-FLAG                  
                           END-IF                                       
                       END-IF                                           
               WHEN 'PSNC'                                              
                   IF JW-COMPANY-NO = '26'                              
                       IF JW-DEST-CD NOT = 'S' AND 'G' AND 'P'          
                           MOVE 'Y' TO WS-PROCESS-FLAG                  
                       END-IF                                           
                   END-IF                                               
               WHEN 'PSNI'                                              
                   IF JW-COMPANY-NO = '26'                              
                       IF JW-DEST-CD = 'S' OR 'G'                       
                           MOVE 'Y' TO WS-PROCESS-FLAG                  
                       END-IF                                           
                   END-IF                                               
               WHEN 'SEBD'                                              
                   IF JW-COMPANY-TYPE-CD = 'D'                          
                      IF JW-DEST-CD NOT = 'P'                           
                         MOVE 'Y' TO WS-PROCESS-FLAG                    
                      END-IF                                            
                   END-IF                                               
               WHEN 'SEBR'                                              
                   IF JW-COMPANY-TYPE-CD = 'R'                          
                       MOVE 'Y' TO WS-PROCESS-FLAG                      
                   END-IF                                               
               WHEN 'PSNI'                                              
                   IF JW-COMPANY-NO = '26'                              
                       IF JW-DEST-CD = 'S' OR 'G'                       
                           MOVE 'Y' TO WS-PROCESS-FLAG                  
                       END-IF                                           
                   END-IF                                               
               WHEN 'SEBD'                                              
                   IF JW-COMPANY-TYPE-CD = 'D'                          
                      IF JW-DEST-CD NOT = 'P'                           
                         MOVE 'Y' TO WS-PROCESS-FLAG                    
                      END-IF                                            
                   END-IF                                               
               WHEN 'SEBR'                                              
                   IF JW-COMPANY-TYPE-CD = 'R'                          
                       MOVE 'Y' TO WS-PROCESS-FLAG                      
                       END-IF                                           
           END-EVALUATE.                                                
           IF WS-PROCESS-FLAG = 'Y'                                     
                PERFORM 1500-SELECT-ACTION THRU 1500-EXIT               
           END-IF.                                                      
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  DISPLAY WHAT ACTION, IF ANY, WAS TAKEN ON EACH ACCOUNT.      **        
      *  SELECT ONLY THE ONES THAT WERE PRINTED TO SHOW ON THE LIST.  **        
      ******************************************************************        
       1500-SELECT-ACTION.                                              
           MOVE ' ' TO WS-ACTION.                                       
           EVALUATE JW-BILL-DISP-CD                                     
               WHEN 'A'                                                 
                   MOVE 'NO ACTION' TO WS-ACTION                        
               WHEN 'E'                                                 
                   MOVE 'EDITED   ' TO WS-ACTION                        
               WHEN 'L'                                                 
                   MOVE 'PAPERLESS' TO WS-ACTION                        
               WHEN 'M'                                                 
                   MOVE 'REMOVED  ' TO WS-ACTION                        
               WHEN 'P'                                                 
                   MOVE 'PRINTED  ' TO WS-ACTION                        
                   ADD  +1          TO WS-ACCOUNT-COUNT                 
                   RELEASE SORTEXCP-RECORD FROM DCLCSS-EXCEPTION-BILL   
               WHEN 'R'                                                 
                   MOVE 'REBILLED ' TO WS-ACTION                        
               WHEN OTHER                                               
                   STRING 'UKNOWN: ' JW-BILL-DISP-CD DELIMITED BY SIZE  
                       INTO WS-ACTION                                   
           END-EVALUATE.                                                
           DISPLAY JW-ACCOUNT-NO         ' ' JW-DATE-BILLED     ' '     
                   JW-COMPANY-NO         ' ' JW-DEST-CD         ' '     
                   JW-PULL-CD            ' ' JW-BILL-NO         ' '     
                   JW-BILL-IMAGE-SEQ     ' ' JW-ACCOUNT-SEQ-NO  ' '     
                   JW-LAST-UPDATE-USERID ' ' WS-ACTION.                 
       1500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  PROCESS THE SELECTED RECORDS.                                **        
      ******************************************************************        
       2000-PRINT-LISTING.                                              
           COMPUTE WS-TOTAL-PAGE-CT =                                   
                   WS-ACCOUNT-COUNT / 49 + .99.                         
           MOVE WS-TOTAL-PAGE-CT TO WS-H1-TOTAL-PAGES.                  
           PERFORM 7100-READ-SORTEXCP.                                  
           PERFORM UNTIL END-OF-SORT                                    
               PERFORM 8000-PRINT-REPORT                                
               PERFORM 7100-READ-SORTEXCP                               
           END-PERFORM.                                                 
       2000-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
      *================================================================*        
           EXEC SQL                                                             
               INCLUDE CPD00040                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
       7000-FETCH-EXCPBILL.                                             
           EXEC SQL FETCH EXCEPTION_CSR INTO                            
               :JW-ACCOUNT-NO                                           
              ,:JW-ACCOUNT-SEQ-NO                                       
              ,:JW-BILL-DISP-CD                                         
              ,:JW-BILL-IMAGE-SEQ                                       
              ,:JW-BILL-NO                                              
              ,:JW-COMPANY-NO                                           
              ,:JW-COMPANY-TYPE-CD                                      
              ,:JW-DATE-BILLED                                          
              ,:JW-DEST-CD                                              
              ,:JW-LAST-UPDATE-USERID                                   
              ,:JW-PULL-CD                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0 AND 100                                   
               DISPLAY '** PCSRP712 PROCESSING ERROR       **'          
               DISPLAY '** FETCH ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 7000-FETCH-EXCPBILL        **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
       7100-READ-SORTEXCP.                                              
           RETURN SORTEXCP INTO DCLCSS-EXCEPTION-BILL AT END            
               MOVE 'Y' TO WS-END-OF-SORT.                              
       7100-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
      *================================================================*        
      *                                                                         
      *==============================================================*          
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      * 7620-START-FCSCA00 VSAM CTRL FILE      *                                
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  PRINT REPORT.                                                **        
      ******************************************************************        
       8000-PRINT-REPORT.                                               
           IF WS-LINE-CT1 > 55 AND NOT END-OF-SORT                      
              ADD +1 TO WS-PAGE-CT1                                     
              MOVE WS-PAGE-CT1 TO WS-H1-PAGE-CT                         
              WRITE PRINT-LINE1 FROM WS-HEADER1                         
                  AFTER ADVANCING PAGE                                  
              WRITE PRINT-LINE1 FROM WS-HEADER2                         
                  AFTER ADVANCING 1 LINE                                
              WRITE PRINT-LINE1 FROM WS-HEADER3                         
                  AFTER ADVANCING 2 LINES                               
              WRITE PRINT-LINE1 FROM WS-BLANK-LINE                      
                  AFTER ADVANCING 1 LINE                                
              MOVE +7 TO WS-LINE-CT1                                    
           END-IF.                                                      
           IF END-OF-SORT                                               
               WRITE PRINT-LINE1 FROM WS-DETAIL-LINE  AFTER ADVANCING 1 
           ELSE                                                         
               MOVE JW-ACCOUNT-NO TO WS-DET-ACCOUNT-NO                  
               INSPECT WS-DET-ACCOUNT-NO-A REPLACING ALL ' ' BY '-'     
               WRITE PRINT-LINE1 FROM WS-DETAIL-LINE  AFTER ADVANCING 1 
               ADD +1 TO WS-LINE-CT1                                    
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE  PRINTER1.                                             
           IF RETURN-CODE = 0                                           
               MOVE WS-RETURN-CODE TO RETURN-CODE                       
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
