       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP700.                                        
       DATE-WRITTEN.   MAY 1999.                                        
       DATE-COMPILED.  MAY 1999.                                        
      ***************************************************************** 00001400
      **              PROGRAM  MODIFICATION  LOG                     ** 00001600
      ***************************************************************** 00001400
      **    DATE    INITIALS     REASON                              ** 00001700
      **    ----    --------     ------                              ** 00001800
      ***************************************************************** 00008500
A04527**   02/2013   MC95456     REPORT ALL ICS FOR EACH ACCOUNT     **         
ACT120**   04/2016   BD09555     EXTENSIVE CHANGES TO EXTRACT AND    **         
ACT120**A05460-ACT120            SUMMARIZE INFORMATION FOR A         **         
ACT120**                         CONVERSTION TO A SPREADSHEET        **         
      ***************************************************************** 00008500
           REMARKS.                                                     
      ******************************************************************00008700
      *   THIS PROGRAM WILL PRODUCE A REPORT OF INDUSTRIAL CUSTOMERS   *        
      *   WITH A SECURED DEPOSIT.                                      *        
      ******************************************************************00011700
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
HPCCDM*    EJECT                                                        00013200
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00042900
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00042900
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00042900
       FILE-CONTROL.                                                    
           SELECT FCSRP700-FILE                                         
               ASSIGN UT-S-FCSRP700.                                    
           SELECT SORTIO                                                
               ASSIGN UT-S-SORTIO.                                      
           SELECT FCSRP701-FILE                                         
               ASSIGN UT-S-FCSRP701.                                    
      *                                                                 00042900
       DATA DIVISION.                                                   
      *                                                                 00042900
       FILE SECTION.                                                    
      *                                                                 00042900
       FD  FCSRP700-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F.                                         
       01  FIORP700.                                                    
           02  FIORP700-DATA-REC.                                       
               05  E-FRP700-RATES.                                      
                   10 E-FRP700-ELEC-RATES       PIC X(15).              
                   10 E-FRP700-GAS-RATES        PIC X(15).              
                   10 E-FRP700-UNMT-RATES       PIC X(15).              
               05  E-FRP700-ACCOUNT-NO          PIC 9(13).              
               05  COMMA-1                      PIC X.                  
               05  E-FRP700-AMT-DEPOSIT         PIC 999999999V99.       
               05  COMMA-2                      PIC X.                  
               05  E-FRP700-DATE-CERT-ISSUE     PIC X(10).              
               05  COMMA-3                      PIC X.                  
               05  E-FRP700-CODE-REVENUE-CLASS  PIC X(03).              
               05  COMMA-4                      PIC X.                  
               05  E-FRP700-COUNTER             PIC 9(6).               
      *                                                                 00042900
       FD  FCSRP701-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F.                                         
       01  FIORP701.                                                    
           02  FIORP701-DATA-REC.                                       
               05  E-FRP701-RATES.                                      
                   10 E-FRP701-ELEC-RATES       PIC X(15).              
                   10 E-FRP701-GAS-RATE         PIC X(15).              
                   10 E-FRP701-UNMT-RATES       PIC X(15).              
               05  E-FRP701-COMMA1              PIC X.                  
               05  E-DELIM1                     PIC X.                  
               05  E-FRP701-COUNTER             PIC ZZZ,ZZ9.            
               05  E-DELIM2                     PIC X.                  
               05  E-FRP701-COMMA2              PIC X.                  
               05  E-DELIM3                     PIC X.                  
               05  E-FRP701-AMT-DEPOSIT         PIC ZZZ,ZZZ,ZZZ.99.     
               05  E-DELIM4                     PIC X.                  
               05  FILLER                       PIC X(8).               
       SD  SORTIO                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F.                                         
       01  SORTIO-RECORD.                                               
           02  SORT701-DATA-REC.                                        
               05  SORT701-RATES.                                       
                   10 SORT701-ELEC-RATES        PIC X(15).              
                   10 SORT701-GAS-RATES         PIC X(15).              
                   10 SORT701-UNMT-RATES        PIC X(15).              
               05  SORT701-ACCOUNT-NO           PIC 9(13).              
               05  FILLER                       PIC X.                  
               05  SORT701-AMT-DEPOSIT          PIC 999999999V99.       
               05  FILLER                       PIC X.                  
               05  SORT701-DATE-CERT-ISSUE      PIC X(10).              
               05  FILLER                       PIC X.                  
               05  SORT701-CODE-REVENUE-CLASS   PIC X(03).              
               05  FILLER                       PIC X.                  
               05  SORT701-COUNTER              PIC 9(6).               
      *                                                                 00042900
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP700'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                     PIC X(40)                    
               VALUE 'WORKING STORAGE FOR PCSMB700 STARTS HERE'.        
      *                                                                 00042900
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSMB700'.  
      *                                                                 00042900
           05  WS-ERROR-VARIABLES.                                      
               10  RS-RETURN-CODE          PIC S9(04) COMP.             
               10  RS-RETURN-CODE-DISP     PIC +Z(04).                  
      *                                                                 00042900
           05  WS-NO-MORE-DATA             PIC X(01)     VALUE 'N'.     
               88  NO-MORE-DATA                          VALUE 'Y'.     
      *                                                                 00042900
           05  WS-END-OF-SORT              PIC X(01)     VALUE 'N'.     
               88  END-OF-SORT                           VALUE 'Y'.     
      *                                                                 00042900
           05  WS-NO-MORE-CLASS-CSR        PIC X(01)     VALUE 'N'.     
               88  NO-MORE-CLASS-CSR                     VALUE 'Y'.     
      *                                                                 00042900
           05  WS-FIRST-TIME-FOR-ACCT      PIC X(01)     VALUE 'N'.     
               88  FIRST-TIME-FOR-ACCT                   VALUE 'Y'.     
      *                                                                 00042900
      *                                                                 00042900
           05  WS-RESTART-FCSRP700-REC-CNTR                             
                                           PIC S9(07)    COMP-3 VALUE 0.
      *                                                                 00042900
           05  WS-CTR                      PIC 9(06)     VALUE ZEROES.  
      *                                                                         
A04527     05  WS-RATES.                                                
A04527         10 WS-ELEC-RATE             PIC X(03) OCCURS 3 TIMES.    
A04527         10 WS-GAS-RATE              PIC X(03) OCCURS 3 TIMES.    
A04527         10 WS-UNMT-RATE             PIC X(03) OCCURS 3 TIMES.    
      *                                                                         
A04527     05  WS-ELEC-INDX                PIC 9(01)     VALUE 0.       
A04527     05  WS-GAS-INDX                 PIC 9(01)     VALUE 0.       
A04527     05  WS-UNMT-INDX                PIC 9(01)     VALUE 0.       
      *                                                                         
           05  WS-DO-DATE-CERT-ISSUE-NI    PIC S9(04)    COMP VALUE +0. 
      *                                                                 00042900
           05  WS-Y                        PIC X(01)     VALUE 'Y'.     
           05  WS-N                        PIC X(01)     VALUE 'N'.     
           05  WS-1                        PIC 9(01)     VALUE  1.      
           05  WS-2                        PIC 9(01)     VALUE  2.      
           05  WS-3                        PIC 9(01)     VALUE  3.      
           05  WS-DEPOSIT-AMT              PIC 9(9)V99   VALUE 0.       
           05  WS-TOTAL-DEPOSIT-AMOUNT     PIC 9(9)V99   VALUE 0.       
           05  WS-OUT-DEPOSIT-AMOUNT       PIC ZZ,ZZZ,ZZ9.99.           
           05  WS-TOTAL-NUMBER-EDITED      PIC ZZZ,ZZ9.                 
           05  WS-DEPOSIT-NBR              PIC 9(6)      VALUE 0.       
           05  WS-TOTAL-NUMBER             PIC 9(6)      VALUE 0.       
           05  WS-PREVIOUS-RATES           PIC X(36).                   
           05  ROW-FETCHED                 PIC X(01)     VALUE 'N'.     
      *                                                                         
           05  WS-CONVERT-DATE             PIC X(10) VALUE SPACES.      
           05  WS-FORMATTED-DATE           PIC X(10) VALUE SPACES.      
      *                                                                         
           05  WS-AMT-DEPOSIT-TOT      PIC S99999999V99 USAGE COMP-3    
               VALUE ZEROES.                                            
      *                                                                         
           05  WS-CODES-DATA-PRESENT   PIC X(32)    VALUE SPACES.       
           05  WS-CURRENT-DATE         PIC X(10)    VALUE SPACES.       
           05  WS-HEADER-LINE          PIC X(49) VALUE                  
               'ELEC RATE,,,GAS RATE,,,UNMT RATE,,,NUMBER,DEP AMT'.     
      *                                                                         
       01  WS-PREV-RECORD.                                              
           02  WS-PREV-DATA-REC.                                        
               05  WS-PREV-RATES.                                       
                   10 WS-PREV-ELEC-RATES        PIC X(15).              
                   10 WS-PREV-GAS-RATES         PIC X(15).              
                   10 WS-PREV-UNMT-RATES        PIC X(15).              
               05  WS-PREV-ACCOUNT-NO           PIC 9(13).              
               05  FILLER                       PIC X.                  
               05  WS-PREV-AMT-DEPOSIT          PIC 999999999V99.       
               05  FILLER                       PIC X.                  
               05  WS-PREV-DATE-CERT-ISSUE      PIC X(10).              
               05  FILLER                       PIC X.                  
               05  WS-PREV-CODE-REVENUE-CLASS   PIC X(03).              
               05  FILLER                       PIC X.                  
               05  WS-PREV-COUNTER              PIC 9(6).               
      ******************************************************************12820900
      * REPORT DETAIL                                                  *12821200
      ******************************************************************12821400
           COPY CWS00010.                                                       
           COPY CWS09900.                                               00017600
           COPY CWS00303.                                                       
      *                                                                 00042900
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
      *                                                                 00042900
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                 00042900
           EXEC SQL                                                     00043800
               INCLUDE SQLCA                                            00043900
           END-EXEC.                                                    00044000
      *                                                                 00042900
           EXEC SQL                                                     00043800
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                    00044000
      *                                                                 00042900
           EXEC SQL                                                     00043800
               INCLUDE TBCUST                                                   
           END-EXEC.                                                    00044000
      *                                                                 00042900
           EXEC SQL                                                     00043800
               INCLUDE TBNAME                                                   
           END-EXEC.                                                    00044000
      *                                                                 00042900
           EXEC SQL                                                     00045900
               INCLUDE TBDEPHND                                         00046000
           END-EXEC.                                                    00046100
      *                                                                 00042900
           EXEC SQL                                                     00046200
               INCLUDE TBACCT                                           00046300
           END-EXEC.                                                    00046400
      *                                                                 00042900
           EXEC SQL                                                     00046200
               INCLUDE TBUTLENV                                         00046300
           END-EXEC.                                                    00046400
      *                                                                 00042900
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                 00042900
           EXEC SQL                                                             
               INCLUDE TBXREF                                                   
           END-EXEC.                                                            
      *                                                                 00042900
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                 00042900
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 00082000
           EXEC SQL                                                     
            DECLARE DEPOSIT_CURSOR CURSOR FOR                           
             SELECT AT.ACCOUNT_NO,                                      
                    AT.CUSTOMER_NO,                                     
                    DO.AMT_DEPOSIT,                                     
                    DO.DATE_CERT_ISSUE                                  
               FROM CSS_ACCOUNT AT,                                     
                    CSS_DEP_ON_HAND AS DO                               
              WHERE AT.COMPANY_NO = '01'                                
                AND AT.ACCOUNT_NO = DO.ACCOUNT_NO                       
                AND DO.DEPOSIT_STATUS_CD = 'P'                          
           END-EXEC.                                                    
           EXEC SQL                                                     
            DECLARE CLASS_CURSOR CURSOR FOR                             
A04527       SELECT DISTINCT                                            
                    UT.CODE_UTIL_TYPE,                                  
                    UT.RATE_PLAN_NO                                     
               FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                      
A04527        ORDER BY UT.CODE_UTIL_TYPE,UT.RATE_PLAN_NO                
A04527        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CLASS_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT DISTINCT                                                    
MFA-TR*             UT.CODE_UTIL_TYPE,                                          
MFA-TR*             UT.RATE_PLAN_NO                                             
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*       ORDER BY UT.CODE_UTIL_TYPE,UT.RATE_PLAN_NO                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                 00082000
       01  WS-MISC-END.                                                 
           05 WS-END                   PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSMB700 ENDS HERE'.              
HPCCDM*    EJECT                                                        00082400
       PROCEDURE DIVISION.                                              
      ******************************************************************00082600
      * CONTROLS THE MAIN PROCESS OF PROGRAM                           *00082900
      ******************************************************************00083100
       0000-MAINLINE.                                                   
      *                                                                 00083300
           OPEN OUTPUT FCSRP700-FILE.                                   
      *                                                                         
      *                                                                         
           PERFORM 7000-OPEN-DEPOSIT-CURSOR            THRU 7000-EXIT.  
      *                                                                         
           PERFORM 7010-FETCH-DEPOSIT-CURSOR           THRU 7010-EXIT.  
      *                                                                         
           PERFORM 1000-PROCESS-CURSOR                 THRU 1000-EXIT   
               UNTIL NO-MORE-DATA.                                      
      *                                                                         
           MOVE SPACES TO FIORP700.                                     
           PERFORM 7020-CLOSE-DEPOSIT-CURSOR           THRU 7020-EXIT.  
           CLOSE FCSRP700-FILE.                                         
           PERFORM 8000-SORT-OUTPUT                    THRU 8000-EXIT.  
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12820900
      * COMMON INITIALIZATION ROUTINE                                  *12821200
      ******************************************************************12821400
      *                                                                         
      *                                                                 14673800
      ******************************************************************12820900
      * PROCESS DATA FROM DEPOSIT_CURSOR                               *12821200
      ******************************************************************12821400
       1000-PROCESS-CURSOR.                                             
           MOVE WS-Y TO WS-FIRST-TIME-FOR-ACCT.                         
           PERFORM 7100-OPEN-CLASS-CURSOR              THRU 7100-EXIT.  
           PERFORM 4500-DETERMINE-RATES                THRU 4500-EXIT   
              UNTIL NO-MORE-CLASS-CSR.                                  
           MOVE WS-N TO WS-NO-MORE-CLASS-CSR.                           
           PERFORM 7120-CLOSE-CLASS-CURSOR             THRU 7120-EXIT.  
           PERFORM 7010-FETCH-DEPOSIT-CURSOR   THRU 7010-EXIT.          
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14673800
       3000-LOAD-RP700-FILE.                                            
           MOVE AT-ACCOUNT-NO         TO E-FRP700-ACCOUNT-NO.           
           MOVE DO-AMT-DEPOSIT        TO E-FRP700-AMT-DEPOSIT.          
           ADD  DO-AMT-DEPOSIT        TO WS-TOTAL-DEPOSIT-AMOUNT.       
           ADD  +1                    TO WS-TOTAL-NUMBER.               
           MOVE DO-DATE-CERT-ISSUE    TO E-FRP700-DATE-CERT-ISSUE.      
           STRING WS-ELEC-RATE (1) ' ,' WS-ELEC-RATE (2) ' ,'           
                  WS-ELEC-RATE (3) ' ,' WS-GAS-RATE  (1) ' ,'           
                  WS-GAS-RATE  (2) ' ,' WS-GAS-RATE  (3) ' ,'           
                  WS-UNMT-RATE (1) ' ,' WS-UNMT-RATE (2) ' ,'           
                  WS-UNMT-RATE (3) ' ,'                                 
                      DELIMITED BY SIZE INTO E-FRP700-RATES.            
           MOVE ',' TO COMMA-1  COMMA-2  COMMA-3  COMMA-4.              
           MOVE 1                     TO E-FRP700-COUNTER.              
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14673800
      ******************************************************************12820900
      * DETERMINES RATES                                               *12821200
      ******************************************************************12821400
       4500-DETERMINE-RATES.                                            
           PERFORM 7110-FETCH-CLASS-CURSOR             THRU 7110-EXIT.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF FIRST-TIME-FOR-ACCT                                    
                 MOVE WS-N   TO WS-FIRST-TIME-FOR-ACCT                  
A04527           MOVE SPACES TO WS-RATES                                
A04527           MOVE 1      TO WS-ELEC-INDX                            
A04527                          WS-GAS-INDX                             
A04527                          WS-UNMT-INDX                            
                 PERFORM 7200-GET-NAME THRU 7200-EXIT                   
              END-IF                                                    
              PERFORM 4600-LOAD-RATE THRU 4600-EXIT                     
           ELSE                                                         
              IF FIRST-TIME-FOR-ACCT                                    
                 CONTINUE                                               
              ELSE                                                      
SHF              PERFORM 3000-LOAD-RP700-FILE       THRU 3000-EXIT      
SHF              PERFORM 8800-WRITE-FCSRP700        THRU 8800-EXIT      
              END-IF                                                    
           END-IF.                                                      
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12821400
      * LOADS RATES                                                    *12821200
      ******************************************************************12821400
       4600-LOAD-RATE.                                                  
           EVALUATE UT-CODE-UTIL-TYPE                                   
              WHEN 'E'                                                  
A04527           IF WS-ELEC-INDX <= 3                                   
A04527              MOVE UT-RATE-PLAN-NO TO WS-ELEC-RATE(WS-ELEC-INDX)  
A04527              ADD +1               TO WS-ELEC-INDX                
A04527           END-IF                                                 
              WHEN 'G'                                                  
A04527           IF WS-GAS-INDX <= 3                                    
A04527              MOVE UT-RATE-PLAN-NO TO WS-GAS-RATE(WS-GAS-INDX)    
A04527              ADD +1               TO WS-GAS-INDX                 
A04527           END-IF                                                 
              WHEN 'U'                                                  
A04527           IF WS-UNMT-INDX <= 3                                   
A04527              MOVE UT-RATE-PLAN-NO TO WS-UNMT-RATE(WS-UNMT-INDX)  
A04527              ADD +1               TO WS-UNMT-INDX                
A04527           END-IF                                                 
           END-EVALUATE.                                                
       4600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12820900
      * OPEN DEPOSIT_CURSOR                                            *12821200
      ******************************************************************12821400
       7000-OPEN-DEPOSIT-CURSOR.                                        
           EXEC SQL                                                     
               OPEN DEPOSIT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14770300
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSMB700******************'    
               DISPLAY '* 7000 : OPEN DEPOSIT_CURSOR              *'    
               DISPLAY '*        RC = ' SQLCODE                         
               DISPLAY '*****************PCSMB700******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15286300
      ******************************************************************12820900
      * FETCH DEPOSIT_CURSOR                                           *12821200
      ******************************************************************12821400
       7010-FETCH-DEPOSIT-CURSOR.                                       
           EXEC SQL                                                     
              FETCH DEPOSIT_CURSOR INTO                                 
                :AT-ACCOUNT-NO,                                         
                :AT-CUSTOMER-NO,                                        
                :DO-AMT-DEPOSIT,                                        
                :DO-DATE-CERT-ISSUE :WS-DO-DATE-CERT-ISSUE-NI            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15286300
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-Y TO WS-NO-MORE-DATA                              
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DO-DATE-CERT-ISSUE-NI < 0                           
                 MOVE SPACES TO DO-DATE-CERT-ISSUE                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7010-FETCH-DEPOSIT-CURSOR            **'      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7010 : RETURN CODE ERROR - FETCH       '      
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12821400
      * CLOSE DEPOSIT CURSOR                                           *12821200
      ******************************************************************12821400
       7020-CLOSE-DEPOSIT-CURSOR.                                       
           EXEC SQL                                                     
              CLOSE DEPOSIT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT: ' AT-ACCOUNT-NO                      
              DISPLAY '** 7020 :  RETURN CODE ERROR - CLOSE  '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12820900
      * OPEN CLASS_CURSOR                                              *12821200
      ******************************************************************12821400
       7100-OPEN-CLASS-CURSOR.                                          
           EXEC SQL                                                     
               OPEN CLASS_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14770300
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSMB700******************'    
               DISPLAY '* 7100 : OPEN CLASS_CURSOR                *'    
               DISPLAY '*        RC = ' SQLCODE                         
               DISPLAY '*****************PCSMB700******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15286300
      ******************************************************************12820900
      * FETCH CLASS_CURSOR                                             *12821200
      ******************************************************************12821400
       7110-FETCH-CLASS-CURSOR.                                         
           EXEC SQL                                                     
              FETCH CLASS_CURSOR INTO                                   
                :UT-CODE-UTIL-TYPE,                                     
                :UT-RATE-PLAN-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15286300
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-Y TO WS-NO-MORE-CLASS-CSR                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7110-FETCH-CLASS-CURSOR              **'      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7110 : RETURN CODE ERROR - FETCH       '      
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12821400
      * CLOSE CLASS CURSOR                                             *12821200
      ******************************************************************12821400
       7120-CLOSE-CLASS-CURSOR.                                         
           EXEC SQL                                                     
              CLOSE CLASS_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT: ' AT-ACCOUNT-NO                      
              DISPLAY '** 7120 :  RETURN CODE ERROR - CLOSE  '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12821400
      * GET CUSTOMER NAME                                              *12821400
      ******************************************************************12821400
       7200-GET-NAME.                                                   
           EXEC SQL                                                     
               SELECT DQ.FULL_NAME                                      
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_CUSTOMER CU, CSS_NAME DQ                      
                WHERE CU.CUSTOMER_NO    =  :AT-CUSTOMER-NO              
                  AND CU.NAME_ID        =  DQ.NAME_ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7200 :  RETURN CODE ERROR - SELECT '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           EXIT
           END-IF.                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
       8000-SORT-OUTPUT.                                                
           OPEN OUTPUT FCSRP701-FILE.                                   
           MOVE WS-HEADER-LINE  TO FIORP701.                            
           PERFORM 8900-WRITE-FCSRP701 THRU 8900-EXIT.                  
           SORT SORTIO                                                  
               ASCENDING KEY SORT701-ELEC-RATES                         
                             SORT701-GAS-RATES                          
                             SORT701-UNMT-RATES                         
               USING FCSRP700-FILE                                      
               OUTPUT PROCEDURE 8100-COMBINE-RATES THRU 8100-EXIT       
           MOVE WS-PREV-RATES           TO E-FRP701-RATES.              
           MOVE WS-DEPOSIT-AMT          TO E-FRP701-AMT-DEPOSIT.        
           MOVE ','                     TO E-FRP701-COMMA2.             
           MOVE '"'                     TO E-DELIM1 E-DELIM2            
                                           E-DELIM3 E-DELIM4.           
           MOVE WS-DEPOSIT-NBR          TO E-FRP701-COUNTER.            
           PERFORM 8900-WRITE-FCSRP701 THRU 8900-EXIT.                  
           MOVE WS-TOTAL-DEPOSIT-AMOUNT TO WS-OUT-DEPOSIT-AMOUNT.       
           MOVE SPACES                  TO FIORP701.                    
           MOVE WS-TOTAL-NUMBER         TO WS-TOTAL-NUMBER-EDITED.      
           STRING ',,,,,,,,TOTAL:,"'                                    
                  WS-TOTAL-NUMBER-EDITED,                               
                  '","'                                                 
                  WS-OUT-DEPOSIT-AMOUNT                                 
                  '"'                                                   
                      DELIMITED BY SIZE INTO FIORP701.                  
           PERFORM 8900-WRITE-FCSRP701 THRU 8900-EXIT.                  
           CLOSE FCSRP701-FILE.                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-COMBINE-RATES.                                              
           PERFORM 8200-RETURN-SORT THRU 8200-EXIT.                     
           MOVE SORTIO-RECORD TO WS-PREV-RECORD.                        
           PERFORM UNTIL END-OF-SORT                                    
               IF SORT701-RATES  = WS-PREV-RATES                        
                   ADD SORT701-AMT-DEPOSIT  TO WS-DEPOSIT-AMT           
                   ADD +1                   TO WS-DEPOSIT-NBR           
               ELSE                                                     
                   MOVE WS-PREV-RATES       TO E-FRP701-RATES           
                   MOVE WS-DEPOSIT-AMT      TO E-FRP701-AMT-DEPOSIT     
                   MOVE ','                 TO E-FRP701-COMMA2          
                   MOVE '"'                 TO E-DELIM1 E-DELIM2        
                                               E-DELIM3 E-DELIM4        
                   MOVE WS-DEPOSIT-NBR      TO E-FRP701-COUNTER         
                   PERFORM 8900-WRITE-FCSRP701 THRU 8900-EXIT           
                   MOVE 1                   TO WS-DEPOSIT-NBR           
                   MOVE SORT701-AMT-DEPOSIT TO WS-DEPOSIT-AMT           
                   MOVE SORT701-RATES       TO WS-PREV-RATES            
               END-IF                                                   
               PERFORM 8200-RETURN-SORT THRU 8200-EXIT                  
           END-PERFORM.                                                 
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-RETURN-SORT.                                                
           RETURN SORTIO AT END                                         
               MOVE 'Y' TO WS-END-OF-SORT.                              
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12820900
      * WRITE FILE                                                              
      ******************************************************************12820900
      *                                                                         
      *                                                                         
       8800-WRITE-FCSRP700.                                             
           WRITE FIORP700.                                              
           INITIALIZE FIORP700.                                         
           ADD 1                       TO WS-RESTART-FCSRP700-REC-CNTR. 
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8900-WRITE-FCSRP701.                                             
           WRITE FIORP701.                                              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ************************************************************              
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING ROUTINE.                   
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************    08140000
      * THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE              *    08150000
      * 9900-ABEND                                                 *            
      **************************************************************    08160000
           EXEC SQL                                                     08170000
               INCLUDE CPD09900                                         08180001
           END-EXEC.                                                    08190000
                                                                        
