       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP691.                                            
       DATE-WRITTEN.   AUG 2002.                                        
       AUTHOR.                                                          
       *****************************************************************
       **               SOUTH CAROLINA ELECTRIC & GAS                 **
       **                         COVANSYS                            **
       **                CUSTOMER INFORMATION SYSTEM                  **
       *****************************************************************
       **                                                             **
       **                P R O G R A M S U M M A R Y                  **
       **                                                             **
       **                                                             **
       **         F U N C T I O N A L  D E S C R I P T I O N          **
       **                         O F  M O D U L E                    **
       **                                                             **
       **  PURPOSE :                                                  **
       **                                                             **
       **  PRODUCE A TREASURER'S 'A' CHECK REGISTER REPORT, WITH      **
       **  SEB REPORT FOLLOWED BY SEBR REPORT.                        **
       *****************************************************************
       **                                                             **
       **              PROGRAM  MODIFICATION  LOG                     **
       **                                                             **
       **     DATE       INITIALS              REASON                 **
       **   04-10-2001   COVANSYS              NEW REPORT PROGRAM     **
       **                                      FOR REPORT GENERATION  **
T29328 **   27-10-2003   COVANSYS              ADDED CODE TO CHECK    **
T29328 **                                      WHETHER AN ACCT IS A   **
T29328 **                                      SERVICE CARE ACCT,     **
T29328 **                                      INDICATOR IS ADDED IN  **
T29328 **                                      THE REPORT.            **
T29328 **   12/04/03     COVANSYS              INCLUDED CHECK FOR     **
T29328 **                                      LOCAL OFFICES 301 & 302**
T29328 **                                      TO VALIDATE FOR SERVICE**
T29328 **                                      CARE ACCOUNTS          **
C32206 **   7/20/06      AP40911             1.USE NEW USER TABLE FOR **
C32206 **                                      CHECK_ISS_REAS_CD      **
C32206 **                                    2.ADD 'FOR FETCH ONLY'   **
C32206 **                                      TO THE MAIN SELECT     **
C32206 **                                      CURSORS.                 
C32206 ** 08/11/2006  AP40911     MADE CHANGES TO ALLOW CHECK REASON  **
C32206 **                         CODE TO BE EXTRACTED FROM THE       **
C32206 **                         CSS_REFUND_REASON TABLE.            **
C35152 ** 03/11/2008  VP94820    -REMOVED ADDRESS AND SERVICE IND     **
C35152 **                         FROM PAGE HEADERS.                  **
P00599 ** 25/09/2012  AS7C117    -USE FCSRP691 INSTEAD OF RP000 AS    **
P00599 **                         INPUT.                              **
       *****************************************************************
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION & INPUT PROCESSING   
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
P00599     COPY CSSRP691.                                                       
           COPY CSSPT33.                                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
P00599     COPY CFDRP691.                                                       
P00599     COPY FIORP691.                                                       
           COPY CFDPT33.                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP691'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP691 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-COUNT                  PIC S9(05) COMP-3              
                                                    VALUE +0.           
           05  WS-TOTAL-COUNT            PIC S9(07) COMP-3              
                                                    VALUE +0.           
           05  WS-PER-TEMP-TOT           PIC S9(07) COMP-3              
                                                    VALUE +0.           
           05  WS-PER-TOT                PIC S9(03)V99 COMP-3           
                                                    VALUE +0.           
           05  WS-ACCOUNT-NO             PIC 9(13).                     
           05  WS-LOC-OFF-NO             PIC X(03)  VALUE SPACES.       
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  WS-MAX-LINES              PIC 9(02)  VALUE 56.           
           05  WS-LINE-COUNT             PIC 9(02)  VALUE 57.           
           05  WS-PAGE-COUNT             PIC 9(03)  VALUE 1.            
           05  WS-ERR-MSG                PIC X(40)  VALUE SPACES.       
           05  WS-PGRMNAME               PIC X(10)  VALUE 'PCSRP691'.   
           05  WS-COMP-NAME              PIC X(31)  VALUE SPACES.       
           05  WS-BLANK-LINE             PIC X(132) VALUE SPACES.       
           05  WS-DASHES                 PIC X(132) VALUE ALL '-'.      
           05  WS-PRT33-RECORD           PIC X(133) VALUE SPACES.       
           05  WS-NULL-INDICATOR-1       PIC S9(04) USAGE COMP.         
           05  WS-TOT-AMT                PIC 9(11)V99                   
                                                    VALUE ZEROES.       
           05  WS-REF-DESC               PIC X(28)  VALUE SPACES.       
           05  WS-FIRST-CHK-NUM          PIC 9(09)  VALUE ZEROES.       
           05  WS-LAST-CHK-NUM           PIC 9(09)  VALUE ZEROES.       
           05  WS-PREV-LAST-CHK-NUM      PIC 9(09)  VALUE ZEROES.       
           05  WS-NO-CHK-ISS             PIC 9(09)  VALUE ZEROES.       
           05  WS-SEBR-COMP-NAME         PIC X(35)  VALUE               
                  'SCANA ENERGY - REGULATED DIVISION  '.                
           05  WS-SEB-COMP-NAME          PIC X(35)  VALUE               
                  'SCANA ENERGY - DEREGULATED DIVISION'.                
           05  WS-REQ-DT.                                               
               10  WS-REQ-DT-CC          PIC X(02)  VALUE SPACES.       
               10  WS-REQ-DT-YY          PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-REQ-DT-MM          PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-REQ-DT-DD          PIC X(02)  VALUE SPACES.       
                                                                        
T29328     05  WS-LOC-301                PIC X(03)  VALUE '301'.        
T29328     05  WS-LOC-302                PIC X(03)  VALUE '302'.        
T29328     05  WS-LOC-303                PIC X(03)  VALUE '303'.        
T29328     05  WS-SERVICE                PIC X(12)                      
T29328                                   VALUE 'SERVICE CARE'.          
           05  P-REQ-DT.                                                
               10  P-REQ-DT-MM           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  P-REQ-DT-DD           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  P-REQ-DT-YY           PIC X(02)  VALUE SPACES.       
                                                                        
           05  WS-TRAN-DATE.                                            
               10  WS-TRAN-MM            PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-TRAN-DD            PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-TRAN-YY            PIC X(02)  VALUE SPACES.       
                                                                        
           05  WS-JOB-PARM               PIC X(10)  VALUE SPACES.       
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                PIC X(02).                     
               10  WS-JOB-PARM-YEAR      PIC X(02).                     
               10  FILLER                PIC X(01).                     
               10  WS-JOB-PARM-MONTH     PIC X(02).                     
               10  FILLER                PIC X(01).                     
               10  WS-JOB-PARM-DAY       PIC X(02).                     
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                    PIC X(55)  VALUE SPACES.       
           05  FILLER                    PIC X(22)  VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                    PIC X(55)  VALUE SPACES.       
                                                                        
       01  WS-END-DATA-LINE.                                            
           05  FILLER                    PIC X(56)  VALUE SPACES.       
           05  FILLER                    PIC X(21)                      
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                    PIC X(55)  VALUE SPACES.       
                                                                        
       01  WS-REPORT-TITLES.                                            
           05  WS-DEFAULT-COMP-NO        PIC X(02)  VALUE '01'.         
           05  WS-DEFAULT-RPT1-HEAD      PIC X(50)  VALUE               
               '          TREASURER''S ''A'' CHECK REGISTER          '. 
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-0                      PIC 9(01)  VALUE 0.            
           05  WS-1                      PIC 9(01)  VALUE 1.            
           05  WS-10                     PIC 9(02)  VALUE 10.           
           05  WS-57                     PIC 9(02)  VALUE 57.           
           05  WS-100                    PIC 9(03)  VALUE 100.          
           05  WS-811                    PIC S9(9)  VALUE -811.         
           05  WS-X                      PIC 9(03)  VALUE 1.            
           05  WS-Z                      PIC 9(03)  VALUE 1.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FIRST-TIME             PIC X(01)  VALUE 'Y'.          
               88  FIRST-TIME                       VALUE 'Y'.          
               88  NOT-FIRST-TIME                   VALUE 'N'.          
           05  WS-SEBR-ACCT              PIC X(01)  VALUE 'N'.          
               88  SEBR-ACCT                        VALUE 'Y'.          
               88  NOT-SEBR-ACCT                    VALUE 'N'.          
           05  WS-SEB-ACCT               PIC X(01)  VALUE 'N'.          
               88  SEB-ACCT                         VALUE 'Y'.          
               88  NOT-SEB-ACCT                     VALUE 'N'.          
           05  WS-SEB-PRESENT            PIC X(01)  VALUE 'N'.          
               88  SEB-PRESENT                      VALUE 'Y'.          
               88  NOT-SEB-PRESENT                  VALUE 'N'.          
           05  WS-SEB-FIRST-TIME         PIC X(01)  VALUE 'Y'.          
               88  SEB-FIRST-TIME                   VALUE 'Y'.          
               88  NOT-SEB-FIRST-TIME               VALUE 'N'.          
           05  WS-SEBR-FIRST-TIME        PIC X(01)  VALUE 'Y'.          
               88  SEBR-FIRST-TIME                  VALUE 'Y'.          
               88  NOT-SEBR-FIRST-TIME              VALUE 'N'.          
           05  WS-SEBR-PRESENT           PIC X(01)  VALUE 'N'.          
               88  SEBR-PRESENT                     VALUE 'Y'.          
               88  NOT-SEBR-PRESENT                 VALUE 'N'.          
           05  WS-FIRST-HEADER           PIC X(01)  VALUE 'Y'.          
               88  FIRST-HEADER                     VALUE 'Y'.          
               88  NOT-FIRST-HEADER                 VALUE 'N'.          
           05  WS-CSH-LOC-OFF-FLAG       PIC X(01)  VALUE 'N'.          
               88  CSH-LOC-OFF-FLAG                 VALUE 'Y'.          
               88  NOT-CSH-LOC-OFF-FLAG             VALUE 'N'.          
           05  WS-COMP-NO-FLAG           PIC X(01)  VALUE 'N'.          
               88  COMP-NO-FLAG                     VALUE 'Y'.          
               88  NOT-COMP-NO-FLAG                 VALUE 'N'.          
P00599     05  WS-FRP691-STATUS          PIC X(02).                     
P00599         88  FRP691-SUCCESSFUL                VALUE '00'.         
P00599     05  WS-FRP691-EOF             PIC X(01)  VALUE 'N'.          
P00599         88  END-OF-FRP691-FILE               VALUE 'Y'.          
           05  WS-FCSPT33-STATUS         PIC X(02)  VALUE '00'.         
               88  FCSPT33-SUCCESSFUL               VALUE '00'.         
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
           05  WS-RPT-TITLE.                                            
               10  P-RPT-PGRMNAME        PIC X(08).                     
               10  FILLER                PIC X(46)  VALUE SPACES.       
                                                                        
               10  P-RPT-COMPANY-NAME    PIC X(35).                     
               10  FILLER                PIC X(24)  VALUE SPACES.       
                                                                        
               10  FILLER                PIC X(11)  VALUE               
                                                'RUN DATE:  '.          
               10  P-RPT-RUN-DATE        PIC X(08).                     
                                                                        
T29328     05  WS-SERV-WRITTEN           PIC X(01)    VALUE 'Y'.        
T29328         88 SERV-WRITTEN                        VALUE 'Y'.        
T29328         88 SERV-NOT-WRITTEN                    VALUE 'N'.        
T29328                                                                  
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE          **           
      ***************************************************************           
           05  WS-RPT1-COLUMN-HEADER-1.                                 
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(10)  VALUE               
                                           'ACCOUNT NO'.                
               10  FILLER                PIC X(121) VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-2.                                 
               10  FILLER                PIC X(01)  VALUE SPACES.       
T29328*        10  FILLER                PIC X(04)  VALUE                       
T29328*                                    'NAME'.                              
T29328         10  FILLER                PIC X(07)  VALUE               
C35152                                     '       '.                   
T29328         10  FILLER                PIC X(80)  VALUE SPACES.       
T29328*        10  FILLER                PIC X(83)  VALUE SPACES.               
               10  FILLER                PIC X(13)  VALUE               
                                           'REFUND REASON'.             
               10  FILLER                PIC X(19)  VALUE SPACES.       
               10  FILLER                PIC X(12)  VALUE               
                                           'CHECK NUMBER'.              
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-3.                                 
               10  FILLER                PIC X(01)  VALUE SPACES.       
T29328*        10  FILLER                PIC X(07)  VALUE                       
T29328*                                    'ADDRESS'.                           
T29328         10  FILLER                PIC X(15)  VALUE               
C35152                                     '               '.           
T29328         10  FILLER                PIC X(36)  VALUE SPACES.       
T29328*        10  FILLER                PIC X(44)  VALUE SPACES.               
               10  FILLER                PIC X(07)  VALUE               
                                           'MAIL TO'.                   
               10  FILLER                PIC X(29)  VALUE SPACES.       
               10  FILLER                PIC X(12)  VALUE               
                                           'REQUEST DATE'.              
               10  FILLER                PIC X(20)  VALUE SPACES.       
               10  FILLER                PIC X(12)  VALUE               
                                           'CHECK AMOUNT'.              
T29328     05  WS-RPT1-COLUMN-HEADER-4.                                 
T29328         10  FILLER                PIC X(01)  VALUE SPACES.       
T29328         10  FILLER                PIC X(04)  VALUE               
T29328                                     'NAME'.                      
T29328         10  FILLER                PIC X(127) VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **    WORKING STORAGE FOR THE DETAIL LINES OF THE TREASURER'S **          
      **    'A' CHECK REGISTER REPORT                               **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-1.                                   
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  P-ACCOUNT-NUMBER      PIC 9(13)  VALUE ZEROES.       
               10  FILLER                PIC X(74)  VALUE SPACES.       
               10  P-REASON-REF-1        PIC X(28)  VALUE SPACES.       
               10  FILLER                PIC X(06)  VALUE SPACES.       
               10  P-CHECK-NUMBER        PIC ZZZZZZZZ99.                
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-2.                                   
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  P-CUSTOMER-NAME       PIC X(50).                     
               10  FILLER                PIC X(37)  VALUE SPACES.       
               10  P-REQUEST-DATE        PIC X(08)  VALUE SPACES.       
               10  FILLER                PIC X(22)  VALUE SPACES.       
               10  P-CHECK-AMOUNT        PIC ZZZ,ZZZ,ZZ9.99.            
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-3.                                   
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  P-SERVICE-ADDR-1      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(16)  VALUE SPACES.       
               10  P-MAILING-ADDR-1      PIC X(50)  VALUE SPACES.       
               10  FILLER                PIC X(30)  VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-4.                                   
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  P-SERVICE-ADDR-2      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(16)  VALUE SPACES.       
               10  P-MAILING-ADDR-2      PIC X(50)  VALUE SPACES.       
               10  FILLER                PIC X(30)  VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-5.                                   
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  P-SERVICE-ADDR-3      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(16)  VALUE SPACES.       
               10  P-MAILING-ADDR-3      PIC X(50)  VALUE SPACES.       
               10  FILLER                PIC X(30)  VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-6.                                   
               10  FILLER                PIC X(52)  VALUE SPACES.       
               10  P-MAILING-ADDR-4      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(45)  VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-7.                                   
               10  FILLER                PIC X(52)  VALUE SPACES.       
               10  P-MAILING-ADDR-5      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(45)  VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-8.                                   
               10  FILLER                PIC X(52)  VALUE SPACES.       
               10  P-MAILING-ADDR-6      PIC X(35)  VALUE SPACES.       
               10  FILLER                PIC X(45)  VALUE SPACES.       
           05  FILLER                    PIC X(60)  VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **  WORKING STORAGE FOR THE COLUMN HEADERS OF THE CONTROL     **          
      **  TOTALS ON REFUND CHECKS REPORT                            **          
      ****************************************************************          
      *                                                                         
       01  WS-TOTALS-HEADERS.                                           
      *                                                                         
           05  WS-RPT-TOT-LINE-1.                                       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(26)                      
                   VALUE 'FIRST CHECK NUMBER ISSUED:'.                  
               10  FILLER                PIC X(15)  VALUE SPACES.       
               10  P-FIRST-CHK-NUM       PIC 9(10)  VALUE ZEROES.       
      *                                                                         
           05  WS-RPT-TOT-LINE-2.                                       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(25)                      
                   VALUE 'LAST CHECK NUMBER ISSUED:'.                   
               10  FILLER                PIC X(16)  VALUE SPACES.       
               10  P-LAST-CHK-NUM        PIC 9(10)  VALUE ZEROES.       
      *                                                                         
           05  WS-RPT-TOT-LINE-3.                                       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(30)                      
                   VALUE 'TOTAL NUMBER OF CHECKS ISSUED:'.              
               10  FILLER                PIC X(11)  VALUE SPACES.       
               10  P-TOT-NO-CHKS         PIC Z(09)9 VALUE ZEROES.       
      *                                                                         
           05  WS-RPT-TOT-LINE-4.                                       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(22)                      
                   VALUE 'TOTAL AMOUNT REFUNDED:'.                      
               10  FILLER                PIC X(12)  VALUE SPACES.       
               10  P-TOT-AMT             PIC ZZ,ZZZ,ZZZ,ZZ9.99          
                  VALUE ZEROES.                                         
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME               PIC 9(08).                     
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-RECORD-FOUND           PIC X(01)  VALUE 'N'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
      * JOBS FILE/TABLE DEFINITIONS                                             
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      * CWS00079 CONTAINS WS FOR PROCESSING JOB_PARM                            
       COPY CWS00038.                                                           
      * CWS00039 IS CA00 WORK DATA                                              
       COPY CWS00039.                                                           
      * CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                              
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                                   
       COPY CWS00010.                                                           
      * CWS00079 CONTAINS VARIABLES FOR REPORT HEADER                           
       COPY CWS00079.                                                           
                                                                        
      *                                                                         
       01  WS-COMPANY-NO                 PIC X(02).                     
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * Y2 - CSS_CASHIER_OFFICE                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCSHOFF                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
C32206*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C32206* CSS_REFUND_REASON                                             *         
C32206*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C32206     EXEC SQL                                                             
C32206         INCLUDE TBRFNRSN                                                 
C32206     END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_REFUND                                                    *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_DELINQUENCY                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *    CSS_JOB_PARM                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *---------------------------------------------------------------*         
      *      CURSOR FOR GETTING ROWS FROM CSS_REFUND                  *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
                DECLARE REFUND-CUR CURSOR FOR                           
                SELECT  RN.CHECK_ISS_REAS_CD                            
                       ,RN.REFUND_ITEM_ID                               
C32206                 ,RU.CHECK_ISS_RSN_DESC                           
                FROM    CSS_REFUND RN WITH(READUNCOMMITTED)                     
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
C32206                 ,CSS_REFUND_REASON RU WITH(READUNCOMMITTED)              
C32206          WHERE   RN.MANUAL_INDICATOR IN ('M','S') AND            
                        RN.CHECK_STATUS_CD  = 'I'                 AND   
                        RN.ACCOUNT_NO       =  AT.ACCOUNT_NO      AND   
                        RN.ACCOUNT_NO       = :RN-ACCOUNT-NO      AND   
                        RN.LOCAL_OFFICE     = :RN-LOCAL-OFFICE    AND   
                        AT.COMPANY_NO       = :AT-COMPANY-NO            
                ORDER BY RN.REFUND_ITEM_ID DESC                         
C32206          FOR READ ONLY                                          
C32206                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE REFUND-CUR CURSOR FOR                                   
MFA-TR*         SELECT  RN.CHECK_ISS_REAS_CD                                    
MFA-TR*                ,RN.REFUND_ITEM_ID                                       
MFA-TR*                ,RU.CHECK_ISS_RSN_DESC                                   
MFA-TR*         FROM    CSS_REFUND RN                                           
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_REFUND_REASON RU                                    
MFA-TR*         WHERE   RN.MANUAL_INDICATOR IN ('M','S') AND                    
MFA-TR*                 RN.CHECK_STATUS_CD  = 'I'                 AND           
MFA-TR*                 RN.ACCOUNT_NO       =  AT.ACCOUNT_NO      AND           
MFA-TR*                 RN.ACCOUNT_NO       = :RN-ACCOUNT-NO      AND           
MFA-TR*                 RN.LOCAL_OFFICE     = :RN-LOCAL-OFFICE    AND           
MFA-TR*                 AT.COMPANY_NO       = :AT-COMPANY-NO                    
MFA-TR*         ORDER BY RN.REFUND_ITEM_ID DESC                                 
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
       01  WS-END                        PIC X(40)  VALUE               
          'WORKING STORAGE FOR PCSRP691 ENDS HERE  '.                   
                                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  0000-MAINLINE.                                              **        
      **       CONTROLS MAIN PATH OF PROGRAM                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION                                  
              THRU 1000-EXIT.                                           
                                                                        
           PERFORM 1100-MAIN-PROCESS-PARA                               
              THRU 1100-EXIT.                                           
                                                                        
           PERFORM 8450-PRINT-RPT-FOOTER                                
              THRU 8450-EXIT.                                           
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1000-INITIALIZATION.                                       **        
      **        INITIALIZATION ROUTINE                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1000-INITIALIZATION.                                             
                                                                        
      * GET CURRENT DATE                                                        
                                                                        
           ACCEPT WS-CURRENT-DATE              FROM DATE.               
           MOVE   WS-CURRENT-YY                TO WS-RD-YY.             
           MOVE   WS-CURRENT-MM                TO WS-RD-MM.             
           MOVE   WS-CURRENT-DD                TO WS-RD-DD.             
           MOVE   WS-RUN-DATE                  TO P-RPT-RUN-DATE.       
                                                                        
      * GET CURRENT TIME                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME              FROM TIME.               
           MOVE   WS-CURRENT-TIME(1:2)         TO WS-RT-HH.             
           MOVE   WS-CURRENT-TIME(3:2)         TO WS-RT-MM.             
           MOVE   WS-CURRENT-TIME(5:2)         TO WS-RT-SS.             
           MOVE   WS-RUN-TIME                  TO P-RPT1-RUN-TIME.      
                                                                        
P00599     OPEN INPUT  FCSRP691-FILE                                    
                OUTPUT FCSPT33-FILE.                                    
                                                                        
           IF FCSPT33-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS           TO WS-DISP-RC            
              MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH   
              MOVE ' ERROR IN OPENING FCSPT33 FILE.'                    
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
P00599     IF FRP691-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
P00599        MOVE WS-FRP691-STATUS            TO WS-DISP-RC            
              MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH   
              MOVE ' ERROR IN OPENING FCSRP691 FILE.'                   
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
           END-IF.                                                      
           MOVE WS-INPUT-DATE                  TO WS-JOB-PARM.          
           MOVE WS-JOB-PARM-YEAR               TO WS-TD-YY.             
           MOVE WS-JOB-PARM-MONTH              TO WS-TD-MM.             
           MOVE WS-JOB-PARM-DAY                TO WS-TD-DD.             
           MOVE WS-H-TRAN-DATE                 TO P-RPT1-TRAN-DATE      
                                                  P-RPT1-REPORT-DATE.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1100-MAIN-PROCESS-PARA.                                    **        
      **        MAIN PROCESS                                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1100-MAIN-PROCESS-PARA.                                          
                                                                        
P00599     PERFORM 7000-READ-FCSRP691-FILE     THRU 7000-EXIT           
P00599          UNTIL END-OF-FRP691-FILE.                               
           IF NOT-SEBR-PRESENT                                          
P00599         MOVE E-RP691-REFND-CHK-NO       TO WS-LAST-CHK-NUM       
                                                                        
               PERFORM 8350-PRINT-RPT-TOTALS   THRU 8350-EXIT           
               MOVE WS-PGRMNAME                TO P-RPT-PGRMNAME        
               MOVE WS-SEBR-COMP-NAME          TO P-RPT-COMPANY-NAME    
               MOVE WS-57                      TO WS-LINE-COUNT         
               MOVE 1                          TO WS-PAGE-COUNT         
               PERFORM 8300-PRINT-RPT-HEADERS  THRU 8300-EXIT           
               PERFORM 8400-PRINT-NO-DATA      THRU 8400-EXIT           
           ELSE                                                         
P00599         MOVE E-RP691-REFND-CHK-NO       TO WS-LAST-CHK-NUM       
               PERFORM 8350-PRINT-RPT-TOTALS   THRU 8350-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2000-PROCESS-SUCCES-PARA                                    **        
      **       WHEN THE READ FROM THE FILE IS SUCCESSFUL DO THIS PARA **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2000-PROCESS-SUCCES-PARA.                                        
                                                                        
           IF FIRST-TIME                                                
              MOVE WS-PGRMNAME                 TO P-RPT-PGRMNAME        
              MOVE WS-DEFAULT-RPT1-HEAD        TO P-RPT1-HEADER         
              MOVE WS-SEB-COMP-NAME            TO P-RPT-COMPANY-NAME    
                                                                        
              PERFORM 8300-PRINT-RPT-HEADERS   THRU 8300-EXIT           
                                                                        
              SET NOT-FIRST-TIME               TO TRUE                  
           END-IF.                                                      
           MOVE WS-LAST-CHK-NUM                TO WS-PREV-LAST-CHK-NUM. 
           SET NOT-SEBR-ACCT                   TO TRUE.                 
           SET NOT-SEB-ACCT                    TO TRUE.                 
                                                                        
P00599     IF E-RP691-SEB-REG-GRP-CD = SPACES                           
              SET SEB-ACCT                     TO TRUE                  
              IF SEB-FIRST-TIME                                         
P00599            MOVE E-RP691-REFND-CHK-NO    TO WS-FIRST-CHK-NUM      
                  SET NOT-SEB-FIRST-TIME       TO TRUE                  
              END-IF                                                    
              PERFORM 2100-PROCESS-REPORT-PARA THRU 2100-EXIT           
              SET SEB-PRESENT                  TO TRUE                  
           END-IF.                                                      
                                                                        
P00599     IF E-RP691-SEB-REG-GRP-CD NOT EQUAL SPACES                   
              SET SEBR-ACCT                    TO TRUE                  
              IF SEB-PRESENT                                            
                  MOVE WS-PREV-LAST-CHK-NUM    TO WS-LAST-CHK-NUM       
                                                                        
                  PERFORM 8350-PRINT-RPT-TOTALS                         
                                               THRU 8350-EXIT           
                  MOVE WS-57                   TO WS-LINE-COUNT         
                  MOVE 1                       TO WS-PAGE-COUNT         
                  MOVE WS-PGRMNAME             TO P-RPT-PGRMNAME        
                  MOVE WS-SEBR-COMP-NAME       TO P-RPT-COMPANY-NAME    
                  PERFORM 8300-PRINT-RPT-HEADERS                        
                                               THRU 8300-EXIT           
                  SET NOT-SEB-PRESENT          TO TRUE                  
                  SET NOT-SEB-FIRST-TIME       TO TRUE                  
                  INITIALIZE                      WS-NO-CHK-ISS         
                                                  WS-TOT-AMT            
              ELSE                                                      
                  IF NOT-SEB-PRESENT AND SEB-FIRST-TIME                 
                     PERFORM 8400-PRINT-NO-DATA                         
                                               THRU 8400-EXIT           
                     MOVE WS-PGRMNAME          TO P-RPT-PGRMNAME        
                     MOVE WS-SEBR-COMP-NAME    TO P-RPT-COMPANY-NAME    
                                                                        
                     MOVE WS-57                TO WS-LINE-COUNT         
                     MOVE 1                    TO WS-PAGE-COUNT         
                     PERFORM 8300-PRINT-RPT-HEADERS                     
                                               THRU 8300-EXIT           
                     SET NOT-SEB-FIRST-TIME    TO TRUE                  
                  END-IF                                                
              END-IF                                                    
              IF SEBR-FIRST-TIME                                        
P00599            MOVE E-RP691-REFND-CHK-NO    TO WS-FIRST-CHK-NUM      
                                                                        
                  SET NOT-SEBR-FIRST-TIME      TO TRUE                  
              END-IF                                                    
              PERFORM 2100-PROCESS-REPORT-PARA THRU 2100-EXIT           
                                                                        
              SET SEBR-PRESENT                 TO TRUE                  
           END-IF.                                                      
P00599     MOVE E-RP691-REFND-CHK-NO           TO WS-LAST-CHK-NUM.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2100-PROCESS-REPORT-PARA                                    **        
      **       REPORT PREOCESSING PARA                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2100-PROCESS-REPORT-PARA.                                        
                                                                        
           MOVE '2100'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
                                                                        
           MOVE SPACES                         TO P-SERVICE-ADDR-1      
                                                  P-MAILING-ADDR-1      
                                                  P-SERVICE-ADDR-2      
                                                  P-MAILING-ADDR-2      
                                                  P-SERVICE-ADDR-3      
                                                  P-MAILING-ADDR-3      
                                                  P-MAILING-ADDR-4      
                                                  P-MAILING-ADDR-5      
                                                  P-MAILING-ADDR-6.     
P00599     MOVE E-RP691-LOCAL-OFF-NO           TO RN-LOCAL-OFFICE.      
P00599     MOVE E-RP691-ACCOUNT-NO             TO RN-ACCOUNT-NO.        
P00599     MOVE E-RP691-COMPANY-NO             TO AT-COMPANY-NO.        
                                                                        
           PERFORM 7100-OPEN-REFUND-CUR        THRU 7100-EXIT.          
           PERFORM 7110-FETCH-REFUND-CUR       THRU 7110-EXIT.          
           PERFORM 7120-CLOSE-REFUND-CUR       THRU 7120-EXIT.          
           PERFORM 8320-WRITE-DET-LINE         THRU 8320-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2200-PROCESS-NOTFOUND-PARA                                  **        
      **       WHEN THE READ FROM THE FILE IS NOT SUCCESSFUL THEN     **        
      **            PROCESS THIS PARA                                 **        
      ******************************************************************        
                                                                        
       2200-PROCESS-NOTFOUND-PARA.                                      
                                                                        
           IF FIRST-TIME                                                
               MOVE WS-PGRMNAME                TO P-RPT-PGRMNAME        
               MOVE WS-DEFAULT-RPT1-HEAD       TO P-RPT1-HEADER         
               MOVE 1                          TO WS-PAGE-COUNT         
               MOVE WS-DEFAULT-COMP-NO         TO C7-COMPANY-NO         
               MOVE WS-SEB-COMP-NAME           TO P-RPT-COMPANY-NAME    
                                                                        
               PERFORM 8300-PRINT-RPT-HEADERS  THRU 8300-EXIT           
                                                                        
               PERFORM 8400-PRINT-NO-DATA      THRU 8400-EXIT           
                                                                        
               MOVE WS-SEBR-COMP-NAME          TO P-RPT-COMPANY-NAME    
               MOVE WS-57                      TO WS-LINE-COUNT         
               MOVE 1                          TO WS-PAGE-COUNT         
               PERFORM 8300-PRINT-RPT-HEADERS  THRU 8300-EXIT           
                                                                        
               PERFORM 8400-PRINT-NO-DATA      THRU 8400-EXIT           
                                                                        
               GO TO 1100-EXIT                                          
                                                                        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 6251-GET-FJC01-DATE                                         **         
      *****************************************************************         
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ******************************************************************        
P00599* READS THE INPUT FILE FCSRP691 AT END SETS END-OF-FILE TO TRUE  *        
      ******************************************************************        
                                                                        
P00599 7000-READ-FCSRP691-FILE.                                         
                                                                        
                                                                        
P00599     READ FCSRP691-FILE                                           
               AT END                                                   
P00599            SET END-OF-FRP691-FILE       TO TRUE.                 
                                                                        
                                                                        
           IF  FRP691-SUCCESSFUL                                        
               PERFORM 2000-PROCESS-SUCCES-PARA                         
                                               THRU 2000-EXIT           
           ELSE                                                         
P00599         IF WS-FRP691-STATUS = WS-10                              
                   PERFORM 2200-PROCESS-NOTFOUND-PARA                   
                                               THRU 2200-EXIT           
               ELSE                                                     
                  DISPLAY '** PCSRP691 PROCESSING ERROR        **'      
P00599            DISPLAY '** SELECT ERROR-FCSRP691-FILE       **'      
P00599            DISPLAY '** PARA 7000-READ-FCSRP691-FILE     **'      
P00599            DISPLAY '** STATUS  IS  ** ' WS-FRP691-STATUS         
                  DISPLAY '** PROCESSING TERMINATED            **'      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7100-OPEN-REFUND-CUR.                                 **              
      **     OPEN THE REFUND CURSOR                             **              
      **                                                        **              
      ************************************************************              
      *                                                                         
       7100-OPEN-REFUND-CUR.                                            
      *                                                                         
           EXEC SQL                                                     
                OPEN REFUND-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '** PCSRP691 PROCESSING ERROR        **'          
              DISPLAY '** OPEN ERROR REFUND,ACCOUNT        **'          
              DISPLAY '** PARA 7100-OPEN-REFUND-CUR        **'          
              DISPLAY '** SQLCODE IS  ** ' SQLCODE                      
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7110-FETCH-REFUND-CUR.                                **              
      **      SELECTS CHECK_ISS_REAS_CD FORM CSS_REFUND TABLE   **              
      **      FOR THE ACCOUNTS AVAILABLE IN INPUT FILE          **              
      ************************************************************              
      *                                                                         
       7110-FETCH-REFUND-CUR.                                           
      *                                                                         
           EXEC SQL                                                     
                FETCH REFUND-CUR                                        
                INTO :RN-CHECK-ISS-REAS-CD,                             
                     :RN-REFUND-ITEM-ID,                                
C32206               :RU-CHECK-ISS-RSN-DESC                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '** PCSRP691 PROCESSING ERROR        **'          
              DISPLAY '** OPEN ERROR REFUND,ACCOUNT        **'          
              DISPLAY '** PARA 7110-FETCH-REFUND-CUR       **'          
              DISPLAY '** SQLCODE IS  ** ' SQLCODE                      
              DISPLAY '** ACCOUNT NO  ** ' RN-ACCOUNT-NO                
              DISPLAY '** LOCAL OFF   ** ' RN-LOCAL-OFFICE              
              DISPLAY '** COMPANY NO  ** ' AT-COMPANY-NO                
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ************************************************************              
      **  7120-CLOSE-REFUND-CUR.                                **              
      **     CLOSE THE REFUND CURSOR                            **              
      **                                                        **              
      ************************************************************              
      *                                                                         
       7120-CLOSE-REFUND-CUR.                                           
      *                                                                         
           EXEC SQL                                                     
                CLOSE REFUND-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '** PCSRP691 PROCESSING ERROR        **'          
              DISPLAY '** OPEN ERROR REFUND,ACCOUNT        **'          
              DISPLAY '** PARA 7120-CLOSE-REFUND-CUR       **'          
              DISPLAY '** SQLCODE IS  ** ' SQLCODE                      
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7600-START-FCJ01                                            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** 7600-START-FCJ01                                            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                              *         
      **  8100-WRITE-RPT.                                             *         
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE *         
      **                                                              *         
      *****************************************************************         
                                                                        
       8100-WRITE-RPT.                                                  
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              MOVE PRT33-RECORD                TO WS-PRT33-RECORD       
              MOVE WS-PGRMNAME                 TO P-RPT-PGRMNAME        
              MOVE WS-DEFAULT-RPT1-HEAD        TO P-RPT1-HEADER         
              MOVE WS-SEB-COMP-NAME            TO P-RPT-COMPANY-NAME    
              PERFORM 8300-PRINT-RPT-HEADERS   THRU 8300-EXIT           
              MOVE WS-PRT33-RECORD             TO PRT33-RECORD          
           END-IF.                                                      
                                                                        
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-HEADERS.                                          
                                                                        
           IF SEBR-ACCT                                                 
               MOVE WS-PGRMNAME                TO P-RPT-PGRMNAME        
               MOVE WS-SEBR-COMP-NAME          TO P-RPT-COMPANY-NAME    
           END-IF.                                                      
                                                                        
           MOVE WS-PAGE-COUNT                  TO P-RPT1-PAGE-NO.       
           MOVE WS-RPT-TITLE                   TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           MOVE WS-RPT1-HEADER-1               TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT..         
           MOVE WS-RPT1-HEADER-2               TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           MOVE WS-RPT1-COLUMN-HEADER-1        TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
T29328     MOVE WS-RPT1-COLUMN-HEADER-4        TO PRT33-DATA.           
T29328     PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           MOVE WS-RPT1-COLUMN-HEADER-2        TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           MOVE WS-RPT1-COLUMN-HEADER-3        TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           MOVE WS-DASHES                      TO PRT33-DATA.           
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           ADD 1                               TO WS-PAGE-COUNT.        
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      **                                                              **        
      **   8320-WRITE-DET-LINE                                        **        
      **       WRITES THE DETAILS TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8320-WRITE-DET-LINE.                                             
                                                                        
P00599     MOVE E-RP691-CUSTOMER-NAME          TO P-CUSTOMER-NAME.      
P00599     MOVE E-RP691-REFND-CHK-AMT          TO P-CHECK-AMOUNT.       
P00599     ADD  E-RP691-REFND-CHK-AMT          TO WS-TOT-AMT.           
P00599     MOVE E-RP691-REFND-CHK-NO           TO P-CHECK-NUMBER.       
           ADD 1                               TO WS-NO-CHK-ISS.        
P00599     MOVE E-RP691-ACCOUNT-NO             TO P-ACCOUNT-NUMBER.     
C32206*    MOVE SPACES                         TO WS-REF-DESC.                  
C32206     MOVE RU-CHECK-ISS-RSN-DESC          TO P-REASON-REF-1.       
P00599     MOVE E-RP691-REFND-DT(3:2)          TO P-REQ-DT-YY.          
P00599     MOVE E-RP691-REFND-DT(6:2)          TO P-REQ-DT-MM.          
P00599     MOVE E-RP691-REFND-DT(9:2)          TO P-REQ-DT-DD.          
           MOVE P-REQ-DT                       TO P-REQUEST-DATE.       
P00599     MOVE E-RP691-MAILING-ADDRESS(1)     TO P-MAILING-ADDR-1.     
P00599     MOVE E-RP691-MAILING-ADDRESS(2)     TO P-MAILING-ADDR-2.     
P00599     MOVE E-RP691-MAILING-ADDRESS(3)     TO P-MAILING-ADDR-3.     
P00599     MOVE E-RP691-MAILING-ADDRESS(4)     TO P-MAILING-ADDR-4.     
P00599     MOVE E-RP691-MAILING-ADDRESS(5)     TO P-MAILING-ADDR-5.     
P00599     MOVE E-RP691-MAILING-ADDRESS(6)     TO P-MAILING-ADDR-6.     
P00599     MOVE E-RP691-SERVICE-ADDR(1)     TO P-SERVICE-ADDR-1.        
P00599     MOVE E-RP691-SERVICE-ADDR(2)     TO P-SERVICE-ADDR-2.        
P00599     MOVE E-RP691-SERVICE-ADDR(3)     TO P-SERVICE-ADDR-3.        
                                                                        
           MOVE WS-RPT1-DETAIL-LINE-1          TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-RPT1-DETAIL-LINE-2          TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-RPT1-DETAIL-LINE-3          TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-RPT1-DETAIL-LINE-4          TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
T29328     SET SERV-NOT-WRITTEN                TO   TRUE.               
           IF ( P-SERVICE-ADDR-3 > SPACES ) OR                          
                 ( P-MAILING-ADDR-3 > SPACES )                          
               MOVE WS-RPT1-DETAIL-LINE-5      TO PRT33-RECORD          
T29328         IF ( P-SERVICE-ADDR-3 = SPACES ) AND                     
P00599               ( E-RP691-LOCAL-OFF-NO = WS-LOC-301 OR WS-LOC-302  
T29328                                                   OR WS-LOC-303) 
T29328             MOVE WS-SERVICE             TO   PRT33-RECORD(2:12)  
T29328             SET SERV-WRITTEN            TO   TRUE                
T29328         END-IF                                                   
               PERFORM 8100-WRITE-RPT          THRU 8100-EXIT           
           END-IF.                                                      
           IF ( P-MAILING-ADDR-4 > SPACES )                             
               MOVE WS-RPT1-DETAIL-LINE-6      TO PRT33-RECORD          
T29328         IF ( SERV-NOT-WRITTEN ) AND                              
P00599            ( E-RP691-LOCAL-OFF-NO = WS-LOC-301 OR WS-LOC-302     
T29328                                                OR WS-LOC-303)    
T29328             MOVE WS-SERVICE             TO   PRT33-RECORD(2:12)  
T29328         END-IF                                                   
T29328         PERFORM 8100-WRITE-RPT          THRU 8100-EXIT           
T29328     ELSE                                                         
T29328         IF ( SERV-NOT-WRITTEN ) AND                              
P00599           ( E-RP691-LOCAL-OFF-NO = WS-LOC-301 OR WS-LOC-302      
T29328                                               OR WS-LOC-303)     
T29328             MOVE WS-SERVICE             TO   PRT33-RECORD(2:12)  
                   PERFORM 8100-WRITE-RPT      THRU 8100-EXIT           
T29328         END-IF                                                   
           END-IF.                                                      
           IF ( P-MAILING-ADDR-6 > SPACES )                             
               MOVE WS-RPT1-DETAIL-LINE-7      TO PRT33-RECORD          
               PERFORM 8100-WRITE-RPT          THRU 8100-EXIT           
           END-IF.                                                      
           IF ( P-MAILING-ADDR-6 > SPACES )                             
               MOVE WS-RPT1-DETAIL-LINE-8      TO PRT33-RECORD          
               PERFORM 8100-WRITE-RPT          THRU 8100-EXIT           
           END-IF.                                                      
           MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8350-PRINT-RPT-TOTALS.                                      **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8350-PRINT-RPT-TOTALS.                                           
                                                                        
           MOVE WS-FIRST-CHK-NUM               TO P-FIRST-CHK-NUM.      
           MOVE WS-RPT-TOT-LINE-1              TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-LAST-CHK-NUM                TO P-LAST-CHK-NUM.       
           MOVE WS-RPT-TOT-LINE-2              TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-NO-CHK-ISS                  TO P-TOT-NO-CHKS.        
           MOVE WS-RPT-TOT-LINE-3              TO PRT33-RECORD.         
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE WS-TOT-AMT                     TO P-TOT-AMT.            
           MOVE WS-RPT-TOT-LINE-4              TO PRT33-RECORD .        
           PERFORM 8100-WRITE-RPT              THRU 8100-EXIT.          
           MOVE ZEROES                         TO WS-TOT-AMT.           
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-NO-DATA.                                         **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8400-PRINT-NO-DATA.                                              
                                                                        
           MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           ADD  WS-1                           TO WS-LINE-COUNT.        
           MOVE WS-NO-DATA-LINE                TO PRT33-RECORD.         
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8450-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8450-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
           ADD  WS-1                           TO WS-LINE-COUNT.        
           MOVE WS-END-DATA-LINE               TO PRT33-RECORD.         
           PERFORM 8900-WRITE-RPT-LINE         THRU 8900-EXIT.          
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **                                                              *         
      **  8900-WRITE-RPT-LINE.                                        *         
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE *         
      **                                                              *         
      *****************************************************************         
                                                                        
       8900-WRITE-RPT-LINE.                                             
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              WRITE PRT33-RECORD AFTER ADVANCING TOP-OF-PAGE            
              MOVE  WS-0                       TO WS-LINE-COUNT         
           ELSE                                                         
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
T29328     INITIALIZE                          PRT33-RECORD.            
           ADD  WS-1                           TO WS-LINE-COUNT.        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE                                           
P00599           FCSRP691-FILE.                                         
                                                                        
           IF FCSPT33-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS           TO WS-DISP-RC            
              MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH   
              MOVE ' ERROR IN CLOSING FCSPT33 FILE.'                    
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
P00599     IF FRP691-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
P00599        MOVE WS-FRP691-STATUS            TO WS-DISP-RC            
              MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH   
              MOVE ' ERROR IN CLOSING FCSAC172 FILE.'                   
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY WS-DISP-RC,'  WS-ACTIVE-RETURN-CODE  '.              
           DISPLAY '**********************************'.                
           DISPLAY '** PROCESSING ERROR             **'.                
           DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH.              
           DISPLAY '** ', WS-ERR-MSG.                                   
           DISPLAY '** SQLCODE   = ', WS-DISP-RC.                       
           DISPLAY '** PROCESSING TERMINATED        **'.                
           DISPLAY '**********************************'.                
           PERFORM 9900-ABEND                  THRU 9900-EXIT.          
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      ** COPYBOOK FOR ABEND ROUTINE                                   **        
      **                                                              **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
