       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP666.                                        
       AUTHOR.         ROGER D FAULK                                    
       INSTALLATION.                                                    
       DATE-WRITTEN.   SEPTEMBER 2014.                                  
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      ** 30 SEP 2014 RF10596       STATE OF GEORGIA REPORT OF       **          
      **                           RATE 457/458 ACCOUNTS WHERE      **          
      **                           AT.CODE_LPC_XMT = SPACE AND/OR   **          
      **                           UT.CODE_STAT_TAX_XMT = SPACE.    **          
      **                           ALSO CHECK FOR MASTER ACCOUNTS   **          
      **                           WITH AT.CODE_LPC_XMT = SPACE     **          
      **                                                            **          
      **  2 OCT 2014 RF10596       HARD CODE BASIS AMOUNTS FOR CHECK**          
      **                                                            **          
A04880** 29 OCT 2014 RF10596       CHANGE PRINTER TO 133            **          
      **                                                            **          
A04880** 30 OCT 2014 RF10596       RESET HARD CODED BASIS FACTORS   **          
A04880**                           TO OLD FACTORS                   **          
      **                                                            **          
A04880**  4 NOV 2014 RF10596       CORRECT WS-BASIS-AMT LOAD        **          
      **                                                            **          
A04880**  9 DEC 2014 RF10596       NEW HARD CODED BASIS FACTORS     **          
A04880**                           FOR THE NEW YEAR                 **          
      **                                                            **          
A05136** 19 DEC 2014 RF10596       ADD HARD CODED BASIS FACTOR      **          
A05136**                           0.4740 FOR RATE 458              **          
      **                                                            **          
A05136** 26 JUN 2015 RF10596       ADD RATE 192 AND OPTION CODE     **          
A05136**                           CM303C03X192                     **          
      **                                                            **          
A05136**  9 JUL 2015 RF10596       CORRECT RATE 458 COMPARE         **          
      **                                                            **          
A05136** 24 SEP 2015 RF10596       NEW RATE 458 RATE BASIS          **          
      **                                                            **          
A05462** 20 OCT 2016 DB41297       NEW RATE 457/458 RATE BASIS      **          
      **                                                            **          
A05462** 22 NOV 2016 DB41297       NEW RATES FOR 457                **          
      **                                                            **          
A05460** 30 NOV 2016 RF10596       CHANGE TABLE USED IN PARAGRAPH   **          
A05460**                           7090-GET-LPC-DESCRIPTION FROM    **          
A05460**                           CSS_LPC_REASON TO CSS_CODE_VALUE **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSRP666 NARRATIVE                        
           PROGRAM SELECTS FROM TABLES WHERE RATE 457/458 ACCOUNTS      
           HAVE AT.CODE_LPC_XMT = SPACE AND/OR                          
           UT.CODE_STAT_TAX_XMT = SPACE. IF SO, PUT IT ON THE REPORT.   
           ALSO, WHEN ACCOUNT IS A SUB CHECK TO SEE IF THE MASTER       
           ACCOUNT HAS AT.CODE_LPC_XMT = SPACE.  IF YES, PUT IT         
           ON THE REPORT.                                               
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
A04880 COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
A04880 COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP666'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-LINE-COUNT               PIC S9(3) COMP-3 VALUE +66.    
          05 WS-LINE-COUNTX REDEFINES WS-LINE-COUNT PIC X(2).           
          05 WS-PAGE-COUNT               PIC S9(3) COMP-3 VALUE ZEROS.  
      *                                                                         
       01  PROGRAM-NAME                PIC X(8)    VALUE 'PCSRP666'.    
      *                                                                         
       01  WS-WORK-AREA.                                                
A05460     05  WS-CODE-VALUE           PIC X          VALUE SPACES.     
           05  WS-RATE-SW              PIC X          VALUE 'N'.        
A04880     05  WS-0-0440               PIC 9(9)V9999  VALUE 0.0440.     
A04880     05  WS-0-0460               PIC 9(9)V9999  VALUE 0.0460.     
A05136     05  WS-0-4740               PIC 9(9)V9999  VALUE 0.4740.     
A05136     05  WS-0-3640               PIC 9(9)V9999  VALUE 0.3640.     
A05046     05  WS-0-3890               PIC 9(9)V9999  VALUE 0.3890.     
A05046     05  WS-0-0410               PIC 9(9)V9999  VALUE 0.0410.     
A05046     05  WS-0-1680               PIC 9(9)V9999  VALUE 0.1680.     
           05  WS-DESCRIPTION          PIC X(20) VALUE SPACES.          
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-MST-LIT              PIC X(3)    VALUE 'MST'.         
           05  WS-SUB-LIT              PIC X(3)    VALUE 'SUB'.         
           05  WS-MASTER-RPT-SUB       PIC X       VALUE 'N'.           
           05  WS-L                    PIC X       VALUE 'L'.           
           05  WS-MASTER-LPC-XMT       PIC X       VALUE SPACES.        
           05  WS-MASTER-BILL-CYCLE    PIC XX      VALUE SPACES.        
           05  WS-SUB                  PIC S9(3) COMP-3 VALUE 0.        
           05  WS-BASIS-AMT            PIC 9(9)V9999  VALUE 0.          
           05  WS-DATA-SW              PIC X       VALUE 'N'.           
           05  WS-EXEMPT-SW            PIC X       VALUE 'N'.           
           05  WS-COMPANY-PARM         PIC XX      VALUE '01'.          
           05  RS-RETURN-CODE          PIC S9(4)   VALUE ZEROS COMP.    
           05  RS-RETURN-CODE-DISP     PIC +Z(4).                       
           05  WS-ACCOUNT-NO           PIC 9(13)   VALUE ZEROS.         
           05  WS-811                  PIC S9(9)   VALUE -811 COMP.     
           05  WS-803                  PIC S9(9)   VALUE -803 COMP.     
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSRP666'.    
      *                                                                         
       01  WS-RATE-457.                                                 
           05  WS-RATE457          PIC X(3)   VALUE '457'.              
           05  WS-RATE457-CHARGE   PIC S9(5)V99 COMP-3 VALUE 0.         
       01  WS-RATE-458.                                                 
           05  WS-RATE458          PIC X(3)   VALUE '458'.              
           05  WS-RATE458-CHARGE   PIC S9(5)V99 COMP-3 VALUE 0.         
A05136 01  WS-RATE-192.                                                 
A05136     05  WS-RATE192          PIC X(3)   VALUE '192'.              
A05136     05  WS-RATE192-CHARGE   PIC S9(5)V99 COMP-3 VALUE 0.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUB-ACCT                 PIC X    VALUE 'S'.          
           05  WS-YES                      PIC X    VALUE 'Y'.          
           05  WS-NO                       PIC X    VALUE 'N'.          
           05  WS-GAS                      PIC X    VALUE 'G'.          
           05  WS-BASIS                    PIC X(9) VALUE 'BASIS'.      
      *                                                                         
       01 WS-MASTER-ACCT-TABLE.                                         
          05 WS-MASTER-ACCT OCCURS 100 TIMES.                           
              10 WS-MASTER-ACCOUNT      PIC 9(13).                      
      *                                                                         
       01 HEADER1.                                                      
          05 HDR1-CC            PIC X     VALUE '1'.                    
          05 FILLER             PIC X(11) VALUE 'PCSRP666-01'.          
          05 FILLER             PIC X(48) VALUE SPACES.                 
          05 WS-COMPANY-NAME    PIC X(12) VALUE 'SCANA ENERGY'.         
          05 FILLER             PIC X(25) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN DATE:  '.          
          05 HDR-DATE           PIC X(17) VALUE SPACES.                 
          05 FILLER             PIC X(8)  VALUE SPACES.                 
      *                                                                         
       01 HEADER2.                                                      
          05 HDR2-CC            PIC X     VALUE ' '.                    
          05 FILLER             PIC X(44) VALUE SPACES.                 
          05 FILLER             PIC X(42) VALUE                         
             'STATE OF GEORGIA ACCOUNTS EXCEPTION REPORT'.              
          05 FILLER             PIC X(10) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN TIME:  '.          
          05 HDR-TIME           PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC XX    VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'PAGE = '.              
          05 HDR-PAGE           PIC ZZ9.                                
          05 FILLER             PIC X(5)  VALUE SPACES.                 
      *                                                                         
       01 HEADER3.                                                      
          05 HDR3-CC            PIC X     VALUE ' '.                    
          05 FILLER             PIC X(98) VALUE SPACES.                 
          05 FILLER             PIC X(18)  VALUE 'LATE PAY EXEMPTION'.  
          05 FILLER             PIC X(16)  VALUE SPACES.                
      *                                                                         
       01 HEADER4.                                                      
          05 HDR4-CC            PIC X     VALUE ' '.                    
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'ACCOUNT'.              
          05 FILLER             PIC X(5)  VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'MST/SUB'.              
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(5)  VALUE 'CYCLE'.                
          05 FILLER             PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC X(12) VALUE 'BASIS FACTOR'.         
          05 FILLER             PIC X(6)  VALUE SPACES.                 
          05 FILLER             PIC X(4)  VALUE 'USER'.                 
          05 FILLER             PIC X(7)  VALUE SPACES.                 
          05 FILLER             PIC X(13) VALUE 'EFF FROM DATE'.        
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'EFF TO DATE'.          
          05 FILLER             PIC X(4)  VALUE SPACES.                 
          05 FILLER             PIC X(19) VALUE 'STATE TAX EXEMPTION'.  
          05 FILLER             PIC X(7)  VALUE SPACES.                 
          05 FILLER             PIC X(3)  VALUE 'CSC'.                  
          05 FILLER             PIC X(5)  VALUE SPACES.                 
      *                                                                         
       01 NO-DATA-LINE.                                                 
          05 NO-CC                    PIC X     VALUE '0'.              
          05 FILLER                   PIC X(24) VALUE SPACES.           
A05136    05 NO-DATA-LITERAL          PIC X(21)                         
A05136              VALUE 'NO DATA FOR THIS RUN '.                      
A05136    05 FILLER                   PIC X(87) VALUE SPACES.           
      *                                                                         
       01 PRINT-LINE.                                                   
          05 FILLER                PIC X     VALUE SPACES.              
          05 PRT-ACCOUNT           PIC X(13).                           
          05 FILLER                PIC X(4)  VALUE SPACES.              
          05 PRT-MST-SUB           PIC X(3).                            
          05 FILLER                PIC X(7)  VALUE SPACES.              
          05 PRT-BILL-CYCLE        PIC XX.                              
          05 FILLER                PIC X(7)  VALUE SPACES.              
          05 PRT-BASIS-FACTOR      PIC --------9.9999.                  
          05 FILLER                PIC X(5)  VALUE SPACES.              
          05 PRT-CREATED-USERID    PIC X(7).                            
          05 FILLER                PIC X(5)  VALUE SPACES.              
          05 PRT-EFF-DATE-FROM     PIC X(10).                           
          05 FILLER                PIC X(6)  VALUE SPACES.              
          05 PRT-EFF-DATE-TO       PIC X(10).                           
          05 FILLER                PIC X(7)  VALUE SPACES.              
          05 PRT-CODE-LPC-XMT      PIC X(20).                           
          05 FILLER                PIC XX    VALUE SPACES.              
          05 PRT-CHARGE            PIC ----9.99.                        
          05 FILLER                PIC XX    VALUE SPACES.              
      *                                                                         
       01 PRINT-LINE2.                                                  
          05 FILLER                PIC X(101) VALUE SPACES.             
          05 PRT-CODE-STAT-TAX-XMT PIC X(20).                           
          05 FILLER                PIC X(12)  VALUE SPACES.             
      *                                                                         
      ****************************************************************          
      *  CWS00303  WORKING STORAGE FIELDS                            *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900                                 *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - REPORT DATE                   *          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_UTIL_ENVRNMT  -  UT                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_COMPANY                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_RATE_VRSN_DEF  -  J4               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTVRSN                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_FIXED_FCTR  -  FF                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_MSTSUB_ACCT -  MU                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSTSUB                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_RTPK_AGR  -  DF               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A05460*   DCLGEN COPYBOOK FOR CSS_CODE_VALUE - UV                    *          
      ****************************************************************          
      *                                                                         
A05460     EXEC SQL                                                             
A05460         INCLUDE TBCDVALU                                                 
A05460     END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      CURSOR TO GET ALL OF THE ACCOUNTS FOR RATES 457 , 458  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE EXEMPT_CRSR CURSOR FOR                             
              SELECT AT.ACCOUNT_NO                                      
                    ,AT.CODE_LPC_XMT                                    
                    ,UT.CODE_STAT_TAX_XMT                               
                    ,AT.MST_SUB_ACCT_IND                                
                    ,UT.CODE_UTIL_TYPE                                  
                    ,UT.IC_NO                                           
                    ,UT.RT_PKG_OPT_SEQ_NO                               
                    ,AT.BILL_CYCLE                                      
                    ,UT.RATE_PLAN_NO                                    
              FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE UT.ACCOUNT_NO = AT.ACCOUNT_NO                       
                AND AT.CODE_ACCT_STAT = 'A'                             
A05136          AND UT.RATE_PLAN_NO IN ('457','458','192')              
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE EXEMPT_CRSR CURSOR FOR                                     
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.CODE_LPC_XMT                                            
MFA-TR*             ,UT.CODE_STAT_TAX_XMT                                       
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*             ,UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*       FROM   CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE UT.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND AT.CODE_ACCT_STAT = 'A'                                     
MFA-TR*         AND UT.RATE_PLAN_NO IN ('457','458','192')                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7021                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7010-OPEN-EXEMPT-CRSR THRU 7010-EXIT.                
      *                                                                         
           PERFORM 7021-FETCH-EXEMPT-CRSR THRU 7021-EXIT.               
      *                                                                         
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT                 
             UNTIL WS-EXEMPT-SW = WS-YES.                               
      *                                                                         
           PERFORM 7030-CLOSE-EXEMPT-CRSR THRU 7030-EXIT.               
      *                                                                         
           IF WS-DATA-SW = 'N'                                          
              MOVE NO-DATA-LINE TO PRINT-LINE                           
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
A04880        MOVE PRINT-LINE TO PRT33-RECORD                           
              PERFORM 8900-WRITE-REPORT THRU 8900-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
      ****************************************************************          
      *   INITIAL ROUTINE - OPEN OUTPUT FILE                         *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
A04880     OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
           MOVE WS-CURRENT-TIMESTAMP(12:8) TO HDR-TIME.                 
           MOVE WS-CURRENT-DATE TO HDR-DATE.                            
      *                                                                         
           MOVE WS-RATE457 TO J4-RATE-PLAN-NO.                          
           PERFORM 7040-SELECT-RATE-CHARGE THRU 7040-EXIT.              
           MOVE J4-AMT-CUST-CHRG TO WS-RATE457-CHARGE.                  
      *                                                                         
           MOVE WS-RATE458 TO J4-RATE-PLAN-NO.                          
           PERFORM 7040-SELECT-RATE-CHARGE THRU 7040-EXIT.              
           MOVE J4-AMT-CUST-CHRG TO WS-RATE458-CHARGE.                  
      *                                                                         
A05136     MOVE WS-RATE192 TO J4-RATE-PLAN-NO.                          
A05136     PERFORM 7040-SELECT-RATE-CHARGE THRU 7040-EXIT.              
A05136     MOVE J4-AMT-CUST-CHRG TO WS-RATE192-CHARGE.                  
      *                                                                         
           INITIALIZE WS-MASTER-ACCT-TABLE.                             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS INPUT DATA                                         *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           IF AT-MST-SUB-ACCT-IND = WS-SUB-ACCT                         
              MOVE AT-ACCOUNT-NO TO MU-SUB-ACCT-NO                      
              PERFORM 5000-CHECK-MASTER-LOAD THRU 5000-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO        TO FF-ACCOUNT-NO.                  
           MOVE UT-CODE-UTIL-TYPE    TO FF-CODE-UTIL-TYPE.              
           MOVE UT-IC-NO             TO FF-IC-NO.                       
           PERFORM 7050-SELECT-FIXED-FCTR THRU 7050-EXIT.               
      *                                                                         
           IF AT-CODE-LPC-XMT NOT = WS-L                                
              PERFORM 1175-PROCESS-ACCOUNT THRU 1175-EXIT               
           ELSE                                                         
             IF UT-CODE-STAT-TAX-XMT = SPACES                           
               PERFORM 1175-PROCESS-ACCOUNT THRU 1175-EXIT              
             ELSE                                                       
               IF WS-BASIS-AMT = WS-0-0460 OR WS-0-0440                 
                 CONTINUE                                               
               ELSE                                                     
A05462            IF (UT-RATE-PLAN-NO = WS-RATE457 OR WS-RATE192) AND   
A05462               (WS-BASIS-AMT = WS-0-1680 OR WS-0-0410)            
                       CONTINUE                                         
A05462            ELSE                                                  
A05462              IF UT-RATE-PLAN-NO = WS-RATE458 AND                 
A05462                WS-BASIS-AMT = WS-0-3890                          
A05136                CONTINUE                                          
A05136              ELSE                                                
A05136                PERFORM 1175-PROCESS-ACCOUNT THRU 1175-EXIT       
A05136              END-IF                                              
                  END-IF                                                
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 7021-FETCH-EXEMPT-CRSR THRU 7021-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE THE PRINT LINE FOR THE REPORT                         *          
      ****************************************************************          
      *                                                                         
       1150-CREATE-REPORT.                                              
      *                                                                         
           MOVE WS-YES TO WS-DATA-SW.                                   
      *                                                                         
           IF AT-MST-SUB-ACCT-IND = WS-SUB-ACCT                         
              MOVE WS-SUB-LIT TO PRT-MST-SUB                            
           END-IF.                                                      
      *                                                                         
           IF UT-RATE-PLAN-NO = WS-RATE457                              
              MOVE WS-RATE457-CHARGE TO PRT-CHARGE                      
           END-IF.                                                      
           IF UT-RATE-PLAN-NO = WS-RATE458                              
              MOVE WS-RATE458-CHARGE TO PRT-CHARGE                      
           END-IF.                                                      
A05136     IF UT-RATE-PLAN-NO = WS-RATE192                              
A05136        MOVE WS-RATE192-CHARGE TO PRT-CHARGE                      
A05136     END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO        TO PRT-ACCOUNT.                    
           MOVE AT-BILL-CYCLE        TO PRT-BILL-CYCLE.                 
           MOVE DF-CREATED-USERID    TO PRT-CREATED-USERID.             
           MOVE FF-EFF-DATE-FROM     TO PRT-EFF-DATE-FROM.              
           MOVE FF-EFF-DATE-TO       TO PRT-EFF-DATE-TO.                
           MOVE WS-BASIS-AMT         TO PRT-BASIS-FACTOR.               
      *                                                                         
           IF UT-CODE-STAT-TAX-XMT = SPACES                             
              MOVE SPACES TO PRT-CODE-STAT-TAX-XMT                      
           ELSE                                                         
              PERFORM 7080-GET-TAX-EXMPT-DESCRIPTION                    
              MOVE WS-DESCRIPTION TO PRT-CODE-STAT-TAX-XMT              
           END-IF.                                                      
      *                                                                         
A05460     MOVE SPACES TO WS-CODE-VALUE.                                
           IF AT-CODE-LPC-XMT = SPACES                                  
              MOVE SPACES TO PRT-CODE-LPC-XMT                           
           ELSE                                                         
A05460        MOVE AT-CODE-LPC-XMT TO WS-CODE-VALUE                     
              PERFORM 7090-GET-LPC-DESCRIPTION                          
              MOVE WS-DESCRIPTION TO PRT-CODE-LPC-XMT                   
           END-IF.                                                      
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
      *                                                                         
A04880     MOVE PRINT-LINE TO PRT33-RECORD.                             
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
A04880     MOVE PRINT-LINE2 TO PRT33-RECORD.                            
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           ADD +2 TO WS-LINE-COUNT.                                     
           MOVE SPACES TO PRINT-LINE                                    
                          PRINT-LINE2.                                  
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS THIS ACCOUNT FOR THE REPORT                          *          
      ****************************************************************          
      *                                                                         
       1175-PROCESS-ACCOUNT.                                            
      *                                                                         
           MOVE SPACES TO PRINT-LINE.                                   
           PERFORM 1200-ACCT-RTPK-AGR THRU 1200-EXIT.                   
           MOVE SPACES TO FF-FACTOR-ID                                  
                          FF-EFF-DATE-FROM                              
                          FF-EFF-DATE-TO                                
                          AT-CODE-LPC-XMT                               
                          UT-CODE-STAT-TAX-XMT                          
                          AT-MST-SUB-ACCT-IND                           
                          DF-CREATED-USERID                             
                          UT-CODE-UTIL-TYPE                             
                          AT-CODE-LPC-XMT                               
                          UT-CODE-STAT-TAX-XMT                          
                          UT-RATE-PLAN-NO                               
                          WS-MASTER-LPC-XMT                             
                          WS-MASTER-BILL-CYCLE                          
                          WS-DESCRIPTION.                               
           MOVE ZEROS  TO FF-FACTOR                                     
                          FF-FIXED-FCTR-SEQ-NO                          
                          AT-ACCOUNT-NO                                 
                          UT-RT-PKG-OPT-SEQ-NO                          
                          WS-BASIS-AMT                                  
                          UT-IC-NO.                                     
      *                                                                         
       1175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET ACCT-RTPK-AGR AND CREATE REPORT                        *          
      ****************************************************************          
      *                                                                         
       1200-ACCT-RTPK-AGR.                                              
      *                                                                         
           MOVE AT-ACCOUNT-NO        TO DF-ACCOUNT-NO.                  
           MOVE UT-CODE-UTIL-TYPE    TO DF-CODE-UTIL-TYPE.              
           MOVE UT-IC-NO             TO DF-IC-NO.                       
           MOVE UT-RT-PKG-OPT-SEQ-NO TO DF-RT-PKG-OPT-SEQ-NO.           
           PERFORM 7070-SELECT-ACCT-RTPK-AGR THRU 7070-EXIT.            
      *                                                                         
           PERFORM 1150-CREATE-REPORT THRU 1150-EXIT.                   
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   MASTER ACCOUNT PROCESS                                     *          
      ****************************************************************          
      *                                                                         
       5000-CHECK-MASTER-LOAD.                                          
      *                                                                         
           PERFORM 7060-SELECT-MASTER THRU 7060-EXIT.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MASTER-LPC-XMT  = WS-L                              
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 5050-MASTER-TABLE THRU 5050-EXIT               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK TO SEE IF MASTER ACCOUNT IS ON THE WS-TABLE.         *          
      *   IF IT IS, THEN IT HAS ALREADY BEEN PUT ON THE REPORT.      *          
      *   DO NOTHING WITH THIS MASTER ACCOUNT.  IF IT IS NOT ON THE  *          
      *   TABLE, PUT IT ON THE TABLE AND ADD IT TO THE REPORT.       *          
      ****************************************************************          
      *                                                                         
       5050-MASTER-TABLE.                                               
      *                                                                         
           MOVE WS-NO  TO WS-MASTER-RPT-SUB.                            
           MOVE SPACES TO PRT-MST-SUB.                                  
      *                                                                         
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                  UNTIL WS-SUB > 100                                    
             IF WS-MASTER-ACCOUNT(WS-SUB) = MU-MST-ACCT-NO              
                   MOVE WS-NO TO WS-MASTER-RPT-SUB                      
                   MOVE 200 TO WS-SUB                                   
             ELSE                                                       
                IF WS-MASTER-ACCOUNT(WS-SUB) = ZEROS                    
                   MOVE MU-MST-ACCT-NO TO WS-MASTER-ACCOUNT(WS-SUB)     
                   MOVE WS-YES TO WS-MASTER-RPT-SUB                     
                   MOVE 200 TO WS-SUB                                   
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF WS-MASTER-RPT-SUB = WS-YES                                
              MOVE SPACES         TO PRINT-LINE                         
              MOVE WS-MST-LIT     TO PRT-MST-SUB                        
              MOVE MU-MST-ACCT-NO TO PRT-ACCOUNT                        
              MOVE WS-MASTER-BILL-CYCLE TO PRT-BILL-CYCLE               
              IF WS-LINE-COUNT > +58                                    
                 PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT              
              END-IF                                                    
A04880        MOVE PRINT-LINE TO PRT33-RECORD                           
              PERFORM 8900-WRITE-REPORT THRU 8900-EXIT                  
A04880        MOVE SPACES      TO PRT33-RECORD                          
              PERFORM 8900-WRITE-REPORT THRU 8900-EXIT                  
              ADD +2 TO WS-LINE-COUNT                                   
              MOVE SPACES     TO PRINT-LINE                             
                                 PRINT-LINE2                            
           END-IF.                                                      
      *                                                                         
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  OPEN EXEMPT_CRSR                                          **          
      ****************************************************************          
      *                                                                         
       7010-OPEN-EXEMPT-CRSR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN EXEMPT_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP666 PROCESSING ERROR      **'       
               DISPLAY '** ABEND - 7010-OPEN-EXEMPT-CRSR       **'      
               DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    FETCH FOR EXEMPT_CRSR                                    **         
      ****************************************************************          
      *                                                                         
       7021-FETCH-EXEMPT-CRSR.                                          
      *                                                                         
           EXEC SQL                                                     
              FETCH EXEMPT_CRSR                                         
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CODE-LPC-XMT                                    
                   ,:UT-CODE-STAT-TAX-XMT                               
                   ,:AT-MST-SUB-ACCT-IND                                
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-RT-PKG-OPT-SEQ-NO                               
                   ,:AT-BILL-CYCLE                                      
                   ,:UT-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-YES TO WS-EXEMPT-SW                            
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSRP666 PROCESSING ERROR      **'     
                 DISPLAY '** ABEND - 7021-FETCH-EXEMPT-CRSR      **'    
                 DISPLAY '** SQLCODE       = ' WS-ACTIVE-RETURN-CODE    
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7021-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    CLOSE FOR EXEMPT_CRSR                                    **         
      ****************************************************************          
      *                                                                         
       7030-CLOSE-EXEMPT-CRSR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE EXEMPT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP666 PROCESSING ERROR      **'       
               DISPLAY '** ABEND - 7030-CLOSE-EXEMPT-CRSR      **'      
               DISPLAY '**     SQLCODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    SELECT CUSTOMER CHARGE FOR RATES USED                   **          
      ****************************************************************          
      *                                                                         
       7040-SELECT-RATE-CHARGE.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) RATE_PLAN_NO,
              AMT_CUST_CHRG,
              VERSION_NO_CNTRL                                    
               INTO :J4-RATE-PLAN-NO                                    
                   ,:J4-AMT-CUST-CHRG                                   
                   ,:J4-VERSION-NO-CNTRL                                
              FROM   CSS_RATE_VRSN_DEF WITH(READUNCOMMITTED)                    
              WHERE RATE_PLAN_NO   = :J4-RATE-PLAN-NO                   
                AND CODE_UTIL_TYPE = :WS-GAS                            
              ORDER BY VERSION_NO_CNTRL DESC                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RATE_PLAN_NO                                                
MFA-TR*            ,AMT_CUST_CHRG                                               
MFA-TR*            ,VERSION_NO_CNTRL                                            
MFA-TR*        INTO :J4-RATE-PLAN-NO                                            
MFA-TR*            ,:J4-AMT-CUST-CHRG                                           
MFA-TR*            ,:J4-VERSION-NO-CNTRL                                        
MFA-TR*       FROM   CSS_RATE_VRSN_DEF                                          
MFA-TR*       WHERE RATE_PLAN_NO   = :J4-RATE-PLAN-NO                           
MFA-TR*         AND CODE_UTIL_TYPE = :WS-GAS                                    
MFA-TR*       ORDER BY VERSION_NO_CNTRL DESC                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSRP666 PROCESSING ERROR      **'        
              DISPLAY '** ABEND - 7040-SELECT-RATE-CHARGE    **'        
              DISPLAY '** ERROR - RATE PLAN NOT FOUND        **'        
              DISPLAY '** J4-RATE-PLAN-NO = ' J4-RATE-PLAN-NO           
              DISPLAY '** SQLCODE         = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    SELECT FACTOR FROM CSS_FIXED_FCTR                       **          
      ****************************************************************          
      *                                                                         
       7050-SELECT-FIXED-FCTR.                                          
      *                                                                         
           EXEC SQL                                                     
            SELECT TOP(1) FACTOR_ID,
              EFF_DATE_FROM,
              EFF_DATE_TO,
              FACTOR,
              FIXED_FCTR_SEQ_NO                                    
             INTO :FF-FACTOR-ID                                         
                 ,:FF-EFF-DATE-FROM                                     
                 ,:FF-EFF-DATE-TO                                       
                 ,:FF-FACTOR                                            
                 ,:FF-FIXED-FCTR-SEQ-NO                                 
            FROM   CSS_FIXED_FCTR WITH(READUNCOMMITTED)                         
            WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                       
              AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                   
              AND IC_NO          = :FF-IC-NO                            
              AND FACTOR_ID      = :WS-BASIS                            
            ORDER BY FIXED_FCTR_SEQ_NO DESC                             
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT FACTOR_ID                                                    
MFA-TR*           ,EFF_DATE_FROM                                                
MFA-TR*           ,EFF_DATE_TO                                                  
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,FIXED_FCTR_SEQ_NO                                            
MFA-TR*      INTO :FF-FACTOR-ID                                                 
MFA-TR*          ,:FF-EFF-DATE-FROM                                             
MFA-TR*          ,:FF-EFF-DATE-TO                                               
MFA-TR*          ,:FF-FACTOR                                                    
MFA-TR*          ,:FF-FIXED-FCTR-SEQ-NO                                         
MFA-TR*     FROM   CSS_FIXED_FCTR                                               
MFA-TR*     WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                               
MFA-TR*       AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                           
MFA-TR*       AND IC_NO          = :FF-IC-NO                                    
MFA-TR*       AND FACTOR_ID      = :WS-BASIS                                    
MFA-TR*     ORDER BY FIXED_FCTR_SEQ_NO DESC                                     
MFA-TR*     FETCH FIRST ROW ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE FF-FACTOR TO WS-BASIS-AMT                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO WS-BASIS-AMT                             
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSRP666 PROCESSING ERROR      **'     
                 DISPLAY '** ABEND - 7050-SELECT-FIXED-FCTR     **'     
                 DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE          
                 DISPLAY '** FF-ACCOUNT-NO      = ' FF-ACCOUNT-NO       
                 DISPLAY '** FF-CODE-UTIL-TYPE  = ' FF-CODE-UTIL-TYPE   
                 DISPLAY '** FF-IC-NO           = ' FF-IC-NO            
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    IF SUB ACCOUNT, GET THE MASTER ACCOUNT                  **          
      ****************************************************************          
      *                                                                         
       7060-SELECT-MASTER.                                              
      *                                                                         
           EXEC SQL                                                     
            SELECT MU.MST_ACCT_NO                                       
                  ,AT.CODE_LPC_XMT                                      
                  ,AT.BILL_CYCLE                                        
             INTO :MU-MST-ACCT-NO                                       
                 ,:WS-MASTER-LPC-XMT                                    
                 ,:WS-MASTER-BILL-CYCLE                                 
            FROM   CSS_MSTSUB_ACCT MU WITH(READUNCOMMITTED)                     
                  ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
            WHERE MU.SUB_ACCT_NO = :MU-SUB-ACCT-NO                      
              AND MU.MST_ACCT_NO = AT.ACCOUNT_NO                        
              AND AT.CODE_ACCT_STAT = 'A'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT MU.MST_ACCT_NO                                               
MFA-TR*           ,AT.CODE_LPC_XMT                                              
MFA-TR*           ,AT.BILL_CYCLE                                                
MFA-TR*      INTO :MU-MST-ACCT-NO                                               
MFA-TR*          ,:WS-MASTER-LPC-XMT                                            
MFA-TR*          ,:WS-MASTER-BILL-CYCLE                                         
MFA-TR*     FROM   CSS_MSTSUB_ACCT MU                                           
MFA-TR*           ,CSS_ACCOUNT AT                                               
MFA-TR*     WHERE MU.SUB_ACCT_NO = :MU-SUB-ACCT-NO                              
MFA-TR*       AND MU.MST_ACCT_NO = AT.ACCOUNT_NO                                
MFA-TR*       AND AT.CODE_ACCT_STAT = 'A'                                       
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '**     PCSRP666 PROCESSING ERROR        **'     
               DISPLAY '** ABEND - PARAGRAPH 7060-SELECT-MASTER **'     
               DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '**  SUB_ACCT_NO = ' MU-SUB-ACCT-NO              
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    SELECT CREATED-USERID FROM CSS_ACCT_RTPK_AGR            **          
      ****************************************************************          
      *                                                                         
       7070-SELECT-ACCT-RTPK-AGR.                                       
      *                                                                         
           EXEC SQL                                                     
            SELECT CREATED_USERID                                       
             INTO :DF-CREATED-USERID                                    
            FROM   CSS_ACCT_RTPK_AGR WITH(READUNCOMMITTED)                      
            WHERE ACCOUNT_NO        = :DF-ACCOUNT-NO                    
              AND CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                
              AND IC_NO             = :DF-IC-NO                         
              AND RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO             
              AND OPTION_CD IN ('CM303C03X457', 'CM303C03X458',         
A05136                          'CM303C03X192')                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CREATED_USERID                                               
MFA-TR*      INTO :DF-CREATED-USERID                                            
MFA-TR*     FROM   CSS_ACCT_RTPK_AGR                                            
MFA-TR*     WHERE ACCOUNT_NO        = :DF-ACCOUNT-NO                            
MFA-TR*       AND CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                        
MFA-TR*       AND IC_NO             = :DF-IC-NO                                 
MFA-TR*       AND RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO                     
MFA-TR*       AND OPTION_CD IN ('CM303C03X457', 'CM303C03X458',                 
MFA-TR*                         'CM303C03X192')                                 
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*    PCSRP666 PROCESSING ERROR        **'        
              DISPLAY '*  ABEND - 7070-SELECT-ACCT-RTPK-AGR  **'        
              DISPLAY '*     SQLCODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '* DF-ACCOUNT-NO        = ' DF-ACCOUNT-NO         
              DISPLAY '* DF-CODE-UTIL-TYPE    = ' DF-CODE-UTIL-TYPE     
              DISPLAY '* DF-IC-NO             = ' DF-IC-NO              
              DISPLAY '* DF-RT-PKG-OPT-SEQ-NO = ' DF-RT-PKG-OPT-SEQ-NO  
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *    GET DESCRIPTION FROM CSS_TAX_EXMPT_CODE                 *            
      **************************************************************            
      *                                                                         
       7080-GET-TAX-EXMPT-DESCRIPTION.                                  
      *                                                                         
           EXEC SQL                                                     
            SELECT TAX_EXEMPT_DESC                                      
             INTO :WS-DESCRIPTION                                       
            FROM   CSS_TAX_EXMPT_CODE WITH(READUNCOMMITTED)                     
            WHERE TAX_EXEMPT_CODE   = :UT-CODE-STAT-TAX-XMT             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT TAX_EXEMPT_DESC                                              
MFA-TR*      INTO :WS-DESCRIPTION                                               
MFA-TR*     FROM   CSS_TAX_EXMPT_CODE                                           
MFA-TR*     WHERE TAX_EXEMPT_CODE   = :UT-CODE-STAT-TAX-XMT                     
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '*    PCSRP666 PROCESSING ERROR           **'     
              DISPLAY '* ABEND - 7080-GET-TAX-EXMPT-DESCRIPTION **'     
              DISPLAY '*     SQLCODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '* CODE-STAT-TAX-XMT  = ' UT-CODE-STAT-TAX-XMT    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
A05460*    GET DESCRIPTION FROM CSS_CODE_VALUE                     *            
      **************************************************************            
      *                                                                         
       7090-GET-LPC-DESCRIPTION.                                        
      *                                                                         
           EXEC SQL                                                     
A05460      SELECT CODE_LONG_DESC                                       
             INTO :UV-CODE-LONG-DESC                                    
A05460      FROM   CSS_CODE_VALUE WITH(READUNCOMMITTED)                         
A05460      WHERE CODE_SHORT_DESC  = 'FRCST EXEMPT'                     
A05460        AND COLUMN_NA        = 'FORECASTED_EXEMPT'                
A05460        AND CODE_VALUE       = :WS-CODE-VALUE                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODE_LONG_DESC                                               
MFA-TR*      INTO :UV-CODE-LONG-DESC                                            
MFA-TR*     FROM   CSS_CODE_VALUE                                               
MFA-TR*     WHERE CODE_SHORT_DESC  = 'FRCST EXEMPT'                             
MFA-TR*       AND COLUMN_NA        = 'FORECASTED_EXEMPT'                        
MFA-TR*       AND CODE_VALUE       = :WS-CODE-VALUE                             
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05460        MOVE UV-CODE-LONG-DESC-TEXT TO WS-DESCRIPTION             
           ELSE                                                         
A05460        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A05460           MOVE 'CODE-VALUE NOT FOUND' TO WS-DESCRIPTION          
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '*    PCSRP666 PROCESSING ERROR         *'     
                 DISPLAY '* ABEND - 7090-GET-LPC-DESCRIPTION     *'     
                 DISPLAY '*     SQLCODE = ' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '* WS-CODE-VALUE = ' WS-CODE-VALUE             
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *    GET CURRENT DATE                                        *            
      **************************************************************            
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '7500-GET-CURRENT-TIMESTAMP'                      
              PERFORM 9900-ABEND THRU  9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       WRITES THE HEADER TO THE REPORT FILE                 **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                         
A04880     MOVE HEADER1 TO PRT33-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
A04880     MOVE HEADER2 TO PRT33-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
A04880     MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
A04880     MOVE HEADER3 TO PRT33-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
A04880     MOVE HEADER4 TO PRT33-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
A04880     MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE +7 TO WS-LINE-COUNT.                                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **       WRITES THE REPORT                                      **        
      ******************************************************************        
      *                                                                         
       8900-WRITE-REPORT.                                               
      *                                                                         
A04880     WRITE PRT33-RECORD.                                          
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   NORMAL JOB TERMINATION                                     *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY 'JOB COMPLETE'.                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE AND ALSO PERFORMS    *          
      *  9000-TERMINATE.  THEN IT MOVES 12 TO RETURN CODE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
