       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP664.                                        
       AUTHOR.         MUTHUKUMAR RAMAIAH.                              
       DATE-WRITTEN.   NOV 2016.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **             F U N C T I O N A L   D E S C R I P T I O N    **          
      **                             O F   M O D U LE               **          
      **                                                            **          
      **  PURPOSE : GAS METER DETAIL FOR CURRENT YEAR REPORT(CSV).  **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
A05460** 11/16/16   MR7E794    INITIAL CODE                         **          
      ** 02/14/17   NC94746    SHOW ORDERS THAT WERE COMPLETED THAT **          
      **                       INCLUDES TESTED TOO IN THIS YEAR.    **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSRP664.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSRP664-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS V                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FCSRP664-RECORD.                                             
           05  FILLER                 PIC X                             
                                      OCCURS 1 TO 122 TIMES             
                                      DEPENDING ON WS-RECORD-LENGTH.    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP664'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 PROGRAM-NAME            PIC X(08) VALUE 'PCSRP664'.       
           05 WS-PGRMNAME             PIC X(08) VALUE 'PCSRP664'.       
           05 WS-OUTPUT-RECORD        PIC X(122) VALUE SPACES.          
           05 WS-RECORD-LENGTH        PIC S9(04) COMP VALUE ZERO.       
           05 WS-K                    PIC S9(04) COMP VALUE ZERO.       
           05 WS-HEADER-LINE.                                           
              10 FILLER               PIC X(51)  VALUE                  
           'COMPANY,ORDER COMPLETED DATE,METER NO,METER SERIAL,'.       
              10 FILLER               PIC X(24)  VALUE                  
           'METER TYPE,STATUS REASON'.                                  
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND1            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND2            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND3            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND4            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND5            PIC S9(04) COMP VALUE +0.         
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS     PIC X(01) VALUE 'N'.              
               88 NO-MORE-RECORDS               VALUE 'Y'.              
           05  WS-FCSRP664-STATUS     PIC X(02).                        
               88 FCSRP664-SUCCESSFUL           VALUE '00'.             
      *                                                                         
       COPY FIORP664.                                                           
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
      *****************************************************************         
      *  CWS00011  CONTAINS SPACE COMPRESSION VARIABLES               *         
      *****************************************************************         
      *    COPY CWS00011.                                                       
       01  WS-11-TABLES.                                                
      *                                                                         
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 122 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +122.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 122 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-W0-DATE               PIC X(10) VALUE SPACES.         
           05  WS-COMPLET-DATE          PIC X(10) VALUE SPACES.         
           05  WS-FMT-COMPLET-DATE.                                     
               10 WS-COMPLET-MNTH       PIC X(02) VALUE SPACES.         
               10 WS-FSLASH             PIC X(01) VALUE '/'.            
               10 WS-COMPLET-DTE        PIC X(02) VALUE SPACES.         
               10 WS-FSLASH             PIC X(01) VALUE '/'.            
               10 WS-COMPLET-YEAR       PIC X(04) VALUE SPACES.         
           05 WS-DATABASE               PIC 9(01) VALUE ZERO.           
              88 CSR-DATABASE                     VALUE 1.              
              88 SEB-DATABASE                     VALUE 2.              
           05 WS-MCU                    PIC X(03) VALUE 'MCU'.          
           05 WS-MCB                    PIC X(03) VALUE 'MCB'.          
           05 WS-RMT                    PIC X(03) VALUE 'RMT'.          
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-G                      PIC X(01) VALUE 'G'.            
           05 WS-COMPANY-NAME           PIC X(04) VALUE SPACES.         
           05 WS-WO-DATE                PIC X(10) VALUE SPACES.         
           05 WS-CURR-DATE              PIC X(10) VALUE SPACES.         
           05 WS-5DAYOLD-DATE           PIC X(10) VALUE SPACES.         
           05 WS-CODE-STATUS-LDESC      PIC X(80) VALUE SPACES.         
      *                                                                         
      *****************************************************************         
      *  COPY BOOK FOR CPD00074                                       *         
      *****************************************************************         
       COPY CWS00074.                                                           
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
      *COPY CWS00039.                                                           
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
      *COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CSS_CODE_VALUE, UV                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME, DQ                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FORMATTED, DY                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ZIP_CODE, A4                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_ADD_XREF, DZ                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FREEFORM, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MISC_INFO, TA                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME_ACC_XREF, HT                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CSS_SO_MTR_CHG, VC                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE  TBSOMCG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_SO_DATA VO                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_SO_ORDER_INST VI                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_GAS_METER GM                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_EQUIPMENT EQ                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : HST_SO_ORDER_INST ZG                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBHSTODR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : HST_SO_DATA YV                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBHSTDAT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DRIVER CURSOR DECLARATIONS.                                *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE GAS_METER_DET  CURSOR FOR                         
                 SELECT VI.SERV_ORDER_NO                                
                       ,VI.SO_INST_SEQ_NO                               
                       ,VI.CODE_UTIL_TYPE                               
                       ,VI.METER_NO                                     
                       ,VI.IC_NO                                        
                       ,VI.MTR_REF_NO                                   
                       ,VO.ACCOUNT_NO                                   
                       ,VO.COMPANY_NO                                   
                       ,CAST(VO.ASSIGNED_DATETIME AS DATE)                      
                       ,CAST(VO.COMPLETED_DATETIME AS DATE)                     
                       ,VO.ACCOUNT_NO_PRIOR                             
                       ,VO.LOCAL_OFFICE                                 
                       ,GM.METER_SIZE_ID                                
                       ,GM.DATE_LAST_TESTED                             
                       ,GM.CCF_CAP_PER_HR                               
                       ,GM.LAST_TEST_SEL_DT                             
                       ,GM.LAST_TEST_SEL_CD                             
                       ,EQ.CODE_CRNT_LOC                                
                       ,EQ.CRNT_LOC_NO                                  
                       ,EQ.DATE_PURCHASED                               
                       ,EQ.SERIAL_NO                                    
                   FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                       ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
                       ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                       ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                  
                  WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO            
                    AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)  
                    AND VI.SAMPLE_TEST_FL = :WS-Y                       
                    AND VI.CODE_UTIL_TYPE = :WS-G                       
                    AND VO.ORDER_STATE_CD = 'Z'                         
                    AND VO.COMPANY_NO  = GM.COMPANY_NO                  
                    AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND VI.METER_NO  = GM.METER_NO                      
                    AND EQ.COMPANY_NO  = GM.COMPANY_NO                  
                    AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND EQ.DEVICE_NO  = GM.METER_NO                     
                    AND YEAR(VO.COMPLETED_DATETIME) = YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE))
                  UNION                                                 
                 SELECT VI.SERV_ORDER_NO                                
                       ,VI.SO_INST_SEQ_NO                               
                       ,VI.CODE_UTIL_TYPE                               
                       ,VI.METER_NO                                     
                       ,VI.IC_NO                                        
                       ,VI.MTR_REF_NO                                   
                       ,VO.ACCOUNT_NO                                   
                       ,VO.COMPANY_NO                                   
                       ,CAST(VO.ASSIGNED_DATETIME AS DATE)                      
                       ,CAST(VO.COMPLETED_DATETIME AS DATE)                     
                       ,VO.ACCOUNT_NO_PRIOR                             
                       ,VO.LOCAL_OFFICE                                 
                       ,GM.METER_SIZE_ID                                
                       ,GM.DATE_LAST_TESTED                             
                       ,GM.CCF_CAP_PER_HR                               
                       ,GM.LAST_TEST_SEL_DT                             
                       ,GM.LAST_TEST_SEL_CD                             
                       ,EQ.CODE_CRNT_LOC                                
                       ,EQ.CRNT_LOC_NO                                  
                       ,EQ.DATE_PURCHASED                               
                       ,EQ.SERIAL_NO                                    
                   FROM HST_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                       ,HST_SO_DATA VO WITH(READUNCOMMITTED)                    
                       ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                       ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                  
                  WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO            
                    AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)  
                    AND VI.SAMPLE_TEST_FL = :WS-Y                       
                    AND VI.CODE_UTIL_TYPE = :WS-G                       
                    AND VO.ORDER_STATE_CD = 'Z'                         
                    AND VO.COMPANY_NO  = GM.COMPANY_NO                  
                    AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND VI.METER_NO  = GM.METER_NO                      
                    AND EQ.COMPANY_NO  = GM.COMPANY_NO                  
                    AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND EQ.DEVICE_NO  = GM.METER_NO                     
                    AND YEAR(VO.COMPLETED_DATETIME) = YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE))
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GAS_METER_DET  CURSOR FOR                                 
MFA-TR*          SELECT VI.SERV_ORDER_NO                                        
MFA-TR*                ,VI.SO_INST_SEQ_NO                                       
MFA-TR*                ,VI.CODE_UTIL_TYPE                                       
MFA-TR*                ,VI.METER_NO                                             
MFA-TR*                ,VI.IC_NO                                                
MFA-TR*                ,VI.MTR_REF_NO                                           
MFA-TR*                ,VO.ACCOUNT_NO                                           
MFA-TR*                ,VO.COMPANY_NO                                           
MFA-TR*                ,DATE(VO.ASSIGNED_DATETIME)                              
MFA-TR*                ,DATE(VO.COMPLETED_DATETIME)                             
MFA-TR*                ,VO.ACCOUNT_NO_PRIOR                                     
MFA-TR*                ,VO.LOCAL_OFFICE                                         
MFA-TR*                ,GM.METER_SIZE_ID                                        
MFA-TR*                ,GM.DATE_LAST_TESTED                                     
MFA-TR*                ,GM.CCF_CAP_PER_HR                                       
MFA-TR*                ,GM.LAST_TEST_SEL_DT                                     
MFA-TR*                ,GM.LAST_TEST_SEL_CD                                     
MFA-TR*                ,EQ.CODE_CRNT_LOC                                        
MFA-TR*                ,EQ.CRNT_LOC_NO                                          
MFA-TR*                ,EQ.DATE_PURCHASED                                       
MFA-TR*                ,EQ.SERIAL_NO                                            
MFA-TR*            FROM CSS_SO_ORDER_INST VI                                    
MFA-TR*                ,CSS_SO_DATA VO                                          
MFA-TR*                ,CSS_GAS_METER GM                                        
MFA-TR*                ,CSS_EQUIPMENT EQ                                        
MFA-TR*           WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                    
MFA-TR*             AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)          
MFA-TR*             AND VI.SAMPLE_TEST_FL = :WS-Y                               
MFA-TR*             AND VI.CODE_UTIL_TYPE = :WS-G                               
MFA-TR*             AND VO.ORDER_STATE_CD = 'Z'                                 
MFA-TR*             AND VO.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND VI.METER_NO  = GM.METER_NO                              
MFA-TR*             AND EQ.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.DEVICE_NO  = GM.METER_NO                             
MFA-TR*             AND YEAR(VO.COMPLETED_DATETIME) = YEAR(CURRENT DATE)        
MFA-TR*           UNION                                                         
MFA-TR*          SELECT VI.SERV_ORDER_NO                                        
MFA-TR*                ,VI.SO_INST_SEQ_NO                                       
MFA-TR*                ,VI.CODE_UTIL_TYPE                                       
MFA-TR*                ,VI.METER_NO                                             
MFA-TR*                ,VI.IC_NO                                                
MFA-TR*                ,VI.MTR_REF_NO                                           
MFA-TR*                ,VO.ACCOUNT_NO                                           
MFA-TR*                ,VO.COMPANY_NO                                           
MFA-TR*                ,DATE(VO.ASSIGNED_DATETIME)                              
MFA-TR*                ,DATE(VO.COMPLETED_DATETIME)                             
MFA-TR*                ,VO.ACCOUNT_NO_PRIOR                                     
MFA-TR*                ,VO.LOCAL_OFFICE                                         
MFA-TR*                ,GM.METER_SIZE_ID                                        
MFA-TR*                ,GM.DATE_LAST_TESTED                                     
MFA-TR*                ,GM.CCF_CAP_PER_HR                                       
MFA-TR*                ,GM.LAST_TEST_SEL_DT                                     
MFA-TR*                ,GM.LAST_TEST_SEL_CD                                     
MFA-TR*                ,EQ.CODE_CRNT_LOC                                        
MFA-TR*                ,EQ.CRNT_LOC_NO                                          
MFA-TR*                ,EQ.DATE_PURCHASED                                       
MFA-TR*                ,EQ.SERIAL_NO                                            
MFA-TR*            FROM HST_SO_ORDER_INST VI                                    
MFA-TR*                ,HST_SO_DATA VO                                          
MFA-TR*                ,CSS_GAS_METER GM                                        
MFA-TR*                ,CSS_EQUIPMENT EQ                                        
MFA-TR*           WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                    
MFA-TR*             AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)          
MFA-TR*             AND VI.SAMPLE_TEST_FL = :WS-Y                               
MFA-TR*             AND VI.CODE_UTIL_TYPE = :WS-G                               
MFA-TR*             AND VO.ORDER_STATE_CD = 'Z'                                 
MFA-TR*             AND VO.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND VI.METER_NO  = GM.METER_NO                              
MFA-TR*             AND EQ.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.DEVICE_NO  = GM.METER_NO                             
MFA-TR*             AND YEAR(VO.COMPLETED_DATETIME) = YEAR(CURRENT DATE)        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-GAS-METER-RPT  THRU 1000-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSRP664-FILE.                                   
                                                                        
           IF FCSRP664-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSRP664 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FIORP664 FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSRP664-STATUS          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP664 ABORT **************'        
              MOVE 12 TO RETURN-CODE                                    
              STOP RUN                                                  
           END-IF.                                                      
                                                                        
           MOVE SPACES TO FCSRP664-RECORD.                              
           INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
                      WS-CMP-TABLE        WS-K.                         
           MOVE WS-HEADER-LINE   TO WS-OUTPUT-RECORD.                   
           MOVE 75               TO WS-RECORD-LENGTH.                   
           MOVE WS-OUTPUT-RECORD TO FCSRP664-RECORD.                    
           WRITE FCSRP664-RECORD.                                       
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-GAS-METER-RPT.                                   *         
      *****************************************************************         
       1000-PROCESS-GAS-METER-RPT.                                      
                                                                        
           PERFORM 7100-GET-CURRENT-DAY        THRU 7100-EXIT.          
           PERFORM 7500-OPEN-GAS-METER-CSR     THRU 7500-EXIT.          
           PERFORM 7510-FETCH-GAS-METER-CSR    THRU 7510-EXIT.          
           IF NO-MORE-RECORDS                                           
              DISPLAY 'NO OUTPUT TO PROCESS'                            
           ELSE                                                         
              PERFORM 5000-GAS-METER-RPT-DETAILS     THRU  5000-EXIT    
                                               UNTIL NO-MORE-RECORDS    
           END-IF.                                                      
                                                                        
           PERFORM 7520-CLOSE-GAS-METER-CSR    THRU 7520-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-GAS-METER-RPT-DETAILS                                    *         
      *****************************************************************         
       5000-GAS-METER-RPT-DETAILS.                                      
                                                                        
      ***********COMPANY NAME                                                   
           IF VO-COMPANY-NO = '01'                                      
              MOVE 'SCEG'             TO WS-COMPANY-NAME                
           ELSE                                                         
              MOVE 'PSNC'             TO WS-COMPANY-NAME                
           END-IF.                                                      
      ***********COMPLETED  DATE                                                
           MOVE WS-COMPLET-DATE(01:04)       TO WS-COMPLET-YEAR.        
           MOVE WS-COMPLET-DATE(06:02)       TO WS-COMPLET-MNTH.        
           MOVE WS-COMPLET-DATE(09:02)       TO WS-COMPLET-DTE.         
      *                                                                         
           INITIALIZE VC-CODE-STATUS-REA-IS.                            
           MOVE VI-SERV-ORDER-NO          TO VC-SERV-ORDER-NO.          
           MOVE VI-CODE-UTIL-TYPE         TO VC-CODE-UTIL-TYPE.         
           MOVE VI-IC-NO                  TO VC-IC-NO.                  
           MOVE VI-MTR-REF-NO             TO VC-MTR-REF-NO.             
           PERFORM 7200-SELECT-CODE-STATUS THRU 7200-EXIT.              
           INITIALIZE UV-CODE-LONG-DESC.                                
           MOVE +01                       TO UV-CODE-VALUE-LEN.         
           MOVE VC-CODE-STATUS-REA-IS     TO UV-CODE-VALUE-TEXT.        
           PERFORM 7300-SELECT-CODE-DESC  THRU 7300-EXIT.               
           MOVE LENGTH OF UV-CODE-LONG-DESC-TEXT                        
                                          TO UV-CODE-LONG-DESC-LEN.     
           MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)         
                                          TO WS-CODE-STATUS-LDESC.      
      *                                                                         
           PERFORM 5100-MOVE-FILE-DETAILS THRU 5100-EXIT.               
           PERFORM 8900-WRITE-OUTPUT      THRU 8900-EXIT.               
           INITIALIZE        WS-COMPANY-NAME,                           
                             WS-COMPLET-MNTH,                           
                             WS-COMPLET-DTE,                            
                             WS-COMPLET-YEAR,                           
                             VI-METER-NO,                               
                             EQ-SERIAL-NO,                              
                             GM-METER-SIZE-ID,                          
                             WS-CODE-STATUS-LDESC.                      
           PERFORM 7510-FETCH-GAS-METER-CSR THRU 7510-EXIT.             
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5100-MOVE-FILE-DETAILS.                                       *         
      *****************************************************************         
       5100-MOVE-FILE-DETAILS.                                          
                                                                        
           INITIALIZE E-FRP664.                                         
                                                                        
           MOVE WS-COMPANY-NAME            TO E-FRP664-COMPANY-NAME.    
           MOVE WS-FMT-COMPLET-DATE        TO E-FRP664-COMPLET-DATE.    
           MOVE VI-METER-NO                TO E-FRP664-METER-NO.        
           MOVE EQ-SERIAL-NO               TO E-FRP664-METER-SERIAL.    
           MOVE GM-METER-SIZE-ID           TO E-FRP664-METER-TYPE.      
           MOVE WS-CODE-STATUS-LDESC       TO E-FRP664-STATUS-DESC.     
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      * 7100-GET-CURRENT-DAY                                          *         
      *****************************************************************         
       7100-GET-CURRENT-DAY.                                            
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURR-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -5, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-5DAYOLD-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-5DAYOLD-DATE = (CURRENT DATE - 5 DAYS)                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**         7100-GET-CURRENT-DAY          **'     
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-SELECT-CODE-STATUS.                                      *         
      *****************************************************************         
       7200-SELECT-CODE-STATUS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT VC.CODE_STATUS_REA_IS                             
                 INTO :VC-CODE-STATUS-REA-IS                            
                 FROM CSS_SO_MTR_CHG   VC WITH(READUNCOMMITTED)                 
                WHERE SERV_ORDER_NO   = :VC-SERV-ORDER-NO               
                  AND CODE_UTIL_TYPE  = :VC-CODE-UTIL-TYPE              
                  AND IC_NO           = :VC-IC-NO                       
                  AND MTR_REF_NO      = :VC-MTR-REF-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VC.CODE_STATUS_REA_IS                                     
MFA-TR*          INTO :VC-CODE-STATUS-REA-IS                                    
MFA-TR*          FROM CSS_SO_MTR_CHG   VC                                       
MFA-TR*         WHERE SERV_ORDER_NO   = :VC-SERV-ORDER-NO                       
MFA-TR*           AND CODE_UTIL_TYPE  = :VC-CODE-UTIL-TYPE                      
MFA-TR*           AND IC_NO           = :VC-IC-NO                               
MFA-TR*           AND MTR_REF_NO      = :VC-MTR-REF-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**         7200-SELECT-CODE-STATUS       **'     
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** SERV_ORDER_NO  = ' VC-SERV-ORDER-NO           
              DISPLAY '** CODE_UTIL_TYPE = ' VC-CODE-UTIL-TYPE          
              DISPLAY '** IC_NO          = ' VC-IC-NO                   
              DISPLAY '** MTR_REF_NO     = ' VC-MTR-REF-NO              
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-SELECT-CODE-DESC.                                        *         
      *****************************************************************         
       7300-SELECT-CODE-DESC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_LONG_DESC                                    
                 INTO :UV-CODE-LONG-DESC                                
                 FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                      
                WHERE CODE_VALUE = :UV-CODE-VALUE                       
                  AND TABLE_NA   = 'CSS_REGISTER_READ'                  
                  AND COLUMN_NA  = 'CODE_STATUS_REAS'                   
                  AND PROGRAM_ID = 'ALL'                                
                  AND COMPANY_NO = '01'                                 
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_LONG_DESC                                            
MFA-TR*          INTO :UV-CODE-LONG-DESC                                        
MFA-TR*          FROM CSS_CODE_VALUE                                            
MFA-TR*         WHERE CODE_VALUE = :UV-CODE-VALUE                               
MFA-TR*           AND TABLE_NA   = 'CSS_REGISTER_READ'                          
MFA-TR*           AND COLUMN_NA  = 'CODE_STATUS_REAS'                           
MFA-TR*           AND PROGRAM_ID = 'ALL'                                        
MFA-TR*           AND COMPANY_NO = '01'                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**         7300-SELECT-CODE-DESC         **'     
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** CODE_VALUE     = ' UV-CODE-VALUE              
              DISPLAY '** TABLE_NA       = CSS_REGISTER_READ'           
              DISPLAY '** COLUMN_NA      = CODE_STATUS_REAS'            
              DISPLAY '** PROGRAM_ID     = ALL'                         
              DISPLAY '** COMPANY_NO     = 01'                          
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-GAS-METER-CSR.                                      *         
      *****************************************************************         
       7500-OPEN-GAS-METER-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN GAS_METER_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP664 ABORT **************'        
              DISPLAY '*     7500-OPEN-GAS-METER-CSR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP664 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7510-FETCH-GAS-METER-CSR                                      *         
      *****************************************************************         
       7510-FETCH-GAS-METER-CSR.                                        
                                                                        
           EXEC SQL                                                     
                FETCH GAS_METER_DET                                     
                 INTO :VI-SERV-ORDER-NO                                 
                     ,:VI-SO-INST-SEQ-NO                                
                     ,:VI-CODE-UTIL-TYPE                                
                     ,:VI-METER-NO                                      
                     ,:VI-IC-NO                                         
                     ,:VI-MTR-REF-NO                                    
                     ,:VO-ACCOUNT-NO                                    
                     ,:VO-COMPANY-NO                                    
                     ,:WS-W0-DATE :WS-NULL-IND1                          
                     ,:WS-COMPLET-DATE :WS-NULL-IND2                     
                     ,:VO-ACCOUNT-NO-PRIOR                              
                     ,:VO-LOCAL-OFFICE                                  
                     ,:GM-METER-SIZE-ID                                 
                     ,:GM-DATE-LAST-TESTED :WS-NULL-IND3                 
                     ,:GM-CCF-CAP-PER-HR                                
                     ,:GM-LAST-TEST-SEL-DT :WS-NULL-IND4                 
                     ,:GM-LAST-TEST-SEL-CD                              
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CRNT-LOC-NO                                   
                     ,:EQ-DATE-PURCHASED :WS-NULL-IND5                   
                     ,:EQ-SERIAL-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO    WS-ACTIVE-RETURN-CODE.   
           EVALUATE TRUE                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL          
                  IF WS-NULL-IND1 < 0                                   
                     MOVE SPACES         TO    WS-COMPLET-DATE          
                  END-IF                                                
                  IF WS-NULL-IND2 < 0                                   
                     MOVE SPACES         TO    VO-COMPLETED-DATETIME    
                  END-IF                                                
                  IF WS-NULL-IND3 < 0                                   
                     MOVE SPACES         TO    GM-DATE-LAST-TESTED      
                  END-IF                                                
                  IF WS-NULL-IND4 < 0                                   
                     MOVE SPACES         TO    GM-LAST-TEST-SEL-DT      
                  END-IF                                                
                  IF WS-NULL-IND5 < 0                                   
                     MOVE SPACES         TO    EQ-DATE-PURCHASED        
                  END-IF                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND                
                  MOVE 'Y'               TO    WS-NO-MORE-RECORDS       
                  DISPLAY '********** PCSRP664 ********************'    
                  DISPLAY '*     7510-FETCH-GAS-METER-CSR         *'    
                  DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE   
                  DISPLAY '* CURRENT DATE   : ' WS-CURR-DATE            
                  DISPLAY '* 5 DAYS OLD DATE: ' WS-5DAYOLD-DATE         
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '***********PCSRP664 ABORT ***************'   
             WHEN OTHER                                                 
                  DISPLAY '********** PCSRP664 ABORT **************'    
                  DISPLAY '*     7510-FETCH-GAS-METER-CSR         *'    
                  DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE   
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '***********PCSRP664 ABORT ***************'   
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-GAS-METER-CSR                                      *         
      *****************************************************************         
       7520-CLOSE-GAS-METER-CSR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE GAS_METER_DET                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP664 ABORT **************'        
              DISPLAY '*      7520-CLOSE-GAS-METER-CSR        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP664 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8900-WRITE-OUTPUT.                                            *         
      *****************************************************************         
       8900-WRITE-OUTPUT.                                               
           INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
                      WS-CMP-TABLE        WS-K.                         
           INSPECT E-FRP664 REPLACING ALL ',' BY ' '.                   
           STRING E-FRP664-COMPANY-NAME  ','                            
                  E-FRP664-COMPLET-DATE  ','                            
                  E-FRP664-METER-NO      ','                            
                  E-FRP664-METER-SERIAL  ','                            
                  E-FRP664-METER-TYPE    ','                            
                  E-FRP664-STATUS-DESC   ','                            
                      DELIMITED BY SIZE INTO WS-OUTPUT-RECORD.          
           MOVE WS-OUTPUT-RECORD    TO WS-EMB-INPUT                     
           MOVE 122                 TO WS-EMB-LENG                      
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT           
           MOVE WS-CMP-TABLE        TO WS-OUTPUT-RECORD.                
      *                                                                         
           INSPECT FUNCTION REVERSE (WS-OUTPUT-RECORD)                  
               TALLYING WS-K FOR LEADING SPACES                         
           COMPUTE WS-RECORD-LENGTH = 122 - WS-K.                       
           MOVE WS-OUTPUT-RECORD TO  FCSRP664-RECORD.                   
           WRITE FCSRP664-RECORD.                                       
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSRP664-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00004                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 4000-MAIL-NAME-ADDRESS.                                       *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
