       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP663.                                        
       AUTHOR.         MUTHUKUMAR RAMAIAH.                              
       DATE-WRITTEN.   NOV 2016.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **             F U N C T I O N A L   D E S C R I P T I O N    **          
      **                             O F   M O D U LE               **          
      **                                                            **          
      **  PURPOSE : GAS METER DETAIL FOR BEFORE CURRENT YEAR REPORT **          
      **                                                     (CSV). **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
A05460** 11/16/16   MR7E794    INITIAL CODE                         **          
      ** 02/14/17   NC94746    SHOW ORDERS THAT WERE NOT CANCELLED  **          
      **                       AND NOT TESTED                       **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSRP663.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSRP663-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS V                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FCSRP663-RECORD.                                             
           05  FILLER                 PIC X                             
                                      OCCURS 1 TO 211 TIMES             
                                      DEPENDING ON WS-RECORD-LENGTH.    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP663'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 PROGRAM-NAME            PIC X(08) VALUE 'PCSRP663'.       
           05 WS-PGRMNAME             PIC X(08) VALUE 'PCSRP663'.       
           05 WS-OUTPUT-RECORD        PIC X(211) VALUE SPACES.          
           05 WS-RECORD-LENGTH        PIC S9(04) COMP VALUE ZERO.       
           05 WS-K                    PIC S9(04) COMP VALUE ZERO.       
           05 WS-HEADER-LINE.                                           
              10 FILLER               PIC X(56)  VALUE                  
           'COMPANY,WO DATE,METER NO,METER SERIAL,METER TYPE,ACCOUNT'.  
              10 FILLER               PIC X(33)  VALUE                  
           ' NO,LOCATION,ADDRESS,LOCAL OFFICE'.                         
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND1            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND2            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND3            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND4            PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND5            PIC S9(04) COMP VALUE +0.         
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS     PIC X(01) VALUE 'N'.              
               88 NO-MORE-RECORDS               VALUE 'Y'.              
           05  WS-FCSRP663-STATUS     PIC X(02).                        
               88 FCSRP663-SUCCESSFUL           VALUE '00'.             
      *                                                                         
       COPY FIORP663.                                                           
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
      *****************************************************************         
      *  CWS00011  CONTAINS SPACE COMPRESSION VARIABLES               *         
      *****************************************************************         
      *    COPY CWS00011.                                                       
       01  WS-11-TABLES.                                                
      *                                                                         
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 211 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +211.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 211 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-WO-DATE               PIC X(10) VALUE SPACES.         
           05  WS-FMT-WO-DATE.                                          
               10 WS-WO-MNTH            PIC X(02) VALUE SPACES.         
               10 WS-FSLASH             PIC X(01) VALUE '/'.            
               10 WS-WO-DTE             PIC X(02) VALUE SPACES.         
               10 WS-FSLASH             PIC X(01) VALUE '/'.            
               10 WS-WO-YEAR            PIC X(04) VALUE SPACES.         
           05 WS-ACCT                   PIC X(13) VALUE SPACES.         
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
           05 WS-LOC-DESC.                                              
              10 WS-CODE-CRNT-LOC       PIC X(01) VALUE SPACE.          
              10 WS-FILLER              PIC X(01) VALUE '-'.            
              10 WS-EQUIP-LOC-DESC      PIC X(25) VALUE SPACES.         
           05 WS-LOCAL-OFFICE.                                          
              10 WS-LOCAL-OFF-CODE      PIC X(03) VALUE SPACES.         
              10 WS-FILLER              PIC X(01) VALUE '-'.            
              10 WS-LOCAL-OFF-DESC      PIC X(22) VALUE SPACES.         
           05 WS-DATABASE               PIC 9(01) VALUE ZERO.           
              88 CSR-DATABASE                     VALUE 1.              
              88 SEB-DATABASE                     VALUE 2.              
           05 WS-MCU                    PIC X(03) VALUE 'MCU'.          
           05 WS-MCB                    PIC X(03) VALUE 'MCB'.          
           05 WS-RMT                    PIC X(03) VALUE 'RMT'.          
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-G                      PIC X(01) VALUE 'G'.            
      *                                                                         
       01  WS-INIT-VAR.                                                 
           05 WS-COMPANY-NAME           PIC X(04) VALUE SPACES.         
           05 WS-FMT-ADDRESS.                                           
              10 WS-FMT-CT-ST           PIC X(30) VALUE SPACES.         
              10 WS-FMT-ZIP-CD          PIC X(05) VALUE SPACES.         
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1 REDEFINES WS-SAVE-ACCT.                  
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
           05 WS-CTY-ST-ZIP             PIC X(32) VALUE SPACES.         
      *                                                                         
      *****************************************************************         
      *  COPY BOOK FOR CPD00074                                       *         
      *****************************************************************         
       COPY CWS00074.                                                           
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
      *COPY CWS00039.                                                           
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
      *COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME, DQ                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FORMATTED, DY                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ZIP_CODE, A4                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_ADD_XREF, DZ                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FREEFORM, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MISC_INFO, TA                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME_ACC_XREF, HT                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_EQUIP_LOCATION M6                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBEQLOC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_SO_DATA VO                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_SO_ORDER_INST VI                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_GAS_METER GM                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_EQUIPMENT EQ                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : HST_SO_ORDER_INST ZG                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBHSTODR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : HST_SO_DATA YV                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBHSTDAT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_LOCAL_OFFICE B1                                          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DRIVER CURSOR DECLARATIONS.                                *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE GAS_METER_DET  CURSOR FOR                         
                 SELECT VI.SERV_ORDER_NO                                
                       ,VI.SO_INST_SEQ_NO                               
                       ,VI.CODE_UTIL_TYPE                               
                       ,VI.METER_NO                                     
                       ,VO.ACCOUNT_NO                                   
                       ,VO.COMPANY_NO                                   
                       ,CAST(VO.ASSIGNED_DATETIME AS DATE)                      
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                           
                       ,VO.ACCOUNT_NO_PRIOR                             
                       ,VO.LOCAL_OFFICE                                 
                       ,GM.METER_SIZE_ID                                
                       ,GM.DATE_LAST_TESTED                             
                       ,GM.CCF_CAP_PER_HR                               
                       ,GM.LAST_TEST_SEL_DT                             
                       ,GM.LAST_TEST_SEL_CD                             
                       ,EQ.CODE_CRNT_LOC                                
                       ,EQ.CRNT_LOC_NO                                  
                       ,EQ.DATE_PURCHASED                               
                       ,EQ.SERIAL_NO                                    
                   FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                       ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
                       ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                       ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                  
                  WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO            
                    AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)  
                    AND VI.SAMPLE_TEST_FL = :WS-Y                       
                    AND VI.CODE_UTIL_TYPE = :WS-G                       
                    AND VO.ORDER_STATE_CD <> 'C'                        
                    AND VO.COMPANY_NO  = GM.COMPANY_NO                  
                    AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND VI.METER_NO  = GM.METER_NO                      
                    AND EQ.COMPANY_NO  = GM.COMPANY_NO                  
                    AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND EQ.DEVICE_NO  = GM.METER_NO                     
                    AND YEAR(COALESCE(GM.DATE_LAST_TESTED,              
                        IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))) <> YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE))      
                    AND YEAR(VO.ASSIGNED_DATETIME) = YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE)) 
                  UNION                                                 
                 SELECT VI.SERV_ORDER_NO                                
                       ,VI.SO_INST_SEQ_NO                               
                       ,VI.CODE_UTIL_TYPE                               
                       ,VI.METER_NO                                     
                       ,VO.ACCOUNT_NO                                   
                       ,VO.COMPANY_NO                                   
                       ,CAST(VO.ASSIGNED_DATETIME AS DATE)                      
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                           
                       ,VO.ACCOUNT_NO_PRIOR                             
                       ,VO.LOCAL_OFFICE                                 
                       ,GM.METER_SIZE_ID                                
                       ,GM.DATE_LAST_TESTED                             
                       ,GM.CCF_CAP_PER_HR                               
                       ,GM.LAST_TEST_SEL_DT                             
                       ,GM.LAST_TEST_SEL_CD                             
                       ,EQ.CODE_CRNT_LOC                                
                       ,EQ.CRNT_LOC_NO                                  
                       ,EQ.DATE_PURCHASED                               
                       ,EQ.SERIAL_NO                                    
                   FROM HST_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                       ,HST_SO_DATA VO WITH(READUNCOMMITTED)                    
                       ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                       ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                  
                  WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO            
                    AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)  
                    AND VI.SAMPLE_TEST_FL = :WS-Y                       
                    AND VI.CODE_UTIL_TYPE = :WS-G                       
                    AND VO.ORDER_STATE_CD <> 'C'                        
                    AND VO.COMPANY_NO  = GM.COMPANY_NO                  
                    AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND VI.METER_NO  = GM.METER_NO                      
                    AND EQ.COMPANY_NO  = GM.COMPANY_NO                  
                    AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE           
                    AND EQ.DEVICE_NO  = GM.METER_NO                     
                    AND YEAR(COALESCE(GM.DATE_LAST_TESTED,              
                        IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))) <> YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE))      
                    AND YEAR(VO.ASSIGNED_DATETIME) = YEAR(
           CAST(SYSDATETIMEOFFSET() AS DATE)) 
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GAS_METER_DET  CURSOR FOR                                 
MFA-TR*          SELECT VI.SERV_ORDER_NO                                        
MFA-TR*                ,VI.SO_INST_SEQ_NO                                       
MFA-TR*                ,VI.CODE_UTIL_TYPE                                       
MFA-TR*                ,VI.METER_NO                                             
MFA-TR*                ,VO.ACCOUNT_NO                                           
MFA-TR*                ,VO.COMPANY_NO                                           
MFA-TR*                ,DATE(VO.ASSIGNED_DATETIME)                              
MFA-TR*                ,VO.COMPLETED_DATETIME                                   
MFA-TR*                ,VO.ACCOUNT_NO_PRIOR                                     
MFA-TR*                ,VO.LOCAL_OFFICE                                         
MFA-TR*                ,GM.METER_SIZE_ID                                        
MFA-TR*                ,GM.DATE_LAST_TESTED                                     
MFA-TR*                ,GM.CCF_CAP_PER_HR                                       
MFA-TR*                ,GM.LAST_TEST_SEL_DT                                     
MFA-TR*                ,GM.LAST_TEST_SEL_CD                                     
MFA-TR*                ,EQ.CODE_CRNT_LOC                                        
MFA-TR*                ,EQ.CRNT_LOC_NO                                          
MFA-TR*                ,EQ.DATE_PURCHASED                                       
MFA-TR*                ,EQ.SERIAL_NO                                            
MFA-TR*            FROM CSS_SO_ORDER_INST VI                                    
MFA-TR*                ,CSS_SO_DATA VO                                          
MFA-TR*                ,CSS_GAS_METER GM                                        
MFA-TR*                ,CSS_EQUIPMENT EQ                                        
MFA-TR*           WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                    
MFA-TR*             AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)          
MFA-TR*             AND VI.SAMPLE_TEST_FL = :WS-Y                               
MFA-TR*             AND VI.CODE_UTIL_TYPE = :WS-G                               
MFA-TR*             AND VO.ORDER_STATE_CD <> 'C'                                
MFA-TR*             AND VO.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND VI.METER_NO  = GM.METER_NO                              
MFA-TR*             AND EQ.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.DEVICE_NO  = GM.METER_NO                             
MFA-TR*             AND YEAR(COALESCE(GM.DATE_LAST_TESTED,                      
MFA-TR*                 DATE('0001-01-01'))) <> YEAR(CURRENT DATE)              
MFA-TR*             AND YEAR(VO.ASSIGNED_DATETIME) = YEAR(CURRENT DATE)         
MFA-TR*           UNION                                                         
MFA-TR*          SELECT VI.SERV_ORDER_NO                                        
MFA-TR*                ,VI.SO_INST_SEQ_NO                                       
MFA-TR*                ,VI.CODE_UTIL_TYPE                                       
MFA-TR*                ,VI.METER_NO                                             
MFA-TR*                ,VO.ACCOUNT_NO                                           
MFA-TR*                ,VO.COMPANY_NO                                           
MFA-TR*                ,DATE(VO.ASSIGNED_DATETIME)                              
MFA-TR*                ,VO.COMPLETED_DATETIME                                   
MFA-TR*                ,VO.ACCOUNT_NO_PRIOR                                     
MFA-TR*                ,VO.LOCAL_OFFICE                                         
MFA-TR*                ,GM.METER_SIZE_ID                                        
MFA-TR*                ,GM.DATE_LAST_TESTED                                     
MFA-TR*                ,GM.CCF_CAP_PER_HR                                       
MFA-TR*                ,GM.LAST_TEST_SEL_DT                                     
MFA-TR*                ,GM.LAST_TEST_SEL_CD                                     
MFA-TR*                ,EQ.CODE_CRNT_LOC                                        
MFA-TR*                ,EQ.CRNT_LOC_NO                                          
MFA-TR*                ,EQ.DATE_PURCHASED                                       
MFA-TR*                ,EQ.SERIAL_NO                                            
MFA-TR*            FROM HST_SO_ORDER_INST VI                                    
MFA-TR*                ,HST_SO_DATA VO                                          
MFA-TR*                ,CSS_GAS_METER GM                                        
MFA-TR*                ,CSS_EQUIPMENT EQ                                        
MFA-TR*           WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                    
MFA-TR*             AND VI.WORK_TYPE_CD   IN (:WS-MCU,:WS-MCB,:WS-RMT)          
MFA-TR*             AND VI.SAMPLE_TEST_FL = :WS-Y                               
MFA-TR*             AND VI.CODE_UTIL_TYPE = :WS-G                               
MFA-TR*             AND VO.ORDER_STATE_CD <> 'C'                                
MFA-TR*             AND VO.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND VI.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND VI.METER_NO  = GM.METER_NO                              
MFA-TR*             AND EQ.COMPANY_NO  = GM.COMPANY_NO                          
MFA-TR*             AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.DEVICE_NO  = GM.METER_NO                             
MFA-TR*             AND YEAR(COALESCE(GM.DATE_LAST_TESTED,                      
MFA-TR*                 DATE('0001-01-01'))) <> YEAR(CURRENT DATE)              
MFA-TR*             AND YEAR(VO.ASSIGNED_DATETIME) = YEAR(CURRENT DATE)         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-GAS-METER-RPT  THRU 1000-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSRP663-FILE.                                   
                                                                        
           IF FCSRP663-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FIORP663 FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSRP663-STATUS          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              MOVE 12 TO RETURN-CODE                                    
              STOP RUN                                                  
           END-IF.                                                      
                                                                        
           MOVE SPACES TO FCSRP663-RECORD.                              
           INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
                      WS-CMP-TABLE        WS-K.                         
           MOVE WS-HEADER-LINE   TO WS-OUTPUT-RECORD.                   
           MOVE 89               TO WS-RECORD-LENGTH.                   
           MOVE WS-OUTPUT-RECORD TO FCSRP663-RECORD.                    
           WRITE FCSRP663-RECORD.                                       
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-GAS-METER-RPT.                                   *         
      *****************************************************************         
       1000-PROCESS-GAS-METER-RPT.                                      
                                                                        
           PERFORM 7500-OPEN-GAS-METER-CSR     THRU 7500-EXIT.          
           PERFORM 7510-FETCH-GAS-METER-CSR    THRU 7510-EXIT.          
           IF NO-MORE-RECORDS                                           
              DISPLAY 'NO OUTPUT TO PROCESS'                            
           ELSE                                                         
              PERFORM 5000-GAS-METER-RPT-DETAILS     THRU  5000-EXIT    
                                               UNTIL NO-MORE-RECORDS    
           END-IF.                                                      
                                                                        
           PERFORM 7520-CLOSE-GAS-METER-CSR    THRU 7520-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-GAS-METER-RPT-DETAILS                                    *         
      *****************************************************************         
       5000-GAS-METER-RPT-DETAILS.                                      
                                                                        
      ***********COMPANY NAME                                                   
           IF VO-COMPANY-NO = '01'                                      
              MOVE 'SCEG'                 TO WS-COMPANY-NAME            
           ELSE                                                         
              MOVE 'PSNC'                 TO WS-COMPANY-NAME            
           END-IF.                                                      
      ***********WO DATE                                                        
           MOVE WS-WO-DATE(01:04)         TO WS-WO-YEAR.                
           MOVE WS-WO-DATE(06:02)         TO WS-WO-MNTH.                
           MOVE WS-WO-DATE(09:02)         TO WS-WO-DTE.                 
      ***********FORMAT ACCOUNT NUMBER                                          
           MOVE VO-ACCOUNT-NO             TO WS-SAVE-ACCT.              
           MOVE WS-SAVE-ACCT1             TO WS-ACCT1.                  
           MOVE WS-SAVE-ACCT2             TO WS-ACCT2.                  
           MOVE WS-SAVE-ACCT3             TO WS-ACCT3.                  
           MOVE WS-SAVE-ACCT4             TO WS-ACCT4.                  
      *                                                                         
           MOVE VO-COMPANY-NO             TO M6-COMPANY-NO.             
           MOVE VI-CODE-UTIL-TYPE         TO M6-CODE-UTIL-TYPE.         
           MOVE EQ-CODE-CRNT-LOC          TO M6-EQUIP-LOC-ID            
                                             WS-CODE-CRNT-LOC.          
           PERFORM 7300-SELECT-LOC-DESC   THRU 7300-EXIT                
           MOVE M6-EQUIP-LOC-DESC         TO WS-EQUIP-LOC-DESC.         
      ***********ADDRESS                                                        
           INITIALIZE        AT-ADDRESS-ID, WS-PR-STREET.               
           MOVE VO-ACCOUNT-NO             TO   AT-ACCOUNT-NO.           
           PERFORM 7200-SELECT-ADDR-ID    THRU 7200-EXIT.               
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           MOVE WS-PR-ADDR-CITY-STATE     TO WS-FMT-CT-ST.              
           MOVE WS-PR-ADDR-ZIP-CODE       TO WS-FMT-ZIP-CD.             
      ***********LOCAL OFFICE                                                   
           MOVE VO-COMPANY-NO             TO B1-COMPANY-NO.             
           MOVE VO-LOCAL-OFFICE           TO B1-LOCAL-OFFICE            
                                             WS-LOCAL-OFF-CODE.         
           PERFORM 7400-SELECT-LOCAL-OFF  THRU 7400-EXIT.               
           MOVE B1-LOCAL-OFFICE-DESC      TO WS-LOCAL-OFF-DESC.         
      *                                                                         
           PERFORM 5100-MOVE-FILE-DETAILS THRU 5100-EXIT                
           PERFORM 8900-WRITE-OUTPUT      THRU 8900-EXIT                
           INITIALIZE        WS-INIT-VAR,                               
                             WS-WO-MNTH,                                
                             WS-WO-DTE,                                 
                             WS-WO-YEAR,                                
                             WS-CODE-CRNT-LOC,                          
                             WS-EQUIP-LOC-DESC,                         
                             WS-LOCAL-OFF-CODE,                         
                             WS-LOCAL-OFF-DESC.                         
           PERFORM 7510-FETCH-GAS-METER-CSR THRU 7510-EXIT.             
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5100-MOVE-FILE-DETAILS.                                       *         
      *****************************************************************         
       5100-MOVE-FILE-DETAILS.                                          
                                                                        
           INITIALIZE E-FRP663.                                         
                                                                        
           MOVE WS-COMPANY-NAME            TO E-FRP663-COMPANY-NAME.    
           MOVE WS-FMT-WO-DATE             TO E-FRP663-WO-DATE.         
           MOVE VI-METER-NO                TO E-FRP663-METER-NO.        
           MOVE EQ-SERIAL-NO               TO E-FRP663-METER-SERIAL.    
           MOVE GM-METER-SIZE-ID           TO E-FRP663-METER-TYPE.      
           MOVE WS-ACCOUNT1                TO E-FRP663-ACCOUNT-NO.      
           MOVE WS-LOC-DESC                TO E-FRP663-LOCATION.        
           STRING WS-PR-STREET ' ' WS-FMT-CT-ST ' '                     
                  WS-FMT-ZIP-CD ',' DELIMITED BY '  '                   
                                         INTO E-FRP663-ADDRESS.         
           MOVE WS-LOCAL-OFFICE            TO E-FRP663-LOCAL-OFFICE.    
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7200-SELECT-ADDR-ID.                                          *         
      *****************************************************************         
       7200-SELECT-ADDR-ID.                                             
                                                                        
           EXEC SQL                                                     
               SELECT  ADDRESS_ID                                       
                 INTO  :AT-ADDRESS-ID                                   
                FROM   CSS_ACCOUNT                                      
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*     7200-SELECT-ADDR-ID  *'                    
              DISPLAY '* ADDRESS ID     : ' AT-ADDRESS-ID               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7300-SELECT-LOC-DESC                                          *         
      *****************************************************************         
       7300-SELECT-LOC-DESC.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  EQUIP_LOC_DESC                                   
                 INTO  :M6-EQUIP-LOC-DESC                               
                 FROM  CSS_EQUIP_LOCATION                               
                WHERE  COMPANY_NO     = :M6-COMPANY-NO                  
                  AND  CODE_UTIL_TYPE = :M6-CODE-UTIL-TYPE              
                  AND  EQUIP_LOC_ID   = :M6-EQUIP-LOC-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*     7300-SELECT-LOC-DESC *'                    
              DISPLAY '* COMPANY_NO     : ' M6-COMPANY-NO               
              DISPLAY '* CODE_UTIL_TYPE : ' M6-CODE-UTIL-TYPE           
              DISPLAY '* EQUIP_LOC_ID   : ' M6-EQUIP-LOC-ID             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7400-SELECT-LOCAL-OFF                                         *         
      *****************************************************************         
       7400-SELECT-LOCAL-OFF.                                           
                                                                        
           EXEC SQL                                                     
               SELECT  LOCAL_OFFICE_DESC                                
                 INTO  :B1-LOCAL-OFFICE-DESC                            
                 FROM  CSS_LOCAL_OFFICE                                 
                WHERE  COMPANY_NO     = :B1-COMPANY-NO                  
                  AND  LOCAL_OFFICE   = :B1-LOCAL-OFFICE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*     7400-SELECT-LOCAL-OFF**'                   
              DISPLAY '* COMPANY_NO     : ' B1-COMPANY-NO               
              DISPLAY '* LOCAL_OFFICE   : ' B1-LOCAL-OFFICE             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-GAS-METER-CSR.                                      *         
      *****************************************************************         
       7500-OPEN-GAS-METER-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN GAS_METER_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*     7500-OPEN-GAS-METER-CSR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7510-FETCH-GAS-METER-CSR                                      *         
      *****************************************************************         
       7510-FETCH-GAS-METER-CSR.                                        
                                                                        
           EXEC SQL                                                     
                FETCH GAS_METER_DET                                     
                 INTO :VI-SERV-ORDER-NO                                 
                     ,:VI-SO-INST-SEQ-NO                                
                     ,:VI-CODE-UTIL-TYPE                                
                     ,:VI-METER-NO                                      
                     ,:VO-ACCOUNT-NO                                    
                     ,:VO-COMPANY-NO                                    
                     ,:WS-WO-DATE :WS-NULL-IND1                          
                     ,:VO-COMPLETED-DATETIME :WS-NULL-IND2               
                     ,:VO-ACCOUNT-NO-PRIOR                              
                     ,:VO-LOCAL-OFFICE                                  
                     ,:GM-METER-SIZE-ID                                 
                     ,:GM-DATE-LAST-TESTED :WS-NULL-IND3                 
                     ,:GM-CCF-CAP-PER-HR                                
                     ,:GM-LAST-TEST-SEL-DT :WS-NULL-IND4                 
                     ,:GM-LAST-TEST-SEL-CD                              
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CRNT-LOC-NO                                   
                     ,:EQ-DATE-PURCHASED :WS-NULL-IND5                   
                     ,:EQ-SERIAL-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO    WS-ACTIVE-RETURN-CODE.   
           EVALUATE TRUE                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL          
                  IF WS-NULL-IND1 < 0                                   
                     MOVE SPACES         TO    WS-WO-DATE               
                  END-IF                                                
                  IF WS-NULL-IND2 < 0                                   
                     MOVE SPACES         TO    VO-COMPLETED-DATETIME    
                  END-IF                                                
                  IF WS-NULL-IND3 < 0                                   
                     MOVE SPACES         TO    GM-DATE-LAST-TESTED      
                  END-IF                                                
                  IF WS-NULL-IND4 < 0                                   
                     MOVE SPACES         TO    GM-LAST-TEST-SEL-DT      
                  END-IF                                                
                  IF WS-NULL-IND5 < 0                                   
                     MOVE SPACES         TO    EQ-DATE-PURCHASED        
                  END-IF                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND                
                  MOVE 'Y'               TO    WS-NO-MORE-RECORDS       
             WHEN OTHER                                                 
                  DISPLAY '********** PCSRP663 ABORT **************'    
                  DISPLAY '*     7510-FETCH-GAS-METER-CSR         *'    
                  DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE   
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '***********PCSRP663 ABORT ***************'   
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-GAS-METER-CSR                                      *         
      *****************************************************************         
       7520-CLOSE-GAS-METER-CSR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE GAS_METER_DET                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP663 ABORT **************'        
              DISPLAY '*      7520-CLOSE-GAS-METER-CSR        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP663 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8900-WRITE-OUTPUT.                                            *         
      *****************************************************************         
       8900-WRITE-OUTPUT.                                               
           MOVE SPACES TO FCSRP663-RECORD.                              
           INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
                      WS-CMP-TABLE        WS-K.                         
           INSPECT E-FRP663 REPLACING ALL ',' BY ' '.                   
           STRING E-FRP663-COMPANY-NAME  ','                            
                  E-FRP663-WO-DATE       ','                            
                  E-FRP663-METER-NO      ','                            
                  E-FRP663-METER-SERIAL  ','                            
                  E-FRP663-METER-TYPE    ','                            
                  E-FRP663-ACCOUNT-NO    ','                            
                  E-FRP663-LOCATION      ','                            
                  E-FRP663-ADDRESS       ','                            
                  E-FRP663-LOCAL-OFFICE                                 
                      DELIMITED BY SIZE INTO WS-OUTPUT-RECORD.          
           MOVE WS-OUTPUT-RECORD    TO WS-EMB-INPUT                     
           MOVE 211                 TO WS-EMB-LENG                      
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT           
           MOVE WS-CMP-TABLE        TO WS-OUTPUT-RECORD.                
      *                                                                         
           INSPECT FUNCTION REVERSE (WS-OUTPUT-RECORD)                  
               TALLYING WS-K FOR LEADING SPACES                         
           COMPUTE WS-RECORD-LENGTH = 211 - WS-K.                       
           MOVE WS-OUTPUT-RECORD TO  FCSRP663-RECORD.                   
           WRITE FCSRP663-RECORD.                                       
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSRP663-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00004                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 4000-MAIL-NAME-ADDRESS.                                       *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
