       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP661.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     APR 15, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***PRINTS A REPORT OF                                          ***        
      ***                                                            ***        
      ***   THIS PROGRAM PRINTS THE GAS PERIODIC METER TEST          ***        
      ***   CONTROL LIST.                                            ***        
      ***                                                            ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT057***  04/15/2016    VV7M728     GMC661 CONVERT EZT TO COBOL     ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
      ****************************************************************          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT INFILE                                                
               ASSIGN TO UT-S-INFILE                                    
           FILE STATUS IS WS-INFILE-STATUS.                             
      *                                                                         
       COPY CSSPT331.                                                           
      *                                                                         
      ****************************************************************          
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  INFILE                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE-REC                      PIC X(230) VALUE SPACES.      
      *                                                                         
       COPY CFDPT331.                                                           
      *                                                                         
      ****************************************************************          
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP661'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOMT12.                                                            
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_COMPANY, C7                              *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBCOMPNY                                         05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ***************************************************************           
      *    CSS_EQUIPMENT                                            *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
       01 WS-MISC.                                                      
      *                                                                         
           05 WS-FMT12-ACCT-NO          PIC 9(13).                      
           05 WS-E-FMT12-ACCT-NO  REDEFINES WS-FMT12-ACCT-NO.           
              10 E-FMT12-ACCOUNT1       PIC 9(01).                      
              10 E-FMT12-ACCOUNT4A      PIC 9(04).                      
              10 E-FMT12-ACCOUNT4B      PIC 9(04).                      
              10 E-FMT12-ACCOUNT4C      PIC 9(04).                      
           05 WS-FMT12-DT-LAST-TSTD     PIC X(10).                      
           05 WS-E-DT-LAST-TESTED.                                      
              10 E-FMT12-LAST-MM        PIC Z9.                         
              10 E-FMT12-LAST-D1        PIC X(01) VALUE '/'.            
              10 E-FMT12-LAST-DD        PIC 9(02).                      
              10 E-FMT12-LAST-D2        PIC X(01) VALUE '/'.            
              10 E-FMT12-LAST-YYYY      PIC 9(04).                      
                                                                        
           05 WS-SCHED-TEST-DT.                                         
              10 E-FMT12-SCHED-YYYY     PIC 9(04) VALUE ZEROES.         
              10 E-FMT12-SCHED-D1       PIC X(01) VALUE '-'.            
              10 E-FMT12-SCHED-MM       PIC 9(02) VALUE ZEROES.         
              10 E-FMT12-SCHED-D2       PIC X(01) VALUE '-'.            
              10 E-FMT12-SCHED-DD       PIC 9(02) VALUE ZEROES.         
                                                                        
           05 WS-LAST-TST-SEL-DT        PIC X(10) VALUE SPACES.         
           05 WS-E-LAST-TEST-SEL-DT.                                    
              10 E-FMT12-L-SEL-MM       PIC 9(02) VALUE ZEROES.         
              10 E-FMT12-L-SEL-D1       PIC X(01) VALUE '/'.            
              10 E-FMT12-L-SEL-DD       PIC 9(02) VALUE ZEROES.         
              10 E-FMT12-L-SEL-D2       PIC X(01) VALUE '/'.            
              10 E-FMT12-L-SEL-YYYY     PIC 9(04) VALUE ZEROES.         
                                                                        
           05 WS-CONSTANT               PIC 9(6)V9(3) VALUE ZEROES.     
           05 WS-COMPANY-NO             PIC X(02) VALUE SPACES.         
           05 WS-SERIAL-NO              PIC X(11) VALUE SPACES.         
           05 WS-COMPANY-NAME           PIC X(26) VALUE SPACES.         
           05 WS-LOCAL-OFFICE-DESC      PIC X(22) VALUE SPACES.         
           05 WS-PAGE-NUM               PIC 9(06) VALUE 1.              
           05 WS-LOCAL-COUNT            PIC 9(06) VALUE ZEROES.         
           05 WS-FIRST                  PIC X(01) VALUE 'Y'.            
           05 WS-METER-NO               PIC X(09) VALUE SPACES.         
           05 WS-LOCAL-OFFICE           PIC X(03) VALUE SPACES.         
           05 WS-PREV-LOCAL-OFFICE      PIC X(03) VALUE SPACES.         
      *                                                                         
       01 WS-ACCT.                                                      
           05 WS-ACCOUNT1               PIC 9(01) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 WS-ACCOUNT4A              PIC 9(04) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 WS-ACCOUNT4B              PIC 9(04) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 WS-ACCOUNT4C              PIC 9(04) VALUE ZEROES.         
      *                                                                         
       01 WS-DATE-LAST-TESTED.                                          
           05 WS-L-DATE-MM              PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '/'.            
           05 WS-L-DATE-DD              PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '/'.            
           05 WS-L-DATE-YYYY            PIC 9(04) VALUE ZEROES.         
      *                                                                         
       01 WS-SCHED-TEST-DATE.                                           
           05 WS-S-DATE-MM              PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE '/'.            
           05 WS-S-DATE-YYYY            PIC 9(04) VALUE ZEROES.         
      *                                                                         
       01 WS-NEXT-TEST-DATE.                                            
           05 WS-N-DATE-MM              PIC 9(02) VALUE ZEROES.         
           05 WS-N-DATE-FF              PIC X(01) VALUE '/'.            
           05 WS-N-DATE-YYYY            PIC 9(04) VALUE ZEROES.         
      *                                                                         
       01 WS-RP661-HDR1-REC-LN1.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN1-NAME             PIC X(06) VALUE 'GMC661'.       
           05 FILLER                    PIC X(39) VALUE SPACES.         
           05 HDR1-LN1-COMPANY-NAME     PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(48) VALUE SPACES.         
           05 HDR1-LN1-PAGE             PIC X(05) VALUE 'PAGE '.        
           05 HDR1-LN1-PAGE-NO          PIC Z(06) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
      *                                                                         
       01 WS-RP661-HDR1-REC-LN2.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN2-DT               PIC X(06) VALUE 'DATE: '.       
           05 HDR1-LN2-DATE             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(21) VALUE SPACES.         
           05 HDR1-LN2-NAME             PIC X(27) VALUE                 
                                  'PERIODIC METER CONTROL LIST'.        
           05 FILLER                    PIC X(46) VALUE SPACES.         
           05 HDR1-LN2-NAME2            PIC X(09) VALUE 'RUN DATE:'.    
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN2-DATE1            PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP661-HDR1-REC-LN3.                                        
           05 FILLER                    PIC X(55) VALUE SPACES.         
           05 HDR1-LN3-NAME             PIC X(13) VALUE 'CURRENT AS OF'.
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN3-DATE             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(32) VALUE SPACES.         
           05 HDR1-LN3-NAME1            PIC X(09) VALUE 'RUN-TIME:'.    
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR1-LN3-TIME             PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP661-HDR1-REC-LN4.                                        
           05 HDR1-LN4-NAME             PIC X(15) VALUE                 
                                             'LOCAL OFFICE - '.         
           05 HDR1-LN4-LOCAL-OFC        PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR1-LN4-LOCAL-DESC       PIC X(22) VALUE SPACES.         
      *                                                                         
       01 WS-RP661-HDR1-REC-LN5.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP661-HDR1-REC-LN6.                                        
           05 FILLER                    PIC X(121) VALUE SPACES.        
           05 HDR1-LN6-TXT1             PIC X(09)  VALUE 'SCHEDULED'.   
      *                                                                         
       01 WS-RP661-HDR1-REC-LN7.                                        
           05 HDR1-LN7-TXT1             PIC X(25) VALUE                 
                           'READ  ACCOUNT NUMBER     '.                 
           05 HDR1-LN7-TXT2             PIC X(25) VALUE                 
                           ' METER      SERIAL       '.                 
           05 HDR1-LN7-TXT3             PIC X(25) VALUE                 
                           '  RATE         METER     '.                 
           05 HDR1-LN7-TXT4             PIC X(25) VALUE                 
                           '   METER         LAST    '.                 
           05 HDR1-LN7-TXT5             PIC X(27) VALUE                 
                           '   TEST   TEST FREQ    TEST'.               
      *                                                                         
       01 WS-RP661-HDR1-REC-LN8.                                        
           05 HDR1-LN8-TXT1             PIC X(25) VALUE                 
                           'ROUTE CUSTOMER NAME      '.                 
           05 HDR1-LN8-TXT2             PIC X(25) VALUE                 
                           'NUMBER      NUMBER    SER'.                 
           05 HDR1-LN8-TXT3             PIC X(25) VALUE                 
                           'VICE ADDRESS   CONST.    '.                 
           05 HDR1-LN8-TXT4             PIC X(25) VALUE                 
                           '    TYPE      TEST DATE  '.                 
           05 HDR1-LN8-TXT5             PIC X(27) VALUE                 
                           '   SCHED   MONTHS      DATE'.               
      *                                                                         
       01 WS-RP661-FTR1-REC-LN1.                                        
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 FTR1-LN1-TXT1             PIC X(24) VALUE                 
                           'TOTAL FOR LOCAL OFFICE: '.                  
           05 FTR1-LN1-COUNT            PIC ZZZ9.                       
      *                                                                         
       01 WS-RP661-FTR1-REC-LN2.                                        
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 FTR1-LN1-TXT2             PIC X(24) VALUE                 
                           '*** END OF REPORT ***   '.                  
      *                                                                         
       01  WS-OUTFILE-LN1.                                              
           05 OUT-READ-ROUTE            PIC 9(04) VALUE ZEROES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-ACCT                  PIC X(16) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-METER-NO              PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-SERIAL-NO             PIC X(11) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 OUT-RATE                  PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 OUT-CONSTANT              PIC ZZZ,ZZ9.999.                
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-METER-SIZE-ID         PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 OUT-DATE-LAST-TESTED      PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-TEST-SCH-CD           PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 OUT-TEST-FREQ-MONTHS      PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 OUT-SCHED-TEST-DATE       PIC X(07) VALUE SPACES.         
      *                                                                         
       01  WS-OUTFILE-LN2.                                              
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-NAME                  PIC X(40) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-SERV-ADDR             PIC X(42) VALUE SPACES.         
           05 OUT-ADDR                  PIC X(41) VALUE SPACES.         
           05 OUT-NEXT-TEST-DATE        PIC X(07) VALUE SPACES.         
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-INFILE-STATUS         PIC X(02) VALUE '00'.           
               88 INFILE-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC1                     VALUE '10'.           
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-TEST-METERS         THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
      *    MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.                  
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
      *    MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE                   
      *                                      HDR-LAST-TEST-SEL-DT.              
                                                                        
      *                                                                         
           OPEN INPUT INFILE.                                           
                                                                        
           IF NOT INFILE-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP661 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE.         **'           
               DISPLAY '**  FILE STATUS = ' WS-INFILE-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE                                    
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP661 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
           INITIALIZE INFILE-REC                                        
                      PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-TEST-METERS                                               
      ******************************************************************        
      *                                                                         
       2000-PROCESS-TEST-METERS.                                        
      *                                                                         
           PERFORM 7500-READ-INFILE                 THRU 7500-EXIT.     
                                                                        
           IF E-FMT12-COMPANY-NO EQUAL X'00' OR X'FF' OR '00' OR '  '   
             MOVE '01'                    TO WS-COMPANY-NO              
           ELSE                                                         
             MOVE E-FMT12-COMPANY-NO      TO WS-COMPANY-NO              
           END-IF.                                                      
                                                                        
           DISPLAY 'WS-COMPANY-NO: ' WS-COMPANY-NO                      
                                                                        
           PERFORM 7000-GET-COMPANY-NAME            THRU 7000-EXIT.     
                                                                        
           PERFORM 2100-PROCESS-REPORT1             THRU 2100-EXIT      
              UNTIL END-OF-REC1.                                        
                                                                        
           MOVE WS-LOCAL-COUNT            TO FTR1-LN1-COUNT             
           PERFORM 8200-WRITE-FTR-OUTFILE           THRU 8200-EXIT.     
           PERFORM 8300-WRITE-FTR-OUTFILE           THRU 8300-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 2100-PROCESS-REPORT1.                                                  
      ******************************************************************        
      *                                                                         
       2100-PROCESS-REPORT1.                                            
      *                                                                         
           MOVE E-FMT12-METER-NO          TO WS-METER-NO                
           MOVE E-FMT12-LOCAL-OFFICE      TO WS-LOCAL-OFFICE            
                                                                        
           PERFORM 7100-GET-SERIAL-NUMBER           THRU 7100-EXIT.     
                                                                        
           MOVE E-FMT12-ACCT-NO           TO WS-FMT12-ACCT-NO           
           MOVE E-FMT12-ACCOUNT1          TO WS-ACCOUNT1                
           MOVE E-FMT12-ACCOUNT4A         TO WS-ACCOUNT4A               
           MOVE E-FMT12-ACCOUNT4B         TO WS-ACCOUNT4B               
           MOVE E-FMT12-ACCOUNT4C         TO WS-ACCOUNT4C               
                                                                        
           MOVE E-FMT12-DATE-LAST-TESTED  TO WS-E-DT-LAST-TESTED        
           MOVE E-FMT12-LAST-MM           TO WS-L-DATE-MM               
           MOVE E-FMT12-LAST-DD           TO WS-L-DATE-DD               
           MOVE E-FMT12-LAST-YYYY         TO WS-L-DATE-YYYY             
                                                                        
           MOVE E-FMT12-SCHED-TEST-DATE   TO WS-SCHED-TEST-DT           
           MOVE E-FMT12-SCHED-MM          TO WS-S-DATE-MM               
           MOVE E-FMT12-SCHED-YYYY        TO WS-S-DATE-YYYY             
           MOVE E-FMT12-CONSTANT          TO WS-CONSTANT                
                                                                        
           IF E-FMT12-TEST-SCH-CD NOT = 'E'                             
              MOVE SPACES                 TO WS-NEXT-TEST-DATE          
           ELSE                                                         
              MOVE '/'                    TO WS-N-DATE-FF               
              COMPUTE WS-N-DATE-MM = E-FMT12-SCHED-MM + 6               
                                                                        
              IF WS-N-DATE-MM <= 12                                     
                 MOVE E-FMT12-SCHED-YYYY  TO WS-N-DATE-YYYY             
              ELSE                                                      
                 COMPUTE WS-N-DATE-MM = WS-N-DATE-MM - 12               
                 COMPUTE WS-N-DATE-YYYY = E-FMT12-SCHED-YYYY + 1        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF E-FMT12-LOCAL-OFFICE NOT = WS-PREV-LOCAL-OFFICE           
              PERFORM 7200-GET-LOCAL-OFFICE         THRU 7200-EXIT      
              IF WS-FIRST NOT = 'Y'                                     
               MOVE WS-LOCAL-COUNT        TO FTR1-LN1-COUNT             
               PERFORM 8200-WRITE-FTR-OUTFILE       THRU 8200-EXIT      
              END-IF                                                    
                                                                        
              ADD +1                      TO WS-PAGE-NUM                
              MOVE 0                      TO WS-LOCAL-COUNT             
              MOVE 'N'                    TO WS-FIRST                   
              MOVE WS-COMPANY-NAME        TO HDR1-LN1-COMPANY-NAME      
              MOVE WS-PAGE-NUM            TO HDR1-LN1-PAGE-NO           
              MOVE WS-RUN-DATE            TO HDR1-LN2-DATE              
              MOVE WS-RUN-DATE            TO HDR1-LN2-DATE1             
              MOVE WS-RUN-DATE            TO HDR1-LN3-DATE              
              MOVE WS-RUN-TIME            TO HDR1-LN3-TIME              
              MOVE E-FMT12-LOCAL-OFFICE   TO HDR1-LN4-LOCAL-OFC         
              MOVE WS-LOCAL-OFFICE-DESC   TO HDR1-LN4-LOCAL-DESC        
                                                                        
              PERFORM 8000-WRITE-HEADER             THRU 8000-EXIT      
           END-IF                                                       
                                                                        
           PERFORM 2200-POPULATE-OUTFILE            THRU 2200-EXIT.     
                                                                        
           PERFORM 8100-WRITE-OUTFILE               THRU 8100-EXIT.     
                                                                        
           MOVE E-FMT12-LOCAL-OFFICE      TO WS-PREV-LOCAL-OFFICE       
                                                                        
           PERFORM 7500-READ-INFILE                 THRU 7500-EXIT.     
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2200-POPULATE-OUTFILE.                                                 
      ******************************************************************        
      *                                                                         
       2200-POPULATE-OUTFILE.                                           
      *                                                                         
           MOVE E-FMT12-READ-ROUTE        TO OUT-READ-ROUTE             
           MOVE WS-ACCT                   TO OUT-ACCT                   
           MOVE E-FMT12-METER-NO          TO OUT-METER-NO               
           MOVE WS-SERIAL-NO              TO OUT-SERIAL-NO              
           MOVE E-FMT12-RATE              TO OUT-RATE                   
           MOVE WS-CONSTANT               TO OUT-CONSTANT               
           MOVE E-FMT12-METER-SIZE-ID     TO OUT-METER-SIZE-ID          
           MOVE WS-DATE-LAST-TESTED       TO OUT-DATE-LAST-TESTED       
           MOVE E-FMT12-TEST-SCH-CD       TO OUT-TEST-SCH-CD            
           MOVE E-FMT12-TEST-FREQ-MONTHS  TO OUT-TEST-FREQ-MONTHS       
           MOVE WS-SCHED-TEST-DATE        TO OUT-SCHED-TEST-DATE        
           MOVE E-FMT12-NAME              TO OUT-NAME                   
           MOVE E-FMT12-SERV-ADDR         TO OUT-SERV-ADDR              
           MOVE E-FMT12-ADDR-CITY-STATE-ZIP TO OUT-ADDR                 
           MOVE WS-NEXT-TEST-DATE         TO OUT-NEXT-TEST-DATE.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7000-GET-COMPANY-NAMEE.                                                
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP661 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-GET-SERIAL-NUMBER.                                                
      ******************************************************************        
      *                                                                         
       7100-GET-SERIAL-NUMBER.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  SERIAL_NO                                         
                INTO :WS-SERIAL-NO                                      
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE DEVICE_NO = :WS-METER-NO                           
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  SERIAL_NO                                                 
MFA-TR*         INTO :WS-SERIAL-NO                                              
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE DEVICE_NO = :WS-METER-NO                                   
MFA-TR*          AND COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP661 ABORT *****'                   
              DISPLAY '**  7100-GET-SERIAL-NUMBER **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-GET-LOCAL-OFFICE.                                                 
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  LOCAL_OFFICE_DESC                                 
                INTO :WS-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE LOCAL_OFFICE = :WS-LOCAL-OFFICE                    
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  LOCAL_OFFICE_DESC                                         
MFA-TR*         INTO :WS-LOCAL-OFFICE-DESC                                      
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE LOCAL_OFFICE = :WS-LOCAL-OFFICE                            
MFA-TR*          AND COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP661 ABORT *****'                   
              DISPLAY '**  7200-GET-LOCAL-OFFICE  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7500-READ-INFILE                                                       
      ******************************************************************        
       7500-READ-INFILE.                                                
      *                                                                         
           READ INFILE.                                                 
                                                                        
           IF INFILE-SUCCESSFUL   OR  END-OF-REC1                       
              MOVE INFILE-REC             TO FIOMT12                    
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP661 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE FILE ****'           
               DISPLAY '** PARAGRAPH -  ' WS-ACTIVE-PARAGRAPH           
               DISPLAY '** FILE STATUS IS ' WS-INFILE-STATUS            
               DISPLAY '** PROCESSING TERMINATED  **'                   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **   8000-WRITE-HEADER.                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-WRITE-HEADER.                                               
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN1.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN2.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN3.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN4.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN6.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN7.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN8.              
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8100-WRITE-OUTFILE.                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE.                                              
      *                                                                 08230000
           ADD +1 TO WS-LOCAL-COUNT                                     
           WRITE PRT331-RECORD FROM WS-OUTFILE-LN1.                     
           WRITE PRT331-RECORD FROM WS-OUTFILE-LN2.                     
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN5.              
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8200-WRITE-FTR-OUTFILE.                                  **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-FTR-OUTFILE.                                          
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP661-FTR1-REC-LN1.              
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8300-WRITE-FTR-OUTFILE.                                  **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-FTR-OUTFILE.                                          
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP661-HDR1-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP661-FTR1-REC-LN2.              
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
