       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP659.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     APR 13, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***PRINTS A REPORT OF                                          ***        
      ***                                                            ***        
      ***   PRINTS A DETAIL REPORT OF METERS SAMPLE TESTED           ***        
      ***   BREAKING ON EACH METER TYPE GROUP.                       ***        
      ***                                                            ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT056***  04/13/2016    VV7M728     GMC659 CONVERT EZT TO COBOL     ***        
      ***                                                            ***        
A05460***  20 JUL 2016   RF10596     FIX HEADERS                     ***        
      ***                                                            ***        
A05460***  22 JUL 2016   RF10596     PUT TOTAL RECORDS ON REPORT     ***        
      ***                                                            ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
      ****************************************************************          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT INFILE                                                
               ASSIGN TO UT-S-INFILE                                    
           FILE STATUS IS WS-INFILE-STATUS.                             
      *                                                                         
       COPY CSSPT331.                                                           
      *                                                                         
      ****************************************************************          
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  INFILE                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE-REC                      PIC X(98) VALUE SPACES.       
      *                                                                         
       COPY CFDPT331.                                                           
      *                                                                         
      ****************************************************************          
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP659'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOMT16.                                                            
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_COMPANY, C7                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_HIST                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRTST                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
       01 WS-MISC.                                                      
      *                                                                         
A05460     05 WS-TEN                    PIC XX    VALUE '10'.           
           05 TOTAL-IN                  PIC 9(07) VALUE ZEROES.         
           05 WS-TOTAL-RECORDS          PIC 9(07) VALUE ZEROES.         
           05 WS-OPEN                   PIC 9(3)V999 VALUE ZEROES.      
           05 WS-CHECK                  PIC 9(3)V999 VALUE ZEROES.      
           05 WS-TEST-YEAR              PIC S9(4) USAGE COMP.           
           05 WS-DATE-TEST              PIC X(08) VALUE SPACES.         
           05 WS-DATE-TEST-MM           PIC Z9.                         
           05 WS-DATE-TEST-DD           PIC X(02) VALUE SPACES.         
           05 WS-DATE-TEST-YY           PIC X(02) VALUE SPACES.         
           05 WS-FIRST-REC-FLAG         PIC X(01) VALUE 'Y'.            
           05 WS-COMPANY-NO             PIC X(02) VALUE SPACES.         
           05 WS-COMPANY-NAME           PIC X(26) VALUE SPACES.         
           05 WS-PREV-GRP-CD            PIC X(02) VALUE SPACES.         
           05 WS-CURR-GRP-CD            PIC X(02) VALUE SPACES.         
           05 WS-PAGE-NUM               PIC 9(06) VALUE ZEROES.         
      *                                                                         
       01 WS-RP659-HDR1-REC-LN1.                                        
           05 HDR1-LN1-NAME             PIC X(09) VALUE 'GMC659-01'.    
           05 FILLER                    PIC X(37) VALUE SPACES.         
           05 HDR1-LN1-COMPANY-NAME     PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(48) VALUE SPACES.         
           05 HDR1-LN1-PAGE             PIC X(05) VALUE 'PAGE '.        
           05 HDR1-LN1-PAGE-NO          PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
      *                                                                         
       01 WS-RP659-HDR1-REC-LN2.                                        
           05 HDR1-LN2-DATE             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(40) VALUE SPACES.         
           05 HDR1-LN2-NAME             PIC X(27) VALUE                 
                                  'SAMPLE GAS METER TESTS FOR '.        
A05460     05 HDR1-LN2-YEAR             PIC X(4)  VALUE SPACES.         
           05 FILLER                    PIC X(30) VALUE SPACES.         
           05 HDR1-LN2-NAME2            PIC X(09) VALUE 'RUN DATE:'.    
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN2-DATE1            PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP659-HDR1-REC-LN3.                                        
           05 FILLER                    PIC X(111) VALUE SPACES.        
           05 HDR1-LN3-NAME             PIC X(09) VALUE 'RUN-TIME:'.    
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR1-LN3-TIME             PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP659-HDR1-REC-LN4.                                        
           05 HDR1-LN4-NAME             PIC X(12) VALUE 'GROUP CODE :'. 
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN4-GRP-CD           PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN4-SAMPLE1          PIC X(25) VALUE SPACES.         
      *                                                                         
       01 WS-RP659-HDR1-REC-LN5.                                        
           05 HDR1-LN5-NAME             PIC X(12) VALUE 'POPULATION :'. 
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN5-POPULATION       PIC Z,ZZZ,ZZZ,ZZ9.              
      *                                                                         
       01 WS-RP659-HDR1-REC-LN6.                                        
           05 HDR1-LN6-NAME             PIC X(12) VALUE 'SAMPLE SIZE:'. 
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN6-SAMPLE           PIC Z,ZZZ,ZZZ,ZZ9.              
      *                                                                         
       01 WS-RP659-HDR1-REC-LN7.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP659-HDR1-REC-LN8.                                        
           05 HDR1-LN8-TXT1             PIC X(35) VALUE                 
                           '  METER      TEST                 '.        
           05 HDR1-LN8-TXT2             PIC X(16) VALUE                 
                           'PROVER     METER'.                          
           05 FILLER                    PIC X(55) VALUE SPACES.         
           05 HDR1-LN8-TXT3             PIC X(27) VALUE                 
                           'AS FOUND       AS FOUND    '.               
      *                                                                         
       01 WS-RP659-HDR1-REC-LN9.                                        
           05 HDR1-LN9-TXT1             PIC X(51) VALUE                 
                  ' NUMBER      DATE       TESTER      ID        TYPE'. 
           05 FILLER                    PIC X(20) VALUE SPACES.         
           05 HDR1-LN9-TXT2             PIC X(18) VALUE                 
                                                     'TESTER  COMMENTS'.
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR1-LN9-TXT3             PIC X(25) VALUE                 
                                            'OPEN           CHECK     '.
      *                                                                         
       01  WS-OUTFILE-DATA.                                             
           05 OUT-DEVICE-NO             PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-DATE-TEST             PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 OUT-EQ-TESTER-ID          PIC X(05) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 OUT-TEST-PROVER-ID        PIC X(06) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 OUT-METER-SIZE-ID         PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-REPAIR-DESC           PIC X(44) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-OPEN                  PIC ZZ9.999.                    
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 OUT-CHECK                 PIC ZZ9.999.                    
      *                                                                         
A05460 01 WS-INPUT-TOTAL9              PIC 9(7) VALUE ZEROS.            
      *                                                                         
A05460 01 WS-TOTAL-RECORD.                                              
A05460     05 FILLER                   PIC X(13) VALUE 'INPUT TOTAL ='. 
A05460     05 FILLER                   PIC X     VALUE SPACES.          
A05460     05 WS-INPUT-TOTAL           PIC Z,ZZZ,ZZ9.                   
A05460     05 FILLER                   PIC X(10) VALUE SPACES.          
A05460     05 FILLER                   PIC X(13) VALUE 'COUNT TOTAL ='. 
A05460     05 FILLER                   PIC X     VALUE SPACES.          
A05460     05 WS-COUNT-TOTAL           PIC Z,ZZZ,ZZ9.                   
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-INFILE-STATUS         PIC X(02) VALUE '00'.           
               88 INFILE-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC1                     VALUE '10'.           
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-TEST-METERS         THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
      *    MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.                  
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
      *    MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE                   
      *                                      HDR-LAST-TEST-SEL-DT.              
                                                                        
      *                                                                         
           OPEN INPUT INFILE.                                           
                                                                        
           IF NOT INFILE-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP659 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE.         **'           
               DISPLAY '**  FILE STATUS = ' WS-INFILE-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE                                    
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP659 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           INITIALIZE INFILE-REC                                        
                      PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-TEST-METERS                                               
      ******************************************************************        
      *                                                                         
       2000-PROCESS-TEST-METERS.                                        
      *                                                                         
           PERFORM 7500-READ-INFILE                 THRU 7500-EXIT.     
                                                                        
           IF E-FMT16-COMPANY-NO EQUAL X'00' OR X'FF' OR '00' OR '  '   
             MOVE '01'                    TO WS-COMPANY-NO              
           ELSE                                                         
             MOVE E-FMT16-COMPANY-NO      TO WS-COMPANY-NO              
           END-IF.                                                      
                                                                        
           DISPLAY 'WS-COMPANY-NO: ' WS-COMPANY-NO                      
                                                                        
           PERFORM 7000-GET-COMPANY-NAME THRU 7000-EXIT.                
                                                                        
A05460     IF E-FMT16-END-RECORD-ID = SPACES                            
A05460        MOVE E-FMT16-NBR-TEST-RECS TO WS-INPUT-TOTAL9             
A05460        MOVE WS-INPUT-TOTAL9 TO WS-INPUT-TOTAL                    
              WRITE PRT331-RECORD FROM WS-TOTAL-RECORD                  
A05460     ELSE                                                         
A05460        COMPUTE TOTAL-IN = TOTAL-IN + 1                           
           END-IF.                                                      
                                                                        
           PERFORM 2100-PROCESS-REPORT1 THRU 2100-EXIT                  
              UNTIL END-OF-REC1.                                        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 2100-PROCESS-REPORT1.                                                  
      ******************************************************************        
      *                                                                         
       2100-PROCESS-REPORT1.                                            
      *                                                                         
           MOVE E-FMT16-IN-OPEN-RATE      TO WS-OPEN.                   
           MOVE E-FMT16-IN-CHECK-RATE     TO WS-CHECK.                  
           MOVE E-FMT16-TEST-YEAR         TO WS-TEST-YEAR.              
A05460     MOVE WS-TEST-YEAR TO HDR1-LN2-YEAR.                          
           MOVE E-FMT16-DATE-TEST-YY      TO WS-DATE-TEST-YY.           
           MOVE E-FMT16-DATE-TEST-MM      TO WS-DATE-TEST-MM.           
           MOVE E-FMT16-DATE-TEST-DD      TO WS-DATE-TEST-DD.           
           MOVE E-FMT16-GRP-CD            TO WS-CURR-GRP-CD.            
                                                                        
           MOVE WS-DATE-TEST-MM           TO WS-DATE-TEST(1:2).         
           MOVE '/'                       TO WS-DATE-TEST(3:1).         
           MOVE WS-DATE-TEST-DD           TO WS-DATE-TEST(4:2).         
           MOVE '/'                       TO WS-DATE-TEST(6:1).         
           MOVE WS-DATE-TEST-YY           TO WS-DATE-TEST(7:2).         
      *                                                                         
           PERFORM 7100-GET-TEST-QTY                THRU 7100-EXIT.     
                                                                        
           IF E-FMT16-GRP-CD NOT = WS-PREV-GRP-CD                       
              ADD +1                      TO WS-PAGE-NUM                
              MOVE WS-COMPANY-NAME        TO HDR1-LN1-COMPANY-NAME      
              MOVE WS-PAGE-NUM            TO HDR1-LN1-PAGE-NO           
              MOVE WS-RUN-DATE            TO HDR1-LN2-DATE              
              MOVE WS-RUN-DATE            TO HDR1-LN2-DATE1             
              MOVE WS-RUN-TIME            TO HDR1-LN3-TIME              
              MOVE E-FMT16-GRP-CD         TO HDR1-LN4-GRP-CD            
              MOVE MQ-INSTALLED-QT        TO HDR1-LN5-POPULATION        
              MOVE MQ-TESTED-QT           TO HDR1-LN6-SAMPLE            
              MOVE MQ-MTR-TEST-GRP-TX     TO HDR1-LN4-SAMPLE1           
              PERFORM 8000-WRITE-HEADER             THRU 8000-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 2200-POPULATE-OUTFILE            THRU 2200-EXIT.     
                                                                        
           PERFORM 8100-WRITE-OUTFILE               THRU 8100-EXIT.     
                                                                        
           MOVE E-FMT16-GRP-CD            TO WS-PREV-GRP-CD.            
                                                                        
           PERFORM 7500-READ-INFILE                 THRU 7500-EXIT.     
      *                                                                         
A05460     IF E-FMT16-END-RECORD-ID = SPACES                            
A05460        MOVE E-FMT16-NBR-TEST-RECS TO WS-INPUT-TOTAL9             
A05460        MOVE WS-INPUT-TOTAL9 TO WS-INPUT-TOTAL                    
A05460        MOVE TOTAL-IN        TO WS-COUNT-TOTAL                    
A05460        WRITE PRT331-RECORD FROM WS-TOTAL-RECORD                  
A05460        MOVE WS-TEN TO WS-INFILE-STATUS                           
A05460     ELSE                                                         
A05460        COMPUTE TOTAL-IN = TOTAL-IN + 1                           
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2200-POPULATE-OUTFILE.                                                 
      ******************************************************************        
      *                                                                         
       2200-POPULATE-OUTFILE.                                           
      *                                                                         
           MOVE E-FMT16-DEVICE-NO         TO OUT-DEVICE-NO              
           MOVE WS-DATE-TEST              TO OUT-DATE-TEST              
           MOVE E-FMT16-EQ-TESTER-ID      TO OUT-EQ-TESTER-ID           
           MOVE E-FMT16-TEST-PROVER-ID    TO OUT-TEST-PROVER-ID         
           MOVE E-FMT16-METER-SIZE-ID     TO OUT-METER-SIZE-ID          
           MOVE E-FMT16-REPAIR-DESC       TO OUT-REPAIR-DESC            
           MOVE WS-OPEN                   TO OUT-OPEN                   
           MOVE WS-CHECK                  TO OUT-CHECK.                 
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7000-GET-COMPANY-NAMEE.                                                
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP659 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-GET-TEST-QTY.                                                     
      ******************************************************************        
      *                                                                         
       7100-GET-TEST-QTY.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT MQ.TESTED_QT                                       
                    ,MQ.INSTALLED_QT                                    
                    ,MQ.MTR_TEST_GRP_TX                                 
                INTO :MQ-TESTED-QT                                      
                    ,:MQ-INSTALLED-QT                                   
                    ,:MQ-MTR-TEST-GRP-TX                                
                FROM CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)                 
               WHERE MQ.MTR_TEST_GRP_CD = :WS-CURR-GRP-CD               
                 AND MQ.TEST_YEAR       = :WS-TEST-YEAR                 
                 AND MQ.TEST_SCHED_CD   = 'R'                           
                 AND MQ.CODE_UTIL_TYPE  = 'G'                           
                 AND MQ.COMPANY_NO      = :WS-COMPANY-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MQ.TESTED_QT                                               
MFA-TR*             ,MQ.INSTALLED_QT                                            
MFA-TR*             ,MQ.MTR_TEST_GRP_TX                                         
MFA-TR*         INTO :MQ-TESTED-QT                                              
MFA-TR*             ,:MQ-INSTALLED-QT                                           
MFA-TR*             ,:MQ-MTR-TEST-GRP-TX                                        
MFA-TR*         FROM CSS_MTR_TEST_HIST MQ                                       
MFA-TR*        WHERE MQ.MTR_TEST_GRP_CD = :WS-CURR-GRP-CD                       
MFA-TR*          AND MQ.TEST_YEAR       = :WS-TEST-YEAR                         
MFA-TR*          AND MQ.TEST_SCHED_CD   = 'R'                                   
MFA-TR*          AND MQ.CODE_UTIL_TYPE  = 'G'                                   
MFA-TR*          AND MQ.COMPANY_NO      = :WS-COMPANY-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP659 ABORT *****'                   
              DISPLAY '**  7200-GET-LOCAL-OFFICE  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  COMPANY-NUMBER= ' WS-COMPANY-NO              
              DISPLAY '**  GROUP CODE    = ' WS-CURR-GRP-CD             
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7500-READ-INFILE                                                       
      ******************************************************************        
       7500-READ-INFILE.                                                
      *                                                                         
           READ INFILE.                                                 
      *                                                                         
A05460     IF INFILE-SUCCESSFUL                                         
              MOVE INFILE-REC TO FIOMT16                                
A05460     ELSE                                                         
              IF END-OF-REC1                                            
A05460           CONTINUE                                               
A05460        ELSE                                                      
                 DISPLAY '************ PCSRP659 ABORT *********'        
                 DISPLAY '** ERROR IN READING INFILE FILE ****'         
                 DISPLAY '** PARAGRAPH -  ' WS-ACTIVE-PARAGRAPH         
                 DISPLAY '** FILE STATUS IS ' WS-INFILE-STATUS          
                 DISPLAY '** PROCESSING TERMINATED  **'                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
A05460        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8000-WRITE-HEADER.                                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8000-WRITE-HEADER.                                               
      *                                                                         
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN1.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN2.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN3.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN4.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN6.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN7.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN8.              
           WRITE PRT331-RECORD FROM WS-RP659-HDR1-REC-LN9.              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8100-WRITE-OUTFILE.                                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-WRITE-OUTFILE.                                              
      *                                                                         
           WRITE PRT331-RECORD FROM WS-OUTFILE-DATA.                    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-CLOSE-OUTFILE                                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-CLOSE-OUTFILE.                                              
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
