       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP657.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     FEB 17, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***PRINTS A DETAIL REPORT OF ELECTRIC METERS SAMPLE TESTED     ***        
      ***BREAKING ON EACH METER TYPE GROUP.                          ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT050***  03/10/2016    VV7M728     ELC657 CONVERT EZT TO COBOL     ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT06.                                                            
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      *                                                                         
       COPY CFDMT06.                                                            
       COPY FIOMT06.                                                            
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP657'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ELEC_TST_GROUP                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBELGRP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_COMPANY                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ELEC_MTR_SPEC                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEMTRSP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTR_TEST_HIST                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRTST                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP657'.     
      *                                                                         
       01 WS-MISC.                                                      
           05 TOTAL-IN                  PIC 9(04) VALUE ZEROES.         
           05 WS-TOTAL-RECORDS          PIC 9(05) VALUE ZEROES.         
           05 SUB                       PIC 9(03) VALUE ZEROES.         
           05 WS-GRP-CD                 PIC X(02) VALUE SPACES.         
           05 WS-GRP-CD-HOLD            PIC X(02) VALUE SPACES.         
           05 WS-SPEC-CD                PIC X(03) VALUE 'UNK'.          
COB305     05 WS-FULL        PIC S9(3)V999 COMP-3 VALUE 0.           
COB305     05 WS-POWER        PIC S9(3)V999 COMP-3 VALUE 0.           
COB305     05 WS-LIGHT        PIC S9(3)V999 COMP-3 VALUE 0.           
           05 WS-TESTED-QTY             PIC S9(9) USAGE COMP.           
           05 WS-INSTALLED-QTY          PIC S9(9) USAGE COMP.           
           05 WS-GRP-DESC               PIC X(25) VALUE SPACES.         
           05 WS-TEST-YEAR              PIC S9(4) USAGE COMP.           
           05 WS-FIND-ERROR             PIC X(30) VALUE SPACES.         
           05 WS-FIRST-REC-FLG          PIC X(01) VALUE 'Y'.            
           05 WS-COMPANY-NO             PIC X(02) VALUE SPACES.         
           05 WS-VALUE-DIFFER           PIC X(01) VALUE 'N'.            
           05 WS-FIRST-VALUE            PIC X(01) VALUE 'Y'.            
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
      *    05 WS-COMPANY-NAME           PIC X(26) VALUE SPACES.                 
      *                                                                         
       01  WS-SWITCH.                                                   
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
           05  WS-FMT06-STATUS          PIC X(02) VALUE '00'.           
               88 FBW006-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
       01 WS-DATE-TEST.                                                 
           05 WS-DATE-TEST-MM           PIC X(02) VALUE SPACES.         
           05 WS-FILLER1                PIC X(01) VALUE SPACES.         
           05 WS-DATE-TEST-DD           PIC X(02) VALUE SPACES.         
           05 WS-FILLER2                PIC X(01) VALUE SPACES.         
           05 WS-DATE-TEST-YY           PIC X(02) VALUE SPACES.         
      *                                                                         
       01 WS-TITLE-LINES.                                               
           05 WS-TITLE-LINE OCCURS 07 TIMES PIC X(68) VALUE SPACES.     
      *                                                                         
       01 WS-CLASS-LINE.                                                
           05 WS-CLASS                  PIC X(02) VALUE SPACES.         
           05 WS-FILLER01               PIC X(08) VALUE SPACES.         
           05 WS-SPEC-CD2               PIC X(03) VALUE SPACES.         
           05 WS-FILLER02               PIC X(01) VALUE SPACES.         
           05 WS-SPEC-DESC              PIC X(25) VALUE SPACES.         
           05 WS-FILLER03               PIC X(05) VALUE SPACES.         
           05 WS-BEG-DT                 PIC X(10) VALUE SPACES.         
           05 WS-FILLER04               PIC X(04) VALUE SPACES.         
           05 WS-END-DT                 PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN1.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN1-NAME              PIC X(09) VALUE 'ELC657-01'.    
           05 FILLER                    PIC X(37) VALUE SPACES.         
           05 WS-COMPANY-NAME           PIC X(26) VALUE SPACES.         
           05 FILLER                    PIC X(48) VALUE SPACES.         
           05 HDR-LN1-PAGE-NUM          PIC X(05) VALUE 'PAGE '.        
           05 HDR-LN1-PAGE-NO           PIC ZZZZZ9.                     
      *                                                                         
       01 WS-RP657-HDR-REC-LN2.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LAST-TEST-SEL-DT      PIC X(10).                      
           05 FILLER                    PIC X(31) VALUE SPACES.         
           05 HDR-LN2-DT2               PIC X(32)                       
              VALUE 'SAMPLE ELECTRIC METER TESTS FOR '.                 
           05 HDR-LN2-YR                PIC 9(04) VALUE ZEROES.         
           05 FILLER                    PIC X(34) VALUE SPACES.         
           05 HDR-LN2-DT4               PIC X(10) VALUE 'RUN DATE: '.   
           05 HDR-LN2-SYS-DATE          PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN3.                                         
           05 FILLER                    PIC X(80) VALUE SPACES.         
           05 FILLER                    PIC X(32) VALUE SPACES.         
           05 HDR-LN3-DT1               PIC X(12) VALUE 'RUN TIME:   '. 
           05 HDR-LN3-SYS-TIME          PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN4.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN4-DT1               PIC X(13)                       
                 VALUE 'GROUP CODE : '.                                 
           05 HDR-FMT06-GRP-CD          PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-GRP-DESC              PIC X(25) VALUE SPACES.         
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 HDR-LN4-POPULATION        PIC X(13) VALUE 'POPULATION : '.
           05 HDR-INSTALLED-QTY         PIC ZZZZZZZZ9.                  
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-SAMPLE-SIZE           PIC X(14)                       
                 VALUE 'SAMPLE SIZE : '.                                
           05 HDR-TESTED-QTY            PIC ZZZZZZZZ9.                  
      *                                                                         
       01 WS-RP657-HDR-REC-LN5.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN5-DT1               PIC X(08) VALUE 'ELECTRIC'.     
           05 FILLER                    PIC X(40) VALUE SPACES.         
           05 HDR-LN5-DT2               PIC X(18)                       
                 VALUE 'BEGIN          END'.                            
           05 FILLER                    PIC X(38) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN6.                                         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN6-DT1               PIC X(25)                       
                 VALUE 'METER      ELECTRIC METER'.                     
           05 FILLER                    PIC X(21) VALUE SPACES.         
           05 HDR-LN6-DT2               PIC X(22)                       
                 VALUE 'PURCHASE      PURCHASE'.                        
           05 FILLER                    PIC X(32) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN7.                                         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN7-DT1               PIC X(25)                       
                 VALUE 'CLASS      SPECIFICATION '.                     
           05 FILLER                    PIC X(23) VALUE SPACES.         
           05 HDR-LN7-DT2               PIC X(18)                       
                 VALUE 'DATE          DATE'.                            
           05 FILLER                    PIC X(23) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN01.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE01          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN02.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE02          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN03.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE03          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN04.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE04          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN05.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE05          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN06.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE06          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN07.                                        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-TITLE-LINE07          PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP657-HDR-REC-LN8.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN8-DT1               PIC X(16)                       
                 VALUE '  METER     TEST'.                              
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR-LN8-DT2               PIC X(18)                       
                 VALUE 'METER METER  METER'.                            
           05 FILLER                    PIC X(52) VALUE SPACES.         
           05 HDR-LN8-DT3               PIC X(28)                       
                 VALUE '-------  AS FOUND  ------- '.                   
      *                                                                         
       01 WS-RP657-HDR-REC-LN9.                                         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN9-DT1               PIC X(33)                       
                 VALUE 'NUMBER     DATE   TESTER STANDARD'.             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN9-DT2               PIC X(18)                       
                 VALUE 'CLASS SPEC    TYPE'.                            
           05 FILLER                    PIC X(20) VALUE SPACES.         
           05 HDR-LN9-DT3               PIC X(16)                       
                 VALUE 'TESTER  COMMENTS'.                              
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR-LN9-DT4               PIC X(25)                       
                 VALUE 'FULL    LIGHT    P.F.F. '.                      
      *                                                                         
       01 WS-RP657-FTR-REC-LN1.                                         
           05 FILLER                    PIC X(60) VALUE SPACES.         
           05 FTR-LN1-DT1               PIC X(21)                       
                VALUE '*** END OF REPORT ***'.                          
      *                                                                         
       01 WS-RP657-HDR-REC-LNX.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01  WS-RP657-OUT-REC.                                            
           05 FILLER                      PIC X(01) VALUE SPACES.       
           05 OUT-FMT06-DEVICE-NO         PIC X(09) VALUE SPACES.       
           05 FILLER                      PIC X(01) VALUE SPACES.       
           05 OUT-DATE-TEST               PIC X(08) VALUE SPACES.       
           05 FILLER                      PIC X(01) VALUE SPACES.       
           05 OUT-FMT06-EQ-TESTER-ID      PIC X(05) VALUE SPACES.       
           05 FILLER                      PIC X(03) VALUE SPACES.       
           05 OUT-FMT06-TEST-BENCH-ID     PIC X(06) VALUE SPACES.       
           05 FILLER                      PIC X(03) VALUE SPACES.       
           05 OUT-FMT06-ELEC-MTR-CLASS-CD PIC X(02) VALUE SPACES.       
           05 FILLER                      PIC X(04) VALUE SPACES.       
           05 OUT-FMT06-ELEC-MTR-SPEC-CD  PIC X(03) VALUE SPACES.       
           05 FILLER                      PIC X(02) VALUE SPACES.       
           05 OUT-FMT06-METER-SIZE-ID     PIC X(08) VALUE SPACES.       
           05 FILLER                      PIC X(01) VALUE SPACES.       
           05 OUT-FMT06-REPAIR-DESC       PIC X(44) VALUE SPACES.       
           05 FILLER                      PIC X(07) VALUE SPACES.       
           05 OUT-FULL                    PIC Z99.999.                  
           05 FILLER                      PIC X(02) VALUE SPACES.       
           05 OUT-LIGHT                   PIC Z99.999.                  
           05 FILLER                      PIC X(02) VALUE SPACES.       
           05 OUT-POWER                   PIC Z99.999.                  
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-LOCAL-COUNT           PIC 9(04) VALUE ZEROS.          
           05  WS-TOTAL-COUNT           PIC 9(06) VALUE ZEROS.          
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
      ***************************************************************           
      *CURSOR FOR RETRIEVING ELECTRIC GROUPS                        *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE ELEC_GRP CURSOR WITH HOLD FOR                      
                SELECT TG.ELEC_MTR_CLASS_CD                             
                      ,TG.ELEC_MTR_SPEC_CD                              
                      ,TG.BEGIN_PURCHASE_DT                             
                      ,TG.END_PURCHASE_DT                               
                  FROM CSS_ELEC_TST_GROUP TG WITH(READUNCOMMITTED)              
                  WHERE TG.MTR_TEST_GRP_CD = :WS-GRP-CD                 
                    AND TG.CODE_UTIL_TYPE  = 'E'                        
                    AND TG.COMPANY_NO      = :WS-COMPANY-NO             
                  FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE ELEC_GRP CURSOR WITH HOLD FOR                              
MFA-TR*         SELECT TG.ELEC_MTR_CLASS_CD                                     
MFA-TR*               ,TG.ELEC_MTR_SPEC_CD                                      
MFA-TR*               ,TG.BEGIN_PURCHASE_DT                                     
MFA-TR*               ,TG.END_PURCHASE_DT                                       
MFA-TR*           FROM CSS_ELEC_TST_GROUP TG                                    
MFA-TR*           WHERE TG.MTR_TEST_GRP_CD = :WS-GRP-CD                         
MFA-TR*             AND TG.CODE_UTIL_TYPE  = 'E'                                
MFA-TR*             AND TG.COMPANY_NO      = :WS-COMPANY-NO                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.          
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE           
                                             HDR-LAST-TEST-SEL-DT.      
      *                                                                         
           OPEN INPUT  FCSMT06-FILE.                                    
                                                                        
           IF NOT FBW006-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSBW06-FILE.    **'          
               DISPLAY '**  FILE STATUS = ' WS-FMT06-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
           INITIALIZE FIOMT06                                           
                      PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 7200-READ-FCSBW06-FILE        THRU 7200-EXIT         
           PERFORM 2300-GET-COMP-NAME            THRU 2300-EXIT         
           PERFORM 7300-GET-COMPANY-NAME         THRU 7300-EXIT         
                                                                        
           PERFORM 2200-PROCESS-DTLS             THRU 2200-EXIT         
              UNTIL END-OF-REC.                                         
           PERFORM 8300-WRITE-OUTFILE-LAST-FTR   THRU 8300-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2200-PROCESS-DTLS.                                           *          
      ****************************************************************          
      *                                                                         
       2200-PROCESS-DTLS.                                               
                                                                        
           MOVE E-FMT06-GRP-CD            TO WS-GRP-CD                  
                                                                        
           PERFORM 7400-OPEN-ELEC-GRP            THRU 7400-EXIT         
                                                                        
           IF E-FMT06-END-RECORD-ID = SPACES                            
            MOVE E-FMT06-NBR-TEST-RECS    TO WS-TOTAL-RECORDS           
           END-IF.                                                      
                                                                        
           IF WS-GRP-CD-HOLD NOT EQUAL E-FMT06-GRP-CD                   
            MOVE SPACES                   TO WS-CLASS-LINE              
            MOVE SPACES                   TO WS-TITLE-LINES             
            MOVE WS-N                     TO WS-VALUE-DIFFER            
            MOVE 0                        TO SUB                        
            MOVE E-FMT06-GRP-CD           TO WS-GRP-CD-HOLD             
            MOVE WS-N                     TO WS-ALL-ROWS-PROCESD        
                                                                        
            MOVE E-FMT06-TEST-YEAR        TO WS-TEST-YEAR               
                                             HDR-LN2-YR                 
                                                                        
           IF E-FMT06-DATE-TEST-CC = X'0000' OR X'FFFF'                 
             MOVE SPACES                   TO E-FMT06-DATE-TEST         
           END-IF                                                       
                                                                        
            PERFORM 2400-LOAD-TITLE-LINES         THRU 2400-EXIT        
            UNTIL WS-ALL-ROWS-PROCESD = WS-Y                            
                                                                        
            MOVE WS-TITLE-LINE(1)         TO HDR-TITLE-LINE01           
            MOVE WS-TITLE-LINE(2)         TO HDR-TITLE-LINE02           
            MOVE WS-TITLE-LINE(3)         TO HDR-TITLE-LINE03           
            MOVE WS-TITLE-LINE(4)         TO HDR-TITLE-LINE04           
            MOVE WS-TITLE-LINE(5)         TO HDR-TITLE-LINE05           
            MOVE WS-TITLE-LINE(6)         TO HDR-TITLE-LINE06           
            MOVE WS-TITLE-LINE(7)         TO HDR-TITLE-LINE07           
                                                                        
            MOVE SPACES                   TO WS-TITLE-LINE(1)           
            MOVE SPACES                   TO WS-TITLE-LINE(2)           
            MOVE SPACES                   TO WS-TITLE-LINE(3)           
            MOVE SPACES                   TO WS-TITLE-LINE(4)           
            MOVE SPACES                   TO WS-TITLE-LINE(5)           
            MOVE SPACES                   TO WS-TITLE-LINE(6)           
            MOVE SPACES                   TO WS-TITLE-LINE(7)           
           ELSE                                                         
            MOVE WS-Y                     TO WS-VALUE-DIFFER            
           END-IF.                                                      
                                                                        
           COMPUTE TOTAL-IN = TOTAL-IN + 1                              
                                                                        
                                                                        
           PERFORM 7800-GET-TEST-QTY               THRU 7800-EXIT.      
                                                                        
           PERFORM 2500-MOVE-OUTPUT                THRU 2500-EXIT.      
                                                                        
           PERFORM 2600-WRITE-REPORT               THRU 2600-EXIT.      
                                                                        
           PERFORM 7600-CLOSE-ELEC-GRP             THRU 7600-EXIT.      
                                                                        
           PERFORM 7200-READ-FCSBW06-FILE          THRU 7200-EXIT.      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2300-GET-COMP-NAME                                            *        
      ******************************************************************        
      *                                                                         
       2300-GET-COMP-NAME.                                              
      *                                                                         
           IF E-FMT06-COMPANY-NO = X'0000' OR X'FFFF' OR X'00' OR SPACES
             MOVE '01'                     TO WS-COMPANY-NO             
           ELSE                                                         
             MOVE E-FMT06-COMPANY-NO       TO WS-COMPANY-NO             
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2400-LOAD-TITLE-LINES.                                       *          
      ****************************************************************          
      *                                                                         
       2400-LOAD-TITLE-LINES.                                           
      *                                                                         
           COMPUTE SUB = SUB + 1                                        
                                                                        
           IF SUB = 8                                                   
             DISPLAY '************ PCSRP657 ABORT   *********'          
             DISPLAY 'ELC657 PROGRAM ERROR'                             
             DISPLAY 'NUMBER OF CLASSES EXCEEDS NUMBER OF TITLE LINES'  
             DISPLAY '*** PROCESSING TERMINATED     *********'          
             MOVE 12 TO RETURN-CODE                                     
             PERFORM 9900-ABEND           THRU 9900-EXIT                
           ELSE                                                         
             PERFORM 7500-FETCH-ELEC-GRP           THRU 7500-EXIT       
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               PERFORM 7700-GET-ELEC-SPEC-DESC     THRU 7700-EXIT       
             ELSE                                                       
               MOVE SPACES                    TO WS-SPEC-DESC           
             END-IF                                                     
                                                                        
             MOVE WS-CLASS-LINE               TO WS-TITLE-LINE (SUB)    
             MOVE SPACES                      TO WS-CLASS-LINE          
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  MOVE TO OUTPUT                                                *        
      ******************************************************************        
      *                                                                         
       2500-MOVE-OUTPUT.                                                
      *                                                                         
           MOVE E-FMT06-FULL-LOAD-ACCU-AF  TO WS-FULL                   
           MOVE E-FMT06-POWER-FCTR-ACCU-AF TO WS-POWER                  
           MOVE E-FMT06-LIGHT-LOAD-ACCU-AF TO WS-LIGHT                  
                                                                        
           MOVE WS-INSTALLED-QTY          TO HDR-INSTALLED-QTY          
           MOVE WS-TESTED-QTY             TO HDR-TESTED-QTY             
           MOVE E-FMT06-GRP-CD            TO HDR-FMT06-GRP-CD           
           MOVE WS-GRP-DESC               TO HDR-GRP-DESC               
           MOVE E-FMT06-DEVICE-NO         TO OUT-FMT06-DEVICE-NO        
                                                                        
           MOVE E-FMT06-DATE-TEST-YY      TO WS-DATE-TEST-YY            
           MOVE E-FMT06-DATE-TEST-MM      TO WS-DATE-TEST-MM            
           MOVE E-FMT06-DATE-TEST-DD      TO WS-DATE-TEST-DD            
                                                                        
           IF WS-DATE-TEST-DD = SPACES                                  
             MOVE SPACES                   TO WS-FILLER1                
                                              WS-FILLER2                
           ELSE                                                         
             MOVE '/'                      TO WS-FILLER1                
                                              WS-FILLER2                
           END-IF                                                       
                                                                        
           MOVE WS-DATE-TEST              TO OUT-DATE-TEST              
                                                                        
           MOVE E-FMT06-EQ-TESTER-ID      TO OUT-FMT06-EQ-TESTER-ID     
           MOVE E-FMT06-TEST-BENCH-ID     TO OUT-FMT06-TEST-BENCH-ID    
           MOVE E-FMT06-ELEC-MTR-CLASS-CD TO OUT-FMT06-ELEC-MTR-CLASS-CD
           MOVE E-FMT06-ELEC-MTR-SPEC-CD  TO OUT-FMT06-ELEC-MTR-SPEC-CD 
           MOVE E-FMT06-METER-SIZE-ID     TO OUT-FMT06-METER-SIZE-ID    
           MOVE E-FMT06-REPAIR-DESC       TO OUT-FMT06-REPAIR-DESC      
                                                                        
           MOVE WS-FULL                   TO OUT-FULL                   
           MOVE WS-LIGHT                  TO OUT-LIGHT                  
           MOVE WS-POWER                  TO OUT-POWER.                 
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2600-WRITE-REPORT.                                           *          
      ****************************************************************          
      *                                                                         
        2600-WRITE-REPORT.                                              
                                                                        
           IF WS-VALUE-DIFFER = WS-N OR WS-TOTAL-COUNT > 65             
              COMPUTE WS-PAGE-NO        = WS-PAGE-NO       + 1          
              MOVE WS-PAGE-NO                 TO HDR-LN1-PAGE-NO        
              MOVE WS-Y                       TO WS-FIRST-VALUE         
                                                                        
              PERFORM 8000-PROCESS-DTLS-HDR         THRU  8000-EXIT     
             IF WS-TOTAL-COUNT > 65                                     
               MOVE 0                         TO WS-TOTAL-COUNT         
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF WS-FIRST-VALUE = WS-Y                                     
             PERFORM 8100-WRITE-OUTFILE             THRU  8100-EXIT     
             MOVE WS-N                        TO WS-FIRST-VALUE         
           ELSE                                                         
             PERFORM 8200-WRITE-OUTFILE             THRU  8200-EXIT     
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSMT06-FILE -INPUT FILE                                 *        
      ******************************************************************        
      *                                                                         
       7200-READ-FCSBW06-FILE.                                          
      *                                                                         
           READ FCSMT06-FILE                                            
                                                                        
           IF FBW006-SUCCESSFUL  OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   *********'        
               DISPLAY '** ERROR IN READING INPUT FILE     ****'        
               DISPLAY '** FILE STATUS IS ' WS-FMT06-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     *********'        
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-GET-COMPANY-NAME.                                                 
      ******************************************************************        
      *                                                                         
       7300-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7300-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-OPEN-ELEC-GRP.                                          **        
      ******************************************************************        
      *                                                                         
       7400-OPEN-ELEC-GRP.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN ELEC_GRP                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP655 ABORT *****'                   
              DISPLAY '**OPEN MAIN CURSOR ERROR   **'                   
              DISPLAY '**7400-OPEN-ELEC-GRP        **'                  
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-FETCH-ELEC-GRP                                          **        
      ******************************************************************        
      *                                                                         
       7500-FETCH-ELEC-GRP.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH ELEC_GRP                                            
               INTO :WS-CLASS                                           
                   ,:WS-SPEC-CD2                                        
                   ,:WS-BEG-DT                                          
                   ,:WS-END-DT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                   TO WS-ALL-ROWS-PROCESD        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7500-GET-ELEC-GRP      **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  WS-GRP-CD-HOLD= ' WS-GRP-CD-HOLD             
              DISPLAY '**  WS-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7600-CLOSE-ELEC-GRP                                          **        
      ******************************************************************        
      *                                                                         
       7600-CLOSE-ELEC-GRP.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE ELEC_GRP                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP655 ABORT *****'                   
              DISPLAY '**CLOSE MAIN CURSOR ERROR  **'                   
              DISPLAY '**7600-CLOSE-ELEC-GRP      **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   7700-GET-ELEC-SPEC-DESC                                  **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       7700-GET-ELEC-SPEC-DESC.                                         
      *                                                                 08230000
           EXEC SQL                                                     
              SELECT U5.ELEC_MTR_SPEC_DESC                              
                INTO :WS-SPEC-DESC                                      
                FROM CSS_ELEC_MTR_SPEC U5 WITH(READUNCOMMITTED)                 
               WHERE U5.ELEC_MTR_SPEC_CD = :WS-SPEC-CD                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT U5.ELEC_MTR_SPEC_DESC                                      
MFA-TR*         INTO :WS-SPEC-DESC                                              
MFA-TR*         FROM CSS_ELEC_MTR_SPEC U5                                       
MFA-TR*        WHERE U5.ELEC_MTR_SPEC_CD = :WS-SPEC-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7700-GET-ELEC-SPEC-DESC**'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  WS-SPEC-CD    = ' WS-SPEC-CD                 
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   7800-GET-TEST-QTY                                        **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       7800-GET-TEST-QTY.                                               
      *                                                                 08230000
           EXEC SQL                                                     
              SELECT MQ.TESTED_QT                                       
                    ,MQ.INSTALLED_QT                                    
                    ,MQ.MTR_TEST_GRP_TX                                 
                INTO :WS-TESTED-QTY                                     
                    ,:WS-INSTALLED-QTY                                  
                    ,:WS-GRP-DESC                                       
                FROM CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)                 
               WHERE MQ.MTR_TEST_GRP_CD = :WS-GRP-CD-HOLD               
                 AND MQ.TEST_YEAR       = :WS-TEST-YEAR                 
                 AND MQ.TEST_SCHED_CD   = 'R'                           
                 AND MQ.CODE_UTIL_TYPE  = 'E'                           
                 AND MQ.COMPANY_NO      = :WS-COMPANY-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MQ.TESTED_QT                                               
MFA-TR*             ,MQ.INSTALLED_QT                                            
MFA-TR*             ,MQ.MTR_TEST_GRP_TX                                         
MFA-TR*         INTO :WS-TESTED-QTY                                             
MFA-TR*             ,:WS-INSTALLED-QTY                                          
MFA-TR*             ,:WS-GRP-DESC                                               
MFA-TR*         FROM CSS_MTR_TEST_HIST MQ                                       
MFA-TR*        WHERE MQ.MTR_TEST_GRP_CD = :WS-GRP-CD-HOLD                       
MFA-TR*          AND MQ.TEST_YEAR       = :WS-TEST-YEAR                         
MFA-TR*          AND MQ.TEST_SCHED_CD   = 'R'                                   
MFA-TR*          AND MQ.CODE_UTIL_TYPE  = 'E'                                   
MFA-TR*          AND MQ.COMPANY_NO      = :WS-COMPANY-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7800-GET-TEST-QTY      **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  WS-GRP-CD-HOLD= ' WS-GRP-CD-HOLD             
              DISPLAY '**  WS-TEST-YEAR    ' WS-TEST-YEAR               
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8000-PROCESS-DTLS-HDR                                    **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-PROCESS-DTLS-HDR.                                           
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN1                
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN4                
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN5                
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN6.               
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN7.               
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN01               
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN02.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN03.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN04.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN05.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN06.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN07.              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LNX                
                  AFTER ADVANCING 3 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN8.               
           WRITE PRT331-RECORD FROM WS-RP657-HDR-REC-LN9.               
           ADD +17 TO WS-TOTAL-COUNT.                                   
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8100-WRITE-OUTFILE.                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE.                                              
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP657-OUT-REC                    
                  AFTER ADVANCING 2 LINES.                              
           ADD +1  TO WS-TOTAL-COUNT.                                   
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8200-WRITE-OUTFILE.                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE.                                              
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP657-OUT-REC.                   
           ADD +1  TO WS-TOTAL-COUNT.                                   
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8300-WRITE-OUTFILE-LAST-FTR.                             **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-OUTFILE-LAST-FTR.                                     
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP657-FTR-REC-LN1.               
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
