       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP656.                                      
COB303 DATE-WRITTEN.     MAR 04, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- THIS PROGRAM WILL PERFORM UPDATES TO METER INVENTORY WITH  --*        
      *-- RESULTS FROM PHYSICAL INVENTORY.                           --*        
      *-- UPDATES EQUIPMENT TABLE.                                   --*        
      *-- INSERTS MOVEMENT HISTORY RECORD.                           --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  02/18/2016    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT048*--                            ELC506 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT INFILE                                                
               ASSIGN TO UT-S-INFILE                                    
               FILE STATUS IS WS-INFILE-STATUS.                         
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN TO UT-S-FCSPT331.                                 
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  INFILE                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE-REC.                                                   
          05 IN-METER-NO              PIC X(09) VALUE SPACES.           
          05 IN-SERL-NO               PIC X(11) VALUE SPACES.           
          05 IN-COMP-NO               PIC X(02) VALUE SPACES.           
          05 IN-MOVE-DT               PIC X(10) VALUE SPACES.           
          05 IN-LOC-CD                PIC X(01) VALUE SPACES.           
          05 IN-UTL-CD                PIC X(01) VALUE SPACES.           
          05 IN-MSF-CD                PIC X(03) VALUE SPACES.           
          05 FILLER                   PIC X(43) VALUE SPACES.           
      *                                                                         
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 PRT331-RECORD               PIC X(133).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP656'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  05170000
      *    COPYBOOK FOR CSS_EQUIPMENT, EQ                            *  05180000
      ****************************************************************  05190000
           EXEC SQL                                                     05200000
               INCLUDE TBEQUIP                                          05210000
           END-EXEC.                                                    05220000
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTRD_ENVRNMT, MN                         *  05180000
      ****************************************************************  05190000
           EXEC SQL                                                     05200000
               INCLUDE TBMTRENV                                         05210000
           END-EXEC.                                                    05220000
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT, AT                              *  05180000
      ****************************************************************  05190000
           EXEC SQL                                                     05200000
               INCLUDE TBACCT                                           05210000
           END-EXEC.                                                    05220000
      ****************************************************************          
      *    COPYBOOK FOR CSS_MOVEMENT_HIST, MV                        *  05180000
      ****************************************************************  05190000
           EXEC SQL                                                     05200000
               INCLUDE TBMVHIST                                         05210000
           END-EXEC.                                                    05220000
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
       01 WS-MISC.                                                      
      *                                                                         
           05 WS-REC-COUNT-EQ         PIC 9(08) VALUE ZEROES.           
           05 WS-REC-COUNT-MV         PIC 9(08) VALUE ZEROES.           
           05 WS-TOT-COUNT-MV         PIC 9(08) VALUE ZEROES.           
           05 WS-TOT-COUNT-EQ         PIC 9(08) VALUE ZEROES.           
           05 WS-REC-CNT              PIC 9(08) VALUE ZEROES.           
           05 WS-REC-CNT-A            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-B            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-C            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-I            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-J            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-K            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-U            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-X            PIC 9(06) VALUE ZEROES.           
           05 WS-REC-CNT-100          PIC 9(06) VALUE ZEROES.           
           05 WS-METER                PIC X(09) VALUE SPACES.           
           05 WS-CUR-LOC              PIC X(01) VALUE SPACES.           
           05 WS-NEW-LOC              PIC X(01) VALUE SPACES.           
           05 WS-UTIL-TYPE            PIC X(01) VALUE SPACES.           
           05 WS-ACCOUNT              PIC 9(13) VALUE ZEROES.           
           05 WS-DATA-IND             PIC X(01) VALUE SPACES.           
           05 WS-TOTAL-IN             PIC 9(07) VALUE ZEROES.           
           05 WS-RPT-PAGE-BRK         PIC X(01) VALUE SPACES.           
           05 WS-RPT-LINE-CNT         PIC 9(06) VALUE ZEROES.           
           05 WS-RPT-PAGE-NUM         PIC 9(06) VALUE ZEROES.           
           05 WS-RPT-NO-DATA          PIC X(01) VALUE SPACES.           
           05 WS-RUN-TIME             PIC X(08) VALUE SPACES.           
           05 WS-RUN-DATE             PIC X(10) VALUE SPACES.           
           05 WS-RPT-DATE.                                              
              10 WS-RPT-MM            PIC X(02) VALUE SPACES.           
              10 FILLER               PIC X(01) VALUE '/'.              
              10 WS-RPT-DD            PIC X(02) VALUE SPACES.           
              10 FILLER               PIC X(01) VALUE '/'.              
              10 WS-RPT-YY            PIC X(04) VALUE SPACES.           
      *                                                                         
       01 WS-LITERALS.                                                  
      *                                                                         
           05 WS-PROGRAM-NAME         PIC X(11) VALUE 'PCSRP656-01'.    
           05 WS-COMPANY-NAME         PIC X(31)                         
           VALUE 'SOUTH CAROLINA ELECTRIC AND GAS'.                     
           05 WS-RPT-DESC             PIC X(28)                         
           VALUE 'METER IS ATTACHED TO ACCOUNT'.                        
           05 WS-RPT-HDR-EXIST        PIC X(01) VALUE 'Y'.              
           05 WS-DATA-SW              PIC X(01) VALUE 'N'.              
           05 WS-Y                    PIC X(01) VALUE 'Y'.              
           05 WS-N                    PIC X(01) VALUE 'N'.              
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-INFILE-STATUS       PIC X(02) VALUE '00'.             
               88 INFILE-SUCCESSFUL             VALUE '00'.             
               88 END-OF-REC                    VALUE '10'.             
      *                                                                         
      ***************** PCSRP505 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  RPT-DATE           PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  RPT-PGM-NAME       PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(28) VALUE SPACES.           
               10  RPT-NAME           PIC X(31) VALUE SPACES.           
               10  FILLER             PIC X(38) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'PAGE'.           
               10  RPT-PGNUM          PIC Z(06)9.                       
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER             PIC X(53) VALUE SPACES.           
               10  RPT-DESC           PIC X(28) VALUE SPACES.           
               10  FILLER             PIC X(24) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE 'RUN DATE: '.     
               10  RPT-RUN-DATE       PIC X(10) VALUE SPACES.           
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER             PIC X(60) VALUE SPACES.           
               10  RPT-ERROR          PIC X(14) VALUE '(ERROR REPORT)'. 
               10  FILLER             PIC X(31) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'RUN TIME:   '.   
               10  RPT-TIME           PIC X(08) VALUE SPACES.           
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER             PIC X(133) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-COLUMN-1.                                         
               10  FILLER             PIC X(21) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'UTILITY TYPE'.   
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(08) VALUE 'METER NO'.       
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  FILLER            PIC X(16) VALUE 'CURRENT LOCATION'.
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'NEW LOCATION'.   
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  FILLER            PIC X(16) VALUE 'ACCOUNT/COMMENTS'.
               10  FILLER             PIC X(05) VALUE SPACES.           
      *                                                                         
           05  WS-RPT-DETAIL.                                           
               10  FILLER             PIC X(26) VALUE SPACES.           
               10  RPT-UTIL-TYPE      PIC X(01) VALUE SPACES.           
               10  FILLER             PIC X(09) VALUE SPACES.           
               10  RPT-METER          PIC X(09) VALUE SPACES.           
               10  FILLER             PIC X(09) VALUE SPACES.           
               10  RPT-CUR-LOC        PIC X(01) VALUE SPACES.           
               10  FILLER             PIC X(16) VALUE SPACES.           
               10  RPT-NEW-LOC        PIC X(01) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE SPACES.           
               10  RPT-ACCOUNT        PIC X(13) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  RPT-COMMENTS       PIC X(40)                         
                                      VALUE 'METER ATTACHED TO ACCOUNT'.
               10  FILLER             PIC X(03) VALUE SPACES.           
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                 PIC X(55) VALUE SPACES.           
           05  FILLER                 PIC X(22) VALUE                   
                     '*** END OF REPORT ***'.                           
           05  FILLER                 PIC X(55) VALUE SPACES.           
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                 PIC X(54) VALUE SPACES.           
           05  FILLER                 PIC X(25) VALUE                   
                     '*** NO ACCOUNTS FOUND ***'.                       
           05  FILLER                 PIC X(45) VALUE SPACES.           
      ****************************************************************          
      *                                                                         
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT            THRU  1000-EXIT.       
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT  INFILE.                                          
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
           PERFORM 7000-GET-CURR-DT-TIME         THRU 7000-EXIT.        
           MOVE WS-RUN-TIME               TO RPT-TIME.                  
           MOVE WS-RUN-DATE(1:4)          TO WS-RPT-YY.                 
           MOVE WS-RUN-DATE(6:2)          TO WS-RPT-MM.                 
           MOVE WS-RUN-DATE(9:2)          TO WS-RPT-DD.                 
           MOVE WS-RPT-DATE               TO RPT-RUN-DATE               
                                             RPT-DATE.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7100-READ-INFILE                 THRU 7100-EXIT.     
           IF END-OF-REC                                                
              MOVE WS-Y                     TO WS-RPT-NO-DATA           
           END-IF.                                                      
      *                                                                         
           PERFORM 2050-WRITE-HEADER                THRU 2050-EXIT.     
           PERFORM 2000-PROCESS-DTLS                THRU  2000-EXIT     
             UNTIL END-OF-REC.                                          
      *                                                                         
           COMPUTE WS-TOT-COUNT-EQ = WS-TOT-COUNT-EQ + WS-REC-COUNT-EQ. 
           COMPUTE WS-TOT-COUNT-MV = WS-TOT-COUNT-MV + WS-REC-COUNT-MV. 
           DISPLAY 'TOTAL COUNT FOR EQ  = ' WS-TOT-COUNT-EQ             
           DISPLAY 'TOTAL COUNT FOR MV  = ' WS-TOT-COUNT-MV             
           DISPLAY ' '                                                  
           DISPLAY 'TOTAL INVENTORY RECORDS PROCESSED: ' WS-REC-CNT     
           DISPLAY ' '                                                  
           DISPLAY 'TOTAL COUNT FOR A - INVENTORY:    ' WS-REC-CNT-A    
           DISPLAY 'TOTAL COUNT FOR B - TEST SHOP:    ' WS-REC-CNT-B    
           DISPLAY 'TOTAL COUNT FOR C - IN TRANSIT:   ' WS-REC-CNT-C    
           DISPLAY 'TOTAL COUNT FOR I - RETIRED  :    ' WS-REC-CNT-I    
           DISPLAY 'TOTAL COUNT FOR J - AT CUST ACCT: ' WS-REC-CNT-J    
           DISPLAY 'TOTAL COUNT FOR K - ATTCH TO MTR: ' WS-REC-CNT-K    
           DISPLAY 'TOTAL COUNT FOR U - UNKNOWN:      ' WS-REC-CNT-U    
           DISPLAY 'TOTAL COUNT FOR X - AT OLD ACCT:  ' WS-REC-CNT-X    
           DISPLAY 'TOTAL COUNT FOR METERS NOT FOUND: ' WS-REC-CNT-100  
           DISPLAY ' '                                                  
           DISPLAY 'TOTAL NUMBER OF METERS THAT WERE MOVED LOCATION: '  
                      WS-TOT-COUNT-EQ                                   
           DISPLAY ' '                                                  
                                                                        
           PERFORM 2250-WRITE-TRLR                  THRU  2250-EXIT.    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS.                                           **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           MOVE SPACES                      TO WS-METER                 
                                               WS-NEW-LOC               
                                               WS-UTIL-TYPE.            
           MOVE ZEROES                      TO WS-ACCOUNT.              
           MOVE WS-N                        TO WS-DATA-IND.             
      *                                                                         
           MOVE IN-UTL-CD                   TO MN-CODE-UTIL-TYPE.       
           MOVE IN-COMP-NO                  TO AT-COMPANY-NO.           
           MOVE IN-METER-NO                 TO MN-METER-NO.             
           MOVE IN-MSF-CD                   TO EQ-LOCAL-OFFICE.         
           MOVE IN-LOC-CD                   TO EQ-CODE-CRNT-LOC.        
           MOVE IN-MOVE-DT                  TO EQ-DATE-LAST-MOVE.       
      *                                                                         
           IF IN-LOC-CD EQUAL ('I' OR 'U')                              
              MOVE IN-LOC-CD                TO WS-NEW-LOC               
              PERFORM 7200-GET-ERR-RPT           THRU 7200-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                MOVE WS-Y                   TO WS-DATA-IND              
                MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT               
                MOVE IN-UTL-CD              TO WS-UTIL-TYPE             
                MOVE IN-METER-NO            TO WS-METER                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2100-DETAILS-DT               THRU 2100-EXIT.        
      *                                                                         
           PERFORM 7100-READ-INFILE              THRU 7100-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-WRITE-HEADER.                                           **        
      ******************************************************************        
      *                                                                         
       2050-WRITE-HEADER.                                               
      *                                                                         
           IF WS-RPT-HDR-EXIST EQUAL WS-Y    OR                         
              WS-RPT-LINE-CNT GREATER THAN 54                           
              MOVE ZEROES                 TO WS-RPT-LINE-CNT            
              MOVE WS-N                   TO WS-RPT-HDR-EXIST           
              MOVE WS-Y                   TO WS-RPT-PAGE-BRK            
              ADD +1                      TO WS-RPT-PAGE-NUM            
              MOVE WS-RPT-PAGE-NUM        TO RPT-PGNUM                  
              MOVE WS-PROGRAM-NAME        TO RPT-PGM-NAME               
              MOVE WS-COMPANY-NAME        TO RPT-NAME                   
              MOVE WS-RPT-HEADER-1        TO PRT331-RECORD              
              PERFORM 8100-WRITE-FCSPT331        THRU 8100-EXIT         
              MOVE WS-RPT-DESC            TO RPT-DESC                   
              MOVE WS-RPT-HEADER-2        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331        THRU 8000-EXIT         
              MOVE WS-RPT-HEADER-3        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331        THRU 8000-EXIT         
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200-WRITE-FCSPT331       THRU 8200-EXIT          
              MOVE WS-RPT-COLUMN-1        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331       THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 2100-DETAILS-DT.                                       **              
      ************************************************************              
      *                                                                         
       2100-DETAILS-DT.                                                 
      *                                                                         
           COMPUTE WS-REC-CNT = WS-REC-CNT + 1.                         
           MOVE IN-COMP-NO                TO EQ-COMPANY-NO.             
           MOVE IN-UTL-CD                 TO EQ-CODE-UTIL-TYPE.         
           MOVE IN-METER-NO               TO EQ-DEVICE-NO.              
           PERFORM 7300-GET-EQUIPMENT-DETAILS      THRU 7300-EXIT.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATA-IND = WS-Y                                     
                 IF WS-NEW-LOC EQUAL ('I' OR 'U')                       
                    MOVE EQ-CODE-CRNT-LOC TO WS-CUR-LOC                 
                    MOVE WS-Y             TO WS-DATA-SW                 
                    PERFORM 2200-WRITE-DETAIL      THRU 2200-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 IF EQ-CODE-CRNT-LOC NOT EQUAL  ('J' AND 'K' AND 'I')   
                    MOVE IN-UTL-CD         TO MV-CODE-UTIL-TYPE         
                    MOVE EQ-DEVICE-NO      TO MV-DEVICE-NO              
                    MOVE EQ-DATE-LAST-MOVE TO MV-DATE-MOVE              
                    MOVE EQ-EQUIP-TYPE-CD  TO MV-CODE-DEVICE-TYPE       
                    MOVE IN-COMP-NO        TO MV-COMPANY-NO             
                    MOVE EQ-LOCAL-OFFICE   TO MV-LOCAL-OFFICE           
                    MOVE EQ-CRNT-LOC-NO    TO MV-LOC-NO                 
                    MOVE EQ-CODE-CRNT-LOC  TO MV-CODE-CRNT-LOC          
                    PERFORM 8400-INSERT-MV         THRU 8400-EXIT       
                    ADD +1                 TO WS-REC-COUNT-MV           
                    IF WS-REC-COUNT-MV = 1000                           
                       COMPUTE WS-TOT-COUNT-MV = WS-TOT-COUNT-MV +      
                                                 WS-REC-COUNT-MV        
                       MOVE ZEROES         TO WS-REC-COUNT-MV           
                       EXEC SQL                                         
                            COMMIT                                      
                       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
                    END-IF                                              
                    PERFORM 8500-UPDATE-EQ         THRU 8500-EXIT       
                    IF WS-REC-COUNT-EQ = 1000                           
                       COMPUTE WS-TOT-COUNT-EQ = WS-TOT-COUNT-EQ +      
                                                 WS-REC-COUNT-EQ        
                       MOVE ZEROES         TO WS-REC-COUNT-EQ           
                       EXEC SQL                                         
                            COMMIT                                      
                       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
                    END-IF                                              
                    EVALUATE EQ-CODE-CRNT-LOC                           
                        WHEN 'A'                                        
                             COMPUTE WS-REC-CNT-A = WS-REC-CNT-A + 1    
                        WHEN 'B'                                        
                             COMPUTE WS-REC-CNT-B = WS-REC-CNT-B + 1    
                        WHEN 'C'                                        
                             COMPUTE WS-REC-CNT-C = WS-REC-CNT-C + 1    
                        WHEN 'U'                                        
                             COMPUTE WS-REC-CNT-U = WS-REC-CNT-U + 1    
                        WHEN 'X'                                        
                             COMPUTE WS-REC-CNT-X = WS-REC-CNT-X + 1    
                    END-EVALUATE                                        
                 ELSE                                                   
                    EVALUATE EQ-CODE-CRNT-LOC                           
                        WHEN 'I'                                        
                             COMPUTE WS-REC-CNT-I = WS-REC-CNT-I + 1    
                        WHEN 'J'                                        
                            COMPUTE WS-REC-CNT-J = WS-REC-CNT-J + 1     
                        WHEN 'K'                                        
                            COMPUTE WS-REC-CNT-K = WS-REC-CNT-K + 1     
                    END-EVALUATE                                        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY 'NOT FOUND ON EQ ' EQ-DEVICE-NO                
                 COMPUTE WS-REC-CNT-100 = WS-REC-CNT-100 + 1            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-WRITE-DETAIL.                                           **        
      ******************************************************************        
      *                                                                         
       2200-WRITE-DETAIL.                                               
      *                                                                         
           MOVE WS-UTIL-TYPE              TO RPT-UTIL-TYPE.             
           MOVE WS-METER                  TO RPT-METER.                 
           MOVE WS-CUR-LOC                TO RPT-CUR-LOC.               
           MOVE WS-NEW-LOC                TO RPT-NEW-LOC.               
           MOVE WS-ACCOUNT                TO RPT-ACCOUNT.               
           MOVE WS-RPT-DETAIL             TO PRT331-RECORD.             
           IF WS-RPT-PAGE-BRK EQUAL WS-Y                                
              MOVE WS-N                   TO WS-RPT-PAGE-BRK            
              PERFORM 8300-WRITE-FCSPT331           THRU 8300-EXIT      
           ELSE                                                         
              PERFORM 8000-WRITE-FCSPT331           THRU 8000-EXIT      
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2250-WRITE-TRLR.                                                 
      *                                                                         
           IF WS-RPT-NO-DATA = WS-Y OR WS-DATA-SW = WS-N                
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200-WRITE-FCSPT331          THRU 8200-EXIT       
              MOVE WS-NO-DATA             TO PRT331-RECORD              
              PERFORM 8200-WRITE-FCSPT331          THRU 8200-EXIT       
           ELSE                                                         
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200-WRITE-FCSPT331          THRU 8200-EXIT       
              MOVE WS-END-DATA            TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331          THRU 8000-EXIT       
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7000-GET-CURR-DT-TIME                                  **              
      ************************************************************              
      *                                                                         
       7000-GET-CURR-DT-TIME.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-TIME,
              :WS-RUN-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RUN-TIME = CURRENT TIME                                 
MFA-TR*            ,:WS-RUN-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP656 ABORT *****'                   
              DISPLAY '**  7000-GET-CURR-DT-TIME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7100-READ-INFILE                                                       
      ******************************************************************        
       7100-READ-INFILE.                                                
      *                                                                         
           READ INFILE.                                                 
                                                                        
           IF INFILE-SUCCESSFUL  OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP656 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSMT13 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE-STATUS            
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7200-GET-ERR-RPT                                       **              
      ************************************************************              
      *                                                                         
       7200-GET-ERR-RPT.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) AT.ACCOUNT_NO                                    
                 INTO :AT-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                     ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE MN.ACCOUNT_NO        = AT.ACCOUNT_NO              
                  AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE         
                  AND AT.CODE_ACCT_STAT    = 'A'                        
                  AND AT.COMPANY_NO        = :AT-COMPANY-NO             
                  AND MN.METER_NO          = :MN-METER-NO               
                  AND MN.CODE_METER_STATUS <> 'K'                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                                       
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*         WHERE MN.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                 
MFA-TR*           AND AT.CODE_ACCT_STAT    = 'A'                                
MFA-TR*           AND AT.COMPANY_NO        = :AT-COMPANY-NO                     
MFA-TR*           AND MN.METER_NO          = :MN-METER-NO                       
MFA-TR*           AND MN.CODE_METER_STATUS <> 'K'                               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP656 ABORT *****'                   
              DISPLAY '**  7200-GET-ERR-RPT       **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-EQUIPMENT-DETAILS                                     *        
      ******************************************************************        
      *                                                                         
       7300-GET-EQUIPMENT-DETAILS.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT DEVICE_NO                                          
                    ,EQUIP_TYPE_CD                                      
                    ,SERIAL_NO                                          
                    ,CODE_CRNT_LOC                                      
                    ,LOCAL_OFFICE                                       
                    ,DATE_LAST_MOVE                                     
                    ,CRNT_LOC_NO                                        
               INTO :EQ-DEVICE-NO                                       
                   ,:EQ-EQUIP-TYPE-CD                                   
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-DATE-LAST-MOVE                                  
                   ,:EQ-CRNT-LOC-NO                                     
                FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DEVICE_NO                                                  
MFA-TR*             ,EQUIP_TYPE_CD                                              
MFA-TR*             ,SERIAL_NO                                                  
MFA-TR*             ,CODE_CRNT_LOC                                              
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,DATE_LAST_MOVE                                             
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*        INTO :EQ-DEVICE-NO                                               
MFA-TR*            ,:EQ-EQUIP-TYPE-CD                                           
MFA-TR*            ,:EQ-SERIAL-NO                                               
MFA-TR*            ,:EQ-CODE-CRNT-LOC                                           
MFA-TR*            ,:EQ-LOCAL-OFFICE                                            
MFA-TR*            ,:EQ-DATE-LAST-MOVE                                          
MFA-TR*            ,:EQ-CRNT-LOC-NO                                             
MFA-TR*         FROM CSS_EQUIPMENT EQ                                           
MFA-TR*        WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP656 ABORT *******'                 
              DISPLAY '**  7300-GET-EQUIPMENT-DETAILS*'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  EQ-COMPANY-NO  = ' EQ-COMPANY-NO             
              DISPLAY '**  EQ-CODE-UTIL-TYPE = ' EQ-CODE-UTIL-TYPE      
              DISPLAY '**  EQ-DEVICE-NO = ' EQ-DEVICE-NO                
              DISPLAY '**  PROCESSING TERMINATED  ****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT331.                                        **         
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8400-INSERT-MV.                                               *         
      *****************************************************************         
      *                                                                         
       8400-INSERT-MV.                                                  
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MOVEMENT_HIST                             
                   ( CODE_UTIL_TYPE                                     
                    ,DEVICE_NO                                          
                    ,DATE_MOVE                                          
                    ,MOVE_NO                                            
                    ,CODE_DEVICE_TYPE                                   
                    ,COMPANY_NO                                         
                    ,LOCAL_OFFICE                                       
                    ,LOC_NO                                             
                    ,CODE_CRNT_LOC )                                    
              VALUES                                                    
                  ( :MV-CODE-UTIL-TYPE                                  
                   ,:MV-DEVICE-NO                                       
                   ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:MV-CODE-DEVICE-TYPE                                
                   ,:MV-COMPANY-NO                                      
                   ,:MV-LOCAL-OFFICE                                    
                   ,:MV-LOC-NO                                          
                   ,:MV-CODE-CRNT-LOC)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MOVEMENT_HIST                                     
MFA-TR*            ( CODE_UTIL_TYPE                                             
MFA-TR*             ,DEVICE_NO                                                  
MFA-TR*             ,DATE_MOVE                                                  
MFA-TR*             ,MOVE_NO                                                    
MFA-TR*             ,CODE_DEVICE_TYPE                                           
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,LOC_NO                                                     
MFA-TR*             ,CODE_CRNT_LOC )                                            
MFA-TR*       VALUES                                                            
MFA-TR*           ( :MV-CODE-UTIL-TYPE                                          
MFA-TR*            ,:MV-DEVICE-NO                                               
MFA-TR*            ,:MV-DATE-MOVE                                               
MFA-TR*            ,CURRENT_TIMESTAMP                                           
MFA-TR*            ,:MV-CODE-DEVICE-TYPE                                        
MFA-TR*            ,:MV-COMPANY-NO                                              
MFA-TR*            ,:MV-LOCAL-OFFICE                                            
MFA-TR*            ,:MV-LOC-NO                                                  
MFA-TR*            ,:MV-CODE-CRNT-LOC)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP656 ABORT *******'                 
              DISPLAY '**  8400-INSERT-MV           **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  ****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 8500-UPDATE-EQ.                                               *         
      *****************************************************************         
      *                                                                         
       8500-UPDATE-EQ.                                                  
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET LOCAL_OFFICE   = :EQ-LOCAL-OFFICE                  
                    ,CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC                 
                    ,DATE_LAST_MOVE = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                
                    ,DATE_LAST_TRAN = CAST(SYSDATETIMEOFFSET() AS DATE)         
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                 AND SERIAL_NO      = :EQ-SERIAL-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIPMENT                                              
MFA-TR*          SET LOCAL_OFFICE   = :EQ-LOCAL-OFFICE                          
MFA-TR*             ,CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC                         
MFA-TR*             ,DATE_LAST_MOVE = :EQ-DATE-LAST-MOVE                        
MFA-TR*             ,DATE_LAST_TRAN = CURRENT_DATE                              
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*          AND SERIAL_NO      = :EQ-SERIAL-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              ADD +1                        TO WS-REC-COUNT-EQ          
           ELSE                                                         
              DISPLAY '******** PCSRP656 ABORT *******'                 
              DISPLAY '**  8500-UPDATE-EQ           **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  ****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE INFILE.                                                
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
