HPCCDM*       CBL ADV                                                           
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP627.                                        
       DATE-WRITTEN.   06/28/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  06/28/95     SJ        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  --------     ----------------------------------  **         
      **  07/20/95     DW        ADDED CWS00303; CHANGED DATE FORMAT **         
      **                         FOR CORRECT RUN-DATE; ADDED COBOL   **         
      **                         ADVANCE; CORRECTED SPACING & SPELL- **         
      **                         ING ERRORS.                         **         
      **  --------  --------     ----------------------------------  **         
T17036**  07/08/98    TDK        MOVE WS-ONPK-ECON-KWH TO WS-VAR-ECON**         
      **                         OMY-KWH WHEN E-FWK05-TOU-CODE = 0.  **         
      **  --------  --------     ----------------------------------  **         
T17180**  07/21/98    TDK        ONLY PICK UP WESTVACO ACCT FOR RPRT.**         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP627 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSWK05.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDWK05.                                                            
       COPY FIOWK05.                                                            
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP627'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP627 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPRCSCH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      *                                                                         
T17180     EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
               'SOUTH CAROLINA ELEC. & GAS'.                            
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(35)    VALUE               
                           'WESTVACO INTERVAL CALCULATION SHEET'.       
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE2.                                  
               10  FILLER              PIC X(14)    VALUE               
                                       'CURRENT AS OF '.                
               10  WS-DEFAULT-RPT1-TITLE2-A PIC X(08).                  
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
               88  REPORT-NOT-STARTED               VALUE 'N'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-FCA-EXIST            PIC X(01)    VALUE 'N'.          
               88  FCA-EXISTS                       VALUE 'Y'.          
               88  FCA-DNE                          VALUE 'N'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
           05  WS-COMPANY-NO           PIC X(02)    VALUE SPACES.       
           05  WS-PREV-COMPANY-NO      PIC X(02)    VALUE SPACES.       
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FWK05-REC-CNTR       PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-BREAK                PIC 9(02)    VALUE ZERO COMP-3.  
           05  WS-FWK05-STATUS         PIC X(02).                       
               88  WS-FWK05-SUCCESSFUL                 VALUE '00'.      
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 60   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DDTT-10.                                                  
           05  WS-DT10-CC              PIC X(02).                       
           05  WS-DT10-YY              PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-DT10-MM              PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-DT10-DD              PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-DDTT-6.                                                   
           05  WS-DT6-YY               PIC X(02).                       
           05  WS-DT6-MM               PIC X(02).                       
           05  WS-DT6-DD               PIC X(02).                       
      *                                                                         
       01  WS-CNTR                     PIC 9(03)    COMP-3 VALUE 0.     
      *                                                                         
       01  WS-INTERVAL-TIME.                                            
           02  WS-INTV-DATE            PIC 9(06).                       
           02  WS-INTV-HH              PIC 9(02).                       
           02  WS-INTV-MM              PIC 9(02).                       
      *                                                                         
       01  WS-PREV-INTERVAL-TIME       PIC 9(10)    VALUE ZERO.         
      *                                                                         
COB305 01 WS-FIXED-FIRM-KWH        PIC S9(03)V9(06) COMP-3 VALUE 0.        
COB305 01 WS-FIRM-KWH        PIC S9(09) COMP-3 VALUE 0.        
COB305 01 WS-ECONOMY-KWH        PIC S9(09) COMP-3 VALUE 0.        
COB305 01 WS-VAR-ECONOMY-KWH        PIC S9(03)V9(06) COMP-3 VALUE 0.        
COB305 01 WS-OFFPK-ECON-KWH        PIC S9(03)V9(06) COMP-3 VALUE 0.        
COB305 01 WS-ONPK-ECON-KWH        PIC S9(03)V9(06) COMP-3 VALUE 0.        
COB305 01 WS-FIRM-KWH-CHARGE        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305 01 WS-ECONOMY-KWH-CHARGE        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305 01 WS-TOT-KWH-CHARGE        PIC S9(11)V99 COMP-3 VALUE 0.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP627'.   
           05  WS-15                   PIC 9(02)    VALUE 15.           
           05  WS-51                   PIC 9(02)    VALUE 51.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
T13114     05  WS-ELECTRIC             PIC X        VALUE 'E'.          
T13114     05  WS-WESTVACO-RATE        PIC X(03)    VALUE '60W'.        
T13114     05  WS-BASIC-COMP           PIC X(02)    VALUE '10'.         
T13114     05  WS-ECON-COMP            PIC X(02)    VALUE '20'.         
T13114     05  WS-BOTH-SEAS            PIC X        VALUE 'B'.          
T13114     05  WS-ENERGY               PIC X        VALUE 'R'.          
T13114     05  WS-ELEC-FCA-LIT         PIC X(08)    VALUE 'ELEC-FCA'.   
      *                                                                         
      ***************** PCSRP627 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(35).                       
               10  FILLER              PIC X(30)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(55)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(22).                       
               10  FILLER              PIC X(41)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **          WORKING STORAGE FOR  DETAIL LINES                 **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X(11)    VALUE 'INTERVAL = '.
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  P-INTERVAL-TIME.                                     
                   15  P-INTV-DATE     PIC 9(06).                       
                   15  P-INTV-HH       PIC 9(02).                       
                   15  P-INTV-MM       PIC 9(02).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'KWH = '.     
               10  FILLER              PIC X(17)    VALUE SPACES.       
               10  P-KWH-VALUE         PIC 999999999.99.                
               10  FILLER              PIC X(11)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'KVAR = '.    
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  P-KVAR-VALUE        PIC 999999999.99.                
               10  FILLER              PIC X(09)    VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-2.                                        
               10  FILLER              PIC X(08)    VALUE 'FIRM KWH'.   
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  P-FIRM-KWH          PIC ZZZZZZZZ9.                   
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'TIMES'.      
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-FIXED-FIRM-KWH    PIC 999.999999.                  
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '='.          
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  P-FIRM-KWH-CHARGE   PIC ZZZZZZZZ9.99.                
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'KVA ='.      
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  P-KVA-VALUE         PIC 999999999.99.                
               10  FILLER              PIC X(02)    VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-3.                                        
               10  FILLER              PIC X(11)    VALUE 'ECONOMY KWH'.
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  P-ECONOMY-KWH       PIC ZZZZZZZZ9.                   
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'TIMES'.      
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-VARIABLE-ECONOMY-KWH                               
                                       PIC 999.999999.                  
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '='.          
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  P-ECONOMY-KWH-CHARGE                                 
                                       PIC ZZZZZZZZ9.99.                
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-ON-OFF-PEAK       PIC X(07)    VALUE 'OFFPEAK'.    
               10  FILLER              PIC X(20)    VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-4.                                        
               10  FILLER              PIC X(38)    VALUE               
                              'TOTAL KWH CHARGE FOR INTERVAL PERIOD ='. 
               10  FILLER              PIC X(41)    VALUE SPACES.       
               10  P-TOT-KWH-CHARGE-INT                                 
                                       PIC ZZZZZZZZZZ9.99.              
               10  FILLER              PIC X(39)    VALUE SPACES.       
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
                              'WORKING STORAGE FOR PCSRP627 ENDS HERE'. 
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
T13114     PERFORM 7500-SELECT-MAX-VERSION       THRU 7500-EXIT.        
T13114     MOVE 0                TO PS-CODE-TIME-PERIOD                 
T13114     MOVE WS-ELECTRIC      TO PS-CODE-UTIL-TYPE                   
T13114     MOVE WS-WESTVACO-RATE TO PS-RATE-PLAN-NO                     
T13114     MOVE WS-BASIC-COMP    TO PS-CMPNT-ID-CD                      
T13114     MOVE WS-ENERGY        TO PS-CODE-USE-INST-TYPE               
T13114     MOVE 1                TO PS-BLOCK-NO                         
T13114     PERFORM 7600-SELECT-PRICE-SCHED THRU 7600-EXIT               
T13114     MOVE PS-SCHED-PRICE-AM TO WS-FIXED-FIRM-KWH                  
T13114     MOVE 1                TO PS-CODE-TIME-PERIOD                 
T13114     MOVE WS-ECON-COMP     TO PS-CMPNT-ID-CD                      
T13114     PERFORM 7600-SELECT-PRICE-SCHED       THRU 7600-EXIT.        
T13114     MOVE PS-SCHED-PRICE-AM TO WS-ONPK-ECON-KWH                   
T13114     MOVE 2                TO PS-CODE-TIME-PERIOD                 
T13114     PERFORM 7600-SELECT-PRICE-SCHED       THRU 7600-EXIT.        
T13114     MOVE PS-SCHED-PRICE-AM TO WS-OFFPK-ECON-KWH                  
      *                                                                         
T13114     PERFORM 7700-SELECT-FCA-FACTOR        THRU 7700-EXIT.        
           ADD SA-FACTOR TO WS-FIXED-FIRM-KWH                           
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
      *                                                                         
           PERFORM 7100-READ-FCSWK05             THRU 7100-EXIT.        
      *                                                                         
           MOVE WS-COMPANY-NO          TO WS-PREV-COMPANY-NO.           
           MOVE WS-INTERVAL-TIME       TO WS-PREV-INTERVAL-TIME.        
      *                                                                         
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           IF SYSIN-EXISTS                                              
               IF WS-FWK05-REC-CNTR EQUAL ZERO                          
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                         AFTER ADVANCING 3 LINES                        
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF  WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                    
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP627 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
               MOVE WS-HH              TO WS-RT-HH.                     
               MOVE WS-MM              TO WS-RT-MM.                     
               MOVE WS-SS              TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
               MOVE WS-CY              TO WS-RD-YY.                     
               MOVE WS-CM              TO WS-RD-MM.                     
               MOVE WS-CD              TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN INPUT FCSWK05-FILE.                                     
           IF WS-FWK05-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP627 PROCESSING ERROR       **'    
               DISPLAY '**  OPEN ERROR OF FCSWK05 - INPUT FILE   **'    
               DISPLAY '**    FILE STATUS = ' WS-FWK05-STATUS           
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSWK05               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-READ-FCSWK05             THRU 7100-EXIT.        
      *                                                                         
           IF E-FWK05-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FWK05-REC-CNTR                        
               MOVE E-FWK05-CREATE-DATE-BREC                            
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
               MOVE WS-DATE-8          TO WS-DEFAULT-RPT1-TITLE2-A      
           ELSE                                                         
               DISPLAY '**       PCSRP627 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP627 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           ELSE                                                         
               IF E-FWK05-KEY-EREC EQUAL HIGH-VALUES                    
                   PERFORM 1900-PROCESS-END-REC  THRU 1900-EXIT         
               ELSE                                                     
                   IF REPORT-STARTED                                    
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       MOVE WS-Y       TO WS-START-REPORT               
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPANY-NO          TO WS-PREV-COMPANY-NO.           
           MOVE WS-INTERVAL-TIME       TO WS-PREV-INTERVAL-TIME.        
           PERFORM 7100-READ-FCSWK05             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-CHECK-COMP-END-REC                                  **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-CHECK-COMP-END-REC.                                         
      *                                                                         
           MOVE '1800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF  WS-COMPANY-NO NOT EQUAL WS-PREV-COMPANY-NO               
               MOVE WS-60              TO WS-RPT1-LINE-NO               
               MOVE WS-Y               TO WS-CHANGE-COMP-NO             
           END-IF.                                                      
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           MOVE '1900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FWK05-REC-CNTR.                           
           IF WS-FWK05-REC-CNTR EQUAL E-FWK05-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP627 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FWK05-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FWK05-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE WS-COMPANY-NO      TO WS-CURRENT-COMP-NO            
                                          WS-PREV-COMPANY-NO            
               MOVE WS-INTERVAL-TIME   TO WS-PREV-INTERVAL-TIME         
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
           END-IF.                                                      
      *                                                                         
           IF WS-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO                
               DISPLAY '**        PCSRP627 PROCESSING ERROR       **'   
               DISPLAY '**   COMPANY DATA RECORDS NOT SEPARATED   **'   
               DISPLAY '**     WITH PROPER COMPANY END-RECORD     **'   
               DISPLAY '**  CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO 
               DISPLAY '**  TABLE COMPANY NO IS :' WS-COMPANY-NO        
               DISPLAY '**  DATA IS :' E-FWK05-DATA-REC                 
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                   IF WS-COMPANY-NO EQUAL WS-SYSIN-COMP-NO              
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT                     
                                                 THRU 2200-EXIT         
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '**  PCSRP627 PROCESSING ERROR   **' 
                           DISPLAY '**   FILE NOT SORTED PROPERLY   **' 
                           DISPLAY '**  IN ORDER OF COMPANY NUMBERS **' 
                           DISPLAY '**  DATA IS :' E-FWK05-DATA-REC     
                           DISPLAY '**    PROCESSING TERMINATED     **' 
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T17180     PERFORM 7750-GET-RATE-PLAN-NO         THRU 7750-EXIT.        
      *                                                                         
T17180     IF UT-RATE-PLAN-NO NOT EQUAL WS-WESTVACO-RATE                
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2300-FORMAT-DETAIL-LINE       THRU 2300-EXIT      
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP627       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-INTERVAL-TIME       TO P-INTERVAL-TIME.              
      *                                                                         
           SET WK05-INTV               TO 1.                            
      *                                                                         
           MOVE 15                     TO WS-CNTR.                      
      *                                                                         
           PERFORM 4 TIMES                                              
               SEARCH E-FWK05-INTERVAL-DATA                             
                   WHEN WK05-INTV LESS THAN 5                           
                       MOVE E-FWK05-KWH-UNITS (WK05-INTV)               
                                       TO WS-ECONOMY-KWH,               
                                          P-KWH-VALUE,                  
                                          P-ECONOMY-KWH                 
                       COMPUTE P-KVA-VALUE ROUNDED                      
                         = E-FWK05-KVA-UNITS (WK05-INTV) / 4            
                       COMPUTE P-KVAR-VALUE ROUNDED                     
                         = E-FWK05-KVAR-UNITS (WK05-INTV) / 4           
T13114*                IF E-FWK05-LOAD-TYPE-CD (WK05-INTV) EQUAL 'A'            
T13114*                    AND E-FWK05-REC-TYPE            EQUAL 'A'            
T13114*                    ADD E-FWK05-RATE-1                                   
T13114*                                TO WS-FIXED-FIRM-KWH,                    
T13114*                                   P-FIXED-FIRM-KWH                      
T13114*                END-IF                                                   
                       MOVE WS-FIXED-FIRM-KWH TO P-FIXED-FIRM-KWH       
                       COMPUTE WS-FIRM-KWH ROUNDED                      
                         = E-FWK05-BASELINE-LOAD / 4                    
                       MOVE WS-FIRM-KWH TO P-FIRM-KWH                   
                       COMPUTE WS-FIRM-KWH-CHARGE ROUNDED               
                         = WS-FIXED-FIRM-KWH * WS-FIRM-KWH              
                       MOVE WS-FIRM-KWH-CHARGE TO P-FIRM-KWH-CHARGE     
                       COMPUTE WS-ECONOMY-KWH ROUNDED                   
                         = WS-ECONOMY-KWH - WS-FIRM-KWH                 
                       MOVE WS-ECONOMY-KWH TO P-ECONOMY-KWH             
T17036                 IF E-FWK05-TOU-CODE = 1 OR 0                     
T17036*                IF E-FWK05-TOU-CODE = 1                                  
                          MOVE WS-ONPK-ECON-KWH TO WS-VAR-ECONOMY-KWH   
                       ELSE                                             
                          IF E-FWK05-TOU-CODE = 2                       
                             MOVE WS-OFFPK-ECON-KWH                     
                                  TO WS-VAR-ECONOMY-KWH                 
                          END-IF                                        
                       END-IF                                           
T13114                 ADD E-FWK05-RATE-1 TO WS-VAR-ECONOMY-KWH         
T13114                 MOVE WS-VAR-ECONOMY-KWH                          
                            TO P-VARIABLE-ECONOMY-KWH                   
                       COMPUTE WS-ECONOMY-KWH-CHARGE ROUNDED            
                         = WS-ECONOMY-KWH * WS-VAR-ECONOMY-KWH          
                       MOVE WS-ECONOMY-KWH-CHARGE                       
                                       TO P-ECONOMY-KWH-CHARGE          
                       ADD WS-FIRM-KWH-CHARGE                           
                                       TO WS-ECONOMY-KWH-CHARGE         
                           GIVING WS-TOT-KWH-CHARGE                     
                       MOVE WS-CNTR    TO P-INTV-MM                     
                       IF WS-CNTR = 60                                  
                          MOVE 0 TO P-INTV-MM                           
                          ADD 1 TO P-INTV-HH                            
                       END-IF                                           
                       MOVE WS-TOT-KWH-CHARGE                           
                                       TO P-TOT-KWH-CHARGE-INT          
                       IF E-FWK05-TOU-CODE = 1 OR 0                     
                          MOVE 'ONPEAK' TO P-ON-OFF-PEAK                
                       ELSE                                             
                          IF E-FWK05-TOU-CODE = 2                       
                             MOVE 'OFFPEAK' TO P-ON-OFF-PEAK            
                          END-IF                                        
                       END-IF                                           
                       IF WS-RPT1-LINE-NO GREATER THAN WS-51            
                           PERFORM 8100-PRINT-COMP-NAME                 
                                                 THRU 8100-EXIT         
                           PERFORM 8200-PRINT-TITLE                     
                                                 THRU 8200-EXIT         
                       END-IF                                           
                       IF E-FWK05-METER-NO = 'SUMMARY'                  
                          PERFORM 8900-PRINT-RPT1-DETAIL                
                                                THRU 8900-EXIT          
                       END-IF                                           
                       ADD WS-15       TO WS-CNTR                       
                       SET WK05-INTV UP BY 1                            
               END-SEARCH                                               
           END-PERFORM.                                                 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2400-GET-INTERVAL                                        **          
      **       CONVERT DATE/TIME TO INTERVAL FORMAT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2400-GET-INTERVAL.                                               
      *                                                                         
           MOVE '2400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE ZEROES                 TO WS-INTV-DATE.                 
           MOVE ZEROES                 TO WS-INTV-HH.                   
      *                                                                         
           MOVE E-FWK05-USAGE-DATE     TO WS-DDTT-10.                   
           MOVE WS-DT10-YY             TO WS-DT6-YY.                    
           MOVE WS-DT10-MM             TO WS-DT6-MM.                    
           MOVE WS-DT10-DD             TO WS-DT6-DD.                    
      *                                                                         
           MOVE WS-DDTT-6              TO WS-INTV-DATE.                 
           MOVE E-FWK05-USAGE-HOUR     TO WS-INTV-HH.                   
T13114     SUBTRACT 1 FROM WS-INTV-HH.                                  
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSWK05                                        **          
      **       READS THE INPUT FILE FCSWK05-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSWK05.                                               
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           READ FCSWK05-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF WS-FWK05-SUCCESSFUL                                       
               ADD 1                   TO WS-FWK05-REC-CNTR             
               IF  E-FWK05-KEY-BREC EQUAL LOW-VALUES OR                 
                   E-FWK05-KEY-EREC EQUAL HIGH-VALUES                   
                   CONTINUE                                             
               ELSE                                                     
                   PERFORM 7200-GET-COMPANY-NO   THRU 7200-EXIT         
                   PERFORM 1800-CHECK-COMP-END-REC                      
                                                 THRU 1800-EXIT         
                   PERFORM 2400-GET-INTERVAL     THRU 2400-EXIT         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSWK05 READ.  STATUS IS '        
                        WS-FWK05-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7200-GET-COMPANY-NO                                      **          
      **      READS THE COMPANY NUMBER WITH THE GIVEN CODE          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7200-GET-COMPANY-NO.                                             
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FWK05-ACCOUNT-NO     TO AT-ACCOUNT-NO.                
      *                                                                         
           EXEC SQL                                                     
               SELECT  A.COMPANY_NO                                     
                INTO :AT-COMPANY-NO                                     
               FROM  CSS_ACCOUNT A,                                     
                     CSS_COMPANY B                                      
                WHERE A.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                  AND A.COMPANY_NO =  B.COMPANY_NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE AT-COMPANY-NO      TO WS-COMPANY-NO,                
                                          WS-CURRENT-COMP-NO            
               IF REPORT-NOT-STARTED                                    
                   MOVE AT-COMPANY-NO  TO WS-PREV-COMPANY-NO            
               END-IF                                                   
           ELSE                                                         
              IF SQLCODE EQUAL NOT-FOUND                                
                   DISPLAY '* COMPANY-NO MISMATCH 7200-GET-COMPANY-NO *'
                   DISPLAY '*          RETURN CODE = ' SQLCODE          
                   DISPLAY '*          PROCESSING TERMINATED          *'
              ELSE                                                      
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-NO **'  
                   DISPLAY '**        RETURN CODE = ' SQLCODE           
                   DISPLAY '**        PROCESSING TERMINATED        **'  
              END-IF                                                    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-SELECT-MAX-VERSION                                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7500-SELECT-MAX-VERSION.                                         
      *                                                                         
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
                INTO :PS-VERSION-NO-CNTRL                               
                FROM CSS_PRICE_SCHED                                    
               WHERE RATE_PLAN_NO = '60W'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7600-SELECT-PRICE-SCHED                                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7600-SELECT-PRICE-SCHED.                                         
      *                                                                         
           MOVE '7600' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT SCHED_PRICE_AM                                     
                INTO :PS-SCHED-PRICE-AM                                 
                FROM CSS_PRICE_SCHED                                    
               WHERE RATE_PLAN_NO = :PS-RATE-PLAN-NO                    
                 AND CODE_UTIL_TYPE = :PS-CODE-UTIL-TYPE                
                 AND VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL            
                 AND CMPNT_ID_CD = :PS-CMPNT-ID-CD                      
                 AND CODE_TIME_PERIOD = :PS-CODE-TIME-PERIOD            
                 AND CODE_USE_INST_TYPE = :PS-CODE-USE-INST-TYPE        
                 AND BLOCK_NO = :PS-BLOCK-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7700-SELECT-FCA-FACTOR.                                          
      *                                                                         
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CMPNT_ID_CD,                                       
                     FACTOR,                                            
                     DATE_FROM,                                         
                     CODE_SEASON,                                       
                     DATE_TO,                                           
                     CODE_TIME_PERIOD                                   
                INTO :SA-CMPNT-ID-CD,                                   
                     :SA-FACTOR,                                        
                     :SA-DATE-FROM,                                     
                     :SA-CODE-SEASON,                                   
                     :SA-DATE-TO,                                       
                     :SA-CODE-TIME-PERIOD                               
                FROM CSS_SPCL_FCTR_APPL                                 
               WHERE RATE_PLAN_NO = :WS-WESTVACO-RATE                   
                 AND CODE_UTIL_TYPE = :WS-ELECTRIC                      
                 AND FACTOR_ID = :WS-ELEC-FCA-LIT                       
                 AND DATE_FROM =                                        
                     (SELECT MAX(DATE_FROM)                             
                        FROM CSS_SPCL_FCTR_APPL                         
                       WHERE CODE_UTIL_TYPE = :WS-ELECTRIC              
                         AND RATE_PLAN_NO = :WS-WESTVACO-RATE           
                         AND FACTOR_ID = :WS-ELEC-FCA-LIT)              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 SET FCA-EXISTS TO TRUE                                 
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 PERFORM 9900-ABEND                 THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7750-GET-RATE-PLAN-NO                                    **          
      **      GETS THE RATE PLAN OF THE CURRENT ACCOUNT.            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7750-GET-RATE-PLAN-NO.                                           
      *                                                                         
           MOVE '7750' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FWK05-ACCOUNT-NO     TO AT-ACCOUNT-NO.                
           MOVE SPACES                 TO UT-RATE-PLAN-NO.              
      *                                                                         
           EXEC SQL                                                     
               SELECT RATE_PLAN_NO                                      
                 INTO :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND RATE_PLAN_NO = :WS-WESTVACO-RATE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '* RATE-PLAN-NO ERROR 7750-GET-RATE-PLAN-NO *'    
              DISPLAY '*          RETURN CODE = ' SQLCODE               
              DISPLAY '*          PROCESSING TERMINATED          *'     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY                                        
               WHERE     COMPANY_NO = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '**        RETURN CODE = ' SQLCODE           
                   DISPLAY '**        PROCESSING TERMINATED          **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               MOVE WS-CURRENT-COMP-NO TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF                                                       
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLES FOR THE REPORT PCSRP627            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE 4                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-RPT1-DETAIL                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP627        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-RPT1-DETAIL.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-3                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-4                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE ZEROES                 TO P-TOT-KWH-CHARGE-INT.         
           MOVE ZEROES                 TO WS-TOT-KWH-CHARGE.            
      *                                                                         
           ADD 1                       TO WS-BREAK.                     
           IF WS-BREAK GREATER THAN OR EQUAL 4                          
               WRITE PRT33-RECORD FROM WS-BLANK-LINE                    
                     AFTER ADVANCING 1 LINE                             
               MOVE ZERO               TO WS-BREAK                      
           END-IF.                                                      
      *                                                                         
           ADD 5                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           CLOSE FCSWK05-FILE.                                          
           IF WS-FWK05-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP627 PROCESSING ERROR        **' 
               DISPLAY '**   CLOSE ERROR FOR FCSWK05 - INPUT FILE   **' 
               DISPLAY '**           FILE STATUS = ' WS-FWK05-STATUS    
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9900-ABEND                                               **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
