       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP617.                                      
       AUTHOR.       ROGER D. FAULK.                                    
COB303 DATE-WRITTEN.     APRIL 2016.                                    
       DATE-COMPILED.                                                   
                                                                        
      ****************************************************************          
      ***              P R O G R A M  S U M M A R Y                  *          
      ***------------------------------------------------------------*          
      ****************************************************************          
      ***THIS PROGRAM IS A COBOL REWRTIE FOR GMC098.                 *          
      *--------------------------------------------------------------*          
      ****************************************************************          
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE         **          
      ****************************************************************          
      **        0000 - 0999   MAIN CONTROL PATH AND INITIALIZATION  **          
      **        1000 - 1999   ACCOUNT PROCESSING CONTROL PATH       **          
      **        2000 - 2999   COMMON PROGRAM MODULES                **          
      **        3000 - 4999   NOT USED                              **          
      **        5000 - 5999   COMMON PROGRAM MODULES                **          
      **        6000 - 6999   NOT USED                              **          
      **        7000 - 7999   OUTPUT MODULES                        **          
      **        8000 - 8999   OUTPUT MODULES                        **          
      **        9000 - 9999   TERMINATION, ABEND, MESSAGING MODULES **          
      ****************************************************************          
      ***                  MODIFICATION LOG                        ***          
      ***----------------------------------------------------------***          
      ***                                                          ***          
      ***  DATE        INITIALS    COMMENTS                        ***          
      ***  ----------- --------    --------------------------------***          
      ***  18 APR 2016 RF10596     GMC098 EZT TO COBOL CONVERSION  ***          
      ***                                                          ***          
A05460***  28 APR 2016 RF10596     ALLOW FOR NO DATA LINE TO BE    ***          
A05460***                          SORTED LAST.  BLANK LINE AFTER  ***          
A05460***                          HEADER. LOCAL OFFICE ORDER      ***          
      ***                                                          ***          
A05460***   5 MAY 2016 RF10596     CLEAR CITY GATE FIELDS WHEN     ***          
A05460***                          NOT FOUND ON CSS_CITY_GATE.     ***          
      ***                                                          ***          
A05460***  17 JUN 2016 RF10596     ADD CURRENT DATE TO REPORT      ***          
      ***                                                          ***          
A05460***   6 JUL 2016 RF10596     CHANGE REPORT LENGTH            ***          
      ***                                                          ***          
      ***----------------------------------------------------------***          
      *                                                              *          
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSRP61A-FILE                                         
               ASSIGN TO UT-S-FCSRP61A                                  
               FILE STATUS IS WS-FCA61A-STATUS.                         
           SELECT FCSRP61B-FILE                                         
               ASSIGN TO UT-S-FCSRP61B                                  
               FILE STATUS IS WS-FCA61B-STATUS.                         
           SELECT FCSRP61C-FILE                                         
               ASSIGN TO UT-S-FCSRP61C                                  
               FILE STATUS IS WS-FCA61C-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ****************************************************************          
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                *          
      ****************************************************************          
      *                                                                         
       FD  FCSRP61A-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
A05460 01  FIORP61A                        PIC X(133).                  
      *                                                                         
       FD  FCSRP61B-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
A05460 01  FIORP61B                        PIC X(133).                  
      *                                                                         
       FD  FCSRP61C-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
A05460 01  FIORP61C                        PIC X(133).                  
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP617'.
MSQ017     COPY MFASQLM.
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ACCOUNT                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_UTIL_ENVRNMT                                          *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_MTRD_ENVRNMT                                          *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FORMATTED                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FREEFORM                                         *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_NAME_ACCT_XREF                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_NAME                                                  *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_PREMISE                                               *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ZIP_CODE                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CUSTOMER                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CUST_PREM_HIST                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_JOB_PARM                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_GAS_SERV_LINE)  -  XO                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_PREM-GAS_LINE)  -  Y0                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_CITY_GATE)  -  CO                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCITGT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE NAME AND ADDRESS - CPD00074 IS NOT USED      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00074                                                  
           END-EXEC.                                                            
*                                                                       
      ****************************************************************          
      * WORKING STORAGE FOR CPE00099                                 *          
      * GETS THE MOST CURRENT ACCOUNT-NO AT A GIVEN PREMISE          *          
      ****************************************************************          
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ****************************************************************          
      * ABEND SWITCH COPYBOOK                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * COPYBOOKS                                                    *          
      ****************************************************************          
      *                                                                         
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00010.                                                       
           COPY FIOJC01.                                                        
           COPY CWS00011.                                                       
      *                                                                         
A05460 01 WS-BLANK-RECORD              PIC X(133) VALUE SPACES.         
      *                                                                         
       01 WS-DETAIL-RECORD.                                             
           05 OUT-ACCOUNT              PIC X(13) VALUE SPACES.          
           05 OUT-DELMTR-1             PIC X     VALUE SPACES.          
           05 OUT-METER-NO             PIC X(9)  VALUE SPACES.          
           05 OUT-DELMTR-2             PIC X     VALUE SPACES.          
           05 OUT-FARM-TAP             PIC X     VALUE SPACES.          
           05 OUT-FILLER               PIC X     VALUE SPACES.          
           05 OUT-DELMTR-3             PIC X     VALUE SPACES.          
           05 OUT-LOC-OFF              PIC X(3)  VALUE SPACES.          
           05 OUT-DELMTR-4             PIC X     VALUE SPACES.          
A05460     05 OUT-CUST-NAME            PIC X(49) VALUE SPACES.          
           05 OUT-DELMTR-5             PIC X     VALUE SPACES.          
           05 OUT-CLASS                PIC X(3)  VALUE SPACES.          
           05 OUT-DELMTR-6             PIC X     VALUE SPACES.          
           05 OUT-RATE                 PIC X(3)  VALUE SPACES.          
           05 OUT-DELMTR-7             PIC X     VALUE SPACES.          
           05 OUT-DIV                  PIC XX    VALUE SPACES.          
           05 OUT-DELMTR-8             PIC X     VALUE SPACES.          
           05 OUT-GATE-ID              PIC X(7)  VALUE SPACES.          
           05 OUT-DELMTR-9             PIC X     VALUE SPACES.          
           05 OUT-GATE-DESC            PIC X(25) VALUE SPACES.          
A05460     05 OUT-FILLER               PIC X(7)  VALUE SPACES.          
           05 OUT-DELMTR-10            PIC X     VALUE SPACES.          
      *                                                                         
A05460 01 WS-HEADER-RECORD.                                             
A05460     05 HD-ACCT-NO               PIC X(10) VALUE 'ACCOUNT   '.    
A05460     05 FILLER                   PIC X(3)  VALUE SPACES.          
HEX01      05 HD-DEL-1                 PIC X     VALUE X'09'.           
A05460     05 FILLER                   PIC X     VALUE SPACES.          
A05460     05 HD-METER-NO              PIC X(5)  VALUE 'METER'.         
A05460     05 FILLER                   PIC X(3)  VALUE SPACES.          
HEX01      05 HD-DEL-2                 PIC X     VALUE X'09'.           
A05460     05 HD-FT                    PIC XX    VALUE 'FT'.            
HEX01      05 HD-DEL-3                 PIC X     VALUE X'09'.           
A05460     05 HD-LOC-OFF               PIC X(3)  VALUE 'LOC'.           
HEX01      05 HD-DEL-4                 PIC X     VALUE X'09'.           
A05460     05 HD-CUST-NAME             PIC X(31)                        
A05460                   VALUE 'CUSTOMER NAME / SERVICE ADDRESS'.       
A05460     05 FILLER                   PIC X(18) VALUE SPACES.          
HEX01      05 HD-DEL-5                 PIC X     VALUE X'09'.           
A05460     05 HD-CLASS                 PIC XXX   VALUE 'CLS'.           
HEX01      05 HD-DEL-6                 PIC X     VALUE X'09'.           
A05460     05 HD-RATE                  PIC XXX   VALUE 'RTE'.           
HEX01      05 HD-DEL-7                 PIC X     VALUE X'09'.           
A05460     05 HD-GATE-DIV              PIC XX    VALUE 'DV'.            
HEX01      05 HD-DEL-8                 PIC X     VALUE X'09'.           
A05460     05 HD-GATE-ID               PIC X(7)  VALUE 'GATE ID'.       
HEX01      05 HD-DEL-9                 PIC X     VALUE X'09'.           
A05460     05 HD-GATE-DESC             PIC X(16)                        
A05460                               VALUE 'GATE DESCRIPTION'.          
A05460     05 FILLER                   PIC X(16) VALUE SPACES.          
HEX01      05 HD-DEL-10                PIC X     VALUE X'09'.           
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-HONKED        PIC X     VALUE 'N'.            
      *                                                                         
       01 WS-SWITCH.                                                    
           05  WS-FCA61A-STATUS         PIC XX   .                      
               88 FCA61A-SUCCESSFUL               VALUE '00'.           
           05  WS-FCA61B-STATUS         PIC XX   .                      
               88 FCA61B-SUCCESSFUL               VALUE '00'.           
           05  WS-FCA61C-STATUS         PIC XX   .                      
               88 FCA61C-SUCCESSFUL               VALUE '00'.           
      *                                                                         
A05460 01 WS-OUT-ADDR.                                                  
A05460     05 WS-OUT-ADDR-2            PIC X(40) VALUE SPACES.          
A05460     05 FILLER                   PIC X(4)  VALUE SPACES.          
A05460     05 WS-OUT-ZIPCODE           PIC X(5)  VALUE SPACES.          
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-PAGE-NO               PIC 9(6)  VALUE ZEROS.          
           05  WS-FIRST                 PIC X     VALUE 'Y'.            
           05  WS-FIRST-TYM             PIC X     VALUE 'Y'.            
           05  WS-CHECK                 PIC X     VALUE 'N'.            
      *                                                                         
A05460 01 WS-HEADER-DATE.                                               
A05460     05 WS-HEADER-DATE05.                                         
A05460        10  WS-DATE-X1           PIC X(11) VALUE 'RUN DATE = '.   
A05460        10  WS-CURRENT-DATE      PIC X(10) VALUE SPACES.          
A05460        10  WS-DATE-X2           PIC X(19) VALUE SPACES.          
      *                                                                         
       01  WS-NF-CITY-STATE.                                            
           05  WS-NF-CITY               PIC X(26).                      
           05  FILLER                   PIC X.                          
           05  WS-NF-STATE              PIC XX.                         
           05  FILLER                   PIC X.                          
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-TITLE-LIT1            PIC X(40)                       
               VALUE 'PLEASE CORRECT FARMTAP CODE OR GATE ID  '.        
           05  WS-TITLE-LIT3            PIC X(40)                       
               VALUE 'PLEASE CORRECT THE INVALID GATE ID      '.        
           05  WS-FULL-NAME617          PIC X(90) VALUE SPACES.         
           05  WS-FULL-NAMEX            PIC X(40) VALUE SPACES.         
           05  WS-FIRST-TIME-SW         PIC X.                          
           05  WS-WORK-ADDRESS          PIC X(82) VALUE SPACES.         
           05  WS-COUNT                 PIC S9(3)V  COMP-3 VALUE 0.     
           05  WS-NBR-INPUT             PIC 9(7)  VALUE 0.              
           05  WS-NBR-OUTPUT            PIC 9(7)  VALUE 0.              
           05  WS-HOUSE-SPLIT           PIC X(15) JUSTIFIED RIGHT.      
           05  WS-STREET-SPLIT          PIC X(55).                      
           05  WS-HOUSE-CHK             PIC X(15).                      
           05  WS-HOUSE-CHKR REDEFINES WS-HOUSE-CHK.                    
               07  WS-HOUSE-BF          PIC X     OCCURS 15 TIMES.      
           05  WS-HOUSE-FIX             PIC X(15).                      
           05  WS-HOUSE-FIXR REDEFINES WS-HOUSE-FIX.                    
               07  WS-HOUSE-AF          PIC X     OCCURS 15 TIMES.      
           05  WS-NBR-INX               PIC 99    VALUE 0.              
           05  WS-NBR-INX2              PIC 99    VALUE 0.              
           05  WS-B-ADDR-PREFIX-1       PIC X(3).                       
           05  WS-B-ADDR-PREFIX-2       PIC XX.                         
           05  WS-B-STREET-LOCATION-1   PIC X(4).                       
           05  WS-B-STREET-LOCATION-2   PIC X(11).                      
           05  WS-B-STREET-SUFFIX       PIC X(4).                       
           05  WS-B-ADDR-SUFFIX         PIC XX.                         
           05  WS-RPT1-LIT              PIC X(8)  VALUE 'PCSR6171'.     
           05  WS-RPT2-LIT              PIC X(8)  VALUE 'PCSR6172'.     
           05  WS-RPT3-LIT              PIC X(8)  VALUE 'PCSR6173'.     
           05  WS-RPT1-TITLE            PIC X(40)                       
                 VALUE 'FARMTAP GATE CODE ACCTS W/O FARMTAP CODE'.      
           05  WS-RPT2-TITLE            PIC X(40)                       
                 VALUE 'ACCT - FARMTAP CD NOT IN FARMTAP GATE ID'.      
           05  WS-RPT3-TITLE            PIC X(40)                       
                 VALUE 'ACCOUNTS WITH INVALID GATE CODES        '.      
           05  WS-0-GATE                PIC X(5)  VALUE '00000'.        
           05  WS-0-NBR                 PIC X(7)  VALUE '0000000'.      
           05  WS-DO-REPORT             PIC X     VALUE 'N'.            
           05  WS-REPORT1               PIC X     VALUE 'N'.            
           05  WS-REPORT2               PIC X     VALUE 'N'.            
           05  WS-REPORT3               PIC X     VALUE 'N'.            
           05  WS-NODATA1               PIC X     VALUE 'Y'.            
           05  WS-NODATA2               PIC X     VALUE 'Y'.            
           05  WS-NODATA3               PIC X     VALUE 'Y'.            
           05  WS-FARM-GATE             PIC X     VALUE SPACES.         
           05  WS-FARM                  PIC X     VALUE 'F'.            
           05  WS-PROGRAM-NAME          PIC X(8)  VALUE 'PCSRP617'.     
           05  WS-PGRMNAME              PIC X(8)  VALUE 'PCSRP617'.     
           05  WS-NO-DATA               PIC X(20)                       
                            VALUE 'NO DATA FOR THIS RUN'.               
           05  WS-NO-NAME               PIC X(7)  VALUE 'NO NAME'.      
           05  WS-SAVE-SQLCODE          PIC S9(4) COMP VALUE 0.         
HEX01      05  WS-DELIM                 PIC X     VALUE X'09'.          
           05  WS-NULL-INDR1            PIC S9(2) COMP VALUE 0.         
           05  WS-NULL-INDR2            PIC S9(2) COMP VALUE 0.         
           05  WS-NULL-IND1             PIC S9(2) COMP VALUE 0.         
           05  WS-NULL-IND2             PIC S9(2) COMP VALUE 0.         
           05  WS-HOUSE-NO-NM           PIC X(7)  VALUE SPACES.         
           05  WS-CNT                   PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT1                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT2                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT3                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT4                  PIC 9(7)  VALUE ZEROES.         
           05  WS-UTIL-TYPE             PIC XX    VALUE SPACES.         
           05  WS-DOT                   PIC X     VALUE '.'.            
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE 0.              
           05  WS-START-POS1            PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-START-POS2            PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-LEN                   PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-ADDR-LEN              PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-ONE                   PIC S9(2)V VALUE 1 COMP-3.      
           05  WS-ADDRESS-LENGTH1       PIC S9(2)V VALUE 50 COMP-3.     
           05  WS-ADDRESS-LENGTH2       PIC S9(2)V VALUE 37 COMP-3.     
           05  WS-LENGTH                PIC S9(2)V VALUE 7 COMP-3.      
           05  WS-ZEROS                 PIC 9(7) VALUE ZEROES.          
           05  WS-HOUSE-NBR             PIC 9(7) VALUE ZEROES.          
           05  WS-HOUSE-NUMBERX            REDEFINES                    
               WS-HOUSE-NBR             PIC X(7).                       
           05  WS-TYPE-SVC              PIC X     VALUE SPACES.         
           05  WS-PREMISE-NO            PIC S9(6)V VALUE 0 COMP-3.      
           05  WS-ADDRESS-1             PIC X(50) VALUE SPACES.         
           05  WS-ADDRESS-2             PIC X(40) VALUE SPACES.         
           05  WS-PREV-ACCT             PIC 9(13) VALUE ZEROES.         
           05  WS-FMT-ACCT              PIC 9999999999999 VALUE ZEROES. 
           05  WS-MTR-RD-INST           PIC X(14) VALUE SPACES.         
           05  WS-DBA-NAME              PIC X(70) VALUE SPACES.         
           05  WS-SPACES                PIC X     VALUE ' '.            
           05  WS-COMPANY-NO            PIC XX    VALUE '01'.           
           05  WS-PROGRAM-NAME          PIC X(10) VALUE 'PCSCA204  '.   
           05  WS-CMND-CODE             PIC X(4)  VALUE 'PARM'.         
           05  WS-Y                     PIC X     VALUE 'Y'.            
           05  WS-N                     PIC X     VALUE 'N'.            
           05  WS-SVC-ADDR-LINE-1       PIC X(50) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-2       PIC X(37) VALUE SPACES.         
           05  WS-FMT-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-FMT-ADDR-LINE-3       PIC X(36) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-ZIP-CODE-SADDR        PIC X(5)  VALUE SPACES.         
           05  WS-ZIP-CD-PL-FOUR-SADDR  PIC X(4)  VALUE SPACES.         
           05  WS-SVC-ZIP-PLUS-4        PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-CITY-GATE.                                                 
           05  WS-CITY-GATE-2           PIC XX.                         
           05  WS-CITY-GATE-5           PIC X(5).                       
      *                                                                         
       01 WS-FMT-NAME.                                                  
           05  WS-FNAME                 PIC X(15) VALUE SPACES.         
           05  WS-FILLER-1              PIC X     VALUE SPACES.         
           05  WS-MNAME                 PIC X     VALUE SPACES.         
           05  WS-FILLER-2              PIC X     VALUE SPACES.         
           05  WS-LNAME                 PIC X(19) VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      *CURSOR FOR REVENUE CLASS - MAIN CURSOR                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE GET_DET CURSOR FOR                                 
               SELECT PR.LOCAL_OFFICE                                   
                     ,PR.PREMISE_NO                                     
                     ,CH.ACCOUNT_NO                                     
                     ,PR.ADDRESS_ID                                     
                     ,PR.CITY_GATE_ID                                   
                     ,XO.FARM_TAP_IND                                   
                     ,UT.CODE_UTIL_TYPE                                 
                     ,CU.NAME_ID                                        
                     ,MAX(UT.CODE_REVENUE_CLASS)                        
                     ,MAX(UT.RATE_PLAN_NO)                              
                     ,MAX(MN.METER_NO)                                  
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                     ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                     ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                     ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               

                  INNER JOIN (
                   SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END               
                      ,IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') ))) MFAAUXI_0         
                      ,MAX(CH1.DATE_UTIL_SVC_STRT) MFAAUXI_1
                      ,CH1.PREMISE_NO MFAAUXI_2
            FROM CSS_CUST_PREM_HIST CH1 WITH(READUNCOMMITTED)
            GROUP BY CH1.PREMISE_NO
                 ) MFAAUXI
                   ON MFAAUXI_0 = COALESCE(CH.DATE_UTIL_SVC_END                 
                      , IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') )) AND 
           MFAAUXI_1 = CH.DATE_UTIL_SVC_STRT
                   AND MFAAUXI.MFAAUXI_2 = CH.PREMISE_NO
                     ,CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED)                
                     ,CSS_PREM_GAS_LINE Y0 WITH(READUNCOMMITTED)                
                 WHERE PR.PREMISE_NO     = UT.PREMISE_NO
                       AND MN.CODE_METER_STATUS <> 'K'
                       AND PR.PREMISE_NO     = CH.PREMISE_NO
                       AND PR.COMPANY_NO     = '01'
                       AND PR.COMPANY_NO     = UT.COMPANY_NO
                       AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO
                       AND CH.ACCOUNT_NO     = MN.ACCOUNT_NO
                       AND CH.ACCOUNT_NO     = AT.ACCOUNT_NO
                       AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO
                       AND UT.IC_NO          = MN.IC_NO
                       AND UT.CODE_UTIL_TYPE = 'G'
                       AND MN.CODE_UTIL_TYPE = 'G'
                       AND PR.PREMISE_NO     = Y0.PREMISE_NO
                       AND Y0.SERVICE_NO     = XO.SERVICE_NO
                       AND XO.SERV_LINE_STAT_FL IN  ('A', 'T', 'U')             
                  GROUP BY PR.LOCAL_OFFICE                              
                          ,PR.PREMISE_NO                                
                          ,CH.ACCOUNT_NO                                
                          ,PR.ADDRESS_ID                                
                          ,PR.CITY_GATE_ID                              
                          ,XO.FARM_TAP_IND                              
                          ,UT.CODE_UTIL_TYPE                            
                          ,CU.NAME_ID                                   
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ059
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_DET CURSOR FOR                                         
MFA-TR*        SELECT PR.LOCAL_OFFICE                                           
MFA-TR*              ,PR.PREMISE_NO                                             
MFA-TR*              ,CH.ACCOUNT_NO                                             
MFA-TR*              ,PR.ADDRESS_ID                                             
MFA-TR*              ,PR.CITY_GATE_ID                                           
MFA-TR*              ,XO.FARM_TAP_IND                                           
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,CU.NAME_ID                                                
MFA-TR*              ,MAX(UT.CODE_REVENUE_CLASS)                                
MFA-TR*              ,MAX(UT.RATE_PLAN_NO)                                      
MFA-TR*              ,MAX(MN.METER_NO)                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*              ,CSS_CUSTOMER CU                                           
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*              ,CSS_CUST_PREM_HIST CH                                     
MFA-TR*              ,CSS_GAS_SERV_LINE XO                                      
MFA-TR*              ,CSS_PREM_GAS_LINE Y0                                      
MFA-TR*          WHERE PR.PREMISE_NO     = UT.PREMISE_NO                        
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*            AND PR.PREMISE_NO     = CH.PREMISE_NO                        
MFA-TR*            AND PR.COMPANY_NO     = '01'                                 
MFA-TR*            AND PR.COMPANY_NO     = UT.COMPANY_NO                        
MFA-TR*            AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO                        
MFA-TR*            AND CH.ACCOUNT_NO     = MN.ACCOUNT_NO                        
MFA-TR*            AND CH.ACCOUNT_NO     = AT.ACCOUNT_NO                        
MFA-TR*            AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                       
MFA-TR*            AND UT.IC_NO          = MN.IC_NO                             
MFA-TR*            AND UT.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND MN.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND PR.PREMISE_NO     = Y0.PREMISE_NO                        
MFA-TR*            AND Y0.SERVICE_NO     = XO.SERVICE_NO                        
MFA-TR*            AND XO.SERV_LINE_STAT_FL IN  ('A', 'T', 'U')                 
MFA-TR*            AND ( COALESCE(CH.DATE_UTIL_SVC_END                          
MFA-TR*               , DATE('9999-12-31'))                                     
MFA-TR*               , CH.DATE_UTIL_SVC_STRT) IN (                             
MFA-TR*         SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END                       
MFA-TR*               ,DATE('9999-12-31')))                                     
MFA-TR*               ,MAX(CH1.DATE_UTIL_SVC_STRT)                              
MFA-TR*            FROM CSS_CUST_PREM_HIST CH1                                  
MFA-TR*           WHERE CH1.PREMISE_NO = CH.PREMISE_NO                          
MFA-TR*           GROUP BY CH1.PREMISE_NO)                                      
MFA-TR*           GROUP BY PR.LOCAL_OFFICE                                      
MFA-TR*                   ,PR.PREMISE_NO                                        
MFA-TR*                   ,CH.ACCOUNT_NO                                        
MFA-TR*                   ,PR.ADDRESS_ID                                        
MFA-TR*                   ,PR.CITY_GATE_ID                                      
MFA-TR*                   ,XO.FARM_TAP_IND                                      
MFA-TR*                   ,UT.CODE_UTIL_TYPE                                    
MFA-TR*                   ,CU.NAME_ID                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
A05460     PERFORM 7000-SELECT-CURRENT THRU 7000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS-MAIN-CSR THRU 2000-EXIT.                
      *                                                                         
           IF WS-NODATA1 = WS-Y                                         
              MOVE WS-NO-DATA TO OUT-CUST-NAME                          
              WRITE FIORP61A FROM WS-DETAIL-RECORD                      
           END-IF.                                                      
           IF WS-NODATA2 = WS-Y                                         
              MOVE WS-NO-DATA TO OUT-CUST-NAME                          
              WRITE FIORP61B FROM WS-DETAIL-RECORD                      
           END-IF.                                                      
           IF WS-NODATA3 = WS-Y                                         
              MOVE WS-NO-DATA TO OUT-CUST-NAME                          
              WRITE FIORP61C FROM WS-DETAIL-RECORD                      
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * INITIALIZE AND OPEN FILE                                     *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSRP61A-FILE                                    
                       FCSRP61B-FILE                                    
                       FCSRP61C-FILE.                                   
      *                                                                         
           IF NOT FCA61A-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP617 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSRP61A-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA61A-STATUS            
               DISPLAY '**  PROCESSING TERMINATED           **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIORP61A.                                         
      *                                                                         
           IF NOT FCA61B-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP617 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSRP61B-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA61B-STATUS            
               DISPLAY '**  PROCESSING TERMINATED           **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIORP61B.                                         
      *                                                                         
           IF NOT FCA61C-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP617 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSRP61C-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA61C-STATUS            
               DISPLAY '**  PROCESSING TERMINATED           **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIORP61C.                                         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS MAIN CURSOR                                          *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 8100-WRITE-OUTFILE-HEADER THRU 8100-EXIT.            
      *                                                                         
           PERFORM 7100-OPEN-MAIN-CSR THRU 7100-EXIT.                   
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR THRU 7200-EXIT.                  
      *                                                                         
           PERFORM 2010-ACCT-ADDR-PROCESS THRU 2010-EXIT                
                UNTIL WS-ALL-ROWS-HONKED = WS-Y.                        
      *                                                                         
           PERFORM 7300-CLOSE-MAIN-CSR THRU  7300-EXIT.                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET NAME AND ADDRESS                                       **          
      ****************************************************************          
      *                                                                         
       2010-ACCT-ADDR-PROCESS.                                          
      *                                                                         
           MOVE PR-CITY-GATE-ID TO WS-CITY-GATE.                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-N TO WS-FARM-GATE                                 
              MOVE WS-N TO WS-REPORT1                                   
                           WS-REPORT2                                   
                           WS-REPORT3                                   
                           WS-DO-REPORT                                 
              PERFORM 7475-GET-GATE THRU 7475-EXIT                      
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-FARM-GATE = WS-Y                                 
                    IF XO-FARM-TAP-IND = WS-N OR SPACES                 
                       IF WS-CITY-GATE-5 = WS-0-GATE                    
                          MOVE WS-Y TO WS-REPORT1                       
                                       WS-DO-REPORT                     
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    IF XO-FARM-TAP-IND = WS-Y                           
                       MOVE WS-Y TO WS-REPORT2                          
                                    WS-DO-REPORT                        
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-Y TO WS-REPORT3                                
                              WS-DO-REPORT                              
              END-IF                                                    
      *                                                                         
              IF WS-DO-REPORT  = WS-Y                                   
                 MOVE CU-NAME-ID TO DQ-NAME-ID                          
                 PERFORM 7788-SELECT-CUSTOMER-NAME THRU 7788-EXIT       
                 MOVE SPACES TO WS-FORMATTED-NAME                       
                                WS-FMT-NAME                             
                                WS-FULL-NAMEX                           
                 IF SQLCODE = 0                                         
                    IF DQ-LAST-NAME = SPACES                            
                       MOVE DQ-FULL-NAME TO WS-FMT-LAST-NAME            
                    ELSE                                                
                       MOVE DQ-FIRST-NAME TO WS-FMT-FIRST-NAME          
                       MOVE DQ-MIDDLE-NAME TO WS-FMT-MIDDLE-NAME        
                       MOVE DQ-LAST-NAME TO WS-FMT-LAST-NAME            
                       MOVE DQ-TITLE-SUFFIX-1                           
                                   TO WS-FMT-TITLE-SUFFIX-1             
                       MOVE DQ-TITLE-SUFFIX-2                           
                                   TO WS-FMT-TITLE-SUFFIX-2             
                    END-IF                                              
                    IF WS-FORMATTED-NAME > SPACES                       
                       MOVE SPACES TO WS-FULL-NAME617                   
                                      WS-EMB-INPUT                      
                                      WS-CMP-TABLE                      
                       MOVE WS-FORMATTED-NAME TO WS-FULL-NAME617        
                       PERFORM 2666-REMOVE-SPACES THRU 2666-EXIT        
                       MOVE WS-FULL-NAME617   TO WS-FULL-NAMEX          
                    ELSE                                                
                       MOVE 'NOT FOUND' TO WS-FULL-NAMEX                
                    END-IF                                              
                 ELSE                                                   
                    MOVE SPACES TO WS-FORMATTED-NAME                    
                    MOVE 'NOT FOUND' TO WS-FULL-NAMEX                   
                 END-IF                                                 
      *                                                                         
                 MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID                    
                 PERFORM 7777-SELECT-PREMISE-ADDRESS THRU 7777-EXIT     
                 IF SQLCODE = 0                                         
                    PERFORM 2400-PREP-PREMISE-ADDRESS THRU 2400-EXIT    
                 END-IF                                                 
      *                                                                         
                 PERFORM 2900-FORMAT-OUTPUT THRU 2900-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-DETAIL-RECORD.                                 
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR THRU 7200-EXIT.                  
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PREP PREMISE ADDRESS - GET RID OF SPACES                     *          
      ****************************************************************          
      *                                                                         
       2400-PREP-PREMISE-ADDRESS.                                       
      *                                                                         
           MOVE SPACES TO WS-EMB-INPUT                                  
                          WS-CMP-TABLE                                  
                          WS-ADDRESS                                    
                          WS-FORMATTED-ADDRESS.                         
      *                                                                         
           MOVE DY-STREET-NAME        TO WS-NAME-STREET.                
           MOVE DY-HOUSE-NO           TO WS-HOUSE-NO.                   
           MOVE DY-ADDR-PREFIX-1      TO WS-ADDR-PREFIX-1               
                                         WS-B-ADDR-PREFIX-1.            
           MOVE DY-ADDR-PREFIX-2      TO WS-ADDR-PREFIX-2               
                                         WS-B-ADDR-PREFIX-2.            
           MOVE DY-STREET-SUFFIX      TO WS-STREET-SUFFIX               
                                         WS-B-STREET-SUFFIX.            
           MOVE DY-STREET-LOCATION-1  TO WS-STREET-LOCATION-1           
                                         WS-B-STREET-LOCATION-1.        
           MOVE DY-STREET-LOCATION-2  TO WS-STREET-LOCATION-2           
                                         WS-B-STREET-LOCATION-2.        
ACT085     MOVE DY-ADDR-SUFFIX        TO WS-ADDRESS-SUFFIX              
ACT085                                   WS-B-ADDR-SUFFIX.              
           MOVE WS-STREET-ADDRESS     TO WS-WORK-ADDRESS.               
           MOVE WS-WORK-ADDRESS       TO WS-EMB-INPUT.                  
ACT085     MOVE +84 TO WS-EMB-LENG.                                     
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE          TO WS-FMT-ADDR-STREET.            
           MOVE DY-ADDRESS-OVERFLOW   TO WS-FMT-ADDR-OVERFLOW.          
           MOVE DY-ZIP-CODE           TO WS-ZIP-CODE.                   
           MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-ZIP-PLUS-4.                 
           MOVE A4-STATE              TO WS-STATE                       
                                         WS-NF-STATE.                   
           MOVE A4-TOWN               TO WS-CITY                        
                                         WS-NF-CITY.                    
      *                                                                         
           MOVE SPACES                TO WS-EMB-INPUT                   
                                         WS-CMP-TABLE.                  
           MOVE WS-NF-CITY-STATE      TO WS-EMB-INPUT.                  
           MOVE +30 TO WS-EMB-LENG.                                     
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE          TO WS-FMT-CITY-STATE.             
      *                                                                         
           MOVE WS-ZIP-CODE           TO WS-FMT-ZIP-CODE.               
           MOVE WS-ZIP-PLUS-4         TO WS-FMT-ZIP-PLUS-4.             
      *                                                                         
           IF WS-FORMATTED-ADDRESS = SPACES                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FMT-ADDR-STREET    TO WS-PR-STREET                
              MOVE WS-FMT-ADDR-OVERFLOW  TO WS-PR-ADDR-OVERFLOW         
              MOVE WS-FMT-CITY-STATE     TO WS-PR-ADDR-CITY-STATE       
              MOVE WS-FMT-CITY-STATE-ZIP TO WS-PR-ADDR-CITY-STATE-ZIP   
              MOVE WS-FMT-ZIP            TO WS-PR-ADDR-ZIP              
           END-IF.                                                      
      *                                                                         
           MOVE +5                       TO WS-NBR-INX                  
                                            WS-NBR-INX2.                
           MOVE SPACES                   TO WS-HOUSE-CHK                
                                            WS-HOUSE-FIX.               
           MOVE WS-HOUSE-NO              TO WS-HOUSE-CHK.               
           PERFORM 2700-DELETE-HOUSE-SPACES THRU 2700-EXIT.             
           INSPECT WS-HOUSE-FIX REPLACING ALL ' ' BY '0'.               
           MOVE WS-HOUSE-FIX          TO WS-HOUSE-SPLIT.                
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * REMOVES SPACES FROM THE NAME.                                *          
      ****************************************************************          
      *                                                                         
       2666-REMOVE-SPACES.                                              
      *                                                                         
           MOVE WS-FULL-NAME617 TO WS-EMB-INPUT.                        
           MOVE +90 TO WS-EMB-LENG.                                     
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE TO WS-FULL-NAME617.                        
      *                                                                         
       2666-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * REMOVE TRAILING SPACES FROM THE HOUSE NUMBER.                *          
      ****************************************************************          
      *                                                                         
       2700-DELETE-HOUSE-SPACES.                                        
      *                                                                         
           IF WS-NBR-INX = 0                                            
              GO TO 2700-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF WS-HOUSE-BF (WS-NBR-INX) < '0'                            
               SUBTRACT +1 FROM WS-NBR-INX                              
               GO TO 2700-DELETE-HOUSE-SPACES                           
           END-IF.                                                      
      *                                                                         
           MOVE WS-HOUSE-BF (WS-NBR-INX) TO WS-HOUSE-AF (WS-NBR-INX2).  
           SUBTRACT +1 FROM WS-NBR-INX WS-NBR-INX2.                     
           GO TO 2700-DELETE-HOUSE-SPACES.                              
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FORMAT OUTPUT RECORD.                                      **          
      ****************************************************************          
      *                                                                         
       2900-FORMAT-OUTPUT.                                              
      *                                                                         
           MOVE WS-DELIM TO OUT-DELMTR-1                                
                            OUT-DELMTR-2                                
                            OUT-DELMTR-3                                
                            OUT-DELMTR-4                                
                            OUT-DELMTR-5                                
                            OUT-DELMTR-6                                
                            OUT-DELMTR-7                                
                            OUT-DELMTR-8                                
                            OUT-DELMTR-9                                
                            OUT-DELMTR-10.                              
      *                                                                         
           MOVE PR-LOCAL-OFFICE             TO OUT-LOC-OFF.             
           MOVE CH-ACCOUNT-NO               TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO OUT-ACCOUNT.             
           MOVE MN-METER-NO                 TO OUT-METER-NO.            
           MOVE PR-CITY-GATE-ID             TO OUT-GATE-ID.             
           MOVE C0-GAS-DISTRIB-DIV          TO OUT-DIV.                 
           MOVE C0-CITY-GATE-DESC           TO OUT-GATE-DESC.           
           MOVE PR-LOCAL-OFFICE             TO OUT-LOC-OFF.             
           MOVE XO-FARM-TAP-IND             TO OUT-FARM-TAP.            
           MOVE UT-RATE-PLAN-NO             TO OUT-RATE.                
           MOVE UT-CODE-REVENUE-CLASS       TO OUT-CLASS.               
           MOVE WS-FULL-NAMEX               TO OUT-CUST-NAME.           
      *                                                                         
           IF WS-REPORT1 = WS-Y                                         
              PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT         
              MOVE WS-N TO WS-NODATA1                                   
           END-IF.                                                      
      *                                                                         
           IF WS-REPORT2 = WS-Y                                         
              PERFORM 8201-WRITE-OUTFILE-DETAILS THRU 8201-EXIT         
              MOVE WS-N TO WS-NODATA2                                   
           END-IF.                                                      
      *                                                                         
           IF WS-REPORT3 = WS-Y                                         
              PERFORM 8202-WRITE-OUTFILE-DETAILS THRU 8202-EXIT         
              MOVE WS-N TO WS-NODATA3                                   
           END-IF.                                                      
      *                                                                         
A05460     INITIALIZE WS-DETAIL-RECORD.                                 
A05460     MOVE WS-DELIM TO OUT-DELMTR-1                                
A05460                      OUT-DELMTR-2                                
A05460                      OUT-DELMTR-3                                
A05460                      OUT-DELMTR-4                                
A05460                      OUT-DELMTR-5                                
A05460                      OUT-DELMTR-6                                
A05460                      OUT-DELMTR-7                                
A05460                      OUT-DELMTR-8                                
A05460                      OUT-DELMTR-9                                
A05460                      OUT-DELMTR-10.                              
A05460     MOVE WS-PR-STREET                TO OUT-CUST-NAME.           
      *                                                                         
A05460     IF WS-REPORT1 = WS-Y                                         
A05460        PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT         
A05460     END-IF.                                                      
      *                                                                         
A05460     IF WS-REPORT2 = WS-Y                                         
A05460        PERFORM 8201-WRITE-OUTFILE-DETAILS THRU 8201-EXIT         
A05460     END-IF.                                                      
      *                                                                         
A05460     IF WS-REPORT3 = WS-Y                                         
A05460        PERFORM 8202-WRITE-OUTFILE-DETAILS THRU 8202-EXIT         
A05460     END-IF.                                                      
      *                                                                         
A05460     MOVE WS-PR-ADDR-CITY-STATE       TO WS-OUT-ADDR-2.           
A05460     MOVE WS-PR-ADDR-ZIP-CODE         TO WS-OUT-ZIPCODE.          
      *                                                                         
A05460     INITIALIZE WS-DETAIL-RECORD.                                 
A05460     MOVE WS-DELIM TO OUT-DELMTR-1                                
A05460                      OUT-DELMTR-2                                
A05460                      OUT-DELMTR-3                                
A05460                      OUT-DELMTR-4                                
A05460                      OUT-DELMTR-5                                
A05460                      OUT-DELMTR-6                                
A05460                      OUT-DELMTR-7                                
A05460                      OUT-DELMTR-8                                
A05460                      OUT-DELMTR-9                                
A05460                      OUT-DELMTR-10.                              
A05460     MOVE WS-OUT-ADDR                 TO OUT-CUST-NAME.           
      *                                                                         
A05460     IF WS-REPORT1 = WS-Y                                         
A05460        PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT         
A05460        WRITE FIORP61A FROM WS-BLANK-RECORD                       
           END-IF.                                                      
      *                                                                         
A05460     IF WS-REPORT2 = WS-Y                                         
A05460        PERFORM 8201-WRITE-OUTFILE-DETAILS THRU 8201-EXIT         
A05460        WRITE FIORP61B FROM WS-BLANK-RECORD                       
A05460     END-IF.                                                      
      *                                                                         
A05460     IF WS-REPORT3 = WS-Y                                         
A05460        PERFORM 8202-WRITE-OUTFILE-DETAILS THRU 8202-EXIT         
A05460        WRITE FIORP61C FROM WS-BLANK-RECORD                       
A05460     END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  6010-REDUCE-EMBEDDED-SPACES                                 *          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
A05460** GET CURRENT DATE FOR HEADER RECORD                         **          
A05460****************************************************************          
      *                                                                         
A05460 7000-SELECT-CURRENT.                                             
      *                                                                         
A05460     EXEC SQL                                                     
A05460        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05460        CONTINUE                                                  
A05460     ELSE                                                         
A05460        DISPLAY '******** PCSRP617 ABORT ******'                  
A05460        DISPLAY '** 7000-SELECT-CURRENT      **'                  
A05460        DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE          
A05460        DISPLAY '** PROCESSING TERMINATED    **'                  
A05460        DISPLAY '******************************'                  
A05460        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05460     END-IF.                                                      
      *                                                                         
A05460 7000-EXIT.                                                       
A05460     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN MAIN CURSOR                                           **          
      ****************************************************************          
      *                                                                         
       7100-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_DET                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP617 ABORT *****'                   
              DISPLAY '** OPEN GET DETAILS ERROR  **'                   
              DISPLAY '** 7100-OPEN-MAIN-CSR      **'                   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED   **'                   
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7200-FETCH-GET-MAIN                                        **          
      ****************************************************************          
      *                                                                         
       7200-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_DET                                             
               INTO  :PR-LOCAL-OFFICE                                   
                    ,:PR-PREMISE-NO                                     
                    ,:CH-ACCOUNT-NO                                     
                    ,:PR-ADDRESS-ID                                     
                    ,:PR-CITY-GATE-ID                                   
                    ,:XO-FARM-TAP-IND                                   
                    ,:UT-CODE-UTIL-TYPE                                 
                    ,:CU-NAME-ID                                        
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:UT-RATE-PLAN-NO                                   
                    ,:MN-METER-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ALL-ROWS-HONKED                        
              ELSE                                                      
                 DISPLAY '******** PCSRP617 ABORT ******'               
                 DISPLAY '**  MAIN CURSOR FETCH ERROR **'               
                 DISPLAY '** 7200-FETCH-MAIN-CSR      **'               
                 DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '** PROCESSING TERMINATED    **'               
                 DISPLAY '******************************'               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7300-CLOSE-MAIN-CSR                                        **          
      ****************************************************************          
      *                                                                         
       7300-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_DET                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP617 ABORT ******'                  
              DISPLAY '** CLOSE MAIN CURSOR ERROR  **'                  
              DISPLAY '** 7300-CLOSE-MAIN-CSR      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET CUSTOMER NAME                                            *          
      ****************************************************************          
      *                                                                         
       7788-SELECT-CUSTOMER-NAME.                                       
      *                                                                         
           EXEC SQL                                                     
                 SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.TITLE_SUFFIX_1,
              DQ.TITLE_SUFFIX_2,
              DQ.FULL_NAME                                    
                 INTO  :DQ-FIRST-NAME                                   
                      ,:DQ-MIDDLE-NAME                                  
                      ,:DQ-LAST-NAME                                    
                      ,:DQ-TITLE-SUFFIX-1                               
                      ,:DQ-TITLE-SUFFIX-2                               
                      ,:DQ-FULL-NAME                                    
                 FROM  CSS_NAME DQ WITH(READUNCOMMITTED)                        
                 WHERE DQ.NAME_ID   = :DQ-NAME-ID                       
                   AND DQ.NAME_TYPE = 'CN'                              
                                             
ACT085                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*                ,DQ.TITLE_SUFFIX_1                                       
MFA-TR*                ,DQ.TITLE_SUFFIX_2                                       
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*          INTO  :DQ-FIRST-NAME                                           
MFA-TR*               ,:DQ-MIDDLE-NAME                                          
MFA-TR*               ,:DQ-LAST-NAME                                            
MFA-TR*               ,:DQ-TITLE-SUFFIX-1                                       
MFA-TR*               ,:DQ-TITLE-SUFFIX-2                                       
MFA-TR*               ,:DQ-FULL-NAME                                            
MFA-TR*          FROM  CSS_NAME DQ                                              
MFA-TR*          WHERE DQ.NAME_ID   = :DQ-NAME-ID                               
MFA-TR*            AND DQ.NAME_TYPE = 'CN'                                      
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7788                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**     PCSRP617 PROCESSING ERROR          **'    
              DISPLAY '**          ABEND IN PARAGRAPH            **'    
              DISPLAY '**      7788-SELECT-CUSTOMER-NAME         **'    
              DISPLAY '** PREMISE-NO = '  PR-PREMISE-NO                 
              DISPLAY '** NAME ID    = '  DQ-NAME-ID                    
              DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE             
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7788-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET GATE TABLE DATA                                        **          
      ****************************************************************          
      *                                                                         
       7475-GET-GATE.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT FARM_TAP_IND                                       
                    ,GAS_DISTRIB_DIV                                    
                    ,CITY_GATE_DESC                                     
                INTO :C0-FARM-TAP-IND                                   
                    ,:C0-GAS-DISTRIB-DIV                                
                    ,:C0-CITY-GATE-DESC                                 
                FROM  CSS_CITY_GATE WITH(READUNCOMMITTED)                       
                WHERE CITY_GATE_ID = :PR-CITY-GATE-ID                   
                AND   LOCAL_OFFICE = :PR-LOCAL-OFFICE                   
                AND   COMPANY_NO   = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FARM_TAP_IND                                               
MFA-TR*             ,GAS_DISTRIB_DIV                                            
MFA-TR*             ,CITY_GATE_DESC                                             
MFA-TR*         INTO :C0-FARM-TAP-IND                                           
MFA-TR*             ,:C0-GAS-DISTRIB-DIV                                        
MFA-TR*             ,:C0-CITY-GATE-DESC                                         
MFA-TR*         FROM  CSS_CITY_GATE                                             
MFA-TR*         WHERE CITY_GATE_ID = :PR-CITY-GATE-ID                           
MFA-TR*         AND   LOCAL_OFFICE = :PR-LOCAL-OFFICE                           
MFA-TR*         AND   COMPANY_NO   = '01'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7475                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF C0-FARM-TAP-IND = WS-FARM                              
                 MOVE WS-Y TO WS-FARM-GATE                              
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A05460           MOVE SPACES TO C0-GAS-DISTRIB-DIV                      
A05460                          C0-CITY-GATE-DESC                       
                 IF XO-FARM-TAP-IND = WS-Y                              
                    MOVE WS-Y TO WS-FARM-GATE                           
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '******** PCSRP617 ABORT *********'            
                 DISPLAY '** GET GATE ID                 **'            
                 DISPLAY '** 7475-GET-GATE               **'            
                 DISPLAY '** CITY_GATE_ID = ' PR-CITY-GATE-ID           
                 DISPLAY '** RETURN CODE  = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '** PROCESSING TERMINATED       **'            
                 DISPLAY '*********************************'            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      * GET PREMISE ADDRESS                                          *          
      ****************************************************************          
      *                                                                         
       7777-SELECT-PREMISE-ADDRESS.                                     
      *                                                                         
           EXEC SQL                                                     
                 SELECT TOP(1) DY.HOUSE_NO,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.STREET_NAME,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.STREET_SUFFIX,
              DY.ADDRESS_OVERFLOW,
              A4.TOWN,
              A4.STATE,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ADDR_SUFFIX                                  
                 INTO  :DY-HOUSE-NO                                     
                      ,:DY-ADDR-PREFIX-1                                
                      ,:DY-ADDR-PREFIX-2                                
                      ,:DY-STREET-NAME                                  
                      ,:DY-STREET-LOCATION-1                            
                      ,:DY-STREET-LOCATION-2                            
                      ,:DY-STREET-SUFFIX                                
                      ,:DY-ADDRESS-OVERFLOW                             
                      ,:A4-TOWN                                         
                      ,:A4-STATE                                        
                      ,:DY-ZIP-CODE                                     
                      ,:DY-ZIP-CODE-PLUS-FOUR                           
ACT085                ,:DY-ADDR-SUFFIX                                  
                 FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                      ,CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                    
                 WHERE DY.ADDRESS_ID = :DY-ADDRESS-ID                   
                   AND DY.ZIP_CODE   = A4.ZIP_CODE                      
                                             
ACT085                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT DY.HOUSE_NO                                             
MFA-TR*                ,DY.ADDR_PREFIX_1                                        
MFA-TR*                ,DY.ADDR_PREFIX_2                                        
MFA-TR*                ,DY.STREET_NAME                                          
MFA-TR*                ,DY.STREET_LOCATION_1                                    
MFA-TR*                ,DY.STREET_LOCATION_2                                    
MFA-TR*                ,DY.STREET_SUFFIX                                        
MFA-TR*                ,DY.ADDRESS_OVERFLOW                                     
MFA-TR*                ,A4.TOWN                                                 
MFA-TR*                ,A4.STATE                                                
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*                ,DY.ZIP_CODE_PLUS_FOUR                                   
MFA-TR*                ,DY.ADDR_SUFFIX                                          
MFA-TR*          INTO  :DY-HOUSE-NO                                             
MFA-TR*               ,:DY-ADDR-PREFIX-1                                        
MFA-TR*               ,:DY-ADDR-PREFIX-2                                        
MFA-TR*               ,:DY-STREET-NAME                                          
MFA-TR*               ,:DY-STREET-LOCATION-1                                    
MFA-TR*               ,:DY-STREET-LOCATION-2                                    
MFA-TR*               ,:DY-STREET-SUFFIX                                        
MFA-TR*               ,:DY-ADDRESS-OVERFLOW                                     
MFA-TR*               ,:A4-TOWN                                                 
MFA-TR*               ,:A4-STATE                                                
MFA-TR*               ,:DY-ZIP-CODE                                             
MFA-TR*               ,:DY-ZIP-CODE-PLUS-FOUR                                   
MFA-TR*               ,:DY-ADDR-SUFFIX                                          
MFA-TR*          FROM  CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_ZIP_CODE A4                                          
MFA-TR*          WHERE DY.ADDRESS_ID = :DY-ADDRESS-ID                           
MFA-TR*            AND DY.ZIP_CODE   = A4.ZIP_CODE                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7777                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**     PCSCA420 PROCESSING ERROR          **'    
              DISPLAY '**          ABEND IN PARAGRAPH            **'    
              DISPLAY '**     7777-SELECT-PREMISE-ADDRESS        **'    
              DISPLAY '** PREMISE-NO = '  PR-PREMISE-NO                 
              DISPLAY '** ADDRESS-ID = '  DY-ADDRESS-ID                 
              DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE             
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7777-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE HEADER RECORD                              **          
      ****************************************************************          
      *                                                                         
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                         
           MOVE WS-RPT1-LIT   TO OUT-ACCOUNT.                           
           MOVE WS-RPT1-TITLE TO OUT-CUST-NAME.                         
           WRITE FIORP61A FROM WS-DETAIL-RECORD.                        
           MOVE SPACES        TO OUT-ACCOUNT.                           
           MOVE WS-TITLE-LIT1 TO OUT-CUST-NAME.                         
           WRITE FIORP61A FROM WS-DETAIL-RECORD.                        
      *                                                                         
A05460     MOVE WS-HEADER-DATE05 TO OUT-CUST-NAME.                      
A05460     WRITE FIORP61A FROM WS-DETAIL-RECORD.                        
      *                                                                         
           WRITE FIORP61A FROM WS-BLANK-RECORD.                         
           WRITE FIORP61A FROM WS-BLANK-RECORD.                         
           WRITE FIORP61A FROM WS-HEADER-RECORD.                        
           WRITE FIORP61A FROM WS-BLANK-RECORD.                         
      *                                                                         
           MOVE WS-RPT2-LIT   TO OUT-ACCOUNT.                           
           MOVE WS-RPT2-TITLE TO OUT-CUST-NAME.                         
           WRITE FIORP61B FROM WS-DETAIL-RECORD.                        
           MOVE SPACES        TO OUT-ACCOUNT.                           
           MOVE WS-TITLE-LIT1 TO OUT-CUST-NAME.                         
           WRITE FIORP61B FROM WS-DETAIL-RECORD.                        
      *                                                                         
A05460     MOVE WS-HEADER-DATE05 TO OUT-CUST-NAME.                      
A05460     WRITE FIORP61B FROM WS-DETAIL-RECORD.                        
      *                                                                         
           WRITE FIORP61B FROM WS-BLANK-RECORD.                         
           WRITE FIORP61B FROM WS-BLANK-RECORD.                         
           WRITE FIORP61B FROM WS-HEADER-RECORD.                        
           WRITE FIORP61B FROM WS-BLANK-RECORD.                         
      *                                                                         
           MOVE WS-RPT3-LIT   TO OUT-ACCOUNT.                           
           MOVE WS-RPT3-TITLE TO OUT-CUST-NAME.                         
           WRITE FIORP61C FROM WS-DETAIL-RECORD.                        
           MOVE SPACES        TO OUT-ACCOUNT.                           
           MOVE WS-TITLE-LIT3 TO OUT-CUST-NAME.                         
           WRITE FIORP61C FROM WS-DETAIL-RECORD.                        
      *                                                                         
A05460     MOVE WS-HEADER-DATE05 TO OUT-CUST-NAME.                      
A05460     WRITE FIORP61C FROM WS-DETAIL-RECORD.                        
      *                                                                         
           WRITE FIORP61C FROM WS-BLANK-RECORD.                         
           WRITE FIORP61C FROM WS-BLANK-RECORD.                         
           WRITE FIORP61C FROM WS-HEADER-RECORD.                        
           WRITE FIORP61C FROM WS-BLANK-RECORD.                         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE DETAIL RECORD FOR REPORT 1                 **          
      ****************************************************************          
      *                                                                         
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                         
           WRITE FIORP61A FROM WS-DETAIL-RECORD.                        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE DETAIL RECORD FOR REPORT 2                 **          
      ****************************************************************          
      *                                                                         
       8201-WRITE-OUTFILE-DETAILS.                                      
      *                                                                         
           WRITE FIORP61B FROM WS-DETAIL-RECORD.                        
      *                                                                         
       8201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE DETAIL RECORD FOR REPORT 3                 **          
      ****************************************************************          
      *                                                                         
       8202-WRITE-OUTFILE-DETAILS.                                      
      *                                                                         
           WRITE FIORP61C FROM WS-DETAIL-RECORD.                        
      *                                                                         
       8202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   CLOSE OUTFILE                                            **          
      ****************************************************************          
      *                                                                         
       8900-CLOSE-OUTFILE.                                              
      *                                                                         
           CLOSE FCSRP61A-FILE                                          
                 FCSRP61B-FILE                                          
                 FCSRP61C-FILE.                                         
      *                                                                         
           IF NOT FCA61A-SUCCESSFUL                                     
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '************ PCSRP617 ABORT   ********'          
              DISPLAY '**  ERROR CLOSING FCSRP61A-FILE     **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA61A-STATUS             
              DISPLAY '**  PROCESSING TERMINATED           **'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           IF NOT FCA61B-SUCCESSFUL                                     
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '************ PCSRP617 ABORT   ********'          
              DISPLAY '**  ERROR CLOSING FCSRP61B-FILE     **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA61B-STATUS             
              DISPLAY '**  PROCESSING TERMINATED           **'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           IF NOT FCA61C-SUCCESSFUL                                     
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '************ PCSRP617 ABORT   ********'          
              DISPLAY '**  ERROR CLOSING FCSRP61C-FILE     **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA61C-STATUS             
              DISPLAY '**  PROCESSING TERMINATED           **'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 8900-CLOSE-OUTFILE THRU 8900-EXIT.                   
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * COPYBOOK FOR ABEND ROUTINE                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
