       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP616.                                      
       AUTHOR.       ROGER D. FAULK.                                    
COB303 DATE-WRITTEN.     APRIL 2016.                                    
       DATE-COMPILED.                                                   
                                                                        
      ****************************************************************          
      ***              P R O G R A M  S U M M A R Y                  *          
      ***------------------------------------------------------------*          
      ****************************************************************          
      ***THIS PROGRAM IS A COBOL REWRTIE FOR GMC015.                 *          
      ***   NON-FARMTAP GATE CLASS 9 ACCOUNTS W/O FARMTAP CODE       *          
      *--------------------------------------------------------------*          
      ****************************************************************          
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE         **          
      ****************************************************************          
      **        0000 - 0999   MAIN CONTROL PATH AND INITIALIZATION  **          
      **        1000 - 1999   ACCOUNT PROCESSING CONTROL PATH       **          
      **        2000 - 2999   COMMON PROGRAM MODULES                **          
      **        3000 - 4999   NOT USED                              **          
      **        5000 - 5999   COMMON PROGRAM MODULES                **          
      **        6000 - 6999   NOT USED                              **          
      **        7000 - 7999   OUTPUT MODULES                        **          
      **        8000 - 8999   OUTPUT MODULES                        **          
      **        9000 - 9999   TERMINATION, ABEND, MESSAGING MODULES **          
      ****************************************************************          
      ***                  MODIFICATION LOG                        ***          
      ***----------------------------------------------------------***          
      ***                                                          ***          
      ***  DATE        INITIALS    COMMENTS                        ***          
      ***  ----------- --------    --------------------------------***          
      ***  18 APR 2016 RF10596     GMC015 EZT TO COBOL CONVERSION  ***          
      ***                                                          ***          
A05460***  28 APR 2016 RF10596     ALLOW FOR NO DATA RECORD TO BE  ***          
A05460***                          SORTED LAST. BLANK LINE AFTER   ***          
A05460***                          HEADER. LOCAL OFFICE ORDER      ***          
      ***                                                          ***          
A05460***  17 JUN 2016 RF10596     PUT CURRENT DATE ON REPORT      ***          
      ***                                                          ***          
A05460***   7 JUL 2016 RF10596     CHANGE REPORT FILE LENGTH       ***          
      ***                                                          ***          
      ***----------------------------------------------------------***          
      *                                                              *          
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSRP616-FILE                                         
               ASSIGN TO UT-S-FCSRP616                                  
               FILE STATUS IS WS-FCA616-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ****************************************************************          
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                *          
      ****************************************************************          
      *                                                                         
       FD  FCSRP616-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIORP616                        PIC X(108).                  
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP616'.
MSQ017     COPY MFASQLM.
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ACCOUNT                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_UTIL_ENVRNMT                                          *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_MTRD_ENVRNMT                                          *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FORMATTED                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FREEFORM                                         *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_NAME_ACCT_XREF                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_NAME                                                  *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_PREMISE                                               *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ZIP_CODE                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CUSTOMER                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CUST_PREM_HIST                                        *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_JOB_PARM                                              *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_GAS_SERV_LINE)  -  XO                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_PREM-GAS_LINE)  -  Y0                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      DCLGEN TABLE(CSS_CITY_GATE)  -  CO                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCITGT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPE00099                                 *          
      * GETS THE MOST CURRENT ACCOUNT-NO AT A GIVEN PREMISE          *          
      ****************************************************************          
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ****************************************************************          
      * ABEND SWITCH COPYBOOK                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * COPYBOOKS                                                    *          
      ****************************************************************          
      *                                                                         
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00010.                                                       
           COPY FIOJC01.                                                        
           COPY CWS00011.                                                       
      *                                                                         
A05460 01 WS-BLANK-RECORD              PIC X(108) VALUE SPACES.         
      *                                                                         
A05460 01 WS-DETAIL-RECORD.                                             
A05460     05 OUT-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
A05460     05 OUT-DELMTR-1             PIC X     VALUE SPACES.          
A05460     05 OUT-METER-NO             PIC X(9)  VALUE SPACES.          
A05460     05 OUT-DELMTR-2             PIC X     VALUE SPACES.          
A05460     05 OUT-LOC-OFF              PIC XXX   VALUE SPACES.          
A05460     05 OUT-DELMTR-3             PIC X     VALUE SPACES.          
A05460     05 OUT-FARM-TAP             PIC XX    VALUE SPACES.          
A05460     05 OUT-DELMTR-4             PIC X     VALUE SPACES.          
A05460     05 OUT-CLASS                PIC XXX   VALUE SPACES.          
A05460     05 OUT-DELMTR-5             PIC X     VALUE SPACES.          
A05460     05 OUT-RATE                 PIC XXX   VALUE SPACES.          
A05460     05 OUT-DELMTR-6             PIC X     VALUE SPACES.          
A05460     05 OUT-UT-CODE              PIC X     VALUE SPACES.          
A05460     05 FILLER                   PIC X     VALUE SPACES.          
A05460     05 OUT-DELMTR-7             PIC X     VALUE SPACES.          
A05460     05 OUT-GATE-ID              PIC X(7)  VALUE SPACES.          
A05460     05 OUT-DELMTR-8             PIC X     VALUE SPACES.          
A05460     05 OUT-NAME                 PIC X(57) VALUE SPACES.          
A05460     05 OUT-DELMTR-9             PIC X     VALUE SPACES.          
      *                                                                         
A05460 01 WS-TITLE-RECORD.                                              
A05460     05 TITLE-ACCOUNT-NO         PIC X(13) VALUE 'PCSRP616     '. 
HEX01      05 TITLE-DELMTR-1           PIC X     VALUE X'09'.           
A05460     05 TITLE-METER-NO           PIC X(9)  VALUE SPACES.          
HEX01      05 TITLE-DELMTR-2           PIC X     VALUE X'09'.           
A05460     05 TITLE-LOC-OFF            PIC XXX   VALUE SPACES.          
HEX01      05 TITLE-DELMTR-3           PIC X     VALUE X'09'.           
A05460     05 TITLE-FARM-TAP           PIC XX    VALUE SPACES.          
HEX01      05 TITLE-DELMTR-4           PIC X     VALUE X'09'.           
A05460     05 TITLE-CLASS              PIC XXX   VALUE SPACES.          
HEX01      05 TITLE-DELMTR-5           PIC X     VALUE X'09'.           
A05460     05 TITLE-RATE               PIC XXX   VALUE SPACES.          
HEX01      05 TITLE-DELMTR-6           PIC X     VALUE X'09'.           
A05460     05 TITLE-UT-CODE            PIC XX    VALUE SPACES.          
HEX01      05 TITLE-DELMTR-7           PIC X     VALUE X'09'.           
A05460     05 TITLE-GATE-ID            PIC X(7)  VALUE SPACES.          
HEX01      05 TITLE-DELMTR-8           PIC X     VALUE X'09'.           
A05460     05 TITLE-NAME               PIC X(40)                        
A05460        VALUE 'NON-FARMTAP GATE CLASS 9 W/O FARMTAP CD '.         
A05460     05 TITLE-FILLER             PIC X(17) VALUE SPACES.          
HEX01      05 TITLE-DELMTR-9           PIC X     VALUE X'09'.           
      *                                                                         
A05460 01 HD-HEADER-RECORD.                                             
A05460     05 HD-ACCT-NO               PIC X(10) VALUE 'ACCOUNT NO'.    
A05460     05 FILLER                   PIC X(3)  VALUE SPACES.          
HEX01      05 HD-DEL-1                 PIC X     VALUE X'09'.           
A05460     05 HD-METER-NO              PIC X(9)  VALUE 'METER NO '.     
HEX01      05 HD-DEL-2                 PIC X     VALUE X'09'.           
A05460     05 HD-LOC-OFF               PIC XXX   VALUE 'LOC'.           
HEX01      05 HD-DEL-3                 PIC X     VALUE X'09'.           
A05460     05 HD-FT                    PIC XX    VALUE 'FT'.            
HEX01      05 HD-DEL-4                 PIC X     VALUE X'09'.           
A05460     05 HD-CL                    PIC XXX   VALUE 'CLS'.           
HEX01      05 HD-DEL-5                 PIC X     VALUE X'09'.           
A05460     05 HD-RTE                   PIC XXX   VALUE 'RTE'.           
HEX01      05 HD-DEL-6                 PIC X     VALUE X'09'.           
A05460     05 HD-UT                    PIC XX    VALUE 'UT'.            
HEX01      05 HD-DEL-7                 PIC X     VALUE X'09'.           
A05460     05 HD-GATEID                PIC X(7)  VALUE 'GATEID '.       
HEX01      05 HD-DEL-8                 PIC X     VALUE X'09'.           
A05460     05 HD-NM                    PIC X(13) VALUE 'CUSTOMER NAME'. 
A05460     05 HD-ADDR                  PIC X(18)                        
A05460                                  VALUE ' / SERVICE ADDRESS'.     
A05460     05 FILLER                   PIC X(26) VALUE SPACES.          
HEX01      05 HD-DEL-9                 PIC X     VALUE X'09'.           
      *                                                                         
A05460 01 WS-NODATA-RECORD.                                             
A05460     05 NOD-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
A05460     05 NOD-DELMTR-1             PIC X     VALUE SPACES.          
A05460     05 NOD-METER-NO             PIC X(9)  VALUE SPACES.          
A05460     05 NOD-DELMTR-2             PIC X     VALUE SPACES.          
A05460     05 NOD-LOC-OFF              PIC XXX   VALUE SPACES.          
A05460     05 NOD-DELMTR-3             PIC X     VALUE SPACES.          
A05460     05 NOD-FARM-TAP             PIC XX    VALUE SPACES.          
A05460     05 NOD-DELMTR-4             PIC X     VALUE SPACES.          
A05460     05 NOD-CLASS                PIC XXX   VALUE SPACES.          
A05460     05 NOD-DELMTR-5             PIC X     VALUE SPACES.          
A05460     05 NOD-RATE                 PIC XXX   VALUE SPACES.          
A05460     05 NOD-DELMTR-6             PIC X     VALUE SPACES.          
A05460     05 NOD-UT-CODE              PIC X     VALUE SPACES.          
A05460     05 FILLER                   PIC X     VALUE SPACES.          
A05460     05 NOD-DELMTR-7             PIC X     VALUE SPACES.          
A05460     05 NOD-GATE-ID              PIC X(7)  VALUE SPACES.          
A05460     05 NOD-DELMTR-8             PIC X     VALUE SPACES.          
A05460     05 NOD-NAME                 PIC X(40)                        
A05460        VALUE 'NO DATA FOR THIS RUN'.                             
A05460     05 NOD-FILLER               PIC X(17) VALUE SPACES.          
A05460     05 NOD-DELMTR-9             PIC X     VALUE SPACES.          
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-PROCESD      PIC X     VALUE 'N'.             
           05 WS-ALL-ROWS-PROCESSD     PIC X     VALUE 'N'.             
      *                                                                         
       01 WS-SWITCH.                                                    
           05  WS-FCA616-STATUS        PIC XX.                          
               88 FCA616-SUCCESSFUL               VALUE '00'.           
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-PAGE-NO              PIC 9(6) VALUE ZEROS.            
           05  WS-FIRST                PIC X     VALUE 'Y'.             
           05  WS-FIRST-TYM            PIC X     VALUE 'Y'.             
           05  WS-CHECK                PIC X     VALUE 'N'.             
      *                                                                         
A05460 01 WS-HEADER-DATE.                                               
A05460     05 WS-HEADER-DATE05.                                         
A05460        10  WS-DATE-X1           PIC X(11) VALUE 'RUN DATE = '.   
A05460        10  WS-CURRENT-DATE      PIC X(10) VALUE SPACES.          
A05460        10  WS-DATE-X2           PIC X(19) VALUE SPACES.          
      *                                                                         
A05460 01 WS-OUT-ADDR.                                                  
A05460     05 WS-OUT-HOUSE-1.                                           
A05460        07 WS-OUT-HOUSE-NBR      PIC X(7).                        
A05460        07 FILLER                PIC X.                           
A05460        07 WS-OUT-ADDRESS        PIC X(49).                       
A05460     05 WS-OUT-HOUSE-2 REDEFINES WS-OUT-HOUSE-1.                  
A05460        07 WS-OUT-ADDRESS2       PIC X(57).                       
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-HONK-LIT1             PIC X(40)                       
              VALUE 'DETERMINE IF THESE SHOULD BE FARM TAP   '.         
           05  WS-HONK-LIT2             PIC X(40)                       
              VALUE 'ACCOUNTS AND CORRECT.  IF THEY ARE NOT, '.         
           05  WS-HONK-LIT3             PIC X(40)                       
              VALUE 'THEN CHANGE CLASS.                      '.         
           05  WS-0-NBR                 PIC X(7)  VALUE '0000000'.      
           05  WS-NAME616               PIC X(90) VALUE SPACES.         
           05  WS-NODATA                PIC X     VALUE 'Y'.            
           05  WS-FARM-GATE             PIC X     VALUE SPACES.         
           05  WS-FARM                  PIC X     VALUE 'F'.            
           05  WS-PROGRAM-NAME          PIC X(8)  VALUE 'PCSRP616'.     
           05  WS-PGRMNAME              PIC X(8)  VALUE 'PCSRP616'.     
           05  WS-NO-NAME               PIC X(7)  VALUE 'NO NAME'.      
           05  WS-SAVE-SQLCODE          PIC S9(4) VALUE 0 COMP.         
HEX01      05  WS-DELIM                 PIC X     VALUE X'09'.          
           05  WS-NULL-INDR1            PIC S9(2) VALUE 0 COMP.         
           05  WS-NULL-INDR2            PIC S9(2) VALUE 0 COMP.         
           05  WS-NULL-IND1             PIC S9(2) VALUE 0 COMP.         
           05  WS-NULL-IND2             PIC S9(2) VALUE 0 COMP.         
           05  WS-CNT                   PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT1                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT2                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT3                  PIC 9(7)  VALUE ZEROES.         
           05  WS-CNT4                  PIC 9(7)  VALUE ZEROES.         
           05  WS-UTIL-TYPE             PIC XX    VALUE SPACES.         
           05  WS-DOT                   PIC X     VALUE '.'.            
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE 0.              
           05  WS-START-POS1            PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-START-POS2            PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-LEN                   PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-ADDR-LEN              PIC S9(2)V VALUE 0 COMP-3.      
           05  WS-ONE                   PIC S9(2)V VALUE 1 COMP-3.      
           05  WS-ADDRESS-LENGTH1       PIC S9(2)V VALUE 50 COMP-3.     
           05  WS-ADDRESS-LENGTH2       PIC S9(2)V VALUE 37 COMP-3.     
           05  WS-LENGTH                PIC S9(2)V VALUE 7 COMP-3.      
           05  WS-ZEROS                 PIC 9(7)   VALUE ZEROES.        
           05  WS-HOUSE-NBR             PIC X(7)   VALUE SPACES.        
           05  WS-TYPE-SVC              PIC X      VALUE SPACES.        
           05  WS-PREMISE-NO            PIC S9(6)V VALUE 0 COMP-3.      
           05  WS-FULL-NAME             PIC X(40)  VALUE SPACES.        
           05  WS-ADDRESS-1             PIC X(50)  VALUE SPACES.        
           05  WS-ADDRESS-2             PIC X(40)  VALUE SPACES.        
           05  WS-PREV-ACCT             PIC 9(13)  VALUE ZEROES.        
           05  WS-FMT-ACCT              PIC 9999999999999 VALUE ZEROES. 
           05  WS-MTR-RD-INST           PIC X(14)  VALUE SPACES.        
           05  WS-DBA-NAME              PIC X(70)  VALUE SPACES.        
           05  WS-SPACES                PIC X      VALUE ' '.           
           05  WS-COMPANY-NO            PIC XX     VALUE '01'.          
           05  WS-PROGRAM-NAME          PIC X(10) VALUE 'PCSCA204  '.   
           05  WS-CMND-CODE             PIC X(4)  VALUE 'PARM'.         
           05  WS-Y                     PIC X     VALUE 'Y'.            
           05  WS-N                     PIC X     VALUE 'N'.            
           05  WS-SVC-ADDR-LINE-1       PIC X(50) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-2       PIC X(37) VALUE SPACES.         
           05  WS-FMT-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-FMT-ADDR-LINE-3       PIC X(36) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-ZIP-CODE-SADDR        PIC X(5) VALUE SPACES.          
           05  WS-ZIP-CD-PL-FOUR-SADDR  PIC X(4) VALUE SPACES.          
           05  WS-SVC-ZIP-PLUS-4        PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-ZIP-CD.                                                    
           05  WS-ZIP-CODE              PIC X(5) VALUE 'N'.             
           05  WS-FILLER-5              PIC X    VALUE 'N'.             
           05  WS-ZIP-CD-PL-FOUR        PIC X(4) VALUE 'N'.             
           05  WS-ADDR-ZIP-CD-5         PIC X(5) VALUE 'N'.             
           05  WS-ADDR-ZIP-CD-4         PIC X(4) VALUE 'N'.             
      *                                                                         
       01  WS-FORMATTED-NAME.                                           
           10 WS-FMT-TITLE-PREFIX     PIC X(9).                         
           10 FILLER                  PIC X.                            
           10 WS-FMT-FIRST-NAME       PIC X(15).                        
           10 FILLER                  PIC X.                            
           10 WS-FMT-MIDDLE-NAME      PIC X(15).                        
           10 FILLER                  PIC X.                            
           10 WS-FMT-LAST-NAME        PIC X(40).                        
           10 FILLER                  PIC X.                            
           10 WS-FMT-TITLE-SUFFIX-1   PIC X(3).                         
           10 FILLER                  PIC X.                            
           10 WS-FMT-TITLE-SUFFIX-2   PIC X(3).                         
      *                                                                         
       01  WS-ADDRESS-FORMAT-FIELDS.                                    
           05  WS-HOUSE-NO              PIC X(7) VALUE SPACES.          
      *                                                                         
       01 WS-FMT-ADDR-LINE-1.                                           
           05  WS-HNO                   PIC X(5)  VALUE SPACES.         
           05  WS-FILLER-3              PIC X     VALUE SPACES.         
           05  WS-APREFIX               PIC XXX   VALUE SPACES.         
           05  WS-FILLER-6              PIC X     VALUE SPACES.         
           05  WS-APREFIX2              PIC XX    VALUE SPACES.         
           05  WS-FILLER-7              PIC X     VALUE SPACES.         
           05  WS-SNAME                 PIC X(16) VALUE SPACES.         
           05  WS-FILLER-8              PIC X     VALUE SPACES.         
           05  WS-SSUFFIX               PIC X(4)  VALUE SPACES.         
           05  WS-FILLER-9              PIC X     VALUE SPACES.         
           05  WS-ASUFFIX               PIC XX    VALUE SPACES.         
           05  WS-FILLER-10             PIC X     VALUE SPACES.         
           05  WS-SLOCATION-1           PIC X(4)  VALUE SPACES.         
           05  WS-FILLER-11             PIC X     VALUE SPACES.         
           05  WS-SLOCATION-2           PIC X(6)  VALUE SPACES.         
      *                                                                         
       01 WS-FMT-ADDR-LINE-2.                                           
           05  WS-TWN                   PIC X(24) VALUE SPACES.         
           05  WS-STT                   PIC XX    VALUE SPACES.         
      *    05  WS-FILLER-4              PIC X     VALUE SPACES.                 
           05  WS-ZIPCD                 PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-FMT-NAME.                                                  
           05  WS-FNAME                 PIC X(15) VALUE SPACES.         
           05  WS-FILLER-1              PIC X     VALUE SPACES.         
           05  WS-MNAME                 PIC X     VALUE SPACES.         
           05  WS-FILLER-2              PIC X     VALUE SPACES.         
           05  WS-LNAME                 PIC X(19) VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      *CURSOR FOR REVENUE CLASS - MAIN CURSOR                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE GET_DET CURSOR FOR                                 
               SELECT DISTINCT PR.PREMISE_NO                            
                     ,CH.ACCOUNT_NO                                     
                     ,PR.ADDRESS_ID                                     
                     ,PR.CITY_GATE_ID                                   
                     ,PR.LOCAL_OFFICE                                   
                     ,XO.FARM_TAP_IND                                   
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.IC_NO                                          
                     ,UT.CODE_REVENUE_CLASS                             
                     ,UT.RATE_PLAN_NO                                   
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                     ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               

                  INNER JOIN (
                   SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END               
                      ,IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') ))) MFAAUXI_0         
                      ,MAX(CH1.DATE_UTIL_SVC_STRT) MFAAUXI_1
                      ,CH1.PREMISE_NO MFAAUXI_2
            FROM CSS_CUST_PREM_HIST CH1 WITH(READUNCOMMITTED)
            GROUP BY CH1.PREMISE_NO
                 ) MFAAUXI
                   ON MFAAUXI_0 = COALESCE(CH.DATE_UTIL_SVC_END                 
                      , IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') )) AND 
           MFAAUXI_1 = CH.DATE_UTIL_SVC_STRT
                   AND MFAAUXI.MFAAUXI_2 = CH.PREMISE_NO
                     ,CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED)                
                     ,CSS_PREM_GAS_LINE Y0 WITH(READUNCOMMITTED)                
                 WHERE PR.PREMISE_NO     = UT.PREMISE_NO
                       AND PR.PREMISE_NO     = CH.PREMISE_NO
                       AND PR.COMPANY_NO     = '01'
                       AND PR.COMPANY_NO     = UT.COMPANY_NO
                       AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO
                       AND UT.CODE_UTIL_TYPE = 'G'
                       AND 
           UT.CODE_REVENUE_CLASS IN ('910', '920', '930')
                       AND PR.PREMISE_NO     = Y0.PREMISE_NO
                       AND Y0.SERVICE_NO     = XO.SERVICE_NO
                       AND XO.SERV_LINE_STAT_FL IN  ('A', 'T', 'U')             
A05460            ORDER BY PR.LOCAL_OFFICE                              
A05460                    ,PR.PREMISE_NO                                
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ059
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_DET CURSOR FOR                                         
MFA-TR*        SELECT DISTINCT PR.PREMISE_NO                                    
MFA-TR*              ,CH.ACCOUNT_NO                                             
MFA-TR*              ,PR.ADDRESS_ID                                             
MFA-TR*              ,PR.CITY_GATE_ID                                           
MFA-TR*              ,PR.LOCAL_OFFICE                                           
MFA-TR*              ,XO.FARM_TAP_IND                                           
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.CODE_REVENUE_CLASS                                     
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*              ,CSS_CUST_PREM_HIST CH                                     
MFA-TR*              ,CSS_GAS_SERV_LINE XO                                      
MFA-TR*              ,CSS_PREM_GAS_LINE Y0                                      
MFA-TR*          WHERE PR.PREMISE_NO     = UT.PREMISE_NO                        
MFA-TR*            AND PR.PREMISE_NO     = CH.PREMISE_NO                        
MFA-TR*            AND PR.COMPANY_NO     = '01'                                 
MFA-TR*            AND PR.COMPANY_NO     = UT.COMPANY_NO                        
MFA-TR*            AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO                        
MFA-TR*            AND UT.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND UT.CODE_REVENUE_CLASS IN ('910', '920', '930')           
MFA-TR*            AND PR.PREMISE_NO     = Y0.PREMISE_NO                        
MFA-TR*            AND Y0.SERVICE_NO     = XO.SERVICE_NO                        
MFA-TR*            AND XO.SERV_LINE_STAT_FL IN  ('A', 'T', 'U')                 
MFA-TR*            AND ( COALESCE(CH.DATE_UTIL_SVC_END                          
MFA-TR*               , DATE('9999-12-31'))                                     
MFA-TR*               , CH.DATE_UTIL_SVC_STRT) IN (                             
MFA-TR*         SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END                       
MFA-TR*               ,DATE('9999-12-31')))                                     
MFA-TR*               ,MAX(CH1.DATE_UTIL_SVC_STRT)                              
MFA-TR*            FROM CSS_CUST_PREM_HIST CH1                                  
MFA-TR*           WHERE CH1.PREMISE_NO = CH.PREMISE_NO                          
MFA-TR*           GROUP BY CH1.PREMISE_NO)                                      
MFA-TR*           ORDER BY PR.LOCAL_OFFICE                                      
MFA-TR*                   ,PR.PREMISE_NO                                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
A05460     PERFORM 7000-SELECT-CURRENT THRU 7000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS-MAIN-CSR THRU 2000-EXIT.                
      *                                                                         
           IF WS-NODATA = WS-Y                                          
              WRITE FIORP616 FROM WS-NODATA-RECORD                      
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * INITIALIZE AND OPEN FILE                                     *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSRP616-FILE.                                   
      *                                                                         
           IF NOT FCA616-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP616 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSRP616-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA616-STATUS            
               DISPLAY '**  PROCESSING TERMINATED           **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIORP616.                                         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS MAIN CURSOR                                          *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 8100-WRITE-OUTFILE-HEADER THRU 8100-EXIT.            
      *                                                                         
           PERFORM 7100-OPEN-MAIN-CSR THRU 7100-EXIT.                   
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR THRU 7200-EXIT.                  
      *                                                                         
           PERFORM 2010-ACCT-ADDR-PROCESS THRU 2010-EXIT                
                UNTIL WS-ALL-ROWS-PROCESD = WS-Y.                       
      *                                                                         
           PERFORM 7300-CLOSE-MAIN-CSR THRU  7300-EXIT.                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET NAME AND ADDRESS                                       **          
      ****************************************************************          
      *                                                                         
       2010-ACCT-ADDR-PROCESS.                                          
      *                                                                         
A05460     MOVE SPACES TO WS-OUT-ADDR.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-N TO WS-FARM-GATE                                 
              PERFORM 7475-GET-GATE THRU 7475-EXIT                      
              IF WS-FARM-GATE = WS-N                                    
                 MOVE SPACES TO WS-FMT-NAME                             
                                WS-FULL-NAME                            
                                WS-FMT-ADDR-LINE-1                      
                                WS-FMT-ADDR-LINE-2                      
      *                                                                         
                 PERFORM 7450-STILL-NEEDED THRU 7450-EXIT               
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    DISPLAY '7450 - DID NOT FIND ACCOUNT'               
                    DISPLAY '*******************************'           
                    DISPLAY '** 2010-ACCT-ADDR-PROCESS    **'           
                    DISPLAY '**  7450 - ACCOUNT NOT FOUND **'           
                    DISPLAY '** ACCOUNT-NO     = ' CH-ACCOUNT-NO        
                    DISPLAY '** CODE-UTIL-TYPE = ' UT-CODE-UTIL-TYPE    
                    DISPLAY '** IC-NO          = ' UT-IC-NO             
                    DISPLAY '*******************************'           
                 ELSE                                                   
                    MOVE CU-NAME-ID TO DQ-NAME-ID                       
                    PERFORM 7788-SELECT-CUSTOMER-NAME THRU 7788-EXIT    
                    MOVE SPACES TO WS-FORMATTED-NAME                    
                    IF SQLCODE = 0                                      
                       IF DQ-LAST-NAME = SPACES                         
                          MOVE DQ-FULL-NAME TO WS-FMT-LAST-NAME         
                       ELSE                                             
                          MOVE DQ-FIRST-NAME TO WS-FMT-FIRST-NAME       
                          MOVE DQ-MIDDLE-NAME TO WS-FMT-MIDDLE-NAME     
                          MOVE DQ-LAST-NAME TO WS-FMT-LAST-NAME         
                          MOVE DQ-TITLE-SUFFIX-1                        
                                  TO WS-FMT-TITLE-SUFFIX-1              
                          MOVE DQ-TITLE-SUFFIX-2                        
                                  TO WS-FMT-TITLE-SUFFIX-2              
                       END-IF                                           
                       IF WS-FORMATTED-NAME > SPACES                    
                          MOVE SPACES TO WS-NAME616                     
                                         WS-EMB-INPUT                   
                                         WS-CMP-TABLE                   
                          MOVE WS-FORMATTED-NAME TO WS-NAME616          
                          PERFORM 2666-REMOVE-SPACES THRU 2666-EXIT     
                          MOVE WS-NAME616 TO WS-FULL-NAME               
                       ELSE                                             
                          MOVE 'NOT FOUND' TO WS-FULL-NAME              
                       END-IF                                           
                    ELSE                                                
                       MOVE SPACES TO WS-FORMATTED-NAME                 
                       MOVE 'NOT FOUND' TO WS-FULL-NAME                 
                    END-IF                                              
      *                                                                         
                    PERFORM 2100-GET-ADDR THRU 2100-EXIT                
      *                                                                         
                    MOVE WS-SVC-ADDR-LINE-1 TO WS-ADDRESS-1             
                    MOVE WS-SVC-ADDR-LINE-2 TO WS-ADDRESS-2             
      *                                                                         
                    PERFORM 2900-FORMAT-OUTPUT THRU 2900-EXIT           
                    MOVE WS-N TO WS-NODATA                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-DETAIL-RECORD.                                 
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR THRU 7200-EXIT.                  
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET SERVICE ADDRESS                                        **          
      ****************************************************************          
      *                                                                         
       2100-GET-ADDR.                                                   
      *                                                                         
           MOVE SPACES TO WS-FMT-ADDR-LINE-1                            
                          WS-FMT-ADDR-LINE-OVERFLOW                     
                          WS-FMT-ADDR-LINE-2                            
                          WS-FMT-ADDR-LINE-3                            
                          WS-SVC-ADDR-LINE-1                            
                          WS-SVC-ADDR-LINE-OVERFLOW                     
                          WS-SVC-ADDR-LINE-2.                           
      *                                                                         
           PERFORM 2200-FMT-SVC-ADDR THRU 2200-EXIT.                    
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FORMAT SERVICE ADDRESS                                     **          
      ****************************************************************          
      *                                                                         
       2200-FMT-SVC-ADDR.                                               
      *                                                                         
           MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID.                         
      *                                                                         
           PERFORM 7500-FMT-SVC-ADDR THRU 7500-EXIT.                    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DY-ZIP-CODE           TO WS-ZIP-CODE                 
              MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-ZIP-CD-PL-FOUR           
              MOVE DY-ZIP-CODE           TO WS-ZIP-CODE-SADDR           
              MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-ZIP-CD-PL-FOUR-SADDR     
      *                                                                         
              IF WS-ZIP-CD-PL-FOUR = SPACES                             
                MOVE ' ' TO WS-FILLER-5                                 
              ELSE                                                      
                MOVE '-' TO WS-FILLER-5                                 
              END-IF                                                    
      *                                                                         
              MOVE WS-ZIP-CD         TO WS-SVC-ZIP-PLUS-4               
              MOVE DY-ZIP-CODE       TO A4-ZIP-CODE                     
              MOVE DY-ZIP-CODE-TOKEN TO A4-ZIP-CODE-TOKEN               
              MOVE SPACES            TO WS-CMP-TABLE                    
      *                                                                         
              PERFORM 7700-TOWN-DETAILS THRU 7700-EXIT                  
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2300-FORMAT-FORM-ADDR THRU 2300-EXIT           
                 MOVE WS-FMT-ADDR-LINE-1   TO WS-EMB-INPUT              
                 MOVE 50                   TO WS-EMB-LENG               
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE         TO WS-SVC-ADDR-LINE-1        
                 MOVE SPACES               TO WS-CMP-TABLE              
                 MOVE WS-FMT-ADDR-LINE-2   TO WS-EMB-INPUT              
                 MOVE 37                   TO WS-EMB-LENG               
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE         TO WS-SVC-ADDR-LINE-2        
                 MOVE SPACES               TO WS-CMP-TABLE              
                 MOVE WS-FMT-ADDR-LINE-OVERFLOW                         
                                       TO WS-SVC-ADDR-LINE-OVERFLOW     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-ADDRESS-LENGTH1 TO WS-ADDR-LEN                       
           MOVE WS-ADDRESS-LENGTH2 TO WS-ADDR-LEN.                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FORMAT ADDRESS                                             **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-FORM-ADDR.                                           
      *                                                                         
           MOVE DY-HOUSE-NO           TO WS-HOUSE-NO.                   
           MOVE DY-ADDR-PREFIX-1      TO WS-APREFIX.                    
           MOVE DY-ADDR-PREFIX-2      TO WS-APREFIX2.                   
           MOVE DY-STREET-LOCATION-1  TO WS-SLOCATION-1.                
           MOVE DY-STREET-LOCATION-2  TO WS-SLOCATION-2.                
           MOVE DY-STREET-NAME        TO WS-SNAME.                      
           MOVE DY-STREET-SUFFIX      TO WS-SSUFFIX.                    
           MOVE DY-ADDR-SUFFIX        TO WS-ASUFFIX.                    
           MOVE A4-TOWN               TO WS-TWN.                        
           MOVE A4-STATE              TO WS-STT.                        
           MOVE WS-ZIP-CD             TO WS-ZIPCD.                      
           MOVE DY-ADDRESS-OVERFLOW   TO WS-FMT-ADDR-LINE-OVERFLOW.     
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * REMOVES SPACES FROM THE NAME.                                *          
      ****************************************************************          
      *                                                                         
       2666-REMOVE-SPACES.                                              
      *                                                                         
           MOVE WS-NAME616 TO WS-EMB-INPUT.                             
           MOVE +90 TO WS-EMB-LENG.                                     
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE TO WS-NAME616.                             
      *                                                                         
       2666-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FORMAT OUTPUT RECORD.                                      **          
      ****************************************************************          
      *                                                                         
       2900-FORMAT-OUTPUT.                                              
      *                                                                         
           MOVE WS-DELIM TO OUT-DELMTR-1                                
                            OUT-DELMTR-2                                
                            OUT-DELMTR-3                                
                            OUT-DELMTR-4                                
                            OUT-DELMTR-5                                
                            OUT-DELMTR-6                                
                            OUT-DELMTR-7                                
                            OUT-DELMTR-8                                
                            OUT-DELMTR-9.                               
      *                                                                         
           MOVE PR-LOCAL-OFFICE             TO OUT-LOC-OFF.             
           MOVE CH-ACCOUNT-NO               TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO OUT-ACCOUNT-NO.          
           MOVE MN-METER-NO                 TO OUT-METER-NO.            
           MOVE PR-CITY-GATE-ID             TO OUT-GATE-ID.             
           MOVE PR-LOCAL-OFFICE             TO OUT-LOC-OFF.             
           MOVE XO-FARM-TAP-IND             TO OUT-FARM-TAP.            
           MOVE MN-UTILITY-SOURCE-CD        TO OUT-UT-CODE.             
           MOVE UT-RATE-PLAN-NO             TO OUT-RATE.                
           MOVE UT-CODE-REVENUE-CLASS       TO OUT-CLASS.               
           MOVE ZEROES                      TO WS-CNT1                  
                                               WS-CNT2                  
                                               WS-CNT3                  
                                               WS-CNT4.                 
A05460     MOVE WS-FULL-NAME                TO OUT-NAME.                
      *                                                                         
A05460     PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT.           
A05460     INITIALIZE WS-DETAIL-RECORD.                                 
      *                                                                         
A05460     MOVE WS-DELIM TO OUT-DELMTR-1                                
A05460                      OUT-DELMTR-2                                
A05460                      OUT-DELMTR-3                                
A05460                      OUT-DELMTR-4                                
A05460                      OUT-DELMTR-5                                
A05460                      OUT-DELMTR-6                                
A05460                      OUT-DELMTR-7                                
A05460                      OUT-DELMTR-8                                
A05460                      OUT-DELMTR-9.                               
      *                                                                         
A05460     MOVE WS-HOUSE-NO TO WS-OUT-HOUSE-NBR.                        
A05460     MOVE SPACES      TO WS-HOUSE-NO.                             
A05460     INSPECT WS-ADDRESS-1 TALLYING WS-CNT1 FOR LEADING SPACES.    
A05460     INSPECT FUNCTION REVERSE(WS-ADDRESS-1) TALLYING              
A05460                                   WS-CNT2 FOR LEADING SPACES.    
A05460     COMPUTE WS-CNT3 = LENGTH OF WS-ADDRESS-1.                    
A05460     COMPUTE WS-CNT4 = WS-CNT3 - WS-CNT2 - WS-CNT1.               
A05460     IF WS-CNT1 = 0                                               
A05460        MOVE 1 TO WS-CNT1                                         
A05460     END-IF.                                                      
A05460     MOVE WS-ADDRESS-1(WS-CNT1:WS-CNT4) TO WS-OUT-ADDRESS.        
A05460     MOVE WS-OUT-ADDR TO OUT-NAME.                                
      *                                                                         
A05460     PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT.           
A05460     INITIALIZE WS-DETAIL-RECORD.                                 
      *                                                                         
A05460     MOVE WS-DELIM TO OUT-DELMTR-1                                
A05460                      OUT-DELMTR-2                                
A05460                      OUT-DELMTR-3                                
A05460                      OUT-DELMTR-4                                
A05460                      OUT-DELMTR-5                                
A05460                      OUT-DELMTR-6                                
A05460                      OUT-DELMTR-7                                
A05460                      OUT-DELMTR-8                                
A05460                      OUT-DELMTR-9.                               
      *                                                                         
A05460     MOVE ZEROES TO WS-CNT1                                       
A05460                    WS-CNT2                                       
A05460                    WS-CNT3                                       
A05460                    WS-CNT4.                                      
      *                                                                         
A05460     INSPECT WS-ADDRESS-2 TALLYING WS-CNT1 FOR LEADING SPACES.    
A05460     INSPECT FUNCTION REVERSE(WS-ADDRESS-2) TALLYING              
A05460                                   WS-CNT2 FOR LEADING SPACES.    
A05460     COMPUTE WS-CNT3 = LENGTH OF WS-ADDRESS-2.                    
A05460     COMPUTE WS-CNT4 = WS-CNT3 - WS-CNT2 - WS-CNT1.               
A05460     IF WS-CNT1 = 0                                               
A05460        MOVE 1 TO WS-CNT1                                         
A05460     END-IF.                                                      
A05460     MOVE WS-ADDRESS-2(WS-CNT1:WS-CNT4) TO WS-OUT-ADDRESS2.       
A05460     MOVE WS-OUT-ADDR TO OUT-NAME.                                
      *                                                                         
           PERFORM 8200-WRITE-OUTFILE-DETAILS THRU 8200-EXIT.           
A05460     WRITE FIORP616 FROM WS-BLANK-RECORD.                         
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  6010-REDUCE-EMBEDDED-SPACES                                 *          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
A05460** GET CURRENT DATE FOR HEADER RECORD                         **          
      ****************************************************************          
      *                                                                         
A05460 7000-SELECT-CURRENT.                                             
      *                                                                         
A05460     EXEC SQL                                                     
A05460        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05460        CONTINUE                                                  
A05460     ELSE                                                         
A05460        DISPLAY '******** PCSRP616 ABORT ******'                  
A05460        DISPLAY '** 7000-SELECT-CURRENT      **'                  
A05460        DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE          
A05460        DISPLAY '** PROCESSING TERMINATED    **'                  
A05460        DISPLAY '******************************'                  
A05460        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05460     END-IF.                                                      
      *                                                                         
A05460 7000-EXIT.                                                       
A05460     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7100-OPEN-MAIN-CSR.                                        **          
      ****************************************************************          
      *                                                                         
       7100-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_DET                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP616 ABORT *****'                   
              DISPLAY '** OPEN GET DETAILS ERROR  **'                   
              DISPLAY '** 7100-OPEN-MAIN-CSR      **'                   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED   **'                   
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7200-FETCH-GET-MAIN                                        **          
      ****************************************************************          
      *                                                                         
       7200-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_DET                                             
               INTO  :PR-PREMISE-NO                                     
                    ,:CH-ACCOUNT-NO                                     
                    ,:PR-ADDRESS-ID                                     
                    ,:PR-CITY-GATE-ID                                   
                    ,:PR-LOCAL-OFFICE                                   
                    ,:XO-FARM-TAP-IND                                   
                    ,:UT-CODE-UTIL-TYPE                                 
                    ,:UT-IC-NO                                          
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:UT-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ALL-ROWS-PROCESD                       
              ELSE                                                      
                 DISPLAY '******** PCSRP616 ABORT ******'               
                 DISPLAY '**  MAIN CURSOR FETCH ERROR **'               
                 DISPLAY '** 7200-FETCH-MAIN-CSR      **'               
                 DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '** PROCESSING TERMINATED    **'               
                 DISPLAY '******************************'               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7300-CLOSE-MAIN-CSR                                        **          
      ****************************************************************          
      *                                                                         
       7300-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_DET                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP616 ABORT ******'                  
              DISPLAY '** CLOSE MAIN CURSOR ERROR  **'                  
              DISPLAY '** 7300-CLOSE-MAIN-CSR      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET CUSTOMER NAME                                            *          
      ****************************************************************          
      *                                                                         
       7788-SELECT-CUSTOMER-NAME.                                       
      *                                                                         
           EXEC SQL                                                     
                 SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.TITLE_SUFFIX_1,
              DQ.TITLE_SUFFIX_2,
              DQ.FULL_NAME                                    
                 INTO  :DQ-FIRST-NAME                                   
                      ,:DQ-MIDDLE-NAME                                  
                      ,:DQ-LAST-NAME                                    
                      ,:DQ-TITLE-SUFFIX-1                               
                      ,:DQ-TITLE-SUFFIX-2                               
                      ,:DQ-FULL-NAME                                    
                 FROM  CSS_NAME DQ WITH(READUNCOMMITTED)                        
                 WHERE DQ.NAME_ID   = :DQ-NAME-ID                       
                   AND DQ.NAME_TYPE = 'CN'                              
                                             
ACT085                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*                ,DQ.TITLE_SUFFIX_1                                       
MFA-TR*                ,DQ.TITLE_SUFFIX_2                                       
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*          INTO  :DQ-FIRST-NAME                                           
MFA-TR*               ,:DQ-MIDDLE-NAME                                          
MFA-TR*               ,:DQ-LAST-NAME                                            
MFA-TR*               ,:DQ-TITLE-SUFFIX-1                                       
MFA-TR*               ,:DQ-TITLE-SUFFIX-2                                       
MFA-TR*               ,:DQ-FULL-NAME                                            
MFA-TR*          FROM  CSS_NAME DQ                                              
MFA-TR*          WHERE DQ.NAME_ID   = :DQ-NAME-ID                               
MFA-TR*            AND DQ.NAME_TYPE = 'CN'                                      
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7788                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**     PCSRP616 PROCESSING ERROR          **'    
              DISPLAY '**          ABEND IN PARAGRAPH            **'    
              DISPLAY '**      7788-SELECT-CUSTOMER-NAME         **'    
              DISPLAY '** PREMISE-NO = '  PR-PREMISE-NO                 
              DISPLAY '** NAME ID    = '  DQ-NAME-ID                    
              DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE             
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7788-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET METERED ENVIRONMENT DATA AND CUSTOMER NAME ID          **          
      ****************************************************************          
      *                                                                         
       7450-STILL-NEEDED.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT MN.METER_NO                                        
                    ,MN.UTILITY_SOURCE_CD                               
                    ,CU.NAME_ID                                         
                INTO :MN-METER-NO                                       
                    ,:MN-UTILITY-SOURCE-CD                              
                    ,:CU-NAME-ID                                        
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                WHERE MN.ACCOUNT_NO     = :CH-ACCOUNT-NO                
                  AND MN.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
                  AND MN.IC_NO          = :UT-IC-NO                     
                  AND MN.ACCOUNT_NO     = AT.ACCOUNT_NO                 
                  AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.METER_NO                                                
MFA-TR*             ,MN.UTILITY_SOURCE_CD                                       
MFA-TR*             ,CU.NAME_ID                                                 
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*             ,:MN-UTILITY-SOURCE-CD                                      
MFA-TR*             ,:CU-NAME-ID                                                
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*         WHERE MN.ACCOUNT_NO     = :CH-ACCOUNT-NO                        
MFA-TR*           AND MN.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                    
MFA-TR*           AND MN.IC_NO          = :UT-IC-NO                             
MFA-TR*           AND MN.ACCOUNT_NO     = AT.ACCOUNT_NO                         
MFA-TR*           AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP616 ABORT *********'               
              DISPLAY '** 7450-STILL-NEEDED           **'               
              DISPLAY '** ACCOUNT-NO  = ' CH-ACCOUNT-NO                 
              DISPLAY '** PREMISE-NO  = ' PR-PREMISE-NO                 
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED       **'               
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET GATE TABLE DATA                                        **          
      ****************************************************************          
      *                                                                         
       7475-GET-GATE.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT FARM_TAP_IND                                       
                INTO :C0-FARM-TAP-IND                                   
                FROM  CSS_CITY_GATE WITH(READUNCOMMITTED)                       
                WHERE CITY_GATE_ID = :PR-CITY-GATE-ID                   
                AND   LOCAL_OFFICE = :PR-LOCAL-OFFICE                   
                AND   COMPANY_NO   = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FARM_TAP_IND                                               
MFA-TR*         INTO :C0-FARM-TAP-IND                                           
MFA-TR*         FROM  CSS_CITY_GATE                                             
MFA-TR*         WHERE CITY_GATE_ID = :PR-CITY-GATE-ID                           
MFA-TR*         AND   LOCAL_OFFICE = :PR-LOCAL-OFFICE                           
MFA-TR*         AND   COMPANY_NO   = '01'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7475                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF C0-FARM-TAP-IND = WS-FARM                              
                 MOVE WS-Y TO WS-FARM-GATE                              
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 IF XO-FARM-TAP-IND = WS-Y                              
                    MOVE WS-Y TO WS-FARM-GATE                           
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '******** PCSRP616 ABORT *********'            
                 DISPLAY '** GET GATE ID                 **'            
                 DISPLAY '** 7475-GET-GATE               **'            
                 DISPLAY '** CITY_GATE_ID = ' PR-CITY-GATE-ID           
                 DISPLAY '** RETURN CODE  = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '** PROCESSING TERMINATED       **'            
                 DISPLAY '*********************************'            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FORMAT SERVICE ADDRESS                                     **          
      ****************************************************************          
      *                                                                         
       7500-FMT-SVC-ADDR.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  HOUSE_NO                                          
                     ,ADDR_PREFIX_1                                     
                     ,ADDR_PREFIX_2                                     
                     ,STREET_NAME                                       
                     ,STREET_SUFFIX                                     
                     ,ZIP_CODE                                          
                     ,ZIP_CODE_PLUS_FOUR                                
                     ,ZIP_CODE_TOKEN                                    
                     ,ADDR_SUFFIX                                       
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,ADDRESS_OVERFLOW                                  
                INTO :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:DY-ZIP-CODE-TOKEN                                 
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-ADDRESS-OVERFLOW                               
                FROM  CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
               WHERE  ADDRESS_ID = :DY-ADDRESS-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*         INTO :DY-HOUSE-NO                                               
MFA-TR*             ,:DY-ADDR-PREFIX-1                                          
MFA-TR*             ,:DY-ADDR-PREFIX-2                                          
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:DY-ZIP-CODE-TOKEN                                         
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM  CSS_ADDR_FORMATTED                                        
MFA-TR*        WHERE  ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP616 ABORT *********'               
              DISPLAY '** FORMAT ADDRESS              **'               
              DISPLAY '** 7500-FMT-SVC-ADDR           **'               
              DISPLAY '** ADDRESS ID  = ' DY-ADDRESS-ID                 
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED       **'               
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      ** SELECT TOWN AND STATE                                      **          
      ****************************************************************          
      *                                                                         
       7700-TOWN-DETAILS.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  TOWN                                              
                     ,STATE                                             
                INTO :A4-TOWN                                           
                    ,:A4-STATE                                          
                FROM  CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
               WHERE  ZIP_CODE       = :A4-ZIP-CODE                     
                 AND  ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*         INTO :A4-TOWN                                                   
MFA-TR*             ,:A4-STATE                                                  
MFA-TR*         FROM  CSS_ZIP_CODE                                              
MFA-TR*        WHERE  ZIP_CODE       = :A4-ZIP-CODE                             
MFA-TR*          AND  ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                       
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP616 ABORT *********'               
              DISPLAY '** GET TOWN DETAILS            **'               
              DISPLAY '** 7700-TOWN-DETAILS           **'               
              DISPLAY '** A4-ZIP-CODE       = ' A4-ZIP-CODE             
              DISPLAY '** A4-ZIP-CODE-TOKEN = ' A4-ZIP-CODE-TOKEN       
              DISPLAY '** RETURN CODE       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '** PROCESSING TERMINATED       **'               
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE HEADER RECORD                              **          
      ****************************************************************          
      *                                                                         
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                         
           WRITE FIORP616 FROM WS-TITLE-RECORD.                         
           MOVE SPACES       TO TITLE-ACCOUNT-NO.                       
           MOVE WS-HONK-LIT1 TO TITLE-NAME.                             
           WRITE FIORP616 FROM WS-TITLE-RECORD.                         
           MOVE WS-HONK-LIT2 TO TITLE-NAME.                             
           WRITE FIORP616 FROM WS-TITLE-RECORD.                         
           MOVE WS-HONK-LIT3 TO TITLE-NAME.                             
           WRITE FIORP616 FROM WS-TITLE-RECORD.                         
      *                                                                         
A05460     MOVE WS-HEADER-DATE05 TO TITLE-NAME.                         
A05460     WRITE FIORP616 FROM WS-TITLE-RECORD.                         
      *                                                                         
           WRITE FIORP616 FROM WS-BLANK-RECORD.                         
           WRITE FIORP616 FROM WS-BLANK-RECORD.                         
           WRITE FIORP616 FROM HD-HEADER-RECORD.                        
           WRITE FIORP616 FROM WS-BLANK-RECORD.                         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   WRITE OUTFILE DETAIL RECORD                              **          
      ****************************************************************          
      *                                                                         
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                         
           WRITE FIORP616 FROM WS-DETAIL-RECORD.                        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   CLOSE OUTFILE                                            **          
      ****************************************************************          
      *                                                                         
       8900-CLOSE-OUTFILE.                                              
      *                                                                         
           CLOSE FCSRP616-FILE.                                         
      *                                                                         
           IF NOT FCA616-SUCCESSFUL                                     
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '************ PCSRP616 ABORT   ********'          
              DISPLAY '**  ERROR CLOSING FCSRP616-FILE     **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA616-STATUS             
              DISPLAY '**  PROCESSING TERMINATED           **'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 8900-CLOSE-OUTFILE THRU 8900-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * COPYBOOK FOR ABEND ROUTINE                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
