       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP613.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     DEC 14, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***   THIS PROGRAM IS TO EXTRACT ALL ELECTRIC METERS           ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT033***  12/14/2015    VV7M728     CSR613 EZT TO COBOL CONVERSION  ***        
      ***                                                            ***        
A05460***  13 JUN 2016   RF10596     CORRECT DBA ERROR               ***        
      ***                                                            ***        
A#5470***  11 NOV 2016   SS95855     ACT054 LAT/LONG FROM PREMISE    ***        
      ***                                                            ***        
A05460***   5 DEC 2016   RF10596     CORRECT LONG FROM PREMISE       ***        
      ***                                                            ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSPT770-FILE                                         
               ASSIGN TO UT-S-FCSBW770                                  
               FILE STATUS IS WS-FCA770-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      *                                                                         
       FD  FCSPT770-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT770-RECORD                        PIC X(770).             
      *                                                                         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP613'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FORMATTED                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FREEFORM                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME                                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PREMISE                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ZIP_CODE                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUSTOMER                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIPMENT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_METER                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ELEC_METER                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTR_CAP                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_METER_ATTCHMTS                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_PHONE                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PIM_POINT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE FOR CPE00099                                  *         
      * GETS THE MOST CURRENT ACCOUNT-NO AT A GIVEN PREMISE           *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00010.                                                       
           COPY FIOJC01.                                                        
           COPY CWS00011.                                                       
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP613'.     
           05 WS-PGRMNAME               PIC X(08) VALUE 'PCSRP613'.     
      *                                                                         
       01 WS-RP613-OUT-REC.                                             
           05 OUT-LOC-OFF               PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-1              PIC X(01) VALUE '|'.            
           05 OUT-READ-ROUTE            PIC 9(04) VALUE ZEROES.         
           05 OUT-DELMTR-2              PIC X(01) VALUE '|'.            
           05 OUT-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05 OUT-DELMTR-3              PIC X(01) VALUE '|'.            
           05 OUT-TYPE-SVC              PIC X(01) VALUE SPACES.         
           05 OUT-DELMTR-4              PIC X(01) VALUE '|'.            
           05 OUT-METER-NO              PIC X(09) VALUE SPACES.         
           05 OUT-DELMTR-5              PIC X(01) VALUE '|'.            
           05 OUT-SERIAL-NO             PIC X(11) VALUE SPACES.         
           05 OUT-DELMTR-6              PIC X(01) VALUE '|'.            
           05 OUT-ERT-ID                PIC X(12) VALUE SPACES.         
           05 OUT-DELMTR-7              PIC X(01) VALUE '|'.            
           05 OUT-REGISTER-RD-SEQ       PIC 9(09) VALUE ZEROES.         
           05 OUT-DELMTR-8              PIC X(01) VALUE '|'.            
           05 OUT-METER-SIZE-ID         PIC X(08) VALUE SPACES.         
           05 OUT-DELMTR-9              PIC X(01) VALUE '|'.            
           05 OUT-ELEC-MTR-CLASS-CD     PIC X(02) VALUE SPACES.         
           05 OUT-DELMTR-10             PIC X(01) VALUE '|'.            
           05 OUT-ELEC-MTR-SPEC-CD      PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-11             PIC X(01) VALUE '|'.            
           05 OUT-CONSTANT              PIC 9(05) VALUE ZEROES.         
           05 OUT-DELMTR-12             PIC X(01) VALUE '|'.            
           05 OUT-NO-DIALS              PIC 9(01) VALUE ZEROES.         
           05 OUT-DELMTR-13             PIC X(01) VALUE '|'.            
           05 OUT-DBA-NAME              PIC X(50) VALUE SPACES.         
           05 OUT-DELMTR-14             PIC X(01) VALUE '|'.            
           05 OUT-HOUSE-NBR             PIC 9(07) VALUE ZEROES.         
           05 OUT-DELMTR-14A            PIC X(01) VALUE '|'.            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-SVC-ADDR-1            PIC X(49) VALUE SPACES.         
           05 OUT-DELMTR-15             PIC X(01) VALUE '|'.            
           05 OUT-SVC-ADDR-OVERFLOW     PIC X(35) VALUE SPACES.         
           05 OUT-DELMTR-16             PIC X(01) VALUE '|'.            
           05 OUT-SVC-ADDR-2            PIC X(40) VALUE SPACES.         
           05 OUT-DELMTR-17             PIC X(01) VALUE '|'.            
           05 OUT-PREMISE-DIRECTIONS    PIC X(255) VALUE SPACES.        
           05 OUT-DELMTR-18             PIC X(01) VALUE '|'.            
           05 OUT-PROGRAM-ID            PIC X(02) VALUE SPACES.         
           05 OUT-DELMTR-19             PIC X(01) VALUE '|'.            
           05 OUT-DIGTL-MTR-TYPE        PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-20             PIC X(01) VALUE '|'.            
           05 OUT-READ-CYCLE            PIC X(02) VALUE SPACES.         
           05 OUT-DELMTR-21             PIC X(01) VALUE '|'.            
           05 OUT-SUBSTATION-ID         PIC X(05) VALUE SPACES.         
           05 OUT-DELMTR-22             PIC X(01) VALUE '|'.            
           05 OUT-CIRCUIT-ID            PIC X(05) VALUE SPACES.         
           05 OUT-DELMTR-23             PIC X(01) VALUE '|'.            
           05 OUT-MTR-LOC               PIC X(14) VALUE SPACES.         
           05 OUT-DELMTR-24             PIC X(01) VALUE '|'.            
           05 OUT-LAST-READ-DATE        PIC X(10) VALUE SPACES.         
           05 OUT-DELMTR-25             PIC X(01) VALUE '|'.            
           05 OUT-LAST-READ-CD          PIC X(23) VALUE SPACES.         
           05 OUT-DELMTR-26             PIC X(01) VALUE '|'.            
           05 OUT-LAST-READ             PIC 9(10) VALUE ZEROES.         
           05 OUT-DELMTR-27             PIC X(01) VALUE '|'.            
           05 OUT-NAME                  PIC X(40) VALUE SPACES.         
           05 OUT-DELMTR-28             PIC X(01) VALUE '|'.            
           05 OUT-PHONE                 PIC X(10) VALUE SPACES.         
           05 OUT-DELMTR-29             PIC X(01) VALUE '|'.            
           05 OUT-PRESSURE              PIC X(04) VALUE SPACES.         
           05 OUT-DELMTR-30             PIC X(01) VALUE '|'.            
           05 OUT-NO-OF-DRIVES          PIC X(04) VALUE SPACES.         
           05 OUT-DELMTR-31             PIC X(01) VALUE '|'.            
           05 OUT-RD-INST               PIC X(14) VALUE SPACES.         
           05 OUT-DELMTR-32             PIC X(01) VALUE '|'.            
           05 OUT-LATITUDE              PIC X(17) VALUE SPACES.         
           05 OUT-DELMTR-33             PIC X(01) VALUE '|'.            
           05 OUT-LONGITUDE             PIC X(17) VALUE SPACES.         
           05 OUT-DELMTR-34             PIC X(01) VALUE '|'.            
           05 OUT-RRI                   PIC X(01) VALUE SPACES.         
           05 OUT-DELMTR-35             PIC X(01) VALUE '|'.            
           05 OUT-CRIT-OUTAGE           PIC X(02) VALUE SPACES.         
           05 OUT-DELMTR-36             PIC X(01) VALUE '|'.            
           05 OUT-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-37             PIC X(01) VALUE '|'.            
           05 OUT-CODE-REVENUE-CLASS    PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-38             PIC X(01) VALUE '|'.            
           05 OUT-DATE-PURCHASED        PIC X(10) VALUE SPACES.         
           05 OUT-DELMTR-39             PIC X(01) VALUE '|'.            
           05 OUT-DATE-LAST-TESTED      PIC X(10) VALUE SPACES.         
                                                                        
       01 WS-RP613-HDR-REC-LN.                                          
           05 WS-LOC-OFF                PIC X(11) VALUE 'LOC OFFICE|'.  
           05 WS-READ-ROUTE             PIC X(11) VALUE 'READ ROUTE|'.  
           05 WS-ACCT-NO                PIC X(11) VALUE 'ACCOUNT NO|'.  
           05 WS-TYP-SVC                PIC X(11) VALUE 'SVC TYPE  |'.  
           05 WS-METER-NO               PIC X(11) VALUE 'METER NO  |'.  
           05 WS-SERIAL-NO              PIC X(11) VALUE 'SERIAL NO |'.  
           05 WS-ERT-ID                 PIC X(11) VALUE 'ERT ID    |'.  
           05 WS-REGISTER-RD-SEQ        PIC X(11) VALUE 'READ SEQ  |'.  
           05 WS-METER-SIZE-ID          PIC X(11) VALUE 'MTR SIZEID|'.  
           05 WS-ELEC-MTR-CLASS-CD      PIC X(11) VALUE 'CLASS CD  |'.  
           05 WS-ELEC-MTR-SPEC-CD       PIC X(11) VALUE 'SPEC CD   |'.  
           05 WS-CONSTANT               PIC X(11) VALUE 'CONSTANT  |'.  
           05 WS-NO-DIALS               PIC X(11) VALUE 'DIALS     |'.  
           05 WS-DBA-NM                 PIC X(11) VALUE 'DBA       |'.  
           05 WS-HDR-HOUSE-NBR          PIC X(11) VALUE 'HOUSE NBR |'.  
           05 WS-SVC-ADDR-1             PIC X(11) VALUE 'SVC ADDR1 |'.  
           05 WS-SVC-ADDR-OVERFLOW      PIC X(11) VALUE 'ADDR OVFLW|'.  
           05 WS-SVC-ADDR-2             PIC X(11) VALUE 'SVC ADDR2 |'.  
           05 WS-PREMISE-DIRECTIONS     PIC X(11) VALUE 'PR DIRECTN|'.  
           05 WS-PROGRAM-ID             PIC X(11) VALUE 'PROGRAM ID|'.  
           05 WS-DIGTL-MTR-TYPE         PIC X(11) VALUE 'DMT       |'.  
           05 WS-READ-CYCLE             PIC X(11) VALUE 'READ CYCLE|'.  
           05 WS-SUBSTATION-ID          PIC X(11) VALUE 'SUBSTN ID |'.  
           05 WS-CIRCUIT-ID             PIC X(11) VALUE 'CIRCUIT ID|'.  
           05 WS-MTR-LOCATION           PIC X(11) VALUE 'MTR LOC   |'.  
           05 WS-LAST-READ-DATE         PIC X(11) VALUE 'LST RD DTE|'.  
           05 WS-LAST-READ-CD           PIC X(11) VALUE 'LST RD CD |'.  
           05 WS-LAST-READ              PIC X(11) VALUE 'LST READ  |'.  
           05 WS-NAME                   PIC X(11) VALUE 'NAME      |'.  
           05 WS-PHONE                  PIC X(11) VALUE 'PHONE     |'.  
           05 WS-PRESSURE               PIC X(11) VALUE 'PRESSURE  |'.  
           05 WS-NO-OF-DRIVES           PIC X(11) VALUE 'DRIVES    |'.  
           05 WS-RD-INST                PIC X(11) VALUE 'READ INST |'.  
           05 WS-LATITUDE               PIC X(11) VALUE 'LATITUDE  |'.  
           05 WS-LONGITUDE              PIC X(11) VALUE 'LONGITUDE |'.  
           05 WS-RRI                    PIC X(11) VALUE 'RRI       |'.  
           05 WS-CRIT-OUTAGE            PIC X(11) VALUE 'CRIT OUTAG|'.  
           05 WS-RATE-PLAN-NO           PIC X(11) VALUE 'RATE PLAN |'.  
           05 WS-CODE-REVENUE-CLASS     PIC X(11) VALUE 'REV CLASS |'.  
           05 WS-DATE-PURCHASED         PIC X(11) VALUE 'PURCH DATE|'.  
           05 WS-DATE-LAST-TESTED       PIC X(11) VALUE 'LST TST DT|'.  
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESSD      PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-SWITCH.                                                    
           05  WS-FCA770-STATUS         PIC X(02).                      
               88 FCA770-SUCCESSFUL               VALUE '00'.           
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
           05  WS-FIRST                 PIC X(01) VALUE 'Y'.            
           05  WS-FIRST-TYM             PIC X(01) VALUE 'Y'.            
           05  WS-CHECK                 PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-NULL-IND1             PIC S9(02)    COMP VALUE 0.     
           05  WS-NULL-IND2             PIC S9(02)    COMP VALUE 0.     
           05  WS-UTIL-TYPE             PIC X(02) VALUE SPACES.         
           05  WS-OTHER-SVC             PIC X(01) VALUE SPACES.         
           05  WS-NO-REPORT             PIC X(01) VALUE 'Y'.            
           05  WS-P-ACCT                PIC S9(07)V    VALUE 0 COMP-3.  
      *                                                                         
           05  WS-ACCOUNT-NO            PIC S9(07)V    VALUE 0 COMP-3.  
           05  WS-ACCOUNT-NOX              REDEFINES                    
               WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-START-POS1            PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-START-POS2            PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-LEN                   PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-ADDR-LEN              PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-ONE                   PIC S9(02)V    VALUE 1 COMP-3.  
           05  WS-ADDRESS-LENGTH1       PIC S9(02)V    VALUE 50 COMP-3. 
           05  WS-ADDRESS-LENGTH2       PIC S9(02)V    VALUE 37 COMP-3. 
           05  WS-LENGTH                PIC S9(02)V    VALUE 7 COMP-3.  
           05  WS-ZEROS                 PIC 9(07) VALUE ZEROES.         
           05  WS-HOUSE-NBR             PIC 9(07) VALUE ZEROES.         
           05  WS-HOUSE-NUMBERX            REDEFINES                    
               WS-HOUSE-NBR             PIC X(07).                      
           05  WS-PRT-ACCOUNT-NO        PIC 9(13) VALUE ZEROES.         
           05  WS-SPACES                PIC X(01) VALUE ' '.            
           05  WS-TYPE-SVC              PIC X(01) VALUE SPACES.         
           05  WS-PREMISE-NO            PIC S9(06)V    VALUE 0 COMP-3.  
           05  WS-FULL-NAME             PIC X(40) VALUE SPACES.         
           05  WS-ADDRESS-1             PIC X(50) VALUE SPACES.         
           05  WS-ADDRESS-2             PIC X(40) VALUE SPACES.         
           05  WS-PREV-ACCT             PIC 9(13) VALUE ZEROES.         
           05  WS-FMT-ACCT              PIC 9999999999999 VALUE ZEROES. 
           05  WS-MTR-LOC               PIC X(14) VALUE SPACES.         
           05  WS-MTR-RD-INST           PIC X(14) VALUE SPACES.         
           05  WS-DBA-NAME              PIC X(70) VALUE SPACES.         
           05  SUBSTATION-ID            PIC X(05) VALUE SPACES.         
           05  CIRCUIT-ID               PIC X(05) VALUE SPACES.         
           05  WS-ELEC-MTR-FORM-CD      PIC X(04) VALUE SPACES.         
           05  WS-ALT-ELEC-MTR-FM-CD    PIC X(04) VALUE SPACES.         
           05  WS-DEVICE-NO             PIC X(12) VALUE SPACES.         
           05  WS-LAT-N                 PIC 9(09) VALUE ZEROES.         
           05  WS-LONG-N                PIC 9(09) VALUE ZEROES.         
           05  WS-SVC-ADDR-LINE-1       PIC X(50) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-2       PIC X(37) VALUE SPACES.         
           05  WS-FMT-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-FMT-ADDR-LINE-3       PIC X(36) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-ABEND-PGM-FG          PIC X(01) VALUE 'N'.            
           05  WS-ZIP-CODE-SADDR        PIC X(05) VALUE SPACES.         
           05  WS-ZIP-CD-PL-FOUR-SADDR  PIC X(04) VALUE SPACES.         
           05  WS-SVC-ZIP-PLUS-4        PIC X(10) VALUE SPACES.         
HEX01      05  WS-DELIM                 PIC X(01) VALUE X'09'.          
           05  WS-CNT                   PIC 9(07) VALUE ZEROES.         
           05  WS-CNT1                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT2                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT3                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT4                  PIC 9(07) VALUE ZEROES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-ADDRESS-FORMAT-FIELDS.                                    
           05  WS-HOUSE-NO              PIC X(07) VALUE SPACES.         
           05  WS-HOUSE-NO-N            PIC X(07).                      
           05  WS-HOUSE-NO6 REDEFINES WS-HOUSE-NO-N.                    
               10  WS-HOUSE-FILL-6      PIC 9(06).                      
               10  WS-HOUSE-NO-6        PIC 9(01).                      
           05  WS-HOUSE-NO5 REDEFINES WS-HOUSE-NO6.                     
               10  WS-HOUSE-FILL-5      PIC 9(05).                      
               10  WS-HOUSE-NO-5        PIC 9(02).                      
           05  WS-HOUSE-NO4 REDEFINES WS-HOUSE-NO5.                     
               10  WS-HOUSE-FILL-4      PIC 9(04).                      
               10  WS-HOUSE-NO-4        PIC 9(03).                      
           05  WS-HOUSE-NO3 REDEFINES WS-HOUSE-NO4.                     
               10  WS-HOUSE-FILL-3      PIC 9(03).                      
               10  WS-HOUSE-NO-3        PIC 9(04).                      
           05  WS-HOUSE-NO2 REDEFINES WS-HOUSE-NO3.                     
               10  WS-HOUSE-FILL-2      PIC 9(02).                      
               10  WS-HOUSE-NO-2        PIC 9(05).                      
           05  WS-HOUSE-NO1 REDEFINES WS-HOUSE-NO2.                     
               10  WS-HOUSE-FILL-1      PIC 9(01).                      
               10  WS-HOUSE-NO-1        PIC 9(06).                      
      *                                                                         
       01 WS-FMT-ADDR-LINE-1.                                           
           05  WS-HNO                   PIC X(05) VALUE SPACES.         
           05  WS-FILLER-3              PIC X(01) VALUE SPACES.         
           05  WS-APREFIX               PIC X(03) VALUE SPACES.         
           05  WS-FILLER-6              PIC X(01) VALUE SPACES.         
           05  WS-APREFIX2              PIC X(02) VALUE SPACES.         
           05  WS-FILLER-7              PIC X(01) VALUE SPACES.         
           05  WS-SNAME                 PIC X(16) VALUE SPACES.         
           05  WS-FILLER-8              PIC X(01) VALUE SPACES.         
           05  WS-SSUFFIX               PIC X(04) VALUE SPACES.         
           05  WS-FILLER-9              PIC X(01) VALUE SPACES.         
           05  WS-ASUFFIX               PIC X(02) VALUE SPACES.         
           05  WS-FILLER-10             PIC X(01) VALUE SPACES.         
           05  WS-SLOCATION-1           PIC X(04) VALUE SPACES.         
           05  WS-FILLER-11             PIC X(01) VALUE SPACES.         
           05  WS-SLOCATION-2           PIC X(06) VALUE SPACES.         
      *                                                                         
       01 WS-FMT-ADDR-LINE-2.                                           
           05  WS-TWN                   PIC X(24) VALUE SPACES.         
           05  WS-STT                   PIC X(02) VALUE SPACES.         
           05  WS-FILLER-4              PIC X(01) VALUE SPACES.         
           05  WS-ZIPCD                 PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-FMT-NAME.                                                  
           05  WS-FNAME                 PIC X(15) VALUE SPACES.         
           05  WS-FILLER-1              PIC X(01) VALUE SPACES.         
           05  WS-MNAME                 PIC X(01) VALUE SPACES.         
           05  WS-FILLER-2              PIC X(01) VALUE SPACES.         
           05  WS-LNAME                 PIC X(19) VALUE SPACES.         
      *                                                                         
       01 WS-ZIP-CD.                                                    
           05  WS-ZIP-CODE              PIC X(05) VALUE 'N'.            
           05  WS-FILLER-5              PIC X(01) VALUE 'N'.            
           05  WS-ZIP-CD-PL-FOUR        PIC X(04) VALUE 'N'.            
           05  WS-ADDR-ZIP-CD-5         PIC X(05) VALUE 'N'.            
           05  WS-ADDR-ZIP-CD-4         PIC X(04) VALUE 'N'.            
      *                                                                         
       01 WS-P-UTIL.                                                    
           05  WS-P-UTIL-E              PIC X(01).                      
           05  WS-P-UTIL-G              PIC X(01).                      
      *                                                                         
       01 WS-LAT.                                                       
           05  WS-LAT-INT               PIC X(03).                      
           05  WS-LAT-DEC               PIC X(06).                      
      *                                                                         
       01 WS-LONG.                                                      
           05  WS-LONG-INT              PIC X(03).                      
           05  WS-LONG-DEC              PIC X(06).                      
      *                                                                         
       01 WS-LAT-1.                                                     
           05  WS-LAT-INT-1             PIC X(03).                      
           05  WS-LAT-DOT               PIC X(01).                      
           05  WS-LAT-DEC-1             PIC X(06).                      
      *                                                                         
       01 WS-LONG-1.                                                    
           05  WS-LONG-SIGN             PIC X(01).                      
           05  WS-LONG-INT-1            PIC X(03).                      
           05  WS-LONG-DOT              PIC X(01).                      
           05  WS-LONG-DEC-1            PIC X(06).                      
      *                                                                         
       01 WS-UT-CLASS.                                                  
           05  WS-UT1                   PIC X(01).                      
           05  WS-UT2                   PIC X(01).                      
           05  WS-UT3                   PIC X(01).                      
      *                                                                         
       01 WS-ERT-ID-A.                                                  
           05  WS-ERT-ID-P1             PIC X(01).                      
           05  WS-ERT-ID-P2             PIC X(09).                      
      *                                                                         
      ***************************************************************           
      *CURSOR FOR WRITE OFFS - MAIN CURSOR                          *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE GET_DET CURSOR FOR                                 
                SELECT AT.LOCAL_OFFICE                                  
                      ,UT.READ_ROUTE                                    
                      ,MN.REGISTER_RD_SEQ                               
                      ,MN.CODE_UTIL_TYPE                                
                      ,AT.ACCOUNT_NO                                    
                      ,MN.METER_NO                                      
                      ,AT.CUSTOMER_NO                                   
                      ,AT.PREMISE_NO                                    
                      ,AT.COMPANY_NO                                    
                      ,MN.PROGRAM_ID                                    
                      ,MN.DIGTL_MTR_TYPE                                
                      ,UT.READ_CYCLE                                    
                      ,UT.CODE_REVENUE_CLASS                            
                      ,MN.GIS_POINT_ID                                  
                      ,MN.CODE_LAST_REG_READ                            
                      ,MN.LAST_REG_READ_DATE                            
                      ,MN.LAST_READ_VALUE                               
                      ,Q4.METER_LOC_DESC                                
                      ,MN.CODE_MTR_RD_INST1                             
                      ,MN.MTR_READ_SOURCE_CD                            
                      ,PR.PREM_REF_LATITUDE                             
                      ,PR.PREM_REF_LONGITUDE                            
                      ,MN.REMOTE_READ_IND                               
                      ,PR.SPCL_READ_INSTR                               
                      ,AT.CODE_CRIT_OUTAGE                              
                      ,UT.RATE_PLAN_NO                                  
                      ,EQ.CODE_CRNT_LOC                                 
                      ,EQ.DATE_PURCHASED                                
                      ,EM.METER_SIZE_ID                                 
                      ,EM.ELEC_MTR_CLASS_CD                             
                      ,EM.ELEC_MTR_SPEC_CD                              
                      ,EM.DATE_LAST_TESTED                              
                      ,MC.CONSTANT                                      
                      ,MC.NO_DIALS                                      
                      ,MC.NO_READ_DIALS                                 
                      ,PR.PREMISE_DIRECTIONS                            
                      ,EQ.SERIAL_NO                                     
                      ,CU.NAME_ID                                       
                      ,PR.ADDRESS_ID                                    
                  FROM CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                   
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
                      ,CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                      ,CSS_METER_LOC Q4 WITH(READUNCOMMITTED)                   
                      ,CSS_EQUIPMENT  EQ WITH(READUNCOMMITTED)                  
                      ,CSS_ELEC_METER EM WITH(READUNCOMMITTED)                  
                      ,CSS_MTR_CAP    MC WITH(READUNCOMMITTED)                  
                      ,CSS_CUSTOMER  CU WITH(READUNCOMMITTED)                   
                  WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO               
                    AND MN.ACCOUNT_NO     = UT.ACCOUNT_NO               
                    AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO              
                    AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE           
                    AND PR.PREMISE_NO     = AT.PREMISE_NO               
                    AND UT.IC_NO          = MN.IC_NO                    
                    AND UT.COMPANY_NO     = AT.COMPANY_NO               
                    AND UT.COMPANY_NO     = EQ.COMPANY_NO               
                    AND MN.METER_NO       = EQ.DEVICE_NO                
                    AND MN.METER_NO       = EM.METER_NO                 
                    AND MN.METER_NO       = MC.METER_NO                 
                    AND EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE           
                    AND EQ.DEVICE_NO      = EM.METER_NO                 
                    AND EQ.COMPANY_NO     = EM.COMPANY_NO               
                    AND EQ.DEVICE_NO      = MC.METER_NO                 
                    AND EQ.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE           
                    AND EQ.COMPANY_NO     = MC.COMPANY_NO               
                    AND MC.REG_ID_NO      = MN.REG_ID_NO                
                    AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC           
                    AND MN.CODE_UTIL_TYPE = 'E'                         
                    AND AT.COMPANY_NO     = '01'                        
                    AND EQ.COMPANY_NO     = '01'                        
                    AND EQ.CODE_UTIL_TYPE = 'E'                         
                    AND EQ.CODE_CRNT_LOC  = 'J'                         
                    AND MN.CODE_METER_STATUS <> 'K'                     
                  FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE GET_DET CURSOR FOR                                         
MFA-TR*         SELECT AT.LOCAL_OFFICE                                          
MFA-TR*               ,UT.READ_ROUTE                                            
MFA-TR*               ,MN.REGISTER_RD_SEQ                                       
MFA-TR*               ,MN.CODE_UTIL_TYPE                                        
MFA-TR*               ,AT.ACCOUNT_NO                                            
MFA-TR*               ,MN.METER_NO                                              
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,MN.PROGRAM_ID                                            
MFA-TR*               ,MN.DIGTL_MTR_TYPE                                        
MFA-TR*               ,UT.READ_CYCLE                                            
MFA-TR*               ,UT.CODE_REVENUE_CLASS                                    
MFA-TR*               ,MN.GIS_POINT_ID                                          
MFA-TR*               ,MN.CODE_LAST_REG_READ                                    
MFA-TR*               ,MN.LAST_REG_READ_DATE                                    
MFA-TR*               ,MN.LAST_READ_VALUE                                       
MFA-TR*               ,Q4.METER_LOC_DESC                                        
MFA-TR*               ,MN.CODE_MTR_RD_INST1                                     
MFA-TR*               ,MN.MTR_READ_SOURCE_CD                                    
MFA-TR*               ,PR.PREM_REF_LATITUDE                                     
MFA-TR*               ,PR.PREM_REF_LONGITUDE                                    
MFA-TR*               ,MN.REMOTE_READ_IND                                       
MFA-TR*               ,PR.SPCL_READ_INSTR                                       
MFA-TR*               ,AT.CODE_CRIT_OUTAGE                                      
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,EQ.CODE_CRNT_LOC                                         
MFA-TR*               ,EQ.DATE_PURCHASED                                        
MFA-TR*               ,EM.METER_SIZE_ID                                         
MFA-TR*               ,EM.ELEC_MTR_CLASS_CD                                     
MFA-TR*               ,EM.ELEC_MTR_SPEC_CD                                      
MFA-TR*               ,EM.DATE_LAST_TESTED                                      
MFA-TR*               ,MC.CONSTANT                                              
MFA-TR*               ,MC.NO_DIALS                                              
MFA-TR*               ,MC.NO_READ_DIALS                                         
MFA-TR*               ,PR.PREMISE_DIRECTIONS                                    
MFA-TR*               ,EQ.SERIAL_NO                                             
MFA-TR*               ,CU.NAME_ID                                               
MFA-TR*               ,PR.ADDRESS_ID                                            
MFA-TR*           FROM CSS_ACCOUNT   AT                                         
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_MTRD_ENVRNMT MN                                      
MFA-TR*               ,CSS_PREMISE PR                                           
MFA-TR*               ,CSS_METER_LOC Q4                                         
MFA-TR*               ,CSS_EQUIPMENT  EQ                                        
MFA-TR*               ,CSS_ELEC_METER EM                                        
MFA-TR*               ,CSS_MTR_CAP    MC                                        
MFA-TR*               ,CSS_CUSTOMER  CU                                         
MFA-TR*           WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO                       
MFA-TR*             AND MN.ACCOUNT_NO     = UT.ACCOUNT_NO                       
MFA-TR*             AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                      
MFA-TR*             AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                   
MFA-TR*             AND PR.PREMISE_NO     = AT.PREMISE_NO                       
MFA-TR*             AND UT.IC_NO          = MN.IC_NO                            
MFA-TR*             AND UT.COMPANY_NO     = AT.COMPANY_NO                       
MFA-TR*             AND UT.COMPANY_NO     = EQ.COMPANY_NO                       
MFA-TR*             AND MN.METER_NO       = EQ.DEVICE_NO                        
MFA-TR*             AND MN.METER_NO       = EM.METER_NO                         
MFA-TR*             AND MN.METER_NO       = MC.METER_NO                         
MFA-TR*             AND EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.DEVICE_NO      = EM.METER_NO                         
MFA-TR*             AND EQ.COMPANY_NO     = EM.COMPANY_NO                       
MFA-TR*             AND EQ.DEVICE_NO      = MC.METER_NO                         
MFA-TR*             AND EQ.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                   
MFA-TR*             AND EQ.COMPANY_NO     = MC.COMPANY_NO                       
MFA-TR*             AND MC.REG_ID_NO      = MN.REG_ID_NO                        
MFA-TR*             AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = 'E'                                 
MFA-TR*             AND AT.COMPANY_NO     = '01'                                
MFA-TR*             AND EQ.COMPANY_NO     = '01'                                
MFA-TR*             AND EQ.CODE_UTIL_TYPE = 'E'                                 
MFA-TR*             AND EQ.CODE_CRNT_LOC  = 'J'                                 
MFA-TR*             AND MN.CODE_METER_STATUS <> 'K'                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 08230000
           OPEN OUTPUT FCSPT770-FILE.                                   
                                                                        
           IF NOT FCA770-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP613 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT770-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA770-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
           INITIALIZE PRT770-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
                                                                        
           MOVE SPACES                      TO PR-PREMISE-DIRECTIONS.   
                                                                        
           PERFORM 8100-WRITE-OUTFILE-HEADER        THRU  8100-EXIT.    
                                                                        
           PERFORM 7100-OPEN-MAIN-CSR               THRU  7100-EXIT.    
                                                                        
           PERFORM 7200-FETCH-MAIN-CSR              THRU  7200-EXIT.    
                                                                        
           PERFORM 2010-PROCESS-ACCT-ADDR           THRU  2010-EXIT     
           UNTIL WS-ALL-ROWS-PROCESD = WS-Y.                            
                                                                        
           PERFORM 7300-CLOSE-MAIN-CSR              THRU  7300-EXIT.    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2010-PROCESS-ACCT-ADDR.                                      **        
      ******************************************************************        
      *                                                                         
       2010-PROCESS-ACCT-ADDR.                                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
             MOVE ZEROES                    TO WS-CPD99-ACCOUNT-NO      
             MOVE AT-PREMISE-NO             TO WS-CPD99-PREMISE-NO      
                                                                        
             PERFORM 6990-FETCH-CUR-ACCOUNT         THRU 6990-EXIT      
                                                                        
             IF AT-ACCOUNT-NO = WS-CPD99-ACCOUNT-NO                     
               MOVE AT-ACCOUNT-NO           TO WS-ACCOUNT-NO            
                                               WS-ACCOUNT-NOX           
               MOVE AT-PREMISE-NO           TO WS-PREMISE-NO            
               MOVE MN-CODE-UTIL-TYPE       TO WS-TYPE-SVC              
               MOVE SPACES                  TO WS-FMT-NAME              
                                               WS-FULL-NAME             
                                               WS-FMT-ADDR-LINE-1       
                                               WS-FMT-ADDR-LINE-2       
               IF MC-CONSTANT > 1                                       
                 MOVE SPACES                TO WS-FMT-NAME              
                                                                        
                 PERFORM 7400-GET-NAME              THRU 7400-EXIT      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                   MOVE DQ-FULL-NAME        TO WS-FMT-NAME              
                 END-IF                                                 
               END-IF                                                   
                                                                        
               MOVE WS-FMT-NAME             TO WS-FULL-NAME             
                                                                        
               PERFORM 2100-GET-ADDR                THRU 2100-EXIT      
               MOVE WS-SVC-ADDR-LINE-1      TO WS-ADDRESS-1             
               MOVE WS-SVC-ADDR-LINE-2      TO WS-ADDRESS-2             
                                                                        
               PERFORM 7750-GET-ERT-ID              THRU 7750-EXIT      
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                 MOVE SPACES                TO WS-DEVICE-NO             
               END-IF                                                   
                                                                        
               PERFORM 7800-GET-OTHER-DET2          THRU 7800-EXIT      
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                 MOVE SPACES                TO SUBSTATION-ID            
                                               CIRCUIT-ID               
               END-IF                                                   
               PERFORM 2600-LOAD-UNINSTAL-MTR       THRU 2600-EXIT      
                                                                        
               PERFORM 2900-FORMAT-OUTPUT           THRU 2900-EXIT      
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7200-FETCH-MAIN-CSR              THRU 7200-EXIT.     
                                                                        
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-GET-ADDR.                                               **        
      ******************************************************************        
      *                                                                         
       2100-GET-ADDR.                                                   
                                                                        
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-1       
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-OVERFLOW
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-2       
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-3       
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-1       
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-OVERFLOW
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-2       
                                                                        
           PERFORM 2200-FMT-SVC-ADDR                THRU 2200-EXIT.     
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-FMT-SVC-ADDR.                                           **        
      ******************************************************************        
      *                                                                         
       2200-FMT-SVC-ADDR.                                               
      *                                                                         
           MOVE PR-ADDRESS-ID               TO DY-ADDRESS-ID            
                                                                        
           PERFORM 7500-GET-FMT-SVC-ADDR            THRU 7500-EXIT      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE 'Y'                       TO WS-ABEND-PGM-FG          
           ELSE                                                         
             MOVE 'N'                       TO WS-ABEND-PGM-FG          
           END-IF                                                       
                                                                        
           IF WS-ABEND-PGM-FG = 'N'                                     
                                                                        
             MOVE DY-ZIP-CODE               TO WS-ZIP-CODE              
             MOVE DY-ZIP-CODE-PLUS-FOUR     TO WS-ZIP-CD-PL-FOUR        
             MOVE DY-ZIP-CODE               TO WS-ZIP-CODE-SADDR        
             MOVE DY-ZIP-CODE-PLUS-FOUR     TO WS-ZIP-CD-PL-FOUR-SADDR  
                                                                        
             IF WS-ZIP-CD-PL-FOUR = '    '                              
               MOVE ' '                     TO WS-FILLER-5              
             ELSE                                                       
               MOVE '-'                     TO WS-FILLER-5              
             END-IF                                                     
                                                                        
             MOVE WS-ZIP-CD                 TO WS-SVC-ZIP-PLUS-4        
             MOVE DY-ZIP-CODE               TO A4-ZIP-CODE              
             MOVE DY-ZIP-CODE-TOKEN         TO A4-ZIP-CODE-TOKEN        
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             PERFORM 7700-GET-TOWN-DETAILS          THRU 7700-EXIT      
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y'                     TO WS-ABEND-PGM-FG          
             ELSE                                                       
               MOVE 'N'                     TO WS-ABEND-PGM-FG          
             END-IF                                                     
                                                                        
             IF WS-ABEND-PGM-FG = 'N'                                   
                                                                        
             PERFORM 2300-FORMAT-FORM-ADDR          THRU 2300-EXIT      
                                                                        
             MOVE WS-FMT-ADDR-LINE-1        TO WS-EMB-INPUT             
             MOVE 50                        TO WS-EMB-LENG              
             PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6011-EXIT    
             MOVE WS-CMP-TABLE              TO WS-SVC-ADDR-LINE-1       
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             MOVE WS-FMT-ADDR-LINE-2        TO WS-EMB-INPUT             
             MOVE 37                        TO WS-EMB-LENG              
             PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6011-EXIT    
             MOVE WS-CMP-TABLE              TO WS-SVC-ADDR-LINE-2       
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             MOVE WS-FMT-ADDR-LINE-OVERFLOW TO WS-SVC-ADDR-LINE-OVERFLOW
             END-IF                                                     
                                                                        
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-FORMAT-FORM-ADDR.                                       **        
      ******************************************************************        
      *                                                                         
       2300-FORMAT-FORM-ADDR.                                           
                                                                        
           IF WS-ABEND-PGM-FG = 'N'                                     
             MOVE DY-HOUSE-NO               TO WS-HOUSE-NO              
                                                                        
             MOVE WS-HOUSE-NO               TO WS-HOUSE-NO-N            
             MOVE ZEROES                    TO WS-CNT                   
                                                                        
             INSPECT WS-HOUSE-NO TALLYING WS-CNT FOR ALL ' '            
                                                                        
             IF WS-HOUSE-NO = SPACES                                    
               MOVE '0000000'               TO WS-HOUSE-NO-N            
             ELSE                                                       
               PERFORM 2400-HOUSE-NUMBER            THRU 2400-EXIT      
             END-IF                                                     
                                                                        
             MOVE DY-ADDR-PREFIX-1          TO WS-APREFIX               
             MOVE DY-ADDR-PREFIX-2          TO WS-APREFIX2              
             MOVE DY-STREET-LOCATION-1      TO WS-SLOCATION-1           
             MOVE DY-STREET-LOCATION-2      TO WS-SLOCATION-2           
             MOVE DY-STREET-NAME            TO WS-SNAME                 
             MOVE DY-STREET-SUFFIX          TO WS-SSUFFIX               
             MOVE DY-ADDR-SUFFIX            TO WS-ASUFFIX               
             MOVE A4-TOWN                   TO WS-TWN                   
             MOVE A4-STATE                  TO WS-STT                   
             MOVE WS-ZIP-CD                 TO WS-ZIPCD                 
             MOVE DY-ADDRESS-OVERFLOW       TO WS-FMT-ADDR-LINE-OVERFLOW
                                                                        
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-HOUSE-NUMBER.                                           **        
      ******************************************************************        
      *                                                                         
       2400-HOUSE-NUMBER.                                               
                                                                        
           IF WS-CNT = ZEROES                                           
              MOVE WS-HOUSE-NO-N   TO OUT-HOUSE-NBR                     
           ELSE                                                         
           IF WS-CNT = 1                                                
              MOVE '0'             TO OUT-HOUSE-NBR(1:1)                
              MOVE WS-HOUSE-NO-N(1:6)   TO OUT-HOUSE-NBR(2:6)           
           ELSE                                                         
           IF WS-CNT = 2                                                
              MOVE '00'            TO OUT-HOUSE-NBR(1:2)                
              MOVE WS-HOUSE-NO-N(1:5)   TO OUT-HOUSE-NBR(3:5)           
           ELSE                                                         
           IF WS-CNT = 3                                                
              MOVE '000'           TO OUT-HOUSE-NBR(1:3)                
              MOVE WS-HOUSE-NO-N(1:4)   TO OUT-HOUSE-NBR(4:4)           
           ELSE                                                         
           IF WS-CNT = 4                                                
              MOVE '0000'          TO OUT-HOUSE-NBR(1:4)                
              MOVE WS-HOUSE-NO-N(1:3)   TO OUT-HOUSE-NBR(5:3)           
           ELSE                                                         
           IF WS-CNT = 5                                                
              MOVE '00000'         TO OUT-HOUSE-NBR(1:5)                
              MOVE WS-HOUSE-NO-N(1:2)   TO OUT-HOUSE-NBR(6:2)           
           ELSE                                                         
           IF WS-CNT = 6                                                
              MOVE '000000'        TO OUT-HOUSE-NBR(1:6)                
              MOVE WS-HOUSE-NO-N(1:1)   TO OUT-HOUSE-NBR(7:1)           
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-LOAD-UNINSTAL-MTR.                                      **        
      ******************************************************************        
      *                                                                         
       2600-LOAD-UNINSTAL-MTR.                                          
      *                                                                         
           MOVE 'E'                         TO OUT-TYPE-SVC             
           MOVE EM-METER-SIZE-ID            TO OUT-METER-SIZE-ID        
           MOVE EM-ELEC-MTR-CLASS-CD        TO OUT-ELEC-MTR-CLASS-CD    
           MOVE EM-ELEC-MTR-SPEC-CD         TO OUT-ELEC-MTR-SPEC-CD     
           MOVE MC-CONSTANT                 TO OUT-CONSTANT             
           MOVE MC-NO-DIALS                 TO OUT-NO-DIALS             
           MOVE MN-METER-NO                 TO OUT-METER-NO             
           MOVE MN-PROGRAM-ID               TO OUT-PROGRAM-ID           
           MOVE EQ-DATE-PURCHASED           TO OUT-DATE-PURCHASED       
           MOVE EM-DATE-LAST-TESTED         TO OUT-DATE-LAST-TESTED.    
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2900-FORMAT-OUTPUT.                                          **        
      ******************************************************************        
      *                                                                         
       2900-FORMAT-OUTPUT.                                              
      *                                                                         
           MOVE AT-LOCAL-OFFICE             TO OUT-LOC-OFF              
           MOVE UT-READ-ROUTE               TO OUT-READ-ROUTE           
           MOVE UT-CODE-REVENUE-CLASS       TO OUT-CODE-REVENUE-CLASS   
           MOVE UT-RATE-PLAN-NO             TO OUT-RATE-PLAN-NO         
           MOVE MN-REGISTER-RD-SEQ          TO OUT-REGISTER-RD-SEQ      
           MOVE MN-CODE-UTIL-TYPE           TO OUT-TYPE-SVC             
           MOVE SUBSTATION-ID               TO OUT-SUBSTATION-ID        
           MOVE CIRCUIT-ID                  TO OUT-CIRCUIT-ID           
           MOVE WS-ACCOUNT-NOX              TO OUT-ACCOUNT-NO           
           MOVE MN-METER-NO                 TO OUT-METER-NO             
                                                                        
           MOVE SPACES                      TO OUT-PREMISE-DIRECTIONS   
           MOVE WS-ADDRESS-1                TO OUT-SVC-ADDR-1           
           MOVE WS-ADDRESS-2                TO OUT-SVC-ADDR-2           
           MOVE MN-PROGRAM-ID               TO OUT-PROGRAM-ID           
           MOVE MN-DIGTL-MTR-TYPE           TO OUT-DIGTL-MTR-TYPE       
           MOVE UT-READ-CYCLE               TO OUT-READ-CYCLE           
           MOVE WS-MTR-LOC                  TO OUT-MTR-LOC              
           MOVE MN-REMOTE-READ-IND          TO OUT-RRI                  
           MOVE WS-DEVICE-NO                TO OUT-ERT-ID               
           MOVE EQ-SERIAL-NO                TO OUT-SERIAL-NO            
           MOVE PR-PREMISE-DIRECTIONS-TEXT  TO OUT-PREMISE-DIRECTIONS   
           MOVE SPACES                      TO PR-PREMISE-DIRECTIONS    
                                                                        
           EVALUATE MN-CODE-LAST-REG-READ                               
                                                                        
             WHEN 'A'                                                   
                 MOVE 'METER INSTALLATION READ' TO OUT-LAST-READ-CD     
             WHEN 'B'                                                   
                 MOVE 'METER EXCHANGE READ'     TO OUT-LAST-READ-CD     
             WHEN 'C'                                                   
                 MOVE 'MANUALLY SET READING'    TO OUT-LAST-READ-CD     
             WHEN 'D'                                                   
                 MOVE 'AWAITING READING'        TO OUT-LAST-READ-CD     
             WHEN 'E'                                                   
                 MOVE 'SYSTEM ESTIMATED'        TO OUT-LAST-READ-CD     
             WHEN 'G'                                                   
                 MOVE 'SERVICE ORDER OFF READ'  TO OUT-LAST-READ-CD     
             WHEN 'J'                                                   
                 MOVE 'NORMAL READING'          TO OUT-LAST-READ-CD     
             WHEN 'K'                                                   
                 MOVE 'VERIFIED READING'        TO OUT-LAST-READ-CD     
             WHEN 'L'                                                   
                 MOVE 'READER ESTIMATED'        TO OUT-LAST-READ-CD     
             WHEN 'S'                                                   
                 MOVE 'CUSTOMER CARD READ'      TO OUT-LAST-READ-CD     
             WHEN 'T'                                                   
                 MOVE 'CUSTOMER CALLED READ'    TO OUT-LAST-READ-CD     
           END-EVALUATE.                                                
                                                                        
           MOVE MN-LAST-REG-READ-DATE       TO OUT-LAST-READ-DATE       
           MOVE MN-LAST-READ-VALUE          TO OUT-LAST-READ            
           MOVE WS-FULL-NAME                TO OUT-NAME                 
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
             MOVE 'H1'                      TO CB-PHONE-TYPE            
           ELSE                                                         
             MOVE 'B1'                      TO CB-PHONE-TYPE            
           END-IF                                                       
                                                                        
           PERFORM 7820-GET-PHONE-NO                THRU 7820-EXIT      
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE SPACES                    TO CB-PHONE-NO              
           END-IF                                                       
                                                                        
           MOVE CB-PHONE-NO                 TO OUT-PHONE                
           MOVE SPACES                      TO WS-MTR-RD-INST           
                                                                        
           PERFORM 7840-GET-RD-INST                 THRU 7840-EXIT      
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE SPACES                    TO WS-MTR-RD-INST           
           END-IF                                                       
           MOVE WS-MTR-RD-INST              TO OUT-RD-INST              
                                                                        
A05460     MOVE SPACES TO WS-DBA-NAME.                                  
           IF MC-CONSTANT > 1                                           
             PERFORM 7920-GET-DBA                   THRU 7920-EXIT      
           END-IF                                                       
                                                                        
           MOVE WS-DBA-NAME                 TO OUT-DBA-NAME             
           MOVE WS-ACCOUNT-NOX              TO WS-FMT-ACCT              
                                                                        
           COMPUTE WS-LAT-N = PR-PREM-REF-LATITUDE * 1000000            
           MOVE WS-LAT-N(1:3)               TO WS-LAT-INT-1             
           MOVE WS-LAT-N(4:6)               TO WS-LAT-DEC-1             
                                                                        
A05460     IF  PR-PREM-REF-LONGITUDE < 0                                
             COMPUTE WS-LONG-N = PR-PREM-REF-LONGITUDE * -1000000       
               MOVE '-'                     TO WS-LONG-SIGN             
           ELSE                                                         
             COMPUTE WS-LONG-N = PR-PREM-REF-LONGITUDE * 1000000        
               MOVE ' '                     TO WS-LONG-SIGN             
           END-IF                                                       
           MOVE WS-LONG-N(1:3)              TO WS-LONG-INT-1            
           MOVE WS-LONG-N(4:6)              TO WS-LONG-DEC-1            
                                                                        
           MOVE '.'                         TO WS-LONG-DOT              
           MOVE '.'                         TO WS-LAT-DOT               
           MOVE '.'                         TO WS-LAT-DOT               
           MOVE '.'                         TO WS-LAT-DOT               
           MOVE WS-LAT-1                    TO OUT-LATITUDE             
           MOVE WS-LONG-1                   TO OUT-LONGITUDE            
           MOVE AT-CODE-CRIT-OUTAGE         TO OUT-CRIT-OUTAGE          
                                                                        
           PERFORM 8200-WRITE-OUTFILE-DETAILS       THRU 8200-EXIT.     
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  6010-REDUCE-EMBEDDED-SPACES                             *              
      ************************************************************              
                                                                        
       COPY CPD00004.                                                           
                                                                        
      ******************************************************************        
      ** 7100-OPEN-MAIN-CSR.                                          **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_DET                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *****'                   
              DISPLAY '** OPEN GET DETAILS ERROR  **'                   
              DISPLAY '** 7100-OPEN-MAIN-CSR      **'                   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED   **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-FETCH-GET-MAIN                                          **        
      ******************************************************************        
      *                                                                         
       7200-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_DET                                             
               INTO  :AT-LOCAL-OFFICE                                   
                    ,:UT-READ-ROUTE                                     
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:MN-CODE-UTIL-TYPE                                 
                    ,:AT-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:MN-PROGRAM-ID                                     
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:UT-READ-CYCLE                                     
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:MN-GIS-POINT-ID                                   
                    ,:MN-CODE-LAST-REG-READ                             
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:MN-LAST-READ-VALUE                                
                    ,:WS-MTR-LOC                                        
                    ,:MN-CODE-MTR-RD-INST1                              
                    ,:MN-MTR-READ-SOURCE-CD                             
                    ,:PR-PREM-REF-LATITUDE                              
                    ,:PR-PREM-REF-LONGITUDE                             
                    ,:MN-REMOTE-READ-IND                                
                    ,:PR-SPCL-READ-INSTR                                
                    ,:AT-CODE-CRIT-OUTAGE                               
                    ,:UT-RATE-PLAN-NO                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-DATE-PURCHASED                                 
                    ,:EM-METER-SIZE-ID                                  
                    ,:EM-ELEC-MTR-CLASS-CD                              
                    ,:EM-ELEC-MTR-SPEC-CD                               
                    ,:EM-DATE-LAST-TESTED :WS-NULL-IND1                  
                    ,:MC-CONSTANT                                       
                    ,:MC-NO-DIALS                                       
                    ,:MC-NO-READ-DIALS                                  
                    ,:PR-PREMISE-DIRECTIONS                             
                    ,:EQ-SERIAL-NO                                      
                    ,:CU-NAME-ID                                        
                    ,:PR-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
      *                                                                         
           WHEN NOT-FOUND                                               
              MOVE WS-Y                      TO WS-ALL-ROWS-PROCESD     
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT ******'                  
              DISPLAY '**  MAIN CURSOR FETCH ERROR **'                  
              DISPLAY '** 7200-FETCH-MAIN-CSR      **'                  
              DISPLAY '** ACCOUNT NUMBER       =' AT-ACCOUNT-NO         
              DISPLAY '** METER NUMBER         =' MN-METER-NO           
              DISPLAY '** REG-ID               =' MN-REG-ID-NO          
              DISPLAY '** PREMISE NUMBER       =' AT-PREMISE-NO         
              DISPLAY '** RETURN CODE          =' WS-ACTIVE-RETURN-CODE 
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-CLOSE-MAIN-CSR                                          **        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_DET                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT ******'                  
              DISPLAY '** CLOSE MAIN CURSOR ERROR  **'                  
              DISPLAY '** 7300-CLOSE-MAIN-CSR      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  NEEDED FOR SOMETHING                                        *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             CONTINUE                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**     PCSRP613 PROCESSING ERROR        **'      
              DISPLAY '** ERROR IN PARA 6995-CPD99-ERROR-ROUTINE '      
              DISPLAY '** PREMISE-NO = ', WS-CPD99-PREMISE-NO           
              DISPLAY '** SQL CODE IS  ', WS-CPD99-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-GET-NAME.                                               **        
      ******************************************************************        
      *                                                                         
       7400-GET-NAME.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME                                       
                INTO :DQ-FULL-NAME                                      
                FROM  CSS_NAME DQ WITH(READUNCOMMITTED)                         
               WHERE  DQ.NAME_ID = :CU-NAME-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.FULL_NAME                                               
MFA-TR*         INTO :DQ-FULL-NAME                                              
MFA-TR*         FROM  CSS_NAME DQ                                               
MFA-TR*        WHERE  DQ.NAME_ID = :CU-NAME-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET FULL NAME               **'               
              DISPLAY '** 7400-GET-NAME               **'               
              DISPLAY '** CUST NAME ID   = ' CU-NAME-ID                 
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-GET-FMT-SVC-ADDR.                                       **        
      ******************************************************************        
      *                                                                         
       7500-GET-FMT-SVC-ADDR.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  HOUSE_NO                                          
                     ,ADDR_PREFIX_1                                     
                     ,ADDR_PREFIX_2                                     
                     ,STREET_NAME                                       
                     ,STREET_SUFFIX                                     
                     ,ZIP_CODE                                          
                     ,ZIP_CODE_PLUS_FOUR                                
                     ,ZIP_CODE_TOKEN                                    
                     ,ADDR_SUFFIX                                       
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,ADDRESS_OVERFLOW                                  
                INTO :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:DY-ZIP-CODE-TOKEN                                 
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-ADDRESS-OVERFLOW                               
                FROM  CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
               WHERE  ADDRESS_ID = :DY-ADDRESS-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*         INTO :DY-HOUSE-NO                                               
MFA-TR*             ,:DY-ADDR-PREFIX-1                                          
MFA-TR*             ,:DY-ADDR-PREFIX-2                                          
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:DY-ZIP-CODE-TOKEN                                         
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM  CSS_ADDR_FORMATTED                                        
MFA-TR*        WHERE  ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** FORMAT ADDRESS              **'               
              DISPLAY '** 7500-GET-FMT-SVC-ADDR           **'           
              DISPLAY '** ADDRESS ID     = ' DY-ADDRESS-ID              
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-GET-TOWN-DETAILS.                                       **        
      ******************************************************************        
      *                                                                         
       7700-GET-TOWN-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  TOWN                                              
                     ,STATE                                             
                INTO :A4-TOWN                                           
                    ,:A4-STATE                                          
                FROM  CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
               WHERE  ZIP_CODE             = :A4-ZIP-CODE               
                 AND  ZIP_CODE_TOKEN       = :A4-ZIP-CODE-TOKEN         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*         INTO :A4-TOWN                                                   
MFA-TR*             ,:A4-STATE                                                  
MFA-TR*         FROM  CSS_ZIP_CODE                                              
MFA-TR*        WHERE  ZIP_CODE             = :A4-ZIP-CODE                       
MFA-TR*          AND  ZIP_CODE_TOKEN       = :A4-ZIP-CODE-TOKEN                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET TOWN DETAILS            **'               
              DISPLAY '** 7700-GET-TOWN-DETAILS           **'           
              DISPLAY '** A4-ZIP-CODE       = ' A4-ZIP-CODE             
              DISPLAY '** A4-ZIP-CODE-TOKEN = ' A4-ZIP-CODE-TOKEN       
              DISPLAY '** RETURN CODE       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7750-GET-ERT-ID.                                             **        
      ******************************************************************        
      *                                                                         
       7750-GET-ERT-ID.                                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DEVICE_NO                                          
                INTO :WS-DEVICE-NO                                      
                FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO = :AT-COMPANY-NO                        
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND METER_NO       = :MN-METER-NO                      
                 AND CODE_ATT_TYPE IN ('IT','SS')                       
               ORDER BY DEVICE_NO DESC                                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DEVICE_NO                                                  
MFA-TR*         INTO :WS-DEVICE-NO                                              
MFA-TR*         FROM CSS_METER_ATTCHMTS                                         
MFA-TR*        WHERE COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND CODE_ATT_TYPE IN ('IT','SS')                               
MFA-TR*        ORDER BY DEVICE_NO DESC                                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET DEVICE NUMBER DETAILS   **'               
              DISPLAY '** 7750-GET-ERT-ID             **'               
              DISPLAY '** AT-COMPANY-NO   =' AT-COMPANY-NO              
              DISPLAY '** MN-CODE-UTIL-TY =' MN-CODE-UTIL-TYPE          
              DISPLAY '** MN-METER-NO     =' MN-METER-NO                
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7800-GET-OTHER-DET2.                                         **        
      ******************************************************************        
      *                                                                         
       7800-GET-OTHER-DET2.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT SUBSTATION_ID                                      
                    ,CIRCUIT_ID                                         
                    ,TAG_NM                                             
                INTO :SUBSTATION-ID                                     
                    ,:CIRCUIT-ID                                        
                FROM  CSS_PIM_POINT PM WITH(READUNCOMMITTED)                    
               WHERE  PM.POINT_ID= :MN-GIS-POINT-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTATION_ID                                              
MFA-TR*             ,CIRCUIT_ID                                                 
MFA-TR*             ,TAG_NM                                                     
MFA-TR*         INTO :SUBSTATION-ID                                             
MFA-TR*             ,:CIRCUIT-ID                                                
MFA-TR*         FROM  CSS_PIM_POINT PM                                          
MFA-TR*        WHERE  PM.POINT_ID= :MN-GIS-POINT-ID                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET OTHER ADDRESS DETAILS   **'               
              DISPLAY '** 7800-GET-OTHER-DET2       **'                 
              DISPLAY '** MN-GIS-POINT-ID =' MN-GIS-POINT-ID            
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7820-GET-PHONE-NO                                            **        
      ******************************************************************        
      *                                                                         
       7820-GET-PHONE-NO.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT PHONE_NO                                           
                INTO :CB-PHONE-NO                                       
                FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :AT-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = 'C'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PHONE_NO                                                   
MFA-TR*         INTO :CB-PHONE-NO                                               
MFA-TR*         FROM CSS_CUST_PHONE                                             
MFA-TR*        WHERE CUSTOMER_NO   = :AT-CUSTOMER-NO                            
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7820                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET PHONE NUMBERS DETAIL    **'               
              DISPLAY '** 7820-GET-PHONE-NO            **'              
              DISPLAY '** AT-CUSTOMER-NO  =' AT-CUSTOMER-NO             
              DISPLAY '** CB-PHONE-TYPE   =' CB-PHONE-TYPE              
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7840-GET-RD-INST                                             **        
      ******************************************************************        
      *                                                                         
       7840-GET-RD-INST.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT MTR_RD_INSTR_DESC                                  
                INTO :WS-MTR-RD-INST                                    
                FROM CSS_MTR_RD_INST WITH(READUNCOMMITTED)                      
               WHERE CODE_MTR_RD_INST = :MN-CODE-MTR-RD-INST1           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_RD_INSTR_DESC                                          
MFA-TR*         INTO :WS-MTR-RD-INST                                            
MFA-TR*         FROM CSS_MTR_RD_INST                                            
MFA-TR*        WHERE CODE_MTR_RD_INST = :MN-CODE-MTR-RD-INST1                   
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7840                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '** GET RD INSTRUCTION DESC DTLS**'               
              DISPLAY '** 7840-GET-RD-INST            **'               
              DISPLAY '** MN-CODE-MTR-RD  =' MN-CODE-MTR-RD-INST1       
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7840-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7920-GET-DBA.                                                **        
      ******************************************************************        
      *                                                                         
       7920-GET-DBA.                                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME                                       
                INTO :WS-DBA-NAME                                       
                FROM CSS_NAME DQ WITH(READUNCOMMITTED)                          
                    ,CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)                
               WHERE AB.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                 AND AB.NAME_TYPE     = 'DB'                            
                 AND AB.NAME_ID       = DQ.NAME_ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.FULL_NAME                                               
MFA-TR*         INTO :WS-DBA-NAME                                               
MFA-TR*         FROM CSS_NAME DQ                                                
MFA-TR*             ,CSS_ACCT_BILL_NMES AB                                      
MFA-TR*        WHERE AB.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*          AND AB.NAME_TYPE     = 'DB'                                    
MFA-TR*          AND AB.NAME_ID       = DQ.NAME_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7920                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP613 ABORT *********'               
              DISPLAY '**   GET DBA DETAILS           **'               
              DISPLAY '** 7920-GET-DBA              **'                 
              DISPLAY '** AT-ACCOUNT-NO   =' AT-ACCOUNT-NO              
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE-HEADER.                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
           WRITE PRT770-RECORD FROM WS-RP613-HDR-REC-LN.                
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT770-RECORD FROM WS-RP613-OUT-REC.                   
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT770-FILE.                                         
                                                                        
           IF NOT FCA770-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP613 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING FCSPT770-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA770-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08386130
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
