       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSRP601.                                         
       DATE-WRITTEN.  04/21/03.                                         
       DATE-COMPILED.                                                   
      ***************************************************************** 00050001
      ***************************************************************** 00060067
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070001
      **                                                             ** 00090001
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100001
      ********                      DB2                       ********* 00110001
      ***************************************************************** 00120001
      **               PROGRAM MODIFICATION LOG                      ** 00140001
      **                                                             ** 00130001
      **    DATE    INITIALS     REASON                              ** 00150001
      **    ----    --------     -----------------                   ** 00160080
      **  04/21/03   SG18894     ORIGINAL VERSION                    ** 00210000
C32277**  03/09/05   SG18894     CHANGES MADE TO REMOVE CMPNT_ID_CD  **         
      **                         CHECK IN 7400- PARA.                **         
C32986**  08/01/05   SG18894     CHANGES MADE TO GENERATE ESTIMATE   **         
      **                         DAY REPORT AFTER ANY MISSING DAYS'  **         
      **                         USAGE IS ESTIMATED FOR A MONTH      **         
C37740**   9/26/08   RF10596     ONLY DO ACCOUNTS WITH               **         
      **                         PROGRAM-ID = 99                     **         
      **                                                             **         
      ***************************************************************** 00170001
           REMARKS.                                                     
                              PCSRP601 NARRATIVE                        
            THIS PROGRAM IS TO REPORT MISSING DAILY READS OF CIG METERS.
            USER SELECTS THE DATE RANGE THROUGH JOB PARM.               
      *                                                                 00240001
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  0100 - 0999     INITIALIZATION                        
                  1000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
C32986 COPY CSSRP601.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
C32986 COPY CFDRP601.                                                           
C32986 COPY FIORP601.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP601'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR PCSRP601 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE             
               'PCSRP601'.                                              
           05  WS-PGRMNAME                 PIC X(08)  VALUE             
               'PCSRP601'.                                              
           05  WS-NO-MORE-DATA             PIC X(01)  VALUE 'N'.        
           05  WS-PARM-REVENUE-MONTH.                                   
               10 WS-PARM-REV-YEAR         PIC 9(04).                   
               10 WS-PARM-REV-MONTH        PIC 9(02).                   
           05  WS-PARM-REV-MONTH-N      REDEFINES                       
                 WS-PARM-REVENUE-MONTH     PIC 9(06).                   
           05  WS-CURR-REV-MONTH           PIC 9(06).                   
           05  WS-PROCESS-REV-MONTH        PIC 9(06).                   
           05  WS-RUN-DATE                 PIC X(10).                   
           05  WS-BASE-RT-TS               PIC X(26).                   
           05  WS-TRNSP-TS                 PIC X(26).                   
           05  WS-FULL-NAME                PIC X(40).                   
           05  WS-DB2-DATE                 PIC X(10).                   
           05  WS-DB2-DATE-R REDEFINES WS-DB2-DATE.                     
               10  WS-DB2-DATE-YY          PIC 9(04).                   
               10  FILLER                  PIC X(01).                   
               10  WS-DB2-DATE-MM          PIC 9(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-DB2-DATE-DD          PIC 9(02).                   
           05  WS-MAX-READ-DT              PIC X(10).                   
           05  WS-MAX-DATE-READ            PIC X(10).                   
           05  WS-MIN-READ-DT              PIC X(10).                   
           05  WS-MIN-DATE-READ            PIC X(10).                   
           05  WS-MONTH-MAX-DT             PIC X(10).                   
           05  WS-MONTH-MIN-DT             PIC X(10).                   
           05  WS-SAVE-INDEX               PIC S9(4)      COMP.         
           05  WS-PREV-ACCT-NO             PIC S9(13) COMP-3 VALUE 0.   
           05  WS-PREV-REV-MONTH           PIC 9(06)           VALUE 0. 
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-WARNING-IND              PIC X(01) VALUE 'N'.         
               88 WS-METER-WARNING                   VALUE 'Y'.         
           05  WS-SKIP-BG-FL               PIC X(01) VALUE 'N'.         
               88 SKIP-BG                            VALUE 'Y'.         
               88 DO-NOT-SKIP-BG                     VALUE 'N'.         
           05  WS-MAIN-CRSR-FL             PIC X(01) VALUE 'N'.         
               88 END-OF-MAIN-CRSR                   VALUE 'Y'.         
           05  WS-MN-CRSR-FL               PIC X(01) VALUE 'N'.         
               88 END-OF-MN-CRSR                     VALUE 'Y'.         
           05  WS-BI-CRSR-FL               PIC X(01) VALUE 'N'.         
               88 END-OF-BI-CRSR                     VALUE 'Y'.         
           05  WS-IC-FOUND-FL              PIC X(01) VALUE 'N'.         
               88 IC-FOUND                           VALUE 'Y'.         
               88 IC-NOT-FOUND                       VALUE 'N'.         
           05  WS-BG-CRSR-FL               PIC X(01) VALUE 'N'.         
               88 END-OF-BG-CRSR                     VALUE 'Y'.         
           05  WS-BG-IC-CRSR-FL            PIC X(01) VALUE 'N'.         
               88 END-OF-BG-IC-CRSR                  VALUE 'Y'.         
           05  WS-CX-CRSR-FL               PIC X(01) VALUE 'N'.         
               88 END-OF-CX-CRSR                     VALUE 'Y'.         
           05  WS-CX-DT-CRSR-FL            PIC X(01) VALUE 'N'.         
               88 END-OF-CX-DT-CRSR                  VALUE 'Y'.         
           05  WS-MV-CRSR-FL               PIC X(01) VALUE 'N'.         
               88 END-OF-MV-CRSR                     VALUE 'Y'.         
           05  WS-CIG-RATE-FL              PIC X(01) VALUE 'N'.         
               88 IT-IS-CIG-RATE                     VALUE 'Y'.         
               88 IT-IS-NOT-CIG-RATE                 VALUE 'N', ' '.    
           05  WS-MISSING-VOL-FL           PIC X(01) VALUE 'N'.         
               88 MISSING-VOL-T                      VALUE 'Y'.         
               88 MISSING-VOL-F                      VALUE 'N', ' '.    
C32986     05  WS-ESTIMATE-VOL-FL          PIC X(01) VALUE 'N'.         
C32986         88 ESTIMATE-VOL-T                     VALUE 'Y'.         
C32986         88 ESTIMATE-VOL-F                     VALUE 'N', ' '.    
           05  WS-EXISTS-IN-OC-FL          PIC X(01) VALUE 'N'.         
               88 EXISTS-IN-OC                       VALUE 'Y'.         
C32986     05  WS-FRP601-STATUS            PIC X(02).                   
C32986         88 FRP601-SUCCESSFUL                  VALUE '00'.        
      *                                                                         
       01  WS-MISSING-DAY-TAB.                                          
           05  WS-MD-TABLE OCCURS 31 TIMES INDEXED BY WS-MD-INDX.       
               10  WS-MD-DAY               PIC X(02).                   
               10  WS-MD-SEP               PIC X(01).                   
      *                                                                         
C32986 01  WS-ESTIMATE-DAY-TAB.                                         
C32986     05  WS-ED-TABLE OCCURS 31 TIMES INDEXED BY WS-ED-INDX.       
C32986         10  WS-ED-DAY               PIC X(02).                   
C32986         10  WS-ED-SEP               PIC X(01).                   
      *                                                                         
       01  WS-BG-CNTRL-TAB.                                             
           05  WS-BG-TABLE OCCURS 50 TIMES INDEXED BY WS-BG-INDX.       
               10  WS-BG-BILL-NO           PIC S9(9) COMP.              
               10  WS-BG-IC-NO             PIC S9(4) COMP.              
               10  WS-BG-RATE              PIC X(03).                   
COB305         10 WS-BG-BTU-FACTOR        PIC S9(2)V9(5) COMP-3 VALUE 0.       
               10  WS-BG-PRIM-TRNSP-FL     PIC X(01).                   
               10  WS-BG-MONTH-END-FL      PIC X(01).                   
               10  WS-BG-READ-EST-FL       PIC X(01).                   
               10  WS-BG-OVER-MDQ-FL       PIC X(01).                   
               10  WS-BG-MONTH-MIN-DT      PIC X(10).                   
               10  WS-BG-MONTH-MAX-DT      PIC X(10).                   
               10  WS-BG-REV-MONTH         PIC 9(06).                   
               10  WS-BG-BASE-TIMESTMP     PIC X(26).                   
               10  WS-BG-TRNSP-TIMESTMP    PIC X(26).                   
               10  WS-MTR-TABLE OCCURS 50 TIMES INDEXED BY WS-MT-INDX.  
                   15  WS-MT-MTR-REF-NO    PIC S9(4) COMP.              
                   15  WS-MT-METER-NO      PIC X(09).                   
                   15  WS-MT-DEP-MTR-FL    PIC X(01).                   
                   15  WS-MT-USAGE-SOURCE  PIC X(01).                   
                   15  WS-MT-MIN-DT        PIC X(10).                   
                   15  WS-MT-MAX-DT        PIC X(10).                   
                   15  WS-MT-MTD-DAYS      PIC S9(4) COMP.              
COB305             15 WS-MT-AVG-CCF        PIC S9(9) COMP-3 VALUE 0.            
                   15  WS-MT-BTU-ID        PIC X(03).                   
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  CX-DATE-READ-NULL           PIC S9(04) COMP VALUE ZEROES.
           05  BG-DATE-ORIG-BILL-NULL      PIC S9(04) COMP VALUE ZEROES.
           05  EQ-DATE-LAST-MOVE-NULL      PIC S9(04) COMP VALUE ZEROES.
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-G                        PIC X(01)  VALUE 'G'.        
           05  WS-I                        PIC X(01)  VALUE 'I'.        
           05  WS-J                        PIC X(01)  VALUE 'J'.        
           05  WS-K                        PIC X(01)  VALUE 'K'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
           05  WS-U                        PIC X(01)  VALUE 'U'.        
           05  WS-01                       PIC X(02)  VALUE '01'.       
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
      *                                                                 03430000
       01  WS-INPUT-PARM-DATA.                                          
           05  WS-PARM-CYC-HDR             PIC X(11).                   
           05  WS-PARM-CYCLE               PIC X(02).                   
           05  FILLER                      PIC X(67).                   
       01  WS-INPUT-BEG-DT-DATA.                                        
           05  WS-PARM-BEG-DT-HDR          PIC X(11).                   
           05  WS-PARM-START-DATE          PIC X(10).                   
           05  FILLER                      PIC X(59).                   
       01  WS-INPUT-END-DT-DATA.                                        
           05  WS-PARM-END-DT-HDR          PIC X(09).                   
           05  WS-PARM-END-DATE            PIC X(10).                   
           05  FILLER                      PIC X(61).                   
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 66   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-RPT-DATE.                                                 
           05  WS-RP-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RP-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RP-YY                PIC X(04).                       
      *                                                                         
      ***************** PCSRP601 REPORT HEADERS **********************          
      **           COMMON WORKING STORAGE FOR REPORT TITLES         **          
      ****************************************************************          
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(10)    VALUE ' PCSRP601'.  
               10  FILLER              PIC X(46)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(21)    VALUE               
                   'S C ELECTRIC & GAS CO'.                             
               10  FILLER              PIC X(36)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(10).                       
      *                                                                         
C32986     05  WS-RPT1-HEADER-1        PIC X(133)   VALUE SPACES.       
C32986*                                                                         
C32986     05  WS-RPT1-HEADER-1M.                                       
               10  FILLER              PIC X(51)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(31)    VALUE               
                   'CIG MISSING DAILY VOLUME REPORT'.                   
               10  FILLER              PIC X(31)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
C32986     05  WS-RPT1-HEADER-1E.                                       
C32986         10  FILLER              PIC X(51)    VALUE SPACES.       
C32986         10  P-RPT1-HEAD1E       PIC X(31)    VALUE               
C32986             'CIG ESTIMATED VOLUME DAY REPORT'.                   
C32986         10  FILLER              PIC X(31)    VALUE SPACES.       
C32986         10  FILLER              PIC X(12)    VALUE 'RUN-TIME: '. 
C32986         10  P-RPT1-RUN-TIMEE    PIC X(08).                       
C32986*                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(48)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                   'DATE RANGE: '.                                      
               10  P-RPT1-FROM-DATE    PIC X(10).                       
               10  FILLER              PIC X(04)    VALUE ' TO '.       
               10  P-RPT1-TO-DATE      PIC X(10).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'NAME'.       
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'METER-NO'.   
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'MISSING DAYS'.      
               10  FILLER              PIC X(16)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **        WORKING STORAGE FOR REPORT DETAIL LINES             **          
      ****************************************************************          
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-ACCT-NO           PIC XBXXXXBXXXXBXXXX             
                                                    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-CUST-NAME         PIC X(12).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-METER-NO          PIC X(09).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-MISSING-DAYS      PIC X(93).                       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *****************************                                             
      **  ABEND SWITCH COPYBOOK  **                                             
      *****************************                                             
      *                                                                         
           COPY CWS00010.                                                       
           COPY CWS09900.                                                       
           COPY CWS00038.                                                       
           COPY CWS00039.                                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      *                                                                         
      **********************************                                        
      **  DB2 AND SQL ERROR CHECKING  **                                        
      **********************************                                        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      **********************************                                        
      **  PARTITION PROCESSING        **                                        
      **********************************                                        
           EXEC SQL                                                             
               INCLUDE CWS00042                                                 
           END-EXEC.                                                            
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_JOB_PARM                **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_BILL_CONTRACT           **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBBLCNTR                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_CNSMPTN_HIST            **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBCNSMP                                                    
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_UTIL_ENVRNMT            **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_ACCOUNT                 **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_CUSTOMER                **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_MTRD_ENVRNMT            **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_BILLING_DET             **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBBLLDET                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_BILLING_HDR             **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_READ_WINDOW             **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBRDWNDW                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_BILL_WINDOW             **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_EQUIPMENT               **                                        
      **********************************                                        
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_MOVEMENT_HIST           **                                        
      **********************************                                        
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_OFF_CYCL_ACCT           **                                        
      **********************************                                        
           EXEC SQL                                                             
               INCLUDE TBOFFCYL                                                 
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_RATE_COMP_DEF           **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBRTCDEF                                                   
           END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- MAIN_CRSR **                                    
      **************************************                                    
           EXEC SQL                                                     
             DECLARE MAIN_CRSR CURSOR FOR                               
              SELECT  UT.ACCOUNT_NO                                     
                     ,READ_CYCLE                                        
                     ,CUSTOMER_NO                                       
                     ,CODE_ACCT_USAGE                                   
                     ,CODE_ACCT_STAT                                    
                     ,CODE_ACCT_BILLED                                  
                     ,CODE_COMPANY_ACCT                                 
                     ,REV_MTH_LST_NRML                                  
                FROM  CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                
                     ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
C37740               ,CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                
               WHERE  AT.ACCOUNT_NO       = UT.ACCOUNT_NO               
C37740           AND  UT.ACCOUNT_NO       = MN.ACCOUNT_NO               
                 AND  UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE          
C37740           AND  UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE           
C37740           AND  UT.IC_NO            = MN.IC_NO                    
C37740           AND  MN.PROGRAM_ID       = '99'                        
                 AND  AT.COMPANY_NO       = :AT-COMPANY-NO              
                 AND  UT.READ_CYCLE       = :UT-READ-CYCLE              
                 AND  EXISTS                                            
                     (SELECT *                                          
                        FROM  CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)        
                       WHERE  J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO       
                         AND  J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE     
                         AND  J1.REG_TYPE_CD    = 'D')                  
            ORDER BY UT.ACCOUNT_NO                                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MAIN_CRSR CURSOR FOR                                       
MFA-TR*       SELECT  UT.ACCOUNT_NO                                             
MFA-TR*              ,READ_CYCLE                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,CODE_ACCT_USAGE                                           
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,CODE_ACCT_BILLED                                          
MFA-TR*              ,CODE_COMPANY_ACCT                                         
MFA-TR*              ,REV_MTH_LST_NRML                                          
MFA-TR*         FROM  CSS_ACCOUNT       AT                                      
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                                      
MFA-TR*              ,CSS_MTRD_ENVRNMT  MN                                      
MFA-TR*        WHERE  AT.ACCOUNT_NO       = UT.ACCOUNT_NO                       
MFA-TR*          AND  UT.ACCOUNT_NO       = MN.ACCOUNT_NO                       
MFA-TR*          AND  UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND  UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE                   
MFA-TR*          AND  UT.IC_NO            = MN.IC_NO                            
MFA-TR*          AND  MN.PROGRAM_ID       = '99'                                
MFA-TR*          AND  AT.COMPANY_NO       = :AT-COMPANY-NO                      
MFA-TR*          AND  UT.READ_CYCLE       = :UT-READ-CYCLE                      
MFA-TR*          AND  EXISTS                                                    
MFA-TR*              (SELECT *                                                  
MFA-TR*                 FROM  CSS_RATE_COMP_DEF J1                              
MFA-TR*                WHERE  J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO               
MFA-TR*                  AND  J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             
MFA-TR*                  AND  J1.REG_TYPE_CD    = 'D')                          
MFA-TR*     ORDER BY UT.ACCOUNT_NO                                              
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- BI_CRSR   **                                    
      **************************************                                    
           EXEC SQL                                                     
             DECLARE BI_CRSR CURSOR FOR                                 
              SELECT BILL_NO                                            
                    ,PREMISE_NO                                         
                FROM CSS_BILLING_HDR                                    
               WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                        
                 AND DATE_BILLED IS NULL                                
            ORDER BY BILL_NO DESC                                       
           END-EXEC.                                                    
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- BG_CRSR   **                                    
      **************************************                                    
           EXEC SQL                                                     
             DECLARE BG_CRSR CURSOR  FOR                                
              SELECT PREMISE_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                 
                    ,DATE_ORIG_BILL                                     
                    ,AMT_BILL_ITEM                                      
                    ,COMPANY_NO                                         
                    ,PRORATE_CD                                         
                    ,CODE_BILL_CALC                                     
                    ,CODE_BILL_ITM_TYPE                                 
                    ,CODE_BILL_ITM_IND                                  
                    ,CODE_DR_CR_CNSMPTN                                 
                    ,AMT_STATE_TAX                                      
                    ,AMT_CITY_TAX                                       
                    ,AMT_OTHER_TAX                                      
                    ,CODE_REVENUE_CLASS                                 
                    ,CODE_SIC_NO                                        
                    ,RATE_PLAN_NO                                       
                    ,CODE_CURTAIL_PRTY                                  
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,REV_MTH_ORIG_BILL                                  
                    ,REV_DISTRICT_CD                                    
                    ,BTU_FACTOR                                         
                    ,ALTERNATE_FUEL_CD                                  
                    ,TRNSP_OVER_MDQ_FL                                  
                FROM CSS_BILLING_DET                                    
               WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
                 AND BILL_NO            = :BG-BILL-NO                   
                 AND CODE_BILL_CALC     = 'A'                           
                 AND CODE_BILL_ITM_TYPE = 'C'                           
                 AND CODE_BILL_ITM_IND  = 'A'                           
                 AND REVENUE_MONTH      = 0                             
            ORDER BY REV_MTH_ORIG_BILL, IC_NO, BILL_ITEM_TIMESTMP       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG_CRSR CURSOR  FOR                                        
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,DATE_ORIG_BILL                                             
MFA-TR*             ,AMT_BILL_ITEM                                              
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,PRORATE_CD                                                 
MFA-TR*             ,CODE_BILL_CALC                                             
MFA-TR*             ,CODE_BILL_ITM_TYPE                                         
MFA-TR*             ,CODE_BILL_ITM_IND                                          
MFA-TR*             ,CODE_DR_CR_CNSMPTN                                         
MFA-TR*             ,AMT_STATE_TAX                                              
MFA-TR*             ,AMT_CITY_TAX                                               
MFA-TR*             ,AMT_OTHER_TAX                                              
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_CURTAIL_PRTY                                          
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,ALTERNATE_FUEL_CD                                          
MFA-TR*             ,TRNSP_OVER_MDQ_FL                                          
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*        WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                    
MFA-TR*          AND BILL_NO            = :BG-BILL-NO                           
MFA-TR*          AND CODE_BILL_CALC     = 'A'                                   
MFA-TR*          AND CODE_BILL_ITM_TYPE = 'C'                                   
MFA-TR*          AND CODE_BILL_ITM_IND  = 'A'                                   
MFA-TR*          AND REVENUE_MONTH      = 0                                     
MFA-TR*     ORDER BY REV_MTH_ORIG_BILL, IC_NO, BILL_ITEM_TIMESTMP               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- CX_CRSR   **                                    
      **************************************                                    
           EXEC SQL                                                     
             DECLARE CX_CRSR CURSOR FOR                                 
              SELECT METER_NO                                           
                    ,CODE_TIME_PERIOD                                   
                    ,MTR_REF_NO                                         
                    ,CODE_USAGE_TYPE                                    
                    ,CODE_USAGE_ID                                      
                    ,CODE_USAGE_SOURCE                                  
                    ,ITEM_SEQ_NO                                        
                    ,REG_ID_NO                                          
                    ,DATE_READ                                          
                    ,CODE_METER_READ                                    
                    ,CODE_METER_NO_READ                                 
                    ,METER_READING                                      
                    ,DEMAND_READING                                     
                    ,EMPLOYEE_NO                                        
                    ,NO_UNITS                                           
                    ,NO_DEMAND_UNITS                                    
                    ,NO_DAYS                                            
                    ,CODE_SOURCE_ID                                     
                    ,CODE_DEBIT_CREDIT                                  
                    ,CODE_ITEM_STATUS                                   
                    ,CODE_DISCOUNT                                      
                    ,CONSTANT                                           
                    ,NO_DIALS                                           
                    ,CODE_TOU_SEASN                                     
                    ,COMPANY_NO                                         
                    ,MTR_READ_SOURCE_CD                                 
                    ,DIGTL_MTR_TYPE                                     
                    ,EXCEPT_OVERRIDE_CD                                 
                    ,REQUESTED_USAGE                                    
                    ,DIGTL_INTRL_MTR_NO                                 
                    ,EXCL_DMD_RCHT_IND                                  
                    ,BTU_FACTOR                                         
                FROM CSS_CNSMPTN_HIST                                   
               WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
                 AND BILL_NO            = :CX-BILL-NO                   
                 AND IC_NO              = :CX-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_METER_READ NOT IN ('B', 'G')                  
                 AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) )                 
                 AND MTR_REF_NO         = :CX-MTR-REF-NO                
                 AND CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CX_CRSR CURSOR FOR                                         
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,CODE_USAGE_TYPE                                            
MFA-TR*             ,CODE_USAGE_ID                                              
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,CODE_METER_READ                                            
MFA-TR*             ,CODE_METER_NO_READ                                         
MFA-TR*             ,METER_READING                                              
MFA-TR*             ,DEMAND_READING                                             
MFA-TR*             ,EMPLOYEE_NO                                                
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,NO_DEMAND_UNITS                                            
MFA-TR*             ,NO_DAYS                                                    
MFA-TR*             ,CODE_SOURCE_ID                                             
MFA-TR*             ,CODE_DEBIT_CREDIT                                          
MFA-TR*             ,CODE_ITEM_STATUS                                           
MFA-TR*             ,CODE_DISCOUNT                                              
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*             ,CODE_TOU_SEASN                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*             ,DIGTL_MTR_TYPE                                             
MFA-TR*             ,EXCEPT_OVERRIDE_CD                                         
MFA-TR*             ,REQUESTED_USAGE                                            
MFA-TR*             ,DIGTL_INTRL_MTR_NO                                         
MFA-TR*             ,EXCL_DMD_RCHT_IND                                          
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                    
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                           
MFA-TR*          AND IC_NO              = :CX-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_METER_READ NOT IN ('B', 'G')                          
MFA-TR*          AND DATE_READ          = :CX-DATE-READ                         
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                        
MFA-TR*          AND CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- MN_CRSR   **                                    
      **************************************                                    
           EXEC SQL                                                     
             DECLARE MN_CRSR CURSOR FOR                                 
              SELECT MN.MTR_REF_NO                                      
                    ,MN.METER_NO                                        
                    ,MN.INDUST_BTU_ID                                   
                    ,MN.CODE_USAGE_SOURCE                               
                    ,EQ.DATE_LAST_MOVE                                  
                FROM CSS_MTRD_ENVRNMT MN                                
                    ,CSS_ACCOUNT      AT                                
                    ,CSS_EQUIPMENT    EQ                                
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND AT.ACCOUNT_NO        = MN.ACCOUNT_NO               
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND EQ.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE           
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.METER_NO          = EQ.DEVICE_NO                
                 AND EQ.COMPANY_NO        = AT.COMPANY_NO               
                 AND MN.CODE_METER_STATUS IN ('A', 'B', 'I')            
              ORDER BY MN.MTR_REF_NO                                    
           END-EXEC.                                                    
      *                                                                         
      ***************************************                                   
      **  CURSOR DECLARATION -- CX_DT_CRSR **                                   
      ***************************************                                   
           EXEC SQL                                                     
             DECLARE CX_DT_CRSR CURSOR FOR                              
              SELECT MTR_REF_NO                                         
                    ,METER_NO                                           
                    ,DATE_READ                                          
                    ,CODE_METER_READ                                    
                    ,CODE_USAGE_SOURCE                                  
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                 
                FROM CSS_CNSMPTN_HIST                                   
               WHERE ACCOUNT_NO          = :CX-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE           
                 AND BILL_NO             = :CX-BILL-NO                  
                 AND IC_NO               = :CX-IC-NO                    
                 AND (BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                         :WS-BASE-RT-TS
              )               
                  OR BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                           :WS-TRNSP-TS
              ))                
                 AND CODE_METER_READ    IN ('B', 'G')                   
                 AND DATE_READ          >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-MONTH-MIN-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MONTH-MIN-DT
              ) <> 0) OR (LEN(:WS-MONTH-MIN-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-MONTH-MIN-DT
              ), CONVERT(DATE, :WS-MONTH-MIN-DT) )             
              ORDER BY DATE_READ, MTR_REF_NO                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CX_DT_CRSR CURSOR FOR                                      
MFA-TR*       SELECT MTR_REF_NO                                                 
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,CODE_METER_READ                                            
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO          = :CX-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE                   
MFA-TR*          AND BILL_NO             = :CX-BILL-NO                          
MFA-TR*          AND IC_NO               = :CX-IC-NO                            
MFA-TR*          AND (BILL_ITEM_TIMESTMP = :WS-BASE-RT-TS                       
MFA-TR*           OR BILL_ITEM_TIMESTMP  = :WS-TRNSP-TS)                        
MFA-TR*          AND CODE_METER_READ    IN ('B', 'G')                           
MFA-TR*          AND DATE_READ          >= :WS-MONTH-MIN-DT                     
MFA-TR*       ORDER BY DATE_READ, MTR_REF_NO                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************                                  
      **  CURSOR DECLARATION -- MV_CRSR     **                                  
      ****************************************                                  
           EXEC SQL                                                     
             DECLARE MV_CRSR CURSOR FOR                                 
              SELECT DATE_MOVE                                          
                FROM CSS_MOVEMENT_HIST                                  
               WHERE CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :MV-DEVICE-NO                     
                 AND COMPANY_NO     = :MV-COMPANY-NO                    
                 AND CODE_CRNT_LOC  = 'J'                               
                 AND LOC_NO         = :MV-LOC-NO                        
            ORDER BY DATE_MOVE DESC                                     
           END-EXEC.                                                    
      *                                                                         
       01  WS-WORKING-STORAGE-END          PIC X(40)    VALUE           
           'WORKING STORAGE FOR PCSRP601 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      **    0000-MAIN                                                **         
      *****************************************************************         
       0000-MAIN.                                                       
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 7000-OPEN-MAIN-CRSR THRU 7000-EXIT.                  
           PERFORM 7010-FETCH-MAIN-CRSR THRU 7010-EXIT.                 
           PERFORM 1000-PROCESS-MAIN-CRSR THRU 1000-EXIT                
                                       UNTIL END-OF-MAIN-CRSR.          
           PERFORM 7020-CLOSE-MAIN-CRSR THRU 7020-EXIT.                 
      *                                                                         
           IF  WS-RPT1-LINE-NO = 66 AND WS-RPT1-PAGE-NO = 0             
               ADD  1                      TO WS-RPT1-PAGE-NO           
               MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO            
               WRITE PRT33-RECORD FROM WS-RPT1-TITLE AFTER NEW-PAGE     
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1 AFTER 1         
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2 AFTER 1         
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-3 AFTER 2         
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2          
           ELSE                                                         
               WRITE PRT33-RECORD FROM WS-END-DATA-LINE AFTER 2         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0100-INITIALIZATION                                      **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                      TO WS-RT-HH.                 
           MOVE WS-MM                      TO WS-RT-MM.                 
           MOVE WS-SS                      TO WS-RT-SS.                 
           MOVE WS-RUN-TIME                TO P-RPT1-RUN-TIME           
C32986                                        P-RPT1-RUN-TIMEE.         
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
C32986     OPEN OUTPUT FCSRP601-FILE.                                   
C32986     IF  FRP601-SUCCESSFUL                                        
C32986         CONTINUE                                                 
C32986     ELSE                                                         
C32986         DISPLAY '0100-ERROR ON FCSRP601 OPEN. STATUS IS '        
C32986                  WS-FRP601-STATUS                                
C32986         PERFORM 9900-ABEND THRU 9900-EXIT                        
C32986     END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                 00568500
           IF  COMMON-DATE-NEEDED                                       
               MOVE 'COMMON'               TO WS-PGRMNAME               
               PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT               
           END-IF.                                                      
           MOVE WS-INPUT-DATE              TO WS-RUN-DATE               
                                              WS-DB2-DATE.              
      *                                                                         
           MOVE WS-DB2-DATE-MM             TO WS-RP-MM                  
           MOVE WS-DB2-DATE-DD             TO WS-RP-DD                  
           MOVE WS-DB2-DATE-YY             TO WS-RP-YY                  
           MOVE WS-RPT-DATE                TO P-RPT1-RUN-DATE.          
      *                                                                 05620000
      *CONSIDER THE LOWEST REVENUE MONTH OPEN FOR THE RUN DATE AS THE   05620000
      *CURRENT REVENUE MONTH                                            05620000
           MOVE WS-RUN-DATE                TO BN-DATE-EXTRACT.          
           PERFORM 7625-SELECT-BILL-WINDOW THRU 7625-EXIT.              
           MOVE BN-REVENUE-MONTH           TO WS-CURR-REV-MONTH.        
      *                                                                         
           MOVE PROGRAM-NAME               TO WS-PROGRAM                
                                              WS-PGRMNAME.              
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:11) =                     
              'READ CYCLE=' AND INPUT-ACTIVE) OR END-OF-SYSIPT.         
           IF  END-OF-SYSIPT                                            
               DISPLAY '      '                                         
               DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'         
               DISPLAY '** READ CYCLE PARM NOT ACTIVE,'                 
                      ' DEFAULTED TO CYCLE 21'                          
               MOVE '21'                   TO WS-PARM-CYCLE             
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-INPUT-PARM-DATA        
               PERFORM 7611-CLOSE            THRU 7611-EXIT             
           END-IF.                                                      
           MOVE WS-PARM-CYCLE              TO UT-READ-CYCLE.            
      *                                                                 05620000
           PERFORM 0110-GET-MIN-MAX-DT THRU 0110-EXIT.                  
      *                                                                 05620000
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:11) =                     
              'START DATE=' AND INPUT-ACTIVE) OR END-OF-SYSIPT.         
           IF  END-OF-SYSIPT                                            
               DISPLAY '      '                                         
               DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'         
               DISPLAY '** START DATE PARM NOT ACTIVE, DEFAULTED'       
                      ' TO MONTH START'                                 
               MOVE WS-MONTH-MIN-DT        TO WS-PARM-START-DATE        
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-INPUT-BEG-DT-DATA      
               PERFORM 7611-CLOSE            THRU 7611-EXIT             
           END-IF.                                                      
      *                                                                 05620000
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:9) =                      
              'END DATE=' AND INPUT-ACTIVE) OR END-OF-SYSIPT.           
           IF  END-OF-SYSIPT                                            
               DISPLAY '      '                                         
               DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'         
               DISPLAY '** END DATE PARM NOT ACTIVE, DEFAULTED'         
                      ' TO MONTH END'                                   
               MOVE WS-MONTH-MAX-DT        TO WS-PARM-END-DATE          
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-INPUT-END-DT-DATA      
               PERFORM 7611-CLOSE            THRU 7611-EXIT             
           END-IF.                                                      
      *                                                                 05620000
           IF  WS-PARM-START-DATE > WS-PARM-END-DATE                    
               DISPLAY '      '                                         
               DISPLAY '** ' WS-PROGRAM ' ERROR MSG **'                 
               DISPLAY '** START DATE IS GREATER THAN END DATE.'        
                      ' PLEASE CORRECT JOB PARM...'                     
               DISPLAY 'START DATE = ' WS-PARM-START-DATE               
               DISPLAY 'END DATE   = ' WS-PARM-END-DATE                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05620000
           IF  WS-PARM-START-DATE >= WS-MONTH-MIN-DT                    
                 AND WS-PARM-END-DATE <= WS-MONTH-MAX-DT                
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 0120-GET-REV-MNTH THRU 0120-EXIT                 
           END-IF.                                                      
      *                                                                 05620000
           DISPLAY '** ' WS-PROGRAM ' RUNNING FOR **'                   
           DISPLAY '** READ CYCLE = ' UT-READ-CYCLE                     
           DISPLAY '** START DATE = ' WS-PARM-START-DATE                
           DISPLAY '** END DATE   = ' WS-PARM-END-DATE                  
           DISPLAY '** REV MONTH  = ' WS-PROCESS-REV-MONTH              
      *                                                                 05620000
           MOVE WS-PARM-START-DATE         TO WS-MONTH-MIN-DT           
                                              P-RPT1-FROM-DATE.         
           MOVE WS-PARM-END-DATE           TO WS-MONTH-MAX-DT           
                                              P-RPT1-TO-DATE.           
      *                                                                 05620000
           MOVE 'G'                        TO UT-CODE-UTIL-TYPE.        
           MOVE '01'                       TO AT-COMPANY-NO.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0110-GET-MIN-MAX-DT                                      **         
      ** GET MONTH'S START/END DATES                                 **         
      *****************************************************************         
       0110-GET-MIN-MAX-DT.                                             
           MOVE UT-READ-CYCLE              TO RW-READ-CYCLE             
                                              BN-BILL-CYCLE.            
           MOVE WS-CURR-REV-MONTH          TO WS-PROCESS-REV-MONTH      
                                              RW-REVENUE-MONTH          
                                              BN-REVENUE-MONTH.         
           PERFORM 7650-SELECT-OPT-READ-DT THRU 7650-EXIT.              
           MOVE RW-OPTIMUM-READ-DATE       TO WS-MAX-READ-DT            
                                              WS-MONTH-MAX-DT.          
      *                                                                         
           MOVE WS-PROCESS-REV-MONTH       TO WS-PARM-REV-MONTH-N.      
           COMPUTE WS-PARM-REV-MONTH = WS-PARM-REV-MONTH - 1            
           IF  WS-PARM-REV-MONTH = 0                                    
               COMPUTE WS-PARM-REV-MONTH = 12                           
               COMPUTE WS-PARM-REV-YEAR  = WS-PARM-REV-YEAR - 1         
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-REV-MONTH-N        TO RW-REVENUE-MONTH.         
           PERFORM 7650-SELECT-OPT-READ-DT THRU 7650-EXIT.              
           MOVE RW-OPTIMUM-READ-DATE       TO WS-DB2-DATE.              
           PERFORM 7990-GET-NEXT-DAY THRU 7990-EXIT                     
           MOVE WS-DB2-DATE                TO WS-MIN-READ-DT            
                                              WS-MONTH-MIN-DT.          
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0120-GET-REV-MNTH                                        **         
      ** GET REVENUE MONTH FOR THE DATES SELECTED                    **         
      *****************************************************************         
       0120-GET-REV-MNTH.                                               
           MOVE UT-READ-CYCLE              TO RW-READ-CYCLE             
                                              BN-BILL-CYCLE.            
           MOVE WS-PARM-START-DATE         TO RW-OPTIMUM-READ-DATE.     
           PERFORM 7700-SELECT-OPT-READ-DT THRU 7700-EXIT               
           MOVE RW-REVENUE-MONTH           TO WS-PROCESS-REV-MONTH.     
      *                                                                         
           MOVE WS-PARM-END-DATE           TO RW-OPTIMUM-READ-DATE.     
           PERFORM 7700-SELECT-OPT-READ-DT THRU 7700-EXIT               
      *                                                                         
           IF  WS-PROCESS-REV-MONTH NOT EQUAL RW-REVENUE-MONTH          
               DISPLAY '** START DATE AND END DATE DOES NOT '           
                      'FALL IN A SINGLE REVENUE MONTH. '                
                      'PLEASE CORRECT JOB PARM...'                      
               DISPLAY 'START DATE = ' WS-PARM-START-DATE               
               DISPLAY 'END DATE   = ' WS-PARM-END-DATE                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1000-PROCESS-MAIN-CRSR                                   **         
      **    GET UNBILLED FUTURE OR REBILL BILL HOOK OF EACH CIG ACCT **         
      *****************************************************************         
       1000-PROCESS-MAIN-CRSR.                                          
      *                                                                         
           MOVE SPACES                     TO WS-BI-CRSR-FL.            
           DISPLAY 'PROCESSING ACCOUNT-NO ' UT-ACCOUNT-NO.              
           MOVE UT-ACCOUNT-NO              TO BI-ACCOUNT-NO             
                                              OC-ACCOUNT-NO             
                                              AT-ACCOUNT-NO             
                                              MN-ACCOUNT-NO             
                                              WS-PREV-ACCT-NO.          
           IF  AT-CODE-ACCT-STAT NOT EQUAL 'A'                          
               MOVE SPACES                 TO WS-EXISTS-IN-OC-FL        
               PERFORM 7550-CHECK-OFF-CYCLE THRU 7550-EXIT              
               IF  EXISTS-IN-OC                                         
                   CONTINUE                                             
               ELSE                                                     
                   PERFORM 7010-FETCH-MAIN-CRSR THRU 7010-EXIT          
                   GO TO 1000-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE UT-ACCOUNT-NO              TO P-ACCT-NO                 
           INSPECT P-ACCT-NO REPLACING ALL ' ' BY '-'.                  
           MOVE AT-CUSTOMER-NO             TO CU-CUSTOMER-NO.           
           PERFORM 7750-GET-CUST-NAME THRU 7750-EXIT.                   
           MOVE WS-FULL-NAME               TO P-CUST-NAME.              
      *                                                                         
           PERFORM 7050-OPEN-BI-CRSR THRU 7050-EXIT.                    
           PERFORM 7060-FETCH-BI-CRSR THRU 7060-EXIT.                   
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               PERFORM 7070-CLOSE-BI-CRSR THRU 7070-EXIT                
               PERFORM 7010-FETCH-MAIN-CRSR THRU 7010-EXIT              
               GO TO 1000-EXIT                                          
           END-IF.                                                      
           PERFORM 1100-PROCESS-EACH-BILL THRU 1100-EXIT                
                                    UNTIL END-OF-BI-CRSR.               
           PERFORM 7070-CLOSE-BI-CRSR THRU 7070-EXIT.                   
      *                                                                         
           PERFORM 7010-FETCH-MAIN-CRSR THRU 7010-EXIT.                 
           PERFORM UNTIL UT-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO        
                                       OR END-OF-MAIN-CRSR              
               PERFORM 7010-FETCH-MAIN-CRSR THRU 7010-EXIT              
           END-PERFORM.                                                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1100-PROCESS-EACH-BILL                                   **         
      **                                                             **         
      *****************************************************************         
       1100-PROCESS-EACH-BILL.                                          
      *                                                                         
           INITIALIZE WS-BG-CNTRL-TAB.                                  
      *                                                                         
      *LOAD BG & MTR CONTROL TABLES FOR ALL IC'S                                
           SET WS-BG-INDX                  TO +1.                       
           MOVE SPACES                     TO WS-BG-CRSR-FL.            
           MOVE BI-ACCOUNT-NO              TO BG-ACCOUNT-NO.            
           MOVE BI-BILL-NO                 TO BG-BILL-NO.               
           MOVE UT-CODE-UTIL-TYPE          TO BG-CODE-UTIL-TYPE         
                                              MN-CODE-UTIL-TYPE         
           PERFORM 7100-OPEN-BG-CRSR THRU 7100-EXIT.                    
           PERFORM 7110-FETCH-BG-CRSR THRU 7110-EXIT.                   
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               PERFORM 7120-CLOSE-BG-CRSR THRU 7120-EXIT                
               PERFORM 7060-FETCH-BI-CRSR THRU 7060-EXIT                
               GO TO 1100-EXIT                                          
           END-IF.                                                      
           PERFORM 1200-PROCESS-EACH-BG THRU 1200-EXIT                  
                                    UNTIL END-OF-BG-CRSR.               
           PERFORM 7120-CLOSE-BG-CRSR THRU 7120-EXIT.                   
      *                                                                         
      *REPORT MISSING METER DAILY VOLUMES                                       
           SET WS-BG-INDX                  TO +1.                       
           PERFORM UNTIL WS-BG-IC-NO (WS-BG-INDX) = 0                   
               PERFORM 1400-REPORT-MISSING-READS THRU 1400-EXIT         
               SET WS-BG-INDX UP BY +1                                  
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7060-FETCH-BI-CRSR THRU 7060-EXIT.                   
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1200-PROCESS-EACH-BG                                     **         
      **                                                             **         
      *****************************************************************         
       1200-PROCESS-EACH-BG.                                            
      *                                                                         
           MOVE SPACES                     TO WS-CIG-RATE-FL            
           SET DO-NOT-SKIP-BG              TO TRUE                      
           MOVE BG-CODE-UTIL-TYPE          TO J1-CODE-UTIL-TYPE         
           MOVE BG-RATE-PLAN-NO            TO J1-RATE-PLAN-NO           
           PERFORM 7400-CHECK-FOR-CIG-RATE THRU 7400-EXIT.              
      *                                                                         
           IF  WS-PROCESS-REV-MONTH EQUAL AT-REV-MTH-LST-NRML           
               SET SKIP-BG                 TO TRUE                      
           END-IF.                                                      
           IF  BG-REV-MTH-ORIG-BILL > 0                                 
               IF  BG-REV-MTH-ORIG-BILL EQUAL WS-PROCESS-REV-MONTH      
                   SET DO-NOT-SKIP-BG      TO TRUE                      
               ELSE                                                     
                   SET SKIP-BG             TO TRUE                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
      *SKIP THE BG, IF IT IS NOT WITH CIG RATE OR ALREADY BILLED FOR            
      *THE CURRENT MONTH                                                        
           IF  IT-IS-NOT-CIG-RATE OR SKIP-BG                            
               PERFORM 7110-FETCH-BG-CRSR THRU 7110-EXIT                
               GO TO 1200-EXIT                                          
           END-IF.                                                      
           MOVE WS-PROCESS-REV-MONTH       TO WS-PREV-REV-MONTH.        
      *                                                                         
           PERFORM 1210-CREATE-BG-CNTRL-TAB THRU 1210-EXIT              
      *                                                                         
           PERFORM 7110-FETCH-BG-CRSR THRU 7110-EXIT.                   
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1210-CREATE-BG-CNTRL-TAB                                 **         
      **                                                             **         
      *****************************************************************         
       1210-CREATE-BG-CNTRL-TAB.                                        
      *                                                                         
           SET WS-SAVE-INDEX               TO WS-BG-INDX.               
           PERFORM 1220-SEARCH-WS-TABLE THRU 1220-EXIT.                 
           IF  IC-FOUND                                                 
               MOVE BG-BILL-ITEM-TIMESTMP  TO                           
                                     WS-BG-TRNSP-TIMESTMP(WS-BG-INDX)   
               MOVE BG-TRNSP-OVER-MDQ-FL   TO                           
                                       WS-BG-OVER-MDQ-FL (WS-BG-INDX)   
               SET WS-BG-INDX              TO WS-SAVE-INDEX             
               GO TO 1210-EXIT                                          
           END-IF.                                                      
           SET WS-BG-INDX                  TO WS-SAVE-INDEX.            
      *                                                                         
           MOVE BI-BILL-NO                 TO WS-BG-BILL-NO (WS-BG-INDX)
           MOVE BG-IC-NO                   TO WS-BG-IC-NO (WS-BG-INDX). 
           MOVE BG-RATE-PLAN-NO            TO WS-BG-RATE (WS-BG-INDX)   
           MOVE WS-PROCESS-REV-MONTH       TO                           
                                     WS-BG-REV-MONTH (WS-BG-INDX).      
      *                                                                         
           MOVE WS-MONTH-MAX-DT            TO WS-MAX-READ-DT            
                                     WS-BG-MONTH-MAX-DT (WS-BG-INDX).   
           MOVE WS-MONTH-MIN-DT            TO WS-MIN-READ-DT            
                                     WS-BG-MONTH-MIN-DT (WS-BG-INDX).   
           IF  BG-PRORATE-CD NOT EQUAL SPACES AND LOW-VALUES AND 'N'    
               MOVE UT-CODE-UTIL-TYPE      TO BK-CODE-UTIL-TYPE         
               MOVE BI-ACCOUNT-NO          TO BK-ACCOUNT-NO             
               MOVE BG-IC-NO               TO BK-IC-NO                  
               IF  BG-PRORATE-CD = 'I' OR AT-CODE-ACCT-STAT = 'A'       
                   MOVE WS-MONTH-MIN-DT    TO BK-CNTRCT-START-DT        
                   PERFORM 7450-GET-CNTRCT-START-DT THRU 7450-EXIT      
                   IF  WS-MONTH-MIN-DT < BK-CNTRCT-START-DT             
                       MOVE BK-CNTRCT-START-DT                          
                                           TO WS-MIN-READ-DT            
                                     WS-BG-MONTH-MIN-DT (WS-BG-INDX)    
                   ELSE                                                 
                       MOVE WS-MONTH-MIN-DT                             
                                           TO WS-MIN-READ-DT            
                                     WS-BG-MONTH-MIN-DT (WS-BG-INDX)    
                   END-IF                                               
               END-IF                                                   
               IF  BG-PRORATE-CD = 'F' OR AT-CODE-ACCT-STAT = 'B'       
                   MOVE WS-MONTH-MAX-DT    TO BK-CNTRCT-END-DT          
                   PERFORM 7500-GET-CNTRCT-END-DT THRU 7500-EXIT        
                   IF  WS-MONTH-MAX-DT < BK-CNTRCT-END-DT               
                       MOVE WS-MONTH-MAX-DT                             
                                           TO WS-MAX-READ-DT            
                                     WS-BG-MONTH-MAX-DT (WS-BG-INDX)    
                   ELSE                                                 
                       MOVE BK-CNTRCT-END-DT                            
                                           TO WS-MAX-READ-DT            
                                     WS-BG-MONTH-MAX-DT (WS-BG-INDX)    
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE BG-BILL-ITEM-TIMESTMP      TO                           
                                      WS-BG-BASE-TIMESTMP (WS-BG-INDX). 
           MOVE SPACES                     TO                           
                                       WS-BG-TRNSP-TIMESTMP(WS-BG-INDX).
      *                                                                         
           PERFORM 1230-BUILD-BG-MTR-TABLE THRU 1230-EXIT.              
      *                                                                         
           SET WS-BG-INDX UP BY +1.                                     
           IF  WS-BG-INDX > 50                                          
               DISPLAY 'WS-BG-INDX WENT OVER MAX OF 50, CHG PGM'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1220-SEARCH-WS-TABLE                                     **         
      **                                                             **         
      *****************************************************************         
       1220-SEARCH-WS-TABLE.                                            
      *                                                                         
           SET IC-NOT-FOUND                TO TRUE.                     
           SET WS-BG-INDX                  TO +1.                       
           SEARCH WS-BG-TABLE                                           
             WHEN WS-BG-IC-NO (WS-BG-INDX) = BG-IC-NO                   
              AND WS-BG-REV-MONTH (WS-BG-INDX) = WS-PREV-REV-MONTH      
                 SET IC-FOUND              TO TRUE                      
           END-SEARCH.                                                  
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1230-BUILD-BG-MTR-TABLE                                  **         
      **    BUILD METER TABLE FOR EACH IC FOR THE CURRENT MONTH      **         
      *****************************************************************         
       1230-BUILD-BG-MTR-TABLE.                                         
      *                                                                         
           MOVE SPACES                     TO WS-MN-CRSR-FL.            
           MOVE BI-ACCOUNT-NO              TO MN-ACCOUNT-NO             
           MOVE UT-CODE-UTIL-TYPE          TO MN-CODE-UTIL-TYPE         
           MOVE WS-BG-IC-NO (WS-BG-INDX)   TO MN-IC-NO                  
           PERFORM 7200-OPEN-MN-CRSR THRU 7200-EXIT.                    
           PERFORM 7210-FETCH-MN-CRSR THRU 7210-EXIT.                   
           SET WS-MT-INDX                  TO +1.                       
           PERFORM UNTIL END-OF-MN-CRSR                                 
               IF  EQ-DATE-LAST-MOVE-NULL = -1                          
                   MOVE SPACES             TO EQ-DATE-LAST-MOVE         
               END-IF                                                   
               MOVE MN-MTR-REF-NO          TO                           
                               WS-MT-MTR-REF-NO (WS-BG-INDX, WS-MT-INDX)
               MOVE MN-METER-NO            TO                           
                               WS-MT-METER-NO (WS-BG-INDX, WS-MT-INDX)  
               IF  WS-MIN-READ-DT     > EQ-DATE-LAST-MOVE               
                   MOVE WS-MIN-READ-DT     TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
               ELSE                                                     
                   MOVE EQ-DATE-LAST-MOVE  TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
               END-IF                                                   
               IF  WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX) >              
                                                   WS-MAX-READ-DT       
                   MOVE WS-MAX-READ-DT     TO                           
                                 WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)  
                                 WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)  
               ELSE                                                     
                   MOVE WS-MAX-READ-DT     TO                           
                               WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)    
               END-IF                                                   
               MOVE MN-CODE-USAGE-SOURCE   TO                           
                           WS-MT-USAGE-SOURCE (WS-BG-INDX, WS-MT-INDX)  
               MOVE MN-INDUST-BTU-ID       TO                           
                               WS-MT-BTU-ID (WS-BG-INDX, WS-MT-INDX)    
               SET WS-MT-INDX UP BY +1                                  
               IF  WS-MT-INDX > 50                                      
                   DISPLAY 'WS-MT-INDX WENT OVER MAX OF 50, CHG PGM'    
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
               PERFORM 7210-FETCH-MN-CRSR THRU 7210-EXIT                
           END-PERFORM.                                                 
           PERFORM 7220-CLOSE-MN-CRSR THRU 7220-EXIT.                   
      *                                                                         
           MOVE SPACES                     TO WS-CX-DT-CRSR-FL.         
           MOVE BI-ACCOUNT-NO              TO CX-ACCOUNT-NO.            
           MOVE UT-CODE-UTIL-TYPE          TO CX-CODE-UTIL-TYPE         
                                              MV-CODE-UTIL-TYPE.        
           MOVE BI-PREMISE-NO              TO MV-LOC-NO.                
           MOVE AT-COMPANY-NO              TO MV-COMPANY-NO.            
           MOVE WS-BG-IC-NO (WS-BG-INDX)   TO CX-IC-NO.                 
           MOVE WS-BG-BILL-NO (WS-BG-INDX) TO CX-BILL-NO.               
           MOVE WS-BG-BASE-TIMESTMP (WS-BG-INDX)                        
                                           TO CX-BILL-ITEM-TIMESTMP     
                                              BG-BILL-ITEM-TIMESTMP     
                                              WS-BASE-RT-TS.            
           PERFORM 7580-GET-TIMESTMP THRU 7580-EXIT.                    
           PERFORM 7250-OPEN-CX-DT-CRSR THRU 7250-EXIT.                 
           PERFORM 7260-FETCH-CX-DT-CRSR THRU 7260-EXIT.                
           PERFORM UNTIL END-OF-CX-DT-CRSR                              
               SET WS-MT-INDX              TO +1                        
               SEARCH WS-MTR-TABLE                                      
                 AT END                                                 
                    MOVE CX-MTR-REF-NO     TO                           
                               WS-MT-MTR-REF-NO (WS-BG-INDX, WS-MT-INDX)
                    MOVE CX-METER-NO       TO                           
                               WS-MT-METER-NO (WS-BG-INDX, WS-MT-INDX)  
                                  MV-DEVICE-NO                          
                    MOVE CX-CODE-USAGE-SOURCE TO                        
                           WS-MT-USAGE-SOURCE (WS-BG-INDX, WS-MT-INDX)  
                    MOVE SPACES            TO WS-MV-CRSR-FL             
                    PERFORM 7300-OPEN-MV-CRSR THRU 7300-EXIT            
                    PERFORM 7310-FETCH-MV-CRSR THRU 7310-EXIT           
                    PERFORM 7320-CLOSE-MV-CRSR THRU 7320-EXIT           
                    IF  CX-CODE-METER-READ = 'B'                        
                        IF  WS-MIN-READ-DT > MV-DATE-MOVE               
                            MOVE WS-MIN-READ-DT                         
                                           TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
                        ELSE                                            
                            MOVE MV-DATE-MOVE                           
                                           TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
                        END-IF                                          
                        IF  WS-MAX-READ-DT > CX-DATE-READ               
                            MOVE CX-DATE-READ                           
                                           TO                           
                               WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)    
                        ELSE                                            
                            MOVE WS-MAX-READ-DT                         
                                           TO                           
                               WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)    
                        END-IF                                          
                    ELSE                                                
                        IF  CX-CODE-METER-READ = 'G'                    
                            IF  WS-MIN-READ-DT > MV-DATE-MOVE           
                                MOVE WS-MIN-READ-DT                     
                                           TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
                            ELSE                                        
                                MOVE MV-DATE-MOVE                       
                                           TO                           
                               WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)    
                            END-IF                                      
                            IF  WS-MAX-READ-DT > CX-DATE-READ           
                                MOVE CX-DATE-READ                       
                                           TO                           
                                  WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX) 
                            ELSE                                        
                                 MOVE WS-MAX-READ-DT                    
                                           TO                           
                                   WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)
                            END-IF                                      
                        END-IF                                          
                    END-IF                                              
                    MOVE SPACES            TO                           
                               WS-MT-BTU-ID (WS-BG-INDX, WS-MT-INDX)    
                 WHEN WS-BG-IC-NO (WS-BG-INDX)      = CX-IC-NO          
                  AND WS-MT-MTR-REF-NO (WS-BG-INDX, WS-MT-INDX)         
                                          = CX-MTR-REF-NO               
                    MOVE CX-METER-NO       TO                           
                               WS-MT-METER-NO (WS-BG-INDX, WS-MT-INDX)  
                                              MV-DEVICE-NO              
                    MOVE SPACES            TO WS-MV-CRSR-FL             
                    PERFORM 7300-OPEN-MV-CRSR THRU 7300-EXIT            
                    PERFORM 7310-FETCH-MV-CRSR THRU 7310-EXIT           
                    PERFORM 7320-CLOSE-MV-CRSR THRU 7320-EXIT           
                    IF  CX-CODE-METER-READ = 'B'                        
                        IF  WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)       
                                      > MV-DATE-MOVE                    
                            IF  WS-MIN-READ-DT > MV-DATE-MOVE           
                                MOVE WS-MIN-READ-DT                     
                                           TO                           
                                  WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX) 
                            ELSE                                        
                                MOVE MV-DATE-MOVE                       
                                           TO                           
                                  WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX) 
                            END-IF                                      
                        END-IF                                          
                    ELSE                                                
                        IF  CX-CODE-METER-READ = 'G'                    
                            IF  WS-MAX-READ-DT > CX-DATE-READ           
                                MOVE CX-DATE-READ                       
                                           TO                           
                                  WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX) 
                            ELSE                                        
                                 MOVE WS-MAX-READ-DT                    
                                           TO                           
                                   WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)
                            END-IF                                      
                        END-IF                                          
                    END-IF                                              
               END-SEARCH                                               
               PERFORM 7260-FETCH-CX-DT-CRSR THRU 7260-EXIT             
           END-PERFORM.                                                 
           PERFORM 7270-CLOSE-CX-DT-CRSR THRU 7270-EXIT.                
      *                                                                         
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1400-REPORT-MISSING-READS                                **         
      **                                                             **         
      *****************************************************************         
       1400-REPORT-MISSING-READS.                                       
      *                                                                         
           SET WS-MT-INDX                  TO +1.                       
           PERFORM UNTIL                                                
                       WS-MT-MTR-REF-NO (WS-BG-INDX, WS-MT-INDX) = 0    
               PERFORM 1410-REPORT-MISSING-CX THRU 1410-EXIT            
               SET WS-MT-INDX UP BY +1                                  
           END-PERFORM.                                                 
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1410-REPORT-MISSING-CX                                   **         
      **                                                             **         
      *****************************************************************         
       1410-REPORT-MISSING-CX.                                          
      *                                                                         
           MOVE SPACES                     TO WS-CX-CRSR-FL             
C32986                                        WS-ESTIMATE-DAY-TAB       
                                              WS-MISSING-DAY-TAB.       
           MOVE BI-ACCOUNT-NO              TO CX-ACCOUNT-NO             
           MOVE UT-CODE-UTIL-TYPE          TO CX-CODE-UTIL-TYPE         
           MOVE WS-BG-BILL-NO (WS-BG-INDX) TO CX-BILL-NO.               
           MOVE WS-BG-IC-NO (WS-BG-INDX)   TO CX-IC-NO                  
           MOVE WS-BG-BASE-TIMESTMP (WS-BG-INDX)                        
                                           TO CX-BILL-ITEM-TIMESTMP     
           MOVE WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)                   
                                           TO CX-DATE-READ.             
           IF  WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)                    
                                   < WS-PARM-START-DATE                 
                OR WS-MT-MIN-DT (WS-BG-INDX, WS-MT-INDX)                
                                   > WS-PARM-END-DATE                   
               GO TO 1410-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE WS-MT-MTR-REF-NO (WS-BG-INDX, WS-MT-INDX)               
                                           TO CX-MTR-REF-NO.            
           MOVE WS-MT-USAGE-SOURCE (WS-BG-INDX, WS-MT-INDX)             
                                           TO CX-CODE-USAGE-SOURCE      
           SET MISSING-VOL-F               TO TRUE.                     
C32986     SET ESTIMATE-VOL-F              TO TRUE.                     
      *                                                                         
           PERFORM UNTIL CX-DATE-READ >                                 
                          WS-MT-MAX-DT (WS-BG-INDX, WS-MT-INDX)         
               MOVE CX-DATE-READ           TO WS-DB2-DATE               
               PERFORM 7150-OPEN-CX-CRSR THRU 7150-EXIT                 
               PERFORM 7160-FETCH-CX-CRSR THRU 7160-EXIT                
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   PERFORM 1500-POPULATE-MISSING-DAYS THRU 1500-EXIT    
               END-IF                                                   
C32986         IF  CX-CODE-METER-READ = 'E'                             
C32986             PERFORM 1510-POPULATE-ESTIMATE-DAYS THRU 1510-EXIT   
C32986         END-IF                                                   
               PERFORM 7170-CLOSE-CX-CRSR THRU 7170-EXIT                
               PERFORM 7990-GET-NEXT-DAY THRU 7990-EXIT                 
               MOVE WS-DB2-DATE            TO CX-DATE-READ              
           END-PERFORM.                                                 
      *                                                                         
C32986*AS COMMA IS THE DELIMITER, REPLACE ',' IN THE NAME AS IT IS FOR          
C32986*INFORMATIONAL PURPOSE ONLY                                               
C32986         INSPECT WS-FULL-NAME REPLACING ALL ',' BY SPACES.        
C32986*                                                                         
C32986*IF A DAYS VOLUMES ARE MISSING OR ESTIMATED, IT WOULD MEAN THE            
C32986*EFM TEAM NEEDS TO SEND THE VOLUMES. SO, WE ARE USING THE SAME            
C32986*REPORT TO DISPLAY ANY COMBINATION                                        
           IF  MISSING-VOL-T                                            
               MOVE WS-MT-METER-NO (WS-BG-INDX, WS-MT-INDX)             
                                           TO P-METER-NO                
C32986                                        E-FRP601-METER-NO         
               MOVE WS-MISSING-DAY-TAB     TO P-MISSING-DAYS            
C32986                                        E-FRP601-DAY-STRING       
C32986         MOVE WS-RPT1-HEADER-1M      TO WS-RPT1-HEADER-1          
               PERFORM 8000-PRINT-REPORT THRU 8000-EXIT                 
C32986         MOVE 'M'                    TO E-FRP601-RECORD-TYPE      
C32986         MOVE WS-FULL-NAME           TO E-FRP601-CUSTOMER-NAME    
C32986         MOVE UT-ACCOUNT-NO          TO E-FRP601-ACCOUNT-NO       
C32986         PERFORM 8001-WRITE-FIORP601 THRU 8001-EXIT               
               MOVE SPACES                 TO P-CUST-NAME               
           END-IF.                                                      
      *                                                                         
C32986     IF  ESTIMATE-VOL-T                                           
C32986         MOVE WS-MT-METER-NO (WS-BG-INDX, WS-MT-INDX)             
C32986                                     TO P-METER-NO                
C32986                                        E-FRP601-METER-NO         
C32986         MOVE WS-ESTIMATE-DAY-TAB    TO E-FRP601-DAY-STRING       
C32986                                        P-MISSING-DAYS            
C32986         MOVE WS-RPT1-HEADER-1E      TO WS-RPT1-HEADER-1          
C32986         PERFORM 8000-PRINT-REPORT THRU 8000-EXIT                 
C32986         MOVE 'E'                    TO E-FRP601-RECORD-TYPE      
C32986         MOVE WS-FULL-NAME           TO E-FRP601-CUSTOMER-NAME    
C32986         MOVE UT-ACCOUNT-NO          TO E-FRP601-ACCOUNT-NO       
C32986         PERFORM 8001-WRITE-FIORP601 THRU 8001-EXIT               
C32986         MOVE SPACES                 TO P-CUST-NAME               
C32986     END-IF.                                                      
C32986*                                                                         
       1410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1500-POPULATE-MISSING-DAYS                               **         
      **                                                             **         
      *****************************************************************         
       1500-POPULATE-MISSING-DAYS.                                      
      *                                                                         
           SET MISSING-VOL-T               TO TRUE.                     
           SET WS-MD-INDX                  TO +1.                       
           SEARCH WS-MD-TABLE                                           
             WHEN WS-MD-DAY (WS-MD-INDX) = LOW-VALUES OR SPACES         
                 MOVE WS-DB2-DATE-DD       TO WS-MD-DAY (WS-MD-INDX)    
                 MOVE SPACES               TO WS-MD-SEP (WS-MD-INDX)    
           END-SEARCH.                                                  
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C32986*****************************************************************         
C32986**    1510-POPULATE-ESTIMATE-DAYS                              **         
C32986**                                                             **         
C32986*****************************************************************         
C32986 1510-POPULATE-ESTIMATE-DAYS.                                     
C32986*                                                                         
C32986     SET ESTIMATE-VOL-T              TO TRUE.                     
C32986     SET WS-ED-INDX                  TO +1.                       
C32986     SEARCH WS-ED-TABLE                                           
C32986       WHEN WS-ED-DAY (WS-ED-INDX) = LOW-VALUES OR SPACES         
C32986           MOVE WS-DB2-DATE-DD       TO WS-ED-DAY (WS-ED-INDX)    
C32986           MOVE SPACES               TO WS-ED-SEP (WS-ED-INDX)    
C32986     END-SEARCH.                                                  
C32986*                                                                         
C32986 1510-EXIT.                                                       
C32986     EXIT.                                                        
      *                                                                         
      ********************************************************                  
      * JOB_PARM INCLUDES FOR DATE ACCESS                                       
      ********************************************************                  
       COPY CPD00037.                                                   13580000
       COPY CPD00040.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **    7000-OPEN-MAIN-CRSR                                      **         
      **     OPEN THE MAIN DRIVING CURSOR                            **         
      *****************************************************************         
       7000-OPEN-MAIN-CRSR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN MAIN_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7000       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7010-FETCH-MAIN-CRSR                                     **         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      *****************************************************************         
       7010-FETCH-MAIN-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH  MAIN_CRSR                                          
               INTO :UT-ACCOUNT-NO                                      
                   ,:UT-READ-CYCLE                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-USAGE                                 
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:AT-CODE-COMPANY-ACCT                               
                   ,:AT-REV-MTH-LST-NRML                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-MAIN-CRSR    TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7010       **'   
                   DISPLAY '**        CYCLE   = ' UT-READ-CYCLE         
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7020-CLOSE-MAIN-CRSR                                     **         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      *****************************************************************         
       7020-CLOSE-MAIN-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE  MAIN_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7020       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7050-OPEN-BI-CRSR                                        **         
      *****************************************************************         
       7050-OPEN-BI-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN BI_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7050       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7060-FETCH-BI-CRSR                                       **         
      *****************************************************************         
       7060-FETCH-BI-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  BI_CRSR                                            
               INTO  :BI-BILL-NO                                        
                    ,:BI-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-BI-CRSR      TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7060       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7070-CLOSE-BI-CRSR                                       **         
      *****************************************************************         
       7070-CLOSE-BI-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  BI_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7070       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7100-OPEN-BG-CRSR                                        **         
      *****************************************************************         
       7100-OPEN-BG-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN BG_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7100       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7110-FETCH-BG-CRSR                                       **         
      *****************************************************************         
       7110-FETCH-BG-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  BG_CRSR                                            
               INTO  :BG-PREMISE-NO                                     
                    ,:BG-BILL-NO                                        
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-DATE-ORIG-BILL :BG-DATE-ORIG-BILL-NULL          
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-COMPANY-NO                                     
                    ,:BG-PRORATE-CD                                     
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REV-DISTRICT-CD                                
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-ALTERNATE-FUEL-CD                              
                    ,:BG-TRNSP-OVER-MDQ-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-BG-CRSR      TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7110       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7120-CLOSE-BG-CRSR                                       **         
      *****************************************************************         
       7120-CLOSE-BG-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  BG_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7120       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7150-OPEN-CX-CRSR                                        **         
      *****************************************************************         
       7150-OPEN-CX-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN CX_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7150       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7160-FETCH-CX-CRSR                                       **         
      *****************************************************************         
       7160-FETCH-CX-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  CX_CRSR                                            
               INTO  :CX-METER-NO                                       
                    ,:CX-CODE-TIME-PERIOD                               
                    ,:CX-MTR-REF-NO                                     
                    ,:CX-CODE-USAGE-TYPE                                
                    ,:CX-CODE-USAGE-ID                                  
                    ,:CX-CODE-USAGE-SOURCE                              
                    ,:CX-ITEM-SEQ-NO                                    
                    ,:CX-REG-ID-NO                                      
                    ,:CX-DATE-READ :CX-DATE-READ-NULL                    
                    ,:CX-CODE-METER-READ                                
                    ,:CX-CODE-METER-NO-READ                             
                    ,:CX-METER-READING                                  
                    ,:CX-DEMAND-READING                                 
                    ,:CX-EMPLOYEE-NO                                    
                    ,:CX-NO-UNITS                                       
                    ,:CX-NO-DEMAND-UNITS                                
                    ,:CX-NO-DAYS                                        
                    ,:CX-CODE-SOURCE-ID                                 
                    ,:CX-CODE-DEBIT-CREDIT                              
                    ,:CX-CODE-ITEM-STATUS                               
                    ,:CX-CODE-DISCOUNT                                  
                    ,:CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                    ,:CX-CODE-TOU-SEASN                                 
                    ,:CX-COMPANY-NO                                     
                    ,:CX-MTR-READ-SOURCE-CD                             
                    ,:CX-DIGTL-MTR-TYPE                                 
                    ,:CX-EXCEPT-OVERRIDE-CD                             
                    ,:CX-REQUESTED-USAGE                                
                    ,:CX-DIGTL-INTRL-MTR-NO                             
                    ,:CX-EXCL-DMD-RCHT-IND                              
                    ,:CX-BTU-FACTOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-CX-CRSR      TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7160       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7170-CLOSE-CX-CRSR                                       **         
      *****************************************************************         
       7170-CLOSE-CX-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  CX_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7170       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7200-OPEN-MN-CRSR                                        **         
      *****************************************************************         
       7200-OPEN-MN-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN MN_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7210-FETCH-MN-CRSR                                       **         
      *****************************************************************         
       7210-FETCH-MN-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  MN_CRSR                                            
               INTO  :MN-MTR-REF-NO                                     
                    ,:MN-METER-NO                                       
                    ,:MN-INDUST-BTU-ID                                  
                    ,:MN-CODE-USAGE-SOURCE                              
                    ,:EQ-DATE-LAST-MOVE :EQ-DATE-LAST-MOVE-NULL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-MN-CRSR      TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7210       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7220-CLOSE-MN-CRSR                                       **         
      *****************************************************************         
       7220-CLOSE-MN-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  MN_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7220       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7250-OPEN-CX-DT-CRSR                                     **         
      *****************************************************************         
       7250-OPEN-CX-DT-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN CX_DT_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7250       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7260-FETCH-CX-DT-CRSR                                    **         
      *****************************************************************         
       7260-FETCH-CX-DT-CRSR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH  CX_DT_CRSR                                         
               INTO  :CX-MTR-REF-NO                                     
                    ,:CX-METER-NO                                       
                    ,:CX-DATE-READ                                      
                    ,:CX-CODE-METER-READ                                
                    ,:CX-CODE-USAGE-SOURCE                              
                    ,:CX-BILL-ITEM-TIMESTMP                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-CX-DT-CRSR   TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7260       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7270-CLOSE-CX-DT-CRSR                                    **         
      *****************************************************************         
       7270-CLOSE-CX-DT-CRSR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE  CX_DT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7270       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7300-OPEN-MV-CRSR                                        **         
      *****************************************************************         
       7300-OPEN-MV-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN MV_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7310-FETCH-MV-CRSR                                       **         
      *****************************************************************         
       7310-FETCH-MV-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  MV_CRSR                                            
               INTO  :MV-DATE-MOVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-MV-CRSR      TO TRUE                      
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSRP601 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7310       **'   
                   DISPLAY '**      DEVICE_NO    = ' MV-DEVICE-NO       
                   DISPLAY '**      LOC_NO       = ' MV-LOC-NO          
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7320-CLOSE-MV-CRSR                                       **         
      *****************************************************************         
       7320-CLOSE-MV-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  MV_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7320       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7400-CHECK-FOR-CIG-RATE                                     **         
      *****************************************************************         
       7400-CHECK-FOR-CIG-RATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CIG-RATE-FL                                    
                FROM CSS_RATE_COMP_DEF                                  
               WHERE RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
                 AND CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                 AND REG_TYPE_CD      = 'D'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                                   OR -811                              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7400       **'       
               DISPLAY '**           RATE = ' J1-RATE-PLAN-NO           
               DISPLAY '**     VERSION NO = ' J1-VERSION-NO-CNTRL       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7450-GET-CNTRCT-START-DT                                    **         
      *****************************************************************         
       7450-GET-CNTRCT-START-DT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT BK.CNTRCT_START_DT                                 
                INTO :BK-CNTRCT-START-DT                                
                FROM CSS_BILL_CONTRACT BK                               
               WHERE BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            
                 AND BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                
                 AND BK.IC_NO           = :BK-IC-NO                     
                 AND BK.CNTRCT_START_DT =                               
                     (SELECT MIN (BK1.CNTRCT_START_DT)                  
                        FROM CSS_BILL_CONTRACT BK1                      
                       WHERE BK1.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE    
                         AND BK1.ACCOUNT_NO      = BK.ACCOUNT_NO        
                         AND BK1.IC_NO           = BK.IC_NO             
                         AND BK1.CNTRCT_START_DT                        
                                     >= IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BK.CNTRCT_START_DT                                         
MFA-TR*         INTO :BK-CNTRCT-START-DT                                        
MFA-TR*         FROM CSS_BILL_CONTRACT BK                               05110000
MFA-TR*        WHERE BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            05120000
MFA-TR*          AND BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                05140000
MFA-TR*          AND BK.IC_NO           = :BK-IC-NO                     05140000
MFA-TR*          AND BK.CNTRCT_START_DT =                                       
MFA-TR*              (SELECT MIN (BK1.CNTRCT_START_DT)                  05160000
MFA-TR*                 FROM CSS_BILL_CONTRACT BK1                      05110000
MFA-TR*                WHERE BK1.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE    05120000
MFA-TR*                  AND BK1.ACCOUNT_NO      = BK.ACCOUNT_NO        05140000
MFA-TR*                  AND BK1.IC_NO           = BK.IC_NO             05140000
MFA-TR*                  AND BK1.CNTRCT_START_DT                        05210000
MFA-TR*                              >= :BK-CNTRCT-START-DT)            05210000
MFA-TR*    END-EXEC.                                                    05230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7450       **'       
               DISPLAY '**     ACCOUNT_NO = ' BK-ACCOUNT-NO             
               DISPLAY '**          IC_NO = ' BK-IC-NO                  
               DISPLAY '**     START_DATE = ' BK-CNTRCT-START-DT        
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7500-GET-CNTRCT-END-DT                                      **         
      *****************************************************************         
       7500-GET-CNTRCT-END-DT.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT BK.CNTRCT_END_DT                                   
                INTO :BK-CNTRCT-END-DT                                  
                FROM CSS_BILL_CONTRACT BK                               
               WHERE BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            
                 AND BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                
                 AND BK.IC_NO           = :BK-IC-NO                     
                 AND BK.CNTRCT_END_DT   =                               
                     (SELECT MAX (BK1.CNTRCT_END_DT)                    
                        FROM CSS_BILL_CONTRACT BK1                      
                       WHERE BK1.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE    
                         AND BK1.ACCOUNT_NO      = BK.ACCOUNT_NO        
                         AND BK1.IC_NO           = BK.IC_NO             
                         AND BK1.CNTRCT_END_DT  <= 
              IIF(TRY_CONVERT(DATE, :BK-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-END-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :BK-CNTRCT-END-DT
              ), CONVERT(DATE, :BK-CNTRCT-END-DT) ))   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BK.CNTRCT_END_DT                                           
MFA-TR*         INTO :BK-CNTRCT-END-DT                                          
MFA-TR*         FROM CSS_BILL_CONTRACT BK                               05110000
MFA-TR*        WHERE BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            05120000
MFA-TR*          AND BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                05140000
MFA-TR*          AND BK.IC_NO           = :BK-IC-NO                     05140000
MFA-TR*          AND BK.CNTRCT_END_DT   =                                       
MFA-TR*              (SELECT MAX (BK1.CNTRCT_END_DT)                    05160000
MFA-TR*                 FROM CSS_BILL_CONTRACT BK1                      05110000
MFA-TR*                WHERE BK1.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE    05120000
MFA-TR*                  AND BK1.ACCOUNT_NO      = BK.ACCOUNT_NO        05140000
MFA-TR*                  AND BK1.IC_NO           = BK.IC_NO             05140000
MFA-TR*                  AND BK1.CNTRCT_END_DT  <= :BK-CNTRCT-END-DT)   05210000
MFA-TR*    END-EXEC.                                                    05230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7500       **'       
               DISPLAY '**     ACCOUNT_NO = ' BK-ACCOUNT-NO             
               DISPLAY '**          IC_NO = ' BK-IC-NO                  
               DISPLAY '**       END_DATE = ' BK-CNTRCT-END-DT          
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7550-CHECK-OFF-CYCLE                                        **         
      *****************************************************************         
       7550-CHECK-OFF-CYCLE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-EXISTS-IN-OC-FL                                
                FROM CSS_OFF_CYCL_ACCT                                  
               WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7550       **'       
               DISPLAY '**      ACCOUNT_NO    = ' OC-ACCOUNT-NO         
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7580-GET-TIMESTMP                                        **         
      *****************************************************************         
       7580-GET-TIMESTMP.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( 
              MICROSECOND, 1, CIS.CHAR2TIMESTAMP(
                                              :BG-BILL-ITEM-TIMESTMP) )
           , 121), ' ', '-'), ':', '.')  
                INTO :WS-TRNSP-TS                                       
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND          
MFA-TR*         INTO :WS-TRNSP-TS                                               
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7580       **'       
               DISPLAY '**       TIMESTMP= ' BG-BILL-ITEM-TIMESTMP      
               DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT BILL WINDOW DATE                                     **         
      *****************************************************************         
       7625-SELECT-BILL-WINDOW.                                         
      *                                                                 05910000
           EXEC SQL                                                     
               SELECT MIN(REVENUE_MONTH)                                
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW                                   
                WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05920000
MFA-TR*        SELECT MIN(REVENUE_MONTH)                                        
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE DATE_EXTRACT = :BN-DATE-EXTRACT                           
MFA-TR*    END-EXEC.                                                    05960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7625       **'       
               DISPLAY '**       RUN DATE = ' BN-DATE-EXTRACT           
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06060000
       7625-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06060000
      *****************************************************************         
      ** SELECT OPTIMUM READ DATE OF THE MONTH                       **         
      *****************************************************************         
       7650-SELECT-OPT-READ-DT.                                         
      *                                                                 05910000
           EXEC SQL                                                     
               SELECT OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM CSS_READ_WINDOW                                   
                WHERE READ_CYCLE    = :RW-READ-CYCLE                    
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7650       **'       
               DISPLAY '**     READ CYCLE = ' RW-READ-CYCLE             
               DISPLAY '**   REVENUE MONTH= ' RW-REVENUE-MONTH          
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06060000
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06060000
      *****************************************************************         
      ** SELECT REVENUE MONTH FOR THE DATE                           **         
      *****************************************************************         
       7700-SELECT-OPT-READ-DT.                                         
      *                                                                 05910000
           EXEC SQL                                                     
               SELECT RW.REVENUE_MONTH                                  
                 INTO :RW-REVENUE-MONTH                                 
                 FROM CSS_READ_WINDOW RW                                
                WHERE RW.READ_CYCLE         = :RW-READ-CYCLE            
                  AND RW.OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                  :RW-OPTIMUM-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :RW-OPTIMUM-READ-DATE
              ) <> 0) OR (LEN(:RW-OPTIMUM-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:RW-OPTIMUM-READ-DATE
              ), CONVERT(DATE, :RW-OPTIMUM-READ-DATE) )     
                  AND RW.REVENUE_MONTH      =                           
                    (SELECT MIN(R1.REVENUE_MONTH)                       
                       FROM CSS_READ_WINDOW R1                          
                      WHERE R1.READ_CYCLE      = RW.READ_CYCLE          
                        AND OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                  :RW-OPTIMUM-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :RW-OPTIMUM-READ-DATE
              ) <> 0) OR (LEN(:RW-OPTIMUM-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:RW-OPTIMUM-READ-DATE
              ), CONVERT(DATE, :RW-OPTIMUM-READ-DATE) )) 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05920000
MFA-TR*        SELECT RW.REVENUE_MONTH                                          
MFA-TR*          INTO :RW-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_READ_WINDOW RW                                        
MFA-TR*         WHERE RW.READ_CYCLE         = :RW-READ-CYCLE                    
MFA-TR*           AND RW.OPTIMUM_READ_DATE >= :RW-OPTIMUM-READ-DATE             
MFA-TR*           AND RW.REVENUE_MONTH      =                                   
MFA-TR*             (SELECT MIN(R1.REVENUE_MONTH)                               
MFA-TR*                FROM CSS_READ_WINDOW R1                                  
MFA-TR*               WHERE R1.READ_CYCLE      = RW.READ_CYCLE                  
MFA-TR*                 AND OPTIMUM_READ_DATE >= :RW-OPTIMUM-READ-DATE)         
MFA-TR*    END-EXEC.                                                    05960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7700       **'       
               DISPLAY '**     READ CYCLE = ' RW-READ-CYCLE             
               DISPLAY '**     DATE       = ' RW-OPTIMUM-READ-DATE      
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06060000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06060000
      *****************************************************************         
      ** GET CUSTOMER NAME                                           **         
      *****************************************************************         
       7750-GET-CUST-NAME.                                              
      *                                                                 05910000
           EXEC SQL                                                     
              SELECT FULL_NAME                                          
                INTO :WS-FULL-NAME                                      
               FROM  CSS_CUSTOMER CU                                    
                    ,CSS_NAME     DQ                                    
              WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                    
                AND DQ.NAME_ID     = CU.NAME_ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7750       **'       
               DISPLAY '**       CUSTOMER = ' CU-CUSTOMER-NO            
               DISPLAY '**       SQLCODE  = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06060000
      *****************************************************************         
      ** SELECT TO ADD ONE DAY TO A DATE                             **         
      *****************************************************************         
       7990-GET-NEXT-DAY.                                               
      *                                                                 05910000
           EXEC SQL                                                     
                SELECT DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                           :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )                       
                  INTO :WS-DB2-DATE                                     
                  FROM CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     05920000
MFA-TR*         SELECT DATE(:WS-DB2-DATE) + 1 DAY                       05930000
MFA-TR*           INTO :WS-DB2-DATE                                     05940000
MFA-TR*           FROM CSS_MODEL_SQL                                    05950000
MFA-TR*    END-EXEC.                                                    05960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP601 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7990       **'       
               DISPLAY '**       DB2 DATE = ' WS-DB2-DATE               
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06060000
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8000-PRINT-REPORT                                        **          
      ****************************************************************          
       8000-PRINT-REPORT.                                               
           IF  (66 - WS-RPT1-LINE-NO) < 2                               
               ADD  1                      TO WS-RPT1-PAGE-NO           
               MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO            
               WRITE PRT33-RECORD FROM WS-RPT1-TITLE AFTER NEW-PAGE     
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1 AFTER 1         
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2 AFTER 1         
               WRITE PRT33-RECORD FROM WS-RPT1-HEADER-3 AFTER 2         
               MOVE 4                      TO WS-RPT1-LINE-NO           
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1 AFTER 2             
           ADD +2                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C32986*****************************************************************         
C32986**   8001-WRITE-FIORP601                                      **          
C32986*****************************************************************         
C32986 8001-WRITE-FIORP601.                                             
C32986*                                                                         
C32986     MOVE ','                    TO E-FRP601-DEL1                 
C32986                                    E-FRP601-DEL2                 
C32986                                    E-FRP601-DEL3                 
C32986                                    E-FRP601-DEL4                 
C32986     WRITE FIORP601.                                              
C32986     IF  FRP601-SUCCESSFUL                                        
C32986         CONTINUE                                                 
C32986     ELSE                                                         
C32986         DISPLAY '8001-ERROR ON FCSRP601 WRITE. STATUS IS '       
C32986                  WS-FRP601-STATUS                                
C32986         PERFORM 9900-ABEND THRU 9900-EXIT                        
C32986     END-IF.                                                      
C32986*                                                                         
C32986 8001-EXIT.                                                       
C32986     EXIT.                                                        
      *****************************************************************         
      **    9000-TERMINATE                                           **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
C32986     CLOSE FCSRP601-FILE.                                         
C32986     IF  FRP601-SUCCESSFUL                                        
C32986         CONTINUE                                                 
C32986     ELSE                                                         
C32986         DISPLAY '9000-ERROR ON FCSRP601 CLOSE. STATUS IS '       
C32986                  WS-FRP601-STATUS                                
C32986     END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY 'PCSRP601: END OF PROCESSING'.                       
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
       COPY CPD0023B.                                                   33937900
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
