       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP517.                                      
COB303 DATE-WRITTEN.     APR 21, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- EACH ROW IN CSS_GAS_METER  TABLE WITH NON-NULL LAST_TEST_SEL-*        
      *-- DT OR NON BLANK LAST_TEST_SEL_CD, IS UPDATED TO LAST_TEST_ --*        
      *-- SEL_DT = NULL AND LAST_TEST_SEL_CD = BLANK                 --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  04/21/2016    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT021*--                            GMC517 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP517'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_GAS_METER,GM                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-LAST-TEST-SEL-DT-NULL PIC S9(04) COMP.                  
          05 WS-REC-COUNT             PIC 9(06) VALUE ZEROES.           
          05 WS-REC-FLAG              PIC X(01) VALUE SPACES.           
      *                                                                         
       01 WS-LITERALS.                                                  
      *                                                                         
          05 WS-N                     PIC X(01) VALUE 'N'.              
          05 WS-Y                     PIC X(01) VALUE 'Y'.              
      ******************************************************************        
      * THIS IS THE DRIVING CURSOR OF THIS PROGRAM FETCHING DETAILS    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DTLS_CSR CURSOR FOR                               
                 SELECT LAST_TEST_SEL_DT                                
                       ,LAST_TEST_SEL_CD                                
                   FROM CSS_GAS_METER GM                                
                  WHERE (LAST_TEST_SEL_DT IS NOT NULL                   
                     OR LAST_TEST_SEL_CD <> ' ')                        
                    AND COMPANY_NO = :GM-COMPANY-NO                     
                    FOR UPDATE OF                                       
                        LAST_TEST_SEL_DT                                
                       ,LAST_TEST_SEL_CD                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTLS_CSR CURSOR FOR                                       
MFA-TR*          SELECT LAST_TEST_SEL_DT                                        
MFA-TR*                ,LAST_TEST_SEL_CD                                        
MFA-TR*            FROM CSS_GAS_METER GM                                        
MFA-TR*           WHERE (LAST_TEST_SEL_DT IS NOT NULL                           
MFA-TR*              OR LAST_TEST_SEL_CD <> ' ')                                
MFA-TR*             AND COMPANY_NO = :GM-COMPANY-NO                             
MFA-TR*             FOR UPDATE OF                                               
MFA-TR*                 LAST_TEST_SEL_DT                                        
MFA-TR*                ,LAST_TEST_SEL_CD                                        
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-INPUT.                                                   
          05 PARM-LENGTH                PIC S9(04) COMP.                
          05 PARM-COMPANY-NO            PIC X(02).                      
      ******************************************************************        
       PROCEDURE DIVISION USING PARM-INPUT.                             
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-CSR                 THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           IF PARM-LENGTH > 0                                           
              MOVE PARM-COMPANY-NO        TO GM-COMPANY-NO              
           ELSE                                                         
              MOVE '01'                   TO GM-COMPANY-NO              
           END-IF.                                                      
           DISPLAY '*******************************'.                   
           DISPLAY 'JOB RUNNING FOR COMPANY NO = ', GM-COMPANY-NO.      
           DISPLAY '*******************************'.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-CSR                                             **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-CSR.                                                
      *                                                                         
           PERFORM 7100-OPEN-DTLS-CSR               THRU  7100-EXIT.    
           PERFORM 7200-FETCH-DTLS-CSR              THRU  7200-EXIT.    
           PERFORM 2000-PROCESS-DTLS-CSR            THRU  2000-EXIT     
             UNTIL WS-REC-FLAG EQUAL WS-N.                              
           DISPLAY 'TOTAL RECS PROCESSED ' WS-REC-COUNT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS-CSR                                        **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS-CSR.                                           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE -1                     TO WS-LAST-TEST-SEL-DT-NULL   
              PERFORM 8000-UPDATE-GAS-METER         THRU 8000-EXIT      
              IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL        
                 DISPLAY 'UPDATE ERROR ' SQLCODE                        
              ELSE                                                      
                 COMPUTE WS-REC-COUNT    = WS-REC-COUNT + 1             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-N                TO WS-REC-FLAG                
              ELSE                                                      
                  DISPLAY 'FETCH ERROR ' SQLCODE                        
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7200-FETCH-DTLS-CSR              THRU 7200-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-DTLS-CSR.                                            *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-DTLS-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN DTLS_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP517 ABORT ******'                  
              DISPLAY '**  7100-OPEN-DTLS-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-FETCH-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DTLS_CSR                                            
               INTO :GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-NULL       
                   ,:GM-LAST-TEST-SEL-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP517 ABORT ******'                  
              DISPLAY '**  7200-FETCH-DTLS-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  GM-COMPANY-NO = ' GM-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-DTLS-CSR.                                           *        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DTLS_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP517 ABORT ******'                  
              DISPLAY '**  7300-CLOSE-DTLS-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8000-UPDATE-GAS-METER                                       **        
      ******************************************************************        
      *                                                                         
       8000-UPDATE-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_GAS_METER                                  
                   SET LAST_TEST_SEL_DT = NULL                       
                      ,LAST_TEST_SEL_CD = ' '                        
                 WHERE CURRENT OF DTLS_CSR                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_GAS_METER GM                                         
MFA-TR*            SET GM.LAST_TEST_SEL_DT = NULL                               
MFA-TR*               ,GM.LAST_TEST_SEL_CD = ' '                                
MFA-TR*          WHERE CURRENT OF DTLS_CSR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP517 ABORT *****'                   
              DISPLAY '**  8000-UPDATE-GAS-METER  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 7300-CLOSE-DTLS-CSR        THRU 7300-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
