       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP516.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.    MAY 10,  2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ***    PRINTS A REPORT OF INSTALLED GAS METER POPULATION       ***        
      ***    AND SAMPLE SIZE DATA FOR EACH METER TYPE GROUP.         ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    ---------------------------------**        
ACT060***  05/10/2016    MS7M727     EZT TO COBOL CONVERSION GMC516  ***        
A05460***  -----------   --------    ---------------------------------**        
ACT188***  08/30/2016    DB41297     CHANGE PIC 9 VALUE SPACE TO ZERO **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSPT61-FILE                                          
               ASSIGN  TO UT-S-FCSPT61                                  
               FILE STATUS IS WS-FCSPT61-STATUS.                        
                                                                        
           SELECT FCSPT33-FILE                                          
               ASSIGN  TO UT-S-FCSPT33                                  
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       FD  FCSPT61-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FCSPT61-REC.                                                 
ACT188     05 WS-FCSPT61-TEST-YEAR         PIC 9(04)  VALUE ZEROES.     
           05 WS-FCSPT61-TYPE-RUN          PIC X(01)  VALUE SPACES.     
           05 WS-FCSPT61-MTR-TST-GRP-CD    PIC X(02)  VALUE SPACES.     
           05 WS-FCSPT61-MTR-TST-GRP-DESC  PIC X(40)  VALUE SPACES.     
ACT188     05 WS-FCSPT61-SAMPL-OVERAGWS-PCT PIC 9(03) VALUE ZEROES.     
           05 WS-FCSPT61-SAMPL-CORRECTV-PCT                             
ACT188                                     PIC 9(03)  VALUE ZEROES.     
ACT188     05 WS-FCSPT61-INSTALLED-QT      PIC 9(09)  VALUE ZEROES.     
ACT188     05 WS-FCSPT61-SAMPLE-MIN-QT     PIC 9(09)  VALUE ZEROES.     
           05 WS-FCSPT61-SAMPLE-ADDITIONL-QT                            
ACT188                                     PIC 9(09)  VALUE ZEROES.     
ACT188     05 WS-FCSPT61-SELECTED-QT       PIC 9(09)  VALUE ZEROES.     
                                                                        
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP516'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01  WS-LITERL.                                                   
           05  WS-PROGRAM-NAME             PIC X(08) VALUE 'PCSRP516'.  
      *                                                                         
       01  WS-COUNTER.                                                  
           05 WS-LINE-COUNT                PIC 9(02) VALUE ZEROES.      
           05 WS-PAGE-COUNT                PIC 9(02) VALUE ZEROES.      
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-TOTAL-IN                  PIC 9(06) VALUE ZEROES.      
           05 WS-ERROR-SW                  PIC X(01) VALUE SPACES.      
           05 WS-FIRST-REC                 PIC X(01) VALUE 'Y'.         
           05 WS-ERROR-MSG                 PIC X(11) VALUE SPACES.      
           05 WS-COMPANY-NO                PIC X(02) VALUE SPACES.      
           05 WS-PARM-COMPANY-NO           PIC X(02) VALUE SPACES.      
           05 WS-TYPE-RUN                  PIC X(25) VALUE SPACES.      
           05 WS-COMPANY-NAME              PIC X(25) VALUE SPACES.      
           05 WS-OVERAGWS-PCT              PIC 9(03) VALUE ZERO.        
           05 WS-CORRECT-PCT               PIC 9(03) VALUE ZERO.        
           05 WS-INSTALLED-POP             PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-MIN                PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-ADDNL              PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-TOT                PIC 9(07) VALUE ZERO.        
           05 WS-INSTALLED-POP-TOTAL       PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-MIN-TOTAL          PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-ADDNL-TOTAL        PIC 9(07) VALUE ZERO.        
           05 WS-SAMPLE-TOT-TOTAL          PIC 9(07) VALUE ZERO.        
           05 WS-SCEG-NAME                 PIC X(21) VALUE              
                                             'S C ELECTRIC & GAS CO'.   
           05 WS-PSNC-NAME                 PIC X(11) VALUE              
                                                       'PSNC ENERGY'.   
      *                                                                         
       01  WS-FILWS-STATUS.                                             
           05 WS-FCSPT33-STATUS          PIC X(02) VALUE SPACES.        
              88 FCSPT33-SUCCESSFUL                VALUE '00'.          
           05 WS-FCSPT61-STATUS          PIC X(02) VALUE SPACES.        
              88 FCSPT61-SUCCESSFUL                VALUE '00'.          
              88 END-OF-REC                        VALUE '10'.          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05 WS-HH                      PIC 9(02) VALUE ZERO.          
           05 WS-MM                      PIC 9(02) VALUE ZERO.          
           05 WS-SS                      PIC 9(02) VALUE ZERO.          
           05 WS-TT                      PIC 9(02) VALUE ZERO.          
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05 WS-RT-HH                   PIC X(02) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE '.'.           
           05 WS-RT-MM                   PIC X(02) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE '.'.           
           05 WS-RT-SS                   PIC X(02) VALUE SPACES.        
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05 WS-RD-MM                   PIC X(02) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE '/'.           
           05 WS-RD-DD                   PIC X(02) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE '/'.           
           05 WS-RD-YY                   PIC X(04) VALUE SPACES.        
      *                                                                         
       01  WS-CURRENT-DATE1.                                            
           05 WS-CY                      PIC X(04) VALUE SPACES.        
           05 WS-CM                      PIC X(02) VALUE SPACES.        
           05 WS-CD                      PIC X(02) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR1.                                                 
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-HDR-PGM              PIC X(11) VALUE 'PCSRP516-01'. 
           05 FILLER                     PIC X(34) VALUE SPACES.        
           05 P-RPT-HDR-COMPANY-NAME     PIC X(25) VALUE SPACES.        
           05 FILLER                     PIC X(50) VALUE SPACES.        
           05 P-RPT-PAGE-HDR             PIC X(04) VALUE 'PAGE'.        
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-PAGE-NO              PIC ZZ    VALUE ZEROES.        
           05 FILLER                     PIC X(01) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR2.                                                 
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-SYS-DATE             PIC X(10) VALUE SPACES.        
           05 FILLER                     PIC X(32) VALUE SPACES.        
           05 P-RPT-GM-HDR               PIC X(46) VALUE                
                    'GAS METER INSTALLED POPULATION AND SAMPLE SIZE'.   
           05 FILLER                     PIC X(23) VALUE SPACES.        
           05 P-RPT-RUN-DATE-HDR         PIC X(09) VALUE 'RUN DATE:'.   
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-RUN-DATE             PIC X(10) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR3.                                                 
           05 FILLER                     PIC X(51) VALUE SPACES.        
           05 P-RPT-TST-YR-HDR           PIC X(13) VALUE                
                                              'FOR TEST YEAR'.          
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-TST-YR               PIC X(04) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-HYPHEN-HDR           PIC X(01) VALUE '-'.           
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-TYPE-RUN             PIC X(25) VALUE SPACES.        
           05 FILLER                     PIC X(15) VALUE SPACES.        
           05 P-RPT-RUN-TIME-HDR         PIC X(09) VALUE 'RUN TIME:'.   
           05 FILLER                     PIC X(03) VALUE SPACES.        
           05 P-RPT-RUN-TIME             PIC X(08) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR4                   PIC X(133) VALUE SPACES.       
      *                                                                         
       01  WS-RPT-HDR5.                                                 
           05 FILLER                     PIC X(45) VALUE SPACES.        
           05 P-RPT-OVERAGWS-PCT-HDR1    PIC X(06) VALUE 'SAMPLE'.      
           05 FILLER                     PIC X(06) VALUE SPACES.        
           05 P-RPT-CORRECT-PCT-HDR1     PIC X(06) VALUE 'SAMPLE'.      
           05 FILLER                     PIC X(22) VALUE SPACES.        
           05 P-SAMPLE-MIN-HDR1          PIC X(07) VALUE 'MINIMUM'.     
           05 FILLER                     PIC X(02) VALUE SPACES.        
           05 P-RPT-SAMPLE-ADDNL-HDR1    PIC X(10) VALUE 'ADDITIONAL'.  
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-SAMPLE-TOT-HDR1      PIC X(10) VALUE 'TOTAL'.       
           05 FILLER                     PIC X(17) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR6.                                                 
           05 FILLER                     PIC X(45) VALUE SPACES.        
           05 P-RPT-OVERAGWS-PCT-HDR2    PIC X(07) VALUE 'OVERAGE'.     
           05 FILLER                     PIC X(03) VALUE SPACES.        
           05 P-RPT-CORRECT-PCT-HDR2     PIC X(10) VALUE 'CORRECTIVE'.  
           05 FILLER                     PIC X(06) VALUE SPACES.        
           05 P-RPT-INSTALLED-POP-HDR1   PIC X(09) VALUE 'INSTALLED'.   
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-SAMPLE-MIN-HDR2      PIC X(06) VALUE 'SAMPLE'.      
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-SAMPLE-ADDNL-HDR2    PIC X(08) VALUE 'QUANTITY'.    
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-SAMPLE-TOT-HDR2      PIC X(08) VALUE 'SELECTED'.    
           05 FILLER                     PIC X(15) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR7.                                                 
           05 FILLER                     PIC X(16) VALUE SPACES.        
           05 P-RPT-MTR-GRP-HDR1         PIC X(16) VALUE                
                                            'METER TEST GROUP'.         
           05 FILLER                     PIC X(13) VALUE SPACES.        
           05 P-RPT-OVERAGWS-PCT-HDR3    PIC X(07) VALUE 'PERCENT'.     
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-CORRECT-PCT-HDR3     PIC X(07) VALUE 'PERCENT'.     
           05 FILLER                     PIC X(07) VALUE SPACES.        
           05 P-RPT-INSTALLED-POP-HDR2   PIC X(10) VALUE 'POPULATION'.  
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-MIN-HDR3      PIC X(08) VALUE 'QUANTITY'.    
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-ADDNL-HDR3    PIC X(08) VALUE 'SELECTED'.    
           05 FILLER                     PIC X(05) VALUE SPACES.        
           05 P-RPT-SAMPLE-TOT-HDR3      PIC X(08) VALUE 'TEST QTY'.    
           05 FILLER                     PIC X(15) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR8.                                                 
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-MTR-TST-GRP-CD       PIC X(02) VALUE SPACES.        
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-MTR-TST-GRP-DESC     PIC X(40) VALUE SPACES.        
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-OVERAGWS-PCT         PIC ZZ9   VALUE ZERO.          
           05 FILLER                     PIC X(09) VALUE SPACES.        
           05 P-RPT-CORRECT-PCT          PIC ZZ9   VALUE ZERO.          
           05 FILLER                     PIC X(09) VALUE SPACES.        
           05 P-RPT-INSTALLED-POP        PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-MIN           PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(03) VALUE SPACES.        
           05 P-RPT-SAMPLE-ADDNL         PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-TOT           PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(02) VALUE SPACES.        
           05 P-RPT-ERROR-MSG            PIC X(11) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR9                   PIC X(133) VALUE SPACES.       
      *                                                                         
       01  WS-RPT-HDR10.                                                
           05 FILLER                     PIC X(64) VALUE SPACES.        
           05 P-RPT-TOTAL-HDR            PIC X(05) VALUE 'TOTAL'.       
           05 FILLER                     PIC X(03) VALUE SPACES.        
           05 P-RPT-INSTALLED-POP-TOTAL  PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-MIN-TOTAL     PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(03) VALUE SPACES.        
           05 P-RPT-SAMPLE-ADDNL-TOTAL   PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(04) VALUE SPACES.        
           05 P-RPT-SAMPLE-TOT-TOTAL     PIC Z,ZZZ,ZZ9 VALUE ZERO.      
           05 FILLER                     PIC X(10) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR11                  PIC X(133) VALUE SPACES.       
      *                                                                         
       01  WS-RPT-HDR12.                                                
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-ERROR-MSG-1          PIC X(07) VALUE 'ERROR: '.     
           05 P-RPT-ERROR-MSG-2          PIC X(51) VALUE                
               'THE SAMPLE SIZE EXCEEDS THE MAXIMUM SAMPLE SIZE OF '.   
           05 P-RPT-ERROR-MSG-3          PIC X(54) VALUE                
               '200 IN TABLE B-5 "TABLE FOR ESTIMATING THE LOT PERCENT'.
           05 P-RPT-ERROR-MSG-4          PIC X(10) VALUE ' DEFECTIVE'.  
           05 FILLER                     PIC X(01) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-HDR13.                                                
           05 FILLER                     PIC X(01) VALUE SPACES.        
           05 P-RPT-ERROR-MSG-5          PIC X(49) VALUE                
              'USING STANDARD DEVIATION METHOD" USED IN PROGRAM '.      
           05 P-RPT-ERROR-MSG-6          PIC X(41) VALUE                
              'PCSMT660 "ANALYZE GAS SAMPLE TESTS".'.                   
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
      *****************************************************************         
      * CURSOR FOR GETTING RECORDS                                              
      *****************************************************************         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU  0100-EXIT.        
                                                                        
           PERFORM 1000-PROCESS-INPUT           THRU  1000-EXIT.        
                                                                        
           PERFORM 9000-TERMINATE               THRU  9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME.             
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                    TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE              
                                            P-RPT-SYS-DATE.             
      *                                                                         
           OPEN INPUT FCSPT61-FILE.                                     
           IF NOT FCSPT61-SUCCESSFUL                                    
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP516******************'         
               DISPLAY '**  0100-INITIALIZATION             **'         
               DISPLAY '**  ERROR OPENING PREMFILE          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT61-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP516******************'         
               DISPLAY '**  ERROR OPENING FCSPT33           **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-READ-FCSPT61            THRU 7000-EXIT.         
           PERFORM 2000-PROCESS-INPUT           THRU 2000-EXIT.         
           PERFORM 2500-WRITE-TOTAL-COUNT       THRU 2500-EXIT.         
           PERFORM 2600-WRITE-ERROR-MSG         THRU 2600-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-INPUT.                                                    
      ******************************************************************        
      *                                                                         
       2000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 2100-CHECK-PARM-CMPNYNO     THRU 2100-EXIT           
                                                                        
           PERFORM 2200-COMPUTE-METER-SIZE     THRU 2200-EXIT           
           UNTIL END-OF-REC.                                            
                                                                        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-CHECK-PARM-CMPNYNO                                                
      ******************************************************************        
      *                                                                         
       2100-CHECK-PARM-CMPNYNO.                                         
      *                                                                         
           ACCEPT WS-PARM-COMPANY-NO  FROM  SYSIN.                      
                                                                        
           IF WS-PARM-COMPANY-NO = SPACES                               
              MOVE '01'                  TO WS-COMPANY-NO               
           ELSE                                                         
              MOVE WS-PARM-COMPANY-NO    TO WS-COMPANY-NO               
           END-IF.                                                      
                                                                        
           DISPLAY '*******************************'                    
           DISPLAY 'JOB RUNNING FOR COMPANY NO = ', WS-COMPANY-NO       
           DISPLAY '*******************************'                    
                                                                        
           IF  WS-COMPANY-NO = '26'                                     
               MOVE WS-PSNC-NAME         TO P-RPT-HDR-COMPANY-NAME      
           ELSE                                                         
               MOVE WS-SCEG-NAME         TO P-RPT-HDR-COMPANY-NAME      
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2200-COMPUTE-METER-SIZE                                                
      ******************************************************************        
      *                                                                         
       2200-COMPUTE-METER-SIZE.                                         
      *                                                                         
           PERFORM 5000-MOVE-FCSPT61           THRU 5000-EXIT.          
                                                                        
           COMPUTE WS-INSTALLED-POP-TOTAL = WS-INSTALLED-POP-TOTAL      
                                          + WS-INSTALLED-POP.           
           COMPUTE WS-SAMPLE-MIN-TOTAL = WS-SAMPLE-MIN-TOTAL            
                                          + WS-SAMPLE-MIN.              
           COMPUTE WS-SAMPLE-ADDNL-TOTAL = WS-SAMPLE-ADDNL-TOTAL        
                                          + WS-SAMPLE-ADDNL.            
           COMPUTE WS-SAMPLE-TOT-TOTAL = WS-SAMPLE-TOT-TOTAL            
                                          + WS-SAMPLE-TOT.              
                                                                        
           IF WS-FCSPT61-TYPE-RUN = 'F'                                 
              MOVE 'FORECAST'            TO WS-TYPE-RUN                 
           ELSE                                                         
             IF WS-FCSPT61-TYPE-RUN = 'A'                               
                MOVE 'ADDITIONAL SELECTIONS'                            
                                         TO WS-TYPE-RUN                 
             ELSE                                                       
               MOVE SPACES               TO WS-TYPE-RUN                 
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-FCSPT61-SELECTED-QT > 200                              
              MOVE 'Y'                   TO WS-ERROR-SW                 
              MOVE  '** ERROR **'        TO WS-ERROR-MSG                
           END-IF.                                                      
                                                                        
           PERFORM 2300-WRITE-PROCESS        THRU 2300-EXIT.            
           PERFORM 7000-READ-FCSPT61         THRU 7000-EXIT.            
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-WRITE-PROCESS                                                     
      ******************************************************************        
      *                                                                         
       2300-WRITE-PROCESS.                                              
      *                                                                         
           IF WS-LINE-COUNT >=34 OR WS-FIRST-REC = 'Y'                  
              ADD  1                     TO WS-PAGE-COUNT               
              MOVE WS-PAGE-COUNT         TO P-RPT-PAGE-NO               
              MOVE ZERO                  TO WS-LINE-COUNT               
              MOVE 'N'                   TO WS-FIRST-REC                
              MOVE WS-RPT-HDR1           TO PRT33-RECORD                
              PERFORM 8300-WRITE-FCSPT33    THRU 8300-EXIT              
              MOVE WS-RPT-HDR2           TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              MOVE WS-FCSPT61-TEST-YEAR  TO P-RPT-TST-YR                
              MOVE WS-TYPE-RUN           TO P-RPT-TYPE-RUN              
              MOVE WS-RPT-HDR3           TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              MOVE WS-RPT-HDR4           TO PRT33-RECORD                
              PERFORM 8200-WRITE-FCSPT33    THRU 8200-EXIT              
              MOVE WS-RPT-HDR5           TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              MOVE WS-RPT-HDR6           TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              MOVE WS-RPT-HDR7           TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              PERFORM 2400-WRITE-DETAIL-REC THRU 2400-EXIT              
           ELSE                                                         
              PERFORM 2400-WRITE-DETAIL-REC THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-WRITE-DETAIL-REC                                                  
      ******************************************************************        
      *                                                                         
       2400-WRITE-DETAIL-REC.                                           
      *                                                                         
           MOVE WS-FCSPT61-MTR-TST-GRP-CD                               
                                         TO P-RPT-MTR-TST-GRP-CD.       
           MOVE WS-FCSPT61-MTR-TST-GRP-DESC                             
                                         TO P-RPT-MTR-TST-GRP-DESC.     
           MOVE WS-OVERAGWS-PCT          TO P-RPT-OVERAGWS-PCT          
           MOVE WS-CORRECT-PCT           TO P-RPT-CORRECT-PCT.          
           MOVE WS-INSTALLED-POP         TO P-RPT-INSTALLED-POP.        
           MOVE WS-SAMPLE-MIN            TO P-RPT-SAMPLE-MIN.           
           MOVE WS-SAMPLE-ADDNL          TO P-RPT-SAMPLE-ADDNL.         
           MOVE WS-SAMPLE-TOT            TO P-RPT-SAMPLE-TOT.           
           MOVE WS-ERROR-MSG             TO P-RPT-ERROR-MSG.            
           MOVE WS-RPT-HDR8              TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT.            
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-WRITE-TOTAL-COUNT                                                 
      ******************************************************************        
      *                                                                         
       2500-WRITE-TOTAL-COUNT.                                          
      *                                                                         
           MOVE WS-RPT-HDR9              TO PRT33-RECORD.               
           PERFORM 8200-WRITE-FCSPT33       THRU 8200-EXIT.             
           MOVE WS-INSTALLED-POP-TOTAL   TO P-RPT-INSTALLED-POP-TOTAL.  
           MOVE WS-SAMPLE-MIN-TOTAL      TO P-RPT-SAMPLE-MIN-TOTAL.     
           MOVE WS-SAMPLE-ADDNL-TOTAL    TO P-RPT-SAMPLE-ADDNL-TOTAL.   
           MOVE WS-SAMPLE-TOT-TOTAL      TO P-RPT-SAMPLE-TOT-TOTAL.     
           MOVE WS-RPT-HDR10             TO PRT33-RECORD.               
           PERFORM 8000-WRITE-FCSPT33       THRU 8000-EXIT.             
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2600-WRITE-ERROR-MSG                                                   
      ******************************************************************        
      *                                                                         
       2600-WRITE-ERROR-MSG.                                            
      *                                                                         
           IF WS-ERROR-SW = 'Y'                                         
              MOVE WS-RPT-HDR11          TO PRT33-RECORD                
              PERFORM 8200-WRITE-FCSPT33    THRU 8200-EXIT              
              MOVE WS-RPT-HDR12          TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
              MOVE WS-RPT-HDR13          TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33    THRU 8000-EXIT              
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 5000-MOVE-FCSPT61                                                      
      ******************************************************************        
      *                                                                         
       5000-MOVE-FCSPT61.                                               
      *                                                                         
           MOVE SPACES                   TO WS-TYPE-RUN.                
           MOVE SPACES                   TO WS-ERROR-MSG.               
                                                                        
           COMPUTE WS-TOTAL-IN = WS-TOTAL-IN + 1.                       
                                                                        
           MOVE WS-FCSPT61-SAMPL-OVERAGWS-PCT                           
                                         TO WS-OVERAGWS-PCT.            
           MOVE WS-FCSPT61-SAMPL-CORRECTV-PCT                           
                                         TO WS-CORRECT-PCT.             
           MOVE WS-FCSPT61-INSTALLED-QT  TO WS-INSTALLED-POP.           
           MOVE WS-FCSPT61-SAMPLE-MIN-QT                                
                                         TO WS-SAMPLE-MIN.              
           MOVE WS-FCSPT61-SAMPLE-ADDITIONL-QT                          
                                         TO WS-SAMPLE-ADDNL.            
           MOVE WS-FCSPT61-SELECTED-QT   TO WS-SAMPLE-TOT.              
                                                                        
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7000-READ-FCSPT61E                                                     
      ******************************************************************        
      *                                                                         
       7000-READ-FCSPT61.                                               
      *                                                                         
           READ FCSPT61-FILE                                            
                                                                        
           IF FCSPT61-SUCCESSFUL OR END-OF-REC                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP516 ABORT *********'          
               DISPLAY '**ERROR IN READING PREMFILE FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS '  WS-FCSPT61-STATUS          
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9000-TERMINATE.                                                         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT61-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
