       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP515.                                      
COB303 DATE-WRITTEN.     APR 15, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- THIS PROGRAM LISTS ALL SAMPLE SELECTION CRITERIA FOR A TEST--*        
      *-- YEAR FOR GAS METERS.                                       --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  04/15/2016    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT054*--                            GMC515 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT OUTFILE                                               
               ASSIGN TO UT-S-OUTFILE.                                  
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  OUTFILE                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 OUTFILE-REC.                                                  
          05 OUT-MTR-TEST-GRP-CD.                                       
             10 OUT-MTR-TEST-GRP-CD1 PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE SPACES.            
             10 OUT-MTR-TEST-GRP-CD2 PIC X(25) VALUE SPACES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-SAMPL-OVERAGE-PCT   PIC 9(02) VALUE ZEROES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-SAMPL-CORRECTV-PCT  PIC 9(02) VALUE ZEROES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-GAS-METER-TYPE      PIC X(34) VALUE SPACES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-BEGIN-PURCHASE-DT   PIC X(10) VALUE SPACES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-END-PURCHASE-DT     PIC X(10) VALUE SPACES.            
HEX01     05 FILLER                  PIC X(01) VALUE X'09'.             
          05 OUT-SELECT-TYPE-CD      PIC X(01) VALUE SPACES.            
          05 FILLER                  PIC X(71) VALUE SPACES.            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP515'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_HIST,MQ                         *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRTST                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_GROUP,GR                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRGP                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_TST_GROUP,GG                         *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASGRP                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER_SIZE,M5                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_COMPANY, C7                              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * ABEND SWITCH COPYBOOK                                       *           
      ***************************************************************           
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ***************************************************************           
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'              *           
      ***************************************************************           
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-RUN-TIME             PIC X(08) VALUE SPACES.           
           05 WS-RUN-DATE             PIC X(10) VALUE SPACES.           
           05 WS-REC-COUNT            PIC 9(06) VALUE ZEROES.           
           05 WS-GAS-METER-TYPE.                                        
              10 WS-GAS-METER-SIZE-ID   PIC X(08).                      
              10 WS-GAS-METER-SIZE-DESC PIC X(25).                      
           05 WS-MTR-TEST-GRP-CD.                                       
              10 WS-MTR-TEST-GRP-CODE   PIC X(02).                      
              10 WS-MTR-TEST-GRP-TX     PIC X(25).                      
       01 WS-LITERALS.                                                  
      *                                                                         
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSRP515'.      
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X(02) VALUE SPACES.          
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  RPT-COMPANY-NAME    PIC X(26) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(02) VALUE SPACES.          
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(22)                        
                   VALUE 'SAMPLE GAS METER TEST '.                      
               10  FILLER              PIC X(13)                        
                   VALUE 'CRITERIA FOR '.                               
               10  RPT-YEAR            PIC X(04) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER              PIC X(17)                        
                   VALUE 'METER TEST GROUP '.                           
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(22)                        
                   VALUE 'SAMPLE OVERAGE PERCENT'.                      
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(25)                        
                   VALUE 'SAMPLE CORRECTIVE PERCENT'.                   
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(14)                        
                   VALUE 'GAS METER TYPE'.                              
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(24)                        
                   VALUE 'BEGIN PURCHASE/TEST DATE'.                    
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(22)                        
                   VALUE 'END PURCHASE/TEST DATE'.                      
HEX01          10  FILLER              PIC X(01) VALUE X'09'.           
               10  FILLER              PIC X(34)                        
                   VALUE 'SELECT BY(P-PURCHASE YR,T-TEST YR)'.          
      *                                                                         
      ******************************************************************        
      * MAIN CURSOR                                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_METER_DETAILS CURSOR FOR                      
               SELECT  MQ.MTR_TEST_GRP_CD                               
                      ,MQ.TEST_YEAR                                     
                      ,MQ.SAMPL_OVERAGE_PCT                             
                      ,MQ.SAMPL_CORRECTV_PCT                            
                      ,MQ.MTR_TEST_GRP_TX                               
                      ,GG.METER_SIZE_ID                                 
                      ,GG.BEGIN_PURCHASE_DT                             
                      ,GG.END_PURCHASE_DT                               
                      ,M5.METER_SIZE_DESC                               
                      ,GR.SELECT_TYPE_CD                                
                 FROM  CSS_MTR_TEST_HIST  MQ WITH(READUNCOMMITTED)              
                      ,CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)              
                      ,CSS_GAS_TST_GROUP  GG WITH(READUNCOMMITTED)              
                      ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)              
                WHERE  MQ.CODE_UTIL_TYPE   = 'G'                        
                  AND  MQ.TEST_YEAR        = :MQ-TEST-YEAR              
                  AND  MQ.TEST_SCHED_CD    = 'R'                        
                  AND  GR.CODE_UTIL_TYPE   = MQ.CODE_UTIL_TYPE          
                  AND  GR.MTR_TEST_GRP_CD  = MQ.MTR_TEST_GRP_CD         
                  AND  GG.MTR_TEST_GRP_CD  = GR.MTR_TEST_GRP_CD         
                  AND  M5.METER_SIZE_ID    = GG.METER_SIZE_ID           
                  AND  MQ.COMPANY_NO       = GR.COMPANY_NO              
                  AND  MQ.COMPANY_NO       = GG.COMPANY_NO              
                  AND  M5.COMPANY_NO       = MQ.COMPANY_NO              
                  AND  MQ.COMPANY_NO       = '26'                       
                ORDER BY  MQ.MTR_TEST_GRP_CD                            
                         ,GG.METER_SIZE_ID                              
                         ,GG.BEGIN_PURCHASE_DT                          
                  FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_METER_DETAILS CURSOR FOR                              
MFA-TR*        SELECT  MQ.MTR_TEST_GRP_CD                                       
MFA-TR*               ,MQ.TEST_YEAR                                             
MFA-TR*               ,MQ.SAMPL_OVERAGE_PCT                                     
MFA-TR*               ,MQ.SAMPL_CORRECTV_PCT                                    
MFA-TR*               ,MQ.MTR_TEST_GRP_TX                                       
MFA-TR*               ,GG.METER_SIZE_ID                                         
MFA-TR*               ,GG.BEGIN_PURCHASE_DT                                     
MFA-TR*               ,GG.END_PURCHASE_DT                                       
MFA-TR*               ,M5.METER_SIZE_DESC                                       
MFA-TR*               ,GR.SELECT_TYPE_CD                                        
MFA-TR*          FROM  CSS_MTR_TEST_HIST  MQ                                    
MFA-TR*               ,CSS_MTR_TEST_GROUP GR                                    
MFA-TR*               ,CSS_GAS_TST_GROUP  GG                                    
MFA-TR*               ,CSS_GAS_METER_SIZE M5                                    
MFA-TR*         WHERE  MQ.CODE_UTIL_TYPE   = 'G'                                
MFA-TR*           AND  MQ.TEST_YEAR        = :MQ-TEST-YEAR                      
MFA-TR*           AND  MQ.TEST_SCHED_CD    = 'R'                                
MFA-TR*           AND  GR.CODE_UTIL_TYPE   = MQ.CODE_UTIL_TYPE                  
MFA-TR*           AND  GR.MTR_TEST_GRP_CD  = MQ.MTR_TEST_GRP_CD                 
MFA-TR*           AND  GG.MTR_TEST_GRP_CD  = GR.MTR_TEST_GRP_CD                 
MFA-TR*           AND  M5.METER_SIZE_ID    = GG.METER_SIZE_ID                   
MFA-TR*           AND  MQ.COMPANY_NO       = GR.COMPANY_NO                      
MFA-TR*           AND  MQ.COMPANY_NO       = GG.COMPANY_NO                      
MFA-TR*           AND  M5.COMPANY_NO       = MQ.COMPANY_NO                      
MFA-TR*           AND  MQ.COMPANY_NO       = '26'                               
MFA-TR*         ORDER BY  MQ.MTR_TEST_GRP_CD                                    
MFA-TR*                  ,GG.METER_SIZE_ID                                      
MFA-TR*                  ,GG.BEGIN_PURCHASE_DT                                  
MFA-TR*           FOR FETCH  ONLY WITH UR                                       
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 0200-GET-TEST-YEAR            THRU  0200-EXIT.       
           PERFORM 2000-WRITE-HEADER-RECORDS     THRU  2000-EXIT.       
           PERFORM 2100-GET-METER-DETAILS        THRU  2100-EXIT.       
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT OUTFILE.                                         
           MOVE '26'                      TO C7-COMPANY-NO.             
           PERFORM 7000-GET-COMPANY-NAME         THRU 7000-EXIT.        
           MOVE C7-COMPANY-NAME           TO RPT-COMPANY-NAME.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 0200-GET-TEST-YEAR                                           **        
      ******************************************************************        
      *                                                                         
       0200-GET-TEST-YEAR.                                              
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
           MOVE 'PCSRP515'                TO WS-PGRMNAME.               
           MOVE '26'                      TO G6-COMPANY-NO.             
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE G6-PARM-DATA(10:4)        TO MQ-TEST-YEAR               
                                             RPT-YEAR.                  
           IF MQ-TEST-YEAR EQUAL ZEROES                                 
              IF WS-OVERRIDE-DATE-SW = 'N'                              
                 PERFORM 7100-GET-CURR-DT-TIME   THRU 7100-EXIT         
                 MOVE WS-RUN-DATE(1:4)    TO MQ-TEST-YEAR               
                                             RPT-YEAR                   
              END-IF                                                    
           END-IF.                                                      
           DISPLAY 'TEST YEAR: ' MQ-TEST-YEAR.                          
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-WRITE-HEADER-RECORDS                                    **        
      ******************************************************************        
      *                                                                         
       2000-WRITE-HEADER-RECORDS.                                       
      *                                                                         
           MOVE WS-RPT-HEADER-1      TO OUTFILE-REC.                    
           PERFORM 8000-WRITE-OUTFILE      THRU 8000-EXIT.              
           MOVE WS-RPT-HEADER-2      TO OUTFILE-REC.                    
           PERFORM 8000-WRITE-OUTFILE      THRU 8000-EXIT.              
           MOVE WS-RPT-HEADER-3      TO OUTFILE-REC.                    
           PERFORM 8000-WRITE-OUTFILE      THRU 8000-EXIT.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-GET-METER-DETAILS                                       **        
      ******************************************************************        
      *                                                                         
       2100-GET-METER-DETAILS.                                          
      *                                                                         
           PERFORM 7200-OPEN-MTR-DTLS               THRU 7200-EXIT.     
           PERFORM 7300-FETCH-MTR-DTLS              THRU 7300-EXIT.     
           PERFORM 2200-PROCESS-MTR-DTLS            THRU 2200-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7400-CLOSE-MTR-DTLS              THRU 7400-EXIT.     
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-MTR-DTLS                                        **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-MTR-DTLS.                                           
      *                                                                         
           COMPUTE WS-REC-COUNT = WS-REC-COUNT + 1.                     
      *                                                                         
           MOVE SPACES                    TO WS-GAS-METER-TYPE          
                                             WS-MTR-TEST-GRP-CD.        
           MOVE GG-METER-SIZE-ID          TO WS-GAS-METER-SIZE-ID.      
           MOVE M5-METER-SIZE-DESC        TO WS-GAS-METER-SIZE-DESC.    
           MOVE MQ-MTR-TEST-GRP-CD        TO WS-MTR-TEST-GRP-CODE.      
           MOVE MQ-MTR-TEST-GRP-TX        TO WS-MTR-TEST-GRP-TX.        
           MOVE WS-MTR-TEST-GRP-CODE      TO OUT-MTR-TEST-GRP-CD1.      
           MOVE WS-MTR-TEST-GRP-TX        TO OUT-MTR-TEST-GRP-CD2.      
           MOVE MQ-SAMPL-OVERAGE-PCT      TO OUT-SAMPL-OVERAGE-PCT.     
           MOVE MQ-SAMPL-CORRECTV-PCT     TO OUT-SAMPL-CORRECTV-PCT.    
           MOVE WS-GAS-METER-TYPE         TO OUT-GAS-METER-TYPE.        
           MOVE GG-BEGIN-PURCHASE-DT      TO OUT-BEGIN-PURCHASE-DT.     
           MOVE GG-END-PURCHASE-DT        TO OUT-END-PURCHASE-DT.       
           MOVE GR-SELECT-TYPE-CD         TO OUT-SELECT-TYPE-CD.        
           PERFORM 8000-WRITE-OUTFILE            THRU 8000-EXIT.        
           PERFORM 7300-FETCH-MTR-DTLS           THRU 7300-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **7000-GET-COMPANY-NAME                                         **        
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP515 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7100-GET-CURR-DT-TIME                                  **              
      ************************************************************              
      *                                                                         
       7100-GET-CURR-DT-TIME.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-TIME,
              :WS-RUN-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RUN-TIME = CURRENT TIME                                 
MFA-TR*            ,:WS-RUN-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP515 ABORT *****'                   
              DISPLAY '**  7100-GET-CURR-DT-TIME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-MTR-DTLS                                             *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-MTR-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_METER_DETAILS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP515 ABORT ******'                  
              DISPLAY '**  7200-OPEN-MTR-DTLS      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7300-FETCH-MTR-DTLS                                    **              
      ************************************************************              
      *                                                                         
       7300-FETCH-MTR-DTLS.                                             
      *                                                                         
           EXEC SQL                                                     
                FETCH GET_METER_DETAILS                                 
                  INTO :MQ-MTR-TEST-GRP-CD                              
                      ,:MQ-TEST-YEAR                                    
                      ,:MQ-SAMPL-OVERAGE-PCT                            
                      ,:MQ-SAMPL-CORRECTV-PCT                           
                      ,:MQ-MTR-TEST-GRP-TX                              
                      ,:GG-METER-SIZE-ID                                
                      ,:GG-BEGIN-PURCHASE-DT                            
                      ,:GG-END-PURCHASE-DT                              
                      ,:M5-METER-SIZE-DESC                              
                      ,:GR-SELECT-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP515 ABORT *****'                   
              DISPLAY '**  7300-FETCH-MTR-DTLS    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  MQ-TEST-YEAR = ' MQ-TEST-YEAR                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-CLOSE-MTR-DTLS                                            *        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-MTR-DTLS.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_METER_DETAILS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP515 ABORT *****'                   
              DISPLAY '**  7400-CLOSE-MTR-DTLS    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-OUTFILE.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-OUTFILE.                                              
      *                                                                         
           WRITE OUTFILE-REC.                                           
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE OUTFILE.                                               
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
