       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP505.                                      
COB303 DATE-WRITTEN.     FEB 04, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- THIS PROGRAM LISTS ALL SAMPLE SELECTION CRITERIA FOR A TEST--*        
      *-- YEAR FOR ELECTRIC METERS                                   --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  02/04/2016    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT040*--                            ELC505 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN TO UT-S-FCSPT331.                                 
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 PRT331-RECORD               PIC X(133).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP505'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTR_TEST_HIST, MQ                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRTST                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ELEC_TST_GROUP, TG                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBELGRP                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ELEC_MTR_SPEC, U5                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEMTRSP                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * ABEND SWITCH COPYBOOK                                       *           
      ***************************************************************           
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ***************************************************************           
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'              *           
      ***************************************************************           
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
      *                                                                         
           05 WS-PGRMNAME               PIC X(08) VALUE SPACES.         
           05 WS-SAMPL-CORRECTV-PCT     PIC 9(02) VALUE ZEROES.         
           05 WS-REC-COUNT              PIC 9(06) VALUE ZEROES.         
           05 WS-RPT-LINE-CNT           PIC 9(06) VALUE ZEROES.         
           05 WS-RPT-PAGE-NUM           PIC 9(06) VALUE ZEROES.         
           05 WS-RPT-NO-DATA            PIC X(01) VALUE SPACES.         
           05 WS-RUN-TIME               PIC X(08) VALUE SPACES.         
           05 WS-RUN-DATE               PIC X(10) VALUE SPACES.         
           05 WS-RPT-DATE.                                              
              10 WS-RPT-MM              PIC X(02) VALUE SPACES.         
              10 FILLER                 PIC X(01) VALUE '/'.            
              10 WS-RPT-DD              PIC X(02) VALUE SPACES.         
              10 FILLER                 PIC X(01) VALUE '/'.            
              10 WS-RPT-YY              PIC X(04) VALUE SPACES.         
      *                                                                         
       01 WS-LITERALS.                                                  
      *                                                                         
           05 WS-COMPANY-NO             PIC X(02) VALUE '01'.           
           05 WS-RPT-HDR-EXIST          PIC X(01) VALUE 'Y'.            
           05 WS-RPT-PAGE-BREAK         PIC X(01) VALUE 'N'.            
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-RPT-DESC               PIC X(40)                       
              VALUE 'SAMPLE ELECTRIC METER TEST CRITERIA FOR '.         
      ***************** PCSRP505 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(02) VALUE SPACES.          
               10  RPT-PGM-NAME        PIC X(08) VALUE SPACES.          
               10  FILLER              PIC X(36) VALUE SPACES.          
               10  RPT-NAME            PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X(48) VALUE SPACES.          
               10  FILLER              PIC X(04) VALUE 'PAGE'.          
               10  RPT-PGNUM           PIC Z(06)9.                      
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(06) VALUE 'DATE: '.        
               10  RPT-DATE            PIC X(10) VALUE SPACES.          
               10  FILLER              PIC X(26) VALUE SPACES.          
               10  RPT-DESC            PIC X(40) VALUE SPACES.          
               10  RPT-YEAR            PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(23) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN DATE: '.    
               10  RPT-RUN-DATE        PIC X(10) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER              PIC X(112) VALUE SPACES.         
               10  FILLER              PIC X(12) VALUE 'RUN TIME:   '.  
               10  RPT-TIME            PIC X(08) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER              PIC X(133) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-COLUMN-1.                                         
               10  FILLER              PIC X(23) VALUE SPACES.          
               10  FILLER              PIC X(06) VALUE 'SAMPLE'.        
               10  FILLER              PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(06) VALUE 'SAMPLE'.        
               10  FILLER              PIC X(03) VALUE SPACES.          
               10  FILLER              PIC X(08) VALUE 'ELECTRIC'.      
               10  FILLER              PIC X(18) VALUE SPACES.          
               10  FILLER              PIC X(05) VALUE 'BEGIN'.         
               10  FILLER              PIC X(07) VALUE SPACES.          
               10  FILLER              PIC X(03) VALUE 'END'.           
               10  FILLER              PIC X(05) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-COLUMN-2.                                         
               10  FILLER              PIC X(23) VALUE SPACES.          
               10  FILLER              PIC X(07) VALUE 'OVERAGE'.       
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'CORRECTIVE'.    
               10  FILLER              PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(05) VALUE 'METER'.         
               10  FILLER              PIC X(03) VALUE SPACES.          
               10  FILLER              PIC X(14)                        
                                       VALUE 'ELECTRIC METER'.          
               10  FILLER              PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(08) VALUE 'PURCHASE'.      
               10  FILLER              PIC X(03) VALUE SPACES.          
               10  FILLER              PIC X(08) VALUE 'PURCHASE'.      
      *                                                                         
           05  WS-RPT-COLUMN-3.                                         
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(21)                        
                                       VALUE 'METER TEST GROUP CODE'.   
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(07) VALUE 'PERCENT'.       
               10  FILLER              PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(07) VALUE 'PERCENT'.       
               10  FILLER              PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(05) VALUE 'CLASS'.         
               10  FILLER              PIC X(03) VALUE SPACES.          
               10  FILLER              PIC X(13) VALUE 'SPECIFICATION'. 
               10  FILLER              PIC X(05) VALUE SPACES.          
               10  FILLER              PIC X(04) VALUE 'DATE'.          
               10  FILLER              PIC X(07) VALUE SPACES.          
               10  FILLER              PIC X(04) VALUE 'DATE'.          
      *                                                                         
           05  WS-RPT-DETAIL.                                           
               10  FILLER                   PIC X(05) VALUE SPACES.     
               10  RPT-MTR-TEST-GRP-CD      PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  RPT-MTR-TEST-GRP-TX      PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(07) VALUE SPACES.     
               10  RPT-SAMPL-OVERAGE-PCT    PIC 9(02) VALUE ZEROES.     
               10  FILLER                   PIC X(07) VALUE SPACES.     
               10  RPT-SAMPL-CORRECTV-PCT   PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(09) VALUE SPACES.     
               10  RPT-ELEC-MTR-CLASS-CD    PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(04) VALUE SPACES.     
               10  RPT-ELEC-MTR-SPEC-CD     PIC X(03) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  RPT-ELEC-MTR-SPEC-DESC   PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  RPT-BEGIN-PURCHASE-DT    PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  RPT-END-PURCHASE-DT      PIC X(10) VALUE SPACES.     
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                       PIC X(55) VALUE SPACES.     
           05  FILLER                       PIC X(22) VALUE             
                     '*** END OF REPORT ***'.                           
           05  FILLER                       PIC X(55) VALUE SPACES.     
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                  PIC X(55) VALUE SPACES.          
           05  FILLER                  PIC X(32) VALUE                  
                     '** NO DATA FOUND FOR THIS RUN **'.                
           05  FILLER                  PIC X(45) VALUE SPACES.          
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *DRIVING CURSOR FOR THIS PROGRAM                               *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
              DECLARE MAIN_CSR CURSOR FOR                               
                 SELECT                                                 
                      MQ.MTR_TEST_GRP_CD                                
                     ,MQ.TEST_YEAR                                      
                     ,MQ.SAMPL_OVERAGE_PCT                              
                     ,MQ.SAMPL_CORRECTV_PCT                             
                     ,MQ.MTR_TEST_GRP_TX                                
                     ,TG.ELEC_MTR_CLASS_CD                              
                     ,TG.ELEC_MTR_SPEC_CD                               
                     ,TG.BEGIN_PURCHASE_DT                              
                     ,TG.END_PURCHASE_DT                                
                     ,U5.ELEC_MTR_SPEC_DESC                             
                 FROM                                                   
                      CSS_MTR_TEST_HIST  MQ WITH(READUNCOMMITTED)               
                     ,CSS_ELEC_TST_GROUP TG WITH(READUNCOMMITTED)               
                     ,CSS_ELEC_MTR_SPEC  U5 WITH(READUNCOMMITTED)               
                WHERE MQ.CODE_UTIL_TYPE    = 'E'                        
                  AND MQ.TEST_YEAR         = :MQ-TEST-YEAR              
                  AND MQ.TEST_SCHED_CD     = 'R'                        
                  AND MQ.MTR_TEST_GRP_CD   = TG.MTR_TEST_GRP_CD         
                  AND TG.ELEC_MTR_SPEC_CD  = U5.ELEC_MTR_SPEC_CD        
                  AND MQ.COMPANY_NO        = :WS-COMPANY-NO             
                  AND MQ.COMPANY_NO        = TG.COMPANY_NO              
                ORDER BY MQ.MTR_TEST_GRP_CD                             
                     ,TG.ELEC_MTR_CLASS_CD                              
                     ,TG.ELEC_MTR_SPEC_CD                               
                     ,TG.BEGIN_PURCHASE_DT                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAIN_CSR CURSOR FOR                                       
MFA-TR*          SELECT                                                         
MFA-TR*               MQ.MTR_TEST_GRP_CD                                        
MFA-TR*              ,MQ.TEST_YEAR                                              
MFA-TR*              ,MQ.SAMPL_OVERAGE_PCT                                      
MFA-TR*              ,MQ.SAMPL_CORRECTV_PCT                                     
MFA-TR*              ,MQ.MTR_TEST_GRP_TX                                        
MFA-TR*              ,TG.ELEC_MTR_CLASS_CD                                      
MFA-TR*              ,TG.ELEC_MTR_SPEC_CD                                       
MFA-TR*              ,TG.BEGIN_PURCHASE_DT                                      
MFA-TR*              ,TG.END_PURCHASE_DT                                        
MFA-TR*              ,U5.ELEC_MTR_SPEC_DESC                                     
MFA-TR*          FROM                                                           
MFA-TR*               CSS_MTR_TEST_HIST  MQ                                     
MFA-TR*              ,CSS_ELEC_TST_GROUP TG                                     
MFA-TR*              ,CSS_ELEC_MTR_SPEC  U5                                     
MFA-TR*         WHERE MQ.CODE_UTIL_TYPE    = 'E'                                
MFA-TR*           AND MQ.TEST_YEAR         = :MQ-TEST-YEAR                      
MFA-TR*           AND MQ.TEST_SCHED_CD     = 'R'                                
MFA-TR*           AND MQ.MTR_TEST_GRP_CD   = TG.MTR_TEST_GRP_CD                 
MFA-TR*           AND TG.ELEC_MTR_SPEC_CD  = U5.ELEC_MTR_SPEC_CD                
MFA-TR*           AND MQ.COMPANY_NO        = :WS-COMPANY-NO                     
MFA-TR*           AND MQ.COMPANY_NO        = TG.COMPANY_NO                      
MFA-TR*         ORDER BY MQ.MTR_TEST_GRP_CD                                     
MFA-TR*              ,TG.ELEC_MTR_CLASS_CD                                      
MFA-TR*              ,TG.ELEC_MTR_SPEC_CD                                       
MFA-TR*              ,TG.BEGIN_PURCHASE_DT                                      
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-INPUT.                                                   
          05 PARM-LENGTH                PIC S9(04) COMP.                
          05 PARM-COMPANY-NO            PIC X(02).                      
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION USING PARM-INPUT.                             
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 1000-PROCESS-CSR              THRU  1000-EXIT.       
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
           IF PARM-LENGTH > 0                                           
              MOVE PARM-COMPANY-NO        TO MQ-COMPANY-NO              
                                             C7-COMPANY-NO              
           ELSE                                                         
              MOVE WS-COMPANY-NO          TO MQ-COMPANY-NO              
                                             C7-COMPANY-NO              
           END-IF.                                                      
           PERFORM 0200-GET-PARM-DATE            THRU  0200-EXIT.       
           PERFORM 7100-GET-COMPANY-NAME         THRU  7100-EXIT.       
           MOVE C7-COMPANY-NAME           TO RPT-NAME.                  
           PERFORM 7200-GET-CURR-DT-TIME         THRU 7200-EXIT.        
           MOVE WS-RUN-TIME               TO RPT-TIME.                  
           MOVE WS-RUN-DATE(1:4)          TO WS-RPT-YY.                 
           MOVE WS-RUN-DATE(6:2)          TO WS-RPT-MM.                 
           MOVE WS-RUN-DATE(9:2)          TO WS-RPT-DD.                 
           MOVE WS-RPT-DATE               TO RPT-RUN-DATE               
                                             RPT-DATE.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 0200-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       0200-GET-PARM-DATE.                                              
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
           MOVE 'ELC505'                  TO WS-PGRMNAME.               
           MOVE 'PCSRP505'                TO RPT-PGM-NAME.              
           MOVE WS-COMPANY-NO             TO G6-COMPANY-NO.             
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE G6-PARM-DATA(10:4)        TO MQ-TEST-YEAR               
                                             RPT-YEAR.                  
           IF WS-OVERRIDE-DATE-SW = 'N'                                 
              PERFORM 7200-GET-CURR-DT-TIME      THRU 7200-EXIT         
              MOVE WS-RUN-DATE(1:4)       TO MQ-TEST-YEAR               
                                             RPT-YEAR                   
           END-IF.                                                      
           DISPLAY 'PARM-YEAR: ' MQ-TEST-YEAR.                          
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-CSR                                             **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-CSR.                                                
      *                                                                         
           PERFORM 7300-OPEN-MAIN-CSR               THRU  7300-EXIT.    
           PERFORM 7400-FETCH-MAIN-CSR              THRU  7400-EXIT.    
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-Y                   TO WS-RPT-NO-DATA             
           END-IF.                                                      
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT     
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7500-CLOSE-MAIN-CSR              THRU 7500-EXIT.     
           DISPLAY 'TOTAL RECS PROCESSED ' WS-REC-COUNT                 
           PERFORM 2150-WRITE-TRLR                  THRU  2150-EXIT.    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-MAIN-CSR.                                       **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           COMPUTE WS-REC-COUNT =  WS-REC-COUNT + 1.                    
           PERFORM 2050-WRITE-HEADER             THRU 2050-EXIT.        
           PERFORM 2100-WRITE-DETAIL             THRU 2100-EXIT.        
           PERFORM 7400-FETCH-MAIN-CSR           THRU 7400-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-WRITE-HEADER.                                           **        
      ******************************************************************        
      *                                                                         
       2050-WRITE-HEADER.                                               
      *                                                                         
           IF WS-RPT-HDR-EXIST EQUAL WS-Y    OR                         
              WS-RPT-LINE-CNT GREATER THAN 54                           
              MOVE WS-Y                   TO WS-RPT-PAGE-BREAK          
              MOVE ZEROES                 TO WS-RPT-LINE-CNT            
              MOVE WS-N                   TO WS-RPT-HDR-EXIST           
              ADD +1                      TO WS-RPT-PAGE-NUM            
              MOVE WS-RPT-PAGE-NUM        TO RPT-PGNUM                  
              MOVE WS-RPT-HEADER-1        TO PRT331-RECORD              
              PERFORM 8100-WRITE-FCSPT331        THRU 8100-EXIT         
              MOVE WS-RPT-DESC            TO RPT-DESC                   
              MOVE WS-RPT-HEADER-2        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331        THRU 8000-EXIT         
              MOVE WS-RPT-HEADER-3        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331        THRU 8000-EXIT         
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200-WRITE-FCSPT331       THRU 8200-EXIT          
              MOVE WS-RPT-COLUMN-1        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331       THRU 8000-EXIT          
              MOVE WS-RPT-COLUMN-2        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331       THRU 8000-EXIT          
              MOVE WS-RPT-COLUMN-3        TO PRT331-RECORD              
              PERFORM 8000-WRITE-FCSPT331       THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-WRITE-DETAIL.                                           **        
      ******************************************************************        
      *                                                                         
       2100-WRITE-DETAIL.                                               
      *                                                                         
           MOVE MQ-MTR-TEST-GRP-CD        TO RPT-MTR-TEST-GRP-CD.       
           MOVE MQ-MTR-TEST-GRP-TX        TO RPT-MTR-TEST-GRP-TX.       
           MOVE MQ-SAMPL-OVERAGE-PCT      TO RPT-SAMPL-OVERAGE-PCT.     
           IF MQ-SAMPL-CORRECTV-PCT = 0                                 
              MOVE SPACES                 TO RPT-SAMPL-CORRECTV-PCT     
           ELSE                                                         
              MOVE MQ-SAMPL-CORRECTV-PCT  TO WS-SAMPL-CORRECTV-PCT      
              MOVE WS-SAMPL-CORRECTV-PCT  TO RPT-SAMPL-CORRECTV-PCT     
           END-IF.                                                      
           MOVE TG-ELEC-MTR-CLASS-CD      TO RPT-ELEC-MTR-CLASS-CD.     
           MOVE TG-ELEC-MTR-SPEC-CD       TO RPT-ELEC-MTR-SPEC-CD.      
           MOVE U5-ELEC-MTR-SPEC-DESC     TO RPT-ELEC-MTR-SPEC-DESC.    
           MOVE TG-BEGIN-PURCHASE-DT      TO RPT-BEGIN-PURCHASE-DT.     
           MOVE TG-END-PURCHASE-DT        TO RPT-END-PURCHASE-DT.       
           MOVE WS-RPT-DETAIL             TO PRT331-RECORD.             
           IF WS-RPT-PAGE-BREAK EQUAL WS-Y                              
              PERFORM 8300-WRITE-FCSPT331       THRU 8300-EXIT          
              MOVE WS-N                   TO WS-RPT-PAGE-BREAK          
           ELSE                                                         
              PERFORM 8000-WRITE-FCSPT331       THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2150-WRITE-TRLR.                                                 
      *                                                                         
           IF WS-RPT-NO-DATA = 'Y'                                      
              MOVE WS-NO-DATA                TO PRT331-RECORD           
              PERFORM 8000-WRITE-FCSPT331          THRU 8000-EXIT       
           ELSE                                                         
              MOVE WS-END-DATA               TO PRT331-RECORD           
              PERFORM 8000-WRITE-FCSPT331          THRU 8000-EXIT       
           END-IF.                                                      
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7100-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP505 ABORT *****'                   
              DISPLAY '**  7100-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7200-GET-CURR-DT-TIME                                  **              
      ************************************************************              
      *                                                                         
       7200-GET-CURR-DT-TIME.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-TIME,
              :WS-RUN-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RUN-TIME = CURRENT TIME                                 
MFA-TR*            ,:WS-RUN-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP505 ABORT *****'                   
              DISPLAY '**  7200-GET-CURR-DT-TIME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-MAIN-CSR.                                            *        
      ******************************************************************        
      *                                                                         
       7300-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN MAIN_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP505 ABORT ******'                  
              DISPLAY '**  7300-OPEN-MAIN-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-FETCH-MAIN-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7400-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH MAIN_CSR                                            
               INTO :MQ-MTR-TEST-GRP-CD                                 
                   ,:MQ-TEST-YEAR                                       
                   ,:MQ-SAMPL-OVERAGE-PCT                               
                   ,:MQ-SAMPL-CORRECTV-PCT                              
                   ,:MQ-MTR-TEST-GRP-TX                                 
                   ,:TG-ELEC-MTR-CLASS-CD                               
                   ,:TG-ELEC-MTR-SPEC-CD                                
                   ,:TG-BEGIN-PURCHASE-DT                               
                   ,:TG-END-PURCHASE-DT                                 
                   ,:U5-ELEC-MTR-SPEC-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP505 ABORT ******'                  
              DISPLAY '**  7400-FETCH-MAIN-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  MQ.TEST_YEAR  ' MQ-TEST-YEAR                 
              DISPLAY '**  MQ.COMPANY_NO ' MQ-COMPANY-NO                
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-CLOSE-MAIN-CSR.                                           *        
      ******************************************************************        
      *                                                                         
       7500-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE MAIN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP505 ABORT ******'                  
              DISPLAY '**  7500-CLOSE-MAIN-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT331.                                        **         
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT-LINE-CNT.           
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
