       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP501.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. AUG-2001.                                          
       *****************************************************************
       *               SOUTH CAROLINA ELECTRIC & GAS                   *
       **                                                             **
       *****************************************************************
       ********        CUSTOMER INFORMATION  SYSTEM            *********
       *****************************************************************
       **                   P R O G R A M S U M M A R Y               **
       **                                                             **
       **                                                             **
       **  PURPOSE :                                                  **
       **  GENERATE A REPORT TO GIVE TOTAL INTEREST EARNED FOR        **
       **  PERVIOUS YEAR ,FOR ALL CONTRACTS WITH INTEREST OR          **
       **  INSTALLMENTS.                                              **
       **                                                             **
       *****************************************************************
       **                                                             **
       **              PROGRAM  MODIFICATION  LOG                     **
       **                                                             **
       **     DATE       INITIALS         REASON                      **
       **    ======      =========        =======                     **
       **   08-07-2001   COVANSYS         NEW REPORT PROGRAM          **
       **                                 FOR REPORT GENERATION       **
T28246 **   01-15-2003   LAT              TO INCLUDE TRANSFERRED      **
T28246 **                                 CONTRACTS IN THE INTEREST   **
T28246 **                                 CALCULATION.                **
A05460 **   06-28-2016   MS7M727          REMOVED REPORT AND UPDATING **
A05460 **                ACT189           TABLE                       **
       *****************************************************************
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP501'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP501 STARTS HERE'.                  
                                                                        
       01 WS-MISC.                                                      
          05  WS-SYSIN-COMP-NO           PIC X(01) VALUE SPACES.        
          05  WS-NULL-IND                PIC S9(04) COMP.               
          05  WS-PREV-COMPANY-NO         PIC X(02) VALUE SPACES.        
          05  WS-COMP-NAME               PIC X(26) VALUE SPACES.        
          05  WS-MAX-LINES               PIC 9(02) VALUE 56.            
          05  WS-LINE-COUNT              PIC 9(02) VALUE 57.            
          05  WS-PAGE-COUNT              PIC 9(03) VALUE ZERO.          
          05  WS-PGRMNAME                PIC X(08) VALUE 'PCSRP501'.    
          05  WS-PGMNAME                 PIC X(08) VALUE 'PCSRP501'.    
          05  WS-ERR-MSG                 PIC X(40) VALUE SPACES.        
          05  WS-DISP-RC                 PIC -ZZZZZZZZ9.9.              
          05  WS-TOTAL                   PIC S9(09)V99 VALUE 0.         
          05  WS-PREV-YEAR-NUM           PIC 9(4) VALUE 0.              
          05  WS-PREV-YEAR REDEFINES     WS-PREV-YEAR-NUM               
                                         PIC X(4) .                     
          05  WS-ST-DATE                 PIC X(10).                     
          05  WS-END-DATE                PIC X(10).                     
          05 WS-SYSIN-CCYY               PIC 9(04).                     
                                                                        
          05  WS-DATE-CASH-REPORT.                                      
              10  WS-REP-MM              PIC X(02).                     
              10  FILLER                 PIC X(01) VALUE '-'.           
              10  WS-REP-DD              PIC X(02).                     
              10  FILLER                 PIC X(01) VALUE '-'.           
              10  WS-REP-CCYY            PIC X(04).                     
           05 WS-FROM-DATE.                                             
              10 WS-FROM-CCYY            PIC 9(04).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 WS-FROM-MM              PIC 9(02).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 WS-FROM-DD              PIC 9(02).                     
           05 WS-TO-DATE.                                               
              10 WS-TO-CCYY              PIC 9(04).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 WS-TO-MM                PIC 9(02).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 WS-TO-DD                PIC 9(02).                     
                                                                        
                                                                        
        01 WS-LITERALS.                                                 
           05 WS-YES                      PIC X(01) VALUE 'Y'.          
           05 WS-N                        PIC X(01) VALUE 'N'.          
           05 WS-Y                        PIC X(01) VALUE 'Y'.          
           05 WS-ONE                      PIC 9(02) VALUE 01.           
           05 WS-ONE1                     PIC 9(03) VALUE 000.          
           05 WS-ZERO                     PIC 9(02) VALUE 00.           
           05 WS-DEFAULT-COMP             PIC X(02) VALUE '01'.         
           05 WS-01                       PIC 9(02) VALUE 01.           
           05 WS-GL-DEBIT-1               PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 253.2300.     
           05 WS-GL-CREDIT-1              PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 419.2300.     
           05 WS-GL-DEBIT-2               PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 253.2399.     
           05 WS-GL-CREDIT-2              PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 419.2599.     
           05 WS-GL-DEBIT1-PSNC           PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 253.0012.     
           05 WS-GL-CREDIT1-PSNC          PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 415.6725.     
           05 WS-GL-DEBIT2-PSNC           PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 253.0011.     
           05 WS-GL-CREDIT2-PSNC          PIC S9(3)V9(4) USAGE COMP-3   
                                                    VALUE 415.6799.     
        01 WS-SWITCHES.                                                 
           05 WS-FILE-STATUS              PIC X(02).                    
              88 SUCCESSFUL                         VALUE '00'.         
                                                                        
           05 WS-VALID-DATA               PIC X(01).                    
              88 VALID-DATA                         VALUE 'Y'.          
              88 NOT-VALID-DATA                     VALUE 'N'.          
                                                                        
                                                                        
           05 WS-RECORD-FOUND             PIC X(01) VALUE 'N'.          
              88 RECORD-FOUND                       VALUE 'Y'.          
              88 NOT-RECORD-FOUND                   VALUE 'N'.          
                                                                        
           05 WS-SYSIN-DT-EXIST           PIC X(01) VALUE 'Y'.          
              88 SYSIN-DT-EXIST                     VALUE 'Y'.          
              88 SYSIN-DT-NOT-EXIST                 VALUE 'N'.          
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY          PIC 9(02).                        
           05  WS-CURRENT-MM          PIC 9(02).                        
           05  WS-CURRENT-DD          PIC 9(02).                        
                                                                        
       01  WS-CURRENT-TIME            PIC 9(08).                        
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_NAME                                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CUSTOMER                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CONTRACT                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTRCT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CONTRACT_INFO                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTINF                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_AR_TRN_HST_DET                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARHDT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_JOB_PARM                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      *   CURSOR FOR FETCHING TOTAL INTEREST EARNED THE PREVIOUS YEAR *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
            DECLARE DET_CUR CURSOR FOR                                  
             SELECT CT.ACCOUNT_NO,                                      
                    K6.CNT_NAME_DESC,                                   
                    CT.CODE_INTRST_METH,                                
                    CT.CNT_ITEM_ID,                                     
                    AT.COMPANY_NO                                       
               FROM CSS_CONTRACT CT,                                    
                    CSS_ACCOUNT  AT,                                    
                    CSS_CONTRACT_INFO K6                                
              WHERE CT.PYMT_PRIORITY_LVL   = 100                        
                AND (CT.CNT_STATUS_CD      = 'C'                        
                 OR CT.CNT_STATUS_CD       = 'B'                        
T28246           OR CT.CNT_STATUS_CD       = 'R')                       
                AND (CT.CODE_INTRST_METH   = 'C'                        
                 OR CT.CODE_INTRST_METH    = 'B')                       
                AND CT.ACCOUNT_NO = AT.ACCOUNT_NO                       
                AND CT.CNT_NAME_CD = K6.CNT_NAME_CD                     
                AND SUBSTRING(REPLACE(REPLACE(CONVERT(CHAR(26), 
           CT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.'), 1, 4) >= 
                                                          :WS-PREV-YEAR
              ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CT.CNT_ITEM_ID     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE DET_CUR CURSOR FOR                                          
MFA-TR*      SELECT CT.ACCOUNT_NO,                                              
MFA-TR*             K6.CNT_NAME_DESC,                                           
MFA-TR*             CT.CODE_INTRST_METH,                                        
MFA-TR*             CT.CNT_ITEM_ID,                                             
MFA-TR*             AT.COMPANY_NO                                               
MFA-TR*        FROM CSS_CONTRACT CT,                                            
MFA-TR*             CSS_ACCOUNT  AT,                                            
MFA-TR*             CSS_CONTRACT_INFO K6                                        
MFA-TR*       WHERE CT.PYMT_PRIORITY_LVL   = 100                                
MFA-TR*         AND (CT.CNT_STATUS_CD      = 'C'                                
MFA-TR*          OR CT.CNT_STATUS_CD       = 'B'                                
MFA-TR*          OR CT.CNT_STATUS_CD       = 'R')                               
MFA-TR*         AND (CT.CODE_INTRST_METH   = 'C'                                
MFA-TR*          OR CT.CODE_INTRST_METH    = 'B')                               
MFA-TR*         AND CT.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND CT.CNT_NAME_CD = K6.CNT_NAME_CD                             
MFA-TR*         AND SUBSTR(CHAR(CT.LAST_UPDATE_TS),1,4) >= :WS-PREV-YEAR        
MFA-TR*       ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CT.CNT_ITEM_ID             
MFA-TR*     END-EXEC.                                                           
                                                                        
       01  WS-END                              PIC X(40) VALUE          
             'WORKING STORAGE FOR PCSRP501 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000' TO  WS-ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA                               
              THRU 1000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
      ***********************************************************               
      **                                                       **               
      **   0100-INITIALIZATION.                                **               
      **       INITIALIZATION ROUTINE                          **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
                                                                        
      * GET MONTH & YEAR FROM SYSIN                                             
                                                                        
           ACCEPT WS-SYSIN-CCYY        FROM SYSIN.                      
                                                                        
           IF WS-SYSIN-CCYY EQUAL SPACES OR LOW-VALUES                  
              MOVE WS-N                    TO WS-SYSIN-DT-EXIST         
           END-IF.                                                      
                                                                        
           PERFORM 2000-VALIDATE-DATE-PARA THRU 2000-EXIT.              
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS BEGINS HERE                      **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
            MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
            PERFORM 7100-OPEN-TOT-INT-EARNED-CUR                        
               THRU 7100-EXIT.                                          
                                                                        
            PERFORM 7200-FETCH-TOT-INT-EARNED-CUR                       
               THRU 7200-EXIT                                           
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
                                                                        
            PERFORM 7300-CLOSE-TOT-INT-EARNED-CUR                       
               THRU 7300-EXIT.                                          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     2000-VALIDATE-DATE-PARA                               **           
      **          VALIDATES DATE  WHICH IS ACCEPTED FROM SYSIN     **           
      **          IF IT IS SPACES THEN USE COMMON DATE PROCEDURE   **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2000-VALIDATE-DATE-PARA.                                         
                                                                        
           MOVE '2000'                  TO WS-ACTIVE-PARAGRAPH.         
                                                                        
      * SET UP DATE                                                             
           IF SYSIN-DT-NOT-EXIST                                        
              PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT            
              IF COMMON-DATE-NEEDED                                     
                 MOVE 'COMMON  '              TO WS-PGRMNAME            
                 MOVE SPACES                  TO WS-INPUT-AREA          
                 MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN
                 PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT            
                 MOVE WS-PGMNAME              TO WS-PGRMNAME            
              END-IF                                                    
                 MOVE WS-INPUT-DATE(1:4)      TO  WS-TO-CCYY            
                 MOVE '12'                    TO  WS-TO-MM              
                 MOVE '31'                    TO  WS-TO-DD              
                 COMPUTE WS-TO-CCYY           =   WS-TO-CCYY - WS-01    
                 MOVE    WS-TO-CCYY           TO  WS-FROM-CCYY          
                 MOVE '01'                    TO  WS-FROM-MM            
                 MOVE '01'                    TO  WS-FROM-DD            
                                                                        
           END-IF.                                                      
      *                                                                         
           IF SYSIN-DT-EXIST                                            
              IF WS-SYSIN-CCYY NUMERIC                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE '** INVALID SYSIN DATA  **'                       
                                              TO WS-ERR-MSG             
                 MOVE SQLCODE                 TO WS-DISP-RC             
                 PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT            
              END-IF                                                    
              COMPUTE WS-TO-CCYY              = WS-SYSIN-CCYY - WS-01   
              MOVE '12'                       TO  WS-TO-MM              
              MOVE '31'                       TO  WS-TO-DD              
              COMPUTE WS-FROM-CCYY            = WS-SYSIN-CCYY - WS-01   
              MOVE '01'                       TO  WS-FROM-MM            
              MOVE '01'                       TO  WS-FROM-DD            
           END-IF.                                                      
           MOVE WS-TO-DATE                    TO WS-END-DATE            
           MOVE WS-FROM-DATE                  TO WS-ST-DATE             
           MOVE WS-FROM-CCYY                  TO WS-PREV-YEAR-NUM.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     2200-PROCESS-DETAIL-PARA                              **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2200-PROCESS-DETAIL-PARA.                                        
                                                                        
           MOVE '2200'            TO WS-ACTIVE-PARAGRAPH.               
           MOVE CT-ACCOUNT-NO     TO AU-ACCOUNT-NO                      
                                     AT-ACCOUNT-NO                      
           MOVE CT-CNT-ITEM-ID    TO AU-ITEM-ID.                        
           PERFORM 7400-CALC-TOTAL-INT-EAR              THRU 7400-EXIT  
           IF VALID-DATA                                                
ACT189      PERFORM 8600-UPDATE-CSS-CONTRACT                            
ACT189         THRU 8600-EXIT                                           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7100-OPEN-TOT-INT-EARNED-CUR                           **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7100-OPEN-TOT-INT-EARNED-CUR.                                    
                                                                        
           MOVE '7100'  TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
                OPEN DET_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7100-OPEN-TOT-INT-EARNED-CUR'                       
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      **                                                           **           
      **    7200-FETCH-TOT-INT-EARNED-CUR                          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7200-FETCH-TOT-INT-EARNED-CUR.                                   
                                                                        
           MOVE '7200'  TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
                FETCH DET_CUR INTO                                      
                   :CT-ACCOUNT-NO,                                      
                   :K6-CNT-NAME-DESC,                                   
                   :CT-CODE-INTRST-METH,                                
                   :CT-CNT-ITEM-ID,                                     
                   :AT-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 2200-PROCESS-DETAIL-PARA THRU 2200-EXIT     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE 'ERROR IN FETCHING BATCH ACTIVE CURSOR'        
                                                  TO WS-ERR-MSG         
                    MOVE SQLCODE                  TO WS-DISP-RC         
                   PERFORM 9900-ABEND    THRU 9900-EXIT.                
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7300-CLOSE-TOT-INT-EARNED-CUR                          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7300-CLOSE-TOT-INT-EARNED-CUR.                                   
                                                                        
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                CLOSE DET_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7300-CLOSE-TOT-INT-EARNED-CUR'                      
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7400-CALC-TOTAL-INTEREST EARNED                          **          
      **                                                            **          
      ****************************************************************          
                                                                        
       7400-CALC-TOTAL-INT-EAR.                                         
                                                                        
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
           SELECT SUM(AMT_POSTED)                                       
             INTO :AU-AMT-POSTED :WS-NULL-IND                           
             FROM CSS_AR_TRN_HST_DET                                    
            WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                           
             AND ITEM_ID    = :AU-ITEM-ID                               
             AND CAST(TRANS_HIST_SEQ_NO AS DATE) BETWEEN                        
                 IIF(TRY_CONVERT(DATE, :WS-ST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ST-DATE) <> 0) OR (LEN(
                                                            :WS-ST-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ST-DATE), CONVERT(DATE, 
                                                            :WS-ST-DATE
              ) ) AND IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                           
             AND (( GL_ACCT_CREDIT >= :WS-GL-CREDIT-1                   
             AND GL_ACCT_CREDIT <  :WS-GL-CREDIT-2                      
             AND GL_ACCT_DEBIT  >= :WS-GL-DEBIT-1                       
             AND GL_ACCT_DEBIT  <  :WS-GL-DEBIT-2)                      
             OR  (GL_ACCT_CREDIT = :WS-GL-CREDIT1-PSNC AND              
                  GL_ACCT_DEBIT  = :WS-GL-DEBIT1-PSNC)                  
             OR  (GL_ACCT_CREDIT = :WS-GL-CREDIT2-PSNC AND              
                  GL_ACCT_DEBIT  = :WS-GL-DEBIT2-PSNC ))                
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT SUM(AMT_POSTED)                                               
MFA-TR*      INTO :AU-AMT-POSTED :WS-NULL-IND                                   
MFA-TR*      FROM CSS_AR_TRN_HST_DET                                            
MFA-TR*     WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                                   
MFA-TR*      AND ITEM_ID    = :AU-ITEM-ID                                       
MFA-TR*      AND DATE(TRANS_HIST_SEQ_NO) BETWEEN                                
MFA-TR*          :WS-ST-DATE AND :WS-END-DATE                                   
MFA-TR*      AND (( GL_ACCT_CREDIT >= :WS-GL-CREDIT-1                           
MFA-TR*      AND GL_ACCT_CREDIT <  :WS-GL-CREDIT-2                              
MFA-TR*      AND GL_ACCT_DEBIT  >= :WS-GL-DEBIT-1                               
MFA-TR*      AND GL_ACCT_DEBIT  <  :WS-GL-DEBIT-2)                              
MFA-TR*      OR  (GL_ACCT_CREDIT = :WS-GL-CREDIT1-PSNC AND                      
MFA-TR*           GL_ACCT_DEBIT  = :WS-GL-DEBIT1-PSNC)                          
MFA-TR*      OR  (GL_ACCT_CREDIT = :WS-GL-CREDIT2-PSNC AND                      
MFA-TR*           GL_ACCT_DEBIT  = :WS-GL-DEBIT2-PSNC ))                        
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND < ZERO                                     
                 MOVE  'N'          TO WS-VALID-DATA                    
              ELSE                                                      
                 MOVE  'Y'          TO  WS-VALID-DATA                   
                 MOVE  'Y'          TO  WS-RECORD-FOUND                 
              END-IF                                                    
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 'N'          TO WS-VALID-DATA                    
               ELSE                                                     
                  MOVE '** SELECT ERROR IN 7400-CALC-TOTAL-INT-EAR **'  
                                    TO WS-ERR-MSG                       
                  MOVE SQLCODE      TO WS-DISP-RC                       
                  PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT            
               END-IF                                                   
            END-IF.                                                     
                                                                        
        7400-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
ACT189******************************************************************        
ACT189**                                                              **        
ACT189**  8600-UPDATE-CSS-CONTRACT                                    **        
ACT189**      IT WILL UPDATE INTRST_PRIOR_YR,INTRST_YTD,LAST_TIMESTAMP**        
ACT189**                                                              **        
ACT189******************************************************************        
ACT189*                                                                         
ACT189 8600-UPDATE-CSS-CONTRACT.                                        
ACT189*                                                                         
ACT189     EXEC SQL                                                     
ACT189         UPDATE  CT                                   
ACT189            SET  CT.INTRST_PRIOR_YR = :AU-AMT-POSTED              
ACT189                ,CT.INTRST_YTD      = 0                           
ACT189                ,CT.LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()           
               FROM CSS_CONTRACT CT
ACT189          WHERE  CT.PYMT_PRIORITY_LVL   = 100                     
ACT189            AND  CT.ACCOUNT_NO      = :CT-ACCOUNT-NO              
ACT189            AND  CT.CNT_ITEM_ID     = :CT-CNT-ITEM-ID             
ACT189     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_CONTRACT CT                                          
MFA-TR*           SET  CT.INTRST_PRIOR_YR = :AU-AMT-POSTED                      
MFA-TR*               ,CT.INTRST_YTD      = 0                                   
MFA-TR*               ,CT.LAST_UPDATE_TS  = CURRENT TIMESTAMP                   
MFA-TR*         WHERE  CT.PYMT_PRIORITY_LVL   = 100                             
MFA-TR*           AND  CT.ACCOUNT_NO      = :CT-ACCOUNT-NO                      
MFA-TR*           AND  CT.CNT_ITEM_ID     = :CT-CNT-ITEM-ID                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT189*                                                                         
ACT189     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT189                                                                  
ACT189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT189        CONTINUE                                                  
ACT189     ELSE                                                         
ACT189        MOVE SQLCODE               TO WS-DISP-RC                  
ACT189        MOVE '8600-UPDATE-CSS-CONTRACT   '                        
ACT189                                   TO WS-ERR-MSG                  
ACT189        DISPLAY 'AMOUNT POSTED '      AU-AMT-POSTED               
ACT189        DISPLAY 'ACCOUNT NO    '      CT-ACCOUNT-NO               
ACT189        DISPLAY 'ITEM ID       '      CT-CNT-ITEM-ID              
ACT189        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
ACT189     END-IF.                                                      
ACT189*                                                                         
ACT189 8600-EXIT.                                                       
ACT189     EXIT.                                                        
ACT189*                                                                         
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP501  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9200-SYSIN-DATA-ERROR                                       **        
      **       SYSIN DATA NOT FOUND                                   **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9200-SYSIN-DATA-ERROR.                                           
                                                                        
           DISPLAY '**   PROCESSING SYSIN NOT FOUND ERR **'.            
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   ABENDING PROGRAM               **'.            
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  6251-GET-FJC01-DATE                                     *              
      *                                                          *              
      ************************************************************              
                                                                        
       COPY CPD00037.                                                           
                                                                        
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      *  7620-START-FCSCA00                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
ACT189******************************************************************55460000
ACT189*     9900-ABEND                                                 *55470000
ACT189*                                                                *55480000
ACT189*     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *55490000
ACT189******************************************************************55500000
ACT189 9900-ABEND.                                                      
010590     DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

ACT189     MOVE 12  TO  RETURN-CODE.                                    
ACT189     MOVE 'YES' TO WS-ABEND-SWITCH.                               
ACT189 9900-EXIT.                                                       
ACT189     IF WS-ABEND-YES                                              
ACT189       STOP RUN
           END-IF.                                                  
