       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP445                                             
       DATE-WRITTEN.   10 NOVEMBER 2006.                                
       DATE-COMPILED.                                                   
      ****************************************************************  00050000
      ****************************************************************  00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                **  00070000
      **              COMPLETE BUSINESS SOLUTIONS INC.              **  00080000
      **                                                            **  00090000
      ********            CUSTOMER SERVICE SYSTEM             ********  00100000
      ********                      DB2                       ********  00110000
      ****************************************************************  00120000
      **                                                            **  00130000
      **            PROGRAM    MODIFICATION  LOG                    **  00140000
      **    DATE    INITIALS     REASON                             **  00150000
      **    ____    ________     ______                             **  00160000
      **                                                            **  00170000
      **  10 NOV 2006 RDF     PROGRAM WRITTEN                       **  00180000
C36665**  27 JUL 2007 SV82012 CHANGES MADE TO REPLACE OPTION CODE   **  00190000
C36665**                      INSTEAD OF RATE PLAN NO.              **  00200000
      **                                                            **  00210000
T33971**   1 JUL 2008 RDF     CHANGED CURSORS FOR PERFORMANCE       **  00220000
      **                      ENHANCEMENTS.  HAD TO CHANGE SOME OF  **  00230000
      **                      PROGRAM FLOW TO ALLOW FOR CHANGES IN  **  00240000
      **                      CURSOR.  DELETED CURSOR OPTION_CD_CSR **  00250000
      **                      AND PUT IT IN THE OTHER CURSORS.      **  00260000
      **                      CHANGE CURRENT DATE RETRIEVE TO SET   **  00270000
      **                                                            **  00280000
C35744**  12 AUG 2008 SS97726 ADD COLUMN OTHER COMMENTS TO THE RPT  **  00290000
C35744**                      TO INDICATE SEB PARTIAL SALES TAX CRD **  00300000
C35744**                      ACCOUNT.                              **  00310000
      **                                                            **  00320000
A00633**   5 FEB 2009 RF10596 DO NOT ABEND ON AN OFF CYCLE.  PUT    **  00330000
      **                      MESSAGE TO PRINTED REPORT.            **  00340000
      **                                                            **  00350000
P00453**  29 JAN 2011 MS93554 CHANGED THE MAIN CURSOR TO PULL THE   **  00360000
      **                      THE FIRST ESTIMATED PRP ACCOUNTS IN   **  00370000
      **                      THE REPORT                            **  00380000
P00473**  19 JUL 2011 SB93596 CHGS INCLUDED TO PULL APPROV0D        **  00390000
P00473**                      OPTION RECORDS.                       **  00400000
      **                                                            **  00410000
A04527**  23 JUN 2013 RF10596 CHANGE CURSOR TO GROUP BY DESCRIPTION **  00420000
      **                                                            **  00430000
ACT199**  02 NOV 2015 SS7F226 REMOVE WRITING CUSTOMERS IN OUTPUT    **  00440000
ACT199**  A05136              WHO HAS MULTIPLE ACCOUNTS.            **  00450000
ACT199**  28 JAN 2016 BD09555 ADDITIONAL CHANGES FOR MULTIPLE       **  00451003
ACT199**  A05136              ACCOUNTS                              **  00452003
      ****************************************************************  00460000
           REMARKS.  CREATE A REPORT OF ACCOUNTS FOR SAMPLE BILLING.    
                              PCSRP445 NARRATIVE                        
            READS CSS_ACCOUNT AND CSS_UTIL_ENVRNMT FOR ACCOUNTS         
            TO RUN THROUGH SAMPLE BILLING.  PUTS OUT A MAXIMUM OF       
            35 ACCOUNTS PER RATE FOR THE REPORT, BUT THE TOTALS         
            ARE ALL FOR THAT RATE.  WE ARE BYPASSING ACCOUNTS WHERE     
            AT-AR-XFER-IND = 'Y' AND AT-BILL-HIST-XFER-IND = 'Y'        
            AND AT-ACCT-XFER-TO > 0.                                    
      *                                                                 00550000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00570000
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00590000
       FILE-CONTROL.                                                    
      *                                                                 00610000
       COPY CSSPT33.                                                    00620000
      *                                                                 00630000
       DATA DIVISION.                                                   
      *                                                                 00650000
       FILE SECTION.                                                    
      *                                                                 00670000
       COPY CFDPT33.                                                    00680000
      *                                                                 00690000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP445'.
MSQ017     COPY MFASQLM.
      *                                                                 00710000
A00633 01 WS-OFF-CYCLE-LIT      PIC X(42)                               
A00633      VALUE 'TODAY IS AN OFF CYCLE - NO DATA TO PROCESS'.         
A00633 01 WS-OFF-CYCLE          PIC X VALUE 'N'.                        
       01 WS-Y                  PIC X VALUE 'Y'.                        
ACT199 01 WS-MULT-ACCT          PIC X(1).                               
       01 WS-HONK-ONE           PIC X VALUE 'Y'.                        
       01 WS-HONK-SEQ           PIC S9(11) COMP-3 VALUE +90000.         
C36665 01 WS-OPTION-COUNT       PIC S9(9)  COMP-3 VALUE 0.              
C36665 01 WS-SR-OPTION-COUNT    PIC S9(9)  COMP-3 VALUE 0.              
       01 WS-LINE-COUNT         PIC S9(3)  COMP-3 VALUE +70.            
       01 WS-PAGE-COUNT         PIC S9(3)  COMP-3 VALUE ZEROS.          
C36665 01 WS-NO-MORE-OPT-FOUND  PIC X   VALUE 'N'.                      
       01 WS-NO-MORE-DATA       PIC X   VALUE 'N'.                      
       01 WS-COMPANY-NO         PIC XX  VALUE '01'.                     
       01 WS-PREV-RATE          PIC XXX VALUE SPACES.                   
C36665 01 WS-PREV-OPTION-CD     PIC X(12) VALUE SPACES.                 
A04527 01 WS-SAVE-OPTION-DESC   PIC X(50)  VALUE SPACES.                
C36665 01 WS-SENIOR-OPTION-CD   PIC X(12) VALUE SPACES.                 
C36665 01 WS-SENIOR-OPTION-DESC PIC X(50) VALUE SPACES.                 
P00453 01 WS-ACTIVE             PIC X(01) VALUE 'A'.                    
       01 WS-SAVE-REV-MONTH     PIC S9(6) COMP-3 VALUE ZEROS.           
       01 WS-BILL-CYCLE-OPEN    PIC XX    VALUE SPACES.                 
       01 WS-DATE-EXTRACT       PIC X(10) VALUE SPACES.                 
       01 WS-CURRENT-DATE       PIC X(10) VALUE SPACES.                 
C36665 01 WS-HOLD-WS-FIELDS.                                            
COB305    05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.             
C36665    05 WS-RATE-PLAN-NO    PIC X(03) VALUE SPACES.                 
C36665    05 WS-CODE-ACCT-STAT  PIC X(01) VALUE SPACES.                 
C36665    05 WS-ACCOUNT-TYPE-CODE PIC X(01) VALUE SPACES.               
COB305    05 WS-ACCT-XFER-TO        PIC S9(13)V USAGE COMP-3 VALUE 0.           
C36665    05 WS-AR-XFER-IND     PIC X(01) VALUE SPACES.                 
C36665    05 WS-SR-NON-SR       PIC X(15) VALUE SPACES.                 
C36665    05 WS-BILL-HIST-XFER-IND PIC X(01) VALUE SPACES.              
      *                                                                 01050000
       01 HEADER1.                                                      
          05 FILLER             PIC X(22)                               
             VALUE '1PROGRAM ID : PCSRP445'.                            
          05 FILLER             PIC X(28) VALUE SPACES.                 
          05 FILLER             PIC X(31)                               
             VALUE '         SCANA ENERGY          '.                   
          05 FILLER             PIC X(36) VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'PAGE = '.              
          05 HDR-PAGE           PIC ZZ9.                                
          05 FILLER             PIC X(6)  VALUE SPACES.                 
      *                                                                 01160000
       01 HEADER2.                                                      
          05 FILLER             PIC X(16) VALUE ' BILL CYCLE :   '.     
          05 HDR-BILL-CYCLE     PIC XX.                                 
          05 FILLER             PIC X(91) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN DATE:  '.          
          05 HDR-DATE           PIC X(10) VALUE SPACES.                 
          05 FILLER             PIC XXX   VALUE SPACES.                 
      *                                                                 01240000
       01 HEADER3.                                                      
C36665    05 FILLER             PIC X(15)  VALUE ' OPTION DESC : '.     
A04527    05 HDR-OPTION-DESC    PIC X(50).                              
C36665    05 FILLER             PIC X(03) VALUE SPACES.                 
A04527    05 FILLER             PIC X(12).                              
C36665    05 FILLER             PIC X(48) VALUE SPACES.                 
      *                                                                 01310000
       01 HEADER4.                                                      
          05 FILLER             PIC X(15)  VALUE '0ACCOUNT NUMBER'.     
          05 FILLER             PIC X(2)   VALUE SPACES.                
          05 FILLER             PIC X(14)  VALUE 'ACCOUNT STATUS'.      
C36665    05 FILLER             PIC X(2)   VALUE SPACES.                
C36665    05 FILLER             PIC X(23)  VALUE                        
C36665                         'AGL SENIOR / NON-SENIOR'.               
A04527    05 FILLER             PIC X(2)  VALUE SPACES.                 
A04527    05 FILLER             PIC X(11)  VALUE 'OPTION CODE'.         
A04527    05 FILLER             PIC X(3)  VALUE SPACES.                 
C35744    05 FILLER             PIC X(8)   VALUE 'COMMENTS'.            
A04527    05 FILLER             PIC X(53)  VALUE SPACES.                
      *                                                                 01440000
       01 PRINT-LINE.                                                   
          05 FILLER             PIC XX.                                 
          05 PRT-ACCT-NBR       PIC X(13).                              
          05 FILLER             PIC X(9).                               
          05 PRT-STATUS         PIC X.                                  
C36665    05 FILLER             PIC X(12).                              
C36665    05 PRT-SR-NON-SR      PIC X(15).                              
A04527    05 FILLER             PIC X(4).                               
A04527    05 PRT-OPTION-CODE    PIC X(12).                              
A04527    05 FILLER             PIC X(3).                               
C35744    05 PRT-COMMENTS       PIC X(50).                              
A04527    05 FILLER             PIC X(12).                              
      *                                                                 01570000
       01 PRINT-TOTAL.                                                  
C36665    05 FILLER             PIC X.                                  
C36665    05 FILLER             PIC X(36)                               
C36665       VALUE 'TOTAL NUMBER OF ACCOUNTS FOR OPTION '.              
C36665    05 PRT-OPTION-DESC    PIC X(50).                              
          05 FILLER             PIC X(4)  VALUE ' IS '.                 
C36665    05 PRT-OPT-CD-TOTAL   PIC 9(11) VALUE ZEROS.                  
C36665    05 FILLER             PIC X(31) VALUE SPACES.                 
      *                                                                 01660000
      *********************                                             01670000
      **  ABEND COPYBOOK **                                             01680000
      *********************                                             01690000
      *                                                                 01700000
       COPY CWS09900.                                                   01710000
      *                                                                 01720000
      ****************************************************              01730000
      ** COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND **              01740000
      ****************************************************              01750000
      *                                                                 01760000
       COPY CWS00303.                                                   01770000
      *                                                                 01780000
P00453 COPY CWS00056.                                                   01790000
      ****************************************************************  01800000
      **            TABLE DEFINITIONS AND DB2 INTERACTIONS          **  01810000
      ****************************************************************  01820000
      *                                                                 01830000
           EXEC SQL                                                     01840000
             INCLUDE SQLCA                                              01850000
           END-EXEC.                                                    01860000
      *                                                                 01870000
      ********************                                              01880000
      **  CSS_JOB_PARM  **                                              01890000
      ********************                                              01900000
      *                                                                 01910000
           EXEC SQL                                                     01920000
             INCLUDE TBJBPARM                                           01930000
           END-EXEC.                                                    01940000
      *                                                                 01950000
      **********************                                            01960000
      **  CSS_UTIL_ENVRNMT**                                            01970000
      **********************                                            01980000
      *                                                                 01990000
           EXEC SQL                                                     02000000
             INCLUDE TBUTLENV                                           02010000
           END-EXEC.                                                    02020000
      *                                                                 02030000
      *******************                                               02040000
      **  CSS_ACCOUNT  **                                               02050000
      *******************                                               02060000
      *                                                                 02070000
           EXEC SQL                                                     02080000
             INCLUDE TBACCT                                             02090000
           END-EXEC.                                                    02100000
      *                                                                 02110000
C36665****************************                                      02120000
C36665**  CSS_ACCT_RTPK_AGR DF **                                       02130000
C36665****************************                                      02140000
C36665*                                                                 02150000
C36665     EXEC SQL                                                     02160000
C36665       INCLUDE TBACCTRG                                           02170000
C36665     END-EXEC.                                                    02180000
C36665*                                                                 02190000
C36665***************************                                       02200000
C36665**  CRM_RT_PKG_OPTION  FI**                                       02210000
C36665***************************                                       02220000
C36665*                                                                 02230000
C36665     EXEC SQL                                                     02240000
C36665       INCLUDE TBRTPKGO                                           02250000
C36665     END-EXEC.                                                    02260000
C36665*                                                                 02270000
C36665***************************                                       02280000
C36665**  CSS_ACCT_ATTRIBUTE YP**                                       02290000
C36665***************************                                       02300000
C36665*                                                                 02310000
C36665     EXEC SQL                                                     02320000
C36665       INCLUDE TBACTATT                                           02330000
C36665     END-EXEC.                                                    02340000
      *                                                                 02350000
      ********************************************                      02360000
      **  CURSOR DECLARATION -- BASE_CSR        **                      02370000
      ********************************************                      02380000
           EXEC SQL                                                     
            DECLARE BASE_CSR CURSOR FOR                                 
             SELECT AT.ACCOUNT_NO                                       
ACT199             ,AT.CUSTOMER_NO                                      
                   ,UT.RATE_PLAN_NO                                     
C35744             ,UT.CODE_STAT_TAX_XMT                                
                   ,AT.CODE_ACCT_STAT                                   
C36665             ,AT.ACCOUNT_TYPE_CODE                                
                   ,AT.ACCT_XFER_TO                                     
                   ,AT.AR_XFER_IND                                      
                   ,AT.BILL_HIST_XFER_IND                               
P00453             ,AT.CODES_DATA_PRESENT                               
T33971             ,FI.OPTION_CD                                        
T33971             ,FI.OPT_DESC_INT                                     
               FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
C36665              ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
T33971              ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
              WHERE AT.BILL_CYCLE = :WS-BILL-CYCLE-OPEN                 
T33971          AND FI.COMPANY_NO = '01'                                
P00473          AND DF.OPTION_CD = FI.OPTION_CD                         
P00473          AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.PROC_STATUS_CD    = 'AC'                         
P00453          AND (AT.CODE_ACCT_BILLED = 'R'                          
P00453           OR (CIS.SUBSTR3(AT.CODES_DATA_PRESENT,15,1) = 'A')          
P00453          AND EXISTS ( SELECT 1                                   
P00453               FROM CSS_OFF_CYCL_ACCT  OC WITH(READUNCOMMITTED)           
P00453              WHERE OC.ACCOUNT_NO   = AT.ACCOUNT_NO               
P00453                AND OC.CODE_BILL_OFF_CYCL = 'P'))                 
                AND AT.CODE_ACCT_STAT <> 'S'                            
                AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                       
C36665          AND UT.ACCOUNT_NO = DF.ACCOUNT_NO                       
C36665          AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE               
C36665          AND UT.IC_NO          = DF.IC_NO                        
C36665          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO         
C36665          AND NOT EXISTS ( SELECT 1                               
C36665                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)          
C36665               WHERE YP.ACCOUNT_NO   = UT.ACCOUNT_NO              
C36665                 AND YP.ATTRIBUTE_DESC  = 'AGL DISCOUNT SR'       
C36665                 AND YP.ATTRIBUTE_VALUE_CD = 'YES')               
A04527        ORDER BY FI.OPT_DESC_INT, AT.ACCOUNT_NO                   
T33971        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02390000
MFA-TR*     DECLARE BASE_CSR CURSOR FOR                                 02400000
MFA-TR*      SELECT AT.ACCOUNT_NO                                       02410000
MFA-TR*            ,AT.CUSTOMER_NO                                      02420000
MFA-TR*            ,UT.RATE_PLAN_NO                                     02430000
MFA-TR*            ,UT.CODE_STAT_TAX_XMT                                02440000
MFA-TR*            ,AT.CODE_ACCT_STAT                                   02450000
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                02460000
MFA-TR*            ,AT.ACCT_XFER_TO                                     02470000
MFA-TR*            ,AT.AR_XFER_IND                                      02480000
MFA-TR*            ,AT.BILL_HIST_XFER_IND                               02490000
MFA-TR*            ,AT.CODES_DATA_PRESENT                               02500000
MFA-TR*            ,FI.OPTION_CD                                        02510000
MFA-TR*            ,FI.OPT_DESC_INT                                     02520000
MFA-TR*        FROM  CSS_ACCOUNT      AT                                02530000
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                02540000
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                               02550000
MFA-TR*             ,CRM_RT_PKG_OPTION FI                               02560000
MFA-TR*       WHERE AT.BILL_CYCLE = :WS-BILL-CYCLE-OPEN                 02570000
MFA-TR*         AND FI.COMPANY_NO = '01'                                02580000
MFA-TR*         AND DF.OPTION_CD = FI.OPTION_CD                         02590000
MFA-TR*         AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP            02600000
MFA-TR*         AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP            02610000
MFA-TR*         AND FI.PROC_STATUS_CD    = 'AC'                         02620000
MFA-TR*         AND (AT.CODE_ACCT_BILLED = 'R'                          02630000
MFA-TR*          OR (SUBSTR(AT.CODES_DATA_PRESENT,15,1) = 'A')          02640000
MFA-TR*         AND EXISTS ( SELECT 1                                   02650000
MFA-TR*              FROM CSS_OFF_CYCL_ACCT  OC                         02660000
MFA-TR*             WHERE OC.ACCOUNT_NO   = AT.ACCOUNT_NO               02670000
MFA-TR*               AND OC.CODE_BILL_OFF_CYCL = 'P'))                 02680000
MFA-TR*         AND AT.CODE_ACCT_STAT <> 'S'                            02690000
MFA-TR*         AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                       02700000
MFA-TR*         AND UT.ACCOUNT_NO = DF.ACCOUNT_NO                       02710000
MFA-TR*         AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE               02720000
MFA-TR*         AND UT.IC_NO          = DF.IC_NO                        02730000
MFA-TR*         AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO         02740000
MFA-TR*         AND NOT EXISTS ( SELECT 1                               02750000
MFA-TR*               FROM CSS_ACCT_ATTRIBUTE YP                        02760000
MFA-TR*              WHERE YP.ACCOUNT_NO   = UT.ACCOUNT_NO              02770000
MFA-TR*                AND YP.ATTRIBUTE_DESC  = 'AGL DISCOUNT SR'       02780000
MFA-TR*                AND YP.ATTRIBUTE_VALUE_CD = 'YES')               02790000
MFA-TR*       ORDER BY FI.OPT_DESC_INT, AT.ACCOUNT_NO                   02800000
MFA-TR*       FOR FETCH ONLY WITH UR                                    02810000
MFA-TR*    END-EXEC.                                                    02820000
      *                                                                 02830000
C36665********************************************                      02840000
C36665**  CURSOR DECLARATION -- AGL_SR_DISCOUNT **                      02850000
C36665********************************************                      02860000
      *                                                                 02870000
C36665     EXEC SQL                                                     
C36665      DECLARE AGL_SR_DISCOUNT CURSOR FOR                          
C36665       SELECT AT.ACCOUNT_NO                                       
ACT199             ,AT.CUSTOMER_NO                                      
C36665             ,UT.RATE_PLAN_NO                                     
C35744             ,UT.CODE_STAT_TAX_XMT                                
C36665             ,AT.CODE_ACCT_STAT                                   
C36665             ,AT.ACCOUNT_TYPE_CODE                                
C36665             ,AT.ACCT_XFER_TO                                     
C36665             ,AT.AR_XFER_IND                                      
C36665             ,AT.BILL_HIST_XFER_IND                               
P00453             ,AT.CODES_DATA_PRESENT                               
T33971             ,FI.OPTION_CD                                        
T33971             ,FI.OPT_DESC_INT                                     
C36665         FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
C36665              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
C36665              ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
T33971              ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
T33971              ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
C36665        WHERE AT.BILL_CYCLE = :WS-BILL-CYCLE-OPEN                 
T33971          AND YP.ACCOUNT_NO = UT.ACCOUNT_NO                       
T33971          AND YP.ATTRIBUTE_DESC  = 'AGL DISCOUNT SR'              
T33971          AND YP.ATTRIBUTE_VALUE_CD = 'YES'                       
T33971          AND FI.COMPANY_NO = '01'                                
P00473          AND DF.OPTION_CD = FI.OPTION_CD                         
P00473          AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.PROC_STATUS_CD    = 'AC'                         
P00453          AND (AT.CODE_ACCT_BILLED = 'R'                          
P00453           OR (CIS.SUBSTR3(AT.CODES_DATA_PRESENT,15,1) = 'A')          
P00453          AND EXISTS ( SELECT 1                                   
P00453               FROM CSS_OFF_CYCL_ACCT  OC WITH(READUNCOMMITTED)           
P00453              WHERE OC.ACCOUNT_NO   = AT.ACCOUNT_NO               
P00453                AND OC.CODE_BILL_OFF_CYCL = 'P'))                 
C36665          AND AT.CODE_ACCT_STAT <> 'S'                            
C36665          AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                       
C36665          AND UT.ACCOUNT_NO = DF.ACCOUNT_NO                       
C36665          AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE               
C36665          AND UT.IC_NO          = DF.IC_NO                        
C36665          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO         
A04527        ORDER BY FI.OPT_DESC_INT, AT.ACCOUNT_NO                   
T33971        FOR READ ONLY                                     
C36665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02880000
MFA-TR*     DECLARE AGL_SR_DISCOUNT CURSOR FOR                          02890000
MFA-TR*      SELECT AT.ACCOUNT_NO                                       02900000
MFA-TR*            ,AT.CUSTOMER_NO                                      02910000
MFA-TR*            ,UT.RATE_PLAN_NO                                     02920000
MFA-TR*            ,UT.CODE_STAT_TAX_XMT                                02930000
MFA-TR*            ,AT.CODE_ACCT_STAT                                   02940000
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                02950000
MFA-TR*            ,AT.ACCT_XFER_TO                                     02960000
MFA-TR*            ,AT.AR_XFER_IND                                      02970000
MFA-TR*            ,AT.BILL_HIST_XFER_IND                               02980000
MFA-TR*            ,AT.CODES_DATA_PRESENT                               02990000
MFA-TR*            ,FI.OPTION_CD                                        03000000
MFA-TR*            ,FI.OPT_DESC_INT                                     03010000
MFA-TR*        FROM  CSS_ACCOUNT      AT                                03020000
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                03030000
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                               03040000
MFA-TR*             ,CRM_RT_PKG_OPTION FI                               03050000
MFA-TR*             ,CSS_ACCT_ATTRIBUTE YP                              03060000
MFA-TR*       WHERE AT.BILL_CYCLE = :WS-BILL-CYCLE-OPEN                 03070000
MFA-TR*         AND YP.ACCOUNT_NO = UT.ACCOUNT_NO                       03080000
MFA-TR*         AND YP.ATTRIBUTE_DESC  = 'AGL DISCOUNT SR'              03090000
MFA-TR*         AND YP.ATTRIBUTE_VALUE_CD = 'YES'                       03100000
MFA-TR*         AND FI.COMPANY_NO = '01'                                03110000
MFA-TR*         AND DF.OPTION_CD = FI.OPTION_CD                         03120000
MFA-TR*         AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP            03130000
MFA-TR*         AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP            03140000
MFA-TR*         AND FI.PROC_STATUS_CD    = 'AC'                         03150000
MFA-TR*         AND (AT.CODE_ACCT_BILLED = 'R'                          03160000
MFA-TR*          OR (SUBSTR(AT.CODES_DATA_PRESENT,15,1) = 'A')          03170000
MFA-TR*         AND EXISTS ( SELECT 1                                   03180000
MFA-TR*              FROM CSS_OFF_CYCL_ACCT  OC                         03190000
MFA-TR*             WHERE OC.ACCOUNT_NO   = AT.ACCOUNT_NO               03200000
MFA-TR*               AND OC.CODE_BILL_OFF_CYCL = 'P'))                 03210000
MFA-TR*         AND AT.CODE_ACCT_STAT <> 'S'                            03220000
MFA-TR*         AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                       03230000
MFA-TR*         AND UT.ACCOUNT_NO = DF.ACCOUNT_NO                       03240000
MFA-TR*         AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE               03250000
MFA-TR*         AND UT.IC_NO          = DF.IC_NO                        03260000
MFA-TR*         AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO         03270000
MFA-TR*       ORDER BY FI.OPT_DESC_INT, AT.ACCOUNT_NO                   03280000
MFA-TR*       FOR FETCH ONLY WITH UR                                    03290000
MFA-TR*    END-EXEC.                                                    03300000
      *                                                                 03310000
       PROCEDURE DIVISION.                                              
      *                                                                 03330000
           PERFORM P0100-INITIALIZATION THRU P0100-EXIT.                
      *                                                                 03350000
A00633     IF WS-OFF-CYCLE = 'N'                                        
              PERFORM P1050-PROCESS-DATA THRU P1050-EXIT                
A00633     END-IF.                                                      
      *                                                                 03390000
           PERFORM P9000-CLOSE-FILES THRU P9000-EXIT.                   
      *                                                                 03410000
           STOP RUN.                                                    
      *                                                                 03430000
      ****************************************************************  03440000
      *  OPEN FILES - GET REPORT DATE FROM DATABASE                  *  03450000
      ****************************************************************  03460000
      *                                                                 03470000
       P0100-INITIALIZATION.                                            
      *                                                                 03490000
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                 03510000
T33971     EXEC SQL                                                     
T33971         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
T33971     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     03520000
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                      03530000
MFA-TR*    END-EXEC.                                                    03540000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03550000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 03570000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP445 ABORT****************'       
              DISPLAY '* P0100-INITIALIZATION - CURRENT DATE   *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSRP445 ABORT****************'       
              PERFORM P9900-ABEND THRU P9900-EXIT                       
           END-IF.                                                      
      *                                                                 03680000
A00633     EXEC SQL                                                     
A00633         SELECT TOP(1) BILL_CYCLE,
              REVENUE_MONTH                                     
A00633         INTO :WS-BILL-CYCLE-OPEN                                 
A00633             ,:WS-SAVE-REV-MONTH                                  
A00633         FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                       
A00633         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
A00633           AND CODE_BILL_COND = 'R'                               
A00633         ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC             
A00633                                       
A00633     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03690000
MFA-TR*        SELECT BILL_CYCLE                                        03700000
MFA-TR*              ,REVENUE_MONTH                                     03710000
MFA-TR*        INTO :WS-BILL-CYCLE-OPEN                                 03720000
MFA-TR*            ,:WS-SAVE-REV-MONTH                                  03730000
MFA-TR*        FROM CSS_BILL_WINDOW                                     03740000
MFA-TR*        WHERE DATE_EXTRACT = :WS-CURRENT-DATE                    03750000
MFA-TR*          AND CODE_BILL_COND = 'R'                               03760000
MFA-TR*        ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC             03770000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             03780000
MFA-TR*    END-EXEC.                                                    03790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03800000
           DISPLAY 'BILL CYCLE OPEN = ' WS-BILL-CYCLE-OPEN.             
           DISPLAY 'SAVE REVENUE MONTH  = ' WS-SAVE-REV-MONTH.          
      *                                                                 03830000
           MOVE WS-BILL-CYCLE-OPEN TO HDR-BILL-CYCLE.                   
A00633     MOVE WS-CURRENT-DATE    TO HDR-DATE.                         
      *                                                                 03860000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 03880000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
A00633        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00633           INITIALIZE PRINT-LINE                                  
A00633           MOVE WS-OFF-CYCLE-LIT TO PRT-COMMENTS                  
A00633           MOVE 'Y' TO WS-OFF-CYCLE                               
A00633           PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT            
A00633           MOVE PRINT-LINE TO PRT33-RECORD                        
A00633           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT             
A00633           GO TO P0100-EXIT                                       
A00633        ELSE                                                      
                 DISPLAY '********** PCSRP445 ABORT****************'    
                 DISPLAY '* P0100-INITIALIZATION - MAX BILL CYCLE *'    
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                   *'    
                 DISPLAY '********** PCSRP445 ABORT****************'    
                 PERFORM P9900-ABEND THRU P9900-EXIT                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04090000
           IF WS-BILL-CYCLE-OPEN = '21'                                 
      *                                                                 04110000
              EXEC SQL                                                  
                  SELECT TOP(1) MIN(DATE_EXTRACT)                              
                  INTO :WS-DATE-EXTRACT                                 
                  FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                  WHERE BILL_CYCLE  = '20'                              
                  AND REVENUE_MONTH = :WS-SAVE-REV-MONTH                
T33971                                       
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  04120000
MFA-TR*           SELECT MIN(DATE_EXTRACT)                              04130000
MFA-TR*           INTO :WS-DATE-EXTRACT                                 04140000
MFA-TR*           FROM CSS_BILL_WINDOW                                  04150000
MFA-TR*           WHERE BILL_CYCLE  = '20'                              04160000
MFA-TR*           AND REVENUE_MONTH = :WS-SAVE-REV-MONTH                04170000
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                          04180000
MFA-TR*       END-EXEC                                                  04190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04200000
              DISPLAY 'DATE EXTRACT = ' WS-DATE-EXTRACT                 
      *                                                                 04220000
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
      *                                                                 04240000
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********** PCSRP445 ABORT****************'    
                 DISPLAY '* P0100-INITIALIZATION - DATE EXTRACT   *'    
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                   *'    
                 DISPLAY '********** PCSRP445 ABORT****************'    
                 PERFORM P9900-ABEND THRU P9900-EXIT                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04360000
           IF WS-DATE-EXTRACT = WS-CURRENT-DATE                         
              MOVE '20' TO WS-BILL-CYCLE-OPEN                           
           END-IF.                                                      
      *                                                                 04400000
           INITIALIZE PRINT-LINE.                                       
      *                                                                 04420000
       P0100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04450000
      ****************************************************************  04460000
      *  MAIN FLOW OF PROGRAM                                        *  04470000
      ****************************************************************  04480000
      *                                                                 04490000
       P1050-PROCESS-DATA.                                              
      *                                                                 04510000
C36665     MOVE 'N'                      TO WS-NO-MORE-DATA.            
C36665     MOVE 'AGL NON-SENIOR '        TO WS-SR-NON-SR.               
           PERFORM P7100-OPEN-BASE-CURSOR THRU P7100-EXIT.              
           PERFORM P7150-FETCH-BASE-CURSOR THRU P7150-EXIT.             
           PERFORM P1100-PROCESS-DATA THRU P1100-EXIT                   
                 UNTIL WS-NO-MORE-DATA = WS-Y.                          
           PERFORM P7200-CLOSE-BASE-CURSOR THRU P7200-EXIT.             
      * GET ALL DETAILS FOR SENIOR CUSTOMERS.                           04590000
T33971     MOVE 'N'                      TO WS-NO-MORE-DATA.            
C36665     PERFORM P1200-GET-AGL-SR-DISCOUNT   THRU P1200-EXIT          
T33971           UNTIL WS-NO-MORE-DATA = WS-Y.                          
      *                                                                 04630000
T33971     PERFORM P1250-PROCESS-ALL-TOTALS THRU P1250-EXIT.            
      *                                                                 04650000
       P1050-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04680000
      ****************************************************************  04690000
      *  MAIN LOOP - PROCESS UNTIL NO MORE DATA                      *  04700000
      ****************************************************************  04710000
      *                                                                 04720000
       P1100-PROCESS-DATA.                                              
      *                                                                 04740000
           IF WS-HONK-ONE = 'Y'                                         
A04527        MOVE FI-OPT-DESC-INT TO WS-SAVE-OPTION-DESC               
C36665        MOVE FI-OPTION-CD    TO WS-PREV-OPTION-CD                 
A04527*                               HDR-OPTION-CD                     04780000
C36665        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C36665           MOVE SPACES            TO FI-OPT-DESC-INT              
C36665           DISPLAY 'DESC NOT FOUND FOR OPTION CODE ' FI-OPTION-CD 
C36665        ELSE                                                      
C36665           MOVE FI-OPT-DESC-INT   TO HDR-OPTION-DESC              
C36665        END-IF                                                    
              MOVE 'N' TO WS-HONK-ONE                                   
           END-IF.                                                      
C36665                                                                  
C36665     IF WS-OPTION-COUNT > 020                                     
C36665        CONTINUE                                                  
C36665     ELSE                                                         
              PERFORM P5000-FORMAT-REPORT THRU P5000-EXIT               
           END-IF.                                                      
      *                                                                 04940000
           PERFORM P7150-FETCH-BASE-CURSOR THRU P7150-EXIT.             
      *                                                                 04960000
T33971*    IF FI-OPTION-CD = WS-PREV-OPTION-CD                          04970000
A04527     IF FI-OPT-DESC-INT = WS-SAVE-OPTION-DESC                     
T33971        CONTINUE                                                  
T33971     ELSE                                                         
T33971        PERFORM P1250-PROCESS-ALL-TOTALS THRU P1250-EXIT          
A04527        MOVE FI-OPT-DESC-INT TO WS-SAVE-OPTION-DESC               
T33971        MOVE FI-OPTION-CD TO WS-PREV-OPTION-CD                    
A04527*                            HDR-OPTION-CD                        05040000
T33971        MOVE FI-OPT-DESC-INT TO HDR-OPTION-DESC                   
T33971     END-IF.                                                      
      *                                                                 05070000
       P1100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05100000
C36665****************************************************************  05110000
C36665*  NEED TO SELECT AT LEAST 3 AGL SENIOR CUSTOMERS OUT OF THE   *  05120000
C36665*  SAMPLE 35 ACCOUNTS PER OPTION CD.                           *  05130000
C36665****************************************************************  05140000
      *                                                                 05150000
C36665 P1200-GET-AGL-SR-DISCOUNT.                                       
C36665                                                                  
C36665     MOVE 'AGL SENIOR     '       TO WS-SR-NON-SR.                
C36665     PERFORM P7400-OPEN-AGL-SR-DISCOUNT   THRU P7400-EXIT.        
C36665     PERFORM P7500-FETCH-AGL-SR-DISCOUNT  THRU P7500-EXIT.        
C36665     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C36665         ADD 1                     TO WS-SR-OPTION-COUNT          
ACT199         IF WS-SR-OPTION-COUNT > 20                               
C36665            CONTINUE                                              
C36665         ELSE                                                     
C36665            PERFORM P5000-FORMAT-REPORT THRU P5000-EXIT           
C36665         END-IF                                                   
C36665         PERFORM P7500-FETCH-AGL-SR-DISCOUNT  THRU P7500-EXIT     
      *                                                                 05290000
T33971*       IF FI-OPTION-CD = WS-PREV-OPTION-CD                       05300000
A04527        IF FI-OPT-DESC-INT = WS-SAVE-OPTION-DESC                  
T33971           CONTINUE                                               
T33971        ELSE                                                      
T33971           PERFORM P1250-PROCESS-ALL-TOTALS THRU P1250-EXIT       
A04527           MOVE FI-OPT-DESC-INT TO WS-SAVE-OPTION-DESC            
T33971           MOVE FI-OPTION-CD TO WS-PREV-OPTION-CD                 
A04527*                               HDR-OPTION-CD                     05370000
T33971           MOVE FI-OPT-DESC-INT TO HDR-OPTION-DESC                
T33971        END-IF                                                    
      *                                                                 05400000
C36665     END-PERFORM.                                                 
C36665     PERFORM P7600-CLOSE-AGL-SR-DISCOUNT  THRU P7600-EXIT.        
C36665                                                                  
C36665 P1200-EXIT.                                                      
C36665     EXIT.                                                        
C36665****************************************************************  05460000
C36665*  PROCESS TOTALS FOR BOTH NON-SENIOR AND SENIOR CUSTOMERS     *  05470000
C36665****************************************************************  05480000
C36665*                                                                 05490000
C36665 P1250-PROCESS-ALL-TOTALS.                                        
C36665     COMPUTE  WS-OPTION-COUNT =                                   
C36665              WS-OPTION-COUNT + WS-SR-OPTION-COUNT.               
      *                                                                 05530000
C36665     PERFORM P4000-RATE-TOTAL THRU P4000-EXIT.                    
      *                                                                 05550000
C36665     MOVE +65 TO WS-LINE-COUNT.                                   
      *                                                                 05570000
C36665     INITIALIZE WS-OPTION-COUNT WS-SR-OPTION-COUNT.               
C36665*                                                                 05590000
C36665 P1250-EXIT.                                                      
C36665     EXIT.                                                        
      ****************************************************************  05620000
      *  PRINT TOTAL NUMBER OF ACCOUNTS FAR A RATE                   *  05630000
      ****************************************************************  05640000
      *                                                                 05650000
       P4000-RATE-TOTAL.                                                
      *                                                                 05670000
C36665     MOVE WS-OPTION-COUNT TO PRT-OPT-CD-TOTAL.                    
A04527     MOVE WS-SAVE-OPTION-DESC TO PRT-OPTION-DESC.                 
      *                                                                 05700000
           IF WS-LINE-COUNT > 57                                        
              PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT               
           END-IF.                                                      
      *                                                                 05740000
           MOVE PRINT-TOTAL TO PRT33-RECORD.                            
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                 05780000
           INITIALIZE PRINT-LINE.                                       
      *                                                                 05800000
       P4000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05830000
C36665****************************************************************  05840000
C36665*  MOVE THE DATA STORED IN WORKING STORAGE BACK TO DCLGEN FIELD*  05850000
C36665****************************************************************  05860000
C36665 P4500-MOVE-WS.                                                   
C36665                                                                  
C36665     MOVE WS-ACCOUNT-NO          TO  AT-ACCOUNT-NO.               
C36665     MOVE WS-RATE-PLAN-NO        TO  UT-RATE-PLAN-NO.             
C36665     MOVE WS-CODE-ACCT-STAT      TO  AT-CODE-ACCT-STAT.           
C36665     MOVE WS-ACCOUNT-TYPE-CODE   TO  AT-ACCOUNT-TYPE-CODE.        
C36665     MOVE WS-ACCT-XFER-TO        TO  AT-ACCT-XFER-TO.             
C36665     MOVE WS-AR-XFER-IND         TO  AT-AR-XFER-IND.              
C36665     MOVE WS-BILL-HIST-XFER-IND  TO  AT-BILL-HIST-XFER-IND.       
C36665                                                                  
C36665 P4500-EXIT.                                                      
C36665     EXIT.                                                        
      ****************************************************************  05990000
      *  PRINT REPORT OF CHANGES AND ERRORS                          *  06000000
      ****************************************************************  06010000
      *                                                                 06020000
       P5000-FORMAT-REPORT.                                             
      *                                                                 06040000
           IF AT-AR-XFER-IND NOT = 'Y'                                  
              AND AT-BILL-HIST-XFER-IND NOT = 'Y'                       
              AND AT-ACCT-XFER-TO = 0                                   
      *                                                                 06080000
              MOVE AT-ACCOUNT-NO     TO PRT-ACCT-NBR                    
A04527        MOVE FI-OPTION-CD      TO PRT-OPTION-CODE                 
              MOVE AT-CODE-ACCT-STAT TO PRT-STATUS                      
C36665        IF AT-ACCOUNT-TYPE-CODE NOT = 'C'                         
                 MOVE WS-SR-NON-SR   TO PRT-SR-NON-SR                   
C36665        END-IF                                                    
      *                                                                 06150000
C35744        IF UT-CODE-STAT-TAX-XMT = 'V'                             
C35744           MOVE 'PARTIAL SALES TAX CREDIT' TO PRT-COMMENTS        
C35744        END-IF                                                    
      *                                                                 06190000
P00453        MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT  
P00453        IF WS-CODE-PRE-PAY-PLAN  = WS-ACTIVE                      
P00453           MOVE 'PRE-PAY-PLAN'    TO PRT-COMMENTS                 
P00453        END-IF                                                    
                                                                        
              IF WS-LINE-COUNT > 57                                     
                 PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT            
              END-IF                                                    
      *                                                                 06280000
ACT199        PERFORM 7290-GET-MULT-ACCTS    THRU 7290-EXIT             
ACT199        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT199           MOVE PRINT-LINE            TO PRT33-RECORD             
ACT199           ADD +1                     TO WS-OPTION-COUNT          
ACT199           PERFORM P8900-PRINT-REPORT  THRU P8900-EXIT            
ACT199           ADD +1                     TO WS-LINE-COUNT            
ACT199        END-IF                                                    
           END-IF.                                                      
      *                                                                 06360000
           INITIALIZE PRINT-LINE.                                       
      *                                                                 06380000
       P5000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 06410000
      ****************************************************************  06420000
      *  OPEN BASE_CSR                                               *  06430000
      ****************************************************************  06440000
      *                                                                 06450000
C36665 P7100-OPEN-BASE-CURSOR.                                          
      *                                                                 06470000
           EXEC SQL                                                     
              OPEN BASE_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06510000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 06530000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**    PCSRP445 PROCESSING ERROR       **'        
C36665        DISPLAY '**      ABEND IN PARAGRAPH P7100      **'        
              DISPLAY '**      OPENING BASE_CSR              **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                 06640000
C36665 P7100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 06670000
      ****************************************************************  06680000
      *  FETCH BASE_CSR                                              *  06690000
      ****************************************************************  06700000
      *                                                                 06710000
C36665 P7150-FETCH-BASE-CURSOR.                                         
      *                                                                 06730000
           EXEC SQL                                                     
             FETCH  BASE_CSR                                            
              INTO  :AT-ACCOUNT-NO                                      
ACT199             ,:AT-CUSTOMER-NO                                     
                   ,:UT-RATE-PLAN-NO                                    
C35744             ,:UT-CODE-STAT-TAX-XMT                               
                   ,:AT-CODE-ACCT-STAT                                  
C36665             ,:AT-ACCOUNT-TYPE-CODE                               
                   ,:AT-ACCT-XFER-TO                                    
                   ,:AT-AR-XFER-IND                                     
                   ,:AT-BILL-HIST-XFER-IND                              
P00453             ,:AT-CODES-DATA-PRESENT                              
                   ,:FI-OPTION-CD                                       
                   ,:FI-OPT-DESC-INT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06890000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 06910000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36665*    MOVE THE DATA TO WORKING STORAGE.                            06930000
C36665        MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO          
C36665        MOVE UT-RATE-PLAN-NO            TO WS-RATE-PLAN-NO        
C36665        MOVE AT-CODE-ACCT-STAT          TO WS-CODE-ACCT-STAT      
C36665        MOVE AT-ACCOUNT-TYPE-CODE       TO WS-ACCOUNT-TYPE-CODE   
C36665        MOVE AT-ACCT-XFER-TO            TO WS-ACCT-XFER-TO        
C36665        MOVE AT-AR-XFER-IND             TO WS-AR-XFER-IND         
C36665        MOVE AT-BILL-HIST-XFER-IND      TO WS-BILL-HIST-XFER-IND  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-NO-MORE-DATA                           
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**    PCSRP445 PROCESSING ERROR       **'     
C36665           DISPLAY '**      ABEND IN PARAGRAPH P7150      **'     
                 DISPLAY '**      FETCHING BASE_CSR             **'     
                 DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '****************************************'     
                 PERFORM P9900-ABEND THRU P9900-EXIT                    
             END-IF                                                     
           END-IF.                                                      
      *                                                                 07140000
C36665 P7150-EXIT.                                                      
           EXIT.                                                        
      *                                                                 07170000
      ****************************************************************  07180000
      *  CLOSE BASE_CSR                                              *  07190000
      ****************************************************************  07200000
      *                                                                 07210000
       P7200-CLOSE-BASE-CURSOR.                                         
      *                                                                 07230000
           EXEC SQL                                                     
               CLOSE BASE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07270000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 07290000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**    PCSRP445 PROCESSING ERROR       **'        
              DISPLAY '**      ABEND IN PARAGRAPH P7200      **'        
              DISPLAY '**      CLOSING BASE_CSR              **'        
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '****************************************'        
              PERFORM P9900-ABEND THRU P9900-EXIT                       
           END-IF.                                                      
      *                                                                 07410000
       P7200-EXIT.                                                      
           EXIT.                                                        
      *                                                                 07440000
ACT199****************************************************************  07450000
ACT199*  7290-GET-MULT-ACCTS.                                        *  07460000
ACT199*  CHECK CUSTOMER HAS MULTIPLE ACCOUNTS EXISTING.              *  07470000
ACT199****************************************************************  07480000
ACT199*                                                                 07490000
ACT199 7290-GET-MULT-ACCTS.                                             
ACT199*                                                                 07510000
ACT199     MOVE 'N' TO WS-MULT-ACCT.                                    
ACT199     EXEC SQL                                                     
ACT199        SELECT TOP(1) 'Y'                                                
ACT199         INTO :WS-MULT-ACCT                                       
ACT199         FROM CSS_ACCOUNT A1 WITH(READUNCOMMITTED)                        
ACT199       WHERE A1.CUSTOMER_NO          = :AT-CUSTOMER-NO            
ACT199         AND A1.CODE_ACCT_STAT       = 'A'                        
ACT199         AND A1.BILL_CYCLE           = :WS-BILL-CYCLE-OPEN        
ACT199         AND A1.ACCOUNT_NO NOT IN                                 
ACT199              (SELECT A2.ACCOUNT_NO                               
ACT199                 FROM CSS_ACCOUNT A2 WITH(READUNCOMMITTED)                
ACT199                WHERE A2.ACCOUNT_NO = :AT-ACCOUNT-NO  )           
ACT199                                       
ACT199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07520001
MFA-TR*       SELECT 'Y'                                                07530001
MFA-TR*        INTO :WS-MULT-ACCT                                       07540001
MFA-TR*        FROM CSS_ACCOUNT A1                                      07550001
MFA-TR*      WHERE A1.CUSTOMER_NO          = :AT-CUSTOMER-NO            07560001
MFA-TR*        AND A1.CODE_ACCT_STAT       = 'A'                        07570002
MFA-TR*        AND A1.BILL_CYCLE           = :WS-BILL-CYCLE-OPEN        07580001
MFA-TR*        AND A1.ACCOUNT_NO NOT IN                                 07590001
MFA-TR*             (SELECT A2.ACCOUNT_NO                               07600001
MFA-TR*                FROM CSS_ACCOUNT A2                              07610001
MFA-TR*               WHERE A2.ACCOUNT_NO = :AT-ACCOUNT-NO  )           07620001
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               07630001
MFA-TR*    END-EXEC.                                                    07631001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT199*                                                                 07640000
ACT199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT199*                                                                 07660000
ACT199     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT199        NEXT SENTENCE                                             
ACT199     ELSE                                                         
ACT199        DISPLAY '****************************************'        
ACT199        DISPLAY '**    PCSRP445 PROCESSING ERROR       **'        
ACT199        DISPLAY '**      ABEND IN PARAGRAPH 7290       **'        
ACT199        DISPLAY '**      SELECT MUTL ACCOUNTS          **'        
ACT199        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
ACT199        DISPLAY '****************************************'        
ACT199        PERFORM P9900-ABEND THRU P9900-EXIT                       
ACT199     END-IF.                                                      
ACT199*                                                                 07780000
ACT199 7290-EXIT.                                                       
ACT199     EXIT.                                                        
ACT199*                                                                 07810000
C36665 P7300-SELECT-OPTION-DESC.                                        
C36665*                                                                 07830000
C36665     EXEC SQL                                                     
C36665          SELECT TOP(1) FI.OPT_DESC_INT                                  
C36665            INTO :WS-SENIOR-OPTION-DESC                           
C36665            FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)               
C36665           WHERE FI.OPTION_CD   = :WS-SENIOR-OPTION-CD            
P00473             AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()            
P00473             AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()            
P00473             AND FI.PROC_STATUS_CD = 'AC'                         
T33971                                       
C36665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07840000
MFA-TR*         SELECT FI.OPT_DESC_INT                                  07850000
MFA-TR*           INTO :WS-SENIOR-OPTION-DESC                           07860000
MFA-TR*           FROM CRM_RT_PKG_OPTION FI                             07870000
MFA-TR*          WHERE FI.OPTION_CD   = :WS-SENIOR-OPTION-CD            07880000
MFA-TR*            AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP            07890000
MFA-TR*            AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP            07900000
MFA-TR*            AND FI.PROC_STATUS_CD = 'AC'                         07910000
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                           07920000
MFA-TR*    END-EXEC.                                                    07930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36665                                                                  
C36665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36665*                                                                 07960000
C36665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C36665        NEXT SENTENCE                                             
C36665     ELSE                                                         
C36665        DISPLAY '******************************************'      
C36665        DISPLAY '**    PCSRP445 PROCESSING ERROR         **'      
C36665        DISPLAY '**      ABEND IN PARAGRAPH P7300        **'      
C36665        DISPLAY '** ERROR IN SELECTING CRM_RT_PKG_OPTION **'      
C36665        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
C36665        DISPLAY '******************************************'      
C36665        PERFORM P9900-ABEND THRU P9900-EXIT                       
C36665     END-IF.                                                      
C36665*                                                                 08080000
C36665 P7300-EXIT.                                                      
C36665     EXIT.                                                        
C36665*                                                                 08110000
C36665****************************************************************  08120000
C36665*  OPEN AGL_SR_DISCOUNT                                        *  08130000
C36665****************************************************************  08140000
C36665*                                                                 08150000
C36665 P7400-OPEN-AGL-SR-DISCOUNT.                                      
C36665*                                                                 08170000
C36665     EXEC SQL                                                     
C36665        OPEN AGL_SR_DISCOUNT                                      
C36665     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36665*                                                                 08210000
C36665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36665*                                                                 08230000
C36665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36665        NEXT SENTENCE                                             
C36665     ELSE                                                         
C36665        DISPLAY '****************************************'        
C36665        DISPLAY '**    PCSRP445 PROCESSING ERROR       **'        
C36665        DISPLAY '**      ABEND IN PARAGRAPH P7400      **'        
C36665        DISPLAY '**      OPENING AGL_SR_DISCOUNT       **'        
C36665        DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
C36665        DISPLAY '****************************************'        
C36665     END-IF.                                                      
C36665*                                                                 08340000
C36665 P7400-EXIT.                                                      
C36665     EXIT.                                                        
C36665*                                                                 08370000
C36665****************************************************************  08380000
C36665*  FETCH AGL_SR_DISCOUNT                                       *  08390000
C36665****************************************************************  08400000
C36665*                                                                 08410000
C36665 P7500-FETCH-AGL-SR-DISCOUNT.                                     
C36665*                                                                 08430000
C36665     EXEC SQL                                                     
C36665       FETCH  AGL_SR_DISCOUNT                                     
C36665        INTO  :AT-ACCOUNT-NO                                      
ACT199             ,:AT-CUSTOMER-NO                                     
C36665             ,:UT-RATE-PLAN-NO                                    
C35744             ,:UT-CODE-STAT-TAX-XMT                               
C36665             ,:AT-CODE-ACCT-STAT                                  
C36665             ,:AT-ACCOUNT-TYPE-CODE                               
C36665             ,:AT-ACCT-XFER-TO                                    
C36665             ,:AT-AR-XFER-IND                                     
C36665             ,:AT-BILL-HIST-XFER-IND                              
P00453             ,:AT-CODES-DATA-PRESENT                              
C36665             ,:FI-OPTION-CD                                       
C36665             ,:FI-OPT-DESC-INT                                    
C36665     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
C36665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 08610000
C36665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36665        CONTINUE                                                  
C36665     ELSE                                                         
T33971        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T33971           MOVE WS-Y TO WS-NO-MORE-DATA                           
C36665        ELSE                                                      
C36665           DISPLAY '****************************************'     
C36665           DISPLAY '**    PCSRP445 PROCESSING ERROR       **'     
C36665           DISPLAY '**      ABEND IN PARAGRAPH P7500      **'     
C36665           DISPLAY '**      FETCHING AGL_SR_DISCOUNT      **'     
C36665           DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C36665           DISPLAY '****************************************'     
C36665           PERFORM P9900-ABEND THRU P9900-EXIT                    
T33971        END-IF                                                    
C36665     END-IF.                                                      
      *                                                                 08770000
C36665 P7500-EXIT.                                                      
C36665     EXIT.                                                        
C36665*                                                                 08800000
C36665****************************************************************  08810000
C36665*  CLOSE AGL_SR_DISCOUNT                                       *  08820000
C36665****************************************************************  08830000
C36665*                                                                 08840000
C36665 P7600-CLOSE-AGL-SR-DISCOUNT.                                     
C36665*                                                                 08860000
C36665     EXEC SQL                                                     
C36665         CLOSE AGL_SR_DISCOUNT                                    
C36665     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36665*                                                                 08900000
C36665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36665*                                                                 08920000
C36665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C36665        NEXT SENTENCE                                             
C36665     ELSE                                                         
C36665        DISPLAY '****************************************'        
C36665        DISPLAY '**    PCSRP445 PROCESSING ERROR       **'        
C36665        DISPLAY '**      ABEND IN PARAGRAPH P7600      **'        
C36665        DISPLAY '**      CLOSING AGL_SR_DISCOUNT       **'        
C36665        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
C36665        DISPLAY '****************************************'        
C36665        PERFORM P9900-ABEND THRU P9900-EXIT                       
C36665     END-IF.                                                      
C36665*                                                                 09040000
C36665 P7600-EXIT.                                                      
C36665     EXIT.                                                        
C36665*                                                                 09070000
      ******************************************************************09080000
      **       WRITES THE HEADER TO THE REPORT FILE                   **09090000
      ******************************************************************09100000
      *                                                                 09110000
       P8200-PRINT-HEADERS.                                             
      *                                                                 09130000
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                 09160000
           MOVE HEADER1 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09190000
           MOVE HEADER2 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09220000
           MOVE HEADER3 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09250000
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09280000
           MOVE HEADER4 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09310000
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 09340000
           MOVE +6 TO WS-LINE-COUNT.                                    
      *                                                                 09360000
       P8200-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09390000
      ****************************************************************  09400000
      *  WRITE PRINT LINE                                            *  09410000
      ****************************************************************  09420000
      *                                                                 09430000
       P8900-PRINT-REPORT.                                              
      *                                                                 09450000
           WRITE PRT33-RECORD.                                          
      *                                                                 09470000
       P8900-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09500000
      ****************************************************************  09510000
      *  CLOSE FILES - NORMAL JOB COMPLETION                         *  09520000
      ****************************************************************  09530000
      *                                                                 09540000
       P9000-CLOSE-FILES.                                               
      *                                                                 09560000
           CLOSE FCSPT33-FILE.                                          
      *                                                                 09580000
           MOVE ZERO TO RETURN-CODE.                                    
      *                                                                 09600000
       P9000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09630000
      ****************************************************************  09640000
      *  P9900-ABEND                                                 *  09650000
      ****************************************************************  09660000
      *                                                                 09670000
       P9900-ABEND.                                                     
      *                                                                 09690000
           PERFORM P9000-CLOSE-FILES THRU P9000-EXIT                    
      *                                                                 09710000
           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                 09740000
       P9900-EXIT.                                                      
           EXIT.                                                        
