       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP444                                             
       DATE-WRITTEN.   10 NOVEMBER 2006.                                
       DATE-COMPILED.                                                   
      ****************************************************************  00050000
      ****************************************************************  00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                **  00070000
      **              COMPLETE BUSINESS SOLUTIONS INC.              **  00080000
      **                                                            **  00090000
      ********            CUSTOMER SERVICE SYSTEM             ********  00100000
      ********                      DB2                       ********  00110000
      ****************************************************************  00120000
      **                                                            **  00130000
      **            PROGRAM    MODIFICATION  LOG                    **  00140000
      **    DATE    INITIALS     REASON                             **  00150000
      **    ____    ________     ______                             **  00160000
      **                                                            **  00170000
      **  10 NOV 2006 RDF     PROGRAM WRITTEN                       **  00180000
      **                                                            **  00190000
T36675**   3 JUN 2008 RDF     CHANGED CURSOR TO A UNION TO ALLOW    **  00200000
      **                      FOR MORE EFFICIENCY.  PUT IN UR.      **  00210000
      **                      REMOVED GAS_BASE_USE FROM THE ORDER   **  00220000
      **                      BY CLAUSE.                            **  00230000
      **                      CODE CHANGE DUE TO NEW DATA SHARING.  **  00240000
      **                                                            **  00250000
A00633**   5 FEB 2009 RF10596 DO NOT ABEND ON AN OFF CYCLE.  PUT    **  00260000
      **                      MESSAGE TO PRINTED REPORT.            **  00270000
P00411**                                                            **  00280000
P00411**  19 JUL 2010 VY95550 ADDED ELECTRIC WNA GROUP NO           **  00290000
PRJ411**  04 AUG 2010 VY95550 ADDED REPORT FOR EWNA GROUP NO        **  00300000
ACT004** 01/10/14  DB41297       REMOVE WNA CODE.                    *  00310000
ACT004**  A04880                                                     *  00320000
ACT199** 04/10/15  SS7F226    REMOVE WRITING CUSTOMERS IN OUTPUT     *  00330000
ACT199**  A05136              WHO HAS MULTIPLE ACCOUNTS.             *  00340000
ACT199** 02/29/16  BD09555    ADDTIONAL SQL CHANGE FOR MULTIPLE      *  00341000
ACT199**  A05136              ACCOUNTS                               *  00342000
      ****************************************************************  00350000
           REMARKS.  CREATE A REPORT OF ACCOUNTS FOR SAMPLE BILLING.    
                              PCSRP444 NARRATIVE                        
            READS CSS_ACCOUNT AND CSS_UTIL_ENVRNMT FOR ACCOUNTS         
            TO RUN THROUGH SAMPLE BILLING.  PUTS OUT A MAXIMUM OF       
            35 ACCOUNTS PER RATE FOR THE REPORT, BUT THE TOTALS         
            ARE ALL FOR THAT RATE.  WE ARE BYPASSING ACCOUNTS WHERE     
            AT-AR-XFER-IND = 'Y' AND AT-BILL-HIST-XFER-IND = 'Y'        
            AND AT-ACCT-XFER-TO > 0.                                    
      *                                                                 00440000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00460000
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00480000
       FILE-CONTROL.                                                    
      *                                                                 00500000
       COPY CSSPT33.                                                    00510000
      *                                                                 00520000
       DATA DIVISION.                                                   
      *                                                                 00540000
       FILE SECTION.                                                    
      *                                                                 00560000
       COPY CFDPT33.                                                    00570000
      *                                                                 00580000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP444'.
MSQ017     COPY MFASQLM.
      *                                                                 00600000
A00633 01 WS-NULL               PIC S9(4) COMP VALUE 0.                 
A00633 01 WS-OFF-CYCLE          PIC X VALUE 'N'.                        
      *                                                                 00630000
       01 WS-Y               PIC X VALUE 'Y'.                           
ACT199 01 WS-MULT-ACCT       PIC X(1).                                  
       01 WS-HONK-ONE        PIC X VALUE 'Y'.                           
       01 WS-HONK-SEQ        PIC S9(11) COMP-3 VALUE +90000.            
       01 WS-RATE-COUNT      PIC S9(9)  COMP-3 VALUE 0.                 
       01 WS-LINE-COUNT      PIC S9(3)  COMP-3 VALUE +70.               
       01 WS-PAGE-COUNT      PIC S9(3)  COMP-3 VALUE ZEROS.             
       01 WS-NO-MORE-DATA    PIC X   VALUE 'N'.                         
       01 WS-COMPANY-NO      PIC XX  VALUE '01'.                        
       01 WS-PREV-RATE       PIC XXX VALUE SPACES.                      
      *                                                                 00740000
       01 WS-BILL-CYCLE-OPEN PIC XX    VALUE SPACES.                    
       01 WS-CURRENT-DATE    PIC X(10) VALUE SPACES.                    
       01 WS-CURR-DATE       PIC X(10) VALUE SPACES.                    
      *                                                                 00780000
       01 HEADER1.                                                      
          05 FILLER             PIC X(22)                               
             VALUE '1PROGRAM ID : PCSRP444'.                            
          05 FILLER             PIC X(28) VALUE SPACES.                 
          05 FILLER             PIC X(31)                               
             VALUE 'SOUTH CAROLINA ELECTRIC AND GAS'.                   
          05 FILLER             PIC X(36) VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'PAGE = '.              
          05 HDR-PAGE           PIC ZZ9.                                
          05 FILLER             PIC X(6)  VALUE SPACES.                 
      *                                                                 00890000
       01 HEADER2.                                                      
          05 FILLER             PIC X(16) VALUE ' BILL CYCLE :   '.     
          05 HDR-BILL-CYCLE     PIC XX.                                 
          05 FILLER             PIC X(91) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN DATE:  '.          
          05 HDR-DATE           PIC X(10) VALUE SPACES.                 
          05 FILLER             PIC XXX   VALUE SPACES.                 
      *                                                                 00970000
       01 HEADER3.                                                      
          05 FILLER             PIC X(15)  VALUE ' RATE      :   '.     
          05 HDR-RATE           PIC X(3).                               
          05 FILLER             PIC X(115) VALUE SPACES.                
      *                                                                 01020000
       01 HEADER4.                                                      
          05 FILLER             PIC X(15)  VALUE '0ACCOUNT NUMBER'.     
          05 FILLER             PIC X(2)   VALUE SPACES.                
          05 FILLER             PIC X(14)  VALUE 'ACCOUNT STATUS'.      
          05 FILLER             PIC X(3)   VALUE SPACES.                
          05 FILLER             PIC X(12)  VALUE 'GAS BASE USE'.        
          05 FILLER             PIC X(87)  VALUE SPACES.                
      *                                                                 01100000
       01 PRINT-LINE.                                                   
          05 FILLER             PIC XX.                                 
          05 PRT-ACCT-NBR       PIC X(13).                              
          05 FILLER             PIC X(9).                               
          05 PRT-STATUS         PIC X.                                  
          05 FILLER             PIC X(8).                               
          05 PRT-GAS-BASE-USE   PIC ZZZZZZZZZ9.                         
          05 FILLER             PIC X(90).                              
      *                                                                 01190000
       01 PRINT-TOTAL.                                                  
          05 FILLER             PIC X(34)                               
             VALUE 'TOTAL NUMBER OF ACCOUNTS FOR RATE '.                
          05 PRT-RATE           PIC X(3).                               
          05 FILLER             PIC X(4)  VALUE ' IS '.                 
          05 PRT-RATE-TOTAL     PIC 9(11) VALUE ZEROS.                  
          05 FILLER             PIC X(81) VALUE SPACES.                 
      *                                                                 01270000
A00633 01 PRINT-OFF-CYCLE.                                              
A00633    05 FILLER             PIC X(45) VALUE SPACES.                 
A00633    05 FILLER             PIC X(42)                               
A00633      VALUE 'TODAY IS AN OFF CYCLE - NO DATA TO PROCESS'.         
A00633    05 FILLER             PIC X(46) VALUE SPACES.                 
PRJ411*                                                                 01330000
      *********************                                             01340000
      **  ABEND COPYBOOK **                                             01350000
      *********************                                             01360000
      *                                                                 01370000
       COPY CWS09900.                                                   01380000
      *                                                                 01390000
      ****************************************************              01400000
      ** COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND **              01410000
      ****************************************************              01420000
      *                                                                 01430000
       COPY CWS00303.                                                   01440000
      *                                                                 01450000
      ****************************************************************  01460000
      **            TABLE DEFINITIONS AND DB2 INTERACTIONS          **  01470000
      ****************************************************************  01480000
      *                                                                 01490000
           EXEC SQL                                                     01500000
             INCLUDE SQLCA                                              01510000
           END-EXEC.                                                    01520000
      *                                                                 01530000
      ********************                                              01540000
      **  CSS_JOB_PARM  **                                              01550000
      ********************                                              01560000
      *                                                                 01570000
           EXEC SQL                                                     01580000
             INCLUDE TBJBPARM                                           01590000
           END-EXEC.                                                    01600000
P00411*                                                                 01610000
      **********************                                            01620000
      **  CSS_UTIL_ENVRNMT**                                            01630000
      **********************                                            01640000
      *                                                                 01650000
           EXEC SQL                                                     01660000
             INCLUDE TBUTLENV                                           01670000
           END-EXEC.                                                    01680000
      *                                                                 01690000
      *******************                                               01700000
      **  CSS_ACCOUNT  **                                               01710000
      *******************                                               01720000
      *                                                                 01730000
           EXEC SQL                                                     01740000
             INCLUDE TBACCT                                             01750000
           END-EXEC.                                                    01760000
      *                                                                 01770000
      ********************************************                      01780000
      **  CURSOR DECLARATION -- BASE_CSR        **                      01790000
      ********************************************                      01800000
      *                                                                 01810000
           EXEC SQL                                                     
T36675      DECLARE BASE_CSR CURSOR WITH HOLD FOR                       
             SELECT AT.ACCOUNT_NO                                       
ACT199             ,AT.CUSTOMER_NO                                      
                   ,UT.RATE_PLAN_NO                                     
                   ,AT.CODE_ACCT_STAT                                   
                   ,UT.GAS_BASE_USE                                     
                   ,AT.ACCT_XFER_TO                                     
                   ,AT.AR_XFER_IND                                      
                   ,AT.BILL_HIST_XFER_IND                               
               FROM  CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                 
                    ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
              WHERE AT.ACCOUNT_NO       = UT.ACCOUNT_NO                 
              AND   AT.CODE_ACCT_STAT   = 'A'                           
              AND   AT.CODE_ACCT_BILLED = 'R'                           
              AND   AT.BILL_CYCLE       = :WS-BILL-CYCLE-OPEN           
T36675        UNION                                                     
T36675       SELECT AT.ACCOUNT_NO                                       
ACT199             ,AT.CUSTOMER_NO                                      
T36675             ,UT.RATE_PLAN_NO                                     
T36675             ,AT.CODE_ACCT_STAT                                   
T36675             ,UT.GAS_BASE_USE                                     
T36675             ,AT.ACCT_XFER_TO                                     
T36675             ,AT.AR_XFER_IND                                      
T36675             ,AT.BILL_HIST_XFER_IND                               
T36675         FROM  CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                 
T36675              ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
T36675              ,CSS_OFF_CYCL_ACCT OC WITH(READUNCOMMITTED)                 
T36675        WHERE OC.ACCOUNT_NO     = AT.ACCOUNT_NO                   
T36675          AND OC.ACCOUNT_NO     = UT.ACCOUNT_NO                   
T36675          AND AT.CODE_ACCT_STAT = 'B'                             
ACT199        ORDER BY 3, 1                                             
T36675        FOR READ ONLY                                     
PRJ411     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01820000
MFA-TR*     DECLARE BASE_CSR CURSOR WITH HOLD FOR                       01830000
MFA-TR*      SELECT AT.ACCOUNT_NO                                       01840000
MFA-TR*            ,AT.CUSTOMER_NO                                      01850000
MFA-TR*            ,UT.RATE_PLAN_NO                                     01860000
MFA-TR*            ,AT.CODE_ACCT_STAT                                   01870000
MFA-TR*            ,UT.GAS_BASE_USE                                     01880000
MFA-TR*            ,AT.ACCT_XFER_TO                                     01890000
MFA-TR*            ,AT.AR_XFER_IND                                      01900000
MFA-TR*            ,AT.BILL_HIST_XFER_IND                               01910000
MFA-TR*        FROM  CSS_ACCOUNT       AT                               01920000
MFA-TR*             ,CSS_UTIL_ENVRNMT  UT                               01930000
MFA-TR*       WHERE AT.ACCOUNT_NO       = UT.ACCOUNT_NO                 01940000
MFA-TR*       AND   AT.CODE_ACCT_STAT   = 'A'                           01950000
MFA-TR*       AND   AT.CODE_ACCT_BILLED = 'R'                           01960000
MFA-TR*       AND   AT.BILL_CYCLE       = :WS-BILL-CYCLE-OPEN           01970000
MFA-TR*       UNION                                                     01980000
MFA-TR*      SELECT AT.ACCOUNT_NO                                       01990000
MFA-TR*            ,AT.CUSTOMER_NO                                      02000000
MFA-TR*            ,UT.RATE_PLAN_NO                                     02010000
MFA-TR*            ,AT.CODE_ACCT_STAT                                   02020000
MFA-TR*            ,UT.GAS_BASE_USE                                     02030000
MFA-TR*            ,AT.ACCT_XFER_TO                                     02040000
MFA-TR*            ,AT.AR_XFER_IND                                      02050000
MFA-TR*            ,AT.BILL_HIST_XFER_IND                               02060000
MFA-TR*        FROM  CSS_ACCOUNT       AT                               02070000
MFA-TR*             ,CSS_UTIL_ENVRNMT  UT                               02080000
MFA-TR*             ,CSS_OFF_CYCL_ACCT OC                               02090000
MFA-TR*       WHERE OC.ACCOUNT_NO     = AT.ACCOUNT_NO                   02100000
MFA-TR*         AND OC.ACCOUNT_NO     = UT.ACCOUNT_NO                   02110000
MFA-TR*         AND AT.CODE_ACCT_STAT = 'B'                             02120000
MFA-TR*       ORDER BY 3, 1                                             02130000
MFA-TR*       FOR FETCH ONLY WITH UR                                    02140000
MFA-TR*    END-EXEC.                                                    02150000
      *                                                                 02160000
       PROCEDURE DIVISION.                                              
      *                                                                 02180000
           PERFORM P0100-INITIALIZATION THRU P0100-EXIT.                
      *                                                                 02200000
A00633     IF WS-OFF-CYCLE = 'N'                                        
              PERFORM P1000-PROCESS-CORR THRU P1000-EXIT                
                  UNTIL WS-NO-MORE-DATA = WS-Y                          
              PERFORM P4000-RATE-TOTAL THRU P4000-EXIT                  
A00633     END-IF.                                                      
      *                                                                 02260000
           PERFORM P9000-CLOSE-FILES THRU P9000-EXIT.                   
      *                                                                 02280000
           STOP RUN.                                                    
      *                                                                 02300000
      ****************************************************************  02310000
      *  OPEN FILES - GET REPORT DATE FROM DATABASE                  *  02320000
      ****************************************************************  02330000
      *                                                                 02340000
       P0100-INITIALIZATION.                                            
      *                                                                 02360000
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                 02380000
           EXEC SQL                                                     
               SELECT TOP(1) CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')           
                 INTO :WS-CURRENT-DATE                                  
                     ,:WS-CURR-DATE                                     
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
T36675                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02390000
MFA-TR*        SELECT CURRENT DATE                                      02400000
MFA-TR*              ,CHAR(CURRENT DATE,USA)                            02410000
MFA-TR*          INTO :WS-CURRENT-DATE                                  02420000
MFA-TR*              ,:WS-CURR-DATE                                     02430000
MFA-TR*          FROM CSS_JOB_PARM                                      02440000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             02450000
MFA-TR*    END-EXEC.                                                    02460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02470000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 02490000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP444 ABORT****************'       
              DISPLAY '* P0100-INITIALIZATION - CURRENT DATE   *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSRP444 ABORT****************'       
              PERFORM P9900-ABEND THRU P9900-EXIT                       
           END-IF.                                                      
      *                                                                 02600000
A00633     MOVE WS-CURRENT-DATE TO HDR-DATE.                            
      *                                                                 02620000
A00633     EXEC SQL                                                     
A00633         SELECT TOP(1) BILL_CYCLE                                        
A00633         INTO :WS-BILL-CYCLE-OPEN                                 
A00633         FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
A00633         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
A00633           AND CODE_BILL_COND = 'R'                               
A00633           AND BILL_CYCLE     <> '21'                             
A00633         ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC             
A00633                                       
A00633     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02630000
MFA-TR*        SELECT BILL_CYCLE                                        02640000
MFA-TR*        INTO :WS-BILL-CYCLE-OPEN                                 02650000
MFA-TR*        FROM  CSS_BILL_WINDOW                                    02660000
MFA-TR*        WHERE DATE_EXTRACT = :WS-CURRENT-DATE                    02670000
MFA-TR*          AND CODE_BILL_COND = 'R'                               02680000
MFA-TR*          AND BILL_CYCLE     <> '21'                             02690000
MFA-TR*        ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC             02700000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             02710000
MFA-TR*    END-EXEC.                                                    02720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02730000
           DISPLAY 'BILL-CYCLE-OPEN = ' WS-BILL-CYCLE-OPEN.             
      *                                                                 02750000
           MOVE WS-BILL-CYCLE-OPEN TO HDR-BILL-CYCLE.                   
      *                                                                 02770000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00633     INITIALIZE PRINT-LINE.                                       
      *                                                                 02800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00633        CONTINUE                                                  
A00633     ELSE                                                         
A00633        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00633           PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT            
A00633           MOVE PRINT-OFF-CYCLE TO PRT33-RECORD                   
A00633           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT             
A00633           MOVE WS-Y TO WS-OFF-CYCLE                              
A00633        ELSE                                                      
A00633           DISPLAY '********** PCSRP444 ABORT****************'    
A00633           DISPLAY '* P0100-INITIALIZATION - MAX BILL CYCLE *'    
A00633           DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
A00633           DISPLAY '* PROGRAM ABORTING...                   *'    
A00633           DISPLAY '********** PCSRP444 ABORT****************'    
A00633           PERFORM P9900-ABEND THRU P9900-EXIT                    
A00633        END-IF                                                    
           END-IF.                                                      
      *                                                                 02980000
       P0100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 03010000
      ****************************************************************  03020000
      *  MAIN FLOW OF PROGRAM                                        *  03030000
      ****************************************************************  03040000
      *                                                                 03050000
       P1000-PROCESS-CORR.                                              
      *                                                                 03070000
           PERFORM P7000-OPEN-BASE-CURSOR THRU P7000-EXIT.              
           PERFORM P7100-FETCH-BASE-CURSOR THRU P7100-EXIT.             
           PERFORM P1100-PROCESS-DATA THRU P1100-EXIT                   
                 UNTIL WS-NO-MORE-DATA = WS-Y.                          
           PERFORM P7200-CLOSE-BASE-CURSOR THRU P7200-EXIT.             
      *                                                                 03130000
       P1000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 03160000
      ****************************************************************  03170000
      *  MAIN LOOP - PROCESS UNTIL NO MORE DATA                      *  03180000
      ****************************************************************  03190000
      *                                                                 03200000
       P1100-PROCESS-DATA.                                              
      *                                                                 03220000
           IF WS-HONK-ONE = 'Y'                                         
              MOVE UT-RATE-PLAN-NO TO WS-PREV-RATE                      
                                      HDR-RATE                          
              MOVE 'N' TO WS-HONK-ONE                                   
           END-IF.                                                      
      *                                                                 03280000
           IF WS-PREV-RATE = UT-RATE-PLAN-NO                            
              IF WS-RATE-COUNT > 020                                    
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM P5000-FORMAT-REPORT THRU P5000-EXIT            
              END-IF                                                    
           ELSE                                                         
              PERFORM P4000-RATE-TOTAL THRU P4000-EXIT                  
      *                                                                 03380000
              MOVE +65 TO WS-LINE-COUNT                                 
              MOVE UT-RATE-PLAN-NO TO WS-PREV-RATE                      
                                      HDR-RATE                          
      *                                                                 03420000
              PERFORM P5000-FORMAT-REPORT THRU P5000-EXIT               
ACT199        MOVE 1                     TO WS-RATE-COUNT               
           END-IF.                                                      
      *                                                                 03460000
           PERFORM P7100-FETCH-BASE-CURSOR THRU P7100-EXIT.             
      *                                                                 03480000
       P1100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 03510000
      ****************************************************************  03520000
      *  PRINT TOTAL NUMBER OF ACCOUNTS FAR A RATE                   *  03530000
      ****************************************************************  03540000
      *                                                                 03550000
       P4000-RATE-TOTAL.                                                
      *                                                                 03570000
           MOVE WS-RATE-COUNT TO PRT-RATE-TOTAL.                        
           MOVE WS-PREV-RATE  TO PRT-RATE.                              
      *                                                                 03600000
           IF WS-LINE-COUNT > 57                                        
              PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT               
           END-IF.                                                      
      *                                                                 03640000
           MOVE PRINT-TOTAL TO PRT33-RECORD.                            
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                 03680000
           INITIALIZE PRINT-LINE.                                       
      *                                                                 03700000
       P4000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 03730000
      ****************************************************************  03740000
      *  PRINT REPORT OF CHANGES AND ERRORS                          *  03750000
      ****************************************************************  03760000
      *                                                                 03770000
       P5000-FORMAT-REPORT.                                             
      *                                                                 03790000
           IF AT-AR-XFER-IND NOT = 'Y'                                  
              AND AT-BILL-HIST-XFER-IND NOT = 'Y'                       
              AND AT-ACCT-XFER-TO = 0                                   
      *                                                                 03830000
              MOVE AT-ACCOUNT-NO     TO PRT-ACCT-NBR                    
              MOVE UT-GAS-BASE-USE   TO PRT-GAS-BASE-USE                
              MOVE AT-CODE-ACCT-STAT TO PRT-STATUS                      
      *                                                                 03870000
              IF WS-LINE-COUNT > 57                                     
                 PERFORM P8200-PRINT-HEADERS THRU P8200-EXIT            
              END-IF                                                    
      *                                                                 03910000
ACT199        PERFORM 7290-GET-MULT-ACCTS    THRU 7290-EXIT             
ACT199        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT199           MOVE PRINT-LINE            TO PRT33-RECORD             
ACT199           PERFORM P8900-PRINT-REPORT  THRU P8900-EXIT            
ACT199           ADD +1                     TO WS-LINE-COUNT            
ACTXXX        ADD +1 TO WS-RATE-COUNT                                   
ACT199        END-IF                                                    
           END-IF.                                                      
      *                                                                 03990000
           INITIALIZE PRINT-LINE.                                       
      *                                                                 04010000
       P5000-EXIT.                                                      
           EXIT.                                                        
PRJ411*                                                                 04040000
PRJ411****************************************************************  04050000
      *  OPEN BASE_CSR                                               *  04060000
      ****************************************************************  04070000
      *                                                                 04080000
       P7000-OPEN-BASE-CURSOR.                                          
      *                                                                 04100000
           EXEC SQL                                                     
              OPEN BASE_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04140000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04160000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**    PCSRP444 PROCESSING ERROR       **'        
              DISPLAY '**      ABEND IN PARAGRAPH P7000      **'        
              DISPLAY '**      OPENING BASE_CSR              **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                 04270000
       P7000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04300000
      ****************************************************************  04310000
      *  FETCH BASE_CSR                                              *  04320000
      ****************************************************************  04330000
      *                                                                 04340000
       P7100-FETCH-BASE-CURSOR.                                         
      *                                                                 04360000
           EXEC SQL                                                     
             FETCH  BASE_CSR                                            
              INTO  :AT-ACCOUNT-NO                                      
ACT199             ,:AT-CUSTOMER-NO                                     
                   ,:UT-RATE-PLAN-NO                                    
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:UT-GAS-BASE-USE                                    
                   ,:AT-ACCT-XFER-TO                                    
                   ,:AT-AR-XFER-IND                                     
                   ,:AT-BILL-HIST-XFER-IND                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

*                                                                       
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
*                                                                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-NO-MORE-DATA                           
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**    PCSRP444 PROCESSING ERROR       **'     
                 DISPLAY '**      ABEND IN PARAGRAPH P7100      **'     
                 DISPLAY '**      FETCHING BASE_CSR             **'     
                 DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '****************************************'     
                 PERFORM P9900-ABEND THRU P9900-EXIT                    
             END-IF                                                     
           END-IF.                                                      
      *                                                                 04660000
       P7100-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04690000
      ****************************************************************  04700000
      *  CLOSE BASE_CSR                                              *  04710000
      ****************************************************************  04720000
      *                                                                 04730000
       P7200-CLOSE-BASE-CURSOR.                                         
      *                                                                 04750000
           EXEC SQL                                                     
               CLOSE BASE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04790000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04810000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**    PCSRP444 PROCESSING ERROR       **'        
              DISPLAY '**      ABEND IN PARAGRAPH P7200      **'        
              DISPLAY '**      CLOSING BASE_CSR              **'        
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '****************************************'        
              PERFORM P9900-ABEND THRU P9900-EXIT                       
           END-IF.                                                      
      *                                                                 04930000
       P7200-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04960000
ACT199****************************************************************  04970000
ACT199*  7290-GET-MULT-ACCTS.                                        *  04980000
ACT199*  CHECK CUSTOMER HAS MULTIPLE ACCOUNTS EXISTING.              *  04990000
ACT199****************************************************************  05000000
ACT199*                                                                 05010000
ACT199 7290-GET-MULT-ACCTS.                                             
ACT199*                                                                 05030000
ACT199     MOVE 'N' TO WS-MULT-ACCT.                                    
ACT199     EXEC SQL                                                     
ACT199        SELECT TOP(1) 'Y'                                                
ACT199         INTO :WS-MULT-ACCT                                       
ACT199         FROM CSS_ACCOUNT A1 WITH(READUNCOMMITTED)                        
ACT199       WHERE A1.CUSTOMER_NO          = :AT-CUSTOMER-NO            
ACT199         AND A1.CODE_ACCT_STAT       = 'A'                        
ACT199         AND A1.BILL_CYCLE           = :WS-BILL-CYCLE-OPEN        
ACT199         AND A1.ACCOUNT_NO NOT IN                                 
ACT199              (SELECT A2.ACCOUNT_NO                               
ACT199                 FROM CSS_ACCOUNT A2 WITH(READUNCOMMITTED)                
ACT199                WHERE A2.ACCOUNT_NO = :AT-ACCOUNT-NO  )           
ACT199                                       
ACT199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05031002
MFA-TR*       SELECT 'Y'                                                05040002
MFA-TR*        INTO :WS-MULT-ACCT                                       05050002
MFA-TR*        FROM CSS_ACCOUNT A1                                      05060002
MFA-TR*      WHERE A1.CUSTOMER_NO          = :AT-CUSTOMER-NO            05070002
MFA-TR*        AND A1.CODE_ACCT_STAT       = 'A'                        05080003
MFA-TR*        AND A1.BILL_CYCLE           = :WS-BILL-CYCLE-OPEN        05090002
MFA-TR*        AND A1.ACCOUNT_NO NOT IN                                 05100002
MFA-TR*             (SELECT A2.ACCOUNT_NO                               05110002
MFA-TR*                FROM CSS_ACCOUNT A2                              05120002
MFA-TR*               WHERE A2.ACCOUNT_NO = :AT-ACCOUNT-NO  )           05130002
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               05140002
MFA-TR*    END-EXEC.                                                    05150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT199*                                                                 05160000
ACT199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT199*                                                                 05180000
ACT199     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT199        NEXT SENTENCE                                             
ACT199     ELSE                                                         
ACT199        DISPLAY '****************************************'        
ACT199        DISPLAY '**    PCSRP444 PROCESSING ERROR       **'        
ACT199        DISPLAY '**      ABEND IN PARAGRAPH 7290       **'        
ACT199        DISPLAY '**      SELECT MUTL ACCOUNTS          **'        
ACT199        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
ACT199        DISPLAY '****************************************'        
ACT199        PERFORM P9900-ABEND THRU P9900-EXIT                       
ACT199     END-IF.                                                      
ACT199*                                                                 05300000
ACT199 7290-EXIT.                                                       
ACT199     EXIT.                                                        
ACT199*                                                                 05330000
      ******************************************************************05340000
      **       WRITES THE HEADER TO THE REPORT FILE                   **05350000
      ******************************************************************05360000
      *                                                                 05370000
       P8200-PRINT-HEADERS.                                             
      *                                                                 05390000
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                 05420000
           MOVE HEADER1 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05450000
           MOVE HEADER2 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05480000
           MOVE HEADER3 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05510000
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05540000
           MOVE HEADER4 TO PRT33-RECORD.                                
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05570000
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM P8900-PRINT-REPORT THRU P8900-EXIT.                  
      *                                                                 05600000
           MOVE +6 TO WS-LINE-COUNT.                                    
      *                                                                 05620000
       P8200-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05650000
      ****************************************************************  05660000
      *  WRITE PRINT LINE                                            *  05670000
      ****************************************************************  05680000
      *                                                                 05690000
       P8900-PRINT-REPORT.                                              
      *                                                                 05710000
           WRITE PRT33-RECORD.                                          
      *                                                                 05730000
       P8900-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05760000
      ****************************************************************  05770000
      *  CLOSE FILES - NORMAL JOB COMPLETION                         *  05780000
      ****************************************************************  05790000
      *                                                                 05800000
       P9000-CLOSE-FILES.                                               
      *                                                                 05820000
           CLOSE FCSPT33-FILE.                                          
      *                                                                 05840000
           MOVE ZERO TO RETURN-CODE.                                    
      *                                                                 05860000
       P9000-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05890000
      ****************************************************************  05900000
      *  P9900-ABEND                                                 *  05910000
      ****************************************************************  05920000
      *                                                                 05930000
       P9900-ABEND.                                                     
      *                                                                 05950000
           PERFORM P9000-CLOSE-FILES THRU P9000-EXIT                    
      *                                                                 05970000
           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                 06000000
       P9900-EXIT.                                                      
           EXIT.                                                        
