       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP440.                                        
       DATE-WRITTEN.                                                    
       DATE-COMPILED.                                                   
      *****************************************************************         
      *              M O D U L E   I N F O R M A T I O N              *         
      *                                                               *         
      *  MODULE NAME:  PCSRP440                                       *         
      *                                                               *         
      *  MODULE DESC:  CREATES REPORTS FOR SCEG AND PSNC              *         
      *                1) LARGE CUSTOMER AND COMMMERCIAL CUSTOMER     *         
      *                   LOSS RESERVE REPORTS                        *         
      *  LANGUAGE   :  COBOL II / DB2                                 *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
      *               M A I N T E N A N C E   L O G                   *         
      *                                                               *         
      *  TPR   |PROGRAMMER|            |                              *         
      * NUMBER | USER-ID  |    DATE    |         DESCRIPTION          *         
      *---------------------------------------------------------------*         
      *        |          |            |                              *         
      * 29399  | SS19371  | 02/17/2004 | INITIAL CODING               *         
      *        |          |            |                              *         
      *---------------------------------------------------------------*         
      *        |          |            |                              *         
      * 35434  | MK92804  | 05/19/2007 | REPLACED MODEL_SQL WITH SET  *         
      *        |          |            | STATEMENT AND ADDED WITH UR  *         
      *        |          |            | FOR AVOIDING -911 ABENDS.    *         
      *        |          |            |                              *         
      *---------------------------------------------------------------*         
      *        |          |            |                              *         
      * A04110 | NS75440  | 05/07/2012 | ADD RISK RATING DATE TO THE  *         
      *        |          |            | REPORT.                      *         
      *        |          |            |                              *         
      *****************************************************************         
      *                   M O D U L E   F L O W                       *         
      *                                                               *         
      *   PARAGRAPH                                                   *         
      *  FROM - THRU     DESCRIPTION                                  *         
      *  -----------------------------------------------------------  *         
      *  0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION         *         
      *  1000 - 2999     MAJOR PROCESSING LOOP                        *         
      *  3000 - 3999     COMMON PROCESSING                            *         
      *  4000 - 4999     NAME/ADDRESS PROCESSING                      *         
      *  5000 - 5999     OUTPUT TO FILES / REPORTS                    *         
      *  6000 - 6999     REDUCE EMBEDDED SPACES PROCESSING            *         
      *  7000 - 7999     INQUIRY CALLS TO INPUT FILES / DATABASE      *         
      *  8000 - 8999     UPDATE CALLS TO DATABASE                     *         
      *  9000 - 9999     TERMINATION ROUTINES                         *         
      *                                                               *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *          E N V I R O N M E N T   D I V I S I O N              *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
                                                                        
      *****************************************************************         
      *  C O N F I G U R A T I O N   S E C T I O N                    *         
      *****************************************************************         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
                                                                        
      *****************************************************************         
      *  I N P U T - O U T P U T   S E C T I O N                      *         
      *****************************************************************         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSFA440-FILE                                         
               ASSIGN UT-S-FCSFA440                                     
               STATUS IS WS-FFA440-STATUS.                              
           SELECT FCSPT441-FILE                                         
               ASSIGN UT-S-FCSPT441                                     
               STATUS IS WS-FPT441-STATUS.                              
           SELECT FCSPT442-FILE                                         
               ASSIGN UT-S-FCSPT442                                     
               STATUS IS WS-FPT442-STATUS.                              
           SELECT FCSPT443-FILE                                         
               ASSIGN UT-S-FCSPT443                                     
               STATUS IS WS-FPT443-STATUS.                              
           SELECT FCSPT444-FILE                                         
               ASSIGN UT-S-FCSPT444                                     
               STATUS IS WS-FPT444-STATUS.                              
      *****************************************************************         
      *                    D A T A   D I V I S I O N                  *         
      *****************************************************************         
       DATA DIVISION.                                                   
                                                                        
      *****************************************************************         
      *  F I L E   S E C T I O N                                      *         
      *****************************************************************         
       FILE SECTION.                                                    
                                                                        
       FD  FCSFA440-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
A04110 COPY FIORP440.                                                           
                                                                        
      *DETAIL REPORT LG CUST                                                    
       FD  FCSPT441-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT441-RECORD                       PIC X(132).              
                                                                        
      *SUMMARY REPORT LG CUST                                                   
       FD  FCSPT442-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT442-RECORD                       PIC X(132).              
                                                                        
      *DETAIL REPORT LOSS RESERVE                                               
       FD  FCSPT443-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT443-RECORD                       PIC X(132).              
                                                                        
      *SUMMARY REPORT LOSS RESERVE                                              
       FD  FCSPT444-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT444-RECORD                       PIC X(132).              
                                                                        
      *****************************************************************         
      *  W O R K I N G - S T O R A G E   S E C T I O N                *         
      *****************************************************************         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP440'.
MSQ017     COPY MFASQLM.
                                                                        
      *****                                                                     
      *  START OF WORKING STORAGE                                               
      *****                                                                     
       01  WS00-START                    PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP440 STARTS HERE'.                  
                                                                        
      *****                                                                     
      *  CONSTANTS AND SWITCHES                                                 
      *****                                                                     
       01  WS01-CONSTANTS-SWITHCES.                                     
           05  WS-REPORT-MONTH             PIC X(02)   VALUE SPACES.    
           05  WS-REPORT-YR                PIC X(04)   VALUE SPACES.    
           05  WS-811                      PIC S9(4) COMP VALUE -811.   
           05  WS-PROGRAM-NAME             PIC X(08) VALUE 'PCSRP440'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-WRITE-FLAG               PIC X(01) VALUE 'N'.         
           05  SW01-SWITCHES.                                           
               10  WS-FPT441-STATUS          PIC X(02) VALUE SPACES.    
                   88  FCSPT441-SUCCESSFUL            VALUE '00'.       
               10  WS-FPT442-STATUS          PIC X(02) VALUE SPACES.    
                   88  FCSPT442-SUCCESSFUL            VALUE '00'.       
               10  WS-FPT443-STATUS          PIC X(02) VALUE SPACES.    
                   88  FCSPT443-SUCCESSFUL            VALUE '00'.       
               10  WS-FPT444-STATUS          PIC X(02) VALUE SPACES.    
                   88  FCSPT444-SUCCESSFUL            VALUE '00'.       
               10  WS-FFA440-STATUS          PIC X(02) VALUE SPACES.    
                   88  FCSFA440-SUCCESSFUL            VALUE '00'.       
               10  WS-FCSFA440-END-REC       PIC X(01) VALUE SPACES.    
                   88  FCSFA440-END-REC-PROCESSED     VALUE 'Y'.        
               10  SW01-FRP440-ACTIVITY    PIC X(01) VALUE 'N'.         
                   88  FRP440-HAD-ACTIVITY           VALUE 'Y'.         
                   88  FRP440-HAD-NO-ACTIVITY        VALUE 'N'.         
               10  SW01-COLUMN-HEADING     PIC X(01) VALUE 'N'.         
                   88  SW01-HEADING-YES              VALUE 'Y'.         
                   88  SW01-HEADING-NO               VALUE 'N'.         
               10  SW01-PROCESSED-LR       PIC X(01) VALUE 'N'.         
                   88  SW01-FIRST-LR                 VALUE 'Y'.         
                   88  SW01-NOT-FIRST-LR             VALUE 'N'.         
               10  SW01-FIRST-RECORD       PIC X(01) VALUE 'N'.         
                   88  SW01-FIRST-TIME               VALUE 'Y'.         
                   88  SW01-NOT-FIRST-TIME           VALUE 'N'.         
                                                                        
      *****                                                                     
      *  TITLES AND HEADERS                                                     
      *****                                                                     
       01  WS02-TITLES-AND-HEADERS.                                     
           05  WS02-TITLES.                                             
               10  WS02-TITLE1A.                                        
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  WS02-T1A-REPTNAME     PIC X(17).                 
                   15  FILLER                PIC X(38) VALUE SPACES.    
                   15  WS02-T1A-COMP-NAME    PIC X(26).                 
                   15  FILLER                PIC X(30) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'RUN-DATE: '.                              
                   15  WS02-T1A-RUN-DT       PIC X(10).                 
               10  WS02-TITLE1B.                                        
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  WS02-T1B-REPTNAME     PIC X(17).                 
                   15  FILLER                PIC X(44) VALUE SPACES.    
                   15  WS02-T1B-COMP-NAME    PIC X(26).                 
                   15  FILLER                PIC X(24) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'RUN-DATE: '.                              
                   15  WS02-T1B-RUN-DT       PIC X(10).                 
               10  WS02-TITLE2A.                                        
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'DATE: '.  
                   15  WS02-T2A-CREATE-DT    PIC X(10) .                
                   15  FILLER                PIC X(27) VALUE SPACES.    
                   15  FILLER                PIC X(44) VALUE            
                     'LARGE CUSTOMER AND COMMERCIAL CUSTOMER GROUP'.    
                   15  FILLER                PIC X(24) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'RUN-TIME:   '.                            
                   15  WS02-T2A-RUN-TM       PIC X(08).                 
               10  WS02-TITLE2B.                                        
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'DATE: '.  
                   15  WS02-T2B-CREATE-DT    PIC X(10) .                
                   15  FILLER                PIC X(43) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'LOSS RESERVE'.                            
                   15  FILLER                PIC X(40) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'RUN-TIME:   '.                            
                   15  WS02-T2B-RUN-TM       PIC X(08).                 
               10  WS02-TITLE3A-DETAIL.                                 
                   15  FILLER                PIC X(60) VALUE SPACES.    
                   15  FILLER                PIC X(13) VALUE            
                                                    'DETAIL REPORT'.    
                   15  FILLER                PIC X(39) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'PAGE:       '.                            
                   15  WS02-T3A-PAGE-NUM     PIC ZZ,ZZ9.                
                   15  FILLER                PIC X(03) VALUE SPACES.    
               10  WS02-TITLE3B-SUMMARY.                                
                   15  FILLER                PIC X(59) VALUE SPACES.    
                   15  FILLER                PIC X(14) VALUE            
                                                   'SUMMARY REPORT'.    
                   15  FILLER                PIC X(38) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE ' PAGE:    '.                              
                   15  WS02-T3B-PAGE-NUM     PIC ZZ,ZZ9.                
                   15  FILLER                PIC X(03) VALUE SPACES.    
               10  WS02-TITLE4.                                         
                   15  FILLER                PIC X(51) VALUE SPACES.    
                   15  FILLER                PIC X(15)                  
                       VALUE 'REVENUE MONTH: '.                         
                   15  WS02-TITLE4-REV-M     PIC X(09).                 
                   15  FILLER                PIC X(03) VALUE ', '.      
                   15  WS02-TITLE4-REV-Y     PIC X(04).                 
                   15  FILLER                PIC X(30) VALUE SPACES.    
               10  WS02-TITLE5.                                         
                   15  FILLER                PIC X(05) VALUE SPACES.    
                   15  FILLER                PIC X(13)                  
                       VALUE 'RISK RATING: '.                           
                   15  WS02-TITLE5-RISK-RATING PIC X(05).               
                   15  FILLER                PIC X(109) VALUE SPACES.   
               10  WS02-TITLE6.                                         
                   15  FILLER                PIC X(01)  VALUE SPACES.   
                   15  FILLER                PIC X(17)                  
                       VALUE 'RESERVE PERCENT: '.                       
                   15  WS02-TITLE6-RESERVE-PCT PIC ZZ9.99.              
                   15  FILLER                PIC X(01) VALUE '%'.       
                   15  FILLER                PIC X(112) VALUE SPACES.   
           05  WS02-HEADERS.                                            
               10  WS02-DETAIL-HEADER1.                                 
                   15  FILLER                 PIC X(27) VALUE SPACES.   
                   15  FILLER                 PIC X(08) VALUE           
                            'CUSTOMER'.                                 
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'ACCOUNT'.                                  
                   15  FILLER                 PIC X(05) VALUE SPACES.   
A04110             15  FILLER                 PIC X(04) VALUE           
A04110                      'RISK'.                                     
A04110             15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  FILLER                 PIC X(04) VALUE           
                            'CRED'.                                     
                   15  FILLER                 PIC X(02) VALUE SPACES.   
                   15  FILLER                 PIC X(03) VALUE           
                            'MAJ'.                                      
                   15  FILLER                 PIC X(03) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'ACCOUNT'.                                  
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'OTH SEC'.                                  
A04110             15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  FILLER                 PIC X(03) VALUE           
                            'A/R'.                                      
A04110             15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'RESERVE'.                                  
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(11) VALUE           
A04110                      'ROLLING 12'.                               
A04110             15  FILLER                 PIC X(01) VALUE SPACES.   
                                                                        
               10  WS02-DETAIL-HEADER2.                                 
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(13) VALUE           
                            'CUSTOMER NAME'.                            
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  FILLER                 PIC X(06) VALUE           
                            'NUMBER'.                                   
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  FILLER                 PIC X(06) VALUE           
                            'NUMBER'.                                   
                   15  FILLER                 PIC X(06) VALUE SPACES.   
A04110             15  FILLER                 PIC X(04) VALUE           
A04110                      'DATE'.                                     
A04110             15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  FILLER                 PIC X(03) VALUE           
                            'GRP'.                                      
                   15  FILLER                 PIC X(03) VALUE SPACES.   
                   15  FILLER                 PIC X(03) VALUE           
                            'IND'.                                      
                   15  FILLER                 PIC X(03) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'DEPOSIT'.                                  
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(03) VALUE           
                            'IND'.                                      
A04110             15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'BALANCE'.                                  
A04110             15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  FILLER                 PIC X(06) VALUE           
                            'AMOUNT'.                                   
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(13) VALUE           
                            'MONTH REVENUE'.                            
                                                                        
               10  WS02-SUMMARY-HEADER1.                                
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  FILLER                 PIC X(04) VALUE           
                            'RISK'.                                     
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  FILLER                 PIC X(12) VALUE           
                            'TOTAL NUMBER'.                             
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(12) VALUE           
                            'TOTAL NUMBER'.                             
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(14) VALUE           
                            'TOTAL CUSTOMER'.                           
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  FILLER                 PIC X(09) VALUE           
                            'TOTAL A/R'.                                
                   15  FILLER                 PIC X(15) VALUE SPACES.   
                   15  FILLER                 PIC X(05) VALUE           
                            'TOTAL'.                                    
                   15  FILLER                 PIC X(19) VALUE SPACES.   
                   15  FILLER                 PIC X(08) VALUE           
                            'TOTAL 12'.                                 
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                                                                        
               10  WS02-SUMMARY-HEADER2.                                
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  FILLER                 PIC X(06) VALUE           
                            'RATING'.                                   
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  FILLER                 PIC X(12) VALUE           
                            'OF CUSTOMERS'.                             
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(11) VALUE           
                            'OF ACCOUNTS'.                              
                   15  FILLER                 PIC X(10) VALUE SPACES.   
                   15  FILLER                 PIC X(08) VALUE           
                            'DEPOSITS'.                                 
                   15  FILLER                 PIC X(12) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'BALANCE'.                                  
                   15  FILLER                 PIC X(15) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE           
                            'RESERVE'.                                  
                   15  FILLER                 PIC X(15) VALUE SPACES.   
                   15  FILLER                 PIC X(13) VALUE           
                            'MONTH REVENUE'.                            
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                                                                        
      *****                                                                     
      *  DETAIL LINES                                                           
      *****                                                                     
       01  WS03-DETAIL-LINES.                                           
           05  WS03-DETAIL-REPORT.                                      
               10  WS03-DETAIL-LINE1.                                   
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS03-CUSTOMER-NAME-AND-NO.                       
                       20  WS03-CUSTOMER-NAME     PIC X(25).            
                       20  WS03-CUSTOMER-DASH     PIC X(01).            
                       20  WS03-CUSTOMER-NO       PIC X(10).            
                   15  FILLER                 PIC X(02) VALUE SPACES.   
                   15  WS03-ACCOUNT-NO        PIC X(13).                
A04110             15  FILLER                 PIC X(01) VALUE SPACES.   
A04110             15  WS03-LOSS-RESV-DATE    PIC X(10).                
A04110             15  FILLER                 PIC X(01) VALUE SPACES.   
A04110             15  WS03-CREDIT-GRP        PIC X(03).                
                   15  FILLER                 PIC X(03) VALUE SPACES.   
                   15  WS03-MAJOR-IND         PIC X(01).                
                   15  FILLER                 PIC X(04) VALUE SPACES.   
A04110             15  WS03-ACCT-DEPOSIT      PIC -,---,--9.            
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  WS03-OTHER-SEC-IND     PIC X(01).                
A04110             15  FILLER                 PIC X(06) VALUE SPACES.   
A04110             15  WS03-TOTAL-AR-BALANCE  PIC -,---,--9.            
                   15  FILLER                 PIC X(02) VALUE SPACES.   
A04110             15  WS03-RESERVE-AMOUNT    PIC -,---,--9.            
                   15  FILLER                 PIC X(02) VALUE SPACES.   
A04110             15  WS03-12-MO-REV         PIC -,---,--9.            
                                                                        
               10  WS03-DETAIL-LINE2.                                   
A04110             15  FILLER                 PIC X(76) VALUE SPACES.   
A04110             15  FILLER                 PIC X(10) VALUE ALL '-'.  
A04110             15  FILLER                 PIC X(10) VALUE SPACES.   
A04110             15  FILLER                 PIC X(10) VALUE ALL '-'.  
                   15  FILLER                 PIC X(02) VALUE SPACES.   
A04110             15  FILLER                 PIC X(10) VALUE ALL '-'.  
                   15  FILLER                 PIC X(02) VALUE SPACES.   
                   15  FILLER                 PIC X(10) VALUE ALL '-'.  
                                                                        
               10  WS03-DETAIL-LINE3.                                   
                   15  FILLER                  PIC X(03) VALUE SPACES.  
                   15  FILLER                  PIC X(15)                
                       VALUE 'CUSTOMER TOTALS'.                         
A04110             15  FILLER                  PIC X(56) VALUE SPACES.  
A04110             15  WS03-ACCT-DEP-CUST-TOT  PIC --,---,--9.          
A04110             15  FILLER                  PIC X(10) VALUE SPACES.  
A04110             15  WS03-AR-BAL-CUST-TOT    PIC --,---,--9.          
A04110             15  FILLER                  PIC X(02) VALUE SPACES.  
A04110             15  WS03-RES-AMT-CUST-TOT   PIC --,---,--9.          
A04110             15  FILLER                  PIC X(02) VALUE SPACES.  
A04110             15  WS03-12-MO-REV-CUST-TOT PIC --,---,--9.          
                                                                        
               10  WS03-DETAIL-LINE4.                                   
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(17) VALUE           
                            'TOTAL CUSTOMERS: '.                        
                   15  WS03-CUST-TOT-RATING   PIC 9(04).                
                                                                        
               10  WS03-DETAIL-LINE5.                                   
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  FILLER                 PIC X(16) VALUE           
                            'TOTAL ACCOUNTS: '.                         
                   15  WS03-ACCT-TOT-RATING   PIC 9(04).                
                                                                        
               10  WS03-DETAIL-LINE6.                                   
                   15  FILLER                 PIC X(02) VALUE SPACES.   
                   15  FILLER                 PIC X(23) VALUE           
                            'GROUP TOTAL CUSTOMERS: '.                  
                   15  WS03-CUST-TOTAL-GROUP  PIC 9(04).                
                                                                        
               10  WS03-DETAIL-LINE7.                                   
                   15  FILLER                 PIC X(03) VALUE SPACES.   
                   15  FILLER                 PIC X(22) VALUE           
                            'GROUP TOTAL ACCOUNTS: '.                   
                   15  WS03-ACCT-TOT-GROUP    PIC 9(04).                
                                                                        
           05  WS03-SUMMARY-REPORT.                                     
               10  WS03-SUMMARY-LINE1.                                  
                   15  FILLER                 PIC X(02) VALUE SPACES.   
                   15  WS03-RR-RISK-RATING    PIC X(11).                
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS03-RR-NUM-CUSTOMERS  PIC ZZZZZ9.               
                   15  FILLER                 PIC X(09) VALUE SPACES.   
                   15  WS03-RR-NUM-ACCOUNTS   PIC ZZZZZZZZZ9.           
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  WS03-RR-CUST-DEPOSITS  PIC ZZ,ZZZ,ZZZ,ZZ9.       
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                   15  WS03-RR-TOT-AR-BALANCE PIC --,---,---,--9.       
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  WS03-RR-RESERVE        PIC ZZ,ZZZ,ZZZ,ZZ9.       
                   15  FILLER                 PIC X(12) VALUE SPACES.   
                   15  WS03-RR-12-MO-REVENUE  PIC ---,---,---,--9.      
                                                                        
               10  WS03-SUMMARY-LINE2.                                  
                   15  FILLER                 PIC X(13) VALUE SPACES.   
                   15  FILLER                 PIC X(07) VALUE ALL '-'.  
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  FILLER                 PIC X(11) VALUE ALL '-'.  
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(15) VALUE ALL '-'.  
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  FILLER                 PIC X(15) VALUE ALL '-'.  
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  FILLER                 PIC X(15) VALUE ALL '-'.  
                   15  FILLER                 PIC X(09) VALUE SPACES.   
                   15  FILLER                 PIC X(18) VALUE ALL '-'.  
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                                                                        
               10  WS03-SUMMARY-LINE3.                                  
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  FILLER                 PIC X(06) VALUE 'TOTALS'. 
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS03-RG-NUM-CUSTOMERS  PIC ZZZZZZ9.              
                   15  FILLER                 PIC X(08) VALUE SPACES.   
                   15  WS03-RG-NUM-ACCOUNTS   PIC ZZZZZZZZZZ9.          
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  WS03-RG-CUST-DEPOSITS  PIC ZZZ,ZZZ,ZZZ,ZZ9.      
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  WS03-RG-TOT-AR-BALANCE PIC ---,---,---,--9.      
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  WS03-RG-RESERVE        PIC ZZZ,ZZZ,ZZZ,ZZ9.      
                   15  FILLER                 PIC X(09) VALUE SPACES.   
                   15  WS03-RG-12-MO-REVENUE  PIC ZZ,ZZZ,ZZZ,ZZZ,ZZ9.   
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                                                                        
               10  WS03-SUMMARY-LINE4.                                  
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  FILLER                 PIC X(12)                 
                       VALUE 'GRAND TOTALS'.                            
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS03-GT-NUM-CUSTOMERS  PIC ZZZZZZ9.              
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  WS03-GT-NUM-ACCOUNTS   PIC ZZZZZZZZZZ9.          
                   15  FILLER                 PIC X(06) VALUE SPACES.   
                   15  WS03-GT-CUST-DEPOSITS  PIC ZZZ,ZZZ,ZZZ,ZZ9.      
                   15  FILLER                 PIC X(04) VALUE SPACES.   
                   15  WS03-GT-TOT-AR-BALANCE PIC ---,---,---,--9.      
                   15  FILLER                 PIC X(07) VALUE SPACES.   
                   15  WS03-GT-RESERVE        PIC ZZZ,ZZZ,ZZZ,ZZ9.      
                   15  FILLER                 PIC X(09) VALUE SPACES.   
                   15  WS03-GT-12-MO-REVENUE  PIC ZZ,ZZZ,ZZZ,ZZZ,ZZ9.   
                   15  FILLER                 PIC X(05) VALUE SPACES.   
                                                                        
           05  WS03-BLANK-LINE               PIC X(132) VALUE SPACES.   
           05  WS03-BLANK-LINE-DASH          PIC X(132) VALUE ALL '-'.  
                                                                        
           05  WS03-NO-FILE-LINE.                                       
               10  FILLER                    PIC X(56) VALUE SPACES.    
               10  FILLER                    PIC X(25)                  
                   VALUE '*** NO DATA RECEIVED *** '.                   
               10  FILLER                    PIC X(52) VALUE SPACES.    
                                                                        
           05  WS03-END-DATA-LINE.                                      
               10  FILLER                    PIC X(56) VALUE SPACES.    
               10  FILLER                    PIC X(22)                  
                   VALUE '*** END OF REPORT *** '.                      
               10  FILLER                    PIC X(55) VALUE SPACES.    
                                                                        
      *****                                                                     
      *  DATES, TIMES AND TIMESTAMPS                                            
      *****                                                                     
       01  WS04-DATE-TIME-STAMPS.                                       
           05  WS04-CURRENT-TS             PIC X(26).                   
           05  WS04-CURRENT-TS-BREAKDOWN   REDEFINES WS04-CURRENT-TS.   
               10  WS04-CURRENT-DATE.                                   
                   15  WS04-CURRENT-YEAR   PIC X(04).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MONTH  PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-DAY    PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS04-CURRENT-TIME.                                   
                   15  WS04-CURRENT-HOUR   PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MIN    PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-SEC    PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MSEC   PIC X(06).                   
           05  WS04-REVENUE-MONTH.                                      
               10  WS04-REVENUE-MONTH-CCYY PIC X(04).                   
               10  WS04-REVENUE-MONTH-MM   PIC X(02).                   
                                                                        
      *****                                                                     
      *  PCSRP440 REPORT WORK AREA                                              
      *****                                                                     
       01  WS05-WORK-AREA.                                              
           05  WS-PGRMNAME                   PIC X(08).                 
           05  WS-COMPANY-NO                 PIC X(02).                 
           05  WS-COMPANY-NAME               PIC X(27).                 
           05  WS-SYSIN-COMP                 PIC X(04).                 
           05  WS-SYSIN-DATABASE             PIC 9(01)  VALUE 0.        
               88 CSR-DATABASE                          VALUE 1.        
               88 SEB-DATABASE                          VALUE 2.        
           05  WS05-R1-CUSTOMER-TOTALS.                                 
COB305         10 WS05-R1-CT-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-CT-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-CT-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-CT-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-CT-TOT-ACCOUNTS        PIC 9(10) COMP-3 
COB305           VALUE 0.       
           05  WS05-R1-RISK-RATING-TOTALS.                              
COB305         10 WS05-R1-RR-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RR-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RR-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RR-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RR-TOT-CUSTOMERS        PIC S9(06) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R1-RR-TOT-ACCOUNTS        PIC S9(10) COMP-3 
COB305           VALUE 0.      
           05  WS05-R1-RISK-GROUP-TOTALS.                               
COB305         10 WS05-R1-RG-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RG-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RG-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RG-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-RG-TOT-CUSTOMERS        PIC S9(07) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R1-RG-TOT-ACCOUNTS        PIC S9(11) COMP-3 
COB305           VALUE 0.      
           05  WS05-R1-GRAND-TOTALS.                                    
COB305         10 WS05-R1-GT-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-GT-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-GT-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-GT-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R1-GT-TOT-CUSTOMERS        PIC S9(07) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R1-GT-TOT-ACCOUNTS        PIC S9(11) COMP-3 
COB305           VALUE 0.      
           05  WS05-R2-CUSTOMER-TOTALS.                                 
COB305         10 WS05-R2-CT-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-CT-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-CT-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-CT-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-CT-TOT-ACCOUNTS        PIC S9(10) COMP-3 
COB305           VALUE 0.      
           05  WS05-R2-RISK-RATING-TOTALS.                              
COB305         10 WS05-R2-RR-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RR-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RR-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RR-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RR-TOT-CUSTOMERS        PIC S9(06) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R2-RR-TOT-ACCOUNTS        PIC S9(10) COMP-3 
COB305           VALUE 0.      
           05  WS05-R2-RISK-GROUP-TOTALS.                               
COB305         10 WS05-R2-RG-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RG-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RG-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RG-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-RG-TOT-CUSTOMERS        PIC S9(07) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R2-RG-TOT-ACCOUNTS        PIC S9(11) COMP-3 
COB305           VALUE 0.      
           05  WS05-R2-GRAND-TOTALS.                                    
COB305         10 WS05-R2-GT-ACCT-DEP        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-GT-TOT-AR-BAL        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-GT-RESERVE-AMT        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-GT-12-MONTH-REV        PIC S9(11)V99 COMP-3 
COB305           VALUE 0.   
COB305         10 WS05-R2-GT-TOT-CUSTOMERS        PIC S9(07) COMP-3 
COB305           VALUE 0.      
COB305         10 WS05-R2-GT-TOT-ACCOUNTS        PIC S9(11) COMP-3 
COB305           VALUE 0.      
           05  WS05-PAGE-COUNTERS.                                      
               10  WS05-R1-DET-PAGE-NUM  PIC 9(05).                     
               10  WS05-R1-SUM-PAGE-NUM  PIC 9(05).                     
               10  WS05-R2-DET-PAGE-NUM  PIC 9(05).                     
               10  WS05-R2-SUM-PAGE-NUM  PIC 9(05).                     
           05  WS05-LINE-COUNTERS.                                      
               10  WS05-R1-DTL-LINE-CTR     PIC 9(05) VALUE 65.         
               10  WS05-R1-SUM-LINE-CTR     PIC 9(05) VALUE 65.         
               10  WS05-R2-DTL-LINE-CTR     PIC 9(05) VALUE 65.         
               10  WS05-R2-SUM-LINE-CTR     PIC 9(05) VALUE 65.         
           05  WS05-PREV-RECORD-VALUES.                                 
               10  WS05-R1-PREV-CUSTOMER-NO     PIC 9(10) VALUE 0.      
               10  WS05-R1-PREV-RISK-RATING     PIC X(15) VALUE SPACES. 
               10  WS05-R1-PREV-GROUP-SEQ-NO    PIC 9(03) VALUE 0.      
               10  WS05-R2-PREV-CUSTOMER-NO     PIC 9(10) VALUE 0.      
               10  WS05-R2-PREV-RISK-RATING     PIC X(15) VALUE SPACES. 
               10  WS05-R2-PREV-GROUP-SEQ-NO    PIC 9(03) VALUE 0.      
      *                                                                         
           COPY FIOCA00.                                                        
      *                                                                         
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ERROR HANDLING                                            
      *****                                                                     
       COPY CWS00010.                                                           
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ABEND SWITCH                                              
      *****                                                                     
       COPY CWS09900.                                                           
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ACCOUNT NO/EXTERNAL ID                                    
      *****                                                                     
       COPY CWS00318.                                                           
                                                                        
      *****                                                                     
      *  COPYBOOK FOR DATE CHECK                                                
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE FIOJC01                                                    
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR JOB PARM INFORMATION                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      **  CWS00114  WS FOR START DT & END DATE.                                 
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00114                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      **  CWS00039 WS FOR COMMON DATE                                           
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_JOB_PARM                                                           
      *****                                                                     
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_DELINQUENCY                                                        
      *****                                                                     
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  COPYBOOK FOR DB2/SQL ERROR HANDLING                                    
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00303                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  SQLCA                                                                  
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSRP440 ENDS HERE'.                    
                                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *             LINKAGE  SECTION                                  *         
      *        PARM-MONTHLY = 'MONTHLY'  FOR MONTHLY JOB              *         
      *****************************************************************         
       LINKAGE SECTION.                                                 
      *****************************************************************         
      *             P R O C E D U R E   D I V I S I O N               *         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  0000-MAINLINE                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           IF FRP440-HAD-ACTIVITY                                       
               PERFORM 1000-PROCESS-DETAIL-REPORT THRU 1000-EXIT        
                 UNTIL FCSFA440-END-REC-PROCESSED                       
                                                                        
               PERFORM 2000-PROCESS-TOTALS        THRU 2000-EXIT        
           END-IF                                                       
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
       0000-EXIT.                                                       
           STOP RUN.                                                    
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  0100-INITIALIZATION                                          *         
      *                                                               *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'              TO ACTIVE-PARAGRAPH.                
                                                                        
           INITIALIZE WS04-DATE-TIME-STAMPS                             
                      WS05-WORK-AREA                                    
                      WS-SYSIPT.                                        
                                                                        
           ACCEPT WS-COMPANY-NO    FROM SYSIN.                          
                                                                        
           MOVE WS-COMPANY-NO      TO C8-COMPANY-NO.                    
           MOVE 'DATABASE'         TO C8-DELINQ-CD.                     
           PERFORM 7300-GET-DEL-VALUE  THRU 7300-EXIT.                  
           MOVE C8-DELINQ-VALUE    TO WS-SYSIN-DATABASE.                
                                                                        
           IF WS-COMPANY-NO = '01'                                      
              IF CSR-DATABASE                                           
                 MOVE 'SCEG' TO WS-SYSIN-COMP                           
              ELSE                                                      
                 MOVE 'SEB ' TO WS-SYSIN-COMP                           
              END-IF                                                    
           ELSE                                                         
              MOVE 'PSNC' TO WS-SYSIN-COMP                              
           END-IF.                                                      
                                                                        
           MOVE WS-PROGRAM-NAME    TO WS-PGRMNAME.                      
                                                                        
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT            
           MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                   
                                                                        
           PERFORM 0200-SELECT-CURR-TIMESTAMP        THRU 0200-EXIT.    
                                                                        
           OPEN INPUT FCSFA440-FILE.                                    
                                                                        
           IF NOT FCSFA440-SUCCESSFUL                                   
               DISPLAY '************************************'           
               DISPLAY '**   PCSRP440 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING FCSFA440      **'          
               DISPLAY '**     FILE STATUS =' WS-FFA440-STATUS          
               DISPLAY '************************************'           
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT441-FILE.                                   
           OPEN OUTPUT FCSPT442-FILE.                                   
           OPEN OUTPUT FCSPT443-FILE.                                   
           OPEN OUTPUT FCSPT444-FILE.                                   
                                                                        
           PERFORM 0300-POPULATE-TITLES      THRU 0300-EXIT.            
                                                                        
           PERFORM 0500-FCSFA440-FIRST-RECORD THRU 0500-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  0200-SELECT-CURR-TIMESTAMP                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) RETRIEVES CURRENT TIMESTAMP FROM DB2                  *         
      *                                                               *         
      *****************************************************************         
       0200-SELECT-CURR-TIMESTAMP.                                      
                                                                        
           MOVE '0200'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS04-CURRENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS04-CURRENT-TS = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '***********************************'             
              DISPLAY '**   PCSRP162 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 0200    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  0300-POPULATE-TITLES                                         *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) POPULATES TITLE VARIABLES THAT WILL BE THE SAME FOR   *         
      *         ALL 3 REPORTS                                         *         
      *                                                               *         
      *****************************************************************         
       0300-POPULATE-TITLES.                                            
                                                                        
           MOVE '0300'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           STRING WS04-CURRENT-TS(6:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(9:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(1:4)  DELIMITED BY SIZE               
             INTO WS02-T1A-RUN-DT.                                      
           MOVE   WS02-T1A-RUN-DT TO WS02-T1B-RUN-DT.                   
                                                                        
           STRING WS04-CURRENT-TS(12:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(15:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(18:2) DELIMITED BY SIZE               
             INTO WS02-T2A-RUN-TM.                                      
           MOVE   WS02-T2A-RUN-TM TO WS02-T2B-RUN-TM.                   
                                                                        
           STRING WS-INPUT-DATE(6:2)            DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-INPUT-DATE(9:2)            DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-INPUT-DATE(1:4)            DELIMITED BY SIZE       
           INTO WS02-T2A-CREATE-DT.                                     
           MOVE WS02-T2A-CREATE-DT TO WS02-T2B-CREATE-DT.               
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  0350-GET-COMPANY-NAME                                       *          
      *       GETS THE COMPANY NAME FROM CSS_COMPANY TABLE           *          
      ****************************************************************          
       0350-GET-COMPANY-NAME.                                           
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO = :WS-COMPANY-NO                        
T35434                                                           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       0350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  0375-GET-REVENUE-MONTH                                      *          
      *       GETS THE MONTH FOR THE TITLE BASED ON THE REV MONTH    *          
      *       PASSSED IN                                             *          
      ****************************************************************          
       0375-GET-REVENUE-MONTH.                                          
                                                                        
           MOVE E-FRP440-CURRENT-REV-MTH TO WS04-REVENUE-MONTH          
           MOVE WS04-REVENUE-MONTH-CCYY  TO WS02-TITLE4-REV-Y           
           EVALUATE WS04-REVENUE-MONTH-MM                               
              WHEN '01'                                                 
                MOVE 'JANUARY  '      TO WS02-TITLE4-REV-M              
              WHEN '02'                                                 
                MOVE 'FEBRUARY '      TO WS02-TITLE4-REV-M              
              WHEN '03'                                                 
                MOVE 'MARCH    '      TO WS02-TITLE4-REV-M              
              WHEN '04'                                                 
                MOVE 'APRIL    '      TO WS02-TITLE4-REV-M              
              WHEN '05'                                                 
                MOVE 'MAY      '      TO WS02-TITLE4-REV-M              
              WHEN '06'                                                 
                MOVE 'JUNE     '      TO WS02-TITLE4-REV-M              
              WHEN '07'                                                 
                MOVE 'JULY     '      TO WS02-TITLE4-REV-M              
              WHEN '08'                                                 
                MOVE 'AUGUST   '      TO WS02-TITLE4-REV-M              
              WHEN '09'                                                 
                MOVE 'SEPTEMBER'      TO WS02-TITLE4-REV-M              
              WHEN '10'                                                 
                MOVE 'OCTOBER  '      TO WS02-TITLE4-REV-M              
              WHEN '11'                                                 
                MOVE 'NOVEMBER '      TO WS02-TITLE4-REV-M              
              WHEN '12'                                                 
                MOVE 'DECEMBER '      TO WS02-TITLE4-REV-M              
           END-EVALUATE.                                                
                                                                        
       0375-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  0500-FRP440-FIRST-RECORD.                                    *         
      *                                                               *         
      *   THIS PARAGRAPH:                                             *         
      *     1) READS FIRST RECORD IN FCSFA440-FILE                    *         
      *        -IF FIRST RECORD IS EOF, NO FILE REC'D                 *         
      *                                                               *         
      *****************************************************************         
       0500-FCSFA440-FIRST-RECORD.                                      
                                                                        
           MOVE '0500'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 7000-READ-FCSFA440 THRU 7000-EXIT.                   
                                                                        
           IF FCSFA440-END-REC-PROCESSED                                
              IF WS-SYSIN-COMP = 'SCEG'                                 
                 PERFORM 5200-NO-SCEG-REPORT THRU 5200-EXIT             
                 SET FRP440-HAD-NO-ACTIVITY TO TRUE                     
              ELSE                                                      
                 IF WS-SYSIN-COMP = 'PSNC'                              
                    PERFORM 5210-NO-PSNC-REPORT THRU 5210-EXIT          
                    SET FRP440-HAD-NO-ACTIVITY TO TRUE                  
                 ELSE                                                   
                    IF WS-SYSIN-COMP = 'SEB '                           
                       PERFORM 5220-NO-SEB-REPORT THRU 5220-EXIT        
                       SET FRP440-HAD-NO-ACTIVITY TO TRUE               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE E-FRP440-COMPANY-NO TO WS-COMPANY-NO                 
              PERFORM 0350-GET-COMPANY-NAME THRU 0350-EXIT              
              IF WS-SYSIN-COMP = 'SCEG'                                 
                 MOVE WS-COMPANY-NAME TO WS02-T1A-COMP-NAME             
              ELSE                                                      
                 MOVE WS-COMPANY-NAME TO WS02-T1B-COMP-NAME             
              END-IF                                                    
              MOVE ZEROES TO WS02-T3A-PAGE-NUM                          
                             WS02-T3B-PAGE-NUM                          
              PERFORM 0375-GET-REVENUE-MONTH THRU 0375-EXIT             
              SET FRP440-HAD-ACTIVITY TO TRUE                           
              MOVE 65  TO WS05-R1-DTL-LINE-CTR                          
                          WS05-R1-SUM-LINE-CTR                          
                          WS05-R2-DTL-LINE-CTR                          
                          WS05-R2-SUM-LINE-CTR                          
                                                                        
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS05-R1-PREV-CUSTOMER-NO 
                                               WS05-R2-PREV-CUSTOMER-NO 
              MOVE E-FRP440-RISK-RATING  TO WS05-R1-PREV-RISK-RATING    
                                            WS05-R2-PREV-RISK-RATING    
                                            WS02-TITLE5-RISK-RATING     
              IF E-FRP440-RISK-RATING = SPACES                          
                 MOVE 'ERROR' TO WS02-TITLE5-RISK-RATING                
              END-IF                                                    
              MOVE E-FRP440-RESERVE-PERCENT TO WS02-TITLE6-RESERVE-PCT  
              MOVE E-FRP440-GROUP-SEQ-NO TO WS05-R1-PREV-GROUP-SEQ-NO   
                                            WS05-R2-PREV-GROUP-SEQ-NO   
              SET  SW01-FIRST-LR           TO TRUE                      
              SET  SW01-FIRST-TIME         TO TRUE                      
           END-IF.                                                      
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1000-PROCESS-DETAIL-REPORT                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) DRIVES PROCESSING FOR DETAIL                          *         
      *                                                               *         
      *****************************************************************         
       1000-PROCESS-DETAIL-REPORT.                                      
                                                                        
           MOVE '1000'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           SET  SW01-HEADING-YES TO TRUE.                               
                                                                        
           INITIALIZE WS03-DETAIL-LINE1                                 
                      WS03-SUMMARY-LINE1.                               
                                                                        
                                                                        
           IF (E-FRP440-CUSTOMER-NUMBER NOT = WS05-R1-PREV-CUSTOMER-NO) 
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS05-R1-PREV-CUSTOMER-NO 
                                                                        
              PERFORM 3000-PRINT-R1-CUSTOMER-TOTALS THRU 3000-EXIT      
                                                                        
              MOVE E-FRP440-CUSTOMER-NAME   TO WS03-CUSTOMER-NAME       
              MOVE '-'                      TO WS03-CUSTOMER-DASH       
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS03-CUSTOMER-NO         
           ELSE                                                         
              IF (SW01-NOT-FIRST-TIME)                                  
                 MOVE SPACES TO WS03-CUSTOMER-NAME-AND-NO               
              ELSE                                                      
                 MOVE E-FRP440-CUSTOMER-NAME   TO WS03-CUSTOMER-NAME    
                 MOVE '-'                      TO WS03-CUSTOMER-DASH    
                 MOVE E-FRP440-CUSTOMER-NUMBER TO WS03-CUSTOMER-NO      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF E-FRP440-RISK-RATING NOT = WS05-R1-PREV-RISK-RATING       
              PERFORM 3100-PRINT-R1-RATING-TOTALS THRU 3100-EXIT        
              MOVE E-FRP440-RISK-RATING TO WS05-R1-PREV-RISK-RATING     
           END-IF.                                                      
                                                                        
           MOVE E-FRP440-ACCOUNT-NO       TO WS03-ACCOUNT-NO            
A04110     MOVE E-FRP440-LOSS-RESV-DATE   TO WS03-LOSS-RESV-DATE        
           MOVE E-FRP440-CREDIT-GROUP     TO WS03-CREDIT-GRP            
           MOVE E-FRP440-MAJOR-IND        TO WS03-MAJOR-IND             
           MOVE E-FRP440-DEPOSIT-AMOUNT   TO WS03-ACCT-DEPOSIT          
           MOVE E-FRP440-OTHER-SEC-IND    TO WS03-OTHER-SEC-IND         
           MOVE E-FRP440-TOTAL-AR-BALANCE TO WS03-TOTAL-AR-BALANCE      
           MOVE E-FRP440-RESERVE-AMOUNT   TO WS03-RESERVE-AMOUNT        
           MOVE E-FRP440-TWELVE-MTH-REV   TO WS03-12-MO-REV             
                                                                        
           ADD  E-FRP440-DEPOSIT-AMOUNT   TO WS05-R1-CT-ACCT-DEP        
           ADD  E-FRP440-TOTAL-AR-BALANCE TO WS05-R1-CT-TOT-AR-BAL      
           ADD  E-FRP440-RESERVE-AMOUNT   TO WS05-R1-CT-RESERVE-AMT     
           ADD  E-FRP440-TWELVE-MTH-REV   TO WS05-R1-CT-12-MONTH-REV    
           ADD  1                         TO WS05-R1-CT-TOT-ACCOUNTS    
                                                                        
           PERFORM 5100-WRITE-FCSRP441-DETAIL THRU 5100-EXIT            
                                                                        
           IF E-FRP440-LOSS-RESERVE-IND = 'Y'                           
               PERFORM 1100-PROCESS-DETAIL-REPORT2 THRU 1100-EXIT       
           END-IF.                                                      
                                                                        
           SET SW01-NOT-FIRST-TIME TO TRUE                              
                                                                        
           PERFORM 7000-READ-FCSFA440 THRU 7000-EXIT.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 1100-PROCESS-DETAIL-REPORT2.                            *               
      *      PROCESS THE ACCOUNT FOR THE SECOND REPORT          *               
      *      ONLY ACCTS WITH LOSS-RESERVE-IND = 'Y' ARE         *               
      *      WRITTEN TO THIS REPORT                             *               
      ***********************************************************               
       1100-PROCESS-DETAIL-REPORT2.                                     
                                                                        
           MOVE '1100'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           SET  SW01-HEADING-YES TO TRUE.                               
                                                                        
           IF SW01-FIRST-LR                                             
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS05-R2-PREV-CUSTOMER-NO 
              MOVE E-FRP440-RISK-RATING     TO WS05-R2-PREV-RISK-RATING 
              MOVE E-FRP440-GROUP-SEQ-NO    TO WS05-R2-PREV-GROUP-SEQ-NO
           END-IF.                                                      
                                                                        
           IF (E-FRP440-CUSTOMER-NUMBER NOT = WS05-R2-PREV-CUSTOMER-NO) 
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS05-R2-PREV-CUSTOMER-NO 
                                                                        
              PERFORM 3010-PRINT-R2-CUSTOMER-TOTALS THRU 3010-EXIT      
                                                                        
              MOVE E-FRP440-CUSTOMER-NAME   TO WS03-CUSTOMER-NAME       
              MOVE '-'                      TO WS03-CUSTOMER-DASH       
              MOVE E-FRP440-CUSTOMER-NUMBER TO WS03-CUSTOMER-NO         
           ELSE                                                         
              IF SW01-FIRST-LR                                          
                 MOVE E-FRP440-CUSTOMER-NAME   TO WS03-CUSTOMER-NAME    
                 MOVE '-'                      TO WS03-CUSTOMER-DASH    
                 MOVE E-FRP440-CUSTOMER-NUMBER TO WS03-CUSTOMER-NO      
                 SET  SW01-NOT-FIRST-LR TO TRUE                         
              ELSE                                                      
                 MOVE SPACES TO WS03-CUSTOMER-NAME-AND-NO               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF E-FRP440-RISK-RATING NOT = WS05-R2-PREV-RISK-RATING       
              PERFORM 3110-PRINT-R2-RATING-TOTALS THRU 3110-EXIT        
              MOVE E-FRP440-RISK-RATING TO WS05-R2-PREV-RISK-RATING     
           END-IF.                                                      
                                                                        
           ADD  E-FRP440-DEPOSIT-AMOUNT   TO WS05-R2-CT-ACCT-DEP        
           ADD  E-FRP440-TOTAL-AR-BALANCE TO WS05-R2-CT-TOT-AR-BAL      
           ADD  E-FRP440-RESERVE-AMOUNT   TO WS05-R2-CT-RESERVE-AMT     
           ADD  E-FRP440-TWELVE-MTH-REV   TO WS05-R2-CT-12-MONTH-REV    
           ADD  1                         TO WS05-R2-CT-TOT-ACCOUNTS    
                                                                        
           PERFORM 5110-WRITE-FCSRP443-DETAIL THRU 5110-EXIT.           
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  2000-PROCESS-TOTALS                                          *         
      *                                                               *         
      *    THIS PARAGRAPH: PRINTS OUT THE FINAL TOTALS AFTER THE LAST *         
      *                    RECORD PROCESSED                           *         
      *****************************************************************         
       2000-PROCESS-TOTALS.                                             
                                                                        
           MOVE '2000'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 3000-PRINT-R1-CUSTOMER-TOTALS    THRU 3000-EXIT      
           PERFORM 3100-PRINT-R1-RATING-TOTALS      THRU 3100-EXIT      
           PERFORM 3200-PRINT-R1-GROUP-TOTALS       THRU 3200-EXIT      
           PERFORM 3300-PRINT-R1-GRAND-TOTALS       THRU 3300-EXIT      
                                                                        
           PERFORM 3010-PRINT-R2-CUSTOMER-TOTALS  THRU 3010-EXIT        
           IF WS05-R1-PREV-GROUP-SEQ-NO = WS05-R2-PREV-GROUP-SEQ-NO     
              PERFORM 3110-PRINT-R2-RATING-TOTALS THRU 3110-EXIT        
              PERFORM 3220-PRINT-R2-GROUP-TOTALS  THRU 3220-EXIT        
           ELSE                                                         
              PERFORM 3110-PRINT-R2-RATING-TOTALS THRU 3110-EXIT        
           END-IF                                                       
           PERFORM 3320-PRINT-R2-GRAND-TOTALS     THRU 3320-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *  3000-PRINT-CUSTOMER-TOTALS   (1ST REPORT)                    *         
      *                                                               *         
      *    THIS PARAGRAPH: PRINTS CUSTOMER TOTAL LINES AND RESETS     *         
      *                    CUSTOMER ACCUMULATORS                      *         
      *****************************************************************         
       3000-PRINT-R1-CUSTOMER-TOTALS.                                   
                                                                        
           MOVE '3000'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS05-R1-DTL-LINE-CTR  GREATER THAN 60                     
              PERFORM 5000-WRITE-FCSRP441-TITLES                        
                 THRU 5000-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS03-DETAIL-LINE2                   
                    AFTER ADVANCING 1 LINE.                             
           MOVE WS05-R1-CT-ACCT-DEP     TO WS03-ACCT-DEP-CUST-TOT       
           MOVE WS05-R1-CT-TOT-AR-BAL   TO WS03-AR-BAL-CUST-TOT         
           MOVE WS05-R1-CT-RESERVE-AMT  TO WS03-RES-AMT-CUST-TOT        
           MOVE WS05-R1-CT-12-MONTH-REV TO WS03-12-MO-REV-CUST-TOT.     
                                                                        
           WRITE PRT441-RECORD FROM WS03-DETAIL-LINE3                   
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT441-RECORD FROM WS03-BLANK-LINE                     
                    AFTER ADVANCING 1 LINE.                             
                                                                        
           ADD 4 TO WS05-R1-DTL-LINE-CTR                                
                                                                        
           ADD 1                       TO WS05-R1-RR-TOT-CUSTOMERS      
           ADD WS05-R1-CT-TOT-ACCOUNTS TO WS05-R1-RR-TOT-ACCOUNTS       
           ADD WS05-R1-CT-ACCT-DEP     TO WS05-R1-RR-ACCT-DEP           
           ADD WS05-R1-CT-TOT-AR-BAL   TO WS05-R1-RR-TOT-AR-BAL         
           ADD WS05-R1-CT-RESERVE-AMT  TO WS05-R1-RR-RESERVE-AMT        
           ADD WS05-R1-CT-12-MONTH-REV TO WS05-R1-RR-12-MONTH-REV.      
                                                                        
           INITIALIZE WS05-R1-CUSTOMER-TOTALS.                          
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  3010-PRINT-R2-CUSTOMER-TOTALS    (2ND REPORT)                *         
      *                                                               *         
      *    THIS PARAGRAPH: PRINTS CUSTOMER TOTAL LINES AND RESETS     *         
      *                    CUSTOMER ACCUMULATORS                      *         
      *****************************************************************         
       3010-PRINT-R2-CUSTOMER-TOTALS.                                   
                                                                        
           MOVE '3010'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS05-R2-DTL-LINE-CTR  GREATER THAN 60                     
              PERFORM 5010-WRITE-FCSRP443-TITLES                        
                 THRU 5010-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT443-RECORD FROM WS03-DETAIL-LINE2                   
                    AFTER ADVANCING 1 LINE.                             
                                                                        
           MOVE WS05-R2-CT-ACCT-DEP     TO WS03-ACCT-DEP-CUST-TOT       
           MOVE WS05-R2-CT-TOT-AR-BAL   TO WS03-AR-BAL-CUST-TOT         
           MOVE WS05-R2-CT-RESERVE-AMT  TO WS03-RES-AMT-CUST-TOT        
           MOVE WS05-R2-CT-12-MONTH-REV TO WS03-12-MO-REV-CUST-TOT.     
                                                                        
           WRITE PRT443-RECORD FROM WS03-DETAIL-LINE3                   
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT443-RECORD FROM WS03-BLANK-LINE                     
                    AFTER ADVANCING 1 LINE.                             
                                                                        
           ADD 4 TO WS05-R2-DTL-LINE-CTR                                
                                                                        
           ADD 1                       TO WS05-R2-RR-TOT-CUSTOMERS      
           ADD WS05-R2-CT-TOT-ACCOUNTS TO WS05-R2-RR-TOT-ACCOUNTS       
           ADD WS05-R2-CT-ACCT-DEP     TO WS05-R2-RR-ACCT-DEP           
           ADD WS05-R2-CT-TOT-AR-BAL   TO WS05-R2-RR-TOT-AR-BAL         
           ADD WS05-R2-CT-RESERVE-AMT  TO WS05-R2-RR-RESERVE-AMT        
           ADD WS05-R2-CT-12-MONTH-REV TO WS05-R2-RR-12-MONTH-REV       
                                                                        
           INITIALIZE WS05-R2-CUSTOMER-TOTALS.                          
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3100-PRINT-R1-RATING-TOTALS.   (1ST REPORT)             *               
      *                                                         *               
      *      THIS PRINTS THE TOTAL LINES FOR THE RISK RATINGS   *               
      * ON THE DETAIL AND SUMMARY REPORT                        *               
      *      IT ALSO CHECKS TO SEE IF THERE IS A CHANGE IN THE  *               
      * RISK RATING GROUP.  IF SO, THAT SUBTOTAL IS WRTITEN OUT *               
      * TO THE SUMMARY REPORT.                                  *               
      ***********************************************************               
       3100-PRINT-R1-RATING-TOTALS.                                     
                                                                        
           MOVE '3100'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS05-R1-DTL-LINE-CTR GREATER THAN 61                      
              PERFORM 5000-WRITE-FCSRP441-TITLES                        
                 THRU 5000-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE  WS05-R1-RR-TOT-CUSTOMERS TO WS03-CUST-TOT-RATING       
           WRITE PRT441-RECORD FROM WS03-DETAIL-LINE4                   
                    AFTER ADVANCING 2 LINE.                             
                                                                        
           MOVE  WS05-R1-RR-TOT-ACCOUNTS  TO WS03-ACCT-TOT-RATING       
           WRITE PRT441-RECORD FROM WS03-DETAIL-LINE5                   
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           MOVE 65 TO WS05-R1-DTL-LINE-CTR                              
                                                                        
      * WRITE OUT SUMMARY REPORT DETAIL LINE                                    
           IF WS05-R1-PREV-RISK-RATING = SPACES                         
              MOVE 'ERROR' TO WS03-RR-RISK-RATING                       
           ELSE                                                         
              MOVE WS05-R1-PREV-RISK-RATING TO WS03-RR-RISK-RATING      
           END-IF                                                       
           MOVE WS05-R1-RR-TOT-CUSTOMERS TO WS03-RR-NUM-CUSTOMERS       
           MOVE WS05-R1-RR-TOT-ACCOUNTS  TO WS03-RR-NUM-ACCOUNTS        
           MOVE WS05-R1-RR-ACCT-DEP      TO WS03-RR-CUST-DEPOSITS       
           MOVE WS05-R1-RR-TOT-AR-BAL    TO WS03-RR-TOT-AR-BALANCE      
           MOVE WS05-R1-RR-RESERVE-AMT   TO WS03-RR-RESERVE             
           MOVE WS05-R1-RR-12-MONTH-REV  TO WS03-RR-12-MO-REVENUE       
                                                                        
           IF WS05-R1-SUM-LINE-CTR GREATER THAN 60                      
              PERFORM 5020-WRITE-FCSRP442-TITLES                        
                 THRU 5020-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT442-RECORD FROM WS03-SUMMARY-LINE1                  
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           ADD 1                         TO WS05-R1-SUM-LINE-CTR        
                                                                        
           ADD WS05-R1-RR-TOT-CUSTOMERS TO WS05-R1-RG-TOT-CUSTOMERS     
           ADD WS05-R1-RR-TOT-ACCOUNTS  TO WS05-R1-RG-TOT-ACCOUNTS      
           ADD WS05-R1-RR-ACCT-DEP      TO WS05-R1-RG-ACCT-DEP          
           ADD WS05-R1-RR-TOT-AR-BAL    TO WS05-R1-RG-TOT-AR-BAL        
           ADD WS05-R1-RR-RESERVE-AMT   TO WS05-R1-RG-RESERVE-AMT       
           ADD WS05-R1-RR-12-MONTH-REV  TO WS05-R1-RG-12-MONTH-REV      
                                                                        
           IF E-FRP440-GROUP-SEQ-NO NOT = WS05-R1-PREV-GROUP-SEQ-NO     
              PERFORM 3200-PRINT-R1-GROUP-TOTALS THRU 3200-EXIT         
           END-IF                                                       
                                                                        
           INITIALIZE WS05-R1-RISK-RATING-TOTALS.                       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3110-PRINT-R2-RATING-TOTALS.   (2ND REPORT)             *               
      *                                                         *               
      *      THIS PRINTS THE TOTAL LINES FOR THE RISK RATINGS   *               
      * ON THE DETAIL AND SUMMARY REPORT                        *               
      *      IT ALSO CHECKS TO SEE IF THERE IS A CHANGE IN THE  *               
      * RISK RATING GROUP.  IF SO, THAT SUBTOTAL IS WRTITEN OUT *               
      * TO THE SUMMARY REPORT.                                  *               
      ***********************************************************               
       3110-PRINT-R2-RATING-TOTALS.                                     
                                                                        
           MOVE '3110'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS05-R2-DTL-LINE-CTR GREATER THAN 60                      
              PERFORM 5010-WRITE-FCSRP443-TITLES                        
                 THRU 5010-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE  WS05-R2-RR-TOT-CUSTOMERS TO WS03-CUST-TOT-RATING       
           WRITE PRT443-RECORD FROM WS03-DETAIL-LINE4                   
                    AFTER ADVANCING 2 LINE.                             
                                                                        
           MOVE  WS05-R2-RR-TOT-ACCOUNTS  TO WS03-ACCT-TOT-RATING       
           WRITE PRT443-RECORD FROM WS03-DETAIL-LINE5                   
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           MOVE 65 TO WS05-R2-DTL-LINE-CTR                              
                                                                        
      * WRITE OUT SUMMARY REPORT DETAIL LINE                                    
           IF WS05-R1-PREV-RISK-RATING = SPACES                         
              MOVE 'ERROR' TO WS03-RR-RISK-RATING                       
           ELSE                                                         
              MOVE WS05-R2-PREV-RISK-RATING TO WS03-RR-RISK-RATING      
           END-IF                                                       
           MOVE WS05-R2-RR-TOT-CUSTOMERS TO WS03-RR-NUM-CUSTOMERS       
           MOVE WS05-R2-RR-TOT-ACCOUNTS  TO WS03-RR-NUM-ACCOUNTS        
           MOVE WS05-R2-RR-ACCT-DEP      TO WS03-RR-CUST-DEPOSITS       
           MOVE WS05-R2-RR-TOT-AR-BAL    TO WS03-RR-TOT-AR-BALANCE      
           MOVE WS05-R2-RR-RESERVE-AMT   TO WS03-RR-RESERVE             
           MOVE WS05-R2-RR-12-MONTH-REV  TO WS03-RR-12-MO-REVENUE       
                                                                        
           IF WS05-R2-SUM-LINE-CTR GREATER THAN 62                      
              PERFORM 5030-WRITE-FCSRP444-TITLES                        
                 THRU 5030-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT444-RECORD FROM WS03-SUMMARY-LINE1                  
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           ADD 1                        TO WS05-R2-SUM-LINE-CTR         
                                                                        
           ADD WS05-R2-RR-TOT-CUSTOMERS TO WS05-R2-RG-TOT-CUSTOMERS     
           ADD WS05-R2-RR-TOT-ACCOUNTS  TO WS05-R2-RG-TOT-ACCOUNTS      
           ADD WS05-R2-RR-ACCT-DEP      TO WS05-R2-RG-ACCT-DEP          
           ADD WS05-R2-RR-TOT-AR-BAL    TO WS05-R2-RG-TOT-AR-BAL        
           ADD WS05-R2-RR-RESERVE-AMT   TO WS05-R2-RG-RESERVE-AMT       
           ADD WS05-R2-RR-12-MONTH-REV  TO WS05-R2-RG-12-MONTH-REV      
                                                                        
           IF E-FRP440-GROUP-SEQ-NO NOT = WS05-R2-PREV-GROUP-SEQ-NO     
              PERFORM 3220-PRINT-R2-GROUP-TOTALS THRU 3220-EXIT         
           END-IF                                                       
                                                                        
           INITIALIZE WS05-R2-RISK-RATING-TOTALS.                       
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3200-PRINT-R1-GROUP-TOTALS.    (1ST REPORT)             *               
      *     PRINT OUT THE GROUP TOTAL LINE FOR THE SUMMARY RPT  *               
      ***********************************************************               
       3200-PRINT-R1-GROUP-TOTALS.                                      
                                                                        
           MOVE WS05-R1-RG-TOT-CUSTOMERS TO WS03-RG-NUM-CUSTOMERS       
           MOVE WS05-R1-RG-TOT-ACCOUNTS  TO WS03-RG-NUM-ACCOUNTS        
           MOVE WS05-R1-RG-ACCT-DEP      TO WS03-RG-CUST-DEPOSITS       
           MOVE WS05-R1-RG-TOT-AR-BAL    TO WS03-RG-TOT-AR-BALANCE      
           MOVE WS05-R1-RG-RESERVE-AMT   TO WS03-RG-RESERVE             
           MOVE WS05-R1-RG-12-MONTH-REV  TO WS03-RG-12-MO-REVENUE       
                                                                        
           IF WS05-R1-SUM-LINE-CTR GREATER THAN 61                      
              PERFORM 5020-WRITE-FCSRP442-TITLES                        
                 THRU 5020-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT442-RECORD FROM WS03-SUMMARY-LINE2                  
                    AFTER ADVANCING 1 LINE.                             
                                                                        
           WRITE PRT442-RECORD FROM WS03-SUMMARY-LINE3                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT442-RECORD FROM WS03-BLANK-LINE                     
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           ADD 4 TO WS05-R1-SUM-LINE-CTR.                               
                                                                        
           ADD WS05-R1-RG-TOT-CUSTOMERS TO WS05-R1-GT-TOT-CUSTOMERS     
           ADD WS05-R1-RG-TOT-ACCOUNTS  TO WS05-R1-GT-TOT-ACCOUNTS      
           ADD WS05-R1-RG-ACCT-DEP      TO WS05-R1-GT-ACCT-DEP          
           ADD WS05-R1-RG-TOT-AR-BAL    TO WS05-R1-GT-TOT-AR-BAL        
           ADD WS05-R1-RG-RESERVE-AMT   TO WS05-R1-GT-RESERVE-AMT       
           ADD WS05-R1-RG-12-MONTH-REV  TO WS05-R1-GT-12-MONTH-REV      
                                                                        
           MOVE E-FRP440-GROUP-SEQ-NO   TO WS05-R1-PREV-GROUP-SEQ-NO    
           INITIALIZE WS05-R1-RISK-GROUP-TOTALS.                        
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3220-PRINT-R2-GROUP-TOTALS.    (2ND REPORT)             *               
      *     PRINT OUT THE GROUP TOTAL LINE FOR THE SUMMARY RPT  *               
      ***********************************************************               
       3220-PRINT-R2-GROUP-TOTALS.                                      
                                                                        
           MOVE WS05-R2-RG-TOT-CUSTOMERS TO WS03-RG-NUM-CUSTOMERS       
           MOVE WS05-R2-RG-TOT-ACCOUNTS  TO WS03-RG-NUM-ACCOUNTS        
           MOVE WS05-R2-RG-ACCT-DEP      TO WS03-RG-CUST-DEPOSITS       
           MOVE WS05-R2-RG-TOT-AR-BAL    TO WS03-RG-TOT-AR-BALANCE      
           MOVE WS05-R2-RG-RESERVE-AMT   TO WS03-RG-RESERVE             
           MOVE WS05-R2-RG-12-MONTH-REV  TO WS03-RG-12-MO-REVENUE       
                                                                        
           IF WS05-R2-SUM-LINE-CTR GREATER THAN 60                      
              PERFORM 5030-WRITE-FCSRP444-TITLES                        
                 THRU 5030-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT444-RECORD FROM WS03-SUMMARY-LINE2                  
                    AFTER ADVANCING 1 LINE.                             
                                                                        
           WRITE PRT444-RECORD FROM WS03-SUMMARY-LINE3                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT444-RECORD FROM WS03-BLANK-LINE                     
                    AFTER ADVANCING 1 LINES.                            
                                                                        
           ADD 4 TO WS05-R2-SUM-LINE-CTR.                               
                                                                        
           ADD WS05-R2-RG-TOT-CUSTOMERS TO WS05-R2-GT-TOT-CUSTOMERS     
           ADD WS05-R2-RG-TOT-ACCOUNTS  TO WS05-R2-GT-TOT-ACCOUNTS      
           ADD WS05-R2-RG-ACCT-DEP      TO WS05-R2-GT-ACCT-DEP          
           ADD WS05-R2-RG-TOT-AR-BAL    TO WS05-R2-GT-TOT-AR-BAL        
           ADD WS05-R2-RG-RESERVE-AMT   TO WS05-R2-GT-RESERVE-AMT       
           ADD WS05-R2-RG-12-MONTH-REV  TO WS05-R2-GT-12-MONTH-REV      
                                                                        
           MOVE E-FRP440-GROUP-SEQ-NO   TO WS05-R2-PREV-GROUP-SEQ-NO    
           INITIALIZE WS05-R2-RISK-GROUP-TOTALS.                        
                                                                        
       3220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3300-PRINT-R1-GRAND-TOTALS.    (1ST REPORT)             *               
      *     PRINT OUT THE GRAND TOTAL LINE FOR THE SUMMARY RPT  *               
      ***********************************************************               
       3300-PRINT-R1-GRAND-TOTALS.                                      
                                                                        
           MOVE WS05-R1-GT-TOT-CUSTOMERS TO WS03-GT-NUM-CUSTOMERS       
           MOVE WS05-R1-GT-TOT-ACCOUNTS  TO WS03-GT-NUM-ACCOUNTS        
           MOVE WS05-R1-GT-ACCT-DEP      TO WS03-GT-CUST-DEPOSITS       
           MOVE WS05-R1-GT-TOT-AR-BAL    TO WS03-GT-TOT-AR-BALANCE      
           MOVE WS05-R1-GT-RESERVE-AMT   TO WS03-GT-RESERVE             
           MOVE WS05-R1-GT-12-MONTH-REV  TO WS03-GT-12-MO-REVENUE       
                                                                        
           IF WS05-R1-SUM-LINE-CTR GREATER THAN 61                      
              PERFORM 5020-WRITE-FCSRP442-TITLES                        
                 THRU 5020-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT442-RECORD FROM WS03-SUMMARY-LINE4                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT442-RECORD FROM WS03-END-DATA-LINE                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT441-RECORD FROM WS03-END-DATA-LINE                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 3320-PRINT-R2-GRAND-TOTALS.    (2ND REPORT)             *               
      *     PRINT OUT THE GRAND TOTAL LINE FOR THE SUMMARY RPT  *               
      ***********************************************************               
       3320-PRINT-R2-GRAND-TOTALS.                                      
                                                                        
           MOVE WS05-R2-GT-TOT-CUSTOMERS TO WS03-GT-NUM-CUSTOMERS       
           MOVE WS05-R2-GT-TOT-ACCOUNTS  TO WS03-GT-NUM-ACCOUNTS        
           MOVE WS05-R2-GT-ACCT-DEP      TO WS03-GT-CUST-DEPOSITS       
           MOVE WS05-R2-GT-TOT-AR-BAL    TO WS03-GT-TOT-AR-BALANCE      
           MOVE WS05-R2-GT-RESERVE-AMT   TO WS03-GT-RESERVE             
           MOVE WS05-R2-GT-12-MONTH-REV  TO WS03-GT-12-MO-REVENUE       
                                                                        
           IF WS05-R2-SUM-LINE-CTR GREATER THAN 61                      
              PERFORM 5030-WRITE-FCSRP444-TITLES                        
                 THRU 5030-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT444-RECORD FROM WS03-SUMMARY-LINE4                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT444-RECORD FROM WS03-END-DATA-LINE                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
           WRITE PRT443-RECORD FROM WS03-END-DATA-LINE                  
                    AFTER ADVANCING 2 LINES.                            
                                                                        
       3320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5000-WRITE-FCSRP441-TITLES                                   *         
      *                                                               *         
      *   THIS PARAGRAPH: WRITE THE TITLES OUT FOR 1ST REPORT DETAIL  *         
      *                                                               *         
      *****************************************************************         
       5000-WRITE-FCSRP441-TITLES.                                      
                                                                        
           MOVE '5000'                TO ACTIVE-PARAGRAPH.              
                                                                        
           ADD  1                     TO WS05-R1-DET-PAGE-NUM.          
           IF WS-SYSIN-COMP = 'SEB '                                    
              MOVE 'SEBR440-PCSRP4401'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           ELSE                                                         
              MOVE 'CSRR440-PCSRP4401'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           END-IF                                                       
           MOVE WS05-R1-DET-PAGE-NUM  TO WS02-T3A-PAGE-NUM.             
                                                                        
           IF WS-SYSIN-COMP = 'SCEG'                                    
              WRITE PRT441-RECORD FROM WS02-TITLE1A                     
                    AFTER ADVANCING PAGE                                
           ELSE                                                         
              WRITE PRT441-RECORD FROM WS02-TITLE1B                     
                    AFTER ADVANCING PAGE                                
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS02-TITLE2A                        
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT441-RECORD FROM WS02-TITLE3A-DETAIL                 
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT441-RECORD FROM WS02-TITLE4                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE  E-FRP440-RISK-RATING TO WS02-TITLE5-RISK-RATING        
           IF E-FRP440-RISK-RATING = SPACES                             
              MOVE 'ERROR' TO WS02-TITLE5-RISK-RATING                   
           END-IF                                                       
           WRITE PRT441-RECORD FROM WS02-TITLE5                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MULTIPLY E-FRP440-RESERVE-PERCENT BY 100                     
                 GIVING WS02-TITLE6-RESERVE-PCT                         
           WRITE PRT441-RECORD FROM WS02-TITLE6                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           IF SW01-HEADING-YES                                          
              WRITE PRT441-RECORD FROM WS02-DETAIL-HEADER1              
                    AFTER ADVANCING 2 LINE                              
              WRITE PRT441-RECORD FROM WS02-DETAIL-HEADER2              
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT441-RECORD FROM WS03-BLANK-LINE                  
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
                                                                        
           MOVE  10                   TO WS05-R1-DTL-LINE-CTR.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5010-WRITE-FCSRP443-TITLES                                   *         
      *                                                               *         
      *   THIS PARAGRAPH: WRITE THE TITLES OUT FOR 2ND REPORT DETAIL  *         
      *                                                               *         
      *****************************************************************         
       5010-WRITE-FCSRP443-TITLES.                                      
                                                                        
           MOVE '5010'                TO ACTIVE-PARAGRAPH.              
                                                                        
           ADD  1                     TO WS05-R2-DET-PAGE-NUM.          
           IF WS-SYSIN-COMP = 'SEB '                                    
              MOVE 'SEBR440-PCSRP4403'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           ELSE                                                         
              MOVE 'CSRR440-PCSRP4403'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           END-IF                                                       
           MOVE WS05-R2-DET-PAGE-NUM  TO WS02-T3A-PAGE-NUM.             
                                                                        
           IF WS-SYSIN-COMP = 'SCEG'                                    
              WRITE PRT443-RECORD FROM WS02-TITLE1A                     
                    AFTER ADVANCING PAGE                                
           ELSE                                                         
              WRITE PRT443-RECORD FROM WS02-TITLE1B                     
                    AFTER ADVANCING PAGE                                
           END-IF.                                                      
                                                                        
           WRITE PRT443-RECORD FROM WS02-TITLE2B                        
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT443-RECORD FROM WS02-TITLE3A-DETAIL                 
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT443-RECORD FROM WS02-TITLE4                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE  E-FRP440-RISK-RATING TO WS02-TITLE5-RISK-RATING        
           IF E-FRP440-RISK-RATING = SPACES                             
              MOVE 'ERROR' TO WS02-TITLE5-RISK-RATING                   
           END-IF                                                       
           WRITE PRT443-RECORD FROM WS02-TITLE5                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MULTIPLY E-FRP440-RESERVE-PERCENT BY 100                     
                 GIVING WS02-TITLE6-RESERVE-PCT                         
           WRITE PRT443-RECORD FROM WS02-TITLE6                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           IF SW01-HEADING-YES                                          
              WRITE PRT443-RECORD FROM WS02-DETAIL-HEADER1              
                    AFTER ADVANCING 2 LINE                              
              WRITE PRT443-RECORD FROM WS02-DETAIL-HEADER2              
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT443-RECORD FROM WS03-BLANK-LINE                  
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
                                                                        
           MOVE  10                   TO WS05-R2-DTL-LINE-CTR.          
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5020-WRITE-FCSRP442-TITLES                                   *         
      *                                                               *         
      *   THIS PARAGRAPH: WRITE THE TITLES OUT FOR 1ST REPORT SUMMARY *         
      *                                                               *         
      *****************************************************************         
       5020-WRITE-FCSRP442-TITLES.                                      
                                                                        
           MOVE '5020'                TO ACTIVE-PARAGRAPH.              
                                                                        
           ADD  1                     TO WS05-R1-SUM-PAGE-NUM.          
           IF WS-SYSIN-COMP = 'SEB '                                    
              MOVE 'SEBR440-PCSRP4402'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           ELSE                                                         
              MOVE 'CSRR440-PCSRP4402'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           END-IF                                                       
           MOVE WS05-R1-SUM-PAGE-NUM  TO WS02-T3B-PAGE-NUM.             
                                                                        
           IF WS-SYSIN-COMP = 'SCEG'                                    
              WRITE PRT442-RECORD FROM WS02-TITLE1A                     
                    AFTER ADVANCING PAGE                                
           ELSE                                                         
              WRITE PRT442-RECORD FROM WS02-TITLE1B                     
                    AFTER ADVANCING PAGE                                
           END-IF.                                                      
                                                                        
           WRITE PRT442-RECORD FROM WS02-TITLE2A                        
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT442-RECORD FROM WS02-TITLE3B-SUMMARY                
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT442-RECORD FROM WS02-TITLE4                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           IF SW01-HEADING-YES                                          
              WRITE PRT442-RECORD FROM WS02-SUMMARY-HEADER1             
                    AFTER ADVANCING 2 LINE                              
              WRITE PRT442-RECORD FROM WS02-SUMMARY-HEADER2             
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT442-RECORD FROM WS03-BLANK-LINE                  
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
                                                                        
           MOVE  08                   TO WS05-R1-SUM-LINE-CTR.          
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5030-WRITE-FCSRP444-TITLES                                   *         
      *                                                               *         
      *   THIS PARAGRAPH: WRITE THE TITLES OUT FOR 2ND REPORT SUMMARY *         
      *                                                               *         
      *****************************************************************         
       5030-WRITE-FCSRP444-TITLES.                                      
                                                                        
           MOVE '5030'                TO ACTIVE-PARAGRAPH.              
                                                                        
           ADD  1                     TO WS05-R2-SUM-PAGE-NUM.          
           IF WS-SYSIN-COMP = 'SEB '                                    
              MOVE 'SEBR440-PCSRP4404'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           ELSE                                                         
              MOVE 'CSRR440-PCSRP4404'   TO WS02-T1A-REPTNAME           
                                            WS02-T1B-REPTNAME           
           END-IF                                                       
           MOVE WS05-R2-SUM-PAGE-NUM  TO WS02-T3B-PAGE-NUM.             
                                                                        
           IF WS-SYSIN-COMP = 'SCEG'                                    
              WRITE PRT444-RECORD FROM WS02-TITLE1A                     
                    AFTER ADVANCING PAGE                                
           ELSE                                                         
              WRITE PRT444-RECORD FROM WS02-TITLE1B                     
                    AFTER ADVANCING PAGE                                
           END-IF.                                                      
                                                                        
           WRITE PRT444-RECORD FROM WS02-TITLE2B                        
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT444-RECORD FROM WS02-TITLE3B-SUMMARY                
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT444-RECORD FROM WS02-TITLE4                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           IF SW01-HEADING-YES                                          
              WRITE PRT444-RECORD FROM WS02-SUMMARY-HEADER1             
                    AFTER ADVANCING 2 LINE                              
              WRITE PRT444-RECORD FROM WS02-SUMMARY-HEADER2             
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT444-RECORD FROM WS03-BLANK-LINE                  
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
                                                                        
           MOVE  08                   TO WS05-R2-SUM-LINE-CTR.          
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5100-WRITE-PCSRP441-DETAIL                                   *         
      *                                                               *         
      *   THIS PARAGRAPH:                                             *         
      *                                                               *         
      *****************************************************************         
       5100-WRITE-FCSRP441-DETAIL.                                      
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS05-R1-DTL-LINE-CTR GREATER THAN 64                      
              PERFORM 5000-WRITE-FCSRP441-TITLES                        
                 THRU 5000-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS03-DETAIL-LINE1                   
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           ADD  1     TO WS05-R1-DTL-LINE-CTR.                          
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  5110-WRITE-PCSRP443-DETAIL                                   *         
      *                                                               *         
      *   THIS PARAGRAPH:                                             *         
      *                                                               *         
      *****************************************************************         
       5110-WRITE-FCSRP443-DETAIL.                                      
                                                                        
           MOVE '5110' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS05-R2-DTL-LINE-CTR GREATER THAN 64                      
              PERFORM 5010-WRITE-FCSRP443-TITLES                        
                 THRU 5010-EXIT                                         
           END-IF.                                                      
                                                                        
           WRITE PRT443-RECORD FROM WS03-DETAIL-LINE1                   
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           ADD  1     TO WS05-R1-DTL-LINE-CTR.                          
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * 5200-NO-SCEG-REPORT.                                  *                 
      *      PRINTS NO DATA REPORTS FOR ALL 4 SCEG REPORTS    *                 
      *      2 DETAIL AND 2 SUMMARY                           *                 
      *********************************************************                 
       5200-NO-SCEG-REPORT.                                             
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE 65 TO WS05-R1-DTL-LINE-CTR                              
           MOVE 'S C ELECTRIC & GAS CO ' TO WS02-T1A-COMP-NAME.         
                                                                        
           MOVE ZEROS                 TO WS02-T3A-PAGE-NUM.             
           IF WS05-R1-DTL-LINE-CTR GREATER THAN 55                      
              PERFORM 5000-WRITE-FCSRP441-TITLES THRU 5000-EXIT         
              PERFORM 5020-WRITE-FCSRP442-TITLES THRU 5020-EXIT         
              PERFORM 5010-WRITE-FCSRP443-TITLES THRU 5010-EXIT         
              PERFORM 5030-WRITE-FCSRP444-TITLES THRU 5030-EXIT         
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS03-NO-FILE-LINE                   
                AFTER ADVANCING 10 LINES.                               
           WRITE PRT442-RECORD FROM WS03-NO-FILE-LINE                   
                AFTER ADVANCING 10 LINES.                               
           WRITE PRT443-RECORD FROM WS03-NO-FILE-LINE                   
                AFTER ADVANCING 10 LINES.                               
           WRITE PRT444-RECORD FROM WS03-NO-FILE-LINE                   
                AFTER ADVANCING 10 LINES.                               
                                                                        
       5200-EXIT.                                                       
                                                                        
      *********************************************************                 
      * 5210-NO-PSNC-REPORT.                                  *                 
      *      PRINTS NO DATA REPORTS FOR ALL 2 PSNC REPORTS    *                 
      *      1 DETAIL AND 1 SUMMARY                           *                 
      *********************************************************                 
       5210-NO-PSNC-REPORT.                                             
                                                                        
           MOVE '5210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE ZEROS                 TO WS02-T3A-PAGE-NUM.             
           MOVE 65 TO WS05-R1-DTL-LINE-CTR                              
           MOVE 'PSNC ENERGY           ' TO WS02-T1B-COMP-NAME.         
                                                                        
           IF WS05-R1-DTL-LINE-CTR GREATER THAN 55                      
              PERFORM 5000-WRITE-FCSRP441-TITLES THRU 5000-EXIT         
              PERFORM 5020-WRITE-FCSRP442-TITLES THRU 5020-EXIT         
              PERFORM 5010-WRITE-FCSRP443-TITLES THRU 5010-EXIT         
              PERFORM 5030-WRITE-FCSRP444-TITLES THRU 5030-EXIT         
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS03-NO-FILE-LINE                   
           WRITE PRT442-RECORD FROM WS03-NO-FILE-LINE                   
                 AFTER ADVANCING 10 LINES.                              
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * 5220-NO-SEB-REPORT.                                   *                 
      *      PRINTS NO DATA REPORTS FOR ALL 2 SEB  REPORTS    *                 
      *      1 DETAIL AND 1 SUMMARY                           *                 
      *********************************************************                 
       5220-NO-SEB-REPORT.                                              
                                                                        
           MOVE '5220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE ZEROS                 TO WS02-T3A-PAGE-NUM.             
           MOVE 65 TO WS05-R1-DTL-LINE-CTR                              
           MOVE 'SCANA ENERGY          ' TO WS02-T1B-COMP-NAME.         
                                                                        
           IF WS05-R1-DTL-LINE-CTR GREATER THAN 55                      
              PERFORM 5000-WRITE-FCSRP441-TITLES THRU 5000-EXIT         
              PERFORM 5020-WRITE-FCSRP442-TITLES THRU 5020-EXIT         
              PERFORM 5010-WRITE-FCSRP443-TITLES THRU 5010-EXIT         
              PERFORM 5030-WRITE-FCSRP444-TITLES THRU 5030-EXIT         
           END-IF.                                                      
                                                                        
           WRITE PRT441-RECORD FROM WS03-NO-FILE-LINE                   
           WRITE PRT442-RECORD FROM WS03-NO-FILE-LINE                   
                 AFTER ADVANCING 10 LINES.                              
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  6200-GET-PARAMETER-DATE                                                
      *  COPY MEMBER TO READ JOB PARM & OBTAIN MONTH AND YEAR.          19590000
      *****************************************************************         
      *                                                                 19590000
           EXEC SQL                                                     19620000
              INCLUDE CPD00114                                          19630000
           END-EXEC.                                                    19640000
      *                                                                 19590000
      *****************************************************************         
      *  6240-GET-FCA00-COMMON-DATE                                             
      *****************************************************************         
      *                                                                 19590000
           EXEC SQL                                                     19620000
              INCLUDE CPD00040                                          19630000
           END-EXEC.                                                    19640000
      *                                                                 19590000
      *****************************************************************         
      *  6251-GET-FJC01-DATE                                          *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00037, WHICH CONTAINS THE DB2 STATEMENTS  *         
      *         NECESSARY TO RETRIEVE PARMS FROM TABLE CSS_JOB_PARM   *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7000-READ-FCSFA440                                           *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *                                                               *         
      *****************************************************************         
       7000-READ-FCSFA440.                                              
                                                                        
           MOVE '7000'              TO ACTIVE-PARAGRAPH.                
                                                                        
           READ FCSFA440-FILE AT END                                    
                SET FCSFA440-END-REC-PROCESSED TO TRUE.                 
                                                                        
           IF FCSFA440-SUCCESSFUL OR FCSFA440-END-REC-PROCESSED         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**     PCSRP440 PROCESSING ERROR    **'         
               DISPLAY '**       ERROR READING FCSFA440     **'         
               DISPLAY '**      FILE STATUS = ' WS-FFA440-STATUS        
               DISPLAY '**       PROCESSING TERMINATED      **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-DEL-VALUE.                                              
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
               INTO   :C8-DELINQ-VALUE                                  
               FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD   = :C8-DELINQ-CD                       
               AND    COMPANY_NO  = :C8-COMPANY-NO                      
T35434                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*        INTO   :C8-DELINQ-VALUE                                          
MFA-TR*        FROM   CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD   = :C8-DELINQ-CD                               
MFA-TR*        AND    COMPANY_NO  = :C8-COMPANY-NO                              
MFA-TR*        WITH   UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE 'PCSRP440'          TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
              MOVE 'DELINQ_CD'         TO TABLE-ELEMENT-1               
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-3               
              MOVE C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1             
              MOVE C8-COMPANY-NO       TO HOSTVAR-ELEMENT-3             
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *  7600-START-FCSJC01                                           *         
      *  7610-READ-FCSJC01                                            *         
      *  7611-CLOSE                                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00038, WHICH DECLARES, OPENS, FETCHES     *         
      *         AND CLOSES CURSOR TO CSS_JOB_PARM                     *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      * CPD00039   S T A R T   A N D   R E A D   F C S C A 0 0     *            
      * 7620-START-FCSCA00                                         *            
      * 7621-READ-FCSCA00                                          *            
      * 7622-CLOSE-CA00-CSR                                        *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  9000-TERMINATE                                               *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) CLOSES THE INPUT AND OUTPUT FILES                     *         
      *                                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           MOVE '9000'              TO ACTIVE-PARAGRAPH.                
                                                                        
           CLOSE FCSFA440-FILE.                                         
                                                                        
           CLOSE FCSPT441-FILE.                                         
           CLOSE FCSPT442-FILE.                                         
           CLOSE FCSPT443-FILE.                                         
           CLOSE FCSPT444-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  9900-ABEND                                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          *         
      *         PROCESSING PARAGRAPH                                  *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
                                                                        
