       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP439.                                            
       AUTHOR. PRIYA.                                                   
       DATE-WRITTEN. AUG-10.                                            
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                ***         
      **                                                             **         
      *****************************************************************         
      ********         CUSTOMER INFORMATION SYSTEM            *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS              REASON                 **         
      **   08-06-2010   PRIYA                 NEW REPORT PROGRAM     **         
A02221**   10-07-2010   MS93554               CIG VOLUME REPORT -    **         
      **                A02221-07             ADDED PARM_END_DATE IN **         
      **                                      MAIN CURSOR TO AVOID   **         
      **                                      DUPLICATES RECORS.     **         
      *****************************************************************         
            REMARKS.                                                    
      *****************************************************************         
      *        REPORT GENERATOR FOR PCSRP439 REPORTS                  *         
      *        THIS IS A NEW PROGRAM WRITTEN FOR GENERATING LIST OF   *         
      *        COG DAILY VOLUMES CUSTOMERS FOR THE PRIOR MONTH TO THE *         
      *        CURRENT PERIOD.                                        *         
      *                                                               *         
      *        INPUT FOR THIS PROGRAM IS FROM THE FOLLOWING TABLES    *         
      *        1. CSS_ACCOUNT                                         *         
      *        2. CSS_UTIL_ENVRNMT                                    *         
      *        3. CSS_BILLING_DET                                     *         
      *        4. CSS_CNSMPTN_HIST                                    *         
      *        5. CSS_MTRD_ENVRNMT                                    *         
      *        6. CSS_PRTY_SVC_CAT                                    *         
      *        7. CSS_BILL_CONTRACT                                   *         
      *        8. CSS_RATE_COMP_DEF                                   *         
      *        9. CSS_RATE_COMPONENT                                  *         
      *                                                               *         
      *        THIS IS A DAILY REPORT                                 *         
       **************************************************************** 
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * COPY BOOK FOR REPORT FILE                                               
       COPY CSSPT331.                                                           
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      * COPY BOOKS FOR WORK FILE AND THE OUTPUT FILE USED                       
      * COPY BOOK FOR REPORT FILE                                               
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT331-RECORD                       PIC X(146).              
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP439'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP439 STARTS HERE'.                  
                                                                        
       COPY FIORP439.                                                           
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE             
               'PCSRP439'.                                              
           05  WS-ERR-MSG                  PIC X(50)  VALUE SPACES.     
           05  WS-DISP-RC                  PIC -ZZZZZZZZ9.9.            
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSRP439'. 
           05  WS-PGRNAME                  PIC X(08)  VALUE 'PCSRP439'. 
           05  WS-CUST-NAME                PIC X(46)  VALUE SPACES.     
           05  WS-FULL-NAME                PIC X(50)  VALUE SPACES.     
           05  WS-MCF-CALCULATE            PIC S9(9)V9(2) USAGE COMP-3  
                                                      VALUE ZERO.       
           05  WS-DTHS-CALCULATE           PIC S9(9)V9(1) USAGE COMP-3  
                                                      VALUE ZERO.       
           05  WS-PREVIOUS-ACCT-NO         PIC 9(13)  VALUE ZERO.       
      *                                                                         
       01  WS-REV-MTH.                                                  
           05  WS-REV-CCYY                 PIC 9(04).                   
           05  WS-REV-MM                   PIC 9(02).                   
      *                                                                         
       01  WS-INPUT-BEG-DT-DATA.                                        
           05  WS-PARM-BEG-DT-HDR          PIC X(11).                   
           05  WS-PARM-START-DATE          PIC X(10) VALUE SPACES.      
           05  FILLER                      PIC X(59).                   
      *                                                                         
       01  WS-INPUT-END-DT-DATA.                                        
           05  WS-PARM-END-DT-HDR          PIC X(09).                   
           05  WS-PARM-END-DATE            PIC X(10) VALUE SPACES.      
           05  FILLER                      PIC X(61).                   
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)  VALUE 'Y'.          
           05 WS-N                       PIC X(01)  VALUE 'N'.          
      *                                                                         
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
       01 WS-RPT1-HEADER.                                               
          05 WS-ACCOUNT-NO-HEADER    PIC X(12) VALUE                    
             'ACCOUNT-NO  '.                                            
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-METER-NO-HEADER      PIC X(09) VALUE                    
             'METER-NO'.                                                
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-IC-NO-HEADER         PIC X(06) VALUE                    
             'ICNO'.                                                    
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-GAS-DAY-HEADER       PIC X(10) VALUE                    
             'GAS-DAYS'.                                                
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-ACCOUNT-NAME-HEADER  PIC X(13) VALUE                    
             'CUSTOMER-NAME'.                                           
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-MCF-HEADER           PIC X(09) VALUE                    
             'MCF-UNITS'.                                               
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-BTU-HEADER           PIC X(08) VALUE                    
             'BTU-FCTR'.                                                
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-DTH-HEADER           PIC X(10) VALUE                    
             'DEKATHERMS'.                                              
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-RATE-PLAN-NO-HEADER  PIC X(09) VALUE                    
             'RATE-PLAN'.                                               
          05 FILLER                  PIC X(01) VALUE ','.               
          05 WS-INDUST-BTU-ID-HEADER PIC X(06) VALUE                    
             'BTU-ID'.                                                  
          05 FILLER                    PIC X(01) VALUE ','.             
          05 WS-PRTY-SVC-CAT-CD-HEADER PIC X(08) VALUE                  
             'CATEGORY'.                                                
          05 FILLER                    PIC X(01) VALUE ','.             
          05 WS-CONTRACT-DEMAND-HEADER PIC X(20) VALUE                  
             'MDQ/CONTRACT DEMAND'.                                     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA331-STATUS               PIC X(02).                
               88 FPT133-SUCCESSFUL           VALUE '00'.               
           05  WS-NOTWRITE-HEADER-SW          PIC X(01) VALUE 'Y'.      
               88 WRITE-HEADER-REPT                     VALUE 'Y'.      
      *                                                                         
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
      /*****   WS AREA FOR REPORTDATE REVENUE MONTH                             
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00011.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT - AT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CONTRACT- BK                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCNTR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_RATE_COMPONENT  N6                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRTCPNT                                                
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PRTY_SVC_CAT - Z4                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBSVCCAT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT - UT                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RATE_COMP_DEF - J1                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCDEF                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILLING_DET - BG                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_MTRD_ENVRNMT - MN                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_CNSMPTN_HIST - CX                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM - G6                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME - DQ                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_CUSTOMER - CU                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * GAS_CUSTOMER CURSOR FOR FETCHING ALL THE GAS CUSTOMERS        *         
      * FROM CSS_UTIL_ENVRNMT,CSS_RATE_COMP_DEF TABLES                *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
              DECLARE CIG_CUSTOMER CURSOR FOR                           
                 SELECT UT.ACCOUNT_NO                                   
                       ,UT.IC_NO                                        
                       ,UT.RATE_PLAN_NO                                 
                       ,Z4.PRTY_SVC_CAT_CD                              
                       ,BK.CONTRACT_DEMAND                              
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                       ,CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)               
                       ,CSS_BILL_CONTRACT  BK WITH(READUNCOMMITTED)             
                 WHERE AT.ACCOUNT_NO       =  UT.ACCOUNT_NO             
                  AND  AT.CODE_ACCT_STAT   =  'A'                       
                  AND  UT.CODE_UTIL_TYPE   =  'G'                       
                  AND  AT.COMPANY_NO       =  UT.COMPANY_NO             
                  AND  AT.COMPANY_NO       =  '01'                      
                  AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY     
                  AND  UT.COMPANY_NO        =  Z4.COMPANY_NO            
                  AND  UT.ACCOUNT_NO       =   BK.ACCOUNT_NO            
                  AND  UT.CODE_UTIL_TYPE   =   BK.CODE_UTIL_TYPE        
                  AND  UT.IC_NO            =   BK.IC_NO                 
A02221            AND  BK.CNTRCT_START_DT <=  IIF(TRY_CONVERT(DATE, 
                                                      :WS-PARM-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-END-DATE
              ) <> 0) OR (LEN(:WS-PARM-END-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PARM-END-DATE
              ), CONVERT(DATE, :WS-PARM-END-DATE) )         
A02221            AND  BK.CNTRCT_END_DT   >=  IIF(TRY_CONVERT(DATE, 
                                                      :WS-PARM-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-END-DATE
              ) <> 0) OR (LEN(:WS-PARM-END-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PARM-END-DATE
              ), CONVERT(DATE, :WS-PARM-END-DATE) )         
                  AND  EXISTS                                           
                       (SELECT 1                                        
                          FROM  CSS_RATE_COMP_DEF J1
                           WITH(READUNCOMMITTED)                    
                          WHERE  J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO    
                           AND  J1.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE  
                           AND  J1.REG_TYPE_CD     = 'D')               
                 ORDER BY UT.ACCOUNT_NO, UT.IC_NO, Z4.PRTY_SVC_CAT_CD   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CIG_CUSTOMER CURSOR FOR                                   
MFA-TR*          SELECT UT.ACCOUNT_NO                                           
MFA-TR*                ,UT.IC_NO                                                
MFA-TR*                ,UT.RATE_PLAN_NO                                         
MFA-TR*                ,Z4.PRTY_SVC_CAT_CD                                      
MFA-TR*                ,BK.CONTRACT_DEMAND                                      
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_PRTY_SVC_CAT Z4                                     
MFA-TR*                ,CSS_BILL_CONTRACT  BK                                   
MFA-TR*          WHERE AT.ACCOUNT_NO       =  UT.ACCOUNT_NO                     
MFA-TR*           AND  AT.CODE_ACCT_STAT   =  'A'                               
MFA-TR*           AND  UT.CODE_UTIL_TYPE   =  'G'                               
MFA-TR*           AND  AT.COMPANY_NO       =  UT.COMPANY_NO                     
MFA-TR*           AND  AT.COMPANY_NO       =  '01'                              
MFA-TR*           AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY             
MFA-TR*           AND  UT.COMPANY_NO        =  Z4.COMPANY_NO                    
MFA-TR*           AND  UT.ACCOUNT_NO       =   BK.ACCOUNT_NO                    
MFA-TR*           AND  UT.CODE_UTIL_TYPE   =   BK.CODE_UTIL_TYPE                
MFA-TR*           AND  UT.IC_NO            =   BK.IC_NO                         
MFA-TR*           AND  BK.CNTRCT_START_DT <=  :WS-PARM-END-DATE                 
MFA-TR*           AND  BK.CNTRCT_END_DT   >=  :WS-PARM-END-DATE                 
MFA-TR*           AND  EXISTS                                                   
MFA-TR*                (SELECT 1                                                
MFA-TR*                   FROM  CSS_RATE_COMP_DEF J1                            
MFA-TR*                   WHERE  J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO            
MFA-TR*                    AND  J1.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE          
MFA-TR*                    AND  J1.REG_TYPE_CD     = 'D')                       
MFA-TR*          ORDER BY UT.ACCOUNT_NO, UT.IC_NO, Z4.PRTY_SVC_CAT_CD           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * GET_UNITS   CURSOR FOR FETCHING THE REVENUE OF EACH           *         
      * CUSTOMER FROM CSS_CNSMPTN_HIST, CSS_MTRD_ENVRNMT & FROM       *         
      * CSS_BILLING_DET.                                              *         
      *---------------------------------------------------------------*         
      *                                                                         
           EXEC SQL                                                     
             DECLARE GET_UNITS   CURSOR FOR                             
                SELECT  MN.METER_NO                                     
                       ,MN.INDUST_BTU_ID                                
                       ,CX.DATE_READ                                    
                       ,CX.NO_UNITS                                     
                       ,CX.BTU_FACTOR                                   
                  FROM  CSS_CNSMPTN_HIST    CX WITH(READUNCOMMITTED)            
                       ,CSS_MTRD_ENVRNMT    MN WITH(READUNCOMMITTED)            
                       ,CSS_BILLING_DET     BG WITH(READUNCOMMITTED)            
                  WHERE  CX.ACCOUNT_NO         =  :UT-ACCOUNT-NO        
                    AND  CX.ACCOUNT_NO         =  MN.ACCOUNT_NO         
                    AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO         
                    AND  CX.CODE_UTIL_TYPE     =  'G'                   
                    AND  CX.CODE_UTIL_TYPE     =  MN.CODE_UTIL_TYPE     
                    AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE     
                    AND  CX.IC_NO              =  :UT-IC-NO             
                    AND  CX.IC_NO              =  MN.IC_NO              
                    AND  CX.IC_NO              =  BG.IC_NO              
                    AND  CX.BILL_NO            =  BG.BILL_NO            
                    AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP 
                    AND  CX.MTR_REF_NO         =  MN.MTR_REF_NO         
                    AND  CX.DATE_READ       BETWEEN 
              IIF(TRY_CONVERT(DATE, :WS-PARM-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-START-DATE
              ) <> 0) OR (LEN(:WS-PARM-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PARM-START-DATE
              ), CONVERT(DATE, :WS-PARM-START-DATE) ) 
                    AND                             
              IIF(TRY_CONVERT(DATE, :WS-PARM-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-END-DATE
              ) <> 0) OR (LEN(:WS-PARM-END-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PARM-END-DATE
              ), CONVERT(DATE, :WS-PARM-END-DATE) )   
                    AND  CX.COMPANY_NO         = '01'                   
                    AND  MN.CODE_METER_STATUS  <> 'K'                   
                    AND  BG.CODE_BILL_CALC     =  'A'                   
                    AND  BG.CODE_BILL_ITM_TYPE =  'C'                   
                    AND  BG.CODE_BILL_ITM_IND  =  'A'                   
                    AND  BG.REV_RPT_CD        <>  'T'                   
               ORDER BY MN.MTR_REF_NO, MN.METER_NO, CX.DATE_READ        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_UNITS   CURSOR FOR                                     
MFA-TR*         SELECT  MN.METER_NO                                             
MFA-TR*                ,MN.INDUST_BTU_ID                                        
MFA-TR*                ,CX.DATE_READ                                            
MFA-TR*                ,CX.NO_UNITS                                             
MFA-TR*                ,CX.BTU_FACTOR                                           
MFA-TR*           FROM  CSS_CNSMPTN_HIST    CX                                  
MFA-TR*                ,CSS_MTRD_ENVRNMT    MN                                  
MFA-TR*                ,CSS_BILLING_DET     BG                                  
MFA-TR*           WHERE  CX.ACCOUNT_NO         =  :UT-ACCOUNT-NO                
MFA-TR*             AND  CX.ACCOUNT_NO         =  MN.ACCOUNT_NO                 
MFA-TR*             AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO                 
MFA-TR*             AND  CX.CODE_UTIL_TYPE     =  'G'                           
MFA-TR*             AND  CX.CODE_UTIL_TYPE     =  MN.CODE_UTIL_TYPE             
MFA-TR*             AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE             
MFA-TR*             AND  CX.IC_NO              =  :UT-IC-NO                     
MFA-TR*             AND  CX.IC_NO              =  MN.IC_NO                      
MFA-TR*             AND  CX.IC_NO              =  BG.IC_NO                      
MFA-TR*             AND  CX.BILL_NO            =  BG.BILL_NO                    
MFA-TR*             AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP         
MFA-TR*             AND  CX.MTR_REF_NO         =  MN.MTR_REF_NO                 
MFA-TR*             AND  CX.DATE_READ       BETWEEN :WS-PARM-START-DATE         
MFA-TR*             AND                             :WS-PARM-END-DATE           
MFA-TR*             AND  CX.COMPANY_NO         = '01'                           
MFA-TR*             AND  MN.CODE_METER_STATUS  <> 'K'                           
MFA-TR*             AND  BG.CODE_BILL_CALC     =  'A'                           
MFA-TR*             AND  BG.CODE_BILL_ITM_TYPE =  'C'                           
MFA-TR*             AND  BG.CODE_BILL_ITM_IND  =  'A'                           
MFA-TR*             AND  BG.REV_RPT_CD        <>  'T'                           
MFA-TR*        ORDER BY MN.MTR_REF_NO, MN.METER_NO, CX.DATE_READ                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSRP439 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
           PERFORM 1000-MAIN-PROCESSING-PARA  THRU 1000-EXIT.           
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **  0100-INITIALIZATION.                                 **               
      **        INITIALIZATION ROUTINE                         **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
           IF FPT133-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********* PCSRP439 ********************'         
              DISPLAY '0100-ERROR ON FCSPT331 OPEN. STATUS IS '         
                       WS-FCA331-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
              DISPLAY '********* PCSRP439 ********************'         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT,                                        
                      WS-INPUT-DATA-BREAKDOWN.                          
      *                                                                         
      *  GET START DATE FROM JOB PARM TABLE.                                    
           MOVE WS-PGRMNAME                TO WS-PROGRAM                
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01      THRU 7600-EXIT.              
           PERFORM 7610-READ-FCSJC01       THRU 7610-EXIT               
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:11) =                     
              'START DATE=' AND INPUT-ACTIVE) OR END-OF-SYSIPT.         
      *  IF START DATE IS SPACES OR STATUS IN ACTIVE.                           
           IF END-OF-SYSIPT                                             
              DISPLAY '      '                                          
              DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'          
              DISPLAY '** START DATE PARM NOT ACTIVE IN THE'            
                     ' JOB PARM TABLE'                                  
              DISPLAY 'START DATE = ' WS-PARM-START-DATE                
           ELSE                                                         
              MOVE G6-PARM-DATA           TO WS-INPUT-BEG-DT-DATA       
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
      *  GET END DATE FROM JOB PARM TABLE.                                      
      *                                                                         
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE WS-PGRMNAME                TO WS-PROGRAM                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:9) =                      
              'END DATE=' AND INPUT-ACTIVE) OR END-OF-SYSIPT.           
      *  IF END DATE IS SPACES OR STATUS IN ACTIVE .                            
           IF END-OF-SYSIPT                                             
              DISPLAY '      '                                          
              DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'          
              DISPLAY '** END DATE PARM NOT ACTIVE IN THE '             
                     ' JOB PARM TABLE'                                  
              DISPLAY 'END DATE   = ' WS-PARM-END-DATE                  
           ELSE                                                         
              MOVE G6-PARM-DATA           TO WS-INPUT-END-DT-DATA       
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
      * START DATE AND END DATE SHOULD BE GREATER THAN SPACES.                  
             WHEN WS-PARM-START-DATE > SPACES AND                       
                  WS-PARM-END-DATE   > SPACES                           
                  CONTINUE                                              
      *  GETTING REPORTDATE FROM THE JOB PARM TABLE.                            
             WHEN WS-PARM-START-DATE = SPACES AND                       
                  WS-PARM-END-DATE   = SPACES                           
                  PERFORM 0120-GET-REPORT-DATE  THRU 0120-EXIT          
             WHEN OTHER                                                 
                  DISPLAY '      '                                      
                  DISPLAY '** ' WS-PROGRAM ' ERROR MSG **'              
                  DISPLAY '** DATE ARE NOT VALID.'                      
                  DISPLAY 'START DATE = ' WS-PARM-START-DATE            
                  DISPLAY 'END DATE   = ' WS-PARM-END-DATE              
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-EVALUATE.                                                
      *                                                                         
           DISPLAY '** ' WS-PROGRAM ' RUNNING FOR **' .                 
           DISPLAY '** START DATE = ' WS-PARM-START-DATE.               
           DISPLAY '** END DATE   = ' WS-PARM-END-DATE.                 
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **  0120-GET-REPORT-DATE.                                **               
      **    GET THE REPORTDATE FROM CSS_JOB_PARM TABLE.        **               
      **    AND BY USING THE COPYBOOK GETTING THE START & END  **               
      **    DAY OF THE MONTH.                                  **               
      ***********************************************************               
       0120-GET-REPORT-DATE.                                            
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE 'REPORTDATE'           TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (REPORT-DATE AND INPUT-ACTIVE)                     
                  OR END-OF-SYSIPT.                                     
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**   PCSRP439 PROCESSING ERROR       **'      
                 DISPLAY '** REPORTDATE REVENUE MONTH NOT ACTIVE **'    
                 DISPLAY '**     PROCESSING TERMINATED         **'      
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (13:06)   TO WS-REV-MTH              
                 MOVE WS-REV-MM              TO WS-PARM-MONTH           
                 MOVE WS-REV-CCYY            TO WS-PARM-YR              
      *  USING COPYBOOK CPD00114 GETTING THE START END DAY OF THE               
      *  MONTH.                                                                 
                 PERFORM 6330-GET-START-END-DATE   THRU 6330-EXIT       
                 MOVE WS-STNDTE-RPT-BEG-DT   TO WS-PARM-START-DATE      
                 MOVE WS-STNDTE-RPT-END-DT   TO WS-PARM-END-DATE        
                 PERFORM 7611-CLOSE                THRU 7611-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **  1000-MAIN-PROCESSING-PARA.                           **               
      **    PROCESSING OF CIG CUSTOMERS TO GET DAILY VOLUMES   **               
      **    DATAS.                                             **               
      ***********************************************************               
       1000-MAIN-PROCESSING-PARA.                                       
                                                                        
           PERFORM 7000-OPEN-CIG-CURSOR       THRU 7000-EXIT.           
           PERFORM 7050-FETCH-CIG-CURSOR      THRU 7050-EXIT.           
           PERFORM 1100-PROCESS-CIG-CURSOR    THRU 1100-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
           PERFORM 7100-CLOSE-CIG-CURSOR      THRU 7100-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      **  1100-PROCESS-CIG-CURSOR.                             **               
      **    GETTING READ DATES, MCF, DEKATHERMS & BTU FACTOR   **               
      **    FROM GET_UNITS CURSORS.                            **               
      ***********************************************************               
       1100-PROCESS-CIG-CURSOR.                                         
      *                                                                         
           INITIALIZE WS-FIORP439,                                      
                      WS-MCF-CALCULATE,                                 
                      WS-DTHS-CALCULATE.                                
      *                                                                         
           IF UT-ACCOUNT-NO  NOT EQUAL WS-PREVIOUS-ACCT-NO              
              MOVE  UT-ACCOUNT-NO             TO WS-PREVIOUS-ACCT-NO    
              MOVE SPACES                     TO WS-CUST-NAME           
              PERFORM 7700-SELECT-CUSTOMER-NAME THRU 7700-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE WS-FULL-NAME            TO WS-EMB-INPUT           
                 MOVE 50                      TO WS-EMB-LENG            
                 MOVE SPACES                  TO WS-CMP-TABLE           
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT     
                 MOVE WS-CMP-TABLE            TO WS-FULL-NAME           
                 MOVE WS-FULL-NAME            TO WS-CUST-NAME           
              ELSE                                                      
                 MOVE SPACES                  TO WS-FULL-NAME           
                                                 WS-CUST-NAME           
              END-IF                                                    
           END-IF .                                                     
      *                                                                         
           PERFORM 7200-OPEN-GET-UNITS-CURSOR   THRU  7200-EXIT.        
           PERFORM 7250-FETCH-GET-UNITS-CURSOR  THRU  7250-EXIT.        
           PERFORM 1200-PROCESS-DAILY-VOLUME    THRU  1200-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
           PERFORM 7300-CLOSE-GET-UNITS-CURSOR  THRU  7300-EXIT.        
           PERFORM 7050-FETCH-CIG-CURSOR        THRU  7050-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***********************************************************               
      **  1200-PROCESS-DAILY-VOLUME.                           **               
      **    GETTING READ DATES, MCF, DEKATHERMS & BTU FACTOR   **               
      **    FROM GET_UNITS CURSORS.                            **               
      ***********************************************************               
       1200-PROCESS-DAILY-VOLUME.                                       
      *                                                                         
      *  WHEN CX BTU FACOTOR IS ZERO, DEFAULT TO 1.032                          
      *                                                                         
           IF CX-BTU-FACTOR   =  0                                      
              MOVE 1.032  TO CX-BTU-FACTOR                              
           END-IF.                                                      
      *                                                                         
      *  COMPUTING MCF & DEKATHERMS                                             
           COMPUTE WS-MCF-CALCULATE  = CX-NO-UNITS / 10.                
           COMPUTE WS-DTHS-CALCULATE ROUNDED =                          
                  (WS-MCF-CALCULATE  * CX-BTU-FACTOR).                  
      *                                                                         
      **    MOVE THE DETAILS OF DAILY VOLUME TO FIORP439       **               
      **    LAYOUT.                                            **               
A02221     MOVE UT-ACCOUNT-NO             TO WS-ACCOUNT-NO-VD.          
A02221     INSPECT WS-ACCOUNT-NO-VD REPLACING ALL ' ' BY '-'.           
                                                                        
           MOVE MN-METER-NO               TO WS-METER-NO-VD.            
           MOVE UT-IC-NO                  TO WS-IC-NO-VD.               
           MOVE CX-DATE-READ              TO WS-GAS-DAYS-VD.            
           INSPECT WS-CUST-NAME REPLACING ALL ',' BY ' '.               
           MOVE WS-CUST-NAME              TO WS-CUSTOMER-NAME-VD.       
           MOVE WS-MCF-CALCULATE          TO WS-MCF-VD.                 
           MOVE CX-BTU-FACTOR             TO WS-BTU-VD.                 
           MOVE WS-DTHS-CALCULATE         TO WS-DTHS-VD.                
           MOVE UT-RATE-PLAN-NO           TO WS-RATE-PLAN-NO.           
           MOVE MN-INDUST-BTU-ID          TO WS-INDUST-BTU-ID.          
           MOVE Z4-PRTY-SVC-CAT-CD        TO WS-PRTY-SVC-CAT-CD.        
           MOVE BK-CONTRACT-DEMAND        TO WS-CONTRACT-DEMAND.        
           PERFORM 8500-WRITE-FCSPT133-DAILY-VOL  THRU 8500-EXIT.       
           PERFORM 7250-FETCH-GET-UNITS-CURSOR    THRU 7250-EXIT.       
      *                                                                         
       1200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **   6010-REDUCE-EMBEDDED-SPACES                                **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *  6200-GET-PARAMETER-DATE.                                     *         
      *  6300-GET-OVERRIDE-DATE.                                      *         
      *  6310-GET-DEFAULT-DATE.                                       *         
      *  6320-EDIT-PARM-DATE.                                         *         
      *  6330-GET-START-END-DATE.                                     *         
      *  6340-UPDATE-JOB-PARM-TABLE.                                  *         
      *****************************************************************         
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **   7600-START-FJC01.                                          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **  6251-GET-FJC01-DATE.                                        **        
      ******************************************************************        
      *                                                                         
       COPY CPD00037.                                                           
       COPY CPD00040.                                                           
      *                                                                         
      ******************************************************************        
      **   7600-START-FCJ01.                                          **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *****************************************************************         
      **    7000-OPEN-CIG-CURSOR                                     **         
      **     OPEN THE MAIN DRIVING CURSOR  OF ALL CIG CUSOTMERS      **         
      *****************************************************************         
       7000-OPEN-CIG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN CIG_CUSTOMER                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP439 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7000       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7050-FETCH-CIG-CURSOR                                    **         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      *****************************************************************         
       7050-FETCH-CIG-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH  CIG_CUSTOMER                                       
               INTO :UT-ACCOUNT-NO                                      
                   ,:UT-IC-NO                                           
                   ,:UT-RATE-PLAN-NO                                    
                   ,:Z4-PRTY-SVC-CAT-CD                                 
                   ,:BK-CONTRACT-DEMAND                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                NEXT SENTENCE                                           
             ELSE                                                       
                DISPLAY '****************************************'      
                DISPLAY '**     PCSRP439 PROCESSING ERROR      **'      
                DISPLAY '**      ABEND IN PARAGRAPH 7050       **'      
                DISPLAY '**  ACCOUNT #     = ' UT-ACCOUNT-NO            
                DISPLAY '**  IC NO         = ' UT-IC-NO                 
                DISPLAY '**  RATE PLAN NO  = ' UT-RATE-PLAN-NO          
                DISPLAY '**  PRTY SVC CAT CD = ' Z4-PRTY-SVC-CAT-CD     
                DISPLAY '**  CONTRACT DEMAND = ' BK-CONTRACT-DEMAND     
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7020-CLOSE-CIG-CURSOR                                    **         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      *****************************************************************         
       7100-CLOSE-CIG-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE CIG_CUSTOMER                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP439 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7100       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7200-OPEN-GET-UNITS-CURSOR.                              **         
      *****************************************************************         
       7200-OPEN-GET-UNITS-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN GET_UNITS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP439 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7250-FETCH-GET-UNITS-CURSOR                             **          
      *****************************************************************         
       7250-FETCH-GET-UNITS-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH  GET_UNITS                                          
               INTO  :MN-METER-NO                                       
                    ,:MN-INDUST-BTU-ID                                  
                    ,:CX-DATE-READ                                      
                    ,:CX-NO-UNITS                                       
                    ,:CX-BTU-FACTOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSRP439 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7250       **'     
                 DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE   
                 DISPLAY '** ACCOUNT NUMBER = ' UT-ACCOUNT-NO           
                 DISPLAY '** IC NO          = ' UT-IC-NO                
                 DISPLAY '** START DATE     = ' WS-PARM-START-DATE      
                 DISPLAY '** END DATE       = ' WS-PARM-END-DATE        
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7300-CLOSE-GET-UNITS-CURSOR.                             **         
      *****************************************************************         
       7300-CLOSE-GET-UNITS-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               CLOSE GET_UNITS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSRP439 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7300       **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** ACCOUNT NUMBER = ' UT-ACCOUNT-NO              
              DISPLAY '** IC NO          = ' UT-IC-NO                   
              DISPLAY '****************************************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7700-SELECT-CUSTOMER-NAME                                **          
      **      SELECTS THE CUSTOMER NAME FROM CSS_NAME               **          
      ****************************************************************          
                                                                        
       7700-SELECT-CUSTOMER-NAME.                                       
                                                                        
           EXEC SQL                                                     
             SELECT DQ.FULL_NAME                                        
               INTO :WS-FULL-NAME                                       
               FROM CSS_NAME DQ WITH(READUNCOMMITTED)                           
                   ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
                   ,CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                       
              WHERE AT.ACCOUNT_NO       = :UT-ACCOUNT-NO                
                AND AT.CUSTOMER_NO      =  CU.CUSTOMER_NO               
                AND CU.NAME_ID          =  DQ.NAME_ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DQ.FULL_NAME                                                
MFA-TR*        INTO :WS-FULL-NAME                                               
MFA-TR*        FROM CSS_NAME DQ                                                 
MFA-TR*            ,CSS_CUSTOMER CU                                             
MFA-TR*            ,CSS_ACCOUNT  AT                                             
MFA-TR*       WHERE AT.ACCOUNT_NO       = :UT-ACCOUNT-NO                        
MFA-TR*         AND AT.CUSTOMER_NO      =  CU.CUSTOMER_NO                       
MFA-TR*         AND CU.NAME_ID          =  DQ.NAME_ID                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING CUSTOMER NAME'                   
                                           TO WS-ERR-MSG                
              DISPLAY 'ACCOUNT-NO:'           UT-ACCOUNT-NO             
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7700'                  TO WS-ACTIVE-PARAGRAPH       
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7700-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      *  WRITE TO FCSPT133  - DAILY VOLUME REPORT FOR CIG CUSTOMERS  *          
      ****************************************************************          
       8500-WRITE-FCSPT133-DAILY-VOL.                                   
      *                                                                         
           IF WRITE-HEADER-REPT                                         
              WRITE PRT331-RECORD  FROM WS-RPT1-HEADER                  
              MOVE  WS-N           TO   WS-NOTWRITE-HEADER-SW           
           END-IF.                                                      
                                                                        
           WRITE PRT331-RECORD     FROM WS-FIORP439.                    
      *                                                                         
           IF FPT133-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP439    ABORT ************'       
              DISPLAY '* 8500-WRITE-FCSPT133-DAILY-VOL         *'       
              DISPLAY 'ERROR IN WRITING FCSPT133 FILE'                  
              DISPLAY 'ERROR STATUS ' WS-FCA331-STATUS                  
              DISPLAY 'ACCOUNT NO   ' UT-ACCOUNT-NO                     
              DISPLAY 'IC NO        ' UT-IC-NO                          
              DISPLAY '********** PCSRP439    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      *  CLOSES  THE OUTPUT  FILE                                   **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF  FPT133-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP439    ABORT ************'      
               DISPLAY '* 9000-TERMINATE                        *'      
               DISPLAY 'ERROR IN CLOSING FCSCA133 FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FCA331-STATUS                 
               DISPLAY 'ACCOUNT NO   ' UT-ACCOUNT-NO                    
               DISPLAY '********** PCSRP439    ABORT ************'      
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP439  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * THIS INCLUDES 9700-PROCESS-ABEND                           *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
