       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP435.                                      
COB303 DATE-WRITTEN.     OCTOBER 7, 2015.                               
       DATE-COMPILED..                                                  
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  10/07/2015    RS7M249     CONVERTED THE EAZYTRIVE PGM     --*        
ACT026*--                            CSR435 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBW06-FILE                                          
              ASSIGN UT-S-FCSBW06                                       
              FILE STATUS IS WS-FCSBW06-STATUS.                         
                                                                        
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDBW06.                                                            
       COPY FIOBW06.                                                            
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP435'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_AR_CNTL, AC                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK_EFT, BE                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                            
               INCLUDE TBUTLENV                                                 
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *    CSS_BANK, D1                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUSTOMER_BANK, JF                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_DELINQUENCY, C8                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_READ_WINDOW, RW                                      *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MODEL_SQL,   MS                                      *           
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM,    G6                                      *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * CSS_MTRD_ENVRNMT,   MN                                      *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * COPYBOOK FOR JOB PARM READ AND PARM CURSOR                  *           
      ***************************************************************           
      *****                                                                     
      *  CWS00038 - JOB PARM / COMMON DATE SUPPORT                              
      *****                                                                     
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
      *****                                                                     
      *  CWS00114 - WORKING STORAGE TO READ REPORT DATE                         
      *****                                                                     
           EXEC SQL                                                             
                INCLUDE CWS00114                                                
           END-EXEC.                                                            
      *****                                                                     
      *  COPYBOOK FOR DATE CHECK                                                
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE FIOJC01                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
           05 COMPANY-NO                PIC X(02)  VALUE '01'.          
           05 CMND-CODE                 PIC X(04)  VALUE SPACES.        
           05 WS-COMPNO                 PIC X(02)  VALUE SPACES.        
           05 WS-COMPANY                PIC X(01)  VALUE SPACES.        
           05 WS-NBR-DAYS-B             PIC S9(4)  COMP.                
           05 WS-WORKSET-ID             PIC X(08)  VALUE SPACES.        
           05 WS-ACCOUNT                PIC 9(13).                      
           05 WS-ACCT-MAX               PIC 9(13)  VALUE 9999999999999. 
           05 WS-NBR-DAYS               PIC 9(02)  VALUE ZEROES.        
           05 WS-ACCT-MIN               PIC 9(13)  VALUE 1.             
           05 WS-DATE-READ              PIC X(10)  VALUE SPACES.        
           05 WS-PREV-ACCOUNT-NO        PIC 9(13).                      
           05 WS-METER-NO               PIC X(09)  VALUE SPACES.        
           05 WS-EMPLOYEE               PIC X(09)  VALUE SPACES.        
           05 WS-RATE-PLAN              PIC X(03)  VALUE SPACES.        
           05 WS-MIN10-DATE             PIC X(10)  VALUE SPACES.        
           05 WS-PLS10-DATE             PIC X(10)  VALUE SPACES.        
           05 WS-PREV-METER-NO          PIC X(09)  VALUE SPACES.        
           05 WS-PREV-DATE-READ         PIC X(10)  VALUE SPACES.        
           05 WS-OPTIMUM-DATE           PIC X(10)  VALUE SPACES.        
           05 WS-PREV-CYCLE             PIC X(02)  VALUE SPACES.        
           05 WS-TOTAL-BAD              PIC 9(6)   VALUE ZEROES.        
           05 PGM-NAME                  PIC X(08)  VALUE 'PCSRP435'.    
           05 WS-CMD-DATE               PIC X(04)  VALUE 'DATE'.        
           05 WS-CMD-PARM               PIC X(04)  VALUE 'PARM'.        
           05 WS-DEFAULT-COMP-NO        PIC X(02)  VALUE '01'.          
           05 WS-ACCOUNT-P              PIC 9(13).                      
           05 WS-ACCOUNT-N              PIC 9(13).                      
           05 WS-CODE-UTIL-TYPE         PIC X(01)  VALUE SPACES.        
           05 WS-NBR-DAYS-X             PIC X(02)  VALUE SPACES.        
           05 WS-CYCLE                  PIC X(02)  VALUE SPACES.        
           05 WS-DATE-SW                PIC X(01)  VALUE 'N'.           
           05 WS-RUN-DATE               PIC X(10)  VALUE SPACES.        
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-LINE-COUNT1            PIC 9(02)  VALUE ZEROES.        
           05 WS-PAGE-NUM1              PIC 9(02)  VALUE ZEROES.        
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-ONE                    PIC X(02) VALUE '01'.           
           05 WS-CURSOR                 PIC X(20) VALUE SPACES.         
           05 WS-ACTION                 PIC X(06) VALUE SPACES.         
           05 WS-REPORT                 PIC X(01) VALUE 'N'.            
           05 WS-RECORD-COUNT           PIC 9(9)  VALUE ZEROES.         
           05 WS-COMPANY-NAME           PIC X(26) VALUE SPACES.         
      *                                                                         
       01  WS-CURRENT-DATE1.                                            
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RPT-DATE.                                                 
           05  WS-RPT-MM                PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RPT-DD                PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RPT-YY                PIC X(04).                      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCSBW06-STATUS        PIC X(02) VALUE '00'.           
               88 FCSBW06-SUCCESSFUL              VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
      ***************** PCSRP435 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINE.                                             
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  P-RPT1-DATE          PIC X(10).                      
               10  FILLER               PIC X(40) VALUE SPACES.         
               10  WS-RPT-TITLE-1       PIC X(31)                       
                       VALUE 'SOUTH CAROLINA ELECTRIC AND GAS'.         
               10  FILLER               PIC X(38) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  P-RPT-TITLE-PGNM     PIC Z(03).                      
               10  FILLER               PIC X(02) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER               PIC X(60) VALUE SPACES.         
               10  WS-RPT-TITLE-2       PIC X(14)                       
                                          VALUE 'BAD READ DATES'.       
               10  FILLER               PIC X(59) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER               PIC X(133) VALUE SPACES.        
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER               PIC X(20) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE 'COMPANY'.      
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE 'CYCLE'.        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'WORKSET ID'.   
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE 'ACCOUNT'.      
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'READ DATE'.    
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'METER NBR'.    
               10  FILLER               PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'EMPL'.         
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'RATE PLAN'.    
               10  FILLER               PIC X(19) VALUE SPACES.         
      *                                                                         
       01  WS-REPORT1.                                                  
           05 FILLER                    PIC X(22) VALUE SPACES.         
           05 RPT-COMPNO                PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 RPT-CYCLE                 PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 RPT-WORKSET-ID            PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 RPT-ACCOUNT               PIC 9(13) VALUE ZEROES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-DATE-READ             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-METER-NO              PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-EMPLOYEE              PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 RPT-RATE-PLAN             PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(21) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-TERMDISP1.                                            
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-TERMDISP2.                                            
           05  FILLER                   PIC X(10) VALUE SPACES.         
           05  FILLER                   PIC X(28) VALUE                 
                      'NUMBER OF BAD READ DATES = '.                    
           05  FILLER                   PIC X(12) VALUE SPACES.         
           05  RPT-TOTAL-BAD            PIC Z(5)9.                      
      *                                                                         
       01  WS-RPT-TERMDISP3.                                            
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01  WS-RPT-TERMDISP4.                                            
           05  FILLER                   PIC X(60) VALUE SPACES.         
           05  FILLER                   PIC X(21) VALUE                 
                         '*** END OF REPORT ***'.                       
           05  FILLER                   PIC X(53) VALUE SPACES.         
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                   PIC X(49) VALUE SPACES.         
           05  FILLER                   PIC X(32) VALUE                 
                     'NO READ DATE ERRORS FOR THIS RUN'.                
           05  FILLER                   PIC X(52) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE            THRU  0100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU  1000-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE             THRU  9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                       TO WS-RPT-YY.               
           MOVE WS-CM                       TO WS-RPT-MM.               
           MOVE WS-CD                       TO WS-RPT-DD.               
           MOVE WS-RPT-DATE                TO P-RPT1-DATE.              
      *                                                                         
           OPEN INPUT  FCSBW06-FILE.                                    
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF FCSBW06-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**   PCSRP435 PROCESSING ERROR       **'         
              DISPLAY '** ERROR ON FCSBW06  OUTPUT FILE     **'         
              DISPLAY '**  FILE STATUS = ' WS-FCSBW06-STATUS            
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 2050-GET-INITIAL-DATE      THRU 2050-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7400-READ-FCSBW06          THRU 7400-EXIT.           
           DISPLAY 'PROCESSED ACCOUNT  : ' WS-ACCOUNT.                  
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
                                              UNTIL END-OF-REC.         
           MOVE WS-TOTAL-BAD                TO RPT-TOTAL-BAD.           
      *                                                                         
           PERFORM 2800-END-REPORT            THRU 2800-EXIT.           
           IF WS-TOTAL-BAD  = 0                                         
              MOVE ZEROES                   TO RETURN-CODE              
           ELSE                                                         
              DISPLAY 'TOTAL NUMBER OF BAD READ DATES = ' WS-TOTAL-BAD  
              MOVE '05'                     TO RETURN-CODE              
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT                                          **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE E-FBW06-WORKSET-ID(1:1)     TO  WS-COMPANY.             
           IF WS-COMPANY = 'S'                                          
              MOVE '01'                     TO  WS-COMPNO               
           ELSE                                                         
              MOVE '26'                     TO  WS-COMPNO               
           END-IF.                                                      
                                                                        
           MOVE E-FBW06-WORKSET-ID(2:2)     TO WS-CYCLE.                
           IF WS-CYCLE > '20' AND  WS-CYCLE <  '90'                     
              MOVE '20'                     TO WS-CYCLE                 
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW06-WORKSET-ID          TO WS-WORKSET-ID.           
           MOVE E-FBW06-METER-NO            TO WS-METER-NO.             
           MOVE E-FBW06-ACCOUNT-NO          TO WS-ACCOUNT.              
           MOVE E-FBW06-DATE-READ           TO WS-DATE-READ.            
           MOVE E-FBW06-CODE-UTIL-TYPE      TO WS-CODE-UTIL-TYPE.       
      *                                                                         
           MOVE E-FBW06-EMPLOYEE-NO         TO WS-EMPLOYEE.             
           MOVE WS-ACCOUNT                  TO WS-ACCOUNT-N.            
           MOVE WS-ACCOUNT-N                TO WS-ACCOUNT-P.            
      *                                                                         
           IF WS-ACCOUNT-N NOT EQUAL WS-ACCT-MAX AND                    
              WS-ACCOUNT-N NOT EQUAL WS-ACCT-MIN                        
              IF WS-ACCOUNT-N NOT EQUAL  WS-PREV-ACCOUNT-NO OR          
                 WS-METER-NO  NOT EQUAL  WS-PREV-METER-NO   OR          
                 WS-DATE-READ NOT EQUAL WS-PREV-DATE-READ               
                 PERFORM 2100-REPORT-DATA     THRU 2100-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-READ-FCSBW06          THRU 7400-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2050-GET-INITIAL-DATE                                          *        
      ******************************************************************        
      *                                                                         
       2050-GET-INITIAL-DATE.                                           
      *                                                                         
           PERFORM 2400-GET-DATE              THRU 2400-EXIT.           
                                                                        
      *                                                                         
           MOVE WS-PROGRAM                TO G6-PROGRAM-NAME.           
           PERFORM 7100-GET-DAYS              THRU 7100-EXIT.           
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-REPORT-DATA                                             **        
      ******************************************************************        
      *                                                                         
       2100-REPORT-DATA.                                                
      *                                                                         
           IF WS-CYCLE NOT EQUAL WS-PREV-CYCLE                          
              MOVE WS-CYCLE                 TO RW-READ-CYCLE            
              MOVE WS-RUN-DATE              TO RW-DATE-MTR-RD-XTRCT     
              PERFORM 7050-GET-OPTIMUM-DATE   THRU 7050-EXIT            
              MOVE WS-CYCLE                 TO  WS-PREV-CYCLE           
           END-IF                                                       
      *                                                                         
           IF WS-OPTIMUM-DATE = WS-DATE-READ                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7500-GET-COMPARE-DATES  THRU 7500-EXIT            
              MOVE WS-ACCOUNT-P              TO MN-ACCOUNT-NO           
              PERFORM 7200-GET-RATE-CURSOR    THRU 7200-EXIT            
              IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
                 MOVE 'N/A'                 TO WS-RATE-PLAN             
              END-IF                                                    
                                                                        
              IF WS-DATE-READ < WS-MIN10-DATE                           
                 COMPUTE WS-TOTAL-BAD = WS-TOTAL-BAD + 1                
                 PERFORM 2900-MOVE-DTL-DATA    THRU 2900-EXIT           
              ELSE                                                      
                 IF WS-DATE-READ > WS-PLS10-DATE                        
                    COMPUTE WS-TOTAL-BAD = WS-TOTAL-BAD + 1             
                    PERFORM 2900-MOVE-DTL-DATA    THRU 2900-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-ACCOUNT                  TO  WS-PREV-ACCOUNT-NO.     
           MOVE WS-METER-NO                 TO  WS-PREV-METER-NO.       
           MOVE WS-DATE-READ                TO  WS-PREV-DATE-READ.      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-DATE.                                                 *        
      ******************************************************************        
      *                                                                         
       2400-GET-DATE.                                                   
      *                                                                         
           MOVE COMPANY-NO             TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PGM-NAME               TO WS-PROGRAM.                   
           MOVE CMND-CODE              TO WS-CMD-DATE.                  
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                   PERFORM 2500-GET-COMMON-DATE THRU 2500-EXIT          
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (10:10)                              
                                       TO WS-RUN-DATE                   
                 DISPLAY '** PROGRAM OVERRIDE RUN DATE USED **'         
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 2400-EXIT                                        
           END-EVALUATE.                                                
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-GET-COMMON-DATE.                                          *        
      ******************************************************************        
      *                                                                         
       2500-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE SPACES                 TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN.      
           MOVE 'COMMONDATE'           TO WS-PROGRAM.                   
           MOVE 'CA00'                 TO CMND-CODE.                    
           MOVE CMND-CODE              TO WS-CMD-DATE.                  
           MOVE WS-CMD-DATE            TO WS-DATE.                      
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
                  UNTIL (RUN-DATE AND INPUT-ACTIVE)                     
                     OR END-OF-SYSIPT.                                  
      *                                                                         
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 MOVE G6-PARM-DATA (1:10)                               
                                       TO WS-RUN-DATE                   
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 2500-EXIT                                        
           END-EVALUATE.                                                
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-MOVE-HDR-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2700-MOVE-HDR-DATA.                                              
      *                                                                         
           ADD +1                        TO WS-PAGE-NUM1                
           MOVE WS-PAGE-NUM1             TO P-RPT-TITLE-PGNM            
           MOVE WS-RPT-HEADER-1          TO PRT33-RECORD                
           WRITE PRT33-RECORD            AFTER ADVANCING PAGE           
           ADD +1                        TO WS-LINE-COUNT1              
           MOVE WS-RPT-HEADER-2          TO PRT33-RECORD                
           PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT               
           MOVE WS-RPT-HEADER-3          TO PRT33-RECORD                
           WRITE PRT33-RECORD            AFTER ADVANCING 3 LINES        
           ADD   +4                      TO WS-LINE-COUNT1              
           MOVE WS-RPT-HEADER-4          TO PRT33-RECORD                
           PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT.              
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2800-END-REPORT.                                             **        
      ******************************************************************        
      *                                                                         
       2800-END-REPORT.                                                 
      *                                                                         
            IF WS-REPORT   = WS-NO                                      
               PERFORM 2700-MOVE-HDR-DATA    THRU 2700-EXIT             
               MOVE WS-NO-DATA               TO PRT33-RECORD            
               PERFORM 8000-WRITE-PRT33      THRU 8000-EXIT             
               MOVE WS-RPT-TERMDISP4          TO PRT33-RECORD           
               PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT            
            ELSE                                                        
              MOVE WS-RPT-TERMDISP1          TO PRT33-RECORD            
              WRITE PRT33-RECORD AFTER ADVANCING 3 LINES                
              ADD   +4                       TO WS-LINE-COUNT1          
              MOVE WS-RPT-TERMDISP2          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP3          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP4          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
            END-IF.                                                     
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2900-MOVE-DTL-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2900-MOVE-DTL-DATA.                                              
      *                                                                         
           IF WS-LINE-COUNT1    >= 52      OR                           
              WS-REPORT         =  WS-NO                                
              MOVE 0                        TO  WS-LINE-COUNT1          
              PERFORM 2700-MOVE-HDR-DATA    THRU 2700-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPNO                   TO  RPT-COMPNO              
           MOVE WS-CYCLE                    TO  RPT-CYCLE               
           MOVE WS-WORKSET-ID               TO  RPT-WORKSET-ID          
           MOVE WS-ACCOUNT                  TO  RPT-ACCOUNT             
           MOVE WS-DATE-READ                TO  RPT-DATE-READ           
           MOVE WS-METER-NO                 TO  RPT-METER-NO            
           MOVE WS-EMPLOYEE                 TO  RPT-EMPLOYEE            
           MOVE WS-RATE-PLAN                TO  RPT-RATE-PLAN           
           MOVE WS-REPORT1                  TO  PRT33-RECORD            
           PERFORM 8000-WRITE-PRT33           THRU 8000-EXIT            
           MOVE WS-YES                      TO  WS-REPORT.              
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-GET-OPTIMUM-DATE.                                         *        
      ******************************************************************        
      *                                                                         
       7050-GET-OPTIMUM-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
            SELECT TOP(1) RW.OPTIMUM_READ_DATE                                 
              INTO :WS-OPTIMUM-DATE                                     
              FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                     
             WHERE RW.READ_CYCLE          = :RW-READ-CYCLE              
               AND RW.DATE_MTR_RD_XTRCT  <= IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )       
          ORDER BY RW.DATE_MTR_RD_XTRCT DESC                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT RW.OPTIMUM_READ_DATE                                         
MFA-TR*       INTO :WS-OPTIMUM-DATE                                             
MFA-TR*       FROM CSS_READ_WINDOW RW                                           
MFA-TR*      WHERE RW.READ_CYCLE          = :RW-READ-CYCLE                      
MFA-TR*        AND RW.DATE_MTR_RD_XTRCT  <= :RW-DATE-MTR-RD-XTRCT               
MFA-TR*   ORDER BY RW.DATE_MTR_RD_XTRCT DESC                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    QUERYNO 7050                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             CONTINUE                                                   
           ELSE                                                         
            DISPLAY '******** PCSRP435 ABORT *****'                     
            DISPLAY '**  7050-GET-OPTIMUM-DATE  **'                     
            DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
            DISPLAY '**  WS-CYCLE    = ' WS-CYCLE                       
            DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                    
            DISPLAY '**  PROCESSING TERMINATED  **'                     
            PERFORM 9900-ABEND              THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-DAYS.                                                 *        
      ******************************************************************        
      *                                                                         
       7100-GET-DAYS.                                                   
      *                                                                         
           EXEC SQL                                                     
                 SELECT CIS.SUBSTR3(PARM_DATA,10,2)                          
                   INTO :WS-NBR-DAYS-X                                  
                   FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                   
                  WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME            
                    AND G6.COMPANY_NO     = :WS-DEFAULT-COMP-NO         
                    AND G6.CMND_CODE      = :WS-CMD-PARM                
                    AND G6.STATUS         = 'A'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT SUBSTR(PARM_DATA,10,2)                                  
MFA-TR*            INTO :WS-NBR-DAYS-X                                          
MFA-TR*            FROM CSS_JOB_PARM G6                                         
MFA-TR*           WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                    
MFA-TR*             AND G6.COMPANY_NO     = :WS-DEFAULT-COMP-NO                 
MFA-TR*             AND G6.CMND_CODE      = :WS-CMD-PARM                        
MFA-TR*             AND G6.STATUS         = 'A'                                 
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                   
              MOVE '10'                   TO WS-NBR-DAYS-B              
           ELSE                                                         
              MOVE WS-NBR-DAYS            TO WS-NBR-DAYS-B              
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP435 ABORT ******'                  
              DISPLAY '**  7100-GET-DAYS           **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '** G6-PROGRAM-NAME    = ' G6-PROGRAM-NAME        
              DISPLAY '** WS-DEFAULT-COMP-NO = ' WS-DEFAULT-COMP-NO     
              DISPLAY '** WS-CMD-PARM        = ' WS-CMD-PARM            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-RATE-CURSOR.                                          *        
      ******************************************************************        
      *                                                                         
       7200-GET-RATE-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                 SELECT TOP(1) UT.RATE_PLAN_NO                                 
                   INTO :WS-RATE-PLAN                                   
                   FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                  WHERE MN.ACCOUNT_NO      = :MN-ACCOUNT-NO             
                    AND MN.METER_NO        = :WS-METER-NO               
                    AND MN.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE         
                    AND UT.ACCOUNT_NO      = MN.ACCOUNT_NO              
                    AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE          
                    AND UT.IC_NO           = MN.IC_NO                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT UT.RATE_PLAN_NO                                         
MFA-TR*            INTO :WS-RATE-PLAN                                           
MFA-TR*            FROM CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE MN.ACCOUNT_NO      = :MN-ACCOUNT-NO                     
MFA-TR*             AND MN.METER_NO        = :WS-METER-NO                       
MFA-TR*             AND MN.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                 
MFA-TR*             AND UT.ACCOUNT_NO      = MN.ACCOUNT_NO                      
MFA-TR*             AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE                  
MFA-TR*             AND UT.IC_NO           = MN.IC_NO                           
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP435 ABORT ******'                  
              DISPLAY '**  7200-GET-RATE-CURSOR    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-READ-FCSBW06                                              *        
      ******************************************************************        
       7400-READ-FCSBW06.                                               
      *                                                                         
           READ FCSBW06-FILE                                            
                                                                        
           IF FCSBW06-SUCCESSFUL OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP435 ABORT *********'          
               DISPLAY '**ERROR IN READING FCSBW06  FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCSBW06-STATUS           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-GET-COMPARE-DATES.                                        *        
      ******************************************************************        
      *                                                                         
       7500-GET-COMPARE-DATES.                                          
      *                                                                         
           EXEC SQL                                                     
            SELECT
              (DATEADD( DAY, -(:WS-NBR-DAYS-B), IIF(TRY_CONVERT(DATE, 
                                                       :WS-OPTIMUM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMUM-DATE
              ) <> 0) OR (LEN(:WS-OPTIMUM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-OPTIMUM-DATE
              ), CONVERT(DATE, :WS-OPTIMUM-DATE) ) )),
              (DATEADD( DAY, (:WS-NBR-DAYS-B), IIF(TRY_CONVERT(DATE, 
                                                       :WS-OPTIMUM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMUM-DATE
              ) <> 0) OR (LEN(:WS-OPTIMUM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-OPTIMUM-DATE
              ), CONVERT(DATE, :WS-OPTIMUM-DATE) ) ))
            INTO
              :WS-MIN10-DATE,
              :WS-PLS10-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET :WS-MIN10-DATE = (DATE(:WS-OPTIMUM-DATE)                        
MFA-TR*                     - (:WS-NBR-DAYS-B) DAYS)                            
MFA-TR*        ,:WS-PLS10-DATE = (DATE(:WS-OPTIMUM-DATE)                        
MFA-TR*                     + (:WS-NBR-DAYS-B) DAYS)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             CONTINUE                                                   
           ELSE                                                         
            DISPLAY '******** PCSRP435 ABORT *****'                     
            DISPLAY '**  7500-GET-COMPARE-DATES **'                     
            DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
            DISPLAY '**  PROCESSING TERMINATED  **'                     
            PERFORM 9900-ABEND              THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD.                                          
           ADD +1                           TO WS-LINE-COUNT1.          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * 9000-CLOSE-FILES.                                        *              
      ************************************************************              
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW06-FILE.                                          
                                                                        
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
