       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP432.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. JAN-2003.                                          
       *****************************************************************
       *               SOUTH CAROLINA ELECTRIC & GAS                   *
       **                                                             **
       *****************************************************************
       ********        CUSTOMER INFORMATION  SYSTEM            *********
       *****************************************************************
       **                   P R O G R A M S U M M A R Y               **
       **                                                             **
       **  PURPOSE :                                                  **
       **  GENERATE A REPORT AND FILE THAT CONTAIN MONTH OF           **
       **  VOLUMES FOR CIG CUSTOMERS.                                 **
       **                                                             **
       **  INPUT :                                                    **
       **  1. CSS_JOB_PARM                                            **
       **  2. CSS_TRNSP_CONTRACT                                      **
       **  3. CSS_TRNSP_VOL_BLK                                       **
       **  4. CSS_CNSMPTN_HIST                                        **
       **                                                             **
       **  FREQUENCY :                                                **
       **  EVERY MONDAY WITH A SPECIAL RUN IF THE END OF THE MONTH    **
       **  IS NOT ON MONDAY.                                          **
       **                                                             **
       *****************************************************************
       **                                                             **
       **              PROGRAM  MODIFICATION  LOG                     **
       **                                                             **
       **     DATE       INITIALS         REASON                      **
       **    ======      =========        =======                     **
       **   01-13-2002   COVANSYS         NEW REPORT PROGRAM.         **
       **                                                             **
A00633 **   09-22-2009   MS93544          CHANGES TO WS-PARM-SHIPPER- **
A00633 **                                 CODE AND FORMATTING THE     **
A00633 **                                 FILE TO EXCEL .             **
       **                                                             **
A04527 **   08-19-2013   MR7E794          ADDED TWO FIELDS ZION-CITY, **
A04527 **                ACT133           MDQ TO REPORT FILE FCSRP432.**
A04880 **   03-19-2014   DB41297  ADDED CHECK FOR REV_RPT_CD TO ENSURE**
ACT068 **                         IT PICKS UP CORRECT BILL_DETAIL REC.**
A05460***   06/03/16     MR7E794  REPLACE THE DUPLICATE FIELD WS-PARM **        
A05460***                ACT188   AND REMOVED THE UNUSED COPYBOOKS.   **        
       *****************************************************************
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP432.                                                           
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP432.                                                           
       COPY FIORP432.                                                           
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP432'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP432 STARTS HERE'.                  
                                                                        
       01 WS-MISC.                                                      
          05  WS-RPT-REV-MTH.                                           
              10 WS-REV-CCYY             PIC 9(04).                     
              10 WS-REV-MM               PIC 9(02).                     
          05  WS-REVENUE-MONTH           PIC 9(06) VALUE 0.             
A00633    05  WS-REVENUE-DATE            PIC X(10) VALUE SPACES.        
A00633    05  WS-REVENUE-MONTH-DT.                                      
A00633        10 WS-REVENUE-CCYY         PIC X(04) VALUE SPACES.        
A00633        10 WS-REVENUE-HYPEN1       PIC X(01) VALUE '-'.           
A00633        10 WS-REVENUE-MM           PIC X(02) VALUE SPACES.        
A00633        10 WS-REVENUE-HYPEN2       PIC X(01) VALUE '-'.           
A00633        10 WS-REVENUE-DT           PIC X(02) VALUE '01'.          
          05  WS-DEFAULT-COMP-NO         PIC X(02) VALUE '01'.          
          05  WS-PREV-ACCOUNT-NO         PIC S9(13)V USAGE COMP-3       
                                                   VALUE 0.             
          05  WS-FUEL-SHIPPER-CD         PIC X(01) VALUE SPACES.        
          05  WS-PREV-FUEL-SHIPPER-CD    PIC X(01) VALUE SPACES.        
          05  WS-PREV-METER-NO           PIC X(09) VALUE SPACES.        
          05  WS-NULL-1                  PIC S9(4) COMP.                
          05  WS-FULL-NAME               PIC X(50) VALUE SPACES.        
          05  WS-CUST-NAME               PIC X(40) VALUE SPACES.        
          05  WS-COMP-NAME               PIC X(26) VALUE SPACES.        
          05  WS-MAX-LINES               PIC 9(02) VALUE 56.            
          05  WS-LINE-COUNT              PIC 9(02) VALUE 57.            
          05  WS-PAGE-COUNT              PIC 9(03) VALUE ZERO.          
          05  WS-PGRMNAME                PIC X(08) VALUE 'PCSRP432'.    
          05  WS-NO-UNITS                PIC S9(9)V USAGE COMP-3        
                                                   VALUE ZEROS.         
          05  WS-READ-UNITS              PIC S9(9)V9 USAGE COMP-3       
                                                   VALUE ZEROS.         
          05  WS-TOT-READ-UNITS          PIC S9(10)V9 USAGE COMP-3      
                                                   VALUE ZEROS.         
          05  WS-SHIP-CD-TOT-DTS         PIC S9(10)V9 USAGE COMP-3      
                                                   VALUE ZEROS.         
          05  WS-METER-TOT-DTS           PIC S9(10)V9 USAGE COMP-3      
                                                   VALUE ZEROS.         
          05  WS-PGMNAME                 PIC X(08) VALUE 'PCSRP432'.    
          05  WS-ERR-MSG                 PIC X(40) VALUE SPACES.        
          05  WS-DISP-RC                 PIC -ZZZZZZZZ9.9.              
          05  MULTIPLE-ROWS              PIC S9(9) VALUE -811 COMP.     
          05  WS-COMPANY-NO              PIC X(02) VALUE SPACES.        
          05  WS-TOTAL-CNTR              PIC 9(04) VALUE ZERO.          
          05  WS-METER-CNTR              PIC S9(02) VALUE -1.           
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                     PIC 9(02).                     
           05  WS-MM                     PIC 9(02).                     
           05  WS-SS                     PIC 9(02).                     
           05  WS-TT                     PIC 9(02).                     
                                                                        
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-MM                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-SS                  PIC X(02).                     
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                     PIC 9(02).                     
           05  WS-CM                     PIC 9(02).                     
           05  WS-CD                     PIC 9(02).                     
                                                                        
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-DD                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-YY                  PIC X(02).                     
                                                                        
        01 WS-LITERALS.                                                 
           05 WS-G                       PIC X(01) VALUE 'G'.           
           05 WS-N                       PIC X(01) VALUE 'N'.           
           05 WS-Y                       PIC X(01) VALUE 'Y'.           
           05 WS-ONE                     PIC 9(02) VALUE 01.            
           05 WS-TWO                     PIC 9(02) VALUE 02.            
           05 WS-ONE1                    PIC 9(03) VALUE 000.           
           05 WS-ZERO                    PIC 9(02) VALUE 0.             
                                                                        
        01 WS-SWITCHES.                                                 
           05 WS-FILE-STATUS             PIC X(02).                     
              88 SUCCESSFUL                        VALUE '00'.          
                                                                        
           05 WS-FRP432-STATUS           PIC X(02) VALUE '00'.          
              88 FRP432-SUCCESSFUL                 VALUE '00'.          
                                                                        
           05 WS-MORE-ROWS-FLAG          PIC X(01) VALUE 'Y'.           
              88 END-OF-ROWS                       VALUE 'N'.           
              88 MORE-ROWS                         VALUE 'Y'.           
                                                                        
           05 WS-MORE-ACCT-FLAG          PIC X(01) VALUE 'Y'.           
              88 END-OF-ACCT                       VALUE 'N'.           
              88 MORE-ACCT                         VALUE 'Y'.           
                                                                        
           05 WS-FIRST-TIME-FLAG         PIC X(01) VALUE 'Y'.           
              88 FIRST-TIME                        VALUE 'Y'.           
              88 NOT-FIRST-TIME                    VALUE 'N'.           
                                                                        
           05 WS-PAGE-BREAK-FL           PIC X(01) VALUE 'N'.           
              88 PAGE-BREAK-FL                     VALUE 'Y'.           
                                                                        
           05 WS-EXTRA-MTR-FL            PIC X(01) VALUE 'N'.           
              88 EXTRA-MTR                         VALUE 'Y'.           
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
           05  WS-RPT-TITLE-1.                                          
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-RPT-TITLE-PGNM      PIC X(08) VALUE 'PCSRP432'.    
               10  FILLER                PIC X(09) VALUE '-PCSR4321'.   
               10  FILLER                PIC X(35) VALUE SPACES.        
               10  P-RPT-COMP-NAME       PIC X(26).                     
               10  FILLER                PIC X(35) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN-DATE: '.  
               10  P-RPT-RUN-DATE        PIC X(08).                     
                                                                        
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER         **          
      ****************************************************************          
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                PIC X(53) VALUE SPACES.        
               10  P-RPT-HEAD            PIC X(25) VALUE SPACES.        
               10  FILLER                PIC X(36) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN-TIME: '.  
               10  P-RPT-RUN-TIME        PIC X(08).                     
                                                                        
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                PIC X(118)                     
                                                   VALUE SPACES.        
               10  FILLER                PIC X(08) VALUE 'PAGE: '.      
               10  P-RPT-PAGE-NO         PIC ZZ,ZZ9.                    
                                                                        
           05  WS-RPT-HEADER-3.                                         
               10 FILLER                 PIC X(03) VALUE SPACES.        
               10 FILLER                 PIC X(15) VALUE                
                                        'ACCOUNT NUMBER'.               
               10 FILLER                 PIC X(06) VALUE SPACES.        
               10 FILLER                 PIC X(13) VALUE                
                                        'CUSTOMER NAME'.                
               10 FILLER                 PIC X(30) VALUE SPACES.        
               10 FILLER                 PIC X(12) VALUE 'METER NUMBER'.
               10 FILLER                 PIC X(17) VALUE SPACES.        
               10 FILLER                 PIC X(03) VALUE                
                                        'DTS'.                          
               10 FILLER                 PIC X(08) VALUE SPACES.        
               10 FILLER                 PIC X(04) VALUE                
                                        'DATE'.                         
               10 FILLER                 PIC X(21) VALUE SPACES.        
                                                                        
           05 WS-RPT-HEADER-4.                                          
              10 FILLER                  PIC X(133) VALUE ALL '-'.      
                                                                        
A00633    05 WS-EXCEL-HEADER-06.                                        
A00633       10 WS-XLS-ACT-NO          PIC X(10) VALUE  'ACCOUNT NO'.   
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-NAME            PIC X(04) VALUE 'NAME'.          
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-SHIP-CD         PIC X(12) VALUE 'SHIPPER CODE'.  
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-READ-UNIT       PIC X(09) VALUE 'READ UNIT'.     
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-REV-MO          PIC X(13) VALUE 'REVENUE MONTH'. 
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-IC-NO           PIC X(05) VALUE  'IC NO'.        
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-CATRY           PIC X(08) VALUE  'CATEGORY'.     
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-MET-NO          PIC X(12) VALUE  'METER NUMBER'. 
A00633       10 FILLER                 PIC X(01) VALUE  ','.            
A00633       10 WS-XLS-READ-DT         PIC X(09) VALUE 'READ DATE'.     
A04527       10 FILLER                 PIC X(01) VALUE  ','.            
A04527       10 WS-XLS-ZONE-CITY       PIC X(09) VALUE 'ZONE CITY'.     
A04527       10 FILLER                 PIC X(01) VALUE  ','.            
A04527       10 WS-XLS-MDQ             PIC X(03) VALUE 'MDQ'.           
                                                                        
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR BLANK LINE             **          
      ****************************************************************          
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
                                                                        
A00633  01 WS-EXCEL-DATA.                                               
A00633    05  WS-FRP432-ACCT-NO            PIC 9(13).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-NAME               PIC X(40).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-SHIPPER-CD         PIC X(01).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-READ-UNITS         PIC ----,---,--9.9.          
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-REV-MNTH           PIC 9(06).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-IC-NO              PIC 9(02).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-CATEGORY           PIC X(02).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-FRP432-METER-NO           PIC X(09).                   
A00633    05  FILLER                       PIC X(1) VALUE ','.          
A00633    05  WS-RP432-READ-DATE           PIC X(10).                   
A04527    05  FILLER                       PIC X(1) VALUE ','.          
A04527    05  WS-FRP432-ZONE-CITY          PIC X(20).                   
A04527    05  FILLER                       PIC X(1) VALUE ','.          
A04527    05  WS-FRP432-MDQ                PIC -,---,--9.99.            
                                                                        
        01 WS-DETAIL-LINE.                                              
           05 WS-DETAIL-LINE-1.                                         
              10 FILLER                  PIC X(03) VALUE SPACES.        
              10 P-RPT-ACCT-NUM          PIC XBXXXXBXXXXBXXXX.          
              10 FILLER                  PIC X(05) VALUE SPACES.        
              10 P-RPT-CUST-NAME         PIC X(40).                     
              10 FILLER                  PIC X(03) VALUE SPACES.        
              10 P-RPT-METER-NO          PIC X(09) VALUE SPACES.        
              10 FILLER                  PIC X(12) VALUE SPACES.        
              10 P-RPT-MTD-DTS           PIC ZZZZZZZZ9.9-.              
              10 FILLER                  PIC X(07) VALUE SPACES.        
              10 P-RPT-DATE-READ.                                       
                 15 P-RPT-MM-READ        PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE '-'.           
                 15 P-RPT-DD-READ        PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE '-'.           
                 15 P-RPT-YY-READ        PIC X(04) VALUE SPACES.        
              10 FILLER                  PIC X(19) VALUE SPACES.        
                                                                        
        01 WS-TOTAL-LINE.                                               
           05 WS-TOTAL-LINE-1.                                          
              10 FILLER                  PIC X(87) VALUE SPACES.        
              10 FILLER                  PIC X(13) VALUE ALL '-'.       
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
           05 WS-TOTAL-LINE-2.                                          
              10 FILLER                  PIC X(66) VALUE SPACES.        
              10 FILLER                  PIC X(21) VALUE                
                                     'TOTAL DTS ALL METERS '.           
              10 P-RPT-TOT-MTD-DTS       PIC ZZZZZZZZZ9.9-.             
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
           05 WS-TOTAL-LINE-3.                                          
              10 FILLER                  PIC X(87) VALUE SPACES.        
              10 FILLER                  PIC X(13) VALUE ALL '='.       
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
           05 WS-TOTAL-LINE-4.                                          
              10 FILLER                  PIC X(87) VALUE SPACES.        
              10 P-RPT-SHIP-TOT          PIC ZZZZZZZZZ9.9-.             
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
           05 WS-TOTAL-LINE-5.                                          
              10 FILLER                  PIC X(87) VALUE SPACES.        
              10 FILLER                  PIC X(13) VALUE ALL '-'.       
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
           05 WS-TOTAL-LINE-6.                                          
              10 FILLER                  PIC X(87) VALUE SPACES.        
              10 P-RPT-MTR-TOTAL         PIC ZZZZZZZZZ9.9-.             
              10 FILLER                  PIC X(32) VALUE SPACES.        
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                     PIC X(48) VALUE SPACES.        
           05 FILLER                     PIC X(31) VALUE                
               '**** NO DATA FOR THIS RUN  ****'.                       
           05 FILLER                     PIC X(53) VALUE SPACES.        
                                                                        
       01  WS-FOOTER-LINE.                                              
           05 FILLER                     PIC X(35) VALUE SPACES.        
           05 FILLER                     PIC X(25) VALUE                
               '* * * END OF REPORT * * *'.                             
           05 FILLER                     PIC X(72) VALUE SPACES.        
                                                                        
      ****************************************************************          
      **                COMMON COPYBOOK FOR WS-VARIABLES            **          
      ****************************************************************          
       COPY CWS00011.                                                           
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_JOB_PARM                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILLING_DET                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_PRTY_SVC_CAT                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_TRNSP_CONTRACT                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTRNCNT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_MTRD_ENVRNMT                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_TRNSP_VOL_BLK                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTRNBLK                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_CNSMPTN_HIST                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_FUEL_SHIPPER                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFULSHP                                                  
           END-EXEC.                                                            
                                                                        
A04527*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A04527*   CSS_BTU_INDUST                                              *         
A04527*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A04527                                                                  
A04527     EXEC SQL                                                             
A04527          INCLUDE TBBTUIND                                                
A04527     END-EXEC.                                                            
A04527                                                                  
A04527*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A04527*   CSS_BILL_CONTRACT                                           *         
A04527*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A04527                                                                  
A04527     EXEC SQL                                                             
A04527        INCLUDE TBBLCNTR                                                  
A04527     END-EXEC.                                                            
A04527                                                                  
      *****************************************************************         
      *   WORKING STORAGE FOR CPD00166                                *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00166                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR FOR FETCHING SHIPPER CODE FROM CSS_JOB_PARM TABLE    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE SHIPPER_CD CURSOR FOR                             
                 SELECT CIS.SUBSTR3(PARM_DATA,12,1)                          
                  FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                      
                 WHERE  PROGRAM_NAME      = :WS-PGRMNAME                
                   AND  COMPANY_NO        = :WS-DEFAULT-COMP-NO         
ACT188             AND  CMND_CODE         = 'PARM'                      
                   AND  STATUS            = 'A'                         
                 ORDER BY PARM_DATA                                     
A00633           FOR READ ONLY                                  
A04527                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SHIPPER_CD CURSOR FOR                                     
MFA-TR*          SELECT SUBSTR(PARM_DATA,12,1)                                  
MFA-TR*           FROM  CSS_JOB_PARM                                            
MFA-TR*          WHERE  PROGRAM_NAME      = :WS-PGRMNAME                        
MFA-TR*            AND  COMPANY_NO        = :WS-DEFAULT-COMP-NO                 
MFA-TR*            AND  CMND_CODE         = 'PARM'                              
MFA-TR*            AND  STATUS            = 'A'                                 
MFA-TR*          ORDER BY PARM_DATA                                             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*     END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *  CURSOR FOR FETCHING ACCOUNT NUMBERS FROM CSS_TRNSP_CONTRACT  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE GET_ACCT CURSOR FOR                               
                 SELECT TW.ACCOUNT_NO,                                  
                        TW.PRIMARY_IC_NO,                               
                        TW.CNTRCT_START_DT,                             
                        DQ.FULL_NAME                                    
                  FROM  CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED),            
                        CSS_NAME DQ WITH(READUNCOMMITTED),                      
                        CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                 WHERE  TW.CODE_UTIL_TYPE    = :WS-G                    
                   AND  TW.FUEL_SHIPPER_CD   = :WS-FUEL-SHIPPER-CD      
                   AND  HT.ACCOUNT_NO        = TW.ACCOUNT_NO            
                   AND  DQ.NAME_TYPE         = 'CN'                     
                   AND  HT.NAME_ID           =  DQ.NAME_ID              
                   AND  HT.CUSTOMER_ROLE_CD  = ''                       
A00633             AND  TW.CNTRCT_START_DT  =                           
A00633              (SELECT MAX(T1.CNTRCT_START_DT)                     
A00633                FROM CSS_TRNSP_VOL_BLK T1 WITH(READUNCOMMITTED)           
A00633               WHERE T1.ACCOUNT_NO       = TW.ACCOUNT_NO          
A00633                 AND T1.CODE_UTIL_TYPE   = :WS-G                  
A00633                 AND T1.PRIMARY_IC_NO    = TW.PRIMARY_IC_NO       
A00633                 AND T1.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) ))      
                 ORDER BY DQ.FULL_NAME                                  
A00633           FOR READ ONLY                                  
A04527                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_ACCT CURSOR FOR                                       
MFA-TR*          SELECT TW.ACCOUNT_NO,                                          
MFA-TR*                 TW.PRIMARY_IC_NO,                                       
MFA-TR*                 TW.CNTRCT_START_DT,                                     
MFA-TR*                 DQ.FULL_NAME                                            
MFA-TR*           FROM  CSS_TRNSP_CONTRACT TW,                                  
MFA-TR*                 CSS_NAME DQ,                                            
MFA-TR*                 CSS_NAME_ACCT_XREF HT                                   
MFA-TR*          WHERE  TW.CODE_UTIL_TYPE    = :WS-G                            
MFA-TR*            AND  TW.FUEL_SHIPPER_CD   = :WS-FUEL-SHIPPER-CD              
MFA-TR*            AND  HT.ACCOUNT_NO        = TW.ACCOUNT_NO                    
MFA-TR*            AND  DQ.NAME_TYPE         = 'CN'                             
MFA-TR*            AND  HT.NAME_ID           =  DQ.NAME_ID                      
MFA-TR*            AND  HT.CUSTOMER_ROLE_CD  = ''                               
MFA-TR*            AND  TW.CNTRCT_START_DT  =                                   
MFA-TR*             (SELECT MAX(T1.CNTRCT_START_DT)                             
MFA-TR*               FROM CSS_TRNSP_VOL_BLK T1                                 
MFA-TR*              WHERE T1.ACCOUNT_NO       = TW.ACCOUNT_NO                  
MFA-TR*                AND T1.CODE_UTIL_TYPE   = :WS-G                          
MFA-TR*                AND T1.PRIMARY_IC_NO    = TW.PRIMARY_IC_NO               
MFA-TR*                AND T1.CNTRCT_START_DT <= :WS-REVENUE-DATE)              
MFA-TR*          ORDER BY DQ.FULL_NAME                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*     END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *  CURSOR FOR FETCHING IC NUMBERS FROM CSS_TRNSP_VOL_BLK        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE GET_IC CURSOR FOR                                 
                 SELECT DISTINCT IC_NO                                  
                  FROM  CSS_TRNSP_VOL_BLK WITH(READUNCOMMITTED)                 
                 WHERE  ACCOUNT_NO       = :TW-ACCOUNT-NO               
                  AND   CODE_UTIL_TYPE   = :WS-G                        
                  AND   PRIMARY_IC_NO    = :TW-PRIMARY-IC-NO            
                  AND   CNTRCT_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :TW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TW-CNTRCT-START-DT
              ), CONVERT(DATE, :TW-CNTRCT-START-DT) )          
A00633           FOR READ ONLY                                  
A04527                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_IC CURSOR FOR                                         
MFA-TR*          SELECT DISTINCT IC_NO                                          
MFA-TR*           FROM  CSS_TRNSP_VOL_BLK                                       
MFA-TR*          WHERE  ACCOUNT_NO       = :TW-ACCOUNT-NO                       
MFA-TR*           AND   CODE_UTIL_TYPE   = :WS-G                                
MFA-TR*           AND   PRIMARY_IC_NO    = :TW-PRIMARY-IC-NO                    
MFA-TR*           AND   CNTRCT_START_DT  = :TW-CNTRCT-START-DT                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*     END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *  CURSOR FOR SELECTING DETAILS FROM CSS_CNSMPTN_HIST TABLE     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE CX_CURSOR CURSOR FOR                              
                SELECT SUM(NO_UNITS),                                   
                       BTU_FACTOR,                                      
                       MTR_REF_NO,                                      
                       METER_NO,                                        
                       DATE_READ                                        
                  FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
                   AND BILL_NO            = :BG-BILL-NO                 
                   AND CODE_UTIL_TYPE     = :WS-G                       
                   AND IC_NO              = :BG-IC-NO                   
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
                   AND COMPANY_NO         = :WS-DEFAULT-COMP-NO         
                GROUP BY MTR_REF_NO,METER_NO, DATE_READ, BTU_FACTOR     
                ORDER BY MTR_REF_NO,METER_NO, DATE_READ, BTU_FACTOR     
A00633           FOR READ ONLY                                  
A04527                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CX_CURSOR CURSOR FOR                                      
MFA-TR*         SELECT SUM(NO_UNITS),                                           
MFA-TR*                BTU_FACTOR,                                              
MFA-TR*                MTR_REF_NO,                                              
MFA-TR*                METER_NO,                                                
MFA-TR*                DATE_READ                                                
MFA-TR*           FROM CSS_CNSMPTN_HIST                                         
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :BG-BILL-NO                         
MFA-TR*            AND CODE_UTIL_TYPE     = :WS-G                               
MFA-TR*            AND IC_NO              = :BG-IC-NO                           
MFA-TR*            AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*            AND COMPANY_NO         = :WS-DEFAULT-COMP-NO                 
MFA-TR*         GROUP BY MTR_REF_NO,METER_NO, DATE_READ, BTU_FACTOR             
MFA-TR*         ORDER BY MTR_REF_NO,METER_NO, DATE_READ, BTU_FACTOR             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7650                                                   
MFA-TR*     END-EXEC.                                                           
                                                                        
       01  WS-END                        PIC X(40) VALUE                
             'WORKING STORAGE FOR PCSRP432 ENDS HERE  '.                
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  WS-PARM-VALUE.                                               
           05  WS-PARM-LENGTH            PIC S9(04) COMP.               
           05  WS-PARM-SHIPPER-CD        PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO  WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      **                                                       **               
      **   0100-INITIALIZATION.                                **               
      **       INITIALIZATION ROUTINE                          **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN OUTPUT FCSRP432-FILE.                                   
                                                                        
           IF FRP432-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN OPENING FCSRP432 - FILE FILE STATUS :'  
                                                 WS-FRP432-STATUS       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
                                                                        
           MOVE WS-HH                      TO WS-RT-HH.                 
           MOVE WS-MM                      TO WS-RT-MM.                 
           MOVE WS-SS                      TO WS-RT-SS.                 
           MOVE WS-RUN-TIME                TO P-RPT-RUN-TIME.           
                                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE WS-CY                      TO WS-RD-YY.                 
           MOVE WS-CM                      TO WS-RD-MM.                 
           MOVE WS-CD                      TO WS-RD-DD.                 
           MOVE WS-RUN-DATE                TO P-RPT-RUN-DATE.           
                                                                        
           PERFORM 7850-GET-COMPANY-DESC   THRU 7850-EXIT.              
           IF WS-ACTIVE-RETURN-CODE        EQUAL SUCCESSFUL-CALL        
              MOVE C7-COMPANY-NAME         TO WS-COMP-NAME              
           END-IF.                                                      
                                                                        
A00633     PERFORM 8910-WRITE-HEADER-PARA  THRU 8910-EXIT.              
                                                                        
           PERFORM 0110-PROCESS-PARM-DATE  THRU 0110-EXIT.              
                                                                        
           INITIALIZE TW-ACCOUNT-NO.                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      **                                                       **               
      **   0110-PROCESS-PARM-DATE.                             **               
      **       PROCESSES THE REVENUE MONTH PARM.               **               
      ***********************************************************               
                                                                        
       0110-PROCESS-PARM-DATE.                                          
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
           IF END-OF-SYSIPT                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
                                                                        
           MOVE WS-PARM-YR                 TO WS-REV-CCYY.              
           MOVE WS-PARM-MONTH              TO WS-REV-MM.                
           MOVE WS-RPT-REV-MTH             TO WS-REVENUE-MONTH.         
A00633     MOVE WS-REVENUE-MONTH(1:4)      TO WS-REVENUE-CCYY.          
A00633     MOVE WS-REVENUE-MONTH(5:2)      TO WS-REVENUE-MM.            
A00633     MOVE WS-REVENUE-MONTH-DT        TO WS-REVENUE-DATE.          
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS BEGINS HERE                      **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
            MOVE '1000'                    TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A00633      IF WS-PARM-LENGTH = 0                                       
A00633         MOVE SPACE TO WS-PARM-SHIPPER-CD                         
A00633      END-IF.                                                     
                                                                        
A00633      DISPLAY "WS-PARM-SHIPPER-CD = " WS-PARM-SHIPPER-CD.         
                                                                        
CIGPRJ      IF WS-PARM-SHIPPER-CD = ' '                                 
CIGPRJ          PERFORM 7100-OPEN-SHIPPER-CD   THRU 7100-EXIT           
                PERFORM 7200-FETCH-SHIPPER-CD  THRU 7200-EXIT           
A00633          DISPLAY "WS-FUEL-SHIPPER-CD = " WS-FUEL-SHIPPER-CD      
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   PERFORM 2000-PROCESS-SHIPPER-CD                      
                                           THRU 2000-EXIT               
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
CIGPRJ          END-IF                                                  
CIGPRJ          PERFORM 7250-CLOSE-SHIPPER-CD  THRU 7250-EXIT           
            ELSE                                                        
A00633         DISPLAY "ELSE WS-PARM-SHIPPER-CD = " WS-PARM-SHIPPER-CD  
               MOVE WS-PARM-SHIPPER-CD     TO WS-FUEL-SHIPPER-CD        
               PERFORM 2000-PROCESS-SHIPPER-CD                          
                                           THRU 2000-EXIT               
            END-IF.                                                     
                                                                        
            IF WS-TOTAL-CNTR = 0                                        
               PERFORM 8100-PRINT-RPT-NO-DATA                           
                                           THRU 8100-EXIT               
            ELSE                                                        
               IF WS-METER-CNTR > 1                                     
                  MOVE WS-METER-TOT-DTS    TO P-RPT-MTR-TOTAL           
                  IF WS-LINE-COUNT > WS-MAX-LINES                       
                     PERFORM 8500-PRINT-RPT-HEADERS                     
                                           THRU 8500-EXIT               
                  END-IF                                                
                                                                        
                  MOVE WS-TOTAL-LINE-5     TO PRT33-RECORD              
                  PERFORM 8900-WRITE-REPORT                             
                                           THRU 8900-EXIT               
                  ADD  WS-ONE              TO WS-LINE-COUNT             
                                                                        
                  IF WS-LINE-COUNT > WS-MAX-LINES                       
                     PERFORM 8500-PRINT-RPT-HEADERS                     
                                           THRU 8500-EXIT               
                  END-IF                                                
                                                                        
                  MOVE WS-TOTAL-LINE-6     TO PRT33-RECORD              
                  PERFORM 8900-WRITE-REPORT                             
                                           THRU 8900-EXIT               
                  ADD  WS-ONE              TO WS-LINE-COUNT             
                                                                        
                  IF WS-LINE-COUNT > WS-MAX-LINES                       
                     PERFORM 8500-PRINT-RPT-HEADERS                     
                                           THRU 8500-EXIT               
                  END-IF                                                
                                                                        
                  MOVE WS-BLANK-LINE       TO PRT33-RECORD              
                  PERFORM 8900-WRITE-REPORT                             
                                           THRU 8900-EXIT               
                  ADD  WS-ONE              TO WS-LINE-COUNT             
                                                                        
                  INITIALIZE WS-METER-TOT-DTS , P-RPT-MTR-TOTAL         
               END-IF                                                   
                                                                        
               MOVE WS-TOT-READ-UNITS      TO P-RPT-TOT-MTD-DTS         
               MOVE WS-TOTAL-LINE-1        TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
               MOVE WS-TOTAL-LINE-2        TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
               MOVE WS-BLANK-LINE          TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
               MOVE WS-SHIP-CD-TOT-DTS     TO P-RPT-SHIP-TOT            
                                                                        
               MOVE WS-TOTAL-LINE-3        TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
               MOVE WS-TOTAL-LINE-4        TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
               MOVE WS-TOTAL-LINE-3        TO PRT33-RECORD              
               PERFORM 8900-WRITE-REPORT   THRU 8900-EXIT               
               ADD  WS-ONE                 TO WS-LINE-COUNT             
                                                                        
            END-IF.                                                     
                                                                        
            PERFORM 8400-PRINT-RPT-FOOTER  THRU 8400-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    2000-PROCESS-SHIPPER-CD.                               **           
      **         PROCESSES FOR SHIPPER_CD CURSOR                   **           
      ***************************************************************           
                                                                        
       2000-PROCESS-SHIPPER-CD.                                         
                                                                        
           MOVE '2000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7300-OPEN-GET-ACCT      THRU 7300-EXIT               
                                                                        
           PERFORM 7350-FETCH-GET-ACCT     THRU 7350-EXIT               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2100-PROCESS-GET-ACCT                             
                                           THRU 2100-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           END-IF                                                       
                                                                        
           PERFORM 7400-CLOSE-GET-ACCT     THRU 7400-EXIT               
                                                                        
CIGPRJ     IF WS-PARM-SHIPPER-CD = ' '                                  
               PERFORM 7200-FETCH-SHIPPER-CD   THRU 7200-EXIT           
CIGPRJ     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    2100-PROCESS-GET-ACCT                                  **           
      **         PROCESSES FOR GET_ACCT CURSOR                     **           
      ***************************************************************           
                                                                        
       2100-PROCESS-GET-ACCT.                                           
                                                                        
           MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-FULL-NAME               TO WS-EMB-INPUT              
           MOVE 50                         TO WS-EMB-LENG               
           MOVE SPACES                     TO WS-CMP-TABLE              
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                           THRU 6010-EXIT               
           MOVE WS-CMP-TABLE               TO WS-FULL-NAME              
           MOVE WS-FULL-NAME               TO WS-CUST-NAME              
                                                                        
           PERFORM 7450-OPEN-GET-IC        THRU 7450-EXIT.              
                                                                        
           PERFORM 7500-FETCH-GET-IC       THRU 7500-EXIT               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2200-PROCESS-DETAIL-PARA                          
                                           THRU 2200-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           END-IF                                                       
                                                                        
           PERFORM 7550-CLOSE-GET-IC       THRU 7550-EXIT.              
                                                                        
           PERFORM 7350-FETCH-GET-ACCT     THRU 7350-EXIT.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    2200-PROCESS-DETAIL-PARA                               **           
      **         PROCESSES FOR EACH ACCOUNT                        **           
      ***************************************************************           
                                                                        
       2200-PROCESS-DETAIL-PARA.                                        
                                                                        
           MOVE '2200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE TW-ACCOUNT-NO              TO BG-ACCOUNT-NO             
           MOVE TZ-IC-NO                   TO BG-IC-NO                  
           MOVE WS-G                       TO BG-CODE-UTIL-TYPE         
           MOVE WS-REVENUE-MONTH           TO BG-REVENUE-MONTH          
                                                                        
           SET BG-RECORD-NOT-EXISTS        TO TRUE.                     
           MOVE 'N'                        TO WS-NO-MORE-BG-SW.         
      *    PERFORM 7110-OPEN-ORIG-BILL-CURSOR                                   
      *                                    THRU 7110-EXIT.                      
      *    PERFORM 7120-FETCH-ORIG-BILL-CURSOR                                  
      *                                    THRU 7120-EXIT.                      
      *  PROCESS TO GET THE BILLING DETAILS FOR FUTURE BILL                     
      *    IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                             
              PERFORM 7999-CHECK-FUTURE-BILL                            
                                           THRU 7999-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR         
                                             MULTIPLE-ROWS              
                 PERFORM 7800-GET-CATEGORY THRU 7800-EXIT               
                 IF WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND              
                    MOVE SPACES            TO Z4-PRTY-SVC-CAT-CD        
                 END-IF                                                 
                 PERFORM 7650-OPEN-CX-CURSOR                            
                                           THRU 7650-EXIT               
                 PERFORM 7700-FETCH-CX-CURSOR                           
                                           THRU 7700-EXIT               
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    PERFORM 2300-PROCESS-CX-CURSOR                      
                                           THRU 2300-EXIT               
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 END-IF                                                 
                 PERFORM 7750-CLOSE-CX-CURSOR                           
                                           THRU 7750-EXIT               
              END-IF                                                    
      *    ELSE                                                                 
      * PROCESS TO GET THE LATEST BILLING DETAILS                               
      *      PERFORM UNTIL WS-NO-MORE-BG-SW = 'Y'                               
      *        SET BG-RECORD-EXISTS        TO TRUE                              
      *        PERFORM 7150-OBTAIN-ALL-BG                                       
      *                                    THRU 7150-EXIT                       
      *        IF BG-RECORD-EXISTS                                              
      *           PERFORM 7800-GET-CATEGORY                                     
      *                                    THRU 7800-EXIT                       
      *           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                      
      *              MOVE SPACES           TO Z4-PRTY-SVC-CAT-CD                
      *           END-IF                                                        
      *           PERFORM 7650-OPEN-CX-CURSOR                                   
      *                                    THRU 7650-EXIT                       
      *           PERFORM 7700-FETCH-CX-CURSOR                                  
      *                                    THRU 7700-EXIT                       
      *           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                
      *              PERFORM 2300-PROCESS-CX-CURSOR                             
      *                                    THRU 2300-EXIT                       
      *              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
      *           END-IF                                                        
      *           PERFORM 7750-CLOSE-CX-CURSOR                                  
      *                                    THRU 7750-EXIT                       
      *        END-IF                                                           
      *        PERFORM 7120-FETCH-ORIG-BILL-CURSOR                              
      *                                    THRU 7120-EXIT                       
      *      END-PERFORM                                                        
      *    END-IF.                                                              
      *    PERFORM 7130-CLOSE-ORIG-BILL-CURSOR                                  
      *                                    THRU 7130-EXIT                       
           PERFORM 7500-FETCH-GET-IC       THRU 7500-EXIT.              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    2300-PROCESS-CX-CURSOR                                 **           
      **         PROCESSES FOR CX_CURSOR                           **           
      ***************************************************************           
      *                                                                         
       2300-PROCESS-CX-CURSOR.                                          
                                                                        
           MOVE '2300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           ADD 1                           TO WS-TOTAL-CNTR             
                                                                        
           IF TW-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
              AND NOT-FIRST-TIME                                        
              IF EXTRA-MTR                                              
                 ADD 1                     TO WS-METER-CNTR             
              END-IF                                                    
              MOVE 'N'                     TO WS-EXTRA-MTR-FL           
              MOVE WS-TOT-READ-UNITS       TO P-RPT-TOT-MTD-DTS         
              MOVE ZERO                    TO WS-TOT-READ-UNITS         
           ELSE                                                         
              IF CX-METER-NO NOT EQUAL WS-PREV-METER-NO                 
                 SET EXTRA-MTR             TO TRUE                      
                 ADD 1                     TO WS-METER-CNTR             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           COMPUTE WS-READ-UNITS ROUNDED                                
                                 = (WS-NO-UNITS * CX-BTU-FACTOR)/10     
                                                                        
           COMPUTE WS-TOT-READ-UNITS ROUNDED                            
                                 = WS-TOT-READ-UNITS + WS-READ-UNITS    
                                                                        
           PERFORM 7950-SELECT-METER-NO    THRU 7950-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00633        MOVE MN-METER-NO             TO WS-FRP432-METER-NO        
                                              P-RPT-METER-NO            
           ELSE                                                         
A00633        MOVE CX-METER-NO             TO WS-FRP432-METER-NO        
                                              P-RPT-METER-NO            
           END-IF.                                                      
                                                                        
A04527     INITIALIZE FD-INDUST-BTU-DESC.                               
A04527     PERFORM 7960-GET-ZONE-CITY       THRU 7960-EXIT.             
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04527        MOVE FD-INDUST-BTU-DESC      TO WS-FRP432-ZONE-CITY       
A04527     END-IF.                                                      
A04527                                                                  
A04527     INITIALIZE BK-CONTRACT-DEMAND.                               
A04527     PERFORM 7970-GET-MDQ-DETAIL     THRU 7970-EXIT.              
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04527        MOVE BK-CONTRACT-DEMAND      TO WS-FRP432-MDQ             
A04527     END-IF.                                                      
A04527                                                                  
A00633     MOVE TW-ACCOUNT-NO              TO WS-FRP432-ACCT-NO         
A00633     INSPECT WS-CUST-NAME   REPLACING ALL ',' BY SPACE.           
A00633     MOVE WS-CUST-NAME               TO WS-FRP432-NAME            
A00633     MOVE WS-FUEL-SHIPPER-CD         TO WS-FRP432-SHIPPER-CD      
A00633     MOVE WS-READ-UNITS              TO WS-FRP432-READ-UNITS      
A00633     MOVE WS-REVENUE-MONTH           TO WS-FRP432-REV-MNTH        
A00633     MOVE TZ-IC-NO                   TO WS-FRP432-IC-NO           
A00633     MOVE Z4-PRTY-SVC-CAT-CD         TO WS-FRP432-CATEGORY        
A00633     MOVE CX-DATE-READ               TO WS-RP432-READ-DATE        
                                                                        
A00633     MOVE WS-EXCEL-DATA              TO FIORP432                  
           PERFORM 8800-WRITE-FCSRP432     THRU 8800-EXIT.              
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT   THRU 8000-EXIT.              
                                                                        
           PERFORM 7700-FETCH-CX-CURSOR    THRU 7700-EXIT.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    6010-REDUCE-EMBEDDED-SPACES                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    6200-GET-PARAMETER-DATE                                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      * CURSOR TO GET THE LATEST VERSION OF EACH BILL              *            
      **************************************************************            
      *    EXEC SQL                                                             
      *       INCLUDE CPD00166                                                  
      *    END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **    7100-OPEN-SHIPPER-CD                                   **           
      **         OPENS CURSOR ON CSS_JOB_PARM TABLE                **           
      ***************************************************************           
                                                                        
       7100-OPEN-SHIPPER-CD.                                            
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN SHIPPER_CD                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7100-OPEN-SHIPPER-CD'  TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **    7200-FETCH-SHIPPER-CD.                                 **           
      **         FETCHES ROWS FROM CURSOR ON CSS_JOB_PARM TABLE    **           
      ***************************************************************           
      *                                                                         
       7200-FETCH-SHIPPER-CD.                                           
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH SHIPPER_CD INTO                                   
                   :WS-FUEL-SHIPPER-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7200-FETCH-SHIPPER-CD'                              
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7250-CLOSE-SHIPPER-CD.                                 **           
      **         CLOSES CURSOR ON CSS_JOB_PARM TABLE               **           
      ***************************************************************           
                                                                        
       7250-CLOSE-SHIPPER-CD.                                           
                                                                        
           MOVE '7250'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE SHIPPER_CD                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7250-CLOSE-SHIPPER-CD' TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **    7300-OPEN-GET-ACCT.                                    **           
      **         OPENS CURSOR ON CSS_TRNSP_CONTRACT                **           
      ***************************************************************           
                                                                        
       7300-OPEN-GET-ACCT.                                              
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN GET_ACCT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7300-OPEN-GET-ACCT'    TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7350-FETCH-GET-ACCT.                                   **           
      **         FETCHES ROWS FROM CURSOR ON CSS_TRNSP_CONTRACT    **           
      ***************************************************************           
                                                                        
       7350-FETCH-GET-ACCT.                                             
                                                                        
           MOVE '7350'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH GET_ACCT INTO                                     
                   :TW-ACCOUNT-NO,                                      
                   :TW-PRIMARY-IC-NO,                                   
                   :TW-CNTRCT-START-DT,                                 
                   :WS-FULL-NAME                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7350-FETCH-GET-ACCT'   TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7400-CLOSE-GET-ACCT.                                   **           
      **         CLOSES CURSOR ON CSS_TRNSP_CONTRACT               **           
      ***************************************************************           
                                                                        
       7400-CLOSE-GET-ACCT.                                             
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE GET_ACCT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7400-CLOSE-GET-ACCT'   TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7450-OPEN-GET-IC.                                      **           
      **         OPENS CURSOR ON CSS_TRNSP_VOL_BLK                 **           
      ***************************************************************           
                                                                        
        7450-OPEN-GET-IC.                                               
                                                                        
           MOVE '7450'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN GET_IC                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7450-OPEN-GET-IC'      TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7500-FETCH-GET-IC.                                     **           
      **         FETCHES ROWS FROM CURSOR ON CSS_TRNSP_VOL_BLK     **           
      ***************************************************************           
                                                                        
       7500-FETCH-GET-IC.                                               
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH GET_IC INTO                                       
                   :TZ-IC-NO                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7500-FETCH-GET-IC'     TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7550-CLOSE-GET-IC.                                     **           
      **         CLOSES CURSOR ON CSS_TRNSP_VOL_BLK                **           
      ***************************************************************           
                                                                        
       7550-CLOSE-GET-IC.                                               
                                                                        
           MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE GET_IC                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7550-CLOSE-GET-IC'     TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7650-OPEN-CX-CURSOR.                                   **           
      **         OPENS CURSOR ON CSS_CNSMPTN_HIST                  **           
      ***************************************************************           
                                                                        
       7650-OPEN-CX-CURSOR.                                             
                                                                        
           MOVE '7650'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN CX_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7650-OPEN-CX-CURSOR'   TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7700-FETCH-CX-CURSOR.                                  **           
      **         FETCHES ROWS FROM CURSOR ON CSS_CNSMPTN_HIST      **           
      ***************************************************************           
                                                                        
       7700-FETCH-CX-CURSOR.                                            
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH CX_CURSOR INTO                                    
                   :WS-NO-UNITS,                                        
                   :CX-BTU-FACTOR,                                      
                   :CX-MTR-REF-NO,                                      
                   :CX-METER-NO,                                        
                   :CX-DATE-READ                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7700-FETCH-CX-CURSOR'  TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7750-CLOSE-CX-CURSOR.                                  **           
      **         CLOSES CURSOR ON CSS_CNSMPTN_HIST                 **           
      ***************************************************************           
                                                                        
       7750-CLOSE-CX-CURSOR.                                            
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE CX_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE '7750-CLOSE-CX-CURSOR'  TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **   7775-GET-FUEL-SHIPPER-NAME.                              **          
      **        GETS SHIPPER NAME FROM CSS_FUEL_SHIPPER             **          
      ****************************************************************          
                                                                        
       7775-GET-FUEL-SHIPPER-NAME.                                      
                                                                        
           MOVE '7775'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT W5.FUEL_SHIPPER_NM                                  
               INTO :W5-FUEL-SHIPPER-NM                                 
               FROM CSS_FUEL_SHIPPER W5 WITH(READUNCOMMITTED)                   
              WHERE W5.FUEL_SHIPPER_CD    = :W5-FUEL-SHIPPER-CD         
A00633                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT W5.FUEL_SHIPPER_NM                                          
MFA-TR*        INTO :W5-FUEL-SHIPPER-NM                                         
MFA-TR*        FROM CSS_FUEL_SHIPPER W5                                         
MFA-TR*       WHERE W5.FUEL_SHIPPER_CD    = :W5-FUEL-SHIPPER-CD                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7775                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7775-GET-FUEL-SHIPPER-NAME'                         
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **   7800-GET-CATEGORY.                                       **          
      **        GETS CATEGORY FROM CSS_PRTY_SVC_CAT TABLE           **          
      ****************************************************************          
                                                                        
       7800-GET-CATEGORY.                                               
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT Z4.PRTY_SVC_CAT_CD                                  
               INTO :Z4-PRTY-SVC-CAT-CD                                 
               FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED),                  
                    CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                   
              WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO              
                AND BG.BILL_NO            = :BG-BILL-NO                 
                AND BG.CODE_UTIL_TYPE     = :WS-G                       
                AND BG.IC_NO              = :BG-IC-NO                   
                AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
                AND BG.COMPANY_NO         = :WS-DEFAULT-COMP-NO         
                AND BG.COMPANY_NO         = Z4.COMPANY_NO               
                AND BG.CODE_CURTAIL_PRTY  = Z4.CODE_CURTAIL_PRTY        
A00633                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT Z4.PRTY_SVC_CAT_CD                                          
MFA-TR*        INTO :Z4-PRTY-SVC-CAT-CD                                         
MFA-TR*        FROM CSS_BILLING_DET  BG,                                        
MFA-TR*             CSS_PRTY_SVC_CAT Z4                                         
MFA-TR*       WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*         AND BG.BILL_NO            = :BG-BILL-NO                         
MFA-TR*         AND BG.CODE_UTIL_TYPE     = :WS-G                               
MFA-TR*         AND BG.IC_NO              = :BG-IC-NO                           
MFA-TR*         AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*         AND BG.COMPANY_NO         = :WS-DEFAULT-COMP-NO                 
MFA-TR*         AND BG.COMPANY_NO         = Z4.COMPANY_NO                       
MFA-TR*         AND BG.CODE_CURTAIL_PRTY  = Z4.CODE_CURTAIL_PRTY                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7800-GET-CATEGORY'     TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **   7850-GET-COMPANY-DESC                                    **          
      **        GETS COMPANY NAME FROM CSS_COMPANY                  **          
      ****************************************************************          
                                                                        
       7850-GET-COMPANY-DESC.                                           
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :WS-DEFAULT-COMP-NO                    
A00633                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :WS-DEFAULT-COMP-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7850-GET-COMPANY-DESC' TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **   7950-SELECT-METER-NO.                                    **          
      **        SELECTS METER NUMBER FROM CSS_MTRD_ENVRNMT TABLE    **          
      ****************************************************************          
                                                                        
       7950-SELECT-METER-NO.                                            
                                                                        
           MOVE '7950'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT METER_NO                                            
               INTO :MN-METER-NO                                        
               FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO     = :TW-ACCOUNT-NO                     
                AND CODE_UTIL_TYPE = :WS-G                              
                AND IC_NO          = :TZ-IC-NO                          
                AND MTR_REF_NO     = :CX-MTR-REF-NO                     
A00633                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT METER_NO                                                    
MFA-TR*        INTO :MN-METER-NO                                                
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*       WHERE ACCOUNT_NO     = :TW-ACCOUNT-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :WS-G                                      
MFA-TR*         AND IC_NO          = :TZ-IC-NO                                  
MFA-TR*         AND MTR_REF_NO     = :CX-MTR-REF-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7950                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7950-SELECT-METER-NO'  TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7950-EXIT.                                                      
            EXIT.                                                       
                                                                        
A04527**********************************************************************    
A04527* 7960-GET-ZONE-CITY.                                               **    
A04527* GETS CITY NAME FOR THE BTU ID(ZONE ID) ACCOCIATED WITH THE        **    
A04527* INSTALLED METER.                                                  **    
A04527**********************************************************************    
A04527 7960-GET-ZONE-CITY.                                              
A04527                                                                  
A04527     MOVE '7960'                   TO WS-ACTIVE-PARAGRAPH.        
A04527                                                                  
A04527     EXEC SQL                                                     
A04527          SELECT TOP(1) FD.INDUST_BTU_DESC                               
A04527            INTO :FD-INDUST-BTU-DESC                              
A04527            FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
A04527                ,CSS_BTU_INDUST   FD WITH(READUNCOMMITTED)                
A04527           WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID          
A04527             AND MN.ACCOUNT_NO        = :TW-ACCOUNT-NO            
A04527             AND MN.CODE_UTIL_TYPE    = :WS-G                     
A04527             AND FD.COMPANY_NO        = :WS-DEFAULT-COMP-NO       
A04527             AND MN.CODE_METER_STATUS <> 'K'                      
A04527                                       
A04527                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FD.INDUST_BTU_DESC                                       
MFA-TR*           INTO :FD-INDUST-BTU-DESC                                      
MFA-TR*           FROM CSS_MTRD_ENVRNMT MN                                      
MFA-TR*               ,CSS_BTU_INDUST   FD                                      
MFA-TR*          WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID                  
MFA-TR*            AND MN.ACCOUNT_NO        = :TW-ACCOUNT-NO                    
MFA-TR*            AND MN.CODE_UTIL_TYPE    = :WS-G                             
MFA-TR*            AND FD.COMPANY_NO        = :WS-DEFAULT-COMP-NO               
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7960                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL OR NOT-FOUND 
A04527        NEXT SENTENCE                                             
A04527     ELSE                                                         
A04527        MOVE '7960-GET-ZONE-CITY' TO WS-ERR-MSG                   
A04527        MOVE SQLCODE               TO WS-DISP-RC                  
A04527        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04527     END-IF.                                                      
A04527                                                                  
A04527 7960-EXIT.                                                       
A04527      EXIT.                                                       
A04527**********************************************************************    
A04527* 7970-GET-MDQ-DETAIL.                                              **    
A04527* GETS MDQ DETAIL FROM CSS_BILL_CONTRACT TABLE.                     **    
A04527**********************************************************************    
A04527 7970-GET-MDQ-DETAIL.                                             
A04527                                                                  
A04527     MOVE '7970'                   TO WS-ACTIVE-PARAGRAPH.        
A04527                                                                  
A04527     EXEC SQL                                                     
A04527        SELECT TOP(1) BK.CONTRACT_DEMAND                                 
A04527          INTO :BK-CONTRACT-DEMAND                                
A04527          FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
A04527         WHERE BK.CODE_UTIL_TYPE  = :WS-G                         
A04527           AND BK.ACCOUNT_NO      = :TW-ACCOUNT-NO                
A04527           AND BK.IC_NO           = :TZ-IC-NO                     
A04527           AND BK.CNTRCT_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
A04527                                       
A02036                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BK.CONTRACT_DEMAND                                         
MFA-TR*         INTO :BK-CONTRACT-DEMAND                                        
MFA-TR*         FROM CSS_BILL_CONTRACT BK                               05110000
MFA-TR*        WHERE BK.CODE_UTIL_TYPE  = :WS-G                         05120000
MFA-TR*          AND BK.ACCOUNT_NO      = :TW-ACCOUNT-NO                05140000
MFA-TR*          AND BK.IC_NO           = :TZ-IC-NO                     05140000
MFA-TR*          AND BK.CNTRCT_END_DT  >= CURRENT DATE                          
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7970                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL OR NOT-FOUND 
A04527        NEXT SENTENCE                                             
A04527     ELSE                                                         
A04527        MOVE '7970-GET-MDQ-DETAIL' TO WS-ERR-MSG                  
A04527        MOVE SQLCODE               TO WS-DISP-RC                  
A04527        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04527     END-IF.                                                      
A04527                                                                  
A04527 7970-EXIT.                                                       
A04527      EXIT.                                                       
      ****************************************************************          
      **   7999-CHECK-FUTURE-BILL.                                  **          
      **        CHECKS IF THE ACCOUNT HAS A FUTURE BILL ROW         **          
      ****************************************************************          
                                                                        
       7999-CHECK-FUTURE-BILL.                                          
                                                                        
           MOVE '7999'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT BILL_NO,                                            
                    REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP                     
               INTO :BG-BILL-NO,                                        
                    :BG-BILL-ITEM-TIMESTMP                              
               FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :WS-G                          
                AND IC_NO              = :BG-IC-NO                      
                AND CODE_BILL_CALC     = 'A'                            
                AND CODE_BILL_ITM_TYPE = 'C'                            
                AND CODE_BILL_ITM_IND  = 'A'                            
                AND REVENUE_MONTH      =  0                             
                AND REV_MTH_ORIG_BILL  =  0                             
                AND CODE_REVENUE_CLASS <> '000'                         
ACT068          AND REV_RPT_CD NOT IN ('T')                             
                AND COMPANY_NO         = :WS-DEFAULT-COMP-NO            
A00633                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BILL_NO,                                                    
MFA-TR*             BILL_ITEM_TIMESTMP                                          
MFA-TR*        INTO :BG-BILL-NO,                                                
MFA-TR*             :BG-BILL-ITEM-TIMESTMP                                      
MFA-TR*        FROM CSS_BILLING_DET                                             
MFA-TR*       WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :WS-G                                  
MFA-TR*         AND IC_NO              = :BG-IC-NO                              
MFA-TR*         AND CODE_BILL_CALC     = 'A'                                    
MFA-TR*         AND CODE_BILL_ITM_TYPE = 'C'                                    
MFA-TR*         AND CODE_BILL_ITM_IND  = 'A'                                    
MFA-TR*         AND REVENUE_MONTH      =  0                                     
MFA-TR*         AND REV_MTH_ORIG_BILL  =  0                                     
MFA-TR*         AND CODE_REVENUE_CLASS <> '000'                                 
MFA-TR*         AND REV_RPT_CD NOT IN ('T')                                     
MFA-TR*         AND COMPANY_NO         = :WS-DEFAULT-COMP-NO                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7999                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR MULTIPLE-ROWS                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7999-CHECK-FUTURE-BILL'                             
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7999-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              MOVE WS-Y                    TO WS-PAGE-BREAK-FL          
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                           THRU 8500-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS  THRU 8300-EXIT.              
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "NO DATA FOR THIS RUN"               **        
      ******************************************************************        
                                                                        
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                     TO   WS-ACTIVE-PARAGRAPH.    
           PERFORM 8500-PRINT-RPT-HEADERS  THRU 8500-EXIT.              
           MOVE WS-BLANK-LINE              TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           MOVE WS-NO-DATA-LINE            TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-HEADERS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF CX-METER-NO NOT EQUAL WS-PREV-METER-NO                    
             IF WS-TOTAL-CNTR > 1 AND WS-METER-CNTR > 1                 
                 MOVE WS-METER-TOT-DTS     TO P-RPT-MTR-TOTAL           
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-5      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-6      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-BLANK-LINE        TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 INITIALIZE WS-METER-TOT-DTS , P-RPT-MTR-TOTAL          
                 MOVE 1                    TO WS-METER-CNTR             
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE CX-METER-NO                TO WS-PREV-METER-NO          
                                                                        
           MOVE WS-CUST-NAME               TO P-RPT-CUST-NAME.          
                                                                        
           IF TW-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
              OR PAGE-BREAK-FL                                          
              INITIALIZE WS-METER-TOT-DTS                               
              MOVE TW-ACCOUNT-NO           TO P-RPT-ACCT-NUM            
              INSPECT P-RPT-ACCT-NUM REPLACING ALL ' ' BY '-'           
                                                                        
              IF (TW-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO            
                 AND NOT-FIRST-TIME)                                    
                 OR                                                     
                 (TW-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO            
                 AND NOT-FIRST-TIME AND PAGE-BREAK-FL)                  
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-1      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-2      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
              END-IF                                                    
                                                                        
              MOVE TW-ACCOUNT-NO           TO WS-PREV-ACCOUNT-NO        
              SET NOT-FIRST-TIME           TO TRUE                      
                                                                        
              IF WS-LINE-COUNT > WS-MAX-LINES                           
                 PERFORM 8500-PRINT-RPT-HEADERS                         
                                           THRU 8500-EXIT               
              END-IF                                                    
                                                                        
              MOVE WS-BLANK-LINE           TO PRT33-RECORD              
              PERFORM 8900-WRITE-REPORT    THRU 8900-EXIT               
              ADD  WS-ONE                  TO WS-LINE-COUNT             
                                                                        
              MOVE WS-N                    TO WS-PAGE-BREAK-FL          
           ELSE                                                         
              MOVE SPACES                  TO P-RPT-ACCT-NUM            
              MOVE SPACES                  TO P-RPT-CUST-NAME           
           END-IF                                                       
                                                                        
           IF WS-FUEL-SHIPPER-CD NOT EQUAL WS-PREV-FUEL-SHIPPER-CD      
             IF WS-TOTAL-CNTR > 1                                       
                 MOVE WS-SHIP-CD-TOT-DTS   TO P-RPT-SHIP-TOT            
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-3      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-4      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 IF WS-LINE-COUNT > WS-MAX-LINES                        
                    PERFORM 8500-PRINT-RPT-HEADERS                      
                                           THRU 8500-EXIT               
                 END-IF                                                 
                                                                        
                 MOVE WS-TOTAL-LINE-3      TO PRT33-RECORD              
                 PERFORM 8900-WRITE-REPORT THRU 8900-EXIT               
                 ADD  WS-ONE               TO WS-LINE-COUNT             
                                                                        
                 INITIALIZE WS-SHIP-CD-TOT-DTS, P-RPT-SHIP-TOT          
                 MOVE 57                   TO WS-LINE-COUNT             
              END-IF                                                    
              MOVE WS-FUEL-SHIPPER-CD      TO WS-PREV-FUEL-SHIPPER-CD   
           END-IF.                                                      
                                                                        
           COMPUTE WS-METER-TOT-DTS ROUNDED                             
                                 = WS-METER-TOT-DTS + WS-READ-UNITS     
                                                                        
           COMPUTE WS-SHIP-CD-TOT-DTS ROUNDED                           
                                 = WS-SHIP-CD-TOT-DTS + WS-READ-UNITS   
                                                                        
           MOVE WS-READ-UNITS              TO P-RPT-MTD-DTS.            
           MOVE CX-DATE-READ(1:4)          TO P-RPT-YY-READ.            
           MOVE CX-DATE-READ(6:2)          TO P-RPT-MM-READ.            
           MOVE CX-DATE-READ(9:2)          TO P-RPT-DD-READ.            
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                           THRU 8500-EXIT               
           END-IF                                                       
                                                                        
           MOVE WS-DETAIL-LINE-1           TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD  WS-ONE                     TO WS-LINE-COUNT.            
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER TO THE REPORT FILE                   **        
      ******************************************************************        
                                                                        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-BLANK-LINE              TO PRT33-RECORD.             
           WRITE PRT33-RECORD.                                          
           MOVE WS-FOOTER-LINE             TO PRT33-RECORD.             
           WRITE PRT33-RECORD.                                          
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-TITLES.                                      **        
      **       WRITES THE HEADER TO THE REPORT FILE                   **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
      *    PRINTS REPORT TITLE                                                  
           IF WS-PAGE-COUNT GREATER THAN WS-ONE1                        
              MOVE WS-BLANK-LINE           TO PRT33-RECORD              
              PERFORM 8900-WRITE-REPORT    THRU 8900-EXIT               
              ADD WS-ONE                   TO WS-LINE-COUNT             
           END-IF.                                                      
           ADD 1                           TO WS-PAGE-COUNT.            
           MOVE WS-PAGE-COUNT              TO P-RPT-PAGE-NO.            
           MOVE WS-COMP-NAME               TO P-RPT-COMP-NAME.          
           MOVE WS-RPT-TITLE-1             TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
      *    PRINTS REPORT HEADERS                                                
                                                                        
           MOVE WS-FUEL-SHIPPER-CD         TO W5-FUEL-SHIPPER-CD        
           PERFORM 7775-GET-FUEL-SHIPPER-NAME                           
                                           THRU 7775-EXIT               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE W5-FUEL-SHIPPER-NM      TO P-RPT-HEAD                
           ELSE                                                         
              MOVE SPACES                  TO P-RPT-HEAD                
           END-IF.                                                      
                                                                        
           MOVE WS-RPT-HEADER-1            TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
           MOVE WS-RPT-HEADER-2            TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
           MOVE WS-BLANK-LINE              TO PRT33-RECORD              
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT               
           ADD WS-ONE                      TO WS-LINE-COUNT             
                                                                        
           MOVE WS-RPT-HEADER-4            TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
           MOVE WS-RPT-HEADER-3            TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
           MOVE WS-RPT-HEADER-4            TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD  WS-ONE                     TO WS-LINE-COUNT.            
                                                                        
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8800-WRITE-FCSRP432.                                        **        
      **       WRITES THE OUPUT FILE FCSRP432-FILE                    **        
      ******************************************************************        
                                                                        
       8800-WRITE-FCSRP432.                                             
                                                                        
           MOVE '8800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A00633     WRITE FIORP432                  FROM WS-EXCEL-DATA           
                                                                        
           IF FRP432-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN WRITING FCSRP432 - FILE FILE STATUS :'  
                                                 WS-FRP432-STATUS       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      ******************************************************************        
                                                                        
       8900-WRITE-REPORT.                                               
                                                                        
            MOVE '8900'                    TO WS-ACTIVE-PARAGRAPH.      
                                                                        
            IF WS-LINE-COUNT > WS-MAX-LINES                             
               WRITE PRT33-RECORD AFTER ADVANCING PAGE                  
               MOVE  WS-ZERO               TO WS-LINE-COUNT             
            ELSE                                                        
               WRITE PRT33-RECORD                                       
            END-IF.                                                     
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                *03240103
A00633***************************************************************** 03240205
A00633* 8910-WRITE-HEADER-PARA.                                       * 03240305
A00633***************************************************************** 03240405
A00633 8910-WRITE-HEADER-PARA.                                          
A00633*                                                                *03251303
A00633     WRITE FIORP432   FROM WS-EXCEL-HEADER-06.                    
A00633     WRITE FIORP432   FROM WS-BLANK-LINE.                         
A00633                                                                  
A00633 8910-EXIT.                                                       
A00633     EXIT.                                                        
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSRP432-FILE.                                         
                                                                        
           IF FRP432-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN CLOSING FCSRP432 - FILE FILE STATUS :'  
                                                 WS-FRP432-STATUS       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP442  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
