       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP430.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     NOV 03, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***THIS PROGRAM IS TO EXTRACT ELECTRIC METERS FOR A REPORT WHEN***        
      ***   MN.CODE_METER_STATUS <> 'K'                              ***        
      ***   MN.DIGTL_MTR_TYPE IN ('SS ','X1 ')                       ***        
      ***PROGRAM USES CSS_JOB_PARM (PCSCA204) FOR REVENUE MONTH      ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT033***  11/23/2015    VV7M728     CSR430 EZT TO COBOL CONVERSION  ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSPT294-FILE                                         
               ASSIGN TO UT-S-FCSBW294                                  
               FILE STATUS IS WS-FCA294-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      *                                                                         
       FD  FCSPT294-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT294-RECORD                        PIC X(294).             
      *                                                                         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP430'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_PEAK_HISTORY                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPKHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FORMATTED                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FREEFORM                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME                                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PREMISE                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ZIP_CODE                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUSTOMER                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIPMENT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_METER                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ELEC_METER                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTR_CAP                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_METER_ATTCHMTS                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_PHONE                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      *                                                                         
      **********************************T*******************************        
      *    CSS_PIM_POINT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILLING_DET                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE FOR CPE00099                                  *         
      * GETS THE MOST CURRENT ACCOUNT-NO AT A GIVEN PREMISE           *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00010.                                                       
           COPY FIOJC01.                                                        
           COPY CWS00011.                                                       
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP430'.     
           05 WS-PGRMNAME               PIC X(08) VALUE 'PCSRP430'.     
      *                                                                         
       01 WS-RP430-OUT-REC.                                             
           05 OUT-LOC-OFF               PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-1              PIC X(01) VALUE SPACES.         
           05 OUT-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05 OUT-DELMTR-2              PIC X(01) VALUE SPACES.         
           05 OUT-METER-NO              PIC X(09) VALUE SPACES.         
           05 OUT-DELMTR-3              PIC X(01) VALUE SPACES.         
           05 OUT-ELEC-MTR-CLASS-CD     PIC X(02) VALUE SPACES.         
           05 OUT-DELMTR-4              PIC X(01) VALUE SPACES.         
           05 OUT-ELEC-MTR-SPEC-CD      PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-5              PIC X(01) VALUE SPACES.         
           05 OUT-CONSTANT              PIC 9(05) VALUE ZEROES.         
           05 OUT-DELMTR-6              PIC X(01) VALUE SPACES.         
           05 OUT-NAME                  PIC X(40) VALUE SPACES.         
           05 OUT-DELMTR-7              PIC X(01) VALUE SPACES.         
           05 OUT-DBA-NAME              PIC X(50) VALUE SPACES.         
           05 OUT-DELMTR-8              PIC X(01) VALUE SPACES.         
           05 OUT-HOUSE-NBR             PIC X(07) VALUE ZEROES.         
           05 OUT-DELMTR-9              PIC X(02) VALUE SPACES.         
           05 OUT-SVC-ADDR-1            PIC X(49) VALUE SPACES.         
           05 OUT-DELMTR-10             PIC X(01) VALUE SPACES.         
           05 OUT-SVC-ADDR-2            PIC X(40) VALUE SPACES.         
           05 OUT-DELMTR-11             PIC X(01) VALUE SPACES.         
           05 OUT-SUBSTATION-ID         PIC X(05) VALUE SPACES.         
           05 OUT-DELMTR-12             PIC X(01) VALUE SPACES.         
           05 OUT-CIRCUIT-ID            PIC X(05) VALUE SPACES.         
           05 OUT-DELMTR-13             PIC X(01) VALUE SPACES.         
           05 OUT-TAG-NM                PIC X(10) VALUE SPACES.         
           05 OUT-DELMTR-14             PIC X(01) VALUE SPACES.         
           05 OUT-KW                    PIC 9(06) VALUE ZEROES.         
           05 OUT-KW-DOT                PIC X(01) VALUE SPACES.         
           05 OUT-KW-DEC                PIC 9(03) VALUE ZEROES.         
           05 OUT-DELMTR-15             PIC X(01) VALUE SPACES.         
           05 OUT-KVA                   PIC 9(06) VALUE ZEROES.         
           05 OUT-KVA-DOT               PIC X(01) VALUE SPACES.         
           05 OUT-KVA-DEC               PIC 9(03) VALUE ZEROES.         
           05 OUT-DELMTR-16             PIC X(01) VALUE SPACES.         
           05 OUT-LAST-READ-DATE        PIC X(10) VALUE SPACES.         
           05 OUT-DELMTR-17             PIC X(01) VALUE SPACES.         
           05 OUT-DIGTL-MTR-TYPE        PIC X(03) VALUE SPACES.         
           05 OUT-DELMTR-18             PIC X(01) VALUE SPACES.         
                                                                        
       01 WS-RP430-HDR-REC-LN.                                          
           05 WS-LOC-OFF                PIC X(03) VALUE 'LOC'.          
HEX01      05 WS-DEL-1                  PIC X(01) VALUE X'09'.          
           05 WS-ACCT-NO                PIC X(13) VALUE 'ACCOUNT NO   '.
HEX01      05 WS-DEL-2                  PIC X(01) VALUE X'09'.          
           05 WS-METER-NO               PIC X(09) VALUE 'METER NO '.    
HEX01      05 WS-DEL-3                  PIC X(01) VALUE X'09'.          
           05 WS-ELEC-MTR-CLASS-CD      PIC X(02) VALUE 'CL'.           
HEX01      05 WS-DEL-4                  PIC X(01) VALUE X'09'.          
           05 WS-ELEC-MTR-SPEC-CD       PIC X(03) VALUE 'SPC'.          
HEX01      05 WS-DEL-5                  PIC X(01) VALUE X'09'.          
           05 WS-CONSTANT               PIC X(05) VALUE 'CONST'.        
HEX01      05 WS-DEL-6                  PIC X(01) VALUE X'09'.          
           05 WS-NAME                   PIC X(13) VALUE 'CUSTOMER NAME'.
           05 WS-SPACE-7                PIC X(27) VALUE ' '.            
HEX01      05 WS-DEL-7                  PIC X(01) VALUE X'09'.          
           05 WS-DBA-NM                 PIC X(03) VALUE 'DBA'.          
           05 WS-SPACE-8                PIC X(47) VALUE ' '.            
HEX01      05 WS-DEL-8                  PIC X(01) VALUE X'09'.          
           05 WS-HDR-HOUSE-NBR          PIC X(07) VALUE 'HSE NBR'.      
HEX01      05 WS-DEL-9                  PIC X(01) VALUE X'09'.          
           05 WS-SVC-ADDR-1             PIC X(16)                       
                                          VALUE ' SERVICE ADDRESS'.     
           05 WS-SPACE-10               PIC X(34) VALUE ' '.            
HEX01      05 WS-DEL-10                 PIC X(01) VALUE X'09'.          
           05 WS-SVC-ADDR-2             PIC X(14)                       
                                          VALUE 'CITY/STATE/ZIP'.       
           05 WS-SPACE-11               PIC X(26) VALUE ' '.            
HEX01      05 WS-DEL-11                 PIC X(01) VALUE X'09'.          
           05 WS-SUBSTATION-ID          PIC X(05) VALUE 'SUBST'.        
HEX01      05 WS-DEL-12                 PIC X(01) VALUE X'09'.          
           05 WS-CIRCUIT-ID             PIC X(05) VALUE 'CIRID'.        
HEX01      05 WS-DEL-13                 PIC X(01) VALUE X'09'.          
           05 WS-TAG-NM                 PIC X(10) VALUE 'TAG NAME  '.   
HEX01      05 WS-DEL-14                 PIC X(01) VALUE X'09'.          
           05 WS-KW                     PIC X(10) VALUE 'PEAK KW   '.   
HEX01      05 WS-DEL-15                 PIC X(01) VALUE X'09'.          
           05 WS-KVA                    PIC X(10) VALUE 'PEAK KVA  '.   
HEX01      05 WS-DEL-16                 PIC X(01) VALUE X'09'.          
           05 WS-LAST-READ-DATE         PIC X(10) VALUE 'LST RD DTE'.   
HEX01      05 WS-DEL-17                 PIC X(01) VALUE X'09'.          
           05 WS-DIGTL-MTR-TYPE         PIC X(03) VALUE 'DMT'.          
HEX01      05 WS-DEL-18                 PIC X(01) VALUE X'09'.          
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESSD      PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-SWITCH.                                                    
           05  WS-FCA294-STATUS         PIC X(02).                      
               88 FCA294-SUCCESSFUL               VALUE '00'.           
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
           05  WS-FIRST                 PIC X(01) VALUE 'Y'.            
           05  WS-FIRST-TYM             PIC X(01) VALUE 'Y'.            
           05  WS-CHECK                 PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-SAVE-TAG-NM           PIC X(10) VALUE SPACES.         
           05  WS-SAVE-SQLCODE          PIC S9(04)    COMP VALUE 0.     
HEX01      05  WS-DELIM                 PIC X(01) VALUE X'09'.          
           05  WS-NULL-INDR1            PIC S9(02)    COMP VALUE 0.     
           05  WS-NULL-INDR2            PIC S9(02)    COMP VALUE 0.     
           05  WS-NULL-IND1             PIC S9(02)    COMP VALUE 0.     
           05  WS-NULL-IND2             PIC S9(02)    COMP VALUE 0.     
           05  WS-HOUSE-NO-NM           PIC X(07) VALUE SPACES.         
           05  WS-CNT                   PIC 9(07) VALUE ZEROES.         
           05  WS-CNT1                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT2                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT3                  PIC 9(07) VALUE ZEROES.         
           05  WS-CNT4                  PIC 9(07) VALUE ZEROES.         
           05  WS-UTIL-TYPE             PIC X(02) VALUE SPACES.         
           05  WS-DOT                   PIC X(01) VALUE '.'.            
           05  WS-OTHER-SVC             PIC X(01) VALUE SPACES.         
           05  WS-NO-REPORT             PIC X(01) VALUE 'Y'.            
           05  WS-P-ACCT                PIC S9(07)V    VALUE 0 COMP-3.  
           05  WS-KW-REGREAD            PIC S9(08)V999 VALUE 0 COMP-3.  
           05  WS-KVA-REGREAD           PIC S9(08)V999 VALUE 0 COMP-3.  
           05  WS-KW-WORK               PIC S9(08)V999 VALUE 0 COMP-3.  
           05  WS-KVA-WORK              PIC S9(08)V999 VALUE 0 COMP-3.  
           05  WS-ACCOUNT-NO            PIC S9(07)V    VALUE 0 COMP-3.  
           05  WS-ACCOUNT-NOX              REDEFINES                    
               WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-START-POS1            PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-START-POS2            PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-LEN                   PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-ADDR-LEN              PIC S9(02)V    VALUE 0 COMP-3.  
           05  WS-ONE                   PIC S9(02)V    VALUE 1 COMP-3.  
           05  WS-ADDRESS-LENGTH1       PIC S9(02)V    VALUE 50 COMP-3. 
           05  WS-ADDRESS-LENGTH2       PIC S9(02)V    VALUE 37 COMP-3. 
           05  WS-LENGTH                PIC S9(02)V    VALUE 7 COMP-3.  
           05  WS-ZEROS                 PIC 9(07) VALUE ZEROES.         
           05  WS-HOUSE-NBR             PIC 9(07) VALUE ZEROES.         
           05  WS-HOUSE-NUMBERX            REDEFINES                    
               WS-HOUSE-NBR             PIC X(07).                      
           05  WS-REVENUE-MONTHX        PIC X(06) VALUE SPACES.         
           05  WS-REVENUE-MONTHN           REDEFINES                    
               WS-REVENUE-MONTHX        PIC 9(06).                      
           05  WS-PRT-ACCOUNT-NO        PIC 9(13) VALUE ZEROES.         
           05  WS-TYPE-SVC              PIC X(01) VALUE SPACES.         
           05  WS-PREMISE-NO            PIC S9(06)V    VALUE 0 COMP-3.  
           05  WS-FULL-NAME             PIC X(40) VALUE SPACES.         
           05  WS-ADDRESS-1             PIC X(50) VALUE SPACES.         
           05  WS-ADDRESS-2             PIC X(40) VALUE SPACES.         
           05  WS-PREV-ACCT             PIC 9(13) VALUE ZEROES.         
           05  WS-FMT-ACCT              PIC 9999999999999 VALUE ZEROES. 
           05  WS-MTR-RD-INST           PIC X(14) VALUE SPACES.         
           05  WS-DBA-NAME              PIC X(70) VALUE SPACES.         
           05  SUBSTATION-ID            PIC X(05) VALUE SPACES.         
           05  CIRCUIT-ID               PIC X(05) VALUE SPACES.         
           05  WS-ELEC-MTR-FORM-CD      PIC X(04) VALUE SPACES.         
           05  WS-ALT-ELEC-MTR-FM-CD    PIC X(04) VALUE SPACES.         
           05  WS-DEVICE-NO             PIC X(12) VALUE SPACES.         
           05  WS-SPACES                PIC X(01) VALUE ' '.            
           05  WS-COMPANY-NO            PIC X(02) VALUE '01'.           
           05  WS-PROGRAM-NAME          PIC X(10) VALUE 'PCSCA204  '.   
           05  WS-CMND-CODE             PIC X(04) VALUE 'PARM'.         
COB305     05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-SVC-ADDR-LINE-1       PIC X(50) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-2       PIC X(37) VALUE SPACES.         
           05  WS-FMT-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-FMT-ADDR-LINE-3       PIC X(36) VALUE SPACES.         
           05  WS-SVC-ADDR-LINE-OVERFLOW PIC X(35) VALUE SPACES.        
           05  WS-ABEND-PGM-FG          PIC X(01) VALUE 'N'.            
           05  WS-ZIP-CODE-SADDR        PIC X(05) VALUE SPACES.         
           05  WS-ZIP-CD-PL-FOUR-SADDR  PIC X(04) VALUE SPACES.         
           05  WS-SVC-ZIP-PLUS-4        PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-ZIP-CD.                                                    
           05  WS-ZIP-CODE              PIC X(05) VALUE 'N'.            
           05  WS-FILLER-5              PIC X(01) VALUE 'N'.            
           05  WS-ZIP-CD-PL-FOUR        PIC X(04) VALUE 'N'.            
           05  WS-ADDR-ZIP-CD-5         PIC X(05) VALUE 'N'.            
           05  WS-ADDR-ZIP-CD-4         PIC X(04) VALUE 'N'.            
      *                                                                         
       01 WS-P-UTIL.                                                    
           05  WS-P-UTIL-E              PIC X(01).                      
           05  WS-P-UTIL-G              PIC X(01).                      
      *                                                                         
       01  WS-ADDRESS-FORMAT-FIELDS.                                    
           05  WS-HOUSE-NO              PIC X(07) VALUE SPACES.         
           05  WS-HOUSE-NO-N            PIC X(07).                      
           05  WS-HOUSE-NO6 REDEFINES WS-HOUSE-NO-N.                    
               10  WS-HOUSE-FILL-6      PIC 9(06).                      
               10  WS-HOUSE-NO-6        PIC 9(01).                      
           05  WS-HOUSE-NO5 REDEFINES WS-HOUSE-NO6.                     
               10  WS-HOUSE-FILL-5      PIC 9(05).                      
               10  WS-HOUSE-NO-5        PIC 9(02).                      
           05  WS-HOUSE-NO4 REDEFINES WS-HOUSE-NO5.                     
               10  WS-HOUSE-FILL-4      PIC 9(04).                      
               10  WS-HOUSE-NO-4        PIC 9(03).                      
           05  WS-HOUSE-NO3 REDEFINES WS-HOUSE-NO4.                     
               10  WS-HOUSE-FILL-3      PIC 9(03).                      
               10  WS-HOUSE-NO-3        PIC 9(04).                      
           05  WS-HOUSE-NO2 REDEFINES WS-HOUSE-NO3.                     
               10  WS-HOUSE-FILL-2      PIC 9(02).                      
               10  WS-HOUSE-NO-2        PIC 9(05).                      
           05  WS-HOUSE-NO1 REDEFINES WS-HOUSE-NO2.                     
               10  WS-HOUSE-FILL-1      PIC 9(01).                      
               10  WS-HOUSE-NO-1        PIC 9(06).                      
      *                                                                         
       01 WS-FMT-ADDR-LINE-1.                                           
           05  WS-HNO                   PIC X(05) VALUE SPACES.         
           05  WS-FILLER-3              PIC X(01) VALUE SPACES.         
           05  WS-APREFIX               PIC X(03) VALUE SPACES.         
           05  WS-FILLER-6              PIC X(01) VALUE SPACES.         
           05  WS-APREFIX2              PIC X(02) VALUE SPACES.         
           05  WS-FILLER-7              PIC X(01) VALUE SPACES.         
           05  WS-SNAME                 PIC X(16) VALUE SPACES.         
           05  WS-FILLER-8              PIC X(01) VALUE SPACES.         
           05  WS-SSUFFIX               PIC X(04) VALUE SPACES.         
           05  WS-FILLER-9              PIC X(01) VALUE SPACES.         
           05  WS-ASUFFIX               PIC X(02) VALUE SPACES.         
           05  WS-FILLER-10             PIC X(01) VALUE SPACES.         
           05  WS-SLOCATION-1           PIC X(04) VALUE SPACES.         
           05  WS-FILLER-11             PIC X(01) VALUE SPACES.         
           05  WS-SLOCATION-2           PIC X(06) VALUE SPACES.         
      *                                                                         
       01 WS-FMT-ADDR-LINE-2.                                           
           05  WS-TWN                   PIC X(24) VALUE SPACES.         
           05  WS-STT                   PIC X(02) VALUE SPACES.         
      *    05  WS-FILLER-4              PIC X(01) VALUE SPACES.                 
           05  WS-ZIPCD                 PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-FMT-NAME.                                                  
           05  WS-FNAME                 PIC X(15) VALUE SPACES.         
           05  WS-FILLER-1              PIC X(01) VALUE SPACES.         
           05  WS-MNAME                 PIC X(01) VALUE SPACES.         
           05  WS-FILLER-2              PIC X(01) VALUE SPACES.         
           05  WS-LNAME                 PIC X(19) VALUE SPACES.         
      *                                                                         
       01 WS-UT-CLASS.                                                  
           05  WS-UT1                   PIC X(01).                      
           05  WS-UT2                   PIC X(01).                      
           05  WS-UT3                   PIC X(01).                      
      *                                                                         
       01 WS-ERT-ID-A.                                                  
           05  WS-ERT-ID-P1             PIC X(01).                      
           05  WS-ERT-ID-P2             PIC X(09).                      
      *                                                                         
       01 WS-PARM-REV-MONTH.                                            
           05  WS-REVENUE-LITERAL       PIC X(14).                      
           05  WS-REV-PARM-MONTH        PIC N(06).                      
           05  WS-REV-PARM-YR           PIC N(04).                      
           05  WS-REV-PARM-MM           PIC N(02).                      
           05  WS-REST-OF-IT            PIC X(60).                      
      *                                                                         
      ***************************************************************           
      *CURSOR FOR WRITE OFFS - MAIN CURSOR                          *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE GET_DET CURSOR FOR                                 
                SELECT AT.LOCAL_OFFICE                                  
                      ,AT.ACCOUNT_NO                                    
                      ,MN.METER_NO                                      
                      ,AT.CUSTOMER_NO                                   
                      ,AT.PREMISE_NO                                    
                      ,AT.COMPANY_NO                                    
                      ,MN.GIS_POINT_ID                                  
                      ,MN.LAST_REG_READ_DATE                            
                      ,MN.CODE_MTR_RD_INST1                             
                      ,EM.ELEC_MTR_CLASS_CD                             
                      ,EM.ELEC_MTR_SPEC_CD                              
                      ,MC.CONSTANT                                      
                      ,CU.NAME_ID                                       
                      ,PR.ADDRESS_ID                                    
                      ,MN.DIGTL_MTR_TYPE                                
                      ,MN.REG_ID_NO                                     
                      ,MN.IC_NO                                         
                      ,MN.CODE_UTIL_TYPE                                
                      ,MN.MTR_REF_NO                                    
                  FROM CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                   
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
                      ,CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                      ,CSS_EQUIPMENT  EQ WITH(READUNCOMMITTED)                  
                      ,CSS_ELEC_METER EM WITH(READUNCOMMITTED)                  
                      ,CSS_MTR_CAP    MC WITH(READUNCOMMITTED)                  
                      ,CSS_CUSTOMER  CU WITH(READUNCOMMITTED)                   
                  WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO               
                    AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO               
                    AND AT.PREMISE_NO     = PR.PREMISE_NO               
                    AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO              
                    AND AT.COMPANY_NO     = '01'                        
                    AND AT.COMPANY_NO     = EQ.COMPANY_NO               
                    AND AT.COMPANY_NO     = EM.COMPANY_NO               
                    AND AT.COMPANY_NO     = MC.COMPANY_NO               
                    AND AT.COMPANY_NO     = UT.COMPANY_NO               
                    AND AT.COMPANY_NO     = EQ.COMPANY_NO               
                    AND UT.IC_NO          = MN.IC_NO                    
                    AND MN.CODE_UTIL_TYPE = 'E'                         
                    AND MN.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE           
                    AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND MN.METER_NO       = EQ.DEVICE_NO                
                    AND MN.METER_NO       = EM.METER_NO                 
                    AND MN.METER_NO       = MC.METER_NO                 
                    AND EQ.CODE_CRNT_LOC  = 'J'                         
                    AND MC.REG_ID_NO      = MN.REG_ID_NO                
                    AND MN.CODE_METER_STATUS <> 'K'                     
                    AND MN.DIGTL_MTR_TYPE IN ('SS ','X1 ')              
                  FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE GET_DET CURSOR FOR                                         
MFA-TR*         SELECT AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.ACCOUNT_NO                                            
MFA-TR*               ,MN.METER_NO                                              
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,MN.GIS_POINT_ID                                          
MFA-TR*               ,MN.LAST_REG_READ_DATE                                    
MFA-TR*               ,MN.CODE_MTR_RD_INST1                                     
MFA-TR*               ,EM.ELEC_MTR_CLASS_CD                                     
MFA-TR*               ,EM.ELEC_MTR_SPEC_CD                                      
MFA-TR*               ,MC.CONSTANT                                              
MFA-TR*               ,CU.NAME_ID                                               
MFA-TR*               ,PR.ADDRESS_ID                                            
MFA-TR*               ,MN.DIGTL_MTR_TYPE                                        
MFA-TR*               ,MN.REG_ID_NO                                             
MFA-TR*               ,MN.IC_NO                                                 
MFA-TR*               ,MN.CODE_UTIL_TYPE                                        
MFA-TR*               ,MN.MTR_REF_NO                                            
MFA-TR*           FROM CSS_ACCOUNT   AT                                         
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_MTRD_ENVRNMT MN                                      
MFA-TR*               ,CSS_PREMISE PR                                           
MFA-TR*               ,CSS_EQUIPMENT  EQ                                        
MFA-TR*               ,CSS_ELEC_METER EM                                        
MFA-TR*               ,CSS_MTR_CAP    MC                                        
MFA-TR*               ,CSS_CUSTOMER  CU                                         
MFA-TR*           WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO                       
MFA-TR*             AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO                       
MFA-TR*             AND AT.PREMISE_NO     = PR.PREMISE_NO                       
MFA-TR*             AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                      
MFA-TR*             AND AT.COMPANY_NO     = '01'                                
MFA-TR*             AND AT.COMPANY_NO     = EQ.COMPANY_NO                       
MFA-TR*             AND AT.COMPANY_NO     = EM.COMPANY_NO                       
MFA-TR*             AND AT.COMPANY_NO     = MC.COMPANY_NO                       
MFA-TR*             AND AT.COMPANY_NO     = UT.COMPANY_NO                       
MFA-TR*             AND AT.COMPANY_NO     = EQ.COMPANY_NO                       
MFA-TR*             AND UT.IC_NO          = MN.IC_NO                            
MFA-TR*             AND MN.CODE_UTIL_TYPE = 'E'                                 
MFA-TR*             AND MN.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                   
MFA-TR*             AND MN.METER_NO       = EQ.DEVICE_NO                        
MFA-TR*             AND MN.METER_NO       = EM.METER_NO                         
MFA-TR*             AND MN.METER_NO       = MC.METER_NO                         
MFA-TR*             AND EQ.CODE_CRNT_LOC  = 'J'                                 
MFA-TR*             AND MC.REG_ID_NO      = MN.REG_ID_NO                        
MFA-TR*             AND MN.CODE_METER_STATUS <> 'K'                             
MFA-TR*             AND MN.DIGTL_MTR_TYPE IN ('SS ','X1 ')                      
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 08230000
           OPEN OUTPUT FCSPT294-FILE.                                   
                                                                        
           IF NOT FCA294-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP430 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT294-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA294-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
           INITIALIZE PRT294-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
                                                                        
           PERFORM 8100-WRITE-OUTFILE-HEADER        THRU  8100-EXIT.    
                                                                        
           PERFORM 2050-GET-REVENUE-MONTH           THRU  2050-EXIT.    
                                                                        
           PERFORM 7100-OPEN-MAIN-CSR               THRU  7100-EXIT.    
                                                                        
           PERFORM 7200-FETCH-MAIN-CSR              THRU  7200-EXIT.    
                                                                        
           PERFORM 2010-ACCT-ADDR-PROCESS           THRU  2010-EXIT     
           UNTIL WS-ALL-ROWS-PROCESD = WS-Y.                            
                                                                        
           PERFORM 7300-CLOSE-MAIN-CSR              THRU  7300-EXIT.    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2010-ACCT-ADDR-PROCESS                                       **        
      ******************************************************************        
      *                                                                         
       2010-ACCT-ADDR-PROCESS.                                          
      *                                                                         
           MOVE ZEROES                      TO PH-PEAK-KW-UNITS         
                                               PH-PEAK-KVA-UNITS        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
             MOVE ZEROES                    TO WS-CPD99-ACCOUNT-NO      
             MOVE AT-PREMISE-NO             TO WS-CPD99-PREMISE-NO      
                                                                        
             PERFORM 6990-FETCH-CUR-ACCOUNT         THRU 6990-EXIT      
                                                                        
             IF AT-ACCOUNT-NO = WS-CPD99-ACCOUNT-NO                     
               MOVE AT-ACCOUNT-NO           TO WS-ACCOUNT-NO            
                                               WS-ACCOUNT-NOX           
               MOVE AT-PREMISE-NO           TO WS-PREMISE-NO            
               MOVE MN-CODE-UTIL-TYPE       TO WS-TYPE-SVC              
               MOVE SPACES                  TO WS-FMT-NAME              
                                               WS-FULL-NAME             
                                               WS-FMT-ADDR-LINE-1       
                                               WS-FMT-ADDR-LINE-2       
               IF MC-CONSTANT > 1                                       
                 MOVE SPACES                TO WS-FMT-NAME              
                                                                        
                 PERFORM 7400-GET-NAME              THRU 7400-EXIT      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                   MOVE DQ-FULL-NAME        TO WS-FMT-NAME              
                 END-IF                                                 
               END-IF                                                   
                                                                        
               MOVE WS-FMT-NAME             TO WS-FULL-NAME             
                                                                        
               PERFORM 2100-GET-ADDR                THRU 2100-EXIT      
               MOVE WS-SVC-ADDR-LINE-1      TO WS-ADDRESS-1             
               MOVE WS-SVC-ADDR-LINE-2      TO WS-ADDRESS-2             
               MOVE ' '                     TO WS-SAVE-TAG-NM           
                                                                        
               PERFORM 7800-GET-OTHER-DET2          THRU 7800-EXIT      
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                 MOVE SPACES                TO SUBSTATION-ID            
                                               CIRCUIT-ID               
                                               WS-SAVE-TAG-NM           
               END-IF                                                   
               PERFORM 2600-LOAD-UNINSTAL-MTR       THRU 2600-EXIT      
                                                                        
               IF MN-DIGTL-MTR-TYPE = 'X1 '                             
                 PERFORM 7900-GET-PEAK              THRU 7900-EXIT      
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                   PERFORM 2700-PROCESS-PEAK        THRU 2700-EXIT      
                 ELSE                                                   
                   MOVE 0                   TO WS-KVA-WORK              
                                               WS-KW-WORK               
                 END-IF                                                 
               ELSE                                                     
                 PERFORM 7910-GET-REG-READ          THRU 7910-EXIT      
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                   IF WS-NULL-INDR1 < 0                                 
                     MOVE 0                 TO WS-KVA-WORK              
                   END-IF                                               
                   IF WS-NULL-INDR2 < 0                                 
                     MOVE 0                 TO WS-KW-WORK               
                   END-IF                                               
                 ELSE                                                   
                   MOVE 0                   TO WS-KVA-WORK              
                                               WS-KW-WORK               
                 END-IF                                                 
                 PERFORM 2800-PROCESS-REG-READ      THRU 2800-EXIT      
               END-IF                                                   
                                                                        
               PERFORM 2900-FORMAT-OUTPUT           THRU 2900-EXIT      
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7200-FETCH-MAIN-CSR              THRU 7200-EXIT.     
                                                                        
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-GET-REVENUE-MONTH                                       **        
      ******************************************************************        
      *                                                                         
       2050-GET-REVENUE-MONTH.                                          
      *                                                                         
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE 'PCSCA204'                   TO WS-PROGRAM.             
           MOVE 'PARM'                       TO WS-COMMAND.             
           MOVE 01                           TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
      *                                                                         
           PERFORM 7600-START-FCSJC01    THRU  7600-EXIT                
      *                                                                         
           PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT                
              UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                    
                    OR END-OF-SYSIPT                                    
      *                                                                         
              MOVE WS-REVENUE-MONTH-PARM     TO WS-PARM-REV-MONTH       
                                                WS-REVENUE-MONTHX       
              MOVE WS-REVENUE-MONTHN         TO BG-REVENUE-MONTH        
                                                WS-REVENUE-MONTH        
                                                WS-REV-MONTH            
      *                                                                         
           DISPLAY 'WS-REVENUE-MONTH  = ' WS-REVENUE-MONTHN.            
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-GET-ADDR.                                               **        
      ******************************************************************        
      *                                                                         
       2100-GET-ADDR.                                                   
                                                                        
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-1       
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-OVERFLOW
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-2       
           MOVE SPACES                      TO WS-FMT-ADDR-LINE-3       
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-1       
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-OVERFLOW
           MOVE SPACES                      TO WS-SVC-ADDR-LINE-2       
                                                                        
           PERFORM 2200-FMT-SVC-ADDR                THRU 2200-EXIT.     
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-FMT-SVC-ADDR.                                           **        
      ******************************************************************        
      *                                                                         
       2200-FMT-SVC-ADDR.                                               
      *                                                                         
           MOVE PR-ADDRESS-ID               TO DY-ADDRESS-ID            
                                                                        
           PERFORM 7500-FMT-SVC-ADDR                THRU 7500-EXIT      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE 'Y'                       TO WS-ABEND-PGM-FG          
           ELSE                                                         
             MOVE 'N'                       TO WS-ABEND-PGM-FG          
           END-IF                                                       
                                                                        
           IF WS-ABEND-PGM-FG = 'N'                                     
                                                                        
             MOVE DY-ZIP-CODE               TO WS-ZIP-CODE              
             MOVE DY-ZIP-CODE-PLUS-FOUR     TO WS-ZIP-CD-PL-FOUR        
             MOVE DY-ZIP-CODE               TO WS-ZIP-CODE-SADDR        
             MOVE DY-ZIP-CODE-PLUS-FOUR     TO WS-ZIP-CD-PL-FOUR-SADDR  
                                                                        
             IF WS-ZIP-CD-PL-FOUR = '    '                              
               MOVE ' '                     TO WS-FILLER-5              
             ELSE                                                       
               MOVE '-'                     TO WS-FILLER-5              
             END-IF                                                     
                                                                        
             MOVE WS-ZIP-CD                 TO WS-SVC-ZIP-PLUS-4        
             MOVE DY-ZIP-CODE               TO A4-ZIP-CODE              
             MOVE DY-ZIP-CODE-TOKEN         TO A4-ZIP-CODE-TOKEN        
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             PERFORM 7700-TOWN-DETAILS              THRU 7700-EXIT      
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y'                   TO WS-ABEND-PGM-FG            
             ELSE                                                       
               MOVE 'N'                   TO WS-ABEND-PGM-FG            
             END-IF                                                     
                                                                        
             IF WS-ABEND-PGM-FG = 'N'                                   
                                                                        
             PERFORM 2300-FORMAT-FORM-ADDR          THRU 2300-EXIT      
                                                                        
             MOVE WS-FMT-ADDR-LINE-1        TO WS-EMB-INPUT             
             MOVE 50                        TO WS-EMB-LENG              
             PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6011-EXIT    
             MOVE WS-CMP-TABLE              TO WS-SVC-ADDR-LINE-1       
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             MOVE WS-FMT-ADDR-LINE-2        TO WS-EMB-INPUT             
             MOVE 37                        TO WS-EMB-LENG              
             PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6011-EXIT    
             MOVE WS-CMP-TABLE              TO WS-SVC-ADDR-LINE-2       
             MOVE SPACES                    TO WS-CMP-TABLE             
                                                                        
             MOVE WS-FMT-ADDR-LINE-OVERFLOW                             
                                            TO WS-SVC-ADDR-LINE-OVERFLOW
             END-IF                                                     
                                                                        
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS-LENGTH1          TO WS-ADDR-LEN              
                                                                        
           MOVE WS-ADDRESS-LENGTH2          TO WS-ADDR-LEN.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-FORMAT-FORM-ADDR.                                       **        
      ******************************************************************        
      *                                                                         
       2300-FORMAT-FORM-ADDR.                                           
                                                                        
           IF WS-ABEND-PGM-FG = 'N'                                     
             MOVE DY-HOUSE-NO               TO WS-HOUSE-NO              
                                                                        
             MOVE WS-HOUSE-NO               TO WS-HOUSE-NO-N            
             MOVE ZEROES                    TO WS-CNT                   
                                                                        
             INSPECT WS-HOUSE-NO TALLYING WS-CNT FOR ALL ' '            
                                                                        
             IF WS-HOUSE-NO = SPACES                                    
               MOVE '0000000'               TO WS-HOUSE-NO-N            
             ELSE                                                       
               PERFORM 2400-HOUSE-NUMBER            THRU 2400-EXIT      
             END-IF                                                     
                                                                        
             MOVE DY-ADDR-PREFIX-1          TO WS-APREFIX               
             MOVE DY-ADDR-PREFIX-2          TO WS-APREFIX2              
             MOVE DY-STREET-LOCATION-1      TO WS-SLOCATION-1           
             MOVE DY-STREET-LOCATION-2      TO WS-SLOCATION-2           
             MOVE DY-STREET-NAME            TO WS-SNAME                 
             MOVE DY-STREET-SUFFIX          TO WS-SSUFFIX               
             MOVE DY-ADDR-SUFFIX            TO WS-ASUFFIX               
             MOVE A4-TOWN                   TO WS-TWN                   
             MOVE A4-STATE                  TO WS-STT                   
             MOVE WS-ZIP-CD                 TO WS-ZIPCD                 
             MOVE DY-ADDRESS-OVERFLOW       TO WS-FMT-ADDR-LINE-OVERFLOW
                                                                        
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-HOUSE-NUMBER.                                           **        
      ******************************************************************        
      *                                                                         
       2400-HOUSE-NUMBER.                                               
                                                                        
           IF WS-CNT = ZEROES                                           
              MOVE WS-HOUSE-NO-N   TO OUT-HOUSE-NBR                     
           ELSE                                                         
           IF WS-CNT = 1                                                
              MOVE '0'             TO OUT-HOUSE-NBR(1:1)                
              MOVE WS-HOUSE-NO-N(1:6)   TO OUT-HOUSE-NBR(2:6)           
           ELSE                                                         
           IF WS-CNT = 2                                                
              MOVE '00'            TO OUT-HOUSE-NBR(1:2)                
              MOVE WS-HOUSE-NO-N(1:5)   TO OUT-HOUSE-NBR(3:5)           
           ELSE                                                         
           IF WS-CNT = 3                                                
              MOVE '000'           TO OUT-HOUSE-NBR(1:3)                
              MOVE WS-HOUSE-NO-N(1:4)   TO OUT-HOUSE-NBR(4:4)           
           ELSE                                                         
           IF WS-CNT = 4                                                
              MOVE '0000'          TO OUT-HOUSE-NBR(1:4)                
              MOVE WS-HOUSE-NO-N(1:3)   TO OUT-HOUSE-NBR(5:3)           
           ELSE                                                         
           IF WS-CNT = 5                                                
              MOVE '00000'         TO OUT-HOUSE-NBR(1:5)                
              MOVE WS-HOUSE-NO-N(1:2)   TO OUT-HOUSE-NBR(6:2)           
           ELSE                                                         
           IF WS-CNT = 6                                                
              MOVE '000000'        TO OUT-HOUSE-NBR(1:6)                
              MOVE WS-HOUSE-NO-N(1:1)   TO OUT-HOUSE-NBR(7:1)           
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-LOAD-UNINSTAL-MTR.                                      **        
      ******************************************************************        
      *                                                                         
       2600-LOAD-UNINSTAL-MTR.                                          
      *                                                                         
           MOVE EM-ELEC-MTR-CLASS-CD        TO OUT-ELEC-MTR-CLASS-CD    
           MOVE EM-ELEC-MTR-SPEC-CD         TO OUT-ELEC-MTR-SPEC-CD     
           MOVE MC-CONSTANT                 TO OUT-CONSTANT             
           MOVE MN-METER-NO                 TO OUT-METER-NO             
           MOVE WS-DELIM                    TO OUT-DELMTR-1             
           MOVE WS-DELIM                    TO OUT-DELMTR-2             
           MOVE WS-DELIM                    TO OUT-DELMTR-3             
           MOVE WS-DELIM                    TO OUT-DELMTR-4             
           MOVE WS-DELIM                    TO OUT-DELMTR-5             
           MOVE WS-DELIM                    TO OUT-DELMTR-6             
           MOVE WS-DELIM                    TO OUT-DELMTR-7             
           MOVE WS-DELIM                    TO OUT-DELMTR-8             
           MOVE WS-DELIM                    TO OUT-DELMTR-9             
           MOVE WS-DELIM                    TO OUT-DELMTR-10            
           MOVE WS-DELIM                    TO OUT-DELMTR-11            
           MOVE WS-DELIM                    TO OUT-DELMTR-12            
           MOVE WS-DELIM                    TO OUT-DELMTR-13            
           MOVE WS-DELIM                    TO OUT-DELMTR-14            
           MOVE WS-DELIM                    TO OUT-DELMTR-15            
           MOVE WS-DELIM                    TO OUT-DELMTR-16            
           MOVE WS-DELIM                    TO OUT-DELMTR-17            
           MOVE WS-DELIM                    TO OUT-DELMTR-18.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2700-PROCESS-PEAK.                                           **        
      ******************************************************************        
      *                                                                         
       2700-PROCESS-PEAK.                                               
      *                                                                         
           IF PH-PEAK-TYPE = 'B'                                        
             MOVE PH-PEAK-KW-UNITS          TO OUT-KW                   
             MOVE WS-DOT                    TO OUT-KW-DOT               
             MOVE 0                         TO OUT-KW-DEC               
             MOVE PH-PEAK-KVA-UNITS         TO OUT-KVA                  
             MOVE WS-DOT                    TO OUT-KVA-DOT              
             MOVE 0                         TO OUT-KVA-DEC              
           ELSE                                                         
             IF PH-PEAK-TYPE = 'E'                                      
               MOVE PH-PEAK-KVA-UNITS       TO OUT-KVA                  
               MOVE WS-DOT                  TO OUT-KVA-DOT              
               MOVE 0                       TO OUT-KVA-DEC              
             ELSE                                                       
               IF PH-PEAK-TYPE = 'J'                                    
                 MOVE PH-PEAK-KW-UNITS      TO OUT-KW                   
                 MOVE WS-DOT                TO OUT-KW-DOT               
                 MOVE 0                     TO OUT-KW-DEC               
               ELSE                                                     
                 MOVE 0                     TO OUT-KW                   
                 MOVE WS-DOT                TO OUT-KW-DOT               
                 MOVE 0                     TO OUT-KW-DEC               
                 MOVE 0                     TO OUT-KVA                  
                 MOVE WS-DOT                TO OUT-KVA-DOT              
                 MOVE 0                     TO OUT-KVA-DEC              
                 DISPLAY 'INVALID PEAK TYPE = ' MN-METER-NO             
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2800-PROCESS-REG-READ.                                       **        
      ******************************************************************        
      *                                                                         
       2800-PROCESS-REG-READ.                                           
      *                                                                         
           IF WS-KVA-WORK = 0                                           
             MOVE 0                         TO WS-KVA-REGREAD           
           ELSE                                                         
             COMPUTE WS-KVA-REGREAD = WS-KVA-WORK * MC-CONSTANT         
           END-IF                                                       
                                                                        
           IF WS-KW-WORK = 0                                            
             MOVE 0                         TO WS-KW-REGREAD            
           ELSE                                                         
             COMPUTE WS-KW-REGREAD = WS-KW-WORK * MC-CONSTANT           
           END-IF                                                       
                                                                        
           MOVE WS-KW-REGREAD               TO OUT-KW                   
           MOVE WS-DOT                      TO OUT-KW-DOT               
           MOVE WS-KW-REGREAD               TO OUT-KW-DEC               
           MOVE WS-KVA-REGREAD              TO OUT-KVA                  
           MOVE WS-DOT                      TO OUT-KVA-DOT              
           MOVE WS-KVA-REGREAD              TO OUT-KVA-DEC.             
                                                                        
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2900-FORMAT-OUTPUT.                                          **        
      ******************************************************************        
      *                                                                         
       2900-FORMAT-OUTPUT.                                              
      *                                                                         
           MOVE AT-LOCAL-OFFICE             TO OUT-LOC-OFF              
           MOVE SUBSTATION-ID               TO OUT-SUBSTATION-ID        
           MOVE CIRCUIT-ID                  TO OUT-CIRCUIT-ID           
           MOVE WS-SAVE-TAG-NM              TO OUT-TAG-NM               
           MOVE WS-ACCOUNT-NOX              TO OUT-ACCOUNT-NO           
           MOVE MN-METER-NO                 TO OUT-METER-NO             
           MOVE MN-DIGTL-MTR-TYPE           TO OUT-DIGTL-MTR-TYPE       
           MOVE ZEROES                      TO WS-CNT1                  
                                               WS-CNT2                  
                                               WS-CNT3                  
                                               WS-CNT4                  
                                                                        
           INSPECT WS-ADDRESS-1 TALLYING WS-CNT1 FOR LEADING SPACES     
                                                                        
           INSPECT FUNCTION REVERSE(WS-ADDRESS-1) TALLYING              
                                         WS-CNT2 FOR LEADING SPACES     
                                                                        
           COMPUTE WS-CNT3 = LENGTH OF WS-ADDRESS-1                     
                                                                        
           COMPUTE WS-CNT4 = WS-CNT3 - WS-CNT2 - WS-CNT1                
                                                                        
           IF WS-CNT1 = 0                                               
              MOVE 1                        TO WS-CNT1                  
           END-IF                                                       
                                                                        
           MOVE WS-ADDRESS-1(WS-CNT1:WS-CNT4) TO OUT-SVC-ADDR-1         
                                                                        
           MOVE ZEROES                      TO WS-CNT1                  
                                               WS-CNT2                  
                                               WS-CNT3                  
                                               WS-CNT4                  
                                                                        
           INSPECT WS-ADDRESS-2 TALLYING WS-CNT1 FOR LEADING SPACES     
                                                                        
           INSPECT FUNCTION REVERSE(WS-ADDRESS-2) TALLYING              
                                         WS-CNT2 FOR LEADING SPACES     
                                                                        
           COMPUTE WS-CNT3 = LENGTH OF WS-ADDRESS-2                     
                                                                        
           COMPUTE WS-CNT4 = WS-CNT3 - WS-CNT2 - WS-CNT1                
                                                                        
           IF WS-CNT1 = 0                                               
              MOVE 1                        TO WS-CNT1                  
           END-IF                                                       
           MOVE WS-ADDRESS-2(WS-CNT1:WS-CNT4) TO OUT-SVC-ADDR-2         
                                                                        
           MOVE MN-LAST-REG-READ-DATE       TO OUT-LAST-READ-DATE       
           MOVE WS-FULL-NAME                TO OUT-NAME                 
           MOVE SPACES                      TO WS-DBA-NAME              
                                                                        
           IF MC-CONSTANT > 1                                           
             PERFORM 7920-GET-DBA                   THRU 7920-EXIT      
           END-IF                                                       
                                                                        
           MOVE WS-DBA-NAME                 TO OUT-DBA-NAME             
           MOVE WS-ACCOUNT-NOX              TO WS-FMT-ACCT.             
                                                                        
           PERFORM 8200-WRITE-OUTFILE-DETAILS       THRU 8200-EXIT.     
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  6010-REDUCE-EMBEDDED-SPACES                             *              
      ************************************************************              
                                                                        
       COPY CPD00004.                                                           
                                                                        
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  ERROR ROUTINE                                               *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             CONTINUE                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**     PCSRP430 PROCESSING ERROR        **'      
              DISPLAY '** ERROR IN PARA 6995-CPD99-ERROR-ROUTINE '      
              DISPLAY '** PREMISE-NO = ', WS-CPD99-PREMISE-NO           
              DISPLAY '** SQL CODE IS  ', WS-CPD99-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-OPEN-MAIN-CSR.                                          **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_DET                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *****'                   
              DISPLAY '** OPEN GET DETAILS ERROR  **'                   
              DISPLAY '** 7100-OPEN-MAIN-CSR      **'                   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED   **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-FETCH-GET-MAIN                                          **        
      ******************************************************************        
      *                                                                         
       7200-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_DET                                             
               INTO  :AT-LOCAL-OFFICE                                   
                    ,:AT-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:MN-GIS-POINT-ID                                   
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:MN-CODE-MTR-RD-INST1                              
                    ,:EM-ELEC-MTR-CLASS-CD                              
                    ,:EM-ELEC-MTR-SPEC-CD                               
                    ,:MC-CONSTANT                                       
                    ,:CU-NAME-ID                                        
                    ,:PR-ADDRESS-ID                                     
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:MN-REG-ID-NO                                      
                    ,:MN-IC-NO                                          
                    ,:MN-CODE-UTIL-TYPE                                 
                    ,:MN-MTR-REF-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
      *                                                                         
           WHEN NOT-FOUND                                               
              MOVE WS-Y                      TO WS-ALL-ROWS-PROCESD     
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT ******'                  
              DISPLAY '**  MAIN CURSOR FETCH ERROR **'                  
              DISPLAY '** 7200-FETCH-MAIN-CSR      **'                  
              DISPLAY '** ACCOUNT NUMBER       =' AT-ACCOUNT-NO         
              DISPLAY '** METER NUMBER         =' MN-METER-NO           
              DISPLAY '** REG-ID               =' MN-REG-ID-NO          
              DISPLAY '** DIGTL-MTR-TYPE       =' MN-DIGTL-MTR-TYPE     
              DISPLAY '** RETURN CODE          =' WS-ACTIVE-RETURN-CODE 
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-CLOSE-MAIN-CSR                                          **        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_DET                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT ******'                  
              DISPLAY '** CLOSE MAIN CURSOR ERROR  **'                  
              DISPLAY '** 7300-CLOSE-MAIN-CSR      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-GET-NAME.                                               **        
      ******************************************************************        
      *                                                                         
       7400-GET-NAME.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME                                       
                INTO :DQ-FULL-NAME                                      
                FROM  CSS_NAME DQ WITH(READUNCOMMITTED)                         
               WHERE  DQ.NAME_ID = :CU-NAME-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.FULL_NAME                                               
MFA-TR*         INTO :DQ-FULL-NAME                                              
MFA-TR*         FROM  CSS_NAME DQ                                               
MFA-TR*        WHERE  DQ.NAME_ID = :CU-NAME-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '** GET FULL NAME               **'               
              DISPLAY '** 7400-GET-NAME               **'               
              DISPLAY '** CUST NAME ID   = ' CU-NAME-ID                 
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-FMT-SVC-ADDR.                                           **        
      ******************************************************************        
      *                                                                         
       7500-FMT-SVC-ADDR.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  HOUSE_NO                                          
                     ,ADDR_PREFIX_1                                     
                     ,ADDR_PREFIX_2                                     
                     ,STREET_NAME                                       
                     ,STREET_SUFFIX                                     
                     ,ZIP_CODE                                          
                     ,ZIP_CODE_PLUS_FOUR                                
                     ,ZIP_CODE_TOKEN                                    
                     ,ADDR_SUFFIX                                       
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,ADDRESS_OVERFLOW                                  
                INTO :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:DY-ZIP-CODE-TOKEN                                 
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-ADDRESS-OVERFLOW                               
                FROM  CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
               WHERE  ADDRESS_ID = :DY-ADDRESS-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*         INTO :DY-HOUSE-NO                                               
MFA-TR*             ,:DY-ADDR-PREFIX-1                                          
MFA-TR*             ,:DY-ADDR-PREFIX-2                                          
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:DY-ZIP-CODE-TOKEN                                         
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM  CSS_ADDR_FORMATTED                                        
MFA-TR*        WHERE  ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '** FORMAT ADDRESS              **'               
              DISPLAY '** 7500-FMT-SVC-ADDR           **'               
              DISPLAY '** ADDRESS ID     = ' DY-ADDRESS-ID              
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
                                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-TOWN-DETAILS.                                           **        
      ******************************************************************        
      *                                                                         
       7700-TOWN-DETAILS.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  TOWN                                              
                     ,STATE                                             
                INTO :A4-TOWN                                           
                    ,:A4-STATE                                          
                FROM  CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
               WHERE  ZIP_CODE             = :A4-ZIP-CODE               
                 AND  ZIP_CODE_TOKEN       = :A4-ZIP-CODE-TOKEN         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*         INTO :A4-TOWN                                                   
MFA-TR*             ,:A4-STATE                                                  
MFA-TR*         FROM  CSS_ZIP_CODE                                              
MFA-TR*        WHERE  ZIP_CODE             = :A4-ZIP-CODE                       
MFA-TR*          AND  ZIP_CODE_TOKEN       = :A4-ZIP-CODE-TOKEN                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '** GET TOWN DETAILS            **'               
              DISPLAY '** 7700-TOWN-DETAILS           **'               
              DISPLAY '** A4-ZIP-CODE       = ' A4-ZIP-CODE             
              DISPLAY '** A4-ZIP-CODE-TOKEN = ' A4-ZIP-CODE-TOKEN       
              DISPLAY '** RETURN CODE       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7800-GET-OTHER-DET2.                                         **        
      ******************************************************************        
      *                                                                         
       7800-GET-OTHER-DET2.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT SUBSTATION_ID                                      
                    ,CIRCUIT_ID                                         
                    ,TAG_NM                                             
                INTO :SUBSTATION-ID                                     
                    ,:CIRCUIT-ID                                        
                    ,:WS-SAVE-TAG-NM                                    
                FROM  CSS_PIM_POINT PM WITH(READUNCOMMITTED)                    
               WHERE  PM.POINT_ID= :MN-GIS-POINT-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTATION_ID                                              
MFA-TR*             ,CIRCUIT_ID                                                 
MFA-TR*             ,TAG_NM                                                     
MFA-TR*         INTO :SUBSTATION-ID                                             
MFA-TR*             ,:CIRCUIT-ID                                                
MFA-TR*             ,:WS-SAVE-TAG-NM                                            
MFA-TR*         FROM  CSS_PIM_POINT PM                                          
MFA-TR*        WHERE  PM.POINT_ID= :MN-GIS-POINT-ID                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '** GET OTHER ADDRESS DETAILS   **'               
              DISPLAY '** 7800-GET-OTHER-DET2       **'                 
              DISPLAY '** MN-GIS-POINT-ID =' MN-GIS-POINT-ID            
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7900-GET-PEAK.                                               **        
      ******************************************************************        
      *                                                                         
       7900-GET-PEAK.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) PH.PEAK_KW_UNITS,
              PH.PEAK_KVA_UNITS,
              PH.PEAK_TYPE                                       
                INTO :PH-PEAK-KW-UNITS                                  
                    ,:PH-PEAK-KVA-UNITS                                 
                    ,:PH-PEAK-TYPE                                      
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_PEAK_HISTORY PH WITH(READUNCOMMITTED)                  
               WHERE BG.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
                 AND BG.ACCOUNT_NO     = PH.ACCOUNT_NO                  
                 AND BG.BILL_NO        = PH.BILL_NO                     
                 AND BG.CODE_UTIL_TYPE = PH.CODE_UTIL_TYPE              
                 AND BG.IC_NO          = PH.IC_NO                       
                 AND BG.REVENUE_MONTH  = :BG-REVENUE-MONTH              
                 AND PH.METER_NO       = :MN-METER-NO                   
                 AND PH.MTR_REF_NO     = :MN-MTR-REF-NO                 
                 AND PH.PEAK_TYPE  IN ('B', 'E', 'J')                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PH.PEAK_KW_UNITS                                           
MFA-TR*             ,PH.PEAK_KVA_UNITS                                          
MFA-TR*             ,PH.PEAK_TYPE                                               
MFA-TR*         INTO :PH-PEAK-KW-UNITS                                          
MFA-TR*             ,:PH-PEAK-KVA-UNITS                                         
MFA-TR*             ,:PH-PEAK-TYPE                                              
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_PEAK_HISTORY PH                                        
MFA-TR*        WHERE BG.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND BG.ACCOUNT_NO     = PH.ACCOUNT_NO                          
MFA-TR*          AND BG.BILL_NO        = PH.BILL_NO                             
MFA-TR*          AND BG.CODE_UTIL_TYPE = PH.CODE_UTIL_TYPE                      
MFA-TR*          AND BG.IC_NO          = PH.IC_NO                               
MFA-TR*          AND BG.REVENUE_MONTH  = :BG-REVENUE-MONTH                      
MFA-TR*          AND PH.METER_NO       = :MN-METER-NO                           
MFA-TR*          AND PH.MTR_REF_NO     = :MN-MTR-REF-NO                         
MFA-TR*          AND PH.PEAK_TYPE  IN ('B', 'E', 'J')                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '** GET PEAK UNITS              **'               
              DISPLAY '** 7900-GET-PEAK             **'                 
              DISPLAY '** AT-ACCOUNT-NO    ' AT-ACCOUNT-NO              
              DISPLAY '** WS-REVENUE-MONTH ' WS-REVENUE-MONTH           
              DISPLAY '** METER NO         ' MN-METER-NO                
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7910-GET-REG-READ.                                           **        
      ******************************************************************        
      *                                                                         
       7910-GET-REG-READ.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                    SUM( CASE WHEN CODE_USAGE_TYPE = 'E'                
                              THEN LAST_READ_VALUE                      
                              ELSE 0 END)                               
                   ,SUM( CASE WHEN CODE_USAGE_TYPE = 'J'                
                              THEN LAST_READ_VALUE                      
                              ELSE 0 END)                               
                INTO :WS-KVA-WORK :WS-NULL-INDR1                         
                    ,:WS-KW-WORK :WS-NULL-INDR2                          
                FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED)                 
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE             
                  AND IC_NO            = :MN-IC-NO                      
                  AND MTR_REF_NO       = :MN-MTR-REF-NO                 
                  AND METER_NO         = :MN-METER-NO                   
                  AND LAST_REG_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE) )         
                  AND CODE_USAGE_TYPE IN ('E', 'J')                     
                  AND CODE_TIME_PERIOD = 0                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*             SUM( CASE WHEN CODE_USAGE_TYPE = 'E'                        
MFA-TR*                       THEN LAST_READ_VALUE                              
MFA-TR*                       ELSE 0 END)                                       
MFA-TR*            ,SUM( CASE WHEN CODE_USAGE_TYPE = 'J'                        
MFA-TR*                       THEN LAST_READ_VALUE                              
MFA-TR*                       ELSE 0 END)                                       
MFA-TR*         INTO :WS-KVA-WORK:WS-NULL-INDR1                                 
MFA-TR*             ,:WS-KW-WORK:WS-NULL-INDR2                                  
MFA-TR*         FROM CSS_REGISTER_READ RG                                       
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE                     
MFA-TR*           AND IC_NO            = :MN-IC-NO                              
MFA-TR*           AND MTR_REF_NO       = :MN-MTR-REF-NO                         
MFA-TR*           AND METER_NO         = :MN-METER-NO                           
MFA-TR*           AND LAST_REG_READ_DT = :MN-LAST-REG-READ-DATE                 
MFA-TR*           AND CODE_USAGE_TYPE IN ('E', 'J')                             
MFA-TR*           AND CODE_TIME_PERIOD = 0                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7910                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '**   GET USAGE READINGS        **'               
              DISPLAY '** 7910-GET-REG-READ           **'               
              DISPLAY '** AT-ACCOUNT-NO    ' AT-ACCOUNT-NO              
              DISPLAY '** MN-CODE-UTIL-TYPE' MN-CODE-UTIL-TYPE          
              DISPLAY '** MN-IC-NO         ' MN-IC-NO                   
              DISPLAY '** MN-MTR-REF-NO    ' MN-MTR-REF-NO              
              DISPLAY '** MN-METER-NO      ' MN-METER-NO                
              DISPLAY '** MN-LAST-REG-READ ' MN-LAST-REG-READ-DATE      
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7920-GET-DBA.                                                **        
      ******************************************************************        
      *                                                                         
       7920-GET-DBA.                                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME                                       
                INTO :WS-DBA-NAME                                       
                FROM CSS_NAME DQ WITH(READUNCOMMITTED)                          
                    ,CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)                
               WHERE AB.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                 AND AB.NAME_TYPE     = 'DB'                            
                 AND AB.NAME_ID       = DQ.NAME_ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.FULL_NAME                                               
MFA-TR*         INTO :WS-DBA-NAME                                               
MFA-TR*         FROM CSS_NAME DQ                                                
MFA-TR*             ,CSS_ACCT_BILL_NMES AB                                      
MFA-TR*        WHERE AB.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*          AND AB.NAME_TYPE     = 'DB'                                    
MFA-TR*          AND AB.NAME_ID       = DQ.NAME_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7920                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP430 ABORT *********'               
              DISPLAY '**   GET DBA DETAILS           **'               
              DISPLAY '** 7920-GET-DBA              **'                 
              DISPLAY '** AT-ACCOUNT-NO   =' AT-ACCOUNT-NO              
              DISPLAY '** RETURN CODE     =' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED       **'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE-HEADER.                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
           WRITE PRT294-RECORD FROM WS-RP430-HDR-REC-LN.                
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT294-RECORD FROM WS-RP430-OUT-REC.                   
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT294-FILE.                                         
                                                                        
           IF NOT FCA294-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP430 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING FCSPT294-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA294-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
