       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP426.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. OCT-2002.                                          
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      ********         CUSTOMER INFORMATION SYSTEM            *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS        REASON                       **         
      **   10-31-2002   COVANSYS    NEW REPORT PROGRAM               **         
      **                            FOR REPORT GENERATION            **         
T35434**   05-16-2007   MK92804     REPLACED MODEL_SQL WITH SET COMMAND         
T35434**                            AND ADDED WITH UR FOR -911 ABENDS**         
A03303*    05-26-2011   SV95326     FIXED FACTOR PRECISION CHANGES     *        
A03303*                 ACT013      FROM 4 TO 6 DECIMAL POINTS FOR     *        
A03303*                             INDUSTRIAL BILLING.                *        
      *****************************************************************         
            REMARKS.                                                    
      *****************************************************************         
      *****************************************************************         
      *        REPORT GENERATOR FOR PCSRP426 REPORTS                  *         
      *        THIS IS A NEW PROGRAM WRITTEN FOR GENERATING           *         
      *        COMPETITIVE PRICE LIST FOR THE CURRENT REVENUE MONTH   *         
      *                                                               *         
      *        INPUT FOR THIS PROGRAM IS FROM FOLLOWING TABLES        *         
      *        1. CSS_UTIL_ENVRNMT                                    *         
      *        2. CSS_FIXED_FCT_HIST                                  *         
      *        3. CSS_PRTY_SVC_CAT                                    *         
      *                                                               *         
      *        THIS IS A MONTHLY REPORT                               *         
      *                                                               *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP426'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP426 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-ONE                    PIC 9(02)  VALUE 01.           
           05  WS-ZERO                   PIC 9(02)  VALUE 00.           
           05  WS-MAX                    PIC 9(02)  VALUE 60.           
           05  WS-RPT-CNTR               PIC 9(05)  VALUE ZERO.         
           05  WS-MAX-LINES              PIC 9(02)  VALUE 56.           
           05  WS-LINE-COUNT             PIC 9(02)  VALUE 57.           
           05  WS-HYPHEN                 PIC X(01)  VALUE '-'.          
           05  WS-PAGE-COUNT             PIC 9(03)  VALUE ZERO.         
           05  WS-ERR-MSG                PIC X(50)  VALUE SPACES.       
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  MULTIPLE-ROWS             PIC S9(9)  VALUE -811 COMP.    
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSRP426'.   
           05  WS-PGRNAME                PIC X(08)  VALUE 'PCSRP426'.   
           05  WS-COMP-NAME              PIC X(26)  VALUE  SPACES.      
           05  WS-MONTH                  PIC X(09)  VALUE  SPACES.      
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-G                      PIC X(01)  VALUE 'G'.          
           05  WS-CP                     PIC X(02)  VALUE 'CP'.         
           05  WS-FULL-NAME              PIC X(50)  VALUE SPACES.       
           05  WS-CUST-NAME              PIC X(40)  VALUE SPACES.       
           05  WS-FACTOR-ID              PIC X(09)  VALUE SPACES.       
           05  WS-READ-CYCLE             PIC X(02)  VALUE SPACES.       
           05  WS-OPTIMUM-DATE-CUR       PIC X(10)  VALUE SPACES.       
           05  WS-OPTIMUM-DT-PRIOR       PIC X(10)  VALUE SPACES.       
           05  WS-OPTIMUM-DT-PRIOR-1     PIC X(10)  VALUE SPACES.       
           05  WS-FACTOR                 PIC S9(9)V9(4) USAGE COMP-3    
                                                    VALUE ZERO.         
           05  WS-FACTOR-NULL-IND        PIC S9(04) COMP                
                                                    VALUE 0.            
           05  WS-OPT-DT-NULL-IND        PIC S9(04) COMP                
                                                    VALUE 0.            
           05  WS-DEFAULT-COMP-NO        PIC X(02)  VALUE '01'.         
           05  WS-CUR-REV-MON.                                          
               10  WS-REV-CCYY           PIC 9(04).                     
               10  WS-REV-MM             PIC 9(02).                     
           05  WS-CUR-REV-MON-CR      REDEFINES WS-CUR-REV-MON          
                                         PIC 9(06).                     
          05  WS-PREV-REVENUE-MONTH.                                    
              10 WS-PREV-REV-YYYY        PIC 9(04).                     
              10 WS-PREV-REV-MM          PIC 9(02).                     
          05  WS-PREV-REV-MONTH REDEFINES                               
              WS-PREV-REVENUE-MONTH      PIC 9(06).                     
                                                                        
COB305     05 WS-CUR-REV-MON-NUM        PIC S9(6)V USAGE COMP-3 VALUE 0.       
A03303     05  WS-FACTOR-FF              PIC S9(09)V9(06) USAGE COMP-3  
A03303                                                    VALUE 0.      
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-FILE-STATUS             PIC X(02).                     
              88 SUCCESSFUL                         VALUE '00'.         
                                                                        
           05 WS-MORE-ROWS-FLAG          PIC X(01)  VALUE 'Y'.          
              88 END-OF-ROWS                        VALUE 'N'.          
              88 MORE-ROWS                          VALUE 'Y'.          
                                                                        
      ***************** PCSRP426 REPORT HEADERS **********************          
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
           05 WS-RPT-TITLE-1.                                           
              10  FILLER                 PIC X(02)  VALUE SPACES.       
              10  P-RPT-TITLE-PGNM       PIC X(08).                     
              10  FILLER                 PIC X(09)  VALUE '-PCSR4261'.  
              10  FILLER                 PIC X(36)  VALUE SPACES.       
              10  P-RPT-COMP-NAME        PIC X(26).                     
              10  FILLER                 PIC X(32)  VALUE SPACES.       
              10  FILLER                 PIC X(11)  VALUE ' RUN DATE: '.
              10  P-RPT-RUN-MM           PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
              10  P-RPT-RUN-DD           PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
              10  P-RPT-RUN-YY           PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
           05 WS-RPT-TITLE-2.                                           
              10 FILLER                  PIC X(55)  VALUE SPACES.       
              10 WS-RPT-HDR              PIC X(58)  VALUE SPACES.       
              10 FILLER                  PIC X(11)  VALUE ' RUN TIME: '.
              10 WS-REP-HH               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-MIN              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-SS               PIC X(02).                     
              10 FILLER                  PIC X(03)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
           05 WS-RPT-TITLE-3.                                           
              10 FILLER                  PIC X(59)  VALUE SPACES.       
              10 P-RPT-MONTH             PIC X(09)  VALUE SPACES.       
              10 FILLER                  PIC X(01)  VALUE SPACES.       
              10 P-RPT-YY                PIC X(02)  VALUE SPACES.       
              10 FILLER                  PIC X(42)  VALUE SPACES.       
              10 FILLER                  PIC X(10)  VALUE '     PAGE:'. 
              10 FILLER                  PIC X(05)  VALUE SPACES.       
              10 WS-REP-PAGE             PIC ZZZ9.                      
              10 FILLER                  PIC X(01)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER.       **            
      ***************************************************************           
           05 WS-RPT-HEADER.                                            
              10 FILLER                  PIC X(08)  VALUE SPACES.       
              10 FILLER                  PIC X(14)  VALUE               
                                                   'ACCOUNT NUMBER'.    
              10 FILLER                  PIC X(05)  VALUE SPACES.       
              10 FILLER                  PIC X(14)  VALUE               
                                                   'CUSTOMER NAME '.    
              10 FILLER                  PIC X(30)  VALUE SPACES.       
              10 FILLER                  PIC X(05)  VALUE 'IC NO'.      
              10 FILLER                  PIC X(06)  VALUE SPACES.       
              10 FILLER                  PIC X(08)  VALUE 'CATEGORY'.   
              10 FILLER                  PIC X(05)  VALUE SPACES.       
              10 FILLER                  PIC X(17)  VALUE               
                                                    'COMPETITIVE PRICE'.
              10 FILLER                  PIC X(20)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
                                                                        
           05  WS-LINE.                                                 
               10 FILLER                 PIC X(133) VALUE ALL '-'.      
                                                                        
           05  WS-UNDERLINE.                                            
               10 FILLER                 PIC X(90)  VALUE SPACES.       
               10 FILLER                 PIC X(14)  VALUE ALL '-'.      
               10 FILLER                 PIC X(28)  VALUE SPACES.       
                                                                        
      ***************************************************************           
                                                                        
       01  WS-DETAIL-LINE.                                              
           10 FILLER                     PIC X(06)  VALUE SPACES.       
           10 WS-ACCOUNT-NO-P            PIC XBXXXXBXXXXBXXXX           
                                                    VALUE SPACES.       
           10 FILLER                     PIC X(05)  VALUE SPACES.       
           10 WS-NAME-P                  PIC X(40).                     
           10 FILLER                     PIC X(05)  VALUE SPACES.       
           10 WS-IC-NO-P                 PIC ZZ99.                      
           10 FILLER                     PIC X(12)  VALUE SPACES.       
           10 WS-CATEGORY-P              PIC X(02)  VALUE SPACES.       
           10 FILLER                     PIC X(08)  VALUE SPACES.       
A03303     10 WS-FACTOR-P                PIC ZZZZZZZZ9.9(06).           
           10 FILLER                     PIC X(10)  VALUE SPACES.       
           10 FILLER                     PIC X(10)  VALUE ALL '_'.      
A03303     10 FILLER                     PIC X(01)  VALUE SPACES.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                     PIC X(48)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '**** NO DATA THIS RUN****'.                             
           05 FILLER                     PIC X(55)  VALUE SPACES.       
                                                                        
       01  WS-FOOTER1.                                                  
           05 FILLER                     PIC X(35)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '* * * END OF REPORT * * *'.                             
           05 FILLER                     PIC X(72)  VALUE SPACES.       
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME               PIC 9(08).                     
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)  VALUE 'Y'.          
           05 WS-N                       PIC X(01)  VALUE 'N'.          
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00011.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT - UT                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RATE_COMP_DEF - J1                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCDEF                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILLING_DET - BG                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PRTY_SVC_CAT -  Z4                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSVCCAT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_FIXED_FCTR - FF                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBFXDFCT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY - C7                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM - G6                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME - DQ                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME_ACCT_XREF - HT                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILLING_HDR - BI                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_READ_WINDOW - RW                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRDWNDW                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_SPCL_FCTR - SF                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSPLFTR                                                
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * FIXED_FCTR CURSOR FOR SELECTING ALL THE FACTORS FOR A         *         
      * CUSTOMER FROM CSS_FIXED_FCTR TABLE                            *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
                DECLARE FIXED_FCTR CURSOR FOR                           
A03303            SELECT  FF.ACCOUNT_NO,                                
A03303                    FF.IC_NO,                                     
A03303                    FF.CODE_UTIL_TYPE,                            
A03303                    FF.FACTOR,                                    
A03303                    SF.FCTR_POWER_10                              
A03303              FROM  CSS_FIXED_FCTR FF WITH(READUNCOMMITTED),              
A03303                    CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                
A03303             WHERE  FF.CODE_UTIL_TYPE    = :WS-G                  
A03303               AND  FF.FACTOR_ID         = :WS-FACTOR-ID          
A03303               AND  FF.FACTOR_ID         = SF.FACTOR_ID           
A03303               AND  FF.EFF_DATE_FROM    >= IIF(TRY_CONVERT(DATE, 
                                                 :WS-OPTIMUM-DT-PRIOR-1
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMUM-DT-PRIOR-1
              ) <> 0) OR (LEN(:WS-OPTIMUM-DT-PRIOR-1
              ) <> 10), CIS.CHAR2DATE(:WS-OPTIMUM-DT-PRIOR-1
              ), CONVERT(DATE, :WS-OPTIMUM-DT-PRIOR-1) ) 
A03303               AND (FF.EFF_DATE_TO IS NULL                        
A03303                OR  FF.EFF_DATE_TO      <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-OPTIMUM-DATE-CUR
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMUM-DATE-CUR
              ) <> 0) OR (LEN(:WS-OPTIMUM-DATE-CUR
              ) <> 10), CIS.CHAR2DATE(:WS-OPTIMUM-DATE-CUR
              ), CONVERT(DATE, :WS-OPTIMUM-DATE-CUR) ))  
A03303               AND  FF.EFF_DATE_FROM    <> EFF_DATE_TO            
A03303               AND  FF.INSTR_USE_TYPE_CD = 'R'                    
A03303          ORDER BY  FF.ACCOUNT_NO,FF.IC_NO,FF.EFF_DATE_FROM       
T35434               FOR READ ONLY                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE FIXED_FCTR CURSOR FOR                                   
MFA-TR*           SELECT  FF.ACCOUNT_NO,                                        
MFA-TR*                   FF.IC_NO,                                             
MFA-TR*                   FF.CODE_UTIL_TYPE,                                    
MFA-TR*                   FF.FACTOR,                                            
MFA-TR*                   SF.FCTR_POWER_10                                      
MFA-TR*             FROM  CSS_FIXED_FCTR FF,                                    
MFA-TR*                   CSS_SPCL_FCTR SF                                      
MFA-TR*            WHERE  FF.CODE_UTIL_TYPE    = :WS-G                          
MFA-TR*              AND  FF.FACTOR_ID         = :WS-FACTOR-ID                  
MFA-TR*              AND  FF.FACTOR_ID         = SF.FACTOR_ID                   
MFA-TR*              AND  FF.EFF_DATE_FROM    >= :WS-OPTIMUM-DT-PRIOR-1         
MFA-TR*              AND (FF.EFF_DATE_TO IS NULL                                
MFA-TR*               OR  FF.EFF_DATE_TO      <= :WS-OPTIMUM-DATE-CUR)          
MFA-TR*              AND  FF.EFF_DATE_FROM    <> EFF_DATE_TO                    
MFA-TR*              AND  FF.INSTR_USE_TYPE_CD = 'R'                            
MFA-TR*         ORDER BY  FF.ACCOUNT_NO,FF.IC_NO,FF.EFF_DATE_FROM               
MFA-TR*              FOR  FETCH ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSRP426 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO  WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **  0100-INITIALIZATION.                                 **               
      **        INITIALIZATION ROUTINE                         **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
      * GET CURRENT DATE                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO   P-RPT-RUN-YY.           
           MOVE   WS-CURRENT-MM            TO   P-RPT-RUN-MM.           
           MOVE   WS-CURRENT-DD            TO   P-RPT-RUN-DD.           
                                                                        
      * GET CURRENT TIME                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
           MOVE   WS-CURRENT-TIME(1:2)     TO   WS-REP-HH.              
           MOVE   WS-CURRENT-TIME(3:2)     TO   WS-REP-MIN.             
           MOVE   WS-CURRENT-TIME(5:2)     TO   WS-REP-SS.              
                                                                        
      * SELECT COMPANY NAME                                                     
           MOVE WS-DEFAULT-COMP-NO         TO C7-COMPANY-NO.            
           PERFORM 7850-GET-COMPANY-DESC   THRU 7850-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME         TO WS-COMP-NAME              
           END-IF.                                                      
                                                                        
      * SELECT CURRENT REVENUE MONTH                                            
           PERFORM 0110-PROCESS-PARM-DATE  THRU 0110-EXIT.              
                                                                        
      * SELECT READ CYCLE FROM CSS_JOB_PARM TABLE                               
           MOVE SPACES                     TO WS-READ-CYCLE.            
           PERFORM 7650-SELECT-READ-CYCLE  THRU 7650-EXIT.              
                                                                        
      * SELECT FACTOR ID FROM CSS_JOB_PARM TABLE                                
           MOVE SPACES                     TO WS-FACTOR-ID.             
           PERFORM 7750-SELECT-FACTOR-ID   THRU 7750-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'COMPPRICE'             TO WS-FACTOR-ID              
           END-IF.                                                      
                                                                        
           PERFORM 7900-SELECT-FACTOR-DESC THRU 7900-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'COMPETITIVE PRICE LIST'                             
                                           TO WS-RPT-HDR                
           ELSE                                                         
              IF WS-FACTOR-ID = 'COMPPRICE'                             
                 MOVE 'COMPETITIVE PRICE LIST'                          
                                           TO WS-RPT-HDR                
              ELSE                                                      
                 MOVE SF-FACTOR-DESC       TO WS-RPT-HDR                
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * SELECT OPTIMUM READ DATE FROM CSS_READ_WINDOW TABLE                     
                                                                        
           MOVE WS-READ-CYCLE              TO RW-READ-CYCLE.            
           MOVE WS-CUR-REV-MON-CR          TO RW-REVENUE-MONTH.         
           MOVE SPACES                     TO RW-OPTIMUM-READ-DATE.     
           PERFORM 7500-SELECT-OPTIMUM-READ-DT                          
                                           THRU 7500-EXIT.              
           IF WS-OPT-DT-NULL-IND < 0                                    
              MOVE SPACES                  TO RW-OPTIMUM-READ-DATE      
           END-IF.                                                      
                                                                        
           MOVE RW-OPTIMUM-READ-DATE       TO WS-OPTIMUM-DATE-CUR.      
      *                                                                         
           MOVE WS-READ-CYCLE              TO RW-READ-CYCLE.            
           MOVE WS-PREV-REV-MONTH          TO RW-REVENUE-MONTH.         
           MOVE SPACES                     TO RW-OPTIMUM-READ-DATE.     
           PERFORM 7500-SELECT-OPTIMUM-READ-DT                          
                                           THRU 7500-EXIT.              
           IF WS-OPT-DT-NULL-IND < 0                                    
              MOVE SPACES                  TO RW-OPTIMUM-READ-DATE      
           END-IF.                                                      
                                                                        
           MOVE RW-OPTIMUM-READ-DATE       TO WS-OPTIMUM-DT-PRIOR.      
           PERFORM 7999-SELECT-OPTIMUM-DT-PRIOR                         
                                           THRU 7999-EXIT.              
                                                                        
      * INITIALIZATION                                                          
           INITIALIZE FF-ACCOUNT-NO,                                    
                      HT-ACCOUNT-NO,                                    
                      FF-IC-NO,                                         
                      WS-FACTOR,                                        
A03303                SF-FCTR-POWER-10.                                 
           MOVE SPACES                     TO WS-CUST-NAME              
                                              Z4-PRTY-SVC-CAT-CD.       
      *                                                                         
           PERFORM 0200-GET-MONTH-NAME     THRU 0200-EXIT.              
      *                                                                         
           MOVE WS-MONTH                   TO P-RPT-MONTH.              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **  0110-PROCESS-PARM-DATE.                                **             
      **       PROCESSES THE REVENUE MONTH                       **             
      *************************************************************             
      *                                                                         
       0110-PROCESS-PARM-DATE.                                          
      *                                                                         
           MOVE '0110'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           INITIALIZE WS-SYSIPT,                                        
                      WS-INPUT-DATA-BREAKDOWN.                          
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
           MOVE WS-PARM-MONTH              TO WS-REV-MM.                
           MOVE WS-PARM-YR(1:4)            TO WS-REV-CCYY.              
           MOVE WS-PARM-YR(3:2)            TO P-RPT-YY.                 
                                                                        
           MOVE WS-CUR-REV-MON-CR          TO WS-PREV-REV-MONTH.        
                                                                        
           COMPUTE WS-PREV-REV-MM = WS-PREV-REV-MM - 1.                 
           IF  WS-PREV-REV-MM = ZEROS                                   
               MOVE 12                     TO WS-PREV-REV-MM            
               COMPUTE WS-PREV-REV-YYYY = WS-PREV-REV-YYYY - 1          
           END-IF.                                                      
                                                                        
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
                                                                        
           MOVE WS-CUR-REV-MON-CR          TO WS-CUR-REV-MON-NUM.       
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **   0200-GET-MONTH-NAME.                                  **             
      **        ASSIGN MONTH NAME ACCORDING TO THE NUMERIC VALUE **             
      *************************************************************             
                                                                        
       0200-GET-MONTH-NAME.                                             
                                                                        
           MOVE '0200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EVALUATE WS-REV-MM                                           
               WHEN 01                                                  
                   MOVE 'JANUARY'          TO WS-MONTH                  
               WHEN 02                                                  
                   MOVE 'FEBRUARY'         TO WS-MONTH                  
               WHEN 03                                                  
                   MOVE 'MARCH'            TO WS-MONTH                  
               WHEN 04                                                  
                   MOVE 'APRIL'            TO WS-MONTH                  
               WHEN 05                                                  
                   MOVE 'MAY'              TO WS-MONTH                  
               WHEN 06                                                  
                   MOVE 'JUNE'             TO WS-MONTH                  
               WHEN 07                                                  
                   MOVE 'JULY'             TO WS-MONTH                  
               WHEN 08                                                  
                   MOVE 'AUGUST'           TO WS-MONTH                  
               WHEN 09                                                  
                   MOVE 'SEPTEMBER'        TO WS-MONTH                  
               WHEN 10                                                  
                   MOVE 'OCTOBER'          TO WS-MONTH                  
               WHEN 11                                                  
                   MOVE 'NOVEMBER'         TO WS-MONTH                  
               WHEN 12                                                  
                   MOVE 'DECEMBER'         TO WS-MONTH                  
           END-EVALUATE.                                                
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7100-OPEN-FIXED-FCTR-CURSOR                          
                                           THRU 7100-EXIT.              
                                                                        
           PERFORM 7200-FETCH-FIXED-FCTR-CURSOR                         
                                           THRU 7200-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2100-GAS-CUSTOMER-DETAILS                         
                                           THRU 2100-EXIT               
                                           UNTIL END-OF-ROWS            
           ELSE                                                         
              PERFORM 8100-PRINT-RPT-NO-DATA                            
                                           THRU 8100-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 7300-CLOSE-FIXED-FCTR-CURSOR                         
                                           THRU 7300-EXIT.              
                                                                        
           PERFORM 8400-PRINT-RPT-FOOTER   THRU 8400-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2100-GAS-CUSTOMER-DETAILS.                            **           
      **          GETS DETAILS FROM EACH CIG CUSTOMER              **           
      ***************************************************************           
      *                                                                         
       2100-GAS-CUSTOMER-DETAILS.                                       
      *                                                                         
           MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           SET MORE-ROWS                   TO TRUE.                     
      *                                                                         
           IF HT-ACCOUNT-NO NOT EQUAL FF-ACCOUNT-NO                     
              PERFORM 7800-SELECT-CUSTOMER-NAME                         
                                           THRU 7800-EXIT               
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE WS-FULL-NAME         TO WS-EMB-INPUT              
                 MOVE 50                   TO WS-EMB-LENG               
                 MOVE SPACES               TO WS-CMP-TABLE              
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES                    
                                           THRU 6010-EXIT               
                 MOVE WS-CMP-TABLE         TO WS-FULL-NAME              
                 MOVE WS-FULL-NAME         TO WS-CUST-NAME              
              ELSE                                                      
                 MOVE SPACES               TO WS-FULL-NAME,             
                                              WS-CUST-NAME              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-SELECT-CAT-CD      THRU 7400-EXIT.              
      *                                                                         
           PERFORM 8000-PRINT-RPT-REPORT   THRU 8000-EXIT.              
      *                                                                         
           PERFORM 7200-FETCH-FIXED-FCTR-CURSOR                         
                                           THRU 7200-EXIT.              
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **   6010-REDUCE-EMBEDDED-SPACES                             **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **   6200-GET-PARAMETER-DATE                                 **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    7600-START-FJC01.                                       **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *   6251-GET-FJC01-DATE.                                     **           
      ***************************************************************           
       COPY CPD00037.                                                           
       COPY CPD00040.                                                           
      ***************************************************************           
      *    7600-START-FCJ01.                                       **           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7100-OPEN-FIXED-FCTR-CURSOR.                           **           
      **         OPENS CURSOR ON CSS_FIXED_FCTR TABLE              **           
      ***************************************************************           
                                                                        
       7100-OPEN-FIXED-FCTR-CURSOR.                                     
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN FIXED_FCTR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN FIXED_FCTR CURSOR ERROR'                       
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7200-FETCH-FIXED-FCTR-CURSOR.                          **           
      **         FETCH ROWS FROM CSS_FIXED_FCTR TABLE              **           
      ***************************************************************           
                                                                        
       7200-FETCH-FIXED-FCTR-CURSOR.                                    
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH FIXED_FCTR INTO                                   
                   :FF-ACCOUNT-NO,                                      
                   :FF-IC-NO,                                           
                   :FF-CODE-UTIL-TYPE,                                  
                   :FF-FACTOR,                                          
                   :SF-FCTR-POWER-10                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
                  SET END-OF-ROWS          TO TRUE                      
             WHEN OTHER                                                 
                  MOVE 'ERROR IN FETCHING FIXED_FCTR CURSOR'            
                                           TO WS-ERR-MSG                
                  MOVE SQLCODE             TO WS-DISP-RC                
                  PERFORM 9100-DISPLAY-ERROR                            
                                           THRU 9100-EXIT               
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7300-CLOSE-FIXED-FCTR-CURSOR.                          **           
      **         CLOSES CURSOR ON CSS_FIXED_FCTR                   **           
      ***************************************************************           
                                                                        
       7300-CLOSE-FIXED-FCTR-CURSOR.                                    
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE FIXED_FCTR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'CLOSE FIXED_FCTR CURSOR ERROR'                      
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7400-SELECT-CAT-CD.                                      **          
      **      SELECTS THE PRIORITY SERVICE CATEGORY CODE            **          
      ****************************************************************          
                                                                        
       7400-SELECT-CAT-CD.                                              
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT PRTY_SVC_CAT_CD                                     
               INTO :Z4-PRTY-SVC-CAT-CD                                 
               FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED),                  
                    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE Z4.CODE_CURTAIL_PRTY  =  UT.CODE_CURTAIL_PRTY       
                AND UT.ACCOUNT_NO         = :FF-ACCOUNT-NO              
                AND UT.IC_NO              = :FF-IC-NO                   
                AND UT.CODE_UTIL_TYPE     = :WS-G                       
                AND Z4.COMPANY_NO         = :WS-DEFAULT-COMP-NO         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PRTY_SVC_CAT_CD                                             
MFA-TR*        INTO :Z4-PRTY-SVC-CAT-CD                                         
MFA-TR*        FROM CSS_PRTY_SVC_CAT Z4,                                        
MFA-TR*             CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE Z4.CODE_CURTAIL_PRTY  =  UT.CODE_CURTAIL_PRTY               
MFA-TR*         AND UT.ACCOUNT_NO         = :FF-ACCOUNT-NO                      
MFA-TR*         AND UT.IC_NO              = :FF-IC-NO                           
MFA-TR*         AND UT.CODE_UTIL_TYPE     = :WS-G                               
MFA-TR*         AND Z4.COMPANY_NO         = :WS-DEFAULT-COMP-NO                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'ERROR IN SELECTING CATEGORY'                       
                                           TO WS-ERR-MSG                
               MOVE SQLCODE                TO WS-DISP-RC                
               PERFORM 9100-DISPLAY-ERROR                               
                                           THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
        7400-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-SELECT-OPTIMUM-READ-DT.                             **          
      **      SELECTS OPTIMUM READ DATE FROM CSS_READ_WINDOW TABLE  **          
      ****************************************************************          
                                                                        
       7500-SELECT-OPTIMUM-READ-DT.                                     
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT OPTIMUM_READ_DATE                                   
               INTO :RW-OPTIMUM-READ-DATE :WS-OPT-DT-NULL-IND            
               FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                       
              WHERE READ_CYCLE    = :RW-READ-CYCLE                      
                AND REVENUE_MONTH = :RW-REVENUE-MONTH                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT OPTIMUM_READ_DATE                                           
MFA-TR*        INTO :RW-OPTIMUM-READ-DATE:WS-OPT-DT-NULL-IND                    
MFA-TR*        FROM CSS_READ_WINDOW                                             
MFA-TR*       WHERE READ_CYCLE    = :RW-READ-CYCLE                              
MFA-TR*         AND REVENUE_MONTH = :RW-REVENUE-MONTH                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'ERROR IN SELECTING OPTIMUM READ DATE'              
                                           TO WS-ERR-MSG                
               MOVE SQLCODE                TO WS-DISP-RC                
               PERFORM 9100-DISPLAY-ERROR                               
                                           THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
        7500-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7650-SELECT-READ-CYCLE.                                  **          
      **      SELECTS READ CYCLE FROM CSS_JOB_PARM TABLE            **          
      ****************************************************************          
                                                                        
       7650-SELECT-READ-CYCLE.                                          
                                                                        
           MOVE '7650'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT CIS.SUBSTR3(PARM_DATA,12,2)                              
               INTO :WS-READ-CYCLE                                      
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME = :WS-PGRMNAME                         
                AND COMPANY_NO   = :WS-DEFAULT-COMP-NO                  
                AND CMND_CODE    = 'PARM'                               
                AND CIS.SUBSTR3(PARM_DATA,1,10) = 'READ CYCLE'               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUBSTR(PARM_DATA,12,2)                                      
MFA-TR*        INTO :WS-READ-CYCLE                                              
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = :WS-PGRMNAME                                 
MFA-TR*         AND COMPANY_NO   = :WS-DEFAULT-COMP-NO                          
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND SUBSTR(PARM_DATA,1,10) = 'READ CYCLE'                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'ERROR IN SELECTING READ CYCLE FROM JOB PARM'       
                                           TO WS-ERR-MSG                
               MOVE SQLCODE                TO WS-DISP-RC                
               PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7650-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7750-SELECT-FACTOR-ID.                                   **          
      **      SELECTS FACTOR FROM CSS_JOB_PARM TABLE                **          
      ****************************************************************          
                                                                        
       7750-SELECT-FACTOR-ID.                                           
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT CIS.SUBSTR3(PARM_DATA,11,9)                              
               INTO :WS-FACTOR-ID                                       
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME          = :WS-PGRMNAME                
                AND COMPANY_NO            = :WS-DEFAULT-COMP-NO         
                AND CMND_CODE             = 'PARM'                      
                AND CIS.SUBSTR3(PARM_DATA,1,9) = 'FACTOR ID'                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUBSTR(PARM_DATA,11,9)                                      
MFA-TR*        INTO :WS-FACTOR-ID                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME          = :WS-PGRMNAME                        
MFA-TR*         AND COMPANY_NO            = :WS-DEFAULT-COMP-NO                 
MFA-TR*         AND CMND_CODE             = 'PARM'                              
MFA-TR*         AND SUBSTR(PARM_DATA,1,9) = 'FACTOR ID'                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'ERROR IN SELECTING FACTOR ID FROM JOB PARM'        
                                           TO WS-ERR-MSG                
               MOVE SQLCODE                TO WS-DISP-RC                
               PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7750-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7800-SELECT-CUSTOMER-NAME                                **          
      **      SELECTS THE CUSTOMER NAME FROM CSS_NAME               **          
      ****************************************************************          
                                                                        
       7800-SELECT-CUSTOMER-NAME.                                       
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT HT.ACCOUNT_NO,                                      
                    DQ.FULL_NAME                                        
               INTO :HT-ACCOUNT-NO,                                     
                    :WS-FULL-NAME                                       
               FROM CSS_NAME DQ WITH(READUNCOMMITTED) ,                         
                    CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                 
              WHERE HT.ACCOUNT_NO       = :FF-ACCOUNT-NO                
                AND DQ.NAME_TYPE        = 'CN'                          
                AND HT.NAME_ID          =  DQ.NAME_ID                   
                AND HT.CUSTOMER_ROLE_CD = ' '                           
                AND HT.COMPANY_NO       = :WS-DEFAULT-COMP-NO           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT HT.ACCOUNT_NO,                                              
MFA-TR*             DQ.FULL_NAME                                                
MFA-TR*        INTO :HT-ACCOUNT-NO,                                             
MFA-TR*             :WS-FULL-NAME                                               
MFA-TR*        FROM CSS_NAME DQ ,                                               
MFA-TR*             CSS_NAME_ACCT_XREF HT                                       
MFA-TR*       WHERE HT.ACCOUNT_NO       = :FF-ACCOUNT-NO                        
MFA-TR*         AND DQ.NAME_TYPE        = 'CN'                                  
MFA-TR*         AND HT.NAME_ID          =  DQ.NAME_ID                           
MFA-TR*         AND HT.CUSTOMER_ROLE_CD = ' '                                   
MFA-TR*         AND HT.COMPANY_NO       = :WS-DEFAULT-COMP-NO                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING CUSTOMER NAME'                   
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7800-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7850-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      ****************************************************************          
                                                                        
       7850-GET-COMPANY-DESC.                                           
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING COMPANY NUMBER'                  
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR                                
           END-IF.                                                      
                                                                        
        7850-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7900-SELECT-FACTOR-DESC.                                 **          
      **      SELECTS FACTOR DESCRIPTION FROM CSS_SPCL_FCTR         **          
      ****************************************************************          
                                                                        
       7900-SELECT-FACTOR-DESC.                                         
                                                                        
           MOVE '7900'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT FACTOR_DESC                                         
               INTO :SF-FACTOR-DESC                                     
               FROM CSS_SPCL_FCTR WITH(READUNCOMMITTED)                         
              WHERE FACTOR_ID = :WS-FACTOR-ID                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT FACTOR_DESC                                                 
MFA-TR*        INTO :SF-FACTOR-DESC                                             
MFA-TR*        FROM CSS_SPCL_FCTR                                               
MFA-TR*       WHERE FACTOR_ID = :WS-FACTOR-ID                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING FACTOR DESCRIPTION'              
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7900-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7999-SELECT-OPTIMUM-DT-PRIOR.                            **          
T35434**      ADDS ONE DAY TO OPTIMUM PRIOR DATE                    **          
      ****************************************************************          
                                                                        
       7999-SELECT-OPTIMUM-DT-PRIOR.                                    
                                                                        
           MOVE '7999'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OPTIMUM-DT-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMUM-DT-PRIOR
              ) <> 0) OR (LEN(:WS-OPTIMUM-DT-PRIOR
              ) <> 10), CIS.CHAR2DATE(:WS-OPTIMUM-DT-PRIOR
              ), CONVERT(DATE, :WS-OPTIMUM-DT-PRIOR) ) )
            INTO
              :WS-OPTIMUM-DT-PRIOR-1         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-OPTIMUM-DT-PRIOR-1 =                                       
MFA-TR*                      DATE(:WS-OPTIMUM-DT-PRIOR) + 1 DAY                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
T35434        MOVE 'ERROR IN SETTING OPTIMUM-DT-PRIOR '                 
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
        7999-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
                 PERFORM 8500-PRINT-RPT-HEADERS                         
                                           THRU 8500-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS  THRU 8300-EXIT.              
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
                 PERFORM 8500-PRINT-RPT-HEADERS                         
                                           THRU 8500-EXIT               
           END-IF.                                                      
                                                                        
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
                 PERFORM 8500-PRINT-RPT-HEADERS                         
                                           THRU 8500-EXIT               
           END-IF.                                                      
                                                                        
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      ******************************************************************        
                                                                        
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                     TO   WS-ACTIVE-PARAGRAPH.    
           PERFORM 8500-PRINT-RPT-HEADERS  THRU 8500-EXIT.              
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           MOVE    WS-NO-DATA-LINE         TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-DETAILS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE FF-ACCOUNT-NO              TO WS-ACCOUNT-NO-P.          
           INSPECT WS-ACCOUNT-NO-P REPLACING ALL ' '  BY  '-'.          
           MOVE WS-CUST-NAME               TO WS-NAME-P.                
           MOVE FF-IC-NO                   TO WS-IC-NO-P.               
           MOVE Z4-PRTY-SVC-CAT-CD         TO WS-CATEGORY-P.            
A03303     IF SF-FCTR-POWER-10 NOT EQUAL 0                              
A03303        COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
A03303        MOVE WS-FACTOR-FF            TO WS-FACTOR-P               
A03303        MOVE 0                       TO SF-FCTR-POWER-10          
A03303     ELSE                                                         
              MOVE FF-FACTOR               TO WS-FACTOR-P               
A03303     END-IF                                                       
                                                                        
           MOVE WS-DETAIL-LINE             TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD  WS-ONE                     TO   WS-LINE-COUNT.          
                                                                        
           INITIALIZE FF-ACCOUNT-NO,                                    
                      FF-IC-NO,                                         
                      WS-FACTOR.                                        
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      ******************************************************************        
                                                                        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-BLANK-LINE              TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           MOVE WS-FOOTER1                 TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
           ADD 1                           TO   WS-PAGE-COUNT.          
           MOVE    WS-PAGE-COUNT           TO   WS-REP-PAGE.            
           MOVE    WS-PGRMNAME             TO   P-RPT-TITLE-PGNM.       
           MOVE    WS-COMP-NAME            TO   P-RPT-COMP-NAME.        
                                                                        
      *    PRINTS COMPANY NAME                                                  
                                                                        
           MOVE    WS-RPT-TITLE-1          TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
      *    PRINTS REPORT TITLE                                                  
                                                                        
           MOVE    WS-RPT-TITLE-2          TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-TITLE-3          TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
      *    PRINTS REPORT HEADER                                                 
                                                                        
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-LINE                 TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-HEADER           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-LINE                 TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      ******************************************************************        
                                                                        
       8900-WRITE-REPORT.                                               
                                                                        
           MOVE '8900'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              WRITE PRT33-RECORD AFTER ADVANCING PAGE                   
              MOVE  WS-ZERO                TO WS-LINE-COUNT             
           ELSE                                                         
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP426  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
