       IDENTIFICATION DIVISION.                                         
ACT156 PROGRAM-ID. PCSRP425.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. OCT-2002.                                          
      *****************************************************************         
      *               SOUTH CAROLINA ELECTRIC & GAS                   *         
      **                                                             **         
      *****************************************************************         
      ********        CUSTOMER INFORMATION  SYSTEM            *********         
      *****************************************************************         
      **                   P R O G R A M S U M M A R Y               **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **    GENERATE A MONTHLY REPORT TO PRINT ALL THE SCE&G         **         
      **    INDUSTRIAL GAS CUSTOMER BILLING INFORMATION WHICH        **         
      **    INCLUDES CUSTOMER NAME, IC, RATE, CATEGORY & METER       **         
      **    DETAILS. THIS IS A MONTHLY REPORT.                       **         
      **                                                             **         
      **    INPUT FOR THIS PROGRAM IS FROM THE FOLLOWING TABLES      **         
      **      1. CSS_JOB_PARM G6                                                
      **      2. CSS_ACCOUNT AT                                      **         
      **      3. CSS_UTIL_ENVRNMT  UT                                **         
      **      4. CSS_MTRD_ENVRNMT  MN                                **         
      **      5. CSS_BILL_CONTRACT BK                                **         
      **      6. CSS_PRTY_SVC_CAT  Z4                                **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS         REASON                      **         
      **    ======      =========        =======                     **         
      **   10-31-2002   ANAND            NEW REPORT PROGRAM          **         
      **                                                             **         
T33270**   03-27-2006   PAM GILLIAM      CHANGE THE PROGRAM TO ALSO  **         
T33270**   CML 33270                     PRINT BLOCK VOLUME ICS WITH **         
T33270**                                 NO METER.                   **         
C34624**   10-12-2006    ANAND           ADDED NEW COLUMN 'ZONE CITY'**         
      **                                                             **         
35518 **   21 MAR 2007  RF10596          CORRECT REPORT YEAR         **         
A00077**   06 JAN 2009  NC94746          ZONE CITY POPULATED USING   **         
A00077**                                 INDUST_BTU_ID OF MN IN PLACE**         
A00077**                                 OF GAS_DLVRY_ZONE_CD OF     **         
ACT009**   06 FEB 2012  BD09555 A03967   ADD REVENUE CLASS TO REPORT **         
ACT009**                                 DON'T SUPPRESS PRINTING OF  **         
ACT009**                                 REPETITIVE VALUES, LIKE     **         
ACT009**                                 ACCOUNT NUMBER AND NAME.    **         
ACT156**   09 MAY 2016  MR7E794 A05460   CORRECTED THE PROGRAM-ID AND**         
ACT156**                                 REMOVED UNUSED COPYBOOKS.   **         
      *****************************************************************         
      *     REMARKS.                                                            
      *             ---- BASIC SEQUENCE STRUCTURE ------                        
      *        0000 - 0999     MAIN CONTROL PATH                                
      *        1000 - 1999     INITIALIZATION                                   
      *        1000 - 1999     INPUT PROCESSING CONTROL PATH                    
      *        2000 - 2999     OUTPUT PROCESSING CONTROL PATH                   
      *        3000 - 4999     BATCH PROCESSING MODULES - NOT USED              
      *        5000 - 5999     COMMON PROGRAM MODULES                           
      *        6000 - 6999     COMMON SYSTEM MODULES                            
      *        7000 - 7999     INPUT MODULES                                    
      *        8000 - 8999     OUTPUT MODULES                                   
      *        9000 - 9799     TERMINATION MODULES                              
      *        9900 - 9999     ABEND/ABORT MODULES                              
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP425'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP425 STARTS HERE'.                  
                                                                        
       01 WS-MISC.                                                      
          05  WS-PREV-ACCOUNT-NO         PIC S9(13)V USAGE COMP-3       
                                                   VALUE 0.             
          05  WS-COMP-NAME               PIC X(26) VALUE SPACES.        
          05  WS-MAX-LINES               PIC 9(02) VALUE 56.            
T33270    05  WS-CAR-CTL                 PIC 9(01) VALUE ZERO.          
          05  WS-LINE-COUNT              PIC 9(02) VALUE 57.            
          05  WS-DEFAULT-COMP-NO         PIC X(02) VALUE '01'.          
          05  WS-FULL-NAME               PIC X(50) VALUE SPACES.        
          05  WS-PREV-PRTY-SVC-CAT-CD    PIC X(02) VALUE SPACES.        
          05  WS-PAGE-COUNT              PIC 9(03) VALUE ZERO.          
          05  WS-PGRMNAME                PIC X(08) VALUE 'PCSRP425'.    
          05  WS-PGMNAME                 PIC X(08) VALUE 'PCSRP425'.    
          05  WS-MONTH                   PIC X(09) VALUE SPACES.        
           05  WS-BEG-BILL-DT           PIC X(10).                      
           05  WS-END-BILL-DT           PIC X(10).                      
          05  WS-ERR-MSG                 PIC X(40) VALUE SPACES.        
          05  WS-DISP-RC                 PIC -ZZZZZZZZ9.9.              
          05  WS-PARM-REVENUE-MONTH.                                    
              10 WS-PARM-REV-YEAR        PIC 9(04).                     
              10 WS-PARM-REV-MONTH       PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                     PIC 9(02).                     
           05  WS-MM                     PIC 9(02).                     
           05  WS-SS                     PIC 9(02).                     
           05  WS-TT                     PIC 9(02).                     
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-MM                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-SS                  PIC X(02).                     
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                     PIC 9(02).                     
           05  WS-CM                     PIC 9(02).                     
           05  WS-CD                     PIC 9(02).                     
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-DD                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-RD-YY                  PIC X(02).                     
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-YES                     PIC X(01) VALUE 'Y'.           
           05 WS-N                       PIC X(01) VALUE 'N'.           
           05 WS-Y                       PIC X(01) VALUE 'Y'.           
           05 WS-ONE                     PIC 9(02) VALUE 01.            
           05 WS-TWO                     PIC 9(02) VALUE 02.            
           05 WS-ONE1                    PIC 9(03) VALUE 000.           
           05 WS-ZERO                    PIC 9(02) VALUE 0.             
           05 WS-01                      PIC X(02) VALUE '01'.          
           05 WS-26                      PIC X(02) VALUE '26'.          
           05 WS-50                      PIC 9(02) VALUE 50.            
           05 WS-52                      PIC 9(02) VALUE 52.            
                                                                        
       01 WS-SWITCHES.                                                  
           05 WS-FILE-STATUS             PIC X(02).                     
              88 SUCCESSFUL                        VALUE '00'.          
                                                                        
           05  WS-RECORD-FOUND           PIC X(01) VALUE 'N'.           
               88 RECORD-NOT-FOUND                 VALUE 'N'.           
                                                                        
           05  WS-BLANK-LINE-FL          PIC X(01) VALUE 'N'.           
               88 BLANK-LINE-FL                    VALUE 'Y'.           
                                                                        
           05  WS-FIRST-TIME-FL          PIC X(01) VALUE 'Y'.           
               88 FIRST-TIME                       VALUE 'Y'.           
               88 NOT-FIRST-TIME                   VALUE 'N'.           
                                                                        
       01 WS-HEADING-LINES.                                             
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
           05  WS-RPT-TITLE-1.                                          
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-RPT-TITLE-PGNM      PIC X(08) VALUE 'PCSRP425'.    
               10  FILLER                PIC X(09) VALUE '-PCSR4251'.   
               10  FILLER                PIC X(35) VALUE SPACES.        
               10  P-RPT-COMP-NAME       PIC X(26).                     
               10  FILLER                PIC X(35) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN-DATE: '.  
               10  P-RPT-RUN-DATE        PIC X(08).                     
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER         **          
      ****************************************************************          
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                PIC X(50) VALUE SPACES.        
               10  P-RPT-HEAD            PIC X(28) VALUE                
                   'CUSTOMER BILLING INFORMATION'.                      
               10  FILLER                PIC X(36) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN-TIME: '.  
               10  P-RPT-RUN-TIME        PIC X(08).                     
                                                                        
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                PIC X(56) VALUE SPACES.        
               10  FILLER                PIC X(04) VALUE 'FOR '.        
               10  P-RPT-MONTH           PIC X(09) VALUE SPACES.        
               10  FILLER                PIC X     VALUE SPACES.        
35518          10  P-RPT-YY              PIC X(4)  VALUE SPACES.        
               10  FILLER                PIC X(44) VALUE SPACES.        
               10  FILLER                PIC X(08) VALUE 'PAGE: '.      
               10  P-RPT-PAGE-NO         PIC ZZ,ZZ9.                    
                                                                        
           05  WS-RPT-HEADER-3.                                         
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  FILLER                PIC X(11) VALUE                
                   'CATEGORY : '.                                       
               10  P-RPT-CAT-CD          PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(03) VALUE ' - '.         
               10  P-RPT-CAT-DESC        PIC X(25) VALUE SPACES.        
               10  FILLER                PIC X(90) VALUE SPACES.        
      *                                                                         
           05 WS-RPT-HEADER-4.                                          
              10 FILLER                  PIC X(01) VALUE SPACES.        
              10 FILLER                  PIC X(10) VALUE                
                                                   'ACCOUNT NO'.        
C34624        10 FILLER                  PIC X(09) VALUE SPACES.        
              10 FILLER                  PIC X(13) VALUE                
                                                   'CUSTOMER NAME'.     
C34624        10 FILLER                  PIC X(30) VALUE SPACES.        
              10 FILLER                  PIC X(05) VALUE 'IC NO'.       
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
              10 FILLER                  PIC X(12) VALUE                
                                                   'RATE   CLASS'.      
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
C34624        10 FILLER                  PIC X(09) VALUE 'ZONE CITY'.   
C34624        10 FILLER                  PIC X(09) VALUE SPACES.        
              10 FILLER                  PIC X(08) VALUE 'METER NO'.    
              10 FILLER                  PIC X(12) VALUE SPACES.        
              10 FILLER                  PIC X(03) VALUE 'MDQ'.         
C34624        10 FILLER                  PIC X(05) VALUE SPACES.        
      *                                                                         
           05 WS-RPT-HEADER-5.                                          
              10 FILLER                  PIC X(133)                     
                                                   VALUE ALL '-'.       
                                                                        
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR BLANK LINE             **          
      ****************************************************************          
           05 WS-BLANK-LINE.                                            
              10 FILLER                  PIC X(133)                     
                                                   VALUE SPACES.        
                                                                        
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR DETAIL LINE            **          
      ****************************************************************          
        01 WS-DETAIL-LINE.                                              
           05 WS-DETAIL-LINE-1.                                         
              10 FILLER                  PIC X(01) VALUE SPACES.        
              10 P-RPT-ACCT-NO           PIC XBXXXXBXXXXBXXXX.          
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
              10 P-RPT-CUST-NAME         PIC X(40).                     
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
              10 P-RPT-IC-NO             PIC ZZ99.                      
C34624        10 FILLER                  PIC X(04) VALUE SPACES.        
              10 P-RPT-RATE-PLAN-NO      PIC X(03).                     
C34624        10 FILLER                  PIC X(06) VALUE SPACES.        
C34624        10 P-RPT-REVENUE-CLASS     PIC X(03).                     
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
C34624        10 P-RPT-ZONE-CITY         PIC X(15).                     
C34624        10 FILLER                  PIC X(03) VALUE SPACES.        
              10 P-RPT-METER-NO          PIC X(09).                     
              10 FILLER                  PIC X(05) VALUE SPACES.        
              10 P-RPT-MDQ               PIC -,---,--9.99.              
C34624        10 FILLER                  PIC X(02) VALUE SPACES.        
                                                                        
       01 WS-NO-DATA-LINE.                                              
          05 FILLER                      PIC X(48) VALUE SPACES.        
          05 FILLER                      PIC X(31) VALUE                
               '**** NO DATA FOR THIS RUN  ****'.                       
          05 FILLER                      PIC X(53) VALUE SPACES.        
                                                                        
       01 WS-FOOTER-LINE.                                               
          05 FILLER                      PIC X(35) VALUE SPACES.        
          05 FILLER                      PIC X(25) VALUE                
              '* * * END OF REPORT * * *'.                              
          05 FILLER                      PIC X(72) VALUE SPACES.        
                                                                        
      ****************************************************************          
      **                COMMON COPYBOOK FOR WS-VARIABLES            **          
      ****************************************************************          
       COPY CWS00039.                                                           
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00011.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_MRTRD_ENVRNMT                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILL_CONTRACT                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PRTY_SVC_CAT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSVCCAT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_VOL_GROUP                                                 *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
      *    EXEC SQL                                                             
      *         INCLUDE TBVOLGRP                                                
      *    END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_JOB_PARM                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
A00077*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A00077*   CSS_BTU_INDUST                                              *         
A00077*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A00077                                                                  
A00077     EXEC SQL                                                             
A00077          INCLUDE TBBTUIND                                                
A00077     END-EXEC.                                                            
A00077                                                                  
      *****************************************************************         
      *   CURSOR FOR FETCHING CUSTOMER BILLING INFORMATION WHICH      *         
      *   INCLUDES CUSTOMER, IC, RATE, CATEGOTY, & MDQ DETAILS        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE CUST-BILL CURSOR FOR                              
                SELECT AT.ACCOUNT_NO                                    
T33270                ,UT.CODE_UTIL_TYPE                                
                      ,UT.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
ACT009                ,UT.CODE_REVENUE_CLASS                            
T34624                ,UT.PREMISE_NO                                    
                      ,BK.CONTRACT_DEMAND                               
                      ,Z4.PRTY_SVC_CAT_CD                               
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)               
                      ,CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)               
                      ,CSS_PRTY_SVC_CAT  Z4 WITH(READUNCOMMITTED)               
                 WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND AT.CODE_ACCT_STAT   NOT IN ('B', 'S')            
                   AND BK.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND UT.CODE_UTIL_TYPE    = 'G'                       
                   AND UT.IC_NO             = BK.IC_NO                  
                   AND BK.CNTRCT_START_DT =                             
                       (SELECT MAX(BK1.CNTRCT_START_DT)                 
                          FROM CSS_BILL_CONTRACT BK1
                           WITH(READUNCOMMITTED)                    
                         WHERE BK1.ACCOUNT_NO     = BK.ACCOUNT_NO       
                           AND BK1.IC_NO          = BK.IC_NO            
                           AND BK1.CODE_UTIL_TYPE = 'G')                
                   AND UT.CODE_CURTAIL_PRTY = Z4.CODE_CURTAIL_PRTY      
                   AND UT.COMPANY_NO        = Z4.COMPANY_NO             
                   AND UT.COMPANY_NO        = :WS-DEFAULT-COMP-NO       
                ORDER BY UT.CODE_CURTAIL_PRTY, AT.ACCOUNT_NO, UT.IC_NO  
A00077           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST-BILL CURSOR FOR                                      
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,UT.CODE_UTIL_TYPE                                        
MFA-TR*               ,UT.IC_NO                                                 
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,UT.CODE_REVENUE_CLASS                                    
MFA-TR*               ,UT.PREMISE_NO                                            
MFA-TR*               ,BK.CONTRACT_DEMAND                                       
MFA-TR*               ,Z4.PRTY_SVC_CAT_CD                                       
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_UTIL_ENVRNMT  UT                                     
MFA-TR*               ,CSS_BILL_CONTRACT BK                                     
MFA-TR*               ,CSS_PRTY_SVC_CAT  Z4                                     
MFA-TR*          WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND AT.CODE_ACCT_STAT   NOT IN ('B', 'S')                    
MFA-TR*            AND BK.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND UT.CODE_UTIL_TYPE    = 'G'                               
MFA-TR*            AND UT.IC_NO             = BK.IC_NO                          
MFA-TR*            AND BK.CNTRCT_START_DT =                                     
MFA-TR*                (SELECT MAX(BK1.CNTRCT_START_DT)                         
MFA-TR*                   FROM CSS_BILL_CONTRACT BK1                            
MFA-TR*                  WHERE BK1.ACCOUNT_NO     = BK.ACCOUNT_NO               
MFA-TR*                    AND BK1.IC_NO          = BK.IC_NO                    
MFA-TR*                    AND BK1.CODE_UTIL_TYPE = 'G')                        
MFA-TR*            AND UT.CODE_CURTAIL_PRTY = Z4.CODE_CURTAIL_PRTY              
MFA-TR*            AND UT.COMPANY_NO        = Z4.COMPANY_NO                     
MFA-TR*            AND UT.COMPANY_NO        = :WS-DEFAULT-COMP-NO               
MFA-TR*         ORDER BY UT.CODE_CURTAIL_PRTY, AT.ACCOUNT_NO, UT.IC_NO          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
T33270*****************************************************************         
T33270*   CURSOR FOR FETCHING METERS BY IC AND ACCOUNT                *         
T33270*****************************************************************         
T33270                                                                  
T33270     EXEC SQL                                                     
T33270        DECLARE METER-NO CURSOR FOR                               
T33270          SELECT MN.METER_NO                                      
T33270            FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
T33270           WHERE MN.ACCOUNT_NO        = :AT-ACCOUNT-NO            
T33270             AND MN.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE        
T33270             AND MN.IC_NO             = :UT-IC-NO                 
T33270             AND MN.CODE_METER_STATUS = 'A'                       
A00077           FOR READ ONLY                                  
T33270     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER-NO CURSOR FOR                                       
MFA-TR*         SELECT MN.METER_NO                                              
MFA-TR*           FROM CSS_MTRD_ENVRNMT MN                                      
MFA-TR*          WHERE MN.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND MN.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                
MFA-TR*            AND MN.IC_NO             = :UT-IC-NO                         
MFA-TR*            AND MN.CODE_METER_STATUS = 'A'                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
T33270                                                                  
       01  WS-END                          PIC X(40) VALUE              
             'WORKING STORAGE FOR PCSRP425 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                   TO  WS-ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 0100-INITIALIZATION   THRU 0100-EXIT.                
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA                               
                                         THRU 1000-EXIT.                
                                                                        
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      **                                                       **               
      **   0100-INITIALIZATION.                                **               
      **       INITIALIZATION ROUTINE                          **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
      * GETS THE CURRENT TIME.                                                  
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME.             
                                                                        
      * GETS THE CURRENT DATE.                                                  
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                    TO WS-RD-YY                    
                                            P-RPT-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE.             
                                                                        
           MOVE WS-DEFAULT-COMP-NO       TO C7-COMPANY-NO               
                                            UT-COMPANY-NO               
                                            Z4-COMPANY-NO               
A00077                                      FD-COMPANY-NO.              
                                                                        
      * GETS THE COMPANY NAME                                                   
           PERFORM 7400-GET-COMPANY-DESC THRU 7400-EXIT.                
           IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
              MOVE C7-COMPANY-NAME       TO WS-COMP-NAME                
           END-IF.                                                      
                                                                        
      *                                                                         
           PERFORM 0110-PROCESS-PARM-DATE THRU 0110-EXIT.               
      *                                                                         
      * GETS THE MONTH NAME                                                     
      *                                                                         
           PERFORM 0200-ASSIGN-MONTH-PARA THRU 0200-EXIT.               
      *                                                                         
           MOVE WS-MONTH         TO P-RPT-MONTH.                        
35518      MOVE WS-PARM-REV-YEAR TO P-RPT-YY.                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0110-PROCESS-PARM-DATE                                   **         
      **      PROCESSES THE REVENUE MONTH PARM.                      **         
      **                                                             **         
      *****************************************************************         
       0110-PROCESS-PARM-DATE.                                          
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
      *                                                                         
           IF END-OF-SYSIPT                                             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-YR    TO WS-PARM-REV-YEAR.                      
           MOVE WS-PARM-MONTH TO WS-PARM-REV-MONTH.                     
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   0200-ASSIGN-MONTH-PARA .                                   **        
      **        ASSIGN MONTH NAME ACCORDING TO THE NUMERIC VALUE.     **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       0200-ASSIGN-MONTH-PARA.                                          
                                                                        
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EVALUATE WS-PARM-REV-MONTH                                   
               WHEN 01                                                  
                   MOVE 'JANUARY'        TO WS-MONTH                    
               WHEN 02                                                  
                   MOVE 'FEBRUARY'       TO WS-MONTH                    
               WHEN 03                                                  
                   MOVE 'MARCH'          TO WS-MONTH                    
               WHEN 04                                                  
                   MOVE 'APRIL'          TO WS-MONTH                    
               WHEN 05                                                  
                   MOVE 'MAY'            TO WS-MONTH                    
               WHEN 06                                                  
                   MOVE 'JUNE'           TO WS-MONTH                    
               WHEN 07                                                  
                   MOVE 'JULY'           TO WS-MONTH                    
               WHEN 08                                                  
                   MOVE 'AUGUST'         TO WS-MONTH                    
               WHEN 09                                                  
                   MOVE 'SEPTEMBER'      TO WS-MONTH                    
               WHEN 10                                                  
                   MOVE 'OCTOBER'        TO WS-MONTH                    
               WHEN 11                                                  
                   MOVE 'NOVEMBER'       TO WS-MONTH                    
               WHEN 12                                                  
                   MOVE 'DECEMBER'       TO WS-MONTH                    
           END-EVALUATE.                                                
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **      1000-MAIN-PROCESS-PARA                                  **        
      **           MAIN PROCESS BEGINS HERE                           **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
            MOVE '1000'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            PERFORM 7000-OPEN-CUST-BILL  THRU 7000-EXIT.                
                                                                        
            PERFORM 7100-FETCH-CUST-BILL THRU 7100-EXIT.                
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                                                        
              PERFORM 2000-PROCESS-DETAIL-PARA                          
                                         THRU 2000-EXIT                 
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                                                                        
            END-IF.                                                     
                                                                        
            IF RECORD-NOT-FOUND                                         
               PERFORM 8100-PRINT-RPT-NO-DATA                           
                                         THRU 8100-EXIT                 
            ELSE                                                        
               PERFORM 8400-PRINT-RPT-FOOTER                            
                                         THRU 8400-EXIT                 
            END-IF.                                                     
                                                                        
            PERFORM 7200-CLOSE-CUST-BILL THRU 7200-EXIT.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   2000-PROCESS-DETAIL-PARA                                   **        
      **        PROCESS THE DETAIL RECORD WHICH IS BEING FETCHED      **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DETAIL-PARA.                                        
                                                                        
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-Y                     TO WS-RECORD-FOUND.            
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT THRU 8000-EXIT.                
           PERFORM 7100-FETCH-CUST-BILL  THRU 7100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    6010-REDUCE-EMBEDDED-SPACES                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   6200-GET-PARAMETER-DATE                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                 INCLUDE CPD00114                                               
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     7000-OPEN-CUST-BILL.                                       *        
      *     OPENS THE CUST-BILL CURSOR                                 *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-CUST-BILL.                                             
      *                                                                         
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                OPEN CUST-BILL                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7000-OPEN-CUST-BILL'                                
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **    7100-FETCH-CUST-BILL.                                     **        
      **         FETCHES THE CUSTOMER BILLING INFORMATION             **        
      ******************************************************************        
      *                                                                         
       7100-FETCH-CUST-BILL.                                            
      *                                                                         
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                FETCH CUST-BILL INTO                                    
                    :AT-ACCOUNT-NO                                      
T33270             ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-RATE-PLAN-NO                                    
ACT009             ,:UT-CODE-REVENUE-CLASS                              
C34624             ,:UT-PREMISE-NO                                      
                   ,:BK-CONTRACT-DEMAND                                 
                   ,:Z4-PRTY-SVC-CAT-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE 'ERROR IN FETCHING BATCH ACTIVE CURSOR'              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7200-CLOSE-CUST-BILL                                   **           
      **         CLOSES CUST-BILL CURSOR                           **           
      ***************************************************************           
      *                                                                         
       7200-CLOSE-CUST-BILL.                                            
      *                                                                         
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                CLOSE CUST-BILL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7200-CLOSE-CUST-BILL'                               
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   7400-GET-COMPANY-DESC                                      **        
      **        GETS THE COMPANY NAME FOR THE GIVEN COMPANY NO        **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       7400-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
A00077                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '** SELECT ERROR IN 7400-GET-COMPANY-DESC **'        
                                         TO WS-ERR-MSG                  
              MOVE SQLCODE               TO WS-DISP-RC                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06617700
      ******************************************************************        
      **                                                              **        
      **   7500-GET-PRTY-SVC-CAT-DESC.                                **        
      **        GETS THE PRIORITY SERVICE CATEGORY DESCRIPTION        **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       7500-GET-PRTY-SVC-CAT-DESC.                                      
      *                                                                         
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT PRTY_SVC_CAT_DESC                                 
                 INTO :Z4-PRTY-SVC-CAT-DESC                             
                 FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO      = :Z4-COMPANY-NO                  
                  AND PRTY_SVC_CAT_CD = :Z4-PRTY-SVC-CAT-CD             
A00077                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRTY_SVC_CAT_DESC                                         
MFA-TR*          INTO :Z4-PRTY-SVC-CAT-DESC                                     
MFA-TR*          FROM CSS_PRTY_SVC_CAT                                          
MFA-TR*         WHERE COMPANY_NO      = :Z4-COMPANY-NO                          
MFA-TR*           AND PRTY_SVC_CAT_CD = :Z4-PRTY-SVC-CAT-CD                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '** SELECT ERROR IN 7500-GET-PRTY-SVC-CAT **'        
                                         TO WS-ERR-MSG                  
              MOVE SQLCODE               TO WS-DISP-RC                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06617700
      ******************************************************************        
      **                                                              **        
      **   7650-GET-CUST-NAME.                                        **        
      **        GETS THE CUSTOMER NAME                                **        
      ******************************************************************        
      *                                                                         
       7650-GET-CUST-NAME.                                              
      *                                                                         
           MOVE '7650'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT FULL_NAME                                          
                INTO :WS-FULL-NAME                                      
               FROM  CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
                    ,CSS_NAME     DQ WITH(READUNCOMMITTED)                      
              WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                     
                AND CU.CUSTOMER_NO = AT.CUSTOMER_NO                     
                AND DQ.NAME_ID     = CU.NAME_ID                         
A00077                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FULL_NAME                                                  
MFA-TR*         INTO :WS-FULL-NAME                                              
MFA-TR*        FROM  CSS_ACCOUNT  AT                                            
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*             ,CSS_NAME     DQ                                            
MFA-TR*       WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                             
MFA-TR*         AND CU.CUSTOMER_NO = AT.CUSTOMER_NO                             
MFA-TR*         AND DQ.NAME_ID     = CU.NAME_ID                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT ERROR IN 7650-GET-CUST-NAME'                 
                                         TO WS-ERR-MSG                  
              MOVE SQLCODE               TO WS-DISP-RC                  
              PERFORM 9100-DISPLAY-ERROR                                
                                         THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T33270******************************************************************        
T33270*                                                                *        
T33270*     7700-OPEN-METER-NO.                                        *        
T33270*     OPENS THE METER-NO  CURSOR                                 *        
T33270******************************************************************        
T33270*                                                                         
T33270 7700-OPEN-METER-NO.                                              
T33270*                                                                         
T33270     MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
T33270                                                                  
T33270     EXEC SQL                                                     
T33270          OPEN METER-NO                                           
T33270     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33270                                                                  
T33270     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T33270                                                                  
T33270     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T33270        NEXT SENTENCE                                             
T33270     ELSE                                                         
T33270        MOVE SQLCODE               TO WS-DISP-RC                  
T33270        MOVE '7700-OPEN-METER-NO'                                 
T33270                                   TO WS-ERR-MSG                  
T33270        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
T33270     END-IF.                                                      
T33270                                                                  
T33270 7700-EXIT.                                                       
T33270     EXIT.                                                        
T33270*                                                                         
T33270******************************************************************        
T33270**                                                              **        
T33270**    7800-FETCH-METER-NO.                                      **        
T33270**         FETCHES THE METER NUMBER                             **        
T33270******************************************************************        
T33270*                                                                         
T33270 7800-FETCH-METER-NO.                                             
T33270*                                                                         
T33270     MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
T33270                                                                  
T33270     EXEC SQL                                                     
T33270          FETCH METER-NO INTO                                     
T33270              :MN-METER-NO                                        
T33270     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33270                                                                  
T33270     MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
T33270                                                                  
T33270     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T33270        NEXT SENTENCE                                             
T33270     ELSE                                                         
T33270        MOVE SQLCODE               TO WS-DISP-RC                  
T33270        MOVE 'ERROR IN FETCHING BATCH ACTIVE CURSOR'              
T33270                                   TO WS-ERR-MSG                  
T33270        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
T33270     END-IF.                                                      
T33270                                                                  
T33270 7800-EXIT.                                                       
T33270     EXIT.                                                        
T33270*                                                                         
T33270***************************************************************           
T33270**                                                           **           
T33270**    7900-CLOSE-METER-NO                                    **           
T33270**         CLOSES METER-NO CURSOR                            **           
T33270***************************************************************           
T33270*                                                                         
T33270 7900-CLOSE-METER-NO.                                             
T33270*                                                                         
T33270     MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH.        
T33270                                                                  
T33270     EXEC SQL                                                     
T33270          CLOSE METER-NO                                          
T33270     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33270                                                                  
T33270     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T33270                                                                  
T33270     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T33270        NEXT SENTENCE                                             
T33270     ELSE                                                         
T33270        MOVE SQLCODE               TO WS-DISP-RC                  
T33270        MOVE '7900-CLOSE-METER-NO'                                
T33270                                   TO WS-ERR-MSG                  
T33270        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
T33270     END-IF.                                                      
T33270                                                                  
T33270 7900-EXIT.                                                       
T33270     EXIT.                                                        
T33270*                                                                         
C34624**********************************************************************    
C34624*    7950-SELECT-ZONE-CITY.                                         **    
C34624* GETS CITY NAME FOR THE BTU ID(ZONE ID) ACCOCIATED WITH THE        **    
C34624* INSTALLED METER.                                                  **    
C34624**********************************************************************    
C34624 7950-SELECT-ZONE-CITY.                                           
C34624                                                                  
C34624     MOVE '7950'                   TO WS-ACTIVE-PARAGRAPH.        
C34624                                                                  
A00077     EXEC SQL                                                     
A00077          SELECT TOP(1) FD.INDUST_BTU_DESC                               
A00077            INTO :FD-INDUST-BTU-DESC                              
A00077            FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
A00077                ,CSS_BTU_INDUST   FD WITH(READUNCOMMITTED)                
A00077           WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID          
A00077             AND MN.ACCOUNT_NO        = :AT-ACCOUNT-NO            
A00077             AND MN.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE        
A00077             AND FD.COMPANY_NO        = :FD-COMPANY-NO            
A00077             AND MN.CODE_METER_STATUS <> 'K'                      
A00077                                       
A00077     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FD.INDUST_BTU_DESC                                       
MFA-TR*           INTO :FD-INDUST-BTU-DESC                                      
MFA-TR*           FROM CSS_MTRD_ENVRNMT MN                                      
MFA-TR*               ,CSS_BTU_INDUST   FD                                      
MFA-TR*          WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID                  
MFA-TR*            AND MN.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND MN.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                
MFA-TR*            AND FD.COMPANY_NO        = :FD-COMPANY-NO                    
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00077                                                                  
C34624     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
C34624                                                                  
C34624     IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL OR NOT-FOUND 
A00077        CONTINUE                                                  
C34624     ELSE                                                         
C34624        MOVE '** SELECT ERROR IN 7950-SELECT-ZONE-CITY **'        
C34624                                   TO WS-ERR-MSG                  
C34624        MOVE SQLCODE               TO WS-DISP-RC                  
C34624        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
C34624     END-IF.                                                      
C34624                                                                  
C34624 7950-EXIT.                                                       
C34624      EXIT.                                                       
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **  WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE      **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF Z4-PRTY-SVC-CAT-CD NOT EQUAL WS-PREV-PRTY-SVC-CAT-CD      
              MOVE 57                    TO WS-LINE-COUNT               
              MOVE Z4-PRTY-SVC-CAT-CD    TO WS-PREV-PRTY-SVC-CAT-CD     
           END-IF.                                                      
                                                                        
           PERFORM 7500-GET-PRTY-SVC-CAT-DESC                           
                                         THRU 7500-EXIT.                
           MOVE Z4-PRTY-SVC-CAT-DESC     TO P-RPT-CAT-DESC.             
           MOVE Z4-PRTY-SVC-CAT-CD       TO P-RPT-CAT-CD.               
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                         THRU 8500-EXIT                 
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS                               
                                         THRU 8300-EXIT.                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE " NO DATA FOR THIS RUN"              **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH.        
           PERFORM 8500-PRINT-RPT-HEADERS                               
                                         THRU 8500-EXIT.                
           MOVE WS-BLANK-LINE            TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           MOVE WS-NO-DATA-LINE          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-HEADERS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
33270**    MOVE UT-IC-NO                 TO P-RPT-IC-NO.                        
33270**    MOVE MN-METER-NO              TO P-RPT-METER-NO.                     
      *                                                                         
33270**    PERFORM 7650-GET-CUST-NAME    THRU 7650-EXIT.                        
      *                                                                         
33270**    IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL                  
33270**       MOVE WS-FULL-NAME          TO WS-EMB-INPUT                        
33270**       MOVE 50                    TO WS-EMB-LENG                         
33270**       MOVE SPACES                TO WS-CMP-TABLE                        
33270**       PERFORM 6010-REDUCE-EMBEDDED-SPACES                               
33270**                                  THRU 6010-EXIT                         
33270**       MOVE WS-CMP-TABLE          TO WS-FULL-NAME                        
33270**    ELSE                                                                 
33270**       MOVE SPACES                TO WS-FULL-NAME                        
33270**       CONTINUE                                                          
33270**    END-IF.                                                              
33270**                                                                         
33270**    MOVE WS-FULL-NAME             TO P-RPT-CUST-NAME.                    
                                                                        
33270      MOVE WS-ONE TO WS-CAR-CTL.                                   
33270      MOVE UT-RATE-PLAN-NO       TO P-RPT-RATE-PLAN-NO.            
ACT009     MOVE UT-CODE-REVENUE-CLASS TO P-RPT-REVENUE-CLASS.           
33270      MOVE BK-CONTRACT-DEMAND    TO P-RPT-MDQ.                     
33270      MOVE UT-IC-NO              TO P-RPT-IC-NO.                   
33270      MOVE MN-METER-NO           TO P-RPT-METER-NO                 
           IF AT-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
              MOVE WS-TWO             TO WS-CAR-CTL                     
33270         MOVE AT-ACCOUNT-NO         TO P-RPT-ACCT-NO               
33270                                    WS-PREV-ACCOUNT-NO             
33270         INSPECT P-RPT-ACCT-NO REPLACING ALL ' ' BY '-'            
33270         PERFORM 7650-GET-CUST-NAME    THRU 7650-EXIT              
33270         IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL       
33270          MOVE WS-FULL-NAME          TO WS-EMB-INPUT               
33270          MOVE 50                    TO WS-EMB-LENG                
33270          MOVE SPACES                TO WS-CMP-TABLE               
33270          PERFORM 6010-REDUCE-EMBEDDED-SPACES                      
33270                                    THRU 6010-EXIT                 
33270          MOVE WS-CMP-TABLE          TO WS-FULL-NAME               
33270         ELSE                                                      
33270          MOVE SPACES                TO WS-FULL-NAME               
33270         END-IF                                                    
              MOVE WS-FULL-NAME        TO P-RPT-CUST-NAME               
              MOVE MN-METER-NO           TO P-RPT-METER-NO              
           END-IF.                                                      
A00077     MOVE SPACES                   TO FD-INDUST-BTU-DESC.         
C34624     PERFORM 7950-SELECT-ZONE-CITY THRU 7950-EXIT.                
A00077     MOVE FD-INDUST-BTU-DESC       TO P-RPT-ZONE-CITY.            
                                                                        
33270      PERFORM 7700-OPEN-METER-NO THRU 7700-EXIT.                   
33270      PERFORM 7800-FETCH-METER-NO THRU 7800-EXIT.                  
33270      IF WS-ACTIVE-RETURN-CODE      EQUAL 0                        
33270         MOVE MN-METER-NO           TO P-RPT-METER-NO              
33270      ELSE                                                         
33270         MOVE 'NO METER' TO P-RPT-METER-NO                         
33270      END-IF.                                                      
33270      MOVE WS-DETAIL-LINE-1         TO PRT33-RECORD.               
33270      PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
33270      ADD  WS-CAR-CTL         TO WS-LINE-COUNT.                    
33270      MOVE 1 TO WS-CAR-CTL.                                        
           IF SQLCODE = 0                                               
33270       PERFORM UNTIL SQLCODE NOT EQUAL 0                           
33270        PERFORM 7800-FETCH-METER-NO THRU 7800-EXIT                 
33270         IF WS-ACTIVE-RETURN-CODE      EQUAL 0                     
33270          MOVE UT-IC-NO              TO P-RPT-IC-NO                
33270          MOVE UT-RATE-PLAN-NO       TO P-RPT-RATE-PLAN-NO         
ACT009         MOVE UT-CODE-REVENUE-CLASS TO P-RPT-REVENUE-CLASS        
33270          MOVE MN-METER-NO           TO P-RPT-METER-NO             
33270          MOVE BK-CONTRACT-DEMAND    TO P-RPT-MDQ                  
33270          MOVE WS-ONE                TO WS-CAR-CTL                 
33270          MOVE WS-DETAIL-LINE-1      TO PRT33-RECORD               
33270          PERFORM 8900-WRITE-REPORT THRU 8900-EXIT                 
33270          ADD  WS-CAR-CTL            TO WS-LINE-COUNT              
33270         END-IF                                                    
33270        IF WS-ACTIVE-RETURN-CODE EQUAL 100 OR ZERO                 
33270         CONTINUE                                                  
33270        ELSE                                                       
33270          DISPLAY '**   PROCESSING ERROR IN PCSRP425  **'          
33270          DISPLAY '**  ', WS-ERR-MSG                               
33270          DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH            
33270          DISPLAY '**   SQLCODE = ', WS-DISP-RC                    
33270          DISPLAY '**   ABENDING PROGRAM              **'          
33270          PERFORM 9900-ABEND            THRU 9900-EXIT             
33270        END-IF                                                     
33270      END-PERFORM                                                  
33270      END-IF.                                                      
33270      PERFORM 7900-CLOSE-METER-NO THRU 7900-EXIT.                  
33270*                                                                  
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER TO THE REPORT FILE                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-BLANK-LINE            TO PRT33-RECORD.               
           WRITE PRT33-RECORD.                                          
           MOVE WS-FOOTER-LINE           TO PRT33-RECORD.               
           WRITE PRT33-RECORD.                                          
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-TITLES.                                      **        
      **       WRITES THE HEADER TO THE REPORT FILE                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8500-PRINT-RPT-HEADERS.                                          
      *                                                                         
           MOVE '8500'                   TO   WS-ACTIVE-PARAGRAPH.      
33270      MOVE  WS-ZERO             TO WS-LINE-COUNT.                  
                                                                        
      *    PRINTS REPORT TITLE                                                  
33270**    IF WS-PAGE-COUNT GREATER THAN WS-ONE1                                
33270**       MOVE WS-BLANK-LINE         TO PRT33-RECORD                        
33270**       PERFORM 8900-WRITE-REPORT  THRU 8900-EXIT                         
33270**       ADD WS-ONE                 TO WS-LINE-COUNT                       
33270**    END-IF.                                                              
           ADD 1                         TO WS-PAGE-COUNT.              
           MOVE WS-PAGE-COUNT            TO P-RPT-PAGE-NO.              
           MOVE WS-COMP-NAME             TO P-RPT-COMP-NAME.            
           MOVE WS-RPT-TITLE-1           TO PRT33-RECORD.               
33270      WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
33270      MOVE WS-ONE TO WS-CAR-CTL.                                   
      *    PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                        
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
      *    PRINTS REPORT HEADERS                                                
                                                                        
           MOVE WS-RPT-HEADER-1          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-RPT-HEADER-2          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-BLANK-LINE            TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-RPT-HEADER-3          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-BLANK-LINE            TO PRT33-RECORD                
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT                 
           ADD WS-ONE                    TO WS-LINE-COUNT               
                                                                        
           MOVE WS-RPT-HEADER-5          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-RPT-HEADER-4          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE WS-RPT-HEADER-5          TO PRT33-RECORD.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8900-WRITE-REPORT.                                               
      *                                                                         
            MOVE '8900'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            IF WS-LINE-COUNT > WS-MAX-LINES                             
33270          PERFORM 8500-PRINT-RPT-HEADERS  THRU 8500-EXIT           
            ELSE                                                        
               WRITE PRT33-RECORD AFTER ADVANCING WS-CAR-CTL LINES      
            END-IF.                                                     
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY '**   PROCESSING ERROR IN PCSRP425  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND            THRU 9900-EXIT.                
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *  7600-START-FCSJC01                                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
