       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP421.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. OCT-2002.                                          
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      *****************************************************************         
      ********         CUSTOMER INFORMATION SYSTEM            *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS              REASON                 **         
      **   10-03-2002   COVANSYS              NEW REPORT PROGRAM     **         
      **                                      FOR REPORT GENERATION  **         
T27240**   04-16-2003   ANAND                 INCREASED THE LENGTH   **         
T27240**                                      OF WS-ANN-MIN-AMT-P2.  **         
      **                                                             **         
CIGPRJ**   04-25-2003   WLR   CHANGED TO SUBTRACT ONE FROM THE REV MM**         
      **                      FOR THE BEGINNING MONTH.                          
      **                                                             **         
35518 **  20 MAR 2007  RF10596 CORRECT ABEND CAUSING NOT FOUND AFTER **         
      **                       7350.  REMOVED CWS00166 AND CPD00166. **         
      **                       CORRECTED JANUARY RUN DATE ERROR.     **         
      **                       PROGRAM RUNS BEFORE CSRC305 REVENUE   **         
      **                       MONTH SWITCH, SO REMOVED YEAR-MONTH   **         
      **                       SUBTRACTION                           **         
T35434**  16 MAY 2007  MK92804 REPLACED MODEL_SQL WITH SET STATEMENT **         
T35434**                       AND ADDED  WITH UR TO AVOID -911.     **         
C31558**  03 SEP 2008  GD97441 1. REMOVE EXISTING ANNUAL REVIEW RPT. **         
C31558**                       2. ADD A NEW REPORT THAT DISPLAYS     **         
C31558**                          ANNUAL MIN & DTS FOR 12 MONTHS     **         
C31558**                          BASED ON ANNUAL REVIEW MONTH.      **         
C31558**                       3. UPDATE CURRENT REVENUE MONTH       **         
C31558**                          MINIMUM AND MAXIMUM CALCULATION.   **         
C31558**                       4. CODE_ACCT_STAT CHECK IS BEEN ADDED **         
C31558**                          TO THE MAIN CURSOR.                **         
C31558**                       5. CNTRCT_START_DT&END_DT CHECKS HAVE **         
C31558**                          BEEN UPDATED IN 7450-PARAGRAPH.    **         
C31558**                       6. UPDATE PGM FOR PERFORMANCE TUNING. **         
A00633**  15 JUL 2009  GD97441 1.INITIALIZATION ISSUE WITH CONTRACT  **         
A00633**                         VARIABLES HAS BEEN FIXED.           **         
A00633**                       2.INCLUDED TRANSPORTATION REVENUE ALSO**         
A00633**                         IN TOTAL REVENUE.                   **         
A00633**                       3.DON'T GET DTS WHEN REV_RPT_CD = 'T' **         
A00633**                         (TRANSPORTATION ROW).               **         
A00633**                       4.REMOVE CODE_ACCT_STAT CHECK.        **         
A02221**  05 JUL 2010  MC95456 1. MIN & MAX REVENUE MONTHS WILL BE   **         
A02221**                          READ FROM JOB PARM                 **         
A02221**                       2. PROGRAM WILL CONTINE BY PROCESSING **         
A02221**                          MAX AND  MIN REVENUE MONTHS        **         
A02221**                       3. TRANSPORTATION REVENUE CAN BE ADDED**         
A02221**                          BASED ON JOB PARM                  **         
A02221**                       4. NON-CALC AMOUNT WILL BE DISPLAYED  **         
A02221**                          AS ADJUSTED REVENUE IN REPORT      **         
A02221**                       5. AVERAGE REVENUE PER CUSTOMER WOULD **         
A02221**                          BE REVENUE / DTS                   **         
A02221**                       6. ADJUSTED DTS WOULD BE REPORTED     **         
A02221**  24 DEC 2010  MC95456 1. ANNUAL MINIMUM REVENUE REPORT TO   **         
A02221**                          BE GENERATED FOR NEXT REVENUE MONTH**         
ACT094**  21 APR 2011  GD97441 VOL_TYPE_CD - NON TRANSP VOLUMES      **         
      *****************************************************************         
            REMARKS.                                                    
      *****************************************************************         
      *****************************************************************         
      *        REPORT GENERATOR FOR PCSRP421 REPORTS                  *         
      *        THIS IS A NEW PROGRAM WRITTEN FOR GENERATING LIST OF   *         
      *        CUSTOMERS WITH HIGHEST REVENUE FOR THE PAST 12 MONTHS  *         
      *                                                               *         
      *        INPUT FOR THIS PROGRAM IS FROM THE FOLLOWING TABLES    *         
      *        1. CSS_ACCOUNT                                         *         
      *        2. CSS_UTIL_ENVRNMT                                    *         
      *        3. CSS_BILLING_DET                                     *         
      *        4. CSS_VOL_DAILY                                       *         
      *                                                               *         
      *        THIS IS A MONTHLY REPORT                               *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * COPY BOOKS FOR WORK FILE AND THE OUTPUT FILE USED FOR SORT              
       COPY CSSRP421.                                                   00630000
      * COPY BOOK FOR REPORT FILE                                               
       COPY CSSPT33.                                                            
A02221     SELECT FCSR421A-FILE                                         
A02221        ASSIGN UT-S-FCSR421A                                      
A02221        FILE STATUS IS WS-FRP421A-STATUS.                         
A02221     SELECT FCSR421B-FILE                                         
A02221        ASSIGN UT-S-FCSR421B                                      
A02221        FILE STATUS IS WS-FRP421B-STATUS.                         
A02221     SELECT FCSR421C-FILE                                         
A02221        ASSIGN UT-S-FCSR421C                                      
A02221        FILE STATUS IS WS-FRP421C-STATUS.                         
A02221     SELECT FCSR421D-FILE                                         
A02221        ASSIGN UT-S-FCSR421D                                      
A02221        FILE STATUS IS WS-FRP421D-STATUS.                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      * COPY BOOKS FOR WORK FILE AND THE OUTPUT FILE USED FOR SORT              
       COPY CFDRP421.                                                   00690000
       COPY FIORP421.                                                   00700000
      *                                                                         
      * COPY BOOK FOR REPORT FILE                                               
       COPY CFDPT33.                                                            
A02221 FD  FCSR421A-FILE                                                
A02221     BLOCK CONTAINS 0 RECORDS                                     
A02221     RECORDING MODE IS F                                          
A02221     LABEL RECORDS ARE STANDARD.                                  
A02221 01 FCSR421A.                                                     
A02221    05 WS-FCSR421A-REC        PIC  X(200).                        
      *                                                                         
A02221 FD  FCSR421B-FILE                                                
A02221     BLOCK CONTAINS 0 RECORDS                                     
A02221     RECORDING MODE IS F                                          
A02221     LABEL RECORDS ARE STANDARD.                                  
A02221 01 FCSR421B.                                                     
A02221    05 WS-FCSR421B-REC        PIC  X(200).                        
      *                                                                         
A02221 FD  FCSR421C-FILE                                                
A02221     BLOCK CONTAINS 0 RECORDS                                     
A02221     RECORDING MODE IS F                                          
A02221     LABEL RECORDS ARE STANDARD.                                  
A02221 01 FCSR421C.                                                     
A02221    05 WS-FCSR421C-REC        PIC  X(200).                        
      *                                                                         
A02221 FD  FCSR421D-FILE                                                
A02221     BLOCK CONTAINS 0 RECORDS                                     
A02221     RECORDING MODE IS F                                          
A02221     LABEL RECORDS ARE STANDARD.                                  
A02221 01 FCSR421D.                                                     
A02221    05 WS-FCSR421D-REC        PIC  X(200).                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP421'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP421 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-ONE                    PIC 9(02)  VALUE 01.           
C31558     05  WS-TWELVE                 PIC 9(02)  VALUE 12.           
           05  WS-ZERO                   PIC 9(02)  VALUE 00.           
           05  WS-MAX                    PIC 9(02)  VALUE 60.           
           05  WS-SUMM-REC-CNTR          PIC 9(03)  VALUE ZERO.         
           05  WS-RPT-CNTR               PIC 9(05)  VALUE 1.            
           05  WS-REPORT-TYPE            PIC 9(01)  VALUE 0.            
           05  WS-PAGE-COUNT             PIC 9(03)  VALUE ZERO.         
           05  WS-ERR-MSG                PIC X(50)  VALUE SPACES.       
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  MULTIPLE-ROWS             PIC S9(9)  VALUE -811 COMP.    
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSRP421'.   
           05  WS-COMP-NAME              PIC X(26)  VALUE  SPACES.      
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-FULL-NAME              PIC X(50)  VALUE SPACES.       
           05  WS-CUST-NAME              PIC X(35)  VALUE SPACES.       
           05  WS-PREV-CUST-NAME         PIC X(35)  VALUE SPACES.       
           05  WS-ANN-REVIEW-MONTH       PIC X(02)  VALUE SPACES.       
           05  WS-MONTH                  PIC X(09)  VALUE SPACES.       
           05  WS-DTS                    PIC S9(9)V9(1) USAGE COMP-3    
                                                    VALUE ZERO.         
           05  WS-BILL-UNITS             PIC S9(9)V USAGE COMP-3        
                                                    VALUE ZERO.         
C31558     05  WS-SUM-BILL-UNITS-R2      PIC S9(11)V9(1) USAGE COMP-3   
C31558                                              VALUE ZERO.         
C31558     05  WS-ADJ-BILL-UNITS-R2      PIC S9(11)V9(1) USAGE COMP-3   
C31558                                              VALUE ZERO.         
           05  WS-AMT-BILL-ITEM          PIC S9(9)V9(2) USAGE COMP-3    
                                                    VALUE ZERO.         
A02221     05  WS-ADJ-REVENUE            PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221     05  WS-AVG-REVENUE            PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221     05  WS-ADJ-DTS                PIC S9(9)V9(1) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221     05  WS-ADJ-MCF                PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
           05  WS-BILL-ITEM-TOT          PIC S9(11)V USAGE COMP-3       
                                                    VALUE ZERO.         
           05  WS-REV-AMT                PIC S9(9)V9(2) USAGE COMP-3    
                                                    VALUE ZERO.         
           05  WS-POS                    PIC 9(05)  VALUE ZERO.         
           05  WS-DTS-NULL-IND           PIC S9(04) COMP                
                                                    VALUE 0.            
           05  WS-ANN-MIN-NULL-IND       PIC S9(04) COMP                
                                                    VALUE 0.            
           05  WS-REVENUE-MM             PIC 9(02)  VALUE ZERO.         
A02221     05  WS-PREVIOUS-ACCT-NO       PIC S9(13)V USAGE COMP-3       
A02221                                              VALUE ZERO.         
           05  WS-PREV-ACCOUNT-NO        PIC 9(13)  VALUE ZERO.         
           05  WS-DEFAULT-COMP-NO        PIC X(02)  VALUE '01'.         
           05  WS-CUR-REV-MON.                                          
               10  WS-REV-CCYY           PIC 9(04).                     
               10  WS-REV-MM             PIC 9(02).                     
           05  WS-CUR-REV-MON-CR      REDEFINES WS-CUR-REV-MON          
                                         PIC 9(06).                     
A02221     05  WS-COMPARE-MONTH.                                        
A02221         10  WS-COMPARE-CCYY       PIC 9(04).                     
A02221         10  WS-COMPARE-MM         PIC 9(02).                     
A02221     05  WS-COMPARE-REV-MON        REDEFINES WS-COMPARE-MONTH     
A02221                                   PIC 9(06).                     
           05  WS-CUR-REV-MON-MIN.                                      
               10  WS-REV-CCYY-MIN       PIC 9(04).                     
               10  WS-REV-MM-MIN         PIC 9(02).                     
           05  WS-CUR-REV-MON-CR-MIN  REDEFINES WS-CUR-REV-MON-MIN      
                                         PIC 9(06).                     
C31558     05  WS-CONTRACT-DT.                                          
A02221         10  WS-CONTRACT-CCYY      PIC 9(04).                     
C31558         10  FILLER                PIC X(01)  VALUE '-'.          
A02221         10  WS-CONTRACT-MM        PIC 9(02).                     
C31558         10  FILLER                PIC X(01)  VALUE '-'.          
C31558         10  WS-CONTRACT-DD        PIC X(02)  VALUE '01'.         
C31558     05  WS-CONTRACT-DATE       REDEFINES WS-CONTRACT-DT          
C31558                                   PIC X(10).                     
A02221     05  WS-ANN-REV-TO-MONTH.                                     
A02221         10  WS-ANN-REV-TO-CCYY    PIC 9(04).                     
A02221         10  WS-ANN-REV-TO-MM      PIC 9(02).                     
A02221     05  WS-ANN-REVIEW-TO-MNTH  REDEFINES WS-ANN-REV-TO-MONTH     
A02221                                   PIC 9(06).                     
A02221     05  WS-ANN-REV-FROM-MONTH.                                   
A02221         10  WS-ANN-REV-FROM-CCYY  PIC 9(04).                     
A02221         10  WS-ANN-REV-FROM-MM    PIC 9(02).                     
A02221     05  WS-ANN-REVIEW-FRM-MNTH REDEFINES WS-ANN-REV-FROM-MONTH   
A02221                                   PIC 9(06).                     
A02221     05  WS-CUR-REV-MON-MAX.                                      
A02221         10  WS-REV-CCYY-MAX       PIC 9(04).                     
A02221         10  WS-REV-MM-MAX         PIC 9(02).                     
A02221     05  WS-CUR-REV-MON-CR-MAX  REDEFINES WS-CUR-REV-MON-MAX      
A02221                                   PIC 9(06).                     
COB305     05 WS-CUR-REV-MON-NUM        PIC S9(6)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-CUR-REV-MON-MIN-NUM        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.       
COB305     05 WS-CUR-REV-MON-MAX-NUM        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.       
C31558     05  WS-BG-REV-MONTH           PIC 9(06).                     
      *                                                                         
A02221     05  WS-CUST-NAME-IN           PIC X(35)  VALUE SPACES.       
A02221     05  WS-ACCT-NO-IN             PIC S9(13) VALUE ZERO.         
      *                                                                         
A02221 01  WS-EXCLUDE-RATES.                                            
A02221     05 WS-RT1                     PIC X(03) VALUE ' '.           
A02221     05 WS-FILLER                  PIC X(01) VALUE ' '.           
A02221     05 WS-RT2                     PIC X(03) VALUE ' '.           
A02221     05 WS-FILLER                  PIC X(01) VALUE ' '.           
A02221     05 WS-RT3                     PIC X(03) VALUE ' '.           
A02221     05 WS-FILLER                  PIC X(01) VALUE ' '.           
A02221     05 WS-RT4                     PIC X(03) VALUE ' '.           
      *                                                                         
A02221 01 WS-AMOUNT-FIELDS.                                             
A02221    05 WS-DTS-AMT                  PIC S9(9)V9(1) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221    05 WS-REVENUE-AMT              PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221    05 WS-AVG-REVENUE-AMT          PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221    05 WS-ADJ-REVENUE-AMT          PIC S9(9)V9(2) USAGE COMP-3    
A02221                                              VALUE ZERO.         
A02221    05 WS-ADJ-DTS-AMT              PIC S9(9)V9(1) USAGE COMP-3    
A02221                                              VALUE ZERO.         
      *                                                                         
A02221 01  WS-TITLE-RECORD.                                             
HEX01      05 WS-FILLER                  PIC  X(01) VALUE X'09'.        
HEX01      05 WS-FILLER                  PIC  X(01) VALUE X'09'.        
HEX01      05 WS-FILLER                  PIC  X(01) VALUE X'09'.        
A02221     05 WS-FILLER                  PIC  X(05) VALUE 'FROM:'.      
A02221     05 WS-FROM-TITLE-MNTH         PIC  X(06) VALUE SPACES.       
HEX01      05 WS-FILLER                  PIC  X(01) VALUE X'09'.        
A02221     05 WS-FILLER                  PIC  X(03) VALUE 'TO:'.        
A02221     05 WS-TO-TITLE-MNTH           PIC  X(06) VALUE SPACES.       
      *                                                                         
A02221 01  WS-HEADER-RECORD.                                            
A02221     05 WS-CUSTOMER-NAME-H         PIC  X(13)                     
A02221                                        VALUE 'CUSTOMER NAME'.    
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ACCOUNT-NO-H            PIC  X(10)                     
A02221                                        VALUE 'ACCOUNT NO'.       
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-DTS-H                   PIC  X(03)                     
A02221                                        VALUE 'DTS'.              
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-REVENUE-H               PIC  X(07)                     
A02221                                        VALUE 'REVENUE'.          
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-AVG-REVENUE-H           PIC  X(11)                     
A02221                                        VALUE 'AVG REVENUE'.      
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ADJ-REVENUE-H           PIC  X(11)                     
A02221                                        VALUE 'ADJ REVENUE'.      
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ADJ-DTS-H               PIC  X(07)                     
A02221                                        VALUE 'ADJ DTS'.          
      *                                                                         
A02221 01  WS-DATA-RECORD.                                              
A02221     05 WS-CUST-NAME-R             PIC  X(35).                    
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ACCT-NO-R               PIC  XBXXXXBXXXXBXXXX.         
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-DTS-R                   PIC  -ZZZ,ZZZ,ZZ9.             
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-REVENUE-R               PIC  -ZZZ,ZZZ,ZZ9.99.          
HEX01      05 WS-FILLLER                 PIC X(01)  VALUE X'09'.        
A02221     05 WS-AVG-REVENUE-R           PIC  -ZZZ,ZZZ,ZZ9.99.          
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ADJ-REVENUE-R           PIC  -ZZZ,ZZZ,ZZ9.99.          
HEX01      05 WS-FILLER                  PIC X(01)  VALUE X'09'.        
A02221     05 WS-ADJ-DTS-R               PIC  -ZZZ,ZZZ,ZZ9.             
                                                                        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FILE-STATUS             PIC  X(02).                    
              88 SUCCESSFUL                         VALUE '00'.         
                                                                        
           05  WS-FRP421-STATUS          PIC XX     VALUE '00'.         
               88  FRP421-SUCCESSFUL                VALUE '00'.         
                                                                        
           05  WS-FRP421A-STATUS          PIC XX    VALUE '00'.         
               88  FRP421A-SUCCESSFUL               VALUE '00'.         
                                                                        
           05  WS-FRP421B-STATUS          PIC XX    VALUE '00'.         
               88  FRP421B-SUCCESSFUL               VALUE '00'.         
                                                                        
           05  WS-FRP421C-STATUS          PIC XX    VALUE '00'.         
               88  FRP421C-SUCCESSFUL               VALUE '00'.         
                                                                        
           05  WS-FRP421D-STATUS          PIC XX    VALUE '00'.         
               88  FRP421D-SUCCESSFUL               VALUE '00'.         
                                                                        
A02221     05  WS-REGULAR-RUN            PIC X(01)  VALUE SPACE.        
A02221         88  REGULAR-RUN                      VALUE 'Y'.          
                                                                        
           05  WS-FCA331-STATUS          PIC XX     VALUE '00'.         
               88  FCA331-SUCCESSFUL                VALUE '00'.         
                                                                        
           05  WS-END-OF-FCSRP421        PIC X(01)  VALUE 'N'.          
               88  END-OF-FCSRP421                  VALUE 'Y'.          
                                                                        
           05 WS-CONTRACT-FOUND          PIC X(01)  VALUE 'N'.          
              88 CONTRACT-FOUND                     VALUE 'Y'.          
              88 CONTRACT-NOT-FOUND                 VALUE 'N'.          
                                                                        
A02221     05 WS-TRANSPORT-REV-FLAG      PIC X(01)  VALUE 'Y'.          
A02221     05 WS-EXCLUDE-RATES-FLAG      PIC X(01)  VALUE 'N'.          
      ***************** PCSRP421 REPORT HEADERS **********************          
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
A02221     05 WS-RPRT-TITLE-1.                                          
              10  FILLER                 PIC X(02)  VALUE SPACES.       
A02221        10  P-RPRT-TITLE-PGNM      PIC X(08).                     
              10  FILLER                 PIC X(09)  VALUE               
                                         '-PCSR4212'.                   
              10  FILLER                 PIC X(36)  VALUE SPACES.       
A02221        10  P-RPRT-COMP-NAME       PIC X(26).                     
              10  FILLER                 PIC X(32)  VALUE SPACES.       
              10  FILLER                 PIC X(11)  VALUE ' RUN DATE: '.
A02221        10  P-RPRT-RUN-MM          PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
A02221        10  P-RPRT-RUN-DD          PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
A02221        10  P-RPRT-RUN-YY          PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE SPACES.       
                                                                        
              10 FILLER                  PIC X(54)  VALUE SPACES.       
              10 FILLER                  PIC X(23)  VALUE               
                                              'GAS CUSTOMERS BY VOLUME'.
              10 FILLER                  PIC X(36)  VALUE SPACES.       
              10 FILLER                  PIC X(11)  VALUE ' RUN TIME: '.
              10 FILLER                  PIC X(01)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
A02221     05 WS-RPRT-TITLE-2.                                          
              10 FILLER                  PIC X(51)  VALUE SPACES.       
              10 FILLER                  PIC X(28)  VALUE               
                                        'ANNUAL MINIMUM REVIEW REPORT'. 
              10 FILLER                  PIC X(34)  VALUE SPACES.       
              10 FILLER                  PIC X(11)  VALUE ' RUN TIME: '.
A02221        10 WS-RPRT-HH              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
A02221        10 WS-RPRT-MIN             PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
A02221        10 WS-RPRT-SS              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
                                                                        
A02221     05 WS-RPRT-TITLE-3.                                          
              10 FILLER                  PIC X(47)  VALUE SPACES.       
              10 FILLER                  PIC X(22)  VALUE               
                                              'ANNUAL REVIEW MONTH - '. 
A02221        10 WS-RPRT-ANN-REV-MNTH    PIC X(09)  VALUE SPACES.       
              10 FILLER                  PIC X(02)  VALUE ', '.         
A02221        10 WS-RPRT-ANN-REV-CCYY.                                  
A02221           15 WS-RPRT-ANN-REV-CC   PIC XX     VALUE SPACES.       
A02221           15 WS-RPRT-ANN-REV-YY   PIC XX     VALUE SPACES.       
              10 FILLER                  PIC X(29)  VALUE SPACES.       
              10 FILLER                  PIC X(10)  VALUE '     PAGE:'. 
              10 FILLER                  PIC X(05)  VALUE SPACES.       
A02221        10 WS-RPRT-PAGE            PIC ZZZ9.                      
              10 FILLER                  PIC X(01)  VALUE SPACES.       
      *                                                                         
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER.       **            
      ***************************************************************           
A02221     05 WS-RPRT-HEADER-1.                                         
C31558        10 FILLER                  PIC X(10)  VALUE SPACES.       
A02221        10 WS-RPRT-NAME            PIC X(35)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(02)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(02)  VALUE '# '.         
A02221        10 WS-RPRT-ACCOUNT-NO      PIC XBXXXXBXXXXBXXXX           
C31558                                              VALUE SPACES.       
C31558        10 FILLER                  PIC X(68)  VALUE SPACES.       
C31558*                                                                         
A02221     05 WS-RPRT-HEADER-2.                                         
C31558        10 FILLER                  PIC X(02)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(27)  VALUE               
C31558                             'CONTRACT YEAR            : '.       
A02221        10 WS-RPRT-BEG-MONTH       PIC X(09)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(02)  VALUE ', '.         
A02221        10 WS-RPRT-BEG-YEAR        PIC X(04)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(03)  VALUE ' - '.        
A02221        10 WS-RPRT-END-MONTH       PIC X(09)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(02)  VALUE ', '.         
A02221        10 WS-RPRT-END-YEAR        PIC X(04)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(71)  VALUE SPACES.       
C31558*                                                                         
A02221     05 WS-RPRT-HEADER-3.                                         
C31558        10 FILLER                  PIC X(02)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(27)  VALUE               
C31558                             'MINIMUM CONSUMPTION(DTS) : '.       
A02221        10 WS-RPRT-ANN-MIN-AMT     PIC ZZZ,ZZZ,ZZ9.9.             
C31558        10 FILLER                  PIC X(91)  VALUE SPACES.       
C31558*                                                                         
A02221     05 WS-RPRT-HEADER-4.                                         
C31558        10 FILLER                  PIC X(02)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(27)  VALUE               
C31558                             'CATEGORY                 : '.       
A02221        10 WS-RPRT-CATEGORY        PIC X(02)  VALUE SPACES.       
C31558        10 FILLER                  PIC X(102) VALUE SPACES.       
C31558*                                                                         
A02221    05 WS-RPRT-HEADER-5.                                          
C31558       10 FILLER                  PIC X(02)  VALUE SPACES.        
C31558       10 FILLER                  PIC X(09)  VALUE 'MONTH    '.   
C31558       10 FILLER                  PIC X(02)  VALUE ', '.          
C31558       10 FILLER                  PIC X(04)  VALUE 'YEAR'.        
C31558       10 FILLER                  PIC X(19)  VALUE SPACES.        
C31558       10 FILLER                  PIC X(10)  VALUE 'DEKATHERMS'.  
C31558       10 FILLER                  PIC X(87)  VALUE SPACES.        
      *                                                                         
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
                                                                        
           05  WS-LINE.                                                 
               10 FILLER                 PIC X(133) VALUE ALL '-'.      
                                                                        
           05  WS-UNDERLINE.                                            
               10 FILLER                 PIC X(67)  VALUE SPACES.       
               10 FILLER                 PIC X(11)  VALUE ALL '-'.      
               10 FILLER                 PIC X(06)  VALUE SPACES.       
               10 FILLER                 PIC X(14)  VALUE ALL '-'.      
               10 FILLER                 PIC X(35)  VALUE SPACES.       
      *                                                                         
A02221     05  WS-RPRT-UNDERLINE.                                       
C31558         10 FILLER                 PIC X(32)  VALUE SPACES.       
C31558         10 FILLER                 PIC X(14)  VALUE ALL '-'.      
C31558         10 FILLER                 PIC X(87)  VALUE SPACES.       
      *                                                                         
      ***************************************************************           
A02221 01  WS-DETAIL-LINE.                                              
C31558     10 FILLER                     PIC X(02)  VALUE SPACES.       
C31558     10 WS-DET2-REV-MONTH          PIC X(09)  VALUE SPACES.       
C31558     10 FILLER                     PIC X(02)  VALUE ', '.         
C31558     10 WS-DET2-REV-YEAR           PIC X(04)  VALUE SPACES.       
C31558     10 FILLER                     PIC X(15)  VALUE SPACES.       
C31558     10 WS-DET2-DTS                PIC ZZZ,ZZZ,ZZ9.9-.            
C31558     10 FILLER                     PIC X(87)  VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                     PIC X(48)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '**** NO DATA THIS RUN****'.                             
           05 FILLER                     PIC X(55)  VALUE SPACES.       
      *                                                                         
A02221 01  WS-RPRT-SUMMARY-LINE1.                                       
C31558     05 FILLER                     PIC X(02)  VALUE SPACES.       
C31558     05 FILLER                     PIC X(28)  VALUE               
C31558               'ANNUAL ACTUAL CONSUMPTION : '.                    
C31558     05 FILLER                     PIC X(02)  VALUE SPACES.       
A02221     05 WS-RPRT-SUM-BILL-UNITS     PIC ZZZ,ZZZ,ZZ9.9-             
C31558                                              VALUE ZEROS.        
C31558     05 FILLER                     PIC X(87)  VALUE SPACES.       
      *                                                                         
A02221 01  WS-RPRT-SUMMARY-LINE2.                                       
C31558     05 FILLER                     PIC X(02)  VALUE SPACES.       
C31558     05 FILLER                     PIC X(17)  VALUE               
C31558                                       'DEFICIT VOLUME : '.       
A02221     05 WS-RPRT-ADJ-BILL-UNITS     PIC ZZZ,ZZZ,ZZ9.9-             
C31558                                              VALUE ZEROS.        
C31558     05 FILLER                     PIC X(100) VALUE SPACES.       
      *                                                                         
       01  WS-FOOTER1.                                                  
           05 FILLER                     PIC X(35)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '* * * END OF REPORT * * *'.                             
           05 FILLER                     PIC X(72)  VALUE SPACES.       
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME               PIC 9(08).                     
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)  VALUE 'Y'.          
           05 WS-N                       PIC X(01)  VALUE 'N'.          
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00011.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT - AT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT - UT                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RATE_COMP_DEF - J1                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCDEF                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILLING_DET - BG                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CONTRACT- BK                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCNTR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_VOL_DAILY - ND                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBVOLDLY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_READ_WINDOW - RW                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRDWNDW                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY - C7                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM - G6                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PRTY_SVC_CAT - Z4                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBSVCCAT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME - DQ                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_CUSTOMER - CU                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILLING_HDR - BI                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
      *                                                                         
A02221*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A02221*   CSS_CNSMPTN_HIST - CX                                       *         
A02221*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
A02221     EXEC SQL                                                             
A02221          INCLUDE TBCNSMP                                                 
A02221     END-EXEC.                                                            
      *                                                                         
A02221*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A02221*   CSS_MTRD_ENVRNMT- MN                                       *          
A02221*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
A02221     EXEC SQL                                                             
A02221         INCLUDE TBMTRENV                                                 
A02221     END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
35518 *   CSS_RATE_COMPONENT  N6                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
35518      EXEC SQL                                                             
35518           INCLUDE TBRTCPNT                                                
35518      END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * GAS_CUSTOMER CURSOR FOR FETCHING ALL THE GAS CUSTOMERS        *         
      * FROM CSS_UTIL_ENVRNMT,CSS_RATE_COMP_DEF TABLES                *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
              DECLARE GAS_CUSTOMER CURSOR FOR                           
                 SELECT UT.ACCOUNT_NO,                                  
A02221                  UT.RATE_PLAN_NO,                                
                        UT.IC_NO,                                       
                        UT.READ_CYCLE,                                  
                        Z4.PRTY_SVC_CAT_CD                              
                  FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),              
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)               
A00633           WHERE  UT.CODE_UTIL_TYPE    = 'G'                      
                   AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO           
                   AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY    
C31558             AND  UT.COMPANY_NO        = '01'                     
                   AND  UT.COMPANY_NO        =  Z4.COMPANY_NO           
                   AND  EXISTS                                          
                        (SELECT *                                       
                          FROM CSS_RATE_COMP_DEF J1
                           WITH(READUNCOMMITTED)                     
A02221                    WHERE J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE   
A02221                    AND ((:WS-EXCLUDE-RATES-FLAG   = 'N')         
A02221                          OR (:WS-EXCLUDE-RATES-FLAG = 'Y'        
A02221                              AND J1.RATE_PLAN_NO NOT IN          
A02221                              (:WS-RT1,:WS-RT2,:WS-RT3,:WS-RT4))) 
A02221                    AND J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO       
A02221                    AND J1.REG_TYPE_CD    = 'D')                  
                ORDER BY  UT.ACCOUNT_NO,UT.IC_NO,Z4.PRTY_SVC_CAT_CD     
                                                                 
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GAS_CUSTOMER CURSOR FOR                                   
MFA-TR*          SELECT UT.ACCOUNT_NO,                                          
MFA-TR*                 UT.RATE_PLAN_NO,                                        
MFA-TR*                 UT.IC_NO,                                               
MFA-TR*                 UT.READ_CYCLE,                                          
MFA-TR*                 Z4.PRTY_SVC_CAT_CD                                      
MFA-TR*           FROM  CSS_UTIL_ENVRNMT UT,                                    
MFA-TR*                 CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_PRTY_SVC_CAT Z4                                     
MFA-TR*          WHERE  UT.CODE_UTIL_TYPE    = 'G'                              
MFA-TR*            AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO                   
MFA-TR*            AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY            
MFA-TR*            AND  UT.COMPANY_NO        = '01'                             
MFA-TR*            AND  UT.COMPANY_NO        =  Z4.COMPANY_NO                   
MFA-TR*            AND  EXISTS                                                  
MFA-TR*                 (SELECT *                                               
MFA-TR*                   FROM CSS_RATE_COMP_DEF J1                             
MFA-TR*                   WHERE J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
MFA-TR*                   AND ((:WS-EXCLUDE-RATES-FLAG   = 'N')                 
MFA-TR*                         OR (:WS-EXCLUDE-RATES-FLAG = 'Y'                
MFA-TR*                             AND J1.RATE_PLAN_NO NOT IN                  
MFA-TR*                             (:WS-RT1,:WS-RT2,:WS-RT3,:WS-RT4)))         
MFA-TR*                   AND J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO               
MFA-TR*                   AND J1.REG_TYPE_CD    = 'D')                          
MFA-TR*         ORDER BY  UT.ACCOUNT_NO,UT.IC_NO,Z4.PRTY_SVC_CAT_CD             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * GAS_REVENUE CURSOR FOR FETCHING THE REVENUE OF EACH           *         
      * CUSTOMER FROM CSS_BILLING_DET TABLE                           *         
      *---------------------------------------------------------------*         
      *                                                                         
           EXEC SQL                                                     
             DECLARE GAS_REVENUE CURSOR FOR                             
                SELECT ACCOUNT_NO                                       
35518                 ,CASE                                             
35518                    WHEN REV_MTH_ORIG_BILL > 0                     
35518                       THEN REV_MTH_ORIG_BILL                      
35518                      ELSE REVENUE_MONTH                           
35518                  END AS REVENUE_MONTH                             
A02221                ,CODE_DR_CR_CNSMPTN                               
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
35518                 ,BILL_NO                                          
35518                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
35518                 ,AMT_BILL_ITEM - AMT_STATE_TAX - AMT_CITY_TAX     
A02221                ,CODE_BILL_CALC                                   
A00633                ,REV_RPT_CD                                       
                 FROM  CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                WHERE  ACCOUNT_NO     = :UT-ACCOUNT-NO                  
C31558            AND  CODE_UTIL_TYPE = 'G'                             
                  AND  IC_NO          = :UT-IC-NO                       
35518             AND ((REV_MTH_ORIG_BILL = 0                           
35518             AND REVENUE_MONTH                                     
35518                 BETWEEN :WS-CUR-REV-MON-MIN-NUM                   
C31558                    AND :WS-CUR-REV-MON-MAX-NUM)                  
35518              OR REV_MTH_ORIG_BILL                                 
35518                 BETWEEN :WS-CUR-REV-MON-MIN-NUM                   
C31558                    AND :WS-CUR-REV-MON-MAX-NUM)                  
A02221            AND ((:WS-TRANSPORT-REV-FLAG = 'Y')                   
A02221                 OR (:WS-TRANSPORT-REV-FLAG = 'N'                 
A02221                      AND REV_RPT_CD       <> 'T'))               
                  AND  CODE_BILL_ITM_TYPE =  'C'                        
                  AND  CODE_BILL_ITM_IND  =  'A'                        
A02221            AND  CODE_BILL_CALC    IN ('A' , 'S')                 
                  AND  COMPANY_NO = '01'                                
                ORDER BY  REVENUE_MONTH                                 
                                                                 
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GAS_REVENUE CURSOR FOR                                     
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,CASE                                                     
MFA-TR*                  WHEN REV_MTH_ORIG_BILL > 0                             
MFA-TR*                     THEN REV_MTH_ORIG_BILL                              
MFA-TR*                    ELSE REVENUE_MONTH                                   
MFA-TR*                END AS REVENUE_MONTH                                     
MFA-TR*               ,CODE_DR_CR_CNSMPTN                                       
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,AMT_BILL_ITEM - AMT_STATE_TAX - AMT_CITY_TAX             
MFA-TR*               ,CODE_BILL_CALC                                           
MFA-TR*               ,REV_RPT_CD                                               
MFA-TR*          FROM  CSS_BILLING_DET                                          
MFA-TR*         WHERE  ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = 'G'                                     
MFA-TR*           AND  IC_NO          = :UT-IC-NO                               
MFA-TR*           AND ((REV_MTH_ORIG_BILL = 0                                   
MFA-TR*           AND REVENUE_MONTH                                             
MFA-TR*               BETWEEN :WS-CUR-REV-MON-MIN-NUM                           
MFA-TR*                   AND :WS-CUR-REV-MON-MAX-NUM)                          
MFA-TR*            OR REV_MTH_ORIG_BILL                                         
MFA-TR*               BETWEEN :WS-CUR-REV-MON-MIN-NUM                           
MFA-TR*                   AND :WS-CUR-REV-MON-MAX-NUM)                          
MFA-TR*           AND ((:WS-TRANSPORT-REV-FLAG = 'Y')                           
MFA-TR*                OR (:WS-TRANSPORT-REV-FLAG = 'N'                         
MFA-TR*                     AND REV_RPT_CD       <> 'T'))                       
MFA-TR*           AND  CODE_BILL_ITM_TYPE =  'C'                                
MFA-TR*           AND  CODE_BILL_ITM_IND  =  'A'                                
MFA-TR*           AND  CODE_BILL_CALC    IN ('A' , 'S')                         
MFA-TR*           AND  COMPANY_NO = '01'                                        
MFA-TR*         ORDER BY  REVENUE_MONTH                                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            
A02221*---------------------------------------------------------------*         
A02221* USAGE_ADJUSTMENT CURSOR FOR FETCHING THE NO.OF UNITS FOR      *         
A02221* NON CALC ROWS FROM CSS_CNSMPTN_HIST                           *         
A02221*---------------------------------------------------------------*         
A02221*                                                                         
A02221     EXEC SQL                                                     
A02221       DECLARE USAGE_ADJUSTMENT CURSOR FOR                        
A02221          SELECT CX.NO_UNITS                                      
A02221                ,CX.BTU_FACTOR                                    
A02221            FROM CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)               
A02221                ,CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)               
A02221            WHERE  CX.ACCOUNT_NO   = :BG-ACCOUNT-NO               
A02221             AND CX.ACCOUNT_NO     =  MN.ACCOUNT_NO               
A02221             AND CX.BILL_NO        = :BG-BILL-NO                  
A02221             AND CX.CODE_UTIL_TYPE = 'G'                          
A02221             AND CX.CODE_UTIL_TYPE =  MN.CODE_UTIL_TYPE           
A02221             AND CX.IC_NO          = :BG-IC-NO                    
A02221             AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
A02221             AND CX.MTR_REF_NO     =  MN.MTR_REF_NO               
A02221             AND CX.COMPANY_NO     = '01'                         
A02221             AND MN.CODE_METER_STATUS  <> 'K'                     
A02221          FOR READ ONLY                                   
A02221                                                      
A02221     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE USAGE_ADJUSTMENT CURSOR FOR                                
MFA-TR*         SELECT CX.NO_UNITS                                              
MFA-TR*               ,CX.BTU_FACTOR                                            
MFA-TR*           FROM CSS_CNSMPTN_HIST  CX                                     
MFA-TR*               ,CSS_MTRD_ENVRNMT  MN                                     
MFA-TR*           WHERE  CX.ACCOUNT_NO   = :BG-ACCOUNT-NO                       
MFA-TR*            AND CX.ACCOUNT_NO     =  MN.ACCOUNT_NO                       
MFA-TR*            AND CX.BILL_NO        = :BG-BILL-NO                          
MFA-TR*            AND CX.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND CX.CODE_UTIL_TYPE =  MN.CODE_UTIL_TYPE                   
MFA-TR*            AND CX.IC_NO          = :BG-IC-NO                            
MFA-TR*            AND CX.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
MFA-TR*            AND CX.MTR_REF_NO     =  MN.MTR_REF_NO                       
MFA-TR*            AND CX.COMPANY_NO     = '01'                                 
MFA-TR*            AND MN.CODE_METER_STATUS  <> 'K'                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            
A02221*                                                                         
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSRP421 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO  WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT.              
A02221     PERFORM 8800-INACTIVE-JOB-PARM  THRU 8800-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      **  0100-INITIALIZATION.                                 **               
      **        INITIALIZATION ROUTINE                         **               
      ***********************************************************               
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                          TO WS-ACTIVE-PARAGRAPH. 
      *                                                                         
A02221     OPEN OUTPUT FCSPT33-FILE.                                    
A02221     OPEN OUTPUT FCSRP421-FILE.                                   
                                                                        
A02221* SELECT COMPANY NAME                                                     
A02221     PERFORM 7750-GET-COMPANY-DESC        THRU 7750-EXIT.         
A02221     MOVE C7-COMPANY-NAME                 TO WS-COMP-NAME         
                                                                        
A02221* SELCT  JOB PARM VALUES FOR MIN AND MAX REVENUE MONTHS                   
A02221     MOVE ZEROS                           TO WS-CUR-REV-MON-MAX,  
A02221                                             WS-CUR-REV-MON-MIN.  
A02221     PERFORM 0110-GET-JOB-PARM-VALUES     THRU 0110-EXIT.         
A02221     PERFORM 0125-POPULATE-RPT-FIELDS     THRU 0125-EXIT.         
      *                                                                         
A02221     PERFORM 7425-GET-CONTRACT-DATE       THRU 7425-EXIT.         
      *                                                                         
A02221     DISPLAY 'WS-CONTRACT-DATE  '  WS-CONTRACT-DATE               
      *                                                                         
A02221     INITIALIZE WS-BILL-UNITS,                                    
A02221                WS-AMT-BILL-ITEM,                                 
A02221                WS-ADJ-REVENUE,                                   
A02221                WS-ADJ-DTS,                                       
A02221                WS-REV-AMT,                                       
A02221                WS-CUST-NAME.                                     
                                                                        
      *                                                                         
A02221 0100-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221*************************************************************             
A02221**  0110-GET-JOB-PARM-VALUES.                              **             
A02221**       READS MIN REV MNTH AND MAX REV MNTH FROM JOB PARM **             
A02221*************************************************************             
A02221 0110-GET-JOB-PARM-VALUES.                                        
      *                                                                         
           MOVE '0110'                          TO WS-ACTIVE-PARAGRAPH. 
      *                                                                         
A02221     MOVE WS-PGRMNAME                     TO WS-PROGRAM.          
A02221     MOVE WS-PARM                         TO WS-COMMAND.          
A02221     MOVE ZEROS                           TO WS-SEQUENCE.         
A02221     MOVE SPACES                          TO WS-SYSIPT.           
A02221     MOVE WS-KEY-AREA                     TO E-FJC01-KEY.         
      *                                                                         
A02221     PERFORM 7600-START-FCSJC01           THRU 7600-EXIT.         
A02221     PERFORM 0120-READ-FCSJC01            THRU 0120-EXIT          
A02221             UNTIL END-OF-SYSIPT.                                 
      *                                                                         
           EVALUATE TRUE                                                
A02221       WHEN WS-CUR-REV-MON-MAX EQUAL ZEROS AND                    
A02221            WS-CUR-REV-MON-MIN EQUAL ZEROS                        
A02221            DISPLAY 'JOB PARM NOT PRESENT FOR'                    
A02221            DISPLAY 'MIN & MAX REVENUE MONTHS'                    
A02221            DISPLAY 'REPORTS WILL BE GENERATED FROM'              
A02221            DISPLAY 'OVERRIDE REVENUE MONTHS'                     
A02221            PERFORM 0111-PROCESS-REVENUE-MNTHS THRU 0111-EXIT     
A02221       WHEN WS-CUR-REV-MON-MIN  EQUAL ZEROS                       
A02221             DISPLAY 'JOB PARM NOT PRESENT FOR MIN REV MNTH'      
A02221             PERFORM 9900-ABEND    THRU  9900-EXIT                
A02221       WHEN WS-CUR-REV-MON-MAX  EQUAL ZEROS                       
A02221             DISPLAY 'JOB PARM NOT PRESENT FOR MAX REV MNTH'      
A02221             PERFORM 9900-ABEND    THRU  9900-EXIT                
A02221     END-EVALUATE.                                                
      *                                                                         
A02221 0110-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221*************************************************************             
A02221**  0111-PROCESS-REVENUE-MNTHS.                            **             
A02221**       PROCESSES THE REVENUE MONTH                       **             
A02221*************************************************************             
A02221 0111-PROCESS-REVENUE-MNTHS.                                      
      *                                                                         
A02221     MOVE '0111'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     INITIALIZE WS-SYSIPT,                                        
A02221                WS-INPUT-DATA-BREAKDOWN.                          
A02221     MOVE 'REPORTDATE'               TO WS-PROGRAM.               
A02221     MOVE WS-DATE                    TO WS-COMMAND.               
A02221     MOVE ZEROS                      TO WS-SEQUENCE.              
A02221     MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
A02221     PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
A02221     PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
A02221          UNTIL (REPORT-DATE AND INPUT-ACTIVE)                    
A02221          OR END-OF-SYSIPT.                                       
A02221     IF END-OF-SYSIPT                                             
A02221        DISPLAY '**   PCSRP421 PROCESSING ERROR         **'       
A02221        DISPLAY '** REPORTDATE FROM JOB PARM NOT ACTIVE **'       
A02221        DISPLAY '**     PROCESSING TERMINATED           **'       
A02221        PERFORM 9900-ABEND           THRU  9900-EXIT              
A02221     ELSE                                                         
A02221        MOVE G6-PARM-DATA            TO WS-INPUT-DATA-BREAKDOWN   
A02221        MOVE 'Y'                     TO WS-REGULAR-RUN            
A02221     END-IF.                                                      
      *                                                                         
A02221     MOVE WS-INPUT-DATA-BREAKDOWN(13:04) TO  WS-REV-CCYY          
A02221                                                                  
A02221     MOVE WS-INPUT-DATA-BREAKDOWN(17:02) TO  WS-REV-MM            
A02221* CALCULATE MINIMUM & MAXIMUM REVENUE YEAR AND MONTH                      
A02221     SUBTRACT WS-ONE FROM WS-REV-CCYY GIVING WS-REV-CCYY-MIN.     
A02221     MOVE     WS-REV-MM                  TO  WS-REV-MM-MIN        
      *                                                                         
A02221     SUBTRACT WS-ONE FROM WS-REV-MM   GIVING WS-REV-MM-MAX        
A02221     IF WS-REV-MM-MAX = 0                                         
A02221        MOVE WS-TWELVE                   TO WS-REV-MM-MAX         
A02221        SUBTRACT WS-ONE FROM WS-REV-CCYY GIVING WS-REV-CCYY-MAX   
A02221     ELSE                                                         
A02221        MOVE WS-REV-CCYY                 TO WS-REV-CCYY-MAX       
A02221     END-IF.                                                      
A02221     DISPLAY  'WS-CUR-REV-MON-MIN: '   WS-CUR-REV-MON-MIN.        
A02221     DISPLAY  'WS-CUR-REV-MON-MAX: '   WS-CUR-REV-MON-MAX.        
      * CALCULATE PREVIOUS YEARS COMPARE MONTH FOR COMPARISON                   
A02221     SUBTRACT WS-ONE FROM WS-REV-MM-MIN GIVING WS-COMPARE-MM      
A02221     IF WS-COMPARE-MM = 0                                         
A02221       MOVE WS-TWELVE                    TO  WS-COMPARE-MM        
A02221       SUBTRACT WS-ONE FROM WS-REV-CCYY-MIN GIVING WS-COMPARE-CCYY
A02221     ELSE                                                         
A02221       MOVE WS-REV-CCYY-MIN              TO WS-COMPARE-CCYY       
A02221     END-IF.                                                      
A02221* CALCULATE CONTRACT YEAR AND MONTH                                       
A02221     ADD  WS-ONE TO WS-REV-MM      GIVING   WS-CONTRACT-MM        
A02221     IF WS-CONTRACT-MM > 12                                       
A02221        MOVE WS-ONE                      TO WS-CONTRACT-MM        
A02221        ADD  WS-ONE TO WS-REV-CCYY GIVING   WS-CONTRACT-CCYY      
A02221        MOVE WS-REV-CCYY                 TO WS-ANN-REV-FROM-CCYY  
A02221     ELSE                                                         
A02221        MOVE WS-REV-CCYY                 TO WS-CONTRACT-CCYY      
A02221        SUBTRACT WS-ONE FROM WS-REV-CCYY GIVING                   
A02221                                            WS-ANN-REV-FROM-CCYY  
A02221     END-IF.                                                      
      *                                                                         
A02221     MOVE WS-CONTRACT-MM                 TO WS-ANN-REVIEW-MONTH   
A02221                                            WS-ANN-REV-FROM-MM.   
      *                                                                         
A02221     MOVE WS-REV-MM                      TO WS-ANN-REV-TO-MM.     
A02221     MOVE WS-REV-CCYY                    TO WS-ANN-REV-TO-CCYY.   
      *                                                                         
A02221 0111-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221*************************************************************             
A02221**  0120-READ-FCSJC01.                                     **             
A02221*************************************************************             
A02221 0120-READ-FCSJC01.                                               
      *                                                                         
A02221     MOVE '0120'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     PERFORM 7610-READ-FCSJC01       THRU 7610-EXIT.              
                                                                        
A02221     IF END-OF-SYSIPT                                             
A02221        GO  TO 0120-EXIT                                          
A02221     END-IF.                                                      
      *                                                                         
A02221     IF WS-INPUT-DATA-BREAKDOWN(1:12) = 'MINREV MNTH='            
A02221        IF INPUT-ACTIVE                                           
A02221           MOVE G6-PARM-DATA         TO WS-INPUT-DATA-BREAKDOWN   
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(13:4)                     
A02221                                     TO WS-REV-CCYY-MIN           
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(17:2)                     
A02221                                     TO WS-REV-MM-MIN             
ACT094           DISPLAY 'MINREV MNTH: '      WS-CUR-REV-MON-CR-MIN     
A02221        END-IF                                                    
A02221     END-IF.                                                      
      *                                                                         
A02221     IF WS-INPUT-DATA-BREAKDOWN(1:12) = 'MAXREV MNTH='            
A02221        IF INPUT-ACTIVE                                           
A02221           MOVE G6-PARM-DATA         TO WS-INPUT-DATA-BREAKDOWN   
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(13:4)                     
A02221                                     TO WS-REV-CCYY-MAX           
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(17:2)                     
A02221                                     TO WS-REV-MM-MAX             
A02221           MOVE WS-REV-MM-MAX        TO WS-CONTRACT-MM            
A02221                                        WS-ANN-REVIEW-MONTH       
A02221           MOVE WS-REV-CCYY-MAX      TO WS-CONTRACT-CCYY          
ACT094           DISPLAY 'MAXREV MNTH: '      WS-CUR-REV-MON-CR-MAX     
A02221        END-IF                                                    
A02221     END-IF.                                                      
      *                                                                         
A02221     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'TRANSPORT REVENUE='      
A02221        IF INPUT-ACTIVE                                           
A02221           MOVE G6-PARM-DATA         TO WS-INPUT-DATA-BREAKDOWN   
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(19:1)                     
A02221                                     TO WS-TRANSPORT-REV-FLAG     
A02221           DISPLAY  'TRANSPORTATION REVENUE FLAG:  '              
A02221                                        WS-TRANSPORT-REV-FLAG     
A02221        END-IF                                                    
A02221     END-IF.                                                      
      *                                                                         
A02221     IF WS-INPUT-DATA-BREAKDOWN(1:14) = 'EXCLUDE RATES='          
A02221        IF INPUT-ACTIVE                                           
A02221           MOVE 'Y'                  TO WS-EXCLUDE-RATES-FLAG     
A02221           MOVE G6-PARM-DATA         TO WS-INPUT-DATA-BREAKDOWN   
A02221           MOVE WS-INPUT-DATA-BREAKDOWN(15:15)                    
A02221                                     TO WS-EXCLUDE-RATES          
A02221           DISPLAY 'PROGRAM IS EXCLUDING THE RATES: '             
A02221                                        WS-EXCLUDE-RATES          
A02221        END-IF                                                    
A02221     END-IF.                                                      
      *                                                                         
A02221 0120-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221*************************************************************             
A02221**  0125-POPULATE-RPT-FIELDS                               **             
A02221*************************************************************             
A02221 0125-POPULATE-RPT-FIELDS.                                        
      *                                                                         
A02221     MOVE '0125'                     TO WS-ACTIVE-PARAGRAPH.      
      * GET CURRENT DATE                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
A02221     MOVE   WS-CURRENT-YY            TO   P-RPRT-RUN-YY.          
A02221     MOVE   WS-CURRENT-MM            TO   P-RPRT-RUN-MM.          
A02221     MOVE   WS-CURRENT-DD            TO   P-RPRT-RUN-DD.          
      * GET CURRENT TIME                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
A02221     MOVE   WS-CURRENT-TIME(1:2)     TO   WS-RPRT-HH.             
A02221     MOVE   WS-CURRENT-TIME(3:2)     TO   WS-RPRT-MIN.            
A02221     MOVE   WS-CURRENT-TIME(5:2)     TO   WS-RPRT-SS.             
                                                                        
A02221     MOVE WS-ANN-REV-FROM-CCYY       TO   WS-RPRT-BEG-YEAR.       
A02221     MOVE WS-ANN-REV-TO-CCYY         TO   WS-RPRT-END-YEAR.       
A02221     MOVE WS-CONTRACT-CCYY           TO   WS-RPRT-ANN-REV-CCYY.   
A02221*                                                                         
A02221     MOVE WS-ANN-REVIEW-FRM-MNTH     TO   WS-REVENUE-MM.          
A02221     PERFORM 0200-ASSIGN-MONTH-PARA  THRU 0200-EXIT.              
A02221     MOVE WS-MONTH                   TO   WS-RPRT-BEG-MONTH       
                                                WS-RPRT-ANN-REV-MNTH.   
A02221*                                                                         
A02221     MOVE WS-ANN-REVIEW-TO-MNTH      TO   WS-REVENUE-MM.          
A02221     PERFORM 0200-ASSIGN-MONTH-PARA  THRU 0200-EXIT.              
A02221     MOVE WS-MONTH                   TO   WS-RPRT-END-MONTH.      
      *                                                                         
A02221 0125-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **   0200-ASSIGN-MONTH-PARA.                                    **        
      **        ASSIGN MONTH NAME ACCORDING TO THE NUMERIC VALUE      **        
      ******************************************************************        
                                                                        
       0200-ASSIGN-MONTH-PARA.                                          
                                                                        
           MOVE '0200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EVALUATE WS-REVENUE-MM                                       
               WHEN 01                                                  
                   MOVE 'JANUARY'          TO WS-MONTH                  
               WHEN 02                                                  
                   MOVE 'FEBRUARY'         TO WS-MONTH                  
               WHEN 03                                                  
                   MOVE 'MARCH'            TO WS-MONTH                  
               WHEN 04                                                  
                   MOVE 'APRIL'            TO WS-MONTH                  
               WHEN 05                                                  
                   MOVE 'MAY'              TO WS-MONTH                  
               WHEN 06                                                  
                   MOVE 'JUNE'             TO WS-MONTH                  
               WHEN 07                                                  
                   MOVE 'JULY'             TO WS-MONTH                  
               WHEN 08                                                  
                   MOVE 'AUGUST'           TO WS-MONTH                  
               WHEN 09                                                  
                   MOVE 'SEPTEMBER'        TO WS-MONTH                  
               WHEN 10                                                  
                   MOVE 'OCTOBER'          TO WS-MONTH                  
               WHEN 11                                                  
                   MOVE 'NOVEMBER'         TO WS-MONTH                  
               WHEN 12                                                  
                   MOVE 'DECEMBER'         TO WS-MONTH                  
           END-EVALUATE.                                                
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      *************************************************************             
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     PERFORM 7100-OPEN-GAS-CUSTOMER-CURSOR  THRU 7100-EXIT.       
A02221     PERFORM 7200-FETCH-GAS-CUSTOMER-CURSOR THRU 7200-EXIT.       
A02221     PERFORM 2000-GAS-CUSTOMER-DETAILS      THRU 2000-EXIT        
A02221             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
A02221     CLOSE FCSRP421-FILE.                                         
A02221     PERFORM 7300-CLOSE-GAS-CUSTOMER-CURSOR THRU 7300-EXIT.       
A02221     PERFORM 3000-PRINT-REVENUE-REPORTS     THRU 3000-EXIT.       
A02221     IF REGULAR-RUN                                               
A02221        PERFORM 4000-PRINT-SUMMARY-LINES    THRU 4000-EXIT        
A02221     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02221******************************************************************        
A02221**     2000-GAS-CUSTOMER-DETAILS                                **        
A02221**          THIS PROCEDURE IS A02221                                      
A02221**          CURSOR DETAILS                                      **        
      ******************************************************************        
A02221 2000-GAS-CUSTOMER-DETAILS.                                       
      *                                                                         
A02221     MOVE '2000'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
      *                                                                         
      * FOR REGULAR RUN WE NEED TO FETCH THE GAS REVENUE FROM                   
      * PREVIOUS YEARS COMPARE MONTH TO CURRENT REVENUE MONTH                   
      *                                                                         
A02221     IF REGULAR-RUN                                               
A02221        MOVE WS-COMPARE-REV-MON      TO WS-CUR-REV-MON-MIN-NUM    
A02221        MOVE WS-CUR-REV-MON-CR       TO WS-CUR-REV-MON-MAX-NUM    
A02221     ELSE                                                         
A02221        MOVE WS-CUR-REV-MON-CR-MIN   TO WS-CUR-REV-MON-MIN-NUM    
A02221        MOVE WS-CUR-REV-MON-CR-MAX   TO WS-CUR-REV-MON-MAX-NUM    
A02221     END-IF.                                                      
      *                                                                         
A02221     PERFORM 7310-OPEN-GAS-REVENUE-CURSOR   THRU  7310-EXIT.      
A02221     PERFORM 7320-FETCH-GAS-REVENUE-CURSOR  THRU  7320-EXIT.      
A02221     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A02221        CONTINUE                                                  
A02221     ELSE                                                         
A02221        PERFORM 2100-PROCESS-GAS-REVENUE    THRU  2100-EXIT       
A02221     END-IF.                                                      
A02221     PERFORM 7330-CLOSE-GAS-REVENUE-CURSOR  THRU  7330-EXIT.      
      *                                                                         
A02221     PERFORM 7200-FETCH-GAS-CUSTOMER-CURSOR THRU  7200-EXIT.      
                                                                        
      *                                                                         
A02221 2000-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221******************************************************************        
A02221**     2100-PROCESS-GAS-REVENUE.                                **        
A02221**      THIS PROCEDURE IS USED FOR PERFORMING GAS_CUSTOMER     **         
A02221**      CURSOR DETAILS                                         **         
A02221******************************************************************        
A02221 2100-PROCESS-GAS-REVENUE.                                        
A02221*                                                                         
A02221     MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH.      
A02221*                                                                         
A02221     MOVE 'N'                        TO WS-CONTRACT-FOUND         
A02221     PERFORM 7450-SELECT-CNTRCT-DATE THRU 7450-EXIT               
A02221     IF WS-ANN-MIN-NULL-IND < 0                                   
A02221        MOVE ZEROS                   TO BK-SPCL-ANN-MIN-AM        
A02221     ELSE                                                         
A02221        MOVE 'Y'                     TO WS-CONTRACT-FOUND         
A02221     END-IF                                                       
      *                                                                         
A02221     IF UT-ACCOUNT-NO  NOT EQUAL WS-PREVIOUS-ACCT-NO              
A02221        MOVE  UT-ACCOUNT-NO          TO WS-PREVIOUS-ACCT-NO       
A02221        PERFORM 7700-SELECT-CUSTOMER-NAME THRU 7700-EXIT          
      *                                                                         
A02221        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
A02221           MOVE WS-FULL-NAME         TO WS-EMB-INPUT              
A02221           MOVE 50                   TO WS-EMB-LENG               
A02221           MOVE SPACES               TO WS-CMP-TABLE              
A02221           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT     
A02221           MOVE WS-CMP-TABLE         TO WS-FULL-NAME              
A02221           MOVE WS-FULL-NAME         TO WS-CUST-NAME              
A02221        ELSE                                                      
A02221           MOVE SPACES               TO WS-FULL-NAME              
A02221                                        WS-CUST-NAME              
A02221        END-IF                                                    
A02221     END-IF .                                                     
      *                                                                         
A02221     IF CONTRACT-FOUND AND REGULAR-RUN                            
A02221        ADD WS-ONE                   TO WS-SUMM-REC-CNTR          
A02221        PERFORM 8550-PRINT-RPRT-HEADERS  THRU  8550-EXIT          
           END-IF.                                                      
      *                                                                         
A02221     PERFORM 2200-PROCESS-REV-AMT    THRU 2200-EXIT               
A02221             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
      *                                                                         
A02221     IF CONTRACT-FOUND AND REGULAR-RUN                            
A02221        PERFORM 8650-PRINT-RPRT-SUMMARY  THRU  8650-EXIT          
A02221        INITIALIZE                WS-SUM-BILL-UNITS-R2            
A02221                                  WS-ADJ-BILL-UNITS-R2            
A02221     END-IF.                                                      
      *                                                                         
      *                                                                         
A02221 2100-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221***************************************************************           
A02221**     2200-PROCESS-REV-AMT                                  **           
A02221**     THIS PROCEDURE IS USED TO OBTAIN BILLING DETAILS FOR  **           
A02221**     EACH ACCOUNT NUMBER AND IC NO                         **           
A02221***************************************************************           
A02221 2200-PROCESS-REV-AMT.                                            
A02221*                                                                         
           MOVE '2200'                     TO WS-ACTIVE-PARAGRAPH.      
A02221*                                                                         
A02221     IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
A02221        COMPUTE WS-REV-AMT    = WS-REV-AMT * -1                   
A02221     END-IF.                                                      
A02221*                                                                         
A02221     IF BG-CODE-BILL-CALC = 'A'                                   
A02221        MOVE WS-REV-AMT              TO WS-AMT-BILL-ITEM          
A02221     ELSE                                                         
A02221        MOVE WS-REV-AMT              TO WS-ADJ-REVENUE            
A02221     END-IF.                                                      
A02221*                                                                         
A00633** DON'T SELECT DTS FOR ROWS WITH REV_RPT_CD = "T" BECAUSE WE             
A00633** NEED TRANSPORTATION REVENUE ONLY (FOR THE FIRST REPORT)                
A00633     IF BG-REV-RPT-CD NOT = 'T'                                   
A02221        IF BG-CODE-BILL-CALC = 'A'                                
A02221           PERFORM 7500-SELECT-DTS    THRU 7500-EXIT              
A02221           IF WS-DTS-NULL-IND < 0                                 
A02221              MOVE ZERO               TO WS-DTS                   
A02221           END-IF                                                 
A02221           MOVE  WS-DTS               TO WS-BILL-UNITS            
A02221           IF CONTRACT-FOUND AND REGULAR-RUN                      
A02221             IF BG-REVENUE-MONTH >= WS-ANN-REVIEW-FRM-MNTH        
A02221                AND BG-REVENUE-MONTH  <= WS-ANN-REVIEW-TO-MNTH    
A02221                COMPUTE WS-SUM-BILL-UNITS-R2                      
A02221                              = WS-SUM-BILL-UNITS-R2 + WS-DTS     
A02221                PERFORM 8350-PRINT-RPRT-DETAILS THRU  8350-EXIT   
A02221             END-IF                                               
A02221           END-IF                                                 
A02221        ELSE                                                      
A02221           PERFORM 2210-GET-USAGE-ADJUSTMENT    THRU  2210-EXIT   
A02221        END-IF                                                    
A00633     END-IF.                                                      
      *                                                                         
A02221     PERFORM 2300-MOVE-DETAILS-PARA             THRU  2300-EXIT.  
      *                                                                         
           PERFORM 7320-FETCH-GAS-REVENUE-CURSOR      THRU  7320-EXIT.  
      *                                                                         
A02221 2200-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221***************************************************************           
A02221**     2210-GET-USAGE-ADJUSTMENT.                            **           
A02221**        THIS PROCEDURE GETS USAGE ADJUSTMENT FROM NON-CALCS**           
A02221***************************************************************           
A02221 2210-GET-USAGE-ADJUSTMENT.                                       
      *                                                                         
A02221     MOVE '2210'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
A02221     PERFORM 7400-OPEN-USAGE-ADJ-CURSOR  THRU 7400-EXIT.          
A02221     PERFORM 7410-FETCH-USAGE-ADJ-CURSOR THRU 7410-EXIT.          
A02221     PERFORM 2220-PROCESS-ADJ-DTS        THRU 2220-EXIT           
A02221                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.          
A02221     PERFORM 7420-CLOSE-USAGE-ADJ-CURSOR THRU 7420-EXIT.          
      *                                                                         
A02221 2210-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221***************************************************************           
A02221**     2220-PROCESS-ADJ-DTS.                                 **           
A02221**          THIS PROCEDURE COMPUTES ADJUSTED DTS             **           
A02221***************************************************************           
A02221 2220-PROCESS-ADJ-DTS.                                            
      *                                                                         
A02221     MOVE '2230'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
A02221     IF CX-BTU-FACTOR   =  0                                      
A02221          MOVE 1.032  TO CX-BTU-FACTOR                            
A02221     END-IF                                                       
A02221     COMPUTE WS-ADJ-MCF = CX-NO-UNITS / 10.                       
A02221     COMPUTE WS-ADJ-DTS = WS-ADJ-DTS +                            
A02221                                (WS-ADJ-MCF * CX-BTU-FACTOR).     
A02221     PERFORM 7410-FETCH-USAGE-ADJ-CURSOR  THRU 7410-EXIT.         
      *                                                                         
A02221 2220-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221***************************************************************           
A02221**     2300-MOVE-DETAILS-PARA                                **           
A02221**          THIS PROCEDURE MOVES THE VALUES OBTAINED TO AN   **           
A02221**          ARRAY FOR SORTING                                **           
A02221***************************************************************           
A02221 2300-MOVE-DETAILS-PARA.                                          
      *                                                                         
A02221     MOVE '2300'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
           MOVE WS-CUST-NAME              TO WS-NAME-FL.                
           MOVE UT-ACCOUNT-NO             TO WS-ACCOUNT-NO-FL.          
           MOVE WS-BILL-UNITS             TO WS-DTS-FL.                 
           MOVE WS-AMT-BILL-ITEM          TO WS-REVENUE-FL.             
A02221     MOVE WS-ADJ-REVENUE            TO WS-ADJ-REVENUE-FL.         
A02221     MOVE WS-ADJ-DTS                TO WS-ADJ-DTS-FL.             
A02221     MOVE BG-REVENUE-MONTH          TO WS-REV-MNTH-FL.            
A02221     WRITE  WS-FIORP421.                                          
           INITIALIZE WS-FIORP421.                                      
      *                                                                         
A02221     INITIALIZE WS-BILL-UNITS,                                    
A02221                WS-AMT-BILL-ITEM,                                 
A02221                WS-ADJ-REVENUE,                                   
A02221                WS-ADJ-DTS,                                       
A02221                WS-REV-AMT.                                       
      *                                                                         
A02221 2300-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221******************************************************************        
A02221**     3000-PRINT-REVENUE-REPORTS                  **                     
A02221******************************************************************        
A02221 3000-PRINT-REVENUE-REPORTS.                                      
      *                                                                         
A02221     MOVE '3000'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
A02221     PERFORM  3100-PRINT-FINAL-REPORT          THRU 3100-EXIT.    
A02221     IF REGULAR-RUN                                               
A02221         PERFORM 3200-PRINT-MIN-REV-MM-REPORT  THRU 3200-EXIT     
A02221         PERFORM 3300-PRINT-MAX-REV-MM-REPORT  THRU 3300-EXIT     
A02221         PERFORM 3400-PRINT-DISPATCH-MM-REPORT THRU 3400-EXIT     
A02221     END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
            EXIT.                                                       
A02221******************************************************************        
A02221**     3100-PRINT-FINAL-REPORT.                    **                     
A02221******************************************************************        
A02221 3100-PRINT-FINAL-REPORT.                                         
A02221*                                                                         
A02221     MOVE '3100'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
A02221     OPEN INPUT  FCSRP421-FILE.                                   
A02221     OPEN OUTPUT FCSR421A-FILE.                                   
      *                                                                         
A02221     INITIALIZE WS-END-OF-FCSRP421                                
A02221                WS-AMOUNT-FIELDS                                  
A02221                WS-PREV-ACCOUNT-NO.                               
A02221     MOVE     1                          TO WS-REPORT-TYPE.       
A02221     MOVE     WS-CUR-REV-MON-MIN         TO WS-FROM-TITLE-MNTH.   
A02221     MOVE     WS-CUR-REV-MON-MAX         TO WS-TO-TITLE-MNTH.     
A02221     PERFORM  8000-WRITE-HEADER-RECORD   THRU 8000-EXIT.          
A02221     PERFORM  7900-READ-FCSRP421-FILE    THRU 7900-EXIT           
A02221     PERFORM UNTIL END-OF-FCSRP421                                
A02221       IF WS-REV-MNTH-FL NOT EQUAL WS-CUR-REV-MON-CR              
A02221          AND WS-REV-MNTH-FL  NOT EQUAL WS-COMPARE-REV-MON        
A02221            PERFORM 3600-PROCESS-RECORDS THRU 3600-EXIT           
A02221       END-IF                                                     
A02221       PERFORM  7900-READ-FCSRP421-FILE  THRU 7900-EXIT           
A02221     END-PERFORM.                                                 
A02221     PERFORM  3620-MOVE-FCSR421-OUTPUT  THRU 3620-EXIT.           
A02221*                                                                         
A02221     CLOSE FCSRP421-FILE                                          
A02221           FCSR421A-FILE.                                         
A02221*                                                                         
A02221 3100-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221******************************************************************        
A02221**     3200-PRINT-MIN-REV-MM-REPORT                                       
A02221******************************************************************        
A02221 3200-PRINT-MIN-REV-MM-REPORT.                                    
A02221*                                                                         
A02221     MOVE '3200'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221     OPEN INPUT  FCSRP421-FILE.                                   
A02221     OPEN OUTPUT FCSR421B-FILE.                                   
      *                                                                         
A02221     INITIALIZE WS-END-OF-FCSRP421                                
A02221                WS-AMOUNT-FIELDS                                  
A02221                WS-PREV-ACCOUNT-NO.                               
A02221     MOVE     2                         TO WS-REPORT-TYPE.        
A02221     MOVE     WS-COMPARE-REV-MON        TO WS-FROM-TITLE-MNTH     
A02221                                           WS-TO-TITLE-MNTH.      
A02221     PERFORM  8000-WRITE-HEADER-RECORD  THRU 8000-EXIT.           
A02221     PERFORM  7900-READ-FCSRP421-FILE   THRU 7900-EXIT.           
A02221     PERFORM UNTIL END-OF-FCSRP421                                
A02221       IF WS-REV-MNTH-FL EQUAL WS-COMPARE-REV-MON                 
A02221          PERFORM 3600-PROCESS-RECORDS  THRU 3600-EXIT            
A02221       END-IF                                                     
A02221       PERFORM  7900-READ-FCSRP421-FILE THRU 7900-EXIT            
A02221     END-PERFORM.                                                 
A02221     PERFORM  3620-MOVE-FCSR421-OUTPUT  THRU 3620-EXIT.           
A02221*                                                                         
A02221     CLOSE FCSRP421-FILE                                          
A02221           FCSR421B-FILE.                                         
A02221*                                                                         
A02221 3200-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221******************************************************************        
A02221**     3300-PRINT-MAX-REV-MM-REPORT                                       
A02221******************************************************************        
A02221 3300-PRINT-MAX-REV-MM-REPORT.                                    
A02221*                                                                         
A02221     MOVE '3300'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221     OPEN INPUT  FCSRP421-FILE.                                   
A02221     OPEN OUTPUT FCSR421C-FILE.                                   
      *                                                                         
A02221     INITIALIZE WS-END-OF-FCSRP421                                
A02221                WS-AMOUNT-FIELDS                                  
A02221                WS-PREV-ACCOUNT-NO.                               
A02221     MOVE     3                         TO WS-REPORT-TYPE.        
A02221     MOVE     WS-CUR-REV-MON-MAX        TO WS-FROM-TITLE-MNTH     
A02221                                           WS-TO-TITLE-MNTH.      
A02221     PERFORM  8000-WRITE-HEADER-RECORD  THRU  8000-EXIT.          
A02221     PERFORM  7900-READ-FCSRP421-FILE   THRU  7900-EXIT.          
A02221     PERFORM UNTIL END-OF-FCSRP421                                
A02221       IF WS-REV-MNTH-FL EQUAL WS-CUR-REV-MON-MAX                 
A02221          PERFORM 3600-PROCESS-RECORDS THRU 3600-EXIT             
A02221       END-IF                                                     
A02221       PERFORM  7900-READ-FCSRP421-FILE  THRU 7900-EXIT           
A02221     END-PERFORM.                                                 
A02221     PERFORM  3620-MOVE-FCSR421-OUTPUT THRU 3620-EXIT.            
A02221*                                                                         
A02221     CLOSE FCSRP421-FILE                                          
A02221           FCSR421C-FILE.                                         
A02221*                                                                         
A02221 3300-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221******************************************************************        
A02221**     3400-PRINT-DISPATCH-MM-REPORT                                      
A02221******************************************************************        
A02221 3400-PRINT-DISPATCH-MM-REPORT.                                   
A02221*                                                                         
A02221     MOVE '3400'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221     OPEN INPUT  FCSRP421-FILE.                                   
A02221     OPEN OUTPUT FCSR421D-FILE.                                   
      *                                                                         
A02221     INITIALIZE WS-END-OF-FCSRP421                                
A02221                WS-AMOUNT-FIELDS                                  
A02221                WS-PREV-ACCOUNT-NO.                               
A02221     MOVE     4                         TO WS-REPORT-TYPE.        
A02221     MOVE     WS-CUR-REV-MON-CR         TO WS-FROM-TITLE-MNTH     
A02221                                           WS-TO-TITLE-MNTH.      
A02221     PERFORM  8000-WRITE-HEADER-RECORD  THRU  8000-EXIT.          
A02221     PERFORM  7900-READ-FCSRP421-FILE   THRU  7900-EXIT.          
A02221     PERFORM UNTIL END-OF-FCSRP421                                
A02221       IF WS-REV-MNTH-FL  EQUAL WS-CUR-REV-MON-CR                 
A02221            PERFORM 3600-PROCESS-RECORDS THRU 3600-EXIT           
A02221       END-IF                                                     
A02221       PERFORM  7900-READ-FCSRP421-FILE  THRU 7900-EXIT           
A02221     END-PERFORM.                                                 
A02221     PERFORM  3620-MOVE-FCSR421-OUTPUT THRU 3620-EXIT.            
A02221*                                                                         
A02221     CLOSE FCSRP421-FILE                                          
A02221           FCSR421D-FILE.                                         
A02221*                                                                         
A02221 3400-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
A02221******************************************************************        
A02221**     3500-MOVE-INPUT-RECORD.                                            
A02221******************************************************************        
A02221 3500-MOVE-INPUT-RECORD.                                          
A02221*                                                                         
A02221     MOVE '3500'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221      MOVE  WS-NAME-FL            TO WS-CUST-NAME-IN.             
A02221      MOVE  WS-ACCOUNT-NO-FL      TO WS-ACCT-NO-IN                
A02221                                     WS-PREV-ACCOUNT-NO.          
A02221      MOVE  WS-DTS-FL             TO WS-DTS-AMT.                  
A02221      MOVE  WS-REVENUE-FL         TO WS-REVENUE-AMT.              
A02221      MOVE  WS-ADJ-REVENUE-FL     TO WS-ADJ-REVENUE-AMT.          
A02221      MOVE  WS-ADJ-DTS-FL         TO WS-ADJ-DTS-AMT.              
      *                                                                         
A02221 3500-EXIT.                                                       
A02221      EXIT.                                                       
A02221******************************************************************        
A02221**     3600-PROCESS-RECORDS.                                              
A02221******************************************************************        
A02221 3600-PROCESS-RECORDS.                                            
      *                                                                         
A02221     MOVE '3600'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221     IF WS-PREV-ACCOUNT-NO EQUAL ZERO                             
A02221        PERFORM 3500-MOVE-INPUT-RECORD   THRU 3500-EXIT           
A02221     ELSE                                                         
A02221        IF WS-ACCOUNT-NO-FL EQUAL WS-PREV-ACCOUNT-NO              
A02221           PERFORM 3610-ADD-AMOUNT-FIELDS  THRU 3610-EXIT         
A02221        ELSE                                                      
A02221           PERFORM 3620-MOVE-FCSR421-OUTPUT THRU 3620-EXIT        
A02221           PERFORM 3500-MOVE-INPUT-RECORD   THRU 3500-EXIT        
A02221        END-IF                                                    
A02221     END-IF.                                                      
      *                                                                         
A02221 3600-EXIT.                                                       
A02221      EXIT.                                                       
A02221******************************************************************        
A02221**     3610-ADD-AMOUNT-FIELDS.                                            
A02221******************************************************************        
A02221 3610-ADD-AMOUNT-FIELDS.                                          
A02221*                                                                         
A02221     MOVE '3610'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221     COMPUTE WS-DTS-AMT ROUNDED       = WS-DTS-AMT + WS-DTS-FL    
A02221     COMPUTE WS-REVENUE-AMT ROUNDED   = WS-REVENUE-AMT +          
A02221                                            WS-REVENUE-FL         
A02221     COMPUTE WS-ADJ-REVENUE-AMT       = WS-ADJ-REVENUE-AMT +      
A02221                                            WS-ADJ-REVENUE-FL     
A02221     COMPUTE WS-ADJ-DTS-AMT ROUNDED   = WS-ADJ-DTS-AMT +          
A02221                                            WS-ADJ-DTS-FL.        
      *                                                                         
A02221 3610-EXIT.                                                       
A02221      EXIT.                                                       
A02221******************************************************************        
A02221**     3620-MOVE-FCSR421-OUTPUT.                                          
A02221******************************************************************        
A02221 3620-MOVE-FCSR421-OUTPUT.                                        
A02221*                                                                         
A02221     MOVE '3620'                        TO WS-ACTIVE-PARAGRAPH.   
      *                                                                         
A02221      MOVE  WS-CUST-NAME-IN       TO WS-CUST-NAME-R.              
A02221      MOVE  WS-ACCT-NO-IN         TO WS-ACCT-NO-R.                
A02221      INSPECT WS-ACCT-NO-R REPLACING ALL ' ' BY '-'.              
A02221      MOVE  WS-DTS-AMT            TO WS-DTS-R.                    
A02221      MOVE  WS-REVENUE-AMT        TO WS-REVENUE-R.                
A02221      MOVE  WS-ADJ-REVENUE-AMT    TO WS-ADJ-REVENUE-R.            
A02221      MOVE  WS-ADJ-DTS-AMT        TO WS-ADJ-DTS-R.                
A02221      IF WS-DTS-AMT  > 0                                          
A02221         COMPUTE WS-AVG-REVENUE-AMT ROUNDED                       
A02221                            = WS-REVENUE-AMT / WS-DTS-AMT         
A02221      ELSE                                                        
A02221         MOVE  ZEROS              TO WS-AVG-REVENUE-AMT           
A02221      END-IF.                                                     
A02221      MOVE  WS-AVG-REVENUE-AMT    TO WS-AVG-REVENUE-R.            
      *                                                                         
A02221      PERFORM 8100-WRITE-DATA-RECORD  THRU 8100-EXIT.             
      *                                                                         
A02221      INITIALIZE WS-CUST-NAME-IN                                  
A02221                 WS-ACCT-NO-IN                                    
A02221                 WS-AMOUNT-FIELDS.                                
      *                                                                         
A02221 3620-EXIT.                                                       
A02221      EXIT.                                                       
A02221******************************************************************        
A02221**     4000-PRINT-SUMMARY-LINES.                                **        
A02221******************************************************************        
A02221 4000-PRINT-SUMMARY-LINES.                                        
      *                                                                         
A02221     MOVE '4000'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     IF WS-SUMM-REC-CNTR EQUAL 0                                  
A02221        PERFORM 8150-PRINT-RPRT-NO-DATA THRU 8150-EXIT            
A02221     END-IF.                                                      
                                                                        
A02221     PERFORM 8450-PRINT-RPRT-FOOTER  THRU 8450-EXIT.              
      *                                                                         
A02221 4000-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **   6010-REDUCE-EMBEDDED-SPACES                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **   6200-GET-PARAMETER-DATE                                    **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **   7600-START-FJC01.                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **  6251-GET-FJC01-DATE.                                        **        
      ******************************************************************        
       COPY CPD00037.                                                           
       COPY CPD00040.                                                           
      ******************************************************************        
      **   7600-START-FCJ01.                                          **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      ***************************************************************           
      **    7100-OPEN-GAS-CUSTOMER-CURSOR                          **           
      **         OPENS CURSOR ON CSS_UTIL_ENVRNMT                  **           
      ***************************************************************           
       7100-OPEN-GAS-CUSTOMER-CURSOR.                                   
      *                                                                         
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                OPEN GAS_CUSTOMER                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN GAS CUSTOMER CURSOR ERROR'                     
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02221***************************************************************           
      **    7200-FETCH-GAS-CUSTOMER-CURSOR                         **           
      **         FETCH ROWS FROM CSS_UTIL_ENVRNMT                  **           
      **         TABLES                                            **           
      ***************************************************************           
A02221 7200-FETCH-GAS-CUSTOMER-CURSOR.                                  
      *                                                                         
A02221     MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                FETCH GAS_CUSTOMER INTO                                 
                   :UT-ACCOUNT-NO,                                      
                   :UT-RATE-PLAN-NO,                                    
                   :UT-IC-NO,                                           
                   :UT-READ-CYCLE,                                      
                   :Z4-PRTY-SVC-CAT-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN FETCHING GAS CUSTOMER CURSOR'              
                                              TO WS-ERR-MSG             
              MOVE SQLCODE                    TO WS-DISP-RC             
              PERFORM 9100-DISPLAY-ERROR      THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
A02221 7200-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
      ***************************************************************           
A02221**    7300-CLOSE-GAS-CUSTOMER-CURSOR.                        **           
      **         CLOSES CURSOR ON CSS_UTIL_ENVRNMT                 **           
      ***************************************************************           
A02221 7300-CLOSE-GAS-CUSTOMER-CURSOR.                                  
      *                                                                         
A02221     MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                CLOSE GAS_CUSTOMER                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'CLOSE GAS CUSTOMER CURSOR ERROR'                    
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
A02221 7300-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
      ***************************************************************           
A02221**    7310-OPEN-GAS-REVENUE-CURSOR                           **           
      **         OPENS CURSOR ON CSS_BILLING_DET TABLE             **           
      ***************************************************************           
A02221 7310-OPEN-GAS-REVENUE-CURSOR.                                    
      *                                                                         
           MOVE '7310'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                OPEN GAS_REVENUE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN GAS REVENUE CURSOR ERROR'                      
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
A02221**    7320-FETCH-GAS-REVENUE-CURSOR                          **           
      **         FETCH ROWS FROM CSS_BILLING_DET TABLE             **           
      ***************************************************************           
A02221 7320-FETCH-GAS-REVENUE-CURSOR.                                   
      *                                                                         
           MOVE '7320'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                FETCH  GAS_REVENUE                                      
                 INTO :BG-ACCOUNT-NO                                    
                     ,:BG-REVENUE-MONTH                                 
A02221               ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
35518                ,:BG-BILL-NO                                       
35518                ,:BG-BILL-ITEM-TIMESTMP                            
35518                ,:WS-REV-AMT                                       
A02221               ,:BG-CODE-BILL-CALC                                
A00633               ,:BG-REV-RPT-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN FETCHING GAS REVENUE CURSOR'               
                                              TO   WS-ERR-MSG           
              MOVE SQLCODE                    TO   WS-DISP-RC           
A02221        DISPLAY 'ACCOUNT NO    ' UT-ACCOUNT-NO                    
A02221        DISPLAY 'IC NO         ' UT-IC-NO                         
A02221        DISPLAY 'TRANSPORT REV FLAG '  WS-TRANSPORT-REV-FLAG      
              PERFORM 9100-DISPLAY-ERROR      THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
A02221 7320-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
      ***************************************************************           
A02221**    7330-CLOSE-GAS-REVENUE-CURSOR                          **           
      **         CLOSES CURSOR ON CSS_BILLING_DET                  **           
      ***************************************************************           
A02221 7330-CLOSE-GAS-REVENUE-CURSOR.                                   
      *                                                                         
A02221     MOVE '7330'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                CLOSE GAS_REVENUE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'CLOSE GAS REVENUE CURSOR ERROR'                     
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
A02221 7330-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221***************************************************************           
A02221**    7400-OPEN-USAGE-ADJ-CURSOR                            **            
A02221**    OPENS CURSOR ON CSS_CNSMPTN_HIST AND CSS_MTRD_ENVRNMT **            
A02221***************************************************************           
A02221 7400-OPEN-USAGE-ADJ-CURSOR.                                      
      *                                                                         
A02221     MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     EXEC SQL                                                     
A02221          OPEN USAGE_ADJUSTMENT                                   
A02221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02221     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
A02221     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02221        NEXT SENTENCE                                             
A02221     ELSE                                                         
A02221         MOVE SQLCODE                 TO WS-DISP-RC               
A02221         MOVE 'OPEN USAGE ADJUSTMENT CURSOR ERROR'                
A02221                                     TO WS-ERR-MSG                
A02221         PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT              
A02221     END-IF.                                                      
      *                                                                         
A02221 7400-EXIT.                                                       
A02221      EXIT.                                                       
      *                                                                         
      ***************************************************************           
A02221**    7410-FETCH-USAGE-ADJ-CURSOR                             *           
A02221**    FETCH ROWS FROM CSS_CNSMPTN_HIST AND CSS_MTRD_ENVRNMT   *           
A02221***************************************************************           
A02221 7410-FETCH-USAGE-ADJ-CURSOR.                                     
      *                                                                         
A02221     MOVE '7410'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     EXEC SQL                                                     
A02221          FETCH  USAGE_ADJUSTMENT                                 
A02221           INTO :CX-NO-UNITS                                      
A02221               ,:CX-BTU-FACTOR                                    
A02221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02221     MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
                                                                        
A02221     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02221        NEXT SENTENCE                                             
A02221     ELSE                                                         
A02221        MOVE 'ERROR IN FETCHING USAGE ADJUSTMENT CURSOR'          
A02221                                          TO WS-ERR-MSG           
A02221        MOVE SQLCODE                      TO WS-DISP-RC           
A02221        DISPLAY 'ACCOUNT NO  '  BG-ACCOUNT-NO                     
A02221        DISPLAY 'BILL NO     '  BG-BILL-NO                        
A02221        DISPLAY 'IC NO       '  BG-IC-NO                          
A02221        DISPLAY 'BILL ITM TIMESTMP  ' BG-BILL-ITEM-TIMESTMP       
A02221        PERFORM 9100-DISPLAY-ERROR        THRU 9100-EXIT          
A02221     END-IF.                                                      
      *                                                                         
A02221 7410-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
A02221***************************************************************           
A02221**    7420-CLOSE-USAGE-ADJ-CURSOR.                          **            
A02221**    CLOSES CURSOR ON CSS_CNSMPTN_HIST AND CSS_MTRD_ENVRNMT**            
A02221***************************************************************           
A02221 7420-CLOSE-USAGE-ADJ-CURSOR.                                     
                                                                        
A02221     MOVE '7420'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A02221     EXEC SQL                                                     
A02221          CLOSE USAGE_ADJUSTMENT                                  
A02221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02221     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
A02221     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02221        NEXT SENTENCE                                             
A02221     ELSE                                                         
A02221        MOVE SQLCODE                 TO WS-DISP-RC                
A02221        MOVE 'CLOSE USAGE ADJUSTMENT CURSOR ERROR'                
A02221                                     TO WS-ERR-MSG                
A02221        PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
A02221     END-IF.                                                      
      *                                                                         
A02221 7420-EXIT.                                                       
A02221     EXIT.                                                        
      *                                                                         
C31558****************************************************************          
C31558**   7425-GET-CONTRACT-DATE.                                  **          
C31558**      SUBTRACT ONE DAY TO GET LAST DAY OF PREV MONTH        **          
C31558****************************************************************          
C31558 7425-GET-CONTRACT-DATE.                                          
      *                                                                         
C31558     MOVE '7425'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
C31558     EXEC SQL                                                     
C31558       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CONTRACT-DATE
              ) <> 0) OR (LEN(:WS-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-CONTRACT-DATE
              ), CONVERT(DATE, :WS-CONTRACT-DATE) ) )
            INTO
              :WS-CONTRACT-DATE    
C31558     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CONTRACT-DATE = DATE(:WS-CONTRACT-DATE) - 1 DAY            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31558                                                                  
C31558     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C31558                                                                  
C31558     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31558        NEXT SENTENCE                                             
C31558     ELSE                                                         
C31558        MOVE 'ERROR IN SETTING CONTRACT DATE'                     
C31558                                     TO WS-ERR-MSG                
C31558        MOVE SQLCODE                 TO WS-DISP-RC                
C31558        PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
C31558     END-IF.                                                      
      *                                                                         
C31558 7425-EXIT.                                                       
C31558     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7450-SELECT-CNTRCT-DATE.                                 **          
      **      SELECTS CONTRACT BEGIN DATE AND END DATE FROM         **          
      **              CSS_BILL_CONTRACT TABLE                       **          
      ****************************************************************          
      *                                                                         
       7450-SELECT-CNTRCT-DATE.                                         
                                                                        
           MOVE '7450'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT  MAX(SPCL_ANN_MIN_AM)                                
               INTO :BK-SPCL-ANN-MIN-AM :WS-ANN-MIN-NULL-IND             
               FROM CSS_BILL_CONTRACT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                   
                AND IC_NO            = :UT-IC-NO                        
C31558          AND CODE_UTIL_TYPE   = 'G'                              
                AND ANN_REVIEW_MONTH = :WS-ANN-REVIEW-MONTH             
C31558          AND CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CONTRACT-DATE
              ) <> 0) OR (LEN(:WS-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-CONTRACT-DATE
              ), CONVERT(DATE, :WS-CONTRACT-DATE) )                
C31558          AND CNTRCT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CONTRACT-DATE
              ) <> 0) OR (LEN(:WS-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-CONTRACT-DATE
              ), CONVERT(DATE, :WS-CONTRACT-DATE) )                
A02221                                                           
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  MAX(SPCL_ANN_MIN_AM)                                        
MFA-TR*        INTO :BK-SPCL-ANN-MIN-AM:WS-ANN-MIN-NULL-IND                     
MFA-TR*        FROM CSS_BILL_CONTRACT                                           
MFA-TR*       WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                           
MFA-TR*         AND IC_NO            = :UT-IC-NO                                
MFA-TR*         AND CODE_UTIL_TYPE   = 'G'                                      
MFA-TR*         AND ANN_REVIEW_MONTH = :WS-ANN-REVIEW-MONTH                     
MFA-TR*         AND CNTRCT_START_DT <= :WS-CONTRACT-DATE                        
MFA-TR*         AND CNTRCT_END_DT   >= :WS-CONTRACT-DATE                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR MULTIPLE-ROWS              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING FROM CSS_BILL_CONTRACT'          
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
A02221        DISPLAY 'ACCOUNT NO      ' UT-ACCOUNT-NO                  
A02221        DISPLAY 'IC NO           ' UT-IC-NO                       
A02221        DISPLAY 'ANN REVIEW MNTH ' WS-ANN-REVIEW-MONTH            
A02221        DISPLAY 'CONTRACT DATE   ' WS-CONTRACT-DATE               
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
        7450-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   7500-SELECT-DTS                                          **          
      **      SELECTS THE BILL UNITS FROM CSS_VOL_DAILY             **          
      ****************************************************************          
       7500-SELECT-DTS.                                                 
      *                                                                         
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
             SELECT SUM(NO_UNITS)                                       
               INTO :WS-DTS :WS-DTS-NULL-IND                             
               FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                 
                AND BILL_NO            = :BG-BILL-NO                    
C31558          AND CODE_UTIL_TYPE     = 'G'                            
                AND IC_NO              = :BG-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )         
ACT094          AND ( (:WS-TRANSPORT-REV-FLAG = 'Y'  AND                
ACT094                  VOL_TYPE_CD           = 'VB'        )           
ACT094                                 OR                               
ACT094                (:WS-TRANSPORT-REV-FLAG = 'N'  AND                
ACT094                   VOL_TYPE_CD IN ('BR','CP','EG','PG') ) )       
                AND ENERGY_UNIT_CD     = 'D'                            
A02221                                                           
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUM(NO_UNITS)                                               
MFA-TR*        INTO :WS-DTS:WS-DTS-NULL-IND                                     
MFA-TR*        FROM CSS_VOL_DAILY                                               
MFA-TR*       WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                         
MFA-TR*         AND BILL_NO            = :BG-BILL-NO                            
MFA-TR*         AND CODE_UTIL_TYPE     = 'G'                                    
MFA-TR*         AND IC_NO              = :BG-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                 
MFA-TR*         AND ( (:WS-TRANSPORT-REV-FLAG = 'Y'  AND                        
MFA-TR*                 VOL_TYPE_CD           = 'VB'        )                   
MFA-TR*                                OR                                       
MFA-TR*               (:WS-TRANSPORT-REV-FLAG = 'N'  AND                        
MFA-TR*                  VOL_TYPE_CD IN ('BR','CP','EG','PG') ) )               
MFA-TR*         AND ENERGY_UNIT_CD     = 'D'                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING DTS FROM CSS_VOL_DAILY'          
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
A02221        DISPLAY 'ACCOUNT-NO ' BG-ACCOUNT-NO                       
A02221        DISPLAY 'BILL NO    ' BG-BILL-NO                          
A02221        DISPLAY 'IC NO      ' BG-IC-NO                            
A02221        DISPLAY 'BILL ITM TIME STAMP ' BG-BILL-ITEM-TIMESTMP      
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   7700-SELECT-CUSTOMER-NAME                                **          
      **      SELECTS THE CUSTOMER NAME FROM CSS_NAME               **          
      ****************************************************************          
       7700-SELECT-CUSTOMER-NAME.                                       
      *                                                                         
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
             SELECT DQ.FULL_NAME                                        
               INTO :WS-FULL-NAME                                       
               FROM CSS_NAME DQ WITH(READUNCOMMITTED) ,                         
                    CSS_CUSTOMER CU WITH(READUNCOMMITTED) ,                     
                    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO       = :UT-ACCOUNT-NO                
                AND AT.CUSTOMER_NO      =  CU.CUSTOMER_NO               
                AND CU.NAME_ID          =  DQ.NAME_ID                   
T35434                                                           
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DQ.FULL_NAME                                                
MFA-TR*        INTO :WS-FULL-NAME                                               
MFA-TR*        FROM CSS_NAME DQ ,                                               
MFA-TR*             CSS_CUSTOMER CU ,                                           
MFA-TR*             CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO       = :UT-ACCOUNT-NO                        
MFA-TR*         AND AT.CUSTOMER_NO      =  CU.CUSTOMER_NO                       
MFA-TR*         AND CU.NAME_ID          =  DQ.NAME_ID                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING CUSTOMER NAME'                   
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
A02221        DISPLAY 'ACCOUNT NO' UT-ACCOUNT-NO                        
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   7750-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      ****************************************************************          
       7750-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
C31558        WHERE COMPANY_NO = '01'                                   
T35434                                                           
A02221                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = '01'                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ERROR IN SELECTING COMPANY NAME '                   
                                           TO WS-ERR-MSG                
              MOVE SQLCODE                 TO WS-DISP-RC                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
        7750-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  7900-READ-FCSRP421-FILE                                     **        
      **       READS THE FCSRP421-FILE FILE                           **        
      ******************************************************************        
                                                                        
       7900-READ-FCSRP421-FILE.                                         
                                                                        
           READ FCSRP421-FILE                                           
               AT END MOVE WS-Y            TO WS-END-OF-FCSRP421        
           END-READ.                                                    
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
A02221**  8000-WRITE-HEADER-RECORD.                                   **        
A02221******************************************************************        
A02221 8000-WRITE-HEADER-RECORD.                                        
A02221         EVALUATE WS-REPORT-TYPE                                  
A02221           WHEN 1                                                 
A02221               WRITE FCSR421A        FROM WS-TITLE-RECORD         
A02221               WRITE FCSR421A        FROM WS-HEADER-RECORD        
A02221           WHEN 2                                                 
A02221               WRITE FCSR421B        FROM WS-TITLE-RECORD         
A02221               WRITE FCSR421B        FROM WS-HEADER-RECORD        
A02221           WHEN 3                                                 
A02221               WRITE FCSR421C        FROM WS-TITLE-RECORD         
A02221               WRITE FCSR421C        FROM WS-HEADER-RECORD        
A02221           WHEN 4                                                 
A02221               WRITE FCSR421D        FROM WS-TITLE-RECORD         
A02221               WRITE FCSR421D        FROM WS-HEADER-RECORD        
A02221         END-EVALUATE.                                            
A02221*                                                                         
A02221 8000-EXIT.                                                       
A02221      EXIT.                                                       
      ******************************************************************        
A02221**  8100-WRITE-DATA-RECORD.                                   **          
A02221******************************************************************        
A02221 8100-WRITE-DATA-RECORD.                                          
A02221         EVALUATE WS-REPORT-TYPE                                  
A02221          WHEN 1                                                  
A02221               WRITE FCSR421A FROM WS-DATA-RECORD                 
A02221          WHEN 2                                                  
A02221               WRITE FCSR421B FROM WS-DATA-RECORD                 
A02221          WHEN 3                                                  
A02221               WRITE FCSR421C FROM WS-DATA-RECORD                 
A02221          WHEN 4                                                  
A02221               WRITE FCSR421D FROM WS-DATA-RECORD                 
A02221         END-EVALUATE.                                            
A02221 8100-EXIT.                                                       
A02221      EXIT.                                                       
      ******************************************************************        
A02221**  8150-PRINT-RPRT-NO-DATA.                                    **        
      **       WRITE THE MESSAGE "NO DATA THIS RUN"                   **        
      ******************************************************************        
A02221 8150-PRINT-RPRT-NO-DATA.                                         
      *                                                                         
           MOVE '8150'                     TO   WS-ACTIVE-PARAGRAPH.    
      *                                                                         
A02221     PERFORM 8550-PRINT-RPRT-HEADERS THRU 8550-EXIT.              
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
           MOVE    WS-NO-DATA-LINE         TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02221**  8350-PRINT-RPRT-DETAILS.                                    **        
      **       WRITES THE OUTPUT RECORDS TO THE SECOND REPORT FILE    **        
      ******************************************************************        
A02221 8350-PRINT-RPRT-DETAILS.                                         
      *                                                                         
           MOVE '8350'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
C31558     MOVE BG-REVENUE-MONTH           TO WS-BG-REV-MONTH.          
C31558     MOVE WS-BG-REV-MONTH(5:2)       TO WS-REVENUE-MM.            
C31558     PERFORM 0200-ASSIGN-MONTH-PARA  THRU 0200-EXIT.              
C31558     MOVE WS-MONTH                   TO WS-DET2-REV-MONTH.        
C31558*                                                                         
C31558     MOVE WS-BG-REV-MONTH(1:4)       TO WS-DET2-REV-YEAR.         
C31558*                                                                         
C31558     MOVE WS-DTS                     TO WS-DET2-DTS.              
C31558*                                                                         
A02221     MOVE WS-DETAIL-LINE             TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02221**  8450-PRINT-RPRT-FOOTER.                                     **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      ******************************************************************        
A02221 8450-PRINT-RPRT-FOOTER.                                          
                                                                        
           MOVE '8450'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE WS-BLANK-LINE              TO PRT33-RECORD.             
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
           MOVE WS-FOOTER1                 TO PRT33-RECORD.             
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02221**  8550-PRINT-RPRT-HEADERS.                                    **        
      **       WRITES THE HEADER  TO THE SECOND REPORT FILE           **        
      ******************************************************************        
A02221 8550-PRINT-RPRT-HEADERS.                                         
      *                                                                         
           MOVE '8550'                     TO   WS-ACTIVE-PARAGRAPH.    
      *                                                                         
           ADD 1                           TO   WS-PAGE-COUNT.          
A02221     MOVE WS-PAGE-COUNT              TO   WS-RPRT-PAGE.           
A02221     MOVE WS-PGRMNAME                TO   P-RPRT-TITLE-PGNM.      
A02221     MOVE WS-COMP-NAME               TO   P-RPRT-COMP-NAME.       
                                                                        
      *    PRINTS COMPANY NAME                                                  
                                                                        
A02221     MOVE WS-RPRT-TITLE-1            TO   PRT33-RECORD.           
A02221     PERFORM 8755-WRITE-RPRT-ADV-PAGE  THRU  8755-EXIT.           
C31558                                                                  
      *    PRINTS REPORT TITLE                                                  
A02221     MOVE    WS-RPRT-TITLE-2         TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
A02221     MOVE    WS-RPRT-TITLE-3         TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
      *    PRINTS REPORT HEADER                                                 
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
A02221     MOVE WS-CUST-NAME               TO WS-RPRT-NAME.             
A02221     MOVE UT-ACCOUNT-NO              TO WS-RPRT-ACCOUNT-NO.       
A02221     INSPECT WS-RPRT-ACCOUNT-NO REPLACING ALL ' ' BY '-'.         
A02221     MOVE WS-RPRT-HEADER-1           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
C31558     MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
A02221     MOVE WS-RPRT-HEADER-2           TO   PRT33-RECORD.           
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
C31558     MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
A02221     MOVE BK-SPCL-ANN-MIN-AM         TO WS-RPRT-ANN-MIN-AMT.      
A02221     MOVE WS-RPRT-HEADER-3           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
C31558     MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
A02221     MOVE Z4-PRTY-SVC-CAT-CD         TO WS-RPRT-CATEGORY.         
A02221     MOVE WS-RPRT-HEADER-4           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
C31558     MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
A02221     MOVE WS-RPRT-HEADER-5           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C31558******************************************************************        
A02221**  8650-PRINT-RPRT-SUMMARY.                                    **        
C31558**       WRITES THE REPORT SUMMARY                              **        
C31558******************************************************************        
A02221 8650-PRINT-RPRT-SUMMARY.                                         
      *                                                                         
C31558     MOVE '8650'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
A02221     MOVE WS-SUM-BILL-UNITS-R2       TO WS-RPRT-SUM-BILL-UNITS.   
C31558     IF BK-SPCL-ANN-MIN-AM > WS-SUM-BILL-UNITS-R2                 
C31558        COMPUTE WS-ADJ-BILL-UNITS-R2 = BK-SPCL-ANN-MIN-AM -       
C31558                                       WS-SUM-BILL-UNITS-R2       
C31558     ELSE                                                         
C31558        MOVE 0                       TO WS-ADJ-BILL-UNITS-R2      
C31558     END-IF.                                                      
A02221     MOVE WS-ADJ-BILL-UNITS-R2       TO WS-RPRT-ADJ-BILL-UNITS.   
C31558                                                                  
C31558     MOVE    WS-BLANK-LINE           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
A02221     MOVE WS-RPRT-UNDERLINE          TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
A02221     MOVE WS-RPRT-SUMMARY-LINE1      TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
A02221     MOVE WS-RPRT-UNDERLINE          TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
C31558     MOVE    WS-BLANK-LINE           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
A02221     MOVE WS-RPRT-SUMMARY-LINE2      TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558                                                                  
C31558     MOVE    WS-BLANK-LINE           TO PRT33-RECORD.             
C31558     PERFORM 8750-WRITE-REPORT       THRU 8750-EXIT.              
C31558*                                                                         
C31558 8650-EXIT.                                                       
C31558     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8750-WRITE-REPORT.                                          **        
      **       WRITES THE RECORD IN THE SAME PAGE                     **        
      ******************************************************************        
       8750-WRITE-REPORT.                                               
      *                                                                         
           MOVE '8750'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C31558******************************************************************        
A02221**  8755-WRITE-RPRT-ADV-PAGE.                                   **        
C31558**       WRITES THE RECORD IN THE NEXT PAGE                     **        
C31558******************************************************************        
A02221 8755-WRITE-RPRT-ADV-PAGE.                                        
      *                                                                         
C31558     MOVE '8755'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
C31558     WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
C31558 8755-EXIT.                                                       
C31558     EXIT.                                                        
      *                                                                         
A02221******************************************************************        
A02221**  8800-INACTIVE-JOB-PARM.                                     **        
A02221**       MAKE THE ROWS STATUS AS INACTIVE AFTER ADHOC REPORTS  **         
A02221******************************************************************        
A02221 8800-INACTIVE-JOB-PARM.                                          
      *                                                                         
A02221     MOVE '8800'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
A02221     EXEC SQL                                                     
A02221          UPDATE CSS_JOB_PARM                                     
A02221             SET  STATUS =  'I'                                   
A02221          WHERE  PROGRAM_NAME  = :WS-PGRMNAME                     
A02221           AND   CMND_CODE     = 'PARM'                           
A02221           AND   COMPANY_NO    = '01'                             
A02221           AND   STATUS        = 'A'                              
A02221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A02221     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02221     IF WS-ACTIVE-RETURN-CODE EQUAL   TO SUCCESSFUL-CALL          
A02221          OR NOT-FOUND                                            
A02221        NEXT SENTENCE                                             
A02221     ELSE                                                         
A02221        MOVE 'ERROR IN UPDATING JOBPAM'                           
A02221                                      TO WS-ERR-MSG               
A02221        MOVE SQLCODE                  TO WS-DISP-RC               
A02221        PERFORM 9100-DISPLAY-ERROR    THRU 9100-EXIT              
A02221     END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP421  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
